﻿using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using UnityEngine;

namespace MissionPatchManager
{
    [KSPAddon(KSPAddon.Startup.MainMenu, true)]
    public class MissionPatchManager : MonoBehaviour
    {
        public static MissionPatchManager Instance;
        public static Dictionary<string, Texture2D> Textures;

        public MissionPatchManager()
        {
            if (Instance != null)
            {
                Destroy(this);
            }

            Instance = this;
            DontDestroyOnLoad(this);
            LoadTextures();
        }

        public void LoadTextures()
        {
            string assemblyLocation = Assembly.GetExecutingAssembly().Location.Replace("\\", "/");
            string assemblyDirectory = Path.GetDirectoryName(assemblyLocation).Replace("\\", "/");
            string textureAssetPath = Path.Combine(assemblyDirectory, "PluginData").Replace("\\", "/");

            if (Directory.Exists(textureAssetPath))
            {
                Textures = new Dictionary<string, Texture2D>();

                foreach (string textureAsset in Directory.GetFiles(textureAssetPath))
                {
                    string textureAssetName = textureAsset.Replace(textureAssetPath + "\\", "");
                    Texture2D loadedTextureAsset = new Texture2D(256, 160, TextureFormat.ARGB32, false);

                    loadedTextureAsset.LoadImage(File.ReadAllBytes(textureAsset));
                    Textures.Add(textureAssetName, loadedTextureAsset);
                }

                Debug.Log(string.Format("MissionPatchManager: {0} patches successfully loaded.", Textures.Count));
            }
            else
            {
                Debug.Log("MissionPatchManager: Unable to find Squad/Patches/");
            }
        }

        public void ApplyTexture(Transform patchTransform, int textureIndex)
        {
            if (Textures.ElementAt(textureIndex).Key != null)
            {
                Texture2D selectedTexture = Textures.ElementAt(textureIndex).Value;
                MeshRenderer patchRenderer = patchTransform.GetComponent<MeshRenderer>();
                patchRenderer.material.mainTexture = selectedTexture;
            }
        }

        public int ReturnTextureCount()
        {
            return Textures.Count() - 1;
        }

        public Dictionary<string, Texture2D> ReturnTextureAssets()
        {
            return Textures;
        }
    }
}
