﻿using UnityEngine;

namespace MissionPatchManager
{
    [KSPModule("PatchDecal")]
    public class PatchDecal : PartModule
    {
        [KSPField]
        public string textureQuadName;

        [KSPField(isPersistant = true)]
        public int textureAssetIndex;

        [KSPField(isPersistant = true)]
        public bool textureQuadVisible;

        public Transform textureQuadTransform;
        public int textureAssetCount;
        public bool showTextureAssetButtons;

        private Transform sprayTransform;

        public override void OnAwake()
        {
            base.OnAwake();            
            textureQuadVisible = true;
        }

        public override void OnStart(StartState state)
        {
            base.OnStart(state);
            textureQuadTransform = part.FindModelTransform(textureQuadName);
            sprayTransform = part.FindModelTransform("Spray");

            if (state == StartState.Editor)
            {
                textureAssetCount = MissionPatchManager.Instance.ReturnTextureCount();
                showTextureAssetButtons = (textureAssetCount != 0);

                BaseEvent nextButton = Events["NextPatch"];
                nextButton.guiActiveEditor = showTextureAssetButtons;

                BaseEvent prevButton = Events["PrevPatch"];
                nextButton.guiActiveEditor = showTextureAssetButtons;

                if (sprayTransform != null)
                {
                    sprayTransform.gameObject.SetActive(true);
                }
            }
            else
            {
                if (sprayTransform != null)
                {
                    sprayTransform.gameObject.SetActive(false);
                }
            }

            MissionPatchManager.Instance.ApplyTexture(textureQuadTransform, textureAssetIndex);
        }

        [KSPEvent(guiName = "Toggle Patch", guiActive = false, guiActiveEditor = true)]
        public void TogglePatch()
        {
            textureQuadVisible = !textureQuadVisible;
            textureQuadTransform.gameObject.SetActive(textureQuadVisible);
        }

        [KSPEvent(guiName = "Select Patch [Next]", guiActive = false, guiActiveEditor = true)]
        public void NextPatch()
        {
            textureAssetIndex++;

            if (textureAssetIndex > textureAssetCount)
            {
                textureAssetIndex = 0;
            }

            MissionPatchManager.Instance.ApplyTexture(textureQuadTransform, textureAssetIndex);
        }

        [KSPEvent(guiName = "Select Patch [Previous]", guiActive = false, guiActiveEditor = true)]
        public void PrevPatch()
        {
            textureAssetIndex--;

            if (textureAssetIndex < 0)
            {
                textureAssetIndex = textureAssetCount;
            }

            MissionPatchManager.Instance.ApplyTexture(textureQuadTransform, textureAssetIndex);
        }
    }
}
