﻿using System;
using System.Timers;
using UnityEngine;

namespace CursorDeleter
{
	[KSPAddon(KSPAddon.Startup.EveryScene, false)]
	public class CursorDeleter : MonoBehaviour
	{
		private Timer checkTimer;
		public void Awake()
		{
			/*
			 * Because this script might run before or after the cursor controller
			 * becomes available, this timer will repeatedly check for a
			 * controller instance.
			 */
			checkTimer = new System.Timers.Timer(20);
			checkTimer.Elapsed += _removeCursor;
			checkTimer.Enabled = true;
		}
		private void _removeCursor(object source, ElapsedEventArgs e)
		{
			if (Cursors.CursorController.Instance) //Only bother if there's a cursor controller to kill.
			{
				/*
				 * Kill the cursor controller WITH FIRE.
				 */
				Cursors.CursorController.Destroy(Cursors.CursorController.Instance);
				/*
				 * Set the cursor back to default.
				 */
				UnityEngine.Cursor.SetCursor(null, Vector2.zero, CursorMode.Auto);
				/*
				 * Done checking. Turn the timer off!
				 */
				checkTimer.Enabled = false;
			}
		}
	}
}

