require "util"

-- Configurable Parameters
-- "harmless" is the maximum pollution the player can withstand without damage

harmless = 1000

-- "pollution_per_point" is the number of pollution points above "harmless" for the player to take each full point of damage per second

pollution_per_point = 100

-- Variables used by this mod; not configurable

pollution = 0
damage = 0

script.on_event(defines.events.on_tick, function(event)
  if (event.tick/60 - math.floor(event.tick/60)) == 0
  -- top of second
  then
  pollution_damage_check()
  end
end)

function pollution_damage_check()
  for _, player in ipairs(game.connected_players) do
    pollution = player.surface.get_pollution(player.position)
    if pollution > harmless
    -- pollution is going to cause damage
    then
      pollution_damage(player)
    end
  end
end

function pollution_damage(player)
  damage = (pollution - harmless) / pollution_per_point
  damage = player.character.damage(damage, game.forces.neutral, "acid")
  -- keep the chat from getting spammed with too many decimal places
  damage = math.floor(damage * 100) / 100
  player.print("You took " .. damage .. " damage from pollution in this area.")
end