# Historical Progression Tech Tree

This tech tree is designed to take you through the history of the human space program. I always felt like the stock tech tree was lacking and did not like the placement of the parts. There are other tech trees that utilize the stock tech tree and move parts around and that is what inspired me to create a new tech tree like this. The tree will start you with Unmanned parts before you progress to learning how to send Kerbals into Space safely.

What I did with this tree is create a linear approach to Research. The entire tree is broken down into space associated disciplines so you are not required to research new fuel tanks before you get bigger and better engines. This allows the player to drive their research focus. If you as the player wants to get the next tier of electronics to support your craft, you have that option.

## TECH TREE BRANCHES
* ROCKETRY
  * Rocket Engine Parts
* JET ENGINES
  * Jet Engine Parts
* FUEL TANKS
  * Rocket Fuel Tanks
  * Liquid Fuel Tanks
  * Advanced Fuel Tanks
* AERODYNAMICS
  * Fairings
  * Advanced Wings
  * Nose Cones
  * Intakes
* ENGINEERING
  * Adapters
  * Decouplers
  * Landing Gear
  * Service Bays
  * Fuel Ducts
  * Docking Ports
  * Rover Wheels
* FLIGHT CONTROL
  * Probe Cores
  * RCS
  * MonoProp Tanks
  * Winglets
  * Reaction Wheels
* CREW SUPPORT
  * Command Pods
  * Cockpits
  * Parachutes
  * Heat Shields
  * Life Support
* SCIENCE
  * All Science Parts
* ELECTRONICS & COMMUNICATIONS
  * Power Generation
  * Power Storage
  * Antennas
  * Heat Control
 

## TECH TREE TIERS

The tiers are organized from left to right and are listed in numerical order. These are the tiers and the corresponding years that I have used for the placement of the parts.

**TIER 1: 1956 and Earlier**
This only includes the starting node with many more parts moved to the starting node than in Stock. There are also a node for Wings and Structural Pieces to remove them from the other nodes.

**TIER 2: 1957 - 1958**
This was the era when we moved from Sounding Rockets to ICBM's and finally to our first satellites like Sputnik and Explorer 1.

**TIER 3: 1959**
During this time, humans successfully flew by the Moon with the Luna program as well as developed the first techniques of returning capsules from space.

**TIER 4: 1960 - 1963**
These years are when Manned spaceflight first happened. Yuri Gregarin became the first person in space and in orbit, with Vostok 1 and the US launched astronauts in the Mercury Program. The first unmanned missions to another planet took place with flybys of Venus.

**TIER 5: 1964 - 1966**
This tier was when we progressed from single manned flights to multiple people in the same spacecraft. The duration of the flights in space increase from short times to up to two weeks. The techniques used to rendezvous and dock ships together were devloped during these years as well as the first landing on the Moon with Luna 9.

**TIER 6: 1967 - 1971**
We landed men on the Moon! This was the ultimate goal of both the US and USSR and the technology developed for huge rockets to launch men to the Moon as well as other unmanned spacecraft to Mars and Venus.

**TIER 7: 1972 - 1979**
This was the time when humans learned how to live in space. The Soviets launched their Salyut space station program and the United States did the same with Skylab. The first missions to the outer planets also took place with Pioneer 10, Pioneer 11, Voyager 1 and Voyager 2. Viking 1 also became the first successful landing on Mars.

**TIER 8: 1980 - 1993**
The Space Shuttle Era where we concentrated on living in Low Earth Orbit. The Soviets launched the Mir space station which was the first modular space station. 

**TIER 9: 1994 - 2005**
Long-term space habitation and rovers on Mars was the major focus during this period. Pathfinder became the first rover on another planet, humans lived for more than a year on Mir, and the construction of the International Space Station began.

**TIER 10: 2006 - 2020**
Back to the Moon or on to Mars? New technologies are being developed by many companies to provide the tools needed for humans to get back to the Moon and to also look to Mars as well.

**TIER 11: 2020 - 2050**
Near future technologies. These are experimental things that are in development right now that may one day help us reach farther than we ever have before.

**TIER 12: 2050 and beyond**
These technologies have not been developed yet, or they are just on the drawing board. Things like Warp Drives and FTL travel and Nuclear Fusion will take us to the stars.

## REQUIRED MODS
* Module Manager

## INCLUDED MODS
* Hide Empty Tech Tree Nodes by ev0

## INSTALLATION
1. Make sure you have Module Manager installed
2. Copy HPTechTree folder into your GameData folder

## MOD CONFLICTS
There will only be mod conflicts with mods that are new tech trees or move parts around in a different organization.

* Community Tech Tree
* Engineering Tech Tree
* SETI Tech Tree
* Unmanned Before Manned
* RP-0
* Open Tech Tree

## FULLY SUPPORTED PARTS MODS
Every parts mod will be supported out of the box as the design of the tech tree utilizes the existing nodes from the stock tech tree. For the most part, you will not have many conflicts as the parts will appear where the mod creator wanted them to. They will not necessarily show up in the exact proper place. If you would like to add support for your mod, please contact me. If you have a request for a mod to be fully supported, please let me know.

* Airplane Plus
* Atomic Age
* Aviation Lights
* BD Armory
* Bluedog Design Bureau
* Buffalo Rover
* Coatl Aerospace
* Cormorant Aeronology
* Cryo Engine & Cryo Tanks
* CxAerospace
* DMagic Orbital Science
* FASA
* Fuel Tanks Plus
* Hab Tech
* Interstellar (through their side)
* KAS
* KAX
* Kerbal Atomics
* Kerbal Planetary Base Systems
* Kerbal Reusability Expansion
* Kerbalism
* KIS
* kOS
* KW Rocketry
* Lonesomr Robots Gemini & Agena
* MechJeb
* Mk2 Expansion
* Modular Rocket Systems
* MOLE
* Near Future Packs
* Pathfinder
* Procedural Fairings
* Raidernicks Mods
  * Cygnus & Antares
  * Misc Parts
  * Skylab
  * US Probes
  * US Rockets
* Real Chute
* Real Scale Boosters
* RemoteTech
* Sample Capsule Return
* SCANsat
* SETI Probe Parts
* Sounding Rockets
* SpaceY Expanded
* SpaceY Heavy Lifters
* SSTU
* Station Science
* Surface Experiment Package
* Tantares
* Tantares (old pack)
* Tantares Launch Vehicles
* Tantares Launch Vehicles (old pack)
* TAC Life Support
* Universal Storage
* USI Life Support
* Vens Stock Revamp
* Wild Blue Tools

## FUTURE PLANS
I will be adding full integration of more mods. My plan is to continue to update the tree with new mods added. The order I will integrate the mods is determined by which I used in my own saves first.

## CHANGELOG

* 2.0 - February 22, 2017
  * Changed all tech costs from Tier 8 and later to better balance the tree and make the late game science more about exploring and less about waiting for Science Labs to generate enough science
    * Tier 8 down from 550 to 500
	* Tier 9  down from 1000 to 700
	* Tier 10 down from 1500 to 900
	* Tier 11 down from 2250 to 1100
	* Tier 12  down from 4000 to 1300
	* Tier 13  down from 4000 to 1500
	* Tier 14  down from 4000 to 1700
	* Tier 15  down from 4000 to 1900
  * Reorganized folders to have all Mods in their own file
  * NEW MOD SUPPORT
    * CxAerospace
	* Lonesome Robots Gemini & Agena
  * MOD UPDATES
    * Bluedog Design Bureau
	* Cormorant Aeronology (Shuttle Lifting Body)
	* Coatl Aerospace (0.15 RC)
	* Kerbal Reusability Expansion
	* MOLE
	* SSTU
	* Tantares
	* TantaresLV


* 1.9 - February 8, 2017
  * Updated to work with 1.2.2
  * No longer includes Hide Empty Tech Tree Nodes, but it should be downloaded for the best experience
  
* 1.8 - October 26, 2016
  * Updated with new 1.2 stock parts
  * 1.2 Compatible
  
* 1.7 - September 10, 2016
  * Fixed issues with Cormorant Aeronology (Shuttle Lifting Body)
  * Fixed issue with advMetalworks with the incorrect syntax (thanks Khantemplation)
  * Moved stock Vernor Engine to Tier 2 so it can be used with the T-30 Reliant Engine
  * NEW MOD SUPPORT
    * Aviation Lights
	* Coatl Aerospace
	* kOS
	* Modular Rocket Systems
	* Real Scale Boosters
	* RealChute
	* SSTU
	* TAC Life Support
	* Tantares
	* Tantares LV
	* Raidernick's Mods (Proton, R7, Salyut, Soviet Probes, Soyuz)
  * UPDATED MODS
    * Kerbal Reusability Expansion
	* Bluedog Design Bureau (Atlas *Muo* placement, H-1C placement, Juno Upper Stage placement)

* 1.6 - August 16, 2016
  * NEW MOD SUPPORT
    * Airplane Plus
	* Bluedog Design Bureau
	* RemoteTech
	* US Rockets updated with latest release

* 1.5 - August 5, 2016
  * NEW MOD SUPPORT
    * Sounding Rockets
	* Raidernicks Mods: Cygnus & Antares, Misc Parts, Skylab, US Probes, US Rockets
	* Updated Kerbal Reusability Expansion with New Parts
	
* 1.4 - August 4, 2016
  * NEW MOD SUPPORT
    * Buffalo Rover
	* FASA
	* KAX
	* MOLE
	* USI Life Support
	* Wild Blue Tools
	
* 1.3 - August 1, 2016
  * Integrated Hide Empty Tech Tree Nodes mod so if the node is empty, it will not be displayed
  * NEW MOD SUPPORT
    * Cormorant Aeronology
	* Kerbalism
	* Near Future
	* Atomic Age
	* Vens Stock Revamp
	* KIS
	* KAS
	* HabTech
	* Surface Experiment Package

* 1.2 - July 24, 2016
  * Fixed issue with Kerbal Reusability Expansion parts
  * NEW MOD SUPPORT
    * KW Rocketry
	
* 1.1.1 - July 22, 2016
  * NEW MOD SUPPORT
    * RemoteTech

* 1.1 - July 22, 2016
  * 10m Inflatable Heat Shield moved to Actuators
  * RC-0015 Remote Guidance Unit moved to Unamnned Tech
  * RC-L01 Remote Guidance Unit moved to Advanced Unmanned Tech
  * NEW MOD SUPPORT
    * Kerbal Reusability Expansion
    * Procedural Fairings
    * Sample Capsule Return
    * SETI Probe Parts
    * SpaceY Heavy Lifters
    * SpaceY Expanded

* 1.0 - July 21, 2016
  * Initial Release