# Contract Pack: Historical Progression

This contract pack is designed to take you through the history of the human space program. This entire contract pack was inspired by Whitecat106's Historic Missions contracts. He has created an incredible selection of close to 700 missions! For me, that is too much, and I wanted to go through the history of human spaceflight and progress how we have done in real life. I did not want to have to launch a mission that was almost the smae thing over and over again.

This contract pack takes you from the first sounding rockets to New Horizons and into the future. You will be tasked with recreating some of the most ambitious missions like the Apollo Program, Voyager and the International Space Station. It is up to you to guide the Kerbals into the cosmos through a historical progression.

Some of these contracts are very involved and require you to use gravity assists to accomplish the contract parameters. Others give you the option to complete certain goals in order to gain bonuses. For example, in your Space Shuttle contracts, you get bonus funds if you land your shuttle on the Runway back at KSC. One of the best examples of this is the MESSENGER contract. It requires you to enter a polar orbit of the first planet in the solar system. We will use the stock system  with the Real Solar System planets as an example.

### MESSENGER Contract Parameters

General Goal: Design an unmanned craft to Orbit Moho (Mercury) with a minimum Inclination of 70 degrees

1. Design an unmanned craft with an antenna (also with 3 SCANsat scanners if you have the mod installed)
2. Launch MESSENGER
3. Enter Orbit of the Sun
4. OPTIONAL BONUS: Flyby Kerbin (Earth) for a gravity assist
5. OPTIONAL BONUS: Flyby Eve (Venus) for a gravity assist
6. OPTIONAL BONUS: Flyby Eve (Venus) again for a gravity assist
7. OPTIONAL BONUS: Flyby Moho (Mercury) for a gravity assist
8. OPTIONAL BONUS: Flyby Moho (Mercury) again for a gravity assist
9. OPTIONAL BONUS: Flyby Moho (Mercury) for the third time for a gravity assist
10. Enter Orbit of Moho (Mercury) with a minimum Inclination of 70 degrees
11. Transmit Science Data from Space around Moho (Mercury)
12. If you have SCANsat installed, have 80% mapping of Low Quality, Biome and High Quality

Most of the missions are not that difficult or that involved, but MESSENGER was launched in 2004 after more than 50 years of spaceflight and we knew some new tricks to help us achieve an orbit.

**HISTORICAL PROGRESSION CONTRACTS**
* Sounding Rocket	- First Launches
* V-2	- First Suborbital Flight
* Sputnik	- First Satellite
* Sputnik 2	- First Object with Living Creatures to Orbit
* Explorer 1 - First American Satellite
* Vanguard 1 - First Solar Powered Satellite, Oldest Object still in Earth Orbit
* Luna 1 - First Flyby of Moon
* Explorer 6 - First Photo of Earth from Orbit
* Luna 2 - First Impact into Moon
* Luna 3 - First Images of Farside of Moon
* Discoverer 13 - First Object to Orbit and Return something to Earth
* Mercury-Redstone 2 - First Primate in Space
* Venera 1 - First Flyby of Venus
* Koarbl-Sputnik 5 - First Mammals to Orbit and Return to Earth
* Vostok 1 - First Human to Orbit Earth
* Freedom 7 - First Suborbital Human Flight
* Vostok 2 - 1 Day Spent in Space
* OSO-1 - First Solar Observatory
* Telstar 1 - First Communications Satellite
* Mariner 2 - First Succesful Venus Flyby (science data returned)
* Vostok 6 - First Woman in Space
* Syncom 2 - First Geosynchronous Satellite
* Syncom 3 - First Geostationary Satellite
* Voskhod 1 - 3 Humans in One Capsule
* Mariner 4 - First Flyby of Mars, First Pictures of Mars
* Voskhod 2 - First EVA
* Gemini V - 7 Days in Space
* Venera 3 - First Impact into Venus
* Gemini 6 & Gemini 7 - First Orbital Rendezvous
* Luna 9 - First Soft Landing on Moon, First Images from Surface of Moon
* Gemini 8 - First Orbital Docking
* Luna 10 - First Satellite Around Moon
* Venera 4 - First Probe to Send Data from Venus Atmosphere
* Kosmos 186 & Kosmos 188 - First Automated Docking
* Apollo 4 - First Test of Saturn V
* Zond 5 - First to Orbit Moon and Return to Earth
* OAO-2 - First Ultraviolet Telescope
* Apollo 8 - First Humans to Orbit Moon
* Apollo 11 - First Landing on Moon
* Apollo 12 - Second Landing on Moon
* Soyuz 9 - 14 Days in Space
* Venera 7 - First Soft Landing on Venus
* Luna 16 - First Automated Sample Return from Moon
* Lunokhod 1 - First Rover on Moon
* Apollo 14 - Third Landing on Moon
* Salyut 1 - First Space Station
* Mars 2 - First Impact into Mars
* Mars 3 - First Soft Landing on Mars
* Mariner 9 - First Orbit of Mars
* Apollo 15 - Fourth Landing on Moon, First Rover
* Pioneer 10 - First Ship on Escape Trajectory from Sun, Pass Asteroid Belt, Jupiter Flyby
* Apollo 16 - Fifth Landing on Moon, 3 Days on Moon
* Apollo 17 - Final Landing on Moon
* Pioneer 11 - First Saturn Flyby
* Skylab & Skylab 2 - First American Space Station, 28 Days in Space
* Skylab 3 - 56 Days in Space
* Mariner 10 - First Photos of Venus, First Mercury Flyby
* Skylab 4 - 84 Days in Space
* Venera 9 - First Orbit of Venus, First Images from Surface of Venus
* Apollo-Soyuz - First International Joint Mission
* Viking 1 - First Images from Mars Surface, First Soil Samples of Mars
* Helios - Closest Ever Flyby of Sun
* Voyager 2 - First Uranus Flyby, First Neptune Flyby
* Voyager 1 - Flyby of Jupiter, Flyby of 5 Jupiter Moons, Flyby of Saturn, First in Interstellar Space
* Pioneer Venus Orbiter - First Multi-Year Mission at Venus
* STS-1 - First Reusable Manned Spacecraft
* Venera 13 - First Venus Soil Samples, First Sounds from Venus Surface
* STS-5 - 4 Crew Members
* IRAS - First Infrared Orbital Observatory
* STS-7 - 5 Crew Members
* STS-9 - 6 Crew Members
* STS-41B - First Untethered EVA
* STS-41G - 7 Crew Members
* Mir - First Long-Term Modular Space Station
* Mir Kvant-1 - First Module Addition to Space Station
* Soyuz TM-4 - 365 Days in Space
* Phobos 2 - First Flyby of Phobos
* Magellan - First to Map Venus
* Hipparcos - First Astrometric Observatory
* Galileo - First Orbit of Jupiter, First Probe in Jupiter Atmosphere
* COBE - First Orbital Cosmic Microwave Observatory
* Hubble - First Optical Observatory
* STS-61 - Repair Hubble
* NEAR Shoemaker - First Orbit of Asteroid, First Landing on Asteroid
* Pathfinder - First Rover on Mars
* HALCA - First Orbital Radio Observatory
* Cassini-Huygens - First Orbit of Saturn, First Landing on Titan
* ISS-Zarya - First Multinational Space Station
* ISS-Unity - Building the ISS
* ISS-Zvezda - Building the ISS
* ISS-Expedition 1 - First Crew on ISS
* Dennis Tito - First Tourist in Space
* Genesis - First Vessel Return from beyond Moon
* Hayabusa - First Ascent from Asteroid, First Sample Return from Asteroid Surface
* MESSENGER - First Orbit Mercury
* New Horizons - First Flyby Pluto

**REQUIRED MODS**
* Contract Configurator - http://forum.kerbalspaceprogram.com/threads/101604
* Module Manager - http://forum.kerbalspaceprogram.com/threads/55219

**HIGHLY, HIGHLY, HIGHLY RECOMMENDED MODS**
These are not nessecary to use the contract pack, but it makes the pack much better
* Unmanned Before Manned - (http://forum.kerbalspaceprogram.com/threads/106130)
  * This lets you start with the proper probe cores instead of manned missions, the contract pack might not be possible to complete without this or something similar
* Outer Planets Mod - (http://forum.kerbalspaceprogram.com/index.php?/topic/93999-112-outer-planets-mod-20-complete-overhaul-better-terrain-nicer-terrain-textures-improved-scatter-etc-21-may/)
  * If you are playing with stock KSP, this will give you the extra planets that simulate the outer solar system and will allow you to explore these places with contracts like New Horizons and Voyager 1 and 2
* Real Solar System
  * If you are up for it, you can recreate some of the most famous missions in different scaled Real Solar Systems
  * Real Solar System - (http://forum.kerbalspaceprogram.com/index.php?/topic/50471-113-real-solar-system-v1140-july-3/)
  * Half Size Real Solar System - (http://forum.kerbalspaceprogram.com/index.php?/topic/142336-113-half-size-rss-v15/)
  * Stock Size Real Solar System - (http://forum.kerbalspaceprogram.com/index.php?/topic/138572-wip-113-117-stock-size-real-solar-system/)
* DMagic Orbital Science - (http://forum.kerbalspaceprogram.com/index.php?/topic/59009-113-dmagic-orbital-science-new-science-parts-v132-6272016/)
  * This gives you more science experiments to use on your various missions around the solar system
* SCANsat - (http://forum.kerbalspaceprogram.com/index.php?/topic/72679-113-scansat-v163-real-scanning-real-science-at-warp-speed-june-27-2016/)
  * This provides you with parts to map the planets in the solar system. The contracts have support for Scanning missions if SCANsat is installed.
* Life Support Mods
  * There are many to choose from, but I reccomend picking at least one of them. Some of these contracts are setting new duration records in space and there is no real challenge to them without having Life Support of some kind.
  
**OTHER MODS TO CONSIDER**
There are many part mods to consider that will give you the ability to construct realistic looking, or in some cases replicas of the spacecraft that are simulated in this contract pack.
* Bluedog Design Bureau (NASA / ESA)
* FASA (NASA)
* Raidernick's Awesome Collection of Mods
  * Skylab
  * US & Soviet Solar Panels Pack
  * Salyut Stations
  * Soviet Spacecraft
  * Soviet Probes
  * US Probes Pack
  * US Rockets Pack
  * Antares & Cygnus  
  
**NOTES**
* The contract removes the World Firsts and Explore Body stock missions as we are already covering this with the pack
* This contract pack works with all planet packs, but you will experience some weird contracts if your Home planet is not the 3rd rock from the sun
* Full support for Stock, Stock x2, Stock x6.4, Outer Planets Mod
* Full support for Real Solar System, Half Size Real Solar System, Stock Size Real Solar System
* I do not know how this will play with other Contract Packs unless listed below, as it is designed to go through all major "firsts" of our space history so will duplicate similar contracts from other packs
* Most missions cannot be cancelled nor will they expire. There are a set of optional missions and more will be coming down the line. These optional missions can be cancelled and do not need to be completed.

**COMPATIBLE CONTRACT PACKS**
* Anomoly Surveyor
* AntennaRange Relays
* Clever Sats
* Field Research
* Giving Aircraft a Purpose (GAP)
* Kerbal Academy
* Maritime Mission Pack
* RemoteTech Contract Pack

**INSTALLATION**
1. Make sure you have Contract Configurator and Module Manager Installed as they are NOT included with the download
2. Download the Contract Pack
3. Copy to GameData folder
4. Enjoy!

**FUTURE PLANS**
* Add Final Missions
  * Dawn - First Orbit of Giant Asteroid
  * Kepler Telescope - First Telescope to look for Planets outside Solar System
  * Dragon First Orbit - First Private Ship to Reach Orbit
  * Juno - First Polar Orbit of Jupiter
  * Falcon Flight 20 - First Powered Landing of First Stage of Rocket
* Add a requirement that Probe Missions to other planets end with the destruction of the probe
* Moon / Mun contracts will require specific biomes to be reached (want to stop players from landing on the far side)
* Add a requirement to deorbit and destroy Space Stations after
* Add additional SCANsat mission support
* Add additional DMagic Orbital Science Mission Support
* Add OPTIONAL MISSIONS
  * Additional Moon / Mun / Minmus Unmanned Landing Missions
    * Surveyor 1
	* Luna 13
	* Surveyor 3
	* Surveyor 5
	* Surveyor 6
	* Surveyor 7
	* Lunokhod 2
  * Additional Mars / Duna Missions
    * Landers
	  * Viking 2
	  * Phoenix
	  * Insight
	* Orbiters
	  * Mars Global Surveyor
	  * MAVEN
	* Rovers
	  * Spirit
	  * Opportunity
	  * Curiosity
  * Mir Space Station Construction
  * ISS Construction
  * Apollo Applications Program
    * Manned Venus Flyby (this was a proposed mission using Apollo hardware)
  * Future Missions
    * OSIRIS Rex
	* Asteroid Redirect Mission
	* Mars Sample Return Mission
	* Europa Mission
	* Red Dragon
	* Mars 2020
	
**LICENSE**
CC-BY-NC-SA (http://creativecommons.org/licenses/by-nc-sa/4.0/)

**CHANGELOG**

1.6 - April 24, 2017
* Small fixes to many missions to fix completion issues
* Fix to STS-41B by removing the EVA as it was not working correctly
* Fix Apollo Rover missions by allowing player to accopmlish mission using a separate craft from lander

1.5 - March 6, 2017
* Fixed secondary Apoapsis in Apollo 4 to make it be on the correct side of the Mun in stock sizes!
* Fixed Gemini 8 mission for the proper docking
* Fixed Shuttle Missions so that you get the credit for Returning Home
* Fixed the Space Station missions to mark parameters as completed correctly


1.4 - January 27, 2017
* Fixed mission for Gemini 7 / Gemini-6
* Fixed Apollo missions, can now be completed with the Rover
* Removed requirements for probes to  have antenna - with the new Coms system in 1.2 it was duplicative

1.3 - August 22, 2016

* Brand New Financial Reward System - This is completely based on the radius of your Home Planet. If you have a larger size Homeworld such as a resized Kerbin or RSS build, then the funds rewards will adjust accordingly to meet the increase costs required to accomplish mission goals
* Zond Orbit Parameters updated
* REMOVED: Venera 3 as it was essentailly a failed mission and Venera 4 was a repeat
* Fixed Phobos 2 prerequisite to allow mission to actually fire correctly
* Adding correct sorting for all contracts so they will show up in order in the Mission Control building interface
* Fixed prestige settings of all missions
* Apollo 14 and Apollo 16 will go to Minmus (unless you have some version of RSS installed and then it will be the Moon)
* Fixed issue where Venera 9 wouldn't check off Orbit Parameter when switching to the Lander

1.2 - July 23, 2016

* Massive Behind the Scenes Overhaul to prepare release for Contract Configurator Update
* Freedom 7 - Moved to Optional
* Vostok 2 - Available after Vostok-1
* Mir: Kvant - Changed Requirement to be finished Mir mission
* Mars 2 - REMOVED - Was a failed mission as it crashed into Mars
* Mars 3 - REMOVED - Was a failed mission since it did not communicate with Earth on landing
* Helios - Fixed Mission Description to give correct Orbital Distance
* NEW! Optional Missions
  * Moon Missions
    * Surveyor 1 - Unmanned Lunar Lander
	* Luna 13 - Unmanned Lunar Lander
	* Surveyor 3 - Unmanned Lunar Lander
	* Surveyor 5 - Unmanned Lunar Lander
	* Surveyor 6 - Unmanned Lunar Lander
	* Surveyor 7 - Unmanned Lunar Lander
	* Lunokhod-2 - Unmanned Lunar Rover
  * Mars Missions
    * Viking 2 - Unmanned Mars/Duna Lander
  * Mir
    * Kristall - Mir Module
	* Soyuz TM-18 - 437 Days in Space
	* Spektr - Mir Module
	* STS-71 - Space Shuttle Docking to Mir
	* STS-74 Mir Docking Module - Mir Module Launched by Space Shuttle
	* Priroda - Mir Module
	* Soyuz TM-31 - Last Human Spaceflight to Mir
	* Mir Deorbit

1.1 - July 12, 2016

* V-2 - Removed the need to destroy the rocket at the end of the contract, was not allowing completion in some cases
* Sputnik 2 - Moved to OPTIONAL (mission is essentially the same as Sputnik)
* Explorer 1 - Moved to OPTIONAL (mission is essentially the same as Sputnik)
* Explorer 6 - Moved to OPTIONAL (mission is essentially the same as Sputnik)
* NEW: Dawn (orbit around giant asteroid, Dres in stock or Vesta & Ceres in Half Size RSS, will not show up in regular RSS)
* NEW: Kepler (first telescope to look for exoplanets)
* NEW: Juno (first mission to enter polar orbit of Jupiter)
* Removed duplicate descriptions
* Kosmos 186 & Kosmos 188 Contract - Fixed the way the docking vessels were treated not allowing the contract to complete
* Luna 10 and Zond 5 Contracts - Fixed an issue where they were offered multiple of times
* Apollo 4 - Fixed the way the Crew Capacity was handled so players could include a Lander for their test as well
* Apollo Program - Fixed the wording on the contracts to better let the player know the Parking Orbit requirements
* Changed Antenna requirements to read Transmission Devices for clarity for player
* Syncom 2 and Syncom 3 Contracts - Changed orbital requirements to require closer to a circular orbit
* Gemini 7 & Gemini 6A Contract - Completely re-wrote to work more consistently

1.01 - July 9, 2016
* Fixed some text on Explorer 6 mission
* Modified some Duna / Mars contracts for stability
* Added main logo in anticipation of Contract Configurator 1.15

1.0 - July 8, 2016
* Initial Release