// Compiled shader for all platforms, uncompressed size: 14331.2KB

// Skipping shader variants that would not be included into build of current scene.

Shader "EVE/Cloud" {
Properties {
 _Color ("Color Tint", Color) = (1,1,1,1)
 _MainTex ("Main (RGB)", 2D) = "white" { }
 _DetailTex ("Detail (RGB)", 2D) = "white" { }
 _UVNoiseTex ("UV Noise (RG)", 2D) = "black" { }
 _FalloffPow ("Falloff Power", Range(0,3)) = 2
 _FalloffScale ("Falloff Scale", Range(0,20)) = 3
 _DetailScale ("Detail Scale", Range(0,100)) = 100
 _DetailDist ("Detail Distance", Range(0,1)) = 0.00875
 _UVNoiseScale ("UV Noise Scale", Range(0,0.1)) = 0.01
 _UVNoiseStrength ("UV Noise Strength", Range(0,0.1)) = 0.002
 _UVNoiseAnimation ("UV Noise Animation", Vector) = (0.002,0.001,0,1)
 _MinLight ("Minimum Light", Range(0,1)) = 0.5
 _DistFade ("Fade Distance", Range(0,100)) = 10
 _DistFadeVert ("Fade Scale", Range(0,1)) = 0.002
 _RimDist ("Rim Distance", Range(0,1)) = 1
 _RimDistSub ("Rim Distance Sub", Range(0,2)) = 1.01
 _InvFade ("Soft Particles Factor", Range(0.01,3)) = 0.01
 _OceanRadius ("Ocean Radius", Float) = 63000
 _PlanetOrigin ("Sphere Center", Vector) = (0,0,0,1)
 _DepthPull ("Depth Augment", Float) = 0.99
 _SunPos ("_SunPos", Vector) = (0,0,0,1)
 _SunRadius ("_SunRadius", Float) = 1
}
SubShader { 
 Tags { "QUEUE"="Transparent+1" "IGNOREPROJECTOR"="true" "RenderType"="Transparent" }


 // Stats for Vertex shader:
 //       d3d11 : 33 avg math (33..34)
 //        d3d9 : 38 avg math (37..39)
 //        gles : 369 avg math (313..421), 5 avg texture (3..10), 3 avg branch (2..5)
 //       metal : 16 avg math (15..18)
 //      opengl : 366 avg math (313..417), 5 avg texture (3..10), 3 avg branch (2..5)
 // Stats for Fragment shader:
 //       d3d11 : 300 avg math (255..330), 2 avg texture (1..4)
 //        d3d9 : 311 avg math (269..341), 12 avg texture (5..24)
 //       metal : 366 avg math (313..417), 5 avg texture (3..10), 3 avg branch (2..5)
 Pass {
  Tags { "LIGHTMODE"="ForwardBase" "QUEUE"="Transparent+1" "IGNOREPROJECTOR"="true" "SHADOWSUPPORT"="true" "RenderType"="Transparent" }
  Lighting On
  ZWrite Off
  Cull Off
  Blend SrcAlpha OneMinusSrcAlpha
  ColorMask RGB
  GpuProgramID 22574
Program "vp" {
SubProgram "opengl " {
// Stats: 375 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec2 uv_17;
  vec3 tmpvar_18;
  tmpvar_18 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_19;
  tmpvar_19 = abs(tmpvar_18);
  float tmpvar_20;
  tmpvar_20 = float((tmpvar_19.z >= tmpvar_19.x));
  float tmpvar_21;
  tmpvar_21 = float((max (tmpvar_19.x, tmpvar_19.z) >= tmpvar_19.y));
  float tmpvar_22;
  tmpvar_22 = sign(mix (tmpvar_18.y, mix (tmpvar_18.x, tmpvar_18.z, tmpvar_20), tmpvar_21));
  vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = -(tmpvar_22);
  vec3 tmpvar_24;
  tmpvar_24.xz = vec2(1.0, -1.0);
  tmpvar_24.y = tmpvar_22;
  vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = tmpvar_22;
  vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_18.yxz), mix ((tmpvar_23 * tmpvar_18.xzy), (tmpvar_24 * tmpvar_18.zxy), vec3(tmpvar_20)), vec3(tmpvar_21));
  uv_17 = (((
    (0.5 * tmpvar_26.yz)
   / 
    abs(tmpvar_26.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_27;
  vec2 tmpvar_28;
  tmpvar_28 = abs((uv_17 - (0.5 * _DetailScale)));
  uvCont_27.x = max (tmpvar_28.x, tmpvar_28.y);
  uvCont_27.y = min (tmpvar_28.x, tmpvar_28.y);
  vec4 tmpvar_29;
  tmpvar_29.xy = dFdx(uvCont_27);
  tmpvar_29.zw = dFdy(uvCont_27);
  vec3 tmpvar_30;
  tmpvar_30 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw)) * mix (texture2DGradARB (_DetailTex, uv_17, tmpvar_29.xy, tmpvar_29.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_30, tmpvar_30)))
  , 0.0, 1.0))));
  float tmpvar_31;
  tmpvar_31 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_32;
  tmpvar_32 = sqrt(dot (tmpvar_30, tmpvar_30));
  vec3 tmpvar_33;
  tmpvar_33 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_34;
  tmpvar_34 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_32), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_32)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_31, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_33, tmpvar_33)) - (_RimDistSub * sqrt(
      dot (tmpvar_34, tmpvar_34)
    ))))
  , 0.0, 1.0)));
  float tmpvar_35;
  tmpvar_35 = color_2.w;
  vec4 c_36;
  float tmpvar_37;
  tmpvar_37 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_36.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_37 * 2.0));
  c_36.w = (tmpvar_37 * 2.0);
  float tmpvar_38;
  tmpvar_38 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_36 * mix (1.0, clamp (
    floor((1.01 + tmpvar_38))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_38))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_35;
  vec4 v_39;
  v_39.x = _ShadowBodies[0].x;
  v_39.y = _ShadowBodies[1].x;
  v_39.z = _ShadowBodies[2].x;
  float tmpvar_40;
  tmpvar_40 = _ShadowBodies[3].x;
  v_39.w = tmpvar_40;
  vec3 tmpvar_41;
  tmpvar_41 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_42;
  tmpvar_42 = (3.141593 * (tmpvar_40 * tmpvar_40));
  vec3 tmpvar_43;
  tmpvar_43 = (v_39.xyz - xlv_TEXCOORD0);
  float tmpvar_44;
  tmpvar_44 = dot (tmpvar_43, normalize(tmpvar_41));
  float tmpvar_45;
  tmpvar_45 = (_SunRadius * (tmpvar_44 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_46;
  tmpvar_46 = (3.141593 * (tmpvar_45 * tmpvar_45));
  float x_47;
  x_47 = ((2.0 * clamp (
    (((tmpvar_40 + tmpvar_45) - sqrt((
      dot (tmpvar_43, tmpvar_43)
     - 
      (tmpvar_44 * tmpvar_44)
    ))) / (2.0 * min (tmpvar_40, tmpvar_45)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_48;
  v_48.x = _ShadowBodies[0].y;
  v_48.y = _ShadowBodies[1].y;
  v_48.z = _ShadowBodies[2].y;
  float tmpvar_49;
  tmpvar_49 = _ShadowBodies[3].y;
  v_48.w = tmpvar_49;
  float tmpvar_50;
  tmpvar_50 = (3.141593 * (tmpvar_49 * tmpvar_49));
  vec3 tmpvar_51;
  tmpvar_51 = (v_48.xyz - xlv_TEXCOORD0);
  float tmpvar_52;
  tmpvar_52 = dot (tmpvar_51, normalize(tmpvar_41));
  float tmpvar_53;
  tmpvar_53 = (_SunRadius * (tmpvar_52 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_54;
  tmpvar_54 = (3.141593 * (tmpvar_53 * tmpvar_53));
  float x_55;
  x_55 = ((2.0 * clamp (
    (((tmpvar_49 + tmpvar_53) - sqrt((
      dot (tmpvar_51, tmpvar_51)
     - 
      (tmpvar_52 * tmpvar_52)
    ))) / (2.0 * min (tmpvar_49, tmpvar_53)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_56;
  v_56.x = _ShadowBodies[0].z;
  v_56.y = _ShadowBodies[1].z;
  v_56.z = _ShadowBodies[2].z;
  float tmpvar_57;
  tmpvar_57 = _ShadowBodies[3].z;
  v_56.w = tmpvar_57;
  float tmpvar_58;
  tmpvar_58 = (3.141593 * (tmpvar_57 * tmpvar_57));
  vec3 tmpvar_59;
  tmpvar_59 = (v_56.xyz - xlv_TEXCOORD0);
  float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, normalize(tmpvar_41));
  float tmpvar_61;
  tmpvar_61 = (_SunRadius * (tmpvar_60 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_62;
  tmpvar_62 = (3.141593 * (tmpvar_61 * tmpvar_61));
  float x_63;
  x_63 = ((2.0 * clamp (
    (((tmpvar_57 + tmpvar_61) - sqrt((
      dot (tmpvar_59, tmpvar_59)
     - 
      (tmpvar_60 * tmpvar_60)
    ))) / (2.0 * min (tmpvar_57, tmpvar_61)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_64;
  v_64.x = _ShadowBodies[0].w;
  v_64.y = _ShadowBodies[1].w;
  v_64.z = _ShadowBodies[2].w;
  float tmpvar_65;
  tmpvar_65 = _ShadowBodies[3].w;
  v_64.w = tmpvar_65;
  float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_65 * tmpvar_65));
  vec3 tmpvar_67;
  tmpvar_67 = (v_64.xyz - xlv_TEXCOORD0);
  float tmpvar_68;
  tmpvar_68 = dot (tmpvar_67, normalize(tmpvar_41));
  float tmpvar_69;
  tmpvar_69 = (_SunRadius * (tmpvar_68 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_70;
  tmpvar_70 = (3.141593 * (tmpvar_69 * tmpvar_69));
  float x_71;
  x_71 = ((2.0 * clamp (
    (((tmpvar_65 + tmpvar_69) - sqrt((
      dot (tmpvar_67, tmpvar_67)
     - 
      (tmpvar_68 * tmpvar_68)
    ))) / (2.0 * min (tmpvar_65, tmpvar_69)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_46 - 
      (((0.3183099 * (
        sign(x_47)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_47)
        )) * (1.570796 + (
          abs(x_47)
         * 
          (-0.2146018 + (abs(x_47) * (0.08656672 + (
            abs(x_47)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_42)
    ) / tmpvar_46), 0.0, 1.0), (float((tmpvar_44 >= tmpvar_40)) * clamp (tmpvar_42, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_54 - 
      (((0.3183099 * (
        sign(x_55)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_55)
        )) * (1.570796 + (
          abs(x_55)
         * 
          (-0.2146018 + (abs(x_55) * (0.08656672 + (
            abs(x_55)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_50)
    ) / tmpvar_54), 0.0, 1.0), (float((tmpvar_52 >= tmpvar_49)) * clamp (tmpvar_50, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_62 - 
      (((0.3183099 * (
        sign(x_63)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_63)
        )) * (1.570796 + (
          abs(x_63)
         * 
          (-0.2146018 + (abs(x_63) * (0.08656672 + (
            abs(x_63)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_58)
    ) / tmpvar_62), 0.0, 1.0), (float((tmpvar_60 >= tmpvar_57)) * clamp (tmpvar_58, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_70 - 
      (((0.3183099 * (
        sign(x_71)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_71)
        )) * (1.570796 + (
          abs(x_71)
         * 
          (-0.2146018 + (abs(x_71) * (0.08656672 + (
            abs(x_71)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_66)
    ) / tmpvar_70), 0.0, 1.0), (float((tmpvar_68 >= tmpvar_65)) * clamp (tmpvar_66, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_35 * float((tmpvar_31 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 37 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord8 o7
dp4 o0.z, c2, v0
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r0.z, r0.y, c19.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xzw, r0.xywz, c22.x
mov o0.xyw, r0
mov o7.w, r0.w
mad o7.xy, r1.z, c20.zwzw, r1.xwzw
dp4 r0.x, c14, v0
mov o7.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21

"
}
SubProgram "d3d11 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa
eefiecedgiicdmggkfmgbpmnnbkbpdjemeopdldcabaaaaaaamahaaaaadaaaaaa
cmaaaaaajmaaaaaaieabaaaaejfdeheogiaaaaaaadaaaaaaaiaaaaaafaaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaaaaaaaaaapapaaaafjaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaapaaaaaafpaaaaaaaaaaaaaaaaaaaaaaadaaaaaaacaaaaaa
ahaaaaaafaepfdejfeejepeoaaedepemepfcaaeoepfcenebemaaklklepfdeheo
oaaaaaaaaiaaaaaaaiaaaaaamiaaaaaaaaaaaaaaabaaaaaaadaaaaaaaaaaaaaa
apaaaaaaneaaaaaaaaaaaaaaaaaaaaaaadaaaaaaabaaaaaaahaiaaaaneaaaaaa
abaaaaaaaaaaaaaaadaaaaaaacaaaaaaahaiaaaaneaaaaaaacaaaaaaaaaaaaaa
adaaaaaaadaaaaaaapaaaaaaneaaaaaaadaaaaaaaaaaaaaaadaaaaaaaeaaaaaa
apaaaaaaneaaaaaaaeaaaaaaaaaaaaaaadaaaaaaafaaaaaaahaiaaaaneaaaaaa
afaaaaaaaaaaaaaaadaaaaaaagaaaaaaahaiaaaaneaaaaaaaiaaaaaaaaaaaaaa
adaaaaaaahaaaaaaapaaaaaafdfgfpfaepfdejfeejepeoaafeeffiedepepfcee
aaklklklfdeieefciaafaaaaeaaaabaagaabaaaafjaaaaaeegiocaaaaaaaaaaa
bnaaaaaafjaaaaaeegiocaaaabaaaaaaagaaaaaafjaaaaaeegiocaaaacaaaaaa
baaaaaaafpaaaaadpcbabaaaaaaaaaaaghaaaaaepccabaaaaaaaaaaaabaaaaaa
gfaaaaadhccabaaaabaaaaaagfaaaaadhccabaaaacaaaaaagfaaaaadpccabaaa
adaaaaaagfaaaaadpccabaaaaeaaaaaagfaaaaadhccabaaaafaaaaaagfaaaaad
hccabaaaagaaaaaagfaaaaadpccabaaaahaaaaaagiaaaaacaeaaaaaadiaaaaai
pcaabaaaaaaaaaaafgbfbaaaaaaaaaaaegiocaaaacaaaaaaabaaaaaadcaaaaak
pcaabaaaaaaaaaaaegiocaaaacaaaaaaaaaaaaaaagbabaaaaaaaaaaaegaobaaa
aaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaaacaaaaaakgbkbaaa
aaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaa
adaaaaaapgbpbaaaaaaaaaaaegaobaaaaaaaaaaadgaaaaafpccabaaaaaaaaaaa
egaobaaaaaaaaaaadiaaaaaihcaabaaaabaaaaaafgbfbaaaaaaaaaaaegiccaaa
acaaaaaaanaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaamaaaaaa
agbabaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaa
acaaaaaaaoaaaaaakgbkbaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
abaaaaaaegiccaaaacaaaaaaapaaaaaapgbpbaaaaaaaaaaaegacbaaaabaaaaaa
dgaaaaafhccabaaaabaaaaaaegacbaaaabaaaaaaaaaaaaakhccabaaaacaaaaaa
egiccaaaaaaaaaaabmaaaaaaegiccaiaebaaaaaaabaaaaaaaeaaaaaadiaaaaai
pcaabaaaacaaaaaafgbfbaaaaaaaaaaaegiocaaaaaaaaaaaakaaaaaadcaaaaak
pcaabaaaacaaaaaaegiocaaaaaaaaaaaajaaaaaaagbabaaaaaaaaaaaegaobaaa
acaaaaaadcaaaaakpcaabaaaacaaaaaaegiocaaaaaaaaaaaalaaaaaakgbkbaaa
aaaaaaaaegaobaaaacaaaaaadcaaaaakpcaabaaaacaaaaaaegiocaaaaaaaaaaa
amaaaaaapgbpbaaaaaaaaaaaegaobaaaacaaaaaadiaaaaaipcaabaaaadaaaaaa
fgafbaaaacaaaaaaegiocaaaaaaaaaaaaoaaaaaadcaaaaakpcaabaaaadaaaaaa
egiocaaaaaaaaaaaanaaaaaaagaabaaaacaaaaaaegaobaaaadaaaaaadcaaaaak
pcaabaaaadaaaaaaegiocaaaaaaaaaaaapaaaaaakgakbaaaacaaaaaaegaobaaa
adaaaaaadcaaaaakpccabaaaadaaaaaaegiocaaaaaaaaaaabaaaaaaapgapbaaa
acaaaaaaegaobaaaadaaaaaadgaaaaafpccabaaaaeaaaaaaegaobaaaacaaaaaa
aaaaaaajhcaabaaaacaaaaaaegacbaaaabaaaaaaegiccaiaebaaaaaaacaaaaaa
apaaaaaaaaaaaaajhcaabaaaabaaaaaaegacbaiaebaaaaaaabaaaaaaegiccaaa
abaaaaaaaeaaaaaabaaaaaahecaabaaaaaaaaaaaegacbaaaacaaaaaaegacbaaa
acaaaaaaeeaaaaafecaabaaaaaaaaaaackaabaaaaaaaaaaadiaaaaahhccabaaa
afaaaaaakgakbaaaaaaaaaaaegacbaaaacaaaaaabaaaaaahecaabaaaaaaaaaaa
egacbaaaabaaaaaaegacbaaaabaaaaaaeeaaaaafecaabaaaaaaaaaaackaabaaa
aaaaaaaadiaaaaahhccabaaaagaaaaaakgakbaaaaaaaaaaaegacbaaaabaaaaaa
diaaaaaiccaabaaaaaaaaaaabkaabaaaaaaaaaaaakiacaaaabaaaaaaafaaaaaa
diaaaaakncaabaaaabaaaaaaagahbaaaaaaaaaaaaceaaaaaaaaaaadpaaaaaaaa
aaaaaadpaaaaaadpdgaaaaaficcabaaaahaaaaaadkaabaaaaaaaaaaaaaaaaaah
dccabaaaahaaaaaakgakbaaaabaaaaaamgaabaaaabaaaaaadiaaaaaibcaabaaa
aaaaaaaabkbabaaaaaaaaaaackiacaaaacaaaaaaafaaaaaadcaaaaakbcaabaaa
aaaaaaaackiacaaaacaaaaaaaeaaaaaaakbabaaaaaaaaaaaakaabaaaaaaaaaaa
dcaaaaakbcaabaaaaaaaaaaackiacaaaacaaaaaaagaaaaaackbabaaaaaaaaaaa
akaabaaaaaaaaaaadcaaaaakbcaabaaaaaaaaaaackiacaaaacaaaaaaahaaaaaa
dkbabaaaaaaaaaaaakaabaaaaaaaaaaadgaaaaageccabaaaahaaaaaaakaabaia
ebaaaaaaaaaaaaaadoaaaaab"
}
SubProgram "gles " {
// Stats: 375 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec2 uv_21;
  mediump vec3 detailCoords_22;
  mediump float s_23;
  mediump float nylerp_24;
  mediump float zxlerp_25;
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_27;
  tmpvar_27 = abs(tmpvar_26);
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_27.z >= tmpvar_27.x));
  zxlerp_25 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = float((max (tmpvar_27.x, tmpvar_27.z) >= tmpvar_27.y));
  nylerp_24 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = mix (tmpvar_26.x, tmpvar_26.z, zxlerp_25);
  s_23 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_26.y, s_23, nylerp_24));
  s_23 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(s_23);
  mediump vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = s_23;
  highp vec3 tmpvar_34;
  tmpvar_34 = mix ((tmpvar_32 * tmpvar_26.xzy), (tmpvar_33 * tmpvar_26.zxy), vec3(zxlerp_25));
  detailCoords_22 = tmpvar_34;
  mediump vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = s_23;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_26.yxz), detailCoords_22, vec3(nylerp_24));
  detailCoords_22 = tmpvar_36;
  uv_21 = (((
    (0.5 * detailCoords_22.yz)
   / 
    abs(detailCoords_22.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_37;
  uv_37 = uv_21;
  highp vec2 uvCont_38;
  highp vec2 tmpvar_39;
  tmpvar_39 = abs((uv_37 - (0.5 * _DetailScale)));
  uvCont_38.x = max (tmpvar_39.x, tmpvar_39.y);
  uvCont_38.y = min (tmpvar_39.x, tmpvar_39.y);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = dFdx(uvCont_38);
  tmpvar_40.zw = dFdy(uvCont_38);
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (_DetailTex, uv_21, tmpvar_40.xy, tmpvar_40.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  highp vec3 tmpvar_43;
  tmpvar_43 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_43, tmpvar_43)
  )), 0.0, 1.0);
  tmpvar_44 = tmpvar_45;
  color_2 = ((_Color * tmpvar_20) * mix (tmpvar_42, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_44)));
  highp float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_47;
  tmpvar_47 = sqrt(dot (tmpvar_43, tmpvar_43));
  highp vec3 tmpvar_48;
  tmpvar_48 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_49;
  tmpvar_49 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_50;
  tmpvar_50 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_47), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_47)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_46, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_48, tmpvar_48)) - (_RimDistSub * sqrt(
      dot (tmpvar_49, tmpvar_49)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_50;
  mediump float tmpvar_51;
  tmpvar_51 = color_2.w;
  mediump vec3 normal_52;
  normal_52 = xlv_TEXCOORD4;
  mediump vec4 c_53;
  mediump vec3 tmpvar_54;
  tmpvar_54 = normalize(normal_52);
  normal_52 = tmpvar_54;
  mediump float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, normalize(_WorldSpaceLightPos0.xyz));
  c_53.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_55 * 2.0));
  c_53.w = (tmpvar_55 * 2.0);
  mediump vec3 normal_56;
  normal_56 = xlv_TEXCOORD4;
  mediump float tmpvar_57;
  tmpvar_57 = dot (normal_56, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_53 * mix (1.0, clamp (
    floor((1.01 + tmpvar_57))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_57))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_51;
  highp vec4 v_58;
  v_58.x = _ShadowBodies[0].x;
  v_58.y = _ShadowBodies[1].x;
  v_58.z = _ShadowBodies[2].x;
  highp float tmpvar_59;
  tmpvar_59 = _ShadowBodies[3].x;
  v_58.w = tmpvar_59;
  mediump float tmpvar_60;
  highp vec3 tmpvar_61;
  tmpvar_61 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_62;
  tmpvar_62 = (3.141593 * (tmpvar_59 * tmpvar_59));
  highp vec3 tmpvar_63;
  tmpvar_63 = (v_58.xyz - xlv_TEXCOORD0);
  highp float tmpvar_64;
  tmpvar_64 = dot (tmpvar_63, normalize(tmpvar_61));
  highp float tmpvar_65;
  tmpvar_65 = (_SunRadius * (tmpvar_64 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_65 * tmpvar_65));
  highp float x_67;
  x_67 = ((2.0 * clamp (
    (((tmpvar_59 + tmpvar_65) - sqrt((
      dot (tmpvar_63, tmpvar_63)
     - 
      (tmpvar_64 * tmpvar_64)
    ))) / (2.0 * min (tmpvar_59, tmpvar_65)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_68;
  tmpvar_68 = mix (1.0, clamp ((
    (tmpvar_66 - (((0.3183099 * 
      (sign(x_67) * (1.570796 - (sqrt(
        (1.0 - abs(x_67))
      ) * (1.570796 + 
        (abs(x_67) * (-0.2146018 + (abs(x_67) * (0.08656672 + 
          (abs(x_67) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_62))
   / tmpvar_66), 0.0, 1.0), (float(
    (tmpvar_64 >= tmpvar_59)
  ) * clamp (tmpvar_62, 0.0, 1.0)));
  tmpvar_60 = tmpvar_68;
  highp vec4 v_69;
  v_69.x = _ShadowBodies[0].y;
  v_69.y = _ShadowBodies[1].y;
  v_69.z = _ShadowBodies[2].y;
  highp float tmpvar_70;
  tmpvar_70 = _ShadowBodies[3].y;
  v_69.w = tmpvar_70;
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = (3.141593 * (tmpvar_70 * tmpvar_70));
  highp vec3 tmpvar_73;
  tmpvar_73 = (v_69.xyz - xlv_TEXCOORD0);
  highp float tmpvar_74;
  tmpvar_74 = dot (tmpvar_73, normalize(tmpvar_61));
  highp float tmpvar_75;
  tmpvar_75 = (_SunRadius * (tmpvar_74 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_76;
  tmpvar_76 = (3.141593 * (tmpvar_75 * tmpvar_75));
  highp float x_77;
  x_77 = ((2.0 * clamp (
    (((tmpvar_70 + tmpvar_75) - sqrt((
      dot (tmpvar_73, tmpvar_73)
     - 
      (tmpvar_74 * tmpvar_74)
    ))) / (2.0 * min (tmpvar_70, tmpvar_75)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_78;
  tmpvar_78 = mix (1.0, clamp ((
    (tmpvar_76 - (((0.3183099 * 
      (sign(x_77) * (1.570796 - (sqrt(
        (1.0 - abs(x_77))
      ) * (1.570796 + 
        (abs(x_77) * (-0.2146018 + (abs(x_77) * (0.08656672 + 
          (abs(x_77) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_72))
   / tmpvar_76), 0.0, 1.0), (float(
    (tmpvar_74 >= tmpvar_70)
  ) * clamp (tmpvar_72, 0.0, 1.0)));
  tmpvar_71 = tmpvar_78;
  highp vec4 v_79;
  v_79.x = _ShadowBodies[0].z;
  v_79.y = _ShadowBodies[1].z;
  v_79.z = _ShadowBodies[2].z;
  highp float tmpvar_80;
  tmpvar_80 = _ShadowBodies[3].z;
  v_79.w = tmpvar_80;
  mediump float tmpvar_81;
  highp float tmpvar_82;
  tmpvar_82 = (3.141593 * (tmpvar_80 * tmpvar_80));
  highp vec3 tmpvar_83;
  tmpvar_83 = (v_79.xyz - xlv_TEXCOORD0);
  highp float tmpvar_84;
  tmpvar_84 = dot (tmpvar_83, normalize(tmpvar_61));
  highp float tmpvar_85;
  tmpvar_85 = (_SunRadius * (tmpvar_84 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_86;
  tmpvar_86 = (3.141593 * (tmpvar_85 * tmpvar_85));
  highp float x_87;
  x_87 = ((2.0 * clamp (
    (((tmpvar_80 + tmpvar_85) - sqrt((
      dot (tmpvar_83, tmpvar_83)
     - 
      (tmpvar_84 * tmpvar_84)
    ))) / (2.0 * min (tmpvar_80, tmpvar_85)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_88;
  tmpvar_88 = mix (1.0, clamp ((
    (tmpvar_86 - (((0.3183099 * 
      (sign(x_87) * (1.570796 - (sqrt(
        (1.0 - abs(x_87))
      ) * (1.570796 + 
        (abs(x_87) * (-0.2146018 + (abs(x_87) * (0.08656672 + 
          (abs(x_87) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_82))
   / tmpvar_86), 0.0, 1.0), (float(
    (tmpvar_84 >= tmpvar_80)
  ) * clamp (tmpvar_82, 0.0, 1.0)));
  tmpvar_81 = tmpvar_88;
  highp vec4 v_89;
  v_89.x = _ShadowBodies[0].w;
  v_89.y = _ShadowBodies[1].w;
  v_89.z = _ShadowBodies[2].w;
  highp float tmpvar_90;
  tmpvar_90 = _ShadowBodies[3].w;
  v_89.w = tmpvar_90;
  mediump float tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = (3.141593 * (tmpvar_90 * tmpvar_90));
  highp vec3 tmpvar_93;
  tmpvar_93 = (v_89.xyz - xlv_TEXCOORD0);
  highp float tmpvar_94;
  tmpvar_94 = dot (tmpvar_93, normalize(tmpvar_61));
  highp float tmpvar_95;
  tmpvar_95 = (_SunRadius * (tmpvar_94 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_96;
  tmpvar_96 = (3.141593 * (tmpvar_95 * tmpvar_95));
  highp float x_97;
  x_97 = ((2.0 * clamp (
    (((tmpvar_90 + tmpvar_95) - sqrt((
      dot (tmpvar_93, tmpvar_93)
     - 
      (tmpvar_94 * tmpvar_94)
    ))) / (2.0 * min (tmpvar_90, tmpvar_95)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_98;
  tmpvar_98 = mix (1.0, clamp ((
    (tmpvar_96 - (((0.3183099 * 
      (sign(x_97) * (1.570796 - (sqrt(
        (1.0 - abs(x_97))
      ) * (1.570796 + 
        (abs(x_97) * (-0.2146018 + (abs(x_97) * (0.08656672 + 
          (abs(x_97) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_92))
   / tmpvar_96), 0.0, 1.0), (float(
    (tmpvar_94 >= tmpvar_90)
  ) * clamp (tmpvar_92, 0.0, 1.0)));
  tmpvar_91 = tmpvar_98;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_60, tmpvar_71), min (tmpvar_81, tmpvar_91)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_99;
  tmpvar_99 = float((tmpvar_46 >= 0.0));
  tmpvar_3.w = (tmpvar_51 * tmpvar_99);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_0 = t10_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    t16_11.xyz = t16_11.xyz + t16_11.xyz;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 15 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  float4 tmpvar_3;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_4;
  tmpvar_4 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_5;
  float4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  float2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _mtl_u._ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_4.xyz));
  _mtl_o.xlv_TEXCOORD8 = tmpvar_3;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t1.xyz = t1.xyz + t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 377 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD6 = o_8;
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec2 uv_17;
  vec3 tmpvar_18;
  tmpvar_18 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_19;
  tmpvar_19 = abs(tmpvar_18);
  float tmpvar_20;
  tmpvar_20 = float((tmpvar_19.z >= tmpvar_19.x));
  float tmpvar_21;
  tmpvar_21 = float((max (tmpvar_19.x, tmpvar_19.z) >= tmpvar_19.y));
  float tmpvar_22;
  tmpvar_22 = sign(mix (tmpvar_18.y, mix (tmpvar_18.x, tmpvar_18.z, tmpvar_20), tmpvar_21));
  vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = -(tmpvar_22);
  vec3 tmpvar_24;
  tmpvar_24.xz = vec2(1.0, -1.0);
  tmpvar_24.y = tmpvar_22;
  vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = tmpvar_22;
  vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_18.yxz), mix ((tmpvar_23 * tmpvar_18.xzy), (tmpvar_24 * tmpvar_18.zxy), vec3(tmpvar_20)), vec3(tmpvar_21));
  uv_17 = (((
    (0.5 * tmpvar_26.yz)
   / 
    abs(tmpvar_26.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_27;
  vec2 tmpvar_28;
  tmpvar_28 = abs((uv_17 - (0.5 * _DetailScale)));
  uvCont_27.x = max (tmpvar_28.x, tmpvar_28.y);
  uvCont_27.y = min (tmpvar_28.x, tmpvar_28.y);
  vec4 tmpvar_29;
  tmpvar_29.xy = dFdx(uvCont_27);
  tmpvar_29.zw = dFdy(uvCont_27);
  vec3 tmpvar_30;
  tmpvar_30 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw)) * mix (texture2DGradARB (_DetailTex, uv_17, tmpvar_29.xy, tmpvar_29.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_30, tmpvar_30)))
  , 0.0, 1.0))));
  float tmpvar_31;
  tmpvar_31 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_32;
  tmpvar_32 = sqrt(dot (tmpvar_30, tmpvar_30));
  vec3 tmpvar_33;
  tmpvar_33 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_34;
  tmpvar_34 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_32), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_32)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_31, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_33, tmpvar_33)) - (_RimDistSub * sqrt(
      dot (tmpvar_34, tmpvar_34)
    ))))
  , 0.0, 1.0)));
  float tmpvar_35;
  tmpvar_35 = color_2.w;
  vec4 tmpvar_36;
  tmpvar_36 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_37;
  float tmpvar_38;
  tmpvar_38 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_37.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_38)) * (tmpvar_36.x * 2.0));
  c_37.w = (tmpvar_38 * (tmpvar_36.x * 2.0));
  float tmpvar_39;
  tmpvar_39 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_37 * mix (1.0, clamp (
    floor((1.01 + tmpvar_39))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_39))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_35;
  vec4 v_40;
  v_40.x = _ShadowBodies[0].x;
  v_40.y = _ShadowBodies[1].x;
  v_40.z = _ShadowBodies[2].x;
  float tmpvar_41;
  tmpvar_41 = _ShadowBodies[3].x;
  v_40.w = tmpvar_41;
  vec3 tmpvar_42;
  tmpvar_42 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_43;
  tmpvar_43 = (3.141593 * (tmpvar_41 * tmpvar_41));
  vec3 tmpvar_44;
  tmpvar_44 = (v_40.xyz - xlv_TEXCOORD0);
  float tmpvar_45;
  tmpvar_45 = dot (tmpvar_44, normalize(tmpvar_42));
  float tmpvar_46;
  tmpvar_46 = (_SunRadius * (tmpvar_45 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_47;
  tmpvar_47 = (3.141593 * (tmpvar_46 * tmpvar_46));
  float x_48;
  x_48 = ((2.0 * clamp (
    (((tmpvar_41 + tmpvar_46) - sqrt((
      dot (tmpvar_44, tmpvar_44)
     - 
      (tmpvar_45 * tmpvar_45)
    ))) / (2.0 * min (tmpvar_41, tmpvar_46)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_49;
  v_49.x = _ShadowBodies[0].y;
  v_49.y = _ShadowBodies[1].y;
  v_49.z = _ShadowBodies[2].y;
  float tmpvar_50;
  tmpvar_50 = _ShadowBodies[3].y;
  v_49.w = tmpvar_50;
  float tmpvar_51;
  tmpvar_51 = (3.141593 * (tmpvar_50 * tmpvar_50));
  vec3 tmpvar_52;
  tmpvar_52 = (v_49.xyz - xlv_TEXCOORD0);
  float tmpvar_53;
  tmpvar_53 = dot (tmpvar_52, normalize(tmpvar_42));
  float tmpvar_54;
  tmpvar_54 = (_SunRadius * (tmpvar_53 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_55;
  tmpvar_55 = (3.141593 * (tmpvar_54 * tmpvar_54));
  float x_56;
  x_56 = ((2.0 * clamp (
    (((tmpvar_50 + tmpvar_54) - sqrt((
      dot (tmpvar_52, tmpvar_52)
     - 
      (tmpvar_53 * tmpvar_53)
    ))) / (2.0 * min (tmpvar_50, tmpvar_54)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_57;
  v_57.x = _ShadowBodies[0].z;
  v_57.y = _ShadowBodies[1].z;
  v_57.z = _ShadowBodies[2].z;
  float tmpvar_58;
  tmpvar_58 = _ShadowBodies[3].z;
  v_57.w = tmpvar_58;
  float tmpvar_59;
  tmpvar_59 = (3.141593 * (tmpvar_58 * tmpvar_58));
  vec3 tmpvar_60;
  tmpvar_60 = (v_57.xyz - xlv_TEXCOORD0);
  float tmpvar_61;
  tmpvar_61 = dot (tmpvar_60, normalize(tmpvar_42));
  float tmpvar_62;
  tmpvar_62 = (_SunRadius * (tmpvar_61 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_63;
  tmpvar_63 = (3.141593 * (tmpvar_62 * tmpvar_62));
  float x_64;
  x_64 = ((2.0 * clamp (
    (((tmpvar_58 + tmpvar_62) - sqrt((
      dot (tmpvar_60, tmpvar_60)
     - 
      (tmpvar_61 * tmpvar_61)
    ))) / (2.0 * min (tmpvar_58, tmpvar_62)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_65;
  v_65.x = _ShadowBodies[0].w;
  v_65.y = _ShadowBodies[1].w;
  v_65.z = _ShadowBodies[2].w;
  float tmpvar_66;
  tmpvar_66 = _ShadowBodies[3].w;
  v_65.w = tmpvar_66;
  float tmpvar_67;
  tmpvar_67 = (3.141593 * (tmpvar_66 * tmpvar_66));
  vec3 tmpvar_68;
  tmpvar_68 = (v_65.xyz - xlv_TEXCOORD0);
  float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, normalize(tmpvar_42));
  float tmpvar_70;
  tmpvar_70 = (_SunRadius * (tmpvar_69 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_71;
  tmpvar_71 = (3.141593 * (tmpvar_70 * tmpvar_70));
  float x_72;
  x_72 = ((2.0 * clamp (
    (((tmpvar_66 + tmpvar_70) - sqrt((
      dot (tmpvar_68, tmpvar_68)
     - 
      (tmpvar_69 * tmpvar_69)
    ))) / (2.0 * min (tmpvar_66, tmpvar_70)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_47 - 
      (((0.3183099 * (
        sign(x_48)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_48)
        )) * (1.570796 + (
          abs(x_48)
         * 
          (-0.2146018 + (abs(x_48) * (0.08656672 + (
            abs(x_48)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_43)
    ) / tmpvar_47), 0.0, 1.0), (float((tmpvar_45 >= tmpvar_41)) * clamp (tmpvar_43, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_55 - 
      (((0.3183099 * (
        sign(x_56)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_56)
        )) * (1.570796 + (
          abs(x_56)
         * 
          (-0.2146018 + (abs(x_56) * (0.08656672 + (
            abs(x_56)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_51)
    ) / tmpvar_55), 0.0, 1.0), (float((tmpvar_53 >= tmpvar_50)) * clamp (tmpvar_51, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_63 - 
      (((0.3183099 * (
        sign(x_64)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_64)
        )) * (1.570796 + (
          abs(x_64)
         * 
          (-0.2146018 + (abs(x_64) * (0.08656672 + (
            abs(x_64)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_59)
    ) / tmpvar_63), 0.0, 1.0), (float((tmpvar_61 >= tmpvar_58)) * clamp (tmpvar_59, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_71 - 
      (((0.3183099 * (
        sign(x_72)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_72)
        )) * (1.570796 + (
          abs(x_72)
         * 
          (-0.2146018 + (abs(x_72) * (0.08656672 + (
            abs(x_72)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_67)
    ) / tmpvar_71), 0.0, 1.0), (float((tmpvar_69 >= tmpvar_66)) * clamp (tmpvar_67, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_35 * float((tmpvar_31 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord6 o7
dcl_texcoord8 o8
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.x, c14, v0
mov o8.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21
dp4 r0.x, c0, v0
dp4 r0.y, c1, v0
dp4 r0.z, c2, v0
dp4 r0.w, c3, v0
mov o0, r0
mul r1.xz, r0.xyww, c22.x
mul r1.y, r0.y, c19.x
mul r1.w, r1.y, c22.x
mad r0.xy, r1.z, c20.zwzw, r1.xwzw
mov o7, r0
mov o8.xyw, r0

"
}
SubProgram "d3d11 " {
// Stats: 34 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 381 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec2 uv_21;
  mediump vec3 detailCoords_22;
  mediump float s_23;
  mediump float nylerp_24;
  mediump float zxlerp_25;
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_27;
  tmpvar_27 = abs(tmpvar_26);
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_27.z >= tmpvar_27.x));
  zxlerp_25 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = float((max (tmpvar_27.x, tmpvar_27.z) >= tmpvar_27.y));
  nylerp_24 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = mix (tmpvar_26.x, tmpvar_26.z, zxlerp_25);
  s_23 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_26.y, s_23, nylerp_24));
  s_23 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(s_23);
  mediump vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = s_23;
  highp vec3 tmpvar_34;
  tmpvar_34 = mix ((tmpvar_32 * tmpvar_26.xzy), (tmpvar_33 * tmpvar_26.zxy), vec3(zxlerp_25));
  detailCoords_22 = tmpvar_34;
  mediump vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = s_23;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_26.yxz), detailCoords_22, vec3(nylerp_24));
  detailCoords_22 = tmpvar_36;
  uv_21 = (((
    (0.5 * detailCoords_22.yz)
   / 
    abs(detailCoords_22.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_37;
  uv_37 = uv_21;
  highp vec2 uvCont_38;
  highp vec2 tmpvar_39;
  tmpvar_39 = abs((uv_37 - (0.5 * _DetailScale)));
  uvCont_38.x = max (tmpvar_39.x, tmpvar_39.y);
  uvCont_38.y = min (tmpvar_39.x, tmpvar_39.y);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = dFdx(uvCont_38);
  tmpvar_40.zw = dFdy(uvCont_38);
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (_DetailTex, uv_21, tmpvar_40.xy, tmpvar_40.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  highp vec3 tmpvar_43;
  tmpvar_43 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_43, tmpvar_43)
  )), 0.0, 1.0);
  tmpvar_44 = tmpvar_45;
  color_2 = ((_Color * tmpvar_20) * mix (tmpvar_42, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_44)));
  highp float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_47;
  tmpvar_47 = sqrt(dot (tmpvar_43, tmpvar_43));
  highp vec3 tmpvar_48;
  tmpvar_48 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_49;
  tmpvar_49 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_50;
  tmpvar_50 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_47), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_47)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_46, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_48, tmpvar_48)) - (_RimDistSub * sqrt(
      dot (tmpvar_49, tmpvar_49)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_50;
  mediump float tmpvar_51;
  tmpvar_51 = color_2.w;
  lowp float tmpvar_52;
  highp float tmpvar_53;
  tmpvar_53 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_52 = tmpvar_53;
  mediump vec3 normal_54;
  normal_54 = xlv_TEXCOORD4;
  mediump float atten_55;
  atten_55 = tmpvar_52;
  mediump vec4 c_56;
  mediump vec3 tmpvar_57;
  tmpvar_57 = normalize(normal_54);
  normal_54 = tmpvar_57;
  mediump float tmpvar_58;
  tmpvar_58 = dot (tmpvar_57, normalize(_WorldSpaceLightPos0.xyz));
  c_56.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_58)) * (atten_55 * 2.0));
  c_56.w = (tmpvar_58 * (atten_55 * 2.0));
  mediump vec3 normal_59;
  normal_59 = xlv_TEXCOORD4;
  mediump float tmpvar_60;
  tmpvar_60 = dot (normal_59, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_56 * mix (1.0, clamp (
    floor((1.01 + tmpvar_60))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_60))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_51;
  highp vec4 v_61;
  v_61.x = _ShadowBodies[0].x;
  v_61.y = _ShadowBodies[1].x;
  v_61.z = _ShadowBodies[2].x;
  highp float tmpvar_62;
  tmpvar_62 = _ShadowBodies[3].x;
  v_61.w = tmpvar_62;
  mediump float tmpvar_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_65;
  tmpvar_65 = (3.141593 * (tmpvar_62 * tmpvar_62));
  highp vec3 tmpvar_66;
  tmpvar_66 = (v_61.xyz - xlv_TEXCOORD0);
  highp float tmpvar_67;
  tmpvar_67 = dot (tmpvar_66, normalize(tmpvar_64));
  highp float tmpvar_68;
  tmpvar_68 = (_SunRadius * (tmpvar_67 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_69;
  tmpvar_69 = (3.141593 * (tmpvar_68 * tmpvar_68));
  highp float x_70;
  x_70 = ((2.0 * clamp (
    (((tmpvar_62 + tmpvar_68) - sqrt((
      dot (tmpvar_66, tmpvar_66)
     - 
      (tmpvar_67 * tmpvar_67)
    ))) / (2.0 * min (tmpvar_62, tmpvar_68)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_71;
  tmpvar_71 = mix (1.0, clamp ((
    (tmpvar_69 - (((0.3183099 * 
      (sign(x_70) * (1.570796 - (sqrt(
        (1.0 - abs(x_70))
      ) * (1.570796 + 
        (abs(x_70) * (-0.2146018 + (abs(x_70) * (0.08656672 + 
          (abs(x_70) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_65))
   / tmpvar_69), 0.0, 1.0), (float(
    (tmpvar_67 >= tmpvar_62)
  ) * clamp (tmpvar_65, 0.0, 1.0)));
  tmpvar_63 = tmpvar_71;
  highp vec4 v_72;
  v_72.x = _ShadowBodies[0].y;
  v_72.y = _ShadowBodies[1].y;
  v_72.z = _ShadowBodies[2].y;
  highp float tmpvar_73;
  tmpvar_73 = _ShadowBodies[3].y;
  v_72.w = tmpvar_73;
  mediump float tmpvar_74;
  highp float tmpvar_75;
  tmpvar_75 = (3.141593 * (tmpvar_73 * tmpvar_73));
  highp vec3 tmpvar_76;
  tmpvar_76 = (v_72.xyz - xlv_TEXCOORD0);
  highp float tmpvar_77;
  tmpvar_77 = dot (tmpvar_76, normalize(tmpvar_64));
  highp float tmpvar_78;
  tmpvar_78 = (_SunRadius * (tmpvar_77 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_79;
  tmpvar_79 = (3.141593 * (tmpvar_78 * tmpvar_78));
  highp float x_80;
  x_80 = ((2.0 * clamp (
    (((tmpvar_73 + tmpvar_78) - sqrt((
      dot (tmpvar_76, tmpvar_76)
     - 
      (tmpvar_77 * tmpvar_77)
    ))) / (2.0 * min (tmpvar_73, tmpvar_78)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_81;
  tmpvar_81 = mix (1.0, clamp ((
    (tmpvar_79 - (((0.3183099 * 
      (sign(x_80) * (1.570796 - (sqrt(
        (1.0 - abs(x_80))
      ) * (1.570796 + 
        (abs(x_80) * (-0.2146018 + (abs(x_80) * (0.08656672 + 
          (abs(x_80) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_75))
   / tmpvar_79), 0.0, 1.0), (float(
    (tmpvar_77 >= tmpvar_73)
  ) * clamp (tmpvar_75, 0.0, 1.0)));
  tmpvar_74 = tmpvar_81;
  highp vec4 v_82;
  v_82.x = _ShadowBodies[0].z;
  v_82.y = _ShadowBodies[1].z;
  v_82.z = _ShadowBodies[2].z;
  highp float tmpvar_83;
  tmpvar_83 = _ShadowBodies[3].z;
  v_82.w = tmpvar_83;
  mediump float tmpvar_84;
  highp float tmpvar_85;
  tmpvar_85 = (3.141593 * (tmpvar_83 * tmpvar_83));
  highp vec3 tmpvar_86;
  tmpvar_86 = (v_82.xyz - xlv_TEXCOORD0);
  highp float tmpvar_87;
  tmpvar_87 = dot (tmpvar_86, normalize(tmpvar_64));
  highp float tmpvar_88;
  tmpvar_88 = (_SunRadius * (tmpvar_87 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_89;
  tmpvar_89 = (3.141593 * (tmpvar_88 * tmpvar_88));
  highp float x_90;
  x_90 = ((2.0 * clamp (
    (((tmpvar_83 + tmpvar_88) - sqrt((
      dot (tmpvar_86, tmpvar_86)
     - 
      (tmpvar_87 * tmpvar_87)
    ))) / (2.0 * min (tmpvar_83, tmpvar_88)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_91;
  tmpvar_91 = mix (1.0, clamp ((
    (tmpvar_89 - (((0.3183099 * 
      (sign(x_90) * (1.570796 - (sqrt(
        (1.0 - abs(x_90))
      ) * (1.570796 + 
        (abs(x_90) * (-0.2146018 + (abs(x_90) * (0.08656672 + 
          (abs(x_90) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_85))
   / tmpvar_89), 0.0, 1.0), (float(
    (tmpvar_87 >= tmpvar_83)
  ) * clamp (tmpvar_85, 0.0, 1.0)));
  tmpvar_84 = tmpvar_91;
  highp vec4 v_92;
  v_92.x = _ShadowBodies[0].w;
  v_92.y = _ShadowBodies[1].w;
  v_92.z = _ShadowBodies[2].w;
  highp float tmpvar_93;
  tmpvar_93 = _ShadowBodies[3].w;
  v_92.w = tmpvar_93;
  mediump float tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = (3.141593 * (tmpvar_93 * tmpvar_93));
  highp vec3 tmpvar_96;
  tmpvar_96 = (v_92.xyz - xlv_TEXCOORD0);
  highp float tmpvar_97;
  tmpvar_97 = dot (tmpvar_96, normalize(tmpvar_64));
  highp float tmpvar_98;
  tmpvar_98 = (_SunRadius * (tmpvar_97 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_99;
  tmpvar_99 = (3.141593 * (tmpvar_98 * tmpvar_98));
  highp float x_100;
  x_100 = ((2.0 * clamp (
    (((tmpvar_93 + tmpvar_98) - sqrt((
      dot (tmpvar_96, tmpvar_96)
     - 
      (tmpvar_97 * tmpvar_97)
    ))) / (2.0 * min (tmpvar_93, tmpvar_98)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_101;
  tmpvar_101 = mix (1.0, clamp ((
    (tmpvar_99 - (((0.3183099 * 
      (sign(x_100) * (1.570796 - (sqrt(
        (1.0 - abs(x_100))
      ) * (1.570796 + 
        (abs(x_100) * (-0.2146018 + (abs(x_100) * (0.08656672 + 
          (abs(x_100) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_95))
   / tmpvar_99), 0.0, 1.0), (float(
    (tmpvar_97 >= tmpvar_93)
  ) * clamp (tmpvar_95, 0.0, 1.0)));
  tmpvar_94 = tmpvar_101;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_63, tmpvar_74), min (tmpvar_84, tmpvar_94)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_102;
  tmpvar_102 = float((tmpvar_46 >= 0.0));
  tmpvar_3.w = (tmpvar_51 * tmpvar_102);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD4.xyz = vec3(t13) * t2.xyz;
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t1.x = t0.y * _ProjectionParams.x;
    t1.w = t1.x * 0.5;
    t1.xz = t0.xw * vec2(0.5, 0.5);
    t0.xy = t1.zz + t1.xw;
    vs_TEXCOORD6 = t0;
    vs_TEXCOORD8.xyw = t0.xyw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
mediump float t16_12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t12.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t12.xy);
    t16_12 = t10_2.x + t10_2.x;
    t1.xyz = vec3(t16_12) * t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 375 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec2 uv_17;
  vec3 tmpvar_18;
  tmpvar_18 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_19;
  tmpvar_19 = abs(tmpvar_18);
  float tmpvar_20;
  tmpvar_20 = float((tmpvar_19.z >= tmpvar_19.x));
  float tmpvar_21;
  tmpvar_21 = float((max (tmpvar_19.x, tmpvar_19.z) >= tmpvar_19.y));
  float tmpvar_22;
  tmpvar_22 = sign(mix (tmpvar_18.y, mix (tmpvar_18.x, tmpvar_18.z, tmpvar_20), tmpvar_21));
  vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = -(tmpvar_22);
  vec3 tmpvar_24;
  tmpvar_24.xz = vec2(1.0, -1.0);
  tmpvar_24.y = tmpvar_22;
  vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = tmpvar_22;
  vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_18.yxz), mix ((tmpvar_23 * tmpvar_18.xzy), (tmpvar_24 * tmpvar_18.zxy), vec3(tmpvar_20)), vec3(tmpvar_21));
  uv_17 = (((
    (0.5 * tmpvar_26.yz)
   / 
    abs(tmpvar_26.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_27;
  vec2 tmpvar_28;
  tmpvar_28 = abs((uv_17 - (0.5 * _DetailScale)));
  uvCont_27.x = max (tmpvar_28.x, tmpvar_28.y);
  uvCont_27.y = min (tmpvar_28.x, tmpvar_28.y);
  vec4 tmpvar_29;
  tmpvar_29.xy = dFdx(uvCont_27);
  tmpvar_29.zw = dFdy(uvCont_27);
  vec3 tmpvar_30;
  tmpvar_30 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw)) * mix (texture2DGradARB (_DetailTex, uv_17, tmpvar_29.xy, tmpvar_29.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_30, tmpvar_30)))
  , 0.0, 1.0))));
  float tmpvar_31;
  tmpvar_31 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_32;
  tmpvar_32 = sqrt(dot (tmpvar_30, tmpvar_30));
  vec3 tmpvar_33;
  tmpvar_33 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_34;
  tmpvar_34 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_32), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_32)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_31, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_33, tmpvar_33)) - (_RimDistSub * sqrt(
      dot (tmpvar_34, tmpvar_34)
    ))))
  , 0.0, 1.0)));
  float tmpvar_35;
  tmpvar_35 = color_2.w;
  vec4 c_36;
  float tmpvar_37;
  tmpvar_37 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_36.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_37 * 2.0));
  c_36.w = (tmpvar_37 * 2.0);
  float tmpvar_38;
  tmpvar_38 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_36 * mix (1.0, clamp (
    floor((1.01 + tmpvar_38))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_38))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_35;
  vec4 v_39;
  v_39.x = _ShadowBodies[0].x;
  v_39.y = _ShadowBodies[1].x;
  v_39.z = _ShadowBodies[2].x;
  float tmpvar_40;
  tmpvar_40 = _ShadowBodies[3].x;
  v_39.w = tmpvar_40;
  vec3 tmpvar_41;
  tmpvar_41 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_42;
  tmpvar_42 = (3.141593 * (tmpvar_40 * tmpvar_40));
  vec3 tmpvar_43;
  tmpvar_43 = (v_39.xyz - xlv_TEXCOORD0);
  float tmpvar_44;
  tmpvar_44 = dot (tmpvar_43, normalize(tmpvar_41));
  float tmpvar_45;
  tmpvar_45 = (_SunRadius * (tmpvar_44 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_46;
  tmpvar_46 = (3.141593 * (tmpvar_45 * tmpvar_45));
  float x_47;
  x_47 = ((2.0 * clamp (
    (((tmpvar_40 + tmpvar_45) - sqrt((
      dot (tmpvar_43, tmpvar_43)
     - 
      (tmpvar_44 * tmpvar_44)
    ))) / (2.0 * min (tmpvar_40, tmpvar_45)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_48;
  v_48.x = _ShadowBodies[0].y;
  v_48.y = _ShadowBodies[1].y;
  v_48.z = _ShadowBodies[2].y;
  float tmpvar_49;
  tmpvar_49 = _ShadowBodies[3].y;
  v_48.w = tmpvar_49;
  float tmpvar_50;
  tmpvar_50 = (3.141593 * (tmpvar_49 * tmpvar_49));
  vec3 tmpvar_51;
  tmpvar_51 = (v_48.xyz - xlv_TEXCOORD0);
  float tmpvar_52;
  tmpvar_52 = dot (tmpvar_51, normalize(tmpvar_41));
  float tmpvar_53;
  tmpvar_53 = (_SunRadius * (tmpvar_52 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_54;
  tmpvar_54 = (3.141593 * (tmpvar_53 * tmpvar_53));
  float x_55;
  x_55 = ((2.0 * clamp (
    (((tmpvar_49 + tmpvar_53) - sqrt((
      dot (tmpvar_51, tmpvar_51)
     - 
      (tmpvar_52 * tmpvar_52)
    ))) / (2.0 * min (tmpvar_49, tmpvar_53)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_56;
  v_56.x = _ShadowBodies[0].z;
  v_56.y = _ShadowBodies[1].z;
  v_56.z = _ShadowBodies[2].z;
  float tmpvar_57;
  tmpvar_57 = _ShadowBodies[3].z;
  v_56.w = tmpvar_57;
  float tmpvar_58;
  tmpvar_58 = (3.141593 * (tmpvar_57 * tmpvar_57));
  vec3 tmpvar_59;
  tmpvar_59 = (v_56.xyz - xlv_TEXCOORD0);
  float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, normalize(tmpvar_41));
  float tmpvar_61;
  tmpvar_61 = (_SunRadius * (tmpvar_60 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_62;
  tmpvar_62 = (3.141593 * (tmpvar_61 * tmpvar_61));
  float x_63;
  x_63 = ((2.0 * clamp (
    (((tmpvar_57 + tmpvar_61) - sqrt((
      dot (tmpvar_59, tmpvar_59)
     - 
      (tmpvar_60 * tmpvar_60)
    ))) / (2.0 * min (tmpvar_57, tmpvar_61)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_64;
  v_64.x = _ShadowBodies[0].w;
  v_64.y = _ShadowBodies[1].w;
  v_64.z = _ShadowBodies[2].w;
  float tmpvar_65;
  tmpvar_65 = _ShadowBodies[3].w;
  v_64.w = tmpvar_65;
  float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_65 * tmpvar_65));
  vec3 tmpvar_67;
  tmpvar_67 = (v_64.xyz - xlv_TEXCOORD0);
  float tmpvar_68;
  tmpvar_68 = dot (tmpvar_67, normalize(tmpvar_41));
  float tmpvar_69;
  tmpvar_69 = (_SunRadius * (tmpvar_68 / sqrt(
    dot (tmpvar_41, tmpvar_41)
  )));
  float tmpvar_70;
  tmpvar_70 = (3.141593 * (tmpvar_69 * tmpvar_69));
  float x_71;
  x_71 = ((2.0 * clamp (
    (((tmpvar_65 + tmpvar_69) - sqrt((
      dot (tmpvar_67, tmpvar_67)
     - 
      (tmpvar_68 * tmpvar_68)
    ))) / (2.0 * min (tmpvar_65, tmpvar_69)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_46 - 
      (((0.3183099 * (
        sign(x_47)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_47)
        )) * (1.570796 + (
          abs(x_47)
         * 
          (-0.2146018 + (abs(x_47) * (0.08656672 + (
            abs(x_47)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_42)
    ) / tmpvar_46), 0.0, 1.0), (float((tmpvar_44 >= tmpvar_40)) * clamp (tmpvar_42, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_54 - 
      (((0.3183099 * (
        sign(x_55)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_55)
        )) * (1.570796 + (
          abs(x_55)
         * 
          (-0.2146018 + (abs(x_55) * (0.08656672 + (
            abs(x_55)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_50)
    ) / tmpvar_54), 0.0, 1.0), (float((tmpvar_52 >= tmpvar_49)) * clamp (tmpvar_50, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_62 - 
      (((0.3183099 * (
        sign(x_63)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_63)
        )) * (1.570796 + (
          abs(x_63)
         * 
          (-0.2146018 + (abs(x_63) * (0.08656672 + (
            abs(x_63)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_58)
    ) / tmpvar_62), 0.0, 1.0), (float((tmpvar_60 >= tmpvar_57)) * clamp (tmpvar_58, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_70 - 
      (((0.3183099 * (
        sign(x_71)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_71)
        )) * (1.570796 + (
          abs(x_71)
         * 
          (-0.2146018 + (abs(x_71) * (0.08656672 + (
            abs(x_71)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_66)
    ) / tmpvar_70), 0.0, 1.0), (float((tmpvar_68 >= tmpvar_65)) * clamp (tmpvar_66, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_35 * float((tmpvar_31 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 37 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord8 o7
dp4 o0.z, c2, v0
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r0.z, r0.y, c19.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xzw, r0.xywz, c22.x
mov o0.xyw, r0
mov o7.w, r0.w
mad o7.xy, r1.z, c20.zwzw, r1.xwzw
dp4 r0.x, c14, v0
mov o7.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21

"
}
SubProgram "d3d11 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 375 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec2 uv_21;
  mediump vec3 detailCoords_22;
  mediump float s_23;
  mediump float nylerp_24;
  mediump float zxlerp_25;
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_27;
  tmpvar_27 = abs(tmpvar_26);
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_27.z >= tmpvar_27.x));
  zxlerp_25 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = float((max (tmpvar_27.x, tmpvar_27.z) >= tmpvar_27.y));
  nylerp_24 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = mix (tmpvar_26.x, tmpvar_26.z, zxlerp_25);
  s_23 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_26.y, s_23, nylerp_24));
  s_23 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(s_23);
  mediump vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = s_23;
  highp vec3 tmpvar_34;
  tmpvar_34 = mix ((tmpvar_32 * tmpvar_26.xzy), (tmpvar_33 * tmpvar_26.zxy), vec3(zxlerp_25));
  detailCoords_22 = tmpvar_34;
  mediump vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = s_23;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_26.yxz), detailCoords_22, vec3(nylerp_24));
  detailCoords_22 = tmpvar_36;
  uv_21 = (((
    (0.5 * detailCoords_22.yz)
   / 
    abs(detailCoords_22.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_37;
  uv_37 = uv_21;
  highp vec2 uvCont_38;
  highp vec2 tmpvar_39;
  tmpvar_39 = abs((uv_37 - (0.5 * _DetailScale)));
  uvCont_38.x = max (tmpvar_39.x, tmpvar_39.y);
  uvCont_38.y = min (tmpvar_39.x, tmpvar_39.y);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = dFdx(uvCont_38);
  tmpvar_40.zw = dFdy(uvCont_38);
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (_DetailTex, uv_21, tmpvar_40.xy, tmpvar_40.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  highp vec3 tmpvar_43;
  tmpvar_43 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_43, tmpvar_43)
  )), 0.0, 1.0);
  tmpvar_44 = tmpvar_45;
  color_2 = ((_Color * tmpvar_20) * mix (tmpvar_42, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_44)));
  highp float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_47;
  tmpvar_47 = sqrt(dot (tmpvar_43, tmpvar_43));
  highp vec3 tmpvar_48;
  tmpvar_48 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_49;
  tmpvar_49 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_50;
  tmpvar_50 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_47), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_47)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_46, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_48, tmpvar_48)) - (_RimDistSub * sqrt(
      dot (tmpvar_49, tmpvar_49)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_50;
  mediump float tmpvar_51;
  tmpvar_51 = color_2.w;
  mediump vec3 normal_52;
  normal_52 = xlv_TEXCOORD4;
  mediump vec4 c_53;
  mediump vec3 tmpvar_54;
  tmpvar_54 = normalize(normal_52);
  normal_52 = tmpvar_54;
  mediump float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, normalize(_WorldSpaceLightPos0.xyz));
  c_53.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_55 * 2.0));
  c_53.w = (tmpvar_55 * 2.0);
  mediump vec3 normal_56;
  normal_56 = xlv_TEXCOORD4;
  mediump float tmpvar_57;
  tmpvar_57 = dot (normal_56, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_53 * mix (1.0, clamp (
    floor((1.01 + tmpvar_57))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_57))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_51;
  highp vec4 v_58;
  v_58.x = _ShadowBodies[0].x;
  v_58.y = _ShadowBodies[1].x;
  v_58.z = _ShadowBodies[2].x;
  highp float tmpvar_59;
  tmpvar_59 = _ShadowBodies[3].x;
  v_58.w = tmpvar_59;
  mediump float tmpvar_60;
  highp vec3 tmpvar_61;
  tmpvar_61 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_62;
  tmpvar_62 = (3.141593 * (tmpvar_59 * tmpvar_59));
  highp vec3 tmpvar_63;
  tmpvar_63 = (v_58.xyz - xlv_TEXCOORD0);
  highp float tmpvar_64;
  tmpvar_64 = dot (tmpvar_63, normalize(tmpvar_61));
  highp float tmpvar_65;
  tmpvar_65 = (_SunRadius * (tmpvar_64 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_65 * tmpvar_65));
  highp float x_67;
  x_67 = ((2.0 * clamp (
    (((tmpvar_59 + tmpvar_65) - sqrt((
      dot (tmpvar_63, tmpvar_63)
     - 
      (tmpvar_64 * tmpvar_64)
    ))) / (2.0 * min (tmpvar_59, tmpvar_65)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_68;
  tmpvar_68 = mix (1.0, clamp ((
    (tmpvar_66 - (((0.3183099 * 
      (sign(x_67) * (1.570796 - (sqrt(
        (1.0 - abs(x_67))
      ) * (1.570796 + 
        (abs(x_67) * (-0.2146018 + (abs(x_67) * (0.08656672 + 
          (abs(x_67) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_62))
   / tmpvar_66), 0.0, 1.0), (float(
    (tmpvar_64 >= tmpvar_59)
  ) * clamp (tmpvar_62, 0.0, 1.0)));
  tmpvar_60 = tmpvar_68;
  highp vec4 v_69;
  v_69.x = _ShadowBodies[0].y;
  v_69.y = _ShadowBodies[1].y;
  v_69.z = _ShadowBodies[2].y;
  highp float tmpvar_70;
  tmpvar_70 = _ShadowBodies[3].y;
  v_69.w = tmpvar_70;
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = (3.141593 * (tmpvar_70 * tmpvar_70));
  highp vec3 tmpvar_73;
  tmpvar_73 = (v_69.xyz - xlv_TEXCOORD0);
  highp float tmpvar_74;
  tmpvar_74 = dot (tmpvar_73, normalize(tmpvar_61));
  highp float tmpvar_75;
  tmpvar_75 = (_SunRadius * (tmpvar_74 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_76;
  tmpvar_76 = (3.141593 * (tmpvar_75 * tmpvar_75));
  highp float x_77;
  x_77 = ((2.0 * clamp (
    (((tmpvar_70 + tmpvar_75) - sqrt((
      dot (tmpvar_73, tmpvar_73)
     - 
      (tmpvar_74 * tmpvar_74)
    ))) / (2.0 * min (tmpvar_70, tmpvar_75)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_78;
  tmpvar_78 = mix (1.0, clamp ((
    (tmpvar_76 - (((0.3183099 * 
      (sign(x_77) * (1.570796 - (sqrt(
        (1.0 - abs(x_77))
      ) * (1.570796 + 
        (abs(x_77) * (-0.2146018 + (abs(x_77) * (0.08656672 + 
          (abs(x_77) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_72))
   / tmpvar_76), 0.0, 1.0), (float(
    (tmpvar_74 >= tmpvar_70)
  ) * clamp (tmpvar_72, 0.0, 1.0)));
  tmpvar_71 = tmpvar_78;
  highp vec4 v_79;
  v_79.x = _ShadowBodies[0].z;
  v_79.y = _ShadowBodies[1].z;
  v_79.z = _ShadowBodies[2].z;
  highp float tmpvar_80;
  tmpvar_80 = _ShadowBodies[3].z;
  v_79.w = tmpvar_80;
  mediump float tmpvar_81;
  highp float tmpvar_82;
  tmpvar_82 = (3.141593 * (tmpvar_80 * tmpvar_80));
  highp vec3 tmpvar_83;
  tmpvar_83 = (v_79.xyz - xlv_TEXCOORD0);
  highp float tmpvar_84;
  tmpvar_84 = dot (tmpvar_83, normalize(tmpvar_61));
  highp float tmpvar_85;
  tmpvar_85 = (_SunRadius * (tmpvar_84 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_86;
  tmpvar_86 = (3.141593 * (tmpvar_85 * tmpvar_85));
  highp float x_87;
  x_87 = ((2.0 * clamp (
    (((tmpvar_80 + tmpvar_85) - sqrt((
      dot (tmpvar_83, tmpvar_83)
     - 
      (tmpvar_84 * tmpvar_84)
    ))) / (2.0 * min (tmpvar_80, tmpvar_85)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_88;
  tmpvar_88 = mix (1.0, clamp ((
    (tmpvar_86 - (((0.3183099 * 
      (sign(x_87) * (1.570796 - (sqrt(
        (1.0 - abs(x_87))
      ) * (1.570796 + 
        (abs(x_87) * (-0.2146018 + (abs(x_87) * (0.08656672 + 
          (abs(x_87) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_82))
   / tmpvar_86), 0.0, 1.0), (float(
    (tmpvar_84 >= tmpvar_80)
  ) * clamp (tmpvar_82, 0.0, 1.0)));
  tmpvar_81 = tmpvar_88;
  highp vec4 v_89;
  v_89.x = _ShadowBodies[0].w;
  v_89.y = _ShadowBodies[1].w;
  v_89.z = _ShadowBodies[2].w;
  highp float tmpvar_90;
  tmpvar_90 = _ShadowBodies[3].w;
  v_89.w = tmpvar_90;
  mediump float tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = (3.141593 * (tmpvar_90 * tmpvar_90));
  highp vec3 tmpvar_93;
  tmpvar_93 = (v_89.xyz - xlv_TEXCOORD0);
  highp float tmpvar_94;
  tmpvar_94 = dot (tmpvar_93, normalize(tmpvar_61));
  highp float tmpvar_95;
  tmpvar_95 = (_SunRadius * (tmpvar_94 / sqrt(
    dot (tmpvar_61, tmpvar_61)
  )));
  highp float tmpvar_96;
  tmpvar_96 = (3.141593 * (tmpvar_95 * tmpvar_95));
  highp float x_97;
  x_97 = ((2.0 * clamp (
    (((tmpvar_90 + tmpvar_95) - sqrt((
      dot (tmpvar_93, tmpvar_93)
     - 
      (tmpvar_94 * tmpvar_94)
    ))) / (2.0 * min (tmpvar_90, tmpvar_95)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_98;
  tmpvar_98 = mix (1.0, clamp ((
    (tmpvar_96 - (((0.3183099 * 
      (sign(x_97) * (1.570796 - (sqrt(
        (1.0 - abs(x_97))
      ) * (1.570796 + 
        (abs(x_97) * (-0.2146018 + (abs(x_97) * (0.08656672 + 
          (abs(x_97) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_92))
   / tmpvar_96), 0.0, 1.0), (float(
    (tmpvar_94 >= tmpvar_90)
  ) * clamp (tmpvar_92, 0.0, 1.0)));
  tmpvar_91 = tmpvar_98;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_60, tmpvar_71), min (tmpvar_81, tmpvar_91)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_99;
  tmpvar_99 = float((tmpvar_46 >= 0.0));
  tmpvar_3.w = (tmpvar_51 * tmpvar_99);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_0 = t10_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    t16_11.xyz = t16_11.xyz + t16_11.xyz;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 15 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  float4 tmpvar_3;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_4;
  tmpvar_4 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_5;
  float4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  float2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _mtl_u._ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_4.xyz));
  _mtl_o.xlv_TEXCOORD8 = tmpvar_3;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t1.xyz = t1.xyz + t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 377 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD6 = o_8;
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec2 uv_17;
  vec3 tmpvar_18;
  tmpvar_18 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_19;
  tmpvar_19 = abs(tmpvar_18);
  float tmpvar_20;
  tmpvar_20 = float((tmpvar_19.z >= tmpvar_19.x));
  float tmpvar_21;
  tmpvar_21 = float((max (tmpvar_19.x, tmpvar_19.z) >= tmpvar_19.y));
  float tmpvar_22;
  tmpvar_22 = sign(mix (tmpvar_18.y, mix (tmpvar_18.x, tmpvar_18.z, tmpvar_20), tmpvar_21));
  vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = -(tmpvar_22);
  vec3 tmpvar_24;
  tmpvar_24.xz = vec2(1.0, -1.0);
  tmpvar_24.y = tmpvar_22;
  vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = tmpvar_22;
  vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_18.yxz), mix ((tmpvar_23 * tmpvar_18.xzy), (tmpvar_24 * tmpvar_18.zxy), vec3(tmpvar_20)), vec3(tmpvar_21));
  uv_17 = (((
    (0.5 * tmpvar_26.yz)
   / 
    abs(tmpvar_26.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_27;
  vec2 tmpvar_28;
  tmpvar_28 = abs((uv_17 - (0.5 * _DetailScale)));
  uvCont_27.x = max (tmpvar_28.x, tmpvar_28.y);
  uvCont_27.y = min (tmpvar_28.x, tmpvar_28.y);
  vec4 tmpvar_29;
  tmpvar_29.xy = dFdx(uvCont_27);
  tmpvar_29.zw = dFdy(uvCont_27);
  vec3 tmpvar_30;
  tmpvar_30 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw)) * mix (texture2DGradARB (_DetailTex, uv_17, tmpvar_29.xy, tmpvar_29.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_30, tmpvar_30)))
  , 0.0, 1.0))));
  float tmpvar_31;
  tmpvar_31 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_32;
  tmpvar_32 = sqrt(dot (tmpvar_30, tmpvar_30));
  vec3 tmpvar_33;
  tmpvar_33 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_34;
  tmpvar_34 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_32), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_32)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_31, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_33, tmpvar_33)) - (_RimDistSub * sqrt(
      dot (tmpvar_34, tmpvar_34)
    ))))
  , 0.0, 1.0)));
  float tmpvar_35;
  tmpvar_35 = color_2.w;
  vec4 tmpvar_36;
  tmpvar_36 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_37;
  float tmpvar_38;
  tmpvar_38 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_37.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_38)) * (tmpvar_36.x * 2.0));
  c_37.w = (tmpvar_38 * (tmpvar_36.x * 2.0));
  float tmpvar_39;
  tmpvar_39 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_37 * mix (1.0, clamp (
    floor((1.01 + tmpvar_39))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_39))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_35;
  vec4 v_40;
  v_40.x = _ShadowBodies[0].x;
  v_40.y = _ShadowBodies[1].x;
  v_40.z = _ShadowBodies[2].x;
  float tmpvar_41;
  tmpvar_41 = _ShadowBodies[3].x;
  v_40.w = tmpvar_41;
  vec3 tmpvar_42;
  tmpvar_42 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_43;
  tmpvar_43 = (3.141593 * (tmpvar_41 * tmpvar_41));
  vec3 tmpvar_44;
  tmpvar_44 = (v_40.xyz - xlv_TEXCOORD0);
  float tmpvar_45;
  tmpvar_45 = dot (tmpvar_44, normalize(tmpvar_42));
  float tmpvar_46;
  tmpvar_46 = (_SunRadius * (tmpvar_45 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_47;
  tmpvar_47 = (3.141593 * (tmpvar_46 * tmpvar_46));
  float x_48;
  x_48 = ((2.0 * clamp (
    (((tmpvar_41 + tmpvar_46) - sqrt((
      dot (tmpvar_44, tmpvar_44)
     - 
      (tmpvar_45 * tmpvar_45)
    ))) / (2.0 * min (tmpvar_41, tmpvar_46)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_49;
  v_49.x = _ShadowBodies[0].y;
  v_49.y = _ShadowBodies[1].y;
  v_49.z = _ShadowBodies[2].y;
  float tmpvar_50;
  tmpvar_50 = _ShadowBodies[3].y;
  v_49.w = tmpvar_50;
  float tmpvar_51;
  tmpvar_51 = (3.141593 * (tmpvar_50 * tmpvar_50));
  vec3 tmpvar_52;
  tmpvar_52 = (v_49.xyz - xlv_TEXCOORD0);
  float tmpvar_53;
  tmpvar_53 = dot (tmpvar_52, normalize(tmpvar_42));
  float tmpvar_54;
  tmpvar_54 = (_SunRadius * (tmpvar_53 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_55;
  tmpvar_55 = (3.141593 * (tmpvar_54 * tmpvar_54));
  float x_56;
  x_56 = ((2.0 * clamp (
    (((tmpvar_50 + tmpvar_54) - sqrt((
      dot (tmpvar_52, tmpvar_52)
     - 
      (tmpvar_53 * tmpvar_53)
    ))) / (2.0 * min (tmpvar_50, tmpvar_54)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_57;
  v_57.x = _ShadowBodies[0].z;
  v_57.y = _ShadowBodies[1].z;
  v_57.z = _ShadowBodies[2].z;
  float tmpvar_58;
  tmpvar_58 = _ShadowBodies[3].z;
  v_57.w = tmpvar_58;
  float tmpvar_59;
  tmpvar_59 = (3.141593 * (tmpvar_58 * tmpvar_58));
  vec3 tmpvar_60;
  tmpvar_60 = (v_57.xyz - xlv_TEXCOORD0);
  float tmpvar_61;
  tmpvar_61 = dot (tmpvar_60, normalize(tmpvar_42));
  float tmpvar_62;
  tmpvar_62 = (_SunRadius * (tmpvar_61 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_63;
  tmpvar_63 = (3.141593 * (tmpvar_62 * tmpvar_62));
  float x_64;
  x_64 = ((2.0 * clamp (
    (((tmpvar_58 + tmpvar_62) - sqrt((
      dot (tmpvar_60, tmpvar_60)
     - 
      (tmpvar_61 * tmpvar_61)
    ))) / (2.0 * min (tmpvar_58, tmpvar_62)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_65;
  v_65.x = _ShadowBodies[0].w;
  v_65.y = _ShadowBodies[1].w;
  v_65.z = _ShadowBodies[2].w;
  float tmpvar_66;
  tmpvar_66 = _ShadowBodies[3].w;
  v_65.w = tmpvar_66;
  float tmpvar_67;
  tmpvar_67 = (3.141593 * (tmpvar_66 * tmpvar_66));
  vec3 tmpvar_68;
  tmpvar_68 = (v_65.xyz - xlv_TEXCOORD0);
  float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, normalize(tmpvar_42));
  float tmpvar_70;
  tmpvar_70 = (_SunRadius * (tmpvar_69 / sqrt(
    dot (tmpvar_42, tmpvar_42)
  )));
  float tmpvar_71;
  tmpvar_71 = (3.141593 * (tmpvar_70 * tmpvar_70));
  float x_72;
  x_72 = ((2.0 * clamp (
    (((tmpvar_66 + tmpvar_70) - sqrt((
      dot (tmpvar_68, tmpvar_68)
     - 
      (tmpvar_69 * tmpvar_69)
    ))) / (2.0 * min (tmpvar_66, tmpvar_70)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_47 - 
      (((0.3183099 * (
        sign(x_48)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_48)
        )) * (1.570796 + (
          abs(x_48)
         * 
          (-0.2146018 + (abs(x_48) * (0.08656672 + (
            abs(x_48)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_43)
    ) / tmpvar_47), 0.0, 1.0), (float((tmpvar_45 >= tmpvar_41)) * clamp (tmpvar_43, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_55 - 
      (((0.3183099 * (
        sign(x_56)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_56)
        )) * (1.570796 + (
          abs(x_56)
         * 
          (-0.2146018 + (abs(x_56) * (0.08656672 + (
            abs(x_56)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_51)
    ) / tmpvar_55), 0.0, 1.0), (float((tmpvar_53 >= tmpvar_50)) * clamp (tmpvar_51, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_63 - 
      (((0.3183099 * (
        sign(x_64)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_64)
        )) * (1.570796 + (
          abs(x_64)
         * 
          (-0.2146018 + (abs(x_64) * (0.08656672 + (
            abs(x_64)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_59)
    ) / tmpvar_63), 0.0, 1.0), (float((tmpvar_61 >= tmpvar_58)) * clamp (tmpvar_59, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_71 - 
      (((0.3183099 * (
        sign(x_72)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_72)
        )) * (1.570796 + (
          abs(x_72)
         * 
          (-0.2146018 + (abs(x_72) * (0.08656672 + (
            abs(x_72)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_67)
    ) / tmpvar_71), 0.0, 1.0), (float((tmpvar_69 >= tmpvar_66)) * clamp (tmpvar_67, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_35 * float((tmpvar_31 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord6 o7
dcl_texcoord8 o8
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.x, c14, v0
mov o8.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21
dp4 r0.x, c0, v0
dp4 r0.y, c1, v0
dp4 r0.z, c2, v0
dp4 r0.w, c3, v0
mov o0, r0
mul r1.xz, r0.xyww, c22.x
mul r1.y, r0.y, c19.x
mul r1.w, r1.y, c22.x
mad r0.xy, r1.z, c20.zwzw, r1.xwzw
mov o7, r0
mov o8.xyw, r0

"
}
SubProgram "d3d11 " {
// Stats: 34 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 381 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec2 uv_21;
  mediump vec3 detailCoords_22;
  mediump float s_23;
  mediump float nylerp_24;
  mediump float zxlerp_25;
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_27;
  tmpvar_27 = abs(tmpvar_26);
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_27.z >= tmpvar_27.x));
  zxlerp_25 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = float((max (tmpvar_27.x, tmpvar_27.z) >= tmpvar_27.y));
  nylerp_24 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = mix (tmpvar_26.x, tmpvar_26.z, zxlerp_25);
  s_23 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_26.y, s_23, nylerp_24));
  s_23 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(s_23);
  mediump vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = s_23;
  highp vec3 tmpvar_34;
  tmpvar_34 = mix ((tmpvar_32 * tmpvar_26.xzy), (tmpvar_33 * tmpvar_26.zxy), vec3(zxlerp_25));
  detailCoords_22 = tmpvar_34;
  mediump vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = s_23;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_26.yxz), detailCoords_22, vec3(nylerp_24));
  detailCoords_22 = tmpvar_36;
  uv_21 = (((
    (0.5 * detailCoords_22.yz)
   / 
    abs(detailCoords_22.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_37;
  uv_37 = uv_21;
  highp vec2 uvCont_38;
  highp vec2 tmpvar_39;
  tmpvar_39 = abs((uv_37 - (0.5 * _DetailScale)));
  uvCont_38.x = max (tmpvar_39.x, tmpvar_39.y);
  uvCont_38.y = min (tmpvar_39.x, tmpvar_39.y);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = dFdx(uvCont_38);
  tmpvar_40.zw = dFdy(uvCont_38);
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (_DetailTex, uv_21, tmpvar_40.xy, tmpvar_40.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  highp vec3 tmpvar_43;
  tmpvar_43 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_43, tmpvar_43)
  )), 0.0, 1.0);
  tmpvar_44 = tmpvar_45;
  color_2 = ((_Color * tmpvar_20) * mix (tmpvar_42, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_44)));
  highp float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_47;
  tmpvar_47 = sqrt(dot (tmpvar_43, tmpvar_43));
  highp vec3 tmpvar_48;
  tmpvar_48 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_49;
  tmpvar_49 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_50;
  tmpvar_50 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_47), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_47)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_46, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_48, tmpvar_48)) - (_RimDistSub * sqrt(
      dot (tmpvar_49, tmpvar_49)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_50;
  mediump float tmpvar_51;
  tmpvar_51 = color_2.w;
  lowp float tmpvar_52;
  highp float tmpvar_53;
  tmpvar_53 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_52 = tmpvar_53;
  mediump vec3 normal_54;
  normal_54 = xlv_TEXCOORD4;
  mediump float atten_55;
  atten_55 = tmpvar_52;
  mediump vec4 c_56;
  mediump vec3 tmpvar_57;
  tmpvar_57 = normalize(normal_54);
  normal_54 = tmpvar_57;
  mediump float tmpvar_58;
  tmpvar_58 = dot (tmpvar_57, normalize(_WorldSpaceLightPos0.xyz));
  c_56.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_58)) * (atten_55 * 2.0));
  c_56.w = (tmpvar_58 * (atten_55 * 2.0));
  mediump vec3 normal_59;
  normal_59 = xlv_TEXCOORD4;
  mediump float tmpvar_60;
  tmpvar_60 = dot (normal_59, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_56 * mix (1.0, clamp (
    floor((1.01 + tmpvar_60))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_60))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_51;
  highp vec4 v_61;
  v_61.x = _ShadowBodies[0].x;
  v_61.y = _ShadowBodies[1].x;
  v_61.z = _ShadowBodies[2].x;
  highp float tmpvar_62;
  tmpvar_62 = _ShadowBodies[3].x;
  v_61.w = tmpvar_62;
  mediump float tmpvar_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_65;
  tmpvar_65 = (3.141593 * (tmpvar_62 * tmpvar_62));
  highp vec3 tmpvar_66;
  tmpvar_66 = (v_61.xyz - xlv_TEXCOORD0);
  highp float tmpvar_67;
  tmpvar_67 = dot (tmpvar_66, normalize(tmpvar_64));
  highp float tmpvar_68;
  tmpvar_68 = (_SunRadius * (tmpvar_67 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_69;
  tmpvar_69 = (3.141593 * (tmpvar_68 * tmpvar_68));
  highp float x_70;
  x_70 = ((2.0 * clamp (
    (((tmpvar_62 + tmpvar_68) - sqrt((
      dot (tmpvar_66, tmpvar_66)
     - 
      (tmpvar_67 * tmpvar_67)
    ))) / (2.0 * min (tmpvar_62, tmpvar_68)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_71;
  tmpvar_71 = mix (1.0, clamp ((
    (tmpvar_69 - (((0.3183099 * 
      (sign(x_70) * (1.570796 - (sqrt(
        (1.0 - abs(x_70))
      ) * (1.570796 + 
        (abs(x_70) * (-0.2146018 + (abs(x_70) * (0.08656672 + 
          (abs(x_70) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_65))
   / tmpvar_69), 0.0, 1.0), (float(
    (tmpvar_67 >= tmpvar_62)
  ) * clamp (tmpvar_65, 0.0, 1.0)));
  tmpvar_63 = tmpvar_71;
  highp vec4 v_72;
  v_72.x = _ShadowBodies[0].y;
  v_72.y = _ShadowBodies[1].y;
  v_72.z = _ShadowBodies[2].y;
  highp float tmpvar_73;
  tmpvar_73 = _ShadowBodies[3].y;
  v_72.w = tmpvar_73;
  mediump float tmpvar_74;
  highp float tmpvar_75;
  tmpvar_75 = (3.141593 * (tmpvar_73 * tmpvar_73));
  highp vec3 tmpvar_76;
  tmpvar_76 = (v_72.xyz - xlv_TEXCOORD0);
  highp float tmpvar_77;
  tmpvar_77 = dot (tmpvar_76, normalize(tmpvar_64));
  highp float tmpvar_78;
  tmpvar_78 = (_SunRadius * (tmpvar_77 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_79;
  tmpvar_79 = (3.141593 * (tmpvar_78 * tmpvar_78));
  highp float x_80;
  x_80 = ((2.0 * clamp (
    (((tmpvar_73 + tmpvar_78) - sqrt((
      dot (tmpvar_76, tmpvar_76)
     - 
      (tmpvar_77 * tmpvar_77)
    ))) / (2.0 * min (tmpvar_73, tmpvar_78)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_81;
  tmpvar_81 = mix (1.0, clamp ((
    (tmpvar_79 - (((0.3183099 * 
      (sign(x_80) * (1.570796 - (sqrt(
        (1.0 - abs(x_80))
      ) * (1.570796 + 
        (abs(x_80) * (-0.2146018 + (abs(x_80) * (0.08656672 + 
          (abs(x_80) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_75))
   / tmpvar_79), 0.0, 1.0), (float(
    (tmpvar_77 >= tmpvar_73)
  ) * clamp (tmpvar_75, 0.0, 1.0)));
  tmpvar_74 = tmpvar_81;
  highp vec4 v_82;
  v_82.x = _ShadowBodies[0].z;
  v_82.y = _ShadowBodies[1].z;
  v_82.z = _ShadowBodies[2].z;
  highp float tmpvar_83;
  tmpvar_83 = _ShadowBodies[3].z;
  v_82.w = tmpvar_83;
  mediump float tmpvar_84;
  highp float tmpvar_85;
  tmpvar_85 = (3.141593 * (tmpvar_83 * tmpvar_83));
  highp vec3 tmpvar_86;
  tmpvar_86 = (v_82.xyz - xlv_TEXCOORD0);
  highp float tmpvar_87;
  tmpvar_87 = dot (tmpvar_86, normalize(tmpvar_64));
  highp float tmpvar_88;
  tmpvar_88 = (_SunRadius * (tmpvar_87 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_89;
  tmpvar_89 = (3.141593 * (tmpvar_88 * tmpvar_88));
  highp float x_90;
  x_90 = ((2.0 * clamp (
    (((tmpvar_83 + tmpvar_88) - sqrt((
      dot (tmpvar_86, tmpvar_86)
     - 
      (tmpvar_87 * tmpvar_87)
    ))) / (2.0 * min (tmpvar_83, tmpvar_88)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_91;
  tmpvar_91 = mix (1.0, clamp ((
    (tmpvar_89 - (((0.3183099 * 
      (sign(x_90) * (1.570796 - (sqrt(
        (1.0 - abs(x_90))
      ) * (1.570796 + 
        (abs(x_90) * (-0.2146018 + (abs(x_90) * (0.08656672 + 
          (abs(x_90) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_85))
   / tmpvar_89), 0.0, 1.0), (float(
    (tmpvar_87 >= tmpvar_83)
  ) * clamp (tmpvar_85, 0.0, 1.0)));
  tmpvar_84 = tmpvar_91;
  highp vec4 v_92;
  v_92.x = _ShadowBodies[0].w;
  v_92.y = _ShadowBodies[1].w;
  v_92.z = _ShadowBodies[2].w;
  highp float tmpvar_93;
  tmpvar_93 = _ShadowBodies[3].w;
  v_92.w = tmpvar_93;
  mediump float tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = (3.141593 * (tmpvar_93 * tmpvar_93));
  highp vec3 tmpvar_96;
  tmpvar_96 = (v_92.xyz - xlv_TEXCOORD0);
  highp float tmpvar_97;
  tmpvar_97 = dot (tmpvar_96, normalize(tmpvar_64));
  highp float tmpvar_98;
  tmpvar_98 = (_SunRadius * (tmpvar_97 / sqrt(
    dot (tmpvar_64, tmpvar_64)
  )));
  highp float tmpvar_99;
  tmpvar_99 = (3.141593 * (tmpvar_98 * tmpvar_98));
  highp float x_100;
  x_100 = ((2.0 * clamp (
    (((tmpvar_93 + tmpvar_98) - sqrt((
      dot (tmpvar_96, tmpvar_96)
     - 
      (tmpvar_97 * tmpvar_97)
    ))) / (2.0 * min (tmpvar_93, tmpvar_98)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_101;
  tmpvar_101 = mix (1.0, clamp ((
    (tmpvar_99 - (((0.3183099 * 
      (sign(x_100) * (1.570796 - (sqrt(
        (1.0 - abs(x_100))
      ) * (1.570796 + 
        (abs(x_100) * (-0.2146018 + (abs(x_100) * (0.08656672 + 
          (abs(x_100) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_95))
   / tmpvar_99), 0.0, 1.0), (float(
    (tmpvar_97 >= tmpvar_93)
  ) * clamp (tmpvar_95, 0.0, 1.0)));
  tmpvar_94 = tmpvar_101;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_63, tmpvar_74), min (tmpvar_84, tmpvar_94)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_102;
  tmpvar_102 = float((tmpvar_46 >= 0.0));
  tmpvar_3.w = (tmpvar_51 * tmpvar_102);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD4.xyz = vec3(t13) * t2.xyz;
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t1.x = t0.y * _ProjectionParams.x;
    t1.w = t1.x * 0.5;
    t1.xz = t0.xw * vec2(0.5, 0.5);
    t0.xy = t1.zz + t1.xw;
    vs_TEXCOORD6 = t0;
    vs_TEXCOORD8.xyw = t0.xyw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
mediump float t16_12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t12.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t12.xy);
    t16_12 = t10_2.x + t10_2.x;
    t1.xyz = vec3(t16_12) * t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 380 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec2 uv_21;
  mediump vec3 detailCoords_22;
  mediump float s_23;
  mediump float nylerp_24;
  mediump float zxlerp_25;
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_27;
  tmpvar_27 = abs(tmpvar_26);
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_27.z >= tmpvar_27.x));
  zxlerp_25 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = float((max (tmpvar_27.x, tmpvar_27.z) >= tmpvar_27.y));
  nylerp_24 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = mix (tmpvar_26.x, tmpvar_26.z, zxlerp_25);
  s_23 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_26.y, s_23, nylerp_24));
  s_23 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(s_23);
  mediump vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = s_23;
  highp vec3 tmpvar_34;
  tmpvar_34 = mix ((tmpvar_32 * tmpvar_26.xzy), (tmpvar_33 * tmpvar_26.zxy), vec3(zxlerp_25));
  detailCoords_22 = tmpvar_34;
  mediump vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = s_23;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_26.yxz), detailCoords_22, vec3(nylerp_24));
  detailCoords_22 = tmpvar_36;
  uv_21 = (((
    (0.5 * detailCoords_22.yz)
   / 
    abs(detailCoords_22.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_37;
  uv_37 = uv_21;
  highp vec2 uvCont_38;
  highp vec2 tmpvar_39;
  tmpvar_39 = abs((uv_37 - (0.5 * _DetailScale)));
  uvCont_38.x = max (tmpvar_39.x, tmpvar_39.y);
  uvCont_38.y = min (tmpvar_39.x, tmpvar_39.y);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = dFdx(uvCont_38);
  tmpvar_40.zw = dFdy(uvCont_38);
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (_DetailTex, uv_21, tmpvar_40.xy, tmpvar_40.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  highp vec3 tmpvar_43;
  tmpvar_43 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_43, tmpvar_43)
  )), 0.0, 1.0);
  tmpvar_44 = tmpvar_45;
  color_2 = ((_Color * tmpvar_20) * mix (tmpvar_42, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_44)));
  highp float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_47;
  tmpvar_47 = sqrt(dot (tmpvar_43, tmpvar_43));
  highp vec3 tmpvar_48;
  tmpvar_48 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_49;
  tmpvar_49 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_50;
  tmpvar_50 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_47), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_47)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_46, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_48, tmpvar_48)) - (_RimDistSub * sqrt(
      dot (tmpvar_49, tmpvar_49)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_50;
  mediump float tmpvar_51;
  tmpvar_51 = color_2.w;
  lowp float shadow_52;
  shadow_52 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 normal_53;
  normal_53 = xlv_TEXCOORD4;
  mediump float atten_54;
  atten_54 = shadow_52;
  mediump vec4 c_55;
  mediump vec3 tmpvar_56;
  tmpvar_56 = normalize(normal_53);
  normal_53 = tmpvar_56;
  mediump float tmpvar_57;
  tmpvar_57 = dot (tmpvar_56, normalize(_WorldSpaceLightPos0.xyz));
  c_55.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_57)) * (atten_54 * 2.0));
  c_55.w = (tmpvar_57 * (atten_54 * 2.0));
  mediump vec3 normal_58;
  normal_58 = xlv_TEXCOORD4;
  mediump float tmpvar_59;
  tmpvar_59 = dot (normal_58, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_55 * mix (1.0, clamp (
    floor((1.01 + tmpvar_59))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_59))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_51;
  highp vec4 v_60;
  v_60.x = _ShadowBodies[0].x;
  v_60.y = _ShadowBodies[1].x;
  v_60.z = _ShadowBodies[2].x;
  highp float tmpvar_61;
  tmpvar_61 = _ShadowBodies[3].x;
  v_60.w = tmpvar_61;
  mediump float tmpvar_62;
  highp vec3 tmpvar_63;
  tmpvar_63 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_61 * tmpvar_61));
  highp vec3 tmpvar_65;
  tmpvar_65 = (v_60.xyz - xlv_TEXCOORD0);
  highp float tmpvar_66;
  tmpvar_66 = dot (tmpvar_65, normalize(tmpvar_63));
  highp float tmpvar_67;
  tmpvar_67 = (_SunRadius * (tmpvar_66 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_68;
  tmpvar_68 = (3.141593 * (tmpvar_67 * tmpvar_67));
  highp float x_69;
  x_69 = ((2.0 * clamp (
    (((tmpvar_61 + tmpvar_67) - sqrt((
      dot (tmpvar_65, tmpvar_65)
     - 
      (tmpvar_66 * tmpvar_66)
    ))) / (2.0 * min (tmpvar_61, tmpvar_67)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_70;
  tmpvar_70 = mix (1.0, clamp ((
    (tmpvar_68 - (((0.3183099 * 
      (sign(x_69) * (1.570796 - (sqrt(
        (1.0 - abs(x_69))
      ) * (1.570796 + 
        (abs(x_69) * (-0.2146018 + (abs(x_69) * (0.08656672 + 
          (abs(x_69) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_64))
   / tmpvar_68), 0.0, 1.0), (float(
    (tmpvar_66 >= tmpvar_61)
  ) * clamp (tmpvar_64, 0.0, 1.0)));
  tmpvar_62 = tmpvar_70;
  highp vec4 v_71;
  v_71.x = _ShadowBodies[0].y;
  v_71.y = _ShadowBodies[1].y;
  v_71.z = _ShadowBodies[2].y;
  highp float tmpvar_72;
  tmpvar_72 = _ShadowBodies[3].y;
  v_71.w = tmpvar_72;
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = (3.141593 * (tmpvar_72 * tmpvar_72));
  highp vec3 tmpvar_75;
  tmpvar_75 = (v_71.xyz - xlv_TEXCOORD0);
  highp float tmpvar_76;
  tmpvar_76 = dot (tmpvar_75, normalize(tmpvar_63));
  highp float tmpvar_77;
  tmpvar_77 = (_SunRadius * (tmpvar_76 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_78;
  tmpvar_78 = (3.141593 * (tmpvar_77 * tmpvar_77));
  highp float x_79;
  x_79 = ((2.0 * clamp (
    (((tmpvar_72 + tmpvar_77) - sqrt((
      dot (tmpvar_75, tmpvar_75)
     - 
      (tmpvar_76 * tmpvar_76)
    ))) / (2.0 * min (tmpvar_72, tmpvar_77)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_80;
  tmpvar_80 = mix (1.0, clamp ((
    (tmpvar_78 - (((0.3183099 * 
      (sign(x_79) * (1.570796 - (sqrt(
        (1.0 - abs(x_79))
      ) * (1.570796 + 
        (abs(x_79) * (-0.2146018 + (abs(x_79) * (0.08656672 + 
          (abs(x_79) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_74))
   / tmpvar_78), 0.0, 1.0), (float(
    (tmpvar_76 >= tmpvar_72)
  ) * clamp (tmpvar_74, 0.0, 1.0)));
  tmpvar_73 = tmpvar_80;
  highp vec4 v_81;
  v_81.x = _ShadowBodies[0].z;
  v_81.y = _ShadowBodies[1].z;
  v_81.z = _ShadowBodies[2].z;
  highp float tmpvar_82;
  tmpvar_82 = _ShadowBodies[3].z;
  v_81.w = tmpvar_82;
  mediump float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = (3.141593 * (tmpvar_82 * tmpvar_82));
  highp vec3 tmpvar_85;
  tmpvar_85 = (v_81.xyz - xlv_TEXCOORD0);
  highp float tmpvar_86;
  tmpvar_86 = dot (tmpvar_85, normalize(tmpvar_63));
  highp float tmpvar_87;
  tmpvar_87 = (_SunRadius * (tmpvar_86 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_88;
  tmpvar_88 = (3.141593 * (tmpvar_87 * tmpvar_87));
  highp float x_89;
  x_89 = ((2.0 * clamp (
    (((tmpvar_82 + tmpvar_87) - sqrt((
      dot (tmpvar_85, tmpvar_85)
     - 
      (tmpvar_86 * tmpvar_86)
    ))) / (2.0 * min (tmpvar_82, tmpvar_87)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_90;
  tmpvar_90 = mix (1.0, clamp ((
    (tmpvar_88 - (((0.3183099 * 
      (sign(x_89) * (1.570796 - (sqrt(
        (1.0 - abs(x_89))
      ) * (1.570796 + 
        (abs(x_89) * (-0.2146018 + (abs(x_89) * (0.08656672 + 
          (abs(x_89) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_84))
   / tmpvar_88), 0.0, 1.0), (float(
    (tmpvar_86 >= tmpvar_82)
  ) * clamp (tmpvar_84, 0.0, 1.0)));
  tmpvar_83 = tmpvar_90;
  highp vec4 v_91;
  v_91.x = _ShadowBodies[0].w;
  v_91.y = _ShadowBodies[1].w;
  v_91.z = _ShadowBodies[2].w;
  highp float tmpvar_92;
  tmpvar_92 = _ShadowBodies[3].w;
  v_91.w = tmpvar_92;
  mediump float tmpvar_93;
  highp float tmpvar_94;
  tmpvar_94 = (3.141593 * (tmpvar_92 * tmpvar_92));
  highp vec3 tmpvar_95;
  tmpvar_95 = (v_91.xyz - xlv_TEXCOORD0);
  highp float tmpvar_96;
  tmpvar_96 = dot (tmpvar_95, normalize(tmpvar_63));
  highp float tmpvar_97;
  tmpvar_97 = (_SunRadius * (tmpvar_96 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_98;
  tmpvar_98 = (3.141593 * (tmpvar_97 * tmpvar_97));
  highp float x_99;
  x_99 = ((2.0 * clamp (
    (((tmpvar_92 + tmpvar_97) - sqrt((
      dot (tmpvar_95, tmpvar_95)
     - 
      (tmpvar_96 * tmpvar_96)
    ))) / (2.0 * min (tmpvar_92, tmpvar_97)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_100;
  tmpvar_100 = mix (1.0, clamp ((
    (tmpvar_98 - (((0.3183099 * 
      (sign(x_99) * (1.570796 - (sqrt(
        (1.0 - abs(x_99))
      ) * (1.570796 + 
        (abs(x_99) * (-0.2146018 + (abs(x_99) * (0.08656672 + 
          (abs(x_99) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_94))
   / tmpvar_98), 0.0, 1.0), (float(
    (tmpvar_96 >= tmpvar_92)
  ) * clamp (tmpvar_94, 0.0, 1.0)));
  tmpvar_93 = tmpvar_100;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_62, tmpvar_73), min (tmpvar_83, tmpvar_93)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_101;
  tmpvar_101 = float((tmpvar_46 >= 0.0));
  tmpvar_3.w = (tmpvar_51 * tmpvar_101);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD6 = t1;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_0 = t10_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    vec3 txVec112 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_13.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec112, 0.0);
    t16_21 = (-_LightShadowData.x) + 1.0;
    t16_13.x = t16_13.x * t16_21 + _LightShadowData.x;
    t16_13.x = t16_13.x + t16_13.x;
    t16_11.xyz = t16_11.xyz * t16_13.xxx;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 18 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  half4 tmpvar_3;
  float4 tmpvar_4;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_5;
  tmpvar_5 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_6;
  float4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  float2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _mtl_u._ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  float4 o_9;
  float4 tmpvar_10;
  tmpvar_10 = (tmpvar_1 * 0.5);
  float2 tmpvar_11;
  tmpvar_11.x = tmpvar_10.x;
  tmpvar_11.y = (tmpvar_10.y * _mtl_u._ProjectionParams.x);
  o_9.xy = (tmpvar_11 + tmpvar_10.w);
  o_9.zw = tmpvar_1.zw;
  tmpvar_3 = half4(o_9);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_5.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_5.xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD8 = tmpvar_4;
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 380 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec2 uv_21;
  mediump vec3 detailCoords_22;
  mediump float s_23;
  mediump float nylerp_24;
  mediump float zxlerp_25;
  highp vec3 tmpvar_26;
  tmpvar_26 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_27;
  tmpvar_27 = abs(tmpvar_26);
  highp float tmpvar_28;
  tmpvar_28 = float((tmpvar_27.z >= tmpvar_27.x));
  zxlerp_25 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = float((max (tmpvar_27.x, tmpvar_27.z) >= tmpvar_27.y));
  nylerp_24 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = mix (tmpvar_26.x, tmpvar_26.z, zxlerp_25);
  s_23 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_26.y, s_23, nylerp_24));
  s_23 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(s_23);
  mediump vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = s_23;
  highp vec3 tmpvar_34;
  tmpvar_34 = mix ((tmpvar_32 * tmpvar_26.xzy), (tmpvar_33 * tmpvar_26.zxy), vec3(zxlerp_25));
  detailCoords_22 = tmpvar_34;
  mediump vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = s_23;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_26.yxz), detailCoords_22, vec3(nylerp_24));
  detailCoords_22 = tmpvar_36;
  uv_21 = (((
    (0.5 * detailCoords_22.yz)
   / 
    abs(detailCoords_22.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_37;
  uv_37 = uv_21;
  highp vec2 uvCont_38;
  highp vec2 tmpvar_39;
  tmpvar_39 = abs((uv_37 - (0.5 * _DetailScale)));
  uvCont_38.x = max (tmpvar_39.x, tmpvar_39.y);
  uvCont_38.y = min (tmpvar_39.x, tmpvar_39.y);
  highp vec4 tmpvar_40;
  tmpvar_40.xy = dFdx(uvCont_38);
  tmpvar_40.zw = dFdy(uvCont_38);
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (_DetailTex, uv_21, tmpvar_40.xy, tmpvar_40.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  highp vec3 tmpvar_43;
  tmpvar_43 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_43, tmpvar_43)
  )), 0.0, 1.0);
  tmpvar_44 = tmpvar_45;
  color_2 = ((_Color * tmpvar_20) * mix (tmpvar_42, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_44)));
  highp float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_47;
  tmpvar_47 = sqrt(dot (tmpvar_43, tmpvar_43));
  highp vec3 tmpvar_48;
  tmpvar_48 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_49;
  tmpvar_49 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_50;
  tmpvar_50 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_47), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_47)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_46, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_48, tmpvar_48)) - (_RimDistSub * sqrt(
      dot (tmpvar_49, tmpvar_49)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_50;
  mediump float tmpvar_51;
  tmpvar_51 = color_2.w;
  lowp float shadow_52;
  shadow_52 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 normal_53;
  normal_53 = xlv_TEXCOORD4;
  mediump float atten_54;
  atten_54 = shadow_52;
  mediump vec4 c_55;
  mediump vec3 tmpvar_56;
  tmpvar_56 = normalize(normal_53);
  normal_53 = tmpvar_56;
  mediump float tmpvar_57;
  tmpvar_57 = dot (tmpvar_56, normalize(_WorldSpaceLightPos0.xyz));
  c_55.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_57)) * (atten_54 * 2.0));
  c_55.w = (tmpvar_57 * (atten_54 * 2.0));
  mediump vec3 normal_58;
  normal_58 = xlv_TEXCOORD4;
  mediump float tmpvar_59;
  tmpvar_59 = dot (normal_58, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_55 * mix (1.0, clamp (
    floor((1.01 + tmpvar_59))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_59))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_51;
  highp vec4 v_60;
  v_60.x = _ShadowBodies[0].x;
  v_60.y = _ShadowBodies[1].x;
  v_60.z = _ShadowBodies[2].x;
  highp float tmpvar_61;
  tmpvar_61 = _ShadowBodies[3].x;
  v_60.w = tmpvar_61;
  mediump float tmpvar_62;
  highp vec3 tmpvar_63;
  tmpvar_63 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_61 * tmpvar_61));
  highp vec3 tmpvar_65;
  tmpvar_65 = (v_60.xyz - xlv_TEXCOORD0);
  highp float tmpvar_66;
  tmpvar_66 = dot (tmpvar_65, normalize(tmpvar_63));
  highp float tmpvar_67;
  tmpvar_67 = (_SunRadius * (tmpvar_66 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_68;
  tmpvar_68 = (3.141593 * (tmpvar_67 * tmpvar_67));
  highp float x_69;
  x_69 = ((2.0 * clamp (
    (((tmpvar_61 + tmpvar_67) - sqrt((
      dot (tmpvar_65, tmpvar_65)
     - 
      (tmpvar_66 * tmpvar_66)
    ))) / (2.0 * min (tmpvar_61, tmpvar_67)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_70;
  tmpvar_70 = mix (1.0, clamp ((
    (tmpvar_68 - (((0.3183099 * 
      (sign(x_69) * (1.570796 - (sqrt(
        (1.0 - abs(x_69))
      ) * (1.570796 + 
        (abs(x_69) * (-0.2146018 + (abs(x_69) * (0.08656672 + 
          (abs(x_69) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_64))
   / tmpvar_68), 0.0, 1.0), (float(
    (tmpvar_66 >= tmpvar_61)
  ) * clamp (tmpvar_64, 0.0, 1.0)));
  tmpvar_62 = tmpvar_70;
  highp vec4 v_71;
  v_71.x = _ShadowBodies[0].y;
  v_71.y = _ShadowBodies[1].y;
  v_71.z = _ShadowBodies[2].y;
  highp float tmpvar_72;
  tmpvar_72 = _ShadowBodies[3].y;
  v_71.w = tmpvar_72;
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = (3.141593 * (tmpvar_72 * tmpvar_72));
  highp vec3 tmpvar_75;
  tmpvar_75 = (v_71.xyz - xlv_TEXCOORD0);
  highp float tmpvar_76;
  tmpvar_76 = dot (tmpvar_75, normalize(tmpvar_63));
  highp float tmpvar_77;
  tmpvar_77 = (_SunRadius * (tmpvar_76 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_78;
  tmpvar_78 = (3.141593 * (tmpvar_77 * tmpvar_77));
  highp float x_79;
  x_79 = ((2.0 * clamp (
    (((tmpvar_72 + tmpvar_77) - sqrt((
      dot (tmpvar_75, tmpvar_75)
     - 
      (tmpvar_76 * tmpvar_76)
    ))) / (2.0 * min (tmpvar_72, tmpvar_77)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_80;
  tmpvar_80 = mix (1.0, clamp ((
    (tmpvar_78 - (((0.3183099 * 
      (sign(x_79) * (1.570796 - (sqrt(
        (1.0 - abs(x_79))
      ) * (1.570796 + 
        (abs(x_79) * (-0.2146018 + (abs(x_79) * (0.08656672 + 
          (abs(x_79) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_74))
   / tmpvar_78), 0.0, 1.0), (float(
    (tmpvar_76 >= tmpvar_72)
  ) * clamp (tmpvar_74, 0.0, 1.0)));
  tmpvar_73 = tmpvar_80;
  highp vec4 v_81;
  v_81.x = _ShadowBodies[0].z;
  v_81.y = _ShadowBodies[1].z;
  v_81.z = _ShadowBodies[2].z;
  highp float tmpvar_82;
  tmpvar_82 = _ShadowBodies[3].z;
  v_81.w = tmpvar_82;
  mediump float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = (3.141593 * (tmpvar_82 * tmpvar_82));
  highp vec3 tmpvar_85;
  tmpvar_85 = (v_81.xyz - xlv_TEXCOORD0);
  highp float tmpvar_86;
  tmpvar_86 = dot (tmpvar_85, normalize(tmpvar_63));
  highp float tmpvar_87;
  tmpvar_87 = (_SunRadius * (tmpvar_86 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_88;
  tmpvar_88 = (3.141593 * (tmpvar_87 * tmpvar_87));
  highp float x_89;
  x_89 = ((2.0 * clamp (
    (((tmpvar_82 + tmpvar_87) - sqrt((
      dot (tmpvar_85, tmpvar_85)
     - 
      (tmpvar_86 * tmpvar_86)
    ))) / (2.0 * min (tmpvar_82, tmpvar_87)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_90;
  tmpvar_90 = mix (1.0, clamp ((
    (tmpvar_88 - (((0.3183099 * 
      (sign(x_89) * (1.570796 - (sqrt(
        (1.0 - abs(x_89))
      ) * (1.570796 + 
        (abs(x_89) * (-0.2146018 + (abs(x_89) * (0.08656672 + 
          (abs(x_89) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_84))
   / tmpvar_88), 0.0, 1.0), (float(
    (tmpvar_86 >= tmpvar_82)
  ) * clamp (tmpvar_84, 0.0, 1.0)));
  tmpvar_83 = tmpvar_90;
  highp vec4 v_91;
  v_91.x = _ShadowBodies[0].w;
  v_91.y = _ShadowBodies[1].w;
  v_91.z = _ShadowBodies[2].w;
  highp float tmpvar_92;
  tmpvar_92 = _ShadowBodies[3].w;
  v_91.w = tmpvar_92;
  mediump float tmpvar_93;
  highp float tmpvar_94;
  tmpvar_94 = (3.141593 * (tmpvar_92 * tmpvar_92));
  highp vec3 tmpvar_95;
  tmpvar_95 = (v_91.xyz - xlv_TEXCOORD0);
  highp float tmpvar_96;
  tmpvar_96 = dot (tmpvar_95, normalize(tmpvar_63));
  highp float tmpvar_97;
  tmpvar_97 = (_SunRadius * (tmpvar_96 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_98;
  tmpvar_98 = (3.141593 * (tmpvar_97 * tmpvar_97));
  highp float x_99;
  x_99 = ((2.0 * clamp (
    (((tmpvar_92 + tmpvar_97) - sqrt((
      dot (tmpvar_95, tmpvar_95)
     - 
      (tmpvar_96 * tmpvar_96)
    ))) / (2.0 * min (tmpvar_92, tmpvar_97)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_100;
  tmpvar_100 = mix (1.0, clamp ((
    (tmpvar_98 - (((0.3183099 * 
      (sign(x_99) * (1.570796 - (sqrt(
        (1.0 - abs(x_99))
      ) * (1.570796 + 
        (abs(x_99) * (-0.2146018 + (abs(x_99) * (0.08656672 + 
          (abs(x_99) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_94))
   / tmpvar_98), 0.0, 1.0), (float(
    (tmpvar_96 >= tmpvar_92)
  ) * clamp (tmpvar_94, 0.0, 1.0)));
  tmpvar_93 = tmpvar_100;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_62, tmpvar_73), min (tmpvar_83, tmpvar_93)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_101;
  tmpvar_101 = float((tmpvar_46 >= 0.0));
  tmpvar_3.w = (tmpvar_51 * tmpvar_101);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD6 = t1;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_0 = t10_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    vec3 txVec93 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_13.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec93, 0.0);
    t16_21 = (-_LightShadowData.x) + 1.0;
    t16_13.x = t16_13.x * t16_21 + _LightShadowData.x;
    t16_13.x = t16_13.x + t16_13.x;
    t16_11.xyz = t16_11.xyz * t16_13.xxx;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 18 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  half4 tmpvar_3;
  float4 tmpvar_4;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_5;
  tmpvar_5 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_6;
  float4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  float2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _mtl_u._ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  float4 o_9;
  float4 tmpvar_10;
  tmpvar_10 = (tmpvar_1 * 0.5);
  float2 tmpvar_11;
  tmpvar_11.x = tmpvar_10.x;
  tmpvar_11.y = (tmpvar_10.y * _mtl_u._ProjectionParams.x);
  o_9.xy = (tmpvar_11 + tmpvar_10.w);
  o_9.zw = tmpvar_1.zw;
  tmpvar_3 = half4(o_9);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_5.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_5.xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD8 = tmpvar_4;
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 380 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec4 v_17;
  v_17 = (texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw) * alphaMask1);
  vec4 tmpvar_18;
  tmpvar_18.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_18.w = ((v_17.x + v_17.y) + (v_17.z + v_17.w));
  vec2 uv_19;
  vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  float tmpvar_24;
  tmpvar_24 = sign(mix (tmpvar_20.y, mix (tmpvar_20.x, tmpvar_20.z, tmpvar_22), tmpvar_23));
  vec3 tmpvar_25;
  tmpvar_25.xz = vec2(1.0, -1.0);
  tmpvar_25.y = -(tmpvar_24);
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = tmpvar_24;
  vec3 tmpvar_27;
  tmpvar_27.xy = vec2(1.0, 1.0);
  tmpvar_27.z = tmpvar_24;
  vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_27 * tmpvar_20.yxz), mix ((tmpvar_25 * tmpvar_20.xzy), (tmpvar_26 * tmpvar_20.zxy), vec3(tmpvar_22)), vec3(tmpvar_23));
  uv_19 = (((
    (0.5 * tmpvar_28.yz)
   / 
    abs(tmpvar_28.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_29;
  vec2 tmpvar_30;
  tmpvar_30 = abs((uv_19 - (0.5 * _DetailScale)));
  uvCont_29.x = max (tmpvar_30.x, tmpvar_30.y);
  uvCont_29.y = min (tmpvar_30.x, tmpvar_30.y);
  vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_29);
  tmpvar_31.zw = dFdy(uvCont_29);
  vec3 tmpvar_32;
  tmpvar_32 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * tmpvar_18) * mix (texture2DGradARB (_DetailTex, uv_19, tmpvar_31.xy, tmpvar_31.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_32, tmpvar_32)))
  , 0.0, 1.0))));
  float tmpvar_33;
  tmpvar_33 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_34;
  tmpvar_34 = sqrt(dot (tmpvar_32, tmpvar_32));
  vec3 tmpvar_35;
  tmpvar_35 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_36;
  tmpvar_36 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_34), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_34)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_33, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_35, tmpvar_35)) - (_RimDistSub * sqrt(
      dot (tmpvar_36, tmpvar_36)
    ))))
  , 0.0, 1.0)));
  float tmpvar_37;
  tmpvar_37 = color_2.w;
  vec4 c_38;
  float tmpvar_39;
  tmpvar_39 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_38.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_39 * 2.0));
  c_38.w = (tmpvar_39 * 2.0);
  float tmpvar_40;
  tmpvar_40 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_38 * mix (1.0, clamp (
    floor((1.01 + tmpvar_40))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_40))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_37;
  vec4 v_41;
  v_41.x = _ShadowBodies[0].x;
  v_41.y = _ShadowBodies[1].x;
  v_41.z = _ShadowBodies[2].x;
  float tmpvar_42;
  tmpvar_42 = _ShadowBodies[3].x;
  v_41.w = tmpvar_42;
  vec3 tmpvar_43;
  tmpvar_43 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_44;
  tmpvar_44 = (3.141593 * (tmpvar_42 * tmpvar_42));
  vec3 tmpvar_45;
  tmpvar_45 = (v_41.xyz - xlv_TEXCOORD0);
  float tmpvar_46;
  tmpvar_46 = dot (tmpvar_45, normalize(tmpvar_43));
  float tmpvar_47;
  tmpvar_47 = (_SunRadius * (tmpvar_46 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_48;
  tmpvar_48 = (3.141593 * (tmpvar_47 * tmpvar_47));
  float x_49;
  x_49 = ((2.0 * clamp (
    (((tmpvar_42 + tmpvar_47) - sqrt((
      dot (tmpvar_45, tmpvar_45)
     - 
      (tmpvar_46 * tmpvar_46)
    ))) / (2.0 * min (tmpvar_42, tmpvar_47)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_50;
  v_50.x = _ShadowBodies[0].y;
  v_50.y = _ShadowBodies[1].y;
  v_50.z = _ShadowBodies[2].y;
  float tmpvar_51;
  tmpvar_51 = _ShadowBodies[3].y;
  v_50.w = tmpvar_51;
  float tmpvar_52;
  tmpvar_52 = (3.141593 * (tmpvar_51 * tmpvar_51));
  vec3 tmpvar_53;
  tmpvar_53 = (v_50.xyz - xlv_TEXCOORD0);
  float tmpvar_54;
  tmpvar_54 = dot (tmpvar_53, normalize(tmpvar_43));
  float tmpvar_55;
  tmpvar_55 = (_SunRadius * (tmpvar_54 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_56;
  tmpvar_56 = (3.141593 * (tmpvar_55 * tmpvar_55));
  float x_57;
  x_57 = ((2.0 * clamp (
    (((tmpvar_51 + tmpvar_55) - sqrt((
      dot (tmpvar_53, tmpvar_53)
     - 
      (tmpvar_54 * tmpvar_54)
    ))) / (2.0 * min (tmpvar_51, tmpvar_55)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_58;
  v_58.x = _ShadowBodies[0].z;
  v_58.y = _ShadowBodies[1].z;
  v_58.z = _ShadowBodies[2].z;
  float tmpvar_59;
  tmpvar_59 = _ShadowBodies[3].z;
  v_58.w = tmpvar_59;
  float tmpvar_60;
  tmpvar_60 = (3.141593 * (tmpvar_59 * tmpvar_59));
  vec3 tmpvar_61;
  tmpvar_61 = (v_58.xyz - xlv_TEXCOORD0);
  float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, normalize(tmpvar_43));
  float tmpvar_63;
  tmpvar_63 = (_SunRadius * (tmpvar_62 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_63 * tmpvar_63));
  float x_65;
  x_65 = ((2.0 * clamp (
    (((tmpvar_59 + tmpvar_63) - sqrt((
      dot (tmpvar_61, tmpvar_61)
     - 
      (tmpvar_62 * tmpvar_62)
    ))) / (2.0 * min (tmpvar_59, tmpvar_63)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_66;
  v_66.x = _ShadowBodies[0].w;
  v_66.y = _ShadowBodies[1].w;
  v_66.z = _ShadowBodies[2].w;
  float tmpvar_67;
  tmpvar_67 = _ShadowBodies[3].w;
  v_66.w = tmpvar_67;
  float tmpvar_68;
  tmpvar_68 = (3.141593 * (tmpvar_67 * tmpvar_67));
  vec3 tmpvar_69;
  tmpvar_69 = (v_66.xyz - xlv_TEXCOORD0);
  float tmpvar_70;
  tmpvar_70 = dot (tmpvar_69, normalize(tmpvar_43));
  float tmpvar_71;
  tmpvar_71 = (_SunRadius * (tmpvar_70 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_72;
  tmpvar_72 = (3.141593 * (tmpvar_71 * tmpvar_71));
  float x_73;
  x_73 = ((2.0 * clamp (
    (((tmpvar_67 + tmpvar_71) - sqrt((
      dot (tmpvar_69, tmpvar_69)
     - 
      (tmpvar_70 * tmpvar_70)
    ))) / (2.0 * min (tmpvar_67, tmpvar_71)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_48 - 
      (((0.3183099 * (
        sign(x_49)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_49)
        )) * (1.570796 + (
          abs(x_49)
         * 
          (-0.2146018 + (abs(x_49) * (0.08656672 + (
            abs(x_49)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_44)
    ) / tmpvar_48), 0.0, 1.0), (float((tmpvar_46 >= tmpvar_42)) * clamp (tmpvar_44, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_56 - 
      (((0.3183099 * (
        sign(x_57)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_57)
        )) * (1.570796 + (
          abs(x_57)
         * 
          (-0.2146018 + (abs(x_57) * (0.08656672 + (
            abs(x_57)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_52)
    ) / tmpvar_56), 0.0, 1.0), (float((tmpvar_54 >= tmpvar_51)) * clamp (tmpvar_52, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_64 - 
      (((0.3183099 * (
        sign(x_65)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_65)
        )) * (1.570796 + (
          abs(x_65)
         * 
          (-0.2146018 + (abs(x_65) * (0.08656672 + (
            abs(x_65)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_60)
    ) / tmpvar_64), 0.0, 1.0), (float((tmpvar_62 >= tmpvar_59)) * clamp (tmpvar_60, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_72 - 
      (((0.3183099 * (
        sign(x_73)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_73)
        )) * (1.570796 + (
          abs(x_73)
         * 
          (-0.2146018 + (abs(x_73) * (0.08656672 + (
            abs(x_73)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_68)
    ) / tmpvar_72), 0.0, 1.0), (float((tmpvar_70 >= tmpvar_67)) * clamp (tmpvar_68, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_37 * float((tmpvar_33 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 37 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord8 o7
dp4 o0.z, c2, v0
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r0.z, r0.y, c19.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xzw, r0.xywz, c22.x
mov o0.xyw, r0
mov o7.w, r0.w
mad o7.xy, r1.z, c20.zwzw, r1.xwzw
dp4 r0.x, c14, v0
mov o7.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21

"
}
SubProgram "d3d11 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 380 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec4 v_21;
  v_21 = (tmpvar_20 * alphaMask1);
  mediump vec4 tmpvar_22;
  tmpvar_22.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_22.w = ((v_21.x + v_21.y) + (v_21.z + v_21.w));
  mediump vec2 uv_23;
  mediump vec3 detailCoords_24;
  mediump float s_25;
  mediump float nylerp_26;
  mediump float zxlerp_27;
  highp vec3 tmpvar_28;
  tmpvar_28 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_28);
  highp float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  zxlerp_27 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  nylerp_26 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = mix (tmpvar_28.x, tmpvar_28.z, zxlerp_27);
  s_25 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = sign(mix (tmpvar_28.y, s_25, nylerp_26));
  s_25 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = -(s_25);
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = s_25;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_34 * tmpvar_28.xzy), (tmpvar_35 * tmpvar_28.zxy), vec3(zxlerp_27));
  detailCoords_24 = tmpvar_36;
  mediump vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = s_25;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_28.yxz), detailCoords_24, vec3(nylerp_26));
  detailCoords_24 = tmpvar_38;
  uv_23 = (((
    (0.5 * detailCoords_24.yz)
   / 
    abs(detailCoords_24.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_39;
  uv_39 = uv_23;
  highp vec2 uvCont_40;
  highp vec2 tmpvar_41;
  tmpvar_41 = abs((uv_39 - (0.5 * _DetailScale)));
  uvCont_40.x = max (tmpvar_41.x, tmpvar_41.y);
  uvCont_40.y = min (tmpvar_41.x, tmpvar_41.y);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_40);
  tmpvar_42.zw = dFdy(uvCont_40);
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (_DetailTex, uv_23, tmpvar_42.xy, tmpvar_42.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  highp vec3 tmpvar_45;
  tmpvar_45 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_45, tmpvar_45)
  )), 0.0, 1.0);
  tmpvar_46 = tmpvar_47;
  color_2 = ((_Color * tmpvar_22) * mix (tmpvar_44, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_46)));
  highp float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_49;
  tmpvar_49 = sqrt(dot (tmpvar_45, tmpvar_45));
  highp vec3 tmpvar_50;
  tmpvar_50 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_51;
  tmpvar_51 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_52;
  tmpvar_52 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_49), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_49)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_48, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_50, tmpvar_50)) - (_RimDistSub * sqrt(
      dot (tmpvar_51, tmpvar_51)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = color_2.w;
  mediump vec3 normal_54;
  normal_54 = xlv_TEXCOORD4;
  mediump vec4 c_55;
  mediump vec3 tmpvar_56;
  tmpvar_56 = normalize(normal_54);
  normal_54 = tmpvar_56;
  mediump float tmpvar_57;
  tmpvar_57 = dot (tmpvar_56, normalize(_WorldSpaceLightPos0.xyz));
  c_55.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_57 * 2.0));
  c_55.w = (tmpvar_57 * 2.0);
  mediump vec3 normal_58;
  normal_58 = xlv_TEXCOORD4;
  mediump float tmpvar_59;
  tmpvar_59 = dot (normal_58, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_55 * mix (1.0, clamp (
    floor((1.01 + tmpvar_59))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_59))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_53;
  highp vec4 v_60;
  v_60.x = _ShadowBodies[0].x;
  v_60.y = _ShadowBodies[1].x;
  v_60.z = _ShadowBodies[2].x;
  highp float tmpvar_61;
  tmpvar_61 = _ShadowBodies[3].x;
  v_60.w = tmpvar_61;
  mediump float tmpvar_62;
  highp vec3 tmpvar_63;
  tmpvar_63 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_61 * tmpvar_61));
  highp vec3 tmpvar_65;
  tmpvar_65 = (v_60.xyz - xlv_TEXCOORD0);
  highp float tmpvar_66;
  tmpvar_66 = dot (tmpvar_65, normalize(tmpvar_63));
  highp float tmpvar_67;
  tmpvar_67 = (_SunRadius * (tmpvar_66 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_68;
  tmpvar_68 = (3.141593 * (tmpvar_67 * tmpvar_67));
  highp float x_69;
  x_69 = ((2.0 * clamp (
    (((tmpvar_61 + tmpvar_67) - sqrt((
      dot (tmpvar_65, tmpvar_65)
     - 
      (tmpvar_66 * tmpvar_66)
    ))) / (2.0 * min (tmpvar_61, tmpvar_67)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_70;
  tmpvar_70 = mix (1.0, clamp ((
    (tmpvar_68 - (((0.3183099 * 
      (sign(x_69) * (1.570796 - (sqrt(
        (1.0 - abs(x_69))
      ) * (1.570796 + 
        (abs(x_69) * (-0.2146018 + (abs(x_69) * (0.08656672 + 
          (abs(x_69) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_64))
   / tmpvar_68), 0.0, 1.0), (float(
    (tmpvar_66 >= tmpvar_61)
  ) * clamp (tmpvar_64, 0.0, 1.0)));
  tmpvar_62 = tmpvar_70;
  highp vec4 v_71;
  v_71.x = _ShadowBodies[0].y;
  v_71.y = _ShadowBodies[1].y;
  v_71.z = _ShadowBodies[2].y;
  highp float tmpvar_72;
  tmpvar_72 = _ShadowBodies[3].y;
  v_71.w = tmpvar_72;
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = (3.141593 * (tmpvar_72 * tmpvar_72));
  highp vec3 tmpvar_75;
  tmpvar_75 = (v_71.xyz - xlv_TEXCOORD0);
  highp float tmpvar_76;
  tmpvar_76 = dot (tmpvar_75, normalize(tmpvar_63));
  highp float tmpvar_77;
  tmpvar_77 = (_SunRadius * (tmpvar_76 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_78;
  tmpvar_78 = (3.141593 * (tmpvar_77 * tmpvar_77));
  highp float x_79;
  x_79 = ((2.0 * clamp (
    (((tmpvar_72 + tmpvar_77) - sqrt((
      dot (tmpvar_75, tmpvar_75)
     - 
      (tmpvar_76 * tmpvar_76)
    ))) / (2.0 * min (tmpvar_72, tmpvar_77)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_80;
  tmpvar_80 = mix (1.0, clamp ((
    (tmpvar_78 - (((0.3183099 * 
      (sign(x_79) * (1.570796 - (sqrt(
        (1.0 - abs(x_79))
      ) * (1.570796 + 
        (abs(x_79) * (-0.2146018 + (abs(x_79) * (0.08656672 + 
          (abs(x_79) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_74))
   / tmpvar_78), 0.0, 1.0), (float(
    (tmpvar_76 >= tmpvar_72)
  ) * clamp (tmpvar_74, 0.0, 1.0)));
  tmpvar_73 = tmpvar_80;
  highp vec4 v_81;
  v_81.x = _ShadowBodies[0].z;
  v_81.y = _ShadowBodies[1].z;
  v_81.z = _ShadowBodies[2].z;
  highp float tmpvar_82;
  tmpvar_82 = _ShadowBodies[3].z;
  v_81.w = tmpvar_82;
  mediump float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = (3.141593 * (tmpvar_82 * tmpvar_82));
  highp vec3 tmpvar_85;
  tmpvar_85 = (v_81.xyz - xlv_TEXCOORD0);
  highp float tmpvar_86;
  tmpvar_86 = dot (tmpvar_85, normalize(tmpvar_63));
  highp float tmpvar_87;
  tmpvar_87 = (_SunRadius * (tmpvar_86 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_88;
  tmpvar_88 = (3.141593 * (tmpvar_87 * tmpvar_87));
  highp float x_89;
  x_89 = ((2.0 * clamp (
    (((tmpvar_82 + tmpvar_87) - sqrt((
      dot (tmpvar_85, tmpvar_85)
     - 
      (tmpvar_86 * tmpvar_86)
    ))) / (2.0 * min (tmpvar_82, tmpvar_87)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_90;
  tmpvar_90 = mix (1.0, clamp ((
    (tmpvar_88 - (((0.3183099 * 
      (sign(x_89) * (1.570796 - (sqrt(
        (1.0 - abs(x_89))
      ) * (1.570796 + 
        (abs(x_89) * (-0.2146018 + (abs(x_89) * (0.08656672 + 
          (abs(x_89) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_84))
   / tmpvar_88), 0.0, 1.0), (float(
    (tmpvar_86 >= tmpvar_82)
  ) * clamp (tmpvar_84, 0.0, 1.0)));
  tmpvar_83 = tmpvar_90;
  highp vec4 v_91;
  v_91.x = _ShadowBodies[0].w;
  v_91.y = _ShadowBodies[1].w;
  v_91.z = _ShadowBodies[2].w;
  highp float tmpvar_92;
  tmpvar_92 = _ShadowBodies[3].w;
  v_91.w = tmpvar_92;
  mediump float tmpvar_93;
  highp float tmpvar_94;
  tmpvar_94 = (3.141593 * (tmpvar_92 * tmpvar_92));
  highp vec3 tmpvar_95;
  tmpvar_95 = (v_91.xyz - xlv_TEXCOORD0);
  highp float tmpvar_96;
  tmpvar_96 = dot (tmpvar_95, normalize(tmpvar_63));
  highp float tmpvar_97;
  tmpvar_97 = (_SunRadius * (tmpvar_96 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_98;
  tmpvar_98 = (3.141593 * (tmpvar_97 * tmpvar_97));
  highp float x_99;
  x_99 = ((2.0 * clamp (
    (((tmpvar_92 + tmpvar_97) - sqrt((
      dot (tmpvar_95, tmpvar_95)
     - 
      (tmpvar_96 * tmpvar_96)
    ))) / (2.0 * min (tmpvar_92, tmpvar_97)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_100;
  tmpvar_100 = mix (1.0, clamp ((
    (tmpvar_98 - (((0.3183099 * 
      (sign(x_99) * (1.570796 - (sqrt(
        (1.0 - abs(x_99))
      ) * (1.570796 + 
        (abs(x_99) * (-0.2146018 + (abs(x_99) * (0.08656672 + 
          (abs(x_99) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_94))
   / tmpvar_98), 0.0, 1.0), (float(
    (tmpvar_96 >= tmpvar_92)
  ) * clamp (tmpvar_94, 0.0, 1.0)));
  tmpvar_93 = tmpvar_100;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_62, tmpvar_73), min (tmpvar_83, tmpvar_93)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_101;
  tmpvar_101 = float((tmpvar_48 >= 0.0));
  tmpvar_3.w = (tmpvar_53 * tmpvar_101);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_13.xy = t10_0.xy * alphaMask1.xy;
    t16_13.x = t16_13.y + t16_13.x;
    t16_13.x = t10_0.z * alphaMask1.z + t16_13.x;
    t16_0.w = t10_0.w * alphaMask1.w + t16_13.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    t16_11.xyz = t16_11.xyz + t16_11.xyz;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 15 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  float4 tmpvar_3;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_4;
  tmpvar_4 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_5;
  float4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  float2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _mtl_u._ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_4.xyz));
  _mtl_o.xlv_TEXCOORD8 = tmpvar_3;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t6.xy = t10_1.xy * alphaMask1.xy;
    t6.x = t6.y + t6.x;
    t6.x = t10_1.z * alphaMask1.z + t6.x;
    t1.w = t10_1.w * alphaMask1.w + t6.x;
    t1.xyz = vec3(1.0, 1.0, 1.0);
    t1 = t1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t1.xyz = t1.xyz + t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 382 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD6 = o_8;
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec4 v_17;
  v_17 = (texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw) * alphaMask1);
  vec4 tmpvar_18;
  tmpvar_18.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_18.w = ((v_17.x + v_17.y) + (v_17.z + v_17.w));
  vec2 uv_19;
  vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  float tmpvar_24;
  tmpvar_24 = sign(mix (tmpvar_20.y, mix (tmpvar_20.x, tmpvar_20.z, tmpvar_22), tmpvar_23));
  vec3 tmpvar_25;
  tmpvar_25.xz = vec2(1.0, -1.0);
  tmpvar_25.y = -(tmpvar_24);
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = tmpvar_24;
  vec3 tmpvar_27;
  tmpvar_27.xy = vec2(1.0, 1.0);
  tmpvar_27.z = tmpvar_24;
  vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_27 * tmpvar_20.yxz), mix ((tmpvar_25 * tmpvar_20.xzy), (tmpvar_26 * tmpvar_20.zxy), vec3(tmpvar_22)), vec3(tmpvar_23));
  uv_19 = (((
    (0.5 * tmpvar_28.yz)
   / 
    abs(tmpvar_28.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_29;
  vec2 tmpvar_30;
  tmpvar_30 = abs((uv_19 - (0.5 * _DetailScale)));
  uvCont_29.x = max (tmpvar_30.x, tmpvar_30.y);
  uvCont_29.y = min (tmpvar_30.x, tmpvar_30.y);
  vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_29);
  tmpvar_31.zw = dFdy(uvCont_29);
  vec3 tmpvar_32;
  tmpvar_32 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * tmpvar_18) * mix (texture2DGradARB (_DetailTex, uv_19, tmpvar_31.xy, tmpvar_31.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_32, tmpvar_32)))
  , 0.0, 1.0))));
  float tmpvar_33;
  tmpvar_33 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_34;
  tmpvar_34 = sqrt(dot (tmpvar_32, tmpvar_32));
  vec3 tmpvar_35;
  tmpvar_35 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_36;
  tmpvar_36 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_34), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_34)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_33, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_35, tmpvar_35)) - (_RimDistSub * sqrt(
      dot (tmpvar_36, tmpvar_36)
    ))))
  , 0.0, 1.0)));
  float tmpvar_37;
  tmpvar_37 = color_2.w;
  vec4 tmpvar_38;
  tmpvar_38 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_39;
  float tmpvar_40;
  tmpvar_40 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_39.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_40)) * (tmpvar_38.x * 2.0));
  c_39.w = (tmpvar_40 * (tmpvar_38.x * 2.0));
  float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_39 * mix (1.0, clamp (
    floor((1.01 + tmpvar_41))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_41))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_37;
  vec4 v_42;
  v_42.x = _ShadowBodies[0].x;
  v_42.y = _ShadowBodies[1].x;
  v_42.z = _ShadowBodies[2].x;
  float tmpvar_43;
  tmpvar_43 = _ShadowBodies[3].x;
  v_42.w = tmpvar_43;
  vec3 tmpvar_44;
  tmpvar_44 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_45;
  tmpvar_45 = (3.141593 * (tmpvar_43 * tmpvar_43));
  vec3 tmpvar_46;
  tmpvar_46 = (v_42.xyz - xlv_TEXCOORD0);
  float tmpvar_47;
  tmpvar_47 = dot (tmpvar_46, normalize(tmpvar_44));
  float tmpvar_48;
  tmpvar_48 = (_SunRadius * (tmpvar_47 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_49;
  tmpvar_49 = (3.141593 * (tmpvar_48 * tmpvar_48));
  float x_50;
  x_50 = ((2.0 * clamp (
    (((tmpvar_43 + tmpvar_48) - sqrt((
      dot (tmpvar_46, tmpvar_46)
     - 
      (tmpvar_47 * tmpvar_47)
    ))) / (2.0 * min (tmpvar_43, tmpvar_48)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_51;
  v_51.x = _ShadowBodies[0].y;
  v_51.y = _ShadowBodies[1].y;
  v_51.z = _ShadowBodies[2].y;
  float tmpvar_52;
  tmpvar_52 = _ShadowBodies[3].y;
  v_51.w = tmpvar_52;
  float tmpvar_53;
  tmpvar_53 = (3.141593 * (tmpvar_52 * tmpvar_52));
  vec3 tmpvar_54;
  tmpvar_54 = (v_51.xyz - xlv_TEXCOORD0);
  float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, normalize(tmpvar_44));
  float tmpvar_56;
  tmpvar_56 = (_SunRadius * (tmpvar_55 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_57;
  tmpvar_57 = (3.141593 * (tmpvar_56 * tmpvar_56));
  float x_58;
  x_58 = ((2.0 * clamp (
    (((tmpvar_52 + tmpvar_56) - sqrt((
      dot (tmpvar_54, tmpvar_54)
     - 
      (tmpvar_55 * tmpvar_55)
    ))) / (2.0 * min (tmpvar_52, tmpvar_56)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_59;
  v_59.x = _ShadowBodies[0].z;
  v_59.y = _ShadowBodies[1].z;
  v_59.z = _ShadowBodies[2].z;
  float tmpvar_60;
  tmpvar_60 = _ShadowBodies[3].z;
  v_59.w = tmpvar_60;
  float tmpvar_61;
  tmpvar_61 = (3.141593 * (tmpvar_60 * tmpvar_60));
  vec3 tmpvar_62;
  tmpvar_62 = (v_59.xyz - xlv_TEXCOORD0);
  float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, normalize(tmpvar_44));
  float tmpvar_64;
  tmpvar_64 = (_SunRadius * (tmpvar_63 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_65;
  tmpvar_65 = (3.141593 * (tmpvar_64 * tmpvar_64));
  float x_66;
  x_66 = ((2.0 * clamp (
    (((tmpvar_60 + tmpvar_64) - sqrt((
      dot (tmpvar_62, tmpvar_62)
     - 
      (tmpvar_63 * tmpvar_63)
    ))) / (2.0 * min (tmpvar_60, tmpvar_64)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_67;
  v_67.x = _ShadowBodies[0].w;
  v_67.y = _ShadowBodies[1].w;
  v_67.z = _ShadowBodies[2].w;
  float tmpvar_68;
  tmpvar_68 = _ShadowBodies[3].w;
  v_67.w = tmpvar_68;
  float tmpvar_69;
  tmpvar_69 = (3.141593 * (tmpvar_68 * tmpvar_68));
  vec3 tmpvar_70;
  tmpvar_70 = (v_67.xyz - xlv_TEXCOORD0);
  float tmpvar_71;
  tmpvar_71 = dot (tmpvar_70, normalize(tmpvar_44));
  float tmpvar_72;
  tmpvar_72 = (_SunRadius * (tmpvar_71 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_73;
  tmpvar_73 = (3.141593 * (tmpvar_72 * tmpvar_72));
  float x_74;
  x_74 = ((2.0 * clamp (
    (((tmpvar_68 + tmpvar_72) - sqrt((
      dot (tmpvar_70, tmpvar_70)
     - 
      (tmpvar_71 * tmpvar_71)
    ))) / (2.0 * min (tmpvar_68, tmpvar_72)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_49 - 
      (((0.3183099 * (
        sign(x_50)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_50)
        )) * (1.570796 + (
          abs(x_50)
         * 
          (-0.2146018 + (abs(x_50) * (0.08656672 + (
            abs(x_50)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_45)
    ) / tmpvar_49), 0.0, 1.0), (float((tmpvar_47 >= tmpvar_43)) * clamp (tmpvar_45, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_57 - 
      (((0.3183099 * (
        sign(x_58)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_58)
        )) * (1.570796 + (
          abs(x_58)
         * 
          (-0.2146018 + (abs(x_58) * (0.08656672 + (
            abs(x_58)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_53)
    ) / tmpvar_57), 0.0, 1.0), (float((tmpvar_55 >= tmpvar_52)) * clamp (tmpvar_53, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_65 - 
      (((0.3183099 * (
        sign(x_66)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_66)
        )) * (1.570796 + (
          abs(x_66)
         * 
          (-0.2146018 + (abs(x_66) * (0.08656672 + (
            abs(x_66)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_61)
    ) / tmpvar_65), 0.0, 1.0), (float((tmpvar_63 >= tmpvar_60)) * clamp (tmpvar_61, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_73 - 
      (((0.3183099 * (
        sign(x_74)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_74)
        )) * (1.570796 + (
          abs(x_74)
         * 
          (-0.2146018 + (abs(x_74) * (0.08656672 + (
            abs(x_74)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_69)
    ) / tmpvar_73), 0.0, 1.0), (float((tmpvar_71 >= tmpvar_68)) * clamp (tmpvar_69, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_37 * float((tmpvar_33 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord6 o7
dcl_texcoord8 o8
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.x, c14, v0
mov o8.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21
dp4 r0.x, c0, v0
dp4 r0.y, c1, v0
dp4 r0.z, c2, v0
dp4 r0.w, c3, v0
mov o0, r0
mul r1.xz, r0.xyww, c22.x
mul r1.y, r0.y, c19.x
mul r1.w, r1.y, c22.x
mad r0.xy, r1.z, c20.zwzw, r1.xwzw
mov o7, r0
mov o8.xyw, r0

"
}
SubProgram "d3d11 " {
// Stats: 34 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa
eefiecedodklnabcmhgepepoaaeakllkhdpeaebcabaaaaaagaahaaaaadaaaaaa
cmaaaaaajmaaaaaajmabaaaaejfdeheogiaaaaaaadaaaaaaaiaaaaaafaaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaaaaaaaaaapapaaaafjaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaapaaaaaafpaaaaaaaaaaaaaaaaaaaaaaadaaaaaaacaaaaaa
ahaaaaaafaepfdejfeejepeoaaedepemepfcaaeoepfcenebemaaklklepfdeheo
piaaaaaaajaaaaaaaiaaaaaaoaaaaaaaaaaaaaaaabaaaaaaadaaaaaaaaaaaaaa
apaaaaaaomaaaaaaaaaaaaaaaaaaaaaaadaaaaaaabaaaaaaahaiaaaaomaaaaaa
abaaaaaaaaaaaaaaadaaaaaaacaaaaaaahaiaaaaomaaaaaaacaaaaaaaaaaaaaa
adaaaaaaadaaaaaaapaaaaaaomaaaaaaadaaaaaaaaaaaaaaadaaaaaaaeaaaaaa
apaaaaaaomaaaaaaaeaaaaaaaaaaaaaaadaaaaaaafaaaaaaahaiaaaaomaaaaaa
afaaaaaaaaaaaaaaadaaaaaaagaaaaaaahaiaaaaomaaaaaaagaaaaaaaaaaaaaa
adaaaaaaahaaaaaaapaaaaaaomaaaaaaaiaaaaaaaaaaaaaaadaaaaaaaiaaaaaa
apaaaaaafdfgfpfaepfdejfeejepeoaafeeffiedepepfceeaaklklklfdeieefc
lmafaaaaeaaaabaagpabaaaafjaaaaaeegiocaaaaaaaaaaabnaaaaaafjaaaaae
egiocaaaabaaaaaaagaaaaaafjaaaaaeegiocaaaacaaaaaabaaaaaaafpaaaaad
pcbabaaaaaaaaaaaghaaaaaepccabaaaaaaaaaaaabaaaaaagfaaaaadhccabaaa
abaaaaaagfaaaaadhccabaaaacaaaaaagfaaaaadpccabaaaadaaaaaagfaaaaad
pccabaaaaeaaaaaagfaaaaadhccabaaaafaaaaaagfaaaaadhccabaaaagaaaaaa
gfaaaaadpccabaaaahaaaaaagfaaaaadpccabaaaaiaaaaaagiaaaaacaeaaaaaa
diaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaaegiocaaaacaaaaaaabaaaaaa
dcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaaaaaaaaaaagbabaaaaaaaaaaa
egaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaaacaaaaaa
kgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaa
acaaaaaaadaaaaaapgbpbaaaaaaaaaaaegaobaaaaaaaaaaadgaaaaafpccabaaa
aaaaaaaaegaobaaaaaaaaaaadiaaaaaihcaabaaaabaaaaaafgbfbaaaaaaaaaaa
egiccaaaacaaaaaaanaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaa
amaaaaaaagbabaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaa
egiccaaaacaaaaaaaoaaaaaakgbkbaaaaaaaaaaaegacbaaaabaaaaaadcaaaaak
hcaabaaaabaaaaaaegiccaaaacaaaaaaapaaaaaapgbpbaaaaaaaaaaaegacbaaa
abaaaaaadgaaaaafhccabaaaabaaaaaaegacbaaaabaaaaaaaaaaaaakhccabaaa
acaaaaaaegiccaaaaaaaaaaabmaaaaaaegiccaiaebaaaaaaabaaaaaaaeaaaaaa
diaaaaaipcaabaaaacaaaaaafgbfbaaaaaaaaaaaegiocaaaaaaaaaaaakaaaaaa
dcaaaaakpcaabaaaacaaaaaaegiocaaaaaaaaaaaajaaaaaaagbabaaaaaaaaaaa
egaobaaaacaaaaaadcaaaaakpcaabaaaacaaaaaaegiocaaaaaaaaaaaalaaaaaa
kgbkbaaaaaaaaaaaegaobaaaacaaaaaadcaaaaakpcaabaaaacaaaaaaegiocaaa
aaaaaaaaamaaaaaapgbpbaaaaaaaaaaaegaobaaaacaaaaaadiaaaaaipcaabaaa
adaaaaaafgafbaaaacaaaaaaegiocaaaaaaaaaaaaoaaaaaadcaaaaakpcaabaaa
adaaaaaaegiocaaaaaaaaaaaanaaaaaaagaabaaaacaaaaaaegaobaaaadaaaaaa
dcaaaaakpcaabaaaadaaaaaaegiocaaaaaaaaaaaapaaaaaakgakbaaaacaaaaaa
egaobaaaadaaaaaadcaaaaakpccabaaaadaaaaaaegiocaaaaaaaaaaabaaaaaaa
pgapbaaaacaaaaaaegaobaaaadaaaaaadgaaaaafpccabaaaaeaaaaaaegaobaaa
acaaaaaaaaaaaaajhcaabaaaacaaaaaaegacbaaaabaaaaaaegiccaiaebaaaaaa
acaaaaaaapaaaaaaaaaaaaajhcaabaaaabaaaaaaegacbaiaebaaaaaaabaaaaaa
egiccaaaabaaaaaaaeaaaaaabaaaaaahicaabaaaabaaaaaaegacbaaaacaaaaaa
egacbaaaacaaaaaaeeaaaaaficaabaaaabaaaaaadkaabaaaabaaaaaadiaaaaah
hccabaaaafaaaaaapgapbaaaabaaaaaaegacbaaaacaaaaaabaaaaaahicaabaaa
abaaaaaaegacbaaaabaaaaaaegacbaaaabaaaaaaeeaaaaaficaabaaaabaaaaaa
dkaabaaaabaaaaaadiaaaaahhccabaaaagaaaaaapgapbaaaabaaaaaaegacbaaa
abaaaaaadiaaaaaibcaabaaaabaaaaaabkaabaaaaaaaaaaaakiacaaaabaaaaaa
afaaaaaadiaaaaahicaabaaaabaaaaaaakaabaaaabaaaaaaabeaaaaaaaaaaadp
diaaaaakfcaabaaaabaaaaaaagadbaaaaaaaaaaaaceaaaaaaaaaaadpaaaaaaaa
aaaaaadpaaaaaaaaaaaaaaahdcaabaaaaaaaaaaakgakbaaaabaaaaaamgaabaaa
abaaaaaadgaaaaafpccabaaaahaaaaaaegaobaaaaaaaaaaadgaaaaaflccabaaa
aiaaaaaaegambaaaaaaaaaaadiaaaaaibcaabaaaaaaaaaaabkbabaaaaaaaaaaa
ckiacaaaacaaaaaaafaaaaaadcaaaaakbcaabaaaaaaaaaaackiacaaaacaaaaaa
aeaaaaaaakbabaaaaaaaaaaaakaabaaaaaaaaaaadcaaaaakbcaabaaaaaaaaaaa
ckiacaaaacaaaaaaagaaaaaackbabaaaaaaaaaaaakaabaaaaaaaaaaadcaaaaak
bcaabaaaaaaaaaaackiacaaaacaaaaaaahaaaaaadkbabaaaaaaaaaaaakaabaaa
aaaaaaaadgaaaaageccabaaaaiaaaaaaakaabaiaebaaaaaaaaaaaaaadoaaaaab
"
}
SubProgram "gles " {
// Stats: 386 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec4 v_21;
  v_21 = (tmpvar_20 * alphaMask1);
  mediump vec4 tmpvar_22;
  tmpvar_22.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_22.w = ((v_21.x + v_21.y) + (v_21.z + v_21.w));
  mediump vec2 uv_23;
  mediump vec3 detailCoords_24;
  mediump float s_25;
  mediump float nylerp_26;
  mediump float zxlerp_27;
  highp vec3 tmpvar_28;
  tmpvar_28 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_28);
  highp float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  zxlerp_27 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  nylerp_26 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = mix (tmpvar_28.x, tmpvar_28.z, zxlerp_27);
  s_25 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = sign(mix (tmpvar_28.y, s_25, nylerp_26));
  s_25 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = -(s_25);
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = s_25;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_34 * tmpvar_28.xzy), (tmpvar_35 * tmpvar_28.zxy), vec3(zxlerp_27));
  detailCoords_24 = tmpvar_36;
  mediump vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = s_25;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_28.yxz), detailCoords_24, vec3(nylerp_26));
  detailCoords_24 = tmpvar_38;
  uv_23 = (((
    (0.5 * detailCoords_24.yz)
   / 
    abs(detailCoords_24.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_39;
  uv_39 = uv_23;
  highp vec2 uvCont_40;
  highp vec2 tmpvar_41;
  tmpvar_41 = abs((uv_39 - (0.5 * _DetailScale)));
  uvCont_40.x = max (tmpvar_41.x, tmpvar_41.y);
  uvCont_40.y = min (tmpvar_41.x, tmpvar_41.y);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_40);
  tmpvar_42.zw = dFdy(uvCont_40);
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (_DetailTex, uv_23, tmpvar_42.xy, tmpvar_42.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  highp vec3 tmpvar_45;
  tmpvar_45 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_45, tmpvar_45)
  )), 0.0, 1.0);
  tmpvar_46 = tmpvar_47;
  color_2 = ((_Color * tmpvar_22) * mix (tmpvar_44, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_46)));
  highp float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_49;
  tmpvar_49 = sqrt(dot (tmpvar_45, tmpvar_45));
  highp vec3 tmpvar_50;
  tmpvar_50 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_51;
  tmpvar_51 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_52;
  tmpvar_52 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_49), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_49)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_48, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_50, tmpvar_50)) - (_RimDistSub * sqrt(
      dot (tmpvar_51, tmpvar_51)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = color_2.w;
  lowp float tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_54 = tmpvar_55;
  mediump vec3 normal_56;
  normal_56 = xlv_TEXCOORD4;
  mediump float atten_57;
  atten_57 = tmpvar_54;
  mediump vec4 c_58;
  mediump vec3 tmpvar_59;
  tmpvar_59 = normalize(normal_56);
  normal_56 = tmpvar_59;
  mediump float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, normalize(_WorldSpaceLightPos0.xyz));
  c_58.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_60)) * (atten_57 * 2.0));
  c_58.w = (tmpvar_60 * (atten_57 * 2.0));
  mediump vec3 normal_61;
  normal_61 = xlv_TEXCOORD4;
  mediump float tmpvar_62;
  tmpvar_62 = dot (normal_61, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_58 * mix (1.0, clamp (
    floor((1.01 + tmpvar_62))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_62))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_53;
  highp vec4 v_63;
  v_63.x = _ShadowBodies[0].x;
  v_63.y = _ShadowBodies[1].x;
  v_63.z = _ShadowBodies[2].x;
  highp float tmpvar_64;
  tmpvar_64 = _ShadowBodies[3].x;
  v_63.w = tmpvar_64;
  mediump float tmpvar_65;
  highp vec3 tmpvar_66;
  tmpvar_66 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_67;
  tmpvar_67 = (3.141593 * (tmpvar_64 * tmpvar_64));
  highp vec3 tmpvar_68;
  tmpvar_68 = (v_63.xyz - xlv_TEXCOORD0);
  highp float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, normalize(tmpvar_66));
  highp float tmpvar_70;
  tmpvar_70 = (_SunRadius * (tmpvar_69 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_71;
  tmpvar_71 = (3.141593 * (tmpvar_70 * tmpvar_70));
  highp float x_72;
  x_72 = ((2.0 * clamp (
    (((tmpvar_64 + tmpvar_70) - sqrt((
      dot (tmpvar_68, tmpvar_68)
     - 
      (tmpvar_69 * tmpvar_69)
    ))) / (2.0 * min (tmpvar_64, tmpvar_70)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_73;
  tmpvar_73 = mix (1.0, clamp ((
    (tmpvar_71 - (((0.3183099 * 
      (sign(x_72) * (1.570796 - (sqrt(
        (1.0 - abs(x_72))
      ) * (1.570796 + 
        (abs(x_72) * (-0.2146018 + (abs(x_72) * (0.08656672 + 
          (abs(x_72) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_67))
   / tmpvar_71), 0.0, 1.0), (float(
    (tmpvar_69 >= tmpvar_64)
  ) * clamp (tmpvar_67, 0.0, 1.0)));
  tmpvar_65 = tmpvar_73;
  highp vec4 v_74;
  v_74.x = _ShadowBodies[0].y;
  v_74.y = _ShadowBodies[1].y;
  v_74.z = _ShadowBodies[2].y;
  highp float tmpvar_75;
  tmpvar_75 = _ShadowBodies[3].y;
  v_74.w = tmpvar_75;
  mediump float tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = (3.141593 * (tmpvar_75 * tmpvar_75));
  highp vec3 tmpvar_78;
  tmpvar_78 = (v_74.xyz - xlv_TEXCOORD0);
  highp float tmpvar_79;
  tmpvar_79 = dot (tmpvar_78, normalize(tmpvar_66));
  highp float tmpvar_80;
  tmpvar_80 = (_SunRadius * (tmpvar_79 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_81;
  tmpvar_81 = (3.141593 * (tmpvar_80 * tmpvar_80));
  highp float x_82;
  x_82 = ((2.0 * clamp (
    (((tmpvar_75 + tmpvar_80) - sqrt((
      dot (tmpvar_78, tmpvar_78)
     - 
      (tmpvar_79 * tmpvar_79)
    ))) / (2.0 * min (tmpvar_75, tmpvar_80)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_83;
  tmpvar_83 = mix (1.0, clamp ((
    (tmpvar_81 - (((0.3183099 * 
      (sign(x_82) * (1.570796 - (sqrt(
        (1.0 - abs(x_82))
      ) * (1.570796 + 
        (abs(x_82) * (-0.2146018 + (abs(x_82) * (0.08656672 + 
          (abs(x_82) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_77))
   / tmpvar_81), 0.0, 1.0), (float(
    (tmpvar_79 >= tmpvar_75)
  ) * clamp (tmpvar_77, 0.0, 1.0)));
  tmpvar_76 = tmpvar_83;
  highp vec4 v_84;
  v_84.x = _ShadowBodies[0].z;
  v_84.y = _ShadowBodies[1].z;
  v_84.z = _ShadowBodies[2].z;
  highp float tmpvar_85;
  tmpvar_85 = _ShadowBodies[3].z;
  v_84.w = tmpvar_85;
  mediump float tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = (3.141593 * (tmpvar_85 * tmpvar_85));
  highp vec3 tmpvar_88;
  tmpvar_88 = (v_84.xyz - xlv_TEXCOORD0);
  highp float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, normalize(tmpvar_66));
  highp float tmpvar_90;
  tmpvar_90 = (_SunRadius * (tmpvar_89 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_91;
  tmpvar_91 = (3.141593 * (tmpvar_90 * tmpvar_90));
  highp float x_92;
  x_92 = ((2.0 * clamp (
    (((tmpvar_85 + tmpvar_90) - sqrt((
      dot (tmpvar_88, tmpvar_88)
     - 
      (tmpvar_89 * tmpvar_89)
    ))) / (2.0 * min (tmpvar_85, tmpvar_90)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_93;
  tmpvar_93 = mix (1.0, clamp ((
    (tmpvar_91 - (((0.3183099 * 
      (sign(x_92) * (1.570796 - (sqrt(
        (1.0 - abs(x_92))
      ) * (1.570796 + 
        (abs(x_92) * (-0.2146018 + (abs(x_92) * (0.08656672 + 
          (abs(x_92) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_87))
   / tmpvar_91), 0.0, 1.0), (float(
    (tmpvar_89 >= tmpvar_85)
  ) * clamp (tmpvar_87, 0.0, 1.0)));
  tmpvar_86 = tmpvar_93;
  highp vec4 v_94;
  v_94.x = _ShadowBodies[0].w;
  v_94.y = _ShadowBodies[1].w;
  v_94.z = _ShadowBodies[2].w;
  highp float tmpvar_95;
  tmpvar_95 = _ShadowBodies[3].w;
  v_94.w = tmpvar_95;
  mediump float tmpvar_96;
  highp float tmpvar_97;
  tmpvar_97 = (3.141593 * (tmpvar_95 * tmpvar_95));
  highp vec3 tmpvar_98;
  tmpvar_98 = (v_94.xyz - xlv_TEXCOORD0);
  highp float tmpvar_99;
  tmpvar_99 = dot (tmpvar_98, normalize(tmpvar_66));
  highp float tmpvar_100;
  tmpvar_100 = (_SunRadius * (tmpvar_99 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_101;
  tmpvar_101 = (3.141593 * (tmpvar_100 * tmpvar_100));
  highp float x_102;
  x_102 = ((2.0 * clamp (
    (((tmpvar_95 + tmpvar_100) - sqrt((
      dot (tmpvar_98, tmpvar_98)
     - 
      (tmpvar_99 * tmpvar_99)
    ))) / (2.0 * min (tmpvar_95, tmpvar_100)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_103;
  tmpvar_103 = mix (1.0, clamp ((
    (tmpvar_101 - (((0.3183099 * 
      (sign(x_102) * (1.570796 - (sqrt(
        (1.0 - abs(x_102))
      ) * (1.570796 + 
        (abs(x_102) * (-0.2146018 + (abs(x_102) * (0.08656672 + 
          (abs(x_102) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_97))
   / tmpvar_101), 0.0, 1.0), (float(
    (tmpvar_99 >= tmpvar_95)
  ) * clamp (tmpvar_97, 0.0, 1.0)));
  tmpvar_96 = tmpvar_103;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_65, tmpvar_76), min (tmpvar_86, tmpvar_96)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_104;
  tmpvar_104 = float((tmpvar_48 >= 0.0));
  tmpvar_3.w = (tmpvar_53 * tmpvar_104);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD4.xyz = vec3(t13) * t2.xyz;
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t1.x = t0.y * _ProjectionParams.x;
    t1.w = t1.x * 0.5;
    t1.xz = t0.xw * vec2(0.5, 0.5);
    t0.xy = t1.zz + t1.xw;
    vs_TEXCOORD6 = t0;
    vs_TEXCOORD8.xyw = t0.xyw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
mediump float t16_12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t6.xy = t10_1.xy * alphaMask1.xy;
    t6.x = t6.y + t6.x;
    t6.x = t10_1.z * alphaMask1.z + t6.x;
    t1.w = t10_1.w * alphaMask1.w + t6.x;
    t1.xyz = vec3(1.0, 1.0, 1.0);
    t1 = t1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t12.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t12.xy);
    t16_12 = t10_2.x + t10_2.x;
    t1.xyz = vec3(t16_12) * t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 380 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec4 v_17;
  v_17 = (texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw) * alphaMask1);
  vec4 tmpvar_18;
  tmpvar_18.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_18.w = ((v_17.x + v_17.y) + (v_17.z + v_17.w));
  vec2 uv_19;
  vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  float tmpvar_24;
  tmpvar_24 = sign(mix (tmpvar_20.y, mix (tmpvar_20.x, tmpvar_20.z, tmpvar_22), tmpvar_23));
  vec3 tmpvar_25;
  tmpvar_25.xz = vec2(1.0, -1.0);
  tmpvar_25.y = -(tmpvar_24);
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = tmpvar_24;
  vec3 tmpvar_27;
  tmpvar_27.xy = vec2(1.0, 1.0);
  tmpvar_27.z = tmpvar_24;
  vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_27 * tmpvar_20.yxz), mix ((tmpvar_25 * tmpvar_20.xzy), (tmpvar_26 * tmpvar_20.zxy), vec3(tmpvar_22)), vec3(tmpvar_23));
  uv_19 = (((
    (0.5 * tmpvar_28.yz)
   / 
    abs(tmpvar_28.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_29;
  vec2 tmpvar_30;
  tmpvar_30 = abs((uv_19 - (0.5 * _DetailScale)));
  uvCont_29.x = max (tmpvar_30.x, tmpvar_30.y);
  uvCont_29.y = min (tmpvar_30.x, tmpvar_30.y);
  vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_29);
  tmpvar_31.zw = dFdy(uvCont_29);
  vec3 tmpvar_32;
  tmpvar_32 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * tmpvar_18) * mix (texture2DGradARB (_DetailTex, uv_19, tmpvar_31.xy, tmpvar_31.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_32, tmpvar_32)))
  , 0.0, 1.0))));
  float tmpvar_33;
  tmpvar_33 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_34;
  tmpvar_34 = sqrt(dot (tmpvar_32, tmpvar_32));
  vec3 tmpvar_35;
  tmpvar_35 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_36;
  tmpvar_36 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_34), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_34)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_33, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_35, tmpvar_35)) - (_RimDistSub * sqrt(
      dot (tmpvar_36, tmpvar_36)
    ))))
  , 0.0, 1.0)));
  float tmpvar_37;
  tmpvar_37 = color_2.w;
  vec4 c_38;
  float tmpvar_39;
  tmpvar_39 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_38.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_39 * 2.0));
  c_38.w = (tmpvar_39 * 2.0);
  float tmpvar_40;
  tmpvar_40 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_38 * mix (1.0, clamp (
    floor((1.01 + tmpvar_40))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_40))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_37;
  vec4 v_41;
  v_41.x = _ShadowBodies[0].x;
  v_41.y = _ShadowBodies[1].x;
  v_41.z = _ShadowBodies[2].x;
  float tmpvar_42;
  tmpvar_42 = _ShadowBodies[3].x;
  v_41.w = tmpvar_42;
  vec3 tmpvar_43;
  tmpvar_43 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_44;
  tmpvar_44 = (3.141593 * (tmpvar_42 * tmpvar_42));
  vec3 tmpvar_45;
  tmpvar_45 = (v_41.xyz - xlv_TEXCOORD0);
  float tmpvar_46;
  tmpvar_46 = dot (tmpvar_45, normalize(tmpvar_43));
  float tmpvar_47;
  tmpvar_47 = (_SunRadius * (tmpvar_46 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_48;
  tmpvar_48 = (3.141593 * (tmpvar_47 * tmpvar_47));
  float x_49;
  x_49 = ((2.0 * clamp (
    (((tmpvar_42 + tmpvar_47) - sqrt((
      dot (tmpvar_45, tmpvar_45)
     - 
      (tmpvar_46 * tmpvar_46)
    ))) / (2.0 * min (tmpvar_42, tmpvar_47)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_50;
  v_50.x = _ShadowBodies[0].y;
  v_50.y = _ShadowBodies[1].y;
  v_50.z = _ShadowBodies[2].y;
  float tmpvar_51;
  tmpvar_51 = _ShadowBodies[3].y;
  v_50.w = tmpvar_51;
  float tmpvar_52;
  tmpvar_52 = (3.141593 * (tmpvar_51 * tmpvar_51));
  vec3 tmpvar_53;
  tmpvar_53 = (v_50.xyz - xlv_TEXCOORD0);
  float tmpvar_54;
  tmpvar_54 = dot (tmpvar_53, normalize(tmpvar_43));
  float tmpvar_55;
  tmpvar_55 = (_SunRadius * (tmpvar_54 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_56;
  tmpvar_56 = (3.141593 * (tmpvar_55 * tmpvar_55));
  float x_57;
  x_57 = ((2.0 * clamp (
    (((tmpvar_51 + tmpvar_55) - sqrt((
      dot (tmpvar_53, tmpvar_53)
     - 
      (tmpvar_54 * tmpvar_54)
    ))) / (2.0 * min (tmpvar_51, tmpvar_55)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_58;
  v_58.x = _ShadowBodies[0].z;
  v_58.y = _ShadowBodies[1].z;
  v_58.z = _ShadowBodies[2].z;
  float tmpvar_59;
  tmpvar_59 = _ShadowBodies[3].z;
  v_58.w = tmpvar_59;
  float tmpvar_60;
  tmpvar_60 = (3.141593 * (tmpvar_59 * tmpvar_59));
  vec3 tmpvar_61;
  tmpvar_61 = (v_58.xyz - xlv_TEXCOORD0);
  float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, normalize(tmpvar_43));
  float tmpvar_63;
  tmpvar_63 = (_SunRadius * (tmpvar_62 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_63 * tmpvar_63));
  float x_65;
  x_65 = ((2.0 * clamp (
    (((tmpvar_59 + tmpvar_63) - sqrt((
      dot (tmpvar_61, tmpvar_61)
     - 
      (tmpvar_62 * tmpvar_62)
    ))) / (2.0 * min (tmpvar_59, tmpvar_63)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_66;
  v_66.x = _ShadowBodies[0].w;
  v_66.y = _ShadowBodies[1].w;
  v_66.z = _ShadowBodies[2].w;
  float tmpvar_67;
  tmpvar_67 = _ShadowBodies[3].w;
  v_66.w = tmpvar_67;
  float tmpvar_68;
  tmpvar_68 = (3.141593 * (tmpvar_67 * tmpvar_67));
  vec3 tmpvar_69;
  tmpvar_69 = (v_66.xyz - xlv_TEXCOORD0);
  float tmpvar_70;
  tmpvar_70 = dot (tmpvar_69, normalize(tmpvar_43));
  float tmpvar_71;
  tmpvar_71 = (_SunRadius * (tmpvar_70 / sqrt(
    dot (tmpvar_43, tmpvar_43)
  )));
  float tmpvar_72;
  tmpvar_72 = (3.141593 * (tmpvar_71 * tmpvar_71));
  float x_73;
  x_73 = ((2.0 * clamp (
    (((tmpvar_67 + tmpvar_71) - sqrt((
      dot (tmpvar_69, tmpvar_69)
     - 
      (tmpvar_70 * tmpvar_70)
    ))) / (2.0 * min (tmpvar_67, tmpvar_71)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_48 - 
      (((0.3183099 * (
        sign(x_49)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_49)
        )) * (1.570796 + (
          abs(x_49)
         * 
          (-0.2146018 + (abs(x_49) * (0.08656672 + (
            abs(x_49)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_44)
    ) / tmpvar_48), 0.0, 1.0), (float((tmpvar_46 >= tmpvar_42)) * clamp (tmpvar_44, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_56 - 
      (((0.3183099 * (
        sign(x_57)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_57)
        )) * (1.570796 + (
          abs(x_57)
         * 
          (-0.2146018 + (abs(x_57) * (0.08656672 + (
            abs(x_57)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_52)
    ) / tmpvar_56), 0.0, 1.0), (float((tmpvar_54 >= tmpvar_51)) * clamp (tmpvar_52, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_64 - 
      (((0.3183099 * (
        sign(x_65)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_65)
        )) * (1.570796 + (
          abs(x_65)
         * 
          (-0.2146018 + (abs(x_65) * (0.08656672 + (
            abs(x_65)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_60)
    ) / tmpvar_64), 0.0, 1.0), (float((tmpvar_62 >= tmpvar_59)) * clamp (tmpvar_60, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_72 - 
      (((0.3183099 * (
        sign(x_73)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_73)
        )) * (1.570796 + (
          abs(x_73)
         * 
          (-0.2146018 + (abs(x_73) * (0.08656672 + (
            abs(x_73)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_68)
    ) / tmpvar_72), 0.0, 1.0), (float((tmpvar_70 >= tmpvar_67)) * clamp (tmpvar_68, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_37 * float((tmpvar_33 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 37 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord8 o7
dp4 o0.z, c2, v0
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r0.z, r0.y, c19.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xzw, r0.xywz, c22.x
mov o0.xyw, r0
mov o7.w, r0.w
mad o7.xy, r1.z, c20.zwzw, r1.xwzw
dp4 r0.x, c14, v0
mov o7.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21

"
}
SubProgram "d3d11 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 380 math, 3 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec4 v_21;
  v_21 = (tmpvar_20 * alphaMask1);
  mediump vec4 tmpvar_22;
  tmpvar_22.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_22.w = ((v_21.x + v_21.y) + (v_21.z + v_21.w));
  mediump vec2 uv_23;
  mediump vec3 detailCoords_24;
  mediump float s_25;
  mediump float nylerp_26;
  mediump float zxlerp_27;
  highp vec3 tmpvar_28;
  tmpvar_28 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_28);
  highp float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  zxlerp_27 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  nylerp_26 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = mix (tmpvar_28.x, tmpvar_28.z, zxlerp_27);
  s_25 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = sign(mix (tmpvar_28.y, s_25, nylerp_26));
  s_25 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = -(s_25);
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = s_25;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_34 * tmpvar_28.xzy), (tmpvar_35 * tmpvar_28.zxy), vec3(zxlerp_27));
  detailCoords_24 = tmpvar_36;
  mediump vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = s_25;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_28.yxz), detailCoords_24, vec3(nylerp_26));
  detailCoords_24 = tmpvar_38;
  uv_23 = (((
    (0.5 * detailCoords_24.yz)
   / 
    abs(detailCoords_24.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_39;
  uv_39 = uv_23;
  highp vec2 uvCont_40;
  highp vec2 tmpvar_41;
  tmpvar_41 = abs((uv_39 - (0.5 * _DetailScale)));
  uvCont_40.x = max (tmpvar_41.x, tmpvar_41.y);
  uvCont_40.y = min (tmpvar_41.x, tmpvar_41.y);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_40);
  tmpvar_42.zw = dFdy(uvCont_40);
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (_DetailTex, uv_23, tmpvar_42.xy, tmpvar_42.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  highp vec3 tmpvar_45;
  tmpvar_45 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_45, tmpvar_45)
  )), 0.0, 1.0);
  tmpvar_46 = tmpvar_47;
  color_2 = ((_Color * tmpvar_22) * mix (tmpvar_44, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_46)));
  highp float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_49;
  tmpvar_49 = sqrt(dot (tmpvar_45, tmpvar_45));
  highp vec3 tmpvar_50;
  tmpvar_50 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_51;
  tmpvar_51 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_52;
  tmpvar_52 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_49), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_49)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_48, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_50, tmpvar_50)) - (_RimDistSub * sqrt(
      dot (tmpvar_51, tmpvar_51)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = color_2.w;
  mediump vec3 normal_54;
  normal_54 = xlv_TEXCOORD4;
  mediump vec4 c_55;
  mediump vec3 tmpvar_56;
  tmpvar_56 = normalize(normal_54);
  normal_54 = tmpvar_56;
  mediump float tmpvar_57;
  tmpvar_57 = dot (tmpvar_56, normalize(_WorldSpaceLightPos0.xyz));
  c_55.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_57 * 2.0));
  c_55.w = (tmpvar_57 * 2.0);
  mediump vec3 normal_58;
  normal_58 = xlv_TEXCOORD4;
  mediump float tmpvar_59;
  tmpvar_59 = dot (normal_58, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_55 * mix (1.0, clamp (
    floor((1.01 + tmpvar_59))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_59))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_53;
  highp vec4 v_60;
  v_60.x = _ShadowBodies[0].x;
  v_60.y = _ShadowBodies[1].x;
  v_60.z = _ShadowBodies[2].x;
  highp float tmpvar_61;
  tmpvar_61 = _ShadowBodies[3].x;
  v_60.w = tmpvar_61;
  mediump float tmpvar_62;
  highp vec3 tmpvar_63;
  tmpvar_63 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_61 * tmpvar_61));
  highp vec3 tmpvar_65;
  tmpvar_65 = (v_60.xyz - xlv_TEXCOORD0);
  highp float tmpvar_66;
  tmpvar_66 = dot (tmpvar_65, normalize(tmpvar_63));
  highp float tmpvar_67;
  tmpvar_67 = (_SunRadius * (tmpvar_66 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_68;
  tmpvar_68 = (3.141593 * (tmpvar_67 * tmpvar_67));
  highp float x_69;
  x_69 = ((2.0 * clamp (
    (((tmpvar_61 + tmpvar_67) - sqrt((
      dot (tmpvar_65, tmpvar_65)
     - 
      (tmpvar_66 * tmpvar_66)
    ))) / (2.0 * min (tmpvar_61, tmpvar_67)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_70;
  tmpvar_70 = mix (1.0, clamp ((
    (tmpvar_68 - (((0.3183099 * 
      (sign(x_69) * (1.570796 - (sqrt(
        (1.0 - abs(x_69))
      ) * (1.570796 + 
        (abs(x_69) * (-0.2146018 + (abs(x_69) * (0.08656672 + 
          (abs(x_69) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_64))
   / tmpvar_68), 0.0, 1.0), (float(
    (tmpvar_66 >= tmpvar_61)
  ) * clamp (tmpvar_64, 0.0, 1.0)));
  tmpvar_62 = tmpvar_70;
  highp vec4 v_71;
  v_71.x = _ShadowBodies[0].y;
  v_71.y = _ShadowBodies[1].y;
  v_71.z = _ShadowBodies[2].y;
  highp float tmpvar_72;
  tmpvar_72 = _ShadowBodies[3].y;
  v_71.w = tmpvar_72;
  mediump float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = (3.141593 * (tmpvar_72 * tmpvar_72));
  highp vec3 tmpvar_75;
  tmpvar_75 = (v_71.xyz - xlv_TEXCOORD0);
  highp float tmpvar_76;
  tmpvar_76 = dot (tmpvar_75, normalize(tmpvar_63));
  highp float tmpvar_77;
  tmpvar_77 = (_SunRadius * (tmpvar_76 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_78;
  tmpvar_78 = (3.141593 * (tmpvar_77 * tmpvar_77));
  highp float x_79;
  x_79 = ((2.0 * clamp (
    (((tmpvar_72 + tmpvar_77) - sqrt((
      dot (tmpvar_75, tmpvar_75)
     - 
      (tmpvar_76 * tmpvar_76)
    ))) / (2.0 * min (tmpvar_72, tmpvar_77)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_80;
  tmpvar_80 = mix (1.0, clamp ((
    (tmpvar_78 - (((0.3183099 * 
      (sign(x_79) * (1.570796 - (sqrt(
        (1.0 - abs(x_79))
      ) * (1.570796 + 
        (abs(x_79) * (-0.2146018 + (abs(x_79) * (0.08656672 + 
          (abs(x_79) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_74))
   / tmpvar_78), 0.0, 1.0), (float(
    (tmpvar_76 >= tmpvar_72)
  ) * clamp (tmpvar_74, 0.0, 1.0)));
  tmpvar_73 = tmpvar_80;
  highp vec4 v_81;
  v_81.x = _ShadowBodies[0].z;
  v_81.y = _ShadowBodies[1].z;
  v_81.z = _ShadowBodies[2].z;
  highp float tmpvar_82;
  tmpvar_82 = _ShadowBodies[3].z;
  v_81.w = tmpvar_82;
  mediump float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = (3.141593 * (tmpvar_82 * tmpvar_82));
  highp vec3 tmpvar_85;
  tmpvar_85 = (v_81.xyz - xlv_TEXCOORD0);
  highp float tmpvar_86;
  tmpvar_86 = dot (tmpvar_85, normalize(tmpvar_63));
  highp float tmpvar_87;
  tmpvar_87 = (_SunRadius * (tmpvar_86 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_88;
  tmpvar_88 = (3.141593 * (tmpvar_87 * tmpvar_87));
  highp float x_89;
  x_89 = ((2.0 * clamp (
    (((tmpvar_82 + tmpvar_87) - sqrt((
      dot (tmpvar_85, tmpvar_85)
     - 
      (tmpvar_86 * tmpvar_86)
    ))) / (2.0 * min (tmpvar_82, tmpvar_87)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_90;
  tmpvar_90 = mix (1.0, clamp ((
    (tmpvar_88 - (((0.3183099 * 
      (sign(x_89) * (1.570796 - (sqrt(
        (1.0 - abs(x_89))
      ) * (1.570796 + 
        (abs(x_89) * (-0.2146018 + (abs(x_89) * (0.08656672 + 
          (abs(x_89) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_84))
   / tmpvar_88), 0.0, 1.0), (float(
    (tmpvar_86 >= tmpvar_82)
  ) * clamp (tmpvar_84, 0.0, 1.0)));
  tmpvar_83 = tmpvar_90;
  highp vec4 v_91;
  v_91.x = _ShadowBodies[0].w;
  v_91.y = _ShadowBodies[1].w;
  v_91.z = _ShadowBodies[2].w;
  highp float tmpvar_92;
  tmpvar_92 = _ShadowBodies[3].w;
  v_91.w = tmpvar_92;
  mediump float tmpvar_93;
  highp float tmpvar_94;
  tmpvar_94 = (3.141593 * (tmpvar_92 * tmpvar_92));
  highp vec3 tmpvar_95;
  tmpvar_95 = (v_91.xyz - xlv_TEXCOORD0);
  highp float tmpvar_96;
  tmpvar_96 = dot (tmpvar_95, normalize(tmpvar_63));
  highp float tmpvar_97;
  tmpvar_97 = (_SunRadius * (tmpvar_96 / sqrt(
    dot (tmpvar_63, tmpvar_63)
  )));
  highp float tmpvar_98;
  tmpvar_98 = (3.141593 * (tmpvar_97 * tmpvar_97));
  highp float x_99;
  x_99 = ((2.0 * clamp (
    (((tmpvar_92 + tmpvar_97) - sqrt((
      dot (tmpvar_95, tmpvar_95)
     - 
      (tmpvar_96 * tmpvar_96)
    ))) / (2.0 * min (tmpvar_92, tmpvar_97)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_100;
  tmpvar_100 = mix (1.0, clamp ((
    (tmpvar_98 - (((0.3183099 * 
      (sign(x_99) * (1.570796 - (sqrt(
        (1.0 - abs(x_99))
      ) * (1.570796 + 
        (abs(x_99) * (-0.2146018 + (abs(x_99) * (0.08656672 + 
          (abs(x_99) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_94))
   / tmpvar_98), 0.0, 1.0), (float(
    (tmpvar_96 >= tmpvar_92)
  ) * clamp (tmpvar_94, 0.0, 1.0)));
  tmpvar_93 = tmpvar_100;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_62, tmpvar_73), min (tmpvar_83, tmpvar_93)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_101;
  tmpvar_101 = float((tmpvar_48 >= 0.0));
  tmpvar_3.w = (tmpvar_53 * tmpvar_101);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_13.xy = t10_0.xy * alphaMask1.xy;
    t16_13.x = t16_13.y + t16_13.x;
    t16_13.x = t10_0.z * alphaMask1.z + t16_13.x;
    t16_0.w = t10_0.w * alphaMask1.w + t16_13.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    t16_11.xyz = t16_11.xyz + t16_11.xyz;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 15 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  float4 tmpvar_3;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_4;
  tmpvar_4 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_5;
  float4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  float2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _mtl_u._ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_4.xyz));
  _mtl_o.xlv_TEXCOORD8 = tmpvar_3;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t6.xy = t10_1.xy * alphaMask1.xy;
    t6.x = t6.y + t6.x;
    t6.x = t10_1.z * alphaMask1.z + t6.x;
    t1.w = t10_1.w * alphaMask1.w + t6.x;
    t1.xyz = vec3(1.0, 1.0, 1.0);
    t1 = t1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t1.xyz = t1.xyz + t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 382 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD6 = o_8;
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec2 uv_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  uv_4 = (uv_6 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_15;
  uvCont_15.y = uv_4.y;
  uvCont_15.x = abs((uv_4.x - 0.5));
  vec4 tmpvar_16;
  tmpvar_16.xy = dFdx(uvCont_15);
  tmpvar_16.zw = dFdy(uvCont_15);
  vec4 v_17;
  v_17 = (texture2DGradARB (_MainTex, uv_4, tmpvar_16.xy, tmpvar_16.zw) * alphaMask1);
  vec4 tmpvar_18;
  tmpvar_18.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_18.w = ((v_17.x + v_17.y) + (v_17.z + v_17.w));
  vec2 uv_19;
  vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  float tmpvar_24;
  tmpvar_24 = sign(mix (tmpvar_20.y, mix (tmpvar_20.x, tmpvar_20.z, tmpvar_22), tmpvar_23));
  vec3 tmpvar_25;
  tmpvar_25.xz = vec2(1.0, -1.0);
  tmpvar_25.y = -(tmpvar_24);
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = tmpvar_24;
  vec3 tmpvar_27;
  tmpvar_27.xy = vec2(1.0, 1.0);
  tmpvar_27.z = tmpvar_24;
  vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_27 * tmpvar_20.yxz), mix ((tmpvar_25 * tmpvar_20.xzy), (tmpvar_26 * tmpvar_20.zxy), vec3(tmpvar_22)), vec3(tmpvar_23));
  uv_19 = (((
    (0.5 * tmpvar_28.yz)
   / 
    abs(tmpvar_28.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_29;
  vec2 tmpvar_30;
  tmpvar_30 = abs((uv_19 - (0.5 * _DetailScale)));
  uvCont_29.x = max (tmpvar_30.x, tmpvar_30.y);
  uvCont_29.y = min (tmpvar_30.x, tmpvar_30.y);
  vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_29);
  tmpvar_31.zw = dFdy(uvCont_29);
  vec3 tmpvar_32;
  tmpvar_32 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * tmpvar_18) * mix (texture2DGradARB (_DetailTex, uv_19, tmpvar_31.xy, tmpvar_31.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_32, tmpvar_32)))
  , 0.0, 1.0))));
  float tmpvar_33;
  tmpvar_33 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_34;
  tmpvar_34 = sqrt(dot (tmpvar_32, tmpvar_32));
  vec3 tmpvar_35;
  tmpvar_35 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_36;
  tmpvar_36 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_34), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_34)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_33, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_35, tmpvar_35)) - (_RimDistSub * sqrt(
      dot (tmpvar_36, tmpvar_36)
    ))))
  , 0.0, 1.0)));
  float tmpvar_37;
  tmpvar_37 = color_2.w;
  vec4 tmpvar_38;
  tmpvar_38 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_39;
  float tmpvar_40;
  tmpvar_40 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_39.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_40)) * (tmpvar_38.x * 2.0));
  c_39.w = (tmpvar_40 * (tmpvar_38.x * 2.0));
  float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_39 * mix (1.0, clamp (
    floor((1.01 + tmpvar_41))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_41))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_37;
  vec4 v_42;
  v_42.x = _ShadowBodies[0].x;
  v_42.y = _ShadowBodies[1].x;
  v_42.z = _ShadowBodies[2].x;
  float tmpvar_43;
  tmpvar_43 = _ShadowBodies[3].x;
  v_42.w = tmpvar_43;
  vec3 tmpvar_44;
  tmpvar_44 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_45;
  tmpvar_45 = (3.141593 * (tmpvar_43 * tmpvar_43));
  vec3 tmpvar_46;
  tmpvar_46 = (v_42.xyz - xlv_TEXCOORD0);
  float tmpvar_47;
  tmpvar_47 = dot (tmpvar_46, normalize(tmpvar_44));
  float tmpvar_48;
  tmpvar_48 = (_SunRadius * (tmpvar_47 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_49;
  tmpvar_49 = (3.141593 * (tmpvar_48 * tmpvar_48));
  float x_50;
  x_50 = ((2.0 * clamp (
    (((tmpvar_43 + tmpvar_48) - sqrt((
      dot (tmpvar_46, tmpvar_46)
     - 
      (tmpvar_47 * tmpvar_47)
    ))) / (2.0 * min (tmpvar_43, tmpvar_48)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_51;
  v_51.x = _ShadowBodies[0].y;
  v_51.y = _ShadowBodies[1].y;
  v_51.z = _ShadowBodies[2].y;
  float tmpvar_52;
  tmpvar_52 = _ShadowBodies[3].y;
  v_51.w = tmpvar_52;
  float tmpvar_53;
  tmpvar_53 = (3.141593 * (tmpvar_52 * tmpvar_52));
  vec3 tmpvar_54;
  tmpvar_54 = (v_51.xyz - xlv_TEXCOORD0);
  float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, normalize(tmpvar_44));
  float tmpvar_56;
  tmpvar_56 = (_SunRadius * (tmpvar_55 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_57;
  tmpvar_57 = (3.141593 * (tmpvar_56 * tmpvar_56));
  float x_58;
  x_58 = ((2.0 * clamp (
    (((tmpvar_52 + tmpvar_56) - sqrt((
      dot (tmpvar_54, tmpvar_54)
     - 
      (tmpvar_55 * tmpvar_55)
    ))) / (2.0 * min (tmpvar_52, tmpvar_56)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_59;
  v_59.x = _ShadowBodies[0].z;
  v_59.y = _ShadowBodies[1].z;
  v_59.z = _ShadowBodies[2].z;
  float tmpvar_60;
  tmpvar_60 = _ShadowBodies[3].z;
  v_59.w = tmpvar_60;
  float tmpvar_61;
  tmpvar_61 = (3.141593 * (tmpvar_60 * tmpvar_60));
  vec3 tmpvar_62;
  tmpvar_62 = (v_59.xyz - xlv_TEXCOORD0);
  float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, normalize(tmpvar_44));
  float tmpvar_64;
  tmpvar_64 = (_SunRadius * (tmpvar_63 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_65;
  tmpvar_65 = (3.141593 * (tmpvar_64 * tmpvar_64));
  float x_66;
  x_66 = ((2.0 * clamp (
    (((tmpvar_60 + tmpvar_64) - sqrt((
      dot (tmpvar_62, tmpvar_62)
     - 
      (tmpvar_63 * tmpvar_63)
    ))) / (2.0 * min (tmpvar_60, tmpvar_64)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_67;
  v_67.x = _ShadowBodies[0].w;
  v_67.y = _ShadowBodies[1].w;
  v_67.z = _ShadowBodies[2].w;
  float tmpvar_68;
  tmpvar_68 = _ShadowBodies[3].w;
  v_67.w = tmpvar_68;
  float tmpvar_69;
  tmpvar_69 = (3.141593 * (tmpvar_68 * tmpvar_68));
  vec3 tmpvar_70;
  tmpvar_70 = (v_67.xyz - xlv_TEXCOORD0);
  float tmpvar_71;
  tmpvar_71 = dot (tmpvar_70, normalize(tmpvar_44));
  float tmpvar_72;
  tmpvar_72 = (_SunRadius * (tmpvar_71 / sqrt(
    dot (tmpvar_44, tmpvar_44)
  )));
  float tmpvar_73;
  tmpvar_73 = (3.141593 * (tmpvar_72 * tmpvar_72));
  float x_74;
  x_74 = ((2.0 * clamp (
    (((tmpvar_68 + tmpvar_72) - sqrt((
      dot (tmpvar_70, tmpvar_70)
     - 
      (tmpvar_71 * tmpvar_71)
    ))) / (2.0 * min (tmpvar_68, tmpvar_72)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_49 - 
      (((0.3183099 * (
        sign(x_50)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_50)
        )) * (1.570796 + (
          abs(x_50)
         * 
          (-0.2146018 + (abs(x_50) * (0.08656672 + (
            abs(x_50)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_45)
    ) / tmpvar_49), 0.0, 1.0), (float((tmpvar_47 >= tmpvar_43)) * clamp (tmpvar_45, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_57 - 
      (((0.3183099 * (
        sign(x_58)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_58)
        )) * (1.570796 + (
          abs(x_58)
         * 
          (-0.2146018 + (abs(x_58) * (0.08656672 + (
            abs(x_58)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_53)
    ) / tmpvar_57), 0.0, 1.0), (float((tmpvar_55 >= tmpvar_52)) * clamp (tmpvar_53, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_65 - 
      (((0.3183099 * (
        sign(x_66)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_66)
        )) * (1.570796 + (
          abs(x_66)
         * 
          (-0.2146018 + (abs(x_66) * (0.08656672 + (
            abs(x_66)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_61)
    ) / tmpvar_65), 0.0, 1.0), (float((tmpvar_63 >= tmpvar_60)) * clamp (tmpvar_61, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_73 - 
      (((0.3183099 * (
        sign(x_74)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_74)
        )) * (1.570796 + (
          abs(x_74)
         * 
          (-0.2146018 + (abs(x_74) * (0.08656672 + (
            abs(x_74)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_69)
    ) / tmpvar_73), 0.0, 1.0), (float((tmpvar_71 >= tmpvar_68)) * clamp (tmpvar_69, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_37 * float((tmpvar_33 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord6 o7
dcl_texcoord8 o8
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.x, c14, v0
mov o8.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21
dp4 r0.x, c0, v0
dp4 r0.y, c1, v0
dp4 r0.z, c2, v0
dp4 r0.w, c3, v0
mov o0, r0
mul r1.xz, r0.xyww, c22.x
mul r1.y, r0.y, c19.x
mul r1.w, r1.y, c22.x
mad r0.xy, r1.z, c20.zwzw, r1.xwzw
mov o7, r0
mov o8.xyw, r0

"
}
SubProgram "d3d11 " {
// Stats: 34 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 386 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec4 v_21;
  v_21 = (tmpvar_20 * alphaMask1);
  mediump vec4 tmpvar_22;
  tmpvar_22.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_22.w = ((v_21.x + v_21.y) + (v_21.z + v_21.w));
  mediump vec2 uv_23;
  mediump vec3 detailCoords_24;
  mediump float s_25;
  mediump float nylerp_26;
  mediump float zxlerp_27;
  highp vec3 tmpvar_28;
  tmpvar_28 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_28);
  highp float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  zxlerp_27 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  nylerp_26 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = mix (tmpvar_28.x, tmpvar_28.z, zxlerp_27);
  s_25 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = sign(mix (tmpvar_28.y, s_25, nylerp_26));
  s_25 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = -(s_25);
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = s_25;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_34 * tmpvar_28.xzy), (tmpvar_35 * tmpvar_28.zxy), vec3(zxlerp_27));
  detailCoords_24 = tmpvar_36;
  mediump vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = s_25;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_28.yxz), detailCoords_24, vec3(nylerp_26));
  detailCoords_24 = tmpvar_38;
  uv_23 = (((
    (0.5 * detailCoords_24.yz)
   / 
    abs(detailCoords_24.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_39;
  uv_39 = uv_23;
  highp vec2 uvCont_40;
  highp vec2 tmpvar_41;
  tmpvar_41 = abs((uv_39 - (0.5 * _DetailScale)));
  uvCont_40.x = max (tmpvar_41.x, tmpvar_41.y);
  uvCont_40.y = min (tmpvar_41.x, tmpvar_41.y);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_40);
  tmpvar_42.zw = dFdy(uvCont_40);
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (_DetailTex, uv_23, tmpvar_42.xy, tmpvar_42.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  highp vec3 tmpvar_45;
  tmpvar_45 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_45, tmpvar_45)
  )), 0.0, 1.0);
  tmpvar_46 = tmpvar_47;
  color_2 = ((_Color * tmpvar_22) * mix (tmpvar_44, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_46)));
  highp float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_49;
  tmpvar_49 = sqrt(dot (tmpvar_45, tmpvar_45));
  highp vec3 tmpvar_50;
  tmpvar_50 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_51;
  tmpvar_51 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_52;
  tmpvar_52 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_49), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_49)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_48, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_50, tmpvar_50)) - (_RimDistSub * sqrt(
      dot (tmpvar_51, tmpvar_51)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = color_2.w;
  lowp float tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_54 = tmpvar_55;
  mediump vec3 normal_56;
  normal_56 = xlv_TEXCOORD4;
  mediump float atten_57;
  atten_57 = tmpvar_54;
  mediump vec4 c_58;
  mediump vec3 tmpvar_59;
  tmpvar_59 = normalize(normal_56);
  normal_56 = tmpvar_59;
  mediump float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, normalize(_WorldSpaceLightPos0.xyz));
  c_58.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_60)) * (atten_57 * 2.0));
  c_58.w = (tmpvar_60 * (atten_57 * 2.0));
  mediump vec3 normal_61;
  normal_61 = xlv_TEXCOORD4;
  mediump float tmpvar_62;
  tmpvar_62 = dot (normal_61, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_58 * mix (1.0, clamp (
    floor((1.01 + tmpvar_62))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_62))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_53;
  highp vec4 v_63;
  v_63.x = _ShadowBodies[0].x;
  v_63.y = _ShadowBodies[1].x;
  v_63.z = _ShadowBodies[2].x;
  highp float tmpvar_64;
  tmpvar_64 = _ShadowBodies[3].x;
  v_63.w = tmpvar_64;
  mediump float tmpvar_65;
  highp vec3 tmpvar_66;
  tmpvar_66 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_67;
  tmpvar_67 = (3.141593 * (tmpvar_64 * tmpvar_64));
  highp vec3 tmpvar_68;
  tmpvar_68 = (v_63.xyz - xlv_TEXCOORD0);
  highp float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, normalize(tmpvar_66));
  highp float tmpvar_70;
  tmpvar_70 = (_SunRadius * (tmpvar_69 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_71;
  tmpvar_71 = (3.141593 * (tmpvar_70 * tmpvar_70));
  highp float x_72;
  x_72 = ((2.0 * clamp (
    (((tmpvar_64 + tmpvar_70) - sqrt((
      dot (tmpvar_68, tmpvar_68)
     - 
      (tmpvar_69 * tmpvar_69)
    ))) / (2.0 * min (tmpvar_64, tmpvar_70)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_73;
  tmpvar_73 = mix (1.0, clamp ((
    (tmpvar_71 - (((0.3183099 * 
      (sign(x_72) * (1.570796 - (sqrt(
        (1.0 - abs(x_72))
      ) * (1.570796 + 
        (abs(x_72) * (-0.2146018 + (abs(x_72) * (0.08656672 + 
          (abs(x_72) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_67))
   / tmpvar_71), 0.0, 1.0), (float(
    (tmpvar_69 >= tmpvar_64)
  ) * clamp (tmpvar_67, 0.0, 1.0)));
  tmpvar_65 = tmpvar_73;
  highp vec4 v_74;
  v_74.x = _ShadowBodies[0].y;
  v_74.y = _ShadowBodies[1].y;
  v_74.z = _ShadowBodies[2].y;
  highp float tmpvar_75;
  tmpvar_75 = _ShadowBodies[3].y;
  v_74.w = tmpvar_75;
  mediump float tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = (3.141593 * (tmpvar_75 * tmpvar_75));
  highp vec3 tmpvar_78;
  tmpvar_78 = (v_74.xyz - xlv_TEXCOORD0);
  highp float tmpvar_79;
  tmpvar_79 = dot (tmpvar_78, normalize(tmpvar_66));
  highp float tmpvar_80;
  tmpvar_80 = (_SunRadius * (tmpvar_79 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_81;
  tmpvar_81 = (3.141593 * (tmpvar_80 * tmpvar_80));
  highp float x_82;
  x_82 = ((2.0 * clamp (
    (((tmpvar_75 + tmpvar_80) - sqrt((
      dot (tmpvar_78, tmpvar_78)
     - 
      (tmpvar_79 * tmpvar_79)
    ))) / (2.0 * min (tmpvar_75, tmpvar_80)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_83;
  tmpvar_83 = mix (1.0, clamp ((
    (tmpvar_81 - (((0.3183099 * 
      (sign(x_82) * (1.570796 - (sqrt(
        (1.0 - abs(x_82))
      ) * (1.570796 + 
        (abs(x_82) * (-0.2146018 + (abs(x_82) * (0.08656672 + 
          (abs(x_82) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_77))
   / tmpvar_81), 0.0, 1.0), (float(
    (tmpvar_79 >= tmpvar_75)
  ) * clamp (tmpvar_77, 0.0, 1.0)));
  tmpvar_76 = tmpvar_83;
  highp vec4 v_84;
  v_84.x = _ShadowBodies[0].z;
  v_84.y = _ShadowBodies[1].z;
  v_84.z = _ShadowBodies[2].z;
  highp float tmpvar_85;
  tmpvar_85 = _ShadowBodies[3].z;
  v_84.w = tmpvar_85;
  mediump float tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = (3.141593 * (tmpvar_85 * tmpvar_85));
  highp vec3 tmpvar_88;
  tmpvar_88 = (v_84.xyz - xlv_TEXCOORD0);
  highp float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, normalize(tmpvar_66));
  highp float tmpvar_90;
  tmpvar_90 = (_SunRadius * (tmpvar_89 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_91;
  tmpvar_91 = (3.141593 * (tmpvar_90 * tmpvar_90));
  highp float x_92;
  x_92 = ((2.0 * clamp (
    (((tmpvar_85 + tmpvar_90) - sqrt((
      dot (tmpvar_88, tmpvar_88)
     - 
      (tmpvar_89 * tmpvar_89)
    ))) / (2.0 * min (tmpvar_85, tmpvar_90)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_93;
  tmpvar_93 = mix (1.0, clamp ((
    (tmpvar_91 - (((0.3183099 * 
      (sign(x_92) * (1.570796 - (sqrt(
        (1.0 - abs(x_92))
      ) * (1.570796 + 
        (abs(x_92) * (-0.2146018 + (abs(x_92) * (0.08656672 + 
          (abs(x_92) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_87))
   / tmpvar_91), 0.0, 1.0), (float(
    (tmpvar_89 >= tmpvar_85)
  ) * clamp (tmpvar_87, 0.0, 1.0)));
  tmpvar_86 = tmpvar_93;
  highp vec4 v_94;
  v_94.x = _ShadowBodies[0].w;
  v_94.y = _ShadowBodies[1].w;
  v_94.z = _ShadowBodies[2].w;
  highp float tmpvar_95;
  tmpvar_95 = _ShadowBodies[3].w;
  v_94.w = tmpvar_95;
  mediump float tmpvar_96;
  highp float tmpvar_97;
  tmpvar_97 = (3.141593 * (tmpvar_95 * tmpvar_95));
  highp vec3 tmpvar_98;
  tmpvar_98 = (v_94.xyz - xlv_TEXCOORD0);
  highp float tmpvar_99;
  tmpvar_99 = dot (tmpvar_98, normalize(tmpvar_66));
  highp float tmpvar_100;
  tmpvar_100 = (_SunRadius * (tmpvar_99 / sqrt(
    dot (tmpvar_66, tmpvar_66)
  )));
  highp float tmpvar_101;
  tmpvar_101 = (3.141593 * (tmpvar_100 * tmpvar_100));
  highp float x_102;
  x_102 = ((2.0 * clamp (
    (((tmpvar_95 + tmpvar_100) - sqrt((
      dot (tmpvar_98, tmpvar_98)
     - 
      (tmpvar_99 * tmpvar_99)
    ))) / (2.0 * min (tmpvar_95, tmpvar_100)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_103;
  tmpvar_103 = mix (1.0, clamp ((
    (tmpvar_101 - (((0.3183099 * 
      (sign(x_102) * (1.570796 - (sqrt(
        (1.0 - abs(x_102))
      ) * (1.570796 + 
        (abs(x_102) * (-0.2146018 + (abs(x_102) * (0.08656672 + 
          (abs(x_102) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_97))
   / tmpvar_101), 0.0, 1.0), (float(
    (tmpvar_99 >= tmpvar_95)
  ) * clamp (tmpvar_97, 0.0, 1.0)));
  tmpvar_96 = tmpvar_103;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_65, tmpvar_76), min (tmpvar_86, tmpvar_96)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_104;
  tmpvar_104 = float((tmpvar_48 >= 0.0));
  tmpvar_3.w = (tmpvar_53 * tmpvar_104);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD4.xyz = vec3(t13) * t2.xyz;
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t1.x = t0.y * _ProjectionParams.x;
    t1.w = t1.x * 0.5;
    t1.xz = t0.xw * vec2(0.5, 0.5);
    t0.xy = t1.zz + t1.xw;
    vs_TEXCOORD6 = t0;
    vs_TEXCOORD8.xyw = t0.xyw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
mediump vec2 t16_6;
int ti6;
bool tb6;
float t7;
bvec2 tb7;
float t8;
float t9;
vec2 t12;
mediump float t16_12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
bool tb19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xzy;
    t1.x = max(abs(t6.y), abs(t6.x));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.y), abs(t6.x));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.y)<abs(t6.x);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.yzyy, (-t6.yzyy)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.y, t6.x);
    tb7.x = t7<(-t7);
    t6.x = max(t6.y, t6.x);
    tb6 = t6.x>=(-t6.x);
    ti6 = int(uint(tb6) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t6.x = (ti6 != 0) ? (-t1.x) : t1.x;
    t1.x = t6.x * 0.159154937 + 0.5;
    t6.x = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t6.x = t6.x * abs(t6.z) + -0.212114394;
    t6.x = t6.x * abs(t6.z) + 1.57072878;
    t12.x = -abs(t6.z) + 1.0;
    t12.x = sqrt(t12.x);
    t18 = t12.x * t6.x;
    t18 = t18 * -2.0 + 3.14159274;
    t18 = tb7.y ? t18 : float(0.0);
    t6.x = t6.x * t12.x + t18;
    t1.y = t6.x * 0.318309873;
    t6.xy = t1.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t6.xyxy, (-t6.xyxy)).xy;
    t6.xy = fract(abs(t6.xy));
    t6.x = (tb13.x) ? t6.x : (-t6.x);
    t6.y = (tb13.x) ? t6.y : (-t6.y);
    t6.xy = t6.xy * vec2(_UVNoiseScale);
    t6.xy = t6.xy / vec2(_UVNoiseScale);
    t6.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t6.xy;
    t10_2 = texture(_UVNoiseTex, t6.xy);
    t16_6.xy = t10_2.xy + vec2(-0.5, -0.5);
    t6.xy = t16_6.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t18 = t6.x + -0.5;
    t6.z = abs(t18);
    t1.xy = dFdx(t6.zy);
    t2.xy = dFdy(t6.zy);
    t10_1 = textureGrad(_MainTex, t6.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t6.xy = t10_1.xy * alphaMask1.xy;
    t6.x = t6.y + t6.x;
    t6.x = t10_1.z * alphaMask1.z + t6.x;
    t1.w = t10_1.w * alphaMask1.w + t6.x;
    t1.xyz = vec3(1.0, 1.0, 1.0);
    t1 = t1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t12.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t12.xy);
    t16_12 = t10_2.x + t10_2.x;
    t1.xyz = vec3(t16_12) * t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 385 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec4 v_21;
  v_21 = (tmpvar_20 * alphaMask1);
  mediump vec4 tmpvar_22;
  tmpvar_22.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_22.w = ((v_21.x + v_21.y) + (v_21.z + v_21.w));
  mediump vec2 uv_23;
  mediump vec3 detailCoords_24;
  mediump float s_25;
  mediump float nylerp_26;
  mediump float zxlerp_27;
  highp vec3 tmpvar_28;
  tmpvar_28 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_28);
  highp float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  zxlerp_27 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  nylerp_26 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = mix (tmpvar_28.x, tmpvar_28.z, zxlerp_27);
  s_25 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = sign(mix (tmpvar_28.y, s_25, nylerp_26));
  s_25 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = -(s_25);
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = s_25;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_34 * tmpvar_28.xzy), (tmpvar_35 * tmpvar_28.zxy), vec3(zxlerp_27));
  detailCoords_24 = tmpvar_36;
  mediump vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = s_25;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_28.yxz), detailCoords_24, vec3(nylerp_26));
  detailCoords_24 = tmpvar_38;
  uv_23 = (((
    (0.5 * detailCoords_24.yz)
   / 
    abs(detailCoords_24.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_39;
  uv_39 = uv_23;
  highp vec2 uvCont_40;
  highp vec2 tmpvar_41;
  tmpvar_41 = abs((uv_39 - (0.5 * _DetailScale)));
  uvCont_40.x = max (tmpvar_41.x, tmpvar_41.y);
  uvCont_40.y = min (tmpvar_41.x, tmpvar_41.y);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_40);
  tmpvar_42.zw = dFdy(uvCont_40);
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (_DetailTex, uv_23, tmpvar_42.xy, tmpvar_42.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  highp vec3 tmpvar_45;
  tmpvar_45 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_45, tmpvar_45)
  )), 0.0, 1.0);
  tmpvar_46 = tmpvar_47;
  color_2 = ((_Color * tmpvar_22) * mix (tmpvar_44, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_46)));
  highp float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_49;
  tmpvar_49 = sqrt(dot (tmpvar_45, tmpvar_45));
  highp vec3 tmpvar_50;
  tmpvar_50 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_51;
  tmpvar_51 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_52;
  tmpvar_52 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_49), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_49)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_48, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_50, tmpvar_50)) - (_RimDistSub * sqrt(
      dot (tmpvar_51, tmpvar_51)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = color_2.w;
  lowp float shadow_54;
  shadow_54 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 normal_55;
  normal_55 = xlv_TEXCOORD4;
  mediump float atten_56;
  atten_56 = shadow_54;
  mediump vec4 c_57;
  mediump vec3 tmpvar_58;
  tmpvar_58 = normalize(normal_55);
  normal_55 = tmpvar_58;
  mediump float tmpvar_59;
  tmpvar_59 = dot (tmpvar_58, normalize(_WorldSpaceLightPos0.xyz));
  c_57.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_59)) * (atten_56 * 2.0));
  c_57.w = (tmpvar_59 * (atten_56 * 2.0));
  mediump vec3 normal_60;
  normal_60 = xlv_TEXCOORD4;
  mediump float tmpvar_61;
  tmpvar_61 = dot (normal_60, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_57 * mix (1.0, clamp (
    floor((1.01 + tmpvar_61))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_61))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_53;
  highp vec4 v_62;
  v_62.x = _ShadowBodies[0].x;
  v_62.y = _ShadowBodies[1].x;
  v_62.z = _ShadowBodies[2].x;
  highp float tmpvar_63;
  tmpvar_63 = _ShadowBodies[3].x;
  v_62.w = tmpvar_63;
  mediump float tmpvar_64;
  highp vec3 tmpvar_65;
  tmpvar_65 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_63 * tmpvar_63));
  highp vec3 tmpvar_67;
  tmpvar_67 = (v_62.xyz - xlv_TEXCOORD0);
  highp float tmpvar_68;
  tmpvar_68 = dot (tmpvar_67, normalize(tmpvar_65));
  highp float tmpvar_69;
  tmpvar_69 = (_SunRadius * (tmpvar_68 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_70;
  tmpvar_70 = (3.141593 * (tmpvar_69 * tmpvar_69));
  highp float x_71;
  x_71 = ((2.0 * clamp (
    (((tmpvar_63 + tmpvar_69) - sqrt((
      dot (tmpvar_67, tmpvar_67)
     - 
      (tmpvar_68 * tmpvar_68)
    ))) / (2.0 * min (tmpvar_63, tmpvar_69)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_72;
  tmpvar_72 = mix (1.0, clamp ((
    (tmpvar_70 - (((0.3183099 * 
      (sign(x_71) * (1.570796 - (sqrt(
        (1.0 - abs(x_71))
      ) * (1.570796 + 
        (abs(x_71) * (-0.2146018 + (abs(x_71) * (0.08656672 + 
          (abs(x_71) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_66))
   / tmpvar_70), 0.0, 1.0), (float(
    (tmpvar_68 >= tmpvar_63)
  ) * clamp (tmpvar_66, 0.0, 1.0)));
  tmpvar_64 = tmpvar_72;
  highp vec4 v_73;
  v_73.x = _ShadowBodies[0].y;
  v_73.y = _ShadowBodies[1].y;
  v_73.z = _ShadowBodies[2].y;
  highp float tmpvar_74;
  tmpvar_74 = _ShadowBodies[3].y;
  v_73.w = tmpvar_74;
  mediump float tmpvar_75;
  highp float tmpvar_76;
  tmpvar_76 = (3.141593 * (tmpvar_74 * tmpvar_74));
  highp vec3 tmpvar_77;
  tmpvar_77 = (v_73.xyz - xlv_TEXCOORD0);
  highp float tmpvar_78;
  tmpvar_78 = dot (tmpvar_77, normalize(tmpvar_65));
  highp float tmpvar_79;
  tmpvar_79 = (_SunRadius * (tmpvar_78 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_80;
  tmpvar_80 = (3.141593 * (tmpvar_79 * tmpvar_79));
  highp float x_81;
  x_81 = ((2.0 * clamp (
    (((tmpvar_74 + tmpvar_79) - sqrt((
      dot (tmpvar_77, tmpvar_77)
     - 
      (tmpvar_78 * tmpvar_78)
    ))) / (2.0 * min (tmpvar_74, tmpvar_79)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_82;
  tmpvar_82 = mix (1.0, clamp ((
    (tmpvar_80 - (((0.3183099 * 
      (sign(x_81) * (1.570796 - (sqrt(
        (1.0 - abs(x_81))
      ) * (1.570796 + 
        (abs(x_81) * (-0.2146018 + (abs(x_81) * (0.08656672 + 
          (abs(x_81) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_76))
   / tmpvar_80), 0.0, 1.0), (float(
    (tmpvar_78 >= tmpvar_74)
  ) * clamp (tmpvar_76, 0.0, 1.0)));
  tmpvar_75 = tmpvar_82;
  highp vec4 v_83;
  v_83.x = _ShadowBodies[0].z;
  v_83.y = _ShadowBodies[1].z;
  v_83.z = _ShadowBodies[2].z;
  highp float tmpvar_84;
  tmpvar_84 = _ShadowBodies[3].z;
  v_83.w = tmpvar_84;
  mediump float tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (3.141593 * (tmpvar_84 * tmpvar_84));
  highp vec3 tmpvar_87;
  tmpvar_87 = (v_83.xyz - xlv_TEXCOORD0);
  highp float tmpvar_88;
  tmpvar_88 = dot (tmpvar_87, normalize(tmpvar_65));
  highp float tmpvar_89;
  tmpvar_89 = (_SunRadius * (tmpvar_88 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_90;
  tmpvar_90 = (3.141593 * (tmpvar_89 * tmpvar_89));
  highp float x_91;
  x_91 = ((2.0 * clamp (
    (((tmpvar_84 + tmpvar_89) - sqrt((
      dot (tmpvar_87, tmpvar_87)
     - 
      (tmpvar_88 * tmpvar_88)
    ))) / (2.0 * min (tmpvar_84, tmpvar_89)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_92;
  tmpvar_92 = mix (1.0, clamp ((
    (tmpvar_90 - (((0.3183099 * 
      (sign(x_91) * (1.570796 - (sqrt(
        (1.0 - abs(x_91))
      ) * (1.570796 + 
        (abs(x_91) * (-0.2146018 + (abs(x_91) * (0.08656672 + 
          (abs(x_91) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_86))
   / tmpvar_90), 0.0, 1.0), (float(
    (tmpvar_88 >= tmpvar_84)
  ) * clamp (tmpvar_86, 0.0, 1.0)));
  tmpvar_85 = tmpvar_92;
  highp vec4 v_93;
  v_93.x = _ShadowBodies[0].w;
  v_93.y = _ShadowBodies[1].w;
  v_93.z = _ShadowBodies[2].w;
  highp float tmpvar_94;
  tmpvar_94 = _ShadowBodies[3].w;
  v_93.w = tmpvar_94;
  mediump float tmpvar_95;
  highp float tmpvar_96;
  tmpvar_96 = (3.141593 * (tmpvar_94 * tmpvar_94));
  highp vec3 tmpvar_97;
  tmpvar_97 = (v_93.xyz - xlv_TEXCOORD0);
  highp float tmpvar_98;
  tmpvar_98 = dot (tmpvar_97, normalize(tmpvar_65));
  highp float tmpvar_99;
  tmpvar_99 = (_SunRadius * (tmpvar_98 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_100;
  tmpvar_100 = (3.141593 * (tmpvar_99 * tmpvar_99));
  highp float x_101;
  x_101 = ((2.0 * clamp (
    (((tmpvar_94 + tmpvar_99) - sqrt((
      dot (tmpvar_97, tmpvar_97)
     - 
      (tmpvar_98 * tmpvar_98)
    ))) / (2.0 * min (tmpvar_94, tmpvar_99)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_102;
  tmpvar_102 = mix (1.0, clamp ((
    (tmpvar_100 - (((0.3183099 * 
      (sign(x_101) * (1.570796 - (sqrt(
        (1.0 - abs(x_101))
      ) * (1.570796 + 
        (abs(x_101) * (-0.2146018 + (abs(x_101) * (0.08656672 + 
          (abs(x_101) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_96))
   / tmpvar_100), 0.0, 1.0), (float(
    (tmpvar_98 >= tmpvar_94)
  ) * clamp (tmpvar_96, 0.0, 1.0)));
  tmpvar_95 = tmpvar_102;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_64, tmpvar_75), min (tmpvar_85, tmpvar_95)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_103;
  tmpvar_103 = float((tmpvar_48 >= 0.0));
  tmpvar_3.w = (tmpvar_53 * tmpvar_103);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD6 = t1;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_13.xy = t10_0.xy * alphaMask1.xy;
    t16_13.x = t16_13.y + t16_13.x;
    t16_13.x = t10_0.z * alphaMask1.z + t16_13.x;
    t16_0.w = t10_0.w * alphaMask1.w + t16_13.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    vec3 txVec96 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_13.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec96, 0.0);
    t16_21 = (-_LightShadowData.x) + 1.0;
    t16_13.x = t16_13.x * t16_21 + _LightShadowData.x;
    t16_13.x = t16_13.x + t16_13.x;
    t16_11.xyz = t16_11.xyz * t16_13.xxx;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 18 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  half4 tmpvar_3;
  float4 tmpvar_4;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_5;
  tmpvar_5 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_6;
  float4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  float2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _mtl_u._ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  float4 o_9;
  float4 tmpvar_10;
  tmpvar_10 = (tmpvar_1 * 0.5);
  float2 tmpvar_11;
  tmpvar_11.x = tmpvar_10.x;
  tmpvar_11.y = (tmpvar_10.y * _mtl_u._ProjectionParams.x);
  o_9.xy = (tmpvar_11 + tmpvar_10.w);
  o_9.zw = tmpvar_1.zw;
  tmpvar_3 = half4(o_9);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_5.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_5.xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD8 = tmpvar_4;
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 385 math, 4 textures, 5 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec2 uv_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  highp vec2 uv_6;
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  highp float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  uv_4 = uv_6;
  highp vec2 tmpvar_10;
  tmpvar_10 = (uv_6 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_11;
  tmpvar_11 = (fract(abs(tmpvar_10)) * vec2(_UVNoiseScale));
  highp float tmpvar_12;
  if ((tmpvar_10.x >= 0.0)) {
    tmpvar_12 = tmpvar_11.x;
  } else {
    tmpvar_12 = -(tmpvar_11.x);
  };
  highp float tmpvar_13;
  if ((tmpvar_10.y >= 0.0)) {
    tmpvar_13 = tmpvar_11.y;
  } else {
    tmpvar_13 = -(tmpvar_11.y);
  };
  highp vec2 tmpvar_14;
  tmpvar_14.x = tmpvar_12;
  tmpvar_14.y = tmpvar_13;
  highp vec2 tmpvar_15;
  tmpvar_15 = ((tmpvar_14 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_16;
  tmpvar_16 = texture2D (_UVNoiseTex, tmpvar_15);
  uv_4 = (uv_6 + ((tmpvar_16.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_17;
  uvCont_17.y = uv_4.y;
  uvCont_17.x = abs((uv_4.x - 0.5));
  highp vec4 tmpvar_18;
  tmpvar_18.xy = dFdx(uvCont_17);
  tmpvar_18.zw = dFdy(uvCont_17);
  lowp vec4 tmpvar_19;
  tmpvar_19 = texture2DGradEXT (_MainTex, uv_4, tmpvar_18.xy, tmpvar_18.zw);
  mediump vec4 tmpvar_20;
  tmpvar_20 = tmpvar_19;
  mediump vec4 v_21;
  v_21 = (tmpvar_20 * alphaMask1);
  mediump vec4 tmpvar_22;
  tmpvar_22.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_22.w = ((v_21.x + v_21.y) + (v_21.z + v_21.w));
  mediump vec2 uv_23;
  mediump vec3 detailCoords_24;
  mediump float s_25;
  mediump float nylerp_26;
  mediump float zxlerp_27;
  highp vec3 tmpvar_28;
  tmpvar_28 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_28);
  highp float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  zxlerp_27 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  nylerp_26 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = mix (tmpvar_28.x, tmpvar_28.z, zxlerp_27);
  s_25 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = sign(mix (tmpvar_28.y, s_25, nylerp_26));
  s_25 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = -(s_25);
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = s_25;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_34 * tmpvar_28.xzy), (tmpvar_35 * tmpvar_28.zxy), vec3(zxlerp_27));
  detailCoords_24 = tmpvar_36;
  mediump vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = s_25;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_28.yxz), detailCoords_24, vec3(nylerp_26));
  detailCoords_24 = tmpvar_38;
  uv_23 = (((
    (0.5 * detailCoords_24.yz)
   / 
    abs(detailCoords_24.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_39;
  uv_39 = uv_23;
  highp vec2 uvCont_40;
  highp vec2 tmpvar_41;
  tmpvar_41 = abs((uv_39 - (0.5 * _DetailScale)));
  uvCont_40.x = max (tmpvar_41.x, tmpvar_41.y);
  uvCont_40.y = min (tmpvar_41.x, tmpvar_41.y);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_40);
  tmpvar_42.zw = dFdy(uvCont_40);
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (_DetailTex, uv_23, tmpvar_42.xy, tmpvar_42.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  highp vec3 tmpvar_45;
  tmpvar_45 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_45, tmpvar_45)
  )), 0.0, 1.0);
  tmpvar_46 = tmpvar_47;
  color_2 = ((_Color * tmpvar_22) * mix (tmpvar_44, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_46)));
  highp float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_49;
  tmpvar_49 = sqrt(dot (tmpvar_45, tmpvar_45));
  highp vec3 tmpvar_50;
  tmpvar_50 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_51;
  tmpvar_51 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_52;
  tmpvar_52 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_49), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_49)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_48, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_50, tmpvar_50)) - (_RimDistSub * sqrt(
      dot (tmpvar_51, tmpvar_51)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = color_2.w;
  lowp float shadow_54;
  shadow_54 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 normal_55;
  normal_55 = xlv_TEXCOORD4;
  mediump float atten_56;
  atten_56 = shadow_54;
  mediump vec4 c_57;
  mediump vec3 tmpvar_58;
  tmpvar_58 = normalize(normal_55);
  normal_55 = tmpvar_58;
  mediump float tmpvar_59;
  tmpvar_59 = dot (tmpvar_58, normalize(_WorldSpaceLightPos0.xyz));
  c_57.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_59)) * (atten_56 * 2.0));
  c_57.w = (tmpvar_59 * (atten_56 * 2.0));
  mediump vec3 normal_60;
  normal_60 = xlv_TEXCOORD4;
  mediump float tmpvar_61;
  tmpvar_61 = dot (normal_60, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_57 * mix (1.0, clamp (
    floor((1.01 + tmpvar_61))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_61))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_53;
  highp vec4 v_62;
  v_62.x = _ShadowBodies[0].x;
  v_62.y = _ShadowBodies[1].x;
  v_62.z = _ShadowBodies[2].x;
  highp float tmpvar_63;
  tmpvar_63 = _ShadowBodies[3].x;
  v_62.w = tmpvar_63;
  mediump float tmpvar_64;
  highp vec3 tmpvar_65;
  tmpvar_65 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_63 * tmpvar_63));
  highp vec3 tmpvar_67;
  tmpvar_67 = (v_62.xyz - xlv_TEXCOORD0);
  highp float tmpvar_68;
  tmpvar_68 = dot (tmpvar_67, normalize(tmpvar_65));
  highp float tmpvar_69;
  tmpvar_69 = (_SunRadius * (tmpvar_68 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_70;
  tmpvar_70 = (3.141593 * (tmpvar_69 * tmpvar_69));
  highp float x_71;
  x_71 = ((2.0 * clamp (
    (((tmpvar_63 + tmpvar_69) - sqrt((
      dot (tmpvar_67, tmpvar_67)
     - 
      (tmpvar_68 * tmpvar_68)
    ))) / (2.0 * min (tmpvar_63, tmpvar_69)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_72;
  tmpvar_72 = mix (1.0, clamp ((
    (tmpvar_70 - (((0.3183099 * 
      (sign(x_71) * (1.570796 - (sqrt(
        (1.0 - abs(x_71))
      ) * (1.570796 + 
        (abs(x_71) * (-0.2146018 + (abs(x_71) * (0.08656672 + 
          (abs(x_71) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_66))
   / tmpvar_70), 0.0, 1.0), (float(
    (tmpvar_68 >= tmpvar_63)
  ) * clamp (tmpvar_66, 0.0, 1.0)));
  tmpvar_64 = tmpvar_72;
  highp vec4 v_73;
  v_73.x = _ShadowBodies[0].y;
  v_73.y = _ShadowBodies[1].y;
  v_73.z = _ShadowBodies[2].y;
  highp float tmpvar_74;
  tmpvar_74 = _ShadowBodies[3].y;
  v_73.w = tmpvar_74;
  mediump float tmpvar_75;
  highp float tmpvar_76;
  tmpvar_76 = (3.141593 * (tmpvar_74 * tmpvar_74));
  highp vec3 tmpvar_77;
  tmpvar_77 = (v_73.xyz - xlv_TEXCOORD0);
  highp float tmpvar_78;
  tmpvar_78 = dot (tmpvar_77, normalize(tmpvar_65));
  highp float tmpvar_79;
  tmpvar_79 = (_SunRadius * (tmpvar_78 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_80;
  tmpvar_80 = (3.141593 * (tmpvar_79 * tmpvar_79));
  highp float x_81;
  x_81 = ((2.0 * clamp (
    (((tmpvar_74 + tmpvar_79) - sqrt((
      dot (tmpvar_77, tmpvar_77)
     - 
      (tmpvar_78 * tmpvar_78)
    ))) / (2.0 * min (tmpvar_74, tmpvar_79)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_82;
  tmpvar_82 = mix (1.0, clamp ((
    (tmpvar_80 - (((0.3183099 * 
      (sign(x_81) * (1.570796 - (sqrt(
        (1.0 - abs(x_81))
      ) * (1.570796 + 
        (abs(x_81) * (-0.2146018 + (abs(x_81) * (0.08656672 + 
          (abs(x_81) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_76))
   / tmpvar_80), 0.0, 1.0), (float(
    (tmpvar_78 >= tmpvar_74)
  ) * clamp (tmpvar_76, 0.0, 1.0)));
  tmpvar_75 = tmpvar_82;
  highp vec4 v_83;
  v_83.x = _ShadowBodies[0].z;
  v_83.y = _ShadowBodies[1].z;
  v_83.z = _ShadowBodies[2].z;
  highp float tmpvar_84;
  tmpvar_84 = _ShadowBodies[3].z;
  v_83.w = tmpvar_84;
  mediump float tmpvar_85;
  highp float tmpvar_86;
  tmpvar_86 = (3.141593 * (tmpvar_84 * tmpvar_84));
  highp vec3 tmpvar_87;
  tmpvar_87 = (v_83.xyz - xlv_TEXCOORD0);
  highp float tmpvar_88;
  tmpvar_88 = dot (tmpvar_87, normalize(tmpvar_65));
  highp float tmpvar_89;
  tmpvar_89 = (_SunRadius * (tmpvar_88 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_90;
  tmpvar_90 = (3.141593 * (tmpvar_89 * tmpvar_89));
  highp float x_91;
  x_91 = ((2.0 * clamp (
    (((tmpvar_84 + tmpvar_89) - sqrt((
      dot (tmpvar_87, tmpvar_87)
     - 
      (tmpvar_88 * tmpvar_88)
    ))) / (2.0 * min (tmpvar_84, tmpvar_89)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_92;
  tmpvar_92 = mix (1.0, clamp ((
    (tmpvar_90 - (((0.3183099 * 
      (sign(x_91) * (1.570796 - (sqrt(
        (1.0 - abs(x_91))
      ) * (1.570796 + 
        (abs(x_91) * (-0.2146018 + (abs(x_91) * (0.08656672 + 
          (abs(x_91) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_86))
   / tmpvar_90), 0.0, 1.0), (float(
    (tmpvar_88 >= tmpvar_84)
  ) * clamp (tmpvar_86, 0.0, 1.0)));
  tmpvar_85 = tmpvar_92;
  highp vec4 v_93;
  v_93.x = _ShadowBodies[0].w;
  v_93.y = _ShadowBodies[1].w;
  v_93.z = _ShadowBodies[2].w;
  highp float tmpvar_94;
  tmpvar_94 = _ShadowBodies[3].w;
  v_93.w = tmpvar_94;
  mediump float tmpvar_95;
  highp float tmpvar_96;
  tmpvar_96 = (3.141593 * (tmpvar_94 * tmpvar_94));
  highp vec3 tmpvar_97;
  tmpvar_97 = (v_93.xyz - xlv_TEXCOORD0);
  highp float tmpvar_98;
  tmpvar_98 = dot (tmpvar_97, normalize(tmpvar_65));
  highp float tmpvar_99;
  tmpvar_99 = (_SunRadius * (tmpvar_98 / sqrt(
    dot (tmpvar_65, tmpvar_65)
  )));
  highp float tmpvar_100;
  tmpvar_100 = (3.141593 * (tmpvar_99 * tmpvar_99));
  highp float x_101;
  x_101 = ((2.0 * clamp (
    (((tmpvar_94 + tmpvar_99) - sqrt((
      dot (tmpvar_97, tmpvar_97)
     - 
      (tmpvar_98 * tmpvar_98)
    ))) / (2.0 * min (tmpvar_94, tmpvar_99)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_102;
  tmpvar_102 = mix (1.0, clamp ((
    (tmpvar_100 - (((0.3183099 * 
      (sign(x_101) * (1.570796 - (sqrt(
        (1.0 - abs(x_101))
      ) * (1.570796 + 
        (abs(x_101) * (-0.2146018 + (abs(x_101) * (0.08656672 + 
          (abs(x_101) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_96))
   / tmpvar_100), 0.0, 1.0), (float(
    (tmpvar_98 >= tmpvar_94)
  ) * clamp (tmpvar_96, 0.0, 1.0)));
  tmpvar_95 = tmpvar_102;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_64, tmpvar_75), min (tmpvar_85, tmpvar_95)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_103;
  tmpvar_103 = float((tmpvar_48 >= 0.0));
  tmpvar_3.w = (tmpvar_53 * tmpvar_103);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD6 = t1;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
bool tb16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16.x = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16.x + _ShadowBodies[3].x;
    t16.x = t16.x * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16.x, _ShadowBodies[3].x);
    t16.x = t16.x * t16.x;
    t16.x = t16.x * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16.x;
    t8 = t8 / t16.x;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16.x = dot(t4.xyz, t4.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16.x = t16.x / t2.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t2.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16.x) + -0.212114394;
    t2.x = t2.x * abs(t16.x) + 1.57072878;
    t3.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16.x = tb16 ? t11 : float(0.0);
    t16.x = t2.x * t3.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.y + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16.x = tb16 ? 1.0 : float(0.0);
    t16.x = t3.z * t16.x;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16.x * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16.x = dot(t2.xyz, t2.xyz);
    t16.x = (-t8) * t8 + t16.x;
    t16.x = sqrt(t16.x);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16.x = (-t16.x) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16.x = t16.x / t1.x;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x * 2.0 + -1.0;
    t1.x = abs(t16.x) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16.x) + -0.212114394;
    t1.x = t1.x * abs(t16.x) + 1.57072878;
    t9.x = -abs(t16.x) + 1.0;
    tb16 = t16.x<(-t16.x);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16.x = tb16 ? t17.x : float(0.0);
    t16.x = t1.x * t9.x + t16.x;
    t16.x = (-t16.x) + 1.57079637;
    t16.x = t16.x * 0.318309873 + 0.5;
    t16.x = (-t16.x) * t2.w + t24;
    t16.x = t16.x / t24;
    t16.x = clamp(t16.x, 0.0, 1.0);
    t16.x = t16.x + -1.0;
    t8 = t8 * t16.x + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(_UVNoiseScale);
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(_UVNoiseScale);
    t16.xy = t16.xy / vec2(_UVNoiseScale);
    t16.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_13.xy = t10_0.xy * alphaMask1.xy;
    t16_13.x = t16_13.y + t16_13.x;
    t16_13.x = t10_0.z * alphaMask1.z + t16_13.x;
    t16_0.w = t10_0.w * alphaMask1.w + t16_13.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    vec3 txVec94 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_13.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec94, 0.0);
    t16_21 = (-_LightShadowData.x) + 1.0;
    t16_13.x = t16_13.x * t16_21 + _LightShadowData.x;
    t16_13.x = t16_13.x + t16_13.x;
    t16_11.xyz = t16_11.xyz * t16_13.xxx;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 18 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  half4 tmpvar_3;
  float4 tmpvar_4;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_5;
  tmpvar_5 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_6;
  float4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  float2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _mtl_u._ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  float4 o_9;
  float4 tmpvar_10;
  tmpvar_10 = (tmpvar_1 * 0.5);
  float2 tmpvar_11;
  tmpvar_11.x = tmpvar_10.x;
  tmpvar_11.y = (tmpvar_10.y * _mtl_u._ProjectionParams.x);
  o_9.xy = (tmpvar_11 + tmpvar_10.w);
  o_9.zw = tmpvar_1.zw;
  tmpvar_3 = half4(o_9);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_5.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_5.xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD8 = tmpvar_4;
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 313 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec3 cubeVect_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  cubeVect_4.xy = (tmpvar_5.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uv_12;
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_13);
  float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  float tmpvar_17;
  tmpvar_17 = sign(mix (tmpvar_13.y, mix (tmpvar_13.x, tmpvar_13.z, tmpvar_15), tmpvar_16));
  vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = -(tmpvar_17);
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = tmpvar_17;
  vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = tmpvar_17;
  vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_13.yxz), mix ((tmpvar_18 * tmpvar_13.xzy), (tmpvar_19 * tmpvar_13.zxy), vec3(tmpvar_15)), vec3(tmpvar_16));
  uv_12 = (((
    (0.5 * tmpvar_21.yz)
   / 
    abs(tmpvar_21.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_22;
  vec2 tmpvar_23;
  tmpvar_23 = abs((uv_12 - (0.5 * _DetailScale)));
  uvCont_22.x = max (tmpvar_23.x, tmpvar_23.y);
  uvCont_22.y = min (tmpvar_23.x, tmpvar_23.y);
  vec4 tmpvar_24;
  tmpvar_24.xy = dFdx(uvCont_22);
  tmpvar_24.zw = dFdy(uvCont_22);
  vec3 tmpvar_25;
  tmpvar_25 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * textureCube (cube_MainTex, cubeVect_4)) * mix (texture2DGradARB (_DetailTex, uv_12, tmpvar_24.xy, tmpvar_24.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_25, tmpvar_25)))
  , 0.0, 1.0))));
  float tmpvar_26;
  tmpvar_26 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_27;
  tmpvar_27 = sqrt(dot (tmpvar_25, tmpvar_25));
  vec3 tmpvar_28;
  tmpvar_28 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_29;
  tmpvar_29 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_27), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_27)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_26, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_28, tmpvar_28)) - (_RimDistSub * sqrt(
      dot (tmpvar_29, tmpvar_29)
    ))))
  , 0.0, 1.0)));
  float tmpvar_30;
  tmpvar_30 = color_2.w;
  vec4 c_31;
  float tmpvar_32;
  tmpvar_32 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_31.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_32 * 2.0));
  c_31.w = (tmpvar_32 * 2.0);
  float tmpvar_33;
  tmpvar_33 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_31 * mix (1.0, clamp (
    floor((1.01 + tmpvar_33))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_33))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_30;
  vec4 v_34;
  v_34.x = _ShadowBodies[0].x;
  v_34.y = _ShadowBodies[1].x;
  v_34.z = _ShadowBodies[2].x;
  float tmpvar_35;
  tmpvar_35 = _ShadowBodies[3].x;
  v_34.w = tmpvar_35;
  vec3 tmpvar_36;
  tmpvar_36 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_37;
  tmpvar_37 = (3.141593 * (tmpvar_35 * tmpvar_35));
  vec3 tmpvar_38;
  tmpvar_38 = (v_34.xyz - xlv_TEXCOORD0);
  float tmpvar_39;
  tmpvar_39 = dot (tmpvar_38, normalize(tmpvar_36));
  float tmpvar_40;
  tmpvar_40 = (_SunRadius * (tmpvar_39 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_41;
  tmpvar_41 = (3.141593 * (tmpvar_40 * tmpvar_40));
  float x_42;
  x_42 = ((2.0 * clamp (
    (((tmpvar_35 + tmpvar_40) - sqrt((
      dot (tmpvar_38, tmpvar_38)
     - 
      (tmpvar_39 * tmpvar_39)
    ))) / (2.0 * min (tmpvar_35, tmpvar_40)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_43;
  v_43.x = _ShadowBodies[0].y;
  v_43.y = _ShadowBodies[1].y;
  v_43.z = _ShadowBodies[2].y;
  float tmpvar_44;
  tmpvar_44 = _ShadowBodies[3].y;
  v_43.w = tmpvar_44;
  float tmpvar_45;
  tmpvar_45 = (3.141593 * (tmpvar_44 * tmpvar_44));
  vec3 tmpvar_46;
  tmpvar_46 = (v_43.xyz - xlv_TEXCOORD0);
  float tmpvar_47;
  tmpvar_47 = dot (tmpvar_46, normalize(tmpvar_36));
  float tmpvar_48;
  tmpvar_48 = (_SunRadius * (tmpvar_47 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_49;
  tmpvar_49 = (3.141593 * (tmpvar_48 * tmpvar_48));
  float x_50;
  x_50 = ((2.0 * clamp (
    (((tmpvar_44 + tmpvar_48) - sqrt((
      dot (tmpvar_46, tmpvar_46)
     - 
      (tmpvar_47 * tmpvar_47)
    ))) / (2.0 * min (tmpvar_44, tmpvar_48)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_51;
  v_51.x = _ShadowBodies[0].z;
  v_51.y = _ShadowBodies[1].z;
  v_51.z = _ShadowBodies[2].z;
  float tmpvar_52;
  tmpvar_52 = _ShadowBodies[3].z;
  v_51.w = tmpvar_52;
  float tmpvar_53;
  tmpvar_53 = (3.141593 * (tmpvar_52 * tmpvar_52));
  vec3 tmpvar_54;
  tmpvar_54 = (v_51.xyz - xlv_TEXCOORD0);
  float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, normalize(tmpvar_36));
  float tmpvar_56;
  tmpvar_56 = (_SunRadius * (tmpvar_55 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_57;
  tmpvar_57 = (3.141593 * (tmpvar_56 * tmpvar_56));
  float x_58;
  x_58 = ((2.0 * clamp (
    (((tmpvar_52 + tmpvar_56) - sqrt((
      dot (tmpvar_54, tmpvar_54)
     - 
      (tmpvar_55 * tmpvar_55)
    ))) / (2.0 * min (tmpvar_52, tmpvar_56)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_59;
  v_59.x = _ShadowBodies[0].w;
  v_59.y = _ShadowBodies[1].w;
  v_59.z = _ShadowBodies[2].w;
  float tmpvar_60;
  tmpvar_60 = _ShadowBodies[3].w;
  v_59.w = tmpvar_60;
  float tmpvar_61;
  tmpvar_61 = (3.141593 * (tmpvar_60 * tmpvar_60));
  vec3 tmpvar_62;
  tmpvar_62 = (v_59.xyz - xlv_TEXCOORD0);
  float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, normalize(tmpvar_36));
  float tmpvar_64;
  tmpvar_64 = (_SunRadius * (tmpvar_63 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_65;
  tmpvar_65 = (3.141593 * (tmpvar_64 * tmpvar_64));
  float x_66;
  x_66 = ((2.0 * clamp (
    (((tmpvar_60 + tmpvar_64) - sqrt((
      dot (tmpvar_62, tmpvar_62)
     - 
      (tmpvar_63 * tmpvar_63)
    ))) / (2.0 * min (tmpvar_60, tmpvar_64)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_41 - 
      (((0.3183099 * (
        sign(x_42)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_42)
        )) * (1.570796 + (
          abs(x_42)
         * 
          (-0.2146018 + (abs(x_42) * (0.08656672 + (
            abs(x_42)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_37)
    ) / tmpvar_41), 0.0, 1.0), (float((tmpvar_39 >= tmpvar_35)) * clamp (tmpvar_37, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_49 - 
      (((0.3183099 * (
        sign(x_50)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_50)
        )) * (1.570796 + (
          abs(x_50)
         * 
          (-0.2146018 + (abs(x_50) * (0.08656672 + (
            abs(x_50)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_45)
    ) / tmpvar_49), 0.0, 1.0), (float((tmpvar_47 >= tmpvar_44)) * clamp (tmpvar_45, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_57 - 
      (((0.3183099 * (
        sign(x_58)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_58)
        )) * (1.570796 + (
          abs(x_58)
         * 
          (-0.2146018 + (abs(x_58) * (0.08656672 + (
            abs(x_58)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_53)
    ) / tmpvar_57), 0.0, 1.0), (float((tmpvar_55 >= tmpvar_52)) * clamp (tmpvar_53, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_65 - 
      (((0.3183099 * (
        sign(x_66)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_66)
        )) * (1.570796 + (
          abs(x_66)
         * 
          (-0.2146018 + (abs(x_66) * (0.08656672 + (
            abs(x_66)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_61)
    ) / tmpvar_65), 0.0, 1.0), (float((tmpvar_63 >= tmpvar_60)) * clamp (tmpvar_61, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_30 * float((tmpvar_26 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 37 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord8 o7
dp4 o0.z, c2, v0
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r0.z, r0.y, c19.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xzw, r0.xywz, c22.x
mov o0.xyw, r0
mov o7.w, r0.w
mad o7.xy, r1.z, c20.zwzw, r1.xwzw
dp4 r0.x, c14, v0
mov o7.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21

"
}
SubProgram "d3d11 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 313 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform lowp samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec3 cubeVect_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  highp float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec2 tmpvar_12;
  tmpvar_12 = ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_UVNoiseTex, tmpvar_12);
  cubeVect_4.xy = (tmpvar_5.xy + ((tmpvar_13.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureCube (cube_MainTex, cubeVect_4);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  mediump vec2 uv_16;
  mediump vec3 detailCoords_17;
  mediump float s_18;
  mediump float nylerp_19;
  mediump float zxlerp_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_21);
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  zxlerp_20 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  nylerp_19 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = mix (tmpvar_21.x, tmpvar_21.z, zxlerp_20);
  s_18 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = sign(mix (tmpvar_21.y, s_18, nylerp_19));
  s_18 = tmpvar_26;
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = -(s_18);
  mediump vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = s_18;
  highp vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_27 * tmpvar_21.xzy), (tmpvar_28 * tmpvar_21.zxy), vec3(zxlerp_20));
  detailCoords_17 = tmpvar_29;
  mediump vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = s_18;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_21.yxz), detailCoords_17, vec3(nylerp_19));
  detailCoords_17 = tmpvar_31;
  uv_16 = (((
    (0.5 * detailCoords_17.yz)
   / 
    abs(detailCoords_17.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_32;
  uv_32 = uv_16;
  highp vec2 uvCont_33;
  highp vec2 tmpvar_34;
  tmpvar_34 = abs((uv_32 - (0.5 * _DetailScale)));
  uvCont_33.x = max (tmpvar_34.x, tmpvar_34.y);
  uvCont_33.y = min (tmpvar_34.x, tmpvar_34.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_33);
  tmpvar_35.zw = dFdy(uvCont_33);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_DetailTex, uv_16, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  highp vec3 tmpvar_38;
  tmpvar_38 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_38, tmpvar_38)
  )), 0.0, 1.0);
  tmpvar_39 = tmpvar_40;
  color_2 = ((_Color * tmpvar_15) * mix (tmpvar_37, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_39)));
  highp float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_42;
  tmpvar_42 = sqrt(dot (tmpvar_38, tmpvar_38));
  highp vec3 tmpvar_43;
  tmpvar_43 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_44;
  tmpvar_44 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_45;
  tmpvar_45 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_42), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_42)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_41, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_43, tmpvar_43)) - (_RimDistSub * sqrt(
      dot (tmpvar_44, tmpvar_44)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_45;
  mediump float tmpvar_46;
  tmpvar_46 = color_2.w;
  mediump vec3 normal_47;
  normal_47 = xlv_TEXCOORD4;
  mediump vec4 c_48;
  mediump vec3 tmpvar_49;
  tmpvar_49 = normalize(normal_47);
  normal_47 = tmpvar_49;
  mediump float tmpvar_50;
  tmpvar_50 = dot (tmpvar_49, normalize(_WorldSpaceLightPos0.xyz));
  c_48.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_50 * 2.0));
  c_48.w = (tmpvar_50 * 2.0);
  mediump vec3 normal_51;
  normal_51 = xlv_TEXCOORD4;
  mediump float tmpvar_52;
  tmpvar_52 = dot (normal_51, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_48 * mix (1.0, clamp (
    floor((1.01 + tmpvar_52))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_52))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_46;
  highp vec4 v_53;
  v_53.x = _ShadowBodies[0].x;
  v_53.y = _ShadowBodies[1].x;
  v_53.z = _ShadowBodies[2].x;
  highp float tmpvar_54;
  tmpvar_54 = _ShadowBodies[3].x;
  v_53.w = tmpvar_54;
  mediump float tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_57;
  tmpvar_57 = (3.141593 * (tmpvar_54 * tmpvar_54));
  highp vec3 tmpvar_58;
  tmpvar_58 = (v_53.xyz - xlv_TEXCOORD0);
  highp float tmpvar_59;
  tmpvar_59 = dot (tmpvar_58, normalize(tmpvar_56));
  highp float tmpvar_60;
  tmpvar_60 = (_SunRadius * (tmpvar_59 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_61;
  tmpvar_61 = (3.141593 * (tmpvar_60 * tmpvar_60));
  highp float x_62;
  x_62 = ((2.0 * clamp (
    (((tmpvar_54 + tmpvar_60) - sqrt((
      dot (tmpvar_58, tmpvar_58)
     - 
      (tmpvar_59 * tmpvar_59)
    ))) / (2.0 * min (tmpvar_54, tmpvar_60)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_63;
  tmpvar_63 = mix (1.0, clamp ((
    (tmpvar_61 - (((0.3183099 * 
      (sign(x_62) * (1.570796 - (sqrt(
        (1.0 - abs(x_62))
      ) * (1.570796 + 
        (abs(x_62) * (-0.2146018 + (abs(x_62) * (0.08656672 + 
          (abs(x_62) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_57))
   / tmpvar_61), 0.0, 1.0), (float(
    (tmpvar_59 >= tmpvar_54)
  ) * clamp (tmpvar_57, 0.0, 1.0)));
  tmpvar_55 = tmpvar_63;
  highp vec4 v_64;
  v_64.x = _ShadowBodies[0].y;
  v_64.y = _ShadowBodies[1].y;
  v_64.z = _ShadowBodies[2].y;
  highp float tmpvar_65;
  tmpvar_65 = _ShadowBodies[3].y;
  v_64.w = tmpvar_65;
  mediump float tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = (3.141593 * (tmpvar_65 * tmpvar_65));
  highp vec3 tmpvar_68;
  tmpvar_68 = (v_64.xyz - xlv_TEXCOORD0);
  highp float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, normalize(tmpvar_56));
  highp float tmpvar_70;
  tmpvar_70 = (_SunRadius * (tmpvar_69 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_71;
  tmpvar_71 = (3.141593 * (tmpvar_70 * tmpvar_70));
  highp float x_72;
  x_72 = ((2.0 * clamp (
    (((tmpvar_65 + tmpvar_70) - sqrt((
      dot (tmpvar_68, tmpvar_68)
     - 
      (tmpvar_69 * tmpvar_69)
    ))) / (2.0 * min (tmpvar_65, tmpvar_70)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_73;
  tmpvar_73 = mix (1.0, clamp ((
    (tmpvar_71 - (((0.3183099 * 
      (sign(x_72) * (1.570796 - (sqrt(
        (1.0 - abs(x_72))
      ) * (1.570796 + 
        (abs(x_72) * (-0.2146018 + (abs(x_72) * (0.08656672 + 
          (abs(x_72) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_67))
   / tmpvar_71), 0.0, 1.0), (float(
    (tmpvar_69 >= tmpvar_65)
  ) * clamp (tmpvar_67, 0.0, 1.0)));
  tmpvar_66 = tmpvar_73;
  highp vec4 v_74;
  v_74.x = _ShadowBodies[0].z;
  v_74.y = _ShadowBodies[1].z;
  v_74.z = _ShadowBodies[2].z;
  highp float tmpvar_75;
  tmpvar_75 = _ShadowBodies[3].z;
  v_74.w = tmpvar_75;
  mediump float tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = (3.141593 * (tmpvar_75 * tmpvar_75));
  highp vec3 tmpvar_78;
  tmpvar_78 = (v_74.xyz - xlv_TEXCOORD0);
  highp float tmpvar_79;
  tmpvar_79 = dot (tmpvar_78, normalize(tmpvar_56));
  highp float tmpvar_80;
  tmpvar_80 = (_SunRadius * (tmpvar_79 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_81;
  tmpvar_81 = (3.141593 * (tmpvar_80 * tmpvar_80));
  highp float x_82;
  x_82 = ((2.0 * clamp (
    (((tmpvar_75 + tmpvar_80) - sqrt((
      dot (tmpvar_78, tmpvar_78)
     - 
      (tmpvar_79 * tmpvar_79)
    ))) / (2.0 * min (tmpvar_75, tmpvar_80)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_83;
  tmpvar_83 = mix (1.0, clamp ((
    (tmpvar_81 - (((0.3183099 * 
      (sign(x_82) * (1.570796 - (sqrt(
        (1.0 - abs(x_82))
      ) * (1.570796 + 
        (abs(x_82) * (-0.2146018 + (abs(x_82) * (0.08656672 + 
          (abs(x_82) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_77))
   / tmpvar_81), 0.0, 1.0), (float(
    (tmpvar_79 >= tmpvar_75)
  ) * clamp (tmpvar_77, 0.0, 1.0)));
  tmpvar_76 = tmpvar_83;
  highp vec4 v_84;
  v_84.x = _ShadowBodies[0].w;
  v_84.y = _ShadowBodies[1].w;
  v_84.z = _ShadowBodies[2].w;
  highp float tmpvar_85;
  tmpvar_85 = _ShadowBodies[3].w;
  v_84.w = tmpvar_85;
  mediump float tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = (3.141593 * (tmpvar_85 * tmpvar_85));
  highp vec3 tmpvar_88;
  tmpvar_88 = (v_84.xyz - xlv_TEXCOORD0);
  highp float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, normalize(tmpvar_56));
  highp float tmpvar_90;
  tmpvar_90 = (_SunRadius * (tmpvar_89 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_91;
  tmpvar_91 = (3.141593 * (tmpvar_90 * tmpvar_90));
  highp float x_92;
  x_92 = ((2.0 * clamp (
    (((tmpvar_85 + tmpvar_90) - sqrt((
      dot (tmpvar_88, tmpvar_88)
     - 
      (tmpvar_89 * tmpvar_89)
    ))) / (2.0 * min (tmpvar_85, tmpvar_90)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_93;
  tmpvar_93 = mix (1.0, clamp ((
    (tmpvar_91 - (((0.3183099 * 
      (sign(x_92) * (1.570796 - (sqrt(
        (1.0 - abs(x_92))
      ) * (1.570796 + 
        (abs(x_92) * (-0.2146018 + (abs(x_92) * (0.08656672 + 
          (abs(x_92) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_87))
   / tmpvar_91), 0.0, 1.0), (float(
    (tmpvar_89 >= tmpvar_85)
  ) * clamp (tmpvar_87, 0.0, 1.0)));
  tmpvar_86 = tmpvar_93;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_55, tmpvar_66), min (tmpvar_76, tmpvar_86)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_94;
  tmpvar_94 = float((tmpvar_41 >= 0.0));
  tmpvar_3.w = (tmpvar_46 * tmpvar_94);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp samplerCube cube_MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp float t16;
bool tb16;
highp vec2 t17;
bvec2 tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16 = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16 + _ShadowBodies[3].x;
    t16 = t16 * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16, _ShadowBodies[3].x);
    t16 = t16 * t16;
    t16 = t16 * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16;
    t8 = t8 / t16;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16 = dot(t4.xyz, t4.xyz);
    t16 = (-t8) * t8 + t16;
    t16 = sqrt(t16);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16 = (-t16) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16 = t16 / t2.x;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 * 2.0 + -1.0;
    t2.x = abs(t16) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16) + -0.212114394;
    t2.x = t2.x * abs(t16) + 1.57072878;
    t3.x = -abs(t16) + 1.0;
    tb16 = t16<(-t16);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16 = tb16 ? t11 : float(0.0);
    t16 = t2.x * t3.x + t16;
    t16 = (-t16) + 1.57079637;
    t16 = t16 * 0.318309873 + 0.5;
    t16 = (-t16) * t2.y + t24;
    t16 = t16 / t24;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 + -1.0;
    t8 = t8 * t16 + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16 = tb16 ? 1.0 : float(0.0);
    t16 = t3.z * t16;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16 * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16 = dot(t2.xyz, t2.xyz);
    t16 = (-t8) * t8 + t16;
    t16 = sqrt(t16);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16 = (-t16) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16 = t16 / t1.x;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 * 2.0 + -1.0;
    t1.x = abs(t16) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16) + -0.212114394;
    t1.x = t1.x * abs(t16) + 1.57072878;
    t9.x = -abs(t16) + 1.0;
    tb16 = t16<(-t16);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16 = tb16 ? t17.x : float(0.0);
    t16 = t1.x * t9.x + t16;
    t16 = (-t16) + 1.57079637;
    t16 = t16 * 0.318309873 + 0.5;
    t16 = (-t16) * t2.w + t24;
    t16 = t16 / t24;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 + -1.0;
    t8 = t8 * t16 + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xyz;
    t1.xy = t0.xy / vec2(_UVNoiseScale);
    tb17.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb17.x) ? t1.x : (-t1.x);
    t1.y = (tb17.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(_UVNoiseScale);
    t1.xy = t1.xy / vec2(_UVNoiseScale);
    t1.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t10_0 = texture(cube_MainTex, t0.xyz);
    t16_0 = t10_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    t16_11.xyz = t16_11.xyz + t16_11.xyz;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 15 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  float4 tmpvar_3;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_4;
  tmpvar_4 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_5;
  float4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  float2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _mtl_u._ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_4.xyz));
  _mtl_o.xlv_TEXCOORD8 = tmpvar_3;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
int ti6;
bool tb6;
float t7;
float t8;
float t9;
vec2 t12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xyz;
    t1.xy = t6.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb13.x) ? t1.x : (-t1.x);
    t1.y = (tb13.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(_UVNoiseScale);
    t1.xy = t1.xy / vec2(_UVNoiseScale);
    t1.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t1.xy;
    t10_1 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t6.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t6.xy;
    t10_1 = texture(cube_MainTex, t6.xyz);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t1.xyz = t1.xyz + t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 315 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD6 = o_8;
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec3 cubeVect_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  cubeVect_4.xy = (tmpvar_5.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uv_12;
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_13);
  float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  float tmpvar_17;
  tmpvar_17 = sign(mix (tmpvar_13.y, mix (tmpvar_13.x, tmpvar_13.z, tmpvar_15), tmpvar_16));
  vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = -(tmpvar_17);
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = tmpvar_17;
  vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = tmpvar_17;
  vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_13.yxz), mix ((tmpvar_18 * tmpvar_13.xzy), (tmpvar_19 * tmpvar_13.zxy), vec3(tmpvar_15)), vec3(tmpvar_16));
  uv_12 = (((
    (0.5 * tmpvar_21.yz)
   / 
    abs(tmpvar_21.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_22;
  vec2 tmpvar_23;
  tmpvar_23 = abs((uv_12 - (0.5 * _DetailScale)));
  uvCont_22.x = max (tmpvar_23.x, tmpvar_23.y);
  uvCont_22.y = min (tmpvar_23.x, tmpvar_23.y);
  vec4 tmpvar_24;
  tmpvar_24.xy = dFdx(uvCont_22);
  tmpvar_24.zw = dFdy(uvCont_22);
  vec3 tmpvar_25;
  tmpvar_25 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * textureCube (cube_MainTex, cubeVect_4)) * mix (texture2DGradARB (_DetailTex, uv_12, tmpvar_24.xy, tmpvar_24.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_25, tmpvar_25)))
  , 0.0, 1.0))));
  float tmpvar_26;
  tmpvar_26 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_27;
  tmpvar_27 = sqrt(dot (tmpvar_25, tmpvar_25));
  vec3 tmpvar_28;
  tmpvar_28 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_29;
  tmpvar_29 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_27), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_27)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_26, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_28, tmpvar_28)) - (_RimDistSub * sqrt(
      dot (tmpvar_29, tmpvar_29)
    ))))
  , 0.0, 1.0)));
  float tmpvar_30;
  tmpvar_30 = color_2.w;
  vec4 tmpvar_31;
  tmpvar_31 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_32;
  float tmpvar_33;
  tmpvar_33 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_32.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_33)) * (tmpvar_31.x * 2.0));
  c_32.w = (tmpvar_33 * (tmpvar_31.x * 2.0));
  float tmpvar_34;
  tmpvar_34 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_32 * mix (1.0, clamp (
    floor((1.01 + tmpvar_34))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_34))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_30;
  vec4 v_35;
  v_35.x = _ShadowBodies[0].x;
  v_35.y = _ShadowBodies[1].x;
  v_35.z = _ShadowBodies[2].x;
  float tmpvar_36;
  tmpvar_36 = _ShadowBodies[3].x;
  v_35.w = tmpvar_36;
  vec3 tmpvar_37;
  tmpvar_37 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_38;
  tmpvar_38 = (3.141593 * (tmpvar_36 * tmpvar_36));
  vec3 tmpvar_39;
  tmpvar_39 = (v_35.xyz - xlv_TEXCOORD0);
  float tmpvar_40;
  tmpvar_40 = dot (tmpvar_39, normalize(tmpvar_37));
  float tmpvar_41;
  tmpvar_41 = (_SunRadius * (tmpvar_40 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_42;
  tmpvar_42 = (3.141593 * (tmpvar_41 * tmpvar_41));
  float x_43;
  x_43 = ((2.0 * clamp (
    (((tmpvar_36 + tmpvar_41) - sqrt((
      dot (tmpvar_39, tmpvar_39)
     - 
      (tmpvar_40 * tmpvar_40)
    ))) / (2.0 * min (tmpvar_36, tmpvar_41)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_44;
  v_44.x = _ShadowBodies[0].y;
  v_44.y = _ShadowBodies[1].y;
  v_44.z = _ShadowBodies[2].y;
  float tmpvar_45;
  tmpvar_45 = _ShadowBodies[3].y;
  v_44.w = tmpvar_45;
  float tmpvar_46;
  tmpvar_46 = (3.141593 * (tmpvar_45 * tmpvar_45));
  vec3 tmpvar_47;
  tmpvar_47 = (v_44.xyz - xlv_TEXCOORD0);
  float tmpvar_48;
  tmpvar_48 = dot (tmpvar_47, normalize(tmpvar_37));
  float tmpvar_49;
  tmpvar_49 = (_SunRadius * (tmpvar_48 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_50;
  tmpvar_50 = (3.141593 * (tmpvar_49 * tmpvar_49));
  float x_51;
  x_51 = ((2.0 * clamp (
    (((tmpvar_45 + tmpvar_49) - sqrt((
      dot (tmpvar_47, tmpvar_47)
     - 
      (tmpvar_48 * tmpvar_48)
    ))) / (2.0 * min (tmpvar_45, tmpvar_49)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_52;
  v_52.x = _ShadowBodies[0].z;
  v_52.y = _ShadowBodies[1].z;
  v_52.z = _ShadowBodies[2].z;
  float tmpvar_53;
  tmpvar_53 = _ShadowBodies[3].z;
  v_52.w = tmpvar_53;
  float tmpvar_54;
  tmpvar_54 = (3.141593 * (tmpvar_53 * tmpvar_53));
  vec3 tmpvar_55;
  tmpvar_55 = (v_52.xyz - xlv_TEXCOORD0);
  float tmpvar_56;
  tmpvar_56 = dot (tmpvar_55, normalize(tmpvar_37));
  float tmpvar_57;
  tmpvar_57 = (_SunRadius * (tmpvar_56 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_58;
  tmpvar_58 = (3.141593 * (tmpvar_57 * tmpvar_57));
  float x_59;
  x_59 = ((2.0 * clamp (
    (((tmpvar_53 + tmpvar_57) - sqrt((
      dot (tmpvar_55, tmpvar_55)
     - 
      (tmpvar_56 * tmpvar_56)
    ))) / (2.0 * min (tmpvar_53, tmpvar_57)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_60;
  v_60.x = _ShadowBodies[0].w;
  v_60.y = _ShadowBodies[1].w;
  v_60.z = _ShadowBodies[2].w;
  float tmpvar_61;
  tmpvar_61 = _ShadowBodies[3].w;
  v_60.w = tmpvar_61;
  float tmpvar_62;
  tmpvar_62 = (3.141593 * (tmpvar_61 * tmpvar_61));
  vec3 tmpvar_63;
  tmpvar_63 = (v_60.xyz - xlv_TEXCOORD0);
  float tmpvar_64;
  tmpvar_64 = dot (tmpvar_63, normalize(tmpvar_37));
  float tmpvar_65;
  tmpvar_65 = (_SunRadius * (tmpvar_64 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_65 * tmpvar_65));
  float x_67;
  x_67 = ((2.0 * clamp (
    (((tmpvar_61 + tmpvar_65) - sqrt((
      dot (tmpvar_63, tmpvar_63)
     - 
      (tmpvar_64 * tmpvar_64)
    ))) / (2.0 * min (tmpvar_61, tmpvar_65)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_42 - 
      (((0.3183099 * (
        sign(x_43)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_43)
        )) * (1.570796 + (
          abs(x_43)
         * 
          (-0.2146018 + (abs(x_43) * (0.08656672 + (
            abs(x_43)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_38)
    ) / tmpvar_42), 0.0, 1.0), (float((tmpvar_40 >= tmpvar_36)) * clamp (tmpvar_38, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_50 - 
      (((0.3183099 * (
        sign(x_51)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_51)
        )) * (1.570796 + (
          abs(x_51)
         * 
          (-0.2146018 + (abs(x_51) * (0.08656672 + (
            abs(x_51)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_46)
    ) / tmpvar_50), 0.0, 1.0), (float((tmpvar_48 >= tmpvar_45)) * clamp (tmpvar_46, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_58 - 
      (((0.3183099 * (
        sign(x_59)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_59)
        )) * (1.570796 + (
          abs(x_59)
         * 
          (-0.2146018 + (abs(x_59) * (0.08656672 + (
            abs(x_59)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_54)
    ) / tmpvar_58), 0.0, 1.0), (float((tmpvar_56 >= tmpvar_53)) * clamp (tmpvar_54, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_66 - 
      (((0.3183099 * (
        sign(x_67)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_67)
        )) * (1.570796 + (
          abs(x_67)
         * 
          (-0.2146018 + (abs(x_67) * (0.08656672 + (
            abs(x_67)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_62)
    ) / tmpvar_66), 0.0, 1.0), (float((tmpvar_64 >= tmpvar_61)) * clamp (tmpvar_62, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_30 * float((tmpvar_26 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord6 o7
dcl_texcoord8 o8
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.x, c14, v0
mov o8.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21
dp4 r0.x, c0, v0
dp4 r0.y, c1, v0
dp4 r0.z, c2, v0
dp4 r0.w, c3, v0
mov o0, r0
mul r1.xz, r0.xyww, c22.x
mul r1.y, r0.y, c19.x
mul r1.w, r1.y, c22.x
mad r0.xy, r1.z, c20.zwzw, r1.xwzw
mov o7, r0
mov o8.xyw, r0

"
}
SubProgram "d3d11 " {
// Stats: 34 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 319 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform lowp samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec3 cubeVect_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  highp float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec2 tmpvar_12;
  tmpvar_12 = ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_UVNoiseTex, tmpvar_12);
  cubeVect_4.xy = (tmpvar_5.xy + ((tmpvar_13.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureCube (cube_MainTex, cubeVect_4);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  mediump vec2 uv_16;
  mediump vec3 detailCoords_17;
  mediump float s_18;
  mediump float nylerp_19;
  mediump float zxlerp_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_21);
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  zxlerp_20 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  nylerp_19 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = mix (tmpvar_21.x, tmpvar_21.z, zxlerp_20);
  s_18 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = sign(mix (tmpvar_21.y, s_18, nylerp_19));
  s_18 = tmpvar_26;
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = -(s_18);
  mediump vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = s_18;
  highp vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_27 * tmpvar_21.xzy), (tmpvar_28 * tmpvar_21.zxy), vec3(zxlerp_20));
  detailCoords_17 = tmpvar_29;
  mediump vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = s_18;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_21.yxz), detailCoords_17, vec3(nylerp_19));
  detailCoords_17 = tmpvar_31;
  uv_16 = (((
    (0.5 * detailCoords_17.yz)
   / 
    abs(detailCoords_17.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_32;
  uv_32 = uv_16;
  highp vec2 uvCont_33;
  highp vec2 tmpvar_34;
  tmpvar_34 = abs((uv_32 - (0.5 * _DetailScale)));
  uvCont_33.x = max (tmpvar_34.x, tmpvar_34.y);
  uvCont_33.y = min (tmpvar_34.x, tmpvar_34.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_33);
  tmpvar_35.zw = dFdy(uvCont_33);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_DetailTex, uv_16, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  highp vec3 tmpvar_38;
  tmpvar_38 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_38, tmpvar_38)
  )), 0.0, 1.0);
  tmpvar_39 = tmpvar_40;
  color_2 = ((_Color * tmpvar_15) * mix (tmpvar_37, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_39)));
  highp float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_42;
  tmpvar_42 = sqrt(dot (tmpvar_38, tmpvar_38));
  highp vec3 tmpvar_43;
  tmpvar_43 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_44;
  tmpvar_44 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_45;
  tmpvar_45 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_42), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_42)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_41, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_43, tmpvar_43)) - (_RimDistSub * sqrt(
      dot (tmpvar_44, tmpvar_44)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_45;
  mediump float tmpvar_46;
  tmpvar_46 = color_2.w;
  lowp float tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_47 = tmpvar_48;
  mediump vec3 normal_49;
  normal_49 = xlv_TEXCOORD4;
  mediump float atten_50;
  atten_50 = tmpvar_47;
  mediump vec4 c_51;
  mediump vec3 tmpvar_52;
  tmpvar_52 = normalize(normal_49);
  normal_49 = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = dot (tmpvar_52, normalize(_WorldSpaceLightPos0.xyz));
  c_51.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_53)) * (atten_50 * 2.0));
  c_51.w = (tmpvar_53 * (atten_50 * 2.0));
  mediump vec3 normal_54;
  normal_54 = xlv_TEXCOORD4;
  mediump float tmpvar_55;
  tmpvar_55 = dot (normal_54, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_51 * mix (1.0, clamp (
    floor((1.01 + tmpvar_55))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_55))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_46;
  highp vec4 v_56;
  v_56.x = _ShadowBodies[0].x;
  v_56.y = _ShadowBodies[1].x;
  v_56.z = _ShadowBodies[2].x;
  highp float tmpvar_57;
  tmpvar_57 = _ShadowBodies[3].x;
  v_56.w = tmpvar_57;
  mediump float tmpvar_58;
  highp vec3 tmpvar_59;
  tmpvar_59 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_60;
  tmpvar_60 = (3.141593 * (tmpvar_57 * tmpvar_57));
  highp vec3 tmpvar_61;
  tmpvar_61 = (v_56.xyz - xlv_TEXCOORD0);
  highp float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, normalize(tmpvar_59));
  highp float tmpvar_63;
  tmpvar_63 = (_SunRadius * (tmpvar_62 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_63 * tmpvar_63));
  highp float x_65;
  x_65 = ((2.0 * clamp (
    (((tmpvar_57 + tmpvar_63) - sqrt((
      dot (tmpvar_61, tmpvar_61)
     - 
      (tmpvar_62 * tmpvar_62)
    ))) / (2.0 * min (tmpvar_57, tmpvar_63)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_66;
  tmpvar_66 = mix (1.0, clamp ((
    (tmpvar_64 - (((0.3183099 * 
      (sign(x_65) * (1.570796 - (sqrt(
        (1.0 - abs(x_65))
      ) * (1.570796 + 
        (abs(x_65) * (-0.2146018 + (abs(x_65) * (0.08656672 + 
          (abs(x_65) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_60))
   / tmpvar_64), 0.0, 1.0), (float(
    (tmpvar_62 >= tmpvar_57)
  ) * clamp (tmpvar_60, 0.0, 1.0)));
  tmpvar_58 = tmpvar_66;
  highp vec4 v_67;
  v_67.x = _ShadowBodies[0].y;
  v_67.y = _ShadowBodies[1].y;
  v_67.z = _ShadowBodies[2].y;
  highp float tmpvar_68;
  tmpvar_68 = _ShadowBodies[3].y;
  v_67.w = tmpvar_68;
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (3.141593 * (tmpvar_68 * tmpvar_68));
  highp vec3 tmpvar_71;
  tmpvar_71 = (v_67.xyz - xlv_TEXCOORD0);
  highp float tmpvar_72;
  tmpvar_72 = dot (tmpvar_71, normalize(tmpvar_59));
  highp float tmpvar_73;
  tmpvar_73 = (_SunRadius * (tmpvar_72 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_74;
  tmpvar_74 = (3.141593 * (tmpvar_73 * tmpvar_73));
  highp float x_75;
  x_75 = ((2.0 * clamp (
    (((tmpvar_68 + tmpvar_73) - sqrt((
      dot (tmpvar_71, tmpvar_71)
     - 
      (tmpvar_72 * tmpvar_72)
    ))) / (2.0 * min (tmpvar_68, tmpvar_73)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_76;
  tmpvar_76 = mix (1.0, clamp ((
    (tmpvar_74 - (((0.3183099 * 
      (sign(x_75) * (1.570796 - (sqrt(
        (1.0 - abs(x_75))
      ) * (1.570796 + 
        (abs(x_75) * (-0.2146018 + (abs(x_75) * (0.08656672 + 
          (abs(x_75) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_70))
   / tmpvar_74), 0.0, 1.0), (float(
    (tmpvar_72 >= tmpvar_68)
  ) * clamp (tmpvar_70, 0.0, 1.0)));
  tmpvar_69 = tmpvar_76;
  highp vec4 v_77;
  v_77.x = _ShadowBodies[0].z;
  v_77.y = _ShadowBodies[1].z;
  v_77.z = _ShadowBodies[2].z;
  highp float tmpvar_78;
  tmpvar_78 = _ShadowBodies[3].z;
  v_77.w = tmpvar_78;
  mediump float tmpvar_79;
  highp float tmpvar_80;
  tmpvar_80 = (3.141593 * (tmpvar_78 * tmpvar_78));
  highp vec3 tmpvar_81;
  tmpvar_81 = (v_77.xyz - xlv_TEXCOORD0);
  highp float tmpvar_82;
  tmpvar_82 = dot (tmpvar_81, normalize(tmpvar_59));
  highp float tmpvar_83;
  tmpvar_83 = (_SunRadius * (tmpvar_82 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_84;
  tmpvar_84 = (3.141593 * (tmpvar_83 * tmpvar_83));
  highp float x_85;
  x_85 = ((2.0 * clamp (
    (((tmpvar_78 + tmpvar_83) - sqrt((
      dot (tmpvar_81, tmpvar_81)
     - 
      (tmpvar_82 * tmpvar_82)
    ))) / (2.0 * min (tmpvar_78, tmpvar_83)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_86;
  tmpvar_86 = mix (1.0, clamp ((
    (tmpvar_84 - (((0.3183099 * 
      (sign(x_85) * (1.570796 - (sqrt(
        (1.0 - abs(x_85))
      ) * (1.570796 + 
        (abs(x_85) * (-0.2146018 + (abs(x_85) * (0.08656672 + 
          (abs(x_85) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_80))
   / tmpvar_84), 0.0, 1.0), (float(
    (tmpvar_82 >= tmpvar_78)
  ) * clamp (tmpvar_80, 0.0, 1.0)));
  tmpvar_79 = tmpvar_86;
  highp vec4 v_87;
  v_87.x = _ShadowBodies[0].w;
  v_87.y = _ShadowBodies[1].w;
  v_87.z = _ShadowBodies[2].w;
  highp float tmpvar_88;
  tmpvar_88 = _ShadowBodies[3].w;
  v_87.w = tmpvar_88;
  mediump float tmpvar_89;
  highp float tmpvar_90;
  tmpvar_90 = (3.141593 * (tmpvar_88 * tmpvar_88));
  highp vec3 tmpvar_91;
  tmpvar_91 = (v_87.xyz - xlv_TEXCOORD0);
  highp float tmpvar_92;
  tmpvar_92 = dot (tmpvar_91, normalize(tmpvar_59));
  highp float tmpvar_93;
  tmpvar_93 = (_SunRadius * (tmpvar_92 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_94;
  tmpvar_94 = (3.141593 * (tmpvar_93 * tmpvar_93));
  highp float x_95;
  x_95 = ((2.0 * clamp (
    (((tmpvar_88 + tmpvar_93) - sqrt((
      dot (tmpvar_91, tmpvar_91)
     - 
      (tmpvar_92 * tmpvar_92)
    ))) / (2.0 * min (tmpvar_88, tmpvar_93)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_96;
  tmpvar_96 = mix (1.0, clamp ((
    (tmpvar_94 - (((0.3183099 * 
      (sign(x_95) * (1.570796 - (sqrt(
        (1.0 - abs(x_95))
      ) * (1.570796 + 
        (abs(x_95) * (-0.2146018 + (abs(x_95) * (0.08656672 + 
          (abs(x_95) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_90))
   / tmpvar_94), 0.0, 1.0), (float(
    (tmpvar_92 >= tmpvar_88)
  ) * clamp (tmpvar_90, 0.0, 1.0)));
  tmpvar_89 = tmpvar_96;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_58, tmpvar_69), min (tmpvar_79, tmpvar_89)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_97;
  tmpvar_97 = float((tmpvar_41 >= 0.0));
  tmpvar_3.w = (tmpvar_46 * tmpvar_97);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD4.xyz = vec3(t13) * t2.xyz;
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t1.x = t0.y * _ProjectionParams.x;
    t1.w = t1.x * 0.5;
    t1.xz = t0.xw * vec2(0.5, 0.5);
    t0.xy = t1.zz + t1.xw;
    vs_TEXCOORD6 = t0;
    vs_TEXCOORD8.xyw = t0.xyw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
int ti6;
bool tb6;
float t7;
float t8;
float t9;
vec2 t12;
mediump float t16_12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xyz;
    t1.xy = t6.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb13.x) ? t1.x : (-t1.x);
    t1.y = (tb13.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(_UVNoiseScale);
    t1.xy = t1.xy / vec2(_UVNoiseScale);
    t1.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t1.xy;
    t10_1 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t6.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t6.xy;
    t10_1 = texture(cube_MainTex, t6.xyz);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t12.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t12.xy);
    t16_12 = t10_2.x + t10_2.x;
    t1.xyz = vec3(t16_12) * t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 313 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec3 cubeVect_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  cubeVect_4.xy = (tmpvar_5.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uv_12;
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_13);
  float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  float tmpvar_17;
  tmpvar_17 = sign(mix (tmpvar_13.y, mix (tmpvar_13.x, tmpvar_13.z, tmpvar_15), tmpvar_16));
  vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = -(tmpvar_17);
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = tmpvar_17;
  vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = tmpvar_17;
  vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_13.yxz), mix ((tmpvar_18 * tmpvar_13.xzy), (tmpvar_19 * tmpvar_13.zxy), vec3(tmpvar_15)), vec3(tmpvar_16));
  uv_12 = (((
    (0.5 * tmpvar_21.yz)
   / 
    abs(tmpvar_21.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_22;
  vec2 tmpvar_23;
  tmpvar_23 = abs((uv_12 - (0.5 * _DetailScale)));
  uvCont_22.x = max (tmpvar_23.x, tmpvar_23.y);
  uvCont_22.y = min (tmpvar_23.x, tmpvar_23.y);
  vec4 tmpvar_24;
  tmpvar_24.xy = dFdx(uvCont_22);
  tmpvar_24.zw = dFdy(uvCont_22);
  vec3 tmpvar_25;
  tmpvar_25 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * textureCube (cube_MainTex, cubeVect_4)) * mix (texture2DGradARB (_DetailTex, uv_12, tmpvar_24.xy, tmpvar_24.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_25, tmpvar_25)))
  , 0.0, 1.0))));
  float tmpvar_26;
  tmpvar_26 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_27;
  tmpvar_27 = sqrt(dot (tmpvar_25, tmpvar_25));
  vec3 tmpvar_28;
  tmpvar_28 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_29;
  tmpvar_29 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_27), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_27)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_26, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_28, tmpvar_28)) - (_RimDistSub * sqrt(
      dot (tmpvar_29, tmpvar_29)
    ))))
  , 0.0, 1.0)));
  float tmpvar_30;
  tmpvar_30 = color_2.w;
  vec4 c_31;
  float tmpvar_32;
  tmpvar_32 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_31.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_32 * 2.0));
  c_31.w = (tmpvar_32 * 2.0);
  float tmpvar_33;
  tmpvar_33 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_31 * mix (1.0, clamp (
    floor((1.01 + tmpvar_33))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_33))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_30;
  vec4 v_34;
  v_34.x = _ShadowBodies[0].x;
  v_34.y = _ShadowBodies[1].x;
  v_34.z = _ShadowBodies[2].x;
  float tmpvar_35;
  tmpvar_35 = _ShadowBodies[3].x;
  v_34.w = tmpvar_35;
  vec3 tmpvar_36;
  tmpvar_36 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_37;
  tmpvar_37 = (3.141593 * (tmpvar_35 * tmpvar_35));
  vec3 tmpvar_38;
  tmpvar_38 = (v_34.xyz - xlv_TEXCOORD0);
  float tmpvar_39;
  tmpvar_39 = dot (tmpvar_38, normalize(tmpvar_36));
  float tmpvar_40;
  tmpvar_40 = (_SunRadius * (tmpvar_39 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_41;
  tmpvar_41 = (3.141593 * (tmpvar_40 * tmpvar_40));
  float x_42;
  x_42 = ((2.0 * clamp (
    (((tmpvar_35 + tmpvar_40) - sqrt((
      dot (tmpvar_38, tmpvar_38)
     - 
      (tmpvar_39 * tmpvar_39)
    ))) / (2.0 * min (tmpvar_35, tmpvar_40)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_43;
  v_43.x = _ShadowBodies[0].y;
  v_43.y = _ShadowBodies[1].y;
  v_43.z = _ShadowBodies[2].y;
  float tmpvar_44;
  tmpvar_44 = _ShadowBodies[3].y;
  v_43.w = tmpvar_44;
  float tmpvar_45;
  tmpvar_45 = (3.141593 * (tmpvar_44 * tmpvar_44));
  vec3 tmpvar_46;
  tmpvar_46 = (v_43.xyz - xlv_TEXCOORD0);
  float tmpvar_47;
  tmpvar_47 = dot (tmpvar_46, normalize(tmpvar_36));
  float tmpvar_48;
  tmpvar_48 = (_SunRadius * (tmpvar_47 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_49;
  tmpvar_49 = (3.141593 * (tmpvar_48 * tmpvar_48));
  float x_50;
  x_50 = ((2.0 * clamp (
    (((tmpvar_44 + tmpvar_48) - sqrt((
      dot (tmpvar_46, tmpvar_46)
     - 
      (tmpvar_47 * tmpvar_47)
    ))) / (2.0 * min (tmpvar_44, tmpvar_48)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_51;
  v_51.x = _ShadowBodies[0].z;
  v_51.y = _ShadowBodies[1].z;
  v_51.z = _ShadowBodies[2].z;
  float tmpvar_52;
  tmpvar_52 = _ShadowBodies[3].z;
  v_51.w = tmpvar_52;
  float tmpvar_53;
  tmpvar_53 = (3.141593 * (tmpvar_52 * tmpvar_52));
  vec3 tmpvar_54;
  tmpvar_54 = (v_51.xyz - xlv_TEXCOORD0);
  float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, normalize(tmpvar_36));
  float tmpvar_56;
  tmpvar_56 = (_SunRadius * (tmpvar_55 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_57;
  tmpvar_57 = (3.141593 * (tmpvar_56 * tmpvar_56));
  float x_58;
  x_58 = ((2.0 * clamp (
    (((tmpvar_52 + tmpvar_56) - sqrt((
      dot (tmpvar_54, tmpvar_54)
     - 
      (tmpvar_55 * tmpvar_55)
    ))) / (2.0 * min (tmpvar_52, tmpvar_56)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_59;
  v_59.x = _ShadowBodies[0].w;
  v_59.y = _ShadowBodies[1].w;
  v_59.z = _ShadowBodies[2].w;
  float tmpvar_60;
  tmpvar_60 = _ShadowBodies[3].w;
  v_59.w = tmpvar_60;
  float tmpvar_61;
  tmpvar_61 = (3.141593 * (tmpvar_60 * tmpvar_60));
  vec3 tmpvar_62;
  tmpvar_62 = (v_59.xyz - xlv_TEXCOORD0);
  float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, normalize(tmpvar_36));
  float tmpvar_64;
  tmpvar_64 = (_SunRadius * (tmpvar_63 / sqrt(
    dot (tmpvar_36, tmpvar_36)
  )));
  float tmpvar_65;
  tmpvar_65 = (3.141593 * (tmpvar_64 * tmpvar_64));
  float x_66;
  x_66 = ((2.0 * clamp (
    (((tmpvar_60 + tmpvar_64) - sqrt((
      dot (tmpvar_62, tmpvar_62)
     - 
      (tmpvar_63 * tmpvar_63)
    ))) / (2.0 * min (tmpvar_60, tmpvar_64)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_41 - 
      (((0.3183099 * (
        sign(x_42)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_42)
        )) * (1.570796 + (
          abs(x_42)
         * 
          (-0.2146018 + (abs(x_42) * (0.08656672 + (
            abs(x_42)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_37)
    ) / tmpvar_41), 0.0, 1.0), (float((tmpvar_39 >= tmpvar_35)) * clamp (tmpvar_37, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_49 - 
      (((0.3183099 * (
        sign(x_50)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_50)
        )) * (1.570796 + (
          abs(x_50)
         * 
          (-0.2146018 + (abs(x_50) * (0.08656672 + (
            abs(x_50)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_45)
    ) / tmpvar_49), 0.0, 1.0), (float((tmpvar_47 >= tmpvar_44)) * clamp (tmpvar_45, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_57 - 
      (((0.3183099 * (
        sign(x_58)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_58)
        )) * (1.570796 + (
          abs(x_58)
         * 
          (-0.2146018 + (abs(x_58) * (0.08656672 + (
            abs(x_58)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_53)
    ) / tmpvar_57), 0.0, 1.0), (float((tmpvar_55 >= tmpvar_52)) * clamp (tmpvar_53, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_65 - 
      (((0.3183099 * (
        sign(x_66)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_66)
        )) * (1.570796 + (
          abs(x_66)
         * 
          (-0.2146018 + (abs(x_66) * (0.08656672 + (
            abs(x_66)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_61)
    ) / tmpvar_65), 0.0, 1.0), (float((tmpvar_63 >= tmpvar_60)) * clamp (tmpvar_61, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_30 * float((tmpvar_26 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 37 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord8 o7
dp4 o0.z, c2, v0
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r0.z, r0.y, c19.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xzw, r0.xywz, c22.x
mov o0.xyw, r0
mov o7.w, r0.w
mad o7.xy, r1.z, c20.zwzw, r1.xwzw
dp4 r0.x, c14, v0
mov o7.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21

"
}
SubProgram "d3d11 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 313 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform lowp samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec3 cubeVect_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  highp float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec2 tmpvar_12;
  tmpvar_12 = ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_UVNoiseTex, tmpvar_12);
  cubeVect_4.xy = (tmpvar_5.xy + ((tmpvar_13.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureCube (cube_MainTex, cubeVect_4);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  mediump vec2 uv_16;
  mediump vec3 detailCoords_17;
  mediump float s_18;
  mediump float nylerp_19;
  mediump float zxlerp_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_21);
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  zxlerp_20 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  nylerp_19 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = mix (tmpvar_21.x, tmpvar_21.z, zxlerp_20);
  s_18 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = sign(mix (tmpvar_21.y, s_18, nylerp_19));
  s_18 = tmpvar_26;
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = -(s_18);
  mediump vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = s_18;
  highp vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_27 * tmpvar_21.xzy), (tmpvar_28 * tmpvar_21.zxy), vec3(zxlerp_20));
  detailCoords_17 = tmpvar_29;
  mediump vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = s_18;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_21.yxz), detailCoords_17, vec3(nylerp_19));
  detailCoords_17 = tmpvar_31;
  uv_16 = (((
    (0.5 * detailCoords_17.yz)
   / 
    abs(detailCoords_17.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_32;
  uv_32 = uv_16;
  highp vec2 uvCont_33;
  highp vec2 tmpvar_34;
  tmpvar_34 = abs((uv_32 - (0.5 * _DetailScale)));
  uvCont_33.x = max (tmpvar_34.x, tmpvar_34.y);
  uvCont_33.y = min (tmpvar_34.x, tmpvar_34.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_33);
  tmpvar_35.zw = dFdy(uvCont_33);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_DetailTex, uv_16, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  highp vec3 tmpvar_38;
  tmpvar_38 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_38, tmpvar_38)
  )), 0.0, 1.0);
  tmpvar_39 = tmpvar_40;
  color_2 = ((_Color * tmpvar_15) * mix (tmpvar_37, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_39)));
  highp float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_42;
  tmpvar_42 = sqrt(dot (tmpvar_38, tmpvar_38));
  highp vec3 tmpvar_43;
  tmpvar_43 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_44;
  tmpvar_44 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_45;
  tmpvar_45 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_42), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_42)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_41, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_43, tmpvar_43)) - (_RimDistSub * sqrt(
      dot (tmpvar_44, tmpvar_44)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_45;
  mediump float tmpvar_46;
  tmpvar_46 = color_2.w;
  mediump vec3 normal_47;
  normal_47 = xlv_TEXCOORD4;
  mediump vec4 c_48;
  mediump vec3 tmpvar_49;
  tmpvar_49 = normalize(normal_47);
  normal_47 = tmpvar_49;
  mediump float tmpvar_50;
  tmpvar_50 = dot (tmpvar_49, normalize(_WorldSpaceLightPos0.xyz));
  c_48.xyz = ((_LightColor0.xyz * color_2.xyz) * (tmpvar_50 * 2.0));
  c_48.w = (tmpvar_50 * 2.0);
  mediump vec3 normal_51;
  normal_51 = xlv_TEXCOORD4;
  mediump float tmpvar_52;
  tmpvar_52 = dot (normal_51, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_48 * mix (1.0, clamp (
    floor((1.01 + tmpvar_52))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_52))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_46;
  highp vec4 v_53;
  v_53.x = _ShadowBodies[0].x;
  v_53.y = _ShadowBodies[1].x;
  v_53.z = _ShadowBodies[2].x;
  highp float tmpvar_54;
  tmpvar_54 = _ShadowBodies[3].x;
  v_53.w = tmpvar_54;
  mediump float tmpvar_55;
  highp vec3 tmpvar_56;
  tmpvar_56 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_57;
  tmpvar_57 = (3.141593 * (tmpvar_54 * tmpvar_54));
  highp vec3 tmpvar_58;
  tmpvar_58 = (v_53.xyz - xlv_TEXCOORD0);
  highp float tmpvar_59;
  tmpvar_59 = dot (tmpvar_58, normalize(tmpvar_56));
  highp float tmpvar_60;
  tmpvar_60 = (_SunRadius * (tmpvar_59 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_61;
  tmpvar_61 = (3.141593 * (tmpvar_60 * tmpvar_60));
  highp float x_62;
  x_62 = ((2.0 * clamp (
    (((tmpvar_54 + tmpvar_60) - sqrt((
      dot (tmpvar_58, tmpvar_58)
     - 
      (tmpvar_59 * tmpvar_59)
    ))) / (2.0 * min (tmpvar_54, tmpvar_60)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_63;
  tmpvar_63 = mix (1.0, clamp ((
    (tmpvar_61 - (((0.3183099 * 
      (sign(x_62) * (1.570796 - (sqrt(
        (1.0 - abs(x_62))
      ) * (1.570796 + 
        (abs(x_62) * (-0.2146018 + (abs(x_62) * (0.08656672 + 
          (abs(x_62) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_57))
   / tmpvar_61), 0.0, 1.0), (float(
    (tmpvar_59 >= tmpvar_54)
  ) * clamp (tmpvar_57, 0.0, 1.0)));
  tmpvar_55 = tmpvar_63;
  highp vec4 v_64;
  v_64.x = _ShadowBodies[0].y;
  v_64.y = _ShadowBodies[1].y;
  v_64.z = _ShadowBodies[2].y;
  highp float tmpvar_65;
  tmpvar_65 = _ShadowBodies[3].y;
  v_64.w = tmpvar_65;
  mediump float tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = (3.141593 * (tmpvar_65 * tmpvar_65));
  highp vec3 tmpvar_68;
  tmpvar_68 = (v_64.xyz - xlv_TEXCOORD0);
  highp float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, normalize(tmpvar_56));
  highp float tmpvar_70;
  tmpvar_70 = (_SunRadius * (tmpvar_69 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_71;
  tmpvar_71 = (3.141593 * (tmpvar_70 * tmpvar_70));
  highp float x_72;
  x_72 = ((2.0 * clamp (
    (((tmpvar_65 + tmpvar_70) - sqrt((
      dot (tmpvar_68, tmpvar_68)
     - 
      (tmpvar_69 * tmpvar_69)
    ))) / (2.0 * min (tmpvar_65, tmpvar_70)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_73;
  tmpvar_73 = mix (1.0, clamp ((
    (tmpvar_71 - (((0.3183099 * 
      (sign(x_72) * (1.570796 - (sqrt(
        (1.0 - abs(x_72))
      ) * (1.570796 + 
        (abs(x_72) * (-0.2146018 + (abs(x_72) * (0.08656672 + 
          (abs(x_72) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_67))
   / tmpvar_71), 0.0, 1.0), (float(
    (tmpvar_69 >= tmpvar_65)
  ) * clamp (tmpvar_67, 0.0, 1.0)));
  tmpvar_66 = tmpvar_73;
  highp vec4 v_74;
  v_74.x = _ShadowBodies[0].z;
  v_74.y = _ShadowBodies[1].z;
  v_74.z = _ShadowBodies[2].z;
  highp float tmpvar_75;
  tmpvar_75 = _ShadowBodies[3].z;
  v_74.w = tmpvar_75;
  mediump float tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = (3.141593 * (tmpvar_75 * tmpvar_75));
  highp vec3 tmpvar_78;
  tmpvar_78 = (v_74.xyz - xlv_TEXCOORD0);
  highp float tmpvar_79;
  tmpvar_79 = dot (tmpvar_78, normalize(tmpvar_56));
  highp float tmpvar_80;
  tmpvar_80 = (_SunRadius * (tmpvar_79 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_81;
  tmpvar_81 = (3.141593 * (tmpvar_80 * tmpvar_80));
  highp float x_82;
  x_82 = ((2.0 * clamp (
    (((tmpvar_75 + tmpvar_80) - sqrt((
      dot (tmpvar_78, tmpvar_78)
     - 
      (tmpvar_79 * tmpvar_79)
    ))) / (2.0 * min (tmpvar_75, tmpvar_80)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_83;
  tmpvar_83 = mix (1.0, clamp ((
    (tmpvar_81 - (((0.3183099 * 
      (sign(x_82) * (1.570796 - (sqrt(
        (1.0 - abs(x_82))
      ) * (1.570796 + 
        (abs(x_82) * (-0.2146018 + (abs(x_82) * (0.08656672 + 
          (abs(x_82) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_77))
   / tmpvar_81), 0.0, 1.0), (float(
    (tmpvar_79 >= tmpvar_75)
  ) * clamp (tmpvar_77, 0.0, 1.0)));
  tmpvar_76 = tmpvar_83;
  highp vec4 v_84;
  v_84.x = _ShadowBodies[0].w;
  v_84.y = _ShadowBodies[1].w;
  v_84.z = _ShadowBodies[2].w;
  highp float tmpvar_85;
  tmpvar_85 = _ShadowBodies[3].w;
  v_84.w = tmpvar_85;
  mediump float tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = (3.141593 * (tmpvar_85 * tmpvar_85));
  highp vec3 tmpvar_88;
  tmpvar_88 = (v_84.xyz - xlv_TEXCOORD0);
  highp float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, normalize(tmpvar_56));
  highp float tmpvar_90;
  tmpvar_90 = (_SunRadius * (tmpvar_89 / sqrt(
    dot (tmpvar_56, tmpvar_56)
  )));
  highp float tmpvar_91;
  tmpvar_91 = (3.141593 * (tmpvar_90 * tmpvar_90));
  highp float x_92;
  x_92 = ((2.0 * clamp (
    (((tmpvar_85 + tmpvar_90) - sqrt((
      dot (tmpvar_88, tmpvar_88)
     - 
      (tmpvar_89 * tmpvar_89)
    ))) / (2.0 * min (tmpvar_85, tmpvar_90)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_93;
  tmpvar_93 = mix (1.0, clamp ((
    (tmpvar_91 - (((0.3183099 * 
      (sign(x_92) * (1.570796 - (sqrt(
        (1.0 - abs(x_92))
      ) * (1.570796 + 
        (abs(x_92) * (-0.2146018 + (abs(x_92) * (0.08656672 + 
          (abs(x_92) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_87))
   / tmpvar_91), 0.0, 1.0), (float(
    (tmpvar_89 >= tmpvar_85)
  ) * clamp (tmpvar_87, 0.0, 1.0)));
  tmpvar_86 = tmpvar_93;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_55, tmpvar_66), min (tmpvar_76, tmpvar_86)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_94;
  tmpvar_94 = float((tmpvar_41 >= 0.0));
  tmpvar_3.w = (tmpvar_46 * tmpvar_94);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp samplerCube cube_MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp float t16;
bool tb16;
highp vec2 t17;
bvec2 tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16 = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16 + _ShadowBodies[3].x;
    t16 = t16 * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16, _ShadowBodies[3].x);
    t16 = t16 * t16;
    t16 = t16 * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16;
    t8 = t8 / t16;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16 = dot(t4.xyz, t4.xyz);
    t16 = (-t8) * t8 + t16;
    t16 = sqrt(t16);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16 = (-t16) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16 = t16 / t2.x;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 * 2.0 + -1.0;
    t2.x = abs(t16) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16) + -0.212114394;
    t2.x = t2.x * abs(t16) + 1.57072878;
    t3.x = -abs(t16) + 1.0;
    tb16 = t16<(-t16);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16 = tb16 ? t11 : float(0.0);
    t16 = t2.x * t3.x + t16;
    t16 = (-t16) + 1.57079637;
    t16 = t16 * 0.318309873 + 0.5;
    t16 = (-t16) * t2.y + t24;
    t16 = t16 / t24;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 + -1.0;
    t8 = t8 * t16 + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16 = tb16 ? 1.0 : float(0.0);
    t16 = t3.z * t16;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16 * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16 = dot(t2.xyz, t2.xyz);
    t16 = (-t8) * t8 + t16;
    t16 = sqrt(t16);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16 = (-t16) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16 = t16 / t1.x;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 * 2.0 + -1.0;
    t1.x = abs(t16) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16) + -0.212114394;
    t1.x = t1.x * abs(t16) + 1.57072878;
    t9.x = -abs(t16) + 1.0;
    tb16 = t16<(-t16);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16 = tb16 ? t17.x : float(0.0);
    t16 = t1.x * t9.x + t16;
    t16 = (-t16) + 1.57079637;
    t16 = t16 * 0.318309873 + 0.5;
    t16 = (-t16) * t2.w + t24;
    t16 = t16 / t24;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 + -1.0;
    t8 = t8 * t16 + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xyz;
    t1.xy = t0.xy / vec2(_UVNoiseScale);
    tb17.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb17.x) ? t1.x : (-t1.x);
    t1.y = (tb17.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(_UVNoiseScale);
    t1.xy = t1.xy / vec2(_UVNoiseScale);
    t1.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t10_0 = texture(cube_MainTex, t0.xyz);
    t16_0 = t10_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    t16_11.xyz = t16_11.xyz + t16_11.xyz;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 15 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  float4 tmpvar_3;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_4;
  tmpvar_4 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_5;
  float4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  float2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _mtl_u._ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_4.xyz));
  _mtl_o.xlv_TEXCOORD8 = tmpvar_3;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
int ti6;
bool tb6;
float t7;
float t8;
float t9;
vec2 t12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xyz;
    t1.xy = t6.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb13.x) ? t1.x : (-t1.x);
    t1.y = (tb13.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(_UVNoiseScale);
    t1.xy = t1.xy / vec2(_UVNoiseScale);
    t1.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t1.xy;
    t10_1 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t6.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t6.xy;
    t10_1 = texture(cube_MainTex, t6.xyz);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t1.xyz = t1.xyz + t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 315 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;


uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec3 _PlanetOrigin;
varying vec3 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec4 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex);
  tmpvar_2 = (_MainRotation * gl_Vertex);
  vec4 o_5;
  vec4 tmpvar_6;
  tmpvar_6 = (tmpvar_1 * 0.5);
  vec2 tmpvar_7;
  tmpvar_7.x = tmpvar_6.x;
  tmpvar_7.y = (tmpvar_6.y * _ProjectionParams.x);
  o_5.xy = (tmpvar_7 + tmpvar_6.w);
  o_5.zw = tmpvar_1.zw;
  tmpvar_3.xyw = o_5.xyw;
  tmpvar_3.z = -((gl_ModelViewMatrix * gl_Vertex).z);
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_4.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_4.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_4.xyz));
  xlv_TEXCOORD6 = o_8;
  xlv_TEXCOORD8 = tmpvar_3;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ZBufferParams;
uniform vec4 _WorldSpaceLightPos0;
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform mat4 _ShadowBodies;
uniform float _SunRadius;
uniform vec3 _SunPos;
uniform samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform vec4 _Color;
uniform float _FalloffPow;
uniform float _FalloffScale;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _RimDist;
uniform float _RimDistSub;
uniform vec3 _PlanetOrigin;
uniform float _DepthPull;
varying vec3 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
varying vec4 xlv_TEXCOORD8;
void main ()
{
  float depthWithOffset_1;
  vec4 color_2;
  vec4 tmpvar_3;
  vec3 cubeVect_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  cubeVect_4.xy = (tmpvar_5.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uv_12;
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2.xyz);
  vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_13);
  float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  float tmpvar_17;
  tmpvar_17 = sign(mix (tmpvar_13.y, mix (tmpvar_13.x, tmpvar_13.z, tmpvar_15), tmpvar_16));
  vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = -(tmpvar_17);
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = tmpvar_17;
  vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = tmpvar_17;
  vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_13.yxz), mix ((tmpvar_18 * tmpvar_13.xzy), (tmpvar_19 * tmpvar_13.zxy), vec3(tmpvar_15)), vec3(tmpvar_16));
  uv_12 = (((
    (0.5 * tmpvar_21.yz)
   / 
    abs(tmpvar_21.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_22;
  vec2 tmpvar_23;
  tmpvar_23 = abs((uv_12 - (0.5 * _DetailScale)));
  uvCont_22.x = max (tmpvar_23.x, tmpvar_23.y);
  uvCont_22.y = min (tmpvar_23.x, tmpvar_23.y);
  vec4 tmpvar_24;
  tmpvar_24.xy = dFdx(uvCont_22);
  tmpvar_24.zw = dFdy(uvCont_22);
  vec3 tmpvar_25;
  tmpvar_25 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  color_2 = ((_Color * textureCube (cube_MainTex, cubeVect_4)) * mix (texture2DGradARB (_DetailTex, uv_12, tmpvar_24.xy, tmpvar_24.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_25, tmpvar_25)))
  , 0.0, 1.0))));
  float tmpvar_26;
  tmpvar_26 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  float tmpvar_27;
  tmpvar_27 = sqrt(dot (tmpvar_25, tmpvar_25));
  vec3 tmpvar_28;
  tmpvar_28 = (_PlanetOrigin - _WorldSpaceCameraPos);
  vec3 tmpvar_29;
  tmpvar_29 = (xlv_TEXCOORD0 - _PlanetOrigin);
  color_2.w = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_27), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_27)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_26, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_28, tmpvar_28)) - (_RimDistSub * sqrt(
      dot (tmpvar_29, tmpvar_29)
    ))))
  , 0.0, 1.0)));
  float tmpvar_30;
  tmpvar_30 = color_2.w;
  vec4 tmpvar_31;
  tmpvar_31 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_32;
  float tmpvar_33;
  tmpvar_33 = dot (normalize(xlv_TEXCOORD4), normalize(_WorldSpaceLightPos0.xyz));
  c_32.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_33)) * (tmpvar_31.x * 2.0));
  c_32.w = (tmpvar_33 * (tmpvar_31.x * 2.0));
  float tmpvar_34;
  tmpvar_34 = dot (xlv_TEXCOORD4, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_32 * mix (1.0, clamp (
    floor((1.01 + tmpvar_34))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_34))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_30;
  vec4 v_35;
  v_35.x = _ShadowBodies[0].x;
  v_35.y = _ShadowBodies[1].x;
  v_35.z = _ShadowBodies[2].x;
  float tmpvar_36;
  tmpvar_36 = _ShadowBodies[3].x;
  v_35.w = tmpvar_36;
  vec3 tmpvar_37;
  tmpvar_37 = (_SunPos - xlv_TEXCOORD0);
  float tmpvar_38;
  tmpvar_38 = (3.141593 * (tmpvar_36 * tmpvar_36));
  vec3 tmpvar_39;
  tmpvar_39 = (v_35.xyz - xlv_TEXCOORD0);
  float tmpvar_40;
  tmpvar_40 = dot (tmpvar_39, normalize(tmpvar_37));
  float tmpvar_41;
  tmpvar_41 = (_SunRadius * (tmpvar_40 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_42;
  tmpvar_42 = (3.141593 * (tmpvar_41 * tmpvar_41));
  float x_43;
  x_43 = ((2.0 * clamp (
    (((tmpvar_36 + tmpvar_41) - sqrt((
      dot (tmpvar_39, tmpvar_39)
     - 
      (tmpvar_40 * tmpvar_40)
    ))) / (2.0 * min (tmpvar_36, tmpvar_41)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_44;
  v_44.x = _ShadowBodies[0].y;
  v_44.y = _ShadowBodies[1].y;
  v_44.z = _ShadowBodies[2].y;
  float tmpvar_45;
  tmpvar_45 = _ShadowBodies[3].y;
  v_44.w = tmpvar_45;
  float tmpvar_46;
  tmpvar_46 = (3.141593 * (tmpvar_45 * tmpvar_45));
  vec3 tmpvar_47;
  tmpvar_47 = (v_44.xyz - xlv_TEXCOORD0);
  float tmpvar_48;
  tmpvar_48 = dot (tmpvar_47, normalize(tmpvar_37));
  float tmpvar_49;
  tmpvar_49 = (_SunRadius * (tmpvar_48 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_50;
  tmpvar_50 = (3.141593 * (tmpvar_49 * tmpvar_49));
  float x_51;
  x_51 = ((2.0 * clamp (
    (((tmpvar_45 + tmpvar_49) - sqrt((
      dot (tmpvar_47, tmpvar_47)
     - 
      (tmpvar_48 * tmpvar_48)
    ))) / (2.0 * min (tmpvar_45, tmpvar_49)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_52;
  v_52.x = _ShadowBodies[0].z;
  v_52.y = _ShadowBodies[1].z;
  v_52.z = _ShadowBodies[2].z;
  float tmpvar_53;
  tmpvar_53 = _ShadowBodies[3].z;
  v_52.w = tmpvar_53;
  float tmpvar_54;
  tmpvar_54 = (3.141593 * (tmpvar_53 * tmpvar_53));
  vec3 tmpvar_55;
  tmpvar_55 = (v_52.xyz - xlv_TEXCOORD0);
  float tmpvar_56;
  tmpvar_56 = dot (tmpvar_55, normalize(tmpvar_37));
  float tmpvar_57;
  tmpvar_57 = (_SunRadius * (tmpvar_56 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_58;
  tmpvar_58 = (3.141593 * (tmpvar_57 * tmpvar_57));
  float x_59;
  x_59 = ((2.0 * clamp (
    (((tmpvar_53 + tmpvar_57) - sqrt((
      dot (tmpvar_55, tmpvar_55)
     - 
      (tmpvar_56 * tmpvar_56)
    ))) / (2.0 * min (tmpvar_53, tmpvar_57)))
  , 0.0, 1.0)) - 1.0);
  vec4 v_60;
  v_60.x = _ShadowBodies[0].w;
  v_60.y = _ShadowBodies[1].w;
  v_60.z = _ShadowBodies[2].w;
  float tmpvar_61;
  tmpvar_61 = _ShadowBodies[3].w;
  v_60.w = tmpvar_61;
  float tmpvar_62;
  tmpvar_62 = (3.141593 * (tmpvar_61 * tmpvar_61));
  vec3 tmpvar_63;
  tmpvar_63 = (v_60.xyz - xlv_TEXCOORD0);
  float tmpvar_64;
  tmpvar_64 = dot (tmpvar_63, normalize(tmpvar_37));
  float tmpvar_65;
  tmpvar_65 = (_SunRadius * (tmpvar_64 / sqrt(
    dot (tmpvar_37, tmpvar_37)
  )));
  float tmpvar_66;
  tmpvar_66 = (3.141593 * (tmpvar_65 * tmpvar_65));
  float x_67;
  x_67 = ((2.0 * clamp (
    (((tmpvar_61 + tmpvar_65) - sqrt((
      dot (tmpvar_63, tmpvar_63)
     - 
      (tmpvar_64 * tmpvar_64)
    ))) / (2.0 * min (tmpvar_61, tmpvar_65)))
  , 0.0, 1.0)) - 1.0);
  color_2.xyz = (color_2.xyz * min (min (
    mix (1.0, clamp (((tmpvar_42 - 
      (((0.3183099 * (
        sign(x_43)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_43)
        )) * (1.570796 + (
          abs(x_43)
         * 
          (-0.2146018 + (abs(x_43) * (0.08656672 + (
            abs(x_43)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_38)
    ) / tmpvar_42), 0.0, 1.0), (float((tmpvar_40 >= tmpvar_36)) * clamp (tmpvar_38, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_50 - 
      (((0.3183099 * (
        sign(x_51)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_51)
        )) * (1.570796 + (
          abs(x_51)
         * 
          (-0.2146018 + (abs(x_51) * (0.08656672 + (
            abs(x_51)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_46)
    ) / tmpvar_50), 0.0, 1.0), (float((tmpvar_48 >= tmpvar_45)) * clamp (tmpvar_46, 0.0, 1.0)))
  ), min (
    mix (1.0, clamp (((tmpvar_58 - 
      (((0.3183099 * (
        sign(x_59)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_59)
        )) * (1.570796 + (
          abs(x_59)
         * 
          (-0.2146018 + (abs(x_59) * (0.08656672 + (
            abs(x_59)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_54)
    ) / tmpvar_58), 0.0, 1.0), (float((tmpvar_56 >= tmpvar_53)) * clamp (tmpvar_54, 0.0, 1.0)))
  , 
    mix (1.0, clamp (((tmpvar_66 - 
      (((0.3183099 * (
        sign(x_67)
       * 
        (1.570796 - (sqrt((1.0 - 
          abs(x_67)
        )) * (1.570796 + (
          abs(x_67)
         * 
          (-0.2146018 + (abs(x_67) * (0.08656672 + (
            abs(x_67)
           * -0.03102955))))
        ))))
      )) + 0.5) * tmpvar_62)
    ) / tmpvar_66), 0.0, 1.0), (float((tmpvar_64 >= tmpvar_61)) * clamp (tmpvar_62, 0.0, 1.0)))
  )));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  tmpvar_3.w = (tmpvar_30 * float((tmpvar_26 >= 0.0)));
  gl_FragData[0] = tmpvar_3;
  gl_FragDepth = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Matrix 8 [_DetailRotation]
Matrix 4 [_MainRotation]
Matrix 15 [_Object2World] 3
Matrix 12 [glstate_matrix_modelview0] 3
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Vector 19 [_ProjectionParams]
Vector 20 [_ScreenParams]
Vector 18 [_WorldSpaceCameraPos]
"vs_3_0
def c22, 0.5, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1.xyz
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dcl_texcoord6 o7
dcl_texcoord8 o8
mov r0.x, c15.w
mov r0.y, c16.w
mov r0.z, c17.w
dp4 r1.x, c15, v0
dp4 r1.y, c16, v0
dp4 r1.z, c17, v0
add r0.xyz, -r0, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o5.xyz, r0.w, r0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
dp4 r0.w, c7, v0
dp4 o3.x, c8, r0
dp4 o3.y, c9, r0
dp4 o3.z, c10, r0
dp4 o3.w, c11, r0
mov o4, r0
add r0.xyz, -r1, c18
mov o1.xyz, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o6.xyz, r0.w, r0
dp4 r0.x, c14, v0
mov o8.z, -r0.x
mov r0.xyz, c18
add o2.xyz, -r0, c21
dp4 r0.x, c0, v0
dp4 r0.y, c1, v0
dp4 r0.z, c2, v0
dp4 r0.w, c3, v0
mov o0, r0
mul r1.xz, r0.xyww, c22.x
mul r1.y, r0.y, c19.x
mul r1.w, r1.y, c22.x
mad r0.xy, r1.z, c20.zwzw, r1.xwzw
mov o7, r0
mov o8.xyw, r0

"
}
SubProgram "d3d11 " {
// Stats: 34 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
ConstBuffer "$Globals" 464
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Vector 448 [_PlanetOrigin] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 319 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform lowp samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec3 cubeVect_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  highp float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec2 tmpvar_12;
  tmpvar_12 = ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_UVNoiseTex, tmpvar_12);
  cubeVect_4.xy = (tmpvar_5.xy + ((tmpvar_13.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureCube (cube_MainTex, cubeVect_4);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  mediump vec2 uv_16;
  mediump vec3 detailCoords_17;
  mediump float s_18;
  mediump float nylerp_19;
  mediump float zxlerp_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_21);
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  zxlerp_20 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  nylerp_19 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = mix (tmpvar_21.x, tmpvar_21.z, zxlerp_20);
  s_18 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = sign(mix (tmpvar_21.y, s_18, nylerp_19));
  s_18 = tmpvar_26;
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = -(s_18);
  mediump vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = s_18;
  highp vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_27 * tmpvar_21.xzy), (tmpvar_28 * tmpvar_21.zxy), vec3(zxlerp_20));
  detailCoords_17 = tmpvar_29;
  mediump vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = s_18;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_21.yxz), detailCoords_17, vec3(nylerp_19));
  detailCoords_17 = tmpvar_31;
  uv_16 = (((
    (0.5 * detailCoords_17.yz)
   / 
    abs(detailCoords_17.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_32;
  uv_32 = uv_16;
  highp vec2 uvCont_33;
  highp vec2 tmpvar_34;
  tmpvar_34 = abs((uv_32 - (0.5 * _DetailScale)));
  uvCont_33.x = max (tmpvar_34.x, tmpvar_34.y);
  uvCont_33.y = min (tmpvar_34.x, tmpvar_34.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_33);
  tmpvar_35.zw = dFdy(uvCont_33);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_DetailTex, uv_16, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  highp vec3 tmpvar_38;
  tmpvar_38 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_38, tmpvar_38)
  )), 0.0, 1.0);
  tmpvar_39 = tmpvar_40;
  color_2 = ((_Color * tmpvar_15) * mix (tmpvar_37, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_39)));
  highp float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_42;
  tmpvar_42 = sqrt(dot (tmpvar_38, tmpvar_38));
  highp vec3 tmpvar_43;
  tmpvar_43 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_44;
  tmpvar_44 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_45;
  tmpvar_45 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_42), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_42)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_41, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_43, tmpvar_43)) - (_RimDistSub * sqrt(
      dot (tmpvar_44, tmpvar_44)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_45;
  mediump float tmpvar_46;
  tmpvar_46 = color_2.w;
  lowp float tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_47 = tmpvar_48;
  mediump vec3 normal_49;
  normal_49 = xlv_TEXCOORD4;
  mediump float atten_50;
  atten_50 = tmpvar_47;
  mediump vec4 c_51;
  mediump vec3 tmpvar_52;
  tmpvar_52 = normalize(normal_49);
  normal_49 = tmpvar_52;
  mediump float tmpvar_53;
  tmpvar_53 = dot (tmpvar_52, normalize(_WorldSpaceLightPos0.xyz));
  c_51.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_53)) * (atten_50 * 2.0));
  c_51.w = (tmpvar_53 * (atten_50 * 2.0));
  mediump vec3 normal_54;
  normal_54 = xlv_TEXCOORD4;
  mediump float tmpvar_55;
  tmpvar_55 = dot (normal_54, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_51 * mix (1.0, clamp (
    floor((1.01 + tmpvar_55))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_55))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_46;
  highp vec4 v_56;
  v_56.x = _ShadowBodies[0].x;
  v_56.y = _ShadowBodies[1].x;
  v_56.z = _ShadowBodies[2].x;
  highp float tmpvar_57;
  tmpvar_57 = _ShadowBodies[3].x;
  v_56.w = tmpvar_57;
  mediump float tmpvar_58;
  highp vec3 tmpvar_59;
  tmpvar_59 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_60;
  tmpvar_60 = (3.141593 * (tmpvar_57 * tmpvar_57));
  highp vec3 tmpvar_61;
  tmpvar_61 = (v_56.xyz - xlv_TEXCOORD0);
  highp float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, normalize(tmpvar_59));
  highp float tmpvar_63;
  tmpvar_63 = (_SunRadius * (tmpvar_62 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_64;
  tmpvar_64 = (3.141593 * (tmpvar_63 * tmpvar_63));
  highp float x_65;
  x_65 = ((2.0 * clamp (
    (((tmpvar_57 + tmpvar_63) - sqrt((
      dot (tmpvar_61, tmpvar_61)
     - 
      (tmpvar_62 * tmpvar_62)
    ))) / (2.0 * min (tmpvar_57, tmpvar_63)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_66;
  tmpvar_66 = mix (1.0, clamp ((
    (tmpvar_64 - (((0.3183099 * 
      (sign(x_65) * (1.570796 - (sqrt(
        (1.0 - abs(x_65))
      ) * (1.570796 + 
        (abs(x_65) * (-0.2146018 + (abs(x_65) * (0.08656672 + 
          (abs(x_65) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_60))
   / tmpvar_64), 0.0, 1.0), (float(
    (tmpvar_62 >= tmpvar_57)
  ) * clamp (tmpvar_60, 0.0, 1.0)));
  tmpvar_58 = tmpvar_66;
  highp vec4 v_67;
  v_67.x = _ShadowBodies[0].y;
  v_67.y = _ShadowBodies[1].y;
  v_67.z = _ShadowBodies[2].y;
  highp float tmpvar_68;
  tmpvar_68 = _ShadowBodies[3].y;
  v_67.w = tmpvar_68;
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (3.141593 * (tmpvar_68 * tmpvar_68));
  highp vec3 tmpvar_71;
  tmpvar_71 = (v_67.xyz - xlv_TEXCOORD0);
  highp float tmpvar_72;
  tmpvar_72 = dot (tmpvar_71, normalize(tmpvar_59));
  highp float tmpvar_73;
  tmpvar_73 = (_SunRadius * (tmpvar_72 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_74;
  tmpvar_74 = (3.141593 * (tmpvar_73 * tmpvar_73));
  highp float x_75;
  x_75 = ((2.0 * clamp (
    (((tmpvar_68 + tmpvar_73) - sqrt((
      dot (tmpvar_71, tmpvar_71)
     - 
      (tmpvar_72 * tmpvar_72)
    ))) / (2.0 * min (tmpvar_68, tmpvar_73)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_76;
  tmpvar_76 = mix (1.0, clamp ((
    (tmpvar_74 - (((0.3183099 * 
      (sign(x_75) * (1.570796 - (sqrt(
        (1.0 - abs(x_75))
      ) * (1.570796 + 
        (abs(x_75) * (-0.2146018 + (abs(x_75) * (0.08656672 + 
          (abs(x_75) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_70))
   / tmpvar_74), 0.0, 1.0), (float(
    (tmpvar_72 >= tmpvar_68)
  ) * clamp (tmpvar_70, 0.0, 1.0)));
  tmpvar_69 = tmpvar_76;
  highp vec4 v_77;
  v_77.x = _ShadowBodies[0].z;
  v_77.y = _ShadowBodies[1].z;
  v_77.z = _ShadowBodies[2].z;
  highp float tmpvar_78;
  tmpvar_78 = _ShadowBodies[3].z;
  v_77.w = tmpvar_78;
  mediump float tmpvar_79;
  highp float tmpvar_80;
  tmpvar_80 = (3.141593 * (tmpvar_78 * tmpvar_78));
  highp vec3 tmpvar_81;
  tmpvar_81 = (v_77.xyz - xlv_TEXCOORD0);
  highp float tmpvar_82;
  tmpvar_82 = dot (tmpvar_81, normalize(tmpvar_59));
  highp float tmpvar_83;
  tmpvar_83 = (_SunRadius * (tmpvar_82 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_84;
  tmpvar_84 = (3.141593 * (tmpvar_83 * tmpvar_83));
  highp float x_85;
  x_85 = ((2.0 * clamp (
    (((tmpvar_78 + tmpvar_83) - sqrt((
      dot (tmpvar_81, tmpvar_81)
     - 
      (tmpvar_82 * tmpvar_82)
    ))) / (2.0 * min (tmpvar_78, tmpvar_83)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_86;
  tmpvar_86 = mix (1.0, clamp ((
    (tmpvar_84 - (((0.3183099 * 
      (sign(x_85) * (1.570796 - (sqrt(
        (1.0 - abs(x_85))
      ) * (1.570796 + 
        (abs(x_85) * (-0.2146018 + (abs(x_85) * (0.08656672 + 
          (abs(x_85) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_80))
   / tmpvar_84), 0.0, 1.0), (float(
    (tmpvar_82 >= tmpvar_78)
  ) * clamp (tmpvar_80, 0.0, 1.0)));
  tmpvar_79 = tmpvar_86;
  highp vec4 v_87;
  v_87.x = _ShadowBodies[0].w;
  v_87.y = _ShadowBodies[1].w;
  v_87.z = _ShadowBodies[2].w;
  highp float tmpvar_88;
  tmpvar_88 = _ShadowBodies[3].w;
  v_87.w = tmpvar_88;
  mediump float tmpvar_89;
  highp float tmpvar_90;
  tmpvar_90 = (3.141593 * (tmpvar_88 * tmpvar_88));
  highp vec3 tmpvar_91;
  tmpvar_91 = (v_87.xyz - xlv_TEXCOORD0);
  highp float tmpvar_92;
  tmpvar_92 = dot (tmpvar_91, normalize(tmpvar_59));
  highp float tmpvar_93;
  tmpvar_93 = (_SunRadius * (tmpvar_92 / sqrt(
    dot (tmpvar_59, tmpvar_59)
  )));
  highp float tmpvar_94;
  tmpvar_94 = (3.141593 * (tmpvar_93 * tmpvar_93));
  highp float x_95;
  x_95 = ((2.0 * clamp (
    (((tmpvar_88 + tmpvar_93) - sqrt((
      dot (tmpvar_91, tmpvar_91)
     - 
      (tmpvar_92 * tmpvar_92)
    ))) / (2.0 * min (tmpvar_88, tmpvar_93)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_96;
  tmpvar_96 = mix (1.0, clamp ((
    (tmpvar_94 - (((0.3183099 * 
      (sign(x_95) * (1.570796 - (sqrt(
        (1.0 - abs(x_95))
      ) * (1.570796 + 
        (abs(x_95) * (-0.2146018 + (abs(x_95) * (0.08656672 + 
          (abs(x_95) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_90))
   / tmpvar_94), 0.0, 1.0), (float(
    (tmpvar_92 >= tmpvar_88)
  ) * clamp (tmpvar_90, 0.0, 1.0)));
  tmpvar_89 = tmpvar_96;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_58, tmpvar_69), min (tmpvar_79, tmpvar_89)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_97;
  tmpvar_97 = float((tmpvar_41 >= 0.0));
  tmpvar_3.w = (tmpvar_46 * tmpvar_97);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in  vec4 in_POSITION0;
out vec3 vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
out vec4 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
vec4 t2;
vec4 t3;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD4.xyz = vec3(t13) * t2.xyz;
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t1.x = t0.y * _ProjectionParams.x;
    t1.w = t1.x * 0.5;
    t1.xz = t0.xw * vec2(0.5, 0.5);
    t0.xy = t1.zz + t1.xw;
    vs_TEXCOORD6 = t0;
    vs_TEXCOORD8.xyw = t0.xyw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
in  vec4 vs_TEXCOORD8;
out vec4 SV_Target0;
vec3 t0;
bool tb0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
vec4 t3;
mediump vec4 t16_3;
vec3 t4;
vec3 t5;
vec3 t6;
int ti6;
bool tb6;
float t7;
float t8;
float t9;
vec2 t12;
mediump float t16_12;
bool tb12;
float t13;
bvec2 tb13;
float t18;
bool tb18;
float t19;
int ti20;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t18 = dot(t0.xyz, t0.xyz);
    t1.xyz = (-vs_TEXCOORD0.xyz) + vec3(_SunPos.x, _SunPos.y, _SunPos.z);
    t19 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t19);
    t19 = sqrt(t19);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = (-t0.x) * t0.x + t18;
    t6.x = sqrt(t6.x);
    t12.x = t0.x / t19;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t18 = _SunRadius * t12.x + _ShadowBodies[3].x;
    t12.x = t12.x * _SunRadius;
    t6.x = (-t6.x) + t18;
    t18 = min(t12.x, _ShadowBodies[3].x);
    t12.x = t12.x * t12.x;
    t12.x = t12.x * 3.14159274;
    t18 = t18 + t18;
    t6.x = t6.x / t18;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x * 2.0 + -1.0;
    t18 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t18 = t18 * abs(t6.x) + -0.212114394;
    t18 = t18 * abs(t6.x) + 1.57072878;
    t2.x = -abs(t6.x) + 1.0;
    tb6 = t6.x<(-t6.x);
    t2.x = sqrt(t2.x);
    t8 = t18 * t2.x;
    t8 = t8 * -2.0 + 3.14159274;
    t6.x = tb6 ? t8 : float(0.0);
    t6.x = t18 * t2.x + t6.x;
    t6.x = (-t6.x) + 1.57079637;
    t6.x = t6.x * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t6.x = (-t6.x) * t2.x + t12.x;
    t6.x = t6.x / t12.x;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t6.x = t6.x + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t6.x + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].y;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.y * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].y;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].y);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t3.x = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t3.x = sqrt(t3.x);
    t9 = t2.x * t3.x;
    t9 = t9 * -2.0 + 3.14159274;
    t12.x = tb12 ? t9 : float(0.0);
    t12.x = t2.x * t3.x + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.y + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = min(t6.x, t0.x);
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t6.x = dot(t4.xyz, t1.xyz);
    t12.x = dot(t4.xyz, t4.xyz);
    t12.x = (-t6.x) * t6.x + t12.x;
    t12.x = sqrt(t12.x);
    t18 = t6.x / t19;
    tb6 = t6.x>=_ShadowBodies[3].z;
    t6.x = tb6 ? 1.0 : float(0.0);
    t6.x = t3.z * t6.x;
    t2.x = _SunRadius * t18 + _ShadowBodies[3].z;
    t18 = t18 * _SunRadius;
    t12.x = (-t12.x) + t2.x;
    t2.x = min(t18, _ShadowBodies[3].z);
    t18 = t18 * t18;
    t18 = t18 * 3.14159274;
    t2.x = t2.x + t2.x;
    t12.x = t12.x / t2.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x * 2.0 + -1.0;
    t2.x = abs(t12.x) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t12.x) + -0.212114394;
    t2.x = t2.x * abs(t12.x) + 1.57072878;
    t8 = -abs(t12.x) + 1.0;
    tb12 = t12.x<(-t12.x);
    t8 = sqrt(t8);
    t3.x = t8 * t2.x;
    t3.x = t3.x * -2.0 + 3.14159274;
    t12.x = tb12 ? t3.x : float(0.0);
    t12.x = t2.x * t8 + t12.x;
    t12.x = (-t12.x) + 1.57079637;
    t12.x = t12.x * 0.318309873 + 0.5;
    t12.x = (-t12.x) * t2.z + t18;
    t12.x = t12.x / t18;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t12.x = dot(t2.xyz, t1.xyz);
    t18 = dot(t2.xyz, t2.xyz);
    t18 = (-t12.x) * t12.x + t18;
    t18 = sqrt(t18);
    t1.x = t12.x / t19;
    tb12 = t12.x>=_ShadowBodies[3].w;
    t12.x = tb12 ? 1.0 : float(0.0);
    t12.x = t3.w * t12.x;
    t7 = _SunRadius * t1.x + _ShadowBodies[3].w;
    t1.x = t1.x * _SunRadius;
    t18 = (-t18) + t7;
    t7 = min(t1.x, _ShadowBodies[3].w);
    t1.x = t1.x * t1.x;
    t1.x = t1.x * 3.14159274;
    t7 = t7 + t7;
    t18 = t18 / t7;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 * 2.0 + -1.0;
    t7 = abs(t18) * -0.0187292993 + 0.0742610022;
    t7 = t7 * abs(t18) + -0.212114394;
    t7 = t7 * abs(t18) + 1.57072878;
    t13 = -abs(t18) + 1.0;
    tb18 = t18<(-t18);
    t13 = sqrt(t13);
    t19 = t13 * t7;
    t19 = t19 * -2.0 + 3.14159274;
    t18 = tb18 ? t19 : float(0.0);
    t18 = t7 * t13 + t18;
    t18 = (-t18) + 1.57079637;
    t18 = t18 * 0.318309873 + 0.5;
    t18 = (-t18) * t2.w + t1.x;
    t18 = t18 / t1.x;
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t6.x = min(t12.x, t6.x);
    t0.x = min(t6.x, t0.x);
    t6.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t6.x = inversesqrt(t6.x);
    t6.xyz = t6.xxx * vs_TEXCOORD3.xyz;
    t1.xy = t6.xy / vec2(_UVNoiseScale);
    tb13.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb13.x) ? t1.x : (-t1.x);
    t1.y = (tb13.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(_UVNoiseScale);
    t1.xy = t1.xy / vec2(_UVNoiseScale);
    t1.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t1.xy;
    t10_1 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t6.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t6.xy;
    t10_1 = texture(cube_MainTex, t6.xyz);
    t1 = t10_1 * _Color;
    t2.xz = vec2(1.0, -1.0);
    t6.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t6.x = inversesqrt(t6.x);
    t3.xyz = t6.xxx * vs_TEXCOORD2.yxz;
    t12.x = vs_TEXCOORD2.z * t6.x + (-t3.y);
    tb18 = abs(t3.z)>=abs(t3.y);
    t18 = tb18 ? 1.0 : float(0.0);
    t12.x = t18 * t12.x + t3.y;
    t6.x = (-vs_TEXCOORD2.y) * t6.x + t12.x;
    t12.x = max(abs(t3.z), abs(t3.y));
    tb12 = t12.x>=abs(t3.x);
    t12.x = tb12 ? 1.0 : float(0.0);
    t6.x = t12.x * t6.x + t3.x;
    ti20 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti20) + ti6;
    t4.y = float(ti6);
    t2.y = (-t4.y);
    t2.xyz = t2.xyz * t3.yzx;
    t4.xz = vec2(1.0, -1.0);
    t5.xyz = t4.xyz * t3.zyx + (-t2.xyz);
    t2.xyz = vec3(t18) * t5.xyz + t2.xyz;
    t2.xyz = (-t4.xxy) * t3.xyz + t2.xyz;
    t3.xyz = t3.xyz * t4.xxy;
    t6.xyz = t12.xxx * t2.xyz + t3.xyz;
    t12.xy = t6.yz * vec2(0.5, 0.5);
    t6.xy = t12.xy / abs(t6.xx);
    t6.xy = t6.xy + vec2(0.5, 0.5);
    t6.xy = t6.xy * vec2(vec2(_DetailScale, _DetailScale));
    t2.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t6.xy;
    t18 = max(abs(t2.y), abs(t2.x));
    t2.x = min(abs(t2.y), abs(t2.x));
    t3.x = dFdx(t18);
    t4.x = dFdy(t18);
    t3.y = dFdx(t2.x);
    t4.y = dFdy(t2.x);
    t10_2 = textureGrad(_DetailTex, t6.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_3 = (-t10_2) + vec4(1.0, 1.0, 1.0, 1.0);
    t6.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t6.x = dot(t6.xyz, t6.xyz);
    t6.x = sqrt(t6.x);
    t12.x = dot(t6.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t12.x = clamp(t12.x, 0.0, 1.0);
    t2 = t12.xxxx * t16_3 + t10_2;
    t1 = t1 * t2;
    t12.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t12.x = inversesqrt(t12.x);
    t3.xyz = t12.xxx * vs_TEXCOORD4.xyz;
    t12.x = dot(t3.xyz, t2.xyz);
    t1.xyz = t12.xxx * t1.xyz;
    t1.xyz = t1.xyz * _LightColor0.xyz;
    t12.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t12.xy);
    t16_12 = t10_2.x + t10_2.x;
    t1.xyz = vec3(t16_12) * t1.xyz;
    t12.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t12.x = inversesqrt(t12.x);
    t2.xyz = t12.xxx * _WorldSpaceLightPos0.xyz;
    t12.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t18 = t12.x + 1.00999999;
    t12.x = t12.x * -10.0;
    t12.x = clamp(t12.x, 0.0, 1.0);
    t18 = floor(t18);
    t18 = clamp(t18, 0.0, 1.0);
    t18 = t18 + -1.0;
    t12.x = t12.x * t18 + 1.0;
    t1.xyz = t12.xxx * t1.xyz;
    SV_Target0.xyz = t0.xxx * t1.xyz;
    t0.x = t6.x * _DistFade;
    t6.x = (-_DistFadeVert) * t6.x + 1.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t0.x = t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) * t6.x + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t12.x = t6.x;
    t12.x = clamp(t12.x, 0.0, 1.0);
    tb6 = t6.x>=0.0;
    t6.x = tb6 ? 1.0 : float(0.0);
    t12.x = t12.x * _FalloffScale;
    t12.x = log2(t12.x);
    t12.x = t12.x * _FalloffPow;
    t12.x = exp2(t12.x);
    t12.x = min(t12.x, 1.0);
    t12.x = (-t0.x) + t12.x;
    t1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t18 = dot(t1.xyz, t1.xyz);
    t18 = sqrt(t18);
    t1.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t1.x = dot(t1.xyz, t1.xyz);
    t1.x = sqrt(t1.x);
    t18 = (-_RimDistSub) * t1.x + t18;
    t18 = t18 * _RimDist;
    t18 = clamp(t18, 0.0, 1.0);
    t0.x = t18 * t12.x + t0.x;
    t0.x = t1.w * t0.x;
    SV_Target0.w = t6.x * t0.x;
    t0.x = vs_TEXCOORD8.z * _DepthPull;
    t6.x = t0.x * _ZBufferParams.z;
    t0.x = (-t0.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t0.x / t6.x;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 318 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform lowp samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec3 cubeVect_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  highp float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec2 tmpvar_12;
  tmpvar_12 = ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_UVNoiseTex, tmpvar_12);
  cubeVect_4.xy = (tmpvar_5.xy + ((tmpvar_13.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureCube (cube_MainTex, cubeVect_4);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  mediump vec2 uv_16;
  mediump vec3 detailCoords_17;
  mediump float s_18;
  mediump float nylerp_19;
  mediump float zxlerp_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_21);
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  zxlerp_20 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  nylerp_19 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = mix (tmpvar_21.x, tmpvar_21.z, zxlerp_20);
  s_18 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = sign(mix (tmpvar_21.y, s_18, nylerp_19));
  s_18 = tmpvar_26;
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = -(s_18);
  mediump vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = s_18;
  highp vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_27 * tmpvar_21.xzy), (tmpvar_28 * tmpvar_21.zxy), vec3(zxlerp_20));
  detailCoords_17 = tmpvar_29;
  mediump vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = s_18;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_21.yxz), detailCoords_17, vec3(nylerp_19));
  detailCoords_17 = tmpvar_31;
  uv_16 = (((
    (0.5 * detailCoords_17.yz)
   / 
    abs(detailCoords_17.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_32;
  uv_32 = uv_16;
  highp vec2 uvCont_33;
  highp vec2 tmpvar_34;
  tmpvar_34 = abs((uv_32 - (0.5 * _DetailScale)));
  uvCont_33.x = max (tmpvar_34.x, tmpvar_34.y);
  uvCont_33.y = min (tmpvar_34.x, tmpvar_34.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_33);
  tmpvar_35.zw = dFdy(uvCont_33);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_DetailTex, uv_16, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  highp vec3 tmpvar_38;
  tmpvar_38 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_38, tmpvar_38)
  )), 0.0, 1.0);
  tmpvar_39 = tmpvar_40;
  color_2 = ((_Color * tmpvar_15) * mix (tmpvar_37, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_39)));
  highp float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_42;
  tmpvar_42 = sqrt(dot (tmpvar_38, tmpvar_38));
  highp vec3 tmpvar_43;
  tmpvar_43 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_44;
  tmpvar_44 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_45;
  tmpvar_45 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_42), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_42)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_41, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_43, tmpvar_43)) - (_RimDistSub * sqrt(
      dot (tmpvar_44, tmpvar_44)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_45;
  mediump float tmpvar_46;
  tmpvar_46 = color_2.w;
  lowp float shadow_47;
  shadow_47 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 normal_48;
  normal_48 = xlv_TEXCOORD4;
  mediump float atten_49;
  atten_49 = shadow_47;
  mediump vec4 c_50;
  mediump vec3 tmpvar_51;
  tmpvar_51 = normalize(normal_48);
  normal_48 = tmpvar_51;
  mediump float tmpvar_52;
  tmpvar_52 = dot (tmpvar_51, normalize(_WorldSpaceLightPos0.xyz));
  c_50.xyz = ((_LightColor0.xyz * (color_2.xyz * tmpvar_52)) * (atten_49 * 2.0));
  c_50.w = (tmpvar_52 * (atten_49 * 2.0));
  mediump vec3 normal_53;
  normal_53 = xlv_TEXCOORD4;
  mediump float tmpvar_54;
  tmpvar_54 = dot (normal_53, normalize(_WorldSpaceLightPos0).xyz);
  color_2.xyz = (c_50 * mix (1.0, clamp (
    floor((1.01 + tmpvar_54))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_54))
  , 0.0, 1.0))).xyz;
  color_2.w = tmpvar_46;
  highp vec4 v_55;
  v_55.x = _ShadowBodies[0].x;
  v_55.y = _ShadowBodies[1].x;
  v_55.z = _ShadowBodies[2].x;
  highp float tmpvar_56;
  tmpvar_56 = _ShadowBodies[3].x;
  v_55.w = tmpvar_56;
  mediump float tmpvar_57;
  highp vec3 tmpvar_58;
  tmpvar_58 = (_SunPos - xlv_TEXCOORD0);
  highp float tmpvar_59;
  tmpvar_59 = (3.141593 * (tmpvar_56 * tmpvar_56));
  highp vec3 tmpvar_60;
  tmpvar_60 = (v_55.xyz - xlv_TEXCOORD0);
  highp float tmpvar_61;
  tmpvar_61 = dot (tmpvar_60, normalize(tmpvar_58));
  highp float tmpvar_62;
  tmpvar_62 = (_SunRadius * (tmpvar_61 / sqrt(
    dot (tmpvar_58, tmpvar_58)
  )));
  highp float tmpvar_63;
  tmpvar_63 = (3.141593 * (tmpvar_62 * tmpvar_62));
  highp float x_64;
  x_64 = ((2.0 * clamp (
    (((tmpvar_56 + tmpvar_62) - sqrt((
      dot (tmpvar_60, tmpvar_60)
     - 
      (tmpvar_61 * tmpvar_61)
    ))) / (2.0 * min (tmpvar_56, tmpvar_62)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_65;
  tmpvar_65 = mix (1.0, clamp ((
    (tmpvar_63 - (((0.3183099 * 
      (sign(x_64) * (1.570796 - (sqrt(
        (1.0 - abs(x_64))
      ) * (1.570796 + 
        (abs(x_64) * (-0.2146018 + (abs(x_64) * (0.08656672 + 
          (abs(x_64) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_59))
   / tmpvar_63), 0.0, 1.0), (float(
    (tmpvar_61 >= tmpvar_56)
  ) * clamp (tmpvar_59, 0.0, 1.0)));
  tmpvar_57 = tmpvar_65;
  highp vec4 v_66;
  v_66.x = _ShadowBodies[0].y;
  v_66.y = _ShadowBodies[1].y;
  v_66.z = _ShadowBodies[2].y;
  highp float tmpvar_67;
  tmpvar_67 = _ShadowBodies[3].y;
  v_66.w = tmpvar_67;
  mediump float tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = (3.141593 * (tmpvar_67 * tmpvar_67));
  highp vec3 tmpvar_70;
  tmpvar_70 = (v_66.xyz - xlv_TEXCOORD0);
  highp float tmpvar_71;
  tmpvar_71 = dot (tmpvar_70, normalize(tmpvar_58));
  highp float tmpvar_72;
  tmpvar_72 = (_SunRadius * (tmpvar_71 / sqrt(
    dot (tmpvar_58, tmpvar_58)
  )));
  highp float tmpvar_73;
  tmpvar_73 = (3.141593 * (tmpvar_72 * tmpvar_72));
  highp float x_74;
  x_74 = ((2.0 * clamp (
    (((tmpvar_67 + tmpvar_72) - sqrt((
      dot (tmpvar_70, tmpvar_70)
     - 
      (tmpvar_71 * tmpvar_71)
    ))) / (2.0 * min (tmpvar_67, tmpvar_72)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_75;
  tmpvar_75 = mix (1.0, clamp ((
    (tmpvar_73 - (((0.3183099 * 
      (sign(x_74) * (1.570796 - (sqrt(
        (1.0 - abs(x_74))
      ) * (1.570796 + 
        (abs(x_74) * (-0.2146018 + (abs(x_74) * (0.08656672 + 
          (abs(x_74) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_69))
   / tmpvar_73), 0.0, 1.0), (float(
    (tmpvar_71 >= tmpvar_67)
  ) * clamp (tmpvar_69, 0.0, 1.0)));
  tmpvar_68 = tmpvar_75;
  highp vec4 v_76;
  v_76.x = _ShadowBodies[0].z;
  v_76.y = _ShadowBodies[1].z;
  v_76.z = _ShadowBodies[2].z;
  highp float tmpvar_77;
  tmpvar_77 = _ShadowBodies[3].z;
  v_76.w = tmpvar_77;
  mediump float tmpvar_78;
  highp float tmpvar_79;
  tmpvar_79 = (3.141593 * (tmpvar_77 * tmpvar_77));
  highp vec3 tmpvar_80;
  tmpvar_80 = (v_76.xyz - xlv_TEXCOORD0);
  highp float tmpvar_81;
  tmpvar_81 = dot (tmpvar_80, normalize(tmpvar_58));
  highp float tmpvar_82;
  tmpvar_82 = (_SunRadius * (tmpvar_81 / sqrt(
    dot (tmpvar_58, tmpvar_58)
  )));
  highp float tmpvar_83;
  tmpvar_83 = (3.141593 * (tmpvar_82 * tmpvar_82));
  highp float x_84;
  x_84 = ((2.0 * clamp (
    (((tmpvar_77 + tmpvar_82) - sqrt((
      dot (tmpvar_80, tmpvar_80)
     - 
      (tmpvar_81 * tmpvar_81)
    ))) / (2.0 * min (tmpvar_77, tmpvar_82)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_85;
  tmpvar_85 = mix (1.0, clamp ((
    (tmpvar_83 - (((0.3183099 * 
      (sign(x_84) * (1.570796 - (sqrt(
        (1.0 - abs(x_84))
      ) * (1.570796 + 
        (abs(x_84) * (-0.2146018 + (abs(x_84) * (0.08656672 + 
          (abs(x_84) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_79))
   / tmpvar_83), 0.0, 1.0), (float(
    (tmpvar_81 >= tmpvar_77)
  ) * clamp (tmpvar_79, 0.0, 1.0)));
  tmpvar_78 = tmpvar_85;
  highp vec4 v_86;
  v_86.x = _ShadowBodies[0].w;
  v_86.y = _ShadowBodies[1].w;
  v_86.z = _ShadowBodies[2].w;
  highp float tmpvar_87;
  tmpvar_87 = _ShadowBodies[3].w;
  v_86.w = tmpvar_87;
  mediump float tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = (3.141593 * (tmpvar_87 * tmpvar_87));
  highp vec3 tmpvar_90;
  tmpvar_90 = (v_86.xyz - xlv_TEXCOORD0);
  highp float tmpvar_91;
  tmpvar_91 = dot (tmpvar_90, normalize(tmpvar_58));
  highp float tmpvar_92;
  tmpvar_92 = (_SunRadius * (tmpvar_91 / sqrt(
    dot (tmpvar_58, tmpvar_58)
  )));
  highp float tmpvar_93;
  tmpvar_93 = (3.141593 * (tmpvar_92 * tmpvar_92));
  highp float x_94;
  x_94 = ((2.0 * clamp (
    (((tmpvar_87 + tmpvar_92) - sqrt((
      dot (tmpvar_90, tmpvar_90)
     - 
      (tmpvar_91 * tmpvar_91)
    ))) / (2.0 * min (tmpvar_87, tmpvar_92)))
  , 0.0, 1.0)) - 1.0);
  highp float tmpvar_95;
  tmpvar_95 = mix (1.0, clamp ((
    (tmpvar_93 - (((0.3183099 * 
      (sign(x_94) * (1.570796 - (sqrt(
        (1.0 - abs(x_94))
      ) * (1.570796 + 
        (abs(x_94) * (-0.2146018 + (abs(x_94) * (0.08656672 + 
          (abs(x_94) * -0.03102955)
        ))))
      ))))
    ) + 0.5) * tmpvar_89))
   / tmpvar_93), 0.0, 1.0), (float(
    (tmpvar_91 >= tmpvar_87)
  ) * clamp (tmpvar_89, 0.0, 1.0)));
  tmpvar_88 = tmpvar_95;
  color_2.xyz = (color_2.xyz * min (min (tmpvar_57, tmpvar_68), min (tmpvar_78, tmpvar_88)));
  tmpvar_3.xyz = color_2.xyz;
  depthWithOffset_1 = (xlv_TEXCOORD8.z * _DepthPull);
  highp float tmpvar_96;
  tmpvar_96 = float((tmpvar_41 >= 0.0));
  tmpvar_3.w = (tmpvar_46 * tmpvar_96);
  gl_FragData[0] = tmpvar_3;
  gl_FragDepthEXT = ((1.0 - (depthWithOffset_1 * _ZBufferParams.w)) / (depthWithOffset_1 * _ZBufferParams.z));
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
in highp vec4 in_POSITION0;
out highp vec3 vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec4 vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
out highp vec4 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
highp vec4 t3;
highp float t8;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    vs_TEXCOORD0.xyz = t1.xyz;
    vs_TEXCOORD1.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t2 = in_POSITION0.yyyy * _MainRotation[1];
    t2 = _MainRotation[0] * in_POSITION0.xxxx + t2;
    t2 = _MainRotation[2] * in_POSITION0.zzzz + t2;
    t2 = _MainRotation[3] * in_POSITION0.wwww + t2;
    t3 = t2.yyyy * _DetailRotation[1];
    t3 = _DetailRotation[0] * t2.xxxx + t3;
    t3 = _DetailRotation[2] * t2.zzzz + t3;
    vs_TEXCOORD2 = _DetailRotation[3] * t2.wwww + t3;
    vs_TEXCOORD3 = t2;
    t2.xyz = t1.xyz + (-_Object2World[3].xyz);
    t1.xyz = (-t1.xyz) + _WorldSpaceCameraPos.xyzx.xyz;
    t8 = dot(t2.xyz, t2.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD4.xyz = vec3(t8) * t2.xyz;
    t8 = dot(t1.xyz, t1.xyz);
    t8 = inversesqrt(t8);
    vs_TEXCOORD5.xyz = vec3(t8) * t1.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD6 = t1;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD8.w = t0.w;
    vs_TEXCOORD8.xy = t1.zz + t1.xw;
    t0.x = in_POSITION0.y * glstate_matrix_modelview0[1].z;
    t0.x = glstate_matrix_modelview0[0].z * in_POSITION0.x + t0.x;
    t0.x = glstate_matrix_modelview0[2].z * in_POSITION0.z + t0.x;
    t0.x = glstate_matrix_modelview0[3].z * in_POSITION0.w + t0.x;
    vs_TEXCOORD8.z = (-t0.x);
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _FalloffPow;
uniform 	float _FalloffScale;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	float _MinLight;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _RimDist;
uniform 	float _RimDistSub;
uniform 	float _OceanRadius;
uniform 	float _InvFade;
uniform 	vec3 _PlanetOrigin;
uniform 	float _DepthPull;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp samplerCube cube_MainTex;
uniform lowp sampler2D _DetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD0;
in highp vec4 vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
in highp vec4 vs_TEXCOORD8;
layout(location = 0) out mediump vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec4 t2;
mediump vec4 t16_2;
bool tb2;
highp vec4 t3;
highp vec3 t4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp float t8;
bool tb8;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t11;
mediump vec3 t16_11;
bool tb11;
mediump vec3 t16_13;
highp float t16;
bool tb16;
highp vec2 t17;
bvec2 tb17;
highp int ti18;
highp float t19;
mediump float t16_21;
highp float t24;
highp float t25;
highp float t27;
void main()
{
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].x;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].x;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].x;
    t24 = dot(t0.xyz, t0.xyz);
    t1.xyz = vec3((-vs_TEXCOORD0.x) + _SunPos.xxyz.y, (-vs_TEXCOORD0.y) + _SunPos.xxyz.z, (-vs_TEXCOORD0.z) + float(_SunPos.z));
    t25 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t25);
    t25 = sqrt(t25);
    t1.xyz = t1.xyz * t2.xxx;
    t0.x = dot(t0.xyz, t1.xyz);
    t8 = (-t0.x) * t0.x + t24;
    t8 = sqrt(t8);
    t16 = t0.x / t25;
    tb0 = t0.x>=_ShadowBodies[3].x;
    t0.x = tb0 ? 1.0 : float(0.0);
    t24 = _SunRadius * t16 + _ShadowBodies[3].x;
    t16 = t16 * _SunRadius;
    t8 = (-t8) + t24;
    t24 = min(t16, _ShadowBodies[3].x);
    t16 = t16 * t16;
    t16 = t16 * 3.14159274;
    t24 = t24 + t24;
    t8 = t8 / t24;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 * 2.0 + -1.0;
    t24 = abs(t8) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t8) + -0.212114394;
    t24 = t24 * abs(t8) + 1.57072878;
    t2.x = -abs(t8) + 1.0;
    tb8 = t8<(-t8);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t8 = tb8 ? t10.x : float(0.0);
    t8 = t24 * t2.x + t8;
    t8 = (-t8) + 1.57079637;
    t8 = t8 * 0.318309873 + 0.5;
    t2 = _ShadowBodies[3] * _ShadowBodies[3];
    t2 = t2 * vec4(3.14159274, 3.14159274, 3.14159274, 3.14159274);
    t8 = (-t8) * t2.x + t16;
    t8 = t8 / t16;
    t8 = clamp(t8, 0.0, 1.0);
    t8 = t8 + -1.0;
    t3 = min(t2, vec4(1.0, 1.0, 1.0, 1.0));
    t0.x = t0.x * t3.x;
    t0.x = t0.x * t8 + 1.0;
    t4.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].y;
    t4.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].y;
    t4.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].y;
    t8 = dot(t4.xyz, t1.xyz);
    t16 = dot(t4.xyz, t4.xyz);
    t16 = (-t8) * t8 + t16;
    t16 = sqrt(t16);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].y;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.y * t8;
    t2.x = _SunRadius * t24 + _ShadowBodies[3].y;
    t24 = t24 * _SunRadius;
    t16 = (-t16) + t2.x;
    t2.x = min(t24, _ShadowBodies[3].y);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t2.x = t2.x + t2.x;
    t16 = t16 / t2.x;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 * 2.0 + -1.0;
    t2.x = abs(t16) * -0.0187292993 + 0.0742610022;
    t2.x = t2.x * abs(t16) + -0.212114394;
    t2.x = t2.x * abs(t16) + 1.57072878;
    t3.x = -abs(t16) + 1.0;
    tb16 = t16<(-t16);
    t3.x = sqrt(t3.x);
    t11 = t2.x * t3.x;
    t11 = t11 * -2.0 + 3.14159274;
    t16 = tb16 ? t11 : float(0.0);
    t16 = t2.x * t3.x + t16;
    t16 = (-t16) + 1.57079637;
    t16 = t16 * 0.318309873 + 0.5;
    t16 = (-t16) * t2.y + t24;
    t16 = t16 / t24;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 + -1.0;
    t8 = t8 * t16 + 1.0;
    t16_5 = min(t8, t0.x);
    t0.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].z;
    t0.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].z;
    t0.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].z;
    t24 = dot(t0.xyz, t1.xyz);
    t0.x = dot(t0.xyz, t0.xyz);
    t0.x = (-t24) * t24 + t0.x;
    t0.x = sqrt(t0.x);
    t8 = t24 / t25;
    tb16 = t24>=_ShadowBodies[3].z;
    t16 = tb16 ? 1.0 : float(0.0);
    t16 = t3.z * t16;
    t24 = _SunRadius * t8 + _ShadowBodies[3].z;
    t8 = t8 * _SunRadius;
    t0.x = (-t0.x) + t24;
    t24 = min(t8, _ShadowBodies[3].z);
    t8 = t8 * t8;
    t8 = t8 * 3.14159274;
    t24 = t24 + t24;
    t0.x = t0.x / t24;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x * 2.0 + -1.0;
    t24 = abs(t0.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.x) + -0.212114394;
    t24 = t24 * abs(t0.x) + 1.57072878;
    t2.x = -abs(t0.x) + 1.0;
    tb0 = t0.x<(-t0.x);
    t2.x = sqrt(t2.x);
    t10.x = t24 * t2.x;
    t10.x = t10.x * -2.0 + 3.14159274;
    t0.x = tb0 ? t10.x : float(0.0);
    t0.x = t24 * t2.x + t0.x;
    t0.x = (-t0.x) + 1.57079637;
    t0.x = t0.x * 0.318309873 + 0.5;
    t0.x = (-t0.x) * t2.z + t8;
    t0.x = t0.x / t8;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + -1.0;
    t0.x = t16 * t0.x + 1.0;
    t2.x = (-vs_TEXCOORD0.x) + _ShadowBodies[0].w;
    t2.y = (-vs_TEXCOORD0.y) + _ShadowBodies[1].w;
    t2.z = (-vs_TEXCOORD0.z) + _ShadowBodies[2].w;
    t8 = dot(t2.xyz, t1.xyz);
    t16 = dot(t2.xyz, t2.xyz);
    t16 = (-t8) * t8 + t16;
    t16 = sqrt(t16);
    t24 = t8 / t25;
    tb8 = t8>=_ShadowBodies[3].w;
    t8 = tb8 ? 1.0 : float(0.0);
    t8 = t3.w * t8;
    t1.x = _SunRadius * t24 + _ShadowBodies[3].w;
    t24 = t24 * _SunRadius;
    t16 = (-t16) + t1.x;
    t1.x = min(t24, _ShadowBodies[3].w);
    t24 = t24 * t24;
    t24 = t24 * 3.14159274;
    t1.x = t1.x + t1.x;
    t16 = t16 / t1.x;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 * 2.0 + -1.0;
    t1.x = abs(t16) * -0.0187292993 + 0.0742610022;
    t1.x = t1.x * abs(t16) + -0.212114394;
    t1.x = t1.x * abs(t16) + 1.57072878;
    t9.x = -abs(t16) + 1.0;
    tb16 = t16<(-t16);
    t9.x = sqrt(t9.x);
    t17.x = t9.x * t1.x;
    t17.x = t17.x * -2.0 + 3.14159274;
    t16 = tb16 ? t17.x : float(0.0);
    t16 = t1.x * t9.x + t16;
    t16 = (-t16) + 1.57079637;
    t16 = t16 * 0.318309873 + 0.5;
    t16 = (-t16) * t2.w + t24;
    t16 = t16 / t24;
    t16 = clamp(t16, 0.0, 1.0);
    t16 = t16 + -1.0;
    t8 = t8 * t16 + 1.0;
    t16_13.x = min(t8, t0.x);
    t16_5 = min(t16_13.x, t16_5);
    t0.x = dot(vs_TEXCOORD3.xyz, vs_TEXCOORD3.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD3.xyz;
    t1.xy = t0.xy / vec2(_UVNoiseScale);
    tb17.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb17.x) ? t1.x : (-t1.x);
    t1.y = (tb17.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(_UVNoiseScale);
    t1.xy = t1.xy / vec2(_UVNoiseScale);
    t1.xy = vec2(_UVNoiseAnimation.x, _UVNoiseAnimation.y) * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t10_0 = texture(cube_MainTex, t0.xyz);
    t16_0 = t10_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD2.yxz;
    t2.x = vs_TEXCOORD2.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD2.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t3.xyz = t9.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t16_7.xyz * t9.zyx + (-t3.xyz);
    t10.xyz = t10.xxx * t4.xyz + t3.xyz;
    t10.xyz = (-t16_7.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_13.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t1.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t1.xy = t16_13.xy * vec2(vec2(_DetailScale, _DetailScale));
    t17.xy = (-vec2(vec2(_DetailScale, _DetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t11 = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t11 = clamp(t11, 0.0, 1.0);
    t16_1 = vec4(t11) * t16_2 + t10_1;
    t16_0 = t16_0 * t16_1;
    t16_13.x = dot(_WorldSpaceLightPos0.xyz, _WorldSpaceLightPos0.xyz);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_6.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_6.x = inversesqrt(t16_6.x);
    t16_6.xyz = t16_6.xxx * vs_TEXCOORD4.xyz;
    t16_13.x = dot(t16_6.xyz, t16_13.xyz);
    t16_13.xyz = t16_0.xyz * t16_13.xxx;
    t16_11.xyz = t16_13.xyz * _LightColor0.xyz;
    vec3 txVec119 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_13.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec119, 0.0);
    t16_21 = (-_LightShadowData.x) + 1.0;
    t16_13.x = t16_13.x * t16_21 + _LightShadowData.x;
    t16_13.x = t16_13.x + t16_13.x;
    t16_11.xyz = t16_11.xyz * t16_13.xxx;
    t16_13.x = dot(_WorldSpaceLightPos0, _WorldSpaceLightPos0);
    t16_13.x = inversesqrt(t16_13.x);
    t16_13.xyz = t16_13.xxx * _WorldSpaceLightPos0.xyz;
    t16_13.x = dot(vs_TEXCOORD4.xyz, t16_13.xyz);
    t16_21 = t16_13.x + 1.00999999;
    t16_13.x = t16_13.x * -10.0;
    t16_13.x = clamp(t16_13.x, 0.0, 1.0);
    t16_21 = floor(t16_21);
    t16_21 = clamp(t16_21, 0.0, 1.0);
    t16_21 = t16_21 + -1.0;
    t16_13.x = t16_13.x * t16_21 + 1.0;
    t16_13.xyz = t16_11.xyz * t16_13.xxx;
    SV_Target0.xyz = vec3(t16_5) * t16_13.xyz;
    t11 = t3.x * _DistFade;
    t3.x = (-_DistFadeVert) * t3.x + 1.0;
    t3.x = clamp(t3.x, 0.0, 1.0);
    t11 = t11;
    t11 = clamp(t11, 0.0, 1.0);
    t3.x = (-t11) * t3.x + 1.0;
    t11 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD4.xyz);
    t19 = t11;
    t19 = clamp(t19, 0.0, 1.0);
    tb11 = t11>=0.0;
    t11 = tb11 ? 1.0 : float(0.0);
    t19 = t19 * _FalloffScale;
    t19 = log2(t19);
    t19 = t19 * _FalloffPow;
    t19 = exp2(t19);
    t19 = min(t19, 1.0);
    t19 = (-t3.x) + t19;
    t4.xyz = (-_WorldSpaceCameraPos.xyzx.xyz) + _PlanetOrigin.xyzx.xyz;
    t27 = dot(t4.xyz, t4.xyz);
    t27 = sqrt(t27);
    t4.xyz = vs_TEXCOORD0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t27 = (-_RimDistSub) * t4.x + t27;
    t27 = t27 * _RimDist;
    t27 = clamp(t27, 0.0, 1.0);
    t3.x = t27 * t19 + t3.x;
    t3.x = t16_0.w * t3.x;
    t3.x = t11 * t3.x;
    SV_Target0.w = t3.x;
    t3.x = vs_TEXCOORD8.z * _DepthPull;
    t11 = t3.x * _ZBufferParams.z;
    t3.x = (-t3.x) * _ZBufferParams.w + 1.0;
    gl_FragDepth = t3.x / t11;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 18 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [glstate_matrix_modelview0]
Matrix 160 [_Object2World]
Matrix 224 [_MainRotation]
Matrix 288 [_DetailRotation]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 352 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float3 xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float4 xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
  float4 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float3 _PlanetOrigin;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  float4 tmpvar_2;
  half4 tmpvar_3;
  float4 tmpvar_4;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float4 tmpvar_5;
  tmpvar_5 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  tmpvar_2 = (_mtl_u._MainRotation * _mtl_i._glesVertex);
  float4 o_6;
  float4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  float2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _mtl_u._ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((_mtl_u.glstate_matrix_modelview0 * _mtl_i._glesVertex).z);
  float4 o_9;
  float4 tmpvar_10;
  tmpvar_10 = (tmpvar_1 * 0.5);
  float2 tmpvar_11;
  tmpvar_11.x = tmpvar_10.x;
  tmpvar_11.y = (tmpvar_10.y * _mtl_u._ProjectionParams.x);
  o_9.xy = (tmpvar_11 + tmpvar_10.w);
  o_9.zw = tmpvar_1.zw;
  tmpvar_3 = half4(o_9);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_5.xyz;
  _mtl_o.xlv_TEXCOORD1 = (_mtl_u._PlanetOrigin - _mtl_u._WorldSpaceCameraPos);
  _mtl_o.xlv_TEXCOORD2 = (_mtl_u._DetailRotation * tmpvar_2);
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0)).xyz));
  _mtl_o.xlv_TEXCOORD5 = normalize((_mtl_u._WorldSpaceCameraPos - tmpvar_5.xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD8 = tmpvar_4;
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 318 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ProjectionParams;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec3 _PlanetOrigin;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 tmpvar_2;
  mediump vec4 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_1 = (glstate_matrix_mvp * _glesVertex);
  highp vec4 tmpvar_5;
  tmpvar_5 = (_Object2World * _glesVertex);
  tmpvar_2 = (_MainRotation * _glesVertex);
  highp vec4 o_6;
  highp vec4 tmpvar_7;
  tmpvar_7 = (tmpvar_1 * 0.5);
  highp vec2 tmpvar_8;
  tmpvar_8.x = tmpvar_7.x;
  tmpvar_8.y = (tmpvar_7.y * _ProjectionParams.x);
  o_6.xy = (tmpvar_8 + tmpvar_7.w);
  o_6.zw = tmpvar_1.zw;
  tmpvar_4.xyw = o_6.xyw;
  tmpvar_4.z = -((glstate_matrix_modelview0 * _glesVertex).z);
  tmpvar_3 = (unity_World2Shadow[0] * tmpvar_5);
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = tmpvar_5.xyz;
  xlv_TEXCOORD1 = (_PlanetOrigin - _WorldSpaceCameraPos);
  xlv_TEXCOORD2 = (_DetailRotation * tmpvar_2);
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = normalize((tmpvar_5.xyz - (_Object2World * vec4(0.0, 0.0, 0.0, 1.0)).xyz));
  xlv_TEXCOORD5 = normalize((_WorldSpaceCameraPos - tmpvar_5.xyz));
  xlv_TEXCOORD6 = tmpvar_3;
  xlv_TEXCOORD8 = tmpvar_4;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
#extension GL_EXT_frag_depth : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp vec4 _ZBufferParams;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform highp mat4 _ShadowBodies;
uniform highp float _SunRadius;
uniform highp vec3 _SunPos;
uniform lowp samplerCube cube_MainTex;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform lowp vec4 _Color;
uniform highp float _FalloffPow;
uniform highp float _FalloffScale;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _RimDist;
uniform highp float _RimDistSub;
uniform highp vec3 _PlanetOrigin;
uniform highp float _DepthPull;
varying highp vec3 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
varying highp vec4 xlv_TEXCOORD8;
void main ()
{
  highp float depthWithOffset_1;
  mediump vec4 color_2;
  mediump vec4 tmpvar_3;
  highp vec3 cubeVect_4;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD3.xyz);
  cubeVect_4 = tmpvar_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = (tmpvar_5 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_7;
  tmpvar_7 = (fract(abs(tmpvar_6)) * vec3(_UVNoiseScale));
  highp float tmpvar_8;
  if ((tmpvar_6.x >= 0.0)) {
    tmpvar_8 = tmpvar_7.x;
  } else {
    tmpvar_8 = -(tmpvar_7.x);
  };
  highp float tmpvar_9;
  if ((tmpvar_6.y >= 0.0)) {
    tmpvar_9 = tmpvar_7.y;
  } else {
    tmpvar_9 = -(tmpvar_7.y);
  };
  highp float tmpvar_10;
  if ((tmpvar_6.z >= 0.0)) {
    tmpvar_10 = tmpvar_7.z;
  } else {
    tmpvar_10 = -(tmpvar_7.z);
  };
  highp vec3 tmpvar_11;
  tmpvar_11.x = tmpvar_8;
  tmpvar_11.y = tmpvar_9;
  tmpvar_11.z = tmpvar_10;
  highp vec2 tmpvar_12;
  tmpvar_12 = ((tmpvar_11 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2D (_UVNoiseTex, tmpvar_12);
  cubeVect_4.xy = (tmpvar_5.xy + ((tmpvar_13.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_14;
  tmpvar_14 = textureCube (cube_MainTex, cubeVect_4);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  mediump vec2 uv_16;
  mediump vec3 detailCoords_17;
  mediump float s_18;
  mediump float nylerp_19;
  mediump float zxlerp_20;
  highp vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2.xyz);
  highp vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_21);
  highp float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  zxlerp_20 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  nylerp_19 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = mix (tmpvar_21.x, tmpvar_21.z, zxlerp_20);
  s_18 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = sign(mix (tmpvar_21.y, s_18, nylerp_19));
  s_18 = tmpvar_26;
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = -(s_18);
  mediump vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = s_18;
  highp vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_27 * tmpvar_21.xzy), (tmpvar_28 * tmpvar_21.zxy), vec3(zxlerp_20));
  detailCoords_17 = tmpvar_29;
  mediump vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = s_18;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_21.yxz), detailCoords_17, vec3(nylerp_19));
  detailCoords_17 = tmpvar_31;
  uv_16 = (((
    (0.5 * detailCoords_17.yz)
   / 
    abs(detailCoords_17.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_32;
  uv_32 = uv_16;
  highp vec2 uvCont_33;
  highp vec2 tmpvar_34;
  tmpvar_34 = abs((uv_32 - (0.5 * _DetailScale)));
  uvCont_33.x = max (tmpvar_34.x, tmpvar_34.y);
  uvCont_33.y = min (tmpvar_34.x, tmpvar_34.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_33);
  tmpvar_35.zw = dFdy(uvCont_33);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_DetailTex, uv_16, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  highp vec3 tmpvar_38;
  tmpvar_38 = (xlv_TEXCOORD0 - _WorldSpaceCameraPos);
  mediump float tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_38, tmpvar_38)
  )), 0.0, 1.0);
  tmpvar_39 = tmpvar_40;
  color_2 = ((_Color * tmpvar_15) * mix (tmpvar_37, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_39)));
  highp float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD5, xlv_TEXCOORD4);
  highp float tmpvar_42;
  tmpvar_42 = sqrt(dot (tmpvar_38, tmpvar_38));
  highp vec3 tmpvar_43;
  tmpvar_43 = (_PlanetOrigin - _WorldSpaceCameraPos);
  highp vec3 tmpvar_44;
  tmpvar_44 = (xlv_TEXCOORD0 - _PlanetOrigin);
  highp float tmpvar_45;
  tmpvar_45 = (color_2.w * mix ((1.0 - 
    (clamp ((_DistFade * tmpvar_42), 0.0, 1.0) * clamp ((1.0 - (_DistFadeVert * tmpvar_42)), 0.0, 1.0))
  ), clamp (
    pow ((_FalloffScale * clamp (tmpvar_41, 0.0, 1.0)), _FalloffPow)
  , 0.0, 1.0), clamp (
    (_RimDist * (sqrt(dot (tmpvar_43, tmpvar_43)) - (_RimDistSub * sqrt(
      dot (tmpvar_44, tmpvar_44)
    ))))
  , 0.0, 1.0)));
  color_2.w = tmpvar_45;
  mediump float tmpvar_46;
  tmpvar_46 = color_2.w;
  lowp float shadow_47;
  shadow_47 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightS