// Compiled shader for all platforms, uncompressed size: 15176.5KB

// Skipping shader variants that would not be included into build of current scene.

Shader "EVE/CloudVolumeParticle" {
Properties {
 _Tex ("Particle Texture", 2D) = "white" { }
 _MainTex ("Main (RGB)", 2D) = "white" { }
 _PerlinTex ("Perlin (RGB)", 2D) = "white" { }
 _BumpMap ("Normalmap", 2D) = "bump" { }
 _DetailTex ("Detail (RGB)", 2D) = "white" { }
 _DetailScale ("Detail Scale", Range(0,1000)) = 100
 _DistFade ("Distance Fade Near", Float) = 1
 _DistFadeVert ("Distance Fade Vertical", Float) = 0.0004
 _MinScatter ("Min Scatter", Float) = 1.05
 _Opacity ("Opacity", Float) = 1.05
 _Color ("Color Tint", Color) = (1,1,1,1)
 _InvFade ("Soft Particles Factor", Range(0,1)) = 0.008
 _Rotation ("Rotation", Float) = 0
 _MaxScale ("Max Scale", Float) = 1
 _MaxTrans ("Max Translation", Vector) = (0,0,0,1)
 _NoiseScale ("Noise Scale", Vector) = (1,2,0.0005,100)
 _SunPos ("_SunPos", Vector) = (0,0,0,1)
 _SunRadius ("_SunRadius", Float) = 1
}
SubShader { 
 Tags { "QUEUE"="Transparent+2" "IGNOREPROJECTOR"="true" "DisableBatching"="true" "RenderType"="Transparent" }


 // Stats for Vertex shader:
 //       d3d11 : 455 avg math (432..478)
 //        d3d9 : 651 avg math (628..673), 4 avg texture (2..6)
 //        gles : 54 avg math (38..91), 5 avg texture (3..10)
 //       metal : 606 avg math (580..647), 2 avg texture (1..3), 45 avg branch (45..48)
 //      opengl : 54 avg math (38..91), 5 avg texture (3..10)
 // Stats for Fragment shader:
 //       d3d11 : 52 avg math (36..89), 3 avg texture (3..4)
 //        d3d9 : 55 avg math (42..87), 8 avg texture (3..22)
 //       metal : 54 avg math (38..91), 5 avg texture (3..10)
 Pass {
  Tags { "LIGHTMODE"="ForwardBase" "QUEUE"="Transparent+2" "IGNOREPROJECTOR"="true" "SHADOWSUPPORT"="true" "DisableBatching"="true" "RenderType"="Transparent" }
  Lighting On
  ZWrite Off
  Blend SrcAlpha OneMinusSrcAlpha
  ColorMask RGB
  GpuProgramID 5618
Program "vp" {
SubProgram "opengl " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _WorldSpaceLightPos0;

uniform mat4 _Object2World;

uniform mat4 unity_MatrixV;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform mat4 _PosRotation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _Rotation;
uniform float _MaxScale;
uniform vec4 _NoiseScale;
uniform vec3 _MaxTrans;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec4 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec2 tmpvar_1;
  tmpvar_1 = gl_MultiTexCoord0.xy;
  vec4 XYv_2;
  vec4 XZv_3;
  vec4 ZYv_4;
  vec4 localOrigin_5;
  vec4 planet_pos_6;
  vec4 origin_7;
  vec4 tmpvar_8;
  vec4 tmpvar_9;
  vec4 tmpvar_10;
  vec3 tmpvar_11;
  vec4 tmpvar_12;
  tmpvar_12 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_7 = tmpvar_12;
  vec4 tmpvar_13;
  tmpvar_13 = (_PosRotation * tmpvar_12);
  planet_pos_6 = tmpvar_13;
  vec3 tmpvar_14;
  tmpvar_14 = (_NoiseScale.z * tmpvar_13.xyz);
  float tmpvar_15;
  vec4 m_16;
  vec3 tmpvar_17;
  tmpvar_17 = floor((tmpvar_14 + dot (tmpvar_14, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_18;
  tmpvar_18 = ((tmpvar_14 - tmpvar_17) + dot (tmpvar_17, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_19;
  tmpvar_19.x = float((tmpvar_18.x >= tmpvar_18.y));
  tmpvar_19.y = float((tmpvar_18.y >= tmpvar_18.z));
  tmpvar_19.z = float((tmpvar_18.z >= tmpvar_18.x));
  vec3 tmpvar_20;
  tmpvar_20 = (1.0 - tmpvar_19);
  vec3 tmpvar_21;
  tmpvar_21 = min (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_22;
  tmpvar_22 = max (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_23;
  tmpvar_23 = ((tmpvar_18 - tmpvar_21) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_24;
  tmpvar_24 = ((tmpvar_18 - tmpvar_22) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_25;
  tmpvar_25 = (tmpvar_18 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_26;
  tmpvar_26 = (tmpvar_17 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_27;
  tmpvar_27 = (fract(abs(tmpvar_26)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_28;
  if ((tmpvar_26.x >= 0.0)) {
    tmpvar_28 = tmpvar_27.x;
  } else {
    tmpvar_28 = -(tmpvar_27.x);
  };
  float tmpvar_29;
  if ((tmpvar_26.y >= 0.0)) {
    tmpvar_29 = tmpvar_27.y;
  } else {
    tmpvar_29 = -(tmpvar_27.y);
  };
  float tmpvar_30;
  if ((tmpvar_26.z >= 0.0)) {
    tmpvar_30 = tmpvar_27.z;
  } else {
    tmpvar_30 = -(tmpvar_27.z);
  };
  vec4 tmpvar_31;
  tmpvar_31.xw = vec2(0.0, 1.0);
  tmpvar_31.y = tmpvar_21.z;
  tmpvar_31.z = tmpvar_22.z;
  vec4 x_32;
  x_32 = (tmpvar_30 + tmpvar_31);
  vec4 tmpvar_33;
  tmpvar_33 = (((
    (x_32 * x_32)
   * 34.0) + x_32) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_34;
  tmpvar_34 = (fract(abs(tmpvar_33)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_35;
  if ((tmpvar_33.x >= 0.0)) {
    tmpvar_35 = tmpvar_34.x;
  } else {
    tmpvar_35 = -(tmpvar_34.x);
  };
  float tmpvar_36;
  if ((tmpvar_33.y >= 0.0)) {
    tmpvar_36 = tmpvar_34.y;
  } else {
    tmpvar_36 = -(tmpvar_34.y);
  };
  float tmpvar_37;
  if ((tmpvar_33.z >= 0.0)) {
    tmpvar_37 = tmpvar_34.z;
  } else {
    tmpvar_37 = -(tmpvar_34.z);
  };
  float tmpvar_38;
  if ((tmpvar_33.w >= 0.0)) {
    tmpvar_38 = tmpvar_34.w;
  } else {
    tmpvar_38 = -(tmpvar_34.w);
  };
  vec4 tmpvar_39;
  tmpvar_39.x = tmpvar_35;
  tmpvar_39.y = tmpvar_36;
  tmpvar_39.z = tmpvar_37;
  tmpvar_39.w = tmpvar_38;
  vec4 tmpvar_40;
  tmpvar_40.xw = vec2(0.0, 1.0);
  tmpvar_40.y = tmpvar_21.y;
  tmpvar_40.z = tmpvar_22.y;
  vec4 x_41;
  x_41 = ((tmpvar_39 + tmpvar_29) + tmpvar_40);
  vec4 tmpvar_42;
  tmpvar_42 = (((
    (x_41 * x_41)
   * 34.0) + x_41) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_43;
  tmpvar_43 = (fract(abs(tmpvar_42)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_44;
  if ((tmpvar_42.x >= 0.0)) {
    tmpvar_44 = tmpvar_43.x;
  } else {
    tmpvar_44 = -(tmpvar_43.x);
  };
  float tmpvar_45;
  if ((tmpvar_42.y >= 0.0)) {
    tmpvar_45 = tmpvar_43.y;
  } else {
    tmpvar_45 = -(tmpvar_43.y);
  };
  float tmpvar_46;
  if ((tmpvar_42.z >= 0.0)) {
    tmpvar_46 = tmpvar_43.z;
  } else {
    tmpvar_46 = -(tmpvar_43.z);
  };
  float tmpvar_47;
  if ((tmpvar_42.w >= 0.0)) {
    tmpvar_47 = tmpvar_43.w;
  } else {
    tmpvar_47 = -(tmpvar_43.w);
  };
  vec4 tmpvar_48;
  tmpvar_48.x = tmpvar_44;
  tmpvar_48.y = tmpvar_45;
  tmpvar_48.z = tmpvar_46;
  tmpvar_48.w = tmpvar_47;
  vec4 tmpvar_49;
  tmpvar_49.xw = vec2(0.0, 1.0);
  tmpvar_49.y = tmpvar_21.x;
  tmpvar_49.z = tmpvar_22.x;
  vec4 x_50;
  x_50 = ((tmpvar_48 + tmpvar_28) + tmpvar_49);
  vec4 tmpvar_51;
  tmpvar_51 = (((
    (x_50 * x_50)
   * 34.0) + x_50) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_52;
  tmpvar_52 = (fract(abs(tmpvar_51)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_53;
  if ((tmpvar_51.x >= 0.0)) {
    tmpvar_53 = tmpvar_52.x;
  } else {
    tmpvar_53 = -(tmpvar_52.x);
  };
  float tmpvar_54;
  if ((tmpvar_51.y >= 0.0)) {
    tmpvar_54 = tmpvar_52.y;
  } else {
    tmpvar_54 = -(tmpvar_52.y);
  };
  float tmpvar_55;
  if ((tmpvar_51.z >= 0.0)) {
    tmpvar_55 = tmpvar_52.z;
  } else {
    tmpvar_55 = -(tmpvar_52.z);
  };
  float tmpvar_56;
  if ((tmpvar_51.w >= 0.0)) {
    tmpvar_56 = tmpvar_52.w;
  } else {
    tmpvar_56 = -(tmpvar_52.w);
  };
  vec4 tmpvar_57;
  tmpvar_57.x = tmpvar_53;
  tmpvar_57.y = tmpvar_54;
  tmpvar_57.z = tmpvar_55;
  tmpvar_57.w = tmpvar_56;
  vec4 tmpvar_58;
  tmpvar_58 = (tmpvar_57 - (49.0 * floor(
    (0.02040815 * tmpvar_57)
  )));
  vec4 tmpvar_59;
  tmpvar_59 = floor((tmpvar_58 * 0.1428571));
  vec4 tmpvar_60;
  tmpvar_60 = ((tmpvar_59 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_61;
  tmpvar_61 = ((floor(
    (tmpvar_58 - (7.0 * tmpvar_59))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_62;
  tmpvar_62 = ((1.0 - abs(tmpvar_60)) - abs(tmpvar_61));
  vec4 tmpvar_63;
  tmpvar_63.xy = tmpvar_60.xy;
  tmpvar_63.zw = tmpvar_61.xy;
  vec4 tmpvar_64;
  tmpvar_64.xy = tmpvar_60.zw;
  tmpvar_64.zw = tmpvar_61.zw;
  vec4 tmpvar_65;
  tmpvar_65 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_62)));
  vec4 tmpvar_66;
  tmpvar_66 = (tmpvar_63.xzyw + ((
    (floor(tmpvar_63) * 2.0)
   + 1.0).xzyw * tmpvar_65.xxyy));
  vec4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_65.zzww));
  vec3 tmpvar_68;
  tmpvar_68.xy = tmpvar_66.xy;
  tmpvar_68.z = tmpvar_62.x;
  vec3 tmpvar_69;
  tmpvar_69.xy = tmpvar_66.zw;
  tmpvar_69.z = tmpvar_62.y;
  vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.xy;
  tmpvar_70.z = tmpvar_62.z;
  vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_67.zw;
  tmpvar_71.z = tmpvar_62.w;
  vec4 tmpvar_72;
  tmpvar_72.x = dot (tmpvar_68, tmpvar_68);
  tmpvar_72.y = dot (tmpvar_69, tmpvar_69);
  tmpvar_72.z = dot (tmpvar_70, tmpvar_70);
  tmpvar_72.w = dot (tmpvar_71, tmpvar_71);
  vec4 tmpvar_73;
  tmpvar_73 = (1.792843 - (0.8537347 * tmpvar_72));
  vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_18, tmpvar_18);
  tmpvar_74.y = dot (tmpvar_23, tmpvar_23);
  tmpvar_74.z = dot (tmpvar_24, tmpvar_24);
  tmpvar_74.w = dot (tmpvar_25, tmpvar_25);
  vec4 tmpvar_75;
  tmpvar_75 = max ((0.6 - tmpvar_74), vec4(0.0, 0.0, 0.0, 0.0));
  m_16 = (tmpvar_75 * tmpvar_75);
  vec4 tmpvar_76;
  tmpvar_76.x = dot ((tmpvar_68 * tmpvar_73.x), tmpvar_18);
  tmpvar_76.y = dot ((tmpvar_69 * tmpvar_73.y), tmpvar_23);
  tmpvar_76.z = dot ((tmpvar_70 * tmpvar_73.z), tmpvar_24);
  tmpvar_76.w = dot ((tmpvar_71 * tmpvar_73.w), tmpvar_25);
  tmpvar_15 = (42.0 * dot ((m_16 * m_16), tmpvar_76));
  float tmpvar_77;
  vec3 v_78;
  v_78 = (_NoiseScale.x * tmpvar_14);
  vec4 m_79;
  vec3 tmpvar_80;
  tmpvar_80 = floor((v_78 + dot (v_78, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_81;
  tmpvar_81 = ((v_78 - tmpvar_80) + dot (tmpvar_80, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_82;
  tmpvar_82.x = float((tmpvar_81.x >= tmpvar_81.y));
  tmpvar_82.y = float((tmpvar_81.y >= tmpvar_81.z));
  tmpvar_82.z = float((tmpvar_81.z >= tmpvar_81.x));
  vec3 tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_82);
  vec3 tmpvar_84;
  tmpvar_84 = min (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_85;
  tmpvar_85 = max (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_86;
  tmpvar_86 = ((tmpvar_81 - tmpvar_84) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_87;
  tmpvar_87 = ((tmpvar_81 - tmpvar_85) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_88;
  tmpvar_88 = (tmpvar_81 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_89;
  tmpvar_89 = (tmpvar_80 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_90;
  tmpvar_90 = (fract(abs(tmpvar_89)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_91;
  if ((tmpvar_89.x >= 0.0)) {
    tmpvar_91 = tmpvar_90.x;
  } else {
    tmpvar_91 = -(tmpvar_90.x);
  };
  float tmpvar_92;
  if ((tmpvar_89.y >= 0.0)) {
    tmpvar_92 = tmpvar_90.y;
  } else {
    tmpvar_92 = -(tmpvar_90.y);
  };
  float tmpvar_93;
  if ((tmpvar_89.z >= 0.0)) {
    tmpvar_93 = tmpvar_90.z;
  } else {
    tmpvar_93 = -(tmpvar_90.z);
  };
  vec4 tmpvar_94;
  tmpvar_94.xw = vec2(0.0, 1.0);
  tmpvar_94.y = tmpvar_84.z;
  tmpvar_94.z = tmpvar_85.z;
  vec4 x_95;
  x_95 = (tmpvar_93 + tmpvar_94);
  vec4 tmpvar_96;
  tmpvar_96 = (((
    (x_95 * x_95)
   * 34.0) + x_95) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_97;
  tmpvar_97 = (fract(abs(tmpvar_96)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_98;
  if ((tmpvar_96.x >= 0.0)) {
    tmpvar_98 = tmpvar_97.x;
  } else {
    tmpvar_98 = -(tmpvar_97.x);
  };
  float tmpvar_99;
  if ((tmpvar_96.y >= 0.0)) {
    tmpvar_99 = tmpvar_97.y;
  } else {
    tmpvar_99 = -(tmpvar_97.y);
  };
  float tmpvar_100;
  if ((tmpvar_96.z >= 0.0)) {
    tmpvar_100 = tmpvar_97.z;
  } else {
    tmpvar_100 = -(tmpvar_97.z);
  };
  float tmpvar_101;
  if ((tmpvar_96.w >= 0.0)) {
    tmpvar_101 = tmpvar_97.w;
  } else {
    tmpvar_101 = -(tmpvar_97.w);
  };
  vec4 tmpvar_102;
  tmpvar_102.x = tmpvar_98;
  tmpvar_102.y = tmpvar_99;
  tmpvar_102.z = tmpvar_100;
  tmpvar_102.w = tmpvar_101;
  vec4 tmpvar_103;
  tmpvar_103.xw = vec2(0.0, 1.0);
  tmpvar_103.y = tmpvar_84.y;
  tmpvar_103.z = tmpvar_85.y;
  vec4 x_104;
  x_104 = ((tmpvar_102 + tmpvar_92) + tmpvar_103);
  vec4 tmpvar_105;
  tmpvar_105 = (((
    (x_104 * x_104)
   * 34.0) + x_104) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_106;
  tmpvar_106 = (fract(abs(tmpvar_105)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_107;
  if ((tmpvar_105.x >= 0.0)) {
    tmpvar_107 = tmpvar_106.x;
  } else {
    tmpvar_107 = -(tmpvar_106.x);
  };
  float tmpvar_108;
  if ((tmpvar_105.y >= 0.0)) {
    tmpvar_108 = tmpvar_106.y;
  } else {
    tmpvar_108 = -(tmpvar_106.y);
  };
  float tmpvar_109;
  if ((tmpvar_105.z >= 0.0)) {
    tmpvar_109 = tmpvar_106.z;
  } else {
    tmpvar_109 = -(tmpvar_106.z);
  };
  float tmpvar_110;
  if ((tmpvar_105.w >= 0.0)) {
    tmpvar_110 = tmpvar_106.w;
  } else {
    tmpvar_110 = -(tmpvar_106.w);
  };
  vec4 tmpvar_111;
  tmpvar_111.x = tmpvar_107;
  tmpvar_111.y = tmpvar_108;
  tmpvar_111.z = tmpvar_109;
  tmpvar_111.w = tmpvar_110;
  vec4 tmpvar_112;
  tmpvar_112.xw = vec2(0.0, 1.0);
  tmpvar_112.y = tmpvar_84.x;
  tmpvar_112.z = tmpvar_85.x;
  vec4 x_113;
  x_113 = ((tmpvar_111 + tmpvar_91) + tmpvar_112);
  vec4 tmpvar_114;
  tmpvar_114 = (((
    (x_113 * x_113)
   * 34.0) + x_113) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_115;
  tmpvar_115 = (fract(abs(tmpvar_114)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_116;
  if ((tmpvar_114.x >= 0.0)) {
    tmpvar_116 = tmpvar_115.x;
  } else {
    tmpvar_116 = -(tmpvar_115.x);
  };
  float tmpvar_117;
  if ((tmpvar_114.y >= 0.0)) {
    tmpvar_117 = tmpvar_115.y;
  } else {
    tmpvar_117 = -(tmpvar_115.y);
  };
  float tmpvar_118;
  if ((tmpvar_114.z >= 0.0)) {
    tmpvar_118 = tmpvar_115.z;
  } else {
    tmpvar_118 = -(tmpvar_115.z);
  };
  float tmpvar_119;
  if ((tmpvar_114.w >= 0.0)) {
    tmpvar_119 = tmpvar_115.w;
  } else {
    tmpvar_119 = -(tmpvar_115.w);
  };
  vec4 tmpvar_120;
  tmpvar_120.x = tmpvar_116;
  tmpvar_120.y = tmpvar_117;
  tmpvar_120.z = tmpvar_118;
  tmpvar_120.w = tmpvar_119;
  vec4 tmpvar_121;
  tmpvar_121 = (tmpvar_120 - (49.0 * floor(
    (0.02040815 * tmpvar_120)
  )));
  vec4 tmpvar_122;
  tmpvar_122 = floor((tmpvar_121 * 0.1428571));
  vec4 tmpvar_123;
  tmpvar_123 = ((tmpvar_122 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_124;
  tmpvar_124 = ((floor(
    (tmpvar_121 - (7.0 * tmpvar_122))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_125;
  tmpvar_125 = ((1.0 - abs(tmpvar_123)) - abs(tmpvar_124));
  vec4 tmpvar_126;
  tmpvar_126.xy = tmpvar_123.xy;
  tmpvar_126.zw = tmpvar_124.xy;
  vec4 tmpvar_127;
  tmpvar_127.xy = tmpvar_123.zw;
  tmpvar_127.zw = tmpvar_124.zw;
  vec4 tmpvar_128;
  tmpvar_128 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_125)));
  vec4 tmpvar_129;
  tmpvar_129 = (tmpvar_126.xzyw + ((
    (floor(tmpvar_126) * 2.0)
   + 1.0).xzyw * tmpvar_128.xxyy));
  vec4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_128.zzww));
  vec3 tmpvar_131;
  tmpvar_131.xy = tmpvar_129.xy;
  tmpvar_131.z = tmpvar_125.x;
  vec3 tmpvar_132;
  tmpvar_132.xy = tmpvar_129.zw;
  tmpvar_132.z = tmpvar_125.y;
  vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.xy;
  tmpvar_133.z = tmpvar_125.z;
  vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_130.zw;
  tmpvar_134.z = tmpvar_125.w;
  vec4 tmpvar_135;
  tmpvar_135.x = dot (tmpvar_131, tmpvar_131);
  tmpvar_135.y = dot (tmpvar_132, tmpvar_132);
  tmpvar_135.z = dot (tmpvar_133, tmpvar_133);
  tmpvar_135.w = dot (tmpvar_134, tmpvar_134);
  vec4 tmpvar_136;
  tmpvar_136 = (1.792843 - (0.8537347 * tmpvar_135));
  vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_81, tmpvar_81);
  tmpvar_137.y = dot (tmpvar_86, tmpvar_86);
  tmpvar_137.z = dot (tmpvar_87, tmpvar_87);
  tmpvar_137.w = dot (tmpvar_88, tmpvar_88);
  vec4 tmpvar_138;
  tmpvar_138 = max ((0.6 - tmpvar_137), vec4(0.0, 0.0, 0.0, 0.0));
  m_79 = (tmpvar_138 * tmpvar_138);
  vec4 tmpvar_139;
  tmpvar_139.x = dot ((tmpvar_131 * tmpvar_136.x), tmpvar_81);
  tmpvar_139.y = dot ((tmpvar_132 * tmpvar_136.y), tmpvar_86);
  tmpvar_139.z = dot ((tmpvar_133 * tmpvar_136.z), tmpvar_87);
  tmpvar_139.w = dot ((tmpvar_134 * tmpvar_136.w), tmpvar_88);
  tmpvar_77 = (42.0 * dot ((m_79 * m_79), tmpvar_139));
  vec3 v_140;
  v_140 = (_NoiseScale.y * tmpvar_14);
  vec4 m_141;
  vec3 tmpvar_142;
  tmpvar_142 = floor((v_140 + dot (v_140, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_143;
  tmpvar_143 = ((v_140 - tmpvar_142) + dot (tmpvar_142, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_144;
  tmpvar_144.x = float((tmpvar_143.x >= tmpvar_143.y));
  tmpvar_144.y = float((tmpvar_143.y >= tmpvar_143.z));
  tmpvar_144.z = float((tmpvar_143.z >= tmpvar_143.x));
  vec3 tmpvar_145;
  tmpvar_145 = (1.0 - tmpvar_144);
  vec3 tmpvar_146;
  tmpvar_146 = min (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_147;
  tmpvar_147 = max (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_148;
  tmpvar_148 = ((tmpvar_143 - tmpvar_146) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_149;
  tmpvar_149 = ((tmpvar_143 - tmpvar_147) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_150;
  tmpvar_150 = (tmpvar_143 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_151;
  tmpvar_151 = (tmpvar_142 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_152;
  tmpvar_152 = (fract(abs(tmpvar_151)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_153;
  if ((tmpvar_151.x >= 0.0)) {
    tmpvar_153 = tmpvar_152.x;
  } else {
    tmpvar_153 = -(tmpvar_152.x);
  };
  float tmpvar_154;
  if ((tmpvar_151.y >= 0.0)) {
    tmpvar_154 = tmpvar_152.y;
  } else {
    tmpvar_154 = -(tmpvar_152.y);
  };
  float tmpvar_155;
  if ((tmpvar_151.z >= 0.0)) {
    tmpvar_155 = tmpvar_152.z;
  } else {
    tmpvar_155 = -(tmpvar_152.z);
  };
  vec4 tmpvar_156;
  tmpvar_156.xw = vec2(0.0, 1.0);
  tmpvar_156.y = tmpvar_146.z;
  tmpvar_156.z = tmpvar_147.z;
  vec4 x_157;
  x_157 = (tmpvar_155 + tmpvar_156);
  vec4 tmpvar_158;
  tmpvar_158 = (((
    (x_157 * x_157)
   * 34.0) + x_157) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_159;
  tmpvar_159 = (fract(abs(tmpvar_158)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_160;
  if ((tmpvar_158.x >= 0.0)) {
    tmpvar_160 = tmpvar_159.x;
  } else {
    tmpvar_160 = -(tmpvar_159.x);
  };
  float tmpvar_161;
  if ((tmpvar_158.y >= 0.0)) {
    tmpvar_161 = tmpvar_159.y;
  } else {
    tmpvar_161 = -(tmpvar_159.y);
  };
  float tmpvar_162;
  if ((tmpvar_158.z >= 0.0)) {
    tmpvar_162 = tmpvar_159.z;
  } else {
    tmpvar_162 = -(tmpvar_159.z);
  };
  float tmpvar_163;
  if ((tmpvar_158.w >= 0.0)) {
    tmpvar_163 = tmpvar_159.w;
  } else {
    tmpvar_163 = -(tmpvar_159.w);
  };
  vec4 tmpvar_164;
  tmpvar_164.x = tmpvar_160;
  tmpvar_164.y = tmpvar_161;
  tmpvar_164.z = tmpvar_162;
  tmpvar_164.w = tmpvar_163;
  vec4 tmpvar_165;
  tmpvar_165.xw = vec2(0.0, 1.0);
  tmpvar_165.y = tmpvar_146.y;
  tmpvar_165.z = tmpvar_147.y;
  vec4 x_166;
  x_166 = ((tmpvar_164 + tmpvar_154) + tmpvar_165);
  vec4 tmpvar_167;
  tmpvar_167 = (((
    (x_166 * x_166)
   * 34.0) + x_166) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_168;
  tmpvar_168 = (fract(abs(tmpvar_167)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_169;
  if ((tmpvar_167.x >= 0.0)) {
    tmpvar_169 = tmpvar_168.x;
  } else {
    tmpvar_169 = -(tmpvar_168.x);
  };
  float tmpvar_170;
  if ((tmpvar_167.y >= 0.0)) {
    tmpvar_170 = tmpvar_168.y;
  } else {
    tmpvar_170 = -(tmpvar_168.y);
  };
  float tmpvar_171;
  if ((tmpvar_167.z >= 0.0)) {
    tmpvar_171 = tmpvar_168.z;
  } else {
    tmpvar_171 = -(tmpvar_168.z);
  };
  float tmpvar_172;
  if ((tmpvar_167.w >= 0.0)) {
    tmpvar_172 = tmpvar_168.w;
  } else {
    tmpvar_172 = -(tmpvar_168.w);
  };
  vec4 tmpvar_173;
  tmpvar_173.x = tmpvar_169;
  tmpvar_173.y = tmpvar_170;
  tmpvar_173.z = tmpvar_171;
  tmpvar_173.w = tmpvar_172;
  vec4 tmpvar_174;
  tmpvar_174.xw = vec2(0.0, 1.0);
  tmpvar_174.y = tmpvar_146.x;
  tmpvar_174.z = tmpvar_147.x;
  vec4 x_175;
  x_175 = ((tmpvar_173 + tmpvar_153) + tmpvar_174);
  vec4 tmpvar_176;
  tmpvar_176 = (((
    (x_175 * x_175)
   * 34.0) + x_175) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_177;
  tmpvar_177 = (fract(abs(tmpvar_176)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_178;
  if ((tmpvar_176.x >= 0.0)) {
    tmpvar_178 = tmpvar_177.x;
  } else {
    tmpvar_178 = -(tmpvar_177.x);
  };
  float tmpvar_179;
  if ((tmpvar_176.y >= 0.0)) {
    tmpvar_179 = tmpvar_177.y;
  } else {
    tmpvar_179 = -(tmpvar_177.y);
  };
  float tmpvar_180;
  if ((tmpvar_176.z >= 0.0)) {
    tmpvar_180 = tmpvar_177.z;
  } else {
    tmpvar_180 = -(tmpvar_177.z);
  };
  float tmpvar_181;
  if ((tmpvar_176.w >= 0.0)) {
    tmpvar_181 = tmpvar_177.w;
  } else {
    tmpvar_181 = -(tmpvar_177.w);
  };
  vec4 tmpvar_182;
  tmpvar_182.x = tmpvar_178;
  tmpvar_182.y = tmpvar_179;
  tmpvar_182.z = tmpvar_180;
  tmpvar_182.w = tmpvar_181;
  vec4 tmpvar_183;
  tmpvar_183 = (tmpvar_182 - (49.0 * floor(
    (0.02040815 * tmpvar_182)
  )));
  vec4 tmpvar_184;
  tmpvar_184 = floor((tmpvar_183 * 0.1428571));
  vec4 tmpvar_185;
  tmpvar_185 = ((tmpvar_184 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_186;
  tmpvar_186 = ((floor(
    (tmpvar_183 - (7.0 * tmpvar_184))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_187;
  tmpvar_187 = ((1.0 - abs(tmpvar_185)) - abs(tmpvar_186));
  vec4 tmpvar_188;
  tmpvar_188.xy = tmpvar_185.xy;
  tmpvar_188.zw = tmpvar_186.xy;
  vec4 tmpvar_189;
  tmpvar_189.xy = tmpvar_185.zw;
  tmpvar_189.zw = tmpvar_186.zw;
  vec4 tmpvar_190;
  tmpvar_190 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_187)));
  vec4 tmpvar_191;
  tmpvar_191 = (tmpvar_188.xzyw + ((
    (floor(tmpvar_188) * 2.0)
   + 1.0).xzyw * tmpvar_190.xxyy));
  vec4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_190.zzww));
  vec3 tmpvar_193;
  tmpvar_193.xy = tmpvar_191.xy;
  tmpvar_193.z = tmpvar_187.x;
  vec3 tmpvar_194;
  tmpvar_194.xy = tmpvar_191.zw;
  tmpvar_194.z = tmpvar_187.y;
  vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.xy;
  tmpvar_195.z = tmpvar_187.z;
  vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_192.zw;
  tmpvar_196.z = tmpvar_187.w;
  vec4 tmpvar_197;
  tmpvar_197.x = dot (tmpvar_193, tmpvar_193);
  tmpvar_197.y = dot (tmpvar_194, tmpvar_194);
  tmpvar_197.z = dot (tmpvar_195, tmpvar_195);
  tmpvar_197.w = dot (tmpvar_196, tmpvar_196);
  vec4 tmpvar_198;
  tmpvar_198 = (1.792843 - (0.8537347 * tmpvar_197));
  vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_143, tmpvar_143);
  tmpvar_199.y = dot (tmpvar_148, tmpvar_148);
  tmpvar_199.z = dot (tmpvar_149, tmpvar_149);
  tmpvar_199.w = dot (tmpvar_150, tmpvar_150);
  vec4 tmpvar_200;
  tmpvar_200 = max ((0.6 - tmpvar_199), vec4(0.0, 0.0, 0.0, 0.0));
  m_141 = (tmpvar_200 * tmpvar_200);
  vec4 tmpvar_201;
  tmpvar_201.x = dot ((tmpvar_193 * tmpvar_198.x), tmpvar_143);
  tmpvar_201.y = dot ((tmpvar_194 * tmpvar_198.y), tmpvar_148);
  tmpvar_201.z = dot ((tmpvar_195 * tmpvar_198.z), tmpvar_149);
  tmpvar_201.w = dot ((tmpvar_196 * tmpvar_198.w), tmpvar_150);
  vec3 tmpvar_202;
  tmpvar_202.x = tmpvar_15;
  tmpvar_202.y = tmpvar_77;
  tmpvar_202.z = (42.0 * dot ((m_141 * m_141), tmpvar_201));
  vec3 tmpvar_203;
  tmpvar_203 = (0.5 * (tmpvar_202 + 1.0));
  localOrigin_5.xyz = (((2.0 * tmpvar_203) - 1.0) * _MaxTrans);
  localOrigin_5.w = 1.0;
  float tmpvar_204;
  tmpvar_204 = ((tmpvar_203.x * (_MaxScale - 1.0)) + 1.0);
  origin_7 = (_Object2World * localOrigin_5);
  planet_pos_6 = (_MainRotation * origin_7);
  vec3 tmpvar_205;
  tmpvar_205 = (_DetailRotation * planet_pos_6).xyz;
  tmpvar_11 = planet_pos_6.xyz;
  vec3 tmpvar_206;
  tmpvar_206 = normalize(planet_pos_6.xyz);
  vec2 uv_207;
  float tmpvar_208;
  float tmpvar_209;
  tmpvar_209 = (min (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0) / max (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0));
  float tmpvar_210;
  tmpvar_210 = (tmpvar_209 * tmpvar_209);
  tmpvar_210 = (((
    ((((
      ((((-0.01213232 * tmpvar_210) + 0.05368138) * tmpvar_210) - 0.1173503)
     * tmpvar_210) + 0.1938925) * tmpvar_210) - 0.3326756)
   * tmpvar_210) + 0.9999793) * tmpvar_209);
  tmpvar_210 = (tmpvar_210 + (float(
    (abs((tmpvar_206.x / tmpvar_206.z)) > 1.0)
  ) * (
    (tmpvar_210 * -2.0)
   + 1.570796)));
  tmpvar_208 = (tmpvar_210 * sign((tmpvar_206.x / tmpvar_206.z)));
  if ((abs(tmpvar_206.z) > (1e-08 * abs(tmpvar_206.x)))) {
    if ((tmpvar_206.z < 0.0)) {
      if ((tmpvar_206.x >= 0.0)) {
        tmpvar_208 += 3.141593;
      } else {
        tmpvar_208 = (tmpvar_208 - 3.141593);
      };
    };
  } else {
    tmpvar_208 = (sign(tmpvar_206.x) * 1.570796);
  };
  uv_207.x = (0.5 + (0.1591549 * tmpvar_208));
  uv_207.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_206.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_206.y)
    )) * (1.570796 + (
      abs(tmpvar_206.y)
     * 
      (-0.2146018 + (abs(tmpvar_206.y) * (0.08656672 + (
        abs(tmpvar_206.y)
       * -0.03102955))))
    ))))
  )));
  vec4 uv4_211;
  uv4_211.zw = vec2(0.0, 0.0);
  vec3 tmpvar_212;
  tmpvar_212 = normalize(tmpvar_205);
  vec3 tmpvar_213;
  tmpvar_213 = abs(tmpvar_212);
  float tmpvar_214;
  tmpvar_214 = float((tmpvar_213.z >= tmpvar_213.x));
  float tmpvar_215;
  tmpvar_215 = float((max (tmpvar_213.x, tmpvar_213.z) >= tmpvar_213.y));
  float tmpvar_216;
  tmpvar_216 = sign(mix (tmpvar_212.y, mix (tmpvar_212.x, tmpvar_212.z, tmpvar_214), tmpvar_215));
  vec3 tmpvar_217;
  tmpvar_217.xz = vec2(1.0, -1.0);
  tmpvar_217.y = -(tmpvar_216);
  vec3 tmpvar_218;
  tmpvar_218.xz = vec2(1.0, -1.0);
  tmpvar_218.y = tmpvar_216;
  vec3 tmpvar_219;
  tmpvar_219.xy = vec2(1.0, 1.0);
  tmpvar_219.z = tmpvar_216;
  vec3 tmpvar_220;
  tmpvar_220 = mix ((tmpvar_219 * tmpvar_212.yxz), mix ((tmpvar_217 * tmpvar_212.xzy), (tmpvar_218 * tmpvar_212.zxy), vec3(tmpvar_214)), vec3(tmpvar_215));
  uv4_211.xy = (((0.5 * tmpvar_220.yz) / abs(tmpvar_220.x)) + 0.5);
  tmpvar_8 = (texture2DLod (_MainTex, uv_207, 0.0) * texture2DLod (_DetailTex, uv4_211.xy, 0.0));
  vec4 tmpvar_221;
  tmpvar_221.w = 0.0;
  tmpvar_221.xyz = _WorldSpaceCameraPos;
  float tmpvar_222;
  vec4 tmpvar_223;
  tmpvar_223 = (origin_7 - tmpvar_221);
  tmpvar_222 = sqrt(dot (tmpvar_223, tmpvar_223));
  tmpvar_9.w = (clamp ((_DistFade * tmpvar_222), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_222)
  ), 0.0, 1.0));
  tmpvar_8.w = (tmpvar_8.w * tmpvar_9.w);
  vec3 tmpvar_224;
  tmpvar_224.yz = vec2(0.0, 0.0);
  tmpvar_224.x = fract(_Rotation);
  vec3 x_225;
  x_225 = (tmpvar_224 + tmpvar_203);
  vec3 trans_226;
  trans_226 = localOrigin_5.xyz;
  float tmpvar_227;
  tmpvar_227 = (x_225.x * 6.283185);
  float tmpvar_228;
  tmpvar_228 = (x_225.y * 6.283185);
  float tmpvar_229;
  tmpvar_229 = (x_225.z * 2.0);
  float tmpvar_230;
  tmpvar_230 = sqrt(tmpvar_229);
  float tmpvar_231;
  tmpvar_231 = (sin(tmpvar_228) * tmpvar_230);
  float tmpvar_232;
  tmpvar_232 = (cos(tmpvar_228) * tmpvar_230);
  float tmpvar_233;
  tmpvar_233 = sqrt((2.0 - tmpvar_229));
  float tmpvar_234;
  tmpvar_234 = sin(tmpvar_227);
  float tmpvar_235;
  tmpvar_235 = cos(tmpvar_227);
  float tmpvar_236;
  tmpvar_236 = ((tmpvar_231 * tmpvar_235) - (tmpvar_232 * tmpvar_234));
  float tmpvar_237;
  tmpvar_237 = ((tmpvar_231 * tmpvar_234) + (tmpvar_232 * tmpvar_235));
  mat4 tmpvar_238;
  tmpvar_238[0].x = (tmpvar_204 * ((tmpvar_231 * tmpvar_236) - tmpvar_235));
  tmpvar_238[0].y = ((tmpvar_231 * tmpvar_237) - tmpvar_234);
  tmpvar_238[0].z = (tmpvar_231 * tmpvar_233);
  tmpvar_238[0].w = 0.0;
  tmpvar_238[1].x = ((tmpvar_232 * tmpvar_236) + tmpvar_234);
  tmpvar_238[1].y = (tmpvar_204 * ((tmpvar_232 * tmpvar_237) - tmpvar_235));
  tmpvar_238[1].z = (tmpvar_232 * tmpvar_233);
  tmpvar_238[1].w = 0.0;
  tmpvar_238[2].x = (tmpvar_233 * tmpvar_236);
  tmpvar_238[2].y = (tmpvar_233 * tmpvar_237);
  tmpvar_238[2].z = (tmpvar_204 * (1.0 - tmpvar_229));
  tmpvar_238[2].w = 0.0;
  tmpvar_238[3].x = trans_226.x;
  tmpvar_238[3].y = trans_226.y;
  tmpvar_238[3].z = trans_226.z;
  tmpvar_238[3].w = 1.0;
  mat4 tmpvar_239;
  tmpvar_239 = ((unity_MatrixV * _Object2World) * tmpvar_238);
  vec4 v_240;
  v_240.x = tmpvar_239[0].z;
  v_240.y = tmpvar_239[1].z;
  v_240.z = tmpvar_239[2].z;
  v_240.w = tmpvar_239[3].z;
  vec3 tmpvar_241;
  tmpvar_241 = normalize(v_240.xyz);
  tmpvar_9.xyz = abs(tmpvar_241);
  vec4 tmpvar_242;
  tmpvar_242 = (gl_ModelViewMatrix * localOrigin_5);
  vec4 tmpvar_243;
  tmpvar_243.xyz = (gl_Vertex.xyz * tmpvar_204);
  tmpvar_243.w = gl_Vertex.w;
  vec2 tmpvar_244;
  tmpvar_244 = ((2.0 * gl_MultiTexCoord0.xy) - 1.0);
  vec4 tmpvar_245;
  tmpvar_245.z = 0.0;
  tmpvar_245.xy = tmpvar_244;
  tmpvar_245.w = gl_Vertex.w;
  ZYv_4.xyw = tmpvar_245.zyw;
  XZv_3.yzw = tmpvar_245.zyw;
  XYv_2.yzw = tmpvar_245.yzw;
  ZYv_4.z = (tmpvar_244.x * sign(-(tmpvar_241.x)));
  XZv_3.x = (tmpvar_244.x * sign(-(tmpvar_241.y)));
  XYv_2.x = (tmpvar_244.x * sign(tmpvar_241.z));
  ZYv_4.x = ((sign(
    -(tmpvar_241.x)
  ) * sign(ZYv_4.z)) * tmpvar_241.z);
  XZv_3.y = ((sign(
    -(tmpvar_241.y)
  ) * sign(XZv_3.x)) * tmpvar_241.x);
  XYv_2.z = ((sign(
    -(tmpvar_241.z)
  ) * sign(XYv_2.x)) * tmpvar_241.x);
  ZYv_4.x = (ZYv_4.x + ((
    sign(-(tmpvar_241.x))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  XZv_3.y = (XZv_3.y + ((
    sign(-(tmpvar_241.y))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.z));
  XYv_2.z = (XYv_2.z + ((
    sign(-(tmpvar_241.z))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  vec3 tmpvar_246;
  tmpvar_246 = normalize((origin_7.xyz - _WorldSpaceCameraPos));
  vec3 tmpvar_247;
  tmpvar_247 = normalize(-(tmpvar_246));
  vec4 v_248;
  v_248.x = unity_MatrixV[0].x;
  v_248.y = unity_MatrixV[1].x;
  v_248.z = unity_MatrixV[2].x;
  v_248.w = unity_MatrixV[3].x;
  vec3 tmpvar_249;
  tmpvar_249 = normalize(v_248.xyz);
  vec3 tmpvar_250;
  vec3 tmpvar_251;
  tmpvar_250 = v_248.xyz;
  tmpvar_251 = ((tmpvar_247.zxy * tmpvar_249.yzx) - (tmpvar_247.yzx * tmpvar_249.zxy));
  mat3 tmpvar_252;
  tmpvar_252[0].x = tmpvar_250.x;
  tmpvar_252[0].y = tmpvar_251.x;
  tmpvar_252[0].z = tmpvar_247.x;
  tmpvar_252[1].x = tmpvar_250.y;
  tmpvar_252[1].y = tmpvar_251.y;
  tmpvar_252[1].z = tmpvar_247.y;
  tmpvar_252[2].x = tmpvar_250.z;
  tmpvar_252[2].y = tmpvar_251.z;
  tmpvar_252[2].z = tmpvar_247.z;
  gl_Position = (gl_ProjectionMatrix * (tmpvar_242 + tmpvar_243));
  xlv_COLOR = tmpvar_8;
  xlv_TEXCOORD0 = tmpvar_9;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * ZYv_4)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XZv_3)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XYv_2)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD4 = tmpvar_1;
  xlv_TEXCOORD5 = tmpvar_10;
  xlv_TEXCOORD6 = tmpvar_11;
  xlv_TEXCOORD7 = normalize((tmpvar_252 * tmpvar_246));
  xlv_TEXCOORD8 = normalize((tmpvar_252 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform vec4 _LightColor0;
uniform sampler2D _Tex;
uniform vec4 _Color;
uniform float _MinScatter;
uniform float _Opacity;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec3 normT_1;
  vec4 color_2;
  vec4 tex_3;
  tex_3.x = texture2D (_Tex, xlv_TEXCOORD1).x;
  tex_3.y = texture2D (_Tex, xlv_TEXCOORD2).y;
  tex_3.z = texture2D (_Tex, xlv_TEXCOORD3).z;
  tex_3.w = 0.0;
  tex_3.xyz = (tex_3.xyz * xlv_TEXCOORD0.xyz);
  tex_3 = (tex_3 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  float tmpvar_4;
  tmpvar_4 = ((tex_3.x + tex_3.y) + (tex_3.z + tex_3.w));
  vec4 tmpvar_5;
  tmpvar_5.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_5.w = tmpvar_4;
  tex_3.xyz = tmpvar_5.xyz;
  color_2 = (_Color * xlv_COLOR);
  normT_1.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_1.z = sqrt((1.0 - clamp (
    dot (normT_1.xy, normT_1.xy)
  , 0.0, 1.0)));
  color_2.w = (color_2.w * tmpvar_4);
  tex_3.w = (xlv_TEXCOORD0.w * tmpvar_4);
  vec4 c_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD8);
  vec3 tmpvar_8;
  tmpvar_8 = normalize(xlv_TEXCOORD7);
  vec3 tmpvar_9;
  tmpvar_9 = normalize(normT_1);
  float tmpvar_10;
  tmpvar_10 = max (dot (tmpvar_9, tmpvar_7), 0.0);
  c_6.xyz = ((_LightColor0.xyz * (vec3(tmpvar_10) + 
    clamp ((((_MinScatter - 
      (_Opacity * tex_3.w)
    ) * (1.0 - 
      dot (tmpvar_9, tmpvar_8)
    )) * (0.5 + (0.5 * 
      dot (tmpvar_8, tmpvar_7)
    ))), 0.0, 1.0)
  )) * 2.0);
  c_6.w = (tmpvar_10 * 2.0);
  color_2.xyz = (color_2.xyz * c_6.xyz);
  gl_FragData[0] = color_2;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 666 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "texcoord" TexCoord0
Matrix 19 [_DetailRotation] 3
Matrix 12 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 22 [_PosRotation] 3
Matrix 0 [glstate_matrix_modelview0]
Matrix 8 [glstate_matrix_projection]
Matrix 16 [unity_MatrixV] 3
Float 27 [_DistFade]
Float 28 [_DistFadeVert]
Float 30 [_MaxScale]
Vector 32 [_MaxTrans]
Vector 31 [_NoiseScale]
Float 29 [_Rotation]
Vector 25 [_WorldSpaceCameraPos]
Vector 26 [_WorldSpaceLightPos0]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
"vs_3_0
def c33, 0.333333343, 0.166666672, 1, -0.5
def c34, 34, 5.89795971, 49, 0.142857149
def c35, 0.00346020772, 289, 0, 1
def c36, 7, 0.285714298, -0.928571403, 0.600000024
def c37, 2, 1, 0.853734732, 1.79284286
def c38, -2, 3.14159274, 1, -1
def c39, 42, 0.0208350997, -0.0851330012, 0.180141002
def c40, -0.330299497, 0.999866009, -2, 1.57079637
def c41, -0.0187292993, 0.0742610022, 1.57072878, 0.318309873
def c42, -3.14159274, 0.159154937, 0.5, -0.212114394
def c43, 6.28318548, -3.14159274, 0.600000024, 0.5
dcl_position v0
dcl_texcoord v1
dcl_2d s0
dcl_2d s1
dcl_position o0
dcl_color o1
dcl_texcoord o2
dcl_texcoord1 o3.xy
dcl_texcoord2 o4.xy
dcl_texcoord3 o5.xy
dcl_texcoord4 o6.xy
dcl_texcoord5 o7
dcl_texcoord6 o8.xyz
dcl_texcoord7 o9.xyz
dcl_texcoord8 o10.xyz
mov r0.x, c4.w
mov r0.y, c5.w
mov r0.z, c6.w
mov r0.w, c7.w
dp4 r1.x, c22, r0
dp4 r1.y, c23, r0
dp4 r1.z, c24, r0
mul r0.xyz, r1, c31.z
dp3 r0.w, r0, c33.x
mad r2.xyz, c31.z, r1, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mad r1.xyz, c31.z, r1, -r2
dp3 r0.w, r2, c33.y
add r1.xyz, r0.w, r1
sge r2.xyz, r1, r1.yzxw
add r3.xyz, -r2.zxyw, c33.z
min r4.xyz, r2, r3
max r2.xyz, r2, r3
mad r3.xyw, r4.z, c35.zwzz, c35.zzzw
mov r3.z, r2.z
mad r3, r5.z, c35.y, r3
mul r5.xy, r5, c35.y
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.y
mad r6.xyw, r4.zyzz, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r3, r3, r6
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.x
mad r5.xyw, r4.zxzz, c35.zwzz, c35.zzzw
add r4.xyz, r1, -r4
add r4.xyz, r4, c33.y
mov r5.z, r2.x
add r2.xyz, r1, -r2
add r2.xyz, r2, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r6, r3, r5, -r5
mul r3, r6, c34.y
mul r5, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r5
frc r5, r5
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r5.xz, r6.yyww
add r7, r5, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r5, r7.zwxy, -r9.yyxx, r5.zwxy
mov r7.xy, r5.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r5.z, r8.y
dp3 r10.y, r5, r5
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r5.xyz, r5, r6.y
dp3 r5.y, r5, r4
dp3 r4.y, r4, r4
mul r3.xyz, r3, r6.z
dp3 r5.z, r3, r2
dp3 r4.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r5.x, r2, r1
add r2.xyz, r1, c33.w
dp3 r4.x, r1, r1
dp3 r5.w, r3, r2
dp3 r4.w, r2, r2
add r1, -r4, c36.w
max r1, r1, c35.z
mul r1, r1, r1
mul r1, r1, r1
dp4 r0.w, r1, r5
mul r1.x, r0.w, c39.x
mul r2.xyz, r0, c31.x
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.x, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r4.xyz, c31.x, r0, -r2
dp3 r0.w, r2, c33.y
add r2.xyz, r0.w, r4
sge r4.xyz, r2, r2.yzxw
add r5.xyw, -r4.zxzy, c33.z
min r6.xyz, r4, r5.xyww
max r4.xyz, r4, r5.xyww
mad r7.xyw, r6.z, c35.zwzz, c35.zzzw
mov r7.z, r4.z
mad r5, r5.z, c35.y, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r5, r8, c35.y, r3.y
mad r7.xyw, r6.zyzz, c35.zwzz, c35.zzzw
mov r7.z, r4.y
add r5, r5, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r3, r8, c35.y, r3.x
mad r5.xyw, r6.zxzz, c35.zwzz, c35.zzzw
add r6.xyz, r2, -r6
add r6.xyz, r6, c33.y
mov r5.z, r4.x
add r4.xyz, r2, -r4
add r4.xyz, r4, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r7, r3, r5, -r5
mul r3, r7, c34.y
mul r5, r7, c35.y
frc r7, r3
add r3, r3, -r7
mad r3, r3, -c34.z, r5
frc r5, r5
mul r7, r3, c34.w
frc r8, r7
add r7, r7, -r8
mad r3, r7, -c36.x, r3
mad r7, r7.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r8.yw, r3.xxzy
frc r8.xz, r7.yyww
mov r5.xz, r7.yyww
add r8, r5, -r8
mad r8, r8, c37.x, c37.y
add r9, -r7_abs.ywxz, c33.z
add r9, -r3_abs.xywz, r9.xywz
sge r10, c35.z, r9.xywz
mad r5, r8.zwxy, -r10.yyxx, r5.zwxy
mov r8.xy, r5.zwzw
mov r8.z, r9.x
dp3 r11.x, r8, r8
mov r5.z, r9.y
dp3 r11.y, r5, r5
frc r12.yw, r3.xzzw
mov r7.yw, r3.xzzw
frc r12.xz, r7
add r3, -r12, r7
mad r3, r3, c37.x, c37.y
mad r3, r3, -r10.zzww, r7
mov r9.xy, r3.zwzw
mov r3.z, r9.w
dp3 r11.z, r3, r3
dp3 r11.w, r9, r9
mad r7, r11, -c37.z, c37.w
mul r5.xyz, r5, r7.y
dp3 r5.y, r5, r6
dp3 r6.y, r6, r6
mul r3.xyz, r3, r7.z
dp3 r5.z, r3, r4
dp3 r6.z, r4, r4
mul r3.xyz, r7.x, r8
mul r4.xyz, r7.w, r9
dp3 r5.x, r3, r2
add r3.xyz, r2, c33.w
dp3 r6.x, r2, r2
dp3 r5.w, r4, r3
dp3 r6.w, r3, r3
add r2, -r6, c36.w
max r2, r2, c35.z
mul r2, r2, r2
mul r2, r2, r2
dp4 r0.w, r2, r5
mul r1.y, r0.w, c39.x
mul r2.xyz, r0, c31.y
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.y, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r0.xyz, c31.y, r0, -r2
dp3 r0.w, r2, c33.y
add r0.xyz, r0.w, r0
sge r2.xyz, r0, r0.yzxw
add r4.xyz, -r2.zxyw, c33.z
min r5.xyw, r2.xyzz, r4.xyzz
max r2.xyz, r2, r4
mad r4.xyw, r5.w, c35.zwzz, c35.zzzw
mov r4.z, r2.z
mad r4, r5.z, c35.y, r4
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r4, r7, c35.y, r3.y
mad r6.xyw, r5.wyzw, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r4, r4, r6
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r3, r7, c35.y, r3.x
mad r4.xyw, r5.wxzw, c35.zwzz, c35.zzzw
add r5.xyz, r0, -r5.xyww
add r5.xyz, r5, c33.y
mov r4.z, r2.x
add r2.xyz, r0, -r2
add r2.xyz, r2, c33.x
add r3, r3, r4
mul r4, r3, r3
mad r3, r4, c34.x, r3
mul r3, r3, c35.x
frc r4, r3_abs
sge r3, r3, -r3
lrp r6, r3, r4, -r4
mul r3, r6, c34.y
mul r4, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r4
frc r4, r4
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r4, r3
mad r3, r3, c36.y, c36.z
mov r4.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r4.xz, r6.yyww
add r7, r4, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r4, r7.zwxy, -r9.yyxx, r4.zwxy
mov r7.xy, r4.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r4.z, r8.y
dp3 r10.y, r4, r4
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r4.xyz, r4, r6.y
dp3 r4.y, r4, r5
dp3 r5.y, r5, r5
mul r3.xyz, r3, r6.z
dp3 r4.z, r3, r2
dp3 r5.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r4.x, r2, r0
add r2.xyz, r0, c33.w
dp3 r5.x, r0, r0
dp3 r4.w, r3, r2
dp3 r5.w, r2, r2
add r0, -r5, c36.w
max r0, r0, c35.z
mul r0, r0, r0
mul r0, r0, r0
dp4 r0.x, r0, r4
mul r1.z, r0.x, c39.x
mul r0.xyz, r1, c32
add r1.xyz, r1, c33.z
mov r0.w, c33.z
dp4 r2.w, c7, r0
dp4 r2.x, c4, r0
dp4 r2.y, c5, r0
dp4 r2.z, c6, r0
dp4 r3.w, c15, r2
dp4 r3.x, c12, r2
dp4 r3.y, c13, r2
dp4 r3.z, c14, r2
add r2.xyz, r2, -c25
dp4 r4.y, c19, r3
dp4 r4.x, c20, r3
dp4 r4.z, c21, r3
dp3 r1.w, r4, r4
rsq r1.w, r1.w
mul r5.xyz, r1.w, r4
mad r2.w, r4.z, r1.w, -r5.y
sge r3.w, r5_abs.z, r5_abs.y
mad r2.w, r3.w, r2.w, r5.y
mad r1.w, r4.x, -r1.w, r2.w
max r2.w, r5_abs.z, r5_abs.y
sge r2.w, r2.w, r5_abs.x
mad r1.w, r2.w, r1.w, r5.x
slt r4.x, -r1.w, r1.w
slt r1.w, r1.w, -r1.w
add r4.y, -r1.w, r4.x
mov r6.y, -r4.y
mov r6.xz, c38.zyww
mul r6.xyz, r5.yzxw, r6
mov r4.xz, c38.zyww
mad r7.xyz, r4, r5.zyxw, -r6
mad r6.xyz, r3.w, r7, r6
mad r6.xyz, r4.xxyw, -r5, r6
mul r4.xyz, r5, r4.xxyw
mad r4.xyz, r2.w, r6, r4
mul r4.yz, r4, -c33.w
rcp r1.w, r4_abs.x
mad r4.xy, r4.yzzw, r1.w, -c33.w
mov r4.zw, c35.z
texldl r4, r4, s1
dp3 r1.w, r3, r3
rsq r1.w, r1.w
mul r5.xyz, r1.w, r3.xzyw
mov o8.xyz, r3
max r1.w, r5_abs.y, r5_abs.x
rcp r1.w, r1.w
min r2.w, r5_abs.y, r5_abs.x
mul r1.w, r1.w, r2.w
mul r2.w, r1.w, r1.w
mad r3.x, r2.w, c39.y, c39.z
mad r3.x, r2.w, r3.x, c39.w
mad r3.x, r2.w, r3.x, c40.x
mad r2.w, r2.w, r3.x, c40.y
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c40.z, c40.w
slt r3.x, r5_abs.y, r5_abs.x
mad r1.w, r2.w, r3.x, r1.w
slt r3.xy, r5.yzzw, -r5.yzzw
mad r1.w, r3.x, c42.x, r1.w
add r2.w, r1.w, r1.w
min r3.x, r5.y, r5.x
slt r3.x, r3.x, -r3.x
max r3.z, r5.y, r5.x
sge r3.z, r3.z, -r3.z
mul r3.x, r3.z, r3.x
mad r1.w, r3.x, -r2.w, r1.w
mad r6.x, r1.w, c42.y, c42.z
mad r1.w, r5_abs.z, c41.x, c41.y
mad r1.w, r1.w, r5_abs.z, c42.w
mad r1.w, r1.w, r5_abs.z, c41.z
add r2.w, -r5_abs.z, c33.z
rsq r2.w, r2.w
rcp r2.w, r2.w
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c38.x, c38.y
mad r1.w, r2.w, r3.y, r1.w
mul r6.y, r1.w, c41.w
mov r6.zw, c35.z
texldl r3, r6, s0
mul r3, r4, r3
dp3 r1.w, r2, r2
rsq r1.w, r1.w
rcp r2.w, r1.w
mul r2.xyz, r1.w, r2
mul_sat r1.w, r2.w, c27.x
mov r4.z, c33.z
mad_sat r2.w, c28.x, -r2.w, r4.z
mul r1.w, r1.w, r2.w
mul o1.w, r1.w, r3.w
mov o1.xyz, r3
mov o2.w, r1.w
frc r3.x, c29.x
mov r3.y, c35.z
mad r1.zw, r1.xyxz, -c33.w, r3.xyxy
mad r3.xy, r1.w, -c37.x, c37
mul r1.x, r1.x, -c33.w
mad r1.y, r1.y, -c33.w, -c33.w
frc r1.y, r1.y
mad r1.y, r1.y, c43.x, c43.y
sincos r5.xy, r1.y
add r1.y, -r4.z, c30.x
mad r1.x, r1.x, r1.y, c33.z
mul r4.z, r3.y, r1.x
rsq r1.y, r3.x
rcp r1.y, r1.y
add r1.w, r1.w, r1.w
add r1.z, r1.z, -c33.w
frc r1.z, r1.z
mad r1.z, r1.z, c43.x, c43.y
sincos r3.xy, r1.z
rsq r1.z, r1.w
rcp r1.z, r1.z
mul r1.zw, r1.z, r5.xyyx
mul r5.xyz, r3.yyxw, r1.wzww
mad r2.w, r1.z, r3.x, -r5.x
add r3.z, r5.z, r5.y
mul r4.x, r1.y, r2.w
mul r4.y, r1.y, r3.z
mad r5.yz, r1.xzww, r3.z, -r3.xyxw
mul r6.zw, r1.y, r1
mov r7, c5
mul r8.xyz, r7, c18.y
mov r9, c4
mad r8.xyz, c18.x, r9, r8
mov r10, c6
mad r8.xyz, c18.z, r10, r8
mov r11, c7
mad r8.xyz, c18.w, r11, r8
dp3 r12.z, r8, r4
mad r1.y, r1.z, r2.w, -r3.x
mad r6.x, r1.w, r2.w, r3.y
mul r5.x, r1.y, r1.x
mov r5.w, r6.z
dp3 r12.x, r8, r5.xyww
mul r6.y, r1.x, r5.z
mul r1.xyz, r1.x, v0
dp3 r12.y, r8, r6.xyww
nrm r3.xyz, r12
abs o2.xyz, r3
dp4 r8.z, c2, r0
dp4 r8.w, c3, r0
dp4 r8.x, c0, r0
dp4 r8.y, c1, r0
mov r1.w, v0.w
add r1, r1, r8
dp4 o0.x, c8, r1
dp4 o0.y, c9, r1
dp4 o0.z, c10, r1
dp4 o0.w, c11, r1
mul r1, r7, c16.y
mad r1, c16.x, r9, r1
mad r1, c16.z, r10, r1
mad r1, c16.w, r11, r1
dp3 r12.z, r1, r4
dp4 r12.w, r1, r0
dp3 r12.x, r1, r5.xyww
dp3 r12.y, r1, r6.xyww
slt r1.xyz, r3, -r3
slt r13.xyz, -r3, r3
add r1.xyw, r1.xyzz, -r13.xyzz
add r1.z, -r1.z, r13.z
mad r8.zw, v1.xyxy, -c38.x, -c38.z
slt r2.w, -r8.w, r8.w
slt r3.w, r8.w, -r8.w
add r2.w, r2.w, -r3.w
mul r13.xyz, r1.xyww, r2.w
mul r13.xyz, r3.yzyw, r13
mul r3.yw, r1.xxzy, r8.z
mul r14.x, r1.z, r8.z
slt r8.zw, -r3.xyyw, r3.xyyw
slt r15.xy, r3.ywzw, -r3.ywzw
add r8.zw, r8, -r15.xyxy
mul r1.xy, r1, r8.zwzw
mad r15.xy, r1, r3.zxzw, r13
mov r16.x, r15.x
mov r16.z, r3.y
mov r15.x, r3.w
mad r16.y, v1.y, -c38.x, -c38.z
mov r16.w, v0.w
dp4 r1.x, r12, r16
mul r7, r7, c17.y
mad r7, c17.x, r9, r7
mad r7, c17.z, r10, r7
mad r7, c17.w, r11, r7
dp3 r4.z, r7, r4
dp3 r4.x, r7, r5.xyww
dp3 r4.y, r7, r6.xyww
dp4 r4.w, r7, r0
dp4 r1.y, r4, r16
mov r15.zw, r16.xyyw
add r0.xy, -r8, r1
mad o3.xy, r0, c43.z, c43.w
dp4 r0.x, r12, r15
dp4 r0.y, r4, r15
mov r14.yw, r15.xzzw
add r0.xy, -r8, r0
mad o4.xy, r0, c43.z, c43.w
slt r0.x, -r14.x, r14.x
slt r0.y, r14.x, -r14.x
add r0.x, -r0.y, r0.x
mul r0.x, r0.x, r1.w
mad r14.z, r0.x, r3.x, r13.z
dp4 r0.x, r12, r14
dp4 r0.y, r4, r14
add r0.xy, -r8, r0
mad o5.xy, r0, c43.z, c43.w
nrm r0.xyz, -r2
dp3 r0.w, c16, c16
rsq r0.w, r0.w
mul r1.xyz, r0.w, c16.yzxw
mul r3.xyz, r0.zxyw, r1
mad r1.xyz, r0.yzxw, r1.yzxw, -r3
dp3 r3.y, -r1, c26
dp3 r1.y, -r1, r2
dp3 r3.z, r0, c26
dp3 r1.z, r0, r2
dp3 r1.x, c16, r2
mov r0.xyz, c16
dp3 r3.x, r0, c26
dp3 r0.x, r3, r3
rsq r0.x, r0.x
mul o10.xyz, r0.x, r3
dp3 r0.x, r1, r1
rsq r0.x, r0.x
mul o9.xyz, r0.x, r1
mov o6.xy, v1
mov o7, c35.z

"
}
SubProgram "d3d11 " {
// Stats: 469 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "texcoord" TexCoord0
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 592
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 368 [_PosRotation]
Float 464 [_DistFade]
Float 468 [_DistFadeVert]
Float 484 [_Rotation]
Float 488 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityLighting" 720
Vector 0 [_WorldSpaceLightPos0]
ConstBuffer "UnityPerDraw" 352
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
ConstBuffer "UnityPerFrame" 256
Matrix 0 [glstate_matrix_projection]
Matrix 80 [unity_MatrixV]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityLighting" 2
BindCB  "UnityPerDraw" 3
BindCB  "UnityPerFrame" 4
"vs_4_0
root12:acafacaa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"
}
SubProgram "gles " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 glstate_matrix_projection;
uniform highp mat4 unity_MatrixV;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform highp mat4 _PosRotation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _Rotation;
uniform highp float _MaxScale;
uniform highp vec4 _NoiseScale;
uniform highp vec3 _MaxTrans;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  mediump vec3 normal_3;
  highp vec4 XYv_4;
  highp vec4 XZv_5;
  highp vec4 ZYv_6;
  highp vec4 localOrigin_7;
  highp vec4 planet_pos_8;
  highp vec4 origin_9;
  lowp vec4 tmpvar_10;
  mediump vec4 tmpvar_11;
  highp vec4 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_9 = tmpvar_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (_PosRotation * tmpvar_14);
  planet_pos_8 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (_NoiseScale.z * tmpvar_15.xyz);
  highp float tmpvar_17;
  highp vec4 m_18;
  highp vec3 tmpvar_19;
  tmpvar_19 = floor((tmpvar_16 + dot (tmpvar_16, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_20;
  tmpvar_20 = ((tmpvar_16 - tmpvar_19) + dot (tmpvar_19, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_21;
  tmpvar_21.x = float((tmpvar_20.x >= tmpvar_20.y));
  tmpvar_21.y = float((tmpvar_20.y >= tmpvar_20.z));
  tmpvar_21.z = float((tmpvar_20.z >= tmpvar_20.x));
  highp vec3 tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_21);
  highp vec3 tmpvar_23;
  tmpvar_23 = min (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_24;
  tmpvar_24 = max (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_25;
  tmpvar_25 = ((tmpvar_20 - tmpvar_23) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_26;
  tmpvar_26 = ((tmpvar_20 - tmpvar_24) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_27;
  tmpvar_27 = (tmpvar_20 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28 = (tmpvar_19 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (fract(abs(tmpvar_28)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_30;
  if ((tmpvar_28.x >= 0.0)) {
    tmpvar_30 = tmpvar_29.x;
  } else {
    tmpvar_30 = -(tmpvar_29.x);
  };
  highp float tmpvar_31;
  if ((tmpvar_28.y >= 0.0)) {
    tmpvar_31 = tmpvar_29.y;
  } else {
    tmpvar_31 = -(tmpvar_29.y);
  };
  highp float tmpvar_32;
  if ((tmpvar_28.z >= 0.0)) {
    tmpvar_32 = tmpvar_29.z;
  } else {
    tmpvar_32 = -(tmpvar_29.z);
  };
  highp vec4 tmpvar_33;
  tmpvar_33.xw = vec2(0.0, 1.0);
  tmpvar_33.y = tmpvar_23.z;
  tmpvar_33.z = tmpvar_24.z;
  highp vec4 x_34;
  x_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35 = (((
    (x_34 * x_34)
   * 34.0) + x_34) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_36;
  tmpvar_36 = (fract(abs(tmpvar_35)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_37;
  if ((tmpvar_35.x >= 0.0)) {
    tmpvar_37 = tmpvar_36.x;
  } else {
    tmpvar_37 = -(tmpvar_36.x);
  };
  highp float tmpvar_38;
  if ((tmpvar_35.y >= 0.0)) {
    tmpvar_38 = tmpvar_36.y;
  } else {
    tmpvar_38 = -(tmpvar_36.y);
  };
  highp float tmpvar_39;
  if ((tmpvar_35.z >= 0.0)) {
    tmpvar_39 = tmpvar_36.z;
  } else {
    tmpvar_39 = -(tmpvar_36.z);
  };
  highp float tmpvar_40;
  if ((tmpvar_35.w >= 0.0)) {
    tmpvar_40 = tmpvar_36.w;
  } else {
    tmpvar_40 = -(tmpvar_36.w);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.x = tmpvar_37;
  tmpvar_41.y = tmpvar_38;
  tmpvar_41.z = tmpvar_39;
  tmpvar_41.w = tmpvar_40;
  highp vec4 tmpvar_42;
  tmpvar_42.xw = vec2(0.0, 1.0);
  tmpvar_42.y = tmpvar_23.y;
  tmpvar_42.z = tmpvar_24.y;
  highp vec4 x_43;
  x_43 = ((tmpvar_41 + tmpvar_31) + tmpvar_42);
  highp vec4 tmpvar_44;
  tmpvar_44 = (((
    (x_43 * x_43)
   * 34.0) + x_43) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_45;
  tmpvar_45 = (fract(abs(tmpvar_44)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_46;
  if ((tmpvar_44.x >= 0.0)) {
    tmpvar_46 = tmpvar_45.x;
  } else {
    tmpvar_46 = -(tmpvar_45.x);
  };
  highp float tmpvar_47;
  if ((tmpvar_44.y >= 0.0)) {
    tmpvar_47 = tmpvar_45.y;
  } else {
    tmpvar_47 = -(tmpvar_45.y);
  };
  highp float tmpvar_48;
  if ((tmpvar_44.z >= 0.0)) {
    tmpvar_48 = tmpvar_45.z;
  } else {
    tmpvar_48 = -(tmpvar_45.z);
  };
  highp float tmpvar_49;
  if ((tmpvar_44.w >= 0.0)) {
    tmpvar_49 = tmpvar_45.w;
  } else {
    tmpvar_49 = -(tmpvar_45.w);
  };
  highp vec4 tmpvar_50;
  tmpvar_50.x = tmpvar_46;
  tmpvar_50.y = tmpvar_47;
  tmpvar_50.z = tmpvar_48;
  tmpvar_50.w = tmpvar_49;
  highp vec4 tmpvar_51;
  tmpvar_51.xw = vec2(0.0, 1.0);
  tmpvar_51.y = tmpvar_23.x;
  tmpvar_51.z = tmpvar_24.x;
  highp vec4 x_52;
  x_52 = ((tmpvar_50 + tmpvar_30) + tmpvar_51);
  highp vec4 tmpvar_53;
  tmpvar_53 = (((
    (x_52 * x_52)
   * 34.0) + x_52) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_54;
  tmpvar_54 = (fract(abs(tmpvar_53)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_55;
  if ((tmpvar_53.x >= 0.0)) {
    tmpvar_55 = tmpvar_54.x;
  } else {
    tmpvar_55 = -(tmpvar_54.x);
  };
  highp float tmpvar_56;
  if ((tmpvar_53.y >= 0.0)) {
    tmpvar_56 = tmpvar_54.y;
  } else {
    tmpvar_56 = -(tmpvar_54.y);
  };
  highp float tmpvar_57;
  if ((tmpvar_53.z >= 0.0)) {
    tmpvar_57 = tmpvar_54.z;
  } else {
    tmpvar_57 = -(tmpvar_54.z);
  };
  highp float tmpvar_58;
  if ((tmpvar_53.w >= 0.0)) {
    tmpvar_58 = tmpvar_54.w;
  } else {
    tmpvar_58 = -(tmpvar_54.w);
  };
  highp vec4 tmpvar_59;
  tmpvar_59.x = tmpvar_55;
  tmpvar_59.y = tmpvar_56;
  tmpvar_59.z = tmpvar_57;
  tmpvar_59.w = tmpvar_58;
  highp vec4 tmpvar_60;
  tmpvar_60 = (tmpvar_59 - (49.0 * floor(
    (0.02040815 * tmpvar_59)
  )));
  highp vec4 tmpvar_61;
  tmpvar_61 = floor((tmpvar_60 * 0.1428571));
  highp vec4 tmpvar_62;
  tmpvar_62 = ((tmpvar_61 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_63;
  tmpvar_63 = ((floor(
    (tmpvar_60 - (7.0 * tmpvar_61))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_64;
  tmpvar_64 = ((1.0 - abs(tmpvar_62)) - abs(tmpvar_63));
  highp vec4 tmpvar_65;
  tmpvar_65.xy = tmpvar_62.xy;
  tmpvar_65.zw = tmpvar_63.xy;
  highp vec4 tmpvar_66;
  tmpvar_66.xy = tmpvar_62.zw;
  tmpvar_66.zw = tmpvar_63.zw;
  highp vec4 tmpvar_67;
  tmpvar_67 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_64)));
  highp vec4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_67.xxyy));
  highp vec4 tmpvar_69;
  tmpvar_69 = (tmpvar_66.xzyw + ((
    (floor(tmpvar_66) * 2.0)
   + 1.0).xzyw * tmpvar_67.zzww));
  highp vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_68.xy;
  tmpvar_70.z = tmpvar_64.x;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.zw;
  tmpvar_71.z = tmpvar_64.y;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = tmpvar_69.xy;
  tmpvar_72.z = tmpvar_64.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = tmpvar_69.zw;
  tmpvar_73.z = tmpvar_64.w;
  highp vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_70, tmpvar_70);
  tmpvar_74.y = dot (tmpvar_71, tmpvar_71);
  tmpvar_74.z = dot (tmpvar_72, tmpvar_72);
  tmpvar_74.w = dot (tmpvar_73, tmpvar_73);
  highp vec4 tmpvar_75;
  tmpvar_75 = (1.792843 - (0.8537347 * tmpvar_74));
  highp vec4 tmpvar_76;
  tmpvar_76.x = dot (tmpvar_20, tmpvar_20);
  tmpvar_76.y = dot (tmpvar_25, tmpvar_25);
  tmpvar_76.z = dot (tmpvar_26, tmpvar_26);
  tmpvar_76.w = dot (tmpvar_27, tmpvar_27);
  highp vec4 tmpvar_77;
  tmpvar_77 = max ((0.6 - tmpvar_76), vec4(0.0, 0.0, 0.0, 0.0));
  m_18 = (tmpvar_77 * tmpvar_77);
  highp vec4 tmpvar_78;
  tmpvar_78.x = dot ((tmpvar_70 * tmpvar_75.x), tmpvar_20);
  tmpvar_78.y = dot ((tmpvar_71 * tmpvar_75.y), tmpvar_25);
  tmpvar_78.z = dot ((tmpvar_72 * tmpvar_75.z), tmpvar_26);
  tmpvar_78.w = dot ((tmpvar_73 * tmpvar_75.w), tmpvar_27);
  tmpvar_17 = (42.0 * dot ((m_18 * m_18), tmpvar_78));
  highp float tmpvar_79;
  highp vec3 v_80;
  v_80 = (_NoiseScale.x * tmpvar_16);
  highp vec4 m_81;
  highp vec3 tmpvar_82;
  tmpvar_82 = floor((v_80 + dot (v_80, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_83;
  tmpvar_83 = ((v_80 - tmpvar_82) + dot (tmpvar_82, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_84;
  tmpvar_84.x = float((tmpvar_83.x >= tmpvar_83.y));
  tmpvar_84.y = float((tmpvar_83.y >= tmpvar_83.z));
  tmpvar_84.z = float((tmpvar_83.z >= tmpvar_83.x));
  highp vec3 tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_84);
  highp vec3 tmpvar_86;
  tmpvar_86 = min (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_87;
  tmpvar_87 = max (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_88;
  tmpvar_88 = ((tmpvar_83 - tmpvar_86) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_89;
  tmpvar_89 = ((tmpvar_83 - tmpvar_87) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_90;
  tmpvar_90 = (tmpvar_83 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_91;
  tmpvar_91 = (tmpvar_82 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = (fract(abs(tmpvar_91)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_93;
  if ((tmpvar_91.x >= 0.0)) {
    tmpvar_93 = tmpvar_92.x;
  } else {
    tmpvar_93 = -(tmpvar_92.x);
  };
  highp float tmpvar_94;
  if ((tmpvar_91.y >= 0.0)) {
    tmpvar_94 = tmpvar_92.y;
  } else {
    tmpvar_94 = -(tmpvar_92.y);
  };
  highp float tmpvar_95;
  if ((tmpvar_91.z >= 0.0)) {
    tmpvar_95 = tmpvar_92.z;
  } else {
    tmpvar_95 = -(tmpvar_92.z);
  };
  highp vec4 tmpvar_96;
  tmpvar_96.xw = vec2(0.0, 1.0);
  tmpvar_96.y = tmpvar_86.z;
  tmpvar_96.z = tmpvar_87.z;
  highp vec4 x_97;
  x_97 = (tmpvar_95 + tmpvar_96);
  highp vec4 tmpvar_98;
  tmpvar_98 = (((
    (x_97 * x_97)
   * 34.0) + x_97) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_99;
  tmpvar_99 = (fract(abs(tmpvar_98)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_100;
  if ((tmpvar_98.x >= 0.0)) {
    tmpvar_100 = tmpvar_99.x;
  } else {
    tmpvar_100 = -(tmpvar_99.x);
  };
  highp float tmpvar_101;
  if ((tmpvar_98.y >= 0.0)) {
    tmpvar_101 = tmpvar_99.y;
  } else {
    tmpvar_101 = -(tmpvar_99.y);
  };
  highp float tmpvar_102;
  if ((tmpvar_98.z >= 0.0)) {
    tmpvar_102 = tmpvar_99.z;
  } else {
    tmpvar_102 = -(tmpvar_99.z);
  };
  highp float tmpvar_103;
  if ((tmpvar_98.w >= 0.0)) {
    tmpvar_103 = tmpvar_99.w;
  } else {
    tmpvar_103 = -(tmpvar_99.w);
  };
  highp vec4 tmpvar_104;
  tmpvar_104.x = tmpvar_100;
  tmpvar_104.y = tmpvar_101;
  tmpvar_104.z = tmpvar_102;
  tmpvar_104.w = tmpvar_103;
  highp vec4 tmpvar_105;
  tmpvar_105.xw = vec2(0.0, 1.0);
  tmpvar_105.y = tmpvar_86.y;
  tmpvar_105.z = tmpvar_87.y;
  highp vec4 x_106;
  x_106 = ((tmpvar_104 + tmpvar_94) + tmpvar_105);
  highp vec4 tmpvar_107;
  tmpvar_107 = (((
    (x_106 * x_106)
   * 34.0) + x_106) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_108;
  tmpvar_108 = (fract(abs(tmpvar_107)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_109;
  if ((tmpvar_107.x >= 0.0)) {
    tmpvar_109 = tmpvar_108.x;
  } else {
    tmpvar_109 = -(tmpvar_108.x);
  };
  highp float tmpvar_110;
  if ((tmpvar_107.y >= 0.0)) {
    tmpvar_110 = tmpvar_108.y;
  } else {
    tmpvar_110 = -(tmpvar_108.y);
  };
  highp float tmpvar_111;
  if ((tmpvar_107.z >= 0.0)) {
    tmpvar_111 = tmpvar_108.z;
  } else {
    tmpvar_111 = -(tmpvar_108.z);
  };
  highp float tmpvar_112;
  if ((tmpvar_107.w >= 0.0)) {
    tmpvar_112 = tmpvar_108.w;
  } else {
    tmpvar_112 = -(tmpvar_108.w);
  };
  highp vec4 tmpvar_113;
  tmpvar_113.x = tmpvar_109;
  tmpvar_113.y = tmpvar_110;
  tmpvar_113.z = tmpvar_111;
  tmpvar_113.w = tmpvar_112;
  highp vec4 tmpvar_114;
  tmpvar_114.xw = vec2(0.0, 1.0);
  tmpvar_114.y = tmpvar_86.x;
  tmpvar_114.z = tmpvar_87.x;
  highp vec4 x_115;
  x_115 = ((tmpvar_113 + tmpvar_93) + tmpvar_114);
  highp vec4 tmpvar_116;
  tmpvar_116 = (((
    (x_115 * x_115)
   * 34.0) + x_115) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_117;
  tmpvar_117 = (fract(abs(tmpvar_116)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_118;
  if ((tmpvar_116.x >= 0.0)) {
    tmpvar_118 = tmpvar_117.x;
  } else {
    tmpvar_118 = -(tmpvar_117.x);
  };
  highp float tmpvar_119;
  if ((tmpvar_116.y >= 0.0)) {
    tmpvar_119 = tmpvar_117.y;
  } else {
    tmpvar_119 = -(tmpvar_117.y);
  };
  highp float tmpvar_120;
  if ((tmpvar_116.z >= 0.0)) {
    tmpvar_120 = tmpvar_117.z;
  } else {
    tmpvar_120 = -(tmpvar_117.z);
  };
  highp float tmpvar_121;
  if ((tmpvar_116.w >= 0.0)) {
    tmpvar_121 = tmpvar_117.w;
  } else {
    tmpvar_121 = -(tmpvar_117.w);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.x = tmpvar_118;
  tmpvar_122.y = tmpvar_119;
  tmpvar_122.z = tmpvar_120;
  tmpvar_122.w = tmpvar_121;
  highp vec4 tmpvar_123;
  tmpvar_123 = (tmpvar_122 - (49.0 * floor(
    (0.02040815 * tmpvar_122)
  )));
  highp vec4 tmpvar_124;
  tmpvar_124 = floor((tmpvar_123 * 0.1428571));
  highp vec4 tmpvar_125;
  tmpvar_125 = ((tmpvar_124 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_126;
  tmpvar_126 = ((floor(
    (tmpvar_123 - (7.0 * tmpvar_124))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_127;
  tmpvar_127 = ((1.0 - abs(tmpvar_125)) - abs(tmpvar_126));
  highp vec4 tmpvar_128;
  tmpvar_128.xy = tmpvar_125.xy;
  tmpvar_128.zw = tmpvar_126.xy;
  highp vec4 tmpvar_129;
  tmpvar_129.xy = tmpvar_125.zw;
  tmpvar_129.zw = tmpvar_126.zw;
  highp vec4 tmpvar_130;
  tmpvar_130 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_127)));
  highp vec4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_130.xxyy));
  highp vec4 tmpvar_132;
  tmpvar_132 = (tmpvar_129.xzyw + ((
    (floor(tmpvar_129) * 2.0)
   + 1.0).xzyw * tmpvar_130.zzww));
  highp vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_131.xy;
  tmpvar_133.z = tmpvar_127.x;
  highp vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.zw;
  tmpvar_134.z = tmpvar_127.y;
  highp vec3 tmpvar_135;
  tmpvar_135.xy = tmpvar_132.xy;
  tmpvar_135.z = tmpvar_127.z;
  highp vec3 tmpvar_136;
  tmpvar_136.xy = tmpvar_132.zw;
  tmpvar_136.z = tmpvar_127.w;
  highp vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_133, tmpvar_133);
  tmpvar_137.y = dot (tmpvar_134, tmpvar_134);
  tmpvar_137.z = dot (tmpvar_135, tmpvar_135);
  tmpvar_137.w = dot (tmpvar_136, tmpvar_136);
  highp vec4 tmpvar_138;
  tmpvar_138 = (1.792843 - (0.8537347 * tmpvar_137));
  highp vec4 tmpvar_139;
  tmpvar_139.x = dot (tmpvar_83, tmpvar_83);
  tmpvar_139.y = dot (tmpvar_88, tmpvar_88);
  tmpvar_139.z = dot (tmpvar_89, tmpvar_89);
  tmpvar_139.w = dot (tmpvar_90, tmpvar_90);
  highp vec4 tmpvar_140;
  tmpvar_140 = max ((0.6 - tmpvar_139), vec4(0.0, 0.0, 0.0, 0.0));
  m_81 = (tmpvar_140 * tmpvar_140);
  highp vec4 tmpvar_141;
  tmpvar_141.x = dot ((tmpvar_133 * tmpvar_138.x), tmpvar_83);
  tmpvar_141.y = dot ((tmpvar_134 * tmpvar_138.y), tmpvar_88);
  tmpvar_141.z = dot ((tmpvar_135 * tmpvar_138.z), tmpvar_89);
  tmpvar_141.w = dot ((tmpvar_136 * tmpvar_138.w), tmpvar_90);
  tmpvar_79 = (42.0 * dot ((m_81 * m_81), tmpvar_141));
  highp vec3 v_142;
  v_142 = (_NoiseScale.y * tmpvar_16);
  highp vec4 m_143;
  highp vec3 tmpvar_144;
  tmpvar_144 = floor((v_142 + dot (v_142, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_145;
  tmpvar_145 = ((v_142 - tmpvar_144) + dot (tmpvar_144, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_146;
  tmpvar_146.x = float((tmpvar_145.x >= tmpvar_145.y));
  tmpvar_146.y = float((tmpvar_145.y >= tmpvar_145.z));
  tmpvar_146.z = float((tmpvar_145.z >= tmpvar_145.x));
  highp vec3 tmpvar_147;
  tmpvar_147 = (1.0 - tmpvar_146);
  highp vec3 tmpvar_148;
  tmpvar_148 = min (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_149;
  tmpvar_149 = max (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_150;
  tmpvar_150 = ((tmpvar_145 - tmpvar_148) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_151;
  tmpvar_151 = ((tmpvar_145 - tmpvar_149) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_152;
  tmpvar_152 = (tmpvar_145 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_153;
  tmpvar_153 = (tmpvar_144 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_154;
  tmpvar_154 = (fract(abs(tmpvar_153)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_155;
  if ((tmpvar_153.x >= 0.0)) {
    tmpvar_155 = tmpvar_154.x;
  } else {
    tmpvar_155 = -(tmpvar_154.x);
  };
  highp float tmpvar_156;
  if ((tmpvar_153.y >= 0.0)) {
    tmpvar_156 = tmpvar_154.y;
  } else {
    tmpvar_156 = -(tmpvar_154.y);
  };
  highp float tmpvar_157;
  if ((tmpvar_153.z >= 0.0)) {
    tmpvar_157 = tmpvar_154.z;
  } else {
    tmpvar_157 = -(tmpvar_154.z);
  };
  highp vec4 tmpvar_158;
  tmpvar_158.xw = vec2(0.0, 1.0);
  tmpvar_158.y = tmpvar_148.z;
  tmpvar_158.z = tmpvar_149.z;
  highp vec4 x_159;
  x_159 = (tmpvar_157 + tmpvar_158);
  highp vec4 tmpvar_160;
  tmpvar_160 = (((
    (x_159 * x_159)
   * 34.0) + x_159) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_161;
  tmpvar_161 = (fract(abs(tmpvar_160)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_162;
  if ((tmpvar_160.x >= 0.0)) {
    tmpvar_162 = tmpvar_161.x;
  } else {
    tmpvar_162 = -(tmpvar_161.x);
  };
  highp float tmpvar_163;
  if ((tmpvar_160.y >= 0.0)) {
    tmpvar_163 = tmpvar_161.y;
  } else {
    tmpvar_163 = -(tmpvar_161.y);
  };
  highp float tmpvar_164;
  if ((tmpvar_160.z >= 0.0)) {
    tmpvar_164 = tmpvar_161.z;
  } else {
    tmpvar_164 = -(tmpvar_161.z);
  };
  highp float tmpvar_165;
  if ((tmpvar_160.w >= 0.0)) {
    tmpvar_165 = tmpvar_161.w;
  } else {
    tmpvar_165 = -(tmpvar_161.w);
  };
  highp vec4 tmpvar_166;
  tmpvar_166.x = tmpvar_162;
  tmpvar_166.y = tmpvar_163;
  tmpvar_166.z = tmpvar_164;
  tmpvar_166.w = tmpvar_165;
  highp vec4 tmpvar_167;
  tmpvar_167.xw = vec2(0.0, 1.0);
  tmpvar_167.y = tmpvar_148.y;
  tmpvar_167.z = tmpvar_149.y;
  highp vec4 x_168;
  x_168 = ((tmpvar_166 + tmpvar_156) + tmpvar_167);
  highp vec4 tmpvar_169;
  tmpvar_169 = (((
    (x_168 * x_168)
   * 34.0) + x_168) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_170;
  tmpvar_170 = (fract(abs(tmpvar_169)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_171;
  if ((tmpvar_169.x >= 0.0)) {
    tmpvar_171 = tmpvar_170.x;
  } else {
    tmpvar_171 = -(tmpvar_170.x);
  };
  highp float tmpvar_172;
  if ((tmpvar_169.y >= 0.0)) {
    tmpvar_172 = tmpvar_170.y;
  } else {
    tmpvar_172 = -(tmpvar_170.y);
  };
  highp float tmpvar_173;
  if ((tmpvar_169.z >= 0.0)) {
    tmpvar_173 = tmpvar_170.z;
  } else {
    tmpvar_173 = -(tmpvar_170.z);
  };
  highp float tmpvar_174;
  if ((tmpvar_169.w >= 0.0)) {
    tmpvar_174 = tmpvar_170.w;
  } else {
    tmpvar_174 = -(tmpvar_170.w);
  };
  highp vec4 tmpvar_175;
  tmpvar_175.x = tmpvar_171;
  tmpvar_175.y = tmpvar_172;
  tmpvar_175.z = tmpvar_173;
  tmpvar_175.w = tmpvar_174;
  highp vec4 tmpvar_176;
  tmpvar_176.xw = vec2(0.0, 1.0);
  tmpvar_176.y = tmpvar_148.x;
  tmpvar_176.z = tmpvar_149.x;
  highp vec4 x_177;
  x_177 = ((tmpvar_175 + tmpvar_155) + tmpvar_176);
  highp vec4 tmpvar_178;
  tmpvar_178 = (((
    (x_177 * x_177)
   * 34.0) + x_177) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_179;
  tmpvar_179 = (fract(abs(tmpvar_178)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_180;
  if ((tmpvar_178.x >= 0.0)) {
    tmpvar_180 = tmpvar_179.x;
  } else {
    tmpvar_180 = -(tmpvar_179.x);
  };
  highp float tmpvar_181;
  if ((tmpvar_178.y >= 0.0)) {
    tmpvar_181 = tmpvar_179.y;
  } else {
    tmpvar_181 = -(tmpvar_179.y);
  };
  highp float tmpvar_182;
  if ((tmpvar_178.z >= 0.0)) {
    tmpvar_182 = tmpvar_179.z;
  } else {
    tmpvar_182 = -(tmpvar_179.z);
  };
  highp float tmpvar_183;
  if ((tmpvar_178.w >= 0.0)) {
    tmpvar_183 = tmpvar_179.w;
  } else {
    tmpvar_183 = -(tmpvar_179.w);
  };
  highp vec4 tmpvar_184;
  tmpvar_184.x = tmpvar_180;
  tmpvar_184.y = tmpvar_181;
  tmpvar_184.z = tmpvar_182;
  tmpvar_184.w = tmpvar_183;
  highp vec4 tmpvar_185;
  tmpvar_185 = (tmpvar_184 - (49.0 * floor(
    (0.02040815 * tmpvar_184)
  )));
  highp vec4 tmpvar_186;
  tmpvar_186 = floor((tmpvar_185 * 0.1428571));
  highp vec4 tmpvar_187;
  tmpvar_187 = ((tmpvar_186 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_188;
  tmpvar_188 = ((floor(
    (tmpvar_185 - (7.0 * tmpvar_186))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_189;
  tmpvar_189 = ((1.0 - abs(tmpvar_187)) - abs(tmpvar_188));
  highp vec4 tmpvar_190;
  tmpvar_190.xy = tmpvar_187.xy;
  tmpvar_190.zw = tmpvar_188.xy;
  highp vec4 tmpvar_191;
  tmpvar_191.xy = tmpvar_187.zw;
  tmpvar_191.zw = tmpvar_188.zw;
  highp vec4 tmpvar_192;
  tmpvar_192 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_189)));
  highp vec4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_192.xxyy));
  highp vec4 tmpvar_194;
  tmpvar_194 = (tmpvar_191.xzyw + ((
    (floor(tmpvar_191) * 2.0)
   + 1.0).xzyw * tmpvar_192.zzww));
  highp vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_193.xy;
  tmpvar_195.z = tmpvar_189.x;
  highp vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.zw;
  tmpvar_196.z = tmpvar_189.y;
  highp vec3 tmpvar_197;
  tmpvar_197.xy = tmpvar_194.xy;
  tmpvar_197.z = tmpvar_189.z;
  highp vec3 tmpvar_198;
  tmpvar_198.xy = tmpvar_194.zw;
  tmpvar_198.z = tmpvar_189.w;
  highp vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_195, tmpvar_195);
  tmpvar_199.y = dot (tmpvar_196, tmpvar_196);
  tmpvar_199.z = dot (tmpvar_197, tmpvar_197);
  tmpvar_199.w = dot (tmpvar_198, tmpvar_198);
  highp vec4 tmpvar_200;
  tmpvar_200 = (1.792843 - (0.8537347 * tmpvar_199));
  highp vec4 tmpvar_201;
  tmpvar_201.x = dot (tmpvar_145, tmpvar_145);
  tmpvar_201.y = dot (tmpvar_150, tmpvar_150);
  tmpvar_201.z = dot (tmpvar_151, tmpvar_151);
  tmpvar_201.w = dot (tmpvar_152, tmpvar_152);
  highp vec4 tmpvar_202;
  tmpvar_202 = max ((0.6 - tmpvar_201), vec4(0.0, 0.0, 0.0, 0.0));
  m_143 = (tmpvar_202 * tmpvar_202);
  highp vec4 tmpvar_203;
  tmpvar_203.x = dot ((tmpvar_195 * tmpvar_200.x), tmpvar_145);
  tmpvar_203.y = dot ((tmpvar_196 * tmpvar_200.y), tmpvar_150);
  tmpvar_203.z = dot ((tmpvar_197 * tmpvar_200.z), tmpvar_151);
  tmpvar_203.w = dot ((tmpvar_198 * tmpvar_200.w), tmpvar_152);
  highp vec3 tmpvar_204;
  tmpvar_204.x = tmpvar_17;
  tmpvar_204.y = tmpvar_79;
  tmpvar_204.z = (42.0 * dot ((m_143 * m_143), tmpvar_203));
  highp vec3 tmpvar_205;
  tmpvar_205 = (0.5 * (tmpvar_204 + 1.0));
  localOrigin_7.xyz = (((2.0 * tmpvar_205) - 1.0) * _MaxTrans);
  localOrigin_7.w = 1.0;
  highp float tmpvar_206;
  tmpvar_206 = ((tmpvar_205.x * (_MaxScale - 1.0)) + 1.0);
  origin_9 = (_Object2World * localOrigin_7);
  planet_pos_8 = (_MainRotation * origin_9);
  highp vec3 tmpvar_207;
  tmpvar_207 = (_DetailRotation * planet_pos_8).xyz;
  tmpvar_13 = planet_pos_8.xyz;
  highp vec3 tmpvar_208;
  tmpvar_208 = normalize(planet_pos_8.xyz);
  highp vec2 uv_209;
  highp float tmpvar_210;
  highp float tmpvar_211;
  tmpvar_211 = (min (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0) / max (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0));
  highp float tmpvar_212;
  tmpvar_212 = (tmpvar_211 * tmpvar_211);
  tmpvar_212 = (((
    ((((
      ((((-0.01213232 * tmpvar_212) + 0.05368138) * tmpvar_212) - 0.1173503)
     * tmpvar_212) + 0.1938925) * tmpvar_212) - 0.3326756)
   * tmpvar_212) + 0.9999793) * tmpvar_211);
  tmpvar_212 = (tmpvar_212 + (float(
    (abs((tmpvar_208.x / tmpvar_208.z)) > 1.0)
  ) * (
    (tmpvar_212 * -2.0)
   + 1.570796)));
  tmpvar_210 = (tmpvar_212 * sign((tmpvar_208.x / tmpvar_208.z)));
  if ((abs(tmpvar_208.z) > (1e-08 * abs(tmpvar_208.x)))) {
    if ((tmpvar_208.z < 0.0)) {
      if ((tmpvar_208.x >= 0.0)) {
        tmpvar_210 += 3.141593;
      } else {
        tmpvar_210 = (tmpvar_210 - 3.141593);
      };
    };
  } else {
    tmpvar_210 = (sign(tmpvar_208.x) * 1.570796);
  };
  uv_209.x = (0.5 + (0.1591549 * tmpvar_210));
  uv_209.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_208.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_208.y)
    )) * (1.570796 + (
      abs(tmpvar_208.y)
     * 
      (-0.2146018 + (abs(tmpvar_208.y) * (0.08656672 + (
        abs(tmpvar_208.y)
       * -0.03102955))))
    ))))
  )));
  lowp vec4 tmpvar_213;
  tmpvar_213 = texture2DLod (_MainTex, uv_209, 0.0);
  mediump vec4 tmpvar_214;
  tmpvar_214 = tmpvar_213;
  tmpvar_10 = tmpvar_214;
  mediump vec3 detailCoords_215;
  mediump float s_216;
  mediump float nylerp_217;
  mediump float zxlerp_218;
  highp vec4 uv4_219;
  uv4_219.zw = vec2(0.0, 0.0);
  highp vec3 tmpvar_220;
  tmpvar_220 = normalize(tmpvar_207);
  highp vec3 tmpvar_221;
  tmpvar_221 = abs(tmpvar_220);
  highp float tmpvar_222;
  tmpvar_222 = float((tmpvar_221.z >= tmpvar_221.x));
  zxlerp_218 = tmpvar_222;
  highp float tmpvar_223;
  tmpvar_223 = float((max (tmpvar_221.x, tmpvar_221.z) >= tmpvar_221.y));
  nylerp_217 = tmpvar_223;
  highp float tmpvar_224;
  tmpvar_224 = mix (tmpvar_220.x, tmpvar_220.z, zxlerp_218);
  s_216 = tmpvar_224;
  highp float tmpvar_225;
  tmpvar_225 = sign(mix (tmpvar_220.y, s_216, nylerp_217));
  s_216 = tmpvar_225;
  mediump vec3 tmpvar_226;
  tmpvar_226.xz = vec2(1.0, -1.0);
  tmpvar_226.y = -(s_216);
  mediump vec3 tmpvar_227;
  tmpvar_227.xz = vec2(1.0, -1.0);
  tmpvar_227.y = s_216;
  highp vec3 tmpvar_228;
  tmpvar_228 = mix ((tmpvar_226 * tmpvar_220.xzy), (tmpvar_227 * tmpvar_220.zxy), vec3(zxlerp_218));
  detailCoords_215 = tmpvar_228;
  mediump vec3 tmpvar_229;
  tmpvar_229.xy = vec2(1.0, 1.0);
  tmpvar_229.z = s_216;
  highp vec3 tmpvar_230;
  tmpvar_230 = mix ((tmpvar_229 * tmpvar_220.yxz), detailCoords_215, vec3(nylerp_217));
  detailCoords_215 = tmpvar_230;
  mediump vec2 tmpvar_231;
  tmpvar_231 = (((0.5 * detailCoords_215.yz) / abs(detailCoords_215.x)) + 0.5);
  uv4_219.xy = tmpvar_231;
  lowp vec4 tmpvar_232;
  tmpvar_232 = texture2DLod (_DetailTex, uv4_219.xy, 0.0);
  mediump vec4 tmpvar_233;
  tmpvar_233 = tmpvar_232;
  tmpvar_10 = (tmpvar_10 * tmpvar_233);
  highp vec4 tmpvar_234;
  tmpvar_234.w = 0.0;
  tmpvar_234.xyz = _WorldSpaceCameraPos;
  highp float tmpvar_235;
  highp vec4 tmpvar_236;
  tmpvar_236 = (origin_9 - tmpvar_234);
  tmpvar_235 = sqrt(dot (tmpvar_236, tmpvar_236));
  highp float tmpvar_237;
  tmpvar_237 = (clamp ((_DistFade * tmpvar_235), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_235)
  ), 0.0, 1.0));
  tmpvar_11.w = tmpvar_237;
  tmpvar_10.w = (tmpvar_10.w * tmpvar_11.w);
  highp vec3 tmpvar_238;
  tmpvar_238.yz = vec2(0.0, 0.0);
  tmpvar_238.x = fract(_Rotation);
  highp vec3 x_239;
  x_239 = (tmpvar_238 + tmpvar_205);
  highp vec3 trans_240;
  trans_240 = localOrigin_7.xyz;
  highp float tmpvar_241;
  tmpvar_241 = (x_239.x * 6.283185);
  highp float tmpvar_242;
  tmpvar_242 = (x_239.y * 6.283185);
  highp float tmpvar_243;
  tmpvar_243 = (x_239.z * 2.0);
  highp float tmpvar_244;
  tmpvar_244 = sqrt(tmpvar_243);
  highp float tmpvar_245;
  tmpvar_245 = (sin(tmpvar_242) * tmpvar_244);
  highp float tmpvar_246;
  tmpvar_246 = (cos(tmpvar_242) * tmpvar_244);
  highp float tmpvar_247;
  tmpvar_247 = sqrt((2.0 - tmpvar_243));
  highp float tmpvar_248;
  tmpvar_248 = sin(tmpvar_241);
  highp float tmpvar_249;
  tmpvar_249 = cos(tmpvar_241);
  highp float tmpvar_250;
  tmpvar_250 = ((tmpvar_245 * tmpvar_249) - (tmpvar_246 * tmpvar_248));
  highp float tmpvar_251;
  tmpvar_251 = ((tmpvar_245 * tmpvar_248) + (tmpvar_246 * tmpvar_249));
  highp mat4 tmpvar_252;
  tmpvar_252[0].x = (tmpvar_206 * ((tmpvar_245 * tmpvar_250) - tmpvar_249));
  tmpvar_252[0].y = ((tmpvar_245 * tmpvar_251) - tmpvar_248);
  tmpvar_252[0].z = (tmpvar_245 * tmpvar_247);
  tmpvar_252[0].w = 0.0;
  tmpvar_252[1].x = ((tmpvar_246 * tmpvar_250) + tmpvar_248);
  tmpvar_252[1].y = (tmpvar_206 * ((tmpvar_246 * tmpvar_251) - tmpvar_249));
  tmpvar_252[1].z = (tmpvar_246 * tmpvar_247);
  tmpvar_252[1].w = 0.0;
  tmpvar_252[2].x = (tmpvar_247 * tmpvar_250);
  tmpvar_252[2].y = (tmpvar_247 * tmpvar_251);
  tmpvar_252[2].z = (tmpvar_206 * (1.0 - tmpvar_243));
  tmpvar_252[2].w = 0.0;
  tmpvar_252[3].x = trans_240.x;
  tmpvar_252[3].y = trans_240.y;
  tmpvar_252[3].z = trans_240.z;
  tmpvar_252[3].w = 1.0;
  highp mat4 tmpvar_253;
  tmpvar_253 = ((unity_MatrixV * _Object2World) * tmpvar_252);
  highp vec4 v_254;
  v_254.x = tmpvar_253[0].z;
  v_254.y = tmpvar_253[1].z;
  v_254.z = tmpvar_253[2].z;
  v_254.w = tmpvar_253[3].z;
  highp vec3 tmpvar_255;
  tmpvar_255 = normalize(v_254.xyz);
  highp vec3 tmpvar_256;
  tmpvar_256 = abs(tmpvar_255);
  tmpvar_11.xyz = tmpvar_256;
  highp vec4 tmpvar_257;
  tmpvar_257 = (glstate_matrix_modelview0 * localOrigin_7);
  highp vec4 tmpvar_258;
  tmpvar_258.xyz = (_glesVertex.xyz * tmpvar_206);
  tmpvar_258.w = tmpvar_1.w;
  highp vec2 tmpvar_259;
  tmpvar_259 = ((2.0 * _glesMultiTexCoord0.xy) - 1.0);
  highp vec4 tmpvar_260;
  tmpvar_260.z = 0.0;
  tmpvar_260.xy = tmpvar_259;
  tmpvar_260.w = tmpvar_1.w;
  ZYv_6.xyw = tmpvar_260.zyw;
  XZv_5.yzw = tmpvar_260.zyw;
  XYv_4.yzw = tmpvar_260.yzw;
  ZYv_6.z = (tmpvar_259.x * sign(-(tmpvar_255.x)));
  XZv_5.x = (tmpvar_259.x * sign(-(tmpvar_255.y)));
  XYv_4.x = (tmpvar_259.x * sign(tmpvar_255.z));
  ZYv_6.x = ((sign(
    -(tmpvar_255.x)
  ) * sign(ZYv_6.z)) * tmpvar_255.z);
  XZv_5.y = ((sign(
    -(tmpvar_255.y)
  ) * sign(XZv_5.x)) * tmpvar_255.x);
  XYv_4.z = ((sign(
    -(tmpvar_255.z)
  ) * sign(XYv_4.x)) * tmpvar_255.x);
  ZYv_6.x = (ZYv_6.x + ((
    sign(-(tmpvar_255.x))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  XZv_5.y = (XZv_5.y + ((
    sign(-(tmpvar_255.y))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.z));
  XYv_4.z = (XYv_4.z + ((
    sign(-(tmpvar_255.z))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  highp vec3 tmpvar_261;
  tmpvar_261 = normalize((origin_9.xyz - _WorldSpaceCameraPos));
  highp vec3 tmpvar_262;
  tmpvar_262 = normalize(-(tmpvar_261));
  normal_3 = tmpvar_262;
  highp vec4 v_263;
  v_263.x = unity_MatrixV[0].x;
  v_263.y = unity_MatrixV[1].x;
  v_263.z = unity_MatrixV[2].x;
  v_263.w = unity_MatrixV[3].x;
  highp vec3 tmpvar_264;
  tmpvar_264 = normalize(v_263.xyz);
  highp vec3 tmpvar_265;
  highp vec3 tmpvar_266;
  tmpvar_265 = v_263.xyz;
  tmpvar_266 = ((normal_3.zxy * tmpvar_264.yzx) - (normal_3.yzx * tmpvar_264.zxy));
  highp vec3 tmpvar_267;
  tmpvar_267 = normal_3;
  highp mat3 tmpvar_268;
  tmpvar_268[0].x = tmpvar_265.x;
  tmpvar_268[0].y = tmpvar_266.x;
  tmpvar_268[0].z = tmpvar_267.x;
  tmpvar_268[1].x = tmpvar_265.y;
  tmpvar_268[1].y = tmpvar_266.y;
  tmpvar_268[1].z = tmpvar_267.y;
  tmpvar_268[2].x = tmpvar_265.z;
  tmpvar_268[2].y = tmpvar_266.z;
  tmpvar_268[2].z = tmpvar_267.z;
  gl_Position = (glstate_matrix_projection * (tmpvar_257 + tmpvar_258));
  xlv_COLOR = tmpvar_10;
  xlv_TEXCOORD0 = tmpvar_11;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * ZYv_6)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XZv_5)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XYv_4)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD4 = tmpvar_2;
  xlv_TEXCOORD5 = tmpvar_12;
  xlv_TEXCOORD6 = tmpvar_13;
  xlv_TEXCOORD7 = normalize((tmpvar_268 * tmpvar_261));
  xlv_TEXCOORD8 = normalize((tmpvar_268 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform lowp vec4 _LightColor0;
uniform sampler2D _Tex;
uniform lowp vec4 _Color;
uniform highp float _MinScatter;
uniform highp float _Opacity;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec3 normT_2;
  mediump vec4 color_3;
  mediump vec4 tex_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_Tex, xlv_TEXCOORD1);
  tex_4.x = tmpvar_5.x;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex, xlv_TEXCOORD2);
  tex_4.y = tmpvar_6.y;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex, xlv_TEXCOORD3);
  tex_4.z = tmpvar_7.z;
  tex_4.w = 0.0;
  tex_4.xyz = (tex_4.xyz * xlv_TEXCOORD0.xyz);
  tex_4 = (tex_4 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  mediump float tmpvar_8;
  tmpvar_8 = ((tex_4.x + tex_4.y) + (tex_4.z + tex_4.w));
  mediump vec4 tmpvar_9;
  tmpvar_9.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_9.w = tmpvar_8;
  tex_4.xyz = tmpvar_9.xyz;
  color_3 = (_Color * xlv_COLOR);
  normT_2.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_2.z = sqrt((1.0 - clamp (
    dot (normT_2.xy, normT_2.xy)
  , 0.0, 1.0)));
  color_3.w = (color_3.w * tmpvar_8);
  tex_4.w = (xlv_TEXCOORD0.w * tmpvar_8);
  mediump vec3 lightDir_10;
  lightDir_10 = xlv_TEXCOORD8;
  mediump vec3 viewDir_11;
  viewDir_11 = xlv_TEXCOORD7;
  mediump vec4 c_12;
  highp float h_13;
  mediump vec3 tmpvar_14;
  tmpvar_14 = normalize(lightDir_10);
  lightDir_10 = tmpvar_14;
  mediump vec3 tmpvar_15;
  tmpvar_15 = normalize(viewDir_11);
  viewDir_11 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16 = normalize(normT_2);
  mediump float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_16, tmpvar_14), 0.0);
  mediump float tmpvar_18;
  tmpvar_18 = (0.5 + (0.5 * dot (tmpvar_15, tmpvar_14)));
  h_13 = tmpvar_18;
  mediump float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, tmpvar_15);
  highp float tmpvar_20;
  tmpvar_20 = clamp (((
    (_MinScatter - (_Opacity * tex_4.w))
   * 
    (1.0 - tmpvar_19)
  ) * h_13), 0.0, 1.0);
  c_12.xyz = ((_LightColor0.xyz * (vec3(tmpvar_17) + tmpvar_20)) * 2.0);
  c_12.w = (tmpvar_17 * 2.0);
  color_3.xyz = (color_3.xyz * c_12.xyz);
  tmpvar_1 = color_3;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 in_POSITION0;
in highp vec2 in_TEXCOORD0;
out lowp vec4 vs_COLOR0;
out mediump vec4 vs_TEXCOORD0;
out highp vec2 vs_TEXCOORD1;
out highp vec2 vs_TEXCOORD2;
out highp vec2 vs_TEXCOORD3;
out highp vec2 vs_TEXCOORD4;
out highp vec4 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD7;
out highp vec3 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
bvec4 tb1;
highp vec4 t2;
highp vec4 t3;
bvec3 tb3;
highp vec4 t4;
mediump vec4 t16_4;
bvec4 tb4;
highp vec4 t5;
highp ivec3 ti5;
bvec4 tb5;
highp vec4 t6;
bvec3 tb6;
highp vec4 t7;
bvec4 tb7;
highp vec4 t8;
highp ivec3 ti8;
highp vec4 t9;
bvec4 tb9;
highp vec4 t10;
bvec4 tb10;
highp vec4 t11;
bvec4 tb11;
highp vec4 t12;
highp vec4 t13;
mediump vec3 t16_14;
mediump vec3 t16_15;
highp float t17;
highp float t22;
highp ivec3 ti22;
highp vec3 t24;
highp vec2 t32;
highp int ti32;
highp vec2 t33;
highp int ti33;
highp vec2 t35;
highp ivec2 ti35;
bvec2 tb35;
highp float t48;
highp int ti48;
highp float t49;
highp int ti49;
bool tb49;
highp float t50;
highp int ti50;
bool tb50;
highp float t51;
highp int ti51;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t50 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t50);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t50 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t50) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t48 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t48);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t48 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t48) + t6.xyz;
    t48 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t48);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t48 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t48) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t48 = dot(t1, t6);
    t0.x = t48 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t48 = t1.x * 0.5;
    t49 = _MaxScale + -1.0;
    t48 = t48 * t49 + 1.0;
    t2.xyz = vec3(t48) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t49 = dot(t5.xyz, t5.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t5.xyz;
    t50 = t5.z * t49 + (-t6.y);
    tb35.x = abs(t6.z)>=abs(t6.y);
    t35.x = tb35.x ? 1.0 : float(0.0);
    t50 = t35.x * t50 + t6.y;
    t49 = (-t5.x) * t49 + t50;
    t50 = max(abs(t6.z), abs(t6.y));
    tb50 = t50>=abs(t6.x);
    t50 = tb50 ? 1.0 : float(0.0);
    t49 = t50 * t49 + t6.x;
    ti51 = int((0.0<t49) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t49<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti49 = (-ti51) + ti49;
    t16_14.y = float(ti49);
    t16_15.y = (-t16_14.y);
    t16_15.xz = vec2(1.0, -1.0);
    t5.xyz = t6.yzx * t16_15.xyz;
    t16_14.xz = vec2(1.0, -1.0);
    t7.xyz = t16_14.xyz * t6.zyx + (-t5.xyz);
    t5.xyz = t35.xxx * t7.xyz + t5.xyz;
    t5.xyz = (-t16_14.xxy) * t6.xyz + t5.xyz;
    t6.xyz = t6.xyz * t16_14.xxy;
    t5.xyz = vec3(t50) * t5.xyz + t6.xyz;
    t16_14.xy = vec2(t5.y * float(0.5), t5.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t5.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t16_14.xy, 0.0);
    t49 = dot(t4.xyz, t4.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb49 = abs(t6.y)<abs(t6.x);
    t50 = max(abs(t6.y), abs(t6.x));
    t50 = float(1.0) / t50;
    t35.x = min(abs(t6.y), abs(t6.x));
    t50 = t50 * t35.x;
    t35.x = t50 * t50;
    t51 = t35.x * 0.0208350997 + -0.0851330012;
    t51 = t35.x * t51 + 0.180141002;
    t51 = t35.x * t51 + -0.330299497;
    t35.x = t35.x * t51 + 0.999866009;
    t51 = t50 * t35.x;
    t51 = t51 * -2.0 + 1.57079637;
    t49 = tb49 ? t51 : float(0.0);
    t49 = t50 * t35.x + t49;
    tb35.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t50 = tb35.x ? -3.14159274 : float(0.0);
    t49 = t49 + t50;
    t50 = min(t6.y, t6.x);
    tb50 = t50<(-t50);
    t35.x = max(t6.y, t6.x);
    tb35.x = t35.x>=(-t35.x);
    ti50 = int(uint(tb50) * 0xffffffffu & uint(tb35.x) * 0xffffffffu);
    t49 = (ti50 != 0) ? (-t49) : t49;
    t4.x = t49 * 0.159154937 + 0.5;
    t49 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t49 = t49 * abs(t6.z) + -0.212114394;
    t49 = t49 * abs(t6.z) + 1.57072878;
    t50 = -abs(t6.z) + 1.0;
    t50 = sqrt(t50);
    t35.x = t49 * t50;
    t35.x = t35.x * -2.0 + 3.14159274;
    t35.x = tb35.y ? t35.x : float(0.0);
    t49 = t49 * t50 + t35.x;
    t4.y = t49 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t16_4 = t5 * t4;
    t49 = dot(t2.xyz, t2.xyz);
    t50 = sqrt(t49);
    t49 = inversesqrt(t49);
    t2.xyz = vec3(t49) * t2.xyz;
    t49 = t50 * _DistFade;
    t50 = (-_DistFadeVert) * t50 + 1.0;
    t50 = clamp(t50, 0.0, 1.0);
    t49 = t49;
    t49 = clamp(t49, 0.0, 1.0);
    t5.w = t50 * t49;
    t16_4.w = t16_4.w * t5.w;
    vs_COLOR0 = t16_4;
    t6.x = fract(_Rotation);
    t6.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t6.xyz;
    t35.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t35.x);
    t50 = t48 * t35.y;
    t33.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t33.x = sqrt(t33.x);
    t6.x = sin(t1.y);
    t7.x = cos(t1.y);
    t8.x = cos(t1.x);
    t1.x = sin(t1.x);
    t17 = t33.x * t7.x;
    t33.x = t33.x * t6.x;
    t35.xy = t1.wx * vec2(t17);
    t51 = t33.x * t8.x + (-t35.y);
    t6.x = t17 * t51 + t1.x;
    t22 = t8.x * t17;
    t22 = t33.x * t1.x + t22;
    t17 = t17 * t22 + (-t8.x);
    t17 = t48 * t17;
    t7.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t7.xyz;
    t24.xyz = vec3(t17) * t7.xyz;
    t9.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t9.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t9.xyz;
    t9.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t9.xyz;
    t9.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t9.xyz;
    t6.xzw = t9.xyz * t6.xxx + t24.xyz;
    t24.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t24.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t24.xyz;
    t24.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t24.xyz;
    t24.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t24.xyz;
    t6.xzw = t24.xyz * t35.xxx + t6.xzw;
    t10.y = t6.w;
    t17 = t33.x * t51 + (-t8.x);
    t1.x = t33.x * t22 + (-t1.x);
    t33.x = t1.w * t33.x;
    t35.x = t1.w * t22;
    t49 = t1.w * t51;
    t11.xyz = t35.xxx * t7.xyz;
    t11.xyz = t9.xyz * vec3(t49) + t11.xyz;
    t11.xyz = t24.xyz * vec3(t50) + t11.xyz;
    t12.xyz = t1.xxx * t7.xyz;
    t1.xw = t0.yy * t7.xy;
    t0.xy = t9.xy * t0.xx + t1.xw;
    t0.xy = t24.xy * t0.zz + t0.xy;
    t32.x = t48 * t17;
    t1.xyw = t9.xyz * t32.xxx + t12.xyz;
    t1.xyz = t24.xyz * t33.xxx + t1.xyw;
    t10.x = t1.z;
    t10.z = t11.z;
    t32.x = dot(t10.xyz, t10.xyz);
    t32.x = inversesqrt(t32.x);
    t7.xyz = t32.xxx * t10.xyz;
    t5.xyz = abs(t7.xyz);
    vs_TEXCOORD0 = t5;
    t32.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t32.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t32.xy;
    t32.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t32.xy;
    t32.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t32.xy;
    t0.xy = t32.xy + t0.xy;
    ti5.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t7.xyzx)).xyz) * 0xFFFFFFFFu);
    ti8.xyz = ivec3(uvec3(lessThan((-t7.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti5.xyz = (-ti5.xyz) + ti8.xyz;
    t32.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti33 = int((0.0<t32.y) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t32.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti33 = (-ti33) + ti49;
    ti8.xyz = ivec3(ti33) * ti5.xyz;
    t8.xyz = vec3(ti8.xyz);
    t8.xyz = vec3(t7.y * t8.x, t7.z * t8.y, t7.y * t8.z);
    t33.xy = vec2(ti5.xy);
    t33.xy = t32.xx * t33.xy;
    ti35.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t33.xyxy).xy) * 0xFFFFFFFFu);
    ti22.xz = ivec2(uvec2(lessThan(t33.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti35.xy = (-ti35.xy) + ti22.xz;
    ti35.xy = ti35.xy * ti5.xy;
    t35.xy = vec2(ti35.xy);
    t35.xy = t35.xy * t7.zx + t8.xy;
    t5.xy = t35.yy * t6.xz;
    t6.xy = t32.yy * t6.xz;
    t35.xy = t1.xy * t35.xx + t6.xy;
    t35.xy = t11.xy * t33.xx + t35.xy;
    t33.xy = t1.xy * t33.yy + t5.xy;
    t33.xy = t11.xy * t32.yy + t33.xy;
    t33.xy = t0.xy * in_POSITION0.ww + t33.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD2.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t33.xy = t0.xy * in_POSITION0.ww + t35.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD1.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti48 = int((0.0<t7.z) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t7.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti48 = (-ti48) + ti33;
    t48 = float(ti48);
    t32.x = t48 * t32.x;
    ti48 = int((0.0<t32.x) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t32.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t32.xx + t6.xy;
    ti32 = (-ti48) + ti33;
    ti32 = ti32 * ti5.z;
    t32.x = float(ti32);
    t32.x = t32.x * t7.x + t8.z;
    t32.xy = t11.xy * t32.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t32.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t48 = dot(t3.xyz, t3.xyz);
    t48 = inversesqrt(t48);
    t5.xyz = vec3(t48) * t3.yzx;
    t6.xyz = t0.zxy * t5.xyz;
    t5.xyz = t0.yzx * t5.yzx + (-t6.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t5.xyz), t2.xyz);
    t0.y = dot((-t5.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t48 = dot(t1.xyz, t1.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD7.xyz = vec3(t48) * t1.xyz;
    t48 = dot(t0.xyz, t0.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD8.xyz = vec3(t48) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _Tex;
in lowp vec4 vs_COLOR0;
in mediump vec4 vs_TEXCOORD0;
in highp vec2 vs_TEXCOORD1;
in highp vec2 vs_TEXCOORD2;
in highp vec2 vs_TEXCOORD3;
in highp vec2 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD7;
in highp vec3 vs_TEXCOORD8;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
mediump vec3 t16_1;
highp vec3 t2;
lowp vec4 t10_2;
highp vec3 t3;
mediump vec3 t16_4;
mediump vec3 t16_5;
highp vec2 t6;
mediump vec3 t16_7;
mediump float t16_13;
mediump float t16_14;
mediump float t16_19;
mediump float t16_22;
void main()
{
    t0.x = texture(_Tex, vs_TEXCOORD1.xy).x;
    t0.y = texture(_Tex, vs_TEXCOORD2.xy).y;
    t0.z = texture(_Tex, vs_TEXCOORD3.xy).z;
    t16_1.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t16_19 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t16_19 = t16_19 + vs_TEXCOORD0.z;
    t16_1.xyz = t16_1.xyz / vec3(t16_19);
    t16_1.x = t16_1.y + t16_1.x;
    t16_1.x = t16_1.z + t16_1.x;
    t16_7.x = t16_1.x * vs_TEXCOORD0.w;
    t0.x = (-_Opacity) * t16_7.x + _MinScatter;
    t2.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t3.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t6.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t16_7.x = dot(t6.xy, t6.xy);
    t16_7.x = min(t16_7.x, 1.0);
    t16_7.x = (-t16_7.x) + 1.0;
    t16_14 = sqrt(t16_7.x);
    t2.z = t16_14;
    t3.z = t2.z;
    t16_7.x = dot(t2.xyz, t3.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_4.xy = t6.xy * t16_7.xx;
    t16_4.z = t16_7.x * t2.z;
    t16_7.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_7.xyz = t16_7.xxx * vs_TEXCOORD7.xyz;
    t16_22 = dot(t16_4.xyz, t16_7.xyz);
    t16_22 = (-t16_22) + 1.0;
    t0.x = t0.x * t16_22;
    t16_22 = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_5.xyz = vec3(t16_22) * vs_TEXCOORD8.xyz;
    t16_7.x = dot(t16_7.xyz, t16_5.xyz);
    t16_13 = dot(t16_4.xyz, t16_5.xyz);
    t16_13 = max(t16_13, 0.0);
    t16_7.x = t16_7.x * 0.5 + 0.5;
    t0.x = t0.x * t16_7.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + t16_13;
    t0.xyz = t0.xxx * _LightColor0.xyz;
    t0.xyz = t0.xyz + t0.xyz;
    t10_2 = vs_COLOR0 * _Color;
    t16_0.xyz = t0.xyz * t10_2.xyz;
    t16_0.w = t16_1.x * t10_2.w;
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 642 math, 2 textures, 48 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "texcoord" ATTR1
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 528
Matrix 32 [glstate_matrix_modelview0]
Matrix 96 [_Object2World]
Matrix 160 [glstate_matrix_projection]
Matrix 224 [unity_MatrixV]
Matrix 288 [_MainRotation]
Matrix 352 [_DetailRotation]
Matrix 416 [_PosRotation]
Vector 0 [_WorldSpaceCameraPos] 3
VectorHalf 16 [_WorldSpaceLightPos0] 4
Float 480 [_DistFade]
Float 484 [_DistFadeVert]
Float 488 [_Rotation]
Float 492 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesMultiTexCoord0 [[attribute(1)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  half4 xlv_COLOR;
  half4 xlv_TEXCOORD0;
  float2 xlv_TEXCOORD1;
  float2 xlv_TEXCOORD2;
  float2 xlv_TEXCOORD3;
  float2 xlv_TEXCOORD4;
  float4 xlv_TEXCOORD5;
  float3 xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
  float3 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  half4 _WorldSpaceLightPos0;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 glstate_matrix_projection;
  float4x4 unity_MatrixV;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4x4 _PosRotation;
  float _DistFade;
  float _DistFadeVert;
  float _Rotation;
  float _MaxScale;
  float4 _NoiseScale;
  float3 _MaxTrans;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> _MainTex [[texture(0)]], sampler _mtlsmp__MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]])
{
  xlatMtlShaderOutput _mtl_o;
  float2 tmpvar_1;
  tmpvar_1 = _mtl_i._glesMultiTexCoord0.xy;
  half3 normal_2;
  float4 XYv_3;
  float4 XZv_4;
  float4 ZYv_5;
  float4 localOrigin_6;
  float4 planet_pos_7;
  float4 origin_8;
  half4 tmpvar_9;
  half4 tmpvar_10;
  float4 tmpvar_11;
  float3 tmpvar_12;
  float4 tmpvar_13;
  tmpvar_13 = (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0));
  origin_8 = tmpvar_13;
  float4 tmpvar_14;
  tmpvar_14 = (_mtl_u._PosRotation * tmpvar_13);
  planet_pos_7 = tmpvar_14;
  float3 tmpvar_15;
  tmpvar_15 = (_mtl_u._NoiseScale.z * tmpvar_14.xyz);
  float tmpvar_16;
  float4 m_17;
  float3 tmpvar_18;
  tmpvar_18 = floor((tmpvar_15 + dot (tmpvar_15, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_19;
  tmpvar_19 = ((tmpvar_15 - tmpvar_18) + dot (tmpvar_18, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_20;
  tmpvar_20.x = float((tmpvar_19.x >= tmpvar_19.y));
  tmpvar_20.y = float((tmpvar_19.y >= tmpvar_19.z));
  tmpvar_20.z = float((tmpvar_19.z >= tmpvar_19.x));
  float3 tmpvar_21;
  tmpvar_21 = (1.0 - tmpvar_20);
  float3 tmpvar_22;
  tmpvar_22 = min (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_23;
  tmpvar_23 = max (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_24;
  tmpvar_24 = ((tmpvar_19 - tmpvar_22) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_25;
  tmpvar_25 = ((tmpvar_19 - tmpvar_23) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_26;
  tmpvar_26 = (tmpvar_19 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_27;
  tmpvar_27 = (tmpvar_18 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_28;
  tmpvar_28 = (fract(abs(tmpvar_27)) * float3(289.0, 289.0, 289.0));
  float tmpvar_29;
  if ((tmpvar_27.x >= 0.0)) {
    tmpvar_29 = tmpvar_28.x;
  } else {
    tmpvar_29 = -(tmpvar_28.x);
  };
  float tmpvar_30;
  if ((tmpvar_27.y >= 0.0)) {
    tmpvar_30 = tmpvar_28.y;
  } else {
    tmpvar_30 = -(tmpvar_28.y);
  };
  float tmpvar_31;
  if ((tmpvar_27.z >= 0.0)) {
    tmpvar_31 = tmpvar_28.z;
  } else {
    tmpvar_31 = -(tmpvar_28.z);
  };
  float4 tmpvar_32;
  tmpvar_32.xw = float2(0.0, 1.0);
  tmpvar_32.y = tmpvar_22.z;
  tmpvar_32.z = tmpvar_23.z;
  float4 x_33;
  x_33 = (tmpvar_31 + tmpvar_32);
  float4 tmpvar_34;
  tmpvar_34 = (((
    (x_33 * x_33)
   * 34.0) + x_33) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_35;
  tmpvar_35 = (fract(abs(tmpvar_34)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_36;
  if ((tmpvar_34.x >= 0.0)) {
    tmpvar_36 = tmpvar_35.x;
  } else {
    tmpvar_36 = -(tmpvar_35.x);
  };
  float tmpvar_37;
  if ((tmpvar_34.y >= 0.0)) {
    tmpvar_37 = tmpvar_35.y;
  } else {
    tmpvar_37 = -(tmpvar_35.y);
  };
  float tmpvar_38;
  if ((tmpvar_34.z >= 0.0)) {
    tmpvar_38 = tmpvar_35.z;
  } else {
    tmpvar_38 = -(tmpvar_35.z);
  };
  float tmpvar_39;
  if ((tmpvar_34.w >= 0.0)) {
    tmpvar_39 = tmpvar_35.w;
  } else {
    tmpvar_39 = -(tmpvar_35.w);
  };
  float4 tmpvar_40;
  tmpvar_40.x = tmpvar_36;
  tmpvar_40.y = tmpvar_37;
  tmpvar_40.z = tmpvar_38;
  tmpvar_40.w = tmpvar_39;
  float4 tmpvar_41;
  tmpvar_41.xw = float2(0.0, 1.0);
  tmpvar_41.y = tmpvar_22.y;
  tmpvar_41.z = tmpvar_23.y;
  float4 x_42;
  x_42 = ((tmpvar_40 + tmpvar_30) + tmpvar_41);
  float4 tmpvar_43;
  tmpvar_43 = (((
    (x_42 * x_42)
   * 34.0) + x_42) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_44;
  tmpvar_44 = (fract(abs(tmpvar_43)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_45;
  if ((tmpvar_43.x >= 0.0)) {
    tmpvar_45 = tmpvar_44.x;
  } else {
    tmpvar_45 = -(tmpvar_44.x);
  };
  float tmpvar_46;
  if ((tmpvar_43.y >= 0.0)) {
    tmpvar_46 = tmpvar_44.y;
  } else {
    tmpvar_46 = -(tmpvar_44.y);
  };
  float tmpvar_47;
  if ((tmpvar_43.z >= 0.0)) {
    tmpvar_47 = tmpvar_44.z;
  } else {
    tmpvar_47 = -(tmpvar_44.z);
  };
  float tmpvar_48;
  if ((tmpvar_43.w >= 0.0)) {
    tmpvar_48 = tmpvar_44.w;
  } else {
    tmpvar_48 = -(tmpvar_44.w);
  };
  float4 tmpvar_49;
  tmpvar_49.x = tmpvar_45;
  tmpvar_49.y = tmpvar_46;
  tmpvar_49.z = tmpvar_47;
  tmpvar_49.w = tmpvar_48;
  float4 tmpvar_50;
  tmpvar_50.xw = float2(0.0, 1.0);
  tmpvar_50.y = tmpvar_22.x;
  tmpvar_50.z = tmpvar_23.x;
  float4 x_51;
  x_51 = ((tmpvar_49 + tmpvar_29) + tmpvar_50);
  float4 tmpvar_52;
  tmpvar_52 = (((
    (x_51 * x_51)
   * 34.0) + x_51) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_53;
  tmpvar_53 = (fract(abs(tmpvar_52)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_54;
  if ((tmpvar_52.x >= 0.0)) {
    tmpvar_54 = tmpvar_53.x;
  } else {
    tmpvar_54 = -(tmpvar_53.x);
  };
  float tmpvar_55;
  if ((tmpvar_52.y >= 0.0)) {
    tmpvar_55 = tmpvar_53.y;
  } else {
    tmpvar_55 = -(tmpvar_53.y);
  };
  float tmpvar_56;
  if ((tmpvar_52.z >= 0.0)) {
    tmpvar_56 = tmpvar_53.z;
  } else {
    tmpvar_56 = -(tmpvar_53.z);
  };
  float tmpvar_57;
  if ((tmpvar_52.w >= 0.0)) {
    tmpvar_57 = tmpvar_53.w;
  } else {
    tmpvar_57 = -(tmpvar_53.w);
  };
  float4 tmpvar_58;
  tmpvar_58.x = tmpvar_54;
  tmpvar_58.y = tmpvar_55;
  tmpvar_58.z = tmpvar_56;
  tmpvar_58.w = tmpvar_57;
  float4 tmpvar_59;
  tmpvar_59 = (tmpvar_58 - (49.0 * floor(
    (0.02040815 * tmpvar_58)
  )));
  float4 tmpvar_60;
  tmpvar_60 = floor((tmpvar_59 * 0.1428571));
  float4 tmpvar_61;
  tmpvar_61 = ((tmpvar_60 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_62;
  tmpvar_62 = ((floor(
    (tmpvar_59 - (7.0 * tmpvar_60))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_63;
  tmpvar_63 = ((1.0 - abs(tmpvar_61)) - abs(tmpvar_62));
  float4 tmpvar_64;
  tmpvar_64.xy = tmpvar_61.xy;
  tmpvar_64.zw = tmpvar_62.xy;
  float4 tmpvar_65;
  tmpvar_65.xy = tmpvar_61.zw;
  tmpvar_65.zw = tmpvar_62.zw;
  float4 tmpvar_66;
  tmpvar_66 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_63)));
  float4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_66.xxyy));
  float4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_66.zzww));
  float3 tmpvar_69;
  tmpvar_69.xy = tmpvar_67.xy;
  tmpvar_69.z = tmpvar_63.x;
  float3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.zw;
  tmpvar_70.z = tmpvar_63.y;
  float3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.xy;
  tmpvar_71.z = tmpvar_63.z;
  float3 tmpvar_72;
  tmpvar_72.xy = tmpvar_68.zw;
  tmpvar_72.z = tmpvar_63.w;
  float4 tmpvar_73;
  tmpvar_73.x = dot (tmpvar_69, tmpvar_69);
  tmpvar_73.y = dot (tmpvar_70, tmpvar_70);
  tmpvar_73.z = dot (tmpvar_71, tmpvar_71);
  tmpvar_73.w = dot (tmpvar_72, tmpvar_72);
  float4 tmpvar_74;
  tmpvar_74 = (1.792843 - (0.8537347 * tmpvar_73));
  float4 tmpvar_75;
  tmpvar_75.x = dot (tmpvar_19, tmpvar_19);
  tmpvar_75.y = dot (tmpvar_24, tmpvar_24);
  tmpvar_75.z = dot (tmpvar_25, tmpvar_25);
  tmpvar_75.w = dot (tmpvar_26, tmpvar_26);
  float4 tmpvar_76;
  tmpvar_76 = max ((0.6 - tmpvar_75), float4(0.0, 0.0, 0.0, 0.0));
  m_17 = (tmpvar_76 * tmpvar_76);
  float4 tmpvar_77;
  tmpvar_77.x = dot ((tmpvar_69 * tmpvar_74.x), tmpvar_19);
  tmpvar_77.y = dot ((tmpvar_70 * tmpvar_74.y), tmpvar_24);
  tmpvar_77.z = dot ((tmpvar_71 * tmpvar_74.z), tmpvar_25);
  tmpvar_77.w = dot ((tmpvar_72 * tmpvar_74.w), tmpvar_26);
  tmpvar_16 = (42.0 * dot ((m_17 * m_17), tmpvar_77));
  float tmpvar_78;
  float3 v_79;
  v_79 = (_mtl_u._NoiseScale.x * tmpvar_15);
  float4 m_80;
  float3 tmpvar_81;
  tmpvar_81 = floor((v_79 + dot (v_79, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_82;
  tmpvar_82 = ((v_79 - tmpvar_81) + dot (tmpvar_81, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_83;
  tmpvar_83.x = float((tmpvar_82.x >= tmpvar_82.y));
  tmpvar_83.y = float((tmpvar_82.y >= tmpvar_82.z));
  tmpvar_83.z = float((tmpvar_82.z >= tmpvar_82.x));
  float3 tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_83);
  float3 tmpvar_85;
  tmpvar_85 = min (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_86;
  tmpvar_86 = max (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_87;
  tmpvar_87 = ((tmpvar_82 - tmpvar_85) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_88;
  tmpvar_88 = ((tmpvar_82 - tmpvar_86) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_89;
  tmpvar_89 = (tmpvar_82 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_90;
  tmpvar_90 = (tmpvar_81 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_91;
  tmpvar_91 = (fract(abs(tmpvar_90)) * float3(289.0, 289.0, 289.0));
  float tmpvar_92;
  if ((tmpvar_90.x >= 0.0)) {
    tmpvar_92 = tmpvar_91.x;
  } else {
    tmpvar_92 = -(tmpvar_91.x);
  };
  float tmpvar_93;
  if ((tmpvar_90.y >= 0.0)) {
    tmpvar_93 = tmpvar_91.y;
  } else {
    tmpvar_93 = -(tmpvar_91.y);
  };
  float tmpvar_94;
  if ((tmpvar_90.z >= 0.0)) {
    tmpvar_94 = tmpvar_91.z;
  } else {
    tmpvar_94 = -(tmpvar_91.z);
  };
  float4 tmpvar_95;
  tmpvar_95.xw = float2(0.0, 1.0);
  tmpvar_95.y = tmpvar_85.z;
  tmpvar_95.z = tmpvar_86.z;
  float4 x_96;
  x_96 = (tmpvar_94 + tmpvar_95);
  float4 tmpvar_97;
  tmpvar_97 = (((
    (x_96 * x_96)
   * 34.0) + x_96) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_98;
  tmpvar_98 = (fract(abs(tmpvar_97)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_99;
  if ((tmpvar_97.x >= 0.0)) {
    tmpvar_99 = tmpvar_98.x;
  } else {
    tmpvar_99 = -(tmpvar_98.x);
  };
  float tmpvar_100;
  if ((tmpvar_97.y >= 0.0)) {
    tmpvar_100 = tmpvar_98.y;
  } else {
    tmpvar_100 = -(tmpvar_98.y);
  };
  float tmpvar_101;
  if ((tmpvar_97.z >= 0.0)) {
    tmpvar_101 = tmpvar_98.z;
  } else {
    tmpvar_101 = -(tmpvar_98.z);
  };
  float tmpvar_102;
  if ((tmpvar_97.w >= 0.0)) {
    tmpvar_102 = tmpvar_98.w;
  } else {
    tmpvar_102 = -(tmpvar_98.w);
  };
  float4 tmpvar_103;
  tmpvar_103.x = tmpvar_99;
  tmpvar_103.y = tmpvar_100;
  tmpvar_103.z = tmpvar_101;
  tmpvar_103.w = tmpvar_102;
  float4 tmpvar_104;
  tmpvar_104.xw = float2(0.0, 1.0);
  tmpvar_104.y = tmpvar_85.y;
  tmpvar_104.z = tmpvar_86.y;
  float4 x_105;
  x_105 = ((tmpvar_103 + tmpvar_93) + tmpvar_104);
  float4 tmpvar_106;
  tmpvar_106 = (((
    (x_105 * x_105)
   * 34.0) + x_105) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_107;
  tmpvar_107 = (fract(abs(tmpvar_106)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_108;
  if ((tmpvar_106.x >= 0.0)) {
    tmpvar_108 = tmpvar_107.x;
  } else {
    tmpvar_108 = -(tmpvar_107.x);
  };
  float tmpvar_109;
  if ((tmpvar_106.y >= 0.0)) {
    tmpvar_109 = tmpvar_107.y;
  } else {
    tmpvar_109 = -(tmpvar_107.y);
  };
  float tmpvar_110;
  if ((tmpvar_106.z >= 0.0)) {
    tmpvar_110 = tmpvar_107.z;
  } else {
    tmpvar_110 = -(tmpvar_107.z);
  };
  float tmpvar_111;
  if ((tmpvar_106.w >= 0.0)) {
    tmpvar_111 = tmpvar_107.w;
  } else {
    tmpvar_111 = -(tmpvar_107.w);
  };
  float4 tmpvar_112;
  tmpvar_112.x = tmpvar_108;
  tmpvar_112.y = tmpvar_109;
  tmpvar_112.z = tmpvar_110;
  tmpvar_112.w = tmpvar_111;
  float4 tmpvar_113;
  tmpvar_113.xw = float2(0.0, 1.0);
  tmpvar_113.y = tmpvar_85.x;
  tmpvar_113.z = tmpvar_86.x;
  float4 x_114;
  x_114 = ((tmpvar_112 + tmpvar_92) + tmpvar_113);
  float4 tmpvar_115;
  tmpvar_115 = (((
    (x_114 * x_114)
   * 34.0) + x_114) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_116;
  tmpvar_116 = (fract(abs(tmpvar_115)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_117;
  if ((tmpvar_115.x >= 0.0)) {
    tmpvar_117 = tmpvar_116.x;
  } else {
    tmpvar_117 = -(tmpvar_116.x);
  };
  float tmpvar_118;
  if ((tmpvar_115.y >= 0.0)) {
    tmpvar_118 = tmpvar_116.y;
  } else {
    tmpvar_118 = -(tmpvar_116.y);
  };
  float tmpvar_119;
  if ((tmpvar_115.z >= 0.0)) {
    tmpvar_119 = tmpvar_116.z;
  } else {
    tmpvar_119 = -(tmpvar_116.z);
  };
  float tmpvar_120;
  if ((tmpvar_115.w >= 0.0)) {
    tmpvar_120 = tmpvar_116.w;
  } else {
    tmpvar_120 = -(tmpvar_116.w);
  };
  float4 tmpvar_121;
  tmpvar_121.x = tmpvar_117;
  tmpvar_121.y = tmpvar_118;
  tmpvar_121.z = tmpvar_119;
  tmpvar_121.w = tmpvar_120;
  float4 tmpvar_122;
  tmpvar_122 = (tmpvar_121 - (49.0 * floor(
    (0.02040815 * tmpvar_121)
  )));
  float4 tmpvar_123;
  tmpvar_123 = floor((tmpvar_122 * 0.1428571));
  float4 tmpvar_124;
  tmpvar_124 = ((tmpvar_123 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_125;
  tmpvar_125 = ((floor(
    (tmpvar_122 - (7.0 * tmpvar_123))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_126;
  tmpvar_126 = ((1.0 - abs(tmpvar_124)) - abs(tmpvar_125));
  float4 tmpvar_127;
  tmpvar_127.xy = tmpvar_124.xy;
  tmpvar_127.zw = tmpvar_125.xy;
  float4 tmpvar_128;
  tmpvar_128.xy = tmpvar_124.zw;
  tmpvar_128.zw = tmpvar_125.zw;
  float4 tmpvar_129;
  tmpvar_129 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_126)));
  float4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_129.xxyy));
  float4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_129.zzww));
  float3 tmpvar_132;
  tmpvar_132.xy = tmpvar_130.xy;
  tmpvar_132.z = tmpvar_126.x;
  float3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.zw;
  tmpvar_133.z = tmpvar_126.y;
  float3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.xy;
  tmpvar_134.z = tmpvar_126.z;
  float3 tmpvar_135;
  tmpvar_135.xy = tmpvar_131.zw;
  tmpvar_135.z = tmpvar_126.w;
  float4 tmpvar_136;
  tmpvar_136.x = dot (tmpvar_132, tmpvar_132);
  tmpvar_136.y = dot (tmpvar_133, tmpvar_133);
  tmpvar_136.z = dot (tmpvar_134, tmpvar_134);
  tmpvar_136.w = dot (tmpvar_135, tmpvar_135);
  float4 tmpvar_137;
  tmpvar_137 = (1.792843 - (0.8537347 * tmpvar_136));
  float4 tmpvar_138;
  tmpvar_138.x = dot (tmpvar_82, tmpvar_82);
  tmpvar_138.y = dot (tmpvar_87, tmpvar_87);
  tmpvar_138.z = dot (tmpvar_88, tmpvar_88);
  tmpvar_138.w = dot (tmpvar_89, tmpvar_89);
  float4 tmpvar_139;
  tmpvar_139 = max ((0.6 - tmpvar_138), float4(0.0, 0.0, 0.0, 0.0));
  m_80 = (tmpvar_139 * tmpvar_139);
  float4 tmpvar_140;
  tmpvar_140.x = dot ((tmpvar_132 * tmpvar_137.x), tmpvar_82);
  tmpvar_140.y = dot ((tmpvar_133 * tmpvar_137.y), tmpvar_87);
  tmpvar_140.z = dot ((tmpvar_134 * tmpvar_137.z), tmpvar_88);
  tmpvar_140.w = dot ((tmpvar_135 * tmpvar_137.w), tmpvar_89);
  tmpvar_78 = (42.0 * dot ((m_80 * m_80), tmpvar_140));
  float3 v_141;
  v_141 = (_mtl_u._NoiseScale.y * tmpvar_15);
  float4 m_142;
  float3 tmpvar_143;
  tmpvar_143 = floor((v_141 + dot (v_141, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_144;
  tmpvar_144 = ((v_141 - tmpvar_143) + dot (tmpvar_143, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_145;
  tmpvar_145.x = float((tmpvar_144.x >= tmpvar_144.y));
  tmpvar_145.y = float((tmpvar_144.y >= tmpvar_144.z));
  tmpvar_145.z = float((tmpvar_144.z >= tmpvar_144.x));
  float3 tmpvar_146;
  tmpvar_146 = (1.0 - tmpvar_145);
  float3 tmpvar_147;
  tmpvar_147 = min (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_148;
  tmpvar_148 = max (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_149;
  tmpvar_149 = ((tmpvar_144 - tmpvar_147) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_150;
  tmpvar_150 = ((tmpvar_144 - tmpvar_148) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_151;
  tmpvar_151 = (tmpvar_144 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_152;
  tmpvar_152 = (tmpvar_143 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_153;
  tmpvar_153 = (fract(abs(tmpvar_152)) * float3(289.0, 289.0, 289.0));
  float tmpvar_154;
  if ((tmpvar_152.x >= 0.0)) {
    tmpvar_154 = tmpvar_153.x;
  } else {
    tmpvar_154 = -(tmpvar_153.x);
  };
  float tmpvar_155;
  if ((tmpvar_152.y >= 0.0)) {
    tmpvar_155 = tmpvar_153.y;
  } else {
    tmpvar_155 = -(tmpvar_153.y);
  };
  float tmpvar_156;
  if ((tmpvar_152.z >= 0.0)) {
    tmpvar_156 = tmpvar_153.z;
  } else {
    tmpvar_156 = -(tmpvar_153.z);
  };
  float4 tmpvar_157;
  tmpvar_157.xw = float2(0.0, 1.0);
  tmpvar_157.y = tmpvar_147.z;
  tmpvar_157.z = tmpvar_148.z;
  float4 x_158;
  x_158 = (tmpvar_156 + tmpvar_157);
  float4 tmpvar_159;
  tmpvar_159 = (((
    (x_158 * x_158)
   * 34.0) + x_158) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_160;
  tmpvar_160 = (fract(abs(tmpvar_159)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_161;
  if ((tmpvar_159.x >= 0.0)) {
    tmpvar_161 = tmpvar_160.x;
  } else {
    tmpvar_161 = -(tmpvar_160.x);
  };
  float tmpvar_162;
  if ((tmpvar_159.y >= 0.0)) {
    tmpvar_162 = tmpvar_160.y;
  } else {
    tmpvar_162 = -(tmpvar_160.y);
  };
  float tmpvar_163;
  if ((tmpvar_159.z >= 0.0)) {
    tmpvar_163 = tmpvar_160.z;
  } else {
    tmpvar_163 = -(tmpvar_160.z);
  };
  float tmpvar_164;
  if ((tmpvar_159.w >= 0.0)) {
    tmpvar_164 = tmpvar_160.w;
  } else {
    tmpvar_164 = -(tmpvar_160.w);
  };
  float4 tmpvar_165;
  tmpvar_165.x = tmpvar_161;
  tmpvar_165.y = tmpvar_162;
  tmpvar_165.z = tmpvar_163;
  tmpvar_165.w = tmpvar_164;
  float4 tmpvar_166;
  tmpvar_166.xw = float2(0.0, 1.0);
  tmpvar_166.y = tmpvar_147.y;
  tmpvar_166.z = tmpvar_148.y;
  float4 x_167;
  x_167 = ((tmpvar_165 + tmpvar_155) + tmpvar_166);
  float4 tmpvar_168;
  tmpvar_168 = (((
    (x_167 * x_167)
   * 34.0) + x_167) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_169;
  tmpvar_169 = (fract(abs(tmpvar_168)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_170;
  if ((tmpvar_168.x >= 0.0)) {
    tmpvar_170 = tmpvar_169.x;
  } else {
    tmpvar_170 = -(tmpvar_169.x);
  };
  float tmpvar_171;
  if ((tmpvar_168.y >= 0.0)) {
    tmpvar_171 = tmpvar_169.y;
  } else {
    tmpvar_171 = -(tmpvar_169.y);
  };
  float tmpvar_172;
  if ((tmpvar_168.z >= 0.0)) {
    tmpvar_172 = tmpvar_169.z;
  } else {
    tmpvar_172 = -(tmpvar_169.z);
  };
  float tmpvar_173;
  if ((tmpvar_168.w >= 0.0)) {
    tmpvar_173 = tmpvar_169.w;
  } else {
    tmpvar_173 = -(tmpvar_169.w);
  };
  float4 tmpvar_174;
  tmpvar_174.x = tmpvar_170;
  tmpvar_174.y = tmpvar_171;
  tmpvar_174.z = tmpvar_172;
  tmpvar_174.w = tmpvar_173;
  float4 tmpvar_175;
  tmpvar_175.xw = float2(0.0, 1.0);
  tmpvar_175.y = tmpvar_147.x;
  tmpvar_175.z = tmpvar_148.x;
  float4 x_176;
  x_176 = ((tmpvar_174 + tmpvar_154) + tmpvar_175);
  float4 tmpvar_177;
  tmpvar_177 = (((
    (x_176 * x_176)
   * 34.0) + x_176) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_178;
  tmpvar_178 = (fract(abs(tmpvar_177)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_179;
  if ((tmpvar_177.x >= 0.0)) {
    tmpvar_179 = tmpvar_178.x;
  } else {
    tmpvar_179 = -(tmpvar_178.x);
  };
  float tmpvar_180;
  if ((tmpvar_177.y >= 0.0)) {
    tmpvar_180 = tmpvar_178.y;
  } else {
    tmpvar_180 = -(tmpvar_178.y);
  };
  float tmpvar_181;
  if ((tmpvar_177.z >= 0.0)) {
    tmpvar_181 = tmpvar_178.z;
  } else {
    tmpvar_181 = -(tmpvar_178.z);
  };
  float tmpvar_182;
  if ((tmpvar_177.w >= 0.0)) {
    tmpvar_182 = tmpvar_178.w;
  } else {
    tmpvar_182 = -(tmpvar_178.w);
  };
  float4 tmpvar_183;
  tmpvar_183.x = tmpvar_179;
  tmpvar_183.y = tmpvar_180;
  tmpvar_183.z = tmpvar_181;
  tmpvar_183.w = tmpvar_182;
  float4 tmpvar_184;
  tmpvar_184 = (tmpvar_183 - (49.0 * floor(
    (0.02040815 * tmpvar_183)
  )));
  float4 tmpvar_185;
  tmpvar_185 = floor((tmpvar_184 * 0.1428571));
  float4 tmpvar_186;
  tmpvar_186 = ((tmpvar_185 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_187;
  tmpvar_187 = ((floor(
    (tmpvar_184 - (7.0 * tmpvar_185))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_188;
  tmpvar_188 = ((1.0 - abs(tmpvar_186)) - abs(tmpvar_187));
  float4 tmpvar_189;
  tmpvar_189.xy = tmpvar_186.xy;
  tmpvar_189.zw = tmpvar_187.xy;
  float4 tmpvar_190;
  tmpvar_190.xy = tmpvar_186.zw;
  tmpvar_190.zw = tmpvar_187.zw;
  float4 tmpvar_191;
  tmpvar_191 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_188)));
  float4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_191.xxyy));
  float4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_191.zzww));
  float3 tmpvar_194;
  tmpvar_194.xy = tmpvar_192.xy;
  tmpvar_194.z = tmpvar_188.x;
  float3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.zw;
  tmpvar_195.z = tmpvar_188.y;
  float3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.xy;
  tmpvar_196.z = tmpvar_188.z;
  float3 tmpvar_197;
  tmpvar_197.xy = tmpvar_193.zw;
  tmpvar_197.z = tmpvar_188.w;
  float4 tmpvar_198;
  tmpvar_198.x = dot (tmpvar_194, tmpvar_194);
  tmpvar_198.y = dot (tmpvar_195, tmpvar_195);
  tmpvar_198.z = dot (tmpvar_196, tmpvar_196);
  tmpvar_198.w = dot (tmpvar_197, tmpvar_197);
  float4 tmpvar_199;
  tmpvar_199 = (1.792843 - (0.8537347 * tmpvar_198));
  float4 tmpvar_200;
  tmpvar_200.x = dot (tmpvar_144, tmpvar_144);
  tmpvar_200.y = dot (tmpvar_149, tmpvar_149);
  tmpvar_200.z = dot (tmpvar_150, tmpvar_150);
  tmpvar_200.w = dot (tmpvar_151, tmpvar_151);
  float4 tmpvar_201;
  tmpvar_201 = max ((0.6 - tmpvar_200), float4(0.0, 0.0, 0.0, 0.0));
  m_142 = (tmpvar_201 * tmpvar_201);
  float4 tmpvar_202;
  tmpvar_202.x = dot ((tmpvar_194 * tmpvar_199.x), tmpvar_144);
  tmpvar_202.y = dot ((tmpvar_195 * tmpvar_199.y), tmpvar_149);
  tmpvar_202.z = dot ((tmpvar_196 * tmpvar_199.z), tmpvar_150);
  tmpvar_202.w = dot ((tmpvar_197 * tmpvar_199.w), tmpvar_151);
  float3 tmpvar_203;
  tmpvar_203.x = tmpvar_16;
  tmpvar_203.y = tmpvar_78;
  tmpvar_203.z = (42.0 * dot ((m_142 * m_142), tmpvar_202));
  float3 tmpvar_204;
  tmpvar_204 = (0.5 * (tmpvar_203 + 1.0));
  localOrigin_6.xyz = (((2.0 * tmpvar_204) - 1.0) * _mtl_u._MaxTrans);
  localOrigin_6.w = 1.0;
  float tmpvar_205;
  tmpvar_205 = ((tmpvar_204.x * (_mtl_u._MaxScale - 1.0)) + 1.0);
  origin_8 = (_mtl_u._Object2World * localOrigin_6);
  planet_pos_7 = (_mtl_u._MainRotation * origin_8);
  float3 tmpvar_206;
  tmpvar_206 = (_mtl_u._DetailRotation * planet_pos_7).xyz;
  tmpvar_12 = planet_pos_7.xyz;
  float3 tmpvar_207;
  tmpvar_207 = normalize(planet_pos_7.xyz);
  float2 uv_208;
  float tmpvar_209;
  float tmpvar_210;
  tmpvar_210 = (min (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0) / max (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0));
  float tmpvar_211;
  tmpvar_211 = (tmpvar_210 * tmpvar_210);
  tmpvar_211 = (((
    ((((
      ((((-0.01213232 * tmpvar_211) + 0.05368138) * tmpvar_211) - 0.1173503)
     * tmpvar_211) + 0.1938925) * tmpvar_211) - 0.3326756)
   * tmpvar_211) + 0.9999793) * tmpvar_210);
  tmpvar_211 = (tmpvar_211 + (float(
    (abs((tmpvar_207.x / tmpvar_207.z)) > 1.0)
  ) * (
    (tmpvar_211 * -2.0)
   + 1.570796)));
  tmpvar_209 = (tmpvar_211 * sign((tmpvar_207.x / tmpvar_207.z)));
  if ((abs(tmpvar_207.z) > (1e-08 * abs(tmpvar_207.x)))) {
    if ((tmpvar_207.z < 0.0)) {
      if ((tmpvar_207.x >= 0.0)) {
        tmpvar_209 += 3.141593;
      } else {
        tmpvar_209 = (tmpvar_209 - 3.141593);
      };
    };
  } else {
    tmpvar_209 = (sign(tmpvar_207.x) * 1.570796);
  };
  uv_208.x = (0.5 + (0.1591549 * tmpvar_209));
  uv_208.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_207.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_207.y)
    )) * (1.570796 + (
      abs(tmpvar_207.y)
     * 
      (-0.2146018 + (abs(tmpvar_207.y) * (0.08656672 + (
        abs(tmpvar_207.y)
       * -0.03102955))))
    ))))
  )));
  half4 tmpvar_212;
  tmpvar_212 = _MainTex.sample(_mtlsmp__MainTex, (float2)(uv_208), level(0.0));
  half4 tmpvar_213;
  tmpvar_213 = tmpvar_212;
  tmpvar_9 = tmpvar_213;
  half3 detailCoords_214;
  half s_215;
  half nylerp_216;
  half zxlerp_217;
  float4 uv4_218;
  uv4_218.zw = float2(0.0, 0.0);
  float3 tmpvar_219;
  tmpvar_219 = normalize(tmpvar_206);
  float3 tmpvar_220;
  tmpvar_220 = abs(tmpvar_219);
  float tmpvar_221;
  tmpvar_221 = float((tmpvar_220.z >= tmpvar_220.x));
  zxlerp_217 = half(tmpvar_221);
  float tmpvar_222;
  tmpvar_222 = float((max (tmpvar_220.x, tmpvar_220.z) >= tmpvar_220.y));
  nylerp_216 = half(tmpvar_222);
  float tmpvar_223;
  tmpvar_223 = mix (tmpvar_219.x, tmpvar_219.z, (float)zxlerp_217);
  s_215 = half(tmpvar_223);
  float tmpvar_224;
  tmpvar_224 = sign(mix (tmpvar_219.y, (float)s_215, (float)nylerp_216));
  s_215 = half(tmpvar_224);
  half3 tmpvar_225;
  tmpvar_225.xz = half2(float2(1.0, -1.0));
  tmpvar_225.y = -(s_215);
  half3 tmpvar_226;
  tmpvar_226.xz = half2(float2(1.0, -1.0));
  tmpvar_226.y = s_215;
  float3 tmpvar_227;
  tmpvar_227 = mix (((float3)tmpvar_225 * tmpvar_219.xzy), ((float3)tmpvar_226 * tmpvar_219.zxy), (float3)half3(zxlerp_217));
  detailCoords_214 = half3(tmpvar_227);
  half3 tmpvar_228;
  tmpvar_228.xy = half2(float2(1.0, 1.0));
  tmpvar_228.z = s_215;
  float3 tmpvar_229;
  tmpvar_229 = mix (((float3)tmpvar_228 * tmpvar_219.yxz), (float3)detailCoords_214, (float3)half3(nylerp_216));
  detailCoords_214 = half3(tmpvar_229);
  half2 tmpvar_230;
  tmpvar_230 = ((((half)0.5 * detailCoords_214.yz) / abs(detailCoords_214.x)) + (half)0.5);
  uv4_218.xy = float2(tmpvar_230);
  half4 tmpvar_231;
  tmpvar_231 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv4_218.xy), level(0.0));
  half4 tmpvar_232;
  tmpvar_232 = tmpvar_231;
  tmpvar_9 = (tmpvar_9 * tmpvar_232);
  float4 tmpvar_233;
  tmpvar_233.w = 0.0;
  tmpvar_233.xyz = _mtl_u._WorldSpaceCameraPos;
  float tmpvar_234;
  float4 tmpvar_235;
  tmpvar_235 = (origin_8 - tmpvar_233);
  tmpvar_234 = sqrt(dot (tmpvar_235, tmpvar_235));
  float tmpvar_236;
  tmpvar_236 = (clamp ((_mtl_u._DistFade * tmpvar_234), 0.0, 1.0) * clamp ((1.0 - 
    (_mtl_u._DistFadeVert * tmpvar_234)
  ), 0.0, 1.0));
  tmpvar_10.w = half(tmpvar_236);
  tmpvar_9.w = (tmpvar_9.w * tmpvar_10.w);
  float3 tmpvar_237;
  tmpvar_237.yz = float2(0.0, 0.0);
  tmpvar_237.x = fract(_mtl_u._Rotation);
  float3 x_238;
  x_238 = (tmpvar_237 + tmpvar_204);
  float3 trans_239;
  trans_239 = localOrigin_6.xyz;
  float tmpvar_240;
  tmpvar_240 = (x_238.x * 6.283185);
  float tmpvar_241;
  tmpvar_241 = (x_238.y * 6.283185);
  float tmpvar_242;
  tmpvar_242 = (x_238.z * 2.0);
  float tmpvar_243;
  tmpvar_243 = sqrt(tmpvar_242);
  float tmpvar_244;
  tmpvar_244 = (sin(tmpvar_241) * tmpvar_243);
  float tmpvar_245;
  tmpvar_245 = (cos(tmpvar_241) * tmpvar_243);
  float tmpvar_246;
  tmpvar_246 = sqrt((2.0 - tmpvar_242));
  float tmpvar_247;
  tmpvar_247 = sin(tmpvar_240);
  float tmpvar_248;
  tmpvar_248 = cos(tmpvar_240);
  float tmpvar_249;
  tmpvar_249 = ((tmpvar_244 * tmpvar_248) - (tmpvar_245 * tmpvar_247));
  float tmpvar_250;
  tmpvar_250 = ((tmpvar_244 * tmpvar_247) + (tmpvar_245 * tmpvar_248));
  float4x4 tmpvar_251;
  tmpvar_251[0].x = (tmpvar_205 * ((tmpvar_244 * tmpvar_249) - tmpvar_248));
  tmpvar_251[0].y = ((tmpvar_244 * tmpvar_250) - tmpvar_247);
  tmpvar_251[0].z = (tmpvar_244 * tmpvar_246);
  tmpvar_251[0].w = 0.0;
  tmpvar_251[1].x = ((tmpvar_245 * tmpvar_249) + tmpvar_247);
  tmpvar_251[1].y = (tmpvar_205 * ((tmpvar_245 * tmpvar_250) - tmpvar_248));
  tmpvar_251[1].z = (tmpvar_245 * tmpvar_246);
  tmpvar_251[1].w = 0.0;
  tmpvar_251[2].x = (tmpvar_246 * tmpvar_249);
  tmpvar_251[2].y = (tmpvar_246 * tmpvar_250);
  tmpvar_251[2].z = (tmpvar_205 * (1.0 - tmpvar_242));
  tmpvar_251[2].w = 0.0;
  tmpvar_251[3].x = trans_239.x;
  tmpvar_251[3].y = trans_239.y;
  tmpvar_251[3].z = trans_239.z;
  tmpvar_251[3].w = 1.0;
  float4x4 tmpvar_252;
  tmpvar_252 = ((_mtl_u.unity_MatrixV * _mtl_u._Object2World) * tmpvar_251);
  float4 v_253;
  v_253.x = tmpvar_252[0].z;
  v_253.y = tmpvar_252[1].z;
  v_253.z = tmpvar_252[2].z;
  v_253.w = tmpvar_252[3].z;
  float3 tmpvar_254;
  tmpvar_254 = normalize(v_253.xyz);
  float3 tmpvar_255;
  tmpvar_255 = abs(tmpvar_254);
  tmpvar_10.xyz = half3(tmpvar_255);
  float4 tmpvar_256;
  tmpvar_256 = (_mtl_u.glstate_matrix_modelview0 * localOrigin_6);
  float4 tmpvar_257;
  tmpvar_257.xyz = (_mtl_i._glesVertex.xyz * tmpvar_205);
  tmpvar_257.w = _mtl_i._glesVertex.w;
  float2 tmpvar_258;
  tmpvar_258 = ((2.0 * _mtl_i._glesMultiTexCoord0.xy) - 1.0);
  float4 tmpvar_259;
  tmpvar_259.z = 0.0;
  tmpvar_259.xy = tmpvar_258;
  tmpvar_259.w = _mtl_i._glesVertex.w;
  ZYv_5.xyw = tmpvar_259.zyw;
  XZv_4.yzw = tmpvar_259.zyw;
  XYv_3.yzw = tmpvar_259.yzw;
  ZYv_5.z = (tmpvar_258.x * sign(-(tmpvar_254.x)));
  XZv_4.x = (tmpvar_258.x * sign(-(tmpvar_254.y)));
  XYv_3.x = (tmpvar_258.x * sign(tmpvar_254.z));
  ZYv_5.x = ((sign(
    -(tmpvar_254.x)
  ) * sign(ZYv_5.z)) * tmpvar_254.z);
  XZv_4.y = ((sign(
    -(tmpvar_254.y)
  ) * sign(XZv_4.x)) * tmpvar_254.x);
  XYv_3.z = ((sign(
    -(tmpvar_254.z)
  ) * sign(XYv_3.x)) * tmpvar_254.x);
  ZYv_5.x = (ZYv_5.x + ((
    sign(-(tmpvar_254.x))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  XZv_4.y = (XZv_4.y + ((
    sign(-(tmpvar_254.y))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.z));
  XYv_3.z = (XYv_3.z + ((
    sign(-(tmpvar_254.z))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  float3 tmpvar_260;
  tmpvar_260 = normalize((origin_8.xyz - _mtl_u._WorldSpaceCameraPos));
  float3 tmpvar_261;
  tmpvar_261 = normalize(-(tmpvar_260));
  normal_2 = half3(tmpvar_261);
  float4 v_262;
  v_262.x = _mtl_u.unity_MatrixV[0].x;
  v_262.y = _mtl_u.unity_MatrixV[1].x;
  v_262.z = _mtl_u.unity_MatrixV[2].x;
  v_262.w = _mtl_u.unity_MatrixV[3].x;
  float3 tmpvar_263;
  tmpvar_263 = normalize(v_262.xyz);
  float3 tmpvar_264;
  float3 tmpvar_265;
  tmpvar_264 = v_262.xyz;
  tmpvar_265 = (((float3)normal_2.zxy * tmpvar_263.yzx) - ((float3)normal_2.yzx * tmpvar_263.zxy));
  float3 tmpvar_266;
  tmpvar_266 = float3(normal_2);
  float3x3 tmpvar_267;
  tmpvar_267[0].x = tmpvar_264.x;
  tmpvar_267[0].y = tmpvar_265.x;
  tmpvar_267[0].z = tmpvar_266.x;
  tmpvar_267[1].x = tmpvar_264.y;
  tmpvar_267[1].y = tmpvar_265.y;
  tmpvar_267[1].z = tmpvar_266.y;
  tmpvar_267[2].x = tmpvar_264.z;
  tmpvar_267[2].y = tmpvar_265.z;
  tmpvar_267[2].z = tmpvar_266.z;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_projection * (tmpvar_256 + tmpvar_257));
  _mtl_o.xlv_COLOR = tmpvar_9;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_10;
  _mtl_o.xlv_TEXCOORD1 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * ZYv_5)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD2 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XZv_4)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD3 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XYv_3)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD4 = tmpvar_1;
  _mtl_o.xlv_TEXCOORD5 = tmpvar_11;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_12;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_267 * tmpvar_260));
  _mtl_o.xlv_TEXCOORD8 = normalize((tmpvar_267 * (float3)_mtl_u._WorldSpaceLightPos0.xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 in_POSITION0;
in  vec2 in_TEXCOORD0;
out vec4 vs_COLOR0;
out vec4 vs_TEXCOORD0;
out vec2 vs_TEXCOORD1;
out vec2 vs_TEXCOORD2;
out vec2 vs_TEXCOORD3;
out vec2 vs_TEXCOORD4;
out vec4 vs_TEXCOORD5;
out vec3 vs_TEXCOORD6;
out vec3 vs_TEXCOORD7;
out vec3 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
bvec4 tb1;
vec4 t2;
vec4 t3;
bvec3 tb3;
vec4 t4;
bvec4 tb4;
vec4 t5;
bvec4 tb5;
vec4 t6;
ivec3 ti6;
bvec3 tb6;
vec4 t7;
ivec3 ti7;
bvec4 tb7;
vec4 t8;
vec4 t9;
bvec4 tb9;
vec4 t10;
bvec4 tb10;
vec4 t11;
bvec4 tb11;
vec4 t12;
vec4 t13;
float t15;
vec3 t18;
ivec3 ti18;
vec3 t20;
vec2 t28;
int ti28;
vec2 t29;
int ti29;
vec2 t31;
ivec2 ti31;
bvec2 tb31;
float t42;
int ti42;
float t43;
int ti43;
bool tb43;
float t44;
int ti44;
bool tb44;
float t45;
int ti45;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t44 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t44);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t44 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t44) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t42 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t42);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t42 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t42) + t6.xyz;
    t42 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t42);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t42 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t42) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t42 = dot(t1, t6);
    t0.x = t42 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t42 = t1.x * 0.5;
    t43 = _MaxScale + -1.0;
    t42 = t42 * t43 + 1.0;
    t2.xyz = vec3(t42) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t43 = dot(t5.xyz, t5.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t5.xyz;
    t44 = t5.z * t43 + (-t6.y);
    tb31.x = abs(t6.z)>=abs(t6.y);
    t31.x = tb31.x ? 1.0 : float(0.0);
    t44 = t31.x * t44 + t6.y;
    t43 = (-t5.x) * t43 + t44;
    t44 = max(abs(t6.z), abs(t6.y));
    tb44 = t44>=abs(t6.x);
    t44 = tb44 ? 1.0 : float(0.0);
    t43 = t44 * t43 + t6.x;
    ti45 = int((0.0<t43) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t43<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti43 = (-ti45) + ti43;
    t5.y = float(ti43);
    t7.y = (-t5.y);
    t7.xz = vec2(1.0, -1.0);
    t7.xyz = t6.yzx * t7.xyz;
    t5.xz = vec2(1.0, -1.0);
    t8.xyz = t5.xyz * t6.zyx + (-t7.xyz);
    t7.xyz = t31.xxx * t8.xyz + t7.xyz;
    t7.xyz = (-t5.xxy) * t6.xyz + t7.xyz;
    t5.xyz = t6.xyz * t5.xxy;
    t5.xyz = vec3(t44) * t7.xyz + t5.xyz;
    t31.xy = t5.yz * vec2(0.5, 0.5);
    t31.xy = t31.xy / abs(t5.xx);
    t31.xy = t31.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t31.xy, 0.0);
    t43 = dot(t4.xyz, t4.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb43 = abs(t6.y)<abs(t6.x);
    t44 = max(abs(t6.y), abs(t6.x));
    t44 = float(1.0) / t44;
    t31.x = min(abs(t6.y), abs(t6.x));
    t44 = t44 * t31.x;
    t31.x = t44 * t44;
    t45 = t31.x * 0.0208350997 + -0.0851330012;
    t45 = t31.x * t45 + 0.180141002;
    t45 = t31.x * t45 + -0.330299497;
    t31.x = t31.x * t45 + 0.999866009;
    t45 = t44 * t31.x;
    t45 = t45 * -2.0 + 1.57079637;
    t43 = tb43 ? t45 : float(0.0);
    t43 = t44 * t31.x + t43;
    tb31.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t44 = tb31.x ? -3.14159274 : float(0.0);
    t43 = t43 + t44;
    t44 = min(t6.y, t6.x);
    tb44 = t44<(-t44);
    t31.x = max(t6.y, t6.x);
    tb31.x = t31.x>=(-t31.x);
    ti44 = int(uint(tb44) * 0xffffffffu & uint(tb31.x) * 0xffffffffu);
    t43 = (ti44 != 0) ? (-t43) : t43;
    t4.x = t43 * 0.159154937 + 0.5;
    t43 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t43 = t43 * abs(t6.z) + -0.212114394;
    t43 = t43 * abs(t6.z) + 1.57072878;
    t44 = -abs(t6.z) + 1.0;
    t44 = sqrt(t44);
    t31.x = t43 * t44;
    t31.x = t31.x * -2.0 + 3.14159274;
    t31.x = tb31.y ? t31.x : float(0.0);
    t43 = t43 * t44 + t31.x;
    t4.y = t43 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t4 = t5 * t4;
    vs_COLOR0.xyz = t4.xyz;
    t43 = dot(t2.xyz, t2.xyz);
    t44 = sqrt(t43);
    t43 = inversesqrt(t43);
    t2.xyz = vec3(t43) * t2.xyz;
    t43 = t44 * _DistFade;
    t44 = (-_DistFadeVert) * t44 + 1.0;
    t44 = clamp(t44, 0.0, 1.0);
    t43 = t43;
    t43 = clamp(t43, 0.0, 1.0);
    t43 = t44 * t43;
    vs_COLOR0.w = t43 * t4.w;
    vs_TEXCOORD0.w = t43;
    t4.x = fract(_Rotation);
    t4.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t4.xyz;
    t31.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t31.x);
    t44 = t42 * t31.y;
    t29.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t29.x = sqrt(t29.x);
    t4.x = sin(t1.y);
    t5.x = cos(t1.y);
    t6.x = cos(t1.x);
    t1.x = sin(t1.x);
    t15 = t29.x * t5.x;
    t29.x = t29.x * t4.x;
    t31.xy = t1.wx * vec2(t15);
    t45 = t29.x * t6.x + (-t31.y);
    t4.x = t15 * t45 + t1.x;
    t18.x = t6.x * t15;
    t18.x = t29.x * t1.x + t18.x;
    t15 = t15 * t18.x + (-t6.x);
    t15 = t42 * t15;
    t5.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t5.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t5.xyz;
    t5.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t5.xyz;
    t5.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t5.xyz;
    t20.xyz = vec3(t15) * t5.xyz;
    t7.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t7.xyz;
    t4.xzw = t7.xyz * t4.xxx + t20.xyz;
    t20.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t20.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t20.xyz;
    t20.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t20.xyz;
    t20.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t20.xyz;
    t4.xzw = t20.xyz * t31.xxx + t4.xzw;
    t8.y = t4.w;
    t15 = t29.x * t45 + (-t6.x);
    t1.x = t29.x * t18.x + (-t1.x);
    t29.x = t1.w * t29.x;
    t31.x = t1.w * t18.x;
    t43 = t1.w * t45;
    t9.xyz = t31.xxx * t5.xyz;
    t9.xyz = t7.xyz * vec3(t43) + t9.xyz;
    t9.xyz = t20.xyz * vec3(t44) + t9.xyz;
    t10.xyz = t1.xxx * t5.xyz;
    t1.xw = t0.yy * t5.xy;
    t0.xy = t7.xy * t0.xx + t1.xw;
    t0.xy = t20.xy * t0.zz + t0.xy;
    t28.x = t42 * t15;
    t1.xyw = t7.xyz * t28.xxx + t10.xyz;
    t1.xyz = t20.xyz * t29.xxx + t1.xyw;
    t8.x = t1.z;
    t8.z = t9.z;
    t28.x = dot(t8.xyz, t8.xyz);
    t28.x = inversesqrt(t28.x);
    t5.xyz = t28.xxx * t8.xyz;
    vs_TEXCOORD0.xyz = abs(t5.xyz);
    t28.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t28.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t28.xy;
    t28.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t28.xy;
    t28.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t28.xy;
    t0.xy = t28.xy + t0.xy;
    ti6.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t5.xyzx)).xyz) * 0xFFFFFFFFu);
    ti7.xyz = ivec3(uvec3(lessThan((-t5.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti6.xyz = (-ti6.xyz) + ti7.xyz;
    t28.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti29 = int((0.0<t28.y) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t28.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti29 = (-ti29) + ti43;
    ti7.xyz = ivec3(ti29) * ti6.xyz;
    t7.xyz = vec3(ti7.xyz);
    t7.xyz = t5.yzy * t7.xyz;
    t29.xy = vec2(ti6.xy);
    t29.xy = t28.xx * t29.xy;
    ti31.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t29.xyxy).xy) * 0xFFFFFFFFu);
    ti18.xz = ivec2(uvec2(lessThan(t29.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti31.xy = (-ti31.xy) + ti18.xz;
    ti31.xy = ti31.xy * ti6.xy;
    t31.xy = vec2(ti31.xy);
    t31.xy = t31.xy * t5.zx + t7.xy;
    t18.xz = t31.yy * t4.xz;
    t4.xz = t28.yy * t4.xz;
    t31.xy = t1.xy * t31.xx + t4.xz;
    t31.xy = t9.xy * t29.xx + t31.xy;
    t29.xy = t1.xy * t29.yy + t18.xz;
    t29.xy = t9.xy * t28.yy + t29.xy;
    t29.xy = t0.xy * in_POSITION0.ww + t29.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD2.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t29.xy = t0.xy * in_POSITION0.ww + t31.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD1.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti42 = int((0.0<t5.z) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t5.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti42 = (-ti42) + ti29;
    t42 = float(ti42);
    t28.x = t42 * t28.x;
    ti42 = int((0.0<t28.x) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t28.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t28.xx + t4.xz;
    ti28 = (-ti42) + ti29;
    ti28 = ti28 * ti6.z;
    t28.x = float(ti28);
    t28.x = t28.x * t5.x + t7.z;
    t28.xy = t9.xy * t28.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t28.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t42 = dot(t3.xyz, t3.xyz);
    t42 = inversesqrt(t42);
    t4.xyz = vec3(t42) * t3.yzx;
    t5.xyz = t0.zxy * t4.xyz;
    t4.xyz = t0.yzx * t4.yzx + (-t5.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t4.xyz), t2.xyz);
    t0.y = dot((-t4.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t42 = dot(t1.xyz, t1.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD7.xyz = vec3(t42) * t1.xyz;
    t42 = dot(t0.xyz, t0.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD8.xyz = vec3(t42) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _Tex;
in  vec4 vs_COLOR0;
in  vec4 vs_TEXCOORD0;
in  vec2 vs_TEXCOORD1;
in  vec2 vs_TEXCOORD2;
in  vec2 vs_TEXCOORD3;
in  vec2 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD7;
in  vec3 vs_TEXCOORD8;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
vec3 t3;
vec3 t4;
vec2 t8;
float t12;
void main()
{
    t0 = texture(_Tex, vs_TEXCOORD1.xy);
    t10_1 = texture(_Tex, vs_TEXCOORD2.xy);
    t0.y = t10_1.y;
    t10_1 = texture(_Tex, vs_TEXCOORD3.xy);
    t0.z = t10_1.z;
    t0.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t12 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t12 = t12 + vs_TEXCOORD0.z;
    t0.xyz = t0.xyz / vec3(t12);
    t0.x = t0.y + t0.x;
    t0.x = t0.z + t0.x;
    t4.x = t0.x * vs_TEXCOORD0.w;
    t4.x = (-_Opacity) * t4.x + _MinScatter;
    t8.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t8.xy, t8.xy);
    t8.x = min(t8.x, 1.0);
    t8.x = (-t8.x) + 1.0;
    t1.z = sqrt(t8.x);
    t1.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t1.xyz, t1.xyz);
    t8.x = inversesqrt(t8.x);
    t1.xyz = t8.xxx * t1.xyz;
    t8.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t8.x = inversesqrt(t8.x);
    t2.xyz = t8.xxx * vs_TEXCOORD7.xyz;
    t8.x = dot(t1.xyz, t2.xyz);
    t8.x = (-t8.x) + 1.0;
    t4.x = t8.x * t4.x;
    t8.x = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t8.x = inversesqrt(t8.x);
    t3.xyz = t8.xxx * vs_TEXCOORD8.xyz;
    t8.x = dot(t2.xyz, t3.xyz);
    t12 = dot(t1.xyz, t3.xyz);
    t12 = max(t12, 0.0);
    t8.x = t8.x * 0.5 + 0.5;
    t4.x = t8.x * t4.x;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t4.x = t4.x + t12;
    t4.xyz = t4.xxx * _LightColor0.xyz;
    t0.yzw = t4.xyz + t4.xyz;
    t1 = vs_COLOR0 * _Color;
    SV_Target0 = t0.yzwx * t1;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _WorldSpaceLightPos0;

uniform mat4 _Object2World;

uniform mat4 unity_MatrixV;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform mat4 _PosRotation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _Rotation;
uniform float _MaxScale;
uniform vec4 _NoiseScale;
uniform vec3 _MaxTrans;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec4 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec2 tmpvar_1;
  tmpvar_1 = gl_MultiTexCoord0.xy;
  vec4 XYv_2;
  vec4 XZv_3;
  vec4 ZYv_4;
  vec4 localOrigin_5;
  vec4 planet_pos_6;
  vec4 origin_7;
  vec4 tmpvar_8;
  vec4 tmpvar_9;
  vec4 tmpvar_10;
  vec3 tmpvar_11;
  vec4 tmpvar_12;
  tmpvar_12 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_7 = tmpvar_12;
  vec4 tmpvar_13;
  tmpvar_13 = (_PosRotation * tmpvar_12);
  planet_pos_6 = tmpvar_13;
  vec3 tmpvar_14;
  tmpvar_14 = (_NoiseScale.z * tmpvar_13.xyz);
  float tmpvar_15;
  vec4 m_16;
  vec3 tmpvar_17;
  tmpvar_17 = floor((tmpvar_14 + dot (tmpvar_14, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_18;
  tmpvar_18 = ((tmpvar_14 - tmpvar_17) + dot (tmpvar_17, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_19;
  tmpvar_19.x = float((tmpvar_18.x >= tmpvar_18.y));
  tmpvar_19.y = float((tmpvar_18.y >= tmpvar_18.z));
  tmpvar_19.z = float((tmpvar_18.z >= tmpvar_18.x));
  vec3 tmpvar_20;
  tmpvar_20 = (1.0 - tmpvar_19);
  vec3 tmpvar_21;
  tmpvar_21 = min (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_22;
  tmpvar_22 = max (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_23;
  tmpvar_23 = ((tmpvar_18 - tmpvar_21) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_24;
  tmpvar_24 = ((tmpvar_18 - tmpvar_22) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_25;
  tmpvar_25 = (tmpvar_18 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_26;
  tmpvar_26 = (tmpvar_17 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_27;
  tmpvar_27 = (fract(abs(tmpvar_26)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_28;
  if ((tmpvar_26.x >= 0.0)) {
    tmpvar_28 = tmpvar_27.x;
  } else {
    tmpvar_28 = -(tmpvar_27.x);
  };
  float tmpvar_29;
  if ((tmpvar_26.y >= 0.0)) {
    tmpvar_29 = tmpvar_27.y;
  } else {
    tmpvar_29 = -(tmpvar_27.y);
  };
  float tmpvar_30;
  if ((tmpvar_26.z >= 0.0)) {
    tmpvar_30 = tmpvar_27.z;
  } else {
    tmpvar_30 = -(tmpvar_27.z);
  };
  vec4 tmpvar_31;
  tmpvar_31.xw = vec2(0.0, 1.0);
  tmpvar_31.y = tmpvar_21.z;
  tmpvar_31.z = tmpvar_22.z;
  vec4 x_32;
  x_32 = (tmpvar_30 + tmpvar_31);
  vec4 tmpvar_33;
  tmpvar_33 = (((
    (x_32 * x_32)
   * 34.0) + x_32) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_34;
  tmpvar_34 = (fract(abs(tmpvar_33)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_35;
  if ((tmpvar_33.x >= 0.0)) {
    tmpvar_35 = tmpvar_34.x;
  } else {
    tmpvar_35 = -(tmpvar_34.x);
  };
  float tmpvar_36;
  if ((tmpvar_33.y >= 0.0)) {
    tmpvar_36 = tmpvar_34.y;
  } else {
    tmpvar_36 = -(tmpvar_34.y);
  };
  float tmpvar_37;
  if ((tmpvar_33.z >= 0.0)) {
    tmpvar_37 = tmpvar_34.z;
  } else {
    tmpvar_37 = -(tmpvar_34.z);
  };
  float tmpvar_38;
  if ((tmpvar_33.w >= 0.0)) {
    tmpvar_38 = tmpvar_34.w;
  } else {
    tmpvar_38 = -(tmpvar_34.w);
  };
  vec4 tmpvar_39;
  tmpvar_39.x = tmpvar_35;
  tmpvar_39.y = tmpvar_36;
  tmpvar_39.z = tmpvar_37;
  tmpvar_39.w = tmpvar_38;
  vec4 tmpvar_40;
  tmpvar_40.xw = vec2(0.0, 1.0);
  tmpvar_40.y = tmpvar_21.y;
  tmpvar_40.z = tmpvar_22.y;
  vec4 x_41;
  x_41 = ((tmpvar_39 + tmpvar_29) + tmpvar_40);
  vec4 tmpvar_42;
  tmpvar_42 = (((
    (x_41 * x_41)
   * 34.0) + x_41) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_43;
  tmpvar_43 = (fract(abs(tmpvar_42)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_44;
  if ((tmpvar_42.x >= 0.0)) {
    tmpvar_44 = tmpvar_43.x;
  } else {
    tmpvar_44 = -(tmpvar_43.x);
  };
  float tmpvar_45;
  if ((tmpvar_42.y >= 0.0)) {
    tmpvar_45 = tmpvar_43.y;
  } else {
    tmpvar_45 = -(tmpvar_43.y);
  };
  float tmpvar_46;
  if ((tmpvar_42.z >= 0.0)) {
    tmpvar_46 = tmpvar_43.z;
  } else {
    tmpvar_46 = -(tmpvar_43.z);
  };
  float tmpvar_47;
  if ((tmpvar_42.w >= 0.0)) {
    tmpvar_47 = tmpvar_43.w;
  } else {
    tmpvar_47 = -(tmpvar_43.w);
  };
  vec4 tmpvar_48;
  tmpvar_48.x = tmpvar_44;
  tmpvar_48.y = tmpvar_45;
  tmpvar_48.z = tmpvar_46;
  tmpvar_48.w = tmpvar_47;
  vec4 tmpvar_49;
  tmpvar_49.xw = vec2(0.0, 1.0);
  tmpvar_49.y = tmpvar_21.x;
  tmpvar_49.z = tmpvar_22.x;
  vec4 x_50;
  x_50 = ((tmpvar_48 + tmpvar_28) + tmpvar_49);
  vec4 tmpvar_51;
  tmpvar_51 = (((
    (x_50 * x_50)
   * 34.0) + x_50) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_52;
  tmpvar_52 = (fract(abs(tmpvar_51)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_53;
  if ((tmpvar_51.x >= 0.0)) {
    tmpvar_53 = tmpvar_52.x;
  } else {
    tmpvar_53 = -(tmpvar_52.x);
  };
  float tmpvar_54;
  if ((tmpvar_51.y >= 0.0)) {
    tmpvar_54 = tmpvar_52.y;
  } else {
    tmpvar_54 = -(tmpvar_52.y);
  };
  float tmpvar_55;
  if ((tmpvar_51.z >= 0.0)) {
    tmpvar_55 = tmpvar_52.z;
  } else {
    tmpvar_55 = -(tmpvar_52.z);
  };
  float tmpvar_56;
  if ((tmpvar_51.w >= 0.0)) {
    tmpvar_56 = tmpvar_52.w;
  } else {
    tmpvar_56 = -(tmpvar_52.w);
  };
  vec4 tmpvar_57;
  tmpvar_57.x = tmpvar_53;
  tmpvar_57.y = tmpvar_54;
  tmpvar_57.z = tmpvar_55;
  tmpvar_57.w = tmpvar_56;
  vec4 tmpvar_58;
  tmpvar_58 = (tmpvar_57 - (49.0 * floor(
    (0.02040815 * tmpvar_57)
  )));
  vec4 tmpvar_59;
  tmpvar_59 = floor((tmpvar_58 * 0.1428571));
  vec4 tmpvar_60;
  tmpvar_60 = ((tmpvar_59 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_61;
  tmpvar_61 = ((floor(
    (tmpvar_58 - (7.0 * tmpvar_59))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_62;
  tmpvar_62 = ((1.0 - abs(tmpvar_60)) - abs(tmpvar_61));
  vec4 tmpvar_63;
  tmpvar_63.xy = tmpvar_60.xy;
  tmpvar_63.zw = tmpvar_61.xy;
  vec4 tmpvar_64;
  tmpvar_64.xy = tmpvar_60.zw;
  tmpvar_64.zw = tmpvar_61.zw;
  vec4 tmpvar_65;
  tmpvar_65 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_62)));
  vec4 tmpvar_66;
  tmpvar_66 = (tmpvar_63.xzyw + ((
    (floor(tmpvar_63) * 2.0)
   + 1.0).xzyw * tmpvar_65.xxyy));
  vec4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_65.zzww));
  vec3 tmpvar_68;
  tmpvar_68.xy = tmpvar_66.xy;
  tmpvar_68.z = tmpvar_62.x;
  vec3 tmpvar_69;
  tmpvar_69.xy = tmpvar_66.zw;
  tmpvar_69.z = tmpvar_62.y;
  vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.xy;
  tmpvar_70.z = tmpvar_62.z;
  vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_67.zw;
  tmpvar_71.z = tmpvar_62.w;
  vec4 tmpvar_72;
  tmpvar_72.x = dot (tmpvar_68, tmpvar_68);
  tmpvar_72.y = dot (tmpvar_69, tmpvar_69);
  tmpvar_72.z = dot (tmpvar_70, tmpvar_70);
  tmpvar_72.w = dot (tmpvar_71, tmpvar_71);
  vec4 tmpvar_73;
  tmpvar_73 = (1.792843 - (0.8537347 * tmpvar_72));
  vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_18, tmpvar_18);
  tmpvar_74.y = dot (tmpvar_23, tmpvar_23);
  tmpvar_74.z = dot (tmpvar_24, tmpvar_24);
  tmpvar_74.w = dot (tmpvar_25, tmpvar_25);
  vec4 tmpvar_75;
  tmpvar_75 = max ((0.6 - tmpvar_74), vec4(0.0, 0.0, 0.0, 0.0));
  m_16 = (tmpvar_75 * tmpvar_75);
  vec4 tmpvar_76;
  tmpvar_76.x = dot ((tmpvar_68 * tmpvar_73.x), tmpvar_18);
  tmpvar_76.y = dot ((tmpvar_69 * tmpvar_73.y), tmpvar_23);
  tmpvar_76.z = dot ((tmpvar_70 * tmpvar_73.z), tmpvar_24);
  tmpvar_76.w = dot ((tmpvar_71 * tmpvar_73.w), tmpvar_25);
  tmpvar_15 = (42.0 * dot ((m_16 * m_16), tmpvar_76));
  float tmpvar_77;
  vec3 v_78;
  v_78 = (_NoiseScale.x * tmpvar_14);
  vec4 m_79;
  vec3 tmpvar_80;
  tmpvar_80 = floor((v_78 + dot (v_78, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_81;
  tmpvar_81 = ((v_78 - tmpvar_80) + dot (tmpvar_80, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_82;
  tmpvar_82.x = float((tmpvar_81.x >= tmpvar_81.y));
  tmpvar_82.y = float((tmpvar_81.y >= tmpvar_81.z));
  tmpvar_82.z = float((tmpvar_81.z >= tmpvar_81.x));
  vec3 tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_82);
  vec3 tmpvar_84;
  tmpvar_84 = min (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_85;
  tmpvar_85 = max (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_86;
  tmpvar_86 = ((tmpvar_81 - tmpvar_84) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_87;
  tmpvar_87 = ((tmpvar_81 - tmpvar_85) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_88;
  tmpvar_88 = (tmpvar_81 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_89;
  tmpvar_89 = (tmpvar_80 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_90;
  tmpvar_90 = (fract(abs(tmpvar_89)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_91;
  if ((tmpvar_89.x >= 0.0)) {
    tmpvar_91 = tmpvar_90.x;
  } else {
    tmpvar_91 = -(tmpvar_90.x);
  };
  float tmpvar_92;
  if ((tmpvar_89.y >= 0.0)) {
    tmpvar_92 = tmpvar_90.y;
  } else {
    tmpvar_92 = -(tmpvar_90.y);
  };
  float tmpvar_93;
  if ((tmpvar_89.z >= 0.0)) {
    tmpvar_93 = tmpvar_90.z;
  } else {
    tmpvar_93 = -(tmpvar_90.z);
  };
  vec4 tmpvar_94;
  tmpvar_94.xw = vec2(0.0, 1.0);
  tmpvar_94.y = tmpvar_84.z;
  tmpvar_94.z = tmpvar_85.z;
  vec4 x_95;
  x_95 = (tmpvar_93 + tmpvar_94);
  vec4 tmpvar_96;
  tmpvar_96 = (((
    (x_95 * x_95)
   * 34.0) + x_95) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_97;
  tmpvar_97 = (fract(abs(tmpvar_96)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_98;
  if ((tmpvar_96.x >= 0.0)) {
    tmpvar_98 = tmpvar_97.x;
  } else {
    tmpvar_98 = -(tmpvar_97.x);
  };
  float tmpvar_99;
  if ((tmpvar_96.y >= 0.0)) {
    tmpvar_99 = tmpvar_97.y;
  } else {
    tmpvar_99 = -(tmpvar_97.y);
  };
  float tmpvar_100;
  if ((tmpvar_96.z >= 0.0)) {
    tmpvar_100 = tmpvar_97.z;
  } else {
    tmpvar_100 = -(tmpvar_97.z);
  };
  float tmpvar_101;
  if ((tmpvar_96.w >= 0.0)) {
    tmpvar_101 = tmpvar_97.w;
  } else {
    tmpvar_101 = -(tmpvar_97.w);
  };
  vec4 tmpvar_102;
  tmpvar_102.x = tmpvar_98;
  tmpvar_102.y = tmpvar_99;
  tmpvar_102.z = tmpvar_100;
  tmpvar_102.w = tmpvar_101;
  vec4 tmpvar_103;
  tmpvar_103.xw = vec2(0.0, 1.0);
  tmpvar_103.y = tmpvar_84.y;
  tmpvar_103.z = tmpvar_85.y;
  vec4 x_104;
  x_104 = ((tmpvar_102 + tmpvar_92) + tmpvar_103);
  vec4 tmpvar_105;
  tmpvar_105 = (((
    (x_104 * x_104)
   * 34.0) + x_104) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_106;
  tmpvar_106 = (fract(abs(tmpvar_105)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_107;
  if ((tmpvar_105.x >= 0.0)) {
    tmpvar_107 = tmpvar_106.x;
  } else {
    tmpvar_107 = -(tmpvar_106.x);
  };
  float tmpvar_108;
  if ((tmpvar_105.y >= 0.0)) {
    tmpvar_108 = tmpvar_106.y;
  } else {
    tmpvar_108 = -(tmpvar_106.y);
  };
  float tmpvar_109;
  if ((tmpvar_105.z >= 0.0)) {
    tmpvar_109 = tmpvar_106.z;
  } else {
    tmpvar_109 = -(tmpvar_106.z);
  };
  float tmpvar_110;
  if ((tmpvar_105.w >= 0.0)) {
    tmpvar_110 = tmpvar_106.w;
  } else {
    tmpvar_110 = -(tmpvar_106.w);
  };
  vec4 tmpvar_111;
  tmpvar_111.x = tmpvar_107;
  tmpvar_111.y = tmpvar_108;
  tmpvar_111.z = tmpvar_109;
  tmpvar_111.w = tmpvar_110;
  vec4 tmpvar_112;
  tmpvar_112.xw = vec2(0.0, 1.0);
  tmpvar_112.y = tmpvar_84.x;
  tmpvar_112.z = tmpvar_85.x;
  vec4 x_113;
  x_113 = ((tmpvar_111 + tmpvar_91) + tmpvar_112);
  vec4 tmpvar_114;
  tmpvar_114 = (((
    (x_113 * x_113)
   * 34.0) + x_113) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_115;
  tmpvar_115 = (fract(abs(tmpvar_114)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_116;
  if ((tmpvar_114.x >= 0.0)) {
    tmpvar_116 = tmpvar_115.x;
  } else {
    tmpvar_116 = -(tmpvar_115.x);
  };
  float tmpvar_117;
  if ((tmpvar_114.y >= 0.0)) {
    tmpvar_117 = tmpvar_115.y;
  } else {
    tmpvar_117 = -(tmpvar_115.y);
  };
  float tmpvar_118;
  if ((tmpvar_114.z >= 0.0)) {
    tmpvar_118 = tmpvar_115.z;
  } else {
    tmpvar_118 = -(tmpvar_115.z);
  };
  float tmpvar_119;
  if ((tmpvar_114.w >= 0.0)) {
    tmpvar_119 = tmpvar_115.w;
  } else {
    tmpvar_119 = -(tmpvar_115.w);
  };
  vec4 tmpvar_120;
  tmpvar_120.x = tmpvar_116;
  tmpvar_120.y = tmpvar_117;
  tmpvar_120.z = tmpvar_118;
  tmpvar_120.w = tmpvar_119;
  vec4 tmpvar_121;
  tmpvar_121 = (tmpvar_120 - (49.0 * floor(
    (0.02040815 * tmpvar_120)
  )));
  vec4 tmpvar_122;
  tmpvar_122 = floor((tmpvar_121 * 0.1428571));
  vec4 tmpvar_123;
  tmpvar_123 = ((tmpvar_122 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_124;
  tmpvar_124 = ((floor(
    (tmpvar_121 - (7.0 * tmpvar_122))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_125;
  tmpvar_125 = ((1.0 - abs(tmpvar_123)) - abs(tmpvar_124));
  vec4 tmpvar_126;
  tmpvar_126.xy = tmpvar_123.xy;
  tmpvar_126.zw = tmpvar_124.xy;
  vec4 tmpvar_127;
  tmpvar_127.xy = tmpvar_123.zw;
  tmpvar_127.zw = tmpvar_124.zw;
  vec4 tmpvar_128;
  tmpvar_128 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_125)));
  vec4 tmpvar_129;
  tmpvar_129 = (tmpvar_126.xzyw + ((
    (floor(tmpvar_126) * 2.0)
   + 1.0).xzyw * tmpvar_128.xxyy));
  vec4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_128.zzww));
  vec3 tmpvar_131;
  tmpvar_131.xy = tmpvar_129.xy;
  tmpvar_131.z = tmpvar_125.x;
  vec3 tmpvar_132;
  tmpvar_132.xy = tmpvar_129.zw;
  tmpvar_132.z = tmpvar_125.y;
  vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.xy;
  tmpvar_133.z = tmpvar_125.z;
  vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_130.zw;
  tmpvar_134.z = tmpvar_125.w;
  vec4 tmpvar_135;
  tmpvar_135.x = dot (tmpvar_131, tmpvar_131);
  tmpvar_135.y = dot (tmpvar_132, tmpvar_132);
  tmpvar_135.z = dot (tmpvar_133, tmpvar_133);
  tmpvar_135.w = dot (tmpvar_134, tmpvar_134);
  vec4 tmpvar_136;
  tmpvar_136 = (1.792843 - (0.8537347 * tmpvar_135));
  vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_81, tmpvar_81);
  tmpvar_137.y = dot (tmpvar_86, tmpvar_86);
  tmpvar_137.z = dot (tmpvar_87, tmpvar_87);
  tmpvar_137.w = dot (tmpvar_88, tmpvar_88);
  vec4 tmpvar_138;
  tmpvar_138 = max ((0.6 - tmpvar_137), vec4(0.0, 0.0, 0.0, 0.0));
  m_79 = (tmpvar_138 * tmpvar_138);
  vec4 tmpvar_139;
  tmpvar_139.x = dot ((tmpvar_131 * tmpvar_136.x), tmpvar_81);
  tmpvar_139.y = dot ((tmpvar_132 * tmpvar_136.y), tmpvar_86);
  tmpvar_139.z = dot ((tmpvar_133 * tmpvar_136.z), tmpvar_87);
  tmpvar_139.w = dot ((tmpvar_134 * tmpvar_136.w), tmpvar_88);
  tmpvar_77 = (42.0 * dot ((m_79 * m_79), tmpvar_139));
  vec3 v_140;
  v_140 = (_NoiseScale.y * tmpvar_14);
  vec4 m_141;
  vec3 tmpvar_142;
  tmpvar_142 = floor((v_140 + dot (v_140, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_143;
  tmpvar_143 = ((v_140 - tmpvar_142) + dot (tmpvar_142, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_144;
  tmpvar_144.x = float((tmpvar_143.x >= tmpvar_143.y));
  tmpvar_144.y = float((tmpvar_143.y >= tmpvar_143.z));
  tmpvar_144.z = float((tmpvar_143.z >= tmpvar_143.x));
  vec3 tmpvar_145;
  tmpvar_145 = (1.0 - tmpvar_144);
  vec3 tmpvar_146;
  tmpvar_146 = min (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_147;
  tmpvar_147 = max (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_148;
  tmpvar_148 = ((tmpvar_143 - tmpvar_146) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_149;
  tmpvar_149 = ((tmpvar_143 - tmpvar_147) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_150;
  tmpvar_150 = (tmpvar_143 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_151;
  tmpvar_151 = (tmpvar_142 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_152;
  tmpvar_152 = (fract(abs(tmpvar_151)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_153;
  if ((tmpvar_151.x >= 0.0)) {
    tmpvar_153 = tmpvar_152.x;
  } else {
    tmpvar_153 = -(tmpvar_152.x);
  };
  float tmpvar_154;
  if ((tmpvar_151.y >= 0.0)) {
    tmpvar_154 = tmpvar_152.y;
  } else {
    tmpvar_154 = -(tmpvar_152.y);
  };
  float tmpvar_155;
  if ((tmpvar_151.z >= 0.0)) {
    tmpvar_155 = tmpvar_152.z;
  } else {
    tmpvar_155 = -(tmpvar_152.z);
  };
  vec4 tmpvar_156;
  tmpvar_156.xw = vec2(0.0, 1.0);
  tmpvar_156.y = tmpvar_146.z;
  tmpvar_156.z = tmpvar_147.z;
  vec4 x_157;
  x_157 = (tmpvar_155 + tmpvar_156);
  vec4 tmpvar_158;
  tmpvar_158 = (((
    (x_157 * x_157)
   * 34.0) + x_157) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_159;
  tmpvar_159 = (fract(abs(tmpvar_158)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_160;
  if ((tmpvar_158.x >= 0.0)) {
    tmpvar_160 = tmpvar_159.x;
  } else {
    tmpvar_160 = -(tmpvar_159.x);
  };
  float tmpvar_161;
  if ((tmpvar_158.y >= 0.0)) {
    tmpvar_161 = tmpvar_159.y;
  } else {
    tmpvar_161 = -(tmpvar_159.y);
  };
  float tmpvar_162;
  if ((tmpvar_158.z >= 0.0)) {
    tmpvar_162 = tmpvar_159.z;
  } else {
    tmpvar_162 = -(tmpvar_159.z);
  };
  float tmpvar_163;
  if ((tmpvar_158.w >= 0.0)) {
    tmpvar_163 = tmpvar_159.w;
  } else {
    tmpvar_163 = -(tmpvar_159.w);
  };
  vec4 tmpvar_164;
  tmpvar_164.x = tmpvar_160;
  tmpvar_164.y = tmpvar_161;
  tmpvar_164.z = tmpvar_162;
  tmpvar_164.w = tmpvar_163;
  vec4 tmpvar_165;
  tmpvar_165.xw = vec2(0.0, 1.0);
  tmpvar_165.y = tmpvar_146.y;
  tmpvar_165.z = tmpvar_147.y;
  vec4 x_166;
  x_166 = ((tmpvar_164 + tmpvar_154) + tmpvar_165);
  vec4 tmpvar_167;
  tmpvar_167 = (((
    (x_166 * x_166)
   * 34.0) + x_166) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_168;
  tmpvar_168 = (fract(abs(tmpvar_167)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_169;
  if ((tmpvar_167.x >= 0.0)) {
    tmpvar_169 = tmpvar_168.x;
  } else {
    tmpvar_169 = -(tmpvar_168.x);
  };
  float tmpvar_170;
  if ((tmpvar_167.y >= 0.0)) {
    tmpvar_170 = tmpvar_168.y;
  } else {
    tmpvar_170 = -(tmpvar_168.y);
  };
  float tmpvar_171;
  if ((tmpvar_167.z >= 0.0)) {
    tmpvar_171 = tmpvar_168.z;
  } else {
    tmpvar_171 = -(tmpvar_168.z);
  };
  float tmpvar_172;
  if ((tmpvar_167.w >= 0.0)) {
    tmpvar_172 = tmpvar_168.w;
  } else {
    tmpvar_172 = -(tmpvar_168.w);
  };
  vec4 tmpvar_173;
  tmpvar_173.x = tmpvar_169;
  tmpvar_173.y = tmpvar_170;
  tmpvar_173.z = tmpvar_171;
  tmpvar_173.w = tmpvar_172;
  vec4 tmpvar_174;
  tmpvar_174.xw = vec2(0.0, 1.0);
  tmpvar_174.y = tmpvar_146.x;
  tmpvar_174.z = tmpvar_147.x;
  vec4 x_175;
  x_175 = ((tmpvar_173 + tmpvar_153) + tmpvar_174);
  vec4 tmpvar_176;
  tmpvar_176 = (((
    (x_175 * x_175)
   * 34.0) + x_175) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_177;
  tmpvar_177 = (fract(abs(tmpvar_176)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_178;
  if ((tmpvar_176.x >= 0.0)) {
    tmpvar_178 = tmpvar_177.x;
  } else {
    tmpvar_178 = -(tmpvar_177.x);
  };
  float tmpvar_179;
  if ((tmpvar_176.y >= 0.0)) {
    tmpvar_179 = tmpvar_177.y;
  } else {
    tmpvar_179 = -(tmpvar_177.y);
  };
  float tmpvar_180;
  if ((tmpvar_176.z >= 0.0)) {
    tmpvar_180 = tmpvar_177.z;
  } else {
    tmpvar_180 = -(tmpvar_177.z);
  };
  float tmpvar_181;
  if ((tmpvar_176.w >= 0.0)) {
    tmpvar_181 = tmpvar_177.w;
  } else {
    tmpvar_181 = -(tmpvar_177.w);
  };
  vec4 tmpvar_182;
  tmpvar_182.x = tmpvar_178;
  tmpvar_182.y = tmpvar_179;
  tmpvar_182.z = tmpvar_180;
  tmpvar_182.w = tmpvar_181;
  vec4 tmpvar_183;
  tmpvar_183 = (tmpvar_182 - (49.0 * floor(
    (0.02040815 * tmpvar_182)
  )));
  vec4 tmpvar_184;
  tmpvar_184 = floor((tmpvar_183 * 0.1428571));
  vec4 tmpvar_185;
  tmpvar_185 = ((tmpvar_184 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_186;
  tmpvar_186 = ((floor(
    (tmpvar_183 - (7.0 * tmpvar_184))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_187;
  tmpvar_187 = ((1.0 - abs(tmpvar_185)) - abs(tmpvar_186));
  vec4 tmpvar_188;
  tmpvar_188.xy = tmpvar_185.xy;
  tmpvar_188.zw = tmpvar_186.xy;
  vec4 tmpvar_189;
  tmpvar_189.xy = tmpvar_185.zw;
  tmpvar_189.zw = tmpvar_186.zw;
  vec4 tmpvar_190;
  tmpvar_190 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_187)));
  vec4 tmpvar_191;
  tmpvar_191 = (tmpvar_188.xzyw + ((
    (floor(tmpvar_188) * 2.0)
   + 1.0).xzyw * tmpvar_190.xxyy));
  vec4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_190.zzww));
  vec3 tmpvar_193;
  tmpvar_193.xy = tmpvar_191.xy;
  tmpvar_193.z = tmpvar_187.x;
  vec3 tmpvar_194;
  tmpvar_194.xy = tmpvar_191.zw;
  tmpvar_194.z = tmpvar_187.y;
  vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.xy;
  tmpvar_195.z = tmpvar_187.z;
  vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_192.zw;
  tmpvar_196.z = tmpvar_187.w;
  vec4 tmpvar_197;
  tmpvar_197.x = dot (tmpvar_193, tmpvar_193);
  tmpvar_197.y = dot (tmpvar_194, tmpvar_194);
  tmpvar_197.z = dot (tmpvar_195, tmpvar_195);
  tmpvar_197.w = dot (tmpvar_196, tmpvar_196);
  vec4 tmpvar_198;
  tmpvar_198 = (1.792843 - (0.8537347 * tmpvar_197));
  vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_143, tmpvar_143);
  tmpvar_199.y = dot (tmpvar_148, tmpvar_148);
  tmpvar_199.z = dot (tmpvar_149, tmpvar_149);
  tmpvar_199.w = dot (tmpvar_150, tmpvar_150);
  vec4 tmpvar_200;
  tmpvar_200 = max ((0.6 - tmpvar_199), vec4(0.0, 0.0, 0.0, 0.0));
  m_141 = (tmpvar_200 * tmpvar_200);
  vec4 tmpvar_201;
  tmpvar_201.x = dot ((tmpvar_193 * tmpvar_198.x), tmpvar_143);
  tmpvar_201.y = dot ((tmpvar_194 * tmpvar_198.y), tmpvar_148);
  tmpvar_201.z = dot ((tmpvar_195 * tmpvar_198.z), tmpvar_149);
  tmpvar_201.w = dot ((tmpvar_196 * tmpvar_198.w), tmpvar_150);
  vec3 tmpvar_202;
  tmpvar_202.x = tmpvar_15;
  tmpvar_202.y = tmpvar_77;
  tmpvar_202.z = (42.0 * dot ((m_141 * m_141), tmpvar_201));
  vec3 tmpvar_203;
  tmpvar_203 = (0.5 * (tmpvar_202 + 1.0));
  localOrigin_5.xyz = (((2.0 * tmpvar_203) - 1.0) * _MaxTrans);
  localOrigin_5.w = 1.0;
  float tmpvar_204;
  tmpvar_204 = ((tmpvar_203.x * (_MaxScale - 1.0)) + 1.0);
  origin_7 = (_Object2World * localOrigin_5);
  planet_pos_6 = (_MainRotation * origin_7);
  vec3 tmpvar_205;
  tmpvar_205 = (_DetailRotation * planet_pos_6).xyz;
  tmpvar_11 = planet_pos_6.xyz;
  vec3 tmpvar_206;
  tmpvar_206 = normalize(planet_pos_6.xyz);
  vec2 uv_207;
  float tmpvar_208;
  float tmpvar_209;
  tmpvar_209 = (min (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0) / max (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0));
  float tmpvar_210;
  tmpvar_210 = (tmpvar_209 * tmpvar_209);
  tmpvar_210 = (((
    ((((
      ((((-0.01213232 * tmpvar_210) + 0.05368138) * tmpvar_210) - 0.1173503)
     * tmpvar_210) + 0.1938925) * tmpvar_210) - 0.3326756)
   * tmpvar_210) + 0.9999793) * tmpvar_209);
  tmpvar_210 = (tmpvar_210 + (float(
    (abs((tmpvar_206.x / tmpvar_206.z)) > 1.0)
  ) * (
    (tmpvar_210 * -2.0)
   + 1.570796)));
  tmpvar_208 = (tmpvar_210 * sign((tmpvar_206.x / tmpvar_206.z)));
  if ((abs(tmpvar_206.z) > (1e-08 * abs(tmpvar_206.x)))) {
    if ((tmpvar_206.z < 0.0)) {
      if ((tmpvar_206.x >= 0.0)) {
        tmpvar_208 += 3.141593;
      } else {
        tmpvar_208 = (tmpvar_208 - 3.141593);
      };
    };
  } else {
    tmpvar_208 = (sign(tmpvar_206.x) * 1.570796);
  };
  uv_207.x = (0.5 + (0.1591549 * tmpvar_208));
  uv_207.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_206.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_206.y)
    )) * (1.570796 + (
      abs(tmpvar_206.y)
     * 
      (-0.2146018 + (abs(tmpvar_206.y) * (0.08656672 + (
        abs(tmpvar_206.y)
       * -0.03102955))))
    ))))
  )));
  vec4 uv4_211;
  uv4_211.zw = vec2(0.0, 0.0);
  vec3 tmpvar_212;
  tmpvar_212 = normalize(tmpvar_205);
  vec3 tmpvar_213;
  tmpvar_213 = abs(tmpvar_212);
  float tmpvar_214;
  tmpvar_214 = float((tmpvar_213.z >= tmpvar_213.x));
  float tmpvar_215;
  tmpvar_215 = float((max (tmpvar_213.x, tmpvar_213.z) >= tmpvar_213.y));
  float tmpvar_216;
  tmpvar_216 = sign(mix (tmpvar_212.y, mix (tmpvar_212.x, tmpvar_212.z, tmpvar_214), tmpvar_215));
  vec3 tmpvar_217;
  tmpvar_217.xz = vec2(1.0, -1.0);
  tmpvar_217.y = -(tmpvar_216);
  vec3 tmpvar_218;
  tmpvar_218.xz = vec2(1.0, -1.0);
  tmpvar_218.y = tmpvar_216;
  vec3 tmpvar_219;
  tmpvar_219.xy = vec2(1.0, 1.0);
  tmpvar_219.z = tmpvar_216;
  vec3 tmpvar_220;
  tmpvar_220 = mix ((tmpvar_219 * tmpvar_212.yxz), mix ((tmpvar_217 * tmpvar_212.xzy), (tmpvar_218 * tmpvar_212.zxy), vec3(tmpvar_214)), vec3(tmpvar_215));
  uv4_211.xy = (((0.5 * tmpvar_220.yz) / abs(tmpvar_220.x)) + 0.5);
  tmpvar_8 = (texture2DLod (_MainTex, uv_207, 0.0) * texture2DLod (_DetailTex, uv4_211.xy, 0.0));
  vec4 tmpvar_221;
  tmpvar_221.w = 0.0;
  tmpvar_221.xyz = _WorldSpaceCameraPos;
  float tmpvar_222;
  vec4 tmpvar_223;
  tmpvar_223 = (origin_7 - tmpvar_221);
  tmpvar_222 = sqrt(dot (tmpvar_223, tmpvar_223));
  tmpvar_9.w = (clamp ((_DistFade * tmpvar_222), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_222)
  ), 0.0, 1.0));
  tmpvar_8.w = (tmpvar_8.w * tmpvar_9.w);
  vec3 tmpvar_224;
  tmpvar_224.yz = vec2(0.0, 0.0);
  tmpvar_224.x = fract(_Rotation);
  vec3 x_225;
  x_225 = (tmpvar_224 + tmpvar_203);
  vec3 trans_226;
  trans_226 = localOrigin_5.xyz;
  float tmpvar_227;
  tmpvar_227 = (x_225.x * 6.283185);
  float tmpvar_228;
  tmpvar_228 = (x_225.y * 6.283185);
  float tmpvar_229;
  tmpvar_229 = (x_225.z * 2.0);
  float tmpvar_230;
  tmpvar_230 = sqrt(tmpvar_229);
  float tmpvar_231;
  tmpvar_231 = (sin(tmpvar_228) * tmpvar_230);
  float tmpvar_232;
  tmpvar_232 = (cos(tmpvar_228) * tmpvar_230);
  float tmpvar_233;
  tmpvar_233 = sqrt((2.0 - tmpvar_229));
  float tmpvar_234;
  tmpvar_234 = sin(tmpvar_227);
  float tmpvar_235;
  tmpvar_235 = cos(tmpvar_227);
  float tmpvar_236;
  tmpvar_236 = ((tmpvar_231 * tmpvar_235) - (tmpvar_232 * tmpvar_234));
  float tmpvar_237;
  tmpvar_237 = ((tmpvar_231 * tmpvar_234) + (tmpvar_232 * tmpvar_235));
  mat4 tmpvar_238;
  tmpvar_238[0].x = (tmpvar_204 * ((tmpvar_231 * tmpvar_236) - tmpvar_235));
  tmpvar_238[0].y = ((tmpvar_231 * tmpvar_237) - tmpvar_234);
  tmpvar_238[0].z = (tmpvar_231 * tmpvar_233);
  tmpvar_238[0].w = 0.0;
  tmpvar_238[1].x = ((tmpvar_232 * tmpvar_236) + tmpvar_234);
  tmpvar_238[1].y = (tmpvar_204 * ((tmpvar_232 * tmpvar_237) - tmpvar_235));
  tmpvar_238[1].z = (tmpvar_232 * tmpvar_233);
  tmpvar_238[1].w = 0.0;
  tmpvar_238[2].x = (tmpvar_233 * tmpvar_236);
  tmpvar_238[2].y = (tmpvar_233 * tmpvar_237);
  tmpvar_238[2].z = (tmpvar_204 * (1.0 - tmpvar_229));
  tmpvar_238[2].w = 0.0;
  tmpvar_238[3].x = trans_226.x;
  tmpvar_238[3].y = trans_226.y;
  tmpvar_238[3].z = trans_226.z;
  tmpvar_238[3].w = 1.0;
  mat4 tmpvar_239;
  tmpvar_239 = ((unity_MatrixV * _Object2World) * tmpvar_238);
  vec4 v_240;
  v_240.x = tmpvar_239[0].z;
  v_240.y = tmpvar_239[1].z;
  v_240.z = tmpvar_239[2].z;
  v_240.w = tmpvar_239[3].z;
  vec3 tmpvar_241;
  tmpvar_241 = normalize(v_240.xyz);
  tmpvar_9.xyz = abs(tmpvar_241);
  vec4 tmpvar_242;
  tmpvar_242 = (gl_ModelViewMatrix * localOrigin_5);
  vec4 tmpvar_243;
  tmpvar_243.xyz = (gl_Vertex.xyz * tmpvar_204);
  tmpvar_243.w = gl_Vertex.w;
  vec2 tmpvar_244;
  tmpvar_244 = ((2.0 * gl_MultiTexCoord0.xy) - 1.0);
  vec4 tmpvar_245;
  tmpvar_245.z = 0.0;
  tmpvar_245.xy = tmpvar_244;
  tmpvar_245.w = gl_Vertex.w;
  ZYv_4.xyw = tmpvar_245.zyw;
  XZv_3.yzw = tmpvar_245.zyw;
  XYv_2.yzw = tmpvar_245.yzw;
  ZYv_4.z = (tmpvar_244.x * sign(-(tmpvar_241.x)));
  XZv_3.x = (tmpvar_244.x * sign(-(tmpvar_241.y)));
  XYv_2.x = (tmpvar_244.x * sign(tmpvar_241.z));
  ZYv_4.x = ((sign(
    -(tmpvar_241.x)
  ) * sign(ZYv_4.z)) * tmpvar_241.z);
  XZv_3.y = ((sign(
    -(tmpvar_241.y)
  ) * sign(XZv_3.x)) * tmpvar_241.x);
  XYv_2.z = ((sign(
    -(tmpvar_241.z)
  ) * sign(XYv_2.x)) * tmpvar_241.x);
  ZYv_4.x = (ZYv_4.x + ((
    sign(-(tmpvar_241.x))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  XZv_3.y = (XZv_3.y + ((
    sign(-(tmpvar_241.y))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.z));
  XYv_2.z = (XYv_2.z + ((
    sign(-(tmpvar_241.z))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  vec3 tmpvar_246;
  tmpvar_246 = normalize((origin_7.xyz - _WorldSpaceCameraPos));
  vec3 tmpvar_247;
  tmpvar_247 = normalize(-(tmpvar_246));
  vec4 v_248;
  v_248.x = unity_MatrixV[0].x;
  v_248.y = unity_MatrixV[1].x;
  v_248.z = unity_MatrixV[2].x;
  v_248.w = unity_MatrixV[3].x;
  vec3 tmpvar_249;
  tmpvar_249 = normalize(v_248.xyz);
  vec3 tmpvar_250;
  vec3 tmpvar_251;
  tmpvar_250 = v_248.xyz;
  tmpvar_251 = ((tmpvar_247.zxy * tmpvar_249.yzx) - (tmpvar_247.yzx * tmpvar_249.zxy));
  mat3 tmpvar_252;
  tmpvar_252[0].x = tmpvar_250.x;
  tmpvar_252[0].y = tmpvar_251.x;
  tmpvar_252[0].z = tmpvar_247.x;
  tmpvar_252[1].x = tmpvar_250.y;
  tmpvar_252[1].y = tmpvar_251.y;
  tmpvar_252[1].z = tmpvar_247.y;
  tmpvar_252[2].x = tmpvar_250.z;
  tmpvar_252[2].y = tmpvar_251.z;
  tmpvar_252[2].z = tmpvar_247.z;
  gl_Position = (gl_ProjectionMatrix * (tmpvar_242 + tmpvar_243));
  xlv_COLOR = tmpvar_8;
  xlv_TEXCOORD0 = tmpvar_9;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * ZYv_4)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XZv_3)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XYv_2)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD4 = tmpvar_1;
  xlv_TEXCOORD5 = tmpvar_10;
  xlv_TEXCOORD6 = tmpvar_11;
  xlv_TEXCOORD7 = normalize((tmpvar_252 * tmpvar_246));
  xlv_TEXCOORD8 = normalize((tmpvar_252 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform vec4 _LightColor0;
uniform sampler2D _Tex;
uniform vec4 _Color;
uniform float _MinScatter;
uniform float _Opacity;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec3 normT_1;
  vec4 color_2;
  vec4 tex_3;
  tex_3.x = texture2D (_Tex, xlv_TEXCOORD1).x;
  tex_3.y = texture2D (_Tex, xlv_TEXCOORD2).y;
  tex_3.z = texture2D (_Tex, xlv_TEXCOORD3).z;
  tex_3.w = 0.0;
  tex_3.xyz = (tex_3.xyz * xlv_TEXCOORD0.xyz);
  tex_3 = (tex_3 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  float tmpvar_4;
  tmpvar_4 = ((tex_3.x + tex_3.y) + (tex_3.z + tex_3.w));
  vec4 tmpvar_5;
  tmpvar_5.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_5.w = tmpvar_4;
  tex_3.xyz = tmpvar_5.xyz;
  color_2 = (_Color * xlv_COLOR);
  normT_1.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_1.z = sqrt((1.0 - clamp (
    dot (normT_1.xy, normT_1.xy)
  , 0.0, 1.0)));
  color_2.w = (color_2.w * tmpvar_4);
  tex_3.w = (xlv_TEXCOORD0.w * tmpvar_4);
  vec4 c_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD8);
  vec3 tmpvar_8;
  tmpvar_8 = normalize(xlv_TEXCOORD7);
  vec3 tmpvar_9;
  tmpvar_9 = normalize(normT_1);
  float tmpvar_10;
  tmpvar_10 = max (dot (tmpvar_9, tmpvar_7), 0.0);
  c_6.xyz = ((_LightColor0.xyz * (vec3(tmpvar_10) + 
    clamp ((((_MinScatter - 
      (_Opacity * tex_3.w)
    ) * (1.0 - 
      dot (tmpvar_9, tmpvar_8)
    )) * (0.5 + (0.5 * 
      dot (tmpvar_8, tmpvar_7)
    ))), 0.0, 1.0)
  )) * 2.0);
  c_6.w = (tmpvar_10 * 2.0);
  color_2.xyz = (color_2.xyz * c_6.xyz);
  gl_FragData[0] = color_2;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 666 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "texcoord" TexCoord0
Matrix 19 [_DetailRotation] 3
Matrix 12 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 22 [_PosRotation] 3
Matrix 0 [glstate_matrix_modelview0]
Matrix 8 [glstate_matrix_projection]
Matrix 16 [unity_MatrixV] 3
Float 27 [_DistFade]
Float 28 [_DistFadeVert]
Float 30 [_MaxScale]
Vector 32 [_MaxTrans]
Vector 31 [_NoiseScale]
Float 29 [_Rotation]
Vector 25 [_WorldSpaceCameraPos]
Vector 26 [_WorldSpaceLightPos0]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
"vs_3_0
def c33, 0.333333343, 0.166666672, 1, -0.5
def c34, 34, 5.89795971, 49, 0.142857149
def c35, 0.00346020772, 289, 0, 1
def c36, 7, 0.285714298, -0.928571403, 0.600000024
def c37, 2, 1, 0.853734732, 1.79284286
def c38, -2, 3.14159274, 1, -1
def c39, 42, 0.0208350997, -0.0851330012, 0.180141002
def c40, -0.330299497, 0.999866009, -2, 1.57079637
def c41, -0.0187292993, 0.0742610022, 1.57072878, 0.318309873
def c42, -3.14159274, 0.159154937, 0.5, -0.212114394
def c43, 6.28318548, -3.14159274, 0.600000024, 0.5
dcl_position v0
dcl_texcoord v1
dcl_2d s0
dcl_2d s1
dcl_position o0
dcl_color o1
dcl_texcoord o2
dcl_texcoord1 o3.xy
dcl_texcoord2 o4.xy
dcl_texcoord3 o5.xy
dcl_texcoord4 o6.xy
dcl_texcoord5 o7
dcl_texcoord6 o8.xyz
dcl_texcoord7 o9.xyz
dcl_texcoord8 o10.xyz
mov r0.x, c4.w
mov r0.y, c5.w
mov r0.z, c6.w
mov r0.w, c7.w
dp4 r1.x, c22, r0
dp4 r1.y, c23, r0
dp4 r1.z, c24, r0
mul r0.xyz, r1, c31.z
dp3 r0.w, r0, c33.x
mad r2.xyz, c31.z, r1, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mad r1.xyz, c31.z, r1, -r2
dp3 r0.w, r2, c33.y
add r1.xyz, r0.w, r1
sge r2.xyz, r1, r1.yzxw
add r3.xyz, -r2.zxyw, c33.z
min r4.xyz, r2, r3
max r2.xyz, r2, r3
mad r3.xyw, r4.z, c35.zwzz, c35.zzzw
mov r3.z, r2.z
mad r3, r5.z, c35.y, r3
mul r5.xy, r5, c35.y
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.y
mad r6.xyw, r4.zyzz, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r3, r3, r6
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.x
mad r5.xyw, r4.zxzz, c35.zwzz, c35.zzzw
add r4.xyz, r1, -r4
add r4.xyz, r4, c33.y
mov r5.z, r2.x
add r2.xyz, r1, -r2
add r2.xyz, r2, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r6, r3, r5, -r5
mul r3, r6, c34.y
mul r5, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r5
frc r5, r5
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r5.xz, r6.yyww
add r7, r5, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r5, r7.zwxy, -r9.yyxx, r5.zwxy
mov r7.xy, r5.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r5.z, r8.y
dp3 r10.y, r5, r5
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r5.xyz, r5, r6.y
dp3 r5.y, r5, r4
dp3 r4.y, r4, r4
mul r3.xyz, r3, r6.z
dp3 r5.z, r3, r2
dp3 r4.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r5.x, r2, r1
add r2.xyz, r1, c33.w
dp3 r4.x, r1, r1
dp3 r5.w, r3, r2
dp3 r4.w, r2, r2
add r1, -r4, c36.w
max r1, r1, c35.z
mul r1, r1, r1
mul r1, r1, r1
dp4 r0.w, r1, r5
mul r1.x, r0.w, c39.x
mul r2.xyz, r0, c31.x
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.x, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r4.xyz, c31.x, r0, -r2
dp3 r0.w, r2, c33.y
add r2.xyz, r0.w, r4
sge r4.xyz, r2, r2.yzxw
add r5.xyw, -r4.zxzy, c33.z
min r6.xyz, r4, r5.xyww
max r4.xyz, r4, r5.xyww
mad r7.xyw, r6.z, c35.zwzz, c35.zzzw
mov r7.z, r4.z
mad r5, r5.z, c35.y, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r5, r8, c35.y, r3.y
mad r7.xyw, r6.zyzz, c35.zwzz, c35.zzzw
mov r7.z, r4.y
add r5, r5, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r3, r8, c35.y, r3.x
mad r5.xyw, r6.zxzz, c35.zwzz, c35.zzzw
add r6.xyz, r2, -r6
add r6.xyz, r6, c33.y
mov r5.z, r4.x
add r4.xyz, r2, -r4
add r4.xyz, r4, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r7, r3, r5, -r5
mul r3, r7, c34.y
mul r5, r7, c35.y
frc r7, r3
add r3, r3, -r7
mad r3, r3, -c34.z, r5
frc r5, r5
mul r7, r3, c34.w
frc r8, r7
add r7, r7, -r8
mad r3, r7, -c36.x, r3
mad r7, r7.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r8.yw, r3.xxzy
frc r8.xz, r7.yyww
mov r5.xz, r7.yyww
add r8, r5, -r8
mad r8, r8, c37.x, c37.y
add r9, -r7_abs.ywxz, c33.z
add r9, -r3_abs.xywz, r9.xywz
sge r10, c35.z, r9.xywz
mad r5, r8.zwxy, -r10.yyxx, r5.zwxy
mov r8.xy, r5.zwzw
mov r8.z, r9.x
dp3 r11.x, r8, r8
mov r5.z, r9.y
dp3 r11.y, r5, r5
frc r12.yw, r3.xzzw
mov r7.yw, r3.xzzw
frc r12.xz, r7
add r3, -r12, r7
mad r3, r3, c37.x, c37.y
mad r3, r3, -r10.zzww, r7
mov r9.xy, r3.zwzw
mov r3.z, r9.w
dp3 r11.z, r3, r3
dp3 r11.w, r9, r9
mad r7, r11, -c37.z, c37.w
mul r5.xyz, r5, r7.y
dp3 r5.y, r5, r6
dp3 r6.y, r6, r6
mul r3.xyz, r3, r7.z
dp3 r5.z, r3, r4
dp3 r6.z, r4, r4
mul r3.xyz, r7.x, r8
mul r4.xyz, r7.w, r9
dp3 r5.x, r3, r2
add r3.xyz, r2, c33.w
dp3 r6.x, r2, r2
dp3 r5.w, r4, r3
dp3 r6.w, r3, r3
add r2, -r6, c36.w
max r2, r2, c35.z
mul r2, r2, r2
mul r2, r2, r2
dp4 r0.w, r2, r5
mul r1.y, r0.w, c39.x
mul r2.xyz, r0, c31.y
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.y, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r0.xyz, c31.y, r0, -r2
dp3 r0.w, r2, c33.y
add r0.xyz, r0.w, r0
sge r2.xyz, r0, r0.yzxw
add r4.xyz, -r2.zxyw, c33.z
min r5.xyw, r2.xyzz, r4.xyzz
max r2.xyz, r2, r4
mad r4.xyw, r5.w, c35.zwzz, c35.zzzw
mov r4.z, r2.z
mad r4, r5.z, c35.y, r4
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r4, r7, c35.y, r3.y
mad r6.xyw, r5.wyzw, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r4, r4, r6
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r3, r7, c35.y, r3.x
mad r4.xyw, r5.wxzw, c35.zwzz, c35.zzzw
add r5.xyz, r0, -r5.xyww
add r5.xyz, r5, c33.y
mov r4.z, r2.x
add r2.xyz, r0, -r2
add r2.xyz, r2, c33.x
add r3, r3, r4
mul r4, r3, r3
mad r3, r4, c34.x, r3
mul r3, r3, c35.x
frc r4, r3_abs
sge r3, r3, -r3
lrp r6, r3, r4, -r4
mul r3, r6, c34.y
mul r4, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r4
frc r4, r4
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r4, r3
mad r3, r3, c36.y, c36.z
mov r4.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r4.xz, r6.yyww
add r7, r4, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r4, r7.zwxy, -r9.yyxx, r4.zwxy
mov r7.xy, r4.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r4.z, r8.y
dp3 r10.y, r4, r4
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r4.xyz, r4, r6.y
dp3 r4.y, r4, r5
dp3 r5.y, r5, r5
mul r3.xyz, r3, r6.z
dp3 r4.z, r3, r2
dp3 r5.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r4.x, r2, r0
add r2.xyz, r0, c33.w
dp3 r5.x, r0, r0
dp3 r4.w, r3, r2
dp3 r5.w, r2, r2
add r0, -r5, c36.w
max r0, r0, c35.z
mul r0, r0, r0
mul r0, r0, r0
dp4 r0.x, r0, r4
mul r1.z, r0.x, c39.x
mul r0.xyz, r1, c32
add r1.xyz, r1, c33.z
mov r0.w, c33.z
dp4 r2.w, c7, r0
dp4 r2.x, c4, r0
dp4 r2.y, c5, r0
dp4 r2.z, c6, r0
dp4 r3.w, c15, r2
dp4 r3.x, c12, r2
dp4 r3.y, c13, r2
dp4 r3.z, c14, r2
add r2.xyz, r2, -c25
dp4 r4.y, c19, r3
dp4 r4.x, c20, r3
dp4 r4.z, c21, r3
dp3 r1.w, r4, r4
rsq r1.w, r1.w
mul r5.xyz, r1.w, r4
mad r2.w, r4.z, r1.w, -r5.y
sge r3.w, r5_abs.z, r5_abs.y
mad r2.w, r3.w, r2.w, r5.y
mad r1.w, r4.x, -r1.w, r2.w
max r2.w, r5_abs.z, r5_abs.y
sge r2.w, r2.w, r5_abs.x
mad r1.w, r2.w, r1.w, r5.x
slt r4.x, -r1.w, r1.w
slt r1.w, r1.w, -r1.w
add r4.y, -r1.w, r4.x
mov r6.y, -r4.y
mov r6.xz, c38.zyww
mul r6.xyz, r5.yzxw, r6
mov r4.xz, c38.zyww
mad r7.xyz, r4, r5.zyxw, -r6
mad r6.xyz, r3.w, r7, r6
mad r6.xyz, r4.xxyw, -r5, r6
mul r4.xyz, r5, r4.xxyw
mad r4.xyz, r2.w, r6, r4
mul r4.yz, r4, -c33.w
rcp r1.w, r4_abs.x
mad r4.xy, r4.yzzw, r1.w, -c33.w
mov r4.zw, c35.z
texldl r4, r4, s1
dp3 r1.w, r3, r3
rsq r1.w, r1.w
mul r5.xyz, r1.w, r3.xzyw
mov o8.xyz, r3
max r1.w, r5_abs.y, r5_abs.x
rcp r1.w, r1.w
min r2.w, r5_abs.y, r5_abs.x
mul r1.w, r1.w, r2.w
mul r2.w, r1.w, r1.w
mad r3.x, r2.w, c39.y, c39.z
mad r3.x, r2.w, r3.x, c39.w
mad r3.x, r2.w, r3.x, c40.x
mad r2.w, r2.w, r3.x, c40.y
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c40.z, c40.w
slt r3.x, r5_abs.y, r5_abs.x
mad r1.w, r2.w, r3.x, r1.w
slt r3.xy, r5.yzzw, -r5.yzzw
mad r1.w, r3.x, c42.x, r1.w
add r2.w, r1.w, r1.w
min r3.x, r5.y, r5.x
slt r3.x, r3.x, -r3.x
max r3.z, r5.y, r5.x
sge r3.z, r3.z, -r3.z
mul r3.x, r3.z, r3.x
mad r1.w, r3.x, -r2.w, r1.w
mad r6.x, r1.w, c42.y, c42.z
mad r1.w, r5_abs.z, c41.x, c41.y
mad r1.w, r1.w, r5_abs.z, c42.w
mad r1.w, r1.w, r5_abs.z, c41.z
add r2.w, -r5_abs.z, c33.z
rsq r2.w, r2.w
rcp r2.w, r2.w
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c38.x, c38.y
mad r1.w, r2.w, r3.y, r1.w
mul r6.y, r1.w, c41.w
mov r6.zw, c35.z
texldl r3, r6, s0
mul r3, r4, r3
dp3 r1.w, r2, r2
rsq r1.w, r1.w
rcp r2.w, r1.w
mul r2.xyz, r1.w, r2
mul_sat r1.w, r2.w, c27.x
mov r4.z, c33.z
mad_sat r2.w, c28.x, -r2.w, r4.z
mul r1.w, r1.w, r2.w
mul o1.w, r1.w, r3.w
mov o1.xyz, r3
mov o2.w, r1.w
frc r3.x, c29.x
mov r3.y, c35.z
mad r1.zw, r1.xyxz, -c33.w, r3.xyxy
mad r3.xy, r1.w, -c37.x, c37
mul r1.x, r1.x, -c33.w
mad r1.y, r1.y, -c33.w, -c33.w
frc r1.y, r1.y
mad r1.y, r1.y, c43.x, c43.y
sincos r5.xy, r1.y
add r1.y, -r4.z, c30.x
mad r1.x, r1.x, r1.y, c33.z
mul r4.z, r3.y, r1.x
rsq r1.y, r3.x
rcp r1.y, r1.y
add r1.w, r1.w, r1.w
add r1.z, r1.z, -c33.w
frc r1.z, r1.z
mad r1.z, r1.z, c43.x, c43.y
sincos r3.xy, r1.z
rsq r1.z, r1.w
rcp r1.z, r1.z
mul r1.zw, r1.z, r5.xyyx
mul r5.xyz, r3.yyxw, r1.wzww
mad r2.w, r1.z, r3.x, -r5.x
add r3.z, r5.z, r5.y
mul r4.x, r1.y, r2.w
mul r4.y, r1.y, r3.z
mad r5.yz, r1.xzww, r3.z, -r3.xyxw
mul r6.zw, r1.y, r1
mov r7, c5
mul r8.xyz, r7, c18.y
mov r9, c4
mad r8.xyz, c18.x, r9, r8
mov r10, c6
mad r8.xyz, c18.z, r10, r8
mov r11, c7
mad r8.xyz, c18.w, r11, r8
dp3 r12.z, r8, r4
mad r1.y, r1.z, r2.w, -r3.x
mad r6.x, r1.w, r2.w, r3.y
mul r5.x, r1.y, r1.x
mov r5.w, r6.z
dp3 r12.x, r8, r5.xyww
mul r6.y, r1.x, r5.z
mul r1.xyz, r1.x, v0
dp3 r12.y, r8, r6.xyww
nrm r3.xyz, r12
abs o2.xyz, r3
dp4 r8.z, c2, r0
dp4 r8.w, c3, r0
dp4 r8.x, c0, r0
dp4 r8.y, c1, r0
mov r1.w, v0.w
add r1, r1, r8
dp4 o0.x, c8, r1
dp4 o0.y, c9, r1
dp4 o0.z, c10, r1
dp4 o0.w, c11, r1
mul r1, r7, c16.y
mad r1, c16.x, r9, r1
mad r1, c16.z, r10, r1
mad r1, c16.w, r11, r1
dp3 r12.z, r1, r4
dp4 r12.w, r1, r0
dp3 r12.x, r1, r5.xyww
dp3 r12.y, r1, r6.xyww
slt r1.xyz, r3, -r3
slt r13.xyz, -r3, r3
add r1.xyw, r1.xyzz, -r13.xyzz
add r1.z, -r1.z, r13.z
mad r8.zw, v1.xyxy, -c38.x, -c38.z
slt r2.w, -r8.w, r8.w
slt r3.w, r8.w, -r8.w
add r2.w, r2.w, -r3.w
mul r13.xyz, r1.xyww, r2.w
mul r13.xyz, r3.yzyw, r13
mul r3.yw, r1.xxzy, r8.z
mul r14.x, r1.z, r8.z
slt r8.zw, -r3.xyyw, r3.xyyw
slt r15.xy, r3.ywzw, -r3.ywzw
add r8.zw, r8, -r15.xyxy
mul r1.xy, r1, r8.zwzw
mad r15.xy, r1, r3.zxzw, r13
mov r16.x, r15.x
mov r16.z, r3.y
mov r15.x, r3.w
mad r16.y, v1.y, -c38.x, -c38.z
mov r16.w, v0.w
dp4 r1.x, r12, r16
mul r7, r7, c17.y
mad r7, c17.x, r9, r7
mad r7, c17.z, r10, r7
mad r7, c17.w, r11, r7
dp3 r4.z, r7, r4
dp3 r4.x, r7, r5.xyww
dp3 r4.y, r7, r6.xyww
dp4 r4.w, r7, r0
dp4 r1.y, r4, r16
mov r15.zw, r16.xyyw
add r0.xy, -r8, r1
mad o3.xy, r0, c43.z, c43.w
dp4 r0.x, r12, r15
dp4 r0.y, r4, r15
mov r14.yw, r15.xzzw
add r0.xy, -r8, r0
mad o4.xy, r0, c43.z, c43.w
slt r0.x, -r14.x, r14.x
slt r0.y, r14.x, -r14.x
add r0.x, -r0.y, r0.x
mul r0.x, r0.x, r1.w
mad r14.z, r0.x, r3.x, r13.z
dp4 r0.x, r12, r14
dp4 r0.y, r4, r14
add r0.xy, -r8, r0
mad o5.xy, r0, c43.z, c43.w
nrm r0.xyz, -r2
dp3 r0.w, c16, c16
rsq r0.w, r0.w
mul r1.xyz, r0.w, c16.yzxw
mul r3.xyz, r0.zxyw, r1
mad r1.xyz, r0.yzxw, r1.yzxw, -r3
dp3 r3.y, -r1, c26
dp3 r1.y, -r1, r2
dp3 r3.z, r0, c26
dp3 r1.z, r0, r2
dp3 r1.x, c16, r2
mov r0.xyz, c16
dp3 r3.x, r0, c26
dp3 r0.x, r3, r3
rsq r0.x, r0.x
mul o10.xyz, r0.x, r3
dp3 r0.x, r1, r1
rsq r0.x, r0.x
mul o9.xyz, r0.x, r1
mov o6.xy, v1
mov o7, c35.z

"
}
SubProgram "d3d11 " {
// Stats: 469 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "texcoord" TexCoord0
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 592
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 368 [_PosRotation]
Float 464 [_DistFade]
Float 468 [_DistFadeVert]
Float 484 [_Rotation]
Float 488 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityLighting" 720
Vector 0 [_WorldSpaceLightPos0]
ConstBuffer "UnityPerDraw" 352
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
ConstBuffer "UnityPerFrame" 256
Matrix 0 [glstate_matrix_projection]
Matrix 80 [unity_MatrixV]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityLighting" 2
BindCB  "UnityPerDraw" 3
BindCB  "UnityPerFrame" 4
"vs_4_0
root12:acafacaa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"
}
SubProgram "gles " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 glstate_matrix_projection;
uniform highp mat4 unity_MatrixV;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform highp mat4 _PosRotation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _Rotation;
uniform highp float _MaxScale;
uniform highp vec4 _NoiseScale;
uniform highp vec3 _MaxTrans;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  mediump vec3 normal_3;
  highp vec4 XYv_4;
  highp vec4 XZv_5;
  highp vec4 ZYv_6;
  highp vec4 localOrigin_7;
  highp vec4 planet_pos_8;
  highp vec4 origin_9;
  lowp vec4 tmpvar_10;
  mediump vec4 tmpvar_11;
  highp vec4 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_9 = tmpvar_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (_PosRotation * tmpvar_14);
  planet_pos_8 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (_NoiseScale.z * tmpvar_15.xyz);
  highp float tmpvar_17;
  highp vec4 m_18;
  highp vec3 tmpvar_19;
  tmpvar_19 = floor((tmpvar_16 + dot (tmpvar_16, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_20;
  tmpvar_20 = ((tmpvar_16 - tmpvar_19) + dot (tmpvar_19, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_21;
  tmpvar_21.x = float((tmpvar_20.x >= tmpvar_20.y));
  tmpvar_21.y = float((tmpvar_20.y >= tmpvar_20.z));
  tmpvar_21.z = float((tmpvar_20.z >= tmpvar_20.x));
  highp vec3 tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_21);
  highp vec3 tmpvar_23;
  tmpvar_23 = min (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_24;
  tmpvar_24 = max (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_25;
  tmpvar_25 = ((tmpvar_20 - tmpvar_23) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_26;
  tmpvar_26 = ((tmpvar_20 - tmpvar_24) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_27;
  tmpvar_27 = (tmpvar_20 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28 = (tmpvar_19 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (fract(abs(tmpvar_28)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_30;
  if ((tmpvar_28.x >= 0.0)) {
    tmpvar_30 = tmpvar_29.x;
  } else {
    tmpvar_30 = -(tmpvar_29.x);
  };
  highp float tmpvar_31;
  if ((tmpvar_28.y >= 0.0)) {
    tmpvar_31 = tmpvar_29.y;
  } else {
    tmpvar_31 = -(tmpvar_29.y);
  };
  highp float tmpvar_32;
  if ((tmpvar_28.z >= 0.0)) {
    tmpvar_32 = tmpvar_29.z;
  } else {
    tmpvar_32 = -(tmpvar_29.z);
  };
  highp vec4 tmpvar_33;
  tmpvar_33.xw = vec2(0.0, 1.0);
  tmpvar_33.y = tmpvar_23.z;
  tmpvar_33.z = tmpvar_24.z;
  highp vec4 x_34;
  x_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35 = (((
    (x_34 * x_34)
   * 34.0) + x_34) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_36;
  tmpvar_36 = (fract(abs(tmpvar_35)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_37;
  if ((tmpvar_35.x >= 0.0)) {
    tmpvar_37 = tmpvar_36.x;
  } else {
    tmpvar_37 = -(tmpvar_36.x);
  };
  highp float tmpvar_38;
  if ((tmpvar_35.y >= 0.0)) {
    tmpvar_38 = tmpvar_36.y;
  } else {
    tmpvar_38 = -(tmpvar_36.y);
  };
  highp float tmpvar_39;
  if ((tmpvar_35.z >= 0.0)) {
    tmpvar_39 = tmpvar_36.z;
  } else {
    tmpvar_39 = -(tmpvar_36.z);
  };
  highp float tmpvar_40;
  if ((tmpvar_35.w >= 0.0)) {
    tmpvar_40 = tmpvar_36.w;
  } else {
    tmpvar_40 = -(tmpvar_36.w);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.x = tmpvar_37;
  tmpvar_41.y = tmpvar_38;
  tmpvar_41.z = tmpvar_39;
  tmpvar_41.w = tmpvar_40;
  highp vec4 tmpvar_42;
  tmpvar_42.xw = vec2(0.0, 1.0);
  tmpvar_42.y = tmpvar_23.y;
  tmpvar_42.z = tmpvar_24.y;
  highp vec4 x_43;
  x_43 = ((tmpvar_41 + tmpvar_31) + tmpvar_42);
  highp vec4 tmpvar_44;
  tmpvar_44 = (((
    (x_43 * x_43)
   * 34.0) + x_43) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_45;
  tmpvar_45 = (fract(abs(tmpvar_44)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_46;
  if ((tmpvar_44.x >= 0.0)) {
    tmpvar_46 = tmpvar_45.x;
  } else {
    tmpvar_46 = -(tmpvar_45.x);
  };
  highp float tmpvar_47;
  if ((tmpvar_44.y >= 0.0)) {
    tmpvar_47 = tmpvar_45.y;
  } else {
    tmpvar_47 = -(tmpvar_45.y);
  };
  highp float tmpvar_48;
  if ((tmpvar_44.z >= 0.0)) {
    tmpvar_48 = tmpvar_45.z;
  } else {
    tmpvar_48 = -(tmpvar_45.z);
  };
  highp float tmpvar_49;
  if ((tmpvar_44.w >= 0.0)) {
    tmpvar_49 = tmpvar_45.w;
  } else {
    tmpvar_49 = -(tmpvar_45.w);
  };
  highp vec4 tmpvar_50;
  tmpvar_50.x = tmpvar_46;
  tmpvar_50.y = tmpvar_47;
  tmpvar_50.z = tmpvar_48;
  tmpvar_50.w = tmpvar_49;
  highp vec4 tmpvar_51;
  tmpvar_51.xw = vec2(0.0, 1.0);
  tmpvar_51.y = tmpvar_23.x;
  tmpvar_51.z = tmpvar_24.x;
  highp vec4 x_52;
  x_52 = ((tmpvar_50 + tmpvar_30) + tmpvar_51);
  highp vec4 tmpvar_53;
  tmpvar_53 = (((
    (x_52 * x_52)
   * 34.0) + x_52) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_54;
  tmpvar_54 = (fract(abs(tmpvar_53)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_55;
  if ((tmpvar_53.x >= 0.0)) {
    tmpvar_55 = tmpvar_54.x;
  } else {
    tmpvar_55 = -(tmpvar_54.x);
  };
  highp float tmpvar_56;
  if ((tmpvar_53.y >= 0.0)) {
    tmpvar_56 = tmpvar_54.y;
  } else {
    tmpvar_56 = -(tmpvar_54.y);
  };
  highp float tmpvar_57;
  if ((tmpvar_53.z >= 0.0)) {
    tmpvar_57 = tmpvar_54.z;
  } else {
    tmpvar_57 = -(tmpvar_54.z);
  };
  highp float tmpvar_58;
  if ((tmpvar_53.w >= 0.0)) {
    tmpvar_58 = tmpvar_54.w;
  } else {
    tmpvar_58 = -(tmpvar_54.w);
  };
  highp vec4 tmpvar_59;
  tmpvar_59.x = tmpvar_55;
  tmpvar_59.y = tmpvar_56;
  tmpvar_59.z = tmpvar_57;
  tmpvar_59.w = tmpvar_58;
  highp vec4 tmpvar_60;
  tmpvar_60 = (tmpvar_59 - (49.0 * floor(
    (0.02040815 * tmpvar_59)
  )));
  highp vec4 tmpvar_61;
  tmpvar_61 = floor((tmpvar_60 * 0.1428571));
  highp vec4 tmpvar_62;
  tmpvar_62 = ((tmpvar_61 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_63;
  tmpvar_63 = ((floor(
    (tmpvar_60 - (7.0 * tmpvar_61))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_64;
  tmpvar_64 = ((1.0 - abs(tmpvar_62)) - abs(tmpvar_63));
  highp vec4 tmpvar_65;
  tmpvar_65.xy = tmpvar_62.xy;
  tmpvar_65.zw = tmpvar_63.xy;
  highp vec4 tmpvar_66;
  tmpvar_66.xy = tmpvar_62.zw;
  tmpvar_66.zw = tmpvar_63.zw;
  highp vec4 tmpvar_67;
  tmpvar_67 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_64)));
  highp vec4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_67.xxyy));
  highp vec4 tmpvar_69;
  tmpvar_69 = (tmpvar_66.xzyw + ((
    (floor(tmpvar_66) * 2.0)
   + 1.0).xzyw * tmpvar_67.zzww));
  highp vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_68.xy;
  tmpvar_70.z = tmpvar_64.x;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.zw;
  tmpvar_71.z = tmpvar_64.y;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = tmpvar_69.xy;
  tmpvar_72.z = tmpvar_64.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = tmpvar_69.zw;
  tmpvar_73.z = tmpvar_64.w;
  highp vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_70, tmpvar_70);
  tmpvar_74.y = dot (tmpvar_71, tmpvar_71);
  tmpvar_74.z = dot (tmpvar_72, tmpvar_72);
  tmpvar_74.w = dot (tmpvar_73, tmpvar_73);
  highp vec4 tmpvar_75;
  tmpvar_75 = (1.792843 - (0.8537347 * tmpvar_74));
  highp vec4 tmpvar_76;
  tmpvar_76.x = dot (tmpvar_20, tmpvar_20);
  tmpvar_76.y = dot (tmpvar_25, tmpvar_25);
  tmpvar_76.z = dot (tmpvar_26, tmpvar_26);
  tmpvar_76.w = dot (tmpvar_27, tmpvar_27);
  highp vec4 tmpvar_77;
  tmpvar_77 = max ((0.6 - tmpvar_76), vec4(0.0, 0.0, 0.0, 0.0));
  m_18 = (tmpvar_77 * tmpvar_77);
  highp vec4 tmpvar_78;
  tmpvar_78.x = dot ((tmpvar_70 * tmpvar_75.x), tmpvar_20);
  tmpvar_78.y = dot ((tmpvar_71 * tmpvar_75.y), tmpvar_25);
  tmpvar_78.z = dot ((tmpvar_72 * tmpvar_75.z), tmpvar_26);
  tmpvar_78.w = dot ((tmpvar_73 * tmpvar_75.w), tmpvar_27);
  tmpvar_17 = (42.0 * dot ((m_18 * m_18), tmpvar_78));
  highp float tmpvar_79;
  highp vec3 v_80;
  v_80 = (_NoiseScale.x * tmpvar_16);
  highp vec4 m_81;
  highp vec3 tmpvar_82;
  tmpvar_82 = floor((v_80 + dot (v_80, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_83;
  tmpvar_83 = ((v_80 - tmpvar_82) + dot (tmpvar_82, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_84;
  tmpvar_84.x = float((tmpvar_83.x >= tmpvar_83.y));
  tmpvar_84.y = float((tmpvar_83.y >= tmpvar_83.z));
  tmpvar_84.z = float((tmpvar_83.z >= tmpvar_83.x));
  highp vec3 tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_84);
  highp vec3 tmpvar_86;
  tmpvar_86 = min (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_87;
  tmpvar_87 = max (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_88;
  tmpvar_88 = ((tmpvar_83 - tmpvar_86) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_89;
  tmpvar_89 = ((tmpvar_83 - tmpvar_87) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_90;
  tmpvar_90 = (tmpvar_83 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_91;
  tmpvar_91 = (tmpvar_82 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = (fract(abs(tmpvar_91)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_93;
  if ((tmpvar_91.x >= 0.0)) {
    tmpvar_93 = tmpvar_92.x;
  } else {
    tmpvar_93 = -(tmpvar_92.x);
  };
  highp float tmpvar_94;
  if ((tmpvar_91.y >= 0.0)) {
    tmpvar_94 = tmpvar_92.y;
  } else {
    tmpvar_94 = -(tmpvar_92.y);
  };
  highp float tmpvar_95;
  if ((tmpvar_91.z >= 0.0)) {
    tmpvar_95 = tmpvar_92.z;
  } else {
    tmpvar_95 = -(tmpvar_92.z);
  };
  highp vec4 tmpvar_96;
  tmpvar_96.xw = vec2(0.0, 1.0);
  tmpvar_96.y = tmpvar_86.z;
  tmpvar_96.z = tmpvar_87.z;
  highp vec4 x_97;
  x_97 = (tmpvar_95 + tmpvar_96);
  highp vec4 tmpvar_98;
  tmpvar_98 = (((
    (x_97 * x_97)
   * 34.0) + x_97) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_99;
  tmpvar_99 = (fract(abs(tmpvar_98)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_100;
  if ((tmpvar_98.x >= 0.0)) {
    tmpvar_100 = tmpvar_99.x;
  } else {
    tmpvar_100 = -(tmpvar_99.x);
  };
  highp float tmpvar_101;
  if ((tmpvar_98.y >= 0.0)) {
    tmpvar_101 = tmpvar_99.y;
  } else {
    tmpvar_101 = -(tmpvar_99.y);
  };
  highp float tmpvar_102;
  if ((tmpvar_98.z >= 0.0)) {
    tmpvar_102 = tmpvar_99.z;
  } else {
    tmpvar_102 = -(tmpvar_99.z);
  };
  highp float tmpvar_103;
  if ((tmpvar_98.w >= 0.0)) {
    tmpvar_103 = tmpvar_99.w;
  } else {
    tmpvar_103 = -(tmpvar_99.w);
  };
  highp vec4 tmpvar_104;
  tmpvar_104.x = tmpvar_100;
  tmpvar_104.y = tmpvar_101;
  tmpvar_104.z = tmpvar_102;
  tmpvar_104.w = tmpvar_103;
  highp vec4 tmpvar_105;
  tmpvar_105.xw = vec2(0.0, 1.0);
  tmpvar_105.y = tmpvar_86.y;
  tmpvar_105.z = tmpvar_87.y;
  highp vec4 x_106;
  x_106 = ((tmpvar_104 + tmpvar_94) + tmpvar_105);
  highp vec4 tmpvar_107;
  tmpvar_107 = (((
    (x_106 * x_106)
   * 34.0) + x_106) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_108;
  tmpvar_108 = (fract(abs(tmpvar_107)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_109;
  if ((tmpvar_107.x >= 0.0)) {
    tmpvar_109 = tmpvar_108.x;
  } else {
    tmpvar_109 = -(tmpvar_108.x);
  };
  highp float tmpvar_110;
  if ((tmpvar_107.y >= 0.0)) {
    tmpvar_110 = tmpvar_108.y;
  } else {
    tmpvar_110 = -(tmpvar_108.y);
  };
  highp float tmpvar_111;
  if ((tmpvar_107.z >= 0.0)) {
    tmpvar_111 = tmpvar_108.z;
  } else {
    tmpvar_111 = -(tmpvar_108.z);
  };
  highp float tmpvar_112;
  if ((tmpvar_107.w >= 0.0)) {
    tmpvar_112 = tmpvar_108.w;
  } else {
    tmpvar_112 = -(tmpvar_108.w);
  };
  highp vec4 tmpvar_113;
  tmpvar_113.x = tmpvar_109;
  tmpvar_113.y = tmpvar_110;
  tmpvar_113.z = tmpvar_111;
  tmpvar_113.w = tmpvar_112;
  highp vec4 tmpvar_114;
  tmpvar_114.xw = vec2(0.0, 1.0);
  tmpvar_114.y = tmpvar_86.x;
  tmpvar_114.z = tmpvar_87.x;
  highp vec4 x_115;
  x_115 = ((tmpvar_113 + tmpvar_93) + tmpvar_114);
  highp vec4 tmpvar_116;
  tmpvar_116 = (((
    (x_115 * x_115)
   * 34.0) + x_115) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_117;
  tmpvar_117 = (fract(abs(tmpvar_116)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_118;
  if ((tmpvar_116.x >= 0.0)) {
    tmpvar_118 = tmpvar_117.x;
  } else {
    tmpvar_118 = -(tmpvar_117.x);
  };
  highp float tmpvar_119;
  if ((tmpvar_116.y >= 0.0)) {
    tmpvar_119 = tmpvar_117.y;
  } else {
    tmpvar_119 = -(tmpvar_117.y);
  };
  highp float tmpvar_120;
  if ((tmpvar_116.z >= 0.0)) {
    tmpvar_120 = tmpvar_117.z;
  } else {
    tmpvar_120 = -(tmpvar_117.z);
  };
  highp float tmpvar_121;
  if ((tmpvar_116.w >= 0.0)) {
    tmpvar_121 = tmpvar_117.w;
  } else {
    tmpvar_121 = -(tmpvar_117.w);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.x = tmpvar_118;
  tmpvar_122.y = tmpvar_119;
  tmpvar_122.z = tmpvar_120;
  tmpvar_122.w = tmpvar_121;
  highp vec4 tmpvar_123;
  tmpvar_123 = (tmpvar_122 - (49.0 * floor(
    (0.02040815 * tmpvar_122)
  )));
  highp vec4 tmpvar_124;
  tmpvar_124 = floor((tmpvar_123 * 0.1428571));
  highp vec4 tmpvar_125;
  tmpvar_125 = ((tmpvar_124 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_126;
  tmpvar_126 = ((floor(
    (tmpvar_123 - (7.0 * tmpvar_124))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_127;
  tmpvar_127 = ((1.0 - abs(tmpvar_125)) - abs(tmpvar_126));
  highp vec4 tmpvar_128;
  tmpvar_128.xy = tmpvar_125.xy;
  tmpvar_128.zw = tmpvar_126.xy;
  highp vec4 tmpvar_129;
  tmpvar_129.xy = tmpvar_125.zw;
  tmpvar_129.zw = tmpvar_126.zw;
  highp vec4 tmpvar_130;
  tmpvar_130 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_127)));
  highp vec4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_130.xxyy));
  highp vec4 tmpvar_132;
  tmpvar_132 = (tmpvar_129.xzyw + ((
    (floor(tmpvar_129) * 2.0)
   + 1.0).xzyw * tmpvar_130.zzww));
  highp vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_131.xy;
  tmpvar_133.z = tmpvar_127.x;
  highp vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.zw;
  tmpvar_134.z = tmpvar_127.y;
  highp vec3 tmpvar_135;
  tmpvar_135.xy = tmpvar_132.xy;
  tmpvar_135.z = tmpvar_127.z;
  highp vec3 tmpvar_136;
  tmpvar_136.xy = tmpvar_132.zw;
  tmpvar_136.z = tmpvar_127.w;
  highp vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_133, tmpvar_133);
  tmpvar_137.y = dot (tmpvar_134, tmpvar_134);
  tmpvar_137.z = dot (tmpvar_135, tmpvar_135);
  tmpvar_137.w = dot (tmpvar_136, tmpvar_136);
  highp vec4 tmpvar_138;
  tmpvar_138 = (1.792843 - (0.8537347 * tmpvar_137));
  highp vec4 tmpvar_139;
  tmpvar_139.x = dot (tmpvar_83, tmpvar_83);
  tmpvar_139.y = dot (tmpvar_88, tmpvar_88);
  tmpvar_139.z = dot (tmpvar_89, tmpvar_89);
  tmpvar_139.w = dot (tmpvar_90, tmpvar_90);
  highp vec4 tmpvar_140;
  tmpvar_140 = max ((0.6 - tmpvar_139), vec4(0.0, 0.0, 0.0, 0.0));
  m_81 = (tmpvar_140 * tmpvar_140);
  highp vec4 tmpvar_141;
  tmpvar_141.x = dot ((tmpvar_133 * tmpvar_138.x), tmpvar_83);
  tmpvar_141.y = dot ((tmpvar_134 * tmpvar_138.y), tmpvar_88);
  tmpvar_141.z = dot ((tmpvar_135 * tmpvar_138.z), tmpvar_89);
  tmpvar_141.w = dot ((tmpvar_136 * tmpvar_138.w), tmpvar_90);
  tmpvar_79 = (42.0 * dot ((m_81 * m_81), tmpvar_141));
  highp vec3 v_142;
  v_142 = (_NoiseScale.y * tmpvar_16);
  highp vec4 m_143;
  highp vec3 tmpvar_144;
  tmpvar_144 = floor((v_142 + dot (v_142, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_145;
  tmpvar_145 = ((v_142 - tmpvar_144) + dot (tmpvar_144, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_146;
  tmpvar_146.x = float((tmpvar_145.x >= tmpvar_145.y));
  tmpvar_146.y = float((tmpvar_145.y >= tmpvar_145.z));
  tmpvar_146.z = float((tmpvar_145.z >= tmpvar_145.x));
  highp vec3 tmpvar_147;
  tmpvar_147 = (1.0 - tmpvar_146);
  highp vec3 tmpvar_148;
  tmpvar_148 = min (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_149;
  tmpvar_149 = max (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_150;
  tmpvar_150 = ((tmpvar_145 - tmpvar_148) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_151;
  tmpvar_151 = ((tmpvar_145 - tmpvar_149) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_152;
  tmpvar_152 = (tmpvar_145 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_153;
  tmpvar_153 = (tmpvar_144 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_154;
  tmpvar_154 = (fract(abs(tmpvar_153)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_155;
  if ((tmpvar_153.x >= 0.0)) {
    tmpvar_155 = tmpvar_154.x;
  } else {
    tmpvar_155 = -(tmpvar_154.x);
  };
  highp float tmpvar_156;
  if ((tmpvar_153.y >= 0.0)) {
    tmpvar_156 = tmpvar_154.y;
  } else {
    tmpvar_156 = -(tmpvar_154.y);
  };
  highp float tmpvar_157;
  if ((tmpvar_153.z >= 0.0)) {
    tmpvar_157 = tmpvar_154.z;
  } else {
    tmpvar_157 = -(tmpvar_154.z);
  };
  highp vec4 tmpvar_158;
  tmpvar_158.xw = vec2(0.0, 1.0);
  tmpvar_158.y = tmpvar_148.z;
  tmpvar_158.z = tmpvar_149.z;
  highp vec4 x_159;
  x_159 = (tmpvar_157 + tmpvar_158);
  highp vec4 tmpvar_160;
  tmpvar_160 = (((
    (x_159 * x_159)
   * 34.0) + x_159) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_161;
  tmpvar_161 = (fract(abs(tmpvar_160)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_162;
  if ((tmpvar_160.x >= 0.0)) {
    tmpvar_162 = tmpvar_161.x;
  } else {
    tmpvar_162 = -(tmpvar_161.x);
  };
  highp float tmpvar_163;
  if ((tmpvar_160.y >= 0.0)) {
    tmpvar_163 = tmpvar_161.y;
  } else {
    tmpvar_163 = -(tmpvar_161.y);
  };
  highp float tmpvar_164;
  if ((tmpvar_160.z >= 0.0)) {
    tmpvar_164 = tmpvar_161.z;
  } else {
    tmpvar_164 = -(tmpvar_161.z);
  };
  highp float tmpvar_165;
  if ((tmpvar_160.w >= 0.0)) {
    tmpvar_165 = tmpvar_161.w;
  } else {
    tmpvar_165 = -(tmpvar_161.w);
  };
  highp vec4 tmpvar_166;
  tmpvar_166.x = tmpvar_162;
  tmpvar_166.y = tmpvar_163;
  tmpvar_166.z = tmpvar_164;
  tmpvar_166.w = tmpvar_165;
  highp vec4 tmpvar_167;
  tmpvar_167.xw = vec2(0.0, 1.0);
  tmpvar_167.y = tmpvar_148.y;
  tmpvar_167.z = tmpvar_149.y;
  highp vec4 x_168;
  x_168 = ((tmpvar_166 + tmpvar_156) + tmpvar_167);
  highp vec4 tmpvar_169;
  tmpvar_169 = (((
    (x_168 * x_168)
   * 34.0) + x_168) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_170;
  tmpvar_170 = (fract(abs(tmpvar_169)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_171;
  if ((tmpvar_169.x >= 0.0)) {
    tmpvar_171 = tmpvar_170.x;
  } else {
    tmpvar_171 = -(tmpvar_170.x);
  };
  highp float tmpvar_172;
  if ((tmpvar_169.y >= 0.0)) {
    tmpvar_172 = tmpvar_170.y;
  } else {
    tmpvar_172 = -(tmpvar_170.y);
  };
  highp float tmpvar_173;
  if ((tmpvar_169.z >= 0.0)) {
    tmpvar_173 = tmpvar_170.z;
  } else {
    tmpvar_173 = -(tmpvar_170.z);
  };
  highp float tmpvar_174;
  if ((tmpvar_169.w >= 0.0)) {
    tmpvar_174 = tmpvar_170.w;
  } else {
    tmpvar_174 = -(tmpvar_170.w);
  };
  highp vec4 tmpvar_175;
  tmpvar_175.x = tmpvar_171;
  tmpvar_175.y = tmpvar_172;
  tmpvar_175.z = tmpvar_173;
  tmpvar_175.w = tmpvar_174;
  highp vec4 tmpvar_176;
  tmpvar_176.xw = vec2(0.0, 1.0);
  tmpvar_176.y = tmpvar_148.x;
  tmpvar_176.z = tmpvar_149.x;
  highp vec4 x_177;
  x_177 = ((tmpvar_175 + tmpvar_155) + tmpvar_176);
  highp vec4 tmpvar_178;
  tmpvar_178 = (((
    (x_177 * x_177)
   * 34.0) + x_177) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_179;
  tmpvar_179 = (fract(abs(tmpvar_178)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_180;
  if ((tmpvar_178.x >= 0.0)) {
    tmpvar_180 = tmpvar_179.x;
  } else {
    tmpvar_180 = -(tmpvar_179.x);
  };
  highp float tmpvar_181;
  if ((tmpvar_178.y >= 0.0)) {
    tmpvar_181 = tmpvar_179.y;
  } else {
    tmpvar_181 = -(tmpvar_179.y);
  };
  highp float tmpvar_182;
  if ((tmpvar_178.z >= 0.0)) {
    tmpvar_182 = tmpvar_179.z;
  } else {
    tmpvar_182 = -(tmpvar_179.z);
  };
  highp float tmpvar_183;
  if ((tmpvar_178.w >= 0.0)) {
    tmpvar_183 = tmpvar_179.w;
  } else {
    tmpvar_183 = -(tmpvar_179.w);
  };
  highp vec4 tmpvar_184;
  tmpvar_184.x = tmpvar_180;
  tmpvar_184.y = tmpvar_181;
  tmpvar_184.z = tmpvar_182;
  tmpvar_184.w = tmpvar_183;
  highp vec4 tmpvar_185;
  tmpvar_185 = (tmpvar_184 - (49.0 * floor(
    (0.02040815 * tmpvar_184)
  )));
  highp vec4 tmpvar_186;
  tmpvar_186 = floor((tmpvar_185 * 0.1428571));
  highp vec4 tmpvar_187;
  tmpvar_187 = ((tmpvar_186 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_188;
  tmpvar_188 = ((floor(
    (tmpvar_185 - (7.0 * tmpvar_186))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_189;
  tmpvar_189 = ((1.0 - abs(tmpvar_187)) - abs(tmpvar_188));
  highp vec4 tmpvar_190;
  tmpvar_190.xy = tmpvar_187.xy;
  tmpvar_190.zw = tmpvar_188.xy;
  highp vec4 tmpvar_191;
  tmpvar_191.xy = tmpvar_187.zw;
  tmpvar_191.zw = tmpvar_188.zw;
  highp vec4 tmpvar_192;
  tmpvar_192 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_189)));
  highp vec4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_192.xxyy));
  highp vec4 tmpvar_194;
  tmpvar_194 = (tmpvar_191.xzyw + ((
    (floor(tmpvar_191) * 2.0)
   + 1.0).xzyw * tmpvar_192.zzww));
  highp vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_193.xy;
  tmpvar_195.z = tmpvar_189.x;
  highp vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.zw;
  tmpvar_196.z = tmpvar_189.y;
  highp vec3 tmpvar_197;
  tmpvar_197.xy = tmpvar_194.xy;
  tmpvar_197.z = tmpvar_189.z;
  highp vec3 tmpvar_198;
  tmpvar_198.xy = tmpvar_194.zw;
  tmpvar_198.z = tmpvar_189.w;
  highp vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_195, tmpvar_195);
  tmpvar_199.y = dot (tmpvar_196, tmpvar_196);
  tmpvar_199.z = dot (tmpvar_197, tmpvar_197);
  tmpvar_199.w = dot (tmpvar_198, tmpvar_198);
  highp vec4 tmpvar_200;
  tmpvar_200 = (1.792843 - (0.8537347 * tmpvar_199));
  highp vec4 tmpvar_201;
  tmpvar_201.x = dot (tmpvar_145, tmpvar_145);
  tmpvar_201.y = dot (tmpvar_150, tmpvar_150);
  tmpvar_201.z = dot (tmpvar_151, tmpvar_151);
  tmpvar_201.w = dot (tmpvar_152, tmpvar_152);
  highp vec4 tmpvar_202;
  tmpvar_202 = max ((0.6 - tmpvar_201), vec4(0.0, 0.0, 0.0, 0.0));
  m_143 = (tmpvar_202 * tmpvar_202);
  highp vec4 tmpvar_203;
  tmpvar_203.x = dot ((tmpvar_195 * tmpvar_200.x), tmpvar_145);
  tmpvar_203.y = dot ((tmpvar_196 * tmpvar_200.y), tmpvar_150);
  tmpvar_203.z = dot ((tmpvar_197 * tmpvar_200.z), tmpvar_151);
  tmpvar_203.w = dot ((tmpvar_198 * tmpvar_200.w), tmpvar_152);
  highp vec3 tmpvar_204;
  tmpvar_204.x = tmpvar_17;
  tmpvar_204.y = tmpvar_79;
  tmpvar_204.z = (42.0 * dot ((m_143 * m_143), tmpvar_203));
  highp vec3 tmpvar_205;
  tmpvar_205 = (0.5 * (tmpvar_204 + 1.0));
  localOrigin_7.xyz = (((2.0 * tmpvar_205) - 1.0) * _MaxTrans);
  localOrigin_7.w = 1.0;
  highp float tmpvar_206;
  tmpvar_206 = ((tmpvar_205.x * (_MaxScale - 1.0)) + 1.0);
  origin_9 = (_Object2World * localOrigin_7);
  planet_pos_8 = (_MainRotation * origin_9);
  highp vec3 tmpvar_207;
  tmpvar_207 = (_DetailRotation * planet_pos_8).xyz;
  tmpvar_13 = planet_pos_8.xyz;
  highp vec3 tmpvar_208;
  tmpvar_208 = normalize(planet_pos_8.xyz);
  highp vec2 uv_209;
  highp float tmpvar_210;
  highp float tmpvar_211;
  tmpvar_211 = (min (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0) / max (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0));
  highp float tmpvar_212;
  tmpvar_212 = (tmpvar_211 * tmpvar_211);
  tmpvar_212 = (((
    ((((
      ((((-0.01213232 * tmpvar_212) + 0.05368138) * tmpvar_212) - 0.1173503)
     * tmpvar_212) + 0.1938925) * tmpvar_212) - 0.3326756)
   * tmpvar_212) + 0.9999793) * tmpvar_211);
  tmpvar_212 = (tmpvar_212 + (float(
    (abs((tmpvar_208.x / tmpvar_208.z)) > 1.0)
  ) * (
    (tmpvar_212 * -2.0)
   + 1.570796)));
  tmpvar_210 = (tmpvar_212 * sign((tmpvar_208.x / tmpvar_208.z)));
  if ((abs(tmpvar_208.z) > (1e-08 * abs(tmpvar_208.x)))) {
    if ((tmpvar_208.z < 0.0)) {
      if ((tmpvar_208.x >= 0.0)) {
        tmpvar_210 += 3.141593;
      } else {
        tmpvar_210 = (tmpvar_210 - 3.141593);
      };
    };
  } else {
    tmpvar_210 = (sign(tmpvar_208.x) * 1.570796);
  };
  uv_209.x = (0.5 + (0.1591549 * tmpvar_210));
  uv_209.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_208.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_208.y)
    )) * (1.570796 + (
      abs(tmpvar_208.y)
     * 
      (-0.2146018 + (abs(tmpvar_208.y) * (0.08656672 + (
        abs(tmpvar_208.y)
       * -0.03102955))))
    ))))
  )));
  lowp vec4 tmpvar_213;
  tmpvar_213 = texture2DLod (_MainTex, uv_209, 0.0);
  mediump vec4 tmpvar_214;
  tmpvar_214 = tmpvar_213;
  tmpvar_10 = tmpvar_214;
  mediump vec3 detailCoords_215;
  mediump float s_216;
  mediump float nylerp_217;
  mediump float zxlerp_218;
  highp vec4 uv4_219;
  uv4_219.zw = vec2(0.0, 0.0);
  highp vec3 tmpvar_220;
  tmpvar_220 = normalize(tmpvar_207);
  highp vec3 tmpvar_221;
  tmpvar_221 = abs(tmpvar_220);
  highp float tmpvar_222;
  tmpvar_222 = float((tmpvar_221.z >= tmpvar_221.x));
  zxlerp_218 = tmpvar_222;
  highp float tmpvar_223;
  tmpvar_223 = float((max (tmpvar_221.x, tmpvar_221.z) >= tmpvar_221.y));
  nylerp_217 = tmpvar_223;
  highp float tmpvar_224;
  tmpvar_224 = mix (tmpvar_220.x, tmpvar_220.z, zxlerp_218);
  s_216 = tmpvar_224;
  highp float tmpvar_225;
  tmpvar_225 = sign(mix (tmpvar_220.y, s_216, nylerp_217));
  s_216 = tmpvar_225;
  mediump vec3 tmpvar_226;
  tmpvar_226.xz = vec2(1.0, -1.0);
  tmpvar_226.y = -(s_216);
  mediump vec3 tmpvar_227;
  tmpvar_227.xz = vec2(1.0, -1.0);
  tmpvar_227.y = s_216;
  highp vec3 tmpvar_228;
  tmpvar_228 = mix ((tmpvar_226 * tmpvar_220.xzy), (tmpvar_227 * tmpvar_220.zxy), vec3(zxlerp_218));
  detailCoords_215 = tmpvar_228;
  mediump vec3 tmpvar_229;
  tmpvar_229.xy = vec2(1.0, 1.0);
  tmpvar_229.z = s_216;
  highp vec3 tmpvar_230;
  tmpvar_230 = mix ((tmpvar_229 * tmpvar_220.yxz), detailCoords_215, vec3(nylerp_217));
  detailCoords_215 = tmpvar_230;
  mediump vec2 tmpvar_231;
  tmpvar_231 = (((0.5 * detailCoords_215.yz) / abs(detailCoords_215.x)) + 0.5);
  uv4_219.xy = tmpvar_231;
  lowp vec4 tmpvar_232;
  tmpvar_232 = texture2DLod (_DetailTex, uv4_219.xy, 0.0);
  mediump vec4 tmpvar_233;
  tmpvar_233 = tmpvar_232;
  tmpvar_10 = (tmpvar_10 * tmpvar_233);
  highp vec4 tmpvar_234;
  tmpvar_234.w = 0.0;
  tmpvar_234.xyz = _WorldSpaceCameraPos;
  highp float tmpvar_235;
  highp vec4 tmpvar_236;
  tmpvar_236 = (origin_9 - tmpvar_234);
  tmpvar_235 = sqrt(dot (tmpvar_236, tmpvar_236));
  highp float tmpvar_237;
  tmpvar_237 = (clamp ((_DistFade * tmpvar_235), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_235)
  ), 0.0, 1.0));
  tmpvar_11.w = tmpvar_237;
  tmpvar_10.w = (tmpvar_10.w * tmpvar_11.w);
  highp vec3 tmpvar_238;
  tmpvar_238.yz = vec2(0.0, 0.0);
  tmpvar_238.x = fract(_Rotation);
  highp vec3 x_239;
  x_239 = (tmpvar_238 + tmpvar_205);
  highp vec3 trans_240;
  trans_240 = localOrigin_7.xyz;
  highp float tmpvar_241;
  tmpvar_241 = (x_239.x * 6.283185);
  highp float tmpvar_242;
  tmpvar_242 = (x_239.y * 6.283185);
  highp float tmpvar_243;
  tmpvar_243 = (x_239.z * 2.0);
  highp float tmpvar_244;
  tmpvar_244 = sqrt(tmpvar_243);
  highp float tmpvar_245;
  tmpvar_245 = (sin(tmpvar_242) * tmpvar_244);
  highp float tmpvar_246;
  tmpvar_246 = (cos(tmpvar_242) * tmpvar_244);
  highp float tmpvar_247;
  tmpvar_247 = sqrt((2.0 - tmpvar_243));
  highp float tmpvar_248;
  tmpvar_248 = sin(tmpvar_241);
  highp float tmpvar_249;
  tmpvar_249 = cos(tmpvar_241);
  highp float tmpvar_250;
  tmpvar_250 = ((tmpvar_245 * tmpvar_249) - (tmpvar_246 * tmpvar_248));
  highp float tmpvar_251;
  tmpvar_251 = ((tmpvar_245 * tmpvar_248) + (tmpvar_246 * tmpvar_249));
  highp mat4 tmpvar_252;
  tmpvar_252[0].x = (tmpvar_206 * ((tmpvar_245 * tmpvar_250) - tmpvar_249));
  tmpvar_252[0].y = ((tmpvar_245 * tmpvar_251) - tmpvar_248);
  tmpvar_252[0].z = (tmpvar_245 * tmpvar_247);
  tmpvar_252[0].w = 0.0;
  tmpvar_252[1].x = ((tmpvar_246 * tmpvar_250) + tmpvar_248);
  tmpvar_252[1].y = (tmpvar_206 * ((tmpvar_246 * tmpvar_251) - tmpvar_249));
  tmpvar_252[1].z = (tmpvar_246 * tmpvar_247);
  tmpvar_252[1].w = 0.0;
  tmpvar_252[2].x = (tmpvar_247 * tmpvar_250);
  tmpvar_252[2].y = (tmpvar_247 * tmpvar_251);
  tmpvar_252[2].z = (tmpvar_206 * (1.0 - tmpvar_243));
  tmpvar_252[2].w = 0.0;
  tmpvar_252[3].x = trans_240.x;
  tmpvar_252[3].y = trans_240.y;
  tmpvar_252[3].z = trans_240.z;
  tmpvar_252[3].w = 1.0;
  highp mat4 tmpvar_253;
  tmpvar_253 = ((unity_MatrixV * _Object2World) * tmpvar_252);
  highp vec4 v_254;
  v_254.x = tmpvar_253[0].z;
  v_254.y = tmpvar_253[1].z;
  v_254.z = tmpvar_253[2].z;
  v_254.w = tmpvar_253[3].z;
  highp vec3 tmpvar_255;
  tmpvar_255 = normalize(v_254.xyz);
  highp vec3 tmpvar_256;
  tmpvar_256 = abs(tmpvar_255);
  tmpvar_11.xyz = tmpvar_256;
  highp vec4 tmpvar_257;
  tmpvar_257 = (glstate_matrix_modelview0 * localOrigin_7);
  highp vec4 tmpvar_258;
  tmpvar_258.xyz = (_glesVertex.xyz * tmpvar_206);
  tmpvar_258.w = tmpvar_1.w;
  highp vec2 tmpvar_259;
  tmpvar_259 = ((2.0 * _glesMultiTexCoord0.xy) - 1.0);
  highp vec4 tmpvar_260;
  tmpvar_260.z = 0.0;
  tmpvar_260.xy = tmpvar_259;
  tmpvar_260.w = tmpvar_1.w;
  ZYv_6.xyw = tmpvar_260.zyw;
  XZv_5.yzw = tmpvar_260.zyw;
  XYv_4.yzw = tmpvar_260.yzw;
  ZYv_6.z = (tmpvar_259.x * sign(-(tmpvar_255.x)));
  XZv_5.x = (tmpvar_259.x * sign(-(tmpvar_255.y)));
  XYv_4.x = (tmpvar_259.x * sign(tmpvar_255.z));
  ZYv_6.x = ((sign(
    -(tmpvar_255.x)
  ) * sign(ZYv_6.z)) * tmpvar_255.z);
  XZv_5.y = ((sign(
    -(tmpvar_255.y)
  ) * sign(XZv_5.x)) * tmpvar_255.x);
  XYv_4.z = ((sign(
    -(tmpvar_255.z)
  ) * sign(XYv_4.x)) * tmpvar_255.x);
  ZYv_6.x = (ZYv_6.x + ((
    sign(-(tmpvar_255.x))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  XZv_5.y = (XZv_5.y + ((
    sign(-(tmpvar_255.y))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.z));
  XYv_4.z = (XYv_4.z + ((
    sign(-(tmpvar_255.z))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  highp vec3 tmpvar_261;
  tmpvar_261 = normalize((origin_9.xyz - _WorldSpaceCameraPos));
  highp vec3 tmpvar_262;
  tmpvar_262 = normalize(-(tmpvar_261));
  normal_3 = tmpvar_262;
  highp vec4 v_263;
  v_263.x = unity_MatrixV[0].x;
  v_263.y = unity_MatrixV[1].x;
  v_263.z = unity_MatrixV[2].x;
  v_263.w = unity_MatrixV[3].x;
  highp vec3 tmpvar_264;
  tmpvar_264 = normalize(v_263.xyz);
  highp vec3 tmpvar_265;
  highp vec3 tmpvar_266;
  tmpvar_265 = v_263.xyz;
  tmpvar_266 = ((normal_3.zxy * tmpvar_264.yzx) - (normal_3.yzx * tmpvar_264.zxy));
  highp vec3 tmpvar_267;
  tmpvar_267 = normal_3;
  highp mat3 tmpvar_268;
  tmpvar_268[0].x = tmpvar_265.x;
  tmpvar_268[0].y = tmpvar_266.x;
  tmpvar_268[0].z = tmpvar_267.x;
  tmpvar_268[1].x = tmpvar_265.y;
  tmpvar_268[1].y = tmpvar_266.y;
  tmpvar_268[1].z = tmpvar_267.y;
  tmpvar_268[2].x = tmpvar_265.z;
  tmpvar_268[2].y = tmpvar_266.z;
  tmpvar_268[2].z = tmpvar_267.z;
  gl_Position = (glstate_matrix_projection * (tmpvar_257 + tmpvar_258));
  xlv_COLOR = tmpvar_10;
  xlv_TEXCOORD0 = tmpvar_11;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * ZYv_6)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XZv_5)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XYv_4)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD4 = tmpvar_2;
  xlv_TEXCOORD5 = tmpvar_12;
  xlv_TEXCOORD6 = tmpvar_13;
  xlv_TEXCOORD7 = normalize((tmpvar_268 * tmpvar_261));
  xlv_TEXCOORD8 = normalize((tmpvar_268 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform lowp vec4 _LightColor0;
uniform sampler2D _Tex;
uniform lowp vec4 _Color;
uniform highp float _MinScatter;
uniform highp float _Opacity;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec3 normT_2;
  mediump vec4 color_3;
  mediump vec4 tex_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_Tex, xlv_TEXCOORD1);
  tex_4.x = tmpvar_5.x;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex, xlv_TEXCOORD2);
  tex_4.y = tmpvar_6.y;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex, xlv_TEXCOORD3);
  tex_4.z = tmpvar_7.z;
  tex_4.w = 0.0;
  tex_4.xyz = (tex_4.xyz * xlv_TEXCOORD0.xyz);
  tex_4 = (tex_4 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  mediump float tmpvar_8;
  tmpvar_8 = ((tex_4.x + tex_4.y) + (tex_4.z + tex_4.w));
  mediump vec4 tmpvar_9;
  tmpvar_9.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_9.w = tmpvar_8;
  tex_4.xyz = tmpvar_9.xyz;
  color_3 = (_Color * xlv_COLOR);
  normT_2.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_2.z = sqrt((1.0 - clamp (
    dot (normT_2.xy, normT_2.xy)
  , 0.0, 1.0)));
  color_3.w = (color_3.w * tmpvar_8);
  tex_4.w = (xlv_TEXCOORD0.w * tmpvar_8);
  mediump vec3 lightDir_10;
  lightDir_10 = xlv_TEXCOORD8;
  mediump vec3 viewDir_11;
  viewDir_11 = xlv_TEXCOORD7;
  mediump vec4 c_12;
  highp float h_13;
  mediump vec3 tmpvar_14;
  tmpvar_14 = normalize(lightDir_10);
  lightDir_10 = tmpvar_14;
  mediump vec3 tmpvar_15;
  tmpvar_15 = normalize(viewDir_11);
  viewDir_11 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16 = normalize(normT_2);
  mediump float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_16, tmpvar_14), 0.0);
  mediump float tmpvar_18;
  tmpvar_18 = (0.5 + (0.5 * dot (tmpvar_15, tmpvar_14)));
  h_13 = tmpvar_18;
  mediump float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, tmpvar_15);
  highp float tmpvar_20;
  tmpvar_20 = clamp (((
    (_MinScatter - (_Opacity * tex_4.w))
   * 
    (1.0 - tmpvar_19)
  ) * h_13), 0.0, 1.0);
  c_12.xyz = ((_LightColor0.xyz * (vec3(tmpvar_17) + tmpvar_20)) * 2.0);
  c_12.w = (tmpvar_17 * 2.0);
  color_3.xyz = (color_3.xyz * c_12.xyz);
  tmpvar_1 = color_3;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 in_POSITION0;
in  vec2 in_TEXCOORD0;
out vec4 vs_COLOR0;
out vec4 vs_TEXCOORD0;
out vec2 vs_TEXCOORD1;
out vec2 vs_TEXCOORD2;
out vec2 vs_TEXCOORD3;
out vec2 vs_TEXCOORD4;
out vec4 vs_TEXCOORD5;
out vec3 vs_TEXCOORD6;
out vec3 vs_TEXCOORD7;
out vec3 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
bvec4 tb1;
vec4 t2;
vec4 t3;
bvec3 tb3;
vec4 t4;
bvec4 tb4;
vec4 t5;
bvec4 tb5;
vec4 t6;
ivec3 ti6;
bvec3 tb6;
vec4 t7;
ivec3 ti7;
bvec4 tb7;
vec4 t8;
vec4 t9;
bvec4 tb9;
vec4 t10;
bvec4 tb10;
vec4 t11;
bvec4 tb11;
vec4 t12;
vec4 t13;
float t15;
vec3 t18;
ivec3 ti18;
vec3 t20;
vec2 t28;
int ti28;
vec2 t29;
int ti29;
vec2 t31;
ivec2 ti31;
bvec2 tb31;
float t42;
int ti42;
float t43;
int ti43;
bool tb43;
float t44;
int ti44;
bool tb44;
float t45;
int ti45;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t44 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t44);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t44 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t44) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t42 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t42);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t42 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t42) + t6.xyz;
    t42 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t42);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t42 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t42) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t42 = dot(t1, t6);
    t0.x = t42 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t42 = t1.x * 0.5;
    t43 = _MaxScale + -1.0;
    t42 = t42 * t43 + 1.0;
    t2.xyz = vec3(t42) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t43 = dot(t5.xyz, t5.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t5.xyz;
    t44 = t5.z * t43 + (-t6.y);
    tb31.x = abs(t6.z)>=abs(t6.y);
    t31.x = tb31.x ? 1.0 : float(0.0);
    t44 = t31.x * t44 + t6.y;
    t43 = (-t5.x) * t43 + t44;
    t44 = max(abs(t6.z), abs(t6.y));
    tb44 = t44>=abs(t6.x);
    t44 = tb44 ? 1.0 : float(0.0);
    t43 = t44 * t43 + t6.x;
    ti45 = int((0.0<t43) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t43<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti43 = (-ti45) + ti43;
    t5.y = float(ti43);
    t7.y = (-t5.y);
    t7.xz = vec2(1.0, -1.0);
    t7.xyz = t6.yzx * t7.xyz;
    t5.xz = vec2(1.0, -1.0);
    t8.xyz = t5.xyz * t6.zyx + (-t7.xyz);
    t7.xyz = t31.xxx * t8.xyz + t7.xyz;
    t7.xyz = (-t5.xxy) * t6.xyz + t7.xyz;
    t5.xyz = t6.xyz * t5.xxy;
    t5.xyz = vec3(t44) * t7.xyz + t5.xyz;
    t31.xy = t5.yz * vec2(0.5, 0.5);
    t31.xy = t31.xy / abs(t5.xx);
    t31.xy = t31.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t31.xy, 0.0);
    t43 = dot(t4.xyz, t4.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb43 = abs(t6.y)<abs(t6.x);
    t44 = max(abs(t6.y), abs(t6.x));
    t44 = float(1.0) / t44;
    t31.x = min(abs(t6.y), abs(t6.x));
    t44 = t44 * t31.x;
    t31.x = t44 * t44;
    t45 = t31.x * 0.0208350997 + -0.0851330012;
    t45 = t31.x * t45 + 0.180141002;
    t45 = t31.x * t45 + -0.330299497;
    t31.x = t31.x * t45 + 0.999866009;
    t45 = t44 * t31.x;
    t45 = t45 * -2.0 + 1.57079637;
    t43 = tb43 ? t45 : float(0.0);
    t43 = t44 * t31.x + t43;
    tb31.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t44 = tb31.x ? -3.14159274 : float(0.0);
    t43 = t43 + t44;
    t44 = min(t6.y, t6.x);
    tb44 = t44<(-t44);
    t31.x = max(t6.y, t6.x);
    tb31.x = t31.x>=(-t31.x);
    ti44 = int(uint(tb44) * 0xffffffffu & uint(tb31.x) * 0xffffffffu);
    t43 = (ti44 != 0) ? (-t43) : t43;
    t4.x = t43 * 0.159154937 + 0.5;
    t43 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t43 = t43 * abs(t6.z) + -0.212114394;
    t43 = t43 * abs(t6.z) + 1.57072878;
    t44 = -abs(t6.z) + 1.0;
    t44 = sqrt(t44);
    t31.x = t43 * t44;
    t31.x = t31.x * -2.0 + 3.14159274;
    t31.x = tb31.y ? t31.x : float(0.0);
    t43 = t43 * t44 + t31.x;
    t4.y = t43 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t4 = t5 * t4;
    vs_COLOR0.xyz = t4.xyz;
    t43 = dot(t2.xyz, t2.xyz);
    t44 = sqrt(t43);
    t43 = inversesqrt(t43);
    t2.xyz = vec3(t43) * t2.xyz;
    t43 = t44 * _DistFade;
    t44 = (-_DistFadeVert) * t44 + 1.0;
    t44 = clamp(t44, 0.0, 1.0);
    t43 = t43;
    t43 = clamp(t43, 0.0, 1.0);
    t43 = t44 * t43;
    vs_COLOR0.w = t43 * t4.w;
    vs_TEXCOORD0.w = t43;
    t4.x = fract(_Rotation);
    t4.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t4.xyz;
    t31.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t31.x);
    t44 = t42 * t31.y;
    t29.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t29.x = sqrt(t29.x);
    t4.x = sin(t1.y);
    t5.x = cos(t1.y);
    t6.x = cos(t1.x);
    t1.x = sin(t1.x);
    t15 = t29.x * t5.x;
    t29.x = t29.x * t4.x;
    t31.xy = t1.wx * vec2(t15);
    t45 = t29.x * t6.x + (-t31.y);
    t4.x = t15 * t45 + t1.x;
    t18.x = t6.x * t15;
    t18.x = t29.x * t1.x + t18.x;
    t15 = t15 * t18.x + (-t6.x);
    t15 = t42 * t15;
    t5.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t5.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t5.xyz;
    t5.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t5.xyz;
    t5.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t5.xyz;
    t20.xyz = vec3(t15) * t5.xyz;
    t7.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t7.xyz;
    t4.xzw = t7.xyz * t4.xxx + t20.xyz;
    t20.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t20.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t20.xyz;
    t20.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t20.xyz;
    t20.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t20.xyz;
    t4.xzw = t20.xyz * t31.xxx + t4.xzw;
    t8.y = t4.w;
    t15 = t29.x * t45 + (-t6.x);
    t1.x = t29.x * t18.x + (-t1.x);
    t29.x = t1.w * t29.x;
    t31.x = t1.w * t18.x;
    t43 = t1.w * t45;
    t9.xyz = t31.xxx * t5.xyz;
    t9.xyz = t7.xyz * vec3(t43) + t9.xyz;
    t9.xyz = t20.xyz * vec3(t44) + t9.xyz;
    t10.xyz = t1.xxx * t5.xyz;
    t1.xw = t0.yy * t5.xy;
    t0.xy = t7.xy * t0.xx + t1.xw;
    t0.xy = t20.xy * t0.zz + t0.xy;
    t28.x = t42 * t15;
    t1.xyw = t7.xyz * t28.xxx + t10.xyz;
    t1.xyz = t20.xyz * t29.xxx + t1.xyw;
    t8.x = t1.z;
    t8.z = t9.z;
    t28.x = dot(t8.xyz, t8.xyz);
    t28.x = inversesqrt(t28.x);
    t5.xyz = t28.xxx * t8.xyz;
    vs_TEXCOORD0.xyz = abs(t5.xyz);
    t28.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t28.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t28.xy;
    t28.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t28.xy;
    t28.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t28.xy;
    t0.xy = t28.xy + t0.xy;
    ti6.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t5.xyzx)).xyz) * 0xFFFFFFFFu);
    ti7.xyz = ivec3(uvec3(lessThan((-t5.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti6.xyz = (-ti6.xyz) + ti7.xyz;
    t28.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti29 = int((0.0<t28.y) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t28.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti29 = (-ti29) + ti43;
    ti7.xyz = ivec3(ti29) * ti6.xyz;
    t7.xyz = vec3(ti7.xyz);
    t7.xyz = t5.yzy * t7.xyz;
    t29.xy = vec2(ti6.xy);
    t29.xy = t28.xx * t29.xy;
    ti31.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t29.xyxy).xy) * 0xFFFFFFFFu);
    ti18.xz = ivec2(uvec2(lessThan(t29.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti31.xy = (-ti31.xy) + ti18.xz;
    ti31.xy = ti31.xy * ti6.xy;
    t31.xy = vec2(ti31.xy);
    t31.xy = t31.xy * t5.zx + t7.xy;
    t18.xz = t31.yy * t4.xz;
    t4.xz = t28.yy * t4.xz;
    t31.xy = t1.xy * t31.xx + t4.xz;
    t31.xy = t9.xy * t29.xx + t31.xy;
    t29.xy = t1.xy * t29.yy + t18.xz;
    t29.xy = t9.xy * t28.yy + t29.xy;
    t29.xy = t0.xy * in_POSITION0.ww + t29.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD2.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t29.xy = t0.xy * in_POSITION0.ww + t31.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD1.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti42 = int((0.0<t5.z) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t5.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti42 = (-ti42) + ti29;
    t42 = float(ti42);
    t28.x = t42 * t28.x;
    ti42 = int((0.0<t28.x) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t28.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t28.xx + t4.xz;
    ti28 = (-ti42) + ti29;
    ti28 = ti28 * ti6.z;
    t28.x = float(ti28);
    t28.x = t28.x * t5.x + t7.z;
    t28.xy = t9.xy * t28.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t28.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t42 = dot(t3.xyz, t3.xyz);
    t42 = inversesqrt(t42);
    t4.xyz = vec3(t42) * t3.yzx;
    t5.xyz = t0.zxy * t4.xyz;
    t4.xyz = t0.yzx * t4.yzx + (-t5.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t4.xyz), t2.xyz);
    t0.y = dot((-t4.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t42 = dot(t1.xyz, t1.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD7.xyz = vec3(t42) * t1.xyz;
    t42 = dot(t0.xyz, t0.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD8.xyz = vec3(t42) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _Tex;
in  vec4 vs_COLOR0;
in  vec4 vs_TEXCOORD0;
in  vec2 vs_TEXCOORD1;
in  vec2 vs_TEXCOORD2;
in  vec2 vs_TEXCOORD3;
in  vec2 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD7;
in  vec3 vs_TEXCOORD8;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
vec3 t3;
vec3 t4;
vec2 t8;
float t12;
void main()
{
    t0 = texture(_Tex, vs_TEXCOORD1.xy);
    t10_1 = texture(_Tex, vs_TEXCOORD2.xy);
    t0.y = t10_1.y;
    t10_1 = texture(_Tex, vs_TEXCOORD3.xy);
    t0.z = t10_1.z;
    t0.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t12 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t12 = t12 + vs_TEXCOORD0.z;
    t0.xyz = t0.xyz / vec3(t12);
    t0.x = t0.y + t0.x;
    t0.x = t0.z + t0.x;
    t4.x = t0.x * vs_TEXCOORD0.w;
    t4.x = (-_Opacity) * t4.x + _MinScatter;
    t8.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t8.xy, t8.xy);
    t8.x = min(t8.x, 1.0);
    t8.x = (-t8.x) + 1.0;
    t1.z = sqrt(t8.x);
    t1.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t1.xyz, t1.xyz);
    t8.x = inversesqrt(t8.x);
    t1.xyz = t8.xxx * t1.xyz;
    t8.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t8.x = inversesqrt(t8.x);
    t2.xyz = t8.xxx * vs_TEXCOORD7.xyz;
    t8.x = dot(t1.xyz, t2.xyz);
    t8.x = (-t8.x) + 1.0;
    t4.x = t8.x * t4.x;
    t8.x = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t8.x = inversesqrt(t8.x);
    t3.xyz = t8.xxx * vs_TEXCOORD8.xyz;
    t8.x = dot(t2.xyz, t3.xyz);
    t12 = dot(t1.xyz, t3.xyz);
    t12 = max(t12, 0.0);
    t8.x = t8.x * 0.5 + 0.5;
    t4.x = t8.x * t4.x;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t4.x = t4.x + t12;
    t4.xyz = t4.xxx * _LightColor0.xyz;
    t0.yzw = t4.xyz + t4.xyz;
    t1 = vs_COLOR0 * _Color;
    SV_Target0 = t0.yzwx * t1;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _WorldSpaceLightPos0;

uniform mat4 _Object2World;

uniform mat4 unity_MatrixV;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform mat4 _PosRotation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _Rotation;
uniform float _MaxScale;
uniform vec4 _NoiseScale;
uniform vec3 _MaxTrans;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec4 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec2 tmpvar_1;
  tmpvar_1 = gl_MultiTexCoord0.xy;
  vec4 XYv_2;
  vec4 XZv_3;
  vec4 ZYv_4;
  vec4 localOrigin_5;
  vec4 planet_pos_6;
  vec4 origin_7;
  vec4 tmpvar_8;
  vec4 tmpvar_9;
  vec4 tmpvar_10;
  vec3 tmpvar_11;
  vec4 tmpvar_12;
  tmpvar_12 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_7 = tmpvar_12;
  vec4 tmpvar_13;
  tmpvar_13 = (_PosRotation * tmpvar_12);
  planet_pos_6 = tmpvar_13;
  vec3 tmpvar_14;
  tmpvar_14 = (_NoiseScale.z * tmpvar_13.xyz);
  float tmpvar_15;
  vec4 m_16;
  vec3 tmpvar_17;
  tmpvar_17 = floor((tmpvar_14 + dot (tmpvar_14, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_18;
  tmpvar_18 = ((tmpvar_14 - tmpvar_17) + dot (tmpvar_17, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_19;
  tmpvar_19.x = float((tmpvar_18.x >= tmpvar_18.y));
  tmpvar_19.y = float((tmpvar_18.y >= tmpvar_18.z));
  tmpvar_19.z = float((tmpvar_18.z >= tmpvar_18.x));
  vec3 tmpvar_20;
  tmpvar_20 = (1.0 - tmpvar_19);
  vec3 tmpvar_21;
  tmpvar_21 = min (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_22;
  tmpvar_22 = max (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_23;
  tmpvar_23 = ((tmpvar_18 - tmpvar_21) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_24;
  tmpvar_24 = ((tmpvar_18 - tmpvar_22) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_25;
  tmpvar_25 = (tmpvar_18 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_26;
  tmpvar_26 = (tmpvar_17 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_27;
  tmpvar_27 = (fract(abs(tmpvar_26)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_28;
  if ((tmpvar_26.x >= 0.0)) {
    tmpvar_28 = tmpvar_27.x;
  } else {
    tmpvar_28 = -(tmpvar_27.x);
  };
  float tmpvar_29;
  if ((tmpvar_26.y >= 0.0)) {
    tmpvar_29 = tmpvar_27.y;
  } else {
    tmpvar_29 = -(tmpvar_27.y);
  };
  float tmpvar_30;
  if ((tmpvar_26.z >= 0.0)) {
    tmpvar_30 = tmpvar_27.z;
  } else {
    tmpvar_30 = -(tmpvar_27.z);
  };
  vec4 tmpvar_31;
  tmpvar_31.xw = vec2(0.0, 1.0);
  tmpvar_31.y = tmpvar_21.z;
  tmpvar_31.z = tmpvar_22.z;
  vec4 x_32;
  x_32 = (tmpvar_30 + tmpvar_31);
  vec4 tmpvar_33;
  tmpvar_33 = (((
    (x_32 * x_32)
   * 34.0) + x_32) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_34;
  tmpvar_34 = (fract(abs(tmpvar_33)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_35;
  if ((tmpvar_33.x >= 0.0)) {
    tmpvar_35 = tmpvar_34.x;
  } else {
    tmpvar_35 = -(tmpvar_34.x);
  };
  float tmpvar_36;
  if ((tmpvar_33.y >= 0.0)) {
    tmpvar_36 = tmpvar_34.y;
  } else {
    tmpvar_36 = -(tmpvar_34.y);
  };
  float tmpvar_37;
  if ((tmpvar_33.z >= 0.0)) {
    tmpvar_37 = tmpvar_34.z;
  } else {
    tmpvar_37 = -(tmpvar_34.z);
  };
  float tmpvar_38;
  if ((tmpvar_33.w >= 0.0)) {
    tmpvar_38 = tmpvar_34.w;
  } else {
    tmpvar_38 = -(tmpvar_34.w);
  };
  vec4 tmpvar_39;
  tmpvar_39.x = tmpvar_35;
  tmpvar_39.y = tmpvar_36;
  tmpvar_39.z = tmpvar_37;
  tmpvar_39.w = tmpvar_38;
  vec4 tmpvar_40;
  tmpvar_40.xw = vec2(0.0, 1.0);
  tmpvar_40.y = tmpvar_21.y;
  tmpvar_40.z = tmpvar_22.y;
  vec4 x_41;
  x_41 = ((tmpvar_39 + tmpvar_29) + tmpvar_40);
  vec4 tmpvar_42;
  tmpvar_42 = (((
    (x_41 * x_41)
   * 34.0) + x_41) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_43;
  tmpvar_43 = (fract(abs(tmpvar_42)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_44;
  if ((tmpvar_42.x >= 0.0)) {
    tmpvar_44 = tmpvar_43.x;
  } else {
    tmpvar_44 = -(tmpvar_43.x);
  };
  float tmpvar_45;
  if ((tmpvar_42.y >= 0.0)) {
    tmpvar_45 = tmpvar_43.y;
  } else {
    tmpvar_45 = -(tmpvar_43.y);
  };
  float tmpvar_46;
  if ((tmpvar_42.z >= 0.0)) {
    tmpvar_46 = tmpvar_43.z;
  } else {
    tmpvar_46 = -(tmpvar_43.z);
  };
  float tmpvar_47;
  if ((tmpvar_42.w >= 0.0)) {
    tmpvar_47 = tmpvar_43.w;
  } else {
    tmpvar_47 = -(tmpvar_43.w);
  };
  vec4 tmpvar_48;
  tmpvar_48.x = tmpvar_44;
  tmpvar_48.y = tmpvar_45;
  tmpvar_48.z = tmpvar_46;
  tmpvar_48.w = tmpvar_47;
  vec4 tmpvar_49;
  tmpvar_49.xw = vec2(0.0, 1.0);
  tmpvar_49.y = tmpvar_21.x;
  tmpvar_49.z = tmpvar_22.x;
  vec4 x_50;
  x_50 = ((tmpvar_48 + tmpvar_28) + tmpvar_49);
  vec4 tmpvar_51;
  tmpvar_51 = (((
    (x_50 * x_50)
   * 34.0) + x_50) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_52;
  tmpvar_52 = (fract(abs(tmpvar_51)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_53;
  if ((tmpvar_51.x >= 0.0)) {
    tmpvar_53 = tmpvar_52.x;
  } else {
    tmpvar_53 = -(tmpvar_52.x);
  };
  float tmpvar_54;
  if ((tmpvar_51.y >= 0.0)) {
    tmpvar_54 = tmpvar_52.y;
  } else {
    tmpvar_54 = -(tmpvar_52.y);
  };
  float tmpvar_55;
  if ((tmpvar_51.z >= 0.0)) {
    tmpvar_55 = tmpvar_52.z;
  } else {
    tmpvar_55 = -(tmpvar_52.z);
  };
  float tmpvar_56;
  if ((tmpvar_51.w >= 0.0)) {
    tmpvar_56 = tmpvar_52.w;
  } else {
    tmpvar_56 = -(tmpvar_52.w);
  };
  vec4 tmpvar_57;
  tmpvar_57.x = tmpvar_53;
  tmpvar_57.y = tmpvar_54;
  tmpvar_57.z = tmpvar_55;
  tmpvar_57.w = tmpvar_56;
  vec4 tmpvar_58;
  tmpvar_58 = (tmpvar_57 - (49.0 * floor(
    (0.02040815 * tmpvar_57)
  )));
  vec4 tmpvar_59;
  tmpvar_59 = floor((tmpvar_58 * 0.1428571));
  vec4 tmpvar_60;
  tmpvar_60 = ((tmpvar_59 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_61;
  tmpvar_61 = ((floor(
    (tmpvar_58 - (7.0 * tmpvar_59))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_62;
  tmpvar_62 = ((1.0 - abs(tmpvar_60)) - abs(tmpvar_61));
  vec4 tmpvar_63;
  tmpvar_63.xy = tmpvar_60.xy;
  tmpvar_63.zw = tmpvar_61.xy;
  vec4 tmpvar_64;
  tmpvar_64.xy = tmpvar_60.zw;
  tmpvar_64.zw = tmpvar_61.zw;
  vec4 tmpvar_65;
  tmpvar_65 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_62)));
  vec4 tmpvar_66;
  tmpvar_66 = (tmpvar_63.xzyw + ((
    (floor(tmpvar_63) * 2.0)
   + 1.0).xzyw * tmpvar_65.xxyy));
  vec4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_65.zzww));
  vec3 tmpvar_68;
  tmpvar_68.xy = tmpvar_66.xy;
  tmpvar_68.z = tmpvar_62.x;
  vec3 tmpvar_69;
  tmpvar_69.xy = tmpvar_66.zw;
  tmpvar_69.z = tmpvar_62.y;
  vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.xy;
  tmpvar_70.z = tmpvar_62.z;
  vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_67.zw;
  tmpvar_71.z = tmpvar_62.w;
  vec4 tmpvar_72;
  tmpvar_72.x = dot (tmpvar_68, tmpvar_68);
  tmpvar_72.y = dot (tmpvar_69, tmpvar_69);
  tmpvar_72.z = dot (tmpvar_70, tmpvar_70);
  tmpvar_72.w = dot (tmpvar_71, tmpvar_71);
  vec4 tmpvar_73;
  tmpvar_73 = (1.792843 - (0.8537347 * tmpvar_72));
  vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_18, tmpvar_18);
  tmpvar_74.y = dot (tmpvar_23, tmpvar_23);
  tmpvar_74.z = dot (tmpvar_24, tmpvar_24);
  tmpvar_74.w = dot (tmpvar_25, tmpvar_25);
  vec4 tmpvar_75;
  tmpvar_75 = max ((0.6 - tmpvar_74), vec4(0.0, 0.0, 0.0, 0.0));
  m_16 = (tmpvar_75 * tmpvar_75);
  vec4 tmpvar_76;
  tmpvar_76.x = dot ((tmpvar_68 * tmpvar_73.x), tmpvar_18);
  tmpvar_76.y = dot ((tmpvar_69 * tmpvar_73.y), tmpvar_23);
  tmpvar_76.z = dot ((tmpvar_70 * tmpvar_73.z), tmpvar_24);
  tmpvar_76.w = dot ((tmpvar_71 * tmpvar_73.w), tmpvar_25);
  tmpvar_15 = (42.0 * dot ((m_16 * m_16), tmpvar_76));
  float tmpvar_77;
  vec3 v_78;
  v_78 = (_NoiseScale.x * tmpvar_14);
  vec4 m_79;
  vec3 tmpvar_80;
  tmpvar_80 = floor((v_78 + dot (v_78, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_81;
  tmpvar_81 = ((v_78 - tmpvar_80) + dot (tmpvar_80, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_82;
  tmpvar_82.x = float((tmpvar_81.x >= tmpvar_81.y));
  tmpvar_82.y = float((tmpvar_81.y >= tmpvar_81.z));
  tmpvar_82.z = float((tmpvar_81.z >= tmpvar_81.x));
  vec3 tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_82);
  vec3 tmpvar_84;
  tmpvar_84 = min (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_85;
  tmpvar_85 = max (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_86;
  tmpvar_86 = ((tmpvar_81 - tmpvar_84) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_87;
  tmpvar_87 = ((tmpvar_81 - tmpvar_85) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_88;
  tmpvar_88 = (tmpvar_81 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_89;
  tmpvar_89 = (tmpvar_80 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_90;
  tmpvar_90 = (fract(abs(tmpvar_89)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_91;
  if ((tmpvar_89.x >= 0.0)) {
    tmpvar_91 = tmpvar_90.x;
  } else {
    tmpvar_91 = -(tmpvar_90.x);
  };
  float tmpvar_92;
  if ((tmpvar_89.y >= 0.0)) {
    tmpvar_92 = tmpvar_90.y;
  } else {
    tmpvar_92 = -(tmpvar_90.y);
  };
  float tmpvar_93;
  if ((tmpvar_89.z >= 0.0)) {
    tmpvar_93 = tmpvar_90.z;
  } else {
    tmpvar_93 = -(tmpvar_90.z);
  };
  vec4 tmpvar_94;
  tmpvar_94.xw = vec2(0.0, 1.0);
  tmpvar_94.y = tmpvar_84.z;
  tmpvar_94.z = tmpvar_85.z;
  vec4 x_95;
  x_95 = (tmpvar_93 + tmpvar_94);
  vec4 tmpvar_96;
  tmpvar_96 = (((
    (x_95 * x_95)
   * 34.0) + x_95) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_97;
  tmpvar_97 = (fract(abs(tmpvar_96)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_98;
  if ((tmpvar_96.x >= 0.0)) {
    tmpvar_98 = tmpvar_97.x;
  } else {
    tmpvar_98 = -(tmpvar_97.x);
  };
  float tmpvar_99;
  if ((tmpvar_96.y >= 0.0)) {
    tmpvar_99 = tmpvar_97.y;
  } else {
    tmpvar_99 = -(tmpvar_97.y);
  };
  float tmpvar_100;
  if ((tmpvar_96.z >= 0.0)) {
    tmpvar_100 = tmpvar_97.z;
  } else {
    tmpvar_100 = -(tmpvar_97.z);
  };
  float tmpvar_101;
  if ((tmpvar_96.w >= 0.0)) {
    tmpvar_101 = tmpvar_97.w;
  } else {
    tmpvar_101 = -(tmpvar_97.w);
  };
  vec4 tmpvar_102;
  tmpvar_102.x = tmpvar_98;
  tmpvar_102.y = tmpvar_99;
  tmpvar_102.z = tmpvar_100;
  tmpvar_102.w = tmpvar_101;
  vec4 tmpvar_103;
  tmpvar_103.xw = vec2(0.0, 1.0);
  tmpvar_103.y = tmpvar_84.y;
  tmpvar_103.z = tmpvar_85.y;
  vec4 x_104;
  x_104 = ((tmpvar_102 + tmpvar_92) + tmpvar_103);
  vec4 tmpvar_105;
  tmpvar_105 = (((
    (x_104 * x_104)
   * 34.0) + x_104) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_106;
  tmpvar_106 = (fract(abs(tmpvar_105)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_107;
  if ((tmpvar_105.x >= 0.0)) {
    tmpvar_107 = tmpvar_106.x;
  } else {
    tmpvar_107 = -(tmpvar_106.x);
  };
  float tmpvar_108;
  if ((tmpvar_105.y >= 0.0)) {
    tmpvar_108 = tmpvar_106.y;
  } else {
    tmpvar_108 = -(tmpvar_106.y);
  };
  float tmpvar_109;
  if ((tmpvar_105.z >= 0.0)) {
    tmpvar_109 = tmpvar_106.z;
  } else {
    tmpvar_109 = -(tmpvar_106.z);
  };
  float tmpvar_110;
  if ((tmpvar_105.w >= 0.0)) {
    tmpvar_110 = tmpvar_106.w;
  } else {
    tmpvar_110 = -(tmpvar_106.w);
  };
  vec4 tmpvar_111;
  tmpvar_111.x = tmpvar_107;
  tmpvar_111.y = tmpvar_108;
  tmpvar_111.z = tmpvar_109;
  tmpvar_111.w = tmpvar_110;
  vec4 tmpvar_112;
  tmpvar_112.xw = vec2(0.0, 1.0);
  tmpvar_112.y = tmpvar_84.x;
  tmpvar_112.z = tmpvar_85.x;
  vec4 x_113;
  x_113 = ((tmpvar_111 + tmpvar_91) + tmpvar_112);
  vec4 tmpvar_114;
  tmpvar_114 = (((
    (x_113 * x_113)
   * 34.0) + x_113) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_115;
  tmpvar_115 = (fract(abs(tmpvar_114)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_116;
  if ((tmpvar_114.x >= 0.0)) {
    tmpvar_116 = tmpvar_115.x;
  } else {
    tmpvar_116 = -(tmpvar_115.x);
  };
  float tmpvar_117;
  if ((tmpvar_114.y >= 0.0)) {
    tmpvar_117 = tmpvar_115.y;
  } else {
    tmpvar_117 = -(tmpvar_115.y);
  };
  float tmpvar_118;
  if ((tmpvar_114.z >= 0.0)) {
    tmpvar_118 = tmpvar_115.z;
  } else {
    tmpvar_118 = -(tmpvar_115.z);
  };
  float tmpvar_119;
  if ((tmpvar_114.w >= 0.0)) {
    tmpvar_119 = tmpvar_115.w;
  } else {
    tmpvar_119 = -(tmpvar_115.w);
  };
  vec4 tmpvar_120;
  tmpvar_120.x = tmpvar_116;
  tmpvar_120.y = tmpvar_117;
  tmpvar_120.z = tmpvar_118;
  tmpvar_120.w = tmpvar_119;
  vec4 tmpvar_121;
  tmpvar_121 = (tmpvar_120 - (49.0 * floor(
    (0.02040815 * tmpvar_120)
  )));
  vec4 tmpvar_122;
  tmpvar_122 = floor((tmpvar_121 * 0.1428571));
  vec4 tmpvar_123;
  tmpvar_123 = ((tmpvar_122 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_124;
  tmpvar_124 = ((floor(
    (tmpvar_121 - (7.0 * tmpvar_122))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_125;
  tmpvar_125 = ((1.0 - abs(tmpvar_123)) - abs(tmpvar_124));
  vec4 tmpvar_126;
  tmpvar_126.xy = tmpvar_123.xy;
  tmpvar_126.zw = tmpvar_124.xy;
  vec4 tmpvar_127;
  tmpvar_127.xy = tmpvar_123.zw;
  tmpvar_127.zw = tmpvar_124.zw;
  vec4 tmpvar_128;
  tmpvar_128 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_125)));
  vec4 tmpvar_129;
  tmpvar_129 = (tmpvar_126.xzyw + ((
    (floor(tmpvar_126) * 2.0)
   + 1.0).xzyw * tmpvar_128.xxyy));
  vec4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_128.zzww));
  vec3 tmpvar_131;
  tmpvar_131.xy = tmpvar_129.xy;
  tmpvar_131.z = tmpvar_125.x;
  vec3 tmpvar_132;
  tmpvar_132.xy = tmpvar_129.zw;
  tmpvar_132.z = tmpvar_125.y;
  vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.xy;
  tmpvar_133.z = tmpvar_125.z;
  vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_130.zw;
  tmpvar_134.z = tmpvar_125.w;
  vec4 tmpvar_135;
  tmpvar_135.x = dot (tmpvar_131, tmpvar_131);
  tmpvar_135.y = dot (tmpvar_132, tmpvar_132);
  tmpvar_135.z = dot (tmpvar_133, tmpvar_133);
  tmpvar_135.w = dot (tmpvar_134, tmpvar_134);
  vec4 tmpvar_136;
  tmpvar_136 = (1.792843 - (0.8537347 * tmpvar_135));
  vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_81, tmpvar_81);
  tmpvar_137.y = dot (tmpvar_86, tmpvar_86);
  tmpvar_137.z = dot (tmpvar_87, tmpvar_87);
  tmpvar_137.w = dot (tmpvar_88, tmpvar_88);
  vec4 tmpvar_138;
  tmpvar_138 = max ((0.6 - tmpvar_137), vec4(0.0, 0.0, 0.0, 0.0));
  m_79 = (tmpvar_138 * tmpvar_138);
  vec4 tmpvar_139;
  tmpvar_139.x = dot ((tmpvar_131 * tmpvar_136.x), tmpvar_81);
  tmpvar_139.y = dot ((tmpvar_132 * tmpvar_136.y), tmpvar_86);
  tmpvar_139.z = dot ((tmpvar_133 * tmpvar_136.z), tmpvar_87);
  tmpvar_139.w = dot ((tmpvar_134 * tmpvar_136.w), tmpvar_88);
  tmpvar_77 = (42.0 * dot ((m_79 * m_79), tmpvar_139));
  vec3 v_140;
  v_140 = (_NoiseScale.y * tmpvar_14);
  vec4 m_141;
  vec3 tmpvar_142;
  tmpvar_142 = floor((v_140 + dot (v_140, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_143;
  tmpvar_143 = ((v_140 - tmpvar_142) + dot (tmpvar_142, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_144;
  tmpvar_144.x = float((tmpvar_143.x >= tmpvar_143.y));
  tmpvar_144.y = float((tmpvar_143.y >= tmpvar_143.z));
  tmpvar_144.z = float((tmpvar_143.z >= tmpvar_143.x));
  vec3 tmpvar_145;
  tmpvar_145 = (1.0 - tmpvar_144);
  vec3 tmpvar_146;
  tmpvar_146 = min (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_147;
  tmpvar_147 = max (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_148;
  tmpvar_148 = ((tmpvar_143 - tmpvar_146) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_149;
  tmpvar_149 = ((tmpvar_143 - tmpvar_147) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_150;
  tmpvar_150 = (tmpvar_143 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_151;
  tmpvar_151 = (tmpvar_142 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_152;
  tmpvar_152 = (fract(abs(tmpvar_151)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_153;
  if ((tmpvar_151.x >= 0.0)) {
    tmpvar_153 = tmpvar_152.x;
  } else {
    tmpvar_153 = -(tmpvar_152.x);
  };
  float tmpvar_154;
  if ((tmpvar_151.y >= 0.0)) {
    tmpvar_154 = tmpvar_152.y;
  } else {
    tmpvar_154 = -(tmpvar_152.y);
  };
  float tmpvar_155;
  if ((tmpvar_151.z >= 0.0)) {
    tmpvar_155 = tmpvar_152.z;
  } else {
    tmpvar_155 = -(tmpvar_152.z);
  };
  vec4 tmpvar_156;
  tmpvar_156.xw = vec2(0.0, 1.0);
  tmpvar_156.y = tmpvar_146.z;
  tmpvar_156.z = tmpvar_147.z;
  vec4 x_157;
  x_157 = (tmpvar_155 + tmpvar_156);
  vec4 tmpvar_158;
  tmpvar_158 = (((
    (x_157 * x_157)
   * 34.0) + x_157) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_159;
  tmpvar_159 = (fract(abs(tmpvar_158)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_160;
  if ((tmpvar_158.x >= 0.0)) {
    tmpvar_160 = tmpvar_159.x;
  } else {
    tmpvar_160 = -(tmpvar_159.x);
  };
  float tmpvar_161;
  if ((tmpvar_158.y >= 0.0)) {
    tmpvar_161 = tmpvar_159.y;
  } else {
    tmpvar_161 = -(tmpvar_159.y);
  };
  float tmpvar_162;
  if ((tmpvar_158.z >= 0.0)) {
    tmpvar_162 = tmpvar_159.z;
  } else {
    tmpvar_162 = -(tmpvar_159.z);
  };
  float tmpvar_163;
  if ((tmpvar_158.w >= 0.0)) {
    tmpvar_163 = tmpvar_159.w;
  } else {
    tmpvar_163 = -(tmpvar_159.w);
  };
  vec4 tmpvar_164;
  tmpvar_164.x = tmpvar_160;
  tmpvar_164.y = tmpvar_161;
  tmpvar_164.z = tmpvar_162;
  tmpvar_164.w = tmpvar_163;
  vec4 tmpvar_165;
  tmpvar_165.xw = vec2(0.0, 1.0);
  tmpvar_165.y = tmpvar_146.y;
  tmpvar_165.z = tmpvar_147.y;
  vec4 x_166;
  x_166 = ((tmpvar_164 + tmpvar_154) + tmpvar_165);
  vec4 tmpvar_167;
  tmpvar_167 = (((
    (x_166 * x_166)
   * 34.0) + x_166) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_168;
  tmpvar_168 = (fract(abs(tmpvar_167)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_169;
  if ((tmpvar_167.x >= 0.0)) {
    tmpvar_169 = tmpvar_168.x;
  } else {
    tmpvar_169 = -(tmpvar_168.x);
  };
  float tmpvar_170;
  if ((tmpvar_167.y >= 0.0)) {
    tmpvar_170 = tmpvar_168.y;
  } else {
    tmpvar_170 = -(tmpvar_168.y);
  };
  float tmpvar_171;
  if ((tmpvar_167.z >= 0.0)) {
    tmpvar_171 = tmpvar_168.z;
  } else {
    tmpvar_171 = -(tmpvar_168.z);
  };
  float tmpvar_172;
  if ((tmpvar_167.w >= 0.0)) {
    tmpvar_172 = tmpvar_168.w;
  } else {
    tmpvar_172 = -(tmpvar_168.w);
  };
  vec4 tmpvar_173;
  tmpvar_173.x = tmpvar_169;
  tmpvar_173.y = tmpvar_170;
  tmpvar_173.z = tmpvar_171;
  tmpvar_173.w = tmpvar_172;
  vec4 tmpvar_174;
  tmpvar_174.xw = vec2(0.0, 1.0);
  tmpvar_174.y = tmpvar_146.x;
  tmpvar_174.z = tmpvar_147.x;
  vec4 x_175;
  x_175 = ((tmpvar_173 + tmpvar_153) + tmpvar_174);
  vec4 tmpvar_176;
  tmpvar_176 = (((
    (x_175 * x_175)
   * 34.0) + x_175) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_177;
  tmpvar_177 = (fract(abs(tmpvar_176)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_178;
  if ((tmpvar_176.x >= 0.0)) {
    tmpvar_178 = tmpvar_177.x;
  } else {
    tmpvar_178 = -(tmpvar_177.x);
  };
  float tmpvar_179;
  if ((tmpvar_176.y >= 0.0)) {
    tmpvar_179 = tmpvar_177.y;
  } else {
    tmpvar_179 = -(tmpvar_177.y);
  };
  float tmpvar_180;
  if ((tmpvar_176.z >= 0.0)) {
    tmpvar_180 = tmpvar_177.z;
  } else {
    tmpvar_180 = -(tmpvar_177.z);
  };
  float tmpvar_181;
  if ((tmpvar_176.w >= 0.0)) {
    tmpvar_181 = tmpvar_177.w;
  } else {
    tmpvar_181 = -(tmpvar_177.w);
  };
  vec4 tmpvar_182;
  tmpvar_182.x = tmpvar_178;
  tmpvar_182.y = tmpvar_179;
  tmpvar_182.z = tmpvar_180;
  tmpvar_182.w = tmpvar_181;
  vec4 tmpvar_183;
  tmpvar_183 = (tmpvar_182 - (49.0 * floor(
    (0.02040815 * tmpvar_182)
  )));
  vec4 tmpvar_184;
  tmpvar_184 = floor((tmpvar_183 * 0.1428571));
  vec4 tmpvar_185;
  tmpvar_185 = ((tmpvar_184 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_186;
  tmpvar_186 = ((floor(
    (tmpvar_183 - (7.0 * tmpvar_184))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_187;
  tmpvar_187 = ((1.0 - abs(tmpvar_185)) - abs(tmpvar_186));
  vec4 tmpvar_188;
  tmpvar_188.xy = tmpvar_185.xy;
  tmpvar_188.zw = tmpvar_186.xy;
  vec4 tmpvar_189;
  tmpvar_189.xy = tmpvar_185.zw;
  tmpvar_189.zw = tmpvar_186.zw;
  vec4 tmpvar_190;
  tmpvar_190 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_187)));
  vec4 tmpvar_191;
  tmpvar_191 = (tmpvar_188.xzyw + ((
    (floor(tmpvar_188) * 2.0)
   + 1.0).xzyw * tmpvar_190.xxyy));
  vec4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_190.zzww));
  vec3 tmpvar_193;
  tmpvar_193.xy = tmpvar_191.xy;
  tmpvar_193.z = tmpvar_187.x;
  vec3 tmpvar_194;
  tmpvar_194.xy = tmpvar_191.zw;
  tmpvar_194.z = tmpvar_187.y;
  vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.xy;
  tmpvar_195.z = tmpvar_187.z;
  vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_192.zw;
  tmpvar_196.z = tmpvar_187.w;
  vec4 tmpvar_197;
  tmpvar_197.x = dot (tmpvar_193, tmpvar_193);
  tmpvar_197.y = dot (tmpvar_194, tmpvar_194);
  tmpvar_197.z = dot (tmpvar_195, tmpvar_195);
  tmpvar_197.w = dot (tmpvar_196, tmpvar_196);
  vec4 tmpvar_198;
  tmpvar_198 = (1.792843 - (0.8537347 * tmpvar_197));
  vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_143, tmpvar_143);
  tmpvar_199.y = dot (tmpvar_148, tmpvar_148);
  tmpvar_199.z = dot (tmpvar_149, tmpvar_149);
  tmpvar_199.w = dot (tmpvar_150, tmpvar_150);
  vec4 tmpvar_200;
  tmpvar_200 = max ((0.6 - tmpvar_199), vec4(0.0, 0.0, 0.0, 0.0));
  m_141 = (tmpvar_200 * tmpvar_200);
  vec4 tmpvar_201;
  tmpvar_201.x = dot ((tmpvar_193 * tmpvar_198.x), tmpvar_143);
  tmpvar_201.y = dot ((tmpvar_194 * tmpvar_198.y), tmpvar_148);
  tmpvar_201.z = dot ((tmpvar_195 * tmpvar_198.z), tmpvar_149);
  tmpvar_201.w = dot ((tmpvar_196 * tmpvar_198.w), tmpvar_150);
  vec3 tmpvar_202;
  tmpvar_202.x = tmpvar_15;
  tmpvar_202.y = tmpvar_77;
  tmpvar_202.z = (42.0 * dot ((m_141 * m_141), tmpvar_201));
  vec3 tmpvar_203;
  tmpvar_203 = (0.5 * (tmpvar_202 + 1.0));
  localOrigin_5.xyz = (((2.0 * tmpvar_203) - 1.0) * _MaxTrans);
  localOrigin_5.w = 1.0;
  float tmpvar_204;
  tmpvar_204 = ((tmpvar_203.x * (_MaxScale - 1.0)) + 1.0);
  origin_7 = (_Object2World * localOrigin_5);
  planet_pos_6 = (_MainRotation * origin_7);
  vec3 tmpvar_205;
  tmpvar_205 = (_DetailRotation * planet_pos_6).xyz;
  tmpvar_11 = planet_pos_6.xyz;
  vec3 tmpvar_206;
  tmpvar_206 = normalize(planet_pos_6.xyz);
  vec2 uv_207;
  float tmpvar_208;
  float tmpvar_209;
  tmpvar_209 = (min (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0) / max (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0));
  float tmpvar_210;
  tmpvar_210 = (tmpvar_209 * tmpvar_209);
  tmpvar_210 = (((
    ((((
      ((((-0.01213232 * tmpvar_210) + 0.05368138) * tmpvar_210) - 0.1173503)
     * tmpvar_210) + 0.1938925) * tmpvar_210) - 0.3326756)
   * tmpvar_210) + 0.9999793) * tmpvar_209);
  tmpvar_210 = (tmpvar_210 + (float(
    (abs((tmpvar_206.x / tmpvar_206.z)) > 1.0)
  ) * (
    (tmpvar_210 * -2.0)
   + 1.570796)));
  tmpvar_208 = (tmpvar_210 * sign((tmpvar_206.x / tmpvar_206.z)));
  if ((abs(tmpvar_206.z) > (1e-08 * abs(tmpvar_206.x)))) {
    if ((tmpvar_206.z < 0.0)) {
      if ((tmpvar_206.x >= 0.0)) {
        tmpvar_208 += 3.141593;
      } else {
        tmpvar_208 = (tmpvar_208 - 3.141593);
      };
    };
  } else {
    tmpvar_208 = (sign(tmpvar_206.x) * 1.570796);
  };
  uv_207.x = (0.5 + (0.1591549 * tmpvar_208));
  uv_207.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_206.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_206.y)
    )) * (1.570796 + (
      abs(tmpvar_206.y)
     * 
      (-0.2146018 + (abs(tmpvar_206.y) * (0.08656672 + (
        abs(tmpvar_206.y)
       * -0.03102955))))
    ))))
  )));
  vec4 uv4_211;
  uv4_211.zw = vec2(0.0, 0.0);
  vec3 tmpvar_212;
  tmpvar_212 = normalize(tmpvar_205);
  vec3 tmpvar_213;
  tmpvar_213 = abs(tmpvar_212);
  float tmpvar_214;
  tmpvar_214 = float((tmpvar_213.z >= tmpvar_213.x));
  float tmpvar_215;
  tmpvar_215 = float((max (tmpvar_213.x, tmpvar_213.z) >= tmpvar_213.y));
  float tmpvar_216;
  tmpvar_216 = sign(mix (tmpvar_212.y, mix (tmpvar_212.x, tmpvar_212.z, tmpvar_214), tmpvar_215));
  vec3 tmpvar_217;
  tmpvar_217.xz = vec2(1.0, -1.0);
  tmpvar_217.y = -(tmpvar_216);
  vec3 tmpvar_218;
  tmpvar_218.xz = vec2(1.0, -1.0);
  tmpvar_218.y = tmpvar_216;
  vec3 tmpvar_219;
  tmpvar_219.xy = vec2(1.0, 1.0);
  tmpvar_219.z = tmpvar_216;
  vec3 tmpvar_220;
  tmpvar_220 = mix ((tmpvar_219 * tmpvar_212.yxz), mix ((tmpvar_217 * tmpvar_212.xzy), (tmpvar_218 * tmpvar_212.zxy), vec3(tmpvar_214)), vec3(tmpvar_215));
  uv4_211.xy = (((0.5 * tmpvar_220.yz) / abs(tmpvar_220.x)) + 0.5);
  tmpvar_8 = (texture2DLod (_MainTex, uv_207, 0.0) * texture2DLod (_DetailTex, uv4_211.xy, 0.0));
  vec4 tmpvar_221;
  tmpvar_221.w = 0.0;
  tmpvar_221.xyz = _WorldSpaceCameraPos;
  float tmpvar_222;
  vec4 tmpvar_223;
  tmpvar_223 = (origin_7 - tmpvar_221);
  tmpvar_222 = sqrt(dot (tmpvar_223, tmpvar_223));
  tmpvar_9.w = (clamp ((_DistFade * tmpvar_222), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_222)
  ), 0.0, 1.0));
  tmpvar_8.w = (tmpvar_8.w * tmpvar_9.w);
  vec3 tmpvar_224;
  tmpvar_224.yz = vec2(0.0, 0.0);
  tmpvar_224.x = fract(_Rotation);
  vec3 x_225;
  x_225 = (tmpvar_224 + tmpvar_203);
  vec3 trans_226;
  trans_226 = localOrigin_5.xyz;
  float tmpvar_227;
  tmpvar_227 = (x_225.x * 6.283185);
  float tmpvar_228;
  tmpvar_228 = (x_225.y * 6.283185);
  float tmpvar_229;
  tmpvar_229 = (x_225.z * 2.0);
  float tmpvar_230;
  tmpvar_230 = sqrt(tmpvar_229);
  float tmpvar_231;
  tmpvar_231 = (sin(tmpvar_228) * tmpvar_230);
  float tmpvar_232;
  tmpvar_232 = (cos(tmpvar_228) * tmpvar_230);
  float tmpvar_233;
  tmpvar_233 = sqrt((2.0 - tmpvar_229));
  float tmpvar_234;
  tmpvar_234 = sin(tmpvar_227);
  float tmpvar_235;
  tmpvar_235 = cos(tmpvar_227);
  float tmpvar_236;
  tmpvar_236 = ((tmpvar_231 * tmpvar_235) - (tmpvar_232 * tmpvar_234));
  float tmpvar_237;
  tmpvar_237 = ((tmpvar_231 * tmpvar_234) + (tmpvar_232 * tmpvar_235));
  mat4 tmpvar_238;
  tmpvar_238[0].x = (tmpvar_204 * ((tmpvar_231 * tmpvar_236) - tmpvar_235));
  tmpvar_238[0].y = ((tmpvar_231 * tmpvar_237) - tmpvar_234);
  tmpvar_238[0].z = (tmpvar_231 * tmpvar_233);
  tmpvar_238[0].w = 0.0;
  tmpvar_238[1].x = ((tmpvar_232 * tmpvar_236) + tmpvar_234);
  tmpvar_238[1].y = (tmpvar_204 * ((tmpvar_232 * tmpvar_237) - tmpvar_235));
  tmpvar_238[1].z = (tmpvar_232 * tmpvar_233);
  tmpvar_238[1].w = 0.0;
  tmpvar_238[2].x = (tmpvar_233 * tmpvar_236);
  tmpvar_238[2].y = (tmpvar_233 * tmpvar_237);
  tmpvar_238[2].z = (tmpvar_204 * (1.0 - tmpvar_229));
  tmpvar_238[2].w = 0.0;
  tmpvar_238[3].x = trans_226.x;
  tmpvar_238[3].y = trans_226.y;
  tmpvar_238[3].z = trans_226.z;
  tmpvar_238[3].w = 1.0;
  mat4 tmpvar_239;
  tmpvar_239 = ((unity_MatrixV * _Object2World) * tmpvar_238);
  vec4 v_240;
  v_240.x = tmpvar_239[0].z;
  v_240.y = tmpvar_239[1].z;
  v_240.z = tmpvar_239[2].z;
  v_240.w = tmpvar_239[3].z;
  vec3 tmpvar_241;
  tmpvar_241 = normalize(v_240.xyz);
  tmpvar_9.xyz = abs(tmpvar_241);
  vec4 tmpvar_242;
  tmpvar_242 = (gl_ModelViewMatrix * localOrigin_5);
  vec4 tmpvar_243;
  tmpvar_243.xyz = (gl_Vertex.xyz * tmpvar_204);
  tmpvar_243.w = gl_Vertex.w;
  vec2 tmpvar_244;
  tmpvar_244 = ((2.0 * gl_MultiTexCoord0.xy) - 1.0);
  vec4 tmpvar_245;
  tmpvar_245.z = 0.0;
  tmpvar_245.xy = tmpvar_244;
  tmpvar_245.w = gl_Vertex.w;
  ZYv_4.xyw = tmpvar_245.zyw;
  XZv_3.yzw = tmpvar_245.zyw;
  XYv_2.yzw = tmpvar_245.yzw;
  ZYv_4.z = (tmpvar_244.x * sign(-(tmpvar_241.x)));
  XZv_3.x = (tmpvar_244.x * sign(-(tmpvar_241.y)));
  XYv_2.x = (tmpvar_244.x * sign(tmpvar_241.z));
  ZYv_4.x = ((sign(
    -(tmpvar_241.x)
  ) * sign(ZYv_4.z)) * tmpvar_241.z);
  XZv_3.y = ((sign(
    -(tmpvar_241.y)
  ) * sign(XZv_3.x)) * tmpvar_241.x);
  XYv_2.z = ((sign(
    -(tmpvar_241.z)
  ) * sign(XYv_2.x)) * tmpvar_241.x);
  ZYv_4.x = (ZYv_4.x + ((
    sign(-(tmpvar_241.x))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  XZv_3.y = (XZv_3.y + ((
    sign(-(tmpvar_241.y))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.z));
  XYv_2.z = (XYv_2.z + ((
    sign(-(tmpvar_241.z))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  vec3 tmpvar_246;
  tmpvar_246 = normalize((origin_7.xyz - _WorldSpaceCameraPos));
  vec3 tmpvar_247;
  tmpvar_247 = normalize(-(tmpvar_246));
  vec4 v_248;
  v_248.x = unity_MatrixV[0].x;
  v_248.y = unity_MatrixV[1].x;
  v_248.z = unity_MatrixV[2].x;
  v_248.w = unity_MatrixV[3].x;
  vec3 tmpvar_249;
  tmpvar_249 = normalize(v_248.xyz);
  vec3 tmpvar_250;
  vec3 tmpvar_251;
  tmpvar_250 = v_248.xyz;
  tmpvar_251 = ((tmpvar_247.zxy * tmpvar_249.yzx) - (tmpvar_247.yzx * tmpvar_249.zxy));
  mat3 tmpvar_252;
  tmpvar_252[0].x = tmpvar_250.x;
  tmpvar_252[0].y = tmpvar_251.x;
  tmpvar_252[0].z = tmpvar_247.x;
  tmpvar_252[1].x = tmpvar_250.y;
  tmpvar_252[1].y = tmpvar_251.y;
  tmpvar_252[1].z = tmpvar_247.y;
  tmpvar_252[2].x = tmpvar_250.z;
  tmpvar_252[2].y = tmpvar_251.z;
  tmpvar_252[2].z = tmpvar_247.z;
  gl_Position = (gl_ProjectionMatrix * (tmpvar_242 + tmpvar_243));
  xlv_COLOR = tmpvar_8;
  xlv_TEXCOORD0 = tmpvar_9;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * ZYv_4)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XZv_3)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XYv_2)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD4 = tmpvar_1;
  xlv_TEXCOORD5 = tmpvar_10;
  xlv_TEXCOORD6 = tmpvar_11;
  xlv_TEXCOORD7 = normalize((tmpvar_252 * tmpvar_246));
  xlv_TEXCOORD8 = normalize((tmpvar_252 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform vec4 _LightColor0;
uniform sampler2D _Tex;
uniform vec4 _Color;
uniform float _MinScatter;
uniform float _Opacity;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec3 normT_1;
  vec4 color_2;
  vec4 tex_3;
  tex_3.x = texture2D (_Tex, xlv_TEXCOORD1).x;
  tex_3.y = texture2D (_Tex, xlv_TEXCOORD2).y;
  tex_3.z = texture2D (_Tex, xlv_TEXCOORD3).z;
  tex_3.w = 0.0;
  tex_3.xyz = (tex_3.xyz * xlv_TEXCOORD0.xyz);
  tex_3 = (tex_3 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  float tmpvar_4;
  tmpvar_4 = ((tex_3.x + tex_3.y) + (tex_3.z + tex_3.w));
  vec4 tmpvar_5;
  tmpvar_5.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_5.w = tmpvar_4;
  tex_3.xyz = tmpvar_5.xyz;
  color_2 = (_Color * xlv_COLOR);
  normT_1.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_1.z = sqrt((1.0 - clamp (
    dot (normT_1.xy, normT_1.xy)
  , 0.0, 1.0)));
  color_2.w = (color_2.w * tmpvar_4);
  tex_3.w = (xlv_TEXCOORD0.w * tmpvar_4);
  vec4 c_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD8);
  vec3 tmpvar_8;
  tmpvar_8 = normalize(xlv_TEXCOORD7);
  vec3 tmpvar_9;
  tmpvar_9 = normalize(normT_1);
  float tmpvar_10;
  tmpvar_10 = max (dot (tmpvar_9, tmpvar_7), 0.0);
  c_6.xyz = ((_LightColor0.xyz * (vec3(tmpvar_10) + 
    clamp ((((_MinScatter - 
      (_Opacity * tex_3.w)
    ) * (1.0 - 
      dot (tmpvar_9, tmpvar_8)
    )) * (0.5 + (0.5 * 
      dot (tmpvar_8, tmpvar_7)
    ))), 0.0, 1.0)
  )) * 2.0);
  c_6.w = (tmpvar_10 * 2.0);
  color_2.xyz = (color_2.xyz * c_6.xyz);
  gl_FragData[0] = color_2;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 666 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "texcoord" TexCoord0
Matrix 19 [_DetailRotation] 3
Matrix 12 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 22 [_PosRotation] 3
Matrix 0 [glstate_matrix_modelview0]
Matrix 8 [glstate_matrix_projection]
Matrix 16 [unity_MatrixV] 3
Float 27 [_DistFade]
Float 28 [_DistFadeVert]
Float 30 [_MaxScale]
Vector 32 [_MaxTrans]
Vector 31 [_NoiseScale]
Float 29 [_Rotation]
Vector 25 [_WorldSpaceCameraPos]
Vector 26 [_WorldSpaceLightPos0]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
"vs_3_0
def c33, 0.333333343, 0.166666672, 1, -0.5
def c34, 34, 5.89795971, 49, 0.142857149
def c35, 0.00346020772, 289, 0, 1
def c36, 7, 0.285714298, -0.928571403, 0.600000024
def c37, 2, 1, 0.853734732, 1.79284286
def c38, -2, 3.14159274, 1, -1
def c39, 42, 0.0208350997, -0.0851330012, 0.180141002
def c40, -0.330299497, 0.999866009, -2, 1.57079637
def c41, -0.0187292993, 0.0742610022, 1.57072878, 0.318309873
def c42, -3.14159274, 0.159154937, 0.5, -0.212114394
def c43, 6.28318548, -3.14159274, 0.600000024, 0.5
dcl_position v0
dcl_texcoord v1
dcl_2d s0
dcl_2d s1
dcl_position o0
dcl_color o1
dcl_texcoord o2
dcl_texcoord1 o3.xy
dcl_texcoord2 o4.xy
dcl_texcoord3 o5.xy
dcl_texcoord4 o6.xy
dcl_texcoord5 o7
dcl_texcoord6 o8.xyz
dcl_texcoord7 o9.xyz
dcl_texcoord8 o10.xyz
mov r0.x, c4.w
mov r0.y, c5.w
mov r0.z, c6.w
mov r0.w, c7.w
dp4 r1.x, c22, r0
dp4 r1.y, c23, r0
dp4 r1.z, c24, r0
mul r0.xyz, r1, c31.z
dp3 r0.w, r0, c33.x
mad r2.xyz, c31.z, r1, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mad r1.xyz, c31.z, r1, -r2
dp3 r0.w, r2, c33.y
add r1.xyz, r0.w, r1
sge r2.xyz, r1, r1.yzxw
add r3.xyz, -r2.zxyw, c33.z
min r4.xyz, r2, r3
max r2.xyz, r2, r3
mad r3.xyw, r4.z, c35.zwzz, c35.zzzw
mov r3.z, r2.z
mad r3, r5.z, c35.y, r3
mul r5.xy, r5, c35.y
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.y
mad r6.xyw, r4.zyzz, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r3, r3, r6
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.x
mad r5.xyw, r4.zxzz, c35.zwzz, c35.zzzw
add r4.xyz, r1, -r4
add r4.xyz, r4, c33.y
mov r5.z, r2.x
add r2.xyz, r1, -r2
add r2.xyz, r2, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r6, r3, r5, -r5
mul r3, r6, c34.y
mul r5, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r5
frc r5, r5
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r5.xz, r6.yyww
add r7, r5, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r5, r7.zwxy, -r9.yyxx, r5.zwxy
mov r7.xy, r5.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r5.z, r8.y
dp3 r10.y, r5, r5
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r5.xyz, r5, r6.y
dp3 r5.y, r5, r4
dp3 r4.y, r4, r4
mul r3.xyz, r3, r6.z
dp3 r5.z, r3, r2
dp3 r4.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r5.x, r2, r1
add r2.xyz, r1, c33.w
dp3 r4.x, r1, r1
dp3 r5.w, r3, r2
dp3 r4.w, r2, r2
add r1, -r4, c36.w
max r1, r1, c35.z
mul r1, r1, r1
mul r1, r1, r1
dp4 r0.w, r1, r5
mul r1.x, r0.w, c39.x
mul r2.xyz, r0, c31.x
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.x, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r4.xyz, c31.x, r0, -r2
dp3 r0.w, r2, c33.y
add r2.xyz, r0.w, r4
sge r4.xyz, r2, r2.yzxw
add r5.xyw, -r4.zxzy, c33.z
min r6.xyz, r4, r5.xyww
max r4.xyz, r4, r5.xyww
mad r7.xyw, r6.z, c35.zwzz, c35.zzzw
mov r7.z, r4.z
mad r5, r5.z, c35.y, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r5, r8, c35.y, r3.y
mad r7.xyw, r6.zyzz, c35.zwzz, c35.zzzw
mov r7.z, r4.y
add r5, r5, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r3, r8, c35.y, r3.x
mad r5.xyw, r6.zxzz, c35.zwzz, c35.zzzw
add r6.xyz, r2, -r6
add r6.xyz, r6, c33.y
mov r5.z, r4.x
add r4.xyz, r2, -r4
add r4.xyz, r4, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r7, r3, r5, -r5
mul r3, r7, c34.y
mul r5, r7, c35.y
frc r7, r3
add r3, r3, -r7
mad r3, r3, -c34.z, r5
frc r5, r5
mul r7, r3, c34.w
frc r8, r7
add r7, r7, -r8
mad r3, r7, -c36.x, r3
mad r7, r7.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r8.yw, r3.xxzy
frc r8.xz, r7.yyww
mov r5.xz, r7.yyww
add r8, r5, -r8
mad r8, r8, c37.x, c37.y
add r9, -r7_abs.ywxz, c33.z
add r9, -r3_abs.xywz, r9.xywz
sge r10, c35.z, r9.xywz
mad r5, r8.zwxy, -r10.yyxx, r5.zwxy
mov r8.xy, r5.zwzw
mov r8.z, r9.x
dp3 r11.x, r8, r8
mov r5.z, r9.y
dp3 r11.y, r5, r5
frc r12.yw, r3.xzzw
mov r7.yw, r3.xzzw
frc r12.xz, r7
add r3, -r12, r7
mad r3, r3, c37.x, c37.y
mad r3, r3, -r10.zzww, r7
mov r9.xy, r3.zwzw
mov r3.z, r9.w
dp3 r11.z, r3, r3
dp3 r11.w, r9, r9
mad r7, r11, -c37.z, c37.w
mul r5.xyz, r5, r7.y
dp3 r5.y, r5, r6
dp3 r6.y, r6, r6
mul r3.xyz, r3, r7.z
dp3 r5.z, r3, r4
dp3 r6.z, r4, r4
mul r3.xyz, r7.x, r8
mul r4.xyz, r7.w, r9
dp3 r5.x, r3, r2
add r3.xyz, r2, c33.w
dp3 r6.x, r2, r2
dp3 r5.w, r4, r3
dp3 r6.w, r3, r3
add r2, -r6, c36.w
max r2, r2, c35.z
mul r2, r2, r2
mul r2, r2, r2
dp4 r0.w, r2, r5
mul r1.y, r0.w, c39.x
mul r2.xyz, r0, c31.y
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.y, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r0.xyz, c31.y, r0, -r2
dp3 r0.w, r2, c33.y
add r0.xyz, r0.w, r0
sge r2.xyz, r0, r0.yzxw
add r4.xyz, -r2.zxyw, c33.z
min r5.xyw, r2.xyzz, r4.xyzz
max r2.xyz, r2, r4
mad r4.xyw, r5.w, c35.zwzz, c35.zzzw
mov r4.z, r2.z
mad r4, r5.z, c35.y, r4
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r4, r7, c35.y, r3.y
mad r6.xyw, r5.wyzw, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r4, r4, r6
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r3, r7, c35.y, r3.x
mad r4.xyw, r5.wxzw, c35.zwzz, c35.zzzw
add r5.xyz, r0, -r5.xyww
add r5.xyz, r5, c33.y
mov r4.z, r2.x
add r2.xyz, r0, -r2
add r2.xyz, r2, c33.x
add r3, r3, r4
mul r4, r3, r3
mad r3, r4, c34.x, r3
mul r3, r3, c35.x
frc r4, r3_abs
sge r3, r3, -r3
lrp r6, r3, r4, -r4
mul r3, r6, c34.y
mul r4, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r4
frc r4, r4
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r4, r3
mad r3, r3, c36.y, c36.z
mov r4.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r4.xz, r6.yyww
add r7, r4, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r4, r7.zwxy, -r9.yyxx, r4.zwxy
mov r7.xy, r4.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r4.z, r8.y
dp3 r10.y, r4, r4
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r4.xyz, r4, r6.y
dp3 r4.y, r4, r5
dp3 r5.y, r5, r5
mul r3.xyz, r3, r6.z
dp3 r4.z, r3, r2
dp3 r5.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r4.x, r2, r0
add r2.xyz, r0, c33.w
dp3 r5.x, r0, r0
dp3 r4.w, r3, r2
dp3 r5.w, r2, r2
add r0, -r5, c36.w
max r0, r0, c35.z
mul r0, r0, r0
mul r0, r0, r0
dp4 r0.x, r0, r4
mul r1.z, r0.x, c39.x
mul r0.xyz, r1, c32
add r1.xyz, r1, c33.z
mov r0.w, c33.z
dp4 r2.w, c7, r0
dp4 r2.x, c4, r0
dp4 r2.y, c5, r0
dp4 r2.z, c6, r0
dp4 r3.w, c15, r2
dp4 r3.x, c12, r2
dp4 r3.y, c13, r2
dp4 r3.z, c14, r2
add r2.xyz, r2, -c25
dp4 r4.y, c19, r3
dp4 r4.x, c20, r3
dp4 r4.z, c21, r3
dp3 r1.w, r4, r4
rsq r1.w, r1.w
mul r5.xyz, r1.w, r4
mad r2.w, r4.z, r1.w, -r5.y
sge r3.w, r5_abs.z, r5_abs.y
mad r2.w, r3.w, r2.w, r5.y
mad r1.w, r4.x, -r1.w, r2.w
max r2.w, r5_abs.z, r5_abs.y
sge r2.w, r2.w, r5_abs.x
mad r1.w, r2.w, r1.w, r5.x
slt r4.x, -r1.w, r1.w
slt r1.w, r1.w, -r1.w
add r4.y, -r1.w, r4.x
mov r6.y, -r4.y
mov r6.xz, c38.zyww
mul r6.xyz, r5.yzxw, r6
mov r4.xz, c38.zyww
mad r7.xyz, r4, r5.zyxw, -r6
mad r6.xyz, r3.w, r7, r6
mad r6.xyz, r4.xxyw, -r5, r6
mul r4.xyz, r5, r4.xxyw
mad r4.xyz, r2.w, r6, r4
mul r4.yz, r4, -c33.w
rcp r1.w, r4_abs.x
mad r4.xy, r4.yzzw, r1.w, -c33.w
mov r4.zw, c35.z
texldl r4, r4, s1
dp3 r1.w, r3, r3
rsq r1.w, r1.w
mul r5.xyz, r1.w, r3.xzyw
mov o8.xyz, r3
max r1.w, r5_abs.y, r5_abs.x
rcp r1.w, r1.w
min r2.w, r5_abs.y, r5_abs.x
mul r1.w, r1.w, r2.w
mul r2.w, r1.w, r1.w
mad r3.x, r2.w, c39.y, c39.z
mad r3.x, r2.w, r3.x, c39.w
mad r3.x, r2.w, r3.x, c40.x
mad r2.w, r2.w, r3.x, c40.y
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c40.z, c40.w
slt r3.x, r5_abs.y, r5_abs.x
mad r1.w, r2.w, r3.x, r1.w
slt r3.xy, r5.yzzw, -r5.yzzw
mad r1.w, r3.x, c42.x, r1.w
add r2.w, r1.w, r1.w
min r3.x, r5.y, r5.x
slt r3.x, r3.x, -r3.x
max r3.z, r5.y, r5.x
sge r3.z, r3.z, -r3.z
mul r3.x, r3.z, r3.x
mad r1.w, r3.x, -r2.w, r1.w
mad r6.x, r1.w, c42.y, c42.z
mad r1.w, r5_abs.z, c41.x, c41.y
mad r1.w, r1.w, r5_abs.z, c42.w
mad r1.w, r1.w, r5_abs.z, c41.z
add r2.w, -r5_abs.z, c33.z
rsq r2.w, r2.w
rcp r2.w, r2.w
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c38.x, c38.y
mad r1.w, r2.w, r3.y, r1.w
mul r6.y, r1.w, c41.w
mov r6.zw, c35.z
texldl r3, r6, s0
mul r3, r4, r3
dp3 r1.w, r2, r2
rsq r1.w, r1.w
rcp r2.w, r1.w
mul r2.xyz, r1.w, r2
mul_sat r1.w, r2.w, c27.x
mov r4.z, c33.z
mad_sat r2.w, c28.x, -r2.w, r4.z
mul r1.w, r1.w, r2.w
mul o1.w, r1.w, r3.w
mov o1.xyz, r3
mov o2.w, r1.w
frc r3.x, c29.x
mov r3.y, c35.z
mad r1.zw, r1.xyxz, -c33.w, r3.xyxy
mad r3.xy, r1.w, -c37.x, c37
mul r1.x, r1.x, -c33.w
mad r1.y, r1.y, -c33.w, -c33.w
frc r1.y, r1.y
mad r1.y, r1.y, c43.x, c43.y
sincos r5.xy, r1.y
add r1.y, -r4.z, c30.x
mad r1.x, r1.x, r1.y, c33.z
mul r4.z, r3.y, r1.x
rsq r1.y, r3.x
rcp r1.y, r1.y
add r1.w, r1.w, r1.w
add r1.z, r1.z, -c33.w
frc r1.z, r1.z
mad r1.z, r1.z, c43.x, c43.y
sincos r3.xy, r1.z
rsq r1.z, r1.w
rcp r1.z, r1.z
mul r1.zw, r1.z, r5.xyyx
mul r5.xyz, r3.yyxw, r1.wzww
mad r2.w, r1.z, r3.x, -r5.x
add r3.z, r5.z, r5.y
mul r4.x, r1.y, r2.w
mul r4.y, r1.y, r3.z
mad r5.yz, r1.xzww, r3.z, -r3.xyxw
mul r6.zw, r1.y, r1
mov r7, c5
mul r8.xyz, r7, c18.y
mov r9, c4
mad r8.xyz, c18.x, r9, r8
mov r10, c6
mad r8.xyz, c18.z, r10, r8
mov r11, c7
mad r8.xyz, c18.w, r11, r8
dp3 r12.z, r8, r4
mad r1.y, r1.z, r2.w, -r3.x
mad r6.x, r1.w, r2.w, r3.y
mul r5.x, r1.y, r1.x
mov r5.w, r6.z
dp3 r12.x, r8, r5.xyww
mul r6.y, r1.x, r5.z
mul r1.xyz, r1.x, v0
dp3 r12.y, r8, r6.xyww
nrm r3.xyz, r12
abs o2.xyz, r3
dp4 r8.z, c2, r0
dp4 r8.w, c3, r0
dp4 r8.x, c0, r0
dp4 r8.y, c1, r0
mov r1.w, v0.w
add r1, r1, r8
dp4 o0.x, c8, r1
dp4 o0.y, c9, r1
dp4 o0.z, c10, r1
dp4 o0.w, c11, r1
mul r1, r7, c16.y
mad r1, c16.x, r9, r1
mad r1, c16.z, r10, r1
mad r1, c16.w, r11, r1
dp3 r12.z, r1, r4
dp4 r12.w, r1, r0
dp3 r12.x, r1, r5.xyww
dp3 r12.y, r1, r6.xyww
slt r1.xyz, r3, -r3
slt r13.xyz, -r3, r3
add r1.xyw, r1.xyzz, -r13.xyzz
add r1.z, -r1.z, r13.z
mad r8.zw, v1.xyxy, -c38.x, -c38.z
slt r2.w, -r8.w, r8.w
slt r3.w, r8.w, -r8.w
add r2.w, r2.w, -r3.w
mul r13.xyz, r1.xyww, r2.w
mul r13.xyz, r3.yzyw, r13
mul r3.yw, r1.xxzy, r8.z
mul r14.x, r1.z, r8.z
slt r8.zw, -r3.xyyw, r3.xyyw
slt r15.xy, r3.ywzw, -r3.ywzw
add r8.zw, r8, -r15.xyxy
mul r1.xy, r1, r8.zwzw
mad r15.xy, r1, r3.zxzw, r13
mov r16.x, r15.x
mov r16.z, r3.y
mov r15.x, r3.w
mad r16.y, v1.y, -c38.x, -c38.z
mov r16.w, v0.w
dp4 r1.x, r12, r16
mul r7, r7, c17.y
mad r7, c17.x, r9, r7
mad r7, c17.z, r10, r7
mad r7, c17.w, r11, r7
dp3 r4.z, r7, r4
dp3 r4.x, r7, r5.xyww
dp3 r4.y, r7, r6.xyww
dp4 r4.w, r7, r0
dp4 r1.y, r4, r16
mov r15.zw, r16.xyyw
add r0.xy, -r8, r1
mad o3.xy, r0, c43.z, c43.w
dp4 r0.x, r12, r15
dp4 r0.y, r4, r15
mov r14.yw, r15.xzzw
add r0.xy, -r8, r0
mad o4.xy, r0, c43.z, c43.w
slt r0.x, -r14.x, r14.x
slt r0.y, r14.x, -r14.x
add r0.x, -r0.y, r0.x
mul r0.x, r0.x, r1.w
mad r14.z, r0.x, r3.x, r13.z
dp4 r0.x, r12, r14
dp4 r0.y, r4, r14
add r0.xy, -r8, r0
mad o5.xy, r0, c43.z, c43.w
nrm r0.xyz, -r2
dp3 r0.w, c16, c16
rsq r0.w, r0.w
mul r1.xyz, r0.w, c16.yzxw
mul r3.xyz, r0.zxyw, r1
mad r1.xyz, r0.yzxw, r1.yzxw, -r3
dp3 r3.y, -r1, c26
dp3 r1.y, -r1, r2
dp3 r3.z, r0, c26
dp3 r1.z, r0, r2
dp3 r1.x, c16, r2
mov r0.xyz, c16
dp3 r3.x, r0, c26
dp3 r0.x, r3, r3
rsq r0.x, r0.x
mul o10.xyz, r0.x, r3
dp3 r0.x, r1, r1
rsq r0.x, r0.x
mul o9.xyz, r0.x, r1
mov o6.xy, v1
mov o7, c35.z

"
}
SubProgram "d3d11 " {
// Stats: 469 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "texcoord" TexCoord0
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 592
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 368 [_PosRotation]
Float 464 [_DistFade]
Float 468 [_DistFadeVert]
Float 484 [_Rotation]
Float 488 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityLighting" 720
Vector 0 [_WorldSpaceLightPos0]
ConstBuffer "UnityPerDraw" 352
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
ConstBuffer "UnityPerFrame" 256
Matrix 0 [glstate_matrix_projection]
Matrix 80 [unity_MatrixV]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityLighting" 2
BindCB  "UnityPerDraw" 3
BindCB  "UnityPerFrame" 4
"vs_4_0
root12:acafacaa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"
}
SubProgram "gles " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 glstate_matrix_projection;
uniform highp mat4 unity_MatrixV;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform highp mat4 _PosRotation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _Rotation;
uniform highp float _MaxScale;
uniform highp vec4 _NoiseScale;
uniform highp vec3 _MaxTrans;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  mediump vec3 normal_3;
  highp vec4 XYv_4;
  highp vec4 XZv_5;
  highp vec4 ZYv_6;
  highp vec4 localOrigin_7;
  highp vec4 planet_pos_8;
  highp vec4 origin_9;
  lowp vec4 tmpvar_10;
  mediump vec4 tmpvar_11;
  highp vec4 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_9 = tmpvar_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (_PosRotation * tmpvar_14);
  planet_pos_8 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (_NoiseScale.z * tmpvar_15.xyz);
  highp float tmpvar_17;
  highp vec4 m_18;
  highp vec3 tmpvar_19;
  tmpvar_19 = floor((tmpvar_16 + dot (tmpvar_16, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_20;
  tmpvar_20 = ((tmpvar_16 - tmpvar_19) + dot (tmpvar_19, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_21;
  tmpvar_21.x = float((tmpvar_20.x >= tmpvar_20.y));
  tmpvar_21.y = float((tmpvar_20.y >= tmpvar_20.z));
  tmpvar_21.z = float((tmpvar_20.z >= tmpvar_20.x));
  highp vec3 tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_21);
  highp vec3 tmpvar_23;
  tmpvar_23 = min (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_24;
  tmpvar_24 = max (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_25;
  tmpvar_25 = ((tmpvar_20 - tmpvar_23) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_26;
  tmpvar_26 = ((tmpvar_20 - tmpvar_24) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_27;
  tmpvar_27 = (tmpvar_20 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28 = (tmpvar_19 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (fract(abs(tmpvar_28)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_30;
  if ((tmpvar_28.x >= 0.0)) {
    tmpvar_30 = tmpvar_29.x;
  } else {
    tmpvar_30 = -(tmpvar_29.x);
  };
  highp float tmpvar_31;
  if ((tmpvar_28.y >= 0.0)) {
    tmpvar_31 = tmpvar_29.y;
  } else {
    tmpvar_31 = -(tmpvar_29.y);
  };
  highp float tmpvar_32;
  if ((tmpvar_28.z >= 0.0)) {
    tmpvar_32 = tmpvar_29.z;
  } else {
    tmpvar_32 = -(tmpvar_29.z);
  };
  highp vec4 tmpvar_33;
  tmpvar_33.xw = vec2(0.0, 1.0);
  tmpvar_33.y = tmpvar_23.z;
  tmpvar_33.z = tmpvar_24.z;
  highp vec4 x_34;
  x_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35 = (((
    (x_34 * x_34)
   * 34.0) + x_34) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_36;
  tmpvar_36 = (fract(abs(tmpvar_35)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_37;
  if ((tmpvar_35.x >= 0.0)) {
    tmpvar_37 = tmpvar_36.x;
  } else {
    tmpvar_37 = -(tmpvar_36.x);
  };
  highp float tmpvar_38;
  if ((tmpvar_35.y >= 0.0)) {
    tmpvar_38 = tmpvar_36.y;
  } else {
    tmpvar_38 = -(tmpvar_36.y);
  };
  highp float tmpvar_39;
  if ((tmpvar_35.z >= 0.0)) {
    tmpvar_39 = tmpvar_36.z;
  } else {
    tmpvar_39 = -(tmpvar_36.z);
  };
  highp float tmpvar_40;
  if ((tmpvar_35.w >= 0.0)) {
    tmpvar_40 = tmpvar_36.w;
  } else {
    tmpvar_40 = -(tmpvar_36.w);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.x = tmpvar_37;
  tmpvar_41.y = tmpvar_38;
  tmpvar_41.z = tmpvar_39;
  tmpvar_41.w = tmpvar_40;
  highp vec4 tmpvar_42;
  tmpvar_42.xw = vec2(0.0, 1.0);
  tmpvar_42.y = tmpvar_23.y;
  tmpvar_42.z = tmpvar_24.y;
  highp vec4 x_43;
  x_43 = ((tmpvar_41 + tmpvar_31) + tmpvar_42);
  highp vec4 tmpvar_44;
  tmpvar_44 = (((
    (x_43 * x_43)
   * 34.0) + x_43) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_45;
  tmpvar_45 = (fract(abs(tmpvar_44)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_46;
  if ((tmpvar_44.x >= 0.0)) {
    tmpvar_46 = tmpvar_45.x;
  } else {
    tmpvar_46 = -(tmpvar_45.x);
  };
  highp float tmpvar_47;
  if ((tmpvar_44.y >= 0.0)) {
    tmpvar_47 = tmpvar_45.y;
  } else {
    tmpvar_47 = -(tmpvar_45.y);
  };
  highp float tmpvar_48;
  if ((tmpvar_44.z >= 0.0)) {
    tmpvar_48 = tmpvar_45.z;
  } else {
    tmpvar_48 = -(tmpvar_45.z);
  };
  highp float tmpvar_49;
  if ((tmpvar_44.w >= 0.0)) {
    tmpvar_49 = tmpvar_45.w;
  } else {
    tmpvar_49 = -(tmpvar_45.w);
  };
  highp vec4 tmpvar_50;
  tmpvar_50.x = tmpvar_46;
  tmpvar_50.y = tmpvar_47;
  tmpvar_50.z = tmpvar_48;
  tmpvar_50.w = tmpvar_49;
  highp vec4 tmpvar_51;
  tmpvar_51.xw = vec2(0.0, 1.0);
  tmpvar_51.y = tmpvar_23.x;
  tmpvar_51.z = tmpvar_24.x;
  highp vec4 x_52;
  x_52 = ((tmpvar_50 + tmpvar_30) + tmpvar_51);
  highp vec4 tmpvar_53;
  tmpvar_53 = (((
    (x_52 * x_52)
   * 34.0) + x_52) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_54;
  tmpvar_54 = (fract(abs(tmpvar_53)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_55;
  if ((tmpvar_53.x >= 0.0)) {
    tmpvar_55 = tmpvar_54.x;
  } else {
    tmpvar_55 = -(tmpvar_54.x);
  };
  highp float tmpvar_56;
  if ((tmpvar_53.y >= 0.0)) {
    tmpvar_56 = tmpvar_54.y;
  } else {
    tmpvar_56 = -(tmpvar_54.y);
  };
  highp float tmpvar_57;
  if ((tmpvar_53.z >= 0.0)) {
    tmpvar_57 = tmpvar_54.z;
  } else {
    tmpvar_57 = -(tmpvar_54.z);
  };
  highp float tmpvar_58;
  if ((tmpvar_53.w >= 0.0)) {
    tmpvar_58 = tmpvar_54.w;
  } else {
    tmpvar_58 = -(tmpvar_54.w);
  };
  highp vec4 tmpvar_59;
  tmpvar_59.x = tmpvar_55;
  tmpvar_59.y = tmpvar_56;
  tmpvar_59.z = tmpvar_57;
  tmpvar_59.w = tmpvar_58;
  highp vec4 tmpvar_60;
  tmpvar_60 = (tmpvar_59 - (49.0 * floor(
    (0.02040815 * tmpvar_59)
  )));
  highp vec4 tmpvar_61;
  tmpvar_61 = floor((tmpvar_60 * 0.1428571));
  highp vec4 tmpvar_62;
  tmpvar_62 = ((tmpvar_61 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_63;
  tmpvar_63 = ((floor(
    (tmpvar_60 - (7.0 * tmpvar_61))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_64;
  tmpvar_64 = ((1.0 - abs(tmpvar_62)) - abs(tmpvar_63));
  highp vec4 tmpvar_65;
  tmpvar_65.xy = tmpvar_62.xy;
  tmpvar_65.zw = tmpvar_63.xy;
  highp vec4 tmpvar_66;
  tmpvar_66.xy = tmpvar_62.zw;
  tmpvar_66.zw = tmpvar_63.zw;
  highp vec4 tmpvar_67;
  tmpvar_67 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_64)));
  highp vec4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_67.xxyy));
  highp vec4 tmpvar_69;
  tmpvar_69 = (tmpvar_66.xzyw + ((
    (floor(tmpvar_66) * 2.0)
   + 1.0).xzyw * tmpvar_67.zzww));
  highp vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_68.xy;
  tmpvar_70.z = tmpvar_64.x;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.zw;
  tmpvar_71.z = tmpvar_64.y;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = tmpvar_69.xy;
  tmpvar_72.z = tmpvar_64.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = tmpvar_69.zw;
  tmpvar_73.z = tmpvar_64.w;
  highp vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_70, tmpvar_70);
  tmpvar_74.y = dot (tmpvar_71, tmpvar_71);
  tmpvar_74.z = dot (tmpvar_72, tmpvar_72);
  tmpvar_74.w = dot (tmpvar_73, tmpvar_73);
  highp vec4 tmpvar_75;
  tmpvar_75 = (1.792843 - (0.8537347 * tmpvar_74));
  highp vec4 tmpvar_76;
  tmpvar_76.x = dot (tmpvar_20, tmpvar_20);
  tmpvar_76.y = dot (tmpvar_25, tmpvar_25);
  tmpvar_76.z = dot (tmpvar_26, tmpvar_26);
  tmpvar_76.w = dot (tmpvar_27, tmpvar_27);
  highp vec4 tmpvar_77;
  tmpvar_77 = max ((0.6 - tmpvar_76), vec4(0.0, 0.0, 0.0, 0.0));
  m_18 = (tmpvar_77 * tmpvar_77);
  highp vec4 tmpvar_78;
  tmpvar_78.x = dot ((tmpvar_70 * tmpvar_75.x), tmpvar_20);
  tmpvar_78.y = dot ((tmpvar_71 * tmpvar_75.y), tmpvar_25);
  tmpvar_78.z = dot ((tmpvar_72 * tmpvar_75.z), tmpvar_26);
  tmpvar_78.w = dot ((tmpvar_73 * tmpvar_75.w), tmpvar_27);
  tmpvar_17 = (42.0 * dot ((m_18 * m_18), tmpvar_78));
  highp float tmpvar_79;
  highp vec3 v_80;
  v_80 = (_NoiseScale.x * tmpvar_16);
  highp vec4 m_81;
  highp vec3 tmpvar_82;
  tmpvar_82 = floor((v_80 + dot (v_80, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_83;
  tmpvar_83 = ((v_80 - tmpvar_82) + dot (tmpvar_82, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_84;
  tmpvar_84.x = float((tmpvar_83.x >= tmpvar_83.y));
  tmpvar_84.y = float((tmpvar_83.y >= tmpvar_83.z));
  tmpvar_84.z = float((tmpvar_83.z >= tmpvar_83.x));
  highp vec3 tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_84);
  highp vec3 tmpvar_86;
  tmpvar_86 = min (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_87;
  tmpvar_87 = max (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_88;
  tmpvar_88 = ((tmpvar_83 - tmpvar_86) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_89;
  tmpvar_89 = ((tmpvar_83 - tmpvar_87) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_90;
  tmpvar_90 = (tmpvar_83 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_91;
  tmpvar_91 = (tmpvar_82 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = (fract(abs(tmpvar_91)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_93;
  if ((tmpvar_91.x >= 0.0)) {
    tmpvar_93 = tmpvar_92.x;
  } else {
    tmpvar_93 = -(tmpvar_92.x);
  };
  highp float tmpvar_94;
  if ((tmpvar_91.y >= 0.0)) {
    tmpvar_94 = tmpvar_92.y;
  } else {
    tmpvar_94 = -(tmpvar_92.y);
  };
  highp float tmpvar_95;
  if ((tmpvar_91.z >= 0.0)) {
    tmpvar_95 = tmpvar_92.z;
  } else {
    tmpvar_95 = -(tmpvar_92.z);
  };
  highp vec4 tmpvar_96;
  tmpvar_96.xw = vec2(0.0, 1.0);
  tmpvar_96.y = tmpvar_86.z;
  tmpvar_96.z = tmpvar_87.z;
  highp vec4 x_97;
  x_97 = (tmpvar_95 + tmpvar_96);
  highp vec4 tmpvar_98;
  tmpvar_98 = (((
    (x_97 * x_97)
   * 34.0) + x_97) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_99;
  tmpvar_99 = (fract(abs(tmpvar_98)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_100;
  if ((tmpvar_98.x >= 0.0)) {
    tmpvar_100 = tmpvar_99.x;
  } else {
    tmpvar_100 = -(tmpvar_99.x);
  };
  highp float tmpvar_101;
  if ((tmpvar_98.y >= 0.0)) {
    tmpvar_101 = tmpvar_99.y;
  } else {
    tmpvar_101 = -(tmpvar_99.y);
  };
  highp float tmpvar_102;
  if ((tmpvar_98.z >= 0.0)) {
    tmpvar_102 = tmpvar_99.z;
  } else {
    tmpvar_102 = -(tmpvar_99.z);
  };
  highp float tmpvar_103;
  if ((tmpvar_98.w >= 0.0)) {
    tmpvar_103 = tmpvar_99.w;
  } else {
    tmpvar_103 = -(tmpvar_99.w);
  };
  highp vec4 tmpvar_104;
  tmpvar_104.x = tmpvar_100;
  tmpvar_104.y = tmpvar_101;
  tmpvar_104.z = tmpvar_102;
  tmpvar_104.w = tmpvar_103;
  highp vec4 tmpvar_105;
  tmpvar_105.xw = vec2(0.0, 1.0);
  tmpvar_105.y = tmpvar_86.y;
  tmpvar_105.z = tmpvar_87.y;
  highp vec4 x_106;
  x_106 = ((tmpvar_104 + tmpvar_94) + tmpvar_105);
  highp vec4 tmpvar_107;
  tmpvar_107 = (((
    (x_106 * x_106)
   * 34.0) + x_106) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_108;
  tmpvar_108 = (fract(abs(tmpvar_107)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_109;
  if ((tmpvar_107.x >= 0.0)) {
    tmpvar_109 = tmpvar_108.x;
  } else {
    tmpvar_109 = -(tmpvar_108.x);
  };
  highp float tmpvar_110;
  if ((tmpvar_107.y >= 0.0)) {
    tmpvar_110 = tmpvar_108.y;
  } else {
    tmpvar_110 = -(tmpvar_108.y);
  };
  highp float tmpvar_111;
  if ((tmpvar_107.z >= 0.0)) {
    tmpvar_111 = tmpvar_108.z;
  } else {
    tmpvar_111 = -(tmpvar_108.z);
  };
  highp float tmpvar_112;
  if ((tmpvar_107.w >= 0.0)) {
    tmpvar_112 = tmpvar_108.w;
  } else {
    tmpvar_112 = -(tmpvar_108.w);
  };
  highp vec4 tmpvar_113;
  tmpvar_113.x = tmpvar_109;
  tmpvar_113.y = tmpvar_110;
  tmpvar_113.z = tmpvar_111;
  tmpvar_113.w = tmpvar_112;
  highp vec4 tmpvar_114;
  tmpvar_114.xw = vec2(0.0, 1.0);
  tmpvar_114.y = tmpvar_86.x;
  tmpvar_114.z = tmpvar_87.x;
  highp vec4 x_115;
  x_115 = ((tmpvar_113 + tmpvar_93) + tmpvar_114);
  highp vec4 tmpvar_116;
  tmpvar_116 = (((
    (x_115 * x_115)
   * 34.0) + x_115) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_117;
  tmpvar_117 = (fract(abs(tmpvar_116)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_118;
  if ((tmpvar_116.x >= 0.0)) {
    tmpvar_118 = tmpvar_117.x;
  } else {
    tmpvar_118 = -(tmpvar_117.x);
  };
  highp float tmpvar_119;
  if ((tmpvar_116.y >= 0.0)) {
    tmpvar_119 = tmpvar_117.y;
  } else {
    tmpvar_119 = -(tmpvar_117.y);
  };
  highp float tmpvar_120;
  if ((tmpvar_116.z >= 0.0)) {
    tmpvar_120 = tmpvar_117.z;
  } else {
    tmpvar_120 = -(tmpvar_117.z);
  };
  highp float tmpvar_121;
  if ((tmpvar_116.w >= 0.0)) {
    tmpvar_121 = tmpvar_117.w;
  } else {
    tmpvar_121 = -(tmpvar_117.w);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.x = tmpvar_118;
  tmpvar_122.y = tmpvar_119;
  tmpvar_122.z = tmpvar_120;
  tmpvar_122.w = tmpvar_121;
  highp vec4 tmpvar_123;
  tmpvar_123 = (tmpvar_122 - (49.0 * floor(
    (0.02040815 * tmpvar_122)
  )));
  highp vec4 tmpvar_124;
  tmpvar_124 = floor((tmpvar_123 * 0.1428571));
  highp vec4 tmpvar_125;
  tmpvar_125 = ((tmpvar_124 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_126;
  tmpvar_126 = ((floor(
    (tmpvar_123 - (7.0 * tmpvar_124))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_127;
  tmpvar_127 = ((1.0 - abs(tmpvar_125)) - abs(tmpvar_126));
  highp vec4 tmpvar_128;
  tmpvar_128.xy = tmpvar_125.xy;
  tmpvar_128.zw = tmpvar_126.xy;
  highp vec4 tmpvar_129;
  tmpvar_129.xy = tmpvar_125.zw;
  tmpvar_129.zw = tmpvar_126.zw;
  highp vec4 tmpvar_130;
  tmpvar_130 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_127)));
  highp vec4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_130.xxyy));
  highp vec4 tmpvar_132;
  tmpvar_132 = (tmpvar_129.xzyw + ((
    (floor(tmpvar_129) * 2.0)
   + 1.0).xzyw * tmpvar_130.zzww));
  highp vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_131.xy;
  tmpvar_133.z = tmpvar_127.x;
  highp vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.zw;
  tmpvar_134.z = tmpvar_127.y;
  highp vec3 tmpvar_135;
  tmpvar_135.xy = tmpvar_132.xy;
  tmpvar_135.z = tmpvar_127.z;
  highp vec3 tmpvar_136;
  tmpvar_136.xy = tmpvar_132.zw;
  tmpvar_136.z = tmpvar_127.w;
  highp vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_133, tmpvar_133);
  tmpvar_137.y = dot (tmpvar_134, tmpvar_134);
  tmpvar_137.z = dot (tmpvar_135, tmpvar_135);
  tmpvar_137.w = dot (tmpvar_136, tmpvar_136);
  highp vec4 tmpvar_138;
  tmpvar_138 = (1.792843 - (0.8537347 * tmpvar_137));
  highp vec4 tmpvar_139;
  tmpvar_139.x = dot (tmpvar_83, tmpvar_83);
  tmpvar_139.y = dot (tmpvar_88, tmpvar_88);
  tmpvar_139.z = dot (tmpvar_89, tmpvar_89);
  tmpvar_139.w = dot (tmpvar_90, tmpvar_90);
  highp vec4 tmpvar_140;
  tmpvar_140 = max ((0.6 - tmpvar_139), vec4(0.0, 0.0, 0.0, 0.0));
  m_81 = (tmpvar_140 * tmpvar_140);
  highp vec4 tmpvar_141;
  tmpvar_141.x = dot ((tmpvar_133 * tmpvar_138.x), tmpvar_83);
  tmpvar_141.y = dot ((tmpvar_134 * tmpvar_138.y), tmpvar_88);
  tmpvar_141.z = dot ((tmpvar_135 * tmpvar_138.z), tmpvar_89);
  tmpvar_141.w = dot ((tmpvar_136 * tmpvar_138.w), tmpvar_90);
  tmpvar_79 = (42.0 * dot ((m_81 * m_81), tmpvar_141));
  highp vec3 v_142;
  v_142 = (_NoiseScale.y * tmpvar_16);
  highp vec4 m_143;
  highp vec3 tmpvar_144;
  tmpvar_144 = floor((v_142 + dot (v_142, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_145;
  tmpvar_145 = ((v_142 - tmpvar_144) + dot (tmpvar_144, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_146;
  tmpvar_146.x = float((tmpvar_145.x >= tmpvar_145.y));
  tmpvar_146.y = float((tmpvar_145.y >= tmpvar_145.z));
  tmpvar_146.z = float((tmpvar_145.z >= tmpvar_145.x));
  highp vec3 tmpvar_147;
  tmpvar_147 = (1.0 - tmpvar_146);
  highp vec3 tmpvar_148;
  tmpvar_148 = min (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_149;
  tmpvar_149 = max (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_150;
  tmpvar_150 = ((tmpvar_145 - tmpvar_148) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_151;
  tmpvar_151 = ((tmpvar_145 - tmpvar_149) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_152;
  tmpvar_152 = (tmpvar_145 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_153;
  tmpvar_153 = (tmpvar_144 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_154;
  tmpvar_154 = (fract(abs(tmpvar_153)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_155;
  if ((tmpvar_153.x >= 0.0)) {
    tmpvar_155 = tmpvar_154.x;
  } else {
    tmpvar_155 = -(tmpvar_154.x);
  };
  highp float tmpvar_156;
  if ((tmpvar_153.y >= 0.0)) {
    tmpvar_156 = tmpvar_154.y;
  } else {
    tmpvar_156 = -(tmpvar_154.y);
  };
  highp float tmpvar_157;
  if ((tmpvar_153.z >= 0.0)) {
    tmpvar_157 = tmpvar_154.z;
  } else {
    tmpvar_157 = -(tmpvar_154.z);
  };
  highp vec4 tmpvar_158;
  tmpvar_158.xw = vec2(0.0, 1.0);
  tmpvar_158.y = tmpvar_148.z;
  tmpvar_158.z = tmpvar_149.z;
  highp vec4 x_159;
  x_159 = (tmpvar_157 + tmpvar_158);
  highp vec4 tmpvar_160;
  tmpvar_160 = (((
    (x_159 * x_159)
   * 34.0) + x_159) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_161;
  tmpvar_161 = (fract(abs(tmpvar_160)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_162;
  if ((tmpvar_160.x >= 0.0)) {
    tmpvar_162 = tmpvar_161.x;
  } else {
    tmpvar_162 = -(tmpvar_161.x);
  };
  highp float tmpvar_163;
  if ((tmpvar_160.y >= 0.0)) {
    tmpvar_163 = tmpvar_161.y;
  } else {
    tmpvar_163 = -(tmpvar_161.y);
  };
  highp float tmpvar_164;
  if ((tmpvar_160.z >= 0.0)) {
    tmpvar_164 = tmpvar_161.z;
  } else {
    tmpvar_164 = -(tmpvar_161.z);
  };
  highp float tmpvar_165;
  if ((tmpvar_160.w >= 0.0)) {
    tmpvar_165 = tmpvar_161.w;
  } else {
    tmpvar_165 = -(tmpvar_161.w);
  };
  highp vec4 tmpvar_166;
  tmpvar_166.x = tmpvar_162;
  tmpvar_166.y = tmpvar_163;
  tmpvar_166.z = tmpvar_164;
  tmpvar_166.w = tmpvar_165;
  highp vec4 tmpvar_167;
  tmpvar_167.xw = vec2(0.0, 1.0);
  tmpvar_167.y = tmpvar_148.y;
  tmpvar_167.z = tmpvar_149.y;
  highp vec4 x_168;
  x_168 = ((tmpvar_166 + tmpvar_156) + tmpvar_167);
  highp vec4 tmpvar_169;
  tmpvar_169 = (((
    (x_168 * x_168)
   * 34.0) + x_168) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_170;
  tmpvar_170 = (fract(abs(tmpvar_169)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_171;
  if ((tmpvar_169.x >= 0.0)) {
    tmpvar_171 = tmpvar_170.x;
  } else {
    tmpvar_171 = -(tmpvar_170.x);
  };
  highp float tmpvar_172;
  if ((tmpvar_169.y >= 0.0)) {
    tmpvar_172 = tmpvar_170.y;
  } else {
    tmpvar_172 = -(tmpvar_170.y);
  };
  highp float tmpvar_173;
  if ((tmpvar_169.z >= 0.0)) {
    tmpvar_173 = tmpvar_170.z;
  } else {
    tmpvar_173 = -(tmpvar_170.z);
  };
  highp float tmpvar_174;
  if ((tmpvar_169.w >= 0.0)) {
    tmpvar_174 = tmpvar_170.w;
  } else {
    tmpvar_174 = -(tmpvar_170.w);
  };
  highp vec4 tmpvar_175;
  tmpvar_175.x = tmpvar_171;
  tmpvar_175.y = tmpvar_172;
  tmpvar_175.z = tmpvar_173;
  tmpvar_175.w = tmpvar_174;
  highp vec4 tmpvar_176;
  tmpvar_176.xw = vec2(0.0, 1.0);
  tmpvar_176.y = tmpvar_148.x;
  tmpvar_176.z = tmpvar_149.x;
  highp vec4 x_177;
  x_177 = ((tmpvar_175 + tmpvar_155) + tmpvar_176);
  highp vec4 tmpvar_178;
  tmpvar_178 = (((
    (x_177 * x_177)
   * 34.0) + x_177) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_179;
  tmpvar_179 = (fract(abs(tmpvar_178)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_180;
  if ((tmpvar_178.x >= 0.0)) {
    tmpvar_180 = tmpvar_179.x;
  } else {
    tmpvar_180 = -(tmpvar_179.x);
  };
  highp float tmpvar_181;
  if ((tmpvar_178.y >= 0.0)) {
    tmpvar_181 = tmpvar_179.y;
  } else {
    tmpvar_181 = -(tmpvar_179.y);
  };
  highp float tmpvar_182;
  if ((tmpvar_178.z >= 0.0)) {
    tmpvar_182 = tmpvar_179.z;
  } else {
    tmpvar_182 = -(tmpvar_179.z);
  };
  highp float tmpvar_183;
  if ((tmpvar_178.w >= 0.0)) {
    tmpvar_183 = tmpvar_179.w;
  } else {
    tmpvar_183 = -(tmpvar_179.w);
  };
  highp vec4 tmpvar_184;
  tmpvar_184.x = tmpvar_180;
  tmpvar_184.y = tmpvar_181;
  tmpvar_184.z = tmpvar_182;
  tmpvar_184.w = tmpvar_183;
  highp vec4 tmpvar_185;
  tmpvar_185 = (tmpvar_184 - (49.0 * floor(
    (0.02040815 * tmpvar_184)
  )));
  highp vec4 tmpvar_186;
  tmpvar_186 = floor((tmpvar_185 * 0.1428571));
  highp vec4 tmpvar_187;
  tmpvar_187 = ((tmpvar_186 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_188;
  tmpvar_188 = ((floor(
    (tmpvar_185 - (7.0 * tmpvar_186))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_189;
  tmpvar_189 = ((1.0 - abs(tmpvar_187)) - abs(tmpvar_188));
  highp vec4 tmpvar_190;
  tmpvar_190.xy = tmpvar_187.xy;
  tmpvar_190.zw = tmpvar_188.xy;
  highp vec4 tmpvar_191;
  tmpvar_191.xy = tmpvar_187.zw;
  tmpvar_191.zw = tmpvar_188.zw;
  highp vec4 tmpvar_192;
  tmpvar_192 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_189)));
  highp vec4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_192.xxyy));
  highp vec4 tmpvar_194;
  tmpvar_194 = (tmpvar_191.xzyw + ((
    (floor(tmpvar_191) * 2.0)
   + 1.0).xzyw * tmpvar_192.zzww));
  highp vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_193.xy;
  tmpvar_195.z = tmpvar_189.x;
  highp vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.zw;
  tmpvar_196.z = tmpvar_189.y;
  highp vec3 tmpvar_197;
  tmpvar_197.xy = tmpvar_194.xy;
  tmpvar_197.z = tmpvar_189.z;
  highp vec3 tmpvar_198;
  tmpvar_198.xy = tmpvar_194.zw;
  tmpvar_198.z = tmpvar_189.w;
  highp vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_195, tmpvar_195);
  tmpvar_199.y = dot (tmpvar_196, tmpvar_196);
  tmpvar_199.z = dot (tmpvar_197, tmpvar_197);
  tmpvar_199.w = dot (tmpvar_198, tmpvar_198);
  highp vec4 tmpvar_200;
  tmpvar_200 = (1.792843 - (0.8537347 * tmpvar_199));
  highp vec4 tmpvar_201;
  tmpvar_201.x = dot (tmpvar_145, tmpvar_145);
  tmpvar_201.y = dot (tmpvar_150, tmpvar_150);
  tmpvar_201.z = dot (tmpvar_151, tmpvar_151);
  tmpvar_201.w = dot (tmpvar_152, tmpvar_152);
  highp vec4 tmpvar_202;
  tmpvar_202 = max ((0.6 - tmpvar_201), vec4(0.0, 0.0, 0.0, 0.0));
  m_143 = (tmpvar_202 * tmpvar_202);
  highp vec4 tmpvar_203;
  tmpvar_203.x = dot ((tmpvar_195 * tmpvar_200.x), tmpvar_145);
  tmpvar_203.y = dot ((tmpvar_196 * tmpvar_200.y), tmpvar_150);
  tmpvar_203.z = dot ((tmpvar_197 * tmpvar_200.z), tmpvar_151);
  tmpvar_203.w = dot ((tmpvar_198 * tmpvar_200.w), tmpvar_152);
  highp vec3 tmpvar_204;
  tmpvar_204.x = tmpvar_17;
  tmpvar_204.y = tmpvar_79;
  tmpvar_204.z = (42.0 * dot ((m_143 * m_143), tmpvar_203));
  highp vec3 tmpvar_205;
  tmpvar_205 = (0.5 * (tmpvar_204 + 1.0));
  localOrigin_7.xyz = (((2.0 * tmpvar_205) - 1.0) * _MaxTrans);
  localOrigin_7.w = 1.0;
  highp float tmpvar_206;
  tmpvar_206 = ((tmpvar_205.x * (_MaxScale - 1.0)) + 1.0);
  origin_9 = (_Object2World * localOrigin_7);
  planet_pos_8 = (_MainRotation * origin_9);
  highp vec3 tmpvar_207;
  tmpvar_207 = (_DetailRotation * planet_pos_8).xyz;
  tmpvar_13 = planet_pos_8.xyz;
  highp vec3 tmpvar_208;
  tmpvar_208 = normalize(planet_pos_8.xyz);
  highp vec2 uv_209;
  highp float tmpvar_210;
  highp float tmpvar_211;
  tmpvar_211 = (min (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0) / max (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0));
  highp float tmpvar_212;
  tmpvar_212 = (tmpvar_211 * tmpvar_211);
  tmpvar_212 = (((
    ((((
      ((((-0.01213232 * tmpvar_212) + 0.05368138) * tmpvar_212) - 0.1173503)
     * tmpvar_212) + 0.1938925) * tmpvar_212) - 0.3326756)
   * tmpvar_212) + 0.9999793) * tmpvar_211);
  tmpvar_212 = (tmpvar_212 + (float(
    (abs((tmpvar_208.x / tmpvar_208.z)) > 1.0)
  ) * (
    (tmpvar_212 * -2.0)
   + 1.570796)));
  tmpvar_210 = (tmpvar_212 * sign((tmpvar_208.x / tmpvar_208.z)));
  if ((abs(tmpvar_208.z) > (1e-08 * abs(tmpvar_208.x)))) {
    if ((tmpvar_208.z < 0.0)) {
      if ((tmpvar_208.x >= 0.0)) {
        tmpvar_210 += 3.141593;
      } else {
        tmpvar_210 = (tmpvar_210 - 3.141593);
      };
    };
  } else {
    tmpvar_210 = (sign(tmpvar_208.x) * 1.570796);
  };
  uv_209.x = (0.5 + (0.1591549 * tmpvar_210));
  uv_209.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_208.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_208.y)
    )) * (1.570796 + (
      abs(tmpvar_208.y)
     * 
      (-0.2146018 + (abs(tmpvar_208.y) * (0.08656672 + (
        abs(tmpvar_208.y)
       * -0.03102955))))
    ))))
  )));
  lowp vec4 tmpvar_213;
  tmpvar_213 = texture2DLod (_MainTex, uv_209, 0.0);
  mediump vec4 tmpvar_214;
  tmpvar_214 = tmpvar_213;
  tmpvar_10 = tmpvar_214;
  mediump vec3 detailCoords_215;
  mediump float s_216;
  mediump float nylerp_217;
  mediump float zxlerp_218;
  highp vec4 uv4_219;
  uv4_219.zw = vec2(0.0, 0.0);
  highp vec3 tmpvar_220;
  tmpvar_220 = normalize(tmpvar_207);
  highp vec3 tmpvar_221;
  tmpvar_221 = abs(tmpvar_220);
  highp float tmpvar_222;
  tmpvar_222 = float((tmpvar_221.z >= tmpvar_221.x));
  zxlerp_218 = tmpvar_222;
  highp float tmpvar_223;
  tmpvar_223 = float((max (tmpvar_221.x, tmpvar_221.z) >= tmpvar_221.y));
  nylerp_217 = tmpvar_223;
  highp float tmpvar_224;
  tmpvar_224 = mix (tmpvar_220.x, tmpvar_220.z, zxlerp_218);
  s_216 = tmpvar_224;
  highp float tmpvar_225;
  tmpvar_225 = sign(mix (tmpvar_220.y, s_216, nylerp_217));
  s_216 = tmpvar_225;
  mediump vec3 tmpvar_226;
  tmpvar_226.xz = vec2(1.0, -1.0);
  tmpvar_226.y = -(s_216);
  mediump vec3 tmpvar_227;
  tmpvar_227.xz = vec2(1.0, -1.0);
  tmpvar_227.y = s_216;
  highp vec3 tmpvar_228;
  tmpvar_228 = mix ((tmpvar_226 * tmpvar_220.xzy), (tmpvar_227 * tmpvar_220.zxy), vec3(zxlerp_218));
  detailCoords_215 = tmpvar_228;
  mediump vec3 tmpvar_229;
  tmpvar_229.xy = vec2(1.0, 1.0);
  tmpvar_229.z = s_216;
  highp vec3 tmpvar_230;
  tmpvar_230 = mix ((tmpvar_229 * tmpvar_220.yxz), detailCoords_215, vec3(nylerp_217));
  detailCoords_215 = tmpvar_230;
  mediump vec2 tmpvar_231;
  tmpvar_231 = (((0.5 * detailCoords_215.yz) / abs(detailCoords_215.x)) + 0.5);
  uv4_219.xy = tmpvar_231;
  lowp vec4 tmpvar_232;
  tmpvar_232 = texture2DLod (_DetailTex, uv4_219.xy, 0.0);
  mediump vec4 tmpvar_233;
  tmpvar_233 = tmpvar_232;
  tmpvar_10 = (tmpvar_10 * tmpvar_233);
  highp vec4 tmpvar_234;
  tmpvar_234.w = 0.0;
  tmpvar_234.xyz = _WorldSpaceCameraPos;
  highp float tmpvar_235;
  highp vec4 tmpvar_236;
  tmpvar_236 = (origin_9 - tmpvar_234);
  tmpvar_235 = sqrt(dot (tmpvar_236, tmpvar_236));
  highp float tmpvar_237;
  tmpvar_237 = (clamp ((_DistFade * tmpvar_235), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_235)
  ), 0.0, 1.0));
  tmpvar_11.w = tmpvar_237;
  tmpvar_10.w = (tmpvar_10.w * tmpvar_11.w);
  highp vec3 tmpvar_238;
  tmpvar_238.yz = vec2(0.0, 0.0);
  tmpvar_238.x = fract(_Rotation);
  highp vec3 x_239;
  x_239 = (tmpvar_238 + tmpvar_205);
  highp vec3 trans_240;
  trans_240 = localOrigin_7.xyz;
  highp float tmpvar_241;
  tmpvar_241 = (x_239.x * 6.283185);
  highp float tmpvar_242;
  tmpvar_242 = (x_239.y * 6.283185);
  highp float tmpvar_243;
  tmpvar_243 = (x_239.z * 2.0);
  highp float tmpvar_244;
  tmpvar_244 = sqrt(tmpvar_243);
  highp float tmpvar_245;
  tmpvar_245 = (sin(tmpvar_242) * tmpvar_244);
  highp float tmpvar_246;
  tmpvar_246 = (cos(tmpvar_242) * tmpvar_244);
  highp float tmpvar_247;
  tmpvar_247 = sqrt((2.0 - tmpvar_243));
  highp float tmpvar_248;
  tmpvar_248 = sin(tmpvar_241);
  highp float tmpvar_249;
  tmpvar_249 = cos(tmpvar_241);
  highp float tmpvar_250;
  tmpvar_250 = ((tmpvar_245 * tmpvar_249) - (tmpvar_246 * tmpvar_248));
  highp float tmpvar_251;
  tmpvar_251 = ((tmpvar_245 * tmpvar_248) + (tmpvar_246 * tmpvar_249));
  highp mat4 tmpvar_252;
  tmpvar_252[0].x = (tmpvar_206 * ((tmpvar_245 * tmpvar_250) - tmpvar_249));
  tmpvar_252[0].y = ((tmpvar_245 * tmpvar_251) - tmpvar_248);
  tmpvar_252[0].z = (tmpvar_245 * tmpvar_247);
  tmpvar_252[0].w = 0.0;
  tmpvar_252[1].x = ((tmpvar_246 * tmpvar_250) + tmpvar_248);
  tmpvar_252[1].y = (tmpvar_206 * ((tmpvar_246 * tmpvar_251) - tmpvar_249));
  tmpvar_252[1].z = (tmpvar_246 * tmpvar_247);
  tmpvar_252[1].w = 0.0;
  tmpvar_252[2].x = (tmpvar_247 * tmpvar_250);
  tmpvar_252[2].y = (tmpvar_247 * tmpvar_251);
  tmpvar_252[2].z = (tmpvar_206 * (1.0 - tmpvar_243));
  tmpvar_252[2].w = 0.0;
  tmpvar_252[3].x = trans_240.x;
  tmpvar_252[3].y = trans_240.y;
  tmpvar_252[3].z = trans_240.z;
  tmpvar_252[3].w = 1.0;
  highp mat4 tmpvar_253;
  tmpvar_253 = ((unity_MatrixV * _Object2World) * tmpvar_252);
  highp vec4 v_254;
  v_254.x = tmpvar_253[0].z;
  v_254.y = tmpvar_253[1].z;
  v_254.z = tmpvar_253[2].z;
  v_254.w = tmpvar_253[3].z;
  highp vec3 tmpvar_255;
  tmpvar_255 = normalize(v_254.xyz);
  highp vec3 tmpvar_256;
  tmpvar_256 = abs(tmpvar_255);
  tmpvar_11.xyz = tmpvar_256;
  highp vec4 tmpvar_257;
  tmpvar_257 = (glstate_matrix_modelview0 * localOrigin_7);
  highp vec4 tmpvar_258;
  tmpvar_258.xyz = (_glesVertex.xyz * tmpvar_206);
  tmpvar_258.w = tmpvar_1.w;
  highp vec2 tmpvar_259;
  tmpvar_259 = ((2.0 * _glesMultiTexCoord0.xy) - 1.0);
  highp vec4 tmpvar_260;
  tmpvar_260.z = 0.0;
  tmpvar_260.xy = tmpvar_259;
  tmpvar_260.w = tmpvar_1.w;
  ZYv_6.xyw = tmpvar_260.zyw;
  XZv_5.yzw = tmpvar_260.zyw;
  XYv_4.yzw = tmpvar_260.yzw;
  ZYv_6.z = (tmpvar_259.x * sign(-(tmpvar_255.x)));
  XZv_5.x = (tmpvar_259.x * sign(-(tmpvar_255.y)));
  XYv_4.x = (tmpvar_259.x * sign(tmpvar_255.z));
  ZYv_6.x = ((sign(
    -(tmpvar_255.x)
  ) * sign(ZYv_6.z)) * tmpvar_255.z);
  XZv_5.y = ((sign(
    -(tmpvar_255.y)
  ) * sign(XZv_5.x)) * tmpvar_255.x);
  XYv_4.z = ((sign(
    -(tmpvar_255.z)
  ) * sign(XYv_4.x)) * tmpvar_255.x);
  ZYv_6.x = (ZYv_6.x + ((
    sign(-(tmpvar_255.x))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  XZv_5.y = (XZv_5.y + ((
    sign(-(tmpvar_255.y))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.z));
  XYv_4.z = (XYv_4.z + ((
    sign(-(tmpvar_255.z))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  highp vec3 tmpvar_261;
  tmpvar_261 = normalize((origin_9.xyz - _WorldSpaceCameraPos));
  highp vec3 tmpvar_262;
  tmpvar_262 = normalize(-(tmpvar_261));
  normal_3 = tmpvar_262;
  highp vec4 v_263;
  v_263.x = unity_MatrixV[0].x;
  v_263.y = unity_MatrixV[1].x;
  v_263.z = unity_MatrixV[2].x;
  v_263.w = unity_MatrixV[3].x;
  highp vec3 tmpvar_264;
  tmpvar_264 = normalize(v_263.xyz);
  highp vec3 tmpvar_265;
  highp vec3 tmpvar_266;
  tmpvar_265 = v_263.xyz;
  tmpvar_266 = ((normal_3.zxy * tmpvar_264.yzx) - (normal_3.yzx * tmpvar_264.zxy));
  highp vec3 tmpvar_267;
  tmpvar_267 = normal_3;
  highp mat3 tmpvar_268;
  tmpvar_268[0].x = tmpvar_265.x;
  tmpvar_268[0].y = tmpvar_266.x;
  tmpvar_268[0].z = tmpvar_267.x;
  tmpvar_268[1].x = tmpvar_265.y;
  tmpvar_268[1].y = tmpvar_266.y;
  tmpvar_268[1].z = tmpvar_267.y;
  tmpvar_268[2].x = tmpvar_265.z;
  tmpvar_268[2].y = tmpvar_266.z;
  tmpvar_268[2].z = tmpvar_267.z;
  gl_Position = (glstate_matrix_projection * (tmpvar_257 + tmpvar_258));
  xlv_COLOR = tmpvar_10;
  xlv_TEXCOORD0 = tmpvar_11;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * ZYv_6)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XZv_5)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XYv_4)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD4 = tmpvar_2;
  xlv_TEXCOORD5 = tmpvar_12;
  xlv_TEXCOORD6 = tmpvar_13;
  xlv_TEXCOORD7 = normalize((tmpvar_268 * tmpvar_261));
  xlv_TEXCOORD8 = normalize((tmpvar_268 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform lowp vec4 _LightColor0;
uniform sampler2D _Tex;
uniform lowp vec4 _Color;
uniform highp float _MinScatter;
uniform highp float _Opacity;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec3 normT_2;
  mediump vec4 color_3;
  mediump vec4 tex_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_Tex, xlv_TEXCOORD1);
  tex_4.x = tmpvar_5.x;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex, xlv_TEXCOORD2);
  tex_4.y = tmpvar_6.y;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex, xlv_TEXCOORD3);
  tex_4.z = tmpvar_7.z;
  tex_4.w = 0.0;
  tex_4.xyz = (tex_4.xyz * xlv_TEXCOORD0.xyz);
  tex_4 = (tex_4 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  mediump float tmpvar_8;
  tmpvar_8 = ((tex_4.x + tex_4.y) + (tex_4.z + tex_4.w));
  mediump vec4 tmpvar_9;
  tmpvar_9.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_9.w = tmpvar_8;
  tex_4.xyz = tmpvar_9.xyz;
  color_3 = (_Color * xlv_COLOR);
  normT_2.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_2.z = sqrt((1.0 - clamp (
    dot (normT_2.xy, normT_2.xy)
  , 0.0, 1.0)));
  color_3.w = (color_3.w * tmpvar_8);
  tex_4.w = (xlv_TEXCOORD0.w * tmpvar_8);
  mediump vec3 lightDir_10;
  lightDir_10 = xlv_TEXCOORD8;
  mediump vec3 viewDir_11;
  viewDir_11 = xlv_TEXCOORD7;
  mediump vec4 c_12;
  highp float h_13;
  mediump vec3 tmpvar_14;
  tmpvar_14 = normalize(lightDir_10);
  lightDir_10 = tmpvar_14;
  mediump vec3 tmpvar_15;
  tmpvar_15 = normalize(viewDir_11);
  viewDir_11 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16 = normalize(normT_2);
  mediump float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_16, tmpvar_14), 0.0);
  mediump float tmpvar_18;
  tmpvar_18 = (0.5 + (0.5 * dot (tmpvar_15, tmpvar_14)));
  h_13 = tmpvar_18;
  mediump float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, tmpvar_15);
  highp float tmpvar_20;
  tmpvar_20 = clamp (((
    (_MinScatter - (_Opacity * tex_4.w))
   * 
    (1.0 - tmpvar_19)
  ) * h_13), 0.0, 1.0);
  c_12.xyz = ((_LightColor0.xyz * (vec3(tmpvar_17) + tmpvar_20)) * 2.0);
  c_12.w = (tmpvar_17 * 2.0);
  color_3.xyz = (color_3.xyz * c_12.xyz);
  tmpvar_1 = color_3;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 in_POSITION0;
in highp vec2 in_TEXCOORD0;
out lowp vec4 vs_COLOR0;
out mediump vec4 vs_TEXCOORD0;
out highp vec2 vs_TEXCOORD1;
out highp vec2 vs_TEXCOORD2;
out highp vec2 vs_TEXCOORD3;
out highp vec2 vs_TEXCOORD4;
out highp vec4 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD7;
out highp vec3 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
bvec4 tb1;
highp vec4 t2;
highp vec4 t3;
bvec3 tb3;
highp vec4 t4;
mediump vec4 t16_4;
bvec4 tb4;
highp vec4 t5;
highp ivec3 ti5;
bvec4 tb5;
highp vec4 t6;
bvec3 tb6;
highp vec4 t7;
bvec4 tb7;
highp vec4 t8;
highp ivec3 ti8;
highp vec4 t9;
bvec4 tb9;
highp vec4 t10;
bvec4 tb10;
highp vec4 t11;
bvec4 tb11;
highp vec4 t12;
highp vec4 t13;
mediump vec3 t16_14;
mediump vec3 t16_15;
highp float t17;
highp float t22;
highp ivec3 ti22;
highp vec3 t24;
highp vec2 t32;
highp int ti32;
highp vec2 t33;
highp int ti33;
highp vec2 t35;
highp ivec2 ti35;
bvec2 tb35;
highp float t48;
highp int ti48;
highp float t49;
highp int ti49;
bool tb49;
highp float t50;
highp int ti50;
bool tb50;
highp float t51;
highp int ti51;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t50 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t50);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t50 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t50) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t48 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t48);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t48 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t48) + t6.xyz;
    t48 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t48);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t48 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t48) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t48 = dot(t1, t6);
    t0.x = t48 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t48 = t1.x * 0.5;
    t49 = _MaxScale + -1.0;
    t48 = t48 * t49 + 1.0;
    t2.xyz = vec3(t48) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t49 = dot(t5.xyz, t5.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t5.xyz;
    t50 = t5.z * t49 + (-t6.y);
    tb35.x = abs(t6.z)>=abs(t6.y);
    t35.x = tb35.x ? 1.0 : float(0.0);
    t50 = t35.x * t50 + t6.y;
    t49 = (-t5.x) * t49 + t50;
    t50 = max(abs(t6.z), abs(t6.y));
    tb50 = t50>=abs(t6.x);
    t50 = tb50 ? 1.0 : float(0.0);
    t49 = t50 * t49 + t6.x;
    ti51 = int((0.0<t49) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t49<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti49 = (-ti51) + ti49;
    t16_14.y = float(ti49);
    t16_15.y = (-t16_14.y);
    t16_15.xz = vec2(1.0, -1.0);
    t5.xyz = t6.yzx * t16_15.xyz;
    t16_14.xz = vec2(1.0, -1.0);
    t7.xyz = t16_14.xyz * t6.zyx + (-t5.xyz);
    t5.xyz = t35.xxx * t7.xyz + t5.xyz;
    t5.xyz = (-t16_14.xxy) * t6.xyz + t5.xyz;
    t6.xyz = t6.xyz * t16_14.xxy;
    t5.xyz = vec3(t50) * t5.xyz + t6.xyz;
    t16_14.xy = vec2(t5.y * float(0.5), t5.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t5.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t16_14.xy, 0.0);
    t49 = dot(t4.xyz, t4.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb49 = abs(t6.y)<abs(t6.x);
    t50 = max(abs(t6.y), abs(t6.x));
    t50 = float(1.0) / t50;
    t35.x = min(abs(t6.y), abs(t6.x));
    t50 = t50 * t35.x;
    t35.x = t50 * t50;
    t51 = t35.x * 0.0208350997 + -0.0851330012;
    t51 = t35.x * t51 + 0.180141002;
    t51 = t35.x * t51 + -0.330299497;
    t35.x = t35.x * t51 + 0.999866009;
    t51 = t50 * t35.x;
    t51 = t51 * -2.0 + 1.57079637;
    t49 = tb49 ? t51 : float(0.0);
    t49 = t50 * t35.x + t49;
    tb35.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t50 = tb35.x ? -3.14159274 : float(0.0);
    t49 = t49 + t50;
    t50 = min(t6.y, t6.x);
    tb50 = t50<(-t50);
    t35.x = max(t6.y, t6.x);
    tb35.x = t35.x>=(-t35.x);
    ti50 = int(uint(tb50) * 0xffffffffu & uint(tb35.x) * 0xffffffffu);
    t49 = (ti50 != 0) ? (-t49) : t49;
    t4.x = t49 * 0.159154937 + 0.5;
    t49 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t49 = t49 * abs(t6.z) + -0.212114394;
    t49 = t49 * abs(t6.z) + 1.57072878;
    t50 = -abs(t6.z) + 1.0;
    t50 = sqrt(t50);
    t35.x = t49 * t50;
    t35.x = t35.x * -2.0 + 3.14159274;
    t35.x = tb35.y ? t35.x : float(0.0);
    t49 = t49 * t50 + t35.x;
    t4.y = t49 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t16_4 = t5 * t4;
    t49 = dot(t2.xyz, t2.xyz);
    t50 = sqrt(t49);
    t49 = inversesqrt(t49);
    t2.xyz = vec3(t49) * t2.xyz;
    t49 = t50 * _DistFade;
    t50 = (-_DistFadeVert) * t50 + 1.0;
    t50 = clamp(t50, 0.0, 1.0);
    t49 = t49;
    t49 = clamp(t49, 0.0, 1.0);
    t5.w = t50 * t49;
    t16_4.w = t16_4.w * t5.w;
    vs_COLOR0 = t16_4;
    t6.x = fract(_Rotation);
    t6.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t6.xyz;
    t35.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t35.x);
    t50 = t48 * t35.y;
    t33.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t33.x = sqrt(t33.x);
    t6.x = sin(t1.y);
    t7.x = cos(t1.y);
    t8.x = cos(t1.x);
    t1.x = sin(t1.x);
    t17 = t33.x * t7.x;
    t33.x = t33.x * t6.x;
    t35.xy = t1.wx * vec2(t17);
    t51 = t33.x * t8.x + (-t35.y);
    t6.x = t17 * t51 + t1.x;
    t22 = t8.x * t17;
    t22 = t33.x * t1.x + t22;
    t17 = t17 * t22 + (-t8.x);
    t17 = t48 * t17;
    t7.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t7.xyz;
    t24.xyz = vec3(t17) * t7.xyz;
    t9.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t9.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t9.xyz;
    t9.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t9.xyz;
    t9.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t9.xyz;
    t6.xzw = t9.xyz * t6.xxx + t24.xyz;
    t24.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t24.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t24.xyz;
    t24.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t24.xyz;
    t24.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t24.xyz;
    t6.xzw = t24.xyz * t35.xxx + t6.xzw;
    t10.y = t6.w;
    t17 = t33.x * t51 + (-t8.x);
    t1.x = t33.x * t22 + (-t1.x);
    t33.x = t1.w * t33.x;
    t35.x = t1.w * t22;
    t49 = t1.w * t51;
    t11.xyz = t35.xxx * t7.xyz;
    t11.xyz = t9.xyz * vec3(t49) + t11.xyz;
    t11.xyz = t24.xyz * vec3(t50) + t11.xyz;
    t12.xyz = t1.xxx * t7.xyz;
    t1.xw = t0.yy * t7.xy;
    t0.xy = t9.xy * t0.xx + t1.xw;
    t0.xy = t24.xy * t0.zz + t0.xy;
    t32.x = t48 * t17;
    t1.xyw = t9.xyz * t32.xxx + t12.xyz;
    t1.xyz = t24.xyz * t33.xxx + t1.xyw;
    t10.x = t1.z;
    t10.z = t11.z;
    t32.x = dot(t10.xyz, t10.xyz);
    t32.x = inversesqrt(t32.x);
    t7.xyz = t32.xxx * t10.xyz;
    t5.xyz = abs(t7.xyz);
    vs_TEXCOORD0 = t5;
    t32.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t32.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t32.xy;
    t32.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t32.xy;
    t32.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t32.xy;
    t0.xy = t32.xy + t0.xy;
    ti5.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t7.xyzx)).xyz) * 0xFFFFFFFFu);
    ti8.xyz = ivec3(uvec3(lessThan((-t7.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti5.xyz = (-ti5.xyz) + ti8.xyz;
    t32.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti33 = int((0.0<t32.y) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t32.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti33 = (-ti33) + ti49;
    ti8.xyz = ivec3(ti33) * ti5.xyz;
    t8.xyz = vec3(ti8.xyz);
    t8.xyz = vec3(t7.y * t8.x, t7.z * t8.y, t7.y * t8.z);
    t33.xy = vec2(ti5.xy);
    t33.xy = t32.xx * t33.xy;
    ti35.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t33.xyxy).xy) * 0xFFFFFFFFu);
    ti22.xz = ivec2(uvec2(lessThan(t33.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti35.xy = (-ti35.xy) + ti22.xz;
    ti35.xy = ti35.xy * ti5.xy;
    t35.xy = vec2(ti35.xy);
    t35.xy = t35.xy * t7.zx + t8.xy;
    t5.xy = t35.yy * t6.xz;
    t6.xy = t32.yy * t6.xz;
    t35.xy = t1.xy * t35.xx + t6.xy;
    t35.xy = t11.xy * t33.xx + t35.xy;
    t33.xy = t1.xy * t33.yy + t5.xy;
    t33.xy = t11.xy * t32.yy + t33.xy;
    t33.xy = t0.xy * in_POSITION0.ww + t33.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD2.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t33.xy = t0.xy * in_POSITION0.ww + t35.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD1.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti48 = int((0.0<t7.z) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t7.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti48 = (-ti48) + ti33;
    t48 = float(ti48);
    t32.x = t48 * t32.x;
    ti48 = int((0.0<t32.x) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t32.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t32.xx + t6.xy;
    ti32 = (-ti48) + ti33;
    ti32 = ti32 * ti5.z;
    t32.x = float(ti32);
    t32.x = t32.x * t7.x + t8.z;
    t32.xy = t11.xy * t32.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t32.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t48 = dot(t3.xyz, t3.xyz);
    t48 = inversesqrt(t48);
    t5.xyz = vec3(t48) * t3.yzx;
    t6.xyz = t0.zxy * t5.xyz;
    t5.xyz = t0.yzx * t5.yzx + (-t6.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t5.xyz), t2.xyz);
    t0.y = dot((-t5.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t48 = dot(t1.xyz, t1.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD7.xyz = vec3(t48) * t1.xyz;
    t48 = dot(t0.xyz, t0.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD8.xyz = vec3(t48) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _Tex;
in lowp vec4 vs_COLOR0;
in mediump vec4 vs_TEXCOORD0;
in highp vec2 vs_TEXCOORD1;
in highp vec2 vs_TEXCOORD2;
in highp vec2 vs_TEXCOORD3;
in highp vec2 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD7;
in highp vec3 vs_TEXCOORD8;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
mediump vec3 t16_1;
highp vec3 t2;
lowp vec4 t10_2;
highp vec3 t3;
mediump vec3 t16_4;
mediump vec3 t16_5;
highp vec2 t6;
mediump vec3 t16_7;
mediump float t16_13;
mediump float t16_14;
mediump float t16_19;
mediump float t16_22;
void main()
{
    t0.x = texture(_Tex, vs_TEXCOORD1.xy).x;
    t0.y = texture(_Tex, vs_TEXCOORD2.xy).y;
    t0.z = texture(_Tex, vs_TEXCOORD3.xy).z;
    t16_1.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t16_19 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t16_19 = t16_19 + vs_TEXCOORD0.z;
    t16_1.xyz = t16_1.xyz / vec3(t16_19);
    t16_1.x = t16_1.y + t16_1.x;
    t16_1.x = t16_1.z + t16_1.x;
    t16_7.x = t16_1.x * vs_TEXCOORD0.w;
    t0.x = (-_Opacity) * t16_7.x + _MinScatter;
    t2.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t3.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t6.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t16_7.x = dot(t6.xy, t6.xy);
    t16_7.x = min(t16_7.x, 1.0);
    t16_7.x = (-t16_7.x) + 1.0;
    t16_14 = sqrt(t16_7.x);
    t2.z = t16_14;
    t3.z = t2.z;
    t16_7.x = dot(t2.xyz, t3.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_4.xy = t6.xy * t16_7.xx;
    t16_4.z = t16_7.x * t2.z;
    t16_7.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_7.xyz = t16_7.xxx * vs_TEXCOORD7.xyz;
    t16_22 = dot(t16_4.xyz, t16_7.xyz);
    t16_22 = (-t16_22) + 1.0;
    t0.x = t0.x * t16_22;
    t16_22 = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_5.xyz = vec3(t16_22) * vs_TEXCOORD8.xyz;
    t16_7.x = dot(t16_7.xyz, t16_5.xyz);
    t16_13 = dot(t16_4.xyz, t16_5.xyz);
    t16_13 = max(t16_13, 0.0);
    t16_7.x = t16_7.x * 0.5 + 0.5;
    t0.x = t0.x * t16_7.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + t16_13;
    t0.xyz = t0.xxx * _LightColor0.xyz;
    t0.xyz = t0.xyz + t0.xyz;
    t10_2 = vs_COLOR0 * _Color;
    t16_0.xyz = t0.xyz * t10_2.xyz;
    t16_0.w = t16_1.x * t10_2.w;
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 642 math, 2 textures, 48 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "texcoord" ATTR1
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 528
Matrix 32 [glstate_matrix_modelview0]
Matrix 96 [_Object2World]
Matrix 160 [glstate_matrix_projection]
Matrix 224 [unity_MatrixV]
Matrix 288 [_MainRotation]
Matrix 352 [_DetailRotation]
Matrix 416 [_PosRotation]
Vector 0 [_WorldSpaceCameraPos] 3
VectorHalf 16 [_WorldSpaceLightPos0] 4
Float 480 [_DistFade]
Float 484 [_DistFadeVert]
Float 488 [_Rotation]
Float 492 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesMultiTexCoord0 [[attribute(1)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  half4 xlv_COLOR;
  half4 xlv_TEXCOORD0;
  float2 xlv_TEXCOORD1;
  float2 xlv_TEXCOORD2;
  float2 xlv_TEXCOORD3;
  float2 xlv_TEXCOORD4;
  float4 xlv_TEXCOORD5;
  float3 xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
  float3 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  half4 _WorldSpaceLightPos0;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 glstate_matrix_projection;
  float4x4 unity_MatrixV;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4x4 _PosRotation;
  float _DistFade;
  float _DistFadeVert;
  float _Rotation;
  float _MaxScale;
  float4 _NoiseScale;
  float3 _MaxTrans;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> _MainTex [[texture(0)]], sampler _mtlsmp__MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]])
{
  xlatMtlShaderOutput _mtl_o;
  float2 tmpvar_1;
  tmpvar_1 = _mtl_i._glesMultiTexCoord0.xy;
  half3 normal_2;
  float4 XYv_3;
  float4 XZv_4;
  float4 ZYv_5;
  float4 localOrigin_6;
  float4 planet_pos_7;
  float4 origin_8;
  half4 tmpvar_9;
  half4 tmpvar_10;
  float4 tmpvar_11;
  float3 tmpvar_12;
  float4 tmpvar_13;
  tmpvar_13 = (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0));
  origin_8 = tmpvar_13;
  float4 tmpvar_14;
  tmpvar_14 = (_mtl_u._PosRotation * tmpvar_13);
  planet_pos_7 = tmpvar_14;
  float3 tmpvar_15;
  tmpvar_15 = (_mtl_u._NoiseScale.z * tmpvar_14.xyz);
  float tmpvar_16;
  float4 m_17;
  float3 tmpvar_18;
  tmpvar_18 = floor((tmpvar_15 + dot (tmpvar_15, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_19;
  tmpvar_19 = ((tmpvar_15 - tmpvar_18) + dot (tmpvar_18, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_20;
  tmpvar_20.x = float((tmpvar_19.x >= tmpvar_19.y));
  tmpvar_20.y = float((tmpvar_19.y >= tmpvar_19.z));
  tmpvar_20.z = float((tmpvar_19.z >= tmpvar_19.x));
  float3 tmpvar_21;
  tmpvar_21 = (1.0 - tmpvar_20);
  float3 tmpvar_22;
  tmpvar_22 = min (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_23;
  tmpvar_23 = max (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_24;
  tmpvar_24 = ((tmpvar_19 - tmpvar_22) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_25;
  tmpvar_25 = ((tmpvar_19 - tmpvar_23) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_26;
  tmpvar_26 = (tmpvar_19 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_27;
  tmpvar_27 = (tmpvar_18 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_28;
  tmpvar_28 = (fract(abs(tmpvar_27)) * float3(289.0, 289.0, 289.0));
  float tmpvar_29;
  if ((tmpvar_27.x >= 0.0)) {
    tmpvar_29 = tmpvar_28.x;
  } else {
    tmpvar_29 = -(tmpvar_28.x);
  };
  float tmpvar_30;
  if ((tmpvar_27.y >= 0.0)) {
    tmpvar_30 = tmpvar_28.y;
  } else {
    tmpvar_30 = -(tmpvar_28.y);
  };
  float tmpvar_31;
  if ((tmpvar_27.z >= 0.0)) {
    tmpvar_31 = tmpvar_28.z;
  } else {
    tmpvar_31 = -(tmpvar_28.z);
  };
  float4 tmpvar_32;
  tmpvar_32.xw = float2(0.0, 1.0);
  tmpvar_32.y = tmpvar_22.z;
  tmpvar_32.z = tmpvar_23.z;
  float4 x_33;
  x_33 = (tmpvar_31 + tmpvar_32);
  float4 tmpvar_34;
  tmpvar_34 = (((
    (x_33 * x_33)
   * 34.0) + x_33) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_35;
  tmpvar_35 = (fract(abs(tmpvar_34)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_36;
  if ((tmpvar_34.x >= 0.0)) {
    tmpvar_36 = tmpvar_35.x;
  } else {
    tmpvar_36 = -(tmpvar_35.x);
  };
  float tmpvar_37;
  if ((tmpvar_34.y >= 0.0)) {
    tmpvar_37 = tmpvar_35.y;
  } else {
    tmpvar_37 = -(tmpvar_35.y);
  };
  float tmpvar_38;
  if ((tmpvar_34.z >= 0.0)) {
    tmpvar_38 = tmpvar_35.z;
  } else {
    tmpvar_38 = -(tmpvar_35.z);
  };
  float tmpvar_39;
  if ((tmpvar_34.w >= 0.0)) {
    tmpvar_39 = tmpvar_35.w;
  } else {
    tmpvar_39 = -(tmpvar_35.w);
  };
  float4 tmpvar_40;
  tmpvar_40.x = tmpvar_36;
  tmpvar_40.y = tmpvar_37;
  tmpvar_40.z = tmpvar_38;
  tmpvar_40.w = tmpvar_39;
  float4 tmpvar_41;
  tmpvar_41.xw = float2(0.0, 1.0);
  tmpvar_41.y = tmpvar_22.y;
  tmpvar_41.z = tmpvar_23.y;
  float4 x_42;
  x_42 = ((tmpvar_40 + tmpvar_30) + tmpvar_41);
  float4 tmpvar_43;
  tmpvar_43 = (((
    (x_42 * x_42)
   * 34.0) + x_42) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_44;
  tmpvar_44 = (fract(abs(tmpvar_43)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_45;
  if ((tmpvar_43.x >= 0.0)) {
    tmpvar_45 = tmpvar_44.x;
  } else {
    tmpvar_45 = -(tmpvar_44.x);
  };
  float tmpvar_46;
  if ((tmpvar_43.y >= 0.0)) {
    tmpvar_46 = tmpvar_44.y;
  } else {
    tmpvar_46 = -(tmpvar_44.y);
  };
  float tmpvar_47;
  if ((tmpvar_43.z >= 0.0)) {
    tmpvar_47 = tmpvar_44.z;
  } else {
    tmpvar_47 = -(tmpvar_44.z);
  };
  float tmpvar_48;
  if ((tmpvar_43.w >= 0.0)) {
    tmpvar_48 = tmpvar_44.w;
  } else {
    tmpvar_48 = -(tmpvar_44.w);
  };
  float4 tmpvar_49;
  tmpvar_49.x = tmpvar_45;
  tmpvar_49.y = tmpvar_46;
  tmpvar_49.z = tmpvar_47;
  tmpvar_49.w = tmpvar_48;
  float4 tmpvar_50;
  tmpvar_50.xw = float2(0.0, 1.0);
  tmpvar_50.y = tmpvar_22.x;
  tmpvar_50.z = tmpvar_23.x;
  float4 x_51;
  x_51 = ((tmpvar_49 + tmpvar_29) + tmpvar_50);
  float4 tmpvar_52;
  tmpvar_52 = (((
    (x_51 * x_51)
   * 34.0) + x_51) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_53;
  tmpvar_53 = (fract(abs(tmpvar_52)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_54;
  if ((tmpvar_52.x >= 0.0)) {
    tmpvar_54 = tmpvar_53.x;
  } else {
    tmpvar_54 = -(tmpvar_53.x);
  };
  float tmpvar_55;
  if ((tmpvar_52.y >= 0.0)) {
    tmpvar_55 = tmpvar_53.y;
  } else {
    tmpvar_55 = -(tmpvar_53.y);
  };
  float tmpvar_56;
  if ((tmpvar_52.z >= 0.0)) {
    tmpvar_56 = tmpvar_53.z;
  } else {
    tmpvar_56 = -(tmpvar_53.z);
  };
  float tmpvar_57;
  if ((tmpvar_52.w >= 0.0)) {
    tmpvar_57 = tmpvar_53.w;
  } else {
    tmpvar_57 = -(tmpvar_53.w);
  };
  float4 tmpvar_58;
  tmpvar_58.x = tmpvar_54;
  tmpvar_58.y = tmpvar_55;
  tmpvar_58.z = tmpvar_56;
  tmpvar_58.w = tmpvar_57;
  float4 tmpvar_59;
  tmpvar_59 = (tmpvar_58 - (49.0 * floor(
    (0.02040815 * tmpvar_58)
  )));
  float4 tmpvar_60;
  tmpvar_60 = floor((tmpvar_59 * 0.1428571));
  float4 tmpvar_61;
  tmpvar_61 = ((tmpvar_60 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_62;
  tmpvar_62 = ((floor(
    (tmpvar_59 - (7.0 * tmpvar_60))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_63;
  tmpvar_63 = ((1.0 - abs(tmpvar_61)) - abs(tmpvar_62));
  float4 tmpvar_64;
  tmpvar_64.xy = tmpvar_61.xy;
  tmpvar_64.zw = tmpvar_62.xy;
  float4 tmpvar_65;
  tmpvar_65.xy = tmpvar_61.zw;
  tmpvar_65.zw = tmpvar_62.zw;
  float4 tmpvar_66;
  tmpvar_66 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_63)));
  float4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_66.xxyy));
  float4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_66.zzww));
  float3 tmpvar_69;
  tmpvar_69.xy = tmpvar_67.xy;
  tmpvar_69.z = tmpvar_63.x;
  float3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.zw;
  tmpvar_70.z = tmpvar_63.y;
  float3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.xy;
  tmpvar_71.z = tmpvar_63.z;
  float3 tmpvar_72;
  tmpvar_72.xy = tmpvar_68.zw;
  tmpvar_72.z = tmpvar_63.w;
  float4 tmpvar_73;
  tmpvar_73.x = dot (tmpvar_69, tmpvar_69);
  tmpvar_73.y = dot (tmpvar_70, tmpvar_70);
  tmpvar_73.z = dot (tmpvar_71, tmpvar_71);
  tmpvar_73.w = dot (tmpvar_72, tmpvar_72);
  float4 tmpvar_74;
  tmpvar_74 = (1.792843 - (0.8537347 * tmpvar_73));
  float4 tmpvar_75;
  tmpvar_75.x = dot (tmpvar_19, tmpvar_19);
  tmpvar_75.y = dot (tmpvar_24, tmpvar_24);
  tmpvar_75.z = dot (tmpvar_25, tmpvar_25);
  tmpvar_75.w = dot (tmpvar_26, tmpvar_26);
  float4 tmpvar_76;
  tmpvar_76 = max ((0.6 - tmpvar_75), float4(0.0, 0.0, 0.0, 0.0));
  m_17 = (tmpvar_76 * tmpvar_76);
  float4 tmpvar_77;
  tmpvar_77.x = dot ((tmpvar_69 * tmpvar_74.x), tmpvar_19);
  tmpvar_77.y = dot ((tmpvar_70 * tmpvar_74.y), tmpvar_24);
  tmpvar_77.z = dot ((tmpvar_71 * tmpvar_74.z), tmpvar_25);
  tmpvar_77.w = dot ((tmpvar_72 * tmpvar_74.w), tmpvar_26);
  tmpvar_16 = (42.0 * dot ((m_17 * m_17), tmpvar_77));
  float tmpvar_78;
  float3 v_79;
  v_79 = (_mtl_u._NoiseScale.x * tmpvar_15);
  float4 m_80;
  float3 tmpvar_81;
  tmpvar_81 = floor((v_79 + dot (v_79, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_82;
  tmpvar_82 = ((v_79 - tmpvar_81) + dot (tmpvar_81, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_83;
  tmpvar_83.x = float((tmpvar_82.x >= tmpvar_82.y));
  tmpvar_83.y = float((tmpvar_82.y >= tmpvar_82.z));
  tmpvar_83.z = float((tmpvar_82.z >= tmpvar_82.x));
  float3 tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_83);
  float3 tmpvar_85;
  tmpvar_85 = min (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_86;
  tmpvar_86 = max (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_87;
  tmpvar_87 = ((tmpvar_82 - tmpvar_85) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_88;
  tmpvar_88 = ((tmpvar_82 - tmpvar_86) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_89;
  tmpvar_89 = (tmpvar_82 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_90;
  tmpvar_90 = (tmpvar_81 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_91;
  tmpvar_91 = (fract(abs(tmpvar_90)) * float3(289.0, 289.0, 289.0));
  float tmpvar_92;
  if ((tmpvar_90.x >= 0.0)) {
    tmpvar_92 = tmpvar_91.x;
  } else {
    tmpvar_92 = -(tmpvar_91.x);
  };
  float tmpvar_93;
  if ((tmpvar_90.y >= 0.0)) {
    tmpvar_93 = tmpvar_91.y;
  } else {
    tmpvar_93 = -(tmpvar_91.y);
  };
  float tmpvar_94;
  if ((tmpvar_90.z >= 0.0)) {
    tmpvar_94 = tmpvar_91.z;
  } else {
    tmpvar_94 = -(tmpvar_91.z);
  };
  float4 tmpvar_95;
  tmpvar_95.xw = float2(0.0, 1.0);
  tmpvar_95.y = tmpvar_85.z;
  tmpvar_95.z = tmpvar_86.z;
  float4 x_96;
  x_96 = (tmpvar_94 + tmpvar_95);
  float4 tmpvar_97;
  tmpvar_97 = (((
    (x_96 * x_96)
   * 34.0) + x_96) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_98;
  tmpvar_98 = (fract(abs(tmpvar_97)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_99;
  if ((tmpvar_97.x >= 0.0)) {
    tmpvar_99 = tmpvar_98.x;
  } else {
    tmpvar_99 = -(tmpvar_98.x);
  };
  float tmpvar_100;
  if ((tmpvar_97.y >= 0.0)) {
    tmpvar_100 = tmpvar_98.y;
  } else {
    tmpvar_100 = -(tmpvar_98.y);
  };
  float tmpvar_101;
  if ((tmpvar_97.z >= 0.0)) {
    tmpvar_101 = tmpvar_98.z;
  } else {
    tmpvar_101 = -(tmpvar_98.z);
  };
  float tmpvar_102;
  if ((tmpvar_97.w >= 0.0)) {
    tmpvar_102 = tmpvar_98.w;
  } else {
    tmpvar_102 = -(tmpvar_98.w);
  };
  float4 tmpvar_103;
  tmpvar_103.x = tmpvar_99;
  tmpvar_103.y = tmpvar_100;
  tmpvar_103.z = tmpvar_101;
  tmpvar_103.w = tmpvar_102;
  float4 tmpvar_104;
  tmpvar_104.xw = float2(0.0, 1.0);
  tmpvar_104.y = tmpvar_85.y;
  tmpvar_104.z = tmpvar_86.y;
  float4 x_105;
  x_105 = ((tmpvar_103 + tmpvar_93) + tmpvar_104);
  float4 tmpvar_106;
  tmpvar_106 = (((
    (x_105 * x_105)
   * 34.0) + x_105) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_107;
  tmpvar_107 = (fract(abs(tmpvar_106)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_108;
  if ((tmpvar_106.x >= 0.0)) {
    tmpvar_108 = tmpvar_107.x;
  } else {
    tmpvar_108 = -(tmpvar_107.x);
  };
  float tmpvar_109;
  if ((tmpvar_106.y >= 0.0)) {
    tmpvar_109 = tmpvar_107.y;
  } else {
    tmpvar_109 = -(tmpvar_107.y);
  };
  float tmpvar_110;
  if ((tmpvar_106.z >= 0.0)) {
    tmpvar_110 = tmpvar_107.z;
  } else {
    tmpvar_110 = -(tmpvar_107.z);
  };
  float tmpvar_111;
  if ((tmpvar_106.w >= 0.0)) {
    tmpvar_111 = tmpvar_107.w;
  } else {
    tmpvar_111 = -(tmpvar_107.w);
  };
  float4 tmpvar_112;
  tmpvar_112.x = tmpvar_108;
  tmpvar_112.y = tmpvar_109;
  tmpvar_112.z = tmpvar_110;
  tmpvar_112.w = tmpvar_111;
  float4 tmpvar_113;
  tmpvar_113.xw = float2(0.0, 1.0);
  tmpvar_113.y = tmpvar_85.x;
  tmpvar_113.z = tmpvar_86.x;
  float4 x_114;
  x_114 = ((tmpvar_112 + tmpvar_92) + tmpvar_113);
  float4 tmpvar_115;
  tmpvar_115 = (((
    (x_114 * x_114)
   * 34.0) + x_114) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_116;
  tmpvar_116 = (fract(abs(tmpvar_115)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_117;
  if ((tmpvar_115.x >= 0.0)) {
    tmpvar_117 = tmpvar_116.x;
  } else {
    tmpvar_117 = -(tmpvar_116.x);
  };
  float tmpvar_118;
  if ((tmpvar_115.y >= 0.0)) {
    tmpvar_118 = tmpvar_116.y;
  } else {
    tmpvar_118 = -(tmpvar_116.y);
  };
  float tmpvar_119;
  if ((tmpvar_115.z >= 0.0)) {
    tmpvar_119 = tmpvar_116.z;
  } else {
    tmpvar_119 = -(tmpvar_116.z);
  };
  float tmpvar_120;
  if ((tmpvar_115.w >= 0.0)) {
    tmpvar_120 = tmpvar_116.w;
  } else {
    tmpvar_120 = -(tmpvar_116.w);
  };
  float4 tmpvar_121;
  tmpvar_121.x = tmpvar_117;
  tmpvar_121.y = tmpvar_118;
  tmpvar_121.z = tmpvar_119;
  tmpvar_121.w = tmpvar_120;
  float4 tmpvar_122;
  tmpvar_122 = (tmpvar_121 - (49.0 * floor(
    (0.02040815 * tmpvar_121)
  )));
  float4 tmpvar_123;
  tmpvar_123 = floor((tmpvar_122 * 0.1428571));
  float4 tmpvar_124;
  tmpvar_124 = ((tmpvar_123 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_125;
  tmpvar_125 = ((floor(
    (tmpvar_122 - (7.0 * tmpvar_123))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_126;
  tmpvar_126 = ((1.0 - abs(tmpvar_124)) - abs(tmpvar_125));
  float4 tmpvar_127;
  tmpvar_127.xy = tmpvar_124.xy;
  tmpvar_127.zw = tmpvar_125.xy;
  float4 tmpvar_128;
  tmpvar_128.xy = tmpvar_124.zw;
  tmpvar_128.zw = tmpvar_125.zw;
  float4 tmpvar_129;
  tmpvar_129 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_126)));
  float4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_129.xxyy));
  float4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_129.zzww));
  float3 tmpvar_132;
  tmpvar_132.xy = tmpvar_130.xy;
  tmpvar_132.z = tmpvar_126.x;
  float3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.zw;
  tmpvar_133.z = tmpvar_126.y;
  float3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.xy;
  tmpvar_134.z = tmpvar_126.z;
  float3 tmpvar_135;
  tmpvar_135.xy = tmpvar_131.zw;
  tmpvar_135.z = tmpvar_126.w;
  float4 tmpvar_136;
  tmpvar_136.x = dot (tmpvar_132, tmpvar_132);
  tmpvar_136.y = dot (tmpvar_133, tmpvar_133);
  tmpvar_136.z = dot (tmpvar_134, tmpvar_134);
  tmpvar_136.w = dot (tmpvar_135, tmpvar_135);
  float4 tmpvar_137;
  tmpvar_137 = (1.792843 - (0.8537347 * tmpvar_136));
  float4 tmpvar_138;
  tmpvar_138.x = dot (tmpvar_82, tmpvar_82);
  tmpvar_138.y = dot (tmpvar_87, tmpvar_87);
  tmpvar_138.z = dot (tmpvar_88, tmpvar_88);
  tmpvar_138.w = dot (tmpvar_89, tmpvar_89);
  float4 tmpvar_139;
  tmpvar_139 = max ((0.6 - tmpvar_138), float4(0.0, 0.0, 0.0, 0.0));
  m_80 = (tmpvar_139 * tmpvar_139);
  float4 tmpvar_140;
  tmpvar_140.x = dot ((tmpvar_132 * tmpvar_137.x), tmpvar_82);
  tmpvar_140.y = dot ((tmpvar_133 * tmpvar_137.y), tmpvar_87);
  tmpvar_140.z = dot ((tmpvar_134 * tmpvar_137.z), tmpvar_88);
  tmpvar_140.w = dot ((tmpvar_135 * tmpvar_137.w), tmpvar_89);
  tmpvar_78 = (42.0 * dot ((m_80 * m_80), tmpvar_140));
  float3 v_141;
  v_141 = (_mtl_u._NoiseScale.y * tmpvar_15);
  float4 m_142;
  float3 tmpvar_143;
  tmpvar_143 = floor((v_141 + dot (v_141, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_144;
  tmpvar_144 = ((v_141 - tmpvar_143) + dot (tmpvar_143, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_145;
  tmpvar_145.x = float((tmpvar_144.x >= tmpvar_144.y));
  tmpvar_145.y = float((tmpvar_144.y >= tmpvar_144.z));
  tmpvar_145.z = float((tmpvar_144.z >= tmpvar_144.x));
  float3 tmpvar_146;
  tmpvar_146 = (1.0 - tmpvar_145);
  float3 tmpvar_147;
  tmpvar_147 = min (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_148;
  tmpvar_148 = max (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_149;
  tmpvar_149 = ((tmpvar_144 - tmpvar_147) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_150;
  tmpvar_150 = ((tmpvar_144 - tmpvar_148) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_151;
  tmpvar_151 = (tmpvar_144 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_152;
  tmpvar_152 = (tmpvar_143 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_153;
  tmpvar_153 = (fract(abs(tmpvar_152)) * float3(289.0, 289.0, 289.0));
  float tmpvar_154;
  if ((tmpvar_152.x >= 0.0)) {
    tmpvar_154 = tmpvar_153.x;
  } else {
    tmpvar_154 = -(tmpvar_153.x);
  };
  float tmpvar_155;
  if ((tmpvar_152.y >= 0.0)) {
    tmpvar_155 = tmpvar_153.y;
  } else {
    tmpvar_155 = -(tmpvar_153.y);
  };
  float tmpvar_156;
  if ((tmpvar_152.z >= 0.0)) {
    tmpvar_156 = tmpvar_153.z;
  } else {
    tmpvar_156 = -(tmpvar_153.z);
  };
  float4 tmpvar_157;
  tmpvar_157.xw = float2(0.0, 1.0);
  tmpvar_157.y = tmpvar_147.z;
  tmpvar_157.z = tmpvar_148.z;
  float4 x_158;
  x_158 = (tmpvar_156 + tmpvar_157);
  float4 tmpvar_159;
  tmpvar_159 = (((
    (x_158 * x_158)
   * 34.0) + x_158) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_160;
  tmpvar_160 = (fract(abs(tmpvar_159)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_161;
  if ((tmpvar_159.x >= 0.0)) {
    tmpvar_161 = tmpvar_160.x;
  } else {
    tmpvar_161 = -(tmpvar_160.x);
  };
  float tmpvar_162;
  if ((tmpvar_159.y >= 0.0)) {
    tmpvar_162 = tmpvar_160.y;
  } else {
    tmpvar_162 = -(tmpvar_160.y);
  };
  float tmpvar_163;
  if ((tmpvar_159.z >= 0.0)) {
    tmpvar_163 = tmpvar_160.z;
  } else {
    tmpvar_163 = -(tmpvar_160.z);
  };
  float tmpvar_164;
  if ((tmpvar_159.w >= 0.0)) {
    tmpvar_164 = tmpvar_160.w;
  } else {
    tmpvar_164 = -(tmpvar_160.w);
  };
  float4 tmpvar_165;
  tmpvar_165.x = tmpvar_161;
  tmpvar_165.y = tmpvar_162;
  tmpvar_165.z = tmpvar_163;
  tmpvar_165.w = tmpvar_164;
  float4 tmpvar_166;
  tmpvar_166.xw = float2(0.0, 1.0);
  tmpvar_166.y = tmpvar_147.y;
  tmpvar_166.z = tmpvar_148.y;
  float4 x_167;
  x_167 = ((tmpvar_165 + tmpvar_155) + tmpvar_166);
  float4 tmpvar_168;
  tmpvar_168 = (((
    (x_167 * x_167)
   * 34.0) + x_167) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_169;
  tmpvar_169 = (fract(abs(tmpvar_168)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_170;
  if ((tmpvar_168.x >= 0.0)) {
    tmpvar_170 = tmpvar_169.x;
  } else {
    tmpvar_170 = -(tmpvar_169.x);
  };
  float tmpvar_171;
  if ((tmpvar_168.y >= 0.0)) {
    tmpvar_171 = tmpvar_169.y;
  } else {
    tmpvar_171 = -(tmpvar_169.y);
  };
  float tmpvar_172;
  if ((tmpvar_168.z >= 0.0)) {
    tmpvar_172 = tmpvar_169.z;
  } else {
    tmpvar_172 = -(tmpvar_169.z);
  };
  float tmpvar_173;
  if ((tmpvar_168.w >= 0.0)) {
    tmpvar_173 = tmpvar_169.w;
  } else {
    tmpvar_173 = -(tmpvar_169.w);
  };
  float4 tmpvar_174;
  tmpvar_174.x = tmpvar_170;
  tmpvar_174.y = tmpvar_171;
  tmpvar_174.z = tmpvar_172;
  tmpvar_174.w = tmpvar_173;
  float4 tmpvar_175;
  tmpvar_175.xw = float2(0.0, 1.0);
  tmpvar_175.y = tmpvar_147.x;
  tmpvar_175.z = tmpvar_148.x;
  float4 x_176;
  x_176 = ((tmpvar_174 + tmpvar_154) + tmpvar_175);
  float4 tmpvar_177;
  tmpvar_177 = (((
    (x_176 * x_176)
   * 34.0) + x_176) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_178;
  tmpvar_178 = (fract(abs(tmpvar_177)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_179;
  if ((tmpvar_177.x >= 0.0)) {
    tmpvar_179 = tmpvar_178.x;
  } else {
    tmpvar_179 = -(tmpvar_178.x);
  };
  float tmpvar_180;
  if ((tmpvar_177.y >= 0.0)) {
    tmpvar_180 = tmpvar_178.y;
  } else {
    tmpvar_180 = -(tmpvar_178.y);
  };
  float tmpvar_181;
  if ((tmpvar_177.z >= 0.0)) {
    tmpvar_181 = tmpvar_178.z;
  } else {
    tmpvar_181 = -(tmpvar_178.z);
  };
  float tmpvar_182;
  if ((tmpvar_177.w >= 0.0)) {
    tmpvar_182 = tmpvar_178.w;
  } else {
    tmpvar_182 = -(tmpvar_178.w);
  };
  float4 tmpvar_183;
  tmpvar_183.x = tmpvar_179;
  tmpvar_183.y = tmpvar_180;
  tmpvar_183.z = tmpvar_181;
  tmpvar_183.w = tmpvar_182;
  float4 tmpvar_184;
  tmpvar_184 = (tmpvar_183 - (49.0 * floor(
    (0.02040815 * tmpvar_183)
  )));
  float4 tmpvar_185;
  tmpvar_185 = floor((tmpvar_184 * 0.1428571));
  float4 tmpvar_186;
  tmpvar_186 = ((tmpvar_185 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_187;
  tmpvar_187 = ((floor(
    (tmpvar_184 - (7.0 * tmpvar_185))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_188;
  tmpvar_188 = ((1.0 - abs(tmpvar_186)) - abs(tmpvar_187));
  float4 tmpvar_189;
  tmpvar_189.xy = tmpvar_186.xy;
  tmpvar_189.zw = tmpvar_187.xy;
  float4 tmpvar_190;
  tmpvar_190.xy = tmpvar_186.zw;
  tmpvar_190.zw = tmpvar_187.zw;
  float4 tmpvar_191;
  tmpvar_191 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_188)));
  float4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_191.xxyy));
  float4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_191.zzww));
  float3 tmpvar_194;
  tmpvar_194.xy = tmpvar_192.xy;
  tmpvar_194.z = tmpvar_188.x;
  float3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.zw;
  tmpvar_195.z = tmpvar_188.y;
  float3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.xy;
  tmpvar_196.z = tmpvar_188.z;
  float3 tmpvar_197;
  tmpvar_197.xy = tmpvar_193.zw;
  tmpvar_197.z = tmpvar_188.w;
  float4 tmpvar_198;
  tmpvar_198.x = dot (tmpvar_194, tmpvar_194);
  tmpvar_198.y = dot (tmpvar_195, tmpvar_195);
  tmpvar_198.z = dot (tmpvar_196, tmpvar_196);
  tmpvar_198.w = dot (tmpvar_197, tmpvar_197);
  float4 tmpvar_199;
  tmpvar_199 = (1.792843 - (0.8537347 * tmpvar_198));
  float4 tmpvar_200;
  tmpvar_200.x = dot (tmpvar_144, tmpvar_144);
  tmpvar_200.y = dot (tmpvar_149, tmpvar_149);
  tmpvar_200.z = dot (tmpvar_150, tmpvar_150);
  tmpvar_200.w = dot (tmpvar_151, tmpvar_151);
  float4 tmpvar_201;
  tmpvar_201 = max ((0.6 - tmpvar_200), float4(0.0, 0.0, 0.0, 0.0));
  m_142 = (tmpvar_201 * tmpvar_201);
  float4 tmpvar_202;
  tmpvar_202.x = dot ((tmpvar_194 * tmpvar_199.x), tmpvar_144);
  tmpvar_202.y = dot ((tmpvar_195 * tmpvar_199.y), tmpvar_149);
  tmpvar_202.z = dot ((tmpvar_196 * tmpvar_199.z), tmpvar_150);
  tmpvar_202.w = dot ((tmpvar_197 * tmpvar_199.w), tmpvar_151);
  float3 tmpvar_203;
  tmpvar_203.x = tmpvar_16;
  tmpvar_203.y = tmpvar_78;
  tmpvar_203.z = (42.0 * dot ((m_142 * m_142), tmpvar_202));
  float3 tmpvar_204;
  tmpvar_204 = (0.5 * (tmpvar_203 + 1.0));
  localOrigin_6.xyz = (((2.0 * tmpvar_204) - 1.0) * _mtl_u._MaxTrans);
  localOrigin_6.w = 1.0;
  float tmpvar_205;
  tmpvar_205 = ((tmpvar_204.x * (_mtl_u._MaxScale - 1.0)) + 1.0);
  origin_8 = (_mtl_u._Object2World * localOrigin_6);
  planet_pos_7 = (_mtl_u._MainRotation * origin_8);
  float3 tmpvar_206;
  tmpvar_206 = (_mtl_u._DetailRotation * planet_pos_7).xyz;
  tmpvar_12 = planet_pos_7.xyz;
  float3 tmpvar_207;
  tmpvar_207 = normalize(planet_pos_7.xyz);
  float2 uv_208;
  float tmpvar_209;
  float tmpvar_210;
  tmpvar_210 = (min (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0) / max (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0));
  float tmpvar_211;
  tmpvar_211 = (tmpvar_210 * tmpvar_210);
  tmpvar_211 = (((
    ((((
      ((((-0.01213232 * tmpvar_211) + 0.05368138) * tmpvar_211) - 0.1173503)
     * tmpvar_211) + 0.1938925) * tmpvar_211) - 0.3326756)
   * tmpvar_211) + 0.9999793) * tmpvar_210);
  tmpvar_211 = (tmpvar_211 + (float(
    (abs((tmpvar_207.x / tmpvar_207.z)) > 1.0)
  ) * (
    (tmpvar_211 * -2.0)
   + 1.570796)));
  tmpvar_209 = (tmpvar_211 * sign((tmpvar_207.x / tmpvar_207.z)));
  if ((abs(tmpvar_207.z) > (1e-08 * abs(tmpvar_207.x)))) {
    if ((tmpvar_207.z < 0.0)) {
      if ((tmpvar_207.x >= 0.0)) {
        tmpvar_209 += 3.141593;
      } else {
        tmpvar_209 = (tmpvar_209 - 3.141593);
      };
    };
  } else {
    tmpvar_209 = (sign(tmpvar_207.x) * 1.570796);
  };
  uv_208.x = (0.5 + (0.1591549 * tmpvar_209));
  uv_208.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_207.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_207.y)
    )) * (1.570796 + (
      abs(tmpvar_207.y)
     * 
      (-0.2146018 + (abs(tmpvar_207.y) * (0.08656672 + (
        abs(tmpvar_207.y)
       * -0.03102955))))
    ))))
  )));
  half4 tmpvar_212;
  tmpvar_212 = _MainTex.sample(_mtlsmp__MainTex, (float2)(uv_208), level(0.0));
  half4 tmpvar_213;
  tmpvar_213 = tmpvar_212;
  tmpvar_9 = tmpvar_213;
  half3 detailCoords_214;
  half s_215;
  half nylerp_216;
  half zxlerp_217;
  float4 uv4_218;
  uv4_218.zw = float2(0.0, 0.0);
  float3 tmpvar_219;
  tmpvar_219 = normalize(tmpvar_206);
  float3 tmpvar_220;
  tmpvar_220 = abs(tmpvar_219);
  float tmpvar_221;
  tmpvar_221 = float((tmpvar_220.z >= tmpvar_220.x));
  zxlerp_217 = half(tmpvar_221);
  float tmpvar_222;
  tmpvar_222 = float((max (tmpvar_220.x, tmpvar_220.z) >= tmpvar_220.y));
  nylerp_216 = half(tmpvar_222);
  float tmpvar_223;
  tmpvar_223 = mix (tmpvar_219.x, tmpvar_219.z, (float)zxlerp_217);
  s_215 = half(tmpvar_223);
  float tmpvar_224;
  tmpvar_224 = sign(mix (tmpvar_219.y, (float)s_215, (float)nylerp_216));
  s_215 = half(tmpvar_224);
  half3 tmpvar_225;
  tmpvar_225.xz = half2(float2(1.0, -1.0));
  tmpvar_225.y = -(s_215);
  half3 tmpvar_226;
  tmpvar_226.xz = half2(float2(1.0, -1.0));
  tmpvar_226.y = s_215;
  float3 tmpvar_227;
  tmpvar_227 = mix (((float3)tmpvar_225 * tmpvar_219.xzy), ((float3)tmpvar_226 * tmpvar_219.zxy), (float3)half3(zxlerp_217));
  detailCoords_214 = half3(tmpvar_227);
  half3 tmpvar_228;
  tmpvar_228.xy = half2(float2(1.0, 1.0));
  tmpvar_228.z = s_215;
  float3 tmpvar_229;
  tmpvar_229 = mix (((float3)tmpvar_228 * tmpvar_219.yxz), (float3)detailCoords_214, (float3)half3(nylerp_216));
  detailCoords_214 = half3(tmpvar_229);
  half2 tmpvar_230;
  tmpvar_230 = ((((half)0.5 * detailCoords_214.yz) / abs(detailCoords_214.x)) + (half)0.5);
  uv4_218.xy = float2(tmpvar_230);
  half4 tmpvar_231;
  tmpvar_231 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv4_218.xy), level(0.0));
  half4 tmpvar_232;
  tmpvar_232 = tmpvar_231;
  tmpvar_9 = (tmpvar_9 * tmpvar_232);
  float4 tmpvar_233;
  tmpvar_233.w = 0.0;
  tmpvar_233.xyz = _mtl_u._WorldSpaceCameraPos;
  float tmpvar_234;
  float4 tmpvar_235;
  tmpvar_235 = (origin_8 - tmpvar_233);
  tmpvar_234 = sqrt(dot (tmpvar_235, tmpvar_235));
  float tmpvar_236;
  tmpvar_236 = (clamp ((_mtl_u._DistFade * tmpvar_234), 0.0, 1.0) * clamp ((1.0 - 
    (_mtl_u._DistFadeVert * tmpvar_234)
  ), 0.0, 1.0));
  tmpvar_10.w = half(tmpvar_236);
  tmpvar_9.w = (tmpvar_9.w * tmpvar_10.w);
  float3 tmpvar_237;
  tmpvar_237.yz = float2(0.0, 0.0);
  tmpvar_237.x = fract(_mtl_u._Rotation);
  float3 x_238;
  x_238 = (tmpvar_237 + tmpvar_204);
  float3 trans_239;
  trans_239 = localOrigin_6.xyz;
  float tmpvar_240;
  tmpvar_240 = (x_238.x * 6.283185);
  float tmpvar_241;
  tmpvar_241 = (x_238.y * 6.283185);
  float tmpvar_242;
  tmpvar_242 = (x_238.z * 2.0);
  float tmpvar_243;
  tmpvar_243 = sqrt(tmpvar_242);
  float tmpvar_244;
  tmpvar_244 = (sin(tmpvar_241) * tmpvar_243);
  float tmpvar_245;
  tmpvar_245 = (cos(tmpvar_241) * tmpvar_243);
  float tmpvar_246;
  tmpvar_246 = sqrt((2.0 - tmpvar_242));
  float tmpvar_247;
  tmpvar_247 = sin(tmpvar_240);
  float tmpvar_248;
  tmpvar_248 = cos(tmpvar_240);
  float tmpvar_249;
  tmpvar_249 = ((tmpvar_244 * tmpvar_248) - (tmpvar_245 * tmpvar_247));
  float tmpvar_250;
  tmpvar_250 = ((tmpvar_244 * tmpvar_247) + (tmpvar_245 * tmpvar_248));
  float4x4 tmpvar_251;
  tmpvar_251[0].x = (tmpvar_205 * ((tmpvar_244 * tmpvar_249) - tmpvar_248));
  tmpvar_251[0].y = ((tmpvar_244 * tmpvar_250) - tmpvar_247);
  tmpvar_251[0].z = (tmpvar_244 * tmpvar_246);
  tmpvar_251[0].w = 0.0;
  tmpvar_251[1].x = ((tmpvar_245 * tmpvar_249) + tmpvar_247);
  tmpvar_251[1].y = (tmpvar_205 * ((tmpvar_245 * tmpvar_250) - tmpvar_248));
  tmpvar_251[1].z = (tmpvar_245 * tmpvar_246);
  tmpvar_251[1].w = 0.0;
  tmpvar_251[2].x = (tmpvar_246 * tmpvar_249);
  tmpvar_251[2].y = (tmpvar_246 * tmpvar_250);
  tmpvar_251[2].z = (tmpvar_205 * (1.0 - tmpvar_242));
  tmpvar_251[2].w = 0.0;
  tmpvar_251[3].x = trans_239.x;
  tmpvar_251[3].y = trans_239.y;
  tmpvar_251[3].z = trans_239.z;
  tmpvar_251[3].w = 1.0;
  float4x4 tmpvar_252;
  tmpvar_252 = ((_mtl_u.unity_MatrixV * _mtl_u._Object2World) * tmpvar_251);
  float4 v_253;
  v_253.x = tmpvar_252[0].z;
  v_253.y = tmpvar_252[1].z;
  v_253.z = tmpvar_252[2].z;
  v_253.w = tmpvar_252[3].z;
  float3 tmpvar_254;
  tmpvar_254 = normalize(v_253.xyz);
  float3 tmpvar_255;
  tmpvar_255 = abs(tmpvar_254);
  tmpvar_10.xyz = half3(tmpvar_255);
  float4 tmpvar_256;
  tmpvar_256 = (_mtl_u.glstate_matrix_modelview0 * localOrigin_6);
  float4 tmpvar_257;
  tmpvar_257.xyz = (_mtl_i._glesVertex.xyz * tmpvar_205);
  tmpvar_257.w = _mtl_i._glesVertex.w;
  float2 tmpvar_258;
  tmpvar_258 = ((2.0 * _mtl_i._glesMultiTexCoord0.xy) - 1.0);
  float4 tmpvar_259;
  tmpvar_259.z = 0.0;
  tmpvar_259.xy = tmpvar_258;
  tmpvar_259.w = _mtl_i._glesVertex.w;
  ZYv_5.xyw = tmpvar_259.zyw;
  XZv_4.yzw = tmpvar_259.zyw;
  XYv_3.yzw = tmpvar_259.yzw;
  ZYv_5.z = (tmpvar_258.x * sign(-(tmpvar_254.x)));
  XZv_4.x = (tmpvar_258.x * sign(-(tmpvar_254.y)));
  XYv_3.x = (tmpvar_258.x * sign(tmpvar_254.z));
  ZYv_5.x = ((sign(
    -(tmpvar_254.x)
  ) * sign(ZYv_5.z)) * tmpvar_254.z);
  XZv_4.y = ((sign(
    -(tmpvar_254.y)
  ) * sign(XZv_4.x)) * tmpvar_254.x);
  XYv_3.z = ((sign(
    -(tmpvar_254.z)
  ) * sign(XYv_3.x)) * tmpvar_254.x);
  ZYv_5.x = (ZYv_5.x + ((
    sign(-(tmpvar_254.x))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  XZv_4.y = (XZv_4.y + ((
    sign(-(tmpvar_254.y))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.z));
  XYv_3.z = (XYv_3.z + ((
    sign(-(tmpvar_254.z))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  float3 tmpvar_260;
  tmpvar_260 = normalize((origin_8.xyz - _mtl_u._WorldSpaceCameraPos));
  float3 tmpvar_261;
  tmpvar_261 = normalize(-(tmpvar_260));
  normal_2 = half3(tmpvar_261);
  float4 v_262;
  v_262.x = _mtl_u.unity_MatrixV[0].x;
  v_262.y = _mtl_u.unity_MatrixV[1].x;
  v_262.z = _mtl_u.unity_MatrixV[2].x;
  v_262.w = _mtl_u.unity_MatrixV[3].x;
  float3 tmpvar_263;
  tmpvar_263 = normalize(v_262.xyz);
  float3 tmpvar_264;
  float3 tmpvar_265;
  tmpvar_264 = v_262.xyz;
  tmpvar_265 = (((float3)normal_2.zxy * tmpvar_263.yzx) - ((float3)normal_2.yzx * tmpvar_263.zxy));
  float3 tmpvar_266;
  tmpvar_266 = float3(normal_2);
  float3x3 tmpvar_267;
  tmpvar_267[0].x = tmpvar_264.x;
  tmpvar_267[0].y = tmpvar_265.x;
  tmpvar_267[0].z = tmpvar_266.x;
  tmpvar_267[1].x = tmpvar_264.y;
  tmpvar_267[1].y = tmpvar_265.y;
  tmpvar_267[1].z = tmpvar_266.y;
  tmpvar_267[2].x = tmpvar_264.z;
  tmpvar_267[2].y = tmpvar_265.z;
  tmpvar_267[2].z = tmpvar_266.z;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_projection * (tmpvar_256 + tmpvar_257));
  _mtl_o.xlv_COLOR = tmpvar_9;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_10;
  _mtl_o.xlv_TEXCOORD1 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * ZYv_5)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD2 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XZv_4)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD3 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XYv_3)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD4 = tmpvar_1;
  _mtl_o.xlv_TEXCOORD5 = tmpvar_11;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_12;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_267 * tmpvar_260));
  _mtl_o.xlv_TEXCOORD8 = normalize((tmpvar_267 * (float3)_mtl_u._WorldSpaceLightPos0.xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 in_POSITION0;
in  vec2 in_TEXCOORD0;
out vec4 vs_COLOR0;
out vec4 vs_TEXCOORD0;
out vec2 vs_TEXCOORD1;
out vec2 vs_TEXCOORD2;
out vec2 vs_TEXCOORD3;
out vec2 vs_TEXCOORD4;
out vec4 vs_TEXCOORD5;
out vec3 vs_TEXCOORD6;
out vec3 vs_TEXCOORD7;
out vec3 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
bvec4 tb1;
vec4 t2;
vec4 t3;
bvec3 tb3;
vec4 t4;
bvec4 tb4;
vec4 t5;
bvec4 tb5;
vec4 t6;
ivec3 ti6;
bvec3 tb6;
vec4 t7;
ivec3 ti7;
bvec4 tb7;
vec4 t8;
vec4 t9;
bvec4 tb9;
vec4 t10;
bvec4 tb10;
vec4 t11;
bvec4 tb11;
vec4 t12;
vec4 t13;
float t15;
vec3 t18;
ivec3 ti18;
vec3 t20;
vec2 t28;
int ti28;
vec2 t29;
int ti29;
vec2 t31;
ivec2 ti31;
bvec2 tb31;
float t42;
int ti42;
float t43;
int ti43;
bool tb43;
float t44;
int ti44;
bool tb44;
float t45;
int ti45;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t44 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t44);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t44 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t44) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t42 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t42);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t42 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t42) + t6.xyz;
    t42 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t42);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t42 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t42) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t42 = dot(t1, t6);
    t0.x = t42 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t42 = t1.x * 0.5;
    t43 = _MaxScale + -1.0;
    t42 = t42 * t43 + 1.0;
    t2.xyz = vec3(t42) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t43 = dot(t5.xyz, t5.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t5.xyz;
    t44 = t5.z * t43 + (-t6.y);
    tb31.x = abs(t6.z)>=abs(t6.y);
    t31.x = tb31.x ? 1.0 : float(0.0);
    t44 = t31.x * t44 + t6.y;
    t43 = (-t5.x) * t43 + t44;
    t44 = max(abs(t6.z), abs(t6.y));
    tb44 = t44>=abs(t6.x);
    t44 = tb44 ? 1.0 : float(0.0);
    t43 = t44 * t43 + t6.x;
    ti45 = int((0.0<t43) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t43<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti43 = (-ti45) + ti43;
    t5.y = float(ti43);
    t7.y = (-t5.y);
    t7.xz = vec2(1.0, -1.0);
    t7.xyz = t6.yzx * t7.xyz;
    t5.xz = vec2(1.0, -1.0);
    t8.xyz = t5.xyz * t6.zyx + (-t7.xyz);
    t7.xyz = t31.xxx * t8.xyz + t7.xyz;
    t7.xyz = (-t5.xxy) * t6.xyz + t7.xyz;
    t5.xyz = t6.xyz * t5.xxy;
    t5.xyz = vec3(t44) * t7.xyz + t5.xyz;
    t31.xy = t5.yz * vec2(0.5, 0.5);
    t31.xy = t31.xy / abs(t5.xx);
    t31.xy = t31.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t31.xy, 0.0);
    t43 = dot(t4.xyz, t4.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb43 = abs(t6.y)<abs(t6.x);
    t44 = max(abs(t6.y), abs(t6.x));
    t44 = float(1.0) / t44;
    t31.x = min(abs(t6.y), abs(t6.x));
    t44 = t44 * t31.x;
    t31.x = t44 * t44;
    t45 = t31.x * 0.0208350997 + -0.0851330012;
    t45 = t31.x * t45 + 0.180141002;
    t45 = t31.x * t45 + -0.330299497;
    t31.x = t31.x * t45 + 0.999866009;
    t45 = t44 * t31.x;
    t45 = t45 * -2.0 + 1.57079637;
    t43 = tb43 ? t45 : float(0.0);
    t43 = t44 * t31.x + t43;
    tb31.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t44 = tb31.x ? -3.14159274 : float(0.0);
    t43 = t43 + t44;
    t44 = min(t6.y, t6.x);
    tb44 = t44<(-t44);
    t31.x = max(t6.y, t6.x);
    tb31.x = t31.x>=(-t31.x);
    ti44 = int(uint(tb44) * 0xffffffffu & uint(tb31.x) * 0xffffffffu);
    t43 = (ti44 != 0) ? (-t43) : t43;
    t4.x = t43 * 0.159154937 + 0.5;
    t43 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t43 = t43 * abs(t6.z) + -0.212114394;
    t43 = t43 * abs(t6.z) + 1.57072878;
    t44 = -abs(t6.z) + 1.0;
    t44 = sqrt(t44);
    t31.x = t43 * t44;
    t31.x = t31.x * -2.0 + 3.14159274;
    t31.x = tb31.y ? t31.x : float(0.0);
    t43 = t43 * t44 + t31.x;
    t4.y = t43 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t4 = t5 * t4;
    vs_COLOR0.xyz = t4.xyz;
    t43 = dot(t2.xyz, t2.xyz);
    t44 = sqrt(t43);
    t43 = inversesqrt(t43);
    t2.xyz = vec3(t43) * t2.xyz;
    t43 = t44 * _DistFade;
    t44 = (-_DistFadeVert) * t44 + 1.0;
    t44 = clamp(t44, 0.0, 1.0);
    t43 = t43;
    t43 = clamp(t43, 0.0, 1.0);
    t43 = t44 * t43;
    vs_COLOR0.w = t43 * t4.w;
    vs_TEXCOORD0.w = t43;
    t4.x = fract(_Rotation);
    t4.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t4.xyz;
    t31.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t31.x);
    t44 = t42 * t31.y;
    t29.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t29.x = sqrt(t29.x);
    t4.x = sin(t1.y);
    t5.x = cos(t1.y);
    t6.x = cos(t1.x);
    t1.x = sin(t1.x);
    t15 = t29.x * t5.x;
    t29.x = t29.x * t4.x;
    t31.xy = t1.wx * vec2(t15);
    t45 = t29.x * t6.x + (-t31.y);
    t4.x = t15 * t45 + t1.x;
    t18.x = t6.x * t15;
    t18.x = t29.x * t1.x + t18.x;
    t15 = t15 * t18.x + (-t6.x);
    t15 = t42 * t15;
    t5.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t5.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t5.xyz;
    t5.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t5.xyz;
    t5.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t5.xyz;
    t20.xyz = vec3(t15) * t5.xyz;
    t7.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t7.xyz;
    t4.xzw = t7.xyz * t4.xxx + t20.xyz;
    t20.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t20.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t20.xyz;
    t20.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t20.xyz;
    t20.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t20.xyz;
    t4.xzw = t20.xyz * t31.xxx + t4.xzw;
    t8.y = t4.w;
    t15 = t29.x * t45 + (-t6.x);
    t1.x = t29.x * t18.x + (-t1.x);
    t29.x = t1.w * t29.x;
    t31.x = t1.w * t18.x;
    t43 = t1.w * t45;
    t9.xyz = t31.xxx * t5.xyz;
    t9.xyz = t7.xyz * vec3(t43) + t9.xyz;
    t9.xyz = t20.xyz * vec3(t44) + t9.xyz;
    t10.xyz = t1.xxx * t5.xyz;
    t1.xw = t0.yy * t5.xy;
    t0.xy = t7.xy * t0.xx + t1.xw;
    t0.xy = t20.xy * t0.zz + t0.xy;
    t28.x = t42 * t15;
    t1.xyw = t7.xyz * t28.xxx + t10.xyz;
    t1.xyz = t20.xyz * t29.xxx + t1.xyw;
    t8.x = t1.z;
    t8.z = t9.z;
    t28.x = dot(t8.xyz, t8.xyz);
    t28.x = inversesqrt(t28.x);
    t5.xyz = t28.xxx * t8.xyz;
    vs_TEXCOORD0.xyz = abs(t5.xyz);
    t28.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t28.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t28.xy;
    t28.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t28.xy;
    t28.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t28.xy;
    t0.xy = t28.xy + t0.xy;
    ti6.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t5.xyzx)).xyz) * 0xFFFFFFFFu);
    ti7.xyz = ivec3(uvec3(lessThan((-t5.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti6.xyz = (-ti6.xyz) + ti7.xyz;
    t28.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti29 = int((0.0<t28.y) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t28.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti29 = (-ti29) + ti43;
    ti7.xyz = ivec3(ti29) * ti6.xyz;
    t7.xyz = vec3(ti7.xyz);
    t7.xyz = t5.yzy * t7.xyz;
    t29.xy = vec2(ti6.xy);
    t29.xy = t28.xx * t29.xy;
    ti31.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t29.xyxy).xy) * 0xFFFFFFFFu);
    ti18.xz = ivec2(uvec2(lessThan(t29.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti31.xy = (-ti31.xy) + ti18.xz;
    ti31.xy = ti31.xy * ti6.xy;
    t31.xy = vec2(ti31.xy);
    t31.xy = t31.xy * t5.zx + t7.xy;
    t18.xz = t31.yy * t4.xz;
    t4.xz = t28.yy * t4.xz;
    t31.xy = t1.xy * t31.xx + t4.xz;
    t31.xy = t9.xy * t29.xx + t31.xy;
    t29.xy = t1.xy * t29.yy + t18.xz;
    t29.xy = t9.xy * t28.yy + t29.xy;
    t29.xy = t0.xy * in_POSITION0.ww + t29.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD2.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t29.xy = t0.xy * in_POSITION0.ww + t31.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD1.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti42 = int((0.0<t5.z) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t5.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti42 = (-ti42) + ti29;
    t42 = float(ti42);
    t28.x = t42 * t28.x;
    ti42 = int((0.0<t28.x) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t28.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t28.xx + t4.xz;
    ti28 = (-ti42) + ti29;
    ti28 = ti28 * ti6.z;
    t28.x = float(ti28);
    t28.x = t28.x * t5.x + t7.z;
    t28.xy = t9.xy * t28.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t28.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t42 = dot(t3.xyz, t3.xyz);
    t42 = inversesqrt(t42);
    t4.xyz = vec3(t42) * t3.yzx;
    t5.xyz = t0.zxy * t4.xyz;
    t4.xyz = t0.yzx * t4.yzx + (-t5.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t4.xyz), t2.xyz);
    t0.y = dot((-t4.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t42 = dot(t1.xyz, t1.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD7.xyz = vec3(t42) * t1.xyz;
    t42 = dot(t0.xyz, t0.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD8.xyz = vec3(t42) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _Tex;
in  vec4 vs_COLOR0;
in  vec4 vs_TEXCOORD0;
in  vec2 vs_TEXCOORD1;
in  vec2 vs_TEXCOORD2;
in  vec2 vs_TEXCOORD3;
in  vec2 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD7;
in  vec3 vs_TEXCOORD8;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
vec3 t3;
vec3 t4;
vec2 t8;
float t12;
void main()
{
    t0 = texture(_Tex, vs_TEXCOORD1.xy);
    t10_1 = texture(_Tex, vs_TEXCOORD2.xy);
    t0.y = t10_1.y;
    t10_1 = texture(_Tex, vs_TEXCOORD3.xy);
    t0.z = t10_1.z;
    t0.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t12 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t12 = t12 + vs_TEXCOORD0.z;
    t0.xyz = t0.xyz / vec3(t12);
    t0.x = t0.y + t0.x;
    t0.x = t0.z + t0.x;
    t4.x = t0.x * vs_TEXCOORD0.w;
    t4.x = (-_Opacity) * t4.x + _MinScatter;
    t8.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t8.xy, t8.xy);
    t8.x = min(t8.x, 1.0);
    t8.x = (-t8.x) + 1.0;
    t1.z = sqrt(t8.x);
    t1.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t1.xyz, t1.xyz);
    t8.x = inversesqrt(t8.x);
    t1.xyz = t8.xxx * t1.xyz;
    t8.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t8.x = inversesqrt(t8.x);
    t2.xyz = t8.xxx * vs_TEXCOORD7.xyz;
    t8.x = dot(t1.xyz, t2.xyz);
    t8.x = (-t8.x) + 1.0;
    t4.x = t8.x * t4.x;
    t8.x = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t8.x = inversesqrt(t8.x);
    t3.xyz = t8.xxx * vs_TEXCOORD8.xyz;
    t8.x = dot(t2.xyz, t3.xyz);
    t12 = dot(t1.xyz, t3.xyz);
    t12 = max(t12, 0.0);
    t8.x = t8.x * 0.5 + 0.5;
    t4.x = t8.x * t4.x;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t4.x = t4.x + t12;
    t4.xyz = t4.xxx * _LightColor0.xyz;
    t0.yzw = t4.xyz + t4.xyz;
    t1 = vs_COLOR0 * _Color;
    SV_Target0 = t0.yzwx * t1;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _WorldSpaceLightPos0;

uniform mat4 _Object2World;

uniform mat4 unity_MatrixV;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform mat4 _PosRotation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _Rotation;
uniform float _MaxScale;
uniform vec4 _NoiseScale;
uniform vec3 _MaxTrans;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec4 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec2 tmpvar_1;
  tmpvar_1 = gl_MultiTexCoord0.xy;
  vec4 XYv_2;
  vec4 XZv_3;
  vec4 ZYv_4;
  vec4 localOrigin_5;
  vec4 planet_pos_6;
  vec4 origin_7;
  vec4 tmpvar_8;
  vec4 tmpvar_9;
  vec4 tmpvar_10;
  vec3 tmpvar_11;
  vec4 tmpvar_12;
  tmpvar_12 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_7 = tmpvar_12;
  vec4 tmpvar_13;
  tmpvar_13 = (_PosRotation * tmpvar_12);
  planet_pos_6 = tmpvar_13;
  vec3 tmpvar_14;
  tmpvar_14 = (_NoiseScale.z * tmpvar_13.xyz);
  float tmpvar_15;
  vec4 m_16;
  vec3 tmpvar_17;
  tmpvar_17 = floor((tmpvar_14 + dot (tmpvar_14, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_18;
  tmpvar_18 = ((tmpvar_14 - tmpvar_17) + dot (tmpvar_17, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_19;
  tmpvar_19.x = float((tmpvar_18.x >= tmpvar_18.y));
  tmpvar_19.y = float((tmpvar_18.y >= tmpvar_18.z));
  tmpvar_19.z = float((tmpvar_18.z >= tmpvar_18.x));
  vec3 tmpvar_20;
  tmpvar_20 = (1.0 - tmpvar_19);
  vec3 tmpvar_21;
  tmpvar_21 = min (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_22;
  tmpvar_22 = max (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_23;
  tmpvar_23 = ((tmpvar_18 - tmpvar_21) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_24;
  tmpvar_24 = ((tmpvar_18 - tmpvar_22) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_25;
  tmpvar_25 = (tmpvar_18 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_26;
  tmpvar_26 = (tmpvar_17 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_27;
  tmpvar_27 = (fract(abs(tmpvar_26)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_28;
  if ((tmpvar_26.x >= 0.0)) {
    tmpvar_28 = tmpvar_27.x;
  } else {
    tmpvar_28 = -(tmpvar_27.x);
  };
  float tmpvar_29;
  if ((tmpvar_26.y >= 0.0)) {
    tmpvar_29 = tmpvar_27.y;
  } else {
    tmpvar_29 = -(tmpvar_27.y);
  };
  float tmpvar_30;
  if ((tmpvar_26.z >= 0.0)) {
    tmpvar_30 = tmpvar_27.z;
  } else {
    tmpvar_30 = -(tmpvar_27.z);
  };
  vec4 tmpvar_31;
  tmpvar_31.xw = vec2(0.0, 1.0);
  tmpvar_31.y = tmpvar_21.z;
  tmpvar_31.z = tmpvar_22.z;
  vec4 x_32;
  x_32 = (tmpvar_30 + tmpvar_31);
  vec4 tmpvar_33;
  tmpvar_33 = (((
    (x_32 * x_32)
   * 34.0) + x_32) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_34;
  tmpvar_34 = (fract(abs(tmpvar_33)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_35;
  if ((tmpvar_33.x >= 0.0)) {
    tmpvar_35 = tmpvar_34.x;
  } else {
    tmpvar_35 = -(tmpvar_34.x);
  };
  float tmpvar_36;
  if ((tmpvar_33.y >= 0.0)) {
    tmpvar_36 = tmpvar_34.y;
  } else {
    tmpvar_36 = -(tmpvar_34.y);
  };
  float tmpvar_37;
  if ((tmpvar_33.z >= 0.0)) {
    tmpvar_37 = tmpvar_34.z;
  } else {
    tmpvar_37 = -(tmpvar_34.z);
  };
  float tmpvar_38;
  if ((tmpvar_33.w >= 0.0)) {
    tmpvar_38 = tmpvar_34.w;
  } else {
    tmpvar_38 = -(tmpvar_34.w);
  };
  vec4 tmpvar_39;
  tmpvar_39.x = tmpvar_35;
  tmpvar_39.y = tmpvar_36;
  tmpvar_39.z = tmpvar_37;
  tmpvar_39.w = tmpvar_38;
  vec4 tmpvar_40;
  tmpvar_40.xw = vec2(0.0, 1.0);
  tmpvar_40.y = tmpvar_21.y;
  tmpvar_40.z = tmpvar_22.y;
  vec4 x_41;
  x_41 = ((tmpvar_39 + tmpvar_29) + tmpvar_40);
  vec4 tmpvar_42;
  tmpvar_42 = (((
    (x_41 * x_41)
   * 34.0) + x_41) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_43;
  tmpvar_43 = (fract(abs(tmpvar_42)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_44;
  if ((tmpvar_42.x >= 0.0)) {
    tmpvar_44 = tmpvar_43.x;
  } else {
    tmpvar_44 = -(tmpvar_43.x);
  };
  float tmpvar_45;
  if ((tmpvar_42.y >= 0.0)) {
    tmpvar_45 = tmpvar_43.y;
  } else {
    tmpvar_45 = -(tmpvar_43.y);
  };
  float tmpvar_46;
  if ((tmpvar_42.z >= 0.0)) {
    tmpvar_46 = tmpvar_43.z;
  } else {
    tmpvar_46 = -(tmpvar_43.z);
  };
  float tmpvar_47;
  if ((tmpvar_42.w >= 0.0)) {
    tmpvar_47 = tmpvar_43.w;
  } else {
    tmpvar_47 = -(tmpvar_43.w);
  };
  vec4 tmpvar_48;
  tmpvar_48.x = tmpvar_44;
  tmpvar_48.y = tmpvar_45;
  tmpvar_48.z = tmpvar_46;
  tmpvar_48.w = tmpvar_47;
  vec4 tmpvar_49;
  tmpvar_49.xw = vec2(0.0, 1.0);
  tmpvar_49.y = tmpvar_21.x;
  tmpvar_49.z = tmpvar_22.x;
  vec4 x_50;
  x_50 = ((tmpvar_48 + tmpvar_28) + tmpvar_49);
  vec4 tmpvar_51;
  tmpvar_51 = (((
    (x_50 * x_50)
   * 34.0) + x_50) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_52;
  tmpvar_52 = (fract(abs(tmpvar_51)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_53;
  if ((tmpvar_51.x >= 0.0)) {
    tmpvar_53 = tmpvar_52.x;
  } else {
    tmpvar_53 = -(tmpvar_52.x);
  };
  float tmpvar_54;
  if ((tmpvar_51.y >= 0.0)) {
    tmpvar_54 = tmpvar_52.y;
  } else {
    tmpvar_54 = -(tmpvar_52.y);
  };
  float tmpvar_55;
  if ((tmpvar_51.z >= 0.0)) {
    tmpvar_55 = tmpvar_52.z;
  } else {
    tmpvar_55 = -(tmpvar_52.z);
  };
  float tmpvar_56;
  if ((tmpvar_51.w >= 0.0)) {
    tmpvar_56 = tmpvar_52.w;
  } else {
    tmpvar_56 = -(tmpvar_52.w);
  };
  vec4 tmpvar_57;
  tmpvar_57.x = tmpvar_53;
  tmpvar_57.y = tmpvar_54;
  tmpvar_57.z = tmpvar_55;
  tmpvar_57.w = tmpvar_56;
  vec4 tmpvar_58;
  tmpvar_58 = (tmpvar_57 - (49.0 * floor(
    (0.02040815 * tmpvar_57)
  )));
  vec4 tmpvar_59;
  tmpvar_59 = floor((tmpvar_58 * 0.1428571));
  vec4 tmpvar_60;
  tmpvar_60 = ((tmpvar_59 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_61;
  tmpvar_61 = ((floor(
    (tmpvar_58 - (7.0 * tmpvar_59))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_62;
  tmpvar_62 = ((1.0 - abs(tmpvar_60)) - abs(tmpvar_61));
  vec4 tmpvar_63;
  tmpvar_63.xy = tmpvar_60.xy;
  tmpvar_63.zw = tmpvar_61.xy;
  vec4 tmpvar_64;
  tmpvar_64.xy = tmpvar_60.zw;
  tmpvar_64.zw = tmpvar_61.zw;
  vec4 tmpvar_65;
  tmpvar_65 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_62)));
  vec4 tmpvar_66;
  tmpvar_66 = (tmpvar_63.xzyw + ((
    (floor(tmpvar_63) * 2.0)
   + 1.0).xzyw * tmpvar_65.xxyy));
  vec4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_65.zzww));
  vec3 tmpvar_68;
  tmpvar_68.xy = tmpvar_66.xy;
  tmpvar_68.z = tmpvar_62.x;
  vec3 tmpvar_69;
  tmpvar_69.xy = tmpvar_66.zw;
  tmpvar_69.z = tmpvar_62.y;
  vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.xy;
  tmpvar_70.z = tmpvar_62.z;
  vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_67.zw;
  tmpvar_71.z = tmpvar_62.w;
  vec4 tmpvar_72;
  tmpvar_72.x = dot (tmpvar_68, tmpvar_68);
  tmpvar_72.y = dot (tmpvar_69, tmpvar_69);
  tmpvar_72.z = dot (tmpvar_70, tmpvar_70);
  tmpvar_72.w = dot (tmpvar_71, tmpvar_71);
  vec4 tmpvar_73;
  tmpvar_73 = (1.792843 - (0.8537347 * tmpvar_72));
  vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_18, tmpvar_18);
  tmpvar_74.y = dot (tmpvar_23, tmpvar_23);
  tmpvar_74.z = dot (tmpvar_24, tmpvar_24);
  tmpvar_74.w = dot (tmpvar_25, tmpvar_25);
  vec4 tmpvar_75;
  tmpvar_75 = max ((0.6 - tmpvar_74), vec4(0.0, 0.0, 0.0, 0.0));
  m_16 = (tmpvar_75 * tmpvar_75);
  vec4 tmpvar_76;
  tmpvar_76.x = dot ((tmpvar_68 * tmpvar_73.x), tmpvar_18);
  tmpvar_76.y = dot ((tmpvar_69 * tmpvar_73.y), tmpvar_23);
  tmpvar_76.z = dot ((tmpvar_70 * tmpvar_73.z), tmpvar_24);
  tmpvar_76.w = dot ((tmpvar_71 * tmpvar_73.w), tmpvar_25);
  tmpvar_15 = (42.0 * dot ((m_16 * m_16), tmpvar_76));
  float tmpvar_77;
  vec3 v_78;
  v_78 = (_NoiseScale.x * tmpvar_14);
  vec4 m_79;
  vec3 tmpvar_80;
  tmpvar_80 = floor((v_78 + dot (v_78, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_81;
  tmpvar_81 = ((v_78 - tmpvar_80) + dot (tmpvar_80, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_82;
  tmpvar_82.x = float((tmpvar_81.x >= tmpvar_81.y));
  tmpvar_82.y = float((tmpvar_81.y >= tmpvar_81.z));
  tmpvar_82.z = float((tmpvar_81.z >= tmpvar_81.x));
  vec3 tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_82);
  vec3 tmpvar_84;
  tmpvar_84 = min (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_85;
  tmpvar_85 = max (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_86;
  tmpvar_86 = ((tmpvar_81 - tmpvar_84) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_87;
  tmpvar_87 = ((tmpvar_81 - tmpvar_85) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_88;
  tmpvar_88 = (tmpvar_81 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_89;
  tmpvar_89 = (tmpvar_80 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_90;
  tmpvar_90 = (fract(abs(tmpvar_89)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_91;
  if ((tmpvar_89.x >= 0.0)) {
    tmpvar_91 = tmpvar_90.x;
  } else {
    tmpvar_91 = -(tmpvar_90.x);
  };
  float tmpvar_92;
  if ((tmpvar_89.y >= 0.0)) {
    tmpvar_92 = tmpvar_90.y;
  } else {
    tmpvar_92 = -(tmpvar_90.y);
  };
  float tmpvar_93;
  if ((tmpvar_89.z >= 0.0)) {
    tmpvar_93 = tmpvar_90.z;
  } else {
    tmpvar_93 = -(tmpvar_90.z);
  };
  vec4 tmpvar_94;
  tmpvar_94.xw = vec2(0.0, 1.0);
  tmpvar_94.y = tmpvar_84.z;
  tmpvar_94.z = tmpvar_85.z;
  vec4 x_95;
  x_95 = (tmpvar_93 + tmpvar_94);
  vec4 tmpvar_96;
  tmpvar_96 = (((
    (x_95 * x_95)
   * 34.0) + x_95) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_97;
  tmpvar_97 = (fract(abs(tmpvar_96)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_98;
  if ((tmpvar_96.x >= 0.0)) {
    tmpvar_98 = tmpvar_97.x;
  } else {
    tmpvar_98 = -(tmpvar_97.x);
  };
  float tmpvar_99;
  if ((tmpvar_96.y >= 0.0)) {
    tmpvar_99 = tmpvar_97.y;
  } else {
    tmpvar_99 = -(tmpvar_97.y);
  };
  float tmpvar_100;
  if ((tmpvar_96.z >= 0.0)) {
    tmpvar_100 = tmpvar_97.z;
  } else {
    tmpvar_100 = -(tmpvar_97.z);
  };
  float tmpvar_101;
  if ((tmpvar_96.w >= 0.0)) {
    tmpvar_101 = tmpvar_97.w;
  } else {
    tmpvar_101 = -(tmpvar_97.w);
  };
  vec4 tmpvar_102;
  tmpvar_102.x = tmpvar_98;
  tmpvar_102.y = tmpvar_99;
  tmpvar_102.z = tmpvar_100;
  tmpvar_102.w = tmpvar_101;
  vec4 tmpvar_103;
  tmpvar_103.xw = vec2(0.0, 1.0);
  tmpvar_103.y = tmpvar_84.y;
  tmpvar_103.z = tmpvar_85.y;
  vec4 x_104;
  x_104 = ((tmpvar_102 + tmpvar_92) + tmpvar_103);
  vec4 tmpvar_105;
  tmpvar_105 = (((
    (x_104 * x_104)
   * 34.0) + x_104) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_106;
  tmpvar_106 = (fract(abs(tmpvar_105)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_107;
  if ((tmpvar_105.x >= 0.0)) {
    tmpvar_107 = tmpvar_106.x;
  } else {
    tmpvar_107 = -(tmpvar_106.x);
  };
  float tmpvar_108;
  if ((tmpvar_105.y >= 0.0)) {
    tmpvar_108 = tmpvar_106.y;
  } else {
    tmpvar_108 = -(tmpvar_106.y);
  };
  float tmpvar_109;
  if ((tmpvar_105.z >= 0.0)) {
    tmpvar_109 = tmpvar_106.z;
  } else {
    tmpvar_109 = -(tmpvar_106.z);
  };
  float tmpvar_110;
  if ((tmpvar_105.w >= 0.0)) {
    tmpvar_110 = tmpvar_106.w;
  } else {
    tmpvar_110 = -(tmpvar_106.w);
  };
  vec4 tmpvar_111;
  tmpvar_111.x = tmpvar_107;
  tmpvar_111.y = tmpvar_108;
  tmpvar_111.z = tmpvar_109;
  tmpvar_111.w = tmpvar_110;
  vec4 tmpvar_112;
  tmpvar_112.xw = vec2(0.0, 1.0);
  tmpvar_112.y = tmpvar_84.x;
  tmpvar_112.z = tmpvar_85.x;
  vec4 x_113;
  x_113 = ((tmpvar_111 + tmpvar_91) + tmpvar_112);
  vec4 tmpvar_114;
  tmpvar_114 = (((
    (x_113 * x_113)
   * 34.0) + x_113) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_115;
  tmpvar_115 = (fract(abs(tmpvar_114)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_116;
  if ((tmpvar_114.x >= 0.0)) {
    tmpvar_116 = tmpvar_115.x;
  } else {
    tmpvar_116 = -(tmpvar_115.x);
  };
  float tmpvar_117;
  if ((tmpvar_114.y >= 0.0)) {
    tmpvar_117 = tmpvar_115.y;
  } else {
    tmpvar_117 = -(tmpvar_115.y);
  };
  float tmpvar_118;
  if ((tmpvar_114.z >= 0.0)) {
    tmpvar_118 = tmpvar_115.z;
  } else {
    tmpvar_118 = -(tmpvar_115.z);
  };
  float tmpvar_119;
  if ((tmpvar_114.w >= 0.0)) {
    tmpvar_119 = tmpvar_115.w;
  } else {
    tmpvar_119 = -(tmpvar_115.w);
  };
  vec4 tmpvar_120;
  tmpvar_120.x = tmpvar_116;
  tmpvar_120.y = tmpvar_117;
  tmpvar_120.z = tmpvar_118;
  tmpvar_120.w = tmpvar_119;
  vec4 tmpvar_121;
  tmpvar_121 = (tmpvar_120 - (49.0 * floor(
    (0.02040815 * tmpvar_120)
  )));
  vec4 tmpvar_122;
  tmpvar_122 = floor((tmpvar_121 * 0.1428571));
  vec4 tmpvar_123;
  tmpvar_123 = ((tmpvar_122 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_124;
  tmpvar_124 = ((floor(
    (tmpvar_121 - (7.0 * tmpvar_122))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_125;
  tmpvar_125 = ((1.0 - abs(tmpvar_123)) - abs(tmpvar_124));
  vec4 tmpvar_126;
  tmpvar_126.xy = tmpvar_123.xy;
  tmpvar_126.zw = tmpvar_124.xy;
  vec4 tmpvar_127;
  tmpvar_127.xy = tmpvar_123.zw;
  tmpvar_127.zw = tmpvar_124.zw;
  vec4 tmpvar_128;
  tmpvar_128 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_125)));
  vec4 tmpvar_129;
  tmpvar_129 = (tmpvar_126.xzyw + ((
    (floor(tmpvar_126) * 2.0)
   + 1.0).xzyw * tmpvar_128.xxyy));
  vec4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_128.zzww));
  vec3 tmpvar_131;
  tmpvar_131.xy = tmpvar_129.xy;
  tmpvar_131.z = tmpvar_125.x;
  vec3 tmpvar_132;
  tmpvar_132.xy = tmpvar_129.zw;
  tmpvar_132.z = tmpvar_125.y;
  vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.xy;
  tmpvar_133.z = tmpvar_125.z;
  vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_130.zw;
  tmpvar_134.z = tmpvar_125.w;
  vec4 tmpvar_135;
  tmpvar_135.x = dot (tmpvar_131, tmpvar_131);
  tmpvar_135.y = dot (tmpvar_132, tmpvar_132);
  tmpvar_135.z = dot (tmpvar_133, tmpvar_133);
  tmpvar_135.w = dot (tmpvar_134, tmpvar_134);
  vec4 tmpvar_136;
  tmpvar_136 = (1.792843 - (0.8537347 * tmpvar_135));
  vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_81, tmpvar_81);
  tmpvar_137.y = dot (tmpvar_86, tmpvar_86);
  tmpvar_137.z = dot (tmpvar_87, tmpvar_87);
  tmpvar_137.w = dot (tmpvar_88, tmpvar_88);
  vec4 tmpvar_138;
  tmpvar_138 = max ((0.6 - tmpvar_137), vec4(0.0, 0.0, 0.0, 0.0));
  m_79 = (tmpvar_138 * tmpvar_138);
  vec4 tmpvar_139;
  tmpvar_139.x = dot ((tmpvar_131 * tmpvar_136.x), tmpvar_81);
  tmpvar_139.y = dot ((tmpvar_132 * tmpvar_136.y), tmpvar_86);
  tmpvar_139.z = dot ((tmpvar_133 * tmpvar_136.z), tmpvar_87);
  tmpvar_139.w = dot ((tmpvar_134 * tmpvar_136.w), tmpvar_88);
  tmpvar_77 = (42.0 * dot ((m_79 * m_79), tmpvar_139));
  vec3 v_140;
  v_140 = (_NoiseScale.y * tmpvar_14);
  vec4 m_141;
  vec3 tmpvar_142;
  tmpvar_142 = floor((v_140 + dot (v_140, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_143;
  tmpvar_143 = ((v_140 - tmpvar_142) + dot (tmpvar_142, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_144;
  tmpvar_144.x = float((tmpvar_143.x >= tmpvar_143.y));
  tmpvar_144.y = float((tmpvar_143.y >= tmpvar_143.z));
  tmpvar_144.z = float((tmpvar_143.z >= tmpvar_143.x));
  vec3 tmpvar_145;
  tmpvar_145 = (1.0 - tmpvar_144);
  vec3 tmpvar_146;
  tmpvar_146 = min (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_147;
  tmpvar_147 = max (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_148;
  tmpvar_148 = ((tmpvar_143 - tmpvar_146) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_149;
  tmpvar_149 = ((tmpvar_143 - tmpvar_147) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_150;
  tmpvar_150 = (tmpvar_143 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_151;
  tmpvar_151 = (tmpvar_142 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_152;
  tmpvar_152 = (fract(abs(tmpvar_151)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_153;
  if ((tmpvar_151.x >= 0.0)) {
    tmpvar_153 = tmpvar_152.x;
  } else {
    tmpvar_153 = -(tmpvar_152.x);
  };
  float tmpvar_154;
  if ((tmpvar_151.y >= 0.0)) {
    tmpvar_154 = tmpvar_152.y;
  } else {
    tmpvar_154 = -(tmpvar_152.y);
  };
  float tmpvar_155;
  if ((tmpvar_151.z >= 0.0)) {
    tmpvar_155 = tmpvar_152.z;
  } else {
    tmpvar_155 = -(tmpvar_152.z);
  };
  vec4 tmpvar_156;
  tmpvar_156.xw = vec2(0.0, 1.0);
  tmpvar_156.y = tmpvar_146.z;
  tmpvar_156.z = tmpvar_147.z;
  vec4 x_157;
  x_157 = (tmpvar_155 + tmpvar_156);
  vec4 tmpvar_158;
  tmpvar_158 = (((
    (x_157 * x_157)
   * 34.0) + x_157) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_159;
  tmpvar_159 = (fract(abs(tmpvar_158)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_160;
  if ((tmpvar_158.x >= 0.0)) {
    tmpvar_160 = tmpvar_159.x;
  } else {
    tmpvar_160 = -(tmpvar_159.x);
  };
  float tmpvar_161;
  if ((tmpvar_158.y >= 0.0)) {
    tmpvar_161 = tmpvar_159.y;
  } else {
    tmpvar_161 = -(tmpvar_159.y);
  };
  float tmpvar_162;
  if ((tmpvar_158.z >= 0.0)) {
    tmpvar_162 = tmpvar_159.z;
  } else {
    tmpvar_162 = -(tmpvar_159.z);
  };
  float tmpvar_163;
  if ((tmpvar_158.w >= 0.0)) {
    tmpvar_163 = tmpvar_159.w;
  } else {
    tmpvar_163 = -(tmpvar_159.w);
  };
  vec4 tmpvar_164;
  tmpvar_164.x = tmpvar_160;
  tmpvar_164.y = tmpvar_161;
  tmpvar_164.z = tmpvar_162;
  tmpvar_164.w = tmpvar_163;
  vec4 tmpvar_165;
  tmpvar_165.xw = vec2(0.0, 1.0);
  tmpvar_165.y = tmpvar_146.y;
  tmpvar_165.z = tmpvar_147.y;
  vec4 x_166;
  x_166 = ((tmpvar_164 + tmpvar_154) + tmpvar_165);
  vec4 tmpvar_167;
  tmpvar_167 = (((
    (x_166 * x_166)
   * 34.0) + x_166) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_168;
  tmpvar_168 = (fract(abs(tmpvar_167)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_169;
  if ((tmpvar_167.x >= 0.0)) {
    tmpvar_169 = tmpvar_168.x;
  } else {
    tmpvar_169 = -(tmpvar_168.x);
  };
  float tmpvar_170;
  if ((tmpvar_167.y >= 0.0)) {
    tmpvar_170 = tmpvar_168.y;
  } else {
    tmpvar_170 = -(tmpvar_168.y);
  };
  float tmpvar_171;
  if ((tmpvar_167.z >= 0.0)) {
    tmpvar_171 = tmpvar_168.z;
  } else {
    tmpvar_171 = -(tmpvar_168.z);
  };
  float tmpvar_172;
  if ((tmpvar_167.w >= 0.0)) {
    tmpvar_172 = tmpvar_168.w;
  } else {
    tmpvar_172 = -(tmpvar_168.w);
  };
  vec4 tmpvar_173;
  tmpvar_173.x = tmpvar_169;
  tmpvar_173.y = tmpvar_170;
  tmpvar_173.z = tmpvar_171;
  tmpvar_173.w = tmpvar_172;
  vec4 tmpvar_174;
  tmpvar_174.xw = vec2(0.0, 1.0);
  tmpvar_174.y = tmpvar_146.x;
  tmpvar_174.z = tmpvar_147.x;
  vec4 x_175;
  x_175 = ((tmpvar_173 + tmpvar_153) + tmpvar_174);
  vec4 tmpvar_176;
  tmpvar_176 = (((
    (x_175 * x_175)
   * 34.0) + x_175) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_177;
  tmpvar_177 = (fract(abs(tmpvar_176)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_178;
  if ((tmpvar_176.x >= 0.0)) {
    tmpvar_178 = tmpvar_177.x;
  } else {
    tmpvar_178 = -(tmpvar_177.x);
  };
  float tmpvar_179;
  if ((tmpvar_176.y >= 0.0)) {
    tmpvar_179 = tmpvar_177.y;
  } else {
    tmpvar_179 = -(tmpvar_177.y);
  };
  float tmpvar_180;
  if ((tmpvar_176.z >= 0.0)) {
    tmpvar_180 = tmpvar_177.z;
  } else {
    tmpvar_180 = -(tmpvar_177.z);
  };
  float tmpvar_181;
  if ((tmpvar_176.w >= 0.0)) {
    tmpvar_181 = tmpvar_177.w;
  } else {
    tmpvar_181 = -(tmpvar_177.w);
  };
  vec4 tmpvar_182;
  tmpvar_182.x = tmpvar_178;
  tmpvar_182.y = tmpvar_179;
  tmpvar_182.z = tmpvar_180;
  tmpvar_182.w = tmpvar_181;
  vec4 tmpvar_183;
  tmpvar_183 = (tmpvar_182 - (49.0 * floor(
    (0.02040815 * tmpvar_182)
  )));
  vec4 tmpvar_184;
  tmpvar_184 = floor((tmpvar_183 * 0.1428571));
  vec4 tmpvar_185;
  tmpvar_185 = ((tmpvar_184 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_186;
  tmpvar_186 = ((floor(
    (tmpvar_183 - (7.0 * tmpvar_184))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_187;
  tmpvar_187 = ((1.0 - abs(tmpvar_185)) - abs(tmpvar_186));
  vec4 tmpvar_188;
  tmpvar_188.xy = tmpvar_185.xy;
  tmpvar_188.zw = tmpvar_186.xy;
  vec4 tmpvar_189;
  tmpvar_189.xy = tmpvar_185.zw;
  tmpvar_189.zw = tmpvar_186.zw;
  vec4 tmpvar_190;
  tmpvar_190 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_187)));
  vec4 tmpvar_191;
  tmpvar_191 = (tmpvar_188.xzyw + ((
    (floor(tmpvar_188) * 2.0)
   + 1.0).xzyw * tmpvar_190.xxyy));
  vec4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_190.zzww));
  vec3 tmpvar_193;
  tmpvar_193.xy = tmpvar_191.xy;
  tmpvar_193.z = tmpvar_187.x;
  vec3 tmpvar_194;
  tmpvar_194.xy = tmpvar_191.zw;
  tmpvar_194.z = tmpvar_187.y;
  vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.xy;
  tmpvar_195.z = tmpvar_187.z;
  vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_192.zw;
  tmpvar_196.z = tmpvar_187.w;
  vec4 tmpvar_197;
  tmpvar_197.x = dot (tmpvar_193, tmpvar_193);
  tmpvar_197.y = dot (tmpvar_194, tmpvar_194);
  tmpvar_197.z = dot (tmpvar_195, tmpvar_195);
  tmpvar_197.w = dot (tmpvar_196, tmpvar_196);
  vec4 tmpvar_198;
  tmpvar_198 = (1.792843 - (0.8537347 * tmpvar_197));
  vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_143, tmpvar_143);
  tmpvar_199.y = dot (tmpvar_148, tmpvar_148);
  tmpvar_199.z = dot (tmpvar_149, tmpvar_149);
  tmpvar_199.w = dot (tmpvar_150, tmpvar_150);
  vec4 tmpvar_200;
  tmpvar_200 = max ((0.6 - tmpvar_199), vec4(0.0, 0.0, 0.0, 0.0));
  m_141 = (tmpvar_200 * tmpvar_200);
  vec4 tmpvar_201;
  tmpvar_201.x = dot ((tmpvar_193 * tmpvar_198.x), tmpvar_143);
  tmpvar_201.y = dot ((tmpvar_194 * tmpvar_198.y), tmpvar_148);
  tmpvar_201.z = dot ((tmpvar_195 * tmpvar_198.z), tmpvar_149);
  tmpvar_201.w = dot ((tmpvar_196 * tmpvar_198.w), tmpvar_150);
  vec3 tmpvar_202;
  tmpvar_202.x = tmpvar_15;
  tmpvar_202.y = tmpvar_77;
  tmpvar_202.z = (42.0 * dot ((m_141 * m_141), tmpvar_201));
  vec3 tmpvar_203;
  tmpvar_203 = (0.5 * (tmpvar_202 + 1.0));
  localOrigin_5.xyz = (((2.0 * tmpvar_203) - 1.0) * _MaxTrans);
  localOrigin_5.w = 1.0;
  float tmpvar_204;
  tmpvar_204 = ((tmpvar_203.x * (_MaxScale - 1.0)) + 1.0);
  origin_7 = (_Object2World * localOrigin_5);
  planet_pos_6 = (_MainRotation * origin_7);
  vec3 tmpvar_205;
  tmpvar_205 = (_DetailRotation * planet_pos_6).xyz;
  tmpvar_11 = planet_pos_6.xyz;
  vec3 tmpvar_206;
  tmpvar_206 = normalize(planet_pos_6.xyz);
  vec2 uv_207;
  float tmpvar_208;
  float tmpvar_209;
  tmpvar_209 = (min (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0) / max (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0));
  float tmpvar_210;
  tmpvar_210 = (tmpvar_209 * tmpvar_209);
  tmpvar_210 = (((
    ((((
      ((((-0.01213232 * tmpvar_210) + 0.05368138) * tmpvar_210) - 0.1173503)
     * tmpvar_210) + 0.1938925) * tmpvar_210) - 0.3326756)
   * tmpvar_210) + 0.9999793) * tmpvar_209);
  tmpvar_210 = (tmpvar_210 + (float(
    (abs((tmpvar_206.x / tmpvar_206.z)) > 1.0)
  ) * (
    (tmpvar_210 * -2.0)
   + 1.570796)));
  tmpvar_208 = (tmpvar_210 * sign((tmpvar_206.x / tmpvar_206.z)));
  if ((abs(tmpvar_206.z) > (1e-08 * abs(tmpvar_206.x)))) {
    if ((tmpvar_206.z < 0.0)) {
      if ((tmpvar_206.x >= 0.0)) {
        tmpvar_208 += 3.141593;
      } else {
        tmpvar_208 = (tmpvar_208 - 3.141593);
      };
    };
  } else {
    tmpvar_208 = (sign(tmpvar_206.x) * 1.570796);
  };
  uv_207.x = (0.5 + (0.1591549 * tmpvar_208));
  uv_207.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_206.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_206.y)
    )) * (1.570796 + (
      abs(tmpvar_206.y)
     * 
      (-0.2146018 + (abs(tmpvar_206.y) * (0.08656672 + (
        abs(tmpvar_206.y)
       * -0.03102955))))
    ))))
  )));
  vec4 uv4_211;
  uv4_211.zw = vec2(0.0, 0.0);
  vec3 tmpvar_212;
  tmpvar_212 = normalize(tmpvar_205);
  vec3 tmpvar_213;
  tmpvar_213 = abs(tmpvar_212);
  float tmpvar_214;
  tmpvar_214 = float((tmpvar_213.z >= tmpvar_213.x));
  float tmpvar_215;
  tmpvar_215 = float((max (tmpvar_213.x, tmpvar_213.z) >= tmpvar_213.y));
  float tmpvar_216;
  tmpvar_216 = sign(mix (tmpvar_212.y, mix (tmpvar_212.x, tmpvar_212.z, tmpvar_214), tmpvar_215));
  vec3 tmpvar_217;
  tmpvar_217.xz = vec2(1.0, -1.0);
  tmpvar_217.y = -(tmpvar_216);
  vec3 tmpvar_218;
  tmpvar_218.xz = vec2(1.0, -1.0);
  tmpvar_218.y = tmpvar_216;
  vec3 tmpvar_219;
  tmpvar_219.xy = vec2(1.0, 1.0);
  tmpvar_219.z = tmpvar_216;
  vec3 tmpvar_220;
  tmpvar_220 = mix ((tmpvar_219 * tmpvar_212.yxz), mix ((tmpvar_217 * tmpvar_212.xzy), (tmpvar_218 * tmpvar_212.zxy), vec3(tmpvar_214)), vec3(tmpvar_215));
  uv4_211.xy = (((0.5 * tmpvar_220.yz) / abs(tmpvar_220.x)) + 0.5);
  tmpvar_8 = (texture2DLod (_MainTex, uv_207, 0.0) * texture2DLod (_DetailTex, uv4_211.xy, 0.0));
  vec4 tmpvar_221;
  tmpvar_221.w = 0.0;
  tmpvar_221.xyz = _WorldSpaceCameraPos;
  float tmpvar_222;
  vec4 tmpvar_223;
  tmpvar_223 = (origin_7 - tmpvar_221);
  tmpvar_222 = sqrt(dot (tmpvar_223, tmpvar_223));
  tmpvar_9.w = (clamp ((_DistFade * tmpvar_222), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_222)
  ), 0.0, 1.0));
  tmpvar_8.w = (tmpvar_8.w * tmpvar_9.w);
  vec3 tmpvar_224;
  tmpvar_224.yz = vec2(0.0, 0.0);
  tmpvar_224.x = fract(_Rotation);
  vec3 x_225;
  x_225 = (tmpvar_224 + tmpvar_203);
  vec3 trans_226;
  trans_226 = localOrigin_5.xyz;
  float tmpvar_227;
  tmpvar_227 = (x_225.x * 6.283185);
  float tmpvar_228;
  tmpvar_228 = (x_225.y * 6.283185);
  float tmpvar_229;
  tmpvar_229 = (x_225.z * 2.0);
  float tmpvar_230;
  tmpvar_230 = sqrt(tmpvar_229);
  float tmpvar_231;
  tmpvar_231 = (sin(tmpvar_228) * tmpvar_230);
  float tmpvar_232;
  tmpvar_232 = (cos(tmpvar_228) * tmpvar_230);
  float tmpvar_233;
  tmpvar_233 = sqrt((2.0 - tmpvar_229));
  float tmpvar_234;
  tmpvar_234 = sin(tmpvar_227);
  float tmpvar_235;
  tmpvar_235 = cos(tmpvar_227);
  float tmpvar_236;
  tmpvar_236 = ((tmpvar_231 * tmpvar_235) - (tmpvar_232 * tmpvar_234));
  float tmpvar_237;
  tmpvar_237 = ((tmpvar_231 * tmpvar_234) + (tmpvar_232 * tmpvar_235));
  mat4 tmpvar_238;
  tmpvar_238[0].x = (tmpvar_204 * ((tmpvar_231 * tmpvar_236) - tmpvar_235));
  tmpvar_238[0].y = ((tmpvar_231 * tmpvar_237) - tmpvar_234);
  tmpvar_238[0].z = (tmpvar_231 * tmpvar_233);
  tmpvar_238[0].w = 0.0;
  tmpvar_238[1].x = ((tmpvar_232 * tmpvar_236) + tmpvar_234);
  tmpvar_238[1].y = (tmpvar_204 * ((tmpvar_232 * tmpvar_237) - tmpvar_235));
  tmpvar_238[1].z = (tmpvar_232 * tmpvar_233);
  tmpvar_238[1].w = 0.0;
  tmpvar_238[2].x = (tmpvar_233 * tmpvar_236);
  tmpvar_238[2].y = (tmpvar_233 * tmpvar_237);
  tmpvar_238[2].z = (tmpvar_204 * (1.0 - tmpvar_229));
  tmpvar_238[2].w = 0.0;
  tmpvar_238[3].x = trans_226.x;
  tmpvar_238[3].y = trans_226.y;
  tmpvar_238[3].z = trans_226.z;
  tmpvar_238[3].w = 1.0;
  mat4 tmpvar_239;
  tmpvar_239 = ((unity_MatrixV * _Object2World) * tmpvar_238);
  vec4 v_240;
  v_240.x = tmpvar_239[0].z;
  v_240.y = tmpvar_239[1].z;
  v_240.z = tmpvar_239[2].z;
  v_240.w = tmpvar_239[3].z;
  vec3 tmpvar_241;
  tmpvar_241 = normalize(v_240.xyz);
  tmpvar_9.xyz = abs(tmpvar_241);
  vec4 tmpvar_242;
  tmpvar_242 = (gl_ModelViewMatrix * localOrigin_5);
  vec4 tmpvar_243;
  tmpvar_243.xyz = (gl_Vertex.xyz * tmpvar_204);
  tmpvar_243.w = gl_Vertex.w;
  vec2 tmpvar_244;
  tmpvar_244 = ((2.0 * gl_MultiTexCoord0.xy) - 1.0);
  vec4 tmpvar_245;
  tmpvar_245.z = 0.0;
  tmpvar_245.xy = tmpvar_244;
  tmpvar_245.w = gl_Vertex.w;
  ZYv_4.xyw = tmpvar_245.zyw;
  XZv_3.yzw = tmpvar_245.zyw;
  XYv_2.yzw = tmpvar_245.yzw;
  ZYv_4.z = (tmpvar_244.x * sign(-(tmpvar_241.x)));
  XZv_3.x = (tmpvar_244.x * sign(-(tmpvar_241.y)));
  XYv_2.x = (tmpvar_244.x * sign(tmpvar_241.z));
  ZYv_4.x = ((sign(
    -(tmpvar_241.x)
  ) * sign(ZYv_4.z)) * tmpvar_241.z);
  XZv_3.y = ((sign(
    -(tmpvar_241.y)
  ) * sign(XZv_3.x)) * tmpvar_241.x);
  XYv_2.z = ((sign(
    -(tmpvar_241.z)
  ) * sign(XYv_2.x)) * tmpvar_241.x);
  ZYv_4.x = (ZYv_4.x + ((
    sign(-(tmpvar_241.x))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  XZv_3.y = (XZv_3.y + ((
    sign(-(tmpvar_241.y))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.z));
  XYv_2.z = (XYv_2.z + ((
    sign(-(tmpvar_241.z))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  vec3 tmpvar_246;
  tmpvar_246 = normalize((origin_7.xyz - _WorldSpaceCameraPos));
  vec3 tmpvar_247;
  tmpvar_247 = normalize(-(tmpvar_246));
  vec4 v_248;
  v_248.x = unity_MatrixV[0].x;
  v_248.y = unity_MatrixV[1].x;
  v_248.z = unity_MatrixV[2].x;
  v_248.w = unity_MatrixV[3].x;
  vec3 tmpvar_249;
  tmpvar_249 = normalize(v_248.xyz);
  vec3 tmpvar_250;
  vec3 tmpvar_251;
  tmpvar_250 = v_248.xyz;
  tmpvar_251 = ((tmpvar_247.zxy * tmpvar_249.yzx) - (tmpvar_247.yzx * tmpvar_249.zxy));
  mat3 tmpvar_252;
  tmpvar_252[0].x = tmpvar_250.x;
  tmpvar_252[0].y = tmpvar_251.x;
  tmpvar_252[0].z = tmpvar_247.x;
  tmpvar_252[1].x = tmpvar_250.y;
  tmpvar_252[1].y = tmpvar_251.y;
  tmpvar_252[1].z = tmpvar_247.y;
  tmpvar_252[2].x = tmpvar_250.z;
  tmpvar_252[2].y = tmpvar_251.z;
  tmpvar_252[2].z = tmpvar_247.z;
  gl_Position = (gl_ProjectionMatrix * (tmpvar_242 + tmpvar_243));
  xlv_COLOR = tmpvar_8;
  xlv_TEXCOORD0 = tmpvar_9;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * ZYv_4)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XZv_3)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XYv_2)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD4 = tmpvar_1;
  xlv_TEXCOORD5 = tmpvar_10;
  xlv_TEXCOORD6 = tmpvar_11;
  xlv_TEXCOORD7 = normalize((tmpvar_252 * tmpvar_246));
  xlv_TEXCOORD8 = normalize((tmpvar_252 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform vec4 _LightColor0;
uniform sampler2D _Tex;
uniform vec4 _Color;
uniform float _MinScatter;
uniform float _Opacity;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec3 normT_1;
  vec4 color_2;
  vec4 tex_3;
  tex_3.x = texture2D (_Tex, xlv_TEXCOORD1).x;
  tex_3.y = texture2D (_Tex, xlv_TEXCOORD2).y;
  tex_3.z = texture2D (_Tex, xlv_TEXCOORD3).z;
  tex_3.w = 0.0;
  tex_3.xyz = (tex_3.xyz * xlv_TEXCOORD0.xyz);
  tex_3 = (tex_3 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  float tmpvar_4;
  tmpvar_4 = ((tex_3.x + tex_3.y) + (tex_3.z + tex_3.w));
  vec4 tmpvar_5;
  tmpvar_5.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_5.w = tmpvar_4;
  tex_3.xyz = tmpvar_5.xyz;
  color_2 = (_Color * xlv_COLOR);
  normT_1.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_1.z = sqrt((1.0 - clamp (
    dot (normT_1.xy, normT_1.xy)
  , 0.0, 1.0)));
  color_2.w = (color_2.w * tmpvar_4);
  tex_3.w = (xlv_TEXCOORD0.w * tmpvar_4);
  vec4 c_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD8);
  vec3 tmpvar_8;
  tmpvar_8 = normalize(xlv_TEXCOORD7);
  vec3 tmpvar_9;
  tmpvar_9 = normalize(normT_1);
  float tmpvar_10;
  tmpvar_10 = max (dot (tmpvar_9, tmpvar_7), 0.0);
  c_6.xyz = ((_LightColor0.xyz * (vec3(tmpvar_10) + 
    clamp ((((_MinScatter - 
      (_Opacity * tex_3.w)
    ) * (1.0 - 
      dot (tmpvar_9, tmpvar_8)
    )) * (0.5 + (0.5 * 
      dot (tmpvar_8, tmpvar_7)
    ))), 0.0, 1.0)
  )) * 2.0);
  c_6.w = (tmpvar_10 * 2.0);
  color_2.xyz = (color_2.xyz * c_6.xyz);
  gl_FragData[0] = color_2;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 666 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "texcoord" TexCoord0
Matrix 19 [_DetailRotation] 3
Matrix 12 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 22 [_PosRotation] 3
Matrix 0 [glstate_matrix_modelview0]
Matrix 8 [glstate_matrix_projection]
Matrix 16 [unity_MatrixV] 3
Float 27 [_DistFade]
Float 28 [_DistFadeVert]
Float 30 [_MaxScale]
Vector 32 [_MaxTrans]
Vector 31 [_NoiseScale]
Float 29 [_Rotation]
Vector 25 [_WorldSpaceCameraPos]
Vector 26 [_WorldSpaceLightPos0]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
"vs_3_0
def c33, 0.333333343, 0.166666672, 1, -0.5
def c34, 34, 5.89795971, 49, 0.142857149
def c35, 0.00346020772, 289, 0, 1
def c36, 7, 0.285714298, -0.928571403, 0.600000024
def c37, 2, 1, 0.853734732, 1.79284286
def c38, -2, 3.14159274, 1, -1
def c39, 42, 0.0208350997, -0.0851330012, 0.180141002
def c40, -0.330299497, 0.999866009, -2, 1.57079637
def c41, -0.0187292993, 0.0742610022, 1.57072878, 0.318309873
def c42, -3.14159274, 0.159154937, 0.5, -0.212114394
def c43, 6.28318548, -3.14159274, 0.600000024, 0.5
dcl_position v0
dcl_texcoord v1
dcl_2d s0
dcl_2d s1
dcl_position o0
dcl_color o1
dcl_texcoord o2
dcl_texcoord1 o3.xy
dcl_texcoord2 o4.xy
dcl_texcoord3 o5.xy
dcl_texcoord4 o6.xy
dcl_texcoord5 o7
dcl_texcoord6 o8.xyz
dcl_texcoord7 o9.xyz
dcl_texcoord8 o10.xyz
mov r0.x, c4.w
mov r0.y, c5.w
mov r0.z, c6.w
mov r0.w, c7.w
dp4 r1.x, c22, r0
dp4 r1.y, c23, r0
dp4 r1.z, c24, r0
mul r0.xyz, r1, c31.z
dp3 r0.w, r0, c33.x
mad r2.xyz, c31.z, r1, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mad r1.xyz, c31.z, r1, -r2
dp3 r0.w, r2, c33.y
add r1.xyz, r0.w, r1
sge r2.xyz, r1, r1.yzxw
add r3.xyz, -r2.zxyw, c33.z
min r4.xyz, r2, r3
max r2.xyz, r2, r3
mad r3.xyw, r4.z, c35.zwzz, c35.zzzw
mov r3.z, r2.z
mad r3, r5.z, c35.y, r3
mul r5.xy, r5, c35.y
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.y
mad r6.xyw, r4.zyzz, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r3, r3, r6
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.x
mad r5.xyw, r4.zxzz, c35.zwzz, c35.zzzw
add r4.xyz, r1, -r4
add r4.xyz, r4, c33.y
mov r5.z, r2.x
add r2.xyz, r1, -r2
add r2.xyz, r2, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r6, r3, r5, -r5
mul r3, r6, c34.y
mul r5, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r5
frc r5, r5
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r5.xz, r6.yyww
add r7, r5, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r5, r7.zwxy, -r9.yyxx, r5.zwxy
mov r7.xy, r5.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r5.z, r8.y
dp3 r10.y, r5, r5
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r5.xyz, r5, r6.y
dp3 r5.y, r5, r4
dp3 r4.y, r4, r4
mul r3.xyz, r3, r6.z
dp3 r5.z, r3, r2
dp3 r4.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r5.x, r2, r1
add r2.xyz, r1, c33.w
dp3 r4.x, r1, r1
dp3 r5.w, r3, r2
dp3 r4.w, r2, r2
add r1, -r4, c36.w
max r1, r1, c35.z
mul r1, r1, r1
mul r1, r1, r1
dp4 r0.w, r1, r5
mul r1.x, r0.w, c39.x
mul r2.xyz, r0, c31.x
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.x, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r4.xyz, c31.x, r0, -r2
dp3 r0.w, r2, c33.y
add r2.xyz, r0.w, r4
sge r4.xyz, r2, r2.yzxw
add r5.xyw, -r4.zxzy, c33.z
min r6.xyz, r4, r5.xyww
max r4.xyz, r4, r5.xyww
mad r7.xyw, r6.z, c35.zwzz, c35.zzzw
mov r7.z, r4.z
mad r5, r5.z, c35.y, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r5, r8, c35.y, r3.y
mad r7.xyw, r6.zyzz, c35.zwzz, c35.zzzw
mov r7.z, r4.y
add r5, r5, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r3, r8, c35.y, r3.x
mad r5.xyw, r6.zxzz, c35.zwzz, c35.zzzw
add r6.xyz, r2, -r6
add r6.xyz, r6, c33.y
mov r5.z, r4.x
add r4.xyz, r2, -r4
add r4.xyz, r4, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r7, r3, r5, -r5
mul r3, r7, c34.y
mul r5, r7, c35.y
frc r7, r3
add r3, r3, -r7
mad r3, r3, -c34.z, r5
frc r5, r5
mul r7, r3, c34.w
frc r8, r7
add r7, r7, -r8
mad r3, r7, -c36.x, r3
mad r7, r7.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r8.yw, r3.xxzy
frc r8.xz, r7.yyww
mov r5.xz, r7.yyww
add r8, r5, -r8
mad r8, r8, c37.x, c37.y
add r9, -r7_abs.ywxz, c33.z
add r9, -r3_abs.xywz, r9.xywz
sge r10, c35.z, r9.xywz
mad r5, r8.zwxy, -r10.yyxx, r5.zwxy
mov r8.xy, r5.zwzw
mov r8.z, r9.x
dp3 r11.x, r8, r8
mov r5.z, r9.y
dp3 r11.y, r5, r5
frc r12.yw, r3.xzzw
mov r7.yw, r3.xzzw
frc r12.xz, r7
add r3, -r12, r7
mad r3, r3, c37.x, c37.y
mad r3, r3, -r10.zzww, r7
mov r9.xy, r3.zwzw
mov r3.z, r9.w
dp3 r11.z, r3, r3
dp3 r11.w, r9, r9
mad r7, r11, -c37.z, c37.w
mul r5.xyz, r5, r7.y
dp3 r5.y, r5, r6
dp3 r6.y, r6, r6
mul r3.xyz, r3, r7.z
dp3 r5.z, r3, r4
dp3 r6.z, r4, r4
mul r3.xyz, r7.x, r8
mul r4.xyz, r7.w, r9
dp3 r5.x, r3, r2
add r3.xyz, r2, c33.w
dp3 r6.x, r2, r2
dp3 r5.w, r4, r3
dp3 r6.w, r3, r3
add r2, -r6, c36.w
max r2, r2, c35.z
mul r2, r2, r2
mul r2, r2, r2
dp4 r0.w, r2, r5
mul r1.y, r0.w, c39.x
mul r2.xyz, r0, c31.y
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.y, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r0.xyz, c31.y, r0, -r2
dp3 r0.w, r2, c33.y
add r0.xyz, r0.w, r0
sge r2.xyz, r0, r0.yzxw
add r4.xyz, -r2.zxyw, c33.z
min r5.xyw, r2.xyzz, r4.xyzz
max r2.xyz, r2, r4
mad r4.xyw, r5.w, c35.zwzz, c35.zzzw
mov r4.z, r2.z
mad r4, r5.z, c35.y, r4
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r4, r7, c35.y, r3.y
mad r6.xyw, r5.wyzw, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r4, r4, r6
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r3, r7, c35.y, r3.x
mad r4.xyw, r5.wxzw, c35.zwzz, c35.zzzw
add r5.xyz, r0, -r5.xyww
add r5.xyz, r5, c33.y
mov r4.z, r2.x
add r2.xyz, r0, -r2
add r2.xyz, r2, c33.x
add r3, r3, r4
mul r4, r3, r3
mad r3, r4, c34.x, r3
mul r3, r3, c35.x
frc r4, r3_abs
sge r3, r3, -r3
lrp r6, r3, r4, -r4
mul r3, r6, c34.y
mul r4, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r4
frc r4, r4
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r4, r3
mad r3, r3, c36.y, c36.z
mov r4.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r4.xz, r6.yyww
add r7, r4, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r4, r7.zwxy, -r9.yyxx, r4.zwxy
mov r7.xy, r4.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r4.z, r8.y
dp3 r10.y, r4, r4
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r4.xyz, r4, r6.y
dp3 r4.y, r4, r5
dp3 r5.y, r5, r5
mul r3.xyz, r3, r6.z
dp3 r4.z, r3, r2
dp3 r5.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r4.x, r2, r0
add r2.xyz, r0, c33.w
dp3 r5.x, r0, r0
dp3 r4.w, r3, r2
dp3 r5.w, r2, r2
add r0, -r5, c36.w
max r0, r0, c35.z
mul r0, r0, r0
mul r0, r0, r0
dp4 r0.x, r0, r4
mul r1.z, r0.x, c39.x
mul r0.xyz, r1, c32
add r1.xyz, r1, c33.z
mov r0.w, c33.z
dp4 r2.w, c7, r0
dp4 r2.x, c4, r0
dp4 r2.y, c5, r0
dp4 r2.z, c6, r0
dp4 r3.w, c15, r2
dp4 r3.x, c12, r2
dp4 r3.y, c13, r2
dp4 r3.z, c14, r2
add r2.xyz, r2, -c25
dp4 r4.y, c19, r3
dp4 r4.x, c20, r3
dp4 r4.z, c21, r3
dp3 r1.w, r4, r4
rsq r1.w, r1.w
mul r5.xyz, r1.w, r4
mad r2.w, r4.z, r1.w, -r5.y
sge r3.w, r5_abs.z, r5_abs.y
mad r2.w, r3.w, r2.w, r5.y
mad r1.w, r4.x, -r1.w, r2.w
max r2.w, r5_abs.z, r5_abs.y
sge r2.w, r2.w, r5_abs.x
mad r1.w, r2.w, r1.w, r5.x
slt r4.x, -r1.w, r1.w
slt r1.w, r1.w, -r1.w
add r4.y, -r1.w, r4.x
mov r6.y, -r4.y
mov r6.xz, c38.zyww
mul r6.xyz, r5.yzxw, r6
mov r4.xz, c38.zyww
mad r7.xyz, r4, r5.zyxw, -r6
mad r6.xyz, r3.w, r7, r6
mad r6.xyz, r4.xxyw, -r5, r6
mul r4.xyz, r5, r4.xxyw
mad r4.xyz, r2.w, r6, r4
mul r4.yz, r4, -c33.w
rcp r1.w, r4_abs.x
mad r4.xy, r4.yzzw, r1.w, -c33.w
mov r4.zw, c35.z
texldl r4, r4, s1
dp3 r1.w, r3, r3
rsq r1.w, r1.w
mul r5.xyz, r1.w, r3.xzyw
mov o8.xyz, r3
max r1.w, r5_abs.y, r5_abs.x
rcp r1.w, r1.w
min r2.w, r5_abs.y, r5_abs.x
mul r1.w, r1.w, r2.w
mul r2.w, r1.w, r1.w
mad r3.x, r2.w, c39.y, c39.z
mad r3.x, r2.w, r3.x, c39.w
mad r3.x, r2.w, r3.x, c40.x
mad r2.w, r2.w, r3.x, c40.y
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c40.z, c40.w
slt r3.x, r5_abs.y, r5_abs.x
mad r1.w, r2.w, r3.x, r1.w
slt r3.xy, r5.yzzw, -r5.yzzw
mad r1.w, r3.x, c42.x, r1.w
add r2.w, r1.w, r1.w
min r3.x, r5.y, r5.x
slt r3.x, r3.x, -r3.x
max r3.z, r5.y, r5.x
sge r3.z, r3.z, -r3.z
mul r3.x, r3.z, r3.x
mad r1.w, r3.x, -r2.w, r1.w
mad r6.x, r1.w, c42.y, c42.z
mad r1.w, r5_abs.z, c41.x, c41.y
mad r1.w, r1.w, r5_abs.z, c42.w
mad r1.w, r1.w, r5_abs.z, c41.z
add r2.w, -r5_abs.z, c33.z
rsq r2.w, r2.w
rcp r2.w, r2.w
mul r1.w, r1.w, r2.w
mad r2.w, r1.w, c38.x, c38.y
mad r1.w, r2.w, r3.y, r1.w
mul r6.y, r1.w, c41.w
mov r6.zw, c35.z
texldl r3, r6, s0
mul r3, r4, r3
dp3 r1.w, r2, r2
rsq r1.w, r1.w
rcp r2.w, r1.w
mul r2.xyz, r1.w, r2
mul_sat r1.w, r2.w, c27.x
mov r4.z, c33.z
mad_sat r2.w, c28.x, -r2.w, r4.z
mul r1.w, r1.w, r2.w
mul o1.w, r1.w, r3.w
mov o1.xyz, r3
mov o2.w, r1.w
frc r3.x, c29.x
mov r3.y, c35.z
mad r1.zw, r1.xyxz, -c33.w, r3.xyxy
mad r3.xy, r1.w, -c37.x, c37
mul r1.x, r1.x, -c33.w
mad r1.y, r1.y, -c33.w, -c33.w
frc r1.y, r1.y
mad r1.y, r1.y, c43.x, c43.y
sincos r5.xy, r1.y
add r1.y, -r4.z, c30.x
mad r1.x, r1.x, r1.y, c33.z
mul r4.z, r3.y, r1.x
rsq r1.y, r3.x
rcp r1.y, r1.y
add r1.w, r1.w, r1.w
add r1.z, r1.z, -c33.w
frc r1.z, r1.z
mad r1.z, r1.z, c43.x, c43.y
sincos r3.xy, r1.z
rsq r1.z, r1.w
rcp r1.z, r1.z
mul r1.zw, r1.z, r5.xyyx
mul r5.xyz, r3.yyxw, r1.wzww
mad r2.w, r1.z, r3.x, -r5.x
add r3.z, r5.z, r5.y
mul r4.x, r1.y, r2.w
mul r4.y, r1.y, r3.z
mad r5.yz, r1.xzww, r3.z, -r3.xyxw
mul r6.zw, r1.y, r1
mov r7, c5
mul r8.xyz, r7, c18.y
mov r9, c4
mad r8.xyz, c18.x, r9, r8
mov r10, c6
mad r8.xyz, c18.z, r10, r8
mov r11, c7
mad r8.xyz, c18.w, r11, r8
dp3 r12.z, r8, r4
mad r1.y, r1.z, r2.w, -r3.x
mad r6.x, r1.w, r2.w, r3.y
mul r5.x, r1.y, r1.x
mov r5.w, r6.z
dp3 r12.x, r8, r5.xyww
mul r6.y, r1.x, r5.z
mul r1.xyz, r1.x, v0
dp3 r12.y, r8, r6.xyww
nrm r3.xyz, r12
abs o2.xyz, r3
dp4 r8.z, c2, r0
dp4 r8.w, c3, r0
dp4 r8.x, c0, r0
dp4 r8.y, c1, r0
mov r1.w, v0.w
add r1, r1, r8
dp4 o0.x, c8, r1
dp4 o0.y, c9, r1
dp4 o0.z, c10, r1
dp4 o0.w, c11, r1
mul r1, r7, c16.y
mad r1, c16.x, r9, r1
mad r1, c16.z, r10, r1
mad r1, c16.w, r11, r1
dp3 r12.z, r1, r4
dp4 r12.w, r1, r0
dp3 r12.x, r1, r5.xyww
dp3 r12.y, r1, r6.xyww
slt r1.xyz, r3, -r3
slt r13.xyz, -r3, r3
add r1.xyw, r1.xyzz, -r13.xyzz
add r1.z, -r1.z, r13.z
mad r8.zw, v1.xyxy, -c38.x, -c38.z
slt r2.w, -r8.w, r8.w
slt r3.w, r8.w, -r8.w
add r2.w, r2.w, -r3.w
mul r13.xyz, r1.xyww, r2.w
mul r13.xyz, r3.yzyw, r13
mul r3.yw, r1.xxzy, r8.z
mul r14.x, r1.z, r8.z
slt r8.zw, -r3.xyyw, r3.xyyw
slt r15.xy, r3.ywzw, -r3.ywzw
add r8.zw, r8, -r15.xyxy
mul r1.xy, r1, r8.zwzw
mad r15.xy, r1, r3.zxzw, r13
mov r16.x, r15.x
mov r16.z, r3.y
mov r15.x, r3.w
mad r16.y, v1.y, -c38.x, -c38.z
mov r16.w, v0.w
dp4 r1.x, r12, r16
mul r7, r7, c17.y
mad r7, c17.x, r9, r7
mad r7, c17.z, r10, r7
mad r7, c17.w, r11, r7
dp3 r4.z, r7, r4
dp3 r4.x, r7, r5.xyww
dp3 r4.y, r7, r6.xyww
dp4 r4.w, r7, r0
dp4 r1.y, r4, r16
mov r15.zw, r16.xyyw
add r0.xy, -r8, r1
mad o3.xy, r0, c43.z, c43.w
dp4 r0.x, r12, r15
dp4 r0.y, r4, r15
mov r14.yw, r15.xzzw
add r0.xy, -r8, r0
mad o4.xy, r0, c43.z, c43.w
slt r0.x, -r14.x, r14.x
slt r0.y, r14.x, -r14.x
add r0.x, -r0.y, r0.x
mul r0.x, r0.x, r1.w
mad r14.z, r0.x, r3.x, r13.z
dp4 r0.x, r12, r14
dp4 r0.y, r4, r14
add r0.xy, -r8, r0
mad o5.xy, r0, c43.z, c43.w
nrm r0.xyz, -r2
dp3 r0.w, c16, c16
rsq r0.w, r0.w
mul r1.xyz, r0.w, c16.yzxw
mul r3.xyz, r0.zxyw, r1
mad r1.xyz, r0.yzxw, r1.yzxw, -r3
dp3 r3.y, -r1, c26
dp3 r1.y, -r1, r2
dp3 r3.z, r0, c26
dp3 r1.z, r0, r2
dp3 r1.x, c16, r2
mov r0.xyz, c16
dp3 r3.x, r0, c26
dp3 r0.x, r3, r3
rsq r0.x, r0.x
mul o10.xyz, r0.x, r3
dp3 r0.x, r1, r1
rsq r0.x, r0.x
mul o9.xyz, r0.x, r1
mov o6.xy, v1
mov o7, c35.z

"
}
SubProgram "d3d11 " {
// Stats: 469 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "texcoord" TexCoord0
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 592
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 368 [_PosRotation]
Float 464 [_DistFade]
Float 468 [_DistFadeVert]
Float 484 [_Rotation]
Float 488 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityLighting" 720
Vector 0 [_WorldSpaceLightPos0]
ConstBuffer "UnityPerDraw" 352
Matrix 64 [glstate_matrix_modelview0]
Matrix 192 [_Object2World]
ConstBuffer "UnityPerFrame" 256
Matrix 0 [glstate_matrix_projection]
Matrix 80 [unity_MatrixV]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityLighting" 2
BindCB  "UnityPerDraw" 3
BindCB  "UnityPerFrame" 4
"vs_4_0
root12:acafacaa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"
}
SubProgram "gles " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 glstate_matrix_projection;
uniform highp mat4 unity_MatrixV;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform highp mat4 _PosRotation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _Rotation;
uniform highp float _MaxScale;
uniform highp vec4 _NoiseScale;
uniform highp vec3 _MaxTrans;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  mediump vec3 normal_3;
  highp vec4 XYv_4;
  highp vec4 XZv_5;
  highp vec4 ZYv_6;
  highp vec4 localOrigin_7;
  highp vec4 planet_pos_8;
  highp vec4 origin_9;
  lowp vec4 tmpvar_10;
  mediump vec4 tmpvar_11;
  highp vec4 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_9 = tmpvar_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (_PosRotation * tmpvar_14);
  planet_pos_8 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (_NoiseScale.z * tmpvar_15.xyz);
  highp float tmpvar_17;
  highp vec4 m_18;
  highp vec3 tmpvar_19;
  tmpvar_19 = floor((tmpvar_16 + dot (tmpvar_16, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_20;
  tmpvar_20 = ((tmpvar_16 - tmpvar_19) + dot (tmpvar_19, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_21;
  tmpvar_21.x = float((tmpvar_20.x >= tmpvar_20.y));
  tmpvar_21.y = float((tmpvar_20.y >= tmpvar_20.z));
  tmpvar_21.z = float((tmpvar_20.z >= tmpvar_20.x));
  highp vec3 tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_21);
  highp vec3 tmpvar_23;
  tmpvar_23 = min (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_24;
  tmpvar_24 = max (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_25;
  tmpvar_25 = ((tmpvar_20 - tmpvar_23) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_26;
  tmpvar_26 = ((tmpvar_20 - tmpvar_24) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_27;
  tmpvar_27 = (tmpvar_20 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28 = (tmpvar_19 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (fract(abs(tmpvar_28)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_30;
  if ((tmpvar_28.x >= 0.0)) {
    tmpvar_30 = tmpvar_29.x;
  } else {
    tmpvar_30 = -(tmpvar_29.x);
  };
  highp float tmpvar_31;
  if ((tmpvar_28.y >= 0.0)) {
    tmpvar_31 = tmpvar_29.y;
  } else {
    tmpvar_31 = -(tmpvar_29.y);
  };
  highp float tmpvar_32;
  if ((tmpvar_28.z >= 0.0)) {
    tmpvar_32 = tmpvar_29.z;
  } else {
    tmpvar_32 = -(tmpvar_29.z);
  };
  highp vec4 tmpvar_33;
  tmpvar_33.xw = vec2(0.0, 1.0);
  tmpvar_33.y = tmpvar_23.z;
  tmpvar_33.z = tmpvar_24.z;
  highp vec4 x_34;
  x_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35 = (((
    (x_34 * x_34)
   * 34.0) + x_34) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_36;
  tmpvar_36 = (fract(abs(tmpvar_35)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_37;
  if ((tmpvar_35.x >= 0.0)) {
    tmpvar_37 = tmpvar_36.x;
  } else {
    tmpvar_37 = -(tmpvar_36.x);
  };
  highp float tmpvar_38;
  if ((tmpvar_35.y >= 0.0)) {
    tmpvar_38 = tmpvar_36.y;
  } else {
    tmpvar_38 = -(tmpvar_36.y);
  };
  highp float tmpvar_39;
  if ((tmpvar_35.z >= 0.0)) {
    tmpvar_39 = tmpvar_36.z;
  } else {
    tmpvar_39 = -(tmpvar_36.z);
  };
  highp float tmpvar_40;
  if ((tmpvar_35.w >= 0.0)) {
    tmpvar_40 = tmpvar_36.w;
  } else {
    tmpvar_40 = -(tmpvar_36.w);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.x = tmpvar_37;
  tmpvar_41.y = tmpvar_38;
  tmpvar_41.z = tmpvar_39;
  tmpvar_41.w = tmpvar_40;
  highp vec4 tmpvar_42;
  tmpvar_42.xw = vec2(0.0, 1.0);
  tmpvar_42.y = tmpvar_23.y;
  tmpvar_42.z = tmpvar_24.y;
  highp vec4 x_43;
  x_43 = ((tmpvar_41 + tmpvar_31) + tmpvar_42);
  highp vec4 tmpvar_44;
  tmpvar_44 = (((
    (x_43 * x_43)
   * 34.0) + x_43) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_45;
  tmpvar_45 = (fract(abs(tmpvar_44)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_46;
  if ((tmpvar_44.x >= 0.0)) {
    tmpvar_46 = tmpvar_45.x;
  } else {
    tmpvar_46 = -(tmpvar_45.x);
  };
  highp float tmpvar_47;
  if ((tmpvar_44.y >= 0.0)) {
    tmpvar_47 = tmpvar_45.y;
  } else {
    tmpvar_47 = -(tmpvar_45.y);
  };
  highp float tmpvar_48;
  if ((tmpvar_44.z >= 0.0)) {
    tmpvar_48 = tmpvar_45.z;
  } else {
    tmpvar_48 = -(tmpvar_45.z);
  };
  highp float tmpvar_49;
  if ((tmpvar_44.w >= 0.0)) {
    tmpvar_49 = tmpvar_45.w;
  } else {
    tmpvar_49 = -(tmpvar_45.w);
  };
  highp vec4 tmpvar_50;
  tmpvar_50.x = tmpvar_46;
  tmpvar_50.y = tmpvar_47;
  tmpvar_50.z = tmpvar_48;
  tmpvar_50.w = tmpvar_49;
  highp vec4 tmpvar_51;
  tmpvar_51.xw = vec2(0.0, 1.0);
  tmpvar_51.y = tmpvar_23.x;
  tmpvar_51.z = tmpvar_24.x;
  highp vec4 x_52;
  x_52 = ((tmpvar_50 + tmpvar_30) + tmpvar_51);
  highp vec4 tmpvar_53;
  tmpvar_53 = (((
    (x_52 * x_52)
   * 34.0) + x_52) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_54;
  tmpvar_54 = (fract(abs(tmpvar_53)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_55;
  if ((tmpvar_53.x >= 0.0)) {
    tmpvar_55 = tmpvar_54.x;
  } else {
    tmpvar_55 = -(tmpvar_54.x);
  };
  highp float tmpvar_56;
  if ((tmpvar_53.y >= 0.0)) {
    tmpvar_56 = tmpvar_54.y;
  } else {
    tmpvar_56 = -(tmpvar_54.y);
  };
  highp float tmpvar_57;
  if ((tmpvar_53.z >= 0.0)) {
    tmpvar_57 = tmpvar_54.z;
  } else {
    tmpvar_57 = -(tmpvar_54.z);
  };
  highp float tmpvar_58;
  if ((tmpvar_53.w >= 0.0)) {
    tmpvar_58 = tmpvar_54.w;
  } else {
    tmpvar_58 = -(tmpvar_54.w);
  };
  highp vec4 tmpvar_59;
  tmpvar_59.x = tmpvar_55;
  tmpvar_59.y = tmpvar_56;
  tmpvar_59.z = tmpvar_57;
  tmpvar_59.w = tmpvar_58;
  highp vec4 tmpvar_60;
  tmpvar_60 = (tmpvar_59 - (49.0 * floor(
    (0.02040815 * tmpvar_59)
  )));
  highp vec4 tmpvar_61;
  tmpvar_61 = floor((tmpvar_60 * 0.1428571));
  highp vec4 tmpvar_62;
  tmpvar_62 = ((tmpvar_61 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_63;
  tmpvar_63 = ((floor(
    (tmpvar_60 - (7.0 * tmpvar_61))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_64;
  tmpvar_64 = ((1.0 - abs(tmpvar_62)) - abs(tmpvar_63));
  highp vec4 tmpvar_65;
  tmpvar_65.xy = tmpvar_62.xy;
  tmpvar_65.zw = tmpvar_63.xy;
  highp vec4 tmpvar_66;
  tmpvar_66.xy = tmpvar_62.zw;
  tmpvar_66.zw = tmpvar_63.zw;
  highp vec4 tmpvar_67;
  tmpvar_67 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_64)));
  highp vec4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_67.xxyy));
  highp vec4 tmpvar_69;
  tmpvar_69 = (tmpvar_66.xzyw + ((
    (floor(tmpvar_66) * 2.0)
   + 1.0).xzyw * tmpvar_67.zzww));
  highp vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_68.xy;
  tmpvar_70.z = tmpvar_64.x;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.zw;
  tmpvar_71.z = tmpvar_64.y;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = tmpvar_69.xy;
  tmpvar_72.z = tmpvar_64.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = tmpvar_69.zw;
  tmpvar_73.z = tmpvar_64.w;
  highp vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_70, tmpvar_70);
  tmpvar_74.y = dot (tmpvar_71, tmpvar_71);
  tmpvar_74.z = dot (tmpvar_72, tmpvar_72);
  tmpvar_74.w = dot (tmpvar_73, tmpvar_73);
  highp vec4 tmpvar_75;
  tmpvar_75 = (1.792843 - (0.8537347 * tmpvar_74));
  highp vec4 tmpvar_76;
  tmpvar_76.x = dot (tmpvar_20, tmpvar_20);
  tmpvar_76.y = dot (tmpvar_25, tmpvar_25);
  tmpvar_76.z = dot (tmpvar_26, tmpvar_26);
  tmpvar_76.w = dot (tmpvar_27, tmpvar_27);
  highp vec4 tmpvar_77;
  tmpvar_77 = max ((0.6 - tmpvar_76), vec4(0.0, 0.0, 0.0, 0.0));
  m_18 = (tmpvar_77 * tmpvar_77);
  highp vec4 tmpvar_78;
  tmpvar_78.x = dot ((tmpvar_70 * tmpvar_75.x), tmpvar_20);
  tmpvar_78.y = dot ((tmpvar_71 * tmpvar_75.y), tmpvar_25);
  tmpvar_78.z = dot ((tmpvar_72 * tmpvar_75.z), tmpvar_26);
  tmpvar_78.w = dot ((tmpvar_73 * tmpvar_75.w), tmpvar_27);
  tmpvar_17 = (42.0 * dot ((m_18 * m_18), tmpvar_78));
  highp float tmpvar_79;
  highp vec3 v_80;
  v_80 = (_NoiseScale.x * tmpvar_16);
  highp vec4 m_81;
  highp vec3 tmpvar_82;
  tmpvar_82 = floor((v_80 + dot (v_80, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_83;
  tmpvar_83 = ((v_80 - tmpvar_82) + dot (tmpvar_82, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_84;
  tmpvar_84.x = float((tmpvar_83.x >= tmpvar_83.y));
  tmpvar_84.y = float((tmpvar_83.y >= tmpvar_83.z));
  tmpvar_84.z = float((tmpvar_83.z >= tmpvar_83.x));
  highp vec3 tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_84);
  highp vec3 tmpvar_86;
  tmpvar_86 = min (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_87;
  tmpvar_87 = max (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_88;
  tmpvar_88 = ((tmpvar_83 - tmpvar_86) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_89;
  tmpvar_89 = ((tmpvar_83 - tmpvar_87) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_90;
  tmpvar_90 = (tmpvar_83 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_91;
  tmpvar_91 = (tmpvar_82 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = (fract(abs(tmpvar_91)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_93;
  if ((tmpvar_91.x >= 0.0)) {
    tmpvar_93 = tmpvar_92.x;
  } else {
    tmpvar_93 = -(tmpvar_92.x);
  };
  highp float tmpvar_94;
  if ((tmpvar_91.y >= 0.0)) {
    tmpvar_94 = tmpvar_92.y;
  } else {
    tmpvar_94 = -(tmpvar_92.y);
  };
  highp float tmpvar_95;
  if ((tmpvar_91.z >= 0.0)) {
    tmpvar_95 = tmpvar_92.z;
  } else {
    tmpvar_95 = -(tmpvar_92.z);
  };
  highp vec4 tmpvar_96;
  tmpvar_96.xw = vec2(0.0, 1.0);
  tmpvar_96.y = tmpvar_86.z;
  tmpvar_96.z = tmpvar_87.z;
  highp vec4 x_97;
  x_97 = (tmpvar_95 + tmpvar_96);
  highp vec4 tmpvar_98;
  tmpvar_98 = (((
    (x_97 * x_97)
   * 34.0) + x_97) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_99;
  tmpvar_99 = (fract(abs(tmpvar_98)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_100;
  if ((tmpvar_98.x >= 0.0)) {
    tmpvar_100 = tmpvar_99.x;
  } else {
    tmpvar_100 = -(tmpvar_99.x);
  };
  highp float tmpvar_101;
  if ((tmpvar_98.y >= 0.0)) {
    tmpvar_101 = tmpvar_99.y;
  } else {
    tmpvar_101 = -(tmpvar_99.y);
  };
  highp float tmpvar_102;
  if ((tmpvar_98.z >= 0.0)) {
    tmpvar_102 = tmpvar_99.z;
  } else {
    tmpvar_102 = -(tmpvar_99.z);
  };
  highp float tmpvar_103;
  if ((tmpvar_98.w >= 0.0)) {
    tmpvar_103 = tmpvar_99.w;
  } else {
    tmpvar_103 = -(tmpvar_99.w);
  };
  highp vec4 tmpvar_104;
  tmpvar_104.x = tmpvar_100;
  tmpvar_104.y = tmpvar_101;
  tmpvar_104.z = tmpvar_102;
  tmpvar_104.w = tmpvar_103;
  highp vec4 tmpvar_105;
  tmpvar_105.xw = vec2(0.0, 1.0);
  tmpvar_105.y = tmpvar_86.y;
  tmpvar_105.z = tmpvar_87.y;
  highp vec4 x_106;
  x_106 = ((tmpvar_104 + tmpvar_94) + tmpvar_105);
  highp vec4 tmpvar_107;
  tmpvar_107 = (((
    (x_106 * x_106)
   * 34.0) + x_106) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_108;
  tmpvar_108 = (fract(abs(tmpvar_107)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_109;
  if ((tmpvar_107.x >= 0.0)) {
    tmpvar_109 = tmpvar_108.x;
  } else {
    tmpvar_109 = -(tmpvar_108.x);
  };
  highp float tmpvar_110;
  if ((tmpvar_107.y >= 0.0)) {
    tmpvar_110 = tmpvar_108.y;
  } else {
    tmpvar_110 = -(tmpvar_108.y);
  };
  highp float tmpvar_111;
  if ((tmpvar_107.z >= 0.0)) {
    tmpvar_111 = tmpvar_108.z;
  } else {
    tmpvar_111 = -(tmpvar_108.z);
  };
  highp float tmpvar_112;
  if ((tmpvar_107.w >= 0.0)) {
    tmpvar_112 = tmpvar_108.w;
  } else {
    tmpvar_112 = -(tmpvar_108.w);
  };
  highp vec4 tmpvar_113;
  tmpvar_113.x = tmpvar_109;
  tmpvar_113.y = tmpvar_110;
  tmpvar_113.z = tmpvar_111;
  tmpvar_113.w = tmpvar_112;
  highp vec4 tmpvar_114;
  tmpvar_114.xw = vec2(0.0, 1.0);
  tmpvar_114.y = tmpvar_86.x;
  tmpvar_114.z = tmpvar_87.x;
  highp vec4 x_115;
  x_115 = ((tmpvar_113 + tmpvar_93) + tmpvar_114);
  highp vec4 tmpvar_116;
  tmpvar_116 = (((
    (x_115 * x_115)
   * 34.0) + x_115) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_117;
  tmpvar_117 = (fract(abs(tmpvar_116)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_118;
  if ((tmpvar_116.x >= 0.0)) {
    tmpvar_118 = tmpvar_117.x;
  } else {
    tmpvar_118 = -(tmpvar_117.x);
  };
  highp float tmpvar_119;
  if ((tmpvar_116.y >= 0.0)) {
    tmpvar_119 = tmpvar_117.y;
  } else {
    tmpvar_119 = -(tmpvar_117.y);
  };
  highp float tmpvar_120;
  if ((tmpvar_116.z >= 0.0)) {
    tmpvar_120 = tmpvar_117.z;
  } else {
    tmpvar_120 = -(tmpvar_117.z);
  };
  highp float tmpvar_121;
  if ((tmpvar_116.w >= 0.0)) {
    tmpvar_121 = tmpvar_117.w;
  } else {
    tmpvar_121 = -(tmpvar_117.w);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.x = tmpvar_118;
  tmpvar_122.y = tmpvar_119;
  tmpvar_122.z = tmpvar_120;
  tmpvar_122.w = tmpvar_121;
  highp vec4 tmpvar_123;
  tmpvar_123 = (tmpvar_122 - (49.0 * floor(
    (0.02040815 * tmpvar_122)
  )));
  highp vec4 tmpvar_124;
  tmpvar_124 = floor((tmpvar_123 * 0.1428571));
  highp vec4 tmpvar_125;
  tmpvar_125 = ((tmpvar_124 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_126;
  tmpvar_126 = ((floor(
    (tmpvar_123 - (7.0 * tmpvar_124))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_127;
  tmpvar_127 = ((1.0 - abs(tmpvar_125)) - abs(tmpvar_126));
  highp vec4 tmpvar_128;
  tmpvar_128.xy = tmpvar_125.xy;
  tmpvar_128.zw = tmpvar_126.xy;
  highp vec4 tmpvar_129;
  tmpvar_129.xy = tmpvar_125.zw;
  tmpvar_129.zw = tmpvar_126.zw;
  highp vec4 tmpvar_130;
  tmpvar_130 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_127)));
  highp vec4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_130.xxyy));
  highp vec4 tmpvar_132;
  tmpvar_132 = (tmpvar_129.xzyw + ((
    (floor(tmpvar_129) * 2.0)
   + 1.0).xzyw * tmpvar_130.zzww));
  highp vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_131.xy;
  tmpvar_133.z = tmpvar_127.x;
  highp vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.zw;
  tmpvar_134.z = tmpvar_127.y;
  highp vec3 tmpvar_135;
  tmpvar_135.xy = tmpvar_132.xy;
  tmpvar_135.z = tmpvar_127.z;
  highp vec3 tmpvar_136;
  tmpvar_136.xy = tmpvar_132.zw;
  tmpvar_136.z = tmpvar_127.w;
  highp vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_133, tmpvar_133);
  tmpvar_137.y = dot (tmpvar_134, tmpvar_134);
  tmpvar_137.z = dot (tmpvar_135, tmpvar_135);
  tmpvar_137.w = dot (tmpvar_136, tmpvar_136);
  highp vec4 tmpvar_138;
  tmpvar_138 = (1.792843 - (0.8537347 * tmpvar_137));
  highp vec4 tmpvar_139;
  tmpvar_139.x = dot (tmpvar_83, tmpvar_83);
  tmpvar_139.y = dot (tmpvar_88, tmpvar_88);
  tmpvar_139.z = dot (tmpvar_89, tmpvar_89);
  tmpvar_139.w = dot (tmpvar_90, tmpvar_90);
  highp vec4 tmpvar_140;
  tmpvar_140 = max ((0.6 - tmpvar_139), vec4(0.0, 0.0, 0.0, 0.0));
  m_81 = (tmpvar_140 * tmpvar_140);
  highp vec4 tmpvar_141;
  tmpvar_141.x = dot ((tmpvar_133 * tmpvar_138.x), tmpvar_83);
  tmpvar_141.y = dot ((tmpvar_134 * tmpvar_138.y), tmpvar_88);
  tmpvar_141.z = dot ((tmpvar_135 * tmpvar_138.z), tmpvar_89);
  tmpvar_141.w = dot ((tmpvar_136 * tmpvar_138.w), tmpvar_90);
  tmpvar_79 = (42.0 * dot ((m_81 * m_81), tmpvar_141));
  highp vec3 v_142;
  v_142 = (_NoiseScale.y * tmpvar_16);
  highp vec4 m_143;
  highp vec3 tmpvar_144;
  tmpvar_144 = floor((v_142 + dot (v_142, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_145;
  tmpvar_145 = ((v_142 - tmpvar_144) + dot (tmpvar_144, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_146;
  tmpvar_146.x = float((tmpvar_145.x >= tmpvar_145.y));
  tmpvar_146.y = float((tmpvar_145.y >= tmpvar_145.z));
  tmpvar_146.z = float((tmpvar_145.z >= tmpvar_145.x));
  highp vec3 tmpvar_147;
  tmpvar_147 = (1.0 - tmpvar_146);
  highp vec3 tmpvar_148;
  tmpvar_148 = min (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_149;
  tmpvar_149 = max (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_150;
  tmpvar_150 = ((tmpvar_145 - tmpvar_148) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_151;
  tmpvar_151 = ((tmpvar_145 - tmpvar_149) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_152;
  tmpvar_152 = (tmpvar_145 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_153;
  tmpvar_153 = (tmpvar_144 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_154;
  tmpvar_154 = (fract(abs(tmpvar_153)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_155;
  if ((tmpvar_153.x >= 0.0)) {
    tmpvar_155 = tmpvar_154.x;
  } else {
    tmpvar_155 = -(tmpvar_154.x);
  };
  highp float tmpvar_156;
  if ((tmpvar_153.y >= 0.0)) {
    tmpvar_156 = tmpvar_154.y;
  } else {
    tmpvar_156 = -(tmpvar_154.y);
  };
  highp float tmpvar_157;
  if ((tmpvar_153.z >= 0.0)) {
    tmpvar_157 = tmpvar_154.z;
  } else {
    tmpvar_157 = -(tmpvar_154.z);
  };
  highp vec4 tmpvar_158;
  tmpvar_158.xw = vec2(0.0, 1.0);
  tmpvar_158.y = tmpvar_148.z;
  tmpvar_158.z = tmpvar_149.z;
  highp vec4 x_159;
  x_159 = (tmpvar_157 + tmpvar_158);
  highp vec4 tmpvar_160;
  tmpvar_160 = (((
    (x_159 * x_159)
   * 34.0) + x_159) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_161;
  tmpvar_161 = (fract(abs(tmpvar_160)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_162;
  if ((tmpvar_160.x >= 0.0)) {
    tmpvar_162 = tmpvar_161.x;
  } else {
    tmpvar_162 = -(tmpvar_161.x);
  };
  highp float tmpvar_163;
  if ((tmpvar_160.y >= 0.0)) {
    tmpvar_163 = tmpvar_161.y;
  } else {
    tmpvar_163 = -(tmpvar_161.y);
  };
  highp float tmpvar_164;
  if ((tmpvar_160.z >= 0.0)) {
    tmpvar_164 = tmpvar_161.z;
  } else {
    tmpvar_164 = -(tmpvar_161.z);
  };
  highp float tmpvar_165;
  if ((tmpvar_160.w >= 0.0)) {
    tmpvar_165 = tmpvar_161.w;
  } else {
    tmpvar_165 = -(tmpvar_161.w);
  };
  highp vec4 tmpvar_166;
  tmpvar_166.x = tmpvar_162;
  tmpvar_166.y = tmpvar_163;
  tmpvar_166.z = tmpvar_164;
  tmpvar_166.w = tmpvar_165;
  highp vec4 tmpvar_167;
  tmpvar_167.xw = vec2(0.0, 1.0);
  tmpvar_167.y = tmpvar_148.y;
  tmpvar_167.z = tmpvar_149.y;
  highp vec4 x_168;
  x_168 = ((tmpvar_166 + tmpvar_156) + tmpvar_167);
  highp vec4 tmpvar_169;
  tmpvar_169 = (((
    (x_168 * x_168)
   * 34.0) + x_168) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_170;
  tmpvar_170 = (fract(abs(tmpvar_169)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_171;
  if ((tmpvar_169.x >= 0.0)) {
    tmpvar_171 = tmpvar_170.x;
  } else {
    tmpvar_171 = -(tmpvar_170.x);
  };
  highp float tmpvar_172;
  if ((tmpvar_169.y >= 0.0)) {
    tmpvar_172 = tmpvar_170.y;
  } else {
    tmpvar_172 = -(tmpvar_170.y);
  };
  highp float tmpvar_173;
  if ((tmpvar_169.z >= 0.0)) {
    tmpvar_173 = tmpvar_170.z;
  } else {
    tmpvar_173 = -(tmpvar_170.z);
  };
  highp float tmpvar_174;
  if ((tmpvar_169.w >= 0.0)) {
    tmpvar_174 = tmpvar_170.w;
  } else {
    tmpvar_174 = -(tmpvar_170.w);
  };
  highp vec4 tmpvar_175;
  tmpvar_175.x = tmpvar_171;
  tmpvar_175.y = tmpvar_172;
  tmpvar_175.z = tmpvar_173;
  tmpvar_175.w = tmpvar_174;
  highp vec4 tmpvar_176;
  tmpvar_176.xw = vec2(0.0, 1.0);
  tmpvar_176.y = tmpvar_148.x;
  tmpvar_176.z = tmpvar_149.x;
  highp vec4 x_177;
  x_177 = ((tmpvar_175 + tmpvar_155) + tmpvar_176);
  highp vec4 tmpvar_178;
  tmpvar_178 = (((
    (x_177 * x_177)
   * 34.0) + x_177) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_179;
  tmpvar_179 = (fract(abs(tmpvar_178)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_180;
  if ((tmpvar_178.x >= 0.0)) {
    tmpvar_180 = tmpvar_179.x;
  } else {
    tmpvar_180 = -(tmpvar_179.x);
  };
  highp float tmpvar_181;
  if ((tmpvar_178.y >= 0.0)) {
    tmpvar_181 = tmpvar_179.y;
  } else {
    tmpvar_181 = -(tmpvar_179.y);
  };
  highp float tmpvar_182;
  if ((tmpvar_178.z >= 0.0)) {
    tmpvar_182 = tmpvar_179.z;
  } else {
    tmpvar_182 = -(tmpvar_179.z);
  };
  highp float tmpvar_183;
  if ((tmpvar_178.w >= 0.0)) {
    tmpvar_183 = tmpvar_179.w;
  } else {
    tmpvar_183 = -(tmpvar_179.w);
  };
  highp vec4 tmpvar_184;
  tmpvar_184.x = tmpvar_180;
  tmpvar_184.y = tmpvar_181;
  tmpvar_184.z = tmpvar_182;
  tmpvar_184.w = tmpvar_183;
  highp vec4 tmpvar_185;
  tmpvar_185 = (tmpvar_184 - (49.0 * floor(
    (0.02040815 * tmpvar_184)
  )));
  highp vec4 tmpvar_186;
  tmpvar_186 = floor((tmpvar_185 * 0.1428571));
  highp vec4 tmpvar_187;
  tmpvar_187 = ((tmpvar_186 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_188;
  tmpvar_188 = ((floor(
    (tmpvar_185 - (7.0 * tmpvar_186))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_189;
  tmpvar_189 = ((1.0 - abs(tmpvar_187)) - abs(tmpvar_188));
  highp vec4 tmpvar_190;
  tmpvar_190.xy = tmpvar_187.xy;
  tmpvar_190.zw = tmpvar_188.xy;
  highp vec4 tmpvar_191;
  tmpvar_191.xy = tmpvar_187.zw;
  tmpvar_191.zw = tmpvar_188.zw;
  highp vec4 tmpvar_192;
  tmpvar_192 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_189)));
  highp vec4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_192.xxyy));
  highp vec4 tmpvar_194;
  tmpvar_194 = (tmpvar_191.xzyw + ((
    (floor(tmpvar_191) * 2.0)
   + 1.0).xzyw * tmpvar_192.zzww));
  highp vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_193.xy;
  tmpvar_195.z = tmpvar_189.x;
  highp vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.zw;
  tmpvar_196.z = tmpvar_189.y;
  highp vec3 tmpvar_197;
  tmpvar_197.xy = tmpvar_194.xy;
  tmpvar_197.z = tmpvar_189.z;
  highp vec3 tmpvar_198;
  tmpvar_198.xy = tmpvar_194.zw;
  tmpvar_198.z = tmpvar_189.w;
  highp vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_195, tmpvar_195);
  tmpvar_199.y = dot (tmpvar_196, tmpvar_196);
  tmpvar_199.z = dot (tmpvar_197, tmpvar_197);
  tmpvar_199.w = dot (tmpvar_198, tmpvar_198);
  highp vec4 tmpvar_200;
  tmpvar_200 = (1.792843 - (0.8537347 * tmpvar_199));
  highp vec4 tmpvar_201;
  tmpvar_201.x = dot (tmpvar_145, tmpvar_145);
  tmpvar_201.y = dot (tmpvar_150, tmpvar_150);
  tmpvar_201.z = dot (tmpvar_151, tmpvar_151);
  tmpvar_201.w = dot (tmpvar_152, tmpvar_152);
  highp vec4 tmpvar_202;
  tmpvar_202 = max ((0.6 - tmpvar_201), vec4(0.0, 0.0, 0.0, 0.0));
  m_143 = (tmpvar_202 * tmpvar_202);
  highp vec4 tmpvar_203;
  tmpvar_203.x = dot ((tmpvar_195 * tmpvar_200.x), tmpvar_145);
  tmpvar_203.y = dot ((tmpvar_196 * tmpvar_200.y), tmpvar_150);
  tmpvar_203.z = dot ((tmpvar_197 * tmpvar_200.z), tmpvar_151);
  tmpvar_203.w = dot ((tmpvar_198 * tmpvar_200.w), tmpvar_152);
  highp vec3 tmpvar_204;
  tmpvar_204.x = tmpvar_17;
  tmpvar_204.y = tmpvar_79;
  tmpvar_204.z = (42.0 * dot ((m_143 * m_143), tmpvar_203));
  highp vec3 tmpvar_205;
  tmpvar_205 = (0.5 * (tmpvar_204 + 1.0));
  localOrigin_7.xyz = (((2.0 * tmpvar_205) - 1.0) * _MaxTrans);
  localOrigin_7.w = 1.0;
  highp float tmpvar_206;
  tmpvar_206 = ((tmpvar_205.x * (_MaxScale - 1.0)) + 1.0);
  origin_9 = (_Object2World * localOrigin_7);
  planet_pos_8 = (_MainRotation * origin_9);
  highp vec3 tmpvar_207;
  tmpvar_207 = (_DetailRotation * planet_pos_8).xyz;
  tmpvar_13 = planet_pos_8.xyz;
  highp vec3 tmpvar_208;
  tmpvar_208 = normalize(planet_pos_8.xyz);
  highp vec2 uv_209;
  highp float tmpvar_210;
  highp float tmpvar_211;
  tmpvar_211 = (min (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0) / max (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0));
  highp float tmpvar_212;
  tmpvar_212 = (tmpvar_211 * tmpvar_211);
  tmpvar_212 = (((
    ((((
      ((((-0.01213232 * tmpvar_212) + 0.05368138) * tmpvar_212) - 0.1173503)
     * tmpvar_212) + 0.1938925) * tmpvar_212) - 0.3326756)
   * tmpvar_212) + 0.9999793) * tmpvar_211);
  tmpvar_212 = (tmpvar_212 + (float(
    (abs((tmpvar_208.x / tmpvar_208.z)) > 1.0)
  ) * (
    (tmpvar_212 * -2.0)
   + 1.570796)));
  tmpvar_210 = (tmpvar_212 * sign((tmpvar_208.x / tmpvar_208.z)));
  if ((abs(tmpvar_208.z) > (1e-08 * abs(tmpvar_208.x)))) {
    if ((tmpvar_208.z < 0.0)) {
      if ((tmpvar_208.x >= 0.0)) {
        tmpvar_210 += 3.141593;
      } else {
        tmpvar_210 = (tmpvar_210 - 3.141593);
      };
    };
  } else {
    tmpvar_210 = (sign(tmpvar_208.x) * 1.570796);
  };
  uv_209.x = (0.5 + (0.1591549 * tmpvar_210));
  uv_209.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_208.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_208.y)
    )) * (1.570796 + (
      abs(tmpvar_208.y)
     * 
      (-0.2146018 + (abs(tmpvar_208.y) * (0.08656672 + (
        abs(tmpvar_208.y)
       * -0.03102955))))
    ))))
  )));
  lowp vec4 tmpvar_213;
  tmpvar_213 = texture2DLod (_MainTex, uv_209, 0.0);
  mediump vec4 tmpvar_214;
  tmpvar_214 = tmpvar_213;
  tmpvar_10 = tmpvar_214;
  mediump vec3 detailCoords_215;
  mediump float s_216;
  mediump float nylerp_217;
  mediump float zxlerp_218;
  highp vec4 uv4_219;
  uv4_219.zw = vec2(0.0, 0.0);
  highp vec3 tmpvar_220;
  tmpvar_220 = normalize(tmpvar_207);
  highp vec3 tmpvar_221;
  tmpvar_221 = abs(tmpvar_220);
  highp float tmpvar_222;
  tmpvar_222 = float((tmpvar_221.z >= tmpvar_221.x));
  zxlerp_218 = tmpvar_222;
  highp float tmpvar_223;
  tmpvar_223 = float((max (tmpvar_221.x, tmpvar_221.z) >= tmpvar_221.y));
  nylerp_217 = tmpvar_223;
  highp float tmpvar_224;
  tmpvar_224 = mix (tmpvar_220.x, tmpvar_220.z, zxlerp_218);
  s_216 = tmpvar_224;
  highp float tmpvar_225;
  tmpvar_225 = sign(mix (tmpvar_220.y, s_216, nylerp_217));
  s_216 = tmpvar_225;
  mediump vec3 tmpvar_226;
  tmpvar_226.xz = vec2(1.0, -1.0);
  tmpvar_226.y = -(s_216);
  mediump vec3 tmpvar_227;
  tmpvar_227.xz = vec2(1.0, -1.0);
  tmpvar_227.y = s_216;
  highp vec3 tmpvar_228;
  tmpvar_228 = mix ((tmpvar_226 * tmpvar_220.xzy), (tmpvar_227 * tmpvar_220.zxy), vec3(zxlerp_218));
  detailCoords_215 = tmpvar_228;
  mediump vec3 tmpvar_229;
  tmpvar_229.xy = vec2(1.0, 1.0);
  tmpvar_229.z = s_216;
  highp vec3 tmpvar_230;
  tmpvar_230 = mix ((tmpvar_229 * tmpvar_220.yxz), detailCoords_215, vec3(nylerp_217));
  detailCoords_215 = tmpvar_230;
  mediump vec2 tmpvar_231;
  tmpvar_231 = (((0.5 * detailCoords_215.yz) / abs(detailCoords_215.x)) + 0.5);
  uv4_219.xy = tmpvar_231;
  lowp vec4 tmpvar_232;
  tmpvar_232 = texture2DLod (_DetailTex, uv4_219.xy, 0.0);
  mediump vec4 tmpvar_233;
  tmpvar_233 = tmpvar_232;
  tmpvar_10 = (tmpvar_10 * tmpvar_233);
  highp vec4 tmpvar_234;
  tmpvar_234.w = 0.0;
  tmpvar_234.xyz = _WorldSpaceCameraPos;
  highp float tmpvar_235;
  highp vec4 tmpvar_236;
  tmpvar_236 = (origin_9 - tmpvar_234);
  tmpvar_235 = sqrt(dot (tmpvar_236, tmpvar_236));
  highp float tmpvar_237;
  tmpvar_237 = (clamp ((_DistFade * tmpvar_235), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_235)
  ), 0.0, 1.0));
  tmpvar_11.w = tmpvar_237;
  tmpvar_10.w = (tmpvar_10.w * tmpvar_11.w);
  highp vec3 tmpvar_238;
  tmpvar_238.yz = vec2(0.0, 0.0);
  tmpvar_238.x = fract(_Rotation);
  highp vec3 x_239;
  x_239 = (tmpvar_238 + tmpvar_205);
  highp vec3 trans_240;
  trans_240 = localOrigin_7.xyz;
  highp float tmpvar_241;
  tmpvar_241 = (x_239.x * 6.283185);
  highp float tmpvar_242;
  tmpvar_242 = (x_239.y * 6.283185);
  highp float tmpvar_243;
  tmpvar_243 = (x_239.z * 2.0);
  highp float tmpvar_244;
  tmpvar_244 = sqrt(tmpvar_243);
  highp float tmpvar_245;
  tmpvar_245 = (sin(tmpvar_242) * tmpvar_244);
  highp float tmpvar_246;
  tmpvar_246 = (cos(tmpvar_242) * tmpvar_244);
  highp float tmpvar_247;
  tmpvar_247 = sqrt((2.0 - tmpvar_243));
  highp float tmpvar_248;
  tmpvar_248 = sin(tmpvar_241);
  highp float tmpvar_249;
  tmpvar_249 = cos(tmpvar_241);
  highp float tmpvar_250;
  tmpvar_250 = ((tmpvar_245 * tmpvar_249) - (tmpvar_246 * tmpvar_248));
  highp float tmpvar_251;
  tmpvar_251 = ((tmpvar_245 * tmpvar_248) + (tmpvar_246 * tmpvar_249));
  highp mat4 tmpvar_252;
  tmpvar_252[0].x = (tmpvar_206 * ((tmpvar_245 * tmpvar_250) - tmpvar_249));
  tmpvar_252[0].y = ((tmpvar_245 * tmpvar_251) - tmpvar_248);
  tmpvar_252[0].z = (tmpvar_245 * tmpvar_247);
  tmpvar_252[0].w = 0.0;
  tmpvar_252[1].x = ((tmpvar_246 * tmpvar_250) + tmpvar_248);
  tmpvar_252[1].y = (tmpvar_206 * ((tmpvar_246 * tmpvar_251) - tmpvar_249));
  tmpvar_252[1].z = (tmpvar_246 * tmpvar_247);
  tmpvar_252[1].w = 0.0;
  tmpvar_252[2].x = (tmpvar_247 * tmpvar_250);
  tmpvar_252[2].y = (tmpvar_247 * tmpvar_251);
  tmpvar_252[2].z = (tmpvar_206 * (1.0 - tmpvar_243));
  tmpvar_252[2].w = 0.0;
  tmpvar_252[3].x = trans_240.x;
  tmpvar_252[3].y = trans_240.y;
  tmpvar_252[3].z = trans_240.z;
  tmpvar_252[3].w = 1.0;
  highp mat4 tmpvar_253;
  tmpvar_253 = ((unity_MatrixV * _Object2World) * tmpvar_252);
  highp vec4 v_254;
  v_254.x = tmpvar_253[0].z;
  v_254.y = tmpvar_253[1].z;
  v_254.z = tmpvar_253[2].z;
  v_254.w = tmpvar_253[3].z;
  highp vec3 tmpvar_255;
  tmpvar_255 = normalize(v_254.xyz);
  highp vec3 tmpvar_256;
  tmpvar_256 = abs(tmpvar_255);
  tmpvar_11.xyz = tmpvar_256;
  highp vec4 tmpvar_257;
  tmpvar_257 = (glstate_matrix_modelview0 * localOrigin_7);
  highp vec4 tmpvar_258;
  tmpvar_258.xyz = (_glesVertex.xyz * tmpvar_206);
  tmpvar_258.w = tmpvar_1.w;
  highp vec2 tmpvar_259;
  tmpvar_259 = ((2.0 * _glesMultiTexCoord0.xy) - 1.0);
  highp vec4 tmpvar_260;
  tmpvar_260.z = 0.0;
  tmpvar_260.xy = tmpvar_259;
  tmpvar_260.w = tmpvar_1.w;
  ZYv_6.xyw = tmpvar_260.zyw;
  XZv_5.yzw = tmpvar_260.zyw;
  XYv_4.yzw = tmpvar_260.yzw;
  ZYv_6.z = (tmpvar_259.x * sign(-(tmpvar_255.x)));
  XZv_5.x = (tmpvar_259.x * sign(-(tmpvar_255.y)));
  XYv_4.x = (tmpvar_259.x * sign(tmpvar_255.z));
  ZYv_6.x = ((sign(
    -(tmpvar_255.x)
  ) * sign(ZYv_6.z)) * tmpvar_255.z);
  XZv_5.y = ((sign(
    -(tmpvar_255.y)
  ) * sign(XZv_5.x)) * tmpvar_255.x);
  XYv_4.z = ((sign(
    -(tmpvar_255.z)
  ) * sign(XYv_4.x)) * tmpvar_255.x);
  ZYv_6.x = (ZYv_6.x + ((
    sign(-(tmpvar_255.x))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  XZv_5.y = (XZv_5.y + ((
    sign(-(tmpvar_255.y))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.z));
  XYv_4.z = (XYv_4.z + ((
    sign(-(tmpvar_255.z))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  highp vec3 tmpvar_261;
  tmpvar_261 = normalize((origin_9.xyz - _WorldSpaceCameraPos));
  highp vec3 tmpvar_262;
  tmpvar_262 = normalize(-(tmpvar_261));
  normal_3 = tmpvar_262;
  highp vec4 v_263;
  v_263.x = unity_MatrixV[0].x;
  v_263.y = unity_MatrixV[1].x;
  v_263.z = unity_MatrixV[2].x;
  v_263.w = unity_MatrixV[3].x;
  highp vec3 tmpvar_264;
  tmpvar_264 = normalize(v_263.xyz);
  highp vec3 tmpvar_265;
  highp vec3 tmpvar_266;
  tmpvar_265 = v_263.xyz;
  tmpvar_266 = ((normal_3.zxy * tmpvar_264.yzx) - (normal_3.yzx * tmpvar_264.zxy));
  highp vec3 tmpvar_267;
  tmpvar_267 = normal_3;
  highp mat3 tmpvar_268;
  tmpvar_268[0].x = tmpvar_265.x;
  tmpvar_268[0].y = tmpvar_266.x;
  tmpvar_268[0].z = tmpvar_267.x;
  tmpvar_268[1].x = tmpvar_265.y;
  tmpvar_268[1].y = tmpvar_266.y;
  tmpvar_268[1].z = tmpvar_267.y;
  tmpvar_268[2].x = tmpvar_265.z;
  tmpvar_268[2].y = tmpvar_266.z;
  tmpvar_268[2].z = tmpvar_267.z;
  gl_Position = (glstate_matrix_projection * (tmpvar_257 + tmpvar_258));
  xlv_COLOR = tmpvar_10;
  xlv_TEXCOORD0 = tmpvar_11;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * ZYv_6)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XZv_5)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XYv_4)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD4 = tmpvar_2;
  xlv_TEXCOORD5 = tmpvar_12;
  xlv_TEXCOORD6 = tmpvar_13;
  xlv_TEXCOORD7 = normalize((tmpvar_268 * tmpvar_261));
  xlv_TEXCOORD8 = normalize((tmpvar_268 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform lowp vec4 _LightColor0;
uniform sampler2D _Tex;
uniform lowp vec4 _Color;
uniform highp float _MinScatter;
uniform highp float _Opacity;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec3 normT_2;
  mediump vec4 color_3;
  mediump vec4 tex_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_Tex, xlv_TEXCOORD1);
  tex_4.x = tmpvar_5.x;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex, xlv_TEXCOORD2);
  tex_4.y = tmpvar_6.y;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex, xlv_TEXCOORD3);
  tex_4.z = tmpvar_7.z;
  tex_4.w = 0.0;
  tex_4.xyz = (tex_4.xyz * xlv_TEXCOORD0.xyz);
  tex_4 = (tex_4 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  mediump float tmpvar_8;
  tmpvar_8 = ((tex_4.x + tex_4.y) + (tex_4.z + tex_4.w));
  mediump vec4 tmpvar_9;
  tmpvar_9.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_9.w = tmpvar_8;
  tex_4.xyz = tmpvar_9.xyz;
  color_3 = (_Color * xlv_COLOR);
  normT_2.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_2.z = sqrt((1.0 - clamp (
    dot (normT_2.xy, normT_2.xy)
  , 0.0, 1.0)));
  color_3.w = (color_3.w * tmpvar_8);
  tex_4.w = (xlv_TEXCOORD0.w * tmpvar_8);
  mediump vec3 lightDir_10;
  lightDir_10 = xlv_TEXCOORD8;
  mediump vec3 viewDir_11;
  viewDir_11 = xlv_TEXCOORD7;
  mediump vec4 c_12;
  highp float h_13;
  mediump vec3 tmpvar_14;
  tmpvar_14 = normalize(lightDir_10);
  lightDir_10 = tmpvar_14;
  mediump vec3 tmpvar_15;
  tmpvar_15 = normalize(viewDir_11);
  viewDir_11 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16 = normalize(normT_2);
  mediump float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_16, tmpvar_14), 0.0);
  mediump float tmpvar_18;
  tmpvar_18 = (0.5 + (0.5 * dot (tmpvar_15, tmpvar_14)));
  h_13 = tmpvar_18;
  mediump float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, tmpvar_15);
  highp float tmpvar_20;
  tmpvar_20 = clamp (((
    (_MinScatter - (_Opacity * tex_4.w))
   * 
    (1.0 - tmpvar_19)
  ) * h_13), 0.0, 1.0);
  c_12.xyz = ((_LightColor0.xyz * (vec3(tmpvar_17) + tmpvar_20)) * 2.0);
  c_12.w = (tmpvar_17 * 2.0);
  color_3.xyz = (color_3.xyz * c_12.xyz);
  tmpvar_1 = color_3;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 in_POSITION0;
in  vec2 in_TEXCOORD0;
out vec4 vs_COLOR0;
out vec4 vs_TEXCOORD0;
out vec2 vs_TEXCOORD1;
out vec2 vs_TEXCOORD2;
out vec2 vs_TEXCOORD3;
out vec2 vs_TEXCOORD4;
out vec4 vs_TEXCOORD5;
out vec3 vs_TEXCOORD6;
out vec3 vs_TEXCOORD7;
out vec3 vs_TEXCOORD8;
vec4 t0;
vec4 t1;
bvec4 tb1;
vec4 t2;
vec4 t3;
bvec3 tb3;
vec4 t4;
bvec4 tb4;
vec4 t5;
bvec4 tb5;
vec4 t6;
ivec3 ti6;
bvec3 tb6;
vec4 t7;
ivec3 ti7;
bvec4 tb7;
vec4 t8;
vec4 t9;
bvec4 tb9;
vec4 t10;
bvec4 tb10;
vec4 t11;
bvec4 tb11;
vec4 t12;
vec4 t13;
float t15;
vec3 t18;
ivec3 ti18;
vec3 t20;
vec2 t28;
int ti28;
vec2 t29;
int ti29;
vec2 t31;
ivec2 ti31;
bvec2 tb31;
float t42;
int ti42;
float t43;
int ti43;
bool tb43;
float t44;
int ti44;
bool tb44;
float t45;
int ti45;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t44 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t44);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t44 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t44) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t42 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t42);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t42 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t42) + t6.xyz;
    t42 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t42);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t42 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t42) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t42 = dot(t1, t6);
    t0.x = t42 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t42 = t1.x * 0.5;
    t43 = _MaxScale + -1.0;
    t42 = t42 * t43 + 1.0;
    t2.xyz = vec3(t42) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t43 = dot(t5.xyz, t5.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t5.xyz;
    t44 = t5.z * t43 + (-t6.y);
    tb31.x = abs(t6.z)>=abs(t6.y);
    t31.x = tb31.x ? 1.0 : float(0.0);
    t44 = t31.x * t44 + t6.y;
    t43 = (-t5.x) * t43 + t44;
    t44 = max(abs(t6.z), abs(t6.y));
    tb44 = t44>=abs(t6.x);
    t44 = tb44 ? 1.0 : float(0.0);
    t43 = t44 * t43 + t6.x;
    ti45 = int((0.0<t43) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t43<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti43 = (-ti45) + ti43;
    t5.y = float(ti43);
    t7.y = (-t5.y);
    t7.xz = vec2(1.0, -1.0);
    t7.xyz = t6.yzx * t7.xyz;
    t5.xz = vec2(1.0, -1.0);
    t8.xyz = t5.xyz * t6.zyx + (-t7.xyz);
    t7.xyz = t31.xxx * t8.xyz + t7.xyz;
    t7.xyz = (-t5.xxy) * t6.xyz + t7.xyz;
    t5.xyz = t6.xyz * t5.xxy;
    t5.xyz = vec3(t44) * t7.xyz + t5.xyz;
    t31.xy = t5.yz * vec2(0.5, 0.5);
    t31.xy = t31.xy / abs(t5.xx);
    t31.xy = t31.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t31.xy, 0.0);
    t43 = dot(t4.xyz, t4.xyz);
    t43 = inversesqrt(t43);
    t6.xyz = vec3(t43) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb43 = abs(t6.y)<abs(t6.x);
    t44 = max(abs(t6.y), abs(t6.x));
    t44 = float(1.0) / t44;
    t31.x = min(abs(t6.y), abs(t6.x));
    t44 = t44 * t31.x;
    t31.x = t44 * t44;
    t45 = t31.x * 0.0208350997 + -0.0851330012;
    t45 = t31.x * t45 + 0.180141002;
    t45 = t31.x * t45 + -0.330299497;
    t31.x = t31.x * t45 + 0.999866009;
    t45 = t44 * t31.x;
    t45 = t45 * -2.0 + 1.57079637;
    t43 = tb43 ? t45 : float(0.0);
    t43 = t44 * t31.x + t43;
    tb31.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t44 = tb31.x ? -3.14159274 : float(0.0);
    t43 = t43 + t44;
    t44 = min(t6.y, t6.x);
    tb44 = t44<(-t44);
    t31.x = max(t6.y, t6.x);
    tb31.x = t31.x>=(-t31.x);
    ti44 = int(uint(tb44) * 0xffffffffu & uint(tb31.x) * 0xffffffffu);
    t43 = (ti44 != 0) ? (-t43) : t43;
    t4.x = t43 * 0.159154937 + 0.5;
    t43 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t43 = t43 * abs(t6.z) + -0.212114394;
    t43 = t43 * abs(t6.z) + 1.57072878;
    t44 = -abs(t6.z) + 1.0;
    t44 = sqrt(t44);
    t31.x = t43 * t44;
    t31.x = t31.x * -2.0 + 3.14159274;
    t31.x = tb31.y ? t31.x : float(0.0);
    t43 = t43 * t44 + t31.x;
    t4.y = t43 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t4 = t5 * t4;
    vs_COLOR0.xyz = t4.xyz;
    t43 = dot(t2.xyz, t2.xyz);
    t44 = sqrt(t43);
    t43 = inversesqrt(t43);
    t2.xyz = vec3(t43) * t2.xyz;
    t43 = t44 * _DistFade;
    t44 = (-_DistFadeVert) * t44 + 1.0;
    t44 = clamp(t44, 0.0, 1.0);
    t43 = t43;
    t43 = clamp(t43, 0.0, 1.0);
    t43 = t44 * t43;
    vs_COLOR0.w = t43 * t4.w;
    vs_TEXCOORD0.w = t43;
    t4.x = fract(_Rotation);
    t4.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t4.xyz;
    t31.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t31.x);
    t44 = t42 * t31.y;
    t29.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t29.x = sqrt(t29.x);
    t4.x = sin(t1.y);
    t5.x = cos(t1.y);
    t6.x = cos(t1.x);
    t1.x = sin(t1.x);
    t15 = t29.x * t5.x;
    t29.x = t29.x * t4.x;
    t31.xy = t1.wx * vec2(t15);
    t45 = t29.x * t6.x + (-t31.y);
    t4.x = t15 * t45 + t1.x;
    t18.x = t6.x * t15;
    t18.x = t29.x * t1.x + t18.x;
    t15 = t15 * t18.x + (-t6.x);
    t15 = t42 * t15;
    t5.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t5.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t5.xyz;
    t5.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t5.xyz;
    t5.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t5.xyz;
    t20.xyz = vec3(t15) * t5.xyz;
    t7.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t7.xyz;
    t4.xzw = t7.xyz * t4.xxx + t20.xyz;
    t20.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t20.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t20.xyz;
    t20.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t20.xyz;
    t20.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t20.xyz;
    t4.xzw = t20.xyz * t31.xxx + t4.xzw;
    t8.y = t4.w;
    t15 = t29.x * t45 + (-t6.x);
    t1.x = t29.x * t18.x + (-t1.x);
    t29.x = t1.w * t29.x;
    t31.x = t1.w * t18.x;
    t43 = t1.w * t45;
    t9.xyz = t31.xxx * t5.xyz;
    t9.xyz = t7.xyz * vec3(t43) + t9.xyz;
    t9.xyz = t20.xyz * vec3(t44) + t9.xyz;
    t10.xyz = t1.xxx * t5.xyz;
    t1.xw = t0.yy * t5.xy;
    t0.xy = t7.xy * t0.xx + t1.xw;
    t0.xy = t20.xy * t0.zz + t0.xy;
    t28.x = t42 * t15;
    t1.xyw = t7.xyz * t28.xxx + t10.xyz;
    t1.xyz = t20.xyz * t29.xxx + t1.xyw;
    t8.x = t1.z;
    t8.z = t9.z;
    t28.x = dot(t8.xyz, t8.xyz);
    t28.x = inversesqrt(t28.x);
    t5.xyz = t28.xxx * t8.xyz;
    vs_TEXCOORD0.xyz = abs(t5.xyz);
    t28.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t28.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t28.xy;
    t28.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t28.xy;
    t28.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t28.xy;
    t0.xy = t28.xy + t0.xy;
    ti6.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t5.xyzx)).xyz) * 0xFFFFFFFFu);
    ti7.xyz = ivec3(uvec3(lessThan((-t5.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti6.xyz = (-ti6.xyz) + ti7.xyz;
    t28.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti29 = int((0.0<t28.y) ? 0xFFFFFFFFu : uint(0u));
    ti43 = int((t28.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti29 = (-ti29) + ti43;
    ti7.xyz = ivec3(ti29) * ti6.xyz;
    t7.xyz = vec3(ti7.xyz);
    t7.xyz = t5.yzy * t7.xyz;
    t29.xy = vec2(ti6.xy);
    t29.xy = t28.xx * t29.xy;
    ti31.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t29.xyxy).xy) * 0xFFFFFFFFu);
    ti18.xz = ivec2(uvec2(lessThan(t29.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti31.xy = (-ti31.xy) + ti18.xz;
    ti31.xy = ti31.xy * ti6.xy;
    t31.xy = vec2(ti31.xy);
    t31.xy = t31.xy * t5.zx + t7.xy;
    t18.xz = t31.yy * t4.xz;
    t4.xz = t28.yy * t4.xz;
    t31.xy = t1.xy * t31.xx + t4.xz;
    t31.xy = t9.xy * t29.xx + t31.xy;
    t29.xy = t1.xy * t29.yy + t18.xz;
    t29.xy = t9.xy * t28.yy + t29.xy;
    t29.xy = t0.xy * in_POSITION0.ww + t29.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD2.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t29.xy = t0.xy * in_POSITION0.ww + t31.xy;
    t29.xy = (-t3.xy) + t29.xy;
    vs_TEXCOORD1.xy = t29.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti42 = int((0.0<t5.z) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t5.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti42 = (-ti42) + ti29;
    t42 = float(ti42);
    t28.x = t42 * t28.x;
    ti42 = int((0.0<t28.x) ? 0xFFFFFFFFu : uint(0u));
    ti29 = int((t28.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t28.xx + t4.xz;
    ti28 = (-ti42) + ti29;
    ti28 = ti28 * ti6.z;
    t28.x = float(ti28);
    t28.x = t28.x * t5.x + t7.z;
    t28.xy = t9.xy * t28.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t28.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t42 = dot(t3.xyz, t3.xyz);
    t42 = inversesqrt(t42);
    t4.xyz = vec3(t42) * t3.yzx;
    t5.xyz = t0.zxy * t4.xyz;
    t4.xyz = t0.yzx * t4.yzx + (-t5.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t4.xyz), t2.xyz);
    t0.y = dot((-t4.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t42 = dot(t1.xyz, t1.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD7.xyz = vec3(t42) * t1.xyz;
    t42 = dot(t0.xyz, t0.xyz);
    t42 = inversesqrt(t42);
    vs_TEXCOORD8.xyz = vec3(t42) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform  sampler2D _Tex;
in  vec4 vs_COLOR0;
in  vec4 vs_TEXCOORD0;
in  vec2 vs_TEXCOORD1;
in  vec2 vs_TEXCOORD2;
in  vec2 vs_TEXCOORD3;
in  vec2 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD7;
in  vec3 vs_TEXCOORD8;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
vec3 t3;
vec3 t4;
vec2 t8;
float t12;
void main()
{
    t0 = texture(_Tex, vs_TEXCOORD1.xy);
    t10_1 = texture(_Tex, vs_TEXCOORD2.xy);
    t0.y = t10_1.y;
    t10_1 = texture(_Tex, vs_TEXCOORD3.xy);
    t0.z = t10_1.z;
    t0.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t12 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t12 = t12 + vs_TEXCOORD0.z;
    t0.xyz = t0.xyz / vec3(t12);
    t0.x = t0.y + t0.x;
    t0.x = t0.z + t0.x;
    t4.x = t0.x * vs_TEXCOORD0.w;
    t4.x = (-_Opacity) * t4.x + _MinScatter;
    t8.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t8.xy, t8.xy);
    t8.x = min(t8.x, 1.0);
    t8.x = (-t8.x) + 1.0;
    t1.z = sqrt(t8.x);
    t1.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t8.x = dot(t1.xyz, t1.xyz);
    t8.x = inversesqrt(t8.x);
    t1.xyz = t8.xxx * t1.xyz;
    t8.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t8.x = inversesqrt(t8.x);
    t2.xyz = t8.xxx * vs_TEXCOORD7.xyz;
    t8.x = dot(t1.xyz, t2.xyz);
    t8.x = (-t8.x) + 1.0;
    t4.x = t8.x * t4.x;
    t8.x = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t8.x = inversesqrt(t8.x);
    t3.xyz = t8.xxx * vs_TEXCOORD8.xyz;
    t8.x = dot(t2.xyz, t3.xyz);
    t12 = dot(t1.xyz, t3.xyz);
    t12 = max(t12, 0.0);
    t8.x = t8.x * 0.5 + 0.5;
    t4.x = t8.x * t4.x;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t4.x = t4.x + t12;
    t4.xyz = t4.xxx * _LightColor0.xyz;
    t0.yzw = t4.xyz + t4.xyz;
    t1 = vs_COLOR0 * _Color;
    SV_Target0 = t0.yzwx * t1;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 glstate_matrix_projection;
uniform highp mat4 unity_MatrixV;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform highp mat4 _PosRotation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _Rotation;
uniform highp float _MaxScale;
uniform highp vec4 _NoiseScale;
uniform highp vec3 _MaxTrans;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  mediump vec3 normal_3;
  highp vec4 XYv_4;
  highp vec4 XZv_5;
  highp vec4 ZYv_6;
  highp vec4 localOrigin_7;
  highp vec4 planet_pos_8;
  highp vec4 origin_9;
  lowp vec4 tmpvar_10;
  mediump vec4 tmpvar_11;
  highp vec4 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_9 = tmpvar_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (_PosRotation * tmpvar_14);
  planet_pos_8 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (_NoiseScale.z * tmpvar_15.xyz);
  highp float tmpvar_17;
  highp vec4 m_18;
  highp vec3 tmpvar_19;
  tmpvar_19 = floor((tmpvar_16 + dot (tmpvar_16, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_20;
  tmpvar_20 = ((tmpvar_16 - tmpvar_19) + dot (tmpvar_19, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_21;
  tmpvar_21.x = float((tmpvar_20.x >= tmpvar_20.y));
  tmpvar_21.y = float((tmpvar_20.y >= tmpvar_20.z));
  tmpvar_21.z = float((tmpvar_20.z >= tmpvar_20.x));
  highp vec3 tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_21);
  highp vec3 tmpvar_23;
  tmpvar_23 = min (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_24;
  tmpvar_24 = max (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_25;
  tmpvar_25 = ((tmpvar_20 - tmpvar_23) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_26;
  tmpvar_26 = ((tmpvar_20 - tmpvar_24) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_27;
  tmpvar_27 = (tmpvar_20 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28 = (tmpvar_19 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (fract(abs(tmpvar_28)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_30;
  if ((tmpvar_28.x >= 0.0)) {
    tmpvar_30 = tmpvar_29.x;
  } else {
    tmpvar_30 = -(tmpvar_29.x);
  };
  highp float tmpvar_31;
  if ((tmpvar_28.y >= 0.0)) {
    tmpvar_31 = tmpvar_29.y;
  } else {
    tmpvar_31 = -(tmpvar_29.y);
  };
  highp float tmpvar_32;
  if ((tmpvar_28.z >= 0.0)) {
    tmpvar_32 = tmpvar_29.z;
  } else {
    tmpvar_32 = -(tmpvar_29.z);
  };
  highp vec4 tmpvar_33;
  tmpvar_33.xw = vec2(0.0, 1.0);
  tmpvar_33.y = tmpvar_23.z;
  tmpvar_33.z = tmpvar_24.z;
  highp vec4 x_34;
  x_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35 = (((
    (x_34 * x_34)
   * 34.0) + x_34) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_36;
  tmpvar_36 = (fract(abs(tmpvar_35)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_37;
  if ((tmpvar_35.x >= 0.0)) {
    tmpvar_37 = tmpvar_36.x;
  } else {
    tmpvar_37 = -(tmpvar_36.x);
  };
  highp float tmpvar_38;
  if ((tmpvar_35.y >= 0.0)) {
    tmpvar_38 = tmpvar_36.y;
  } else {
    tmpvar_38 = -(tmpvar_36.y);
  };
  highp float tmpvar_39;
  if ((tmpvar_35.z >= 0.0)) {
    tmpvar_39 = tmpvar_36.z;
  } else {
    tmpvar_39 = -(tmpvar_36.z);
  };
  highp float tmpvar_40;
  if ((tmpvar_35.w >= 0.0)) {
    tmpvar_40 = tmpvar_36.w;
  } else {
    tmpvar_40 = -(tmpvar_36.w);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.x = tmpvar_37;
  tmpvar_41.y = tmpvar_38;
  tmpvar_41.z = tmpvar_39;
  tmpvar_41.w = tmpvar_40;
  highp vec4 tmpvar_42;
  tmpvar_42.xw = vec2(0.0, 1.0);
  tmpvar_42.y = tmpvar_23.y;
  tmpvar_42.z = tmpvar_24.y;
  highp vec4 x_43;
  x_43 = ((tmpvar_41 + tmpvar_31) + tmpvar_42);
  highp vec4 tmpvar_44;
  tmpvar_44 = (((
    (x_43 * x_43)
   * 34.0) + x_43) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_45;
  tmpvar_45 = (fract(abs(tmpvar_44)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_46;
  if ((tmpvar_44.x >= 0.0)) {
    tmpvar_46 = tmpvar_45.x;
  } else {
    tmpvar_46 = -(tmpvar_45.x);
  };
  highp float tmpvar_47;
  if ((tmpvar_44.y >= 0.0)) {
    tmpvar_47 = tmpvar_45.y;
  } else {
    tmpvar_47 = -(tmpvar_45.y);
  };
  highp float tmpvar_48;
  if ((tmpvar_44.z >= 0.0)) {
    tmpvar_48 = tmpvar_45.z;
  } else {
    tmpvar_48 = -(tmpvar_45.z);
  };
  highp float tmpvar_49;
  if ((tmpvar_44.w >= 0.0)) {
    tmpvar_49 = tmpvar_45.w;
  } else {
    tmpvar_49 = -(tmpvar_45.w);
  };
  highp vec4 tmpvar_50;
  tmpvar_50.x = tmpvar_46;
  tmpvar_50.y = tmpvar_47;
  tmpvar_50.z = tmpvar_48;
  tmpvar_50.w = tmpvar_49;
  highp vec4 tmpvar_51;
  tmpvar_51.xw = vec2(0.0, 1.0);
  tmpvar_51.y = tmpvar_23.x;
  tmpvar_51.z = tmpvar_24.x;
  highp vec4 x_52;
  x_52 = ((tmpvar_50 + tmpvar_30) + tmpvar_51);
  highp vec4 tmpvar_53;
  tmpvar_53 = (((
    (x_52 * x_52)
   * 34.0) + x_52) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_54;
  tmpvar_54 = (fract(abs(tmpvar_53)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_55;
  if ((tmpvar_53.x >= 0.0)) {
    tmpvar_55 = tmpvar_54.x;
  } else {
    tmpvar_55 = -(tmpvar_54.x);
  };
  highp float tmpvar_56;
  if ((tmpvar_53.y >= 0.0)) {
    tmpvar_56 = tmpvar_54.y;
  } else {
    tmpvar_56 = -(tmpvar_54.y);
  };
  highp float tmpvar_57;
  if ((tmpvar_53.z >= 0.0)) {
    tmpvar_57 = tmpvar_54.z;
  } else {
    tmpvar_57 = -(tmpvar_54.z);
  };
  highp float tmpvar_58;
  if ((tmpvar_53.w >= 0.0)) {
    tmpvar_58 = tmpvar_54.w;
  } else {
    tmpvar_58 = -(tmpvar_54.w);
  };
  highp vec4 tmpvar_59;
  tmpvar_59.x = tmpvar_55;
  tmpvar_59.y = tmpvar_56;
  tmpvar_59.z = tmpvar_57;
  tmpvar_59.w = tmpvar_58;
  highp vec4 tmpvar_60;
  tmpvar_60 = (tmpvar_59 - (49.0 * floor(
    (0.02040815 * tmpvar_59)
  )));
  highp vec4 tmpvar_61;
  tmpvar_61 = floor((tmpvar_60 * 0.1428571));
  highp vec4 tmpvar_62;
  tmpvar_62 = ((tmpvar_61 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_63;
  tmpvar_63 = ((floor(
    (tmpvar_60 - (7.0 * tmpvar_61))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_64;
  tmpvar_64 = ((1.0 - abs(tmpvar_62)) - abs(tmpvar_63));
  highp vec4 tmpvar_65;
  tmpvar_65.xy = tmpvar_62.xy;
  tmpvar_65.zw = tmpvar_63.xy;
  highp vec4 tmpvar_66;
  tmpvar_66.xy = tmpvar_62.zw;
  tmpvar_66.zw = tmpvar_63.zw;
  highp vec4 tmpvar_67;
  tmpvar_67 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_64)));
  highp vec4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_67.xxyy));
  highp vec4 tmpvar_69;
  tmpvar_69 = (tmpvar_66.xzyw + ((
    (floor(tmpvar_66) * 2.0)
   + 1.0).xzyw * tmpvar_67.zzww));
  highp vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_68.xy;
  tmpvar_70.z = tmpvar_64.x;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.zw;
  tmpvar_71.z = tmpvar_64.y;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = tmpvar_69.xy;
  tmpvar_72.z = tmpvar_64.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = tmpvar_69.zw;
  tmpvar_73.z = tmpvar_64.w;
  highp vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_70, tmpvar_70);
  tmpvar_74.y = dot (tmpvar_71, tmpvar_71);
  tmpvar_74.z = dot (tmpvar_72, tmpvar_72);
  tmpvar_74.w = dot (tmpvar_73, tmpvar_73);
  highp vec4 tmpvar_75;
  tmpvar_75 = (1.792843 - (0.8537347 * tmpvar_74));
  highp vec4 tmpvar_76;
  tmpvar_76.x = dot (tmpvar_20, tmpvar_20);
  tmpvar_76.y = dot (tmpvar_25, tmpvar_25);
  tmpvar_76.z = dot (tmpvar_26, tmpvar_26);
  tmpvar_76.w = dot (tmpvar_27, tmpvar_27);
  highp vec4 tmpvar_77;
  tmpvar_77 = max ((0.6 - tmpvar_76), vec4(0.0, 0.0, 0.0, 0.0));
  m_18 = (tmpvar_77 * tmpvar_77);
  highp vec4 tmpvar_78;
  tmpvar_78.x = dot ((tmpvar_70 * tmpvar_75.x), tmpvar_20);
  tmpvar_78.y = dot ((tmpvar_71 * tmpvar_75.y), tmpvar_25);
  tmpvar_78.z = dot ((tmpvar_72 * tmpvar_75.z), tmpvar_26);
  tmpvar_78.w = dot ((tmpvar_73 * tmpvar_75.w), tmpvar_27);
  tmpvar_17 = (42.0 * dot ((m_18 * m_18), tmpvar_78));
  highp float tmpvar_79;
  highp vec3 v_80;
  v_80 = (_NoiseScale.x * tmpvar_16);
  highp vec4 m_81;
  highp vec3 tmpvar_82;
  tmpvar_82 = floor((v_80 + dot (v_80, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_83;
  tmpvar_83 = ((v_80 - tmpvar_82) + dot (tmpvar_82, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_84;
  tmpvar_84.x = float((tmpvar_83.x >= tmpvar_83.y));
  tmpvar_84.y = float((tmpvar_83.y >= tmpvar_83.z));
  tmpvar_84.z = float((tmpvar_83.z >= tmpvar_83.x));
  highp vec3 tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_84);
  highp vec3 tmpvar_86;
  tmpvar_86 = min (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_87;
  tmpvar_87 = max (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_88;
  tmpvar_88 = ((tmpvar_83 - tmpvar_86) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_89;
  tmpvar_89 = ((tmpvar_83 - tmpvar_87) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_90;
  tmpvar_90 = (tmpvar_83 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_91;
  tmpvar_91 = (tmpvar_82 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = (fract(abs(tmpvar_91)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_93;
  if ((tmpvar_91.x >= 0.0)) {
    tmpvar_93 = tmpvar_92.x;
  } else {
    tmpvar_93 = -(tmpvar_92.x);
  };
  highp float tmpvar_94;
  if ((tmpvar_91.y >= 0.0)) {
    tmpvar_94 = tmpvar_92.y;
  } else {
    tmpvar_94 = -(tmpvar_92.y);
  };
  highp float tmpvar_95;
  if ((tmpvar_91.z >= 0.0)) {
    tmpvar_95 = tmpvar_92.z;
  } else {
    tmpvar_95 = -(tmpvar_92.z);
  };
  highp vec4 tmpvar_96;
  tmpvar_96.xw = vec2(0.0, 1.0);
  tmpvar_96.y = tmpvar_86.z;
  tmpvar_96.z = tmpvar_87.z;
  highp vec4 x_97;
  x_97 = (tmpvar_95 + tmpvar_96);
  highp vec4 tmpvar_98;
  tmpvar_98 = (((
    (x_97 * x_97)
   * 34.0) + x_97) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_99;
  tmpvar_99 = (fract(abs(tmpvar_98)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_100;
  if ((tmpvar_98.x >= 0.0)) {
    tmpvar_100 = tmpvar_99.x;
  } else {
    tmpvar_100 = -(tmpvar_99.x);
  };
  highp float tmpvar_101;
  if ((tmpvar_98.y >= 0.0)) {
    tmpvar_101 = tmpvar_99.y;
  } else {
    tmpvar_101 = -(tmpvar_99.y);
  };
  highp float tmpvar_102;
  if ((tmpvar_98.z >= 0.0)) {
    tmpvar_102 = tmpvar_99.z;
  } else {
    tmpvar_102 = -(tmpvar_99.z);
  };
  highp float tmpvar_103;
  if ((tmpvar_98.w >= 0.0)) {
    tmpvar_103 = tmpvar_99.w;
  } else {
    tmpvar_103 = -(tmpvar_99.w);
  };
  highp vec4 tmpvar_104;
  tmpvar_104.x = tmpvar_100;
  tmpvar_104.y = tmpvar_101;
  tmpvar_104.z = tmpvar_102;
  tmpvar_104.w = tmpvar_103;
  highp vec4 tmpvar_105;
  tmpvar_105.xw = vec2(0.0, 1.0);
  tmpvar_105.y = tmpvar_86.y;
  tmpvar_105.z = tmpvar_87.y;
  highp vec4 x_106;
  x_106 = ((tmpvar_104 + tmpvar_94) + tmpvar_105);
  highp vec4 tmpvar_107;
  tmpvar_107 = (((
    (x_106 * x_106)
   * 34.0) + x_106) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_108;
  tmpvar_108 = (fract(abs(tmpvar_107)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_109;
  if ((tmpvar_107.x >= 0.0)) {
    tmpvar_109 = tmpvar_108.x;
  } else {
    tmpvar_109 = -(tmpvar_108.x);
  };
  highp float tmpvar_110;
  if ((tmpvar_107.y >= 0.0)) {
    tmpvar_110 = tmpvar_108.y;
  } else {
    tmpvar_110 = -(tmpvar_108.y);
  };
  highp float tmpvar_111;
  if ((tmpvar_107.z >= 0.0)) {
    tmpvar_111 = tmpvar_108.z;
  } else {
    tmpvar_111 = -(tmpvar_108.z);
  };
  highp float tmpvar_112;
  if ((tmpvar_107.w >= 0.0)) {
    tmpvar_112 = tmpvar_108.w;
  } else {
    tmpvar_112 = -(tmpvar_108.w);
  };
  highp vec4 tmpvar_113;
  tmpvar_113.x = tmpvar_109;
  tmpvar_113.y = tmpvar_110;
  tmpvar_113.z = tmpvar_111;
  tmpvar_113.w = tmpvar_112;
  highp vec4 tmpvar_114;
  tmpvar_114.xw = vec2(0.0, 1.0);
  tmpvar_114.y = tmpvar_86.x;
  tmpvar_114.z = tmpvar_87.x;
  highp vec4 x_115;
  x_115 = ((tmpvar_113 + tmpvar_93) + tmpvar_114);
  highp vec4 tmpvar_116;
  tmpvar_116 = (((
    (x_115 * x_115)
   * 34.0) + x_115) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_117;
  tmpvar_117 = (fract(abs(tmpvar_116)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_118;
  if ((tmpvar_116.x >= 0.0)) {
    tmpvar_118 = tmpvar_117.x;
  } else {
    tmpvar_118 = -(tmpvar_117.x);
  };
  highp float tmpvar_119;
  if ((tmpvar_116.y >= 0.0)) {
    tmpvar_119 = tmpvar_117.y;
  } else {
    tmpvar_119 = -(tmpvar_117.y);
  };
  highp float tmpvar_120;
  if ((tmpvar_116.z >= 0.0)) {
    tmpvar_120 = tmpvar_117.z;
  } else {
    tmpvar_120 = -(tmpvar_117.z);
  };
  highp float tmpvar_121;
  if ((tmpvar_116.w >= 0.0)) {
    tmpvar_121 = tmpvar_117.w;
  } else {
    tmpvar_121 = -(tmpvar_117.w);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.x = tmpvar_118;
  tmpvar_122.y = tmpvar_119;
  tmpvar_122.z = tmpvar_120;
  tmpvar_122.w = tmpvar_121;
  highp vec4 tmpvar_123;
  tmpvar_123 = (tmpvar_122 - (49.0 * floor(
    (0.02040815 * tmpvar_122)
  )));
  highp vec4 tmpvar_124;
  tmpvar_124 = floor((tmpvar_123 * 0.1428571));
  highp vec4 tmpvar_125;
  tmpvar_125 = ((tmpvar_124 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_126;
  tmpvar_126 = ((floor(
    (tmpvar_123 - (7.0 * tmpvar_124))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_127;
  tmpvar_127 = ((1.0 - abs(tmpvar_125)) - abs(tmpvar_126));
  highp vec4 tmpvar_128;
  tmpvar_128.xy = tmpvar_125.xy;
  tmpvar_128.zw = tmpvar_126.xy;
  highp vec4 tmpvar_129;
  tmpvar_129.xy = tmpvar_125.zw;
  tmpvar_129.zw = tmpvar_126.zw;
  highp vec4 tmpvar_130;
  tmpvar_130 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_127)));
  highp vec4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_130.xxyy));
  highp vec4 tmpvar_132;
  tmpvar_132 = (tmpvar_129.xzyw + ((
    (floor(tmpvar_129) * 2.0)
   + 1.0).xzyw * tmpvar_130.zzww));
  highp vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_131.xy;
  tmpvar_133.z = tmpvar_127.x;
  highp vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.zw;
  tmpvar_134.z = tmpvar_127.y;
  highp vec3 tmpvar_135;
  tmpvar_135.xy = tmpvar_132.xy;
  tmpvar_135.z = tmpvar_127.z;
  highp vec3 tmpvar_136;
  tmpvar_136.xy = tmpvar_132.zw;
  tmpvar_136.z = tmpvar_127.w;
  highp vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_133, tmpvar_133);
  tmpvar_137.y = dot (tmpvar_134, tmpvar_134);
  tmpvar_137.z = dot (tmpvar_135, tmpvar_135);
  tmpvar_137.w = dot (tmpvar_136, tmpvar_136);
  highp vec4 tmpvar_138;
  tmpvar_138 = (1.792843 - (0.8537347 * tmpvar_137));
  highp vec4 tmpvar_139;
  tmpvar_139.x = dot (tmpvar_83, tmpvar_83);
  tmpvar_139.y = dot (tmpvar_88, tmpvar_88);
  tmpvar_139.z = dot (tmpvar_89, tmpvar_89);
  tmpvar_139.w = dot (tmpvar_90, tmpvar_90);
  highp vec4 tmpvar_140;
  tmpvar_140 = max ((0.6 - tmpvar_139), vec4(0.0, 0.0, 0.0, 0.0));
  m_81 = (tmpvar_140 * tmpvar_140);
  highp vec4 tmpvar_141;
  tmpvar_141.x = dot ((tmpvar_133 * tmpvar_138.x), tmpvar_83);
  tmpvar_141.y = dot ((tmpvar_134 * tmpvar_138.y), tmpvar_88);
  tmpvar_141.z = dot ((tmpvar_135 * tmpvar_138.z), tmpvar_89);
  tmpvar_141.w = dot ((tmpvar_136 * tmpvar_138.w), tmpvar_90);
  tmpvar_79 = (42.0 * dot ((m_81 * m_81), tmpvar_141));
  highp vec3 v_142;
  v_142 = (_NoiseScale.y * tmpvar_16);
  highp vec4 m_143;
  highp vec3 tmpvar_144;
  tmpvar_144 = floor((v_142 + dot (v_142, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_145;
  tmpvar_145 = ((v_142 - tmpvar_144) + dot (tmpvar_144, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_146;
  tmpvar_146.x = float((tmpvar_145.x >= tmpvar_145.y));
  tmpvar_146.y = float((tmpvar_145.y >= tmpvar_145.z));
  tmpvar_146.z = float((tmpvar_145.z >= tmpvar_145.x));
  highp vec3 tmpvar_147;
  tmpvar_147 = (1.0 - tmpvar_146);
  highp vec3 tmpvar_148;
  tmpvar_148 = min (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_149;
  tmpvar_149 = max (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_150;
  tmpvar_150 = ((tmpvar_145 - tmpvar_148) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_151;
  tmpvar_151 = ((tmpvar_145 - tmpvar_149) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_152;
  tmpvar_152 = (tmpvar_145 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_153;
  tmpvar_153 = (tmpvar_144 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_154;
  tmpvar_154 = (fract(abs(tmpvar_153)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_155;
  if ((tmpvar_153.x >= 0.0)) {
    tmpvar_155 = tmpvar_154.x;
  } else {
    tmpvar_155 = -(tmpvar_154.x);
  };
  highp float tmpvar_156;
  if ((tmpvar_153.y >= 0.0)) {
    tmpvar_156 = tmpvar_154.y;
  } else {
    tmpvar_156 = -(tmpvar_154.y);
  };
  highp float tmpvar_157;
  if ((tmpvar_153.z >= 0.0)) {
    tmpvar_157 = tmpvar_154.z;
  } else {
    tmpvar_157 = -(tmpvar_154.z);
  };
  highp vec4 tmpvar_158;
  tmpvar_158.xw = vec2(0.0, 1.0);
  tmpvar_158.y = tmpvar_148.z;
  tmpvar_158.z = tmpvar_149.z;
  highp vec4 x_159;
  x_159 = (tmpvar_157 + tmpvar_158);
  highp vec4 tmpvar_160;
  tmpvar_160 = (((
    (x_159 * x_159)
   * 34.0) + x_159) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_161;
  tmpvar_161 = (fract(abs(tmpvar_160)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_162;
  if ((tmpvar_160.x >= 0.0)) {
    tmpvar_162 = tmpvar_161.x;
  } else {
    tmpvar_162 = -(tmpvar_161.x);
  };
  highp float tmpvar_163;
  if ((tmpvar_160.y >= 0.0)) {
    tmpvar_163 = tmpvar_161.y;
  } else {
    tmpvar_163 = -(tmpvar_161.y);
  };
  highp float tmpvar_164;
  if ((tmpvar_160.z >= 0.0)) {
    tmpvar_164 = tmpvar_161.z;
  } else {
    tmpvar_164 = -(tmpvar_161.z);
  };
  highp float tmpvar_165;
  if ((tmpvar_160.w >= 0.0)) {
    tmpvar_165 = tmpvar_161.w;
  } else {
    tmpvar_165 = -(tmpvar_161.w);
  };
  highp vec4 tmpvar_166;
  tmpvar_166.x = tmpvar_162;
  tmpvar_166.y = tmpvar_163;
  tmpvar_166.z = tmpvar_164;
  tmpvar_166.w = tmpvar_165;
  highp vec4 tmpvar_167;
  tmpvar_167.xw = vec2(0.0, 1.0);
  tmpvar_167.y = tmpvar_148.y;
  tmpvar_167.z = tmpvar_149.y;
  highp vec4 x_168;
  x_168 = ((tmpvar_166 + tmpvar_156) + tmpvar_167);
  highp vec4 tmpvar_169;
  tmpvar_169 = (((
    (x_168 * x_168)
   * 34.0) + x_168) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_170;
  tmpvar_170 = (fract(abs(tmpvar_169)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_171;
  if ((tmpvar_169.x >= 0.0)) {
    tmpvar_171 = tmpvar_170.x;
  } else {
    tmpvar_171 = -(tmpvar_170.x);
  };
  highp float tmpvar_172;
  if ((tmpvar_169.y >= 0.0)) {
    tmpvar_172 = tmpvar_170.y;
  } else {
    tmpvar_172 = -(tmpvar_170.y);
  };
  highp float tmpvar_173;
  if ((tmpvar_169.z >= 0.0)) {
    tmpvar_173 = tmpvar_170.z;
  } else {
    tmpvar_173 = -(tmpvar_170.z);
  };
  highp float tmpvar_174;
  if ((tmpvar_169.w >= 0.0)) {
    tmpvar_174 = tmpvar_170.w;
  } else {
    tmpvar_174 = -(tmpvar_170.w);
  };
  highp vec4 tmpvar_175;
  tmpvar_175.x = tmpvar_171;
  tmpvar_175.y = tmpvar_172;
  tmpvar_175.z = tmpvar_173;
  tmpvar_175.w = tmpvar_174;
  highp vec4 tmpvar_176;
  tmpvar_176.xw = vec2(0.0, 1.0);
  tmpvar_176.y = tmpvar_148.x;
  tmpvar_176.z = tmpvar_149.x;
  highp vec4 x_177;
  x_177 = ((tmpvar_175 + tmpvar_155) + tmpvar_176);
  highp vec4 tmpvar_178;
  tmpvar_178 = (((
    (x_177 * x_177)
   * 34.0) + x_177) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_179;
  tmpvar_179 = (fract(abs(tmpvar_178)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_180;
  if ((tmpvar_178.x >= 0.0)) {
    tmpvar_180 = tmpvar_179.x;
  } else {
    tmpvar_180 = -(tmpvar_179.x);
  };
  highp float tmpvar_181;
  if ((tmpvar_178.y >= 0.0)) {
    tmpvar_181 = tmpvar_179.y;
  } else {
    tmpvar_181 = -(tmpvar_179.y);
  };
  highp float tmpvar_182;
  if ((tmpvar_178.z >= 0.0)) {
    tmpvar_182 = tmpvar_179.z;
  } else {
    tmpvar_182 = -(tmpvar_179.z);
  };
  highp float tmpvar_183;
  if ((tmpvar_178.w >= 0.0)) {
    tmpvar_183 = tmpvar_179.w;
  } else {
    tmpvar_183 = -(tmpvar_179.w);
  };
  highp vec4 tmpvar_184;
  tmpvar_184.x = tmpvar_180;
  tmpvar_184.y = tmpvar_181;
  tmpvar_184.z = tmpvar_182;
  tmpvar_184.w = tmpvar_183;
  highp vec4 tmpvar_185;
  tmpvar_185 = (tmpvar_184 - (49.0 * floor(
    (0.02040815 * tmpvar_184)
  )));
  highp vec4 tmpvar_186;
  tmpvar_186 = floor((tmpvar_185 * 0.1428571));
  highp vec4 tmpvar_187;
  tmpvar_187 = ((tmpvar_186 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_188;
  tmpvar_188 = ((floor(
    (tmpvar_185 - (7.0 * tmpvar_186))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_189;
  tmpvar_189 = ((1.0 - abs(tmpvar_187)) - abs(tmpvar_188));
  highp vec4 tmpvar_190;
  tmpvar_190.xy = tmpvar_187.xy;
  tmpvar_190.zw = tmpvar_188.xy;
  highp vec4 tmpvar_191;
  tmpvar_191.xy = tmpvar_187.zw;
  tmpvar_191.zw = tmpvar_188.zw;
  highp vec4 tmpvar_192;
  tmpvar_192 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_189)));
  highp vec4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_192.xxyy));
  highp vec4 tmpvar_194;
  tmpvar_194 = (tmpvar_191.xzyw + ((
    (floor(tmpvar_191) * 2.0)
   + 1.0).xzyw * tmpvar_192.zzww));
  highp vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_193.xy;
  tmpvar_195.z = tmpvar_189.x;
  highp vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.zw;
  tmpvar_196.z = tmpvar_189.y;
  highp vec3 tmpvar_197;
  tmpvar_197.xy = tmpvar_194.xy;
  tmpvar_197.z = tmpvar_189.z;
  highp vec3 tmpvar_198;
  tmpvar_198.xy = tmpvar_194.zw;
  tmpvar_198.z = tmpvar_189.w;
  highp vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_195, tmpvar_195);
  tmpvar_199.y = dot (tmpvar_196, tmpvar_196);
  tmpvar_199.z = dot (tmpvar_197, tmpvar_197);
  tmpvar_199.w = dot (tmpvar_198, tmpvar_198);
  highp vec4 tmpvar_200;
  tmpvar_200 = (1.792843 - (0.8537347 * tmpvar_199));
  highp vec4 tmpvar_201;
  tmpvar_201.x = dot (tmpvar_145, tmpvar_145);
  tmpvar_201.y = dot (tmpvar_150, tmpvar_150);
  tmpvar_201.z = dot (tmpvar_151, tmpvar_151);
  tmpvar_201.w = dot (tmpvar_152, tmpvar_152);
  highp vec4 tmpvar_202;
  tmpvar_202 = max ((0.6 - tmpvar_201), vec4(0.0, 0.0, 0.0, 0.0));
  m_143 = (tmpvar_202 * tmpvar_202);
  highp vec4 tmpvar_203;
  tmpvar_203.x = dot ((tmpvar_195 * tmpvar_200.x), tmpvar_145);
  tmpvar_203.y = dot ((tmpvar_196 * tmpvar_200.y), tmpvar_150);
  tmpvar_203.z = dot ((tmpvar_197 * tmpvar_200.z), tmpvar_151);
  tmpvar_203.w = dot ((tmpvar_198 * tmpvar_200.w), tmpvar_152);
  highp vec3 tmpvar_204;
  tmpvar_204.x = tmpvar_17;
  tmpvar_204.y = tmpvar_79;
  tmpvar_204.z = (42.0 * dot ((m_143 * m_143), tmpvar_203));
  highp vec3 tmpvar_205;
  tmpvar_205 = (0.5 * (tmpvar_204 + 1.0));
  localOrigin_7.xyz = (((2.0 * tmpvar_205) - 1.0) * _MaxTrans);
  localOrigin_7.w = 1.0;
  highp float tmpvar_206;
  tmpvar_206 = ((tmpvar_205.x * (_MaxScale - 1.0)) + 1.0);
  origin_9 = (_Object2World * localOrigin_7);
  planet_pos_8 = (_MainRotation * origin_9);
  highp vec3 tmpvar_207;
  tmpvar_207 = (_DetailRotation * planet_pos_8).xyz;
  tmpvar_13 = planet_pos_8.xyz;
  highp vec3 tmpvar_208;
  tmpvar_208 = normalize(planet_pos_8.xyz);
  highp vec2 uv_209;
  highp float tmpvar_210;
  highp float tmpvar_211;
  tmpvar_211 = (min (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0) / max (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0));
  highp float tmpvar_212;
  tmpvar_212 = (tmpvar_211 * tmpvar_211);
  tmpvar_212 = (((
    ((((
      ((((-0.01213232 * tmpvar_212) + 0.05368138) * tmpvar_212) - 0.1173503)
     * tmpvar_212) + 0.1938925) * tmpvar_212) - 0.3326756)
   * tmpvar_212) + 0.9999793) * tmpvar_211);
  tmpvar_212 = (tmpvar_212 + (float(
    (abs((tmpvar_208.x / tmpvar_208.z)) > 1.0)
  ) * (
    (tmpvar_212 * -2.0)
   + 1.570796)));
  tmpvar_210 = (tmpvar_212 * sign((tmpvar_208.x / tmpvar_208.z)));
  if ((abs(tmpvar_208.z) > (1e-08 * abs(tmpvar_208.x)))) {
    if ((tmpvar_208.z < 0.0)) {
      if ((tmpvar_208.x >= 0.0)) {
        tmpvar_210 += 3.141593;
      } else {
        tmpvar_210 = (tmpvar_210 - 3.141593);
      };
    };
  } else {
    tmpvar_210 = (sign(tmpvar_208.x) * 1.570796);
  };
  uv_209.x = (0.5 + (0.1591549 * tmpvar_210));
  uv_209.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_208.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_208.y)
    )) * (1.570796 + (
      abs(tmpvar_208.y)
     * 
      (-0.2146018 + (abs(tmpvar_208.y) * (0.08656672 + (
        abs(tmpvar_208.y)
       * -0.03102955))))
    ))))
  )));
  lowp vec4 tmpvar_213;
  tmpvar_213 = texture2DLod (_MainTex, uv_209, 0.0);
  mediump vec4 tmpvar_214;
  tmpvar_214 = tmpvar_213;
  tmpvar_10 = tmpvar_214;
  mediump vec3 detailCoords_215;
  mediump float s_216;
  mediump float nylerp_217;
  mediump float zxlerp_218;
  highp vec4 uv4_219;
  uv4_219.zw = vec2(0.0, 0.0);
  highp vec3 tmpvar_220;
  tmpvar_220 = normalize(tmpvar_207);
  highp vec3 tmpvar_221;
  tmpvar_221 = abs(tmpvar_220);
  highp float tmpvar_222;
  tmpvar_222 = float((tmpvar_221.z >= tmpvar_221.x));
  zxlerp_218 = tmpvar_222;
  highp float tmpvar_223;
  tmpvar_223 = float((max (tmpvar_221.x, tmpvar_221.z) >= tmpvar_221.y));
  nylerp_217 = tmpvar_223;
  highp float tmpvar_224;
  tmpvar_224 = mix (tmpvar_220.x, tmpvar_220.z, zxlerp_218);
  s_216 = tmpvar_224;
  highp float tmpvar_225;
  tmpvar_225 = sign(mix (tmpvar_220.y, s_216, nylerp_217));
  s_216 = tmpvar_225;
  mediump vec3 tmpvar_226;
  tmpvar_226.xz = vec2(1.0, -1.0);
  tmpvar_226.y = -(s_216);
  mediump vec3 tmpvar_227;
  tmpvar_227.xz = vec2(1.0, -1.0);
  tmpvar_227.y = s_216;
  highp vec3 tmpvar_228;
  tmpvar_228 = mix ((tmpvar_226 * tmpvar_220.xzy), (tmpvar_227 * tmpvar_220.zxy), vec3(zxlerp_218));
  detailCoords_215 = tmpvar_228;
  mediump vec3 tmpvar_229;
  tmpvar_229.xy = vec2(1.0, 1.0);
  tmpvar_229.z = s_216;
  highp vec3 tmpvar_230;
  tmpvar_230 = mix ((tmpvar_229 * tmpvar_220.yxz), detailCoords_215, vec3(nylerp_217));
  detailCoords_215 = tmpvar_230;
  mediump vec2 tmpvar_231;
  tmpvar_231 = (((0.5 * detailCoords_215.yz) / abs(detailCoords_215.x)) + 0.5);
  uv4_219.xy = tmpvar_231;
  lowp vec4 tmpvar_232;
  tmpvar_232 = texture2DLod (_DetailTex, uv4_219.xy, 0.0);
  mediump vec4 tmpvar_233;
  tmpvar_233 = tmpvar_232;
  tmpvar_10 = (tmpvar_10 * tmpvar_233);
  highp vec4 tmpvar_234;
  tmpvar_234.w = 0.0;
  tmpvar_234.xyz = _WorldSpaceCameraPos;
  highp float tmpvar_235;
  highp vec4 tmpvar_236;
  tmpvar_236 = (origin_9 - tmpvar_234);
  tmpvar_235 = sqrt(dot (tmpvar_236, tmpvar_236));
  highp float tmpvar_237;
  tmpvar_237 = (clamp ((_DistFade * tmpvar_235), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_235)
  ), 0.0, 1.0));
  tmpvar_11.w = tmpvar_237;
  tmpvar_10.w = (tmpvar_10.w * tmpvar_11.w);
  highp vec3 tmpvar_238;
  tmpvar_238.yz = vec2(0.0, 0.0);
  tmpvar_238.x = fract(_Rotation);
  highp vec3 x_239;
  x_239 = (tmpvar_238 + tmpvar_205);
  highp vec3 trans_240;
  trans_240 = localOrigin_7.xyz;
  highp float tmpvar_241;
  tmpvar_241 = (x_239.x * 6.283185);
  highp float tmpvar_242;
  tmpvar_242 = (x_239.y * 6.283185);
  highp float tmpvar_243;
  tmpvar_243 = (x_239.z * 2.0);
  highp float tmpvar_244;
  tmpvar_244 = sqrt(tmpvar_243);
  highp float tmpvar_245;
  tmpvar_245 = (sin(tmpvar_242) * tmpvar_244);
  highp float tmpvar_246;
  tmpvar_246 = (cos(tmpvar_242) * tmpvar_244);
  highp float tmpvar_247;
  tmpvar_247 = sqrt((2.0 - tmpvar_243));
  highp float tmpvar_248;
  tmpvar_248 = sin(tmpvar_241);
  highp float tmpvar_249;
  tmpvar_249 = cos(tmpvar_241);
  highp float tmpvar_250;
  tmpvar_250 = ((tmpvar_245 * tmpvar_249) - (tmpvar_246 * tmpvar_248));
  highp float tmpvar_251;
  tmpvar_251 = ((tmpvar_245 * tmpvar_248) + (tmpvar_246 * tmpvar_249));
  highp mat4 tmpvar_252;
  tmpvar_252[0].x = (tmpvar_206 * ((tmpvar_245 * tmpvar_250) - tmpvar_249));
  tmpvar_252[0].y = ((tmpvar_245 * tmpvar_251) - tmpvar_248);
  tmpvar_252[0].z = (tmpvar_245 * tmpvar_247);
  tmpvar_252[0].w = 0.0;
  tmpvar_252[1].x = ((tmpvar_246 * tmpvar_250) + tmpvar_248);
  tmpvar_252[1].y = (tmpvar_206 * ((tmpvar_246 * tmpvar_251) - tmpvar_249));
  tmpvar_252[1].z = (tmpvar_246 * tmpvar_247);
  tmpvar_252[1].w = 0.0;
  tmpvar_252[2].x = (tmpvar_247 * tmpvar_250);
  tmpvar_252[2].y = (tmpvar_247 * tmpvar_251);
  tmpvar_252[2].z = (tmpvar_206 * (1.0 - tmpvar_243));
  tmpvar_252[2].w = 0.0;
  tmpvar_252[3].x = trans_240.x;
  tmpvar_252[3].y = trans_240.y;
  tmpvar_252[3].z = trans_240.z;
  tmpvar_252[3].w = 1.0;
  highp mat4 tmpvar_253;
  tmpvar_253 = ((unity_MatrixV * _Object2World) * tmpvar_252);
  highp vec4 v_254;
  v_254.x = tmpvar_253[0].z;
  v_254.y = tmpvar_253[1].z;
  v_254.z = tmpvar_253[2].z;
  v_254.w = tmpvar_253[3].z;
  highp vec3 tmpvar_255;
  tmpvar_255 = normalize(v_254.xyz);
  highp vec3 tmpvar_256;
  tmpvar_256 = abs(tmpvar_255);
  tmpvar_11.xyz = tmpvar_256;
  highp vec4 tmpvar_257;
  tmpvar_257 = (glstate_matrix_modelview0 * localOrigin_7);
  highp vec4 tmpvar_258;
  tmpvar_258.xyz = (_glesVertex.xyz * tmpvar_206);
  tmpvar_258.w = tmpvar_1.w;
  highp vec2 tmpvar_259;
  tmpvar_259 = ((2.0 * _glesMultiTexCoord0.xy) - 1.0);
  highp vec4 tmpvar_260;
  tmpvar_260.z = 0.0;
  tmpvar_260.xy = tmpvar_259;
  tmpvar_260.w = tmpvar_1.w;
  ZYv_6.xyw = tmpvar_260.zyw;
  XZv_5.yzw = tmpvar_260.zyw;
  XYv_4.yzw = tmpvar_260.yzw;
  ZYv_6.z = (tmpvar_259.x * sign(-(tmpvar_255.x)));
  XZv_5.x = (tmpvar_259.x * sign(-(tmpvar_255.y)));
  XYv_4.x = (tmpvar_259.x * sign(tmpvar_255.z));
  ZYv_6.x = ((sign(
    -(tmpvar_255.x)
  ) * sign(ZYv_6.z)) * tmpvar_255.z);
  XZv_5.y = ((sign(
    -(tmpvar_255.y)
  ) * sign(XZv_5.x)) * tmpvar_255.x);
  XYv_4.z = ((sign(
    -(tmpvar_255.z)
  ) * sign(XYv_4.x)) * tmpvar_255.x);
  ZYv_6.x = (ZYv_6.x + ((
    sign(-(tmpvar_255.x))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  XZv_5.y = (XZv_5.y + ((
    sign(-(tmpvar_255.y))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.z));
  XYv_4.z = (XYv_4.z + ((
    sign(-(tmpvar_255.z))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  highp vec3 tmpvar_261;
  tmpvar_261 = normalize((origin_9.xyz - _WorldSpaceCameraPos));
  highp vec3 tmpvar_262;
  tmpvar_262 = normalize(-(tmpvar_261));
  normal_3 = tmpvar_262;
  highp vec4 v_263;
  v_263.x = unity_MatrixV[0].x;
  v_263.y = unity_MatrixV[1].x;
  v_263.z = unity_MatrixV[2].x;
  v_263.w = unity_MatrixV[3].x;
  highp vec3 tmpvar_264;
  tmpvar_264 = normalize(v_263.xyz);
  highp vec3 tmpvar_265;
  highp vec3 tmpvar_266;
  tmpvar_265 = v_263.xyz;
  tmpvar_266 = ((normal_3.zxy * tmpvar_264.yzx) - (normal_3.yzx * tmpvar_264.zxy));
  highp vec3 tmpvar_267;
  tmpvar_267 = normal_3;
  highp mat3 tmpvar_268;
  tmpvar_268[0].x = tmpvar_265.x;
  tmpvar_268[0].y = tmpvar_266.x;
  tmpvar_268[0].z = tmpvar_267.x;
  tmpvar_268[1].x = tmpvar_265.y;
  tmpvar_268[1].y = tmpvar_266.y;
  tmpvar_268[1].z = tmpvar_267.y;
  tmpvar_268[2].x = tmpvar_265.z;
  tmpvar_268[2].y = tmpvar_266.z;
  tmpvar_268[2].z = tmpvar_267.z;
  gl_Position = (glstate_matrix_projection * (tmpvar_257 + tmpvar_258));
  xlv_COLOR = tmpvar_10;
  xlv_TEXCOORD0 = tmpvar_11;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * ZYv_6)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XZv_5)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XYv_4)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD4 = tmpvar_2;
  xlv_TEXCOORD5 = tmpvar_12;
  xlv_TEXCOORD6 = tmpvar_13;
  xlv_TEXCOORD7 = normalize((tmpvar_268 * tmpvar_261));
  xlv_TEXCOORD8 = normalize((tmpvar_268 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shadow_samplers : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D _Tex;
uniform lowp vec4 _Color;
uniform highp float _MinScatter;
uniform highp float _Opacity;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec3 normT_2;
  mediump vec4 color_3;
  mediump vec4 tex_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_Tex, xlv_TEXCOORD1);
  tex_4.x = tmpvar_5.x;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex, xlv_TEXCOORD2);
  tex_4.y = tmpvar_6.y;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex, xlv_TEXCOORD3);
  tex_4.z = tmpvar_7.z;
  tex_4.w = 0.0;
  tex_4.xyz = (tex_4.xyz * xlv_TEXCOORD0.xyz);
  tex_4 = (tex_4 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  mediump float tmpvar_8;
  tmpvar_8 = ((tex_4.x + tex_4.y) + (tex_4.z + tex_4.w));
  mediump vec4 tmpvar_9;
  tmpvar_9.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_9.w = tmpvar_8;
  tex_4.xyz = tmpvar_9.xyz;
  color_3 = (_Color * xlv_COLOR);
  normT_2.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_2.z = sqrt((1.0 - clamp (
    dot (normT_2.xy, normT_2.xy)
  , 0.0, 1.0)));
  color_3.w = (color_3.w * tmpvar_8);
  tex_4.w = (xlv_TEXCOORD0.w * tmpvar_8);
  mediump vec3 lightDir_10;
  lightDir_10 = xlv_TEXCOORD8;
  mediump vec3 viewDir_11;
  viewDir_11 = xlv_TEXCOORD7;
  mediump vec4 c_12;
  highp float h_13;
  mediump vec3 tmpvar_14;
  tmpvar_14 = normalize(lightDir_10);
  lightDir_10 = tmpvar_14;
  mediump vec3 tmpvar_15;
  tmpvar_15 = normalize(viewDir_11);
  viewDir_11 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16 = normalize(normT_2);
  mediump float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_16, tmpvar_14), 0.0);
  mediump float tmpvar_18;
  tmpvar_18 = (0.5 + (0.5 * dot (tmpvar_15, tmpvar_14)));
  h_13 = tmpvar_18;
  mediump float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, tmpvar_15);
  highp float tmpvar_20;
  tmpvar_20 = clamp (((
    (_MinScatter - (_Opacity * tex_4.w))
   * 
    (1.0 - tmpvar_19)
  ) * h_13), 0.0, 1.0);
  c_12.xyz = ((_LightColor0.xyz * (vec3(tmpvar_17) + tmpvar_20)) * 2.0);
  c_12.w = (tmpvar_17 * 2.0);
  color_3.xyz = (color_3.xyz * c_12.xyz);
  tmpvar_1 = color_3;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 in_POSITION0;
in highp vec2 in_TEXCOORD0;
out lowp vec4 vs_COLOR0;
out mediump vec4 vs_TEXCOORD0;
out highp vec2 vs_TEXCOORD1;
out highp vec2 vs_TEXCOORD2;
out highp vec2 vs_TEXCOORD3;
out highp vec2 vs_TEXCOORD4;
out highp vec4 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD7;
out highp vec3 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
bvec4 tb1;
highp vec4 t2;
highp vec4 t3;
bvec3 tb3;
highp vec4 t4;
mediump vec4 t16_4;
bvec4 tb4;
highp vec4 t5;
highp ivec3 ti5;
bvec4 tb5;
highp vec4 t6;
bvec3 tb6;
highp vec4 t7;
bvec4 tb7;
highp vec4 t8;
highp ivec3 ti8;
highp vec4 t9;
bvec4 tb9;
highp vec4 t10;
bvec4 tb10;
highp vec4 t11;
bvec4 tb11;
highp vec4 t12;
highp vec4 t13;
mediump vec3 t16_14;
mediump vec3 t16_15;
highp float t17;
highp float t22;
highp ivec3 ti22;
highp vec3 t24;
highp vec2 t32;
highp int ti32;
highp vec2 t33;
highp int ti33;
highp vec2 t35;
highp ivec2 ti35;
bvec2 tb35;
highp float t48;
highp int ti48;
highp float t49;
highp int ti49;
bool tb49;
highp float t50;
highp int ti50;
bool tb50;
highp float t51;
highp int ti51;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t50 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t50);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t50 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t50) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t48 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t48);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t48 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t48) + t6.xyz;
    t48 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t48);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t48 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t48) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t48 = dot(t1, t6);
    t0.x = t48 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t48 = t1.x * 0.5;
    t49 = _MaxScale + -1.0;
    t48 = t48 * t49 + 1.0;
    t2.xyz = vec3(t48) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t49 = dot(t5.xyz, t5.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t5.xyz;
    t50 = t5.z * t49 + (-t6.y);
    tb35.x = abs(t6.z)>=abs(t6.y);
    t35.x = tb35.x ? 1.0 : float(0.0);
    t50 = t35.x * t50 + t6.y;
    t49 = (-t5.x) * t49 + t50;
    t50 = max(abs(t6.z), abs(t6.y));
    tb50 = t50>=abs(t6.x);
    t50 = tb50 ? 1.0 : float(0.0);
    t49 = t50 * t49 + t6.x;
    ti51 = int((0.0<t49) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t49<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti49 = (-ti51) + ti49;
    t16_14.y = float(ti49);
    t16_15.y = (-t16_14.y);
    t16_15.xz = vec2(1.0, -1.0);
    t5.xyz = t6.yzx * t16_15.xyz;
    t16_14.xz = vec2(1.0, -1.0);
    t7.xyz = t16_14.xyz * t6.zyx + (-t5.xyz);
    t5.xyz = t35.xxx * t7.xyz + t5.xyz;
    t5.xyz = (-t16_14.xxy) * t6.xyz + t5.xyz;
    t6.xyz = t6.xyz * t16_14.xxy;
    t5.xyz = vec3(t50) * t5.xyz + t6.xyz;
    t16_14.xy = vec2(t5.y * float(0.5), t5.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t5.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t16_14.xy, 0.0);
    t49 = dot(t4.xyz, t4.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb49 = abs(t6.y)<abs(t6.x);
    t50 = max(abs(t6.y), abs(t6.x));
    t50 = float(1.0) / t50;
    t35.x = min(abs(t6.y), abs(t6.x));
    t50 = t50 * t35.x;
    t35.x = t50 * t50;
    t51 = t35.x * 0.0208350997 + -0.0851330012;
    t51 = t35.x * t51 + 0.180141002;
    t51 = t35.x * t51 + -0.330299497;
    t35.x = t35.x * t51 + 0.999866009;
    t51 = t50 * t35.x;
    t51 = t51 * -2.0 + 1.57079637;
    t49 = tb49 ? t51 : float(0.0);
    t49 = t50 * t35.x + t49;
    tb35.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t50 = tb35.x ? -3.14159274 : float(0.0);
    t49 = t49 + t50;
    t50 = min(t6.y, t6.x);
    tb50 = t50<(-t50);
    t35.x = max(t6.y, t6.x);
    tb35.x = t35.x>=(-t35.x);
    ti50 = int(uint(tb50) * 0xffffffffu & uint(tb35.x) * 0xffffffffu);
    t49 = (ti50 != 0) ? (-t49) : t49;
    t4.x = t49 * 0.159154937 + 0.5;
    t49 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t49 = t49 * abs(t6.z) + -0.212114394;
    t49 = t49 * abs(t6.z) + 1.57072878;
    t50 = -abs(t6.z) + 1.0;
    t50 = sqrt(t50);
    t35.x = t49 * t50;
    t35.x = t35.x * -2.0 + 3.14159274;
    t35.x = tb35.y ? t35.x : float(0.0);
    t49 = t49 * t50 + t35.x;
    t4.y = t49 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t16_4 = t5 * t4;
    t49 = dot(t2.xyz, t2.xyz);
    t50 = sqrt(t49);
    t49 = inversesqrt(t49);
    t2.xyz = vec3(t49) * t2.xyz;
    t49 = t50 * _DistFade;
    t50 = (-_DistFadeVert) * t50 + 1.0;
    t50 = clamp(t50, 0.0, 1.0);
    t49 = t49;
    t49 = clamp(t49, 0.0, 1.0);
    t5.w = t50 * t49;
    t16_4.w = t16_4.w * t5.w;
    vs_COLOR0 = t16_4;
    t6.x = fract(_Rotation);
    t6.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t6.xyz;
    t35.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t35.x);
    t50 = t48 * t35.y;
    t33.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t33.x = sqrt(t33.x);
    t6.x = sin(t1.y);
    t7.x = cos(t1.y);
    t8.x = cos(t1.x);
    t1.x = sin(t1.x);
    t17 = t33.x * t7.x;
    t33.x = t33.x * t6.x;
    t35.xy = t1.wx * vec2(t17);
    t51 = t33.x * t8.x + (-t35.y);
    t6.x = t17 * t51 + t1.x;
    t22 = t8.x * t17;
    t22 = t33.x * t1.x + t22;
    t17 = t17 * t22 + (-t8.x);
    t17 = t48 * t17;
    t7.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t7.xyz;
    t24.xyz = vec3(t17) * t7.xyz;
    t9.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t9.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t9.xyz;
    t9.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t9.xyz;
    t9.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t9.xyz;
    t6.xzw = t9.xyz * t6.xxx + t24.xyz;
    t24.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t24.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t24.xyz;
    t24.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t24.xyz;
    t24.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t24.xyz;
    t6.xzw = t24.xyz * t35.xxx + t6.xzw;
    t10.y = t6.w;
    t17 = t33.x * t51 + (-t8.x);
    t1.x = t33.x * t22 + (-t1.x);
    t33.x = t1.w * t33.x;
    t35.x = t1.w * t22;
    t49 = t1.w * t51;
    t11.xyz = t35.xxx * t7.xyz;
    t11.xyz = t9.xyz * vec3(t49) + t11.xyz;
    t11.xyz = t24.xyz * vec3(t50) + t11.xyz;
    t12.xyz = t1.xxx * t7.xyz;
    t1.xw = t0.yy * t7.xy;
    t0.xy = t9.xy * t0.xx + t1.xw;
    t0.xy = t24.xy * t0.zz + t0.xy;
    t32.x = t48 * t17;
    t1.xyw = t9.xyz * t32.xxx + t12.xyz;
    t1.xyz = t24.xyz * t33.xxx + t1.xyw;
    t10.x = t1.z;
    t10.z = t11.z;
    t32.x = dot(t10.xyz, t10.xyz);
    t32.x = inversesqrt(t32.x);
    t7.xyz = t32.xxx * t10.xyz;
    t5.xyz = abs(t7.xyz);
    vs_TEXCOORD0 = t5;
    t32.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t32.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t32.xy;
    t32.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t32.xy;
    t32.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t32.xy;
    t0.xy = t32.xy + t0.xy;
    ti5.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t7.xyzx)).xyz) * 0xFFFFFFFFu);
    ti8.xyz = ivec3(uvec3(lessThan((-t7.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti5.xyz = (-ti5.xyz) + ti8.xyz;
    t32.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti33 = int((0.0<t32.y) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t32.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti33 = (-ti33) + ti49;
    ti8.xyz = ivec3(ti33) * ti5.xyz;
    t8.xyz = vec3(ti8.xyz);
    t8.xyz = vec3(t7.y * t8.x, t7.z * t8.y, t7.y * t8.z);
    t33.xy = vec2(ti5.xy);
    t33.xy = t32.xx * t33.xy;
    ti35.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t33.xyxy).xy) * 0xFFFFFFFFu);
    ti22.xz = ivec2(uvec2(lessThan(t33.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti35.xy = (-ti35.xy) + ti22.xz;
    ti35.xy = ti35.xy * ti5.xy;
    t35.xy = vec2(ti35.xy);
    t35.xy = t35.xy * t7.zx + t8.xy;
    t5.xy = t35.yy * t6.xz;
    t6.xy = t32.yy * t6.xz;
    t35.xy = t1.xy * t35.xx + t6.xy;
    t35.xy = t11.xy * t33.xx + t35.xy;
    t33.xy = t1.xy * t33.yy + t5.xy;
    t33.xy = t11.xy * t32.yy + t33.xy;
    t33.xy = t0.xy * in_POSITION0.ww + t33.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD2.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t33.xy = t0.xy * in_POSITION0.ww + t35.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD1.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti48 = int((0.0<t7.z) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t7.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti48 = (-ti48) + ti33;
    t48 = float(ti48);
    t32.x = t48 * t32.x;
    ti48 = int((0.0<t32.x) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t32.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t32.xx + t6.xy;
    ti32 = (-ti48) + ti33;
    ti32 = ti32 * ti5.z;
    t32.x = float(ti32);
    t32.x = t32.x * t7.x + t8.z;
    t32.xy = t11.xy * t32.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t32.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t48 = dot(t3.xyz, t3.xyz);
    t48 = inversesqrt(t48);
    t5.xyz = vec3(t48) * t3.yzx;
    t6.xyz = t0.zxy * t5.xyz;
    t5.xyz = t0.yzx * t5.yzx + (-t6.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t5.xyz), t2.xyz);
    t0.y = dot((-t5.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t48 = dot(t1.xyz, t1.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD7.xyz = vec3(t48) * t1.xyz;
    t48 = dot(t0.xyz, t0.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD8.xyz = vec3(t48) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _Tex;
in lowp vec4 vs_COLOR0;
in mediump vec4 vs_TEXCOORD0;
in highp vec2 vs_TEXCOORD1;
in highp vec2 vs_TEXCOORD2;
in highp vec2 vs_TEXCOORD3;
in highp vec2 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD7;
in highp vec3 vs_TEXCOORD8;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
mediump vec3 t16_1;
highp vec3 t2;
lowp vec4 t10_2;
highp vec3 t3;
mediump vec3 t16_4;
mediump vec3 t16_5;
highp vec2 t6;
mediump vec3 t16_7;
mediump float t16_13;
mediump float t16_14;
mediump float t16_19;
mediump float t16_22;
void main()
{
    t0.x = texture(_Tex, vs_TEXCOORD1.xy).x;
    t0.y = texture(_Tex, vs_TEXCOORD2.xy).y;
    t0.z = texture(_Tex, vs_TEXCOORD3.xy).z;
    t16_1.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t16_19 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t16_19 = t16_19 + vs_TEXCOORD0.z;
    t16_1.xyz = t16_1.xyz / vec3(t16_19);
    t16_1.x = t16_1.y + t16_1.x;
    t16_1.x = t16_1.z + t16_1.x;
    t16_7.x = t16_1.x * vs_TEXCOORD0.w;
    t0.x = (-_Opacity) * t16_7.x + _MinScatter;
    t2.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t3.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t6.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t16_7.x = dot(t6.xy, t6.xy);
    t16_7.x = min(t16_7.x, 1.0);
    t16_7.x = (-t16_7.x) + 1.0;
    t16_14 = sqrt(t16_7.x);
    t2.z = t16_14;
    t3.z = t2.z;
    t16_7.x = dot(t2.xyz, t3.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_4.xy = t6.xy * t16_7.xx;
    t16_4.z = t16_7.x * t2.z;
    t16_7.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_7.xyz = t16_7.xxx * vs_TEXCOORD7.xyz;
    t16_22 = dot(t16_4.xyz, t16_7.xyz);
    t16_22 = (-t16_22) + 1.0;
    t0.x = t0.x * t16_22;
    t16_22 = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_5.xyz = vec3(t16_22) * vs_TEXCOORD8.xyz;
    t16_7.x = dot(t16_7.xyz, t16_5.xyz);
    t16_13 = dot(t16_4.xyz, t16_5.xyz);
    t16_13 = max(t16_13, 0.0);
    t16_7.x = t16_7.x * 0.5 + 0.5;
    t0.x = t0.x * t16_7.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + t16_13;
    t0.xyz = t0.xxx * _LightColor0.xyz;
    t0.xyz = t0.xyz + t0.xyz;
    t10_2 = vs_COLOR0 * _Color;
    t16_0.xyz = t0.xyz * t10_2.xyz;
    t16_0.w = t16_1.x * t10_2.w;
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 642 math, 2 textures, 48 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "texcoord" ATTR1
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 528
Matrix 32 [glstate_matrix_modelview0]
Matrix 96 [_Object2World]
Matrix 160 [glstate_matrix_projection]
Matrix 224 [unity_MatrixV]
Matrix 288 [_MainRotation]
Matrix 352 [_DetailRotation]
Matrix 416 [_PosRotation]
Vector 0 [_WorldSpaceCameraPos] 3
VectorHalf 16 [_WorldSpaceLightPos0] 4
Float 480 [_DistFade]
Float 484 [_DistFadeVert]
Float 488 [_Rotation]
Float 492 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesMultiTexCoord0 [[attribute(1)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  half4 xlv_COLOR;
  half4 xlv_TEXCOORD0;
  float2 xlv_TEXCOORD1;
  float2 xlv_TEXCOORD2;
  float2 xlv_TEXCOORD3;
  float2 xlv_TEXCOORD4;
  float4 xlv_TEXCOORD5;
  float3 xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
  float3 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  half4 _WorldSpaceLightPos0;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 glstate_matrix_projection;
  float4x4 unity_MatrixV;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4x4 _PosRotation;
  float _DistFade;
  float _DistFadeVert;
  float _Rotation;
  float _MaxScale;
  float4 _NoiseScale;
  float3 _MaxTrans;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> _MainTex [[texture(0)]], sampler _mtlsmp__MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]])
{
  xlatMtlShaderOutput _mtl_o;
  float2 tmpvar_1;
  tmpvar_1 = _mtl_i._glesMultiTexCoord0.xy;
  half3 normal_2;
  float4 XYv_3;
  float4 XZv_4;
  float4 ZYv_5;
  float4 localOrigin_6;
  float4 planet_pos_7;
  float4 origin_8;
  half4 tmpvar_9;
  half4 tmpvar_10;
  float4 tmpvar_11;
  float3 tmpvar_12;
  float4 tmpvar_13;
  tmpvar_13 = (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0));
  origin_8 = tmpvar_13;
  float4 tmpvar_14;
  tmpvar_14 = (_mtl_u._PosRotation * tmpvar_13);
  planet_pos_7 = tmpvar_14;
  float3 tmpvar_15;
  tmpvar_15 = (_mtl_u._NoiseScale.z * tmpvar_14.xyz);
  float tmpvar_16;
  float4 m_17;
  float3 tmpvar_18;
  tmpvar_18 = floor((tmpvar_15 + dot (tmpvar_15, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_19;
  tmpvar_19 = ((tmpvar_15 - tmpvar_18) + dot (tmpvar_18, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_20;
  tmpvar_20.x = float((tmpvar_19.x >= tmpvar_19.y));
  tmpvar_20.y = float((tmpvar_19.y >= tmpvar_19.z));
  tmpvar_20.z = float((tmpvar_19.z >= tmpvar_19.x));
  float3 tmpvar_21;
  tmpvar_21 = (1.0 - tmpvar_20);
  float3 tmpvar_22;
  tmpvar_22 = min (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_23;
  tmpvar_23 = max (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_24;
  tmpvar_24 = ((tmpvar_19 - tmpvar_22) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_25;
  tmpvar_25 = ((tmpvar_19 - tmpvar_23) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_26;
  tmpvar_26 = (tmpvar_19 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_27;
  tmpvar_27 = (tmpvar_18 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_28;
  tmpvar_28 = (fract(abs(tmpvar_27)) * float3(289.0, 289.0, 289.0));
  float tmpvar_29;
  if ((tmpvar_27.x >= 0.0)) {
    tmpvar_29 = tmpvar_28.x;
  } else {
    tmpvar_29 = -(tmpvar_28.x);
  };
  float tmpvar_30;
  if ((tmpvar_27.y >= 0.0)) {
    tmpvar_30 = tmpvar_28.y;
  } else {
    tmpvar_30 = -(tmpvar_28.y);
  };
  float tmpvar_31;
  if ((tmpvar_27.z >= 0.0)) {
    tmpvar_31 = tmpvar_28.z;
  } else {
    tmpvar_31 = -(tmpvar_28.z);
  };
  float4 tmpvar_32;
  tmpvar_32.xw = float2(0.0, 1.0);
  tmpvar_32.y = tmpvar_22.z;
  tmpvar_32.z = tmpvar_23.z;
  float4 x_33;
  x_33 = (tmpvar_31 + tmpvar_32);
  float4 tmpvar_34;
  tmpvar_34 = (((
    (x_33 * x_33)
   * 34.0) + x_33) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_35;
  tmpvar_35 = (fract(abs(tmpvar_34)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_36;
  if ((tmpvar_34.x >= 0.0)) {
    tmpvar_36 = tmpvar_35.x;
  } else {
    tmpvar_36 = -(tmpvar_35.x);
  };
  float tmpvar_37;
  if ((tmpvar_34.y >= 0.0)) {
    tmpvar_37 = tmpvar_35.y;
  } else {
    tmpvar_37 = -(tmpvar_35.y);
  };
  float tmpvar_38;
  if ((tmpvar_34.z >= 0.0)) {
    tmpvar_38 = tmpvar_35.z;
  } else {
    tmpvar_38 = -(tmpvar_35.z);
  };
  float tmpvar_39;
  if ((tmpvar_34.w >= 0.0)) {
    tmpvar_39 = tmpvar_35.w;
  } else {
    tmpvar_39 = -(tmpvar_35.w);
  };
  float4 tmpvar_40;
  tmpvar_40.x = tmpvar_36;
  tmpvar_40.y = tmpvar_37;
  tmpvar_40.z = tmpvar_38;
  tmpvar_40.w = tmpvar_39;
  float4 tmpvar_41;
  tmpvar_41.xw = float2(0.0, 1.0);
  tmpvar_41.y = tmpvar_22.y;
  tmpvar_41.z = tmpvar_23.y;
  float4 x_42;
  x_42 = ((tmpvar_40 + tmpvar_30) + tmpvar_41);
  float4 tmpvar_43;
  tmpvar_43 = (((
    (x_42 * x_42)
   * 34.0) + x_42) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_44;
  tmpvar_44 = (fract(abs(tmpvar_43)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_45;
  if ((tmpvar_43.x >= 0.0)) {
    tmpvar_45 = tmpvar_44.x;
  } else {
    tmpvar_45 = -(tmpvar_44.x);
  };
  float tmpvar_46;
  if ((tmpvar_43.y >= 0.0)) {
    tmpvar_46 = tmpvar_44.y;
  } else {
    tmpvar_46 = -(tmpvar_44.y);
  };
  float tmpvar_47;
  if ((tmpvar_43.z >= 0.0)) {
    tmpvar_47 = tmpvar_44.z;
  } else {
    tmpvar_47 = -(tmpvar_44.z);
  };
  float tmpvar_48;
  if ((tmpvar_43.w >= 0.0)) {
    tmpvar_48 = tmpvar_44.w;
  } else {
    tmpvar_48 = -(tmpvar_44.w);
  };
  float4 tmpvar_49;
  tmpvar_49.x = tmpvar_45;
  tmpvar_49.y = tmpvar_46;
  tmpvar_49.z = tmpvar_47;
  tmpvar_49.w = tmpvar_48;
  float4 tmpvar_50;
  tmpvar_50.xw = float2(0.0, 1.0);
  tmpvar_50.y = tmpvar_22.x;
  tmpvar_50.z = tmpvar_23.x;
  float4 x_51;
  x_51 = ((tmpvar_49 + tmpvar_29) + tmpvar_50);
  float4 tmpvar_52;
  tmpvar_52 = (((
    (x_51 * x_51)
   * 34.0) + x_51) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_53;
  tmpvar_53 = (fract(abs(tmpvar_52)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_54;
  if ((tmpvar_52.x >= 0.0)) {
    tmpvar_54 = tmpvar_53.x;
  } else {
    tmpvar_54 = -(tmpvar_53.x);
  };
  float tmpvar_55;
  if ((tmpvar_52.y >= 0.0)) {
    tmpvar_55 = tmpvar_53.y;
  } else {
    tmpvar_55 = -(tmpvar_53.y);
  };
  float tmpvar_56;
  if ((tmpvar_52.z >= 0.0)) {
    tmpvar_56 = tmpvar_53.z;
  } else {
    tmpvar_56 = -(tmpvar_53.z);
  };
  float tmpvar_57;
  if ((tmpvar_52.w >= 0.0)) {
    tmpvar_57 = tmpvar_53.w;
  } else {
    tmpvar_57 = -(tmpvar_53.w);
  };
  float4 tmpvar_58;
  tmpvar_58.x = tmpvar_54;
  tmpvar_58.y = tmpvar_55;
  tmpvar_58.z = tmpvar_56;
  tmpvar_58.w = tmpvar_57;
  float4 tmpvar_59;
  tmpvar_59 = (tmpvar_58 - (49.0 * floor(
    (0.02040815 * tmpvar_58)
  )));
  float4 tmpvar_60;
  tmpvar_60 = floor((tmpvar_59 * 0.1428571));
  float4 tmpvar_61;
  tmpvar_61 = ((tmpvar_60 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_62;
  tmpvar_62 = ((floor(
    (tmpvar_59 - (7.0 * tmpvar_60))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_63;
  tmpvar_63 = ((1.0 - abs(tmpvar_61)) - abs(tmpvar_62));
  float4 tmpvar_64;
  tmpvar_64.xy = tmpvar_61.xy;
  tmpvar_64.zw = tmpvar_62.xy;
  float4 tmpvar_65;
  tmpvar_65.xy = tmpvar_61.zw;
  tmpvar_65.zw = tmpvar_62.zw;
  float4 tmpvar_66;
  tmpvar_66 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_63)));
  float4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_66.xxyy));
  float4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_66.zzww));
  float3 tmpvar_69;
  tmpvar_69.xy = tmpvar_67.xy;
  tmpvar_69.z = tmpvar_63.x;
  float3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.zw;
  tmpvar_70.z = tmpvar_63.y;
  float3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.xy;
  tmpvar_71.z = tmpvar_63.z;
  float3 tmpvar_72;
  tmpvar_72.xy = tmpvar_68.zw;
  tmpvar_72.z = tmpvar_63.w;
  float4 tmpvar_73;
  tmpvar_73.x = dot (tmpvar_69, tmpvar_69);
  tmpvar_73.y = dot (tmpvar_70, tmpvar_70);
  tmpvar_73.z = dot (tmpvar_71, tmpvar_71);
  tmpvar_73.w = dot (tmpvar_72, tmpvar_72);
  float4 tmpvar_74;
  tmpvar_74 = (1.792843 - (0.8537347 * tmpvar_73));
  float4 tmpvar_75;
  tmpvar_75.x = dot (tmpvar_19, tmpvar_19);
  tmpvar_75.y = dot (tmpvar_24, tmpvar_24);
  tmpvar_75.z = dot (tmpvar_25, tmpvar_25);
  tmpvar_75.w = dot (tmpvar_26, tmpvar_26);
  float4 tmpvar_76;
  tmpvar_76 = max ((0.6 - tmpvar_75), float4(0.0, 0.0, 0.0, 0.0));
  m_17 = (tmpvar_76 * tmpvar_76);
  float4 tmpvar_77;
  tmpvar_77.x = dot ((tmpvar_69 * tmpvar_74.x), tmpvar_19);
  tmpvar_77.y = dot ((tmpvar_70 * tmpvar_74.y), tmpvar_24);
  tmpvar_77.z = dot ((tmpvar_71 * tmpvar_74.z), tmpvar_25);
  tmpvar_77.w = dot ((tmpvar_72 * tmpvar_74.w), tmpvar_26);
  tmpvar_16 = (42.0 * dot ((m_17 * m_17), tmpvar_77));
  float tmpvar_78;
  float3 v_79;
  v_79 = (_mtl_u._NoiseScale.x * tmpvar_15);
  float4 m_80;
  float3 tmpvar_81;
  tmpvar_81 = floor((v_79 + dot (v_79, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_82;
  tmpvar_82 = ((v_79 - tmpvar_81) + dot (tmpvar_81, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_83;
  tmpvar_83.x = float((tmpvar_82.x >= tmpvar_82.y));
  tmpvar_83.y = float((tmpvar_82.y >= tmpvar_82.z));
  tmpvar_83.z = float((tmpvar_82.z >= tmpvar_82.x));
  float3 tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_83);
  float3 tmpvar_85;
  tmpvar_85 = min (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_86;
  tmpvar_86 = max (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_87;
  tmpvar_87 = ((tmpvar_82 - tmpvar_85) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_88;
  tmpvar_88 = ((tmpvar_82 - tmpvar_86) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_89;
  tmpvar_89 = (tmpvar_82 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_90;
  tmpvar_90 = (tmpvar_81 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_91;
  tmpvar_91 = (fract(abs(tmpvar_90)) * float3(289.0, 289.0, 289.0));
  float tmpvar_92;
  if ((tmpvar_90.x >= 0.0)) {
    tmpvar_92 = tmpvar_91.x;
  } else {
    tmpvar_92 = -(tmpvar_91.x);
  };
  float tmpvar_93;
  if ((tmpvar_90.y >= 0.0)) {
    tmpvar_93 = tmpvar_91.y;
  } else {
    tmpvar_93 = -(tmpvar_91.y);
  };
  float tmpvar_94;
  if ((tmpvar_90.z >= 0.0)) {
    tmpvar_94 = tmpvar_91.z;
  } else {
    tmpvar_94 = -(tmpvar_91.z);
  };
  float4 tmpvar_95;
  tmpvar_95.xw = float2(0.0, 1.0);
  tmpvar_95.y = tmpvar_85.z;
  tmpvar_95.z = tmpvar_86.z;
  float4 x_96;
  x_96 = (tmpvar_94 + tmpvar_95);
  float4 tmpvar_97;
  tmpvar_97 = (((
    (x_96 * x_96)
   * 34.0) + x_96) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_98;
  tmpvar_98 = (fract(abs(tmpvar_97)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_99;
  if ((tmpvar_97.x >= 0.0)) {
    tmpvar_99 = tmpvar_98.x;
  } else {
    tmpvar_99 = -(tmpvar_98.x);
  };
  float tmpvar_100;
  if ((tmpvar_97.y >= 0.0)) {
    tmpvar_100 = tmpvar_98.y;
  } else {
    tmpvar_100 = -(tmpvar_98.y);
  };
  float tmpvar_101;
  if ((tmpvar_97.z >= 0.0)) {
    tmpvar_101 = tmpvar_98.z;
  } else {
    tmpvar_101 = -(tmpvar_98.z);
  };
  float tmpvar_102;
  if ((tmpvar_97.w >= 0.0)) {
    tmpvar_102 = tmpvar_98.w;
  } else {
    tmpvar_102 = -(tmpvar_98.w);
  };
  float4 tmpvar_103;
  tmpvar_103.x = tmpvar_99;
  tmpvar_103.y = tmpvar_100;
  tmpvar_103.z = tmpvar_101;
  tmpvar_103.w = tmpvar_102;
  float4 tmpvar_104;
  tmpvar_104.xw = float2(0.0, 1.0);
  tmpvar_104.y = tmpvar_85.y;
  tmpvar_104.z = tmpvar_86.y;
  float4 x_105;
  x_105 = ((tmpvar_103 + tmpvar_93) + tmpvar_104);
  float4 tmpvar_106;
  tmpvar_106 = (((
    (x_105 * x_105)
   * 34.0) + x_105) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_107;
  tmpvar_107 = (fract(abs(tmpvar_106)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_108;
  if ((tmpvar_106.x >= 0.0)) {
    tmpvar_108 = tmpvar_107.x;
  } else {
    tmpvar_108 = -(tmpvar_107.x);
  };
  float tmpvar_109;
  if ((tmpvar_106.y >= 0.0)) {
    tmpvar_109 = tmpvar_107.y;
  } else {
    tmpvar_109 = -(tmpvar_107.y);
  };
  float tmpvar_110;
  if ((tmpvar_106.z >= 0.0)) {
    tmpvar_110 = tmpvar_107.z;
  } else {
    tmpvar_110 = -(tmpvar_107.z);
  };
  float tmpvar_111;
  if ((tmpvar_106.w >= 0.0)) {
    tmpvar_111 = tmpvar_107.w;
  } else {
    tmpvar_111 = -(tmpvar_107.w);
  };
  float4 tmpvar_112;
  tmpvar_112.x = tmpvar_108;
  tmpvar_112.y = tmpvar_109;
  tmpvar_112.z = tmpvar_110;
  tmpvar_112.w = tmpvar_111;
  float4 tmpvar_113;
  tmpvar_113.xw = float2(0.0, 1.0);
  tmpvar_113.y = tmpvar_85.x;
  tmpvar_113.z = tmpvar_86.x;
  float4 x_114;
  x_114 = ((tmpvar_112 + tmpvar_92) + tmpvar_113);
  float4 tmpvar_115;
  tmpvar_115 = (((
    (x_114 * x_114)
   * 34.0) + x_114) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_116;
  tmpvar_116 = (fract(abs(tmpvar_115)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_117;
  if ((tmpvar_115.x >= 0.0)) {
    tmpvar_117 = tmpvar_116.x;
  } else {
    tmpvar_117 = -(tmpvar_116.x);
  };
  float tmpvar_118;
  if ((tmpvar_115.y >= 0.0)) {
    tmpvar_118 = tmpvar_116.y;
  } else {
    tmpvar_118 = -(tmpvar_116.y);
  };
  float tmpvar_119;
  if ((tmpvar_115.z >= 0.0)) {
    tmpvar_119 = tmpvar_116.z;
  } else {
    tmpvar_119 = -(tmpvar_116.z);
  };
  float tmpvar_120;
  if ((tmpvar_115.w >= 0.0)) {
    tmpvar_120 = tmpvar_116.w;
  } else {
    tmpvar_120 = -(tmpvar_116.w);
  };
  float4 tmpvar_121;
  tmpvar_121.x = tmpvar_117;
  tmpvar_121.y = tmpvar_118;
  tmpvar_121.z = tmpvar_119;
  tmpvar_121.w = tmpvar_120;
  float4 tmpvar_122;
  tmpvar_122 = (tmpvar_121 - (49.0 * floor(
    (0.02040815 * tmpvar_121)
  )));
  float4 tmpvar_123;
  tmpvar_123 = floor((tmpvar_122 * 0.1428571));
  float4 tmpvar_124;
  tmpvar_124 = ((tmpvar_123 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_125;
  tmpvar_125 = ((floor(
    (tmpvar_122 - (7.0 * tmpvar_123))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_126;
  tmpvar_126 = ((1.0 - abs(tmpvar_124)) - abs(tmpvar_125));
  float4 tmpvar_127;
  tmpvar_127.xy = tmpvar_124.xy;
  tmpvar_127.zw = tmpvar_125.xy;
  float4 tmpvar_128;
  tmpvar_128.xy = tmpvar_124.zw;
  tmpvar_128.zw = tmpvar_125.zw;
  float4 tmpvar_129;
  tmpvar_129 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_126)));
  float4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_129.xxyy));
  float4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_129.zzww));
  float3 tmpvar_132;
  tmpvar_132.xy = tmpvar_130.xy;
  tmpvar_132.z = tmpvar_126.x;
  float3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.zw;
  tmpvar_133.z = tmpvar_126.y;
  float3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.xy;
  tmpvar_134.z = tmpvar_126.z;
  float3 tmpvar_135;
  tmpvar_135.xy = tmpvar_131.zw;
  tmpvar_135.z = tmpvar_126.w;
  float4 tmpvar_136;
  tmpvar_136.x = dot (tmpvar_132, tmpvar_132);
  tmpvar_136.y = dot (tmpvar_133, tmpvar_133);
  tmpvar_136.z = dot (tmpvar_134, tmpvar_134);
  tmpvar_136.w = dot (tmpvar_135, tmpvar_135);
  float4 tmpvar_137;
  tmpvar_137 = (1.792843 - (0.8537347 * tmpvar_136));
  float4 tmpvar_138;
  tmpvar_138.x = dot (tmpvar_82, tmpvar_82);
  tmpvar_138.y = dot (tmpvar_87, tmpvar_87);
  tmpvar_138.z = dot (tmpvar_88, tmpvar_88);
  tmpvar_138.w = dot (tmpvar_89, tmpvar_89);
  float4 tmpvar_139;
  tmpvar_139 = max ((0.6 - tmpvar_138), float4(0.0, 0.0, 0.0, 0.0));
  m_80 = (tmpvar_139 * tmpvar_139);
  float4 tmpvar_140;
  tmpvar_140.x = dot ((tmpvar_132 * tmpvar_137.x), tmpvar_82);
  tmpvar_140.y = dot ((tmpvar_133 * tmpvar_137.y), tmpvar_87);
  tmpvar_140.z = dot ((tmpvar_134 * tmpvar_137.z), tmpvar_88);
  tmpvar_140.w = dot ((tmpvar_135 * tmpvar_137.w), tmpvar_89);
  tmpvar_78 = (42.0 * dot ((m_80 * m_80), tmpvar_140));
  float3 v_141;
  v_141 = (_mtl_u._NoiseScale.y * tmpvar_15);
  float4 m_142;
  float3 tmpvar_143;
  tmpvar_143 = floor((v_141 + dot (v_141, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_144;
  tmpvar_144 = ((v_141 - tmpvar_143) + dot (tmpvar_143, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_145;
  tmpvar_145.x = float((tmpvar_144.x >= tmpvar_144.y));
  tmpvar_145.y = float((tmpvar_144.y >= tmpvar_144.z));
  tmpvar_145.z = float((tmpvar_144.z >= tmpvar_144.x));
  float3 tmpvar_146;
  tmpvar_146 = (1.0 - tmpvar_145);
  float3 tmpvar_147;
  tmpvar_147 = min (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_148;
  tmpvar_148 = max (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_149;
  tmpvar_149 = ((tmpvar_144 - tmpvar_147) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_150;
  tmpvar_150 = ((tmpvar_144 - tmpvar_148) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_151;
  tmpvar_151 = (tmpvar_144 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_152;
  tmpvar_152 = (tmpvar_143 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_153;
  tmpvar_153 = (fract(abs(tmpvar_152)) * float3(289.0, 289.0, 289.0));
  float tmpvar_154;
  if ((tmpvar_152.x >= 0.0)) {
    tmpvar_154 = tmpvar_153.x;
  } else {
    tmpvar_154 = -(tmpvar_153.x);
  };
  float tmpvar_155;
  if ((tmpvar_152.y >= 0.0)) {
    tmpvar_155 = tmpvar_153.y;
  } else {
    tmpvar_155 = -(tmpvar_153.y);
  };
  float tmpvar_156;
  if ((tmpvar_152.z >= 0.0)) {
    tmpvar_156 = tmpvar_153.z;
  } else {
    tmpvar_156 = -(tmpvar_153.z);
  };
  float4 tmpvar_157;
  tmpvar_157.xw = float2(0.0, 1.0);
  tmpvar_157.y = tmpvar_147.z;
  tmpvar_157.z = tmpvar_148.z;
  float4 x_158;
  x_158 = (tmpvar_156 + tmpvar_157);
  float4 tmpvar_159;
  tmpvar_159 = (((
    (x_158 * x_158)
   * 34.0) + x_158) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_160;
  tmpvar_160 = (fract(abs(tmpvar_159)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_161;
  if ((tmpvar_159.x >= 0.0)) {
    tmpvar_161 = tmpvar_160.x;
  } else {
    tmpvar_161 = -(tmpvar_160.x);
  };
  float tmpvar_162;
  if ((tmpvar_159.y >= 0.0)) {
    tmpvar_162 = tmpvar_160.y;
  } else {
    tmpvar_162 = -(tmpvar_160.y);
  };
  float tmpvar_163;
  if ((tmpvar_159.z >= 0.0)) {
    tmpvar_163 = tmpvar_160.z;
  } else {
    tmpvar_163 = -(tmpvar_160.z);
  };
  float tmpvar_164;
  if ((tmpvar_159.w >= 0.0)) {
    tmpvar_164 = tmpvar_160.w;
  } else {
    tmpvar_164 = -(tmpvar_160.w);
  };
  float4 tmpvar_165;
  tmpvar_165.x = tmpvar_161;
  tmpvar_165.y = tmpvar_162;
  tmpvar_165.z = tmpvar_163;
  tmpvar_165.w = tmpvar_164;
  float4 tmpvar_166;
  tmpvar_166.xw = float2(0.0, 1.0);
  tmpvar_166.y = tmpvar_147.y;
  tmpvar_166.z = tmpvar_148.y;
  float4 x_167;
  x_167 = ((tmpvar_165 + tmpvar_155) + tmpvar_166);
  float4 tmpvar_168;
  tmpvar_168 = (((
    (x_167 * x_167)
   * 34.0) + x_167) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_169;
  tmpvar_169 = (fract(abs(tmpvar_168)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_170;
  if ((tmpvar_168.x >= 0.0)) {
    tmpvar_170 = tmpvar_169.x;
  } else {
    tmpvar_170 = -(tmpvar_169.x);
  };
  float tmpvar_171;
  if ((tmpvar_168.y >= 0.0)) {
    tmpvar_171 = tmpvar_169.y;
  } else {
    tmpvar_171 = -(tmpvar_169.y);
  };
  float tmpvar_172;
  if ((tmpvar_168.z >= 0.0)) {
    tmpvar_172 = tmpvar_169.z;
  } else {
    tmpvar_172 = -(tmpvar_169.z);
  };
  float tmpvar_173;
  if ((tmpvar_168.w >= 0.0)) {
    tmpvar_173 = tmpvar_169.w;
  } else {
    tmpvar_173 = -(tmpvar_169.w);
  };
  float4 tmpvar_174;
  tmpvar_174.x = tmpvar_170;
  tmpvar_174.y = tmpvar_171;
  tmpvar_174.z = tmpvar_172;
  tmpvar_174.w = tmpvar_173;
  float4 tmpvar_175;
  tmpvar_175.xw = float2(0.0, 1.0);
  tmpvar_175.y = tmpvar_147.x;
  tmpvar_175.z = tmpvar_148.x;
  float4 x_176;
  x_176 = ((tmpvar_174 + tmpvar_154) + tmpvar_175);
  float4 tmpvar_177;
  tmpvar_177 = (((
    (x_176 * x_176)
   * 34.0) + x_176) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_178;
  tmpvar_178 = (fract(abs(tmpvar_177)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_179;
  if ((tmpvar_177.x >= 0.0)) {
    tmpvar_179 = tmpvar_178.x;
  } else {
    tmpvar_179 = -(tmpvar_178.x);
  };
  float tmpvar_180;
  if ((tmpvar_177.y >= 0.0)) {
    tmpvar_180 = tmpvar_178.y;
  } else {
    tmpvar_180 = -(tmpvar_178.y);
  };
  float tmpvar_181;
  if ((tmpvar_177.z >= 0.0)) {
    tmpvar_181 = tmpvar_178.z;
  } else {
    tmpvar_181 = -(tmpvar_178.z);
  };
  float tmpvar_182;
  if ((tmpvar_177.w >= 0.0)) {
    tmpvar_182 = tmpvar_178.w;
  } else {
    tmpvar_182 = -(tmpvar_178.w);
  };
  float4 tmpvar_183;
  tmpvar_183.x = tmpvar_179;
  tmpvar_183.y = tmpvar_180;
  tmpvar_183.z = tmpvar_181;
  tmpvar_183.w = tmpvar_182;
  float4 tmpvar_184;
  tmpvar_184 = (tmpvar_183 - (49.0 * floor(
    (0.02040815 * tmpvar_183)
  )));
  float4 tmpvar_185;
  tmpvar_185 = floor((tmpvar_184 * 0.1428571));
  float4 tmpvar_186;
  tmpvar_186 = ((tmpvar_185 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_187;
  tmpvar_187 = ((floor(
    (tmpvar_184 - (7.0 * tmpvar_185))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_188;
  tmpvar_188 = ((1.0 - abs(tmpvar_186)) - abs(tmpvar_187));
  float4 tmpvar_189;
  tmpvar_189.xy = tmpvar_186.xy;
  tmpvar_189.zw = tmpvar_187.xy;
  float4 tmpvar_190;
  tmpvar_190.xy = tmpvar_186.zw;
  tmpvar_190.zw = tmpvar_187.zw;
  float4 tmpvar_191;
  tmpvar_191 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_188)));
  float4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_191.xxyy));
  float4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_191.zzww));
  float3 tmpvar_194;
  tmpvar_194.xy = tmpvar_192.xy;
  tmpvar_194.z = tmpvar_188.x;
  float3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.zw;
  tmpvar_195.z = tmpvar_188.y;
  float3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.xy;
  tmpvar_196.z = tmpvar_188.z;
  float3 tmpvar_197;
  tmpvar_197.xy = tmpvar_193.zw;
  tmpvar_197.z = tmpvar_188.w;
  float4 tmpvar_198;
  tmpvar_198.x = dot (tmpvar_194, tmpvar_194);
  tmpvar_198.y = dot (tmpvar_195, tmpvar_195);
  tmpvar_198.z = dot (tmpvar_196, tmpvar_196);
  tmpvar_198.w = dot (tmpvar_197, tmpvar_197);
  float4 tmpvar_199;
  tmpvar_199 = (1.792843 - (0.8537347 * tmpvar_198));
  float4 tmpvar_200;
  tmpvar_200.x = dot (tmpvar_144, tmpvar_144);
  tmpvar_200.y = dot (tmpvar_149, tmpvar_149);
  tmpvar_200.z = dot (tmpvar_150, tmpvar_150);
  tmpvar_200.w = dot (tmpvar_151, tmpvar_151);
  float4 tmpvar_201;
  tmpvar_201 = max ((0.6 - tmpvar_200), float4(0.0, 0.0, 0.0, 0.0));
  m_142 = (tmpvar_201 * tmpvar_201);
  float4 tmpvar_202;
  tmpvar_202.x = dot ((tmpvar_194 * tmpvar_199.x), tmpvar_144);
  tmpvar_202.y = dot ((tmpvar_195 * tmpvar_199.y), tmpvar_149);
  tmpvar_202.z = dot ((tmpvar_196 * tmpvar_199.z), tmpvar_150);
  tmpvar_202.w = dot ((tmpvar_197 * tmpvar_199.w), tmpvar_151);
  float3 tmpvar_203;
  tmpvar_203.x = tmpvar_16;
  tmpvar_203.y = tmpvar_78;
  tmpvar_203.z = (42.0 * dot ((m_142 * m_142), tmpvar_202));
  float3 tmpvar_204;
  tmpvar_204 = (0.5 * (tmpvar_203 + 1.0));
  localOrigin_6.xyz = (((2.0 * tmpvar_204) - 1.0) * _mtl_u._MaxTrans);
  localOrigin_6.w = 1.0;
  float tmpvar_205;
  tmpvar_205 = ((tmpvar_204.x * (_mtl_u._MaxScale - 1.0)) + 1.0);
  origin_8 = (_mtl_u._Object2World * localOrigin_6);
  planet_pos_7 = (_mtl_u._MainRotation * origin_8);
  float3 tmpvar_206;
  tmpvar_206 = (_mtl_u._DetailRotation * planet_pos_7).xyz;
  tmpvar_12 = planet_pos_7.xyz;
  float3 tmpvar_207;
  tmpvar_207 = normalize(planet_pos_7.xyz);
  float2 uv_208;
  float tmpvar_209;
  float tmpvar_210;
  tmpvar_210 = (min (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0) / max (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0));
  float tmpvar_211;
  tmpvar_211 = (tmpvar_210 * tmpvar_210);
  tmpvar_211 = (((
    ((((
      ((((-0.01213232 * tmpvar_211) + 0.05368138) * tmpvar_211) - 0.1173503)
     * tmpvar_211) + 0.1938925) * tmpvar_211) - 0.3326756)
   * tmpvar_211) + 0.9999793) * tmpvar_210);
  tmpvar_211 = (tmpvar_211 + (float(
    (abs((tmpvar_207.x / tmpvar_207.z)) > 1.0)
  ) * (
    (tmpvar_211 * -2.0)
   + 1.570796)));
  tmpvar_209 = (tmpvar_211 * sign((tmpvar_207.x / tmpvar_207.z)));
  if ((abs(tmpvar_207.z) > (1e-08 * abs(tmpvar_207.x)))) {
    if ((tmpvar_207.z < 0.0)) {
      if ((tmpvar_207.x >= 0.0)) {
        tmpvar_209 += 3.141593;
      } else {
        tmpvar_209 = (tmpvar_209 - 3.141593);
      };
    };
  } else {
    tmpvar_209 = (sign(tmpvar_207.x) * 1.570796);
  };
  uv_208.x = (0.5 + (0.1591549 * tmpvar_209));
  uv_208.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_207.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_207.y)
    )) * (1.570796 + (
      abs(tmpvar_207.y)
     * 
      (-0.2146018 + (abs(tmpvar_207.y) * (0.08656672 + (
        abs(tmpvar_207.y)
       * -0.03102955))))
    ))))
  )));
  half4 tmpvar_212;
  tmpvar_212 = _MainTex.sample(_mtlsmp__MainTex, (float2)(uv_208), level(0.0));
  half4 tmpvar_213;
  tmpvar_213 = tmpvar_212;
  tmpvar_9 = tmpvar_213;
  half3 detailCoords_214;
  half s_215;
  half nylerp_216;
  half zxlerp_217;
  float4 uv4_218;
  uv4_218.zw = float2(0.0, 0.0);
  float3 tmpvar_219;
  tmpvar_219 = normalize(tmpvar_206);
  float3 tmpvar_220;
  tmpvar_220 = abs(tmpvar_219);
  float tmpvar_221;
  tmpvar_221 = float((tmpvar_220.z >= tmpvar_220.x));
  zxlerp_217 = half(tmpvar_221);
  float tmpvar_222;
  tmpvar_222 = float((max (tmpvar_220.x, tmpvar_220.z) >= tmpvar_220.y));
  nylerp_216 = half(tmpvar_222);
  float tmpvar_223;
  tmpvar_223 = mix (tmpvar_219.x, tmpvar_219.z, (float)zxlerp_217);
  s_215 = half(tmpvar_223);
  float tmpvar_224;
  tmpvar_224 = sign(mix (tmpvar_219.y, (float)s_215, (float)nylerp_216));
  s_215 = half(tmpvar_224);
  half3 tmpvar_225;
  tmpvar_225.xz = half2(float2(1.0, -1.0));
  tmpvar_225.y = -(s_215);
  half3 tmpvar_226;
  tmpvar_226.xz = half2(float2(1.0, -1.0));
  tmpvar_226.y = s_215;
  float3 tmpvar_227;
  tmpvar_227 = mix (((float3)tmpvar_225 * tmpvar_219.xzy), ((float3)tmpvar_226 * tmpvar_219.zxy), (float3)half3(zxlerp_217));
  detailCoords_214 = half3(tmpvar_227);
  half3 tmpvar_228;
  tmpvar_228.xy = half2(float2(1.0, 1.0));
  tmpvar_228.z = s_215;
  float3 tmpvar_229;
  tmpvar_229 = mix (((float3)tmpvar_228 * tmpvar_219.yxz), (float3)detailCoords_214, (float3)half3(nylerp_216));
  detailCoords_214 = half3(tmpvar_229);
  half2 tmpvar_230;
  tmpvar_230 = ((((half)0.5 * detailCoords_214.yz) / abs(detailCoords_214.x)) + (half)0.5);
  uv4_218.xy = float2(tmpvar_230);
  half4 tmpvar_231;
  tmpvar_231 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv4_218.xy), level(0.0));
  half4 tmpvar_232;
  tmpvar_232 = tmpvar_231;
  tmpvar_9 = (tmpvar_9 * tmpvar_232);
  float4 tmpvar_233;
  tmpvar_233.w = 0.0;
  tmpvar_233.xyz = _mtl_u._WorldSpaceCameraPos;
  float tmpvar_234;
  float4 tmpvar_235;
  tmpvar_235 = (origin_8 - tmpvar_233);
  tmpvar_234 = sqrt(dot (tmpvar_235, tmpvar_235));
  float tmpvar_236;
  tmpvar_236 = (clamp ((_mtl_u._DistFade * tmpvar_234), 0.0, 1.0) * clamp ((1.0 - 
    (_mtl_u._DistFadeVert * tmpvar_234)
  ), 0.0, 1.0));
  tmpvar_10.w = half(tmpvar_236);
  tmpvar_9.w = (tmpvar_9.w * tmpvar_10.w);
  float3 tmpvar_237;
  tmpvar_237.yz = float2(0.0, 0.0);
  tmpvar_237.x = fract(_mtl_u._Rotation);
  float3 x_238;
  x_238 = (tmpvar_237 + tmpvar_204);
  float3 trans_239;
  trans_239 = localOrigin_6.xyz;
  float tmpvar_240;
  tmpvar_240 = (x_238.x * 6.283185);
  float tmpvar_241;
  tmpvar_241 = (x_238.y * 6.283185);
  float tmpvar_242;
  tmpvar_242 = (x_238.z * 2.0);
  float tmpvar_243;
  tmpvar_243 = sqrt(tmpvar_242);
  float tmpvar_244;
  tmpvar_244 = (sin(tmpvar_241) * tmpvar_243);
  float tmpvar_245;
  tmpvar_245 = (cos(tmpvar_241) * tmpvar_243);
  float tmpvar_246;
  tmpvar_246 = sqrt((2.0 - tmpvar_242));
  float tmpvar_247;
  tmpvar_247 = sin(tmpvar_240);
  float tmpvar_248;
  tmpvar_248 = cos(tmpvar_240);
  float tmpvar_249;
  tmpvar_249 = ((tmpvar_244 * tmpvar_248) - (tmpvar_245 * tmpvar_247));
  float tmpvar_250;
  tmpvar_250 = ((tmpvar_244 * tmpvar_247) + (tmpvar_245 * tmpvar_248));
  float4x4 tmpvar_251;
  tmpvar_251[0].x = (tmpvar_205 * ((tmpvar_244 * tmpvar_249) - tmpvar_248));
  tmpvar_251[0].y = ((tmpvar_244 * tmpvar_250) - tmpvar_247);
  tmpvar_251[0].z = (tmpvar_244 * tmpvar_246);
  tmpvar_251[0].w = 0.0;
  tmpvar_251[1].x = ((tmpvar_245 * tmpvar_249) + tmpvar_247);
  tmpvar_251[1].y = (tmpvar_205 * ((tmpvar_245 * tmpvar_250) - tmpvar_248));
  tmpvar_251[1].z = (tmpvar_245 * tmpvar_246);
  tmpvar_251[1].w = 0.0;
  tmpvar_251[2].x = (tmpvar_246 * tmpvar_249);
  tmpvar_251[2].y = (tmpvar_246 * tmpvar_250);
  tmpvar_251[2].z = (tmpvar_205 * (1.0 - tmpvar_242));
  tmpvar_251[2].w = 0.0;
  tmpvar_251[3].x = trans_239.x;
  tmpvar_251[3].y = trans_239.y;
  tmpvar_251[3].z = trans_239.z;
  tmpvar_251[3].w = 1.0;
  float4x4 tmpvar_252;
  tmpvar_252 = ((_mtl_u.unity_MatrixV * _mtl_u._Object2World) * tmpvar_251);
  float4 v_253;
  v_253.x = tmpvar_252[0].z;
  v_253.y = tmpvar_252[1].z;
  v_253.z = tmpvar_252[2].z;
  v_253.w = tmpvar_252[3].z;
  float3 tmpvar_254;
  tmpvar_254 = normalize(v_253.xyz);
  float3 tmpvar_255;
  tmpvar_255 = abs(tmpvar_254);
  tmpvar_10.xyz = half3(tmpvar_255);
  float4 tmpvar_256;
  tmpvar_256 = (_mtl_u.glstate_matrix_modelview0 * localOrigin_6);
  float4 tmpvar_257;
  tmpvar_257.xyz = (_mtl_i._glesVertex.xyz * tmpvar_205);
  tmpvar_257.w = _mtl_i._glesVertex.w;
  float2 tmpvar_258;
  tmpvar_258 = ((2.0 * _mtl_i._glesMultiTexCoord0.xy) - 1.0);
  float4 tmpvar_259;
  tmpvar_259.z = 0.0;
  tmpvar_259.xy = tmpvar_258;
  tmpvar_259.w = _mtl_i._glesVertex.w;
  ZYv_5.xyw = tmpvar_259.zyw;
  XZv_4.yzw = tmpvar_259.zyw;
  XYv_3.yzw = tmpvar_259.yzw;
  ZYv_5.z = (tmpvar_258.x * sign(-(tmpvar_254.x)));
  XZv_4.x = (tmpvar_258.x * sign(-(tmpvar_254.y)));
  XYv_3.x = (tmpvar_258.x * sign(tmpvar_254.z));
  ZYv_5.x = ((sign(
    -(tmpvar_254.x)
  ) * sign(ZYv_5.z)) * tmpvar_254.z);
  XZv_4.y = ((sign(
    -(tmpvar_254.y)
  ) * sign(XZv_4.x)) * tmpvar_254.x);
  XYv_3.z = ((sign(
    -(tmpvar_254.z)
  ) * sign(XYv_3.x)) * tmpvar_254.x);
  ZYv_5.x = (ZYv_5.x + ((
    sign(-(tmpvar_254.x))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  XZv_4.y = (XZv_4.y + ((
    sign(-(tmpvar_254.y))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.z));
  XYv_3.z = (XYv_3.z + ((
    sign(-(tmpvar_254.z))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  float3 tmpvar_260;
  tmpvar_260 = normalize((origin_8.xyz - _mtl_u._WorldSpaceCameraPos));
  float3 tmpvar_261;
  tmpvar_261 = normalize(-(tmpvar_260));
  normal_2 = half3(tmpvar_261);
  float4 v_262;
  v_262.x = _mtl_u.unity_MatrixV[0].x;
  v_262.y = _mtl_u.unity_MatrixV[1].x;
  v_262.z = _mtl_u.unity_MatrixV[2].x;
  v_262.w = _mtl_u.unity_MatrixV[3].x;
  float3 tmpvar_263;
  tmpvar_263 = normalize(v_262.xyz);
  float3 tmpvar_264;
  float3 tmpvar_265;
  tmpvar_264 = v_262.xyz;
  tmpvar_265 = (((float3)normal_2.zxy * tmpvar_263.yzx) - ((float3)normal_2.yzx * tmpvar_263.zxy));
  float3 tmpvar_266;
  tmpvar_266 = float3(normal_2);
  float3x3 tmpvar_267;
  tmpvar_267[0].x = tmpvar_264.x;
  tmpvar_267[0].y = tmpvar_265.x;
  tmpvar_267[0].z = tmpvar_266.x;
  tmpvar_267[1].x = tmpvar_264.y;
  tmpvar_267[1].y = tmpvar_265.y;
  tmpvar_267[1].z = tmpvar_266.y;
  tmpvar_267[2].x = tmpvar_264.z;
  tmpvar_267[2].y = tmpvar_265.z;
  tmpvar_267[2].z = tmpvar_266.z;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_projection * (tmpvar_256 + tmpvar_257));
  _mtl_o.xlv_COLOR = tmpvar_9;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_10;
  _mtl_o.xlv_TEXCOORD1 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * ZYv_5)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD2 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XZv_4)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD3 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XYv_3)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD4 = tmpvar_1;
  _mtl_o.xlv_TEXCOORD5 = tmpvar_11;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_12;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_267 * tmpvar_260));
  _mtl_o.xlv_TEXCOORD8 = normalize((tmpvar_267 * (float3)_mtl_u._WorldSpaceLightPos0.xyz));
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 38 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 _WorldSpaceLightPos0;
uniform highp mat4 glstate_matrix_modelview0;
uniform highp mat4 _Object2World;
uniform highp mat4 glstate_matrix_projection;
uniform highp mat4 unity_MatrixV;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform highp mat4 _PosRotation;
uniform highp float _DistFade;
uniform highp float _DistFadeVert;
uniform highp float _Rotation;
uniform highp float _MaxScale;
uniform highp vec4 _NoiseScale;
uniform highp vec3 _MaxTrans;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec4 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  mediump vec3 normal_3;
  highp vec4 XYv_4;
  highp vec4 XZv_5;
  highp vec4 ZYv_6;
  highp vec4 localOrigin_7;
  highp vec4 planet_pos_8;
  highp vec4 origin_9;
  lowp vec4 tmpvar_10;
  mediump vec4 tmpvar_11;
  highp vec4 tmpvar_12;
  highp vec3 tmpvar_13;
  highp vec4 tmpvar_14;
  tmpvar_14 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_9 = tmpvar_14;
  highp vec4 tmpvar_15;
  tmpvar_15 = (_PosRotation * tmpvar_14);
  planet_pos_8 = tmpvar_15;
  highp vec3 tmpvar_16;
  tmpvar_16 = (_NoiseScale.z * tmpvar_15.xyz);
  highp float tmpvar_17;
  highp vec4 m_18;
  highp vec3 tmpvar_19;
  tmpvar_19 = floor((tmpvar_16 + dot (tmpvar_16, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_20;
  tmpvar_20 = ((tmpvar_16 - tmpvar_19) + dot (tmpvar_19, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_21;
  tmpvar_21.x = float((tmpvar_20.x >= tmpvar_20.y));
  tmpvar_21.y = float((tmpvar_20.y >= tmpvar_20.z));
  tmpvar_21.z = float((tmpvar_20.z >= tmpvar_20.x));
  highp vec3 tmpvar_22;
  tmpvar_22 = (1.0 - tmpvar_21);
  highp vec3 tmpvar_23;
  tmpvar_23 = min (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_24;
  tmpvar_24 = max (tmpvar_21, tmpvar_22.zxy);
  highp vec3 tmpvar_25;
  tmpvar_25 = ((tmpvar_20 - tmpvar_23) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_26;
  tmpvar_26 = ((tmpvar_20 - tmpvar_24) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_27;
  tmpvar_27 = (tmpvar_20 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_28;
  tmpvar_28 = (tmpvar_19 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_29;
  tmpvar_29 = (fract(abs(tmpvar_28)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_30;
  if ((tmpvar_28.x >= 0.0)) {
    tmpvar_30 = tmpvar_29.x;
  } else {
    tmpvar_30 = -(tmpvar_29.x);
  };
  highp float tmpvar_31;
  if ((tmpvar_28.y >= 0.0)) {
    tmpvar_31 = tmpvar_29.y;
  } else {
    tmpvar_31 = -(tmpvar_29.y);
  };
  highp float tmpvar_32;
  if ((tmpvar_28.z >= 0.0)) {
    tmpvar_32 = tmpvar_29.z;
  } else {
    tmpvar_32 = -(tmpvar_29.z);
  };
  highp vec4 tmpvar_33;
  tmpvar_33.xw = vec2(0.0, 1.0);
  tmpvar_33.y = tmpvar_23.z;
  tmpvar_33.z = tmpvar_24.z;
  highp vec4 x_34;
  x_34 = (tmpvar_32 + tmpvar_33);
  highp vec4 tmpvar_35;
  tmpvar_35 = (((
    (x_34 * x_34)
   * 34.0) + x_34) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_36;
  tmpvar_36 = (fract(abs(tmpvar_35)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_37;
  if ((tmpvar_35.x >= 0.0)) {
    tmpvar_37 = tmpvar_36.x;
  } else {
    tmpvar_37 = -(tmpvar_36.x);
  };
  highp float tmpvar_38;
  if ((tmpvar_35.y >= 0.0)) {
    tmpvar_38 = tmpvar_36.y;
  } else {
    tmpvar_38 = -(tmpvar_36.y);
  };
  highp float tmpvar_39;
  if ((tmpvar_35.z >= 0.0)) {
    tmpvar_39 = tmpvar_36.z;
  } else {
    tmpvar_39 = -(tmpvar_36.z);
  };
  highp float tmpvar_40;
  if ((tmpvar_35.w >= 0.0)) {
    tmpvar_40 = tmpvar_36.w;
  } else {
    tmpvar_40 = -(tmpvar_36.w);
  };
  highp vec4 tmpvar_41;
  tmpvar_41.x = tmpvar_37;
  tmpvar_41.y = tmpvar_38;
  tmpvar_41.z = tmpvar_39;
  tmpvar_41.w = tmpvar_40;
  highp vec4 tmpvar_42;
  tmpvar_42.xw = vec2(0.0, 1.0);
  tmpvar_42.y = tmpvar_23.y;
  tmpvar_42.z = tmpvar_24.y;
  highp vec4 x_43;
  x_43 = ((tmpvar_41 + tmpvar_31) + tmpvar_42);
  highp vec4 tmpvar_44;
  tmpvar_44 = (((
    (x_43 * x_43)
   * 34.0) + x_43) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_45;
  tmpvar_45 = (fract(abs(tmpvar_44)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_46;
  if ((tmpvar_44.x >= 0.0)) {
    tmpvar_46 = tmpvar_45.x;
  } else {
    tmpvar_46 = -(tmpvar_45.x);
  };
  highp float tmpvar_47;
  if ((tmpvar_44.y >= 0.0)) {
    tmpvar_47 = tmpvar_45.y;
  } else {
    tmpvar_47 = -(tmpvar_45.y);
  };
  highp float tmpvar_48;
  if ((tmpvar_44.z >= 0.0)) {
    tmpvar_48 = tmpvar_45.z;
  } else {
    tmpvar_48 = -(tmpvar_45.z);
  };
  highp float tmpvar_49;
  if ((tmpvar_44.w >= 0.0)) {
    tmpvar_49 = tmpvar_45.w;
  } else {
    tmpvar_49 = -(tmpvar_45.w);
  };
  highp vec4 tmpvar_50;
  tmpvar_50.x = tmpvar_46;
  tmpvar_50.y = tmpvar_47;
  tmpvar_50.z = tmpvar_48;
  tmpvar_50.w = tmpvar_49;
  highp vec4 tmpvar_51;
  tmpvar_51.xw = vec2(0.0, 1.0);
  tmpvar_51.y = tmpvar_23.x;
  tmpvar_51.z = tmpvar_24.x;
  highp vec4 x_52;
  x_52 = ((tmpvar_50 + tmpvar_30) + tmpvar_51);
  highp vec4 tmpvar_53;
  tmpvar_53 = (((
    (x_52 * x_52)
   * 34.0) + x_52) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_54;
  tmpvar_54 = (fract(abs(tmpvar_53)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_55;
  if ((tmpvar_53.x >= 0.0)) {
    tmpvar_55 = tmpvar_54.x;
  } else {
    tmpvar_55 = -(tmpvar_54.x);
  };
  highp float tmpvar_56;
  if ((tmpvar_53.y >= 0.0)) {
    tmpvar_56 = tmpvar_54.y;
  } else {
    tmpvar_56 = -(tmpvar_54.y);
  };
  highp float tmpvar_57;
  if ((tmpvar_53.z >= 0.0)) {
    tmpvar_57 = tmpvar_54.z;
  } else {
    tmpvar_57 = -(tmpvar_54.z);
  };
  highp float tmpvar_58;
  if ((tmpvar_53.w >= 0.0)) {
    tmpvar_58 = tmpvar_54.w;
  } else {
    tmpvar_58 = -(tmpvar_54.w);
  };
  highp vec4 tmpvar_59;
  tmpvar_59.x = tmpvar_55;
  tmpvar_59.y = tmpvar_56;
  tmpvar_59.z = tmpvar_57;
  tmpvar_59.w = tmpvar_58;
  highp vec4 tmpvar_60;
  tmpvar_60 = (tmpvar_59 - (49.0 * floor(
    (0.02040815 * tmpvar_59)
  )));
  highp vec4 tmpvar_61;
  tmpvar_61 = floor((tmpvar_60 * 0.1428571));
  highp vec4 tmpvar_62;
  tmpvar_62 = ((tmpvar_61 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_63;
  tmpvar_63 = ((floor(
    (tmpvar_60 - (7.0 * tmpvar_61))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_64;
  tmpvar_64 = ((1.0 - abs(tmpvar_62)) - abs(tmpvar_63));
  highp vec4 tmpvar_65;
  tmpvar_65.xy = tmpvar_62.xy;
  tmpvar_65.zw = tmpvar_63.xy;
  highp vec4 tmpvar_66;
  tmpvar_66.xy = tmpvar_62.zw;
  tmpvar_66.zw = tmpvar_63.zw;
  highp vec4 tmpvar_67;
  tmpvar_67 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_64)));
  highp vec4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_67.xxyy));
  highp vec4 tmpvar_69;
  tmpvar_69 = (tmpvar_66.xzyw + ((
    (floor(tmpvar_66) * 2.0)
   + 1.0).xzyw * tmpvar_67.zzww));
  highp vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_68.xy;
  tmpvar_70.z = tmpvar_64.x;
  highp vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.zw;
  tmpvar_71.z = tmpvar_64.y;
  highp vec3 tmpvar_72;
  tmpvar_72.xy = tmpvar_69.xy;
  tmpvar_72.z = tmpvar_64.z;
  highp vec3 tmpvar_73;
  tmpvar_73.xy = tmpvar_69.zw;
  tmpvar_73.z = tmpvar_64.w;
  highp vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_70, tmpvar_70);
  tmpvar_74.y = dot (tmpvar_71, tmpvar_71);
  tmpvar_74.z = dot (tmpvar_72, tmpvar_72);
  tmpvar_74.w = dot (tmpvar_73, tmpvar_73);
  highp vec4 tmpvar_75;
  tmpvar_75 = (1.792843 - (0.8537347 * tmpvar_74));
  highp vec4 tmpvar_76;
  tmpvar_76.x = dot (tmpvar_20, tmpvar_20);
  tmpvar_76.y = dot (tmpvar_25, tmpvar_25);
  tmpvar_76.z = dot (tmpvar_26, tmpvar_26);
  tmpvar_76.w = dot (tmpvar_27, tmpvar_27);
  highp vec4 tmpvar_77;
  tmpvar_77 = max ((0.6 - tmpvar_76), vec4(0.0, 0.0, 0.0, 0.0));
  m_18 = (tmpvar_77 * tmpvar_77);
  highp vec4 tmpvar_78;
  tmpvar_78.x = dot ((tmpvar_70 * tmpvar_75.x), tmpvar_20);
  tmpvar_78.y = dot ((tmpvar_71 * tmpvar_75.y), tmpvar_25);
  tmpvar_78.z = dot ((tmpvar_72 * tmpvar_75.z), tmpvar_26);
  tmpvar_78.w = dot ((tmpvar_73 * tmpvar_75.w), tmpvar_27);
  tmpvar_17 = (42.0 * dot ((m_18 * m_18), tmpvar_78));
  highp float tmpvar_79;
  highp vec3 v_80;
  v_80 = (_NoiseScale.x * tmpvar_16);
  highp vec4 m_81;
  highp vec3 tmpvar_82;
  tmpvar_82 = floor((v_80 + dot (v_80, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_83;
  tmpvar_83 = ((v_80 - tmpvar_82) + dot (tmpvar_82, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_84;
  tmpvar_84.x = float((tmpvar_83.x >= tmpvar_83.y));
  tmpvar_84.y = float((tmpvar_83.y >= tmpvar_83.z));
  tmpvar_84.z = float((tmpvar_83.z >= tmpvar_83.x));
  highp vec3 tmpvar_85;
  tmpvar_85 = (1.0 - tmpvar_84);
  highp vec3 tmpvar_86;
  tmpvar_86 = min (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_87;
  tmpvar_87 = max (tmpvar_84, tmpvar_85.zxy);
  highp vec3 tmpvar_88;
  tmpvar_88 = ((tmpvar_83 - tmpvar_86) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_89;
  tmpvar_89 = ((tmpvar_83 - tmpvar_87) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_90;
  tmpvar_90 = (tmpvar_83 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_91;
  tmpvar_91 = (tmpvar_82 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = (fract(abs(tmpvar_91)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_93;
  if ((tmpvar_91.x >= 0.0)) {
    tmpvar_93 = tmpvar_92.x;
  } else {
    tmpvar_93 = -(tmpvar_92.x);
  };
  highp float tmpvar_94;
  if ((tmpvar_91.y >= 0.0)) {
    tmpvar_94 = tmpvar_92.y;
  } else {
    tmpvar_94 = -(tmpvar_92.y);
  };
  highp float tmpvar_95;
  if ((tmpvar_91.z >= 0.0)) {
    tmpvar_95 = tmpvar_92.z;
  } else {
    tmpvar_95 = -(tmpvar_92.z);
  };
  highp vec4 tmpvar_96;
  tmpvar_96.xw = vec2(0.0, 1.0);
  tmpvar_96.y = tmpvar_86.z;
  tmpvar_96.z = tmpvar_87.z;
  highp vec4 x_97;
  x_97 = (tmpvar_95 + tmpvar_96);
  highp vec4 tmpvar_98;
  tmpvar_98 = (((
    (x_97 * x_97)
   * 34.0) + x_97) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_99;
  tmpvar_99 = (fract(abs(tmpvar_98)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_100;
  if ((tmpvar_98.x >= 0.0)) {
    tmpvar_100 = tmpvar_99.x;
  } else {
    tmpvar_100 = -(tmpvar_99.x);
  };
  highp float tmpvar_101;
  if ((tmpvar_98.y >= 0.0)) {
    tmpvar_101 = tmpvar_99.y;
  } else {
    tmpvar_101 = -(tmpvar_99.y);
  };
  highp float tmpvar_102;
  if ((tmpvar_98.z >= 0.0)) {
    tmpvar_102 = tmpvar_99.z;
  } else {
    tmpvar_102 = -(tmpvar_99.z);
  };
  highp float tmpvar_103;
  if ((tmpvar_98.w >= 0.0)) {
    tmpvar_103 = tmpvar_99.w;
  } else {
    tmpvar_103 = -(tmpvar_99.w);
  };
  highp vec4 tmpvar_104;
  tmpvar_104.x = tmpvar_100;
  tmpvar_104.y = tmpvar_101;
  tmpvar_104.z = tmpvar_102;
  tmpvar_104.w = tmpvar_103;
  highp vec4 tmpvar_105;
  tmpvar_105.xw = vec2(0.0, 1.0);
  tmpvar_105.y = tmpvar_86.y;
  tmpvar_105.z = tmpvar_87.y;
  highp vec4 x_106;
  x_106 = ((tmpvar_104 + tmpvar_94) + tmpvar_105);
  highp vec4 tmpvar_107;
  tmpvar_107 = (((
    (x_106 * x_106)
   * 34.0) + x_106) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_108;
  tmpvar_108 = (fract(abs(tmpvar_107)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_109;
  if ((tmpvar_107.x >= 0.0)) {
    tmpvar_109 = tmpvar_108.x;
  } else {
    tmpvar_109 = -(tmpvar_108.x);
  };
  highp float tmpvar_110;
  if ((tmpvar_107.y >= 0.0)) {
    tmpvar_110 = tmpvar_108.y;
  } else {
    tmpvar_110 = -(tmpvar_108.y);
  };
  highp float tmpvar_111;
  if ((tmpvar_107.z >= 0.0)) {
    tmpvar_111 = tmpvar_108.z;
  } else {
    tmpvar_111 = -(tmpvar_108.z);
  };
  highp float tmpvar_112;
  if ((tmpvar_107.w >= 0.0)) {
    tmpvar_112 = tmpvar_108.w;
  } else {
    tmpvar_112 = -(tmpvar_108.w);
  };
  highp vec4 tmpvar_113;
  tmpvar_113.x = tmpvar_109;
  tmpvar_113.y = tmpvar_110;
  tmpvar_113.z = tmpvar_111;
  tmpvar_113.w = tmpvar_112;
  highp vec4 tmpvar_114;
  tmpvar_114.xw = vec2(0.0, 1.0);
  tmpvar_114.y = tmpvar_86.x;
  tmpvar_114.z = tmpvar_87.x;
  highp vec4 x_115;
  x_115 = ((tmpvar_113 + tmpvar_93) + tmpvar_114);
  highp vec4 tmpvar_116;
  tmpvar_116 = (((
    (x_115 * x_115)
   * 34.0) + x_115) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_117;
  tmpvar_117 = (fract(abs(tmpvar_116)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_118;
  if ((tmpvar_116.x >= 0.0)) {
    tmpvar_118 = tmpvar_117.x;
  } else {
    tmpvar_118 = -(tmpvar_117.x);
  };
  highp float tmpvar_119;
  if ((tmpvar_116.y >= 0.0)) {
    tmpvar_119 = tmpvar_117.y;
  } else {
    tmpvar_119 = -(tmpvar_117.y);
  };
  highp float tmpvar_120;
  if ((tmpvar_116.z >= 0.0)) {
    tmpvar_120 = tmpvar_117.z;
  } else {
    tmpvar_120 = -(tmpvar_117.z);
  };
  highp float tmpvar_121;
  if ((tmpvar_116.w >= 0.0)) {
    tmpvar_121 = tmpvar_117.w;
  } else {
    tmpvar_121 = -(tmpvar_117.w);
  };
  highp vec4 tmpvar_122;
  tmpvar_122.x = tmpvar_118;
  tmpvar_122.y = tmpvar_119;
  tmpvar_122.z = tmpvar_120;
  tmpvar_122.w = tmpvar_121;
  highp vec4 tmpvar_123;
  tmpvar_123 = (tmpvar_122 - (49.0 * floor(
    (0.02040815 * tmpvar_122)
  )));
  highp vec4 tmpvar_124;
  tmpvar_124 = floor((tmpvar_123 * 0.1428571));
  highp vec4 tmpvar_125;
  tmpvar_125 = ((tmpvar_124 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_126;
  tmpvar_126 = ((floor(
    (tmpvar_123 - (7.0 * tmpvar_124))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_127;
  tmpvar_127 = ((1.0 - abs(tmpvar_125)) - abs(tmpvar_126));
  highp vec4 tmpvar_128;
  tmpvar_128.xy = tmpvar_125.xy;
  tmpvar_128.zw = tmpvar_126.xy;
  highp vec4 tmpvar_129;
  tmpvar_129.xy = tmpvar_125.zw;
  tmpvar_129.zw = tmpvar_126.zw;
  highp vec4 tmpvar_130;
  tmpvar_130 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_127)));
  highp vec4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_130.xxyy));
  highp vec4 tmpvar_132;
  tmpvar_132 = (tmpvar_129.xzyw + ((
    (floor(tmpvar_129) * 2.0)
   + 1.0).xzyw * tmpvar_130.zzww));
  highp vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_131.xy;
  tmpvar_133.z = tmpvar_127.x;
  highp vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.zw;
  tmpvar_134.z = tmpvar_127.y;
  highp vec3 tmpvar_135;
  tmpvar_135.xy = tmpvar_132.xy;
  tmpvar_135.z = tmpvar_127.z;
  highp vec3 tmpvar_136;
  tmpvar_136.xy = tmpvar_132.zw;
  tmpvar_136.z = tmpvar_127.w;
  highp vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_133, tmpvar_133);
  tmpvar_137.y = dot (tmpvar_134, tmpvar_134);
  tmpvar_137.z = dot (tmpvar_135, tmpvar_135);
  tmpvar_137.w = dot (tmpvar_136, tmpvar_136);
  highp vec4 tmpvar_138;
  tmpvar_138 = (1.792843 - (0.8537347 * tmpvar_137));
  highp vec4 tmpvar_139;
  tmpvar_139.x = dot (tmpvar_83, tmpvar_83);
  tmpvar_139.y = dot (tmpvar_88, tmpvar_88);
  tmpvar_139.z = dot (tmpvar_89, tmpvar_89);
  tmpvar_139.w = dot (tmpvar_90, tmpvar_90);
  highp vec4 tmpvar_140;
  tmpvar_140 = max ((0.6 - tmpvar_139), vec4(0.0, 0.0, 0.0, 0.0));
  m_81 = (tmpvar_140 * tmpvar_140);
  highp vec4 tmpvar_141;
  tmpvar_141.x = dot ((tmpvar_133 * tmpvar_138.x), tmpvar_83);
  tmpvar_141.y = dot ((tmpvar_134 * tmpvar_138.y), tmpvar_88);
  tmpvar_141.z = dot ((tmpvar_135 * tmpvar_138.z), tmpvar_89);
  tmpvar_141.w = dot ((tmpvar_136 * tmpvar_138.w), tmpvar_90);
  tmpvar_79 = (42.0 * dot ((m_81 * m_81), tmpvar_141));
  highp vec3 v_142;
  v_142 = (_NoiseScale.y * tmpvar_16);
  highp vec4 m_143;
  highp vec3 tmpvar_144;
  tmpvar_144 = floor((v_142 + dot (v_142, vec3(0.3333333, 0.3333333, 0.3333333))));
  highp vec3 tmpvar_145;
  tmpvar_145 = ((v_142 - tmpvar_144) + dot (tmpvar_144, vec3(0.1666667, 0.1666667, 0.1666667)));
  highp vec3 tmpvar_146;
  tmpvar_146.x = float((tmpvar_145.x >= tmpvar_145.y));
  tmpvar_146.y = float((tmpvar_145.y >= tmpvar_145.z));
  tmpvar_146.z = float((tmpvar_145.z >= tmpvar_145.x));
  highp vec3 tmpvar_147;
  tmpvar_147 = (1.0 - tmpvar_146);
  highp vec3 tmpvar_148;
  tmpvar_148 = min (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_149;
  tmpvar_149 = max (tmpvar_146, tmpvar_147.zxy);
  highp vec3 tmpvar_150;
  tmpvar_150 = ((tmpvar_145 - tmpvar_148) + vec3(0.1666667, 0.1666667, 0.1666667));
  highp vec3 tmpvar_151;
  tmpvar_151 = ((tmpvar_145 - tmpvar_149) + vec3(0.3333333, 0.3333333, 0.3333333));
  highp vec3 tmpvar_152;
  tmpvar_152 = (tmpvar_145 - vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_153;
  tmpvar_153 = (tmpvar_144 / vec3(289.0, 289.0, 289.0));
  highp vec3 tmpvar_154;
  tmpvar_154 = (fract(abs(tmpvar_153)) * vec3(289.0, 289.0, 289.0));
  highp float tmpvar_155;
  if ((tmpvar_153.x >= 0.0)) {
    tmpvar_155 = tmpvar_154.x;
  } else {
    tmpvar_155 = -(tmpvar_154.x);
  };
  highp float tmpvar_156;
  if ((tmpvar_153.y >= 0.0)) {
    tmpvar_156 = tmpvar_154.y;
  } else {
    tmpvar_156 = -(tmpvar_154.y);
  };
  highp float tmpvar_157;
  if ((tmpvar_153.z >= 0.0)) {
    tmpvar_157 = tmpvar_154.z;
  } else {
    tmpvar_157 = -(tmpvar_154.z);
  };
  highp vec4 tmpvar_158;
  tmpvar_158.xw = vec2(0.0, 1.0);
  tmpvar_158.y = tmpvar_148.z;
  tmpvar_158.z = tmpvar_149.z;
  highp vec4 x_159;
  x_159 = (tmpvar_157 + tmpvar_158);
  highp vec4 tmpvar_160;
  tmpvar_160 = (((
    (x_159 * x_159)
   * 34.0) + x_159) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_161;
  tmpvar_161 = (fract(abs(tmpvar_160)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_162;
  if ((tmpvar_160.x >= 0.0)) {
    tmpvar_162 = tmpvar_161.x;
  } else {
    tmpvar_162 = -(tmpvar_161.x);
  };
  highp float tmpvar_163;
  if ((tmpvar_160.y >= 0.0)) {
    tmpvar_163 = tmpvar_161.y;
  } else {
    tmpvar_163 = -(tmpvar_161.y);
  };
  highp float tmpvar_164;
  if ((tmpvar_160.z >= 0.0)) {
    tmpvar_164 = tmpvar_161.z;
  } else {
    tmpvar_164 = -(tmpvar_161.z);
  };
  highp float tmpvar_165;
  if ((tmpvar_160.w >= 0.0)) {
    tmpvar_165 = tmpvar_161.w;
  } else {
    tmpvar_165 = -(tmpvar_161.w);
  };
  highp vec4 tmpvar_166;
  tmpvar_166.x = tmpvar_162;
  tmpvar_166.y = tmpvar_163;
  tmpvar_166.z = tmpvar_164;
  tmpvar_166.w = tmpvar_165;
  highp vec4 tmpvar_167;
  tmpvar_167.xw = vec2(0.0, 1.0);
  tmpvar_167.y = tmpvar_148.y;
  tmpvar_167.z = tmpvar_149.y;
  highp vec4 x_168;
  x_168 = ((tmpvar_166 + tmpvar_156) + tmpvar_167);
  highp vec4 tmpvar_169;
  tmpvar_169 = (((
    (x_168 * x_168)
   * 34.0) + x_168) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_170;
  tmpvar_170 = (fract(abs(tmpvar_169)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_171;
  if ((tmpvar_169.x >= 0.0)) {
    tmpvar_171 = tmpvar_170.x;
  } else {
    tmpvar_171 = -(tmpvar_170.x);
  };
  highp float tmpvar_172;
  if ((tmpvar_169.y >= 0.0)) {
    tmpvar_172 = tmpvar_170.y;
  } else {
    tmpvar_172 = -(tmpvar_170.y);
  };
  highp float tmpvar_173;
  if ((tmpvar_169.z >= 0.0)) {
    tmpvar_173 = tmpvar_170.z;
  } else {
    tmpvar_173 = -(tmpvar_170.z);
  };
  highp float tmpvar_174;
  if ((tmpvar_169.w >= 0.0)) {
    tmpvar_174 = tmpvar_170.w;
  } else {
    tmpvar_174 = -(tmpvar_170.w);
  };
  highp vec4 tmpvar_175;
  tmpvar_175.x = tmpvar_171;
  tmpvar_175.y = tmpvar_172;
  tmpvar_175.z = tmpvar_173;
  tmpvar_175.w = tmpvar_174;
  highp vec4 tmpvar_176;
  tmpvar_176.xw = vec2(0.0, 1.0);
  tmpvar_176.y = tmpvar_148.x;
  tmpvar_176.z = tmpvar_149.x;
  highp vec4 x_177;
  x_177 = ((tmpvar_175 + tmpvar_155) + tmpvar_176);
  highp vec4 tmpvar_178;
  tmpvar_178 = (((
    (x_177 * x_177)
   * 34.0) + x_177) / vec4(289.0, 289.0, 289.0, 289.0));
  highp vec4 tmpvar_179;
  tmpvar_179 = (fract(abs(tmpvar_178)) * vec4(289.0, 289.0, 289.0, 289.0));
  highp float tmpvar_180;
  if ((tmpvar_178.x >= 0.0)) {
    tmpvar_180 = tmpvar_179.x;
  } else {
    tmpvar_180 = -(tmpvar_179.x);
  };
  highp float tmpvar_181;
  if ((tmpvar_178.y >= 0.0)) {
    tmpvar_181 = tmpvar_179.y;
  } else {
    tmpvar_181 = -(tmpvar_179.y);
  };
  highp float tmpvar_182;
  if ((tmpvar_178.z >= 0.0)) {
    tmpvar_182 = tmpvar_179.z;
  } else {
    tmpvar_182 = -(tmpvar_179.z);
  };
  highp float tmpvar_183;
  if ((tmpvar_178.w >= 0.0)) {
    tmpvar_183 = tmpvar_179.w;
  } else {
    tmpvar_183 = -(tmpvar_179.w);
  };
  highp vec4 tmpvar_184;
  tmpvar_184.x = tmpvar_180;
  tmpvar_184.y = tmpvar_181;
  tmpvar_184.z = tmpvar_182;
  tmpvar_184.w = tmpvar_183;
  highp vec4 tmpvar_185;
  tmpvar_185 = (tmpvar_184 - (49.0 * floor(
    (0.02040815 * tmpvar_184)
  )));
  highp vec4 tmpvar_186;
  tmpvar_186 = floor((tmpvar_185 * 0.1428571));
  highp vec4 tmpvar_187;
  tmpvar_187 = ((tmpvar_186 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_188;
  tmpvar_188 = ((floor(
    (tmpvar_185 - (7.0 * tmpvar_186))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  highp vec4 tmpvar_189;
  tmpvar_189 = ((1.0 - abs(tmpvar_187)) - abs(tmpvar_188));
  highp vec4 tmpvar_190;
  tmpvar_190.xy = tmpvar_187.xy;
  tmpvar_190.zw = tmpvar_188.xy;
  highp vec4 tmpvar_191;
  tmpvar_191.xy = tmpvar_187.zw;
  tmpvar_191.zw = tmpvar_188.zw;
  highp vec4 tmpvar_192;
  tmpvar_192 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_189)));
  highp vec4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_192.xxyy));
  highp vec4 tmpvar_194;
  tmpvar_194 = (tmpvar_191.xzyw + ((
    (floor(tmpvar_191) * 2.0)
   + 1.0).xzyw * tmpvar_192.zzww));
  highp vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_193.xy;
  tmpvar_195.z = tmpvar_189.x;
  highp vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.zw;
  tmpvar_196.z = tmpvar_189.y;
  highp vec3 tmpvar_197;
  tmpvar_197.xy = tmpvar_194.xy;
  tmpvar_197.z = tmpvar_189.z;
  highp vec3 tmpvar_198;
  tmpvar_198.xy = tmpvar_194.zw;
  tmpvar_198.z = tmpvar_189.w;
  highp vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_195, tmpvar_195);
  tmpvar_199.y = dot (tmpvar_196, tmpvar_196);
  tmpvar_199.z = dot (tmpvar_197, tmpvar_197);
  tmpvar_199.w = dot (tmpvar_198, tmpvar_198);
  highp vec4 tmpvar_200;
  tmpvar_200 = (1.792843 - (0.8537347 * tmpvar_199));
  highp vec4 tmpvar_201;
  tmpvar_201.x = dot (tmpvar_145, tmpvar_145);
  tmpvar_201.y = dot (tmpvar_150, tmpvar_150);
  tmpvar_201.z = dot (tmpvar_151, tmpvar_151);
  tmpvar_201.w = dot (tmpvar_152, tmpvar_152);
  highp vec4 tmpvar_202;
  tmpvar_202 = max ((0.6 - tmpvar_201), vec4(0.0, 0.0, 0.0, 0.0));
  m_143 = (tmpvar_202 * tmpvar_202);
  highp vec4 tmpvar_203;
  tmpvar_203.x = dot ((tmpvar_195 * tmpvar_200.x), tmpvar_145);
  tmpvar_203.y = dot ((tmpvar_196 * tmpvar_200.y), tmpvar_150);
  tmpvar_203.z = dot ((tmpvar_197 * tmpvar_200.z), tmpvar_151);
  tmpvar_203.w = dot ((tmpvar_198 * tmpvar_200.w), tmpvar_152);
  highp vec3 tmpvar_204;
  tmpvar_204.x = tmpvar_17;
  tmpvar_204.y = tmpvar_79;
  tmpvar_204.z = (42.0 * dot ((m_143 * m_143), tmpvar_203));
  highp vec3 tmpvar_205;
  tmpvar_205 = (0.5 * (tmpvar_204 + 1.0));
  localOrigin_7.xyz = (((2.0 * tmpvar_205) - 1.0) * _MaxTrans);
  localOrigin_7.w = 1.0;
  highp float tmpvar_206;
  tmpvar_206 = ((tmpvar_205.x * (_MaxScale - 1.0)) + 1.0);
  origin_9 = (_Object2World * localOrigin_7);
  planet_pos_8 = (_MainRotation * origin_9);
  highp vec3 tmpvar_207;
  tmpvar_207 = (_DetailRotation * planet_pos_8).xyz;
  tmpvar_13 = planet_pos_8.xyz;
  highp vec3 tmpvar_208;
  tmpvar_208 = normalize(planet_pos_8.xyz);
  highp vec2 uv_209;
  highp float tmpvar_210;
  highp float tmpvar_211;
  tmpvar_211 = (min (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0) / max (abs(
    (tmpvar_208.x / tmpvar_208.z)
  ), 1.0));
  highp float tmpvar_212;
  tmpvar_212 = (tmpvar_211 * tmpvar_211);
  tmpvar_212 = (((
    ((((
      ((((-0.01213232 * tmpvar_212) + 0.05368138) * tmpvar_212) - 0.1173503)
     * tmpvar_212) + 0.1938925) * tmpvar_212) - 0.3326756)
   * tmpvar_212) + 0.9999793) * tmpvar_211);
  tmpvar_212 = (tmpvar_212 + (float(
    (abs((tmpvar_208.x / tmpvar_208.z)) > 1.0)
  ) * (
    (tmpvar_212 * -2.0)
   + 1.570796)));
  tmpvar_210 = (tmpvar_212 * sign((tmpvar_208.x / tmpvar_208.z)));
  if ((abs(tmpvar_208.z) > (1e-08 * abs(tmpvar_208.x)))) {
    if ((tmpvar_208.z < 0.0)) {
      if ((tmpvar_208.x >= 0.0)) {
        tmpvar_210 += 3.141593;
      } else {
        tmpvar_210 = (tmpvar_210 - 3.141593);
      };
    };
  } else {
    tmpvar_210 = (sign(tmpvar_208.x) * 1.570796);
  };
  uv_209.x = (0.5 + (0.1591549 * tmpvar_210));
  uv_209.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_208.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_208.y)
    )) * (1.570796 + (
      abs(tmpvar_208.y)
     * 
      (-0.2146018 + (abs(tmpvar_208.y) * (0.08656672 + (
        abs(tmpvar_208.y)
       * -0.03102955))))
    ))))
  )));
  lowp vec4 tmpvar_213;
  tmpvar_213 = texture2DLod (_MainTex, uv_209, 0.0);
  mediump vec4 tmpvar_214;
  tmpvar_214 = tmpvar_213;
  tmpvar_10 = tmpvar_214;
  mediump vec3 detailCoords_215;
  mediump float s_216;
  mediump float nylerp_217;
  mediump float zxlerp_218;
  highp vec4 uv4_219;
  uv4_219.zw = vec2(0.0, 0.0);
  highp vec3 tmpvar_220;
  tmpvar_220 = normalize(tmpvar_207);
  highp vec3 tmpvar_221;
  tmpvar_221 = abs(tmpvar_220);
  highp float tmpvar_222;
  tmpvar_222 = float((tmpvar_221.z >= tmpvar_221.x));
  zxlerp_218 = tmpvar_222;
  highp float tmpvar_223;
  tmpvar_223 = float((max (tmpvar_221.x, tmpvar_221.z) >= tmpvar_221.y));
  nylerp_217 = tmpvar_223;
  highp float tmpvar_224;
  tmpvar_224 = mix (tmpvar_220.x, tmpvar_220.z, zxlerp_218);
  s_216 = tmpvar_224;
  highp float tmpvar_225;
  tmpvar_225 = sign(mix (tmpvar_220.y, s_216, nylerp_217));
  s_216 = tmpvar_225;
  mediump vec3 tmpvar_226;
  tmpvar_226.xz = vec2(1.0, -1.0);
  tmpvar_226.y = -(s_216);
  mediump vec3 tmpvar_227;
  tmpvar_227.xz = vec2(1.0, -1.0);
  tmpvar_227.y = s_216;
  highp vec3 tmpvar_228;
  tmpvar_228 = mix ((tmpvar_226 * tmpvar_220.xzy), (tmpvar_227 * tmpvar_220.zxy), vec3(zxlerp_218));
  detailCoords_215 = tmpvar_228;
  mediump vec3 tmpvar_229;
  tmpvar_229.xy = vec2(1.0, 1.0);
  tmpvar_229.z = s_216;
  highp vec3 tmpvar_230;
  tmpvar_230 = mix ((tmpvar_229 * tmpvar_220.yxz), detailCoords_215, vec3(nylerp_217));
  detailCoords_215 = tmpvar_230;
  mediump vec2 tmpvar_231;
  tmpvar_231 = (((0.5 * detailCoords_215.yz) / abs(detailCoords_215.x)) + 0.5);
  uv4_219.xy = tmpvar_231;
  lowp vec4 tmpvar_232;
  tmpvar_232 = texture2DLod (_DetailTex, uv4_219.xy, 0.0);
  mediump vec4 tmpvar_233;
  tmpvar_233 = tmpvar_232;
  tmpvar_10 = (tmpvar_10 * tmpvar_233);
  highp vec4 tmpvar_234;
  tmpvar_234.w = 0.0;
  tmpvar_234.xyz = _WorldSpaceCameraPos;
  highp float tmpvar_235;
  highp vec4 tmpvar_236;
  tmpvar_236 = (origin_9 - tmpvar_234);
  tmpvar_235 = sqrt(dot (tmpvar_236, tmpvar_236));
  highp float tmpvar_237;
  tmpvar_237 = (clamp ((_DistFade * tmpvar_235), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_235)
  ), 0.0, 1.0));
  tmpvar_11.w = tmpvar_237;
  tmpvar_10.w = (tmpvar_10.w * tmpvar_11.w);
  highp vec3 tmpvar_238;
  tmpvar_238.yz = vec2(0.0, 0.0);
  tmpvar_238.x = fract(_Rotation);
  highp vec3 x_239;
  x_239 = (tmpvar_238 + tmpvar_205);
  highp vec3 trans_240;
  trans_240 = localOrigin_7.xyz;
  highp float tmpvar_241;
  tmpvar_241 = (x_239.x * 6.283185);
  highp float tmpvar_242;
  tmpvar_242 = (x_239.y * 6.283185);
  highp float tmpvar_243;
  tmpvar_243 = (x_239.z * 2.0);
  highp float tmpvar_244;
  tmpvar_244 = sqrt(tmpvar_243);
  highp float tmpvar_245;
  tmpvar_245 = (sin(tmpvar_242) * tmpvar_244);
  highp float tmpvar_246;
  tmpvar_246 = (cos(tmpvar_242) * tmpvar_244);
  highp float tmpvar_247;
  tmpvar_247 = sqrt((2.0 - tmpvar_243));
  highp float tmpvar_248;
  tmpvar_248 = sin(tmpvar_241);
  highp float tmpvar_249;
  tmpvar_249 = cos(tmpvar_241);
  highp float tmpvar_250;
  tmpvar_250 = ((tmpvar_245 * tmpvar_249) - (tmpvar_246 * tmpvar_248));
  highp float tmpvar_251;
  tmpvar_251 = ((tmpvar_245 * tmpvar_248) + (tmpvar_246 * tmpvar_249));
  highp mat4 tmpvar_252;
  tmpvar_252[0].x = (tmpvar_206 * ((tmpvar_245 * tmpvar_250) - tmpvar_249));
  tmpvar_252[0].y = ((tmpvar_245 * tmpvar_251) - tmpvar_248);
  tmpvar_252[0].z = (tmpvar_245 * tmpvar_247);
  tmpvar_252[0].w = 0.0;
  tmpvar_252[1].x = ((tmpvar_246 * tmpvar_250) + tmpvar_248);
  tmpvar_252[1].y = (tmpvar_206 * ((tmpvar_246 * tmpvar_251) - tmpvar_249));
  tmpvar_252[1].z = (tmpvar_246 * tmpvar_247);
  tmpvar_252[1].w = 0.0;
  tmpvar_252[2].x = (tmpvar_247 * tmpvar_250);
  tmpvar_252[2].y = (tmpvar_247 * tmpvar_251);
  tmpvar_252[2].z = (tmpvar_206 * (1.0 - tmpvar_243));
  tmpvar_252[2].w = 0.0;
  tmpvar_252[3].x = trans_240.x;
  tmpvar_252[3].y = trans_240.y;
  tmpvar_252[3].z = trans_240.z;
  tmpvar_252[3].w = 1.0;
  highp mat4 tmpvar_253;
  tmpvar_253 = ((unity_MatrixV * _Object2World) * tmpvar_252);
  highp vec4 v_254;
  v_254.x = tmpvar_253[0].z;
  v_254.y = tmpvar_253[1].z;
  v_254.z = tmpvar_253[2].z;
  v_254.w = tmpvar_253[3].z;
  highp vec3 tmpvar_255;
  tmpvar_255 = normalize(v_254.xyz);
  highp vec3 tmpvar_256;
  tmpvar_256 = abs(tmpvar_255);
  tmpvar_11.xyz = tmpvar_256;
  highp vec4 tmpvar_257;
  tmpvar_257 = (glstate_matrix_modelview0 * localOrigin_7);
  highp vec4 tmpvar_258;
  tmpvar_258.xyz = (_glesVertex.xyz * tmpvar_206);
  tmpvar_258.w = tmpvar_1.w;
  highp vec2 tmpvar_259;
  tmpvar_259 = ((2.0 * _glesMultiTexCoord0.xy) - 1.0);
  highp vec4 tmpvar_260;
  tmpvar_260.z = 0.0;
  tmpvar_260.xy = tmpvar_259;
  tmpvar_260.w = tmpvar_1.w;
  ZYv_6.xyw = tmpvar_260.zyw;
  XZv_5.yzw = tmpvar_260.zyw;
  XYv_4.yzw = tmpvar_260.yzw;
  ZYv_6.z = (tmpvar_259.x * sign(-(tmpvar_255.x)));
  XZv_5.x = (tmpvar_259.x * sign(-(tmpvar_255.y)));
  XYv_4.x = (tmpvar_259.x * sign(tmpvar_255.z));
  ZYv_6.x = ((sign(
    -(tmpvar_255.x)
  ) * sign(ZYv_6.z)) * tmpvar_255.z);
  XZv_5.y = ((sign(
    -(tmpvar_255.y)
  ) * sign(XZv_5.x)) * tmpvar_255.x);
  XYv_4.z = ((sign(
    -(tmpvar_255.z)
  ) * sign(XYv_4.x)) * tmpvar_255.x);
  ZYv_6.x = (ZYv_6.x + ((
    sign(-(tmpvar_255.x))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  XZv_5.y = (XZv_5.y + ((
    sign(-(tmpvar_255.y))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.z));
  XYv_4.z = (XYv_4.z + ((
    sign(-(tmpvar_255.z))
   * 
    sign(tmpvar_259.y)
  ) * tmpvar_255.y));
  highp vec3 tmpvar_261;
  tmpvar_261 = normalize((origin_9.xyz - _WorldSpaceCameraPos));
  highp vec3 tmpvar_262;
  tmpvar_262 = normalize(-(tmpvar_261));
  normal_3 = tmpvar_262;
  highp vec4 v_263;
  v_263.x = unity_MatrixV[0].x;
  v_263.y = unity_MatrixV[1].x;
  v_263.z = unity_MatrixV[2].x;
  v_263.w = unity_MatrixV[3].x;
  highp vec3 tmpvar_264;
  tmpvar_264 = normalize(v_263.xyz);
  highp vec3 tmpvar_265;
  highp vec3 tmpvar_266;
  tmpvar_265 = v_263.xyz;
  tmpvar_266 = ((normal_3.zxy * tmpvar_264.yzx) - (normal_3.yzx * tmpvar_264.zxy));
  highp vec3 tmpvar_267;
  tmpvar_267 = normal_3;
  highp mat3 tmpvar_268;
  tmpvar_268[0].x = tmpvar_265.x;
  tmpvar_268[0].y = tmpvar_266.x;
  tmpvar_268[0].z = tmpvar_267.x;
  tmpvar_268[1].x = tmpvar_265.y;
  tmpvar_268[1].y = tmpvar_266.y;
  tmpvar_268[1].z = tmpvar_267.y;
  tmpvar_268[2].x = tmpvar_265.z;
  tmpvar_268[2].y = tmpvar_266.z;
  tmpvar_268[2].z = tmpvar_267.z;
  gl_Position = (glstate_matrix_projection * (tmpvar_257 + tmpvar_258));
  xlv_COLOR = tmpvar_10;
  xlv_TEXCOORD0 = tmpvar_11;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * ZYv_6)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XZv_5)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_253 * XYv_4)
  .xy - tmpvar_257.xy)));
  xlv_TEXCOORD4 = tmpvar_2;
  xlv_TEXCOORD5 = tmpvar_12;
  xlv_TEXCOORD6 = tmpvar_13;
  xlv_TEXCOORD7 = normalize((tmpvar_268 * tmpvar_261));
  xlv_TEXCOORD8 = normalize((tmpvar_268 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shadow_samplers : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D _Tex;
uniform lowp vec4 _Color;
uniform highp float _MinScatter;
uniform highp float _Opacity;
varying lowp vec4 xlv_COLOR;
varying mediump vec4 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD7;
varying highp vec3 xlv_TEXCOORD8;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec3 normT_2;
  mediump vec4 color_3;
  mediump vec4 tex_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (_Tex, xlv_TEXCOORD1);
  tex_4.x = tmpvar_5.x;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (_Tex, xlv_TEXCOORD2);
  tex_4.y = tmpvar_6.y;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (_Tex, xlv_TEXCOORD3);
  tex_4.z = tmpvar_7.z;
  tex_4.w = 0.0;
  tex_4.xyz = (tex_4.xyz * xlv_TEXCOORD0.xyz);
  tex_4 = (tex_4 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  mediump float tmpvar_8;
  tmpvar_8 = ((tex_4.x + tex_4.y) + (tex_4.z + tex_4.w));
  mediump vec4 tmpvar_9;
  tmpvar_9.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_9.w = tmpvar_8;
  tex_4.xyz = tmpvar_9.xyz;
  color_3 = (_Color * xlv_COLOR);
  normT_2.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_2.z = sqrt((1.0 - clamp (
    dot (normT_2.xy, normT_2.xy)
  , 0.0, 1.0)));
  color_3.w = (color_3.w * tmpvar_8);
  tex_4.w = (xlv_TEXCOORD0.w * tmpvar_8);
  mediump vec3 lightDir_10;
  lightDir_10 = xlv_TEXCOORD8;
  mediump vec3 viewDir_11;
  viewDir_11 = xlv_TEXCOORD7;
  mediump vec4 c_12;
  highp float h_13;
  mediump vec3 tmpvar_14;
  tmpvar_14 = normalize(lightDir_10);
  lightDir_10 = tmpvar_14;
  mediump vec3 tmpvar_15;
  tmpvar_15 = normalize(viewDir_11);
  viewDir_11 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16 = normalize(normT_2);
  mediump float tmpvar_17;
  tmpvar_17 = max (dot (tmpvar_16, tmpvar_14), 0.0);
  mediump float tmpvar_18;
  tmpvar_18 = (0.5 + (0.5 * dot (tmpvar_15, tmpvar_14)));
  h_13 = tmpvar_18;
  mediump float tmpvar_19;
  tmpvar_19 = dot (tmpvar_16, tmpvar_15);
  highp float tmpvar_20;
  tmpvar_20 = clamp (((
    (_MinScatter - (_Opacity * tex_4.w))
   * 
    (1.0 - tmpvar_19)
  ) * h_13), 0.0, 1.0);
  c_12.xyz = ((_LightColor0.xyz * (vec3(tmpvar_17) + tmpvar_20)) * 2.0);
  c_12.w = (tmpvar_17 * 2.0);
  color_3.xyz = (color_3.xyz * c_12.xyz);
  tmpvar_1 = color_3;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 in_POSITION0;
in highp vec2 in_TEXCOORD0;
out lowp vec4 vs_COLOR0;
out mediump vec4 vs_TEXCOORD0;
out highp vec2 vs_TEXCOORD1;
out highp vec2 vs_TEXCOORD2;
out highp vec2 vs_TEXCOORD3;
out highp vec2 vs_TEXCOORD4;
out highp vec4 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD7;
out highp vec3 vs_TEXCOORD8;
highp vec4 t0;
highp vec4 t1;
bvec4 tb1;
highp vec4 t2;
highp vec4 t3;
bvec3 tb3;
highp vec4 t4;
mediump vec4 t16_4;
bvec4 tb4;
highp vec4 t5;
highp ivec3 ti5;
bvec4 tb5;
highp vec4 t6;
bvec3 tb6;
highp vec4 t7;
bvec4 tb7;
highp vec4 t8;
highp ivec3 ti8;
highp vec4 t9;
bvec4 tb9;
highp vec4 t10;
bvec4 tb10;
highp vec4 t11;
bvec4 tb11;
highp vec4 t12;
highp vec4 t13;
mediump vec3 t16_14;
mediump vec3 t16_15;
highp float t17;
highp float t22;
highp ivec3 ti22;
highp vec3 t24;
highp vec2 t32;
highp int ti32;
highp vec2 t33;
highp int ti33;
highp vec2 t35;
highp ivec2 ti35;
bvec2 tb35;
highp float t48;
highp int ti48;
highp float t49;
highp int ti49;
bool tb49;
highp float t50;
highp int ti50;
bool tb50;
highp float t51;
highp int ti51;
void main()
{
    t0.xw = vec2(0.0, 1.0);
    t1.xw = vec2(0.0, 1.0);
    t2.xyz = _Object2World[3].yyy * _PosRotation[1].xyz;
    t2.xyz = _PosRotation[0].xyz * _Object2World[3].xxx + t2.xyz;
    t2.xyz = _PosRotation[2].xyz * _Object2World[3].zzz + t2.xyz;
    t2.xyz = _PosRotation[3].xyz * _Object2World[3].www + t2.xyz;
    t3.xyz = t2.xyz * _NoiseScale.zzz;
    t4.xyz = t3.xyz * _NoiseScale.xxx;
    t50 = dot(t4.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t4.xyz = _NoiseScale.xxx * t3.xyz + vec3(t50);
    t4.xyz = floor(t4.xyz);
    t5.xyz = t4.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb6.xyz = greaterThanEqual(t5.xyzx, (-t5.xyzx)).xyz;
    t5.xyz = fract(abs(t5.xyz));
    t5.x = (tb6.x) ? t5.x : (-t5.x);
    t5.y = (tb6.y) ? t5.y : (-t5.y);
    t5.z = (tb6.z) ? t5.z : (-t5.z);
    t6.xyz = _NoiseScale.xxx * t3.xyz + (-t4.xyz);
    t50 = dot(t4.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t4.xyz = vec3(t50) + t6.xyz;
    tb6.xyz = greaterThanEqual(t4.zxyz, t4.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t1.y = t8.z;
    t1.z = t6.z;
    t1 = t5.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t1;
    t5.xy = t5.xy * vec2(289.0, 289.0);
    t7 = t1 * t1;
    t1 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb7.x) ? t1.x : (-t1.x);
    t1.y = (tb7.y) ? t1.y : (-t1.y);
    t1.z = (tb7.z) ? t1.z : (-t1.z);
    t1.w = (tb7.w) ? t1.w : (-t1.w);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + t5.yyyy;
    t0.y = t8.y;
    t0.z = t6.y;
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + t5.xxxx;
    t1.xw = vec2(0.0, 1.0);
    t1.y = t8.x;
    t5.xyz = t4.xyz + (-t8.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t1.z = t6.x;
    t6.xyz = t4.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t0 = t0 + t1;
    t1 = t0 * t0;
    t0 = t1 * vec4(34.0, 34.0, 34.0, 34.0) + t0;
    t0 = t0 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb1 = greaterThanEqual(t0, (-t0));
    t0 = fract(abs(t0));
    t0.x = (tb1.x) ? t0.x : (-t0.x);
    t0.y = (tb1.y) ? t0.y : (-t0.y);
    t0.z = (tb1.z) ? t0.z : (-t0.z);
    t0.w = (tb1.w) ? t0.w : (-t0.w);
    t1 = t0 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t1 = floor(t1);
    t1 = t1 * vec4(49.0, 49.0, 49.0, 49.0);
    t0 = t0 * vec4(289.0, 289.0, 289.0, 289.0) + (-t1);
    t1 = t0 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t1 = floor(t1);
    t0 = (-t1) * vec4(7.0, 7.0, 7.0, 7.0) + t0;
    t1 = t1.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t0 = floor(t0);
    t0 = t0 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t7.yw = t0.xy;
    t7.xz = t1.yw;
    t8.yw = floor(t0.xy);
    t8.xz = floor(t1.yw);
    t8 = t8 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t1.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t9 = -abs(t0.xywz) + t9.xywz;
    tb10 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t9.xywz);
    t10.x = (tb10.x) ? float(-1.0) : float(-0.0);
    t10.y = (tb10.y) ? float(-1.0) : float(-0.0);
    t10.z = (tb10.z) ? float(-1.0) : float(-0.0);
    t10.w = (tb10.w) ? float(-1.0) : float(-0.0);
    t7 = t8.zwxy * t10.yyxx + t7.zwxy;
    t8.xy = t7.zw;
    t8.z = t9.x;
    t11.x = dot(t8.xyz, t8.xyz);
    t7.z = t9.y;
    t11.y = dot(t7.xyz, t7.xyz);
    t12.yw = floor(t0.zw);
    t1.yw = t0.zw;
    t12.xz = floor(t1.xz);
    t0 = t12 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t0 = t0 * t10.zzww + t1;
    t9.xy = t0.zw;
    t0.z = t9.w;
    t11.z = dot(t0.xyz, t0.xyz);
    t11.w = dot(t9.xyz, t9.xyz);
    t1 = (-t11) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t7.xyz = t1.yyy * t7.xyz;
    t7.y = dot(t7.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t0.xyz = t0.xyz * t1.zzz;
    t7.z = dot(t0.xyz, t6.xyz);
    t5.z = dot(t6.xyz, t6.xyz);
    t0.xyz = t1.xxx * t8.xyz;
    t1.xyz = t1.www * t9.xyz;
    t7.x = dot(t0.xyz, t4.xyz);
    t0.xyz = t4.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t4.xyz, t4.xyz);
    t7.w = dot(t1.xyz, t0.xyz);
    t5.w = dot(t0.xyz, t0.xyz);
    t0 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t0 = max(t0, vec4(0.0, 0.0, 0.0, 0.0));
    t0 = t0 * t0;
    t0 = t0 * t0;
    t0.x = dot(t0, t7);
    t1.xyz = t3.xyz * _NoiseScale.yyy;
    t48 = dot(t1.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t1.xyz = _NoiseScale.yyy * t3.xyz + vec3(t48);
    t1.xyz = floor(t1.xyz);
    t4.xyz = t1.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb5.xyz = greaterThanEqual(t4.xyzx, (-t4.xyzx)).xyz;
    t4.xyz = fract(abs(t4.xyz));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t5.xw = vec2(0.0, 1.0);
    t6.xyz = _NoiseScale.yyy * t3.xyz + (-t1.xyz);
    t48 = dot(t1.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t1.xyz = vec3(t48) + t6.xyz;
    t48 = dot(t3.xyz, vec3(0.333333343, 0.333333343, 0.333333343));
    t3.xyz = _NoiseScale.zzz * t2.xyz + vec3(t48);
    t3.xyz = floor(t3.xyz);
    tb6.xyz = greaterThanEqual(t1.zxyz, t1.xyzx).xyz;
    t7.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb6.yzx));
    t6.x = (tb6.x) ? float(0.0) : float(1.0);
    t6.y = (tb6.y) ? float(0.0) : float(1.0);
    t6.z = (tb6.z) ? float(0.0) : float(1.0);
    t8.xyz = min(t6.xyz, t7.xyz);
    t6.xyz = max(t6.xyz, t7.xyz);
    t5.y = t8.z;
    t5.z = t6.z;
    t5 = t4.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t5;
    t4.xy = t4.xy * vec2(289.0, 289.0);
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t5 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.yyyy;
    t7.xw = vec2(0.0, 1.0);
    t7.y = t8.y;
    t7.z = t6.y;
    t5 = t5 + t7;
    t7 = t5 * t5;
    t5 = t7 * vec4(34.0, 34.0, 34.0, 34.0) + t5;
    t5 = t5 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb7 = greaterThanEqual(t5, (-t5));
    t5 = fract(abs(t5));
    t5.x = (tb7.x) ? t5.x : (-t5.x);
    t5.y = (tb7.y) ? t5.y : (-t5.y);
    t5.z = (tb7.z) ? t5.z : (-t5.z);
    t5.w = (tb7.w) ? t5.w : (-t5.w);
    t4 = t5 * vec4(289.0, 289.0, 289.0, 289.0) + t4.xxxx;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t8.x;
    t7.xyz = t1.xyz + (-t8.xyz);
    t7.xyz = t7.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t5.z = t6.x;
    t6.xyz = t1.xyz + (-t6.xyz);
    t6.xyz = t6.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t5 = t4 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t5 = floor(t5);
    t5 = t5 * vec4(49.0, 49.0, 49.0, 49.0);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + (-t5);
    t5 = t4 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t5 = floor(t5);
    t4 = (-t5) * vec4(7.0, 7.0, 7.0, 7.0) + t4;
    t5 = t5.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t4 = floor(t4);
    t4 = t4 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t8.yw = t4.xy;
    t8.xz = t5.yw;
    t9.yw = floor(t4.xy);
    t9.xz = floor(t5.yw);
    t9 = t9 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t5.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t10 = -abs(t4.xywz) + t10.xywz;
    tb11 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t10.xywz);
    t11.x = (tb11.x) ? float(-1.0) : float(-0.0);
    t11.y = (tb11.y) ? float(-1.0) : float(-0.0);
    t11.z = (tb11.z) ? float(-1.0) : float(-0.0);
    t11.w = (tb11.w) ? float(-1.0) : float(-0.0);
    t8 = t9.zwxy * t11.yyxx + t8.zwxy;
    t9.xy = t8.zw;
    t9.z = t10.x;
    t12.x = dot(t9.xyz, t9.xyz);
    t8.z = t10.y;
    t12.y = dot(t8.xyz, t8.xyz);
    t13.yw = floor(t4.zw);
    t5.yw = t4.zw;
    t13.xz = floor(t5.xz);
    t4 = t13 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t4 = t4 * t11.zzww + t5;
    t10.xy = t4.zw;
    t4.z = t10.w;
    t12.z = dot(t4.xyz, t4.xyz);
    t12.w = dot(t10.xyz, t10.xyz);
    t5 = (-t12) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t8.xyz = t5.yyy * t8.xyz;
    t8.y = dot(t8.xyz, t7.xyz);
    t7.y = dot(t7.xyz, t7.xyz);
    t4.xyz = t4.xyz * t5.zzz;
    t8.z = dot(t4.xyz, t6.xyz);
    t7.z = dot(t6.xyz, t6.xyz);
    t4.xyz = t5.xxx * t9.xyz;
    t5.xyz = t5.www * t10.xyz;
    t8.x = dot(t4.xyz, t1.xyz);
    t4.xyz = t1.xyz + vec3(-0.5, -0.5, -0.5);
    t7.x = dot(t1.xyz, t1.xyz);
    t8.w = dot(t5.xyz, t4.xyz);
    t7.w = dot(t4.xyz, t4.xyz);
    t1 = (-t7) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t0.w = dot(t1, t8);
    t0.yz = t0.xw * vec2(42.0, 42.0);
    t1.xyz = t3.xyz * vec3(0.00346020772, 0.00346020772, 0.00346020772);
    tb4.xyz = greaterThanEqual(t1.xyzx, (-t1.xyzx)).xyz;
    t1.xyz = fract(abs(t1.xyz));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t4.xw = vec2(0.0, 1.0);
    t2.xyz = _NoiseScale.zzz * t2.xyz + (-t3.xyz);
    t48 = dot(t3.xyz, vec3(0.166666672, 0.166666672, 0.166666672));
    t2.xyz = vec3(t48) + t2.xyz;
    tb3.xyz = greaterThanEqual(t2.zxyz, t2.xyzx).xyz;
    t5.xyz = mix(vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), vec3(tb3.yzx));
    t3.x = (tb3.x) ? float(0.0) : float(1.0);
    t3.y = (tb3.y) ? float(0.0) : float(1.0);
    t3.z = (tb3.z) ? float(0.0) : float(1.0);
    t6.xyz = min(t3.xyz, t5.xyz);
    t3.xyz = max(t3.xyz, t5.xyz);
    t4.y = t6.z;
    t4.z = t3.z;
    t4 = t1.zzzz * vec4(289.0, 289.0, 289.0, 289.0) + t4;
    t1.xy = t1.xy * vec2(289.0, 289.0);
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t4 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.yyyy;
    t5.xw = vec2(0.0, 1.0);
    t5.y = t6.y;
    t5.z = t3.y;
    t4 = t4 + t5;
    t5 = t4 * t4;
    t4 = t5 * vec4(34.0, 34.0, 34.0, 34.0) + t4;
    t4 = t4 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb5 = greaterThanEqual(t4, (-t4));
    t4 = fract(abs(t4));
    t4.x = (tb5.x) ? t4.x : (-t4.x);
    t4.y = (tb5.y) ? t4.y : (-t4.y);
    t4.z = (tb5.z) ? t4.z : (-t4.z);
    t4.w = (tb5.w) ? t4.w : (-t4.w);
    t1 = t4 * vec4(289.0, 289.0, 289.0, 289.0) + t1.xxxx;
    t4.xw = vec2(0.0, 1.0);
    t4.y = t6.x;
    t5.xyz = t2.xyz + (-t6.xyz);
    t5.xyz = t5.xyz + vec3(0.166666672, 0.166666672, 0.166666672);
    t4.z = t3.x;
    t3.xyz = t2.xyz + (-t3.xyz);
    t3.xyz = t3.xyz + vec3(0.333333343, 0.333333343, 0.333333343);
    t1 = t1 + t4;
    t4 = t1 * t1;
    t1 = t4 * vec4(34.0, 34.0, 34.0, 34.0) + t1;
    t1 = t1 * vec4(0.00346020772, 0.00346020772, 0.00346020772, 0.00346020772);
    tb4 = greaterThanEqual(t1, (-t1));
    t1 = fract(abs(t1));
    t1.x = (tb4.x) ? t1.x : (-t1.x);
    t1.y = (tb4.y) ? t1.y : (-t1.y);
    t1.z = (tb4.z) ? t1.z : (-t1.z);
    t1.w = (tb4.w) ? t1.w : (-t1.w);
    t4 = t1 * vec4(5.89795971, 5.89795971, 5.89795971, 5.89795971);
    t4 = floor(t4);
    t4 = t4 * vec4(49.0, 49.0, 49.0, 49.0);
    t1 = t1 * vec4(289.0, 289.0, 289.0, 289.0) + (-t4);
    t4 = t1 * vec4(0.142857149, 0.142857149, 0.142857149, 0.142857149);
    t4 = floor(t4);
    t1 = (-t4) * vec4(7.0, 7.0, 7.0, 7.0) + t1;
    t4 = t4.zxwy * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t1 = floor(t1);
    t1 = t1 * vec4(0.285714298, 0.285714298, 0.285714298, 0.285714298) + vec4(-0.928571403, -0.928571403, -0.928571403, -0.928571403);
    t6.yw = t1.xy;
    t6.xz = t4.yw;
    t7.yw = floor(t1.xy);
    t7.xz = floor(t4.yw);
    t7 = t7 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t4.ywxz) + vec4(1.0, 1.0, 1.0, 1.0);
    t8 = -abs(t1.xywz) + t8.xywz;
    tb9 = greaterThanEqual(vec4(0.0, 0.0, 0.0, 0.0), t8.xywz);
    t9.x = (tb9.x) ? float(-1.0) : float(-0.0);
    t9.y = (tb9.y) ? float(-1.0) : float(-0.0);
    t9.z = (tb9.z) ? float(-1.0) : float(-0.0);
    t9.w = (tb9.w) ? float(-1.0) : float(-0.0);
    t6 = t7.zwxy * t9.yyxx + t6.zwxy;
    t7.xy = t6.zw;
    t7.z = t8.x;
    t10.x = dot(t7.xyz, t7.xyz);
    t6.z = t8.y;
    t10.y = dot(t6.xyz, t6.xyz);
    t11.yw = floor(t1.zw);
    t4.yw = t1.zw;
    t11.xz = floor(t4.xz);
    t1 = t11 * vec4(2.0, 2.0, 2.0, 2.0) + vec4(1.0, 1.0, 1.0, 1.0);
    t1 = t1 * t9.zzww + t4;
    t8.xy = t1.zw;
    t1.z = t8.w;
    t10.z = dot(t1.xyz, t1.xyz);
    t10.w = dot(t8.xyz, t8.xyz);
    t4 = (-t10) * vec4(0.853734732, 0.853734732, 0.853734732, 0.853734732) + vec4(1.79284286, 1.79284286, 1.79284286, 1.79284286);
    t6.xyz = t4.yyy * t6.xyz;
    t6.y = dot(t6.xyz, t5.xyz);
    t5.y = dot(t5.xyz, t5.xyz);
    t1.xyz = t1.xyz * t4.zzz;
    t6.z = dot(t1.xyz, t3.xyz);
    t5.z = dot(t3.xyz, t3.xyz);
    t1.xyz = t4.xxx * t7.xyz;
    t3.xyz = t4.www * t8.xyz;
    t6.x = dot(t1.xyz, t2.xyz);
    t1.xyz = t2.xyz + vec3(-0.5, -0.5, -0.5);
    t5.x = dot(t2.xyz, t2.xyz);
    t6.w = dot(t3.xyz, t1.xyz);
    t5.w = dot(t1.xyz, t1.xyz);
    t1 = (-t5) + vec4(0.600000024, 0.600000024, 0.600000024, 0.600000024);
    t1 = max(t1, vec4(0.0, 0.0, 0.0, 0.0));
    t1 = t1 * t1;
    t1 = t1 * t1;
    t48 = dot(t1, t6);
    t0.x = t48 * 42.0;
    t1.xyz = t0.xyz + vec3(1.0, 1.0, 1.0);
    t0.xyz = t0.xyz * _MaxTrans.xyzx.xyz;
    t48 = t1.x * 0.5;
    t49 = _MaxScale + -1.0;
    t48 = t48 * t49 + 1.0;
    t2.xyz = vec3(t48) * in_POSITION0.xyz;
    t3 = t0.yyyy * glstate_matrix_modelview0[1];
    t3 = glstate_matrix_modelview0[0] * t0.xxxx + t3;
    t3 = glstate_matrix_modelview0[2] * t0.zzzz + t3;
    t3 = t3 + glstate_matrix_modelview0[3];
    t2.w = in_POSITION0.w;
    t2 = t2 + t3;
    t4 = t2.yyyy * glstate_matrix_projection[1];
    t4 = glstate_matrix_projection[0] * t2.xxxx + t4;
    t4 = glstate_matrix_projection[2] * t2.zzzz + t4;
    gl_Position = glstate_matrix_projection[3] * t2.wwww + t4;
    t2 = t0.yyyy * _Object2World[1];
    t2 = _Object2World[0] * t0.xxxx + t2;
    t2 = _Object2World[2] * t0.zzzz + t2;
    t2 = t2 + _Object2World[3];
    t4 = t2.yyyy * _MainRotation[1];
    t4 = _MainRotation[0] * t2.xxxx + t4;
    t4 = _MainRotation[2] * t2.zzzz + t4;
    t4 = _MainRotation[3] * t2.wwww + t4;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.xyz = t4.yyy * _DetailRotation[1].yxz;
    t5.xyz = _DetailRotation[0].yxz * t4.xxx + t5.xyz;
    t5.xyz = _DetailRotation[2].yxz * t4.zzz + t5.xyz;
    t5.xyz = _DetailRotation[3].yxz * t4.www + t5.xyz;
    t49 = dot(t5.xyz, t5.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t5.xyz;
    t50 = t5.z * t49 + (-t6.y);
    tb35.x = abs(t6.z)>=abs(t6.y);
    t35.x = tb35.x ? 1.0 : float(0.0);
    t50 = t35.x * t50 + t6.y;
    t49 = (-t5.x) * t49 + t50;
    t50 = max(abs(t6.z), abs(t6.y));
    tb50 = t50>=abs(t6.x);
    t50 = tb50 ? 1.0 : float(0.0);
    t49 = t50 * t49 + t6.x;
    ti51 = int((0.0<t49) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t49<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti49 = (-ti51) + ti49;
    t16_14.y = float(ti49);
    t16_15.y = (-t16_14.y);
    t16_15.xz = vec2(1.0, -1.0);
    t5.xyz = t6.yzx * t16_15.xyz;
    t16_14.xz = vec2(1.0, -1.0);
    t7.xyz = t16_14.xyz * t6.zyx + (-t5.xyz);
    t5.xyz = t35.xxx * t7.xyz + t5.xyz;
    t5.xyz = (-t16_14.xxy) * t6.xyz + t5.xyz;
    t6.xyz = t6.xyz * t16_14.xxy;
    t5.xyz = vec3(t50) * t5.xyz + t6.xyz;
    t16_14.xy = vec2(t5.y * float(0.5), t5.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t5.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t5 = textureLod(_DetailTex, t16_14.xy, 0.0);
    t49 = dot(t4.xyz, t4.xyz);
    t49 = inversesqrt(t49);
    t6.xyz = vec3(t49) * t4.xzy;
    vs_TEXCOORD6.xyz = t4.xyz;
    tb49 = abs(t6.y)<abs(t6.x);
    t50 = max(abs(t6.y), abs(t6.x));
    t50 = float(1.0) / t50;
    t35.x = min(abs(t6.y), abs(t6.x));
    t50 = t50 * t35.x;
    t35.x = t50 * t50;
    t51 = t35.x * 0.0208350997 + -0.0851330012;
    t51 = t35.x * t51 + 0.180141002;
    t51 = t35.x * t51 + -0.330299497;
    t35.x = t35.x * t51 + 0.999866009;
    t51 = t50 * t35.x;
    t51 = t51 * -2.0 + 1.57079637;
    t49 = tb49 ? t51 : float(0.0);
    t49 = t50 * t35.x + t49;
    tb35.xy = lessThan(t6.yzyz, (-t6.yzyz)).xy;
    t50 = tb35.x ? -3.14159274 : float(0.0);
    t49 = t49 + t50;
    t50 = min(t6.y, t6.x);
    tb50 = t50<(-t50);
    t35.x = max(t6.y, t6.x);
    tb35.x = t35.x>=(-t35.x);
    ti50 = int(uint(tb50) * 0xffffffffu & uint(tb35.x) * 0xffffffffu);
    t49 = (ti50 != 0) ? (-t49) : t49;
    t4.x = t49 * 0.159154937 + 0.5;
    t49 = abs(t6.z) * -0.0187292993 + 0.0742610022;
    t49 = t49 * abs(t6.z) + -0.212114394;
    t49 = t49 * abs(t6.z) + 1.57072878;
    t50 = -abs(t6.z) + 1.0;
    t50 = sqrt(t50);
    t35.x = t49 * t50;
    t35.x = t35.x * -2.0 + 3.14159274;
    t35.x = tb35.y ? t35.x : float(0.0);
    t49 = t49 * t50 + t35.x;
    t4.y = t49 * 0.318309873;
    t4 = textureLod(_MainTex, t4.xy, 0.0);
    t16_4 = t5 * t4;
    t49 = dot(t2.xyz, t2.xyz);
    t50 = sqrt(t49);
    t49 = inversesqrt(t49);
    t2.xyz = vec3(t49) * t2.xyz;
    t49 = t50 * _DistFade;
    t50 = (-_DistFadeVert) * t50 + 1.0;
    t50 = clamp(t50, 0.0, 1.0);
    t49 = t49;
    t49 = clamp(t49, 0.0, 1.0);
    t5.w = t50 * t49;
    t16_4.w = t16_4.w * t5.w;
    vs_COLOR0 = t16_4;
    t6.x = fract(_Rotation);
    t6.yz = vec2(0.0, 0.0);
    t1.xyz = t1.xyz * vec3(0.5, 0.5, 0.5) + t6.xyz;
    t35.xy = (-t1.zz) * vec2(2.0, 2.0) + vec2(2.0, 1.0);
    t1.w = sqrt(t35.x);
    t50 = t48 * t35.y;
    t33.x = t1.z + t1.z;
    t1.xy = t1.xy * vec2(6.28318548, 6.28318548);
    t33.x = sqrt(t33.x);
    t6.x = sin(t1.y);
    t7.x = cos(t1.y);
    t8.x = cos(t1.x);
    t1.x = sin(t1.x);
    t17 = t33.x * t7.x;
    t33.x = t33.x * t6.x;
    t35.xy = t1.wx * vec2(t17);
    t51 = t33.x * t8.x + (-t35.y);
    t6.x = t17 * t51 + t1.x;
    t22 = t8.x * t17;
    t22 = t33.x * t1.x + t22;
    t17 = t17 * t22 + (-t8.x);
    t17 = t48 * t17;
    t7.xyz = _Object2World[1].yyy * unity_MatrixV[1].xyz;
    t7.xyz = unity_MatrixV[0].xyz * _Object2World[1].xxx + t7.xyz;
    t7.xyz = unity_MatrixV[2].xyz * _Object2World[1].zzz + t7.xyz;
    t7.xyz = unity_MatrixV[3].xyz * _Object2World[1].www + t7.xyz;
    t24.xyz = vec3(t17) * t7.xyz;
    t9.xyz = _Object2World[0].yyy * unity_MatrixV[1].xyz;
    t9.xyz = unity_MatrixV[0].xyz * _Object2World[0].xxx + t9.xyz;
    t9.xyz = unity_MatrixV[2].xyz * _Object2World[0].zzz + t9.xyz;
    t9.xyz = unity_MatrixV[3].xyz * _Object2World[0].www + t9.xyz;
    t6.xzw = t9.xyz * t6.xxx + t24.xyz;
    t24.xyz = _Object2World[2].yyy * unity_MatrixV[1].xyz;
    t24.xyz = unity_MatrixV[0].xyz * _Object2World[2].xxx + t24.xyz;
    t24.xyz = unity_MatrixV[2].xyz * _Object2World[2].zzz + t24.xyz;
    t24.xyz = unity_MatrixV[3].xyz * _Object2World[2].www + t24.xyz;
    t6.xzw = t24.xyz * t35.xxx + t6.xzw;
    t10.y = t6.w;
    t17 = t33.x * t51 + (-t8.x);
    t1.x = t33.x * t22 + (-t1.x);
    t33.x = t1.w * t33.x;
    t35.x = t1.w * t22;
    t49 = t1.w * t51;
    t11.xyz = t35.xxx * t7.xyz;
    t11.xyz = t9.xyz * vec3(t49) + t11.xyz;
    t11.xyz = t24.xyz * vec3(t50) + t11.xyz;
    t12.xyz = t1.xxx * t7.xyz;
    t1.xw = t0.yy * t7.xy;
    t0.xy = t9.xy * t0.xx + t1.xw;
    t0.xy = t24.xy * t0.zz + t0.xy;
    t32.x = t48 * t17;
    t1.xyw = t9.xyz * t32.xxx + t12.xyz;
    t1.xyz = t24.xyz * t33.xxx + t1.xyw;
    t10.x = t1.z;
    t10.z = t11.z;
    t32.x = dot(t10.xyz, t10.xyz);
    t32.x = inversesqrt(t32.x);
    t7.xyz = t32.xxx * t10.xyz;
    t5.xyz = abs(t7.xyz);
    vs_TEXCOORD0 = t5;
    t32.xy = _Object2World[3].yy * unity_MatrixV[1].xy;
    t32.xy = unity_MatrixV[0].xy * _Object2World[3].xx + t32.xy;
    t32.xy = unity_MatrixV[2].xy * _Object2World[3].zz + t32.xy;
    t32.xy = unity_MatrixV[3].xy * _Object2World[3].ww + t32.xy;
    t0.xy = t32.xy + t0.xy;
    ti5.xyz = ivec3(uvec3(lessThan(vec4(0.0, 0.0, 0.0, 0.0), (-t7.xyzx)).xyz) * 0xFFFFFFFFu);
    ti8.xyz = ivec3(uvec3(lessThan((-t7.xyzx), vec4(0.0, 0.0, 0.0, 0.0)).xyz) * 0xFFFFFFFFu);
    ti5.xyz = (-ti5.xyz) + ti8.xyz;
    t32.xy = in_TEXCOORD0.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    ti33 = int((0.0<t32.y) ? 0xFFFFFFFFu : uint(0u));
    ti49 = int((t32.y<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti33 = (-ti33) + ti49;
    ti8.xyz = ivec3(ti33) * ti5.xyz;
    t8.xyz = vec3(ti8.xyz);
    t8.xyz = vec3(t7.y * t8.x, t7.z * t8.y, t7.y * t8.z);
    t33.xy = vec2(ti5.xy);
    t33.xy = t32.xx * t33.xy;
    ti35.xy = ivec2(uvec2(lessThan(vec4(0.0, 0.0, 0.0, 0.0), t33.xyxy).xy) * 0xFFFFFFFFu);
    ti22.xz = ivec2(uvec2(lessThan(t33.xxyy, vec4(0.0, 0.0, 0.0, 0.0)).xz) * 0xFFFFFFFFu);
    ti35.xy = (-ti35.xy) + ti22.xz;
    ti35.xy = ti35.xy * ti5.xy;
    t35.xy = vec2(ti35.xy);
    t35.xy = t35.xy * t7.zx + t8.xy;
    t5.xy = t35.yy * t6.xz;
    t6.xy = t32.yy * t6.xz;
    t35.xy = t1.xy * t35.xx + t6.xy;
    t35.xy = t11.xy * t33.xx + t35.xy;
    t33.xy = t1.xy * t33.yy + t5.xy;
    t33.xy = t11.xy * t32.yy + t33.xy;
    t33.xy = t0.xy * in_POSITION0.ww + t33.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD2.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    t33.xy = t0.xy * in_POSITION0.ww + t35.xy;
    t33.xy = (-t3.xy) + t33.xy;
    vs_TEXCOORD1.xy = t33.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    ti48 = int((0.0<t7.z) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t7.z<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti48 = (-ti48) + ti33;
    t48 = float(ti48);
    t32.x = t48 * t32.x;
    ti48 = int((0.0<t32.x) ? 0xFFFFFFFFu : uint(0u));
    ti33 = int((t32.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    t1.xy = t1.xy * t32.xx + t6.xy;
    ti32 = (-ti48) + ti33;
    ti32 = ti32 * ti5.z;
    t32.x = float(ti32);
    t32.x = t32.x * t7.x + t8.z;
    t32.xy = t11.xy * t32.xx + t1.xy;
    t0.xy = t0.xy * in_POSITION0.ww + t32.xy;
    t0.xy = (-t3.xy) + t0.xy;
    vs_TEXCOORD3.xy = t0.xy * vec2(0.600000024, 0.600000024) + vec2(0.5, 0.5);
    vs_TEXCOORD4.xy = in_TEXCOORD0.xy;
    vs_TEXCOORD5 = vec4(0.0, 0.0, 0.0, 0.0);
    t0.x = dot((-t2.xyz), (-t2.xyz));
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * (-t2.xyz);
    t1.z = dot(t0.xyz, t2.xyz);
    t3.x = unity_MatrixV[0].x;
    t3.y = unity_MatrixV[1].x;
    t3.z = unity_MatrixV[2].x;
    t48 = dot(t3.xyz, t3.xyz);
    t48 = inversesqrt(t48);
    t5.xyz = vec3(t48) * t3.yzx;
    t6.xyz = t0.zxy * t5.xyz;
    t5.xyz = t0.yzx * t5.yzx + (-t6.xyz);
    t0.z = dot(t0.xyz, _WorldSpaceLightPos0.xyz);
    t1.y = dot((-t5.xyz), t2.xyz);
    t0.y = dot((-t5.xyz), _WorldSpaceLightPos0.xyz);
    t1.x = dot(t3.xyz, t2.xyz);
    t0.x = dot(t3.xyz, _WorldSpaceLightPos0.xyz);
    t48 = dot(t1.xyz, t1.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD7.xyz = vec3(t48) * t1.xyz;
    t48 = dot(t0.xyz, t0.xyz);
    t48 = inversesqrt(t48);
    vs_TEXCOORD8.xyz = vec3(t48) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	mat4 _PosRotation;
uniform 	float _DetailScale;
uniform 	lowp vec4 _Color;
uniform 	float _DistFade;
uniform 	float _DistFadeVert;
uniform 	float _MinScatter;
uniform 	float _Opacity;
uniform 	float _InvFade;
uniform 	float _Rotation;
uniform 	float _MaxScale;
uniform 	vec4 _NoiseScale;
uniform 	vec3 _MaxTrans;
uniform 	mat4 _CameraToWorld;
uniform lowp sampler2D _Tex;
in lowp vec4 vs_COLOR0;
in mediump vec4 vs_TEXCOORD0;
in highp vec2 vs_TEXCOORD1;
in highp vec2 vs_TEXCOORD2;
in highp vec2 vs_TEXCOORD3;
in highp vec2 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD7;
in highp vec3 vs_TEXCOORD8;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
mediump vec3 t16_1;
highp vec3 t2;
lowp vec4 t10_2;
highp vec3 t3;
mediump vec3 t16_4;
mediump vec3 t16_5;
highp vec2 t6;
mediump vec3 t16_7;
mediump float t16_13;
mediump float t16_14;
mediump float t16_19;
mediump float t16_22;
void main()
{
    t0.x = texture(_Tex, vs_TEXCOORD1.xy).x;
    t0.y = texture(_Tex, vs_TEXCOORD2.xy).y;
    t0.z = texture(_Tex, vs_TEXCOORD3.xy).z;
    t16_1.xyz = t0.xyz * vs_TEXCOORD0.xyz;
    t16_19 = vs_TEXCOORD0.y + vs_TEXCOORD0.x;
    t16_19 = t16_19 + vs_TEXCOORD0.z;
    t16_1.xyz = t16_1.xyz / vec3(t16_19);
    t16_1.x = t16_1.y + t16_1.x;
    t16_1.x = t16_1.z + t16_1.x;
    t16_7.x = t16_1.x * vs_TEXCOORD0.w;
    t0.x = (-_Opacity) * t16_7.x + _MinScatter;
    t2.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t3.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t6.xy = vs_TEXCOORD4.xy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t16_7.x = dot(t6.xy, t6.xy);
    t16_7.x = min(t16_7.x, 1.0);
    t16_7.x = (-t16_7.x) + 1.0;
    t16_14 = sqrt(t16_7.x);
    t2.z = t16_14;
    t3.z = t2.z;
    t16_7.x = dot(t2.xyz, t3.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_4.xy = t6.xy * t16_7.xx;
    t16_4.z = t16_7.x * t2.z;
    t16_7.x = dot(vs_TEXCOORD7.xyz, vs_TEXCOORD7.xyz);
    t16_7.x = inversesqrt(t16_7.x);
    t16_7.xyz = t16_7.xxx * vs_TEXCOORD7.xyz;
    t16_22 = dot(t16_4.xyz, t16_7.xyz);
    t16_22 = (-t16_22) + 1.0;
    t0.x = t0.x * t16_22;
    t16_22 = dot(vs_TEXCOORD8.xyz, vs_TEXCOORD8.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_5.xyz = vec3(t16_22) * vs_TEXCOORD8.xyz;
    t16_7.x = dot(t16_7.xyz, t16_5.xyz);
    t16_13 = dot(t16_4.xyz, t16_5.xyz);
    t16_13 = max(t16_13, 0.0);
    t16_7.x = t16_7.x * 0.5 + 0.5;
    t0.x = t0.x * t16_7.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = t0.x + t16_13;
    t0.xyz = t0.xxx * _LightColor0.xyz;
    t0.xyz = t0.xyz + t0.xyz;
    t10_2 = vs_COLOR0 * _Color;
    t16_0.xyz = t0.xyz * t10_2.xyz;
    t16_0.w = t16_1.x * t10_2.w;
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 642 math, 2 textures, 48 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "texcoord" ATTR1
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
ConstBuffer "$Globals" 528
Matrix 32 [glstate_matrix_modelview0]
Matrix 96 [_Object2World]
Matrix 160 [glstate_matrix_projection]
Matrix 224 [unity_MatrixV]
Matrix 288 [_MainRotation]
Matrix 352 [_DetailRotation]
Matrix 416 [_PosRotation]
Vector 0 [_WorldSpaceCameraPos] 3
VectorHalf 16 [_WorldSpaceLightPos0] 4
Float 480 [_DistFade]
Float 484 [_DistFadeVert]
Float 488 [_Rotation]
Float 492 [_MaxScale]
Vector 496 [_NoiseScale]
Vector 512 [_MaxTrans] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesMultiTexCoord0 [[attribute(1)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  half4 xlv_COLOR;
  half4 xlv_TEXCOORD0;
  float2 xlv_TEXCOORD1;
  float2 xlv_TEXCOORD2;
  float2 xlv_TEXCOORD3;
  float2 xlv_TEXCOORD4;
  float4 xlv_TEXCOORD5;
  float3 xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
  float3 xlv_TEXCOORD8;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  half4 _WorldSpaceLightPos0;
  float4x4 glstate_matrix_modelview0;
  float4x4 _Object2World;
  float4x4 glstate_matrix_projection;
  float4x4 unity_MatrixV;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4x4 _PosRotation;
  float _DistFade;
  float _DistFadeVert;
  float _Rotation;
  float _MaxScale;
  float4 _NoiseScale;
  float3 _MaxTrans;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> _MainTex [[texture(0)]], sampler _mtlsmp__MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]])
{
  xlatMtlShaderOutput _mtl_o;
  float2 tmpvar_1;
  tmpvar_1 = _mtl_i._glesMultiTexCoord0.xy;
  half3 normal_2;
  float4 XYv_3;
  float4 XZv_4;
  float4 ZYv_5;
  float4 localOrigin_6;
  float4 planet_pos_7;
  float4 origin_8;
  half4 tmpvar_9;
  half4 tmpvar_10;
  float4 tmpvar_11;
  float3 tmpvar_12;
  float4 tmpvar_13;
  tmpvar_13 = (_mtl_u._Object2World * float4(0.0, 0.0, 0.0, 1.0));
  origin_8 = tmpvar_13;
  float4 tmpvar_14;
  tmpvar_14 = (_mtl_u._PosRotation * tmpvar_13);
  planet_pos_7 = tmpvar_14;
  float3 tmpvar_15;
  tmpvar_15 = (_mtl_u._NoiseScale.z * tmpvar_14.xyz);
  float tmpvar_16;
  float4 m_17;
  float3 tmpvar_18;
  tmpvar_18 = floor((tmpvar_15 + dot (tmpvar_15, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_19;
  tmpvar_19 = ((tmpvar_15 - tmpvar_18) + dot (tmpvar_18, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_20;
  tmpvar_20.x = float((tmpvar_19.x >= tmpvar_19.y));
  tmpvar_20.y = float((tmpvar_19.y >= tmpvar_19.z));
  tmpvar_20.z = float((tmpvar_19.z >= tmpvar_19.x));
  float3 tmpvar_21;
  tmpvar_21 = (1.0 - tmpvar_20);
  float3 tmpvar_22;
  tmpvar_22 = min (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_23;
  tmpvar_23 = max (tmpvar_20, tmpvar_21.zxy);
  float3 tmpvar_24;
  tmpvar_24 = ((tmpvar_19 - tmpvar_22) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_25;
  tmpvar_25 = ((tmpvar_19 - tmpvar_23) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_26;
  tmpvar_26 = (tmpvar_19 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_27;
  tmpvar_27 = (tmpvar_18 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_28;
  tmpvar_28 = (fract(abs(tmpvar_27)) * float3(289.0, 289.0, 289.0));
  float tmpvar_29;
  if ((tmpvar_27.x >= 0.0)) {
    tmpvar_29 = tmpvar_28.x;
  } else {
    tmpvar_29 = -(tmpvar_28.x);
  };
  float tmpvar_30;
  if ((tmpvar_27.y >= 0.0)) {
    tmpvar_30 = tmpvar_28.y;
  } else {
    tmpvar_30 = -(tmpvar_28.y);
  };
  float tmpvar_31;
  if ((tmpvar_27.z >= 0.0)) {
    tmpvar_31 = tmpvar_28.z;
  } else {
    tmpvar_31 = -(tmpvar_28.z);
  };
  float4 tmpvar_32;
  tmpvar_32.xw = float2(0.0, 1.0);
  tmpvar_32.y = tmpvar_22.z;
  tmpvar_32.z = tmpvar_23.z;
  float4 x_33;
  x_33 = (tmpvar_31 + tmpvar_32);
  float4 tmpvar_34;
  tmpvar_34 = (((
    (x_33 * x_33)
   * 34.0) + x_33) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_35;
  tmpvar_35 = (fract(abs(tmpvar_34)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_36;
  if ((tmpvar_34.x >= 0.0)) {
    tmpvar_36 = tmpvar_35.x;
  } else {
    tmpvar_36 = -(tmpvar_35.x);
  };
  float tmpvar_37;
  if ((tmpvar_34.y >= 0.0)) {
    tmpvar_37 = tmpvar_35.y;
  } else {
    tmpvar_37 = -(tmpvar_35.y);
  };
  float tmpvar_38;
  if ((tmpvar_34.z >= 0.0)) {
    tmpvar_38 = tmpvar_35.z;
  } else {
    tmpvar_38 = -(tmpvar_35.z);
  };
  float tmpvar_39;
  if ((tmpvar_34.w >= 0.0)) {
    tmpvar_39 = tmpvar_35.w;
  } else {
    tmpvar_39 = -(tmpvar_35.w);
  };
  float4 tmpvar_40;
  tmpvar_40.x = tmpvar_36;
  tmpvar_40.y = tmpvar_37;
  tmpvar_40.z = tmpvar_38;
  tmpvar_40.w = tmpvar_39;
  float4 tmpvar_41;
  tmpvar_41.xw = float2(0.0, 1.0);
  tmpvar_41.y = tmpvar_22.y;
  tmpvar_41.z = tmpvar_23.y;
  float4 x_42;
  x_42 = ((tmpvar_40 + tmpvar_30) + tmpvar_41);
  float4 tmpvar_43;
  tmpvar_43 = (((
    (x_42 * x_42)
   * 34.0) + x_42) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_44;
  tmpvar_44 = (fract(abs(tmpvar_43)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_45;
  if ((tmpvar_43.x >= 0.0)) {
    tmpvar_45 = tmpvar_44.x;
  } else {
    tmpvar_45 = -(tmpvar_44.x);
  };
  float tmpvar_46;
  if ((tmpvar_43.y >= 0.0)) {
    tmpvar_46 = tmpvar_44.y;
  } else {
    tmpvar_46 = -(tmpvar_44.y);
  };
  float tmpvar_47;
  if ((tmpvar_43.z >= 0.0)) {
    tmpvar_47 = tmpvar_44.z;
  } else {
    tmpvar_47 = -(tmpvar_44.z);
  };
  float tmpvar_48;
  if ((tmpvar_43.w >= 0.0)) {
    tmpvar_48 = tmpvar_44.w;
  } else {
    tmpvar_48 = -(tmpvar_44.w);
  };
  float4 tmpvar_49;
  tmpvar_49.x = tmpvar_45;
  tmpvar_49.y = tmpvar_46;
  tmpvar_49.z = tmpvar_47;
  tmpvar_49.w = tmpvar_48;
  float4 tmpvar_50;
  tmpvar_50.xw = float2(0.0, 1.0);
  tmpvar_50.y = tmpvar_22.x;
  tmpvar_50.z = tmpvar_23.x;
  float4 x_51;
  x_51 = ((tmpvar_49 + tmpvar_29) + tmpvar_50);
  float4 tmpvar_52;
  tmpvar_52 = (((
    (x_51 * x_51)
   * 34.0) + x_51) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_53;
  tmpvar_53 = (fract(abs(tmpvar_52)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_54;
  if ((tmpvar_52.x >= 0.0)) {
    tmpvar_54 = tmpvar_53.x;
  } else {
    tmpvar_54 = -(tmpvar_53.x);
  };
  float tmpvar_55;
  if ((tmpvar_52.y >= 0.0)) {
    tmpvar_55 = tmpvar_53.y;
  } else {
    tmpvar_55 = -(tmpvar_53.y);
  };
  float tmpvar_56;
  if ((tmpvar_52.z >= 0.0)) {
    tmpvar_56 = tmpvar_53.z;
  } else {
    tmpvar_56 = -(tmpvar_53.z);
  };
  float tmpvar_57;
  if ((tmpvar_52.w >= 0.0)) {
    tmpvar_57 = tmpvar_53.w;
  } else {
    tmpvar_57 = -(tmpvar_53.w);
  };
  float4 tmpvar_58;
  tmpvar_58.x = tmpvar_54;
  tmpvar_58.y = tmpvar_55;
  tmpvar_58.z = tmpvar_56;
  tmpvar_58.w = tmpvar_57;
  float4 tmpvar_59;
  tmpvar_59 = (tmpvar_58 - (49.0 * floor(
    (0.02040815 * tmpvar_58)
  )));
  float4 tmpvar_60;
  tmpvar_60 = floor((tmpvar_59 * 0.1428571));
  float4 tmpvar_61;
  tmpvar_61 = ((tmpvar_60 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_62;
  tmpvar_62 = ((floor(
    (tmpvar_59 - (7.0 * tmpvar_60))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_63;
  tmpvar_63 = ((1.0 - abs(tmpvar_61)) - abs(tmpvar_62));
  float4 tmpvar_64;
  tmpvar_64.xy = tmpvar_61.xy;
  tmpvar_64.zw = tmpvar_62.xy;
  float4 tmpvar_65;
  tmpvar_65.xy = tmpvar_61.zw;
  tmpvar_65.zw = tmpvar_62.zw;
  float4 tmpvar_66;
  tmpvar_66 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_63)));
  float4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_66.xxyy));
  float4 tmpvar_68;
  tmpvar_68 = (tmpvar_65.xzyw + ((
    (floor(tmpvar_65) * 2.0)
   + 1.0).xzyw * tmpvar_66.zzww));
  float3 tmpvar_69;
  tmpvar_69.xy = tmpvar_67.xy;
  tmpvar_69.z = tmpvar_63.x;
  float3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.zw;
  tmpvar_70.z = tmpvar_63.y;
  float3 tmpvar_71;
  tmpvar_71.xy = tmpvar_68.xy;
  tmpvar_71.z = tmpvar_63.z;
  float3 tmpvar_72;
  tmpvar_72.xy = tmpvar_68.zw;
  tmpvar_72.z = tmpvar_63.w;
  float4 tmpvar_73;
  tmpvar_73.x = dot (tmpvar_69, tmpvar_69);
  tmpvar_73.y = dot (tmpvar_70, tmpvar_70);
  tmpvar_73.z = dot (tmpvar_71, tmpvar_71);
  tmpvar_73.w = dot (tmpvar_72, tmpvar_72);
  float4 tmpvar_74;
  tmpvar_74 = (1.792843 - (0.8537347 * tmpvar_73));
  float4 tmpvar_75;
  tmpvar_75.x = dot (tmpvar_19, tmpvar_19);
  tmpvar_75.y = dot (tmpvar_24, tmpvar_24);
  tmpvar_75.z = dot (tmpvar_25, tmpvar_25);
  tmpvar_75.w = dot (tmpvar_26, tmpvar_26);
  float4 tmpvar_76;
  tmpvar_76 = max ((0.6 - tmpvar_75), float4(0.0, 0.0, 0.0, 0.0));
  m_17 = (tmpvar_76 * tmpvar_76);
  float4 tmpvar_77;
  tmpvar_77.x = dot ((tmpvar_69 * tmpvar_74.x), tmpvar_19);
  tmpvar_77.y = dot ((tmpvar_70 * tmpvar_74.y), tmpvar_24);
  tmpvar_77.z = dot ((tmpvar_71 * tmpvar_74.z), tmpvar_25);
  tmpvar_77.w = dot ((tmpvar_72 * tmpvar_74.w), tmpvar_26);
  tmpvar_16 = (42.0 * dot ((m_17 * m_17), tmpvar_77));
  float tmpvar_78;
  float3 v_79;
  v_79 = (_mtl_u._NoiseScale.x * tmpvar_15);
  float4 m_80;
  float3 tmpvar_81;
  tmpvar_81 = floor((v_79 + dot (v_79, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_82;
  tmpvar_82 = ((v_79 - tmpvar_81) + dot (tmpvar_81, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_83;
  tmpvar_83.x = float((tmpvar_82.x >= tmpvar_82.y));
  tmpvar_83.y = float((tmpvar_82.y >= tmpvar_82.z));
  tmpvar_83.z = float((tmpvar_82.z >= tmpvar_82.x));
  float3 tmpvar_84;
  tmpvar_84 = (1.0 - tmpvar_83);
  float3 tmpvar_85;
  tmpvar_85 = min (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_86;
  tmpvar_86 = max (tmpvar_83, tmpvar_84.zxy);
  float3 tmpvar_87;
  tmpvar_87 = ((tmpvar_82 - tmpvar_85) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_88;
  tmpvar_88 = ((tmpvar_82 - tmpvar_86) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_89;
  tmpvar_89 = (tmpvar_82 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_90;
  tmpvar_90 = (tmpvar_81 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_91;
  tmpvar_91 = (fract(abs(tmpvar_90)) * float3(289.0, 289.0, 289.0));
  float tmpvar_92;
  if ((tmpvar_90.x >= 0.0)) {
    tmpvar_92 = tmpvar_91.x;
  } else {
    tmpvar_92 = -(tmpvar_91.x);
  };
  float tmpvar_93;
  if ((tmpvar_90.y >= 0.0)) {
    tmpvar_93 = tmpvar_91.y;
  } else {
    tmpvar_93 = -(tmpvar_91.y);
  };
  float tmpvar_94;
  if ((tmpvar_90.z >= 0.0)) {
    tmpvar_94 = tmpvar_91.z;
  } else {
    tmpvar_94 = -(tmpvar_91.z);
  };
  float4 tmpvar_95;
  tmpvar_95.xw = float2(0.0, 1.0);
  tmpvar_95.y = tmpvar_85.z;
  tmpvar_95.z = tmpvar_86.z;
  float4 x_96;
  x_96 = (tmpvar_94 + tmpvar_95);
  float4 tmpvar_97;
  tmpvar_97 = (((
    (x_96 * x_96)
   * 34.0) + x_96) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_98;
  tmpvar_98 = (fract(abs(tmpvar_97)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_99;
  if ((tmpvar_97.x >= 0.0)) {
    tmpvar_99 = tmpvar_98.x;
  } else {
    tmpvar_99 = -(tmpvar_98.x);
  };
  float tmpvar_100;
  if ((tmpvar_97.y >= 0.0)) {
    tmpvar_100 = tmpvar_98.y;
  } else {
    tmpvar_100 = -(tmpvar_98.y);
  };
  float tmpvar_101;
  if ((tmpvar_97.z >= 0.0)) {
    tmpvar_101 = tmpvar_98.z;
  } else {
    tmpvar_101 = -(tmpvar_98.z);
  };
  float tmpvar_102;
  if ((tmpvar_97.w >= 0.0)) {
    tmpvar_102 = tmpvar_98.w;
  } else {
    tmpvar_102 = -(tmpvar_98.w);
  };
  float4 tmpvar_103;
  tmpvar_103.x = tmpvar_99;
  tmpvar_103.y = tmpvar_100;
  tmpvar_103.z = tmpvar_101;
  tmpvar_103.w = tmpvar_102;
  float4 tmpvar_104;
  tmpvar_104.xw = float2(0.0, 1.0);
  tmpvar_104.y = tmpvar_85.y;
  tmpvar_104.z = tmpvar_86.y;
  float4 x_105;
  x_105 = ((tmpvar_103 + tmpvar_93) + tmpvar_104);
  float4 tmpvar_106;
  tmpvar_106 = (((
    (x_105 * x_105)
   * 34.0) + x_105) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_107;
  tmpvar_107 = (fract(abs(tmpvar_106)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_108;
  if ((tmpvar_106.x >= 0.0)) {
    tmpvar_108 = tmpvar_107.x;
  } else {
    tmpvar_108 = -(tmpvar_107.x);
  };
  float tmpvar_109;
  if ((tmpvar_106.y >= 0.0)) {
    tmpvar_109 = tmpvar_107.y;
  } else {
    tmpvar_109 = -(tmpvar_107.y);
  };
  float tmpvar_110;
  if ((tmpvar_106.z >= 0.0)) {
    tmpvar_110 = tmpvar_107.z;
  } else {
    tmpvar_110 = -(tmpvar_107.z);
  };
  float tmpvar_111;
  if ((tmpvar_106.w >= 0.0)) {
    tmpvar_111 = tmpvar_107.w;
  } else {
    tmpvar_111 = -(tmpvar_107.w);
  };
  float4 tmpvar_112;
  tmpvar_112.x = tmpvar_108;
  tmpvar_112.y = tmpvar_109;
  tmpvar_112.z = tmpvar_110;
  tmpvar_112.w = tmpvar_111;
  float4 tmpvar_113;
  tmpvar_113.xw = float2(0.0, 1.0);
  tmpvar_113.y = tmpvar_85.x;
  tmpvar_113.z = tmpvar_86.x;
  float4 x_114;
  x_114 = ((tmpvar_112 + tmpvar_92) + tmpvar_113);
  float4 tmpvar_115;
  tmpvar_115 = (((
    (x_114 * x_114)
   * 34.0) + x_114) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_116;
  tmpvar_116 = (fract(abs(tmpvar_115)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_117;
  if ((tmpvar_115.x >= 0.0)) {
    tmpvar_117 = tmpvar_116.x;
  } else {
    tmpvar_117 = -(tmpvar_116.x);
  };
  float tmpvar_118;
  if ((tmpvar_115.y >= 0.0)) {
    tmpvar_118 = tmpvar_116.y;
  } else {
    tmpvar_118 = -(tmpvar_116.y);
  };
  float tmpvar_119;
  if ((tmpvar_115.z >= 0.0)) {
    tmpvar_119 = tmpvar_116.z;
  } else {
    tmpvar_119 = -(tmpvar_116.z);
  };
  float tmpvar_120;
  if ((tmpvar_115.w >= 0.0)) {
    tmpvar_120 = tmpvar_116.w;
  } else {
    tmpvar_120 = -(tmpvar_116.w);
  };
  float4 tmpvar_121;
  tmpvar_121.x = tmpvar_117;
  tmpvar_121.y = tmpvar_118;
  tmpvar_121.z = tmpvar_119;
  tmpvar_121.w = tmpvar_120;
  float4 tmpvar_122;
  tmpvar_122 = (tmpvar_121 - (49.0 * floor(
    (0.02040815 * tmpvar_121)
  )));
  float4 tmpvar_123;
  tmpvar_123 = floor((tmpvar_122 * 0.1428571));
  float4 tmpvar_124;
  tmpvar_124 = ((tmpvar_123 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_125;
  tmpvar_125 = ((floor(
    (tmpvar_122 - (7.0 * tmpvar_123))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_126;
  tmpvar_126 = ((1.0 - abs(tmpvar_124)) - abs(tmpvar_125));
  float4 tmpvar_127;
  tmpvar_127.xy = tmpvar_124.xy;
  tmpvar_127.zw = tmpvar_125.xy;
  float4 tmpvar_128;
  tmpvar_128.xy = tmpvar_124.zw;
  tmpvar_128.zw = tmpvar_125.zw;
  float4 tmpvar_129;
  tmpvar_129 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_126)));
  float4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_129.xxyy));
  float4 tmpvar_131;
  tmpvar_131 = (tmpvar_128.xzyw + ((
    (floor(tmpvar_128) * 2.0)
   + 1.0).xzyw * tmpvar_129.zzww));
  float3 tmpvar_132;
  tmpvar_132.xy = tmpvar_130.xy;
  tmpvar_132.z = tmpvar_126.x;
  float3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.zw;
  tmpvar_133.z = tmpvar_126.y;
  float3 tmpvar_134;
  tmpvar_134.xy = tmpvar_131.xy;
  tmpvar_134.z = tmpvar_126.z;
  float3 tmpvar_135;
  tmpvar_135.xy = tmpvar_131.zw;
  tmpvar_135.z = tmpvar_126.w;
  float4 tmpvar_136;
  tmpvar_136.x = dot (tmpvar_132, tmpvar_132);
  tmpvar_136.y = dot (tmpvar_133, tmpvar_133);
  tmpvar_136.z = dot (tmpvar_134, tmpvar_134);
  tmpvar_136.w = dot (tmpvar_135, tmpvar_135);
  float4 tmpvar_137;
  tmpvar_137 = (1.792843 - (0.8537347 * tmpvar_136));
  float4 tmpvar_138;
  tmpvar_138.x = dot (tmpvar_82, tmpvar_82);
  tmpvar_138.y = dot (tmpvar_87, tmpvar_87);
  tmpvar_138.z = dot (tmpvar_88, tmpvar_88);
  tmpvar_138.w = dot (tmpvar_89, tmpvar_89);
  float4 tmpvar_139;
  tmpvar_139 = max ((0.6 - tmpvar_138), float4(0.0, 0.0, 0.0, 0.0));
  m_80 = (tmpvar_139 * tmpvar_139);
  float4 tmpvar_140;
  tmpvar_140.x = dot ((tmpvar_132 * tmpvar_137.x), tmpvar_82);
  tmpvar_140.y = dot ((tmpvar_133 * tmpvar_137.y), tmpvar_87);
  tmpvar_140.z = dot ((tmpvar_134 * tmpvar_137.z), tmpvar_88);
  tmpvar_140.w = dot ((tmpvar_135 * tmpvar_137.w), tmpvar_89);
  tmpvar_78 = (42.0 * dot ((m_80 * m_80), tmpvar_140));
  float3 v_141;
  v_141 = (_mtl_u._NoiseScale.y * tmpvar_15);
  float4 m_142;
  float3 tmpvar_143;
  tmpvar_143 = floor((v_141 + dot (v_141, float3(0.3333333, 0.3333333, 0.3333333))));
  float3 tmpvar_144;
  tmpvar_144 = ((v_141 - tmpvar_143) + dot (tmpvar_143, float3(0.1666667, 0.1666667, 0.1666667)));
  float3 tmpvar_145;
  tmpvar_145.x = float((tmpvar_144.x >= tmpvar_144.y));
  tmpvar_145.y = float((tmpvar_144.y >= tmpvar_144.z));
  tmpvar_145.z = float((tmpvar_144.z >= tmpvar_144.x));
  float3 tmpvar_146;
  tmpvar_146 = (1.0 - tmpvar_145);
  float3 tmpvar_147;
  tmpvar_147 = min (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_148;
  tmpvar_148 = max (tmpvar_145, tmpvar_146.zxy);
  float3 tmpvar_149;
  tmpvar_149 = ((tmpvar_144 - tmpvar_147) + float3(0.1666667, 0.1666667, 0.1666667));
  float3 tmpvar_150;
  tmpvar_150 = ((tmpvar_144 - tmpvar_148) + float3(0.3333333, 0.3333333, 0.3333333));
  float3 tmpvar_151;
  tmpvar_151 = (tmpvar_144 - float3(0.5, 0.5, 0.5));
  float3 tmpvar_152;
  tmpvar_152 = (tmpvar_143 / float3(289.0, 289.0, 289.0));
  float3 tmpvar_153;
  tmpvar_153 = (fract(abs(tmpvar_152)) * float3(289.0, 289.0, 289.0));
  float tmpvar_154;
  if ((tmpvar_152.x >= 0.0)) {
    tmpvar_154 = tmpvar_153.x;
  } else {
    tmpvar_154 = -(tmpvar_153.x);
  };
  float tmpvar_155;
  if ((tmpvar_152.y >= 0.0)) {
    tmpvar_155 = tmpvar_153.y;
  } else {
    tmpvar_155 = -(tmpvar_153.y);
  };
  float tmpvar_156;
  if ((tmpvar_152.z >= 0.0)) {
    tmpvar_156 = tmpvar_153.z;
  } else {
    tmpvar_156 = -(tmpvar_153.z);
  };
  float4 tmpvar_157;
  tmpvar_157.xw = float2(0.0, 1.0);
  tmpvar_157.y = tmpvar_147.z;
  tmpvar_157.z = tmpvar_148.z;
  float4 x_158;
  x_158 = (tmpvar_156 + tmpvar_157);
  float4 tmpvar_159;
  tmpvar_159 = (((
    (x_158 * x_158)
   * 34.0) + x_158) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_160;
  tmpvar_160 = (fract(abs(tmpvar_159)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_161;
  if ((tmpvar_159.x >= 0.0)) {
    tmpvar_161 = tmpvar_160.x;
  } else {
    tmpvar_161 = -(tmpvar_160.x);
  };
  float tmpvar_162;
  if ((tmpvar_159.y >= 0.0)) {
    tmpvar_162 = tmpvar_160.y;
  } else {
    tmpvar_162 = -(tmpvar_160.y);
  };
  float tmpvar_163;
  if ((tmpvar_159.z >= 0.0)) {
    tmpvar_163 = tmpvar_160.z;
  } else {
    tmpvar_163 = -(tmpvar_160.z);
  };
  float tmpvar_164;
  if ((tmpvar_159.w >= 0.0)) {
    tmpvar_164 = tmpvar_160.w;
  } else {
    tmpvar_164 = -(tmpvar_160.w);
  };
  float4 tmpvar_165;
  tmpvar_165.x = tmpvar_161;
  tmpvar_165.y = tmpvar_162;
  tmpvar_165.z = tmpvar_163;
  tmpvar_165.w = tmpvar_164;
  float4 tmpvar_166;
  tmpvar_166.xw = float2(0.0, 1.0);
  tmpvar_166.y = tmpvar_147.y;
  tmpvar_166.z = tmpvar_148.y;
  float4 x_167;
  x_167 = ((tmpvar_165 + tmpvar_155) + tmpvar_166);
  float4 tmpvar_168;
  tmpvar_168 = (((
    (x_167 * x_167)
   * 34.0) + x_167) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_169;
  tmpvar_169 = (fract(abs(tmpvar_168)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_170;
  if ((tmpvar_168.x >= 0.0)) {
    tmpvar_170 = tmpvar_169.x;
  } else {
    tmpvar_170 = -(tmpvar_169.x);
  };
  float tmpvar_171;
  if ((tmpvar_168.y >= 0.0)) {
    tmpvar_171 = tmpvar_169.y;
  } else {
    tmpvar_171 = -(tmpvar_169.y);
  };
  float tmpvar_172;
  if ((tmpvar_168.z >= 0.0)) {
    tmpvar_172 = tmpvar_169.z;
  } else {
    tmpvar_172 = -(tmpvar_169.z);
  };
  float tmpvar_173;
  if ((tmpvar_168.w >= 0.0)) {
    tmpvar_173 = tmpvar_169.w;
  } else {
    tmpvar_173 = -(tmpvar_169.w);
  };
  float4 tmpvar_174;
  tmpvar_174.x = tmpvar_170;
  tmpvar_174.y = tmpvar_171;
  tmpvar_174.z = tmpvar_172;
  tmpvar_174.w = tmpvar_173;
  float4 tmpvar_175;
  tmpvar_175.xw = float2(0.0, 1.0);
  tmpvar_175.y = tmpvar_147.x;
  tmpvar_175.z = tmpvar_148.x;
  float4 x_176;
  x_176 = ((tmpvar_174 + tmpvar_154) + tmpvar_175);
  float4 tmpvar_177;
  tmpvar_177 = (((
    (x_176 * x_176)
   * 34.0) + x_176) / float4(289.0, 289.0, 289.0, 289.0));
  float4 tmpvar_178;
  tmpvar_178 = (fract(abs(tmpvar_177)) * float4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_179;
  if ((tmpvar_177.x >= 0.0)) {
    tmpvar_179 = tmpvar_178.x;
  } else {
    tmpvar_179 = -(tmpvar_178.x);
  };
  float tmpvar_180;
  if ((tmpvar_177.y >= 0.0)) {
    tmpvar_180 = tmpvar_178.y;
  } else {
    tmpvar_180 = -(tmpvar_178.y);
  };
  float tmpvar_181;
  if ((tmpvar_177.z >= 0.0)) {
    tmpvar_181 = tmpvar_178.z;
  } else {
    tmpvar_181 = -(tmpvar_178.z);
  };
  float tmpvar_182;
  if ((tmpvar_177.w >= 0.0)) {
    tmpvar_182 = tmpvar_178.w;
  } else {
    tmpvar_182 = -(tmpvar_178.w);
  };
  float4 tmpvar_183;
  tmpvar_183.x = tmpvar_179;
  tmpvar_183.y = tmpvar_180;
  tmpvar_183.z = tmpvar_181;
  tmpvar_183.w = tmpvar_182;
  float4 tmpvar_184;
  tmpvar_184 = (tmpvar_183 - (49.0 * floor(
    (0.02040815 * tmpvar_183)
  )));
  float4 tmpvar_185;
  tmpvar_185 = floor((tmpvar_184 * 0.1428571));
  float4 tmpvar_186;
  tmpvar_186 = ((tmpvar_185 * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_187;
  tmpvar_187 = ((floor(
    (tmpvar_184 - (7.0 * tmpvar_185))
  ) * 0.2857142) + float4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  float4 tmpvar_188;
  tmpvar_188 = ((1.0 - abs(tmpvar_186)) - abs(tmpvar_187));
  float4 tmpvar_189;
  tmpvar_189.xy = tmpvar_186.xy;
  tmpvar_189.zw = tmpvar_187.xy;
  float4 tmpvar_190;
  tmpvar_190.xy = tmpvar_186.zw;
  tmpvar_190.zw = tmpvar_187.zw;
  float4 tmpvar_191;
  tmpvar_191 = -(float4((float4(0.0, 0.0, 0.0, 0.0) >= tmpvar_188)));
  float4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_191.xxyy));
  float4 tmpvar_193;
  tmpvar_193 = (tmpvar_190.xzyw + ((
    (floor(tmpvar_190) * 2.0)
   + 1.0).xzyw * tmpvar_191.zzww));
  float3 tmpvar_194;
  tmpvar_194.xy = tmpvar_192.xy;
  tmpvar_194.z = tmpvar_188.x;
  float3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.zw;
  tmpvar_195.z = tmpvar_188.y;
  float3 tmpvar_196;
  tmpvar_196.xy = tmpvar_193.xy;
  tmpvar_196.z = tmpvar_188.z;
  float3 tmpvar_197;
  tmpvar_197.xy = tmpvar_193.zw;
  tmpvar_197.z = tmpvar_188.w;
  float4 tmpvar_198;
  tmpvar_198.x = dot (tmpvar_194, tmpvar_194);
  tmpvar_198.y = dot (tmpvar_195, tmpvar_195);
  tmpvar_198.z = dot (tmpvar_196, tmpvar_196);
  tmpvar_198.w = dot (tmpvar_197, tmpvar_197);
  float4 tmpvar_199;
  tmpvar_199 = (1.792843 - (0.8537347 * tmpvar_198));
  float4 tmpvar_200;
  tmpvar_200.x = dot (tmpvar_144, tmpvar_144);
  tmpvar_200.y = dot (tmpvar_149, tmpvar_149);
  tmpvar_200.z = dot (tmpvar_150, tmpvar_150);
  tmpvar_200.w = dot (tmpvar_151, tmpvar_151);
  float4 tmpvar_201;
  tmpvar_201 = max ((0.6 - tmpvar_200), float4(0.0, 0.0, 0.0, 0.0));
  m_142 = (tmpvar_201 * tmpvar_201);
  float4 tmpvar_202;
  tmpvar_202.x = dot ((tmpvar_194 * tmpvar_199.x), tmpvar_144);
  tmpvar_202.y = dot ((tmpvar_195 * tmpvar_199.y), tmpvar_149);
  tmpvar_202.z = dot ((tmpvar_196 * tmpvar_199.z), tmpvar_150);
  tmpvar_202.w = dot ((tmpvar_197 * tmpvar_199.w), tmpvar_151);
  float3 tmpvar_203;
  tmpvar_203.x = tmpvar_16;
  tmpvar_203.y = tmpvar_78;
  tmpvar_203.z = (42.0 * dot ((m_142 * m_142), tmpvar_202));
  float3 tmpvar_204;
  tmpvar_204 = (0.5 * (tmpvar_203 + 1.0));
  localOrigin_6.xyz = (((2.0 * tmpvar_204) - 1.0) * _mtl_u._MaxTrans);
  localOrigin_6.w = 1.0;
  float tmpvar_205;
  tmpvar_205 = ((tmpvar_204.x * (_mtl_u._MaxScale - 1.0)) + 1.0);
  origin_8 = (_mtl_u._Object2World * localOrigin_6);
  planet_pos_7 = (_mtl_u._MainRotation * origin_8);
  float3 tmpvar_206;
  tmpvar_206 = (_mtl_u._DetailRotation * planet_pos_7).xyz;
  tmpvar_12 = planet_pos_7.xyz;
  float3 tmpvar_207;
  tmpvar_207 = normalize(planet_pos_7.xyz);
  float2 uv_208;
  float tmpvar_209;
  float tmpvar_210;
  tmpvar_210 = (min (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0) / max (abs(
    (tmpvar_207.x / tmpvar_207.z)
  ), 1.0));
  float tmpvar_211;
  tmpvar_211 = (tmpvar_210 * tmpvar_210);
  tmpvar_211 = (((
    ((((
      ((((-0.01213232 * tmpvar_211) + 0.05368138) * tmpvar_211) - 0.1173503)
     * tmpvar_211) + 0.1938925) * tmpvar_211) - 0.3326756)
   * tmpvar_211) + 0.9999793) * tmpvar_210);
  tmpvar_211 = (tmpvar_211 + (float(
    (abs((tmpvar_207.x / tmpvar_207.z)) > 1.0)
  ) * (
    (tmpvar_211 * -2.0)
   + 1.570796)));
  tmpvar_209 = (tmpvar_211 * sign((tmpvar_207.x / tmpvar_207.z)));
  if ((abs(tmpvar_207.z) > (1e-08 * abs(tmpvar_207.x)))) {
    if ((tmpvar_207.z < 0.0)) {
      if ((tmpvar_207.x >= 0.0)) {
        tmpvar_209 += 3.141593;
      } else {
        tmpvar_209 = (tmpvar_209 - 3.141593);
      };
    };
  } else {
    tmpvar_209 = (sign(tmpvar_207.x) * 1.570796);
  };
  uv_208.x = (0.5 + (0.1591549 * tmpvar_209));
  uv_208.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_207.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_207.y)
    )) * (1.570796 + (
      abs(tmpvar_207.y)
     * 
      (-0.2146018 + (abs(tmpvar_207.y) * (0.08656672 + (
        abs(tmpvar_207.y)
       * -0.03102955))))
    ))))
  )));
  half4 tmpvar_212;
  tmpvar_212 = _MainTex.sample(_mtlsmp__MainTex, (float2)(uv_208), level(0.0));
  half4 tmpvar_213;
  tmpvar_213 = tmpvar_212;
  tmpvar_9 = tmpvar_213;
  half3 detailCoords_214;
  half s_215;
  half nylerp_216;
  half zxlerp_217;
  float4 uv4_218;
  uv4_218.zw = float2(0.0, 0.0);
  float3 tmpvar_219;
  tmpvar_219 = normalize(tmpvar_206);
  float3 tmpvar_220;
  tmpvar_220 = abs(tmpvar_219);
  float tmpvar_221;
  tmpvar_221 = float((tmpvar_220.z >= tmpvar_220.x));
  zxlerp_217 = half(tmpvar_221);
  float tmpvar_222;
  tmpvar_222 = float((max (tmpvar_220.x, tmpvar_220.z) >= tmpvar_220.y));
  nylerp_216 = half(tmpvar_222);
  float tmpvar_223;
  tmpvar_223 = mix (tmpvar_219.x, tmpvar_219.z, (float)zxlerp_217);
  s_215 = half(tmpvar_223);
  float tmpvar_224;
  tmpvar_224 = sign(mix (tmpvar_219.y, (float)s_215, (float)nylerp_216));
  s_215 = half(tmpvar_224);
  half3 tmpvar_225;
  tmpvar_225.xz = half2(float2(1.0, -1.0));
  tmpvar_225.y = -(s_215);
  half3 tmpvar_226;
  tmpvar_226.xz = half2(float2(1.0, -1.0));
  tmpvar_226.y = s_215;
  float3 tmpvar_227;
  tmpvar_227 = mix (((float3)tmpvar_225 * tmpvar_219.xzy), ((float3)tmpvar_226 * tmpvar_219.zxy), (float3)half3(zxlerp_217));
  detailCoords_214 = half3(tmpvar_227);
  half3 tmpvar_228;
  tmpvar_228.xy = half2(float2(1.0, 1.0));
  tmpvar_228.z = s_215;
  float3 tmpvar_229;
  tmpvar_229 = mix (((float3)tmpvar_228 * tmpvar_219.yxz), (float3)detailCoords_214, (float3)half3(nylerp_216));
  detailCoords_214 = half3(tmpvar_229);
  half2 tmpvar_230;
  tmpvar_230 = ((((half)0.5 * detailCoords_214.yz) / abs(detailCoords_214.x)) + (half)0.5);
  uv4_218.xy = float2(tmpvar_230);
  half4 tmpvar_231;
  tmpvar_231 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv4_218.xy), level(0.0));
  half4 tmpvar_232;
  tmpvar_232 = tmpvar_231;
  tmpvar_9 = (tmpvar_9 * tmpvar_232);
  float4 tmpvar_233;
  tmpvar_233.w = 0.0;
  tmpvar_233.xyz = _mtl_u._WorldSpaceCameraPos;
  float tmpvar_234;
  float4 tmpvar_235;
  tmpvar_235 = (origin_8 - tmpvar_233);
  tmpvar_234 = sqrt(dot (tmpvar_235, tmpvar_235));
  float tmpvar_236;
  tmpvar_236 = (clamp ((_mtl_u._DistFade * tmpvar_234), 0.0, 1.0) * clamp ((1.0 - 
    (_mtl_u._DistFadeVert * tmpvar_234)
  ), 0.0, 1.0));
  tmpvar_10.w = half(tmpvar_236);
  tmpvar_9.w = (tmpvar_9.w * tmpvar_10.w);
  float3 tmpvar_237;
  tmpvar_237.yz = float2(0.0, 0.0);
  tmpvar_237.x = fract(_mtl_u._Rotation);
  float3 x_238;
  x_238 = (tmpvar_237 + tmpvar_204);
  float3 trans_239;
  trans_239 = localOrigin_6.xyz;
  float tmpvar_240;
  tmpvar_240 = (x_238.x * 6.283185);
  float tmpvar_241;
  tmpvar_241 = (x_238.y * 6.283185);
  float tmpvar_242;
  tmpvar_242 = (x_238.z * 2.0);
  float tmpvar_243;
  tmpvar_243 = sqrt(tmpvar_242);
  float tmpvar_244;
  tmpvar_244 = (sin(tmpvar_241) * tmpvar_243);
  float tmpvar_245;
  tmpvar_245 = (cos(tmpvar_241) * tmpvar_243);
  float tmpvar_246;
  tmpvar_246 = sqrt((2.0 - tmpvar_242));
  float tmpvar_247;
  tmpvar_247 = sin(tmpvar_240);
  float tmpvar_248;
  tmpvar_248 = cos(tmpvar_240);
  float tmpvar_249;
  tmpvar_249 = ((tmpvar_244 * tmpvar_248) - (tmpvar_245 * tmpvar_247));
  float tmpvar_250;
  tmpvar_250 = ((tmpvar_244 * tmpvar_247) + (tmpvar_245 * tmpvar_248));
  float4x4 tmpvar_251;
  tmpvar_251[0].x = (tmpvar_205 * ((tmpvar_244 * tmpvar_249) - tmpvar_248));
  tmpvar_251[0].y = ((tmpvar_244 * tmpvar_250) - tmpvar_247);
  tmpvar_251[0].z = (tmpvar_244 * tmpvar_246);
  tmpvar_251[0].w = 0.0;
  tmpvar_251[1].x = ((tmpvar_245 * tmpvar_249) + tmpvar_247);
  tmpvar_251[1].y = (tmpvar_205 * ((tmpvar_245 * tmpvar_250) - tmpvar_248));
  tmpvar_251[1].z = (tmpvar_245 * tmpvar_246);
  tmpvar_251[1].w = 0.0;
  tmpvar_251[2].x = (tmpvar_246 * tmpvar_249);
  tmpvar_251[2].y = (tmpvar_246 * tmpvar_250);
  tmpvar_251[2].z = (tmpvar_205 * (1.0 - tmpvar_242));
  tmpvar_251[2].w = 0.0;
  tmpvar_251[3].x = trans_239.x;
  tmpvar_251[3].y = trans_239.y;
  tmpvar_251[3].z = trans_239.z;
  tmpvar_251[3].w = 1.0;
  float4x4 tmpvar_252;
  tmpvar_252 = ((_mtl_u.unity_MatrixV * _mtl_u._Object2World) * tmpvar_251);
  float4 v_253;
  v_253.x = tmpvar_252[0].z;
  v_253.y = tmpvar_252[1].z;
  v_253.z = tmpvar_252[2].z;
  v_253.w = tmpvar_252[3].z;
  float3 tmpvar_254;
  tmpvar_254 = normalize(v_253.xyz);
  float3 tmpvar_255;
  tmpvar_255 = abs(tmpvar_254);
  tmpvar_10.xyz = half3(tmpvar_255);
  float4 tmpvar_256;
  tmpvar_256 = (_mtl_u.glstate_matrix_modelview0 * localOrigin_6);
  float4 tmpvar_257;
  tmpvar_257.xyz = (_mtl_i._glesVertex.xyz * tmpvar_205);
  tmpvar_257.w = _mtl_i._glesVertex.w;
  float2 tmpvar_258;
  tmpvar_258 = ((2.0 * _mtl_i._glesMultiTexCoord0.xy) - 1.0);
  float4 tmpvar_259;
  tmpvar_259.z = 0.0;
  tmpvar_259.xy = tmpvar_258;
  tmpvar_259.w = _mtl_i._glesVertex.w;
  ZYv_5.xyw = tmpvar_259.zyw;
  XZv_4.yzw = tmpvar_259.zyw;
  XYv_3.yzw = tmpvar_259.yzw;
  ZYv_5.z = (tmpvar_258.x * sign(-(tmpvar_254.x)));
  XZv_4.x = (tmpvar_258.x * sign(-(tmpvar_254.y)));
  XYv_3.x = (tmpvar_258.x * sign(tmpvar_254.z));
  ZYv_5.x = ((sign(
    -(tmpvar_254.x)
  ) * sign(ZYv_5.z)) * tmpvar_254.z);
  XZv_4.y = ((sign(
    -(tmpvar_254.y)
  ) * sign(XZv_4.x)) * tmpvar_254.x);
  XYv_3.z = ((sign(
    -(tmpvar_254.z)
  ) * sign(XYv_3.x)) * tmpvar_254.x);
  ZYv_5.x = (ZYv_5.x + ((
    sign(-(tmpvar_254.x))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  XZv_4.y = (XZv_4.y + ((
    sign(-(tmpvar_254.y))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.z));
  XYv_3.z = (XYv_3.z + ((
    sign(-(tmpvar_254.z))
   * 
    sign(tmpvar_258.y)
  ) * tmpvar_254.y));
  float3 tmpvar_260;
  tmpvar_260 = normalize((origin_8.xyz - _mtl_u._WorldSpaceCameraPos));
  float3 tmpvar_261;
  tmpvar_261 = normalize(-(tmpvar_260));
  normal_2 = half3(tmpvar_261);
  float4 v_262;
  v_262.x = _mtl_u.unity_MatrixV[0].x;
  v_262.y = _mtl_u.unity_MatrixV[1].x;
  v_262.z = _mtl_u.unity_MatrixV[2].x;
  v_262.w = _mtl_u.unity_MatrixV[3].x;
  float3 tmpvar_263;
  tmpvar_263 = normalize(v_262.xyz);
  float3 tmpvar_264;
  float3 tmpvar_265;
  tmpvar_264 = v_262.xyz;
  tmpvar_265 = (((float3)normal_2.zxy * tmpvar_263.yzx) - ((float3)normal_2.yzx * tmpvar_263.zxy));
  float3 tmpvar_266;
  tmpvar_266 = float3(normal_2);
  float3x3 tmpvar_267;
  tmpvar_267[0].x = tmpvar_264.x;
  tmpvar_267[0].y = tmpvar_265.x;
  tmpvar_267[0].z = tmpvar_266.x;
  tmpvar_267[1].x = tmpvar_264.y;
  tmpvar_267[1].y = tmpvar_265.y;
  tmpvar_267[1].z = tmpvar_266.y;
  tmpvar_267[2].x = tmpvar_264.z;
  tmpvar_267[2].y = tmpvar_265.z;
  tmpvar_267[2].z = tmpvar_266.z;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_projection * (tmpvar_256 + tmpvar_257));
  _mtl_o.xlv_COLOR = tmpvar_9;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_10;
  _mtl_o.xlv_TEXCOORD1 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * ZYv_5)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD2 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XZv_4)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD3 = (float2(0.5, 0.5) + (0.6 * (
    (tmpvar_252 * XYv_3)
  .xy - tmpvar_256.xy)));
  _mtl_o.xlv_TEXCOORD4 = tmpvar_1;
  _mtl_o.xlv_TEXCOORD5 = tmpvar_11;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_12;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_267 * tmpvar_260));
  _mtl_o.xlv_TEXCOORD8 = normalize((tmpvar_267 * (float3)_mtl_u._WorldSpaceLightPos0.xyz));
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 43 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _WorldSpaceLightPos0;

uniform mat4 _Object2World;

uniform mat4 unity_MatrixV;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform sampler2D _MainTex;
uniform sampler2D _DetailTex;
uniform mat4 _PosRotation;
uniform float _DistFade;
uniform float _DistFadeVert;
uniform float _Rotation;
uniform float _MaxScale;
uniform vec4 _NoiseScale;
uniform vec3 _MaxTrans;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec4 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec2 tmpvar_1;
  tmpvar_1 = gl_MultiTexCoord0.xy;
  vec4 XYv_2;
  vec4 XZv_3;
  vec4 ZYv_4;
  vec4 localOrigin_5;
  vec4 planet_pos_6;
  vec4 origin_7;
  vec4 tmpvar_8;
  vec4 tmpvar_9;
  vec4 tmpvar_10;
  vec3 tmpvar_11;
  vec4 tmpvar_12;
  tmpvar_12 = (_Object2World * vec4(0.0, 0.0, 0.0, 1.0));
  origin_7 = tmpvar_12;
  vec4 tmpvar_13;
  tmpvar_13 = (_PosRotation * tmpvar_12);
  planet_pos_6 = tmpvar_13;
  vec3 tmpvar_14;
  tmpvar_14 = (_NoiseScale.z * tmpvar_13.xyz);
  float tmpvar_15;
  vec4 m_16;
  vec3 tmpvar_17;
  tmpvar_17 = floor((tmpvar_14 + dot (tmpvar_14, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_18;
  tmpvar_18 = ((tmpvar_14 - tmpvar_17) + dot (tmpvar_17, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_19;
  tmpvar_19.x = float((tmpvar_18.x >= tmpvar_18.y));
  tmpvar_19.y = float((tmpvar_18.y >= tmpvar_18.z));
  tmpvar_19.z = float((tmpvar_18.z >= tmpvar_18.x));
  vec3 tmpvar_20;
  tmpvar_20 = (1.0 - tmpvar_19);
  vec3 tmpvar_21;
  tmpvar_21 = min (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_22;
  tmpvar_22 = max (tmpvar_19, tmpvar_20.zxy);
  vec3 tmpvar_23;
  tmpvar_23 = ((tmpvar_18 - tmpvar_21) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_24;
  tmpvar_24 = ((tmpvar_18 - tmpvar_22) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_25;
  tmpvar_25 = (tmpvar_18 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_26;
  tmpvar_26 = (tmpvar_17 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_27;
  tmpvar_27 = (fract(abs(tmpvar_26)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_28;
  if ((tmpvar_26.x >= 0.0)) {
    tmpvar_28 = tmpvar_27.x;
  } else {
    tmpvar_28 = -(tmpvar_27.x);
  };
  float tmpvar_29;
  if ((tmpvar_26.y >= 0.0)) {
    tmpvar_29 = tmpvar_27.y;
  } else {
    tmpvar_29 = -(tmpvar_27.y);
  };
  float tmpvar_30;
  if ((tmpvar_26.z >= 0.0)) {
    tmpvar_30 = tmpvar_27.z;
  } else {
    tmpvar_30 = -(tmpvar_27.z);
  };
  vec4 tmpvar_31;
  tmpvar_31.xw = vec2(0.0, 1.0);
  tmpvar_31.y = tmpvar_21.z;
  tmpvar_31.z = tmpvar_22.z;
  vec4 x_32;
  x_32 = (tmpvar_30 + tmpvar_31);
  vec4 tmpvar_33;
  tmpvar_33 = (((
    (x_32 * x_32)
   * 34.0) + x_32) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_34;
  tmpvar_34 = (fract(abs(tmpvar_33)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_35;
  if ((tmpvar_33.x >= 0.0)) {
    tmpvar_35 = tmpvar_34.x;
  } else {
    tmpvar_35 = -(tmpvar_34.x);
  };
  float tmpvar_36;
  if ((tmpvar_33.y >= 0.0)) {
    tmpvar_36 = tmpvar_34.y;
  } else {
    tmpvar_36 = -(tmpvar_34.y);
  };
  float tmpvar_37;
  if ((tmpvar_33.z >= 0.0)) {
    tmpvar_37 = tmpvar_34.z;
  } else {
    tmpvar_37 = -(tmpvar_34.z);
  };
  float tmpvar_38;
  if ((tmpvar_33.w >= 0.0)) {
    tmpvar_38 = tmpvar_34.w;
  } else {
    tmpvar_38 = -(tmpvar_34.w);
  };
  vec4 tmpvar_39;
  tmpvar_39.x = tmpvar_35;
  tmpvar_39.y = tmpvar_36;
  tmpvar_39.z = tmpvar_37;
  tmpvar_39.w = tmpvar_38;
  vec4 tmpvar_40;
  tmpvar_40.xw = vec2(0.0, 1.0);
  tmpvar_40.y = tmpvar_21.y;
  tmpvar_40.z = tmpvar_22.y;
  vec4 x_41;
  x_41 = ((tmpvar_39 + tmpvar_29) + tmpvar_40);
  vec4 tmpvar_42;
  tmpvar_42 = (((
    (x_41 * x_41)
   * 34.0) + x_41) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_43;
  tmpvar_43 = (fract(abs(tmpvar_42)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_44;
  if ((tmpvar_42.x >= 0.0)) {
    tmpvar_44 = tmpvar_43.x;
  } else {
    tmpvar_44 = -(tmpvar_43.x);
  };
  float tmpvar_45;
  if ((tmpvar_42.y >= 0.0)) {
    tmpvar_45 = tmpvar_43.y;
  } else {
    tmpvar_45 = -(tmpvar_43.y);
  };
  float tmpvar_46;
  if ((tmpvar_42.z >= 0.0)) {
    tmpvar_46 = tmpvar_43.z;
  } else {
    tmpvar_46 = -(tmpvar_43.z);
  };
  float tmpvar_47;
  if ((tmpvar_42.w >= 0.0)) {
    tmpvar_47 = tmpvar_43.w;
  } else {
    tmpvar_47 = -(tmpvar_43.w);
  };
  vec4 tmpvar_48;
  tmpvar_48.x = tmpvar_44;
  tmpvar_48.y = tmpvar_45;
  tmpvar_48.z = tmpvar_46;
  tmpvar_48.w = tmpvar_47;
  vec4 tmpvar_49;
  tmpvar_49.xw = vec2(0.0, 1.0);
  tmpvar_49.y = tmpvar_21.x;
  tmpvar_49.z = tmpvar_22.x;
  vec4 x_50;
  x_50 = ((tmpvar_48 + tmpvar_28) + tmpvar_49);
  vec4 tmpvar_51;
  tmpvar_51 = (((
    (x_50 * x_50)
   * 34.0) + x_50) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_52;
  tmpvar_52 = (fract(abs(tmpvar_51)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_53;
  if ((tmpvar_51.x >= 0.0)) {
    tmpvar_53 = tmpvar_52.x;
  } else {
    tmpvar_53 = -(tmpvar_52.x);
  };
  float tmpvar_54;
  if ((tmpvar_51.y >= 0.0)) {
    tmpvar_54 = tmpvar_52.y;
  } else {
    tmpvar_54 = -(tmpvar_52.y);
  };
  float tmpvar_55;
  if ((tmpvar_51.z >= 0.0)) {
    tmpvar_55 = tmpvar_52.z;
  } else {
    tmpvar_55 = -(tmpvar_52.z);
  };
  float tmpvar_56;
  if ((tmpvar_51.w >= 0.0)) {
    tmpvar_56 = tmpvar_52.w;
  } else {
    tmpvar_56 = -(tmpvar_52.w);
  };
  vec4 tmpvar_57;
  tmpvar_57.x = tmpvar_53;
  tmpvar_57.y = tmpvar_54;
  tmpvar_57.z = tmpvar_55;
  tmpvar_57.w = tmpvar_56;
  vec4 tmpvar_58;
  tmpvar_58 = (tmpvar_57 - (49.0 * floor(
    (0.02040815 * tmpvar_57)
  )));
  vec4 tmpvar_59;
  tmpvar_59 = floor((tmpvar_58 * 0.1428571));
  vec4 tmpvar_60;
  tmpvar_60 = ((tmpvar_59 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_61;
  tmpvar_61 = ((floor(
    (tmpvar_58 - (7.0 * tmpvar_59))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_62;
  tmpvar_62 = ((1.0 - abs(tmpvar_60)) - abs(tmpvar_61));
  vec4 tmpvar_63;
  tmpvar_63.xy = tmpvar_60.xy;
  tmpvar_63.zw = tmpvar_61.xy;
  vec4 tmpvar_64;
  tmpvar_64.xy = tmpvar_60.zw;
  tmpvar_64.zw = tmpvar_61.zw;
  vec4 tmpvar_65;
  tmpvar_65 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_62)));
  vec4 tmpvar_66;
  tmpvar_66 = (tmpvar_63.xzyw + ((
    (floor(tmpvar_63) * 2.0)
   + 1.0).xzyw * tmpvar_65.xxyy));
  vec4 tmpvar_67;
  tmpvar_67 = (tmpvar_64.xzyw + ((
    (floor(tmpvar_64) * 2.0)
   + 1.0).xzyw * tmpvar_65.zzww));
  vec3 tmpvar_68;
  tmpvar_68.xy = tmpvar_66.xy;
  tmpvar_68.z = tmpvar_62.x;
  vec3 tmpvar_69;
  tmpvar_69.xy = tmpvar_66.zw;
  tmpvar_69.z = tmpvar_62.y;
  vec3 tmpvar_70;
  tmpvar_70.xy = tmpvar_67.xy;
  tmpvar_70.z = tmpvar_62.z;
  vec3 tmpvar_71;
  tmpvar_71.xy = tmpvar_67.zw;
  tmpvar_71.z = tmpvar_62.w;
  vec4 tmpvar_72;
  tmpvar_72.x = dot (tmpvar_68, tmpvar_68);
  tmpvar_72.y = dot (tmpvar_69, tmpvar_69);
  tmpvar_72.z = dot (tmpvar_70, tmpvar_70);
  tmpvar_72.w = dot (tmpvar_71, tmpvar_71);
  vec4 tmpvar_73;
  tmpvar_73 = (1.792843 - (0.8537347 * tmpvar_72));
  vec4 tmpvar_74;
  tmpvar_74.x = dot (tmpvar_18, tmpvar_18);
  tmpvar_74.y = dot (tmpvar_23, tmpvar_23);
  tmpvar_74.z = dot (tmpvar_24, tmpvar_24);
  tmpvar_74.w = dot (tmpvar_25, tmpvar_25);
  vec4 tmpvar_75;
  tmpvar_75 = max ((0.6 - tmpvar_74), vec4(0.0, 0.0, 0.0, 0.0));
  m_16 = (tmpvar_75 * tmpvar_75);
  vec4 tmpvar_76;
  tmpvar_76.x = dot ((tmpvar_68 * tmpvar_73.x), tmpvar_18);
  tmpvar_76.y = dot ((tmpvar_69 * tmpvar_73.y), tmpvar_23);
  tmpvar_76.z = dot ((tmpvar_70 * tmpvar_73.z), tmpvar_24);
  tmpvar_76.w = dot ((tmpvar_71 * tmpvar_73.w), tmpvar_25);
  tmpvar_15 = (42.0 * dot ((m_16 * m_16), tmpvar_76));
  float tmpvar_77;
  vec3 v_78;
  v_78 = (_NoiseScale.x * tmpvar_14);
  vec4 m_79;
  vec3 tmpvar_80;
  tmpvar_80 = floor((v_78 + dot (v_78, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_81;
  tmpvar_81 = ((v_78 - tmpvar_80) + dot (tmpvar_80, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_82;
  tmpvar_82.x = float((tmpvar_81.x >= tmpvar_81.y));
  tmpvar_82.y = float((tmpvar_81.y >= tmpvar_81.z));
  tmpvar_82.z = float((tmpvar_81.z >= tmpvar_81.x));
  vec3 tmpvar_83;
  tmpvar_83 = (1.0 - tmpvar_82);
  vec3 tmpvar_84;
  tmpvar_84 = min (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_85;
  tmpvar_85 = max (tmpvar_82, tmpvar_83.zxy);
  vec3 tmpvar_86;
  tmpvar_86 = ((tmpvar_81 - tmpvar_84) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_87;
  tmpvar_87 = ((tmpvar_81 - tmpvar_85) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_88;
  tmpvar_88 = (tmpvar_81 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_89;
  tmpvar_89 = (tmpvar_80 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_90;
  tmpvar_90 = (fract(abs(tmpvar_89)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_91;
  if ((tmpvar_89.x >= 0.0)) {
    tmpvar_91 = tmpvar_90.x;
  } else {
    tmpvar_91 = -(tmpvar_90.x);
  };
  float tmpvar_92;
  if ((tmpvar_89.y >= 0.0)) {
    tmpvar_92 = tmpvar_90.y;
  } else {
    tmpvar_92 = -(tmpvar_90.y);
  };
  float tmpvar_93;
  if ((tmpvar_89.z >= 0.0)) {
    tmpvar_93 = tmpvar_90.z;
  } else {
    tmpvar_93 = -(tmpvar_90.z);
  };
  vec4 tmpvar_94;
  tmpvar_94.xw = vec2(0.0, 1.0);
  tmpvar_94.y = tmpvar_84.z;
  tmpvar_94.z = tmpvar_85.z;
  vec4 x_95;
  x_95 = (tmpvar_93 + tmpvar_94);
  vec4 tmpvar_96;
  tmpvar_96 = (((
    (x_95 * x_95)
   * 34.0) + x_95) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_97;
  tmpvar_97 = (fract(abs(tmpvar_96)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_98;
  if ((tmpvar_96.x >= 0.0)) {
    tmpvar_98 = tmpvar_97.x;
  } else {
    tmpvar_98 = -(tmpvar_97.x);
  };
  float tmpvar_99;
  if ((tmpvar_96.y >= 0.0)) {
    tmpvar_99 = tmpvar_97.y;
  } else {
    tmpvar_99 = -(tmpvar_97.y);
  };
  float tmpvar_100;
  if ((tmpvar_96.z >= 0.0)) {
    tmpvar_100 = tmpvar_97.z;
  } else {
    tmpvar_100 = -(tmpvar_97.z);
  };
  float tmpvar_101;
  if ((tmpvar_96.w >= 0.0)) {
    tmpvar_101 = tmpvar_97.w;
  } else {
    tmpvar_101 = -(tmpvar_97.w);
  };
  vec4 tmpvar_102;
  tmpvar_102.x = tmpvar_98;
  tmpvar_102.y = tmpvar_99;
  tmpvar_102.z = tmpvar_100;
  tmpvar_102.w = tmpvar_101;
  vec4 tmpvar_103;
  tmpvar_103.xw = vec2(0.0, 1.0);
  tmpvar_103.y = tmpvar_84.y;
  tmpvar_103.z = tmpvar_85.y;
  vec4 x_104;
  x_104 = ((tmpvar_102 + tmpvar_92) + tmpvar_103);
  vec4 tmpvar_105;
  tmpvar_105 = (((
    (x_104 * x_104)
   * 34.0) + x_104) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_106;
  tmpvar_106 = (fract(abs(tmpvar_105)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_107;
  if ((tmpvar_105.x >= 0.0)) {
    tmpvar_107 = tmpvar_106.x;
  } else {
    tmpvar_107 = -(tmpvar_106.x);
  };
  float tmpvar_108;
  if ((tmpvar_105.y >= 0.0)) {
    tmpvar_108 = tmpvar_106.y;
  } else {
    tmpvar_108 = -(tmpvar_106.y);
  };
  float tmpvar_109;
  if ((tmpvar_105.z >= 0.0)) {
    tmpvar_109 = tmpvar_106.z;
  } else {
    tmpvar_109 = -(tmpvar_106.z);
  };
  float tmpvar_110;
  if ((tmpvar_105.w >= 0.0)) {
    tmpvar_110 = tmpvar_106.w;
  } else {
    tmpvar_110 = -(tmpvar_106.w);
  };
  vec4 tmpvar_111;
  tmpvar_111.x = tmpvar_107;
  tmpvar_111.y = tmpvar_108;
  tmpvar_111.z = tmpvar_109;
  tmpvar_111.w = tmpvar_110;
  vec4 tmpvar_112;
  tmpvar_112.xw = vec2(0.0, 1.0);
  tmpvar_112.y = tmpvar_84.x;
  tmpvar_112.z = tmpvar_85.x;
  vec4 x_113;
  x_113 = ((tmpvar_111 + tmpvar_91) + tmpvar_112);
  vec4 tmpvar_114;
  tmpvar_114 = (((
    (x_113 * x_113)
   * 34.0) + x_113) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_115;
  tmpvar_115 = (fract(abs(tmpvar_114)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_116;
  if ((tmpvar_114.x >= 0.0)) {
    tmpvar_116 = tmpvar_115.x;
  } else {
    tmpvar_116 = -(tmpvar_115.x);
  };
  float tmpvar_117;
  if ((tmpvar_114.y >= 0.0)) {
    tmpvar_117 = tmpvar_115.y;
  } else {
    tmpvar_117 = -(tmpvar_115.y);
  };
  float tmpvar_118;
  if ((tmpvar_114.z >= 0.0)) {
    tmpvar_118 = tmpvar_115.z;
  } else {
    tmpvar_118 = -(tmpvar_115.z);
  };
  float tmpvar_119;
  if ((tmpvar_114.w >= 0.0)) {
    tmpvar_119 = tmpvar_115.w;
  } else {
    tmpvar_119 = -(tmpvar_115.w);
  };
  vec4 tmpvar_120;
  tmpvar_120.x = tmpvar_116;
  tmpvar_120.y = tmpvar_117;
  tmpvar_120.z = tmpvar_118;
  tmpvar_120.w = tmpvar_119;
  vec4 tmpvar_121;
  tmpvar_121 = (tmpvar_120 - (49.0 * floor(
    (0.02040815 * tmpvar_120)
  )));
  vec4 tmpvar_122;
  tmpvar_122 = floor((tmpvar_121 * 0.1428571));
  vec4 tmpvar_123;
  tmpvar_123 = ((tmpvar_122 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_124;
  tmpvar_124 = ((floor(
    (tmpvar_121 - (7.0 * tmpvar_122))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_125;
  tmpvar_125 = ((1.0 - abs(tmpvar_123)) - abs(tmpvar_124));
  vec4 tmpvar_126;
  tmpvar_126.xy = tmpvar_123.xy;
  tmpvar_126.zw = tmpvar_124.xy;
  vec4 tmpvar_127;
  tmpvar_127.xy = tmpvar_123.zw;
  tmpvar_127.zw = tmpvar_124.zw;
  vec4 tmpvar_128;
  tmpvar_128 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_125)));
  vec4 tmpvar_129;
  tmpvar_129 = (tmpvar_126.xzyw + ((
    (floor(tmpvar_126) * 2.0)
   + 1.0).xzyw * tmpvar_128.xxyy));
  vec4 tmpvar_130;
  tmpvar_130 = (tmpvar_127.xzyw + ((
    (floor(tmpvar_127) * 2.0)
   + 1.0).xzyw * tmpvar_128.zzww));
  vec3 tmpvar_131;
  tmpvar_131.xy = tmpvar_129.xy;
  tmpvar_131.z = tmpvar_125.x;
  vec3 tmpvar_132;
  tmpvar_132.xy = tmpvar_129.zw;
  tmpvar_132.z = tmpvar_125.y;
  vec3 tmpvar_133;
  tmpvar_133.xy = tmpvar_130.xy;
  tmpvar_133.z = tmpvar_125.z;
  vec3 tmpvar_134;
  tmpvar_134.xy = tmpvar_130.zw;
  tmpvar_134.z = tmpvar_125.w;
  vec4 tmpvar_135;
  tmpvar_135.x = dot (tmpvar_131, tmpvar_131);
  tmpvar_135.y = dot (tmpvar_132, tmpvar_132);
  tmpvar_135.z = dot (tmpvar_133, tmpvar_133);
  tmpvar_135.w = dot (tmpvar_134, tmpvar_134);
  vec4 tmpvar_136;
  tmpvar_136 = (1.792843 - (0.8537347 * tmpvar_135));
  vec4 tmpvar_137;
  tmpvar_137.x = dot (tmpvar_81, tmpvar_81);
  tmpvar_137.y = dot (tmpvar_86, tmpvar_86);
  tmpvar_137.z = dot (tmpvar_87, tmpvar_87);
  tmpvar_137.w = dot (tmpvar_88, tmpvar_88);
  vec4 tmpvar_138;
  tmpvar_138 = max ((0.6 - tmpvar_137), vec4(0.0, 0.0, 0.0, 0.0));
  m_79 = (tmpvar_138 * tmpvar_138);
  vec4 tmpvar_139;
  tmpvar_139.x = dot ((tmpvar_131 * tmpvar_136.x), tmpvar_81);
  tmpvar_139.y = dot ((tmpvar_132 * tmpvar_136.y), tmpvar_86);
  tmpvar_139.z = dot ((tmpvar_133 * tmpvar_136.z), tmpvar_87);
  tmpvar_139.w = dot ((tmpvar_134 * tmpvar_136.w), tmpvar_88);
  tmpvar_77 = (42.0 * dot ((m_79 * m_79), tmpvar_139));
  vec3 v_140;
  v_140 = (_NoiseScale.y * tmpvar_14);
  vec4 m_141;
  vec3 tmpvar_142;
  tmpvar_142 = floor((v_140 + dot (v_140, vec3(0.3333333, 0.3333333, 0.3333333))));
  vec3 tmpvar_143;
  tmpvar_143 = ((v_140 - tmpvar_142) + dot (tmpvar_142, vec3(0.1666667, 0.1666667, 0.1666667)));
  vec3 tmpvar_144;
  tmpvar_144.x = float((tmpvar_143.x >= tmpvar_143.y));
  tmpvar_144.y = float((tmpvar_143.y >= tmpvar_143.z));
  tmpvar_144.z = float((tmpvar_143.z >= tmpvar_143.x));
  vec3 tmpvar_145;
  tmpvar_145 = (1.0 - tmpvar_144);
  vec3 tmpvar_146;
  tmpvar_146 = min (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_147;
  tmpvar_147 = max (tmpvar_144, tmpvar_145.zxy);
  vec3 tmpvar_148;
  tmpvar_148 = ((tmpvar_143 - tmpvar_146) + vec3(0.1666667, 0.1666667, 0.1666667));
  vec3 tmpvar_149;
  tmpvar_149 = ((tmpvar_143 - tmpvar_147) + vec3(0.3333333, 0.3333333, 0.3333333));
  vec3 tmpvar_150;
  tmpvar_150 = (tmpvar_143 - vec3(0.5, 0.5, 0.5));
  vec3 tmpvar_151;
  tmpvar_151 = (tmpvar_142 / vec3(289.0, 289.0, 289.0));
  vec3 tmpvar_152;
  tmpvar_152 = (fract(abs(tmpvar_151)) * vec3(289.0, 289.0, 289.0));
  float tmpvar_153;
  if ((tmpvar_151.x >= 0.0)) {
    tmpvar_153 = tmpvar_152.x;
  } else {
    tmpvar_153 = -(tmpvar_152.x);
  };
  float tmpvar_154;
  if ((tmpvar_151.y >= 0.0)) {
    tmpvar_154 = tmpvar_152.y;
  } else {
    tmpvar_154 = -(tmpvar_152.y);
  };
  float tmpvar_155;
  if ((tmpvar_151.z >= 0.0)) {
    tmpvar_155 = tmpvar_152.z;
  } else {
    tmpvar_155 = -(tmpvar_152.z);
  };
  vec4 tmpvar_156;
  tmpvar_156.xw = vec2(0.0, 1.0);
  tmpvar_156.y = tmpvar_146.z;
  tmpvar_156.z = tmpvar_147.z;
  vec4 x_157;
  x_157 = (tmpvar_155 + tmpvar_156);
  vec4 tmpvar_158;
  tmpvar_158 = (((
    (x_157 * x_157)
   * 34.0) + x_157) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_159;
  tmpvar_159 = (fract(abs(tmpvar_158)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_160;
  if ((tmpvar_158.x >= 0.0)) {
    tmpvar_160 = tmpvar_159.x;
  } else {
    tmpvar_160 = -(tmpvar_159.x);
  };
  float tmpvar_161;
  if ((tmpvar_158.y >= 0.0)) {
    tmpvar_161 = tmpvar_159.y;
  } else {
    tmpvar_161 = -(tmpvar_159.y);
  };
  float tmpvar_162;
  if ((tmpvar_158.z >= 0.0)) {
    tmpvar_162 = tmpvar_159.z;
  } else {
    tmpvar_162 = -(tmpvar_159.z);
  };
  float tmpvar_163;
  if ((tmpvar_158.w >= 0.0)) {
    tmpvar_163 = tmpvar_159.w;
  } else {
    tmpvar_163 = -(tmpvar_159.w);
  };
  vec4 tmpvar_164;
  tmpvar_164.x = tmpvar_160;
  tmpvar_164.y = tmpvar_161;
  tmpvar_164.z = tmpvar_162;
  tmpvar_164.w = tmpvar_163;
  vec4 tmpvar_165;
  tmpvar_165.xw = vec2(0.0, 1.0);
  tmpvar_165.y = tmpvar_146.y;
  tmpvar_165.z = tmpvar_147.y;
  vec4 x_166;
  x_166 = ((tmpvar_164 + tmpvar_154) + tmpvar_165);
  vec4 tmpvar_167;
  tmpvar_167 = (((
    (x_166 * x_166)
   * 34.0) + x_166) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_168;
  tmpvar_168 = (fract(abs(tmpvar_167)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_169;
  if ((tmpvar_167.x >= 0.0)) {
    tmpvar_169 = tmpvar_168.x;
  } else {
    tmpvar_169 = -(tmpvar_168.x);
  };
  float tmpvar_170;
  if ((tmpvar_167.y >= 0.0)) {
    tmpvar_170 = tmpvar_168.y;
  } else {
    tmpvar_170 = -(tmpvar_168.y);
  };
  float tmpvar_171;
  if ((tmpvar_167.z >= 0.0)) {
    tmpvar_171 = tmpvar_168.z;
  } else {
    tmpvar_171 = -(tmpvar_168.z);
  };
  float tmpvar_172;
  if ((tmpvar_167.w >= 0.0)) {
    tmpvar_172 = tmpvar_168.w;
  } else {
    tmpvar_172 = -(tmpvar_168.w);
  };
  vec4 tmpvar_173;
  tmpvar_173.x = tmpvar_169;
  tmpvar_173.y = tmpvar_170;
  tmpvar_173.z = tmpvar_171;
  tmpvar_173.w = tmpvar_172;
  vec4 tmpvar_174;
  tmpvar_174.xw = vec2(0.0, 1.0);
  tmpvar_174.y = tmpvar_146.x;
  tmpvar_174.z = tmpvar_147.x;
  vec4 x_175;
  x_175 = ((tmpvar_173 + tmpvar_153) + tmpvar_174);
  vec4 tmpvar_176;
  tmpvar_176 = (((
    (x_175 * x_175)
   * 34.0) + x_175) / vec4(289.0, 289.0, 289.0, 289.0));
  vec4 tmpvar_177;
  tmpvar_177 = (fract(abs(tmpvar_176)) * vec4(289.0, 289.0, 289.0, 289.0));
  float tmpvar_178;
  if ((tmpvar_176.x >= 0.0)) {
    tmpvar_178 = tmpvar_177.x;
  } else {
    tmpvar_178 = -(tmpvar_177.x);
  };
  float tmpvar_179;
  if ((tmpvar_176.y >= 0.0)) {
    tmpvar_179 = tmpvar_177.y;
  } else {
    tmpvar_179 = -(tmpvar_177.y);
  };
  float tmpvar_180;
  if ((tmpvar_176.z >= 0.0)) {
    tmpvar_180 = tmpvar_177.z;
  } else {
    tmpvar_180 = -(tmpvar_177.z);
  };
  float tmpvar_181;
  if ((tmpvar_176.w >= 0.0)) {
    tmpvar_181 = tmpvar_177.w;
  } else {
    tmpvar_181 = -(tmpvar_177.w);
  };
  vec4 tmpvar_182;
  tmpvar_182.x = tmpvar_178;
  tmpvar_182.y = tmpvar_179;
  tmpvar_182.z = tmpvar_180;
  tmpvar_182.w = tmpvar_181;
  vec4 tmpvar_183;
  tmpvar_183 = (tmpvar_182 - (49.0 * floor(
    (0.02040815 * tmpvar_182)
  )));
  vec4 tmpvar_184;
  tmpvar_184 = floor((tmpvar_183 * 0.1428571));
  vec4 tmpvar_185;
  tmpvar_185 = ((tmpvar_184 * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_186;
  tmpvar_186 = ((floor(
    (tmpvar_183 - (7.0 * tmpvar_184))
  ) * 0.2857142) + vec4(-0.9285715, -0.9285715, -0.9285715, -0.9285715));
  vec4 tmpvar_187;
  tmpvar_187 = ((1.0 - abs(tmpvar_185)) - abs(tmpvar_186));
  vec4 tmpvar_188;
  tmpvar_188.xy = tmpvar_185.xy;
  tmpvar_188.zw = tmpvar_186.xy;
  vec4 tmpvar_189;
  tmpvar_189.xy = tmpvar_185.zw;
  tmpvar_189.zw = tmpvar_186.zw;
  vec4 tmpvar_190;
  tmpvar_190 = -(vec4(greaterThanEqual (vec4(0.0, 0.0, 0.0, 0.0), tmpvar_187)));
  vec4 tmpvar_191;
  tmpvar_191 = (tmpvar_188.xzyw + ((
    (floor(tmpvar_188) * 2.0)
   + 1.0).xzyw * tmpvar_190.xxyy));
  vec4 tmpvar_192;
  tmpvar_192 = (tmpvar_189.xzyw + ((
    (floor(tmpvar_189) * 2.0)
   + 1.0).xzyw * tmpvar_190.zzww));
  vec3 tmpvar_193;
  tmpvar_193.xy = tmpvar_191.xy;
  tmpvar_193.z = tmpvar_187.x;
  vec3 tmpvar_194;
  tmpvar_194.xy = tmpvar_191.zw;
  tmpvar_194.z = tmpvar_187.y;
  vec3 tmpvar_195;
  tmpvar_195.xy = tmpvar_192.xy;
  tmpvar_195.z = tmpvar_187.z;
  vec3 tmpvar_196;
  tmpvar_196.xy = tmpvar_192.zw;
  tmpvar_196.z = tmpvar_187.w;
  vec4 tmpvar_197;
  tmpvar_197.x = dot (tmpvar_193, tmpvar_193);
  tmpvar_197.y = dot (tmpvar_194, tmpvar_194);
  tmpvar_197.z = dot (tmpvar_195, tmpvar_195);
  tmpvar_197.w = dot (tmpvar_196, tmpvar_196);
  vec4 tmpvar_198;
  tmpvar_198 = (1.792843 - (0.8537347 * tmpvar_197));
  vec4 tmpvar_199;
  tmpvar_199.x = dot (tmpvar_143, tmpvar_143);
  tmpvar_199.y = dot (tmpvar_148, tmpvar_148);
  tmpvar_199.z = dot (tmpvar_149, tmpvar_149);
  tmpvar_199.w = dot (tmpvar_150, tmpvar_150);
  vec4 tmpvar_200;
  tmpvar_200 = max ((0.6 - tmpvar_199), vec4(0.0, 0.0, 0.0, 0.0));
  m_141 = (tmpvar_200 * tmpvar_200);
  vec4 tmpvar_201;
  tmpvar_201.x = dot ((tmpvar_193 * tmpvar_198.x), tmpvar_143);
  tmpvar_201.y = dot ((tmpvar_194 * tmpvar_198.y), tmpvar_148);
  tmpvar_201.z = dot ((tmpvar_195 * tmpvar_198.z), tmpvar_149);
  tmpvar_201.w = dot ((tmpvar_196 * tmpvar_198.w), tmpvar_150);
  vec3 tmpvar_202;
  tmpvar_202.x = tmpvar_15;
  tmpvar_202.y = tmpvar_77;
  tmpvar_202.z = (42.0 * dot ((m_141 * m_141), tmpvar_201));
  vec3 tmpvar_203;
  tmpvar_203 = (0.5 * (tmpvar_202 + 1.0));
  localOrigin_5.xyz = (((2.0 * tmpvar_203) - 1.0) * _MaxTrans);
  localOrigin_5.w = 1.0;
  float tmpvar_204;
  tmpvar_204 = ((tmpvar_203.x * (_MaxScale - 1.0)) + 1.0);
  origin_7 = (_Object2World * localOrigin_5);
  planet_pos_6 = (_MainRotation * origin_7);
  vec3 tmpvar_205;
  tmpvar_205 = (_DetailRotation * planet_pos_6).xyz;
  tmpvar_11 = planet_pos_6.xyz;
  vec3 tmpvar_206;
  tmpvar_206 = normalize(planet_pos_6.xyz);
  vec2 uv_207;
  float tmpvar_208;
  float tmpvar_209;
  tmpvar_209 = (min (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0) / max (abs(
    (tmpvar_206.x / tmpvar_206.z)
  ), 1.0));
  float tmpvar_210;
  tmpvar_210 = (tmpvar_209 * tmpvar_209);
  tmpvar_210 = (((
    ((((
      ((((-0.01213232 * tmpvar_210) + 0.05368138) * tmpvar_210) - 0.1173503)
     * tmpvar_210) + 0.1938925) * tmpvar_210) - 0.3326756)
   * tmpvar_210) + 0.9999793) * tmpvar_209);
  tmpvar_210 = (tmpvar_210 + (float(
    (abs((tmpvar_206.x / tmpvar_206.z)) > 1.0)
  ) * (
    (tmpvar_210 * -2.0)
   + 1.570796)));
  tmpvar_208 = (tmpvar_210 * sign((tmpvar_206.x / tmpvar_206.z)));
  if ((abs(tmpvar_206.z) > (1e-08 * abs(tmpvar_206.x)))) {
    if ((tmpvar_206.z < 0.0)) {
      if ((tmpvar_206.x >= 0.0)) {
        tmpvar_208 += 3.141593;
      } else {
        tmpvar_208 = (tmpvar_208 - 3.141593);
      };
    };
  } else {
    tmpvar_208 = (sign(tmpvar_206.x) * 1.570796);
  };
  uv_207.x = (0.5 + (0.1591549 * tmpvar_208));
  uv_207.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_206.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_206.y)
    )) * (1.570796 + (
      abs(tmpvar_206.y)
     * 
      (-0.2146018 + (abs(tmpvar_206.y) * (0.08656672 + (
        abs(tmpvar_206.y)
       * -0.03102955))))
    ))))
  )));
  vec4 uv4_211;
  uv4_211.zw = vec2(0.0, 0.0);
  vec3 tmpvar_212;
  tmpvar_212 = normalize(tmpvar_205);
  vec3 tmpvar_213;
  tmpvar_213 = abs(tmpvar_212);
  float tmpvar_214;
  tmpvar_214 = float((tmpvar_213.z >= tmpvar_213.x));
  float tmpvar_215;
  tmpvar_215 = float((max (tmpvar_213.x, tmpvar_213.z) >= tmpvar_213.y));
  float tmpvar_216;
  tmpvar_216 = sign(mix (tmpvar_212.y, mix (tmpvar_212.x, tmpvar_212.z, tmpvar_214), tmpvar_215));
  vec3 tmpvar_217;
  tmpvar_217.xz = vec2(1.0, -1.0);
  tmpvar_217.y = -(tmpvar_216);
  vec3 tmpvar_218;
  tmpvar_218.xz = vec2(1.0, -1.0);
  tmpvar_218.y = tmpvar_216;
  vec3 tmpvar_219;
  tmpvar_219.xy = vec2(1.0, 1.0);
  tmpvar_219.z = tmpvar_216;
  vec3 tmpvar_220;
  tmpvar_220 = mix ((tmpvar_219 * tmpvar_212.yxz), mix ((tmpvar_217 * tmpvar_212.xzy), (tmpvar_218 * tmpvar_212.zxy), vec3(tmpvar_214)), vec3(tmpvar_215));
  uv4_211.xy = (((0.5 * tmpvar_220.yz) / abs(tmpvar_220.x)) + 0.5);
  tmpvar_8 = (texture2DLod (_MainTex, uv_207, 0.0) * texture2DLod (_DetailTex, uv4_211.xy, 0.0));
  vec4 tmpvar_221;
  tmpvar_221.w = 0.0;
  tmpvar_221.xyz = _WorldSpaceCameraPos;
  float tmpvar_222;
  vec4 tmpvar_223;
  tmpvar_223 = (origin_7 - tmpvar_221);
  tmpvar_222 = sqrt(dot (tmpvar_223, tmpvar_223));
  tmpvar_9.w = (clamp ((_DistFade * tmpvar_222), 0.0, 1.0) * clamp ((1.0 - 
    (_DistFadeVert * tmpvar_222)
  ), 0.0, 1.0));
  tmpvar_8.w = (tmpvar_8.w * tmpvar_9.w);
  vec3 tmpvar_224;
  tmpvar_224.yz = vec2(0.0, 0.0);
  tmpvar_224.x = fract(_Rotation);
  vec3 x_225;
  x_225 = (tmpvar_224 + tmpvar_203);
  vec3 trans_226;
  trans_226 = localOrigin_5.xyz;
  float tmpvar_227;
  tmpvar_227 = (x_225.x * 6.283185);
  float tmpvar_228;
  tmpvar_228 = (x_225.y * 6.283185);
  float tmpvar_229;
  tmpvar_229 = (x_225.z * 2.0);
  float tmpvar_230;
  tmpvar_230 = sqrt(tmpvar_229);
  float tmpvar_231;
  tmpvar_231 = (sin(tmpvar_228) * tmpvar_230);
  float tmpvar_232;
  tmpvar_232 = (cos(tmpvar_228) * tmpvar_230);
  float tmpvar_233;
  tmpvar_233 = sqrt((2.0 - tmpvar_229));
  float tmpvar_234;
  tmpvar_234 = sin(tmpvar_227);
  float tmpvar_235;
  tmpvar_235 = cos(tmpvar_227);
  float tmpvar_236;
  tmpvar_236 = ((tmpvar_231 * tmpvar_235) - (tmpvar_232 * tmpvar_234));
  float tmpvar_237;
  tmpvar_237 = ((tmpvar_231 * tmpvar_234) + (tmpvar_232 * tmpvar_235));
  mat4 tmpvar_238;
  tmpvar_238[0].x = (tmpvar_204 * ((tmpvar_231 * tmpvar_236) - tmpvar_235));
  tmpvar_238[0].y = ((tmpvar_231 * tmpvar_237) - tmpvar_234);
  tmpvar_238[0].z = (tmpvar_231 * tmpvar_233);
  tmpvar_238[0].w = 0.0;
  tmpvar_238[1].x = ((tmpvar_232 * tmpvar_236) + tmpvar_234);
  tmpvar_238[1].y = (tmpvar_204 * ((tmpvar_232 * tmpvar_237) - tmpvar_235));
  tmpvar_238[1].z = (tmpvar_232 * tmpvar_233);
  tmpvar_238[1].w = 0.0;
  tmpvar_238[2].x = (tmpvar_233 * tmpvar_236);
  tmpvar_238[2].y = (tmpvar_233 * tmpvar_237);
  tmpvar_238[2].z = (tmpvar_204 * (1.0 - tmpvar_229));
  tmpvar_238[2].w = 0.0;
  tmpvar_238[3].x = trans_226.x;
  tmpvar_238[3].y = trans_226.y;
  tmpvar_238[3].z = trans_226.z;
  tmpvar_238[3].w = 1.0;
  mat4 tmpvar_239;
  tmpvar_239 = ((unity_MatrixV * _Object2World) * tmpvar_238);
  vec4 v_240;
  v_240.x = tmpvar_239[0].z;
  v_240.y = tmpvar_239[1].z;
  v_240.z = tmpvar_239[2].z;
  v_240.w = tmpvar_239[3].z;
  vec3 tmpvar_241;
  tmpvar_241 = normalize(v_240.xyz);
  tmpvar_9.xyz = abs(tmpvar_241);
  vec4 tmpvar_242;
  tmpvar_242 = (gl_ModelViewMatrix * localOrigin_5);
  vec4 tmpvar_243;
  tmpvar_243.xyz = (gl_Vertex.xyz * tmpvar_204);
  tmpvar_243.w = gl_Vertex.w;
  vec2 tmpvar_244;
  tmpvar_244 = ((2.0 * gl_MultiTexCoord0.xy) - 1.0);
  vec4 tmpvar_245;
  tmpvar_245.z = 0.0;
  tmpvar_245.xy = tmpvar_244;
  tmpvar_245.w = gl_Vertex.w;
  ZYv_4.xyw = tmpvar_245.zyw;
  XZv_3.yzw = tmpvar_245.zyw;
  XYv_2.yzw = tmpvar_245.yzw;
  ZYv_4.z = (tmpvar_244.x * sign(-(tmpvar_241.x)));
  XZv_3.x = (tmpvar_244.x * sign(-(tmpvar_241.y)));
  XYv_2.x = (tmpvar_244.x * sign(tmpvar_241.z));
  ZYv_4.x = ((sign(
    -(tmpvar_241.x)
  ) * sign(ZYv_4.z)) * tmpvar_241.z);
  XZv_3.y = ((sign(
    -(tmpvar_241.y)
  ) * sign(XZv_3.x)) * tmpvar_241.x);
  XYv_2.z = ((sign(
    -(tmpvar_241.z)
  ) * sign(XYv_2.x)) * tmpvar_241.x);
  ZYv_4.x = (ZYv_4.x + ((
    sign(-(tmpvar_241.x))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  XZv_3.y = (XZv_3.y + ((
    sign(-(tmpvar_241.y))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.z));
  XYv_2.z = (XYv_2.z + ((
    sign(-(tmpvar_241.z))
   * 
    sign(tmpvar_244.y)
  ) * tmpvar_241.y));
  vec3 tmpvar_246;
  tmpvar_246 = normalize((origin_7.xyz - _WorldSpaceCameraPos));
  vec3 tmpvar_247;
  tmpvar_247 = normalize(-(tmpvar_246));
  vec4 v_248;
  v_248.x = unity_MatrixV[0].x;
  v_248.y = unity_MatrixV[1].x;
  v_248.z = unity_MatrixV[2].x;
  v_248.w = unity_MatrixV[3].x;
  vec3 tmpvar_249;
  tmpvar_249 = normalize(v_248.xyz);
  vec3 tmpvar_250;
  vec3 tmpvar_251;
  tmpvar_250 = v_248.xyz;
  tmpvar_251 = ((tmpvar_247.zxy * tmpvar_249.yzx) - (tmpvar_247.yzx * tmpvar_249.zxy));
  mat3 tmpvar_252;
  tmpvar_252[0].x = tmpvar_250.x;
  tmpvar_252[0].y = tmpvar_251.x;
  tmpvar_252[0].z = tmpvar_247.x;
  tmpvar_252[1].x = tmpvar_250.y;
  tmpvar_252[1].y = tmpvar_251.y;
  tmpvar_252[1].z = tmpvar_247.y;
  tmpvar_252[2].x = tmpvar_250.z;
  tmpvar_252[2].y = tmpvar_251.z;
  tmpvar_252[2].z = tmpvar_247.z;
  gl_Position = (gl_ProjectionMatrix * (tmpvar_242 + tmpvar_243));
  xlv_COLOR = tmpvar_8;
  xlv_TEXCOORD0 = tmpvar_9;
  xlv_TEXCOORD1 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * ZYv_4)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD2 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XZv_3)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD3 = (vec2(0.5, 0.5) + (0.6 * (
    (tmpvar_239 * XYv_2)
  .xy - tmpvar_242.xy)));
  xlv_TEXCOORD4 = tmpvar_1;
  xlv_TEXCOORD5 = tmpvar_10;
  xlv_TEXCOORD6 = tmpvar_11;
  xlv_TEXCOORD7 = normalize((tmpvar_252 * tmpvar_246));
  xlv_TEXCOORD8 = normalize((tmpvar_252 * _WorldSpaceLightPos0.xyz));
}


#endif
#ifdef FRAGMENT
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _Tex;
uniform vec4 _Color;
uniform float _MinScatter;
uniform float _Opacity;
varying vec4 xlv_COLOR;
varying vec4 xlv_TEXCOORD0;
varying vec2 xlv_TEXCOORD1;
varying vec2 xlv_TEXCOORD2;
varying vec2 xlv_TEXCOORD3;
varying vec2 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD7;
varying vec3 xlv_TEXCOORD8;
void main ()
{
  vec3 normT_1;
  vec4 color_2;
  vec4 tex_3;
  tex_3.x = texture2D (_Tex, xlv_TEXCOORD1).x;
  tex_3.y = texture2D (_Tex, xlv_TEXCOORD2).y;
  tex_3.z = texture2D (_Tex, xlv_TEXCOORD3).z;
  tex_3.w = 0.0;
  tex_3.xyz = (tex_3.xyz * xlv_TEXCOORD0.xyz);
  tex_3 = (tex_3 / ((xlv_TEXCOORD0.x + xlv_TEXCOORD0.y) + xlv_TEXCOORD0.z));
  float tmpvar_4;
  tmpvar_4 = ((tex_3.x + tex_3.y) + (tex_3.z + tex_3.w));
  vec4 tmpvar_5;
  tmpvar_5.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_5.w = tmpvar_4;
  tex_3.xyz = tmpvar_5.xyz;
  vec4 tmpvar_6;
  tmpvar_6.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_6.w = ((alphaMask1.x + alphaMask1.y) + (alphaMask1.z + alphaMask1.w));
  color_2 = (tmpvar_6 * (_Color * xlv_COLOR));
  normT_1.xy = ((2.0 * xlv_TEXCOORD4) - 1.0);
  normT_1.z = sqrt((1.0 - clamp (
    dot (normT_1.xy, normT_1.xy)
  , 0.0, 1.0)));
  color_2.w = (color_2.w * tmpvar_4);
  tex_3.w = (xlv_TEXCOORD0.w * tmpvar_4);
  vec4 c_7;
  vec3 tmpvar_8;
  tmpvar_8 = normalize(xlv_TEXCOORD8);
  vec3 tmpvar_9;
  tmpvar_9 = normalize(xlv_TEXCOORD7);
  vec3 tmpvar_10;
  tmpvar_10 = normalize(normT_1);
  float tmpvar_11;
  tmpvar_11 = max (dot (tmpvar_10, tmpvar_8), 0.0);
  c_7.xyz = ((_LightColor0.xyz * (vec3(tmpvar_11) + 
    clamp ((((_MinScatter - 
      (_Opacity * tex_3.w)
    ) * (1.0 - 
      dot (tmpvar_10, tmpvar_9)
    )) * (0.5 + (0.5 * 
      dot (tmpvar_9, tmpvar_8)
    ))), 0.0, 1.0)
  )) * 2.0);
  c_7.w = (tmpvar_11 * 2.0);
  color_2.xyz = (color_2.xyz * c_7.xyz);
  gl_FragData[0] = color_2;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 666 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "SOFT_DEPTH_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "texcoord" TexCoord0
Matrix 19 [_DetailRotation] 3
Matrix 12 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 22 [_PosRotation] 3
Matrix 0 [glstate_matrix_modelview0]
Matrix 8 [glstate_matrix_projection]
Matrix 16 [unity_MatrixV] 3
Float 27 [_DistFade]
Float 28 [_DistFadeVert]
Float 30 [_MaxScale]
Vector 32 [_MaxTrans]
Vector 31 [_NoiseScale]
Float 29 [_Rotation]
Vector 25 [_WorldSpaceCameraPos]
Vector 26 [_WorldSpaceLightPos0]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
"vs_3_0
def c33, 0.333333343, 0.166666672, 1, -0.5
def c34, 34, 5.89795971, 49, 0.142857149
def c35, 0.00346020772, 289, 0, 1
def c36, 7, 0.285714298, -0.928571403, 0.600000024
def c37, 2, 1, 0.853734732, 1.79284286
def c38, -2, 3.14159274, 1, -1
def c39, 42, 0.0208350997, -0.0851330012, 0.180141002
def c40, -0.330299497, 0.999866009, -2, 1.57079637
def c41, -0.0187292993, 0.0742610022, 1.57072878, 0.318309873
def c42, -3.14159274, 0.159154937, 0.5, -0.212114394
def c43, 6.28318548, -3.14159274, 0.600000024, 0.5
dcl_position v0
dcl_texcoord v1
dcl_2d s0
dcl_2d s1
dcl_position o0
dcl_color o1
dcl_texcoord o2
dcl_texcoord1 o3.xy
dcl_texcoord2 o4.xy
dcl_texcoord3 o5.xy
dcl_texcoord4 o6.xy
dcl_texcoord5 o7
dcl_texcoord6 o8.xyz
dcl_texcoord7 o9.xyz
dcl_texcoord8 o10.xyz
mov r0.x, c4.w
mov r0.y, c5.w
mov r0.z, c6.w
mov r0.w, c7.w
dp4 r1.x, c22, r0
dp4 r1.y, c23, r0
dp4 r1.z, c24, r0
mul r0.xyz, r1, c31.z
dp3 r0.w, r0, c33.x
mad r2.xyz, c31.z, r1, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mad r1.xyz, c31.z, r1, -r2
dp3 r0.w, r2, c33.y
add r1.xyz, r0.w, r1
sge r2.xyz, r1, r1.yzxw
add r3.xyz, -r2.zxyw, c33.z
min r4.xyz, r2, r3
max r2.xyz, r2, r3
mad r3.xyw, r4.z, c35.zwzz, c35.zzzw
mov r3.z, r2.z
mad r3, r5.z, c35.y, r3
mul r5.xy, r5, c35.y
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.y
mad r6.xyw, r4.zyzz, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r3, r3, r6
mul r6, r3, r3
mad r3, r6, c34.x, r3
mul r3, r3, c35.x
frc r6, r3_abs
sge r3, r3, -r3
lrp r7, r3, r6, -r6
mad r3, r7, c35.y, r5.x
mad r5.xyw, r4.zxzz, c35.zwzz, c35.zzzw
add r4.xyz, r1, -r4
add r4.xyz, r4, c33.y
mov r5.z, r2.x
add r2.xyz, r1, -r2
add r2.xyz, r2, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r6, r3, r5, -r5
mul r3, r6, c34.y
mul r5, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r5
frc r5, r5
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r5.xz, r6.yyww
add r7, r5, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r5, r7.zwxy, -r9.yyxx, r5.zwxy
mov r7.xy, r5.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r5.z, r8.y
dp3 r10.y, r5, r5
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r5.xyz, r5, r6.y
dp3 r5.y, r5, r4
dp3 r4.y, r4, r4
mul r3.xyz, r3, r6.z
dp3 r5.z, r3, r2
dp3 r4.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r5.x, r2, r1
add r2.xyz, r1, c33.w
dp3 r4.x, r1, r1
dp3 r5.w, r3, r2
dp3 r4.w, r2, r2
add r1, -r4, c36.w
max r1, r1, c35.z
mul r1, r1, r1
mul r1, r1, r1
dp4 r0.w, r1, r5
mul r1.x, r0.w, c39.x
mul r2.xyz, r0, c31.x
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.x, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r4.xyz, c31.x, r0, -r2
dp3 r0.w, r2, c33.y
add r2.xyz, r0.w, r4
sge r4.xyz, r2, r2.yzxw
add r5.xyw, -r4.zxzy, c33.z
min r6.xyz, r4, r5.xyww
max r4.xyz, r4, r5.xyww
mad r7.xyw, r6.z, c35.zwzz, c35.zzzw
mov r7.z, r4.z
mad r5, r5.z, c35.y, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r5, r8, c35.y, r3.y
mad r7.xyw, r6.zyzz, c35.zwzz, c35.zzzw
mov r7.z, r4.y
add r5, r5, r7
mul r7, r5, r5
mad r5, r7, c34.x, r5
mul r5, r5, c35.x
frc r7, r5_abs
sge r5, r5, -r5
lrp r8, r5, r7, -r7
mad r3, r8, c35.y, r3.x
mad r5.xyw, r6.zxzz, c35.zwzz, c35.zzzw
add r6.xyz, r2, -r6
add r6.xyz, r6, c33.y
mov r5.z, r4.x
add r4.xyz, r2, -r4
add r4.xyz, r4, c33.x
add r3, r3, r5
mul r5, r3, r3
mad r3, r5, c34.x, r3
mul r3, r3, c35.x
frc r5, r3_abs
sge r3, r3, -r3
lrp r7, r3, r5, -r5
mul r3, r7, c34.y
mul r5, r7, c35.y
frc r7, r3
add r3, r3, -r7
mad r3, r3, -c34.z, r5
frc r5, r5
mul r7, r3, c34.w
frc r8, r7
add r7, r7, -r8
mad r3, r7, -c36.x, r3
mad r7, r7.zxwy, c36.y, c36.z
add r3, -r5, r3
mad r3, r3, c36.y, c36.z
mov r5.yw, r3.xxzy
frc r8.yw, r3.xxzy
frc r8.xz, r7.yyww
mov r5.xz, r7.yyww
add r8, r5, -r8
mad r8, r8, c37.x, c37.y
add r9, -r7_abs.ywxz, c33.z
add r9, -r3_abs.xywz, r9.xywz
sge r10, c35.z, r9.xywz
mad r5, r8.zwxy, -r10.yyxx, r5.zwxy
mov r8.xy, r5.zwzw
mov r8.z, r9.x
dp3 r11.x, r8, r8
mov r5.z, r9.y
dp3 r11.y, r5, r5
frc r12.yw, r3.xzzw
mov r7.yw, r3.xzzw
frc r12.xz, r7
add r3, -r12, r7
mad r3, r3, c37.x, c37.y
mad r3, r3, -r10.zzww, r7
mov r9.xy, r3.zwzw
mov r3.z, r9.w
dp3 r11.z, r3, r3
dp3 r11.w, r9, r9
mad r7, r11, -c37.z, c37.w
mul r5.xyz, r5, r7.y
dp3 r5.y, r5, r6
dp3 r6.y, r6, r6
mul r3.xyz, r3, r7.z
dp3 r5.z, r3, r4
dp3 r6.z, r4, r4
mul r3.xyz, r7.x, r8
mul r4.xyz, r7.w, r9
dp3 r5.x, r3, r2
add r3.xyz, r2, c33.w
dp3 r6.x, r2, r2
dp3 r5.w, r4, r3
dp3 r6.w, r3, r3
add r2, -r6, c36.w
max r2, r2, c35.z
mul r2, r2, r2
mul r2, r2, r2
dp4 r0.w, r2, r5
mul r1.y, r0.w, c39.x
mul r2.xyz, r0, c31.y
dp3 r0.w, r2, c33.x
mad r2.xyz, c31.y, r0, r0.w
frc r3.xyz, r2
add r2.xyz, r2, -r3
mul r3.xyz, r2, c35.x
frc r4.xyz, r3_abs
sge r3.xyz, r3, -r3
lrp r5.xyz, r3, r4, -r4
mul r3.xy, r5, c35.y
mad r0.xyz, c31.y, r0, -r2
dp3 r0.w, r2, c33.y
add r0.xyz, r0.w, r0
sge r2.xyz, r0, r0.yzxw
add r4.xyz, -r2.zxyw, c33.z
min r5.xyw, r2.xyzz, r4.xyzz
max r2.xyz, r2, r4
mad r4.xyw, r5.w, c35.zwzz, c35.zzzw
mov r4.z, r2.z
mad r4, r5.z, c35.y, r4
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r4, r7, c35.y, r3.y
mad r6.xyw, r5.wyzw, c35.zwzz, c35.zzzw
mov r6.z, r2.y
add r4, r4, r6
mul r6, r4, r4
mad r4, r6, c34.x, r4
mul r4, r4, c35.x
frc r6, r4_abs
sge r4, r4, -r4
lrp r7, r4, r6, -r6
mad r3, r7, c35.y, r3.x
mad r4.xyw, r5.wxzw, c35.zwzz, c35.zzzw
add r5.xyz, r0, -r5.xyww
add r5.xyz, r5, c33.y
mov r4.z, r2.x
add r2.xyz, r0, -r2
add r2.xyz, r2, c33.x
add r3, r3, r4
mul r4, r3, r3
mad r3, r4, c34.x, r3
mul r3, r3, c35.x
frc r4, r3_abs
sge r3, r3, -r3
lrp r6, r3, r4, -r4
mul r3, r6, c34.y
mul r4, r6, c35.y
frc r6, r3
add r3, r3, -r6
mad r3, r3, -c34.z, r4
frc r4, r4
mul r6, r3, c34.w
frc r7, r6
add r6, r6, -r7
mad r3, r6, -c36.x, r3
mad r6, r6.zxwy, c36.y, c36.z
add r3, -r4, r3
mad r3, r3, c36.y, c36.z
mov r4.yw, r3.xxzy
frc r7.yw, r3.xxzy
frc r7.xz, r6.yyww
mov r4.xz, r6.yyww
add r7, r4, -r7
mad r7, r7, c37.x, c37.y
add r8, -r6_abs.ywxz, c33.z
add r8, -r3_abs.xywz, r8.xywz
sge r9, c35.z, r8.xywz
mad r4, r7.zwxy, -r9.yyxx, r4.zwxy
mov r7.xy, r4.zwzw
mov r7.z, r8.x
dp3 r10.x, r7, r7
mov r4.z, r8.y
dp3 r10.y, r4, r4
frc r11.yw, r3.xzzw
mov r6.yw, r3.xzzw
frc r11.xz, r6
add r3, -r11, r6
mad r3, r3, c37.x, c37.y
mad r3, r3, -r9.zzww, r6
mov r8.xy, r3.zwzw
mov r3.z, r8.w
dp3 r10.z, r3, r3
dp3 r10.w, r8, r8
mad r6, r10, -c37.z, c37.w
mul r4.xyz, r4, r6.y
dp3 r4.y, r4, r5
dp3 r5.y, r5, r5
mul r3.xyz, r3, r6.z
dp3 r4.z, r3, r2
dp3 r5.z, r2, r2
mul r2.xyz, r6.x, r7
mul r3.xyz, r6.w, r8
dp3 r4.x, r2, r0
add r2.xyz, r0, c33.w
dp3 r5.x, r0, r0
dp3 r4.w, r3, r2
dp3 r5.w, r2, r2
add r0, -r5, c36.w
max r0, r0, c35.z
mul r0, r0, r0
mul r0, r0, r0
dp4 r0.x, r0, r4
mul r1.z, r0.x, c39.x
mul r0.xyz, r1, c32
add r1.xyz, r1, c33.z
mov r0.w, c33.z
dp4 r2.w, c7, r0
dp4 r2.x, c4, r0
dp4 r2.y, c5, r0
dp4 r2.z, c6, r0
dp4 r3.w, c15, r2
dp4 r3.x, c12, r2
dp4 r3.y, c13, r2
dp4 r3.z, c14, r2
add r2.xyz, r2, -c25
dp4 r4.y, c19, r3
dp4 r4.x, c20, r3
dp4 r4.z, c21, r3
dp3 r1.w, r4, r4
rsq r1.w, r1.w
mul r5.xyz, r1.w, r4
mad r2.w, r4.z, r1.w, -r5.y
sge r3.w, r5_abs.z, r5_abs.y
mad r2.w, r3.w, r2.w, r5.y
mad r1.w, r4.x, -r1.w, r2.w
max r2.w, r5_abs.z, r5_abs.y
sge r2.w, r2.w, r5_abs.x
mad r1.w, r2.w, r1.w, r5.x
slt r4.x, -r1.w, r1.w
slt r1.w, r1.w, -r1.w
add r4.y, -r1.w, r4.x
mov r6.y, -r4.y
mov r6.xz, c38.zyww
mul r6.xyz, r5.yzxw, r6
mov r4.xz, c38.zyww
mad r7.xyz, r4, r5.zyxw, -r6
mad r6.xyz, r3.w, r7, r6
mad r6.xyz, r4.xxyw, -r5, r6
mul r4.xyz, r5, r4.xxyw
mad r4.xyz, r2.w, r6, r4
mul r4.yz, r4, -c33.w
rcp r1.w, r4_abs.x
mad r4.xy, r4.yzzw, r1.w, -c33.w
mov r4.zw, c35.z
texldl r4, r4, 