// Compiled shader for all platforms, uncompressed size: 1119.6KB

// Skipping shader variants that would not be included into build of current scene.

Shader "EVE/CloudShadow" {
Properties {
 _Color ("Color Tint", Color) = (1,1,1,1)
 _MainTex ("Main (RGB)", 2D) = "white" { }
 _DetailTex ("Detail (RGB)", 2D) = "white" { }
 _UVNoiseTex ("UV Noise (RG)", 2D) = "black" { }
 _DetailScale ("Detail Scale", Float) = 100
 _DetailDist ("Detail Distance", Range(0,1)) = 0.00875
 _UVNoiseScale ("UV Noise Scale", Range(0,0.1)) = 0.01
 _UVNoiseStrength ("UV Noise Strength", Range(0,0.1)) = 0.002
 _UVNoiseAnimation ("UV Noise Animation", Vector) = (0.002,0.001,0,1)
 _PlanetOrigin ("Sphere Center", Vector) = (0,0,0,1)
 _SunDir ("Sunlight direction", Vector) = (0,0,0,1)
 _Radius ("Radius", Float) = 1
 _PlanetRadius ("Planet Radius", Float) = 1
 _ShadowFactor ("Shadow Factor", Float) = 1
}
SubShader { 


 // Stats for Vertex shader:
 //       d3d11 : 48 avg math (48..49)
 //        d3d9 : 52 avg math (51..53)
 //        gles : 103 avg math (66..138), 4 avg texture (3..8), 3 avg branch (2..5)
 //       metal : 43 math
 //      opengl : 103 avg math (66..138), 4 avg texture (3..8), 3 avg branch (2..5)
 // Stats for Fragment shader:
 //       d3d11 : 94 avg math (62..111), 1 avg texture (1..2)
 //        d3d9 : 92 avg math (63..109), 11 avg texture (5..22)
 //       metal : 103 avg math (66..138), 4 avg texture (3..8), 3 avg branch (2..5)
 Pass {
  ZWrite Off
  Blend Zero SrcColor
  GpuProgramID 23044
Program "vp" {
SubProgram "opengl " {
// Stats: 128 math, 3 textures, 5 branches
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform sampler2D _MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec2 uv_5;
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = (min (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0) / max (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0));
  float tmpvar_8;
  tmpvar_8 = (tmpvar_7 * tmpvar_7);
  tmpvar_8 = (((
    ((((
      ((((-0.01213232 * tmpvar_8) + 0.05368138) * tmpvar_8) - 0.1173503)
     * tmpvar_8) + 0.1938925) * tmpvar_8) - 0.3326756)
   * tmpvar_8) + 0.9999793) * tmpvar_7);
  tmpvar_8 = (tmpvar_8 + (float(
    (abs((tmpvar_4.x / tmpvar_4.z)) > 1.0)
  ) * (
    (tmpvar_8 * -2.0)
   + 1.570796)));
  tmpvar_6 = (tmpvar_8 * sign((tmpvar_4.x / tmpvar_4.z)));
  if ((abs(tmpvar_4.z) > (1e-08 * abs(tmpvar_4.x)))) {
    if ((tmpvar_4.z < 0.0)) {
      if ((tmpvar_4.x >= 0.0)) {
        tmpvar_6 += 3.141593;
      } else {
        tmpvar_6 = (tmpvar_6 - 3.141593);
      };
    };
  } else {
    tmpvar_6 = (sign(tmpvar_4.x) * 1.570796);
  };
  uv_5.x = (0.5 + (0.1591549 * tmpvar_6));
  uv_5.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_4.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_4.y)
    )) * (1.570796 + (
      abs(tmpvar_4.y)
     * 
      (-0.2146018 + (abs(tmpvar_4.y) * (0.08656672 + (
        abs(tmpvar_4.y)
       * -0.03102955))))
    ))))
  )));
  uv_3 = uv_5;
  vec2 tmpvar_9;
  tmpvar_9 = (uv_5 / vec2(_UVNoiseScale));
  vec2 tmpvar_10;
  tmpvar_10 = (fract(abs(tmpvar_9)) * vec2(_UVNoiseScale));
  float tmpvar_11;
  if ((tmpvar_9.x >= 0.0)) {
    tmpvar_11 = tmpvar_10.x;
  } else {
    tmpvar_11 = -(tmpvar_10.x);
  };
  float tmpvar_12;
  if ((tmpvar_9.y >= 0.0)) {
    tmpvar_12 = tmpvar_10.y;
  } else {
    tmpvar_12 = -(tmpvar_10.y);
  };
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_11;
  tmpvar_13.y = tmpvar_12;
  uv_3 = (uv_5 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_13 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_14;
  uvCont_14.y = uv_3.y;
  uvCont_14.x = abs((uv_3.x - 0.5));
  vec4 tmpvar_15;
  tmpvar_15.xy = dFdx(uvCont_14);
  tmpvar_15.zw = dFdy(uvCont_14);
  vec2 uv_16;
  vec3 tmpvar_17;
  tmpvar_17 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_18;
  tmpvar_18 = abs(tmpvar_17);
  float tmpvar_19;
  tmpvar_19 = float((tmpvar_18.z >= tmpvar_18.x));
  float tmpvar_20;
  tmpvar_20 = float((max (tmpvar_18.x, tmpvar_18.z) >= tmpvar_18.y));
  float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_17.y, mix (tmpvar_17.x, tmpvar_17.z, tmpvar_19), tmpvar_20));
  vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(tmpvar_21);
  vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = tmpvar_21;
  vec3 tmpvar_24;
  tmpvar_24.xy = vec2(1.0, 1.0);
  tmpvar_24.z = tmpvar_21;
  vec3 tmpvar_25;
  tmpvar_25 = mix ((tmpvar_24 * tmpvar_17.yxz), mix ((tmpvar_22 * tmpvar_17.xzy), (tmpvar_23 * tmpvar_17.zxy), vec3(tmpvar_19)), vec3(tmpvar_20));
  uv_16 = (((
    (0.5 * tmpvar_25.yz)
   / 
    abs(tmpvar_25.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_26;
  vec2 tmpvar_27;
  tmpvar_27 = abs((uv_16 - (0.5 * _DetailScale)));
  uvCont_26.x = max (tmpvar_27.x, tmpvar_27.y);
  uvCont_26.y = min (tmpvar_27.x, tmpvar_27.y);
  vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_26);
  tmpvar_28.zw = dFdy(uvCont_26);
  vec3 tmpvar_29;
  tmpvar_29 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_30;
  tmpvar_30 = ((_Color * texture2DGradARB (_MainTex, uv_3, tmpvar_15.xy, tmpvar_15.zw)) * mix (texture2DGradARB (_DetailTex, uv_16, tmpvar_28.xy, tmpvar_28.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_29, tmpvar_29)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_30.w;
  color_1.xyz = clamp ((tmpvar_30.xyz * (1.0 - tmpvar_30.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_30.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 128 math, 3 textures, 5 branches
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform sampler2D _MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp vec2 uv_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD4);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  uv_5 = uv_7;
  highp vec2 tmpvar_11;
  tmpvar_11 = (uv_7 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_12;
  tmpvar_12 = (fract(abs(tmpvar_11)) * vec2(_UVNoiseScale));
  highp float tmpvar_13;
  if ((tmpvar_11.x >= 0.0)) {
    tmpvar_13 = tmpvar_12.x;
  } else {
    tmpvar_13 = -(tmpvar_12.x);
  };
  highp float tmpvar_14;
  if ((tmpvar_11.y >= 0.0)) {
    tmpvar_14 = tmpvar_12.y;
  } else {
    tmpvar_14 = -(tmpvar_12.y);
  };
  highp vec2 tmpvar_15;
  tmpvar_15.x = tmpvar_13;
  tmpvar_15.y = tmpvar_14;
  highp vec2 tmpvar_16;
  tmpvar_16 = ((tmpvar_15 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_17;
  tmpvar_17 = texture2D (_UVNoiseTex, tmpvar_16);
  uv_5 = (uv_7 + ((tmpvar_17.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_18;
  uvCont_18.y = uv_5.y;
  uvCont_18.x = abs((uv_5.x - 0.5));
  highp vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  lowp vec4 tmpvar_20;
  tmpvar_20 = texture2DGradEXT (_MainTex, uv_5, tmpvar_19.xy, tmpvar_19.zw);
  mediump vec4 tmpvar_21;
  tmpvar_21 = tmpvar_20;
  mediump vec2 uv_22;
  mediump vec3 detailCoords_23;
  mediump float s_24;
  mediump float nylerp_25;
  mediump float zxlerp_26;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_28;
  tmpvar_28 = abs(tmpvar_27);
  highp float tmpvar_29;
  tmpvar_29 = float((tmpvar_28.z >= tmpvar_28.x));
  zxlerp_26 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = float((max (tmpvar_28.x, tmpvar_28.z) >= tmpvar_28.y));
  nylerp_25 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_26);
  s_24 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = sign(mix (tmpvar_27.y, s_24, nylerp_25));
  s_24 = tmpvar_32;
  mediump vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = -(s_24);
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = s_24;
  highp vec3 tmpvar_35;
  tmpvar_35 = mix ((tmpvar_33 * tmpvar_27.xzy), (tmpvar_34 * tmpvar_27.zxy), vec3(zxlerp_26));
  detailCoords_23 = tmpvar_35;
  mediump vec3 tmpvar_36;
  tmpvar_36.xy = vec2(1.0, 1.0);
  tmpvar_36.z = s_24;
  highp vec3 tmpvar_37;
  tmpvar_37 = mix ((tmpvar_36 * tmpvar_27.yxz), detailCoords_23, vec3(nylerp_25));
  detailCoords_23 = tmpvar_37;
  uv_22 = (((
    (0.5 * detailCoords_23.yz)
   / 
    abs(detailCoords_23.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_38;
  uv_38 = uv_22;
  highp vec2 uvCont_39;
  highp vec2 tmpvar_40;
  tmpvar_40 = abs((uv_38 - (0.5 * _DetailScale)));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  highp vec4 tmpvar_41;
  tmpvar_41.xy = dFdx(uvCont_39);
  tmpvar_41.zw = dFdy(uvCont_39);
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture2DGradEXT (_DetailTex, uv_22, tmpvar_41.xy, tmpvar_41.zw);
  mediump vec4 tmpvar_43;
  tmpvar_43 = tmpvar_42;
  highp vec3 tmpvar_44;
  tmpvar_44 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_44, tmpvar_44)
  )), 0.0, 1.0);
  tmpvar_45 = tmpvar_46;
  mediump vec4 tmpvar_47;
  tmpvar_47 = ((_Color * tmpvar_21) * mix (tmpvar_43, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_45)));
  color_2 = tmpvar_47;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_48;
  tmpvar_48 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_48;
  mediump vec4 tmpvar_49;
  tmpvar_49 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_49;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec2 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
mediump vec3 t16_4;
highp vec3 t5;
bool tb5;
highp vec3 t6;
lowp vec3 t10_7;
highp vec3 t9;
highp vec3 t10;
bool tb10;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t24;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = t16.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_0 = t10_0 * _Color;
    t16_3.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_4.y = float(ti1);
    t16_3.y = (-t16_4.y);
    t5.xyz = t9.yzx * t16_3.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t9.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_4.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_3.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_3.xy = t16_3.xy / abs(t1.xx);
    t16_3.xy = t16_3.xy + vec2(0.5, 0.5);
    t1.xy = t16_3.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t5.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t5.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t5.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_7.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_7.xyz = t10_7.xxx * t16_2.xyz;
    t10_7.xyz = clamp(t10_7.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_13.xyz = t10_7.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_13.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
int ti0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
bvec2 tb1;
vec3 t2;
mediump vec4 t16_2;
vec3 t3;
bool tb3;
vec3 t4;
vec2 t6;
vec3 t8;
int ti8;
vec2 t10;
mediump vec2 t16_10;
vec2 t11;
bool tb11;
float t15;
float t16;
int ti16;
float t17;
bool tb17;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t15 = max(abs(t0.y), abs(t0.x));
    t15 = float(1.0) / t15;
    t1.x = min(abs(t0.y), abs(t0.x));
    t15 = t15 * t1.x;
    t1.x = t15 * t15;
    t6.x = t1.x * 0.0208350997 + -0.0851330012;
    t6.x = t1.x * t6.x + 0.180141002;
    t6.x = t1.x * t6.x + -0.330299497;
    t1.x = t1.x * t6.x + 0.999866009;
    t6.x = t15 * t1.x;
    t6.x = t6.x * -2.0 + 1.57079637;
    tb11 = abs(t0.y)<abs(t0.x);
    t6.x = tb11 ? t6.x : float(0.0);
    t15 = t15 * t1.x + t6.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t15 = t15 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t15) : t15;
    t0.x = t0.x * 0.159154937 + 0.5;
    t15 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t15 = t15 * abs(t0.z) + -0.212114394;
    t15 = t15 * abs(t0.z) + 1.57072878;
    t10.x = -abs(t0.z) + 1.0;
    t10.x = sqrt(t10.x);
    t1.x = t10.x * t15;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t10.x = t15 * t10.x + t1.x;
    t0.y = t10.x * 0.318309873;
    t10.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t10.xyxx, (-t10.xyxx)).xy;
    t10.xy = fract(abs(t10.xy));
    t10.x = (tb1.x) ? t10.x : (-t10.x);
    t10.y = (tb1.x) ? t10.y : (-t10.y);
    t10.xy = t10.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = t10.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t10.xy;
    t10_1 = texture(_UVNoiseTex, t10.xy);
    t16_10.xy = t10_1.xy + vec2(-0.5, -0.5);
    t0.xy = t16_10.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t10.x = t0.x + -0.5;
    t0.z = abs(t10.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = t10_0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t16 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16 = inversesqrt(t16);
    t2.xyz = vec3(t16) * vs_TEXCOORD5.yxz;
    t17 = vs_TEXCOORD5.z * t16 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t17 = t3.x * t17 + t2.y;
    t16 = (-vs_TEXCOORD5.y) * t16 + t17;
    t17 = max(abs(t2.z), abs(t2.y));
    tb17 = t17>=abs(t2.x);
    t17 = tb17 ? 1.0 : float(0.0);
    t16 = t17 * t16 + t2.x;
    ti8 = int((0.0<t16) ? 0xFFFFFFFFu : uint(0u));
    ti16 = int((t16<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti16 = (-ti8) + ti16;
    t4.y = float(ti16);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t8.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t8.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t17) * t1.xyz + t2.xyz;
    t6.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t6.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t11.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t11.y), abs(t11.x));
    t11.x = min(abs(t11.y), abs(t11.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t11.x);
    t2.y = dFdy(t11.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t16 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t16);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1.x = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1.x ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 133 math, 3 textures, 5 branches
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec2 uv_5;
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = (min (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0) / max (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0));
  float tmpvar_8;
  tmpvar_8 = (tmpvar_7 * tmpvar_7);
  tmpvar_8 = (((
    ((((
      ((((-0.01213232 * tmpvar_8) + 0.05368138) * tmpvar_8) - 0.1173503)
     * tmpvar_8) + 0.1938925) * tmpvar_8) - 0.3326756)
   * tmpvar_8) + 0.9999793) * tmpvar_7);
  tmpvar_8 = (tmpvar_8 + (float(
    (abs((tmpvar_4.x / tmpvar_4.z)) > 1.0)
  ) * (
    (tmpvar_8 * -2.0)
   + 1.570796)));
  tmpvar_6 = (tmpvar_8 * sign((tmpvar_4.x / tmpvar_4.z)));
  if ((abs(tmpvar_4.z) > (1e-08 * abs(tmpvar_4.x)))) {
    if ((tmpvar_4.z < 0.0)) {
      if ((tmpvar_4.x >= 0.0)) {
        tmpvar_6 += 3.141593;
      } else {
        tmpvar_6 = (tmpvar_6 - 3.141593);
      };
    };
  } else {
    tmpvar_6 = (sign(tmpvar_4.x) * 1.570796);
  };
  uv_5.x = (0.5 + (0.1591549 * tmpvar_6));
  uv_5.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_4.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_4.y)
    )) * (1.570796 + (
      abs(tmpvar_4.y)
     * 
      (-0.2146018 + (abs(tmpvar_4.y) * (0.08656672 + (
        abs(tmpvar_4.y)
       * -0.03102955))))
    ))))
  )));
  uv_3 = uv_5;
  vec2 tmpvar_9;
  tmpvar_9 = (uv_5 / vec2(_UVNoiseScale));
  vec2 tmpvar_10;
  tmpvar_10 = (fract(abs(tmpvar_9)) * vec2(_UVNoiseScale));
  float tmpvar_11;
  if ((tmpvar_9.x >= 0.0)) {
    tmpvar_11 = tmpvar_10.x;
  } else {
    tmpvar_11 = -(tmpvar_10.x);
  };
  float tmpvar_12;
  if ((tmpvar_9.y >= 0.0)) {
    tmpvar_12 = tmpvar_10.y;
  } else {
    tmpvar_12 = -(tmpvar_10.y);
  };
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_11;
  tmpvar_13.y = tmpvar_12;
  uv_3 = (uv_5 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_13 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_14;
  uvCont_14.y = uv_3.y;
  uvCont_14.x = abs((uv_3.x - 0.5));
  vec4 tmpvar_15;
  tmpvar_15.xy = dFdx(uvCont_14);
  tmpvar_15.zw = dFdy(uvCont_14);
  vec4 v_16;
  v_16 = (texture2DGradARB (_MainTex, uv_3, tmpvar_15.xy, tmpvar_15.zw) * alphaMask1);
  vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  vec2 uv_18;
  vec3 tmpvar_19;
  tmpvar_19 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_20;
  tmpvar_20 = abs(tmpvar_19);
  float tmpvar_21;
  tmpvar_21 = float((tmpvar_20.z >= tmpvar_20.x));
  float tmpvar_22;
  tmpvar_22 = float((max (tmpvar_20.x, tmpvar_20.z) >= tmpvar_20.y));
  float tmpvar_23;
  tmpvar_23 = sign(mix (tmpvar_19.y, mix (tmpvar_19.x, tmpvar_19.z, tmpvar_21), tmpvar_22));
  vec3 tmpvar_24;
  tmpvar_24.xz = vec2(1.0, -1.0);
  tmpvar_24.y = -(tmpvar_23);
  vec3 tmpvar_25;
  tmpvar_25.xz = vec2(1.0, -1.0);
  tmpvar_25.y = tmpvar_23;
  vec3 tmpvar_26;
  tmpvar_26.xy = vec2(1.0, 1.0);
  tmpvar_26.z = tmpvar_23;
  vec3 tmpvar_27;
  tmpvar_27 = mix ((tmpvar_26 * tmpvar_19.yxz), mix ((tmpvar_24 * tmpvar_19.xzy), (tmpvar_25 * tmpvar_19.zxy), vec3(tmpvar_21)), vec3(tmpvar_22));
  uv_18 = (((
    (0.5 * tmpvar_27.yz)
   / 
    abs(tmpvar_27.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_28;
  vec2 tmpvar_29;
  tmpvar_29 = abs((uv_18 - (0.5 * _DetailScale)));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  vec4 tmpvar_30;
  tmpvar_30.xy = dFdx(uvCont_28);
  tmpvar_30.zw = dFdy(uvCont_28);
  vec3 tmpvar_31;
  tmpvar_31 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_32;
  tmpvar_32 = ((_Color * tmpvar_17) * mix (texture2DGradARB (_DetailTex, uv_18, tmpvar_30.xy, tmpvar_30.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_31, tmpvar_31)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_32.w;
  color_1.xyz = clamp ((tmpvar_32.xyz * (1.0 - tmpvar_32.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_32.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 133 math, 3 textures, 5 branches
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp vec2 uv_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD4);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  uv_5 = uv_7;
  highp vec2 tmpvar_11;
  tmpvar_11 = (uv_7 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_12;
  tmpvar_12 = (fract(abs(tmpvar_11)) * vec2(_UVNoiseScale));
  highp float tmpvar_13;
  if ((tmpvar_11.x >= 0.0)) {
    tmpvar_13 = tmpvar_12.x;
  } else {
    tmpvar_13 = -(tmpvar_12.x);
  };
  highp float tmpvar_14;
  if ((tmpvar_11.y >= 0.0)) {
    tmpvar_14 = tmpvar_12.y;
  } else {
    tmpvar_14 = -(tmpvar_12.y);
  };
  highp vec2 tmpvar_15;
  tmpvar_15.x = tmpvar_13;
  tmpvar_15.y = tmpvar_14;
  highp vec2 tmpvar_16;
  tmpvar_16 = ((tmpvar_15 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_17;
  tmpvar_17 = texture2D (_UVNoiseTex, tmpvar_16);
  uv_5 = (uv_7 + ((tmpvar_17.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_18;
  uvCont_18.y = uv_5.y;
  uvCont_18.x = abs((uv_5.x - 0.5));
  highp vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  lowp vec4 tmpvar_20;
  tmpvar_20 = texture2DGradEXT (_MainTex, uv_5, tmpvar_19.xy, tmpvar_19.zw);
  mediump vec4 tmpvar_21;
  tmpvar_21 = tmpvar_20;
  mediump vec4 v_22;
  v_22 = (tmpvar_21 * alphaMask1);
  mediump vec4 tmpvar_23;
  tmpvar_23.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_23.w = ((v_22.x + v_22.y) + (v_22.z + v_22.w));
  mediump vec2 uv_24;
  mediump vec3 detailCoords_25;
  mediump float s_26;
  mediump float nylerp_27;
  mediump float zxlerp_28;
  highp vec3 tmpvar_29;
  tmpvar_29 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_30;
  tmpvar_30 = abs(tmpvar_29);
  highp float tmpvar_31;
  tmpvar_31 = float((tmpvar_30.z >= tmpvar_30.x));
  zxlerp_28 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = float((max (tmpvar_30.x, tmpvar_30.z) >= tmpvar_30.y));
  nylerp_27 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = mix (tmpvar_29.x, tmpvar_29.z, zxlerp_28);
  s_26 = tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_29.y, s_26, nylerp_27));
  s_26 = tmpvar_34;
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(s_26);
  mediump vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = s_26;
  highp vec3 tmpvar_37;
  tmpvar_37 = mix ((tmpvar_35 * tmpvar_29.xzy), (tmpvar_36 * tmpvar_29.zxy), vec3(zxlerp_28));
  detailCoords_25 = tmpvar_37;
  mediump vec3 tmpvar_38;
  tmpvar_38.xy = vec2(1.0, 1.0);
  tmpvar_38.z = s_26;
  highp vec3 tmpvar_39;
  tmpvar_39 = mix ((tmpvar_38 * tmpvar_29.yxz), detailCoords_25, vec3(nylerp_27));
  detailCoords_25 = tmpvar_39;
  uv_24 = (((
    (0.5 * detailCoords_25.yz)
   / 
    abs(detailCoords_25.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_40;
  uv_40 = uv_24;
  highp vec2 uvCont_41;
  highp vec2 tmpvar_42;
  tmpvar_42 = abs((uv_40 - (0.5 * _DetailScale)));
  uvCont_41.x = max (tmpvar_42.x, tmpvar_42.y);
  uvCont_41.y = min (tmpvar_42.x, tmpvar_42.y);
  highp vec4 tmpvar_43;
  tmpvar_43.xy = dFdx(uvCont_41);
  tmpvar_43.zw = dFdy(uvCont_41);
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture2DGradEXT (_DetailTex, uv_24, tmpvar_43.xy, tmpvar_43.zw);
  mediump vec4 tmpvar_45;
  tmpvar_45 = tmpvar_44;
  highp vec3 tmpvar_46;
  tmpvar_46 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_46, tmpvar_46)
  )), 0.0, 1.0);
  tmpvar_47 = tmpvar_48;
  mediump vec4 tmpvar_49;
  tmpvar_49 = ((_Color * tmpvar_23) * mix (tmpvar_45, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_47)));
  color_2 = tmpvar_49;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_50;
  tmpvar_50 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_50;
  mediump vec4 tmpvar_51;
  tmpvar_51 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_51;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec2 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
mediump vec3 t16_4;
highp vec3 t5;
bool tb5;
highp vec3 t6;
lowp vec3 t10_7;
highp vec3 t9;
highp vec3 t10;
bool tb10;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t24;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = t16.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_3.xy = t10_0.xy * alphaMask1.xy;
    t16_3.x = t16_3.y + t16_3.x;
    t16_3.x = t10_0.z * alphaMask1.z + t16_3.x;
    t16_0.w = t10_0.w * alphaMask1.w + t16_3.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_3.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_4.y = float(ti1);
    t16_3.y = (-t16_4.y);
    t5.xyz = t9.yzx * t16_3.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t9.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_4.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_3.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_3.xy = t16_3.xy / abs(t1.xx);
    t16_3.xy = t16_3.xy + vec2(0.5, 0.5);
    t1.xy = t16_3.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t5.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t5.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t5.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_7.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_7.xyz = t10_7.xxx * t16_2.xyz;
    t10_7.xyz = clamp(t10_7.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_13.xyz = t10_7.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_13.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
int ti0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
bvec2 tb1;
vec3 t2;
mediump vec4 t16_2;
vec3 t3;
bool tb3;
vec3 t4;
vec2 t6;
vec3 t8;
int ti8;
vec2 t10;
mediump vec2 t16_10;
vec2 t11;
bool tb11;
float t15;
float t16;
int ti16;
float t17;
bool tb17;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t15 = max(abs(t0.y), abs(t0.x));
    t15 = float(1.0) / t15;
    t1.x = min(abs(t0.y), abs(t0.x));
    t15 = t15 * t1.x;
    t1.x = t15 * t15;
    t6.x = t1.x * 0.0208350997 + -0.0851330012;
    t6.x = t1.x * t6.x + 0.180141002;
    t6.x = t1.x * t6.x + -0.330299497;
    t1.x = t1.x * t6.x + 0.999866009;
    t6.x = t15 * t1.x;
    t6.x = t6.x * -2.0 + 1.57079637;
    tb11 = abs(t0.y)<abs(t0.x);
    t6.x = tb11 ? t6.x : float(0.0);
    t15 = t15 * t1.x + t6.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t15 = t15 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t15) : t15;
    t0.x = t0.x * 0.159154937 + 0.5;
    t15 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t15 = t15 * abs(t0.z) + -0.212114394;
    t15 = t15 * abs(t0.z) + 1.57072878;
    t10.x = -abs(t0.z) + 1.0;
    t10.x = sqrt(t10.x);
    t1.x = t10.x * t15;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t10.x = t15 * t10.x + t1.x;
    t0.y = t10.x * 0.318309873;
    t10.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t10.xyxx, (-t10.xyxx)).xy;
    t10.xy = fract(abs(t10.xy));
    t10.x = (tb1.x) ? t10.x : (-t10.x);
    t10.y = (tb1.x) ? t10.y : (-t10.y);
    t10.xy = t10.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = t10.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t10.xy;
    t10_1 = texture(_UVNoiseTex, t10.xy);
    t16_10.xy = t10_1.xy + vec2(-0.5, -0.5);
    t0.xy = t16_10.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t10.x = t0.x + -0.5;
    t0.z = abs(t10.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t0.xy = t10_0.xy * alphaMask1.xy;
    t0.x = t0.y + t0.x;
    t0.x = t10_0.z * alphaMask1.z + t0.x;
    t0.w = t10_0.w * alphaMask1.w + t0.x;
    t0.xyz = vec3(1.0, 1.0, 1.0);
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t16 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16 = inversesqrt(t16);
    t2.xyz = vec3(t16) * vs_TEXCOORD5.yxz;
    t17 = vs_TEXCOORD5.z * t16 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t17 = t3.x * t17 + t2.y;
    t16 = (-vs_TEXCOORD5.y) * t16 + t17;
    t17 = max(abs(t2.z), abs(t2.y));
    tb17 = t17>=abs(t2.x);
    t17 = tb17 ? 1.0 : float(0.0);
    t16 = t17 * t16 + t2.x;
    ti8 = int((0.0<t16) ? 0xFFFFFFFFu : uint(0u));
    ti16 = int((t16<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti16 = (-ti8) + ti16;
    t4.y = float(ti16);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t8.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t8.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t17) * t1.xyz + t2.xyz;
    t6.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t6.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t11.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t11.y), abs(t11.x));
    t11.x = min(abs(t11.y), abs(t11.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t11.x);
    t2.y = dFdy(t11.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t16 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t16);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1.x = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1.x ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 66 math, 3 textures, 3 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform samplerCube cube_MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec3 cubeVect_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  cubeVect_3 = tmpvar_4;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 / vec3(_UVNoiseScale));
  vec3 tmpvar_6;
  tmpvar_6 = (fract(abs(tmpvar_5)) * vec3(_UVNoiseScale));
  float tmpvar_7;
  if ((tmpvar_5.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  float tmpvar_8;
  if ((tmpvar_5.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  float tmpvar_9;
  if ((tmpvar_5.z >= 0.0)) {
    tmpvar_9 = tmpvar_6.z;
  } else {
    tmpvar_9 = -(tmpvar_6.z);
  };
  vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  cubeVect_3.xy = (tmpvar_4.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_10 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uv_11;
  vec3 tmpvar_12;
  tmpvar_12 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_13;
  tmpvar_13 = abs(tmpvar_12);
  float tmpvar_14;
  tmpvar_14 = float((tmpvar_13.z >= tmpvar_13.x));
  float tmpvar_15;
  tmpvar_15 = float((max (tmpvar_13.x, tmpvar_13.z) >= tmpvar_13.y));
  float tmpvar_16;
  tmpvar_16 = sign(mix (tmpvar_12.y, mix (tmpvar_12.x, tmpvar_12.z, tmpvar_14), tmpvar_15));
  vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = -(tmpvar_16);
  vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = tmpvar_16;
  vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = tmpvar_16;
  vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_12.yxz), mix ((tmpvar_17 * tmpvar_12.xzy), (tmpvar_18 * tmpvar_12.zxy), vec3(tmpvar_14)), vec3(tmpvar_15));
  uv_11 = (((
    (0.5 * tmpvar_20.yz)
   / 
    abs(tmpvar_20.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_21;
  vec2 tmpvar_22;
  tmpvar_22 = abs((uv_11 - (0.5 * _DetailScale)));
  uvCont_21.x = max (tmpvar_22.x, tmpvar_22.y);
  uvCont_21.y = min (tmpvar_22.x, tmpvar_22.y);
  vec4 tmpvar_23;
  tmpvar_23.xy = dFdx(uvCont_21);
  tmpvar_23.zw = dFdy(uvCont_21);
  vec3 tmpvar_24;
  tmpvar_24 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_25;
  tmpvar_25 = ((_Color * textureCube (cube_MainTex, cubeVect_3)) * mix (texture2DGradARB (_DetailTex, uv_11, tmpvar_23.xy, tmpvar_23.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_24, tmpvar_24)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_25.w;
  color_1.xyz = clamp ((tmpvar_25.xyz * (1.0 - tmpvar_25.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_25.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 66 math, 3 textures, 3 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform lowp samplerCube cube_MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp vec3 cubeVect_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD4);
  cubeVect_5 = tmpvar_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = (tmpvar_6 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_8;
  tmpvar_8 = (fract(abs(tmpvar_7)) * vec3(_UVNoiseScale));
  highp float tmpvar_9;
  if ((tmpvar_7.x >= 0.0)) {
    tmpvar_9 = tmpvar_8.x;
  } else {
    tmpvar_9 = -(tmpvar_8.x);
  };
  highp float tmpvar_10;
  if ((tmpvar_7.y >= 0.0)) {
    tmpvar_10 = tmpvar_8.y;
  } else {
    tmpvar_10 = -(tmpvar_8.y);
  };
  highp float tmpvar_11;
  if ((tmpvar_7.z >= 0.0)) {
    tmpvar_11 = tmpvar_8.z;
  } else {
    tmpvar_11 = -(tmpvar_8.z);
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  highp vec2 tmpvar_13;
  tmpvar_13 = ((tmpvar_12 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_UVNoiseTex, tmpvar_13);
  cubeVect_5.xy = (tmpvar_6.xy + ((tmpvar_14.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_15;
  tmpvar_15 = textureCube (cube_MainTex, cubeVect_5);
  mediump vec4 tmpvar_16;
  tmpvar_16 = tmpvar_15;
  mediump vec2 uv_17;
  mediump vec3 detailCoords_18;
  mediump float s_19;
  mediump float nylerp_20;
  mediump float zxlerp_21;
  highp vec3 tmpvar_22;
  tmpvar_22 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_23;
  tmpvar_23 = abs(tmpvar_22);
  highp float tmpvar_24;
  tmpvar_24 = float((tmpvar_23.z >= tmpvar_23.x));
  zxlerp_21 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = float((max (tmpvar_23.x, tmpvar_23.z) >= tmpvar_23.y));
  nylerp_20 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = mix (tmpvar_22.x, tmpvar_22.z, zxlerp_21);
  s_19 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_22.y, s_19, nylerp_20));
  s_19 = tmpvar_27;
  mediump vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(s_19);
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = s_19;
  highp vec3 tmpvar_30;
  tmpvar_30 = mix ((tmpvar_28 * tmpvar_22.xzy), (tmpvar_29 * tmpvar_22.zxy), vec3(zxlerp_21));
  detailCoords_18 = tmpvar_30;
  mediump vec3 tmpvar_31;
  tmpvar_31.xy = vec2(1.0, 1.0);
  tmpvar_31.z = s_19;
  highp vec3 tmpvar_32;
  tmpvar_32 = mix ((tmpvar_31 * tmpvar_22.yxz), detailCoords_18, vec3(nylerp_20));
  detailCoords_18 = tmpvar_32;
  uv_17 = (((
    (0.5 * detailCoords_18.yz)
   / 
    abs(detailCoords_18.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_33;
  uv_33 = uv_17;
  highp vec2 uvCont_34;
  highp vec2 tmpvar_35;
  tmpvar_35 = abs((uv_33 - (0.5 * _DetailScale)));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  highp vec4 tmpvar_36;
  tmpvar_36.xy = dFdx(uvCont_34);
  tmpvar_36.zw = dFdy(uvCont_34);
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture2DGradEXT (_DetailTex, uv_17, tmpvar_36.xy, tmpvar_36.zw);
  mediump vec4 tmpvar_38;
  tmpvar_38 = tmpvar_37;
  highp vec3 tmpvar_39;
  tmpvar_39 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_39, tmpvar_39)
  )), 0.0, 1.0);
  tmpvar_40 = tmpvar_41;
  mediump vec4 tmpvar_42;
  tmpvar_42 = ((_Color * tmpvar_16) * mix (tmpvar_38, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_40)));
  color_2 = tmpvar_42;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_43;
  tmpvar_43 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_43;
  mediump vec4 tmpvar_44;
  tmpvar_44 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_44;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp samplerCube cube_MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
highp vec3 t4;
mediump vec2 t16_4;
lowp vec2 t10_4;
bool tb4;
highp vec3 t5;
lowp vec3 t10_6;
highp vec3 t8;
highp vec3 t9;
bool tb9;
mediump vec3 t16_11;
highp vec2 t15;
highp int ti16;
bvec2 tb18;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t8.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t8.y);
    tb9 = abs(t8.z)>=abs(t8.y);
    t9.x = tb9 ? 1.0 : float(0.0);
    t2.x = t9.x * t2.x + t8.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t8.z), abs(t8.y));
    tb2 = t2.x>=abs(t8.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t8.x;
    ti16 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti16) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t8.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t8.zyx + (-t4.xyz);
    t9.xyz = t9.xxx * t5.xyz + t4.xyz;
    t9.xyz = (-t16_3.xxy) * t8.xyz + t9.xyz;
    t1.xyz = t8.xyz * t16_3.xxy;
    t1.xyz = t2.xxx * t9.xyz + t1.xyz;
    t16_0.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_0.xy = t16_0.xy / abs(t1.xx);
    t16_0.xy = t16_0.xy + vec2(0.5, 0.5);
    t1.xy = t16_0.xy * vec2(_DetailScale);
    t15.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t15.y), abs(t15.x));
    t15.x = min(abs(t15.y), abs(t15.x));
    t4.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t4.y = dFdx(t15.x);
    t2.y = dFdy(t15.x);
    t10_0 = textureGrad(_DetailTex, t1.xy, vec4(t4.xyxx).xy, vec4(t2.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t16_0 = t2.xxxx * t16_1 + t10_0;
    t2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD4.xyz;
    t4.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb18.xy = greaterThanEqual(t4.xyxy, (-t4.xyxy)).xy;
    t4.xy = fract(abs(t4.xy));
    t4.x = (tb18.x) ? t4.x : (-t4.x);
    t4.y = (tb18.y) ? t4.y : (-t4.y);
    t4.xy = t4.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = t4.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t4.xy;
    t10_4.xy = texture(_UVNoiseTex, t4.xy).xy;
    t16_4.xy = t10_4.xy + vec2(-0.5, -0.5);
    t2.xy = t16_4.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t2.xy;
    t10_1 = texture(cube_MainTex, t2.xyz);
    t16_1 = t10_1 * _Color;
    t10_6.x = (-t16_1.w) * t16_0.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_1.w * t16_0.w + -1.0;
    t10_6.xyz = t10_6.xxx * t16_2.xyz;
    t10_6.xyz = clamp(t10_6.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_11.xyz = t10_6.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_11.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
vec4 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec2 t16_2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
vec2 t4;
vec3 t6;
int ti6;
vec2 t8;
bvec2 tb10;
float t12;
int ti12;
float t13;
bool tb13;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t12 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t12 = inversesqrt(t12);
    t1.xyz = vec3(t12) * vs_TEXCOORD5.yxz;
    t13 = vs_TEXCOORD5.z * t12 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t13 = t2.x * t13 + t1.y;
    t12 = (-vs_TEXCOORD5.y) * t12 + t13;
    t13 = max(abs(t1.z), abs(t1.y));
    tb13 = t13>=abs(t1.x);
    t13 = tb13 ? 1.0 : float(0.0);
    t12 = t13 * t12 + t1.x;
    ti6 = int((0.0<t12) ? 0xFFFFFFFFu : uint(0u));
    ti12 = int((t12<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti12 = (-ti6) + ti12;
    t3.y = float(ti12);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t6.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t6.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    t0.xyz = vec3(t13) * t0.xyz + t1.xyz;
    t4.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t4.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_DetailScale);
    t8.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t8.y), abs(t8.x));
    t8.x = min(abs(t8.y), abs(t8.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t8.x);
    t1.y = dFdy(t8.x);
    t10_0 = textureGrad(_DetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t0 = t2.xxxx * t16_1 + t10_0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t2.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t2.xyxy, (-t2.xyxy)).xy;
    t2.xy = fract(abs(t2.xy));
    t2.x = (tb10.x) ? t2.x : (-t2.x);
    t2.y = (tb10.y) ? t2.y : (-t2.y);
    t2.xy = t2.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t2.xy;
    t10_2 = texture(_UVNoiseTex, t2.xy);
    t16_2.xy = t10_2.xy + vec2(-0.5, -0.5);
    t1.xy = t16_2.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t10_1 = texture(cube_MainTex, t1.xyz);
    t1 = t10_1 * _Color;
    t2.x = (-t1.w) * t0.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t13 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t13);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 71 math, 3 textures, 3 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform samplerCube cube_MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec3 cubeVect_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  cubeVect_3 = tmpvar_4;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 / vec3(_UVNoiseScale));
  vec3 tmpvar_6;
  tmpvar_6 = (fract(abs(tmpvar_5)) * vec3(_UVNoiseScale));
  float tmpvar_7;
  if ((tmpvar_5.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  float tmpvar_8;
  if ((tmpvar_5.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  float tmpvar_9;
  if ((tmpvar_5.z >= 0.0)) {
    tmpvar_9 = tmpvar_6.z;
  } else {
    tmpvar_9 = -(tmpvar_6.z);
  };
  vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  cubeVect_3.xy = (tmpvar_4.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_10 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec4 v_11;
  v_11 = (textureCube (cube_MainTex, cubeVect_3) * alphaMask1);
  vec4 tmpvar_12;
  tmpvar_12.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_12.w = ((v_11.x + v_11.y) + (v_11.z + v_11.w));
  vec2 uv_13;
  vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_15;
  tmpvar_15 = abs(tmpvar_14);
  float tmpvar_16;
  tmpvar_16 = float((tmpvar_15.z >= tmpvar_15.x));
  float tmpvar_17;
  tmpvar_17 = float((max (tmpvar_15.x, tmpvar_15.z) >= tmpvar_15.y));
  float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_16), tmpvar_17));
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(tmpvar_18);
  vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = tmpvar_18;
  vec3 tmpvar_21;
  tmpvar_21.xy = vec2(1.0, 1.0);
  tmpvar_21.z = tmpvar_18;
  vec3 tmpvar_22;
  tmpvar_22 = mix ((tmpvar_21 * tmpvar_14.yxz), mix ((tmpvar_19 * tmpvar_14.xzy), (tmpvar_20 * tmpvar_14.zxy), vec3(tmpvar_16)), vec3(tmpvar_17));
  uv_13 = (((
    (0.5 * tmpvar_22.yz)
   / 
    abs(tmpvar_22.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_23;
  vec2 tmpvar_24;
  tmpvar_24 = abs((uv_13 - (0.5 * _DetailScale)));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  vec4 tmpvar_25;
  tmpvar_25.xy = dFdx(uvCont_23);
  tmpvar_25.zw = dFdy(uvCont_23);
  vec3 tmpvar_26;
  tmpvar_26 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_27;
  tmpvar_27 = ((_Color * tmpvar_12) * mix (texture2DGradARB (_DetailTex, uv_13, tmpvar_25.xy, tmpvar_25.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_26, tmpvar_26)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_27.w;
  color_1.xyz = clamp ((tmpvar_27.xyz * (1.0 - tmpvar_27.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_27.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 71 math, 3 textures, 3 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp vec3 cubeVect_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD4);
  cubeVect_5 = tmpvar_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = (tmpvar_6 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_8;
  tmpvar_8 = (fract(abs(tmpvar_7)) * vec3(_UVNoiseScale));
  highp float tmpvar_9;
  if ((tmpvar_7.x >= 0.0)) {
    tmpvar_9 = tmpvar_8.x;
  } else {
    tmpvar_9 = -(tmpvar_8.x);
  };
  highp float tmpvar_10;
  if ((tmpvar_7.y >= 0.0)) {
    tmpvar_10 = tmpvar_8.y;
  } else {
    tmpvar_10 = -(tmpvar_8.y);
  };
  highp float tmpvar_11;
  if ((tmpvar_7.z >= 0.0)) {
    tmpvar_11 = tmpvar_8.z;
  } else {
    tmpvar_11 = -(tmpvar_8.z);
  };
  highp vec3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  highp vec2 tmpvar_13;
  tmpvar_13 = ((tmpvar_12 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2D (_UVNoiseTex, tmpvar_13);
  cubeVect_5.xy = (tmpvar_6.xy + ((tmpvar_14.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_15;
  tmpvar_15 = textureCube (cube_MainTex, cubeVect_5);
  mediump vec4 tmpvar_16;
  tmpvar_16 = tmpvar_15;
  mediump vec4 v_17;
  v_17 = (tmpvar_16 * alphaMask1);
  mediump vec4 tmpvar_18;
  tmpvar_18.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_18.w = ((v_17.x + v_17.y) + (v_17.z + v_17.w));
  mediump vec2 uv_19;
  mediump vec3 detailCoords_20;
  mediump float s_21;
  mediump float nylerp_22;
  mediump float zxlerp_23;
  highp vec3 tmpvar_24;
  tmpvar_24 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_25;
  tmpvar_25 = abs(tmpvar_24);
  highp float tmpvar_26;
  tmpvar_26 = float((tmpvar_25.z >= tmpvar_25.x));
  zxlerp_23 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = float((max (tmpvar_25.x, tmpvar_25.z) >= tmpvar_25.y));
  nylerp_22 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = mix (tmpvar_24.x, tmpvar_24.z, zxlerp_23);
  s_21 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_24.y, s_21, nylerp_22));
  s_21 = tmpvar_29;
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(s_21);
  mediump vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = s_21;
  highp vec3 tmpvar_32;
  tmpvar_32 = mix ((tmpvar_30 * tmpvar_24.xzy), (tmpvar_31 * tmpvar_24.zxy), vec3(zxlerp_23));
  detailCoords_20 = tmpvar_32;
  mediump vec3 tmpvar_33;
  tmpvar_33.xy = vec2(1.0, 1.0);
  tmpvar_33.z = s_21;
  highp vec3 tmpvar_34;
  tmpvar_34 = mix ((tmpvar_33 * tmpvar_24.yxz), detailCoords_20, vec3(nylerp_22));
  detailCoords_20 = tmpvar_34;
  uv_19 = (((
    (0.5 * detailCoords_20.yz)
   / 
    abs(detailCoords_20.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_35;
  uv_35 = uv_19;
  highp vec2 uvCont_36;
  highp vec2 tmpvar_37;
  tmpvar_37 = abs((uv_35 - (0.5 * _DetailScale)));
  uvCont_36.x = max (tmpvar_37.x, tmpvar_37.y);
  uvCont_36.y = min (tmpvar_37.x, tmpvar_37.y);
  highp vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_36);
  tmpvar_38.zw = dFdy(uvCont_36);
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (_DetailTex, uv_19, tmpvar_38.xy, tmpvar_38.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  highp vec3 tmpvar_41;
  tmpvar_41 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_41, tmpvar_41)
  )), 0.0, 1.0);
  tmpvar_42 = tmpvar_43;
  mediump vec4 tmpvar_44;
  tmpvar_44 = ((_Color * tmpvar_18) * mix (tmpvar_40, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_42)));
  color_2 = tmpvar_44;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_45;
  tmpvar_45 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_45;
  mediump vec4 tmpvar_46;
  tmpvar_46 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_46;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp samplerCube cube_MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
highp vec3 t4;
mediump vec2 t16_4;
lowp vec2 t10_4;
bool tb4;
highp vec3 t5;
lowp vec3 t10_6;
highp vec3 t8;
highp vec3 t9;
bool tb9;
mediump vec3 t16_11;
highp vec2 t15;
highp int ti16;
bvec2 tb18;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t8.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t8.y);
    tb9 = abs(t8.z)>=abs(t8.y);
    t9.x = tb9 ? 1.0 : float(0.0);
    t2.x = t9.x * t2.x + t8.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t8.z), abs(t8.y));
    tb2 = t2.x>=abs(t8.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t8.x;
    ti16 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti16) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t8.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t8.zyx + (-t4.xyz);
    t9.xyz = t9.xxx * t5.xyz + t4.xyz;
    t9.xyz = (-t16_3.xxy) * t8.xyz + t9.xyz;
    t1.xyz = t8.xyz * t16_3.xxy;
    t1.xyz = t2.xxx * t9.xyz + t1.xyz;
    t16_0.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_0.xy = t16_0.xy / abs(t1.xx);
    t16_0.xy = t16_0.xy + vec2(0.5, 0.5);
    t1.xy = t16_0.xy * vec2(_DetailScale);
    t15.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t15.y), abs(t15.x));
    t15.x = min(abs(t15.y), abs(t15.x));
    t4.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t4.y = dFdx(t15.x);
    t2.y = dFdy(t15.x);
    t10_0 = textureGrad(_DetailTex, t1.xy, vec4(t4.xyxx).xy, vec4(t2.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t16_0 = t2.xxxx * t16_1 + t10_0;
    t2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD4.xyz;
    t4.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb18.xy = greaterThanEqual(t4.xyxy, (-t4.xyxy)).xy;
    t4.xy = fract(abs(t4.xy));
    t4.x = (tb18.x) ? t4.x : (-t4.x);
    t4.y = (tb18.y) ? t4.y : (-t4.y);
    t4.xy = t4.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = t4.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t4.xy;
    t10_4.xy = texture(_UVNoiseTex, t4.xy).xy;
    t16_4.xy = t10_4.xy + vec2(-0.5, -0.5);
    t2.xy = t16_4.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t2.xy;
    t10_1 = texture(cube_MainTex, t2.xyz);
    t16_3.xy = t10_1.xy * alphaMask1.xy;
    t16_3.x = t16_3.y + t16_3.x;
    t16_3.x = t10_1.z * alphaMask1.z + t16_3.x;
    t16_1.w = t10_1.w * alphaMask1.w + t16_3.x;
    t16_1.xyz = vec3(1.0, 1.0, 1.0);
    t16_1 = t16_1 * _Color;
    t10_6.x = (-t16_1.w) * t16_0.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_1.w * t16_0.w + -1.0;
    t10_6.xyz = t10_6.xxx * t16_2.xyz;
    t10_6.xyz = clamp(t10_6.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_11.xyz = t10_6.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_11.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
vec4 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec2 t16_2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
vec2 t4;
vec3 t6;
int ti6;
vec2 t8;
bvec2 tb10;
float t12;
int ti12;
float t13;
bool tb13;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t12 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t12 = inversesqrt(t12);
    t1.xyz = vec3(t12) * vs_TEXCOORD5.yxz;
    t13 = vs_TEXCOORD5.z * t12 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t13 = t2.x * t13 + t1.y;
    t12 = (-vs_TEXCOORD5.y) * t12 + t13;
    t13 = max(abs(t1.z), abs(t1.y));
    tb13 = t13>=abs(t1.x);
    t13 = tb13 ? 1.0 : float(0.0);
    t12 = t13 * t12 + t1.x;
    ti6 = int((0.0<t12) ? 0xFFFFFFFFu : uint(0u));
    ti12 = int((t12<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti12 = (-ti6) + ti12;
    t3.y = float(ti12);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t6.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t6.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    t0.xyz = vec3(t13) * t0.xyz + t1.xyz;
    t4.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t4.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_DetailScale);
    t8.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t8.y), abs(t8.x));
    t8.x = min(abs(t8.y), abs(t8.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t8.x);
    t1.y = dFdy(t8.x);
    t10_0 = textureGrad(_DetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t0 = t2.xxxx * t16_1 + t10_0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t2.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t2.xyxy, (-t2.xyxy)).xy;
    t2.xy = fract(abs(t2.xy));
    t2.x = (tb10.x) ? t2.x : (-t2.x);
    t2.y = (tb10.y) ? t2.y : (-t2.y);
    t2.xy = t2.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t2.xy;
    t10_2 = texture(_UVNoiseTex, t2.xy);
    t16_2.xy = t10_2.xy + vec2(-0.5, -0.5);
    t1.xy = t16_2.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t10_1 = texture(cube_MainTex, t1.xyz);
    t1.xy = t10_1.xy * alphaMask1.xy;
    t1.x = t1.y + t1.x;
    t1.x = t10_1.z * alphaMask1.z + t1.x;
    t1.w = t10_1.w * alphaMask1.w + t1.x;
    t1.xyz = vec3(1.0, 1.0, 1.0);
    t1 = t1 * _Color;
    t2.x = (-t1.w) * t0.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t13 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t13);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 97 math, 4 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec4 tmpvar_22;
  tmpvar_22 = mix (texture2DGradARB (cube_MainTexNEG, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexPOS, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))));
  vec4 tmpvar_23;
  tmpvar_23.x = tmpvar_22.w;
  tmpvar_23.y = tmpvar_22.w;
  tmpvar_23.z = tmpvar_22.w;
  tmpvar_23.w = mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_6), tmpvar_7);
  vec2 uv_24;
  vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_25);
  float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_25.y, mix (tmpvar_25.x, tmpvar_25.z, tmpvar_27), tmpvar_28));
  vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(tmpvar_29);
  vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = tmpvar_29;
  vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = tmpvar_29;
  vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_25.yxz), mix ((tmpvar_30 * tmpvar_25.xzy), (tmpvar_31 * tmpvar_25.zxy), vec3(tmpvar_27)), vec3(tmpvar_28));
  uv_24 = (((
    (0.5 * tmpvar_33.yz)
   / 
    abs(tmpvar_33.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_34;
  vec2 tmpvar_35;
  tmpvar_35 = abs((uv_24 - (0.5 * _DetailScale)));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  vec4 tmpvar_36;
  tmpvar_36.xy = dFdx(uvCont_34);
  tmpvar_36.zw = dFdy(uvCont_34);
  vec3 tmpvar_37;
  tmpvar_37 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_38;
  tmpvar_38 = ((_Color * tmpvar_23) * mix (texture2DGradARB (_DetailTex, uv_24, tmpvar_36.xy, tmpvar_36.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_37, tmpvar_37)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_38.w;
  color_1.xyz = clamp ((tmpvar_38.xyz * (1.0 - tmpvar_38.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_38.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 97 math, 4 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  mediump vec2 uv_5;
  mediump vec3 detailCoords_6;
  mediump float s_7;
  mediump float nylerp_8;
  mediump float zxlerp_9;
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_9);
  s_7 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, s_7, nylerp_8));
  s_7 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16.xz = vec2(1.0, -1.0);
  tmpvar_16.y = -(s_7);
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = s_7;
  highp vec3 tmpvar_18;
  tmpvar_18 = mix ((tmpvar_16 * tmpvar_10.xzy), (tmpvar_17 * tmpvar_10.zxy), vec3(zxlerp_9));
  detailCoords_6 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = s_7;
  highp vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_10.yxz), detailCoords_6, vec3(nylerp_8));
  detailCoords_6 = tmpvar_20;
  mediump vec2 tmpvar_21;
  tmpvar_21 = (((0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + 0.5);
  uv_5 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22 = (tmpvar_21 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * vec2(_UVNoiseScale));
  highp float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  highp float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  highp vec2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  highp vec2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture2D (_UVNoiseTex, tmpvar_27);
  uv_5 = (tmpvar_21 + ((tmpvar_28.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_29;
  uv_29 = uv_5;
  highp vec2 uvCont_30;
  highp vec2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  highp vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  lowp vec4 tmpvar_33;
  tmpvar_33 = texture2DGradEXT (cube_MainTexPOS, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  lowp vec4 tmpvar_35;
  tmpvar_35 = texture2DGradEXT (cube_MainTexNEG, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  mediump vec4 tmpvar_37;
  tmpvar_37 = mix (tmpvar_36, tmpvar_34, vec4(float((s_7 >= 0.0))));
  mediump vec4 tmpvar_38;
  tmpvar_38.x = tmpvar_37.w;
  tmpvar_38.y = tmpvar_37.w;
  tmpvar_38.z = tmpvar_37.w;
  tmpvar_38.w = mix (tmpvar_37.y, mix (tmpvar_37.x, tmpvar_37.z, zxlerp_9), nylerp_8);
  mediump vec2 uv_39;
  mediump vec3 detailCoords_40;
  mediump float s_41;
  mediump float nylerp_42;
  mediump float zxlerp_43;
  highp vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  highp float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_43);
  s_41 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, s_41, nylerp_42));
  s_41 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = -(s_41);
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = s_41;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_50 * tmpvar_44.xzy), (tmpvar_51 * tmpvar_44.zxy), vec3(zxlerp_43));
  detailCoords_40 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = s_41;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_44.yxz), detailCoords_40, vec3(nylerp_42));
  detailCoords_40 = tmpvar_54;
  uv_39 = (((
    (0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_55;
  uv_55 = uv_39;
  highp vec2 uvCont_56;
  highp vec2 tmpvar_57;
  tmpvar_57 = abs((uv_55 - (0.5 * _DetailScale)));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  highp vec4 tmpvar_58;
  tmpvar_58.xy = dFdx(uvCont_56);
  tmpvar_58.zw = dFdy(uvCont_56);
  lowp vec4 tmpvar_59;
  tmpvar_59 = texture2DGradEXT (_DetailTex, uv_39, tmpvar_58.xy, tmpvar_58.zw);
  mediump vec4 tmpvar_60;
  tmpvar_60 = tmpvar_59;
  highp vec3 tmpvar_61;
  tmpvar_61 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_61, tmpvar_61)
  )), 0.0, 1.0);
  tmpvar_62 = tmpvar_63;
  mediump vec4 tmpvar_64;
  tmpvar_64 = ((_Color * tmpvar_38) * mix (tmpvar_60, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_62)));
  color_2 = tmpvar_64;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_65;
  tmpvar_65 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_65;
  mediump vec4 tmpvar_66;
  tmpvar_66 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_66;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexPOS;
uniform lowp sampler2D cube_MainTexNEG;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
highp int ti2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
bool tb4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp vec3 t8;
lowp vec3 t10_9;
mediump vec2 t16_10;
highp vec3 t11;
highp vec3 t12;
bool tb12;
highp vec3 t14;
mediump vec3 t16_14;
bool tb14;
mediump float t16_20;
highp vec2 t21;
bvec2 tb21;
highp vec2 t22;
highp int ti22;
highp int ti24;
bool tb31;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t11.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t11.y);
    tb12 = abs(t11.z)>=abs(t11.y);
    t12.x = tb12 ? 1.0 : float(0.0);
    t2.x = t12.x * t2.x + t11.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t11.z), abs(t11.y));
    tb2 = t2.x>=abs(t11.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t11.x;
    ti22 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti22) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t11.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t11.zyx + (-t4.xyz);
    t4.xyz = t12.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t11.xyz + t4.xyz;
    t1.xyz = t11.xyz * t16_3.xxy;
    tb31 = t16_3.y>=0.0;
    t16_0.x = (tb31) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_10.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_10.xy = t16_10.xy / abs(t1.xx);
    t16_10.xy = t16_10.xy + vec2(0.5, 0.5);
    t1.xy = t16_10.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb21.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb21.x) ? t1.x : (-t1.x);
    t1.y = (tb21.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_10.xy;
    t21.xy = t1.xy + vec2(-0.5, -0.5);
    t22.x = max(abs(t21.y), abs(t21.x));
    t21.x = min(abs(t21.y), abs(t21.x));
    t4.x = dFdx(t22.x);
    t5.x = dFdy(t22.x);
    t4.y = dFdx(t21.x);
    t5.y = dFdy(t21.x);
    t10_3 = textureGrad(cube_MainTexPOS, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexNEG, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = (-t10_1) + t10_3;
    t16_0 = t16_0.xxxx * t16_3 + t10_1;
    t16_20 = (-t16_0.x) + t16_0.z;
    t16_0.x = t12.x * t16_20 + t16_0.x;
    t16_0.x = (-t16_0.y) + t16_0.x;
    t16_1.w = t2.x * t16_0.x + t16_0.y;
    t16_1.xyz = t16_0.www;
    t16_0 = t16_1 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t12.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t4.x = vs_TEXCOORD5.z * t2.x + (-t12.y);
    tb14 = abs(t12.z)>=abs(t12.y);
    t14.x = tb14 ? 1.0 : float(0.0);
    t4.x = t14.x * t4.x + t12.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t4.x;
    t4.x = max(abs(t12.z), abs(t12.y));
    tb4 = t4.x>=abs(t12.x);
    t4.x = tb4 ? 1.0 : float(0.0);
    t2.x = t4.x * t2.x + t12.x;
    ti24 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti24) + ti2;
    t16_7.y = float(ti2);
    t16_6.y = (-t16_7.y);
    t5.xyz = t12.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t8.xyz = t16_7.xyz * t12.zyx + (-t5.xyz);
    t14.xyz = t14.xxx * t8.xyz + t5.xyz;
    t14.xyz = (-t16_7.xxy) * t12.xyz + t14.xyz;
    t2.xyz = t12.xyz * t16_7.xxy;
    t2.xyz = t4.xxx * t14.xyz + t2.xyz;
    t16_6.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_6.xy = t16_6.xy / abs(t2.xx);
    t16_6.xy = t16_6.xy + vec2(0.5, 0.5);
    t2.xy = t16_6.xy * vec2(_DetailScale);
    t22.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t2.xy;
    t4.x = max(abs(t22.y), abs(t22.x));
    t22.x = min(abs(t22.y), abs(t22.x));
    t5.x = dFdx(t4.x);
    t4.x = dFdy(t4.x);
    t5.y = dFdx(t22.x);
    t4.y = dFdy(t22.x);
    t10_1 = textureGrad(_DetailTex, t2.xy, vec4(t5.xyxx).xy, vec4(t4.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t4.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t4.x = dot(t4.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t4.x = clamp(t4.x, 0.0, 1.0);
    t16_1 = t4.xxxx * t16_2 + t10_1;
    t10_9.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_9.xyz = t10_9.xxx * t16_2.xyz;
    t10_9.xyz = clamp(t10_9.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_14.xyz = t10_9.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_14.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexPOS;
uniform  sampler2D cube_MainTexNEG;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
lowp vec4 t10_5;
vec2 t6;
vec2 t7;
vec3 t8;
int ti8;
bvec2 tb8;
vec3 t9;
int ti9;
float t12;
vec2 t13;
float t18;
int ti18;
bool tb18;
float t19;
int ti19;
bool tb19;
float t20;
bool tb20;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t18 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * vs_TEXCOORD4.yxz;
    t19 = vs_TEXCOORD4.z * t18 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t19 = t2.x * t19 + t1.y;
    t18 = (-vs_TEXCOORD4.y) * t18 + t19;
    t19 = max(abs(t1.z), abs(t1.y));
    tb19 = t19>=abs(t1.x);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.x;
    ti8 = int((0.0<t18) ? 0xFFFFFFFFu : uint(0u));
    ti18 = int((t18<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti18 = (-ti8) + ti18;
    t3.y = float(ti18);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t8.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb18 = t3.y>=0.0;
    t18 = tb18 ? 1.0 : float(0.0);
    t0.xyz = vec3(t19) * t0.xyz + t1.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb8.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb8.x) ? t1.x : (-t1.x);
    t1.y = (tb8.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t12 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t12);
    t4.x = dFdy(t12);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexPOS, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexNEG, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t18) * t16_4 + t10_3;
    t12 = (-t0.x) + t0.z;
    t0.x = t2.x * t12 + t0.x;
    t0.x = (-t0.y) + t0.x;
    t1.w = t19 * t0.x + t0.y;
    t1.xyz = t0.www;
    t0 = t1 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t2.xyz = vec3(t19) * vs_TEXCOORD5.yxz;
    t20 = vs_TEXCOORD5.z * t19 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t20 = t3.x * t20 + t2.y;
    t19 = (-vs_TEXCOORD5.y) * t19 + t20;
    t20 = max(abs(t2.z), abs(t2.y));
    tb20 = t20>=abs(t2.x);
    t20 = tb20 ? 1.0 : float(0.0);
    t19 = t20 * t19 + t2.x;
    ti9 = int((0.0<t19) ? 0xFFFFFFFFu : uint(0u));
    ti19 = int((t19<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti19 = (-ti9) + ti19;
    t4.y = float(ti19);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t9.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t9.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t20) * t1.xyz + t2.xyz;
    t7.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t7.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t13.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t13.y), abs(t13.x));
    t13.x = min(abs(t13.y), abs(t13.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t13.x);
    t2.y = dFdy(t13.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t19 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t19);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 102 math, 4 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec4 tmpvar_22;
  tmpvar_22 = mix (texture2DGradARB (cube_MainTexNEG, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexPOS, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))));
  vec4 tmpvar_23;
  tmpvar_23.x = tmpvar_22.w;
  tmpvar_23.y = tmpvar_22.w;
  tmpvar_23.z = tmpvar_22.w;
  tmpvar_23.w = mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_6), tmpvar_7);
  vec4 v_24;
  v_24 = (tmpvar_23 * alphaMask1);
  vec4 tmpvar_25;
  tmpvar_25.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_25.w = ((v_24.x + v_24.y) + (v_24.z + v_24.w));
  vec2 uv_26;
  vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_28;
  tmpvar_28 = abs(tmpvar_27);
  float tmpvar_29;
  tmpvar_29 = float((tmpvar_28.z >= tmpvar_28.x));
  float tmpvar_30;
  tmpvar_30 = float((max (tmpvar_28.x, tmpvar_28.z) >= tmpvar_28.y));
  float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_27.y, mix (tmpvar_27.x, tmpvar_27.z, tmpvar_29), tmpvar_30));
  vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(tmpvar_31);
  vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = tmpvar_31;
  vec3 tmpvar_34;
  tmpvar_34.xy = vec2(1.0, 1.0);
  tmpvar_34.z = tmpvar_31;
  vec3 tmpvar_35;
  tmpvar_35 = mix ((tmpvar_34 * tmpvar_27.yxz), mix ((tmpvar_32 * tmpvar_27.xzy), (tmpvar_33 * tmpvar_27.zxy), vec3(tmpvar_29)), vec3(tmpvar_30));
  uv_26 = (((
    (0.5 * tmpvar_35.yz)
   / 
    abs(tmpvar_35.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_36;
  vec2 tmpvar_37;
  tmpvar_37 = abs((uv_26 - (0.5 * _DetailScale)));
  uvCont_36.x = max (tmpvar_37.x, tmpvar_37.y);
  uvCont_36.y = min (tmpvar_37.x, tmpvar_37.y);
  vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_36);
  tmpvar_38.zw = dFdy(uvCont_36);
  vec3 tmpvar_39;
  tmpvar_39 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_40;
  tmpvar_40 = ((_Color * tmpvar_25) * mix (texture2DGradARB (_DetailTex, uv_26, tmpvar_38.xy, tmpvar_38.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_39, tmpvar_39)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_40.w;
  color_1.xyz = clamp ((tmpvar_40.xyz * (1.0 - tmpvar_40.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_40.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 102 math, 4 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  mediump vec2 uv_5;
  mediump vec3 detailCoords_6;
  mediump float s_7;
  mediump float nylerp_8;
  mediump float zxlerp_9;
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_9);
  s_7 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, s_7, nylerp_8));
  s_7 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16.xz = vec2(1.0, -1.0);
  tmpvar_16.y = -(s_7);
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = s_7;
  highp vec3 tmpvar_18;
  tmpvar_18 = mix ((tmpvar_16 * tmpvar_10.xzy), (tmpvar_17 * tmpvar_10.zxy), vec3(zxlerp_9));
  detailCoords_6 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = s_7;
  highp vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_10.yxz), detailCoords_6, vec3(nylerp_8));
  detailCoords_6 = tmpvar_20;
  mediump vec2 tmpvar_21;
  tmpvar_21 = (((0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + 0.5);
  uv_5 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22 = (tmpvar_21 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * vec2(_UVNoiseScale));
  highp float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  highp float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  highp vec2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  highp vec2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture2D (_UVNoiseTex, tmpvar_27);
  uv_5 = (tmpvar_21 + ((tmpvar_28.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_29;
  uv_29 = uv_5;
  highp vec2 uvCont_30;
  highp vec2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  highp vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  lowp vec4 tmpvar_33;
  tmpvar_33 = texture2DGradEXT (cube_MainTexPOS, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  lowp vec4 tmpvar_35;
  tmpvar_35 = texture2DGradEXT (cube_MainTexNEG, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  mediump vec4 tmpvar_37;
  tmpvar_37 = mix (tmpvar_36, tmpvar_34, vec4(float((s_7 >= 0.0))));
  mediump vec4 tmpvar_38;
  tmpvar_38.x = tmpvar_37.w;
  tmpvar_38.y = tmpvar_37.w;
  tmpvar_38.z = tmpvar_37.w;
  tmpvar_38.w = mix (tmpvar_37.y, mix (tmpvar_37.x, tmpvar_37.z, zxlerp_9), nylerp_8);
  mediump vec4 v_39;
  v_39 = (tmpvar_38 * alphaMask1);
  mediump vec4 tmpvar_40;
  tmpvar_40.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_40.w = ((v_39.x + v_39.y) + (v_39.z + v_39.w));
  mediump vec2 uv_41;
  mediump vec3 detailCoords_42;
  mediump float s_43;
  mediump float nylerp_44;
  mediump float zxlerp_45;
  highp vec3 tmpvar_46;
  tmpvar_46 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_47;
  tmpvar_47 = abs(tmpvar_46);
  highp float tmpvar_48;
  tmpvar_48 = float((tmpvar_47.z >= tmpvar_47.x));
  zxlerp_45 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = float((max (tmpvar_47.x, tmpvar_47.z) >= tmpvar_47.y));
  nylerp_44 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = mix (tmpvar_46.x, tmpvar_46.z, zxlerp_45);
  s_43 = tmpvar_50;
  highp float tmpvar_51;
  tmpvar_51 = sign(mix (tmpvar_46.y, s_43, nylerp_44));
  s_43 = tmpvar_51;
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = -(s_43);
  mediump vec3 tmpvar_53;
  tmpvar_53.xz = vec2(1.0, -1.0);
  tmpvar_53.y = s_43;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_52 * tmpvar_46.xzy), (tmpvar_53 * tmpvar_46.zxy), vec3(zxlerp_45));
  detailCoords_42 = tmpvar_54;
  mediump vec3 tmpvar_55;
  tmpvar_55.xy = vec2(1.0, 1.0);
  tmpvar_55.z = s_43;
  highp vec3 tmpvar_56;
  tmpvar_56 = mix ((tmpvar_55 * tmpvar_46.yxz), detailCoords_42, vec3(nylerp_44));
  detailCoords_42 = tmpvar_56;
  uv_41 = (((
    (0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_57;
  uv_57 = uv_41;
  highp vec2 uvCont_58;
  highp vec2 tmpvar_59;
  tmpvar_59 = abs((uv_57 - (0.5 * _DetailScale)));
  uvCont_58.x = max (tmpvar_59.x, tmpvar_59.y);
  uvCont_58.y = min (tmpvar_59.x, tmpvar_59.y);
  highp vec4 tmpvar_60;
  tmpvar_60.xy = dFdx(uvCont_58);
  tmpvar_60.zw = dFdy(uvCont_58);
  lowp vec4 tmpvar_61;
  tmpvar_61 = texture2DGradEXT (_DetailTex, uv_41, tmpvar_60.xy, tmpvar_60.zw);
  mediump vec4 tmpvar_62;
  tmpvar_62 = tmpvar_61;
  highp vec3 tmpvar_63;
  tmpvar_63 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_64;
  highp float tmpvar_65;
  tmpvar_65 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_63, tmpvar_63)
  )), 0.0, 1.0);
  tmpvar_64 = tmpvar_65;
  mediump vec4 tmpvar_66;
  tmpvar_66 = ((_Color * tmpvar_40) * mix (tmpvar_62, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_64)));
  color_2 = tmpvar_66;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_67;
  tmpvar_67 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_67;
  mediump vec4 tmpvar_68;
  tmpvar_68 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_68;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexPOS;
uniform lowp sampler2D cube_MainTexNEG;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec2 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
bool tb4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
lowp vec3 t10_8;
mediump vec3 t16_9;
highp vec3 t10;
highp vec3 t11;
bool tb11;
mediump vec3 t16_13;
mediump float t16_18;
highp vec2 t19;
bvec2 tb19;
highp float t20;
highp int ti20;
bool tb28;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t10.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t10.y);
    tb11 = abs(t10.z)>=abs(t10.y);
    t11.x = tb11 ? 1.0 : float(0.0);
    t2.x = t11.x * t2.x + t10.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t10.z), abs(t10.y));
    tb2 = t2.x>=abs(t10.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t10.x;
    ti20 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti20) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t10.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t10.zyx + (-t4.xyz);
    t4.xyz = t11.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t10.xyz + t4.xyz;
    t1.xyz = t10.xyz * t16_3.xxy;
    tb28 = t16_3.y>=0.0;
    t16_0.x = (tb28) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_9.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_9.xy = t16_9.xy / abs(t1.xx);
    t16_9.xy = t16_9.xy + vec2(0.5, 0.5);
    t1.xy = t16_9.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb19.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb19.x) ? t1.x : (-t1.x);
    t1.y = (tb19.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_9.xy;
    t19.xy = t1.xy + vec2(-0.5, -0.5);
    t20 = max(abs(t19.y), abs(t19.x));
    t19.x = min(abs(t19.y), abs(t19.x));
    t4.x = dFdx(t20);
    t5.x = dFdy(t20);
    t4.y = dFdx(t19.x);
    t5.y = dFdy(t19.x);
    t10_3 = textureGrad(cube_MainTexPOS, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexNEG, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = (-t10_1) + t10_3;
    t16_0 = t16_0.xxxx * t16_3 + t10_1;
    t16_18 = (-t16_0.x) + t16_0.z;
    t16_0.x = t11.x * t16_18 + t16_0.x;
    t16_0.x = (-t16_0.y) + t16_0.x;
    t16_0.x = t2.x * t16_0.x + t16_0.y;
    t16_9.xyz = t16_0.www;
    t16_9.xy = t16_9.xy * alphaMask1.xy;
    t16_9.x = t16_9.y + t16_9.x;
    t16_9.x = t16_9.z * alphaMask1.z + t16_9.x;
    t16_0.w = t16_0.x * alphaMask1.w + t16_9.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t10.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t10.y);
    tb11 = abs(t10.z)>=abs(t10.y);
    t11.x = tb11 ? 1.0 : float(0.0);
    t2.x = t11.x * t2.x + t10.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t10.z), abs(t10.y));
    tb2 = t2.x>=abs(t10.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t10.x;
    ti20 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti20) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t4.xyz = t10.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t5.xyz = t16_7.xyz * t10.zyx + (-t4.xyz);
    t11.xyz = t11.xxx * t5.xyz + t4.xyz;
    t11.xyz = (-t16_7.xxy) * t10.xyz + t11.xyz;
    t1.xyz = t10.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t11.xyz + t1.xyz;
    t16_6.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_6.xy = t16_6.xy / abs(t1.xx);
    t16_6.xy = t16_6.xy + vec2(0.5, 0.5);
    t1.xy = t16_6.xy * vec2(_DetailScale);
    t19.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t19.y), abs(t19.x));
    t19.x = min(abs(t19.y), abs(t19.x));
    t4.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t4.y = dFdx(t19.x);
    t2.y = dFdy(t19.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t4.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t4.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t4.x = dot(t4.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t4.x = clamp(t4.x, 0.0, 1.0);
    t16_1 = t4.xxxx * t16_2 + t10_1;
    t10_8.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_8.xyz = t10_8.xxx * t16_2.xyz;
    t10_8.xyz = clamp(t10_8.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_13.xyz = t10_8.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_13.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexPOS;
uniform  sampler2D cube_MainTexNEG;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
lowp vec4 t10_5;
vec3 t6;
vec2 t7;
vec3 t8;
int ti8;
bvec2 tb8;
vec3 t9;
int ti9;
float t12;
vec2 t13;
float t18;
int ti18;
bool tb18;
float t19;
int ti19;
bool tb19;
float t20;
bool tb20;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t18 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * vs_TEXCOORD4.yxz;
    t19 = vs_TEXCOORD4.z * t18 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t19 = t2.x * t19 + t1.y;
    t18 = (-vs_TEXCOORD4.y) * t18 + t19;
    t19 = max(abs(t1.z), abs(t1.y));
    tb19 = t19>=abs(t1.x);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.x;
    ti8 = int((0.0<t18) ? 0xFFFFFFFFu : uint(0u));
    ti18 = int((t18<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti18 = (-ti8) + ti18;
    t3.y = float(ti18);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t8.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb18 = t3.y>=0.0;
    t18 = tb18 ? 1.0 : float(0.0);
    t0.xyz = vec3(t19) * t0.xyz + t1.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb8.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb8.x) ? t1.x : (-t1.x);
    t1.y = (tb8.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t12 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t12);
    t4.x = dFdy(t12);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexPOS, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexNEG, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t18) * t16_4 + t10_3;
    t12 = (-t0.x) + t0.z;
    t0.x = t2.x * t12 + t0.x;
    t0.x = (-t0.y) + t0.x;
    t0.x = t19 * t0.x + t0.y;
    t6.xyz = t0.www;
    t6.xy = t6.xy * alphaMask1.xy;
    t6.x = t6.y + t6.x;
    t6.x = t6.z * alphaMask1.z + t6.x;
    t0.w = t0.x * alphaMask1.w + t6.x;
    t0.xyz = vec3(1.0, 1.0, 1.0);
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t2.xyz = vec3(t19) * vs_TEXCOORD5.yxz;
    t20 = vs_TEXCOORD5.z * t19 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t20 = t3.x * t20 + t2.y;
    t19 = (-vs_TEXCOORD5.y) * t19 + t20;
    t20 = max(abs(t2.z), abs(t2.y));
    tb20 = t20>=abs(t2.x);
    t20 = tb20 ? 1.0 : float(0.0);
    t19 = t20 * t19 + t2.x;
    ti9 = int((0.0<t19) ? 0xFFFFFFFFu : uint(0u));
    ti19 = int((t19<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti19 = (-ti9) + ti19;
    t4.y = float(ti19);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t9.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t9.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t20) * t1.xyz + t2.xyz;
    t7.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t7.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t13.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t13.y), abs(t13.x));
    t13.x = min(abs(t13.y), abs(t13.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t13.x);
    t2.y = dFdy(t13.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t19 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t19);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 103 math, 8 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec2 uv_22;
  vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_23.yxz), mix ((tmpvar_28 * tmpvar_23.xzy), (tmpvar_29 * tmpvar_23.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_22 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  tmpvar_33 = abs((uv_22 - (0.5 * _DetailScale)));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_34;
  tmpvar_34.xy = dFdx(uvCont_32);
  tmpvar_34.zw = dFdy(uvCont_32);
  vec3 tmpvar_35;
  tmpvar_35 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_36;
  tmpvar_36 = ((_Color * mix (
    mix (texture2DGradARB (cube_MainTexyn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexyp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))))
  , 
    mix (mix (texture2DGradARB (cube_MainTexxn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexxp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0)))), mix (texture2DGradARB (cube_MainTexzn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexzp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0)))), vec4(tmpvar_6))
  , vec4(tmpvar_7))) * mix (texture2DGradARB (_DetailTex, uv_22, tmpvar_34.xy, tmpvar_34.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_35, tmpvar_35)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_36.w;
  color_1.xyz = clamp ((tmpvar_36.xyz * (1.0 - tmpvar_36.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_36.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 103 math, 8 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  mediump vec2 uv_5;
  mediump vec3 detailCoords_6;
  mediump float s_7;
  mediump float nylerp_8;
  mediump float zxlerp_9;
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_9);
  s_7 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, s_7, nylerp_8));
  s_7 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16.xz = vec2(1.0, -1.0);
  tmpvar_16.y = -(s_7);
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = s_7;
  highp vec3 tmpvar_18;
  tmpvar_18 = mix ((tmpvar_16 * tmpvar_10.xzy), (tmpvar_17 * tmpvar_10.zxy), vec3(zxlerp_9));
  detailCoords_6 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = s_7;
  highp vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_10.yxz), detailCoords_6, vec3(nylerp_8));
  detailCoords_6 = tmpvar_20;
  mediump vec2 tmpvar_21;
  tmpvar_21 = (((0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + 0.5);
  uv_5 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22 = (tmpvar_21 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * vec2(_UVNoiseScale));
  highp float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  highp float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  highp vec2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  highp vec2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture2D (_UVNoiseTex, tmpvar_27);
  uv_5 = (tmpvar_21 + ((tmpvar_28.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_29;
  uv_29 = uv_5;
  highp vec2 uvCont_30;
  highp vec2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  highp vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  lowp vec4 tmpvar_33;
  tmpvar_33 = texture2DGradEXT (cube_MainTexxn, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  lowp vec4 tmpvar_35;
  tmpvar_35 = texture2DGradEXT (cube_MainTexxp, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture2DGradEXT (cube_MainTexyn, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_38;
  tmpvar_38 = tmpvar_37;
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (cube_MainTexyp, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (cube_MainTexzn, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (cube_MainTexzp, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  mediump vec2 uv_45;
  mediump vec3 detailCoords_46;
  mediump float s_47;
  mediump float nylerp_48;
  mediump float zxlerp_49;
  highp vec3 tmpvar_50;
  tmpvar_50 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_51;
  tmpvar_51 = abs(tmpvar_50);
  highp float tmpvar_52;
  tmpvar_52 = float((tmpvar_51.z >= tmpvar_51.x));
  zxlerp_49 = tmpvar_52;
  highp float tmpvar_53;
  tmpvar_53 = float((max (tmpvar_51.x, tmpvar_51.z) >= tmpvar_51.y));
  nylerp_48 = tmpvar_53;
  highp float tmpvar_54;
  tmpvar_54 = mix (tmpvar_50.x, tmpvar_50.z, zxlerp_49);
  s_47 = tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = sign(mix (tmpvar_50.y, s_47, nylerp_48));
  s_47 = tmpvar_55;
  mediump vec3 tmpvar_56;
  tmpvar_56.xz = vec2(1.0, -1.0);
  tmpvar_56.y = -(s_47);
  mediump vec3 tmpvar_57;
  tmpvar_57.xz = vec2(1.0, -1.0);
  tmpvar_57.y = s_47;
  highp vec3 tmpvar_58;
  tmpvar_58 = mix ((tmpvar_56 * tmpvar_50.xzy), (tmpvar_57 * tmpvar_50.zxy), vec3(zxlerp_49));
  detailCoords_46 = tmpvar_58;
  mediump vec3 tmpvar_59;
  tmpvar_59.xy = vec2(1.0, 1.0);
  tmpvar_59.z = s_47;
  highp vec3 tmpvar_60;
  tmpvar_60 = mix ((tmpvar_59 * tmpvar_50.yxz), detailCoords_46, vec3(nylerp_48));
  detailCoords_46 = tmpvar_60;
  uv_45 = (((
    (0.5 * detailCoords_46.yz)
   / 
    abs(detailCoords_46.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_61;
  uv_61 = uv_45;
  highp vec2 uvCont_62;
  highp vec2 tmpvar_63;
  tmpvar_63 = abs((uv_61 - (0.5 * _DetailScale)));
  uvCont_62.x = max (tmpvar_63.x, tmpvar_63.y);
  uvCont_62.y = min (tmpvar_63.x, tmpvar_63.y);
  highp vec4 tmpvar_64;
  tmpvar_64.xy = dFdx(uvCont_62);
  tmpvar_64.zw = dFdy(uvCont_62);
  lowp vec4 tmpvar_65;
  tmpvar_65 = texture2DGradEXT (_DetailTex, uv_45, tmpvar_64.xy, tmpvar_64.zw);
  mediump vec4 tmpvar_66;
  tmpvar_66 = tmpvar_65;
  highp vec3 tmpvar_67;
  tmpvar_67 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_67, tmpvar_67)
  )), 0.0, 1.0);
  tmpvar_68 = tmpvar_69;
  mediump vec4 tmpvar_70;
  tmpvar_70 = ((_Color * mix (
    mix (tmpvar_38, tmpvar_40, vec4(float((s_7 >= 0.0))))
  , 
    mix (mix (tmpvar_34, tmpvar_36, vec4(float((s_7 >= 0.0)))), mix (tmpvar_42, tmpvar_44, vec4(float((s_7 >= 0.0)))), vec4(zxlerp_9))
  , vec4(nylerp_8))) * mix (tmpvar_66, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_68)));
  color_2 = tmpvar_70;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_71;
  tmpvar_71 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_71;
  mediump vec4 tmpvar_72;
  tmpvar_72 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_72;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexxn;
uniform lowp sampler2D cube_MainTexxp;
uniform lowp sampler2D cube_MainTexyn;
uniform lowp sampler2D cube_MainTexyp;
uniform lowp sampler2D cube_MainTexzn;
uniform lowp sampler2D cube_MainTexzp;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
highp int ti2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
mediump vec4 t16_4;
highp vec3 t5;
bool tb5;
mediump vec4 t16_6;
lowp vec4 t10_6;
highp vec3 t7;
lowp vec4 t10_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
lowp vec3 t10_11;
mediump vec2 t16_12;
highp vec3 t13;
highp vec3 t14;
bool tb14;
highp vec3 t17;
mediump vec3 t16_17;
bool tb17;
highp vec2 t25;
bvec2 tb25;
highp vec2 t26;
highp int ti26;
highp int ti29;
bool tb37;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t13.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t13.y);
    tb14 = abs(t13.z)>=abs(t13.y);
    t14.x = tb14 ? 1.0 : float(0.0);
    t2.x = t14.x * t2.x + t13.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t13.z), abs(t13.y));
    tb2 = t2.x>=abs(t13.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t13.x;
    ti26 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti26) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t13.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t13.zyx + (-t4.xyz);
    t4.xyz = t14.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t13.xyz + t4.xyz;
    t1.xyz = t13.xyz * t16_3.xxy;
    tb37 = t16_3.y>=0.0;
    t16_0.x = (tb37) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_12.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_12.xy = t16_12.xy / abs(t1.xx);
    t16_12.xy = t16_12.xy + vec2(0.5, 0.5);
    t1.xy = t16_12.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb25.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb25.x) ? t1.x : (-t1.x);
    t1.y = (tb25.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_12.xy;
    t25.xy = t1.xy + vec2(-0.5, -0.5);
    t26.x = max(abs(t25.y), abs(t25.x));
    t25.x = min(abs(t25.y), abs(t25.x));
    t4.x = dFdx(t26.x);
    t5.x = dFdy(t26.x);
    t4.y = dFdx(t25.x);
    t5.y = dFdy(t25.x);
    t10_3 = textureGrad(cube_MainTexzp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = t10_3 + (-t10_6);
    t16_3 = t16_0.xxxx * t16_3 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t16_6 = t16_0.xxxx * t16_6 + t10_7;
    t16_3 = t16_3 + (-t16_6);
    t16_3 = t14.xxxx * t16_3 + t16_6;
    t10_6 = textureGrad(cube_MainTexyp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexyn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_4 = (-t10_1) + t10_6;
    t16_0 = t16_0.xxxx * t16_4 + t10_1;
    t16_1 = (-t16_0) + t16_3;
    t16_0 = t2.xxxx * t16_1 + t16_0;
    t16_0 = t16_0 * _Color;
    t16_8.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t14.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t5.x = vs_TEXCOORD5.z * t2.x + (-t14.y);
    tb17 = abs(t14.z)>=abs(t14.y);
    t17.x = tb17 ? 1.0 : float(0.0);
    t5.x = t17.x * t5.x + t14.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t5.x;
    t5.x = max(abs(t14.z), abs(t14.y));
    tb5 = t5.x>=abs(t14.x);
    t5.x = tb5 ? 1.0 : float(0.0);
    t2.x = t5.x * t2.x + t14.x;
    ti29 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti29) + ti2;
    t16_9.y = float(ti2);
    t16_8.y = (-t16_9.y);
    t7.xyz = t14.yzx * t16_8.xyz;
    t16_9.xz = vec2(1.0, -1.0);
    t10.xyz = t16_9.xyz * t14.zyx + (-t7.xyz);
    t17.xyz = t17.xxx * t10.xyz + t7.xyz;
    t17.xyz = (-t16_9.xxy) * t14.xyz + t17.xyz;
    t2.xyz = t14.xyz * t16_9.xxy;
    t2.xyz = t5.xxx * t17.xyz + t2.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(_DetailScale);
    t26.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t2.xy;
    t5.x = max(abs(t26.y), abs(t26.x));
    t26.x = min(abs(t26.y), abs(t26.x));
    t7.x = dFdx(t5.x);
    t5.x = dFdy(t5.x);
    t7.y = dFdx(t26.x);
    t5.y = dFdy(t26.x);
    t10_1 = textureGrad(_DetailTex, t2.xy, vec4(t7.xyxx).xy, vec4(t5.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_11.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_11.xyz = t10_11.xxx * t16_2.xyz;
    t10_11.xyz = clamp(t10_11.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_17.xyz = t10_11.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_17.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexxn;
uniform  sampler2D cube_MainTexxp;
uniform  sampler2D cube_MainTexyn;
uniform  sampler2D cube_MainTexyp;
uniform  sampler2D cube_MainTexzn;
uniform  sampler2D cube_MainTexzp;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec4 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
vec4 t5;
mediump vec4 t16_5;
lowp vec4 t10_5;
vec4 t6;
mediump vec4 t16_6;
lowp vec4 t10_6;
lowp vec4 t10_7;
vec2 t8;
vec2 t9;
vec3 t10;
int ti10;
bvec2 tb10;
vec3 t11;
int ti11;
float t16;
vec2 t17;
float t24;
int ti24;
bool tb24;
float t25;
int ti25;
bool tb25;
float t26;
bool tb26;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t24 = inversesqrt(t24);
    t1.xyz = vec3(t24) * vs_TEXCOORD4.yxz;
    t25 = vs_TEXCOORD4.z * t24 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t25 = t2.x * t25 + t1.y;
    t24 = (-vs_TEXCOORD4.y) * t24 + t25;
    t25 = max(abs(t1.z), abs(t1.y));
    tb25 = t25>=abs(t1.x);
    t25 = tb25 ? 1.0 : float(0.0);
    t24 = t25 * t24 + t1.x;
    ti10 = int((0.0<t24) ? 0xFFFFFFFFu : uint(0u));
    ti24 = int((t24<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti24 = (-ti10) + ti24;
    t3.y = float(ti24);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t10.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t10.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb24 = t3.y>=0.0;
    t24 = tb24 ? 1.0 : float(0.0);
    t0.xyz = vec3(t25) * t0.xyz + t1.xyz;
    t8.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t8.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb10.x) ? t1.x : (-t1.x);
    t1.y = (tb10.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t16 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t16);
    t4.x = dFdy(t16);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexzp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_5 = t10_5 + (-t10_6);
    t5 = vec4(t24) * t16_5 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t6 = vec4(t24) * t16_6 + t10_7;
    t5 = t5 + (-t6);
    t2 = t2.xxxx * t5 + t6;
    t10_5 = textureGrad(cube_MainTexyp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexyn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t24) * t16_4 + t10_3;
    t2 = (-t0) + t2;
    t0 = vec4(t25) * t2 + t0;
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t25 = inversesqrt(t25);
    t2.xyz = vec3(t25) * vs_TEXCOORD5.yxz;
    t26 = vs_TEXCOORD5.z * t25 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t26 = t3.x * t26 + t2.y;
    t25 = (-vs_TEXCOORD5.y) * t25 + t26;
    t26 = max(abs(t2.z), abs(t2.y));
    tb26 = t26>=abs(t2.x);
    t26 = tb26 ? 1.0 : float(0.0);
    t25 = t26 * t25 + t2.x;
    ti11 = int((0.0<t25) ? 0xFFFFFFFFu : uint(0u));
    ti25 = int((t25<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti25 = (-ti11) + ti25;
    t4.y = float(ti25);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t11.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t11.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t26) * t1.xyz + t2.xyz;
    t9.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t9.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t25 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t25);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 108 math, 8 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec3 tmpvar_2;
  tmpvar_2 = -(gl_Vertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (gl_Vertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * gl_Vertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float tmpvar_2;
  tmpvar_2 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec4 v_22;
  v_22 = (mix (mix (texture2DGradARB (cube_MainTexyn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexyp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(
    float((tmpvar_8 >= 0.0))
  )), mix (
    mix (texture2DGradARB (cube_MainTexxn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexxp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))))
  , 
    mix (texture2DGradARB (cube_MainTexzn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexzp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))))
  , vec4(tmpvar_6)), vec4(tmpvar_7)) * alphaMask1);
  vec4 tmpvar_23;
  tmpvar_23.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_23.w = ((v_22.x + v_22.y) + (v_22.z + v_22.w));
  vec2 uv_24;
  vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_25);
  float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_25.y, mix (tmpvar_25.x, tmpvar_25.z, tmpvar_27), tmpvar_28));
  vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(tmpvar_29);
  vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = tmpvar_29;
  vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = tmpvar_29;
  vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_25.yxz), mix ((tmpvar_30 * tmpvar_25.xzy), (tmpvar_31 * tmpvar_25.zxy), vec3(tmpvar_27)), vec3(tmpvar_28));
  uv_24 = (((
    (0.5 * tmpvar_33.yz)
   / 
    abs(tmpvar_33.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_34;
  vec2 tmpvar_35;
  tmpvar_35 = abs((uv_24 - (0.5 * _DetailScale)));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  vec4 tmpvar_36;
  tmpvar_36.xy = dFdx(uvCont_34);
  tmpvar_36.zw = dFdy(uvCont_34);
  vec3 tmpvar_37;
  tmpvar_37 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_38;
  tmpvar_38 = ((_Color * tmpvar_23) * mix (texture2DGradARB (_DetailTex, uv_24, tmpvar_36.xy, tmpvar_36.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_37, tmpvar_37)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_38.w;
  color_1.xyz = clamp ((tmpvar_38.xyz * (1.0 - tmpvar_38.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_38.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, tmpvar_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 51 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c21, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 o4.x, c4, v0
dp4 o4.y, c5, v0
dp4 o4.z, c6, v0
dp4 o4.w, c7, v0
dp3 r0.x, -v0, -v0
rsq r0.y, r0.x
mul r1.xyz, r0.y, -v0
rcp r0.y, r0.y
dp3 r0.z, r1, c19
mul_sat r0.z, r0.z, c21.x
sge r0.w, c20.x, r0.y
mov o3.x, r0.y
mul o2.x, r0.z, r0.w
dp3 r0.y, -v0, -c19
mad r0.z, r0.y, -r0.y, r0.x
rsq r0.z, r0.z
rcp r0.z, r0.z
mad r0.x, r0.z, -r0.z, r0.x
mul r0.z, r0.z, r0.z
mad r0.z, c20.x, c20.x, -r0.z
rsq r0.z, r0.z
rcp r0.z, r0.z
rsq r0.x, r0.x
rcp r0.x, r0.x
add r0.x, -r0.x, r0.z
add r1.x, -r0.z, r0.y
add r0.z, r0.z, r0.y
sge r0.y, r0.y, c21.y
lrp r1.y, r0.y, r0.z, r0.x
lrp r2.x, r0.y, r1.x, r0.x
lrp r3.x, r0.w, r1.y, r2.x
mad r0, -c19, r3.x, v0
dp4 r1.w, c11, r0
dp4 r1.x, c8, r0
dp4 r1.y, c9, r0
dp4 r1.z, c10, r0
dp4 o6.x, c16, r1
dp4 o6.y, c17, r1
dp4 o6.z, c18, r1
mov o5.xyz, r1

"
}
SubProgram "d3d11 " {
// Stats: 48 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 108 math, 8 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec3 tmpvar_2;
  tmpvar_2 = -(_glesVertex.xyz);
  highp float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  highp float tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5 = -(_SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  highp float tmpvar_6;
  highp float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  highp float tmpvar_9;
  tmpvar_9 = sqrt(((_Radius * _Radius) - tmpvar_6));
  planetPos_1 = (_MainRotation * (_glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_Radius >= tmpvar_3)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_3;
  xlv_TEXCOORD3 = (_Object2World * _glesVertex);
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  mediump vec2 uv_5;
  mediump vec3 detailCoords_6;
  mediump float s_7;
  mediump float nylerp_8;
  mediump float zxlerp_9;
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_9);
  s_7 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, s_7, nylerp_8));
  s_7 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16.xz = vec2(1.0, -1.0);
  tmpvar_16.y = -(s_7);
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = s_7;
  highp vec3 tmpvar_18;
  tmpvar_18 = mix ((tmpvar_16 * tmpvar_10.xzy), (tmpvar_17 * tmpvar_10.zxy), vec3(zxlerp_9));
  detailCoords_6 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = s_7;
  highp vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_10.yxz), detailCoords_6, vec3(nylerp_8));
  detailCoords_6 = tmpvar_20;
  mediump vec2 tmpvar_21;
  tmpvar_21 = (((0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + 0.5);
  uv_5 = tmpvar_21;
  highp vec2 tmpvar_22;
  tmpvar_22 = (tmpvar_21 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * vec2(_UVNoiseScale));
  highp float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  highp float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  highp vec2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  highp vec2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture2D (_UVNoiseTex, tmpvar_27);
  uv_5 = (tmpvar_21 + ((tmpvar_28.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_29;
  uv_29 = uv_5;
  highp vec2 uvCont_30;
  highp vec2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  highp vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  lowp vec4 tmpvar_33;
  tmpvar_33 = texture2DGradEXT (cube_MainTexxn, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  lowp vec4 tmpvar_35;
  tmpvar_35 = texture2DGradEXT (cube_MainTexxp, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  lowp vec4 tmpvar_37;
  tmpvar_37 = texture2DGradEXT (cube_MainTexyn, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_38;
  tmpvar_38 = tmpvar_37;
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (cube_MainTexyp, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  lowp vec4 tmpvar_41;
  tmpvar_41 = texture2DGradEXT (cube_MainTexzn, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (cube_MainTexzp, uv_5, tmpvar_32.xy, tmpvar_32.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  mediump vec4 v_45;
  v_45 = (mix (mix (tmpvar_38, tmpvar_40, vec4(
    float((s_7 >= 0.0))
  )), mix (
    mix (tmpvar_34, tmpvar_36, vec4(float((s_7 >= 0.0))))
  , 
    mix (tmpvar_42, tmpvar_44, vec4(float((s_7 >= 0.0))))
  , vec4(zxlerp_9)), vec4(nylerp_8)) * alphaMask1);
  mediump vec4 tmpvar_46;
  tmpvar_46.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_46.w = ((v_45.x + v_45.y) + (v_45.z + v_45.w));
  mediump vec2 uv_47;
  mediump vec3 detailCoords_48;
  mediump float s_49;
  mediump float nylerp_50;
  mediump float zxlerp_51;
  highp vec3 tmpvar_52;
  tmpvar_52 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_53;
  tmpvar_53 = abs(tmpvar_52);
  highp float tmpvar_54;
  tmpvar_54 = float((tmpvar_53.z >= tmpvar_53.x));
  zxlerp_51 = tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = float((max (tmpvar_53.x, tmpvar_53.z) >= tmpvar_53.y));
  nylerp_50 = tmpvar_55;
  highp float tmpvar_56;
  tmpvar_56 = mix (tmpvar_52.x, tmpvar_52.z, zxlerp_51);
  s_49 = tmpvar_56;
  highp float tmpvar_57;
  tmpvar_57 = sign(mix (tmpvar_52.y, s_49, nylerp_50));
  s_49 = tmpvar_57;
  mediump vec3 tmpvar_58;
  tmpvar_58.xz = vec2(1.0, -1.0);
  tmpvar_58.y = -(s_49);
  mediump vec3 tmpvar_59;
  tmpvar_59.xz = vec2(1.0, -1.0);
  tmpvar_59.y = s_49;
  highp vec3 tmpvar_60;
  tmpvar_60 = mix ((tmpvar_58 * tmpvar_52.xzy), (tmpvar_59 * tmpvar_52.zxy), vec3(zxlerp_51));
  detailCoords_48 = tmpvar_60;
  mediump vec3 tmpvar_61;
  tmpvar_61.xy = vec2(1.0, 1.0);
  tmpvar_61.z = s_49;
  highp vec3 tmpvar_62;
  tmpvar_62 = mix ((tmpvar_61 * tmpvar_52.yxz), detailCoords_48, vec3(nylerp_50));
  detailCoords_48 = tmpvar_62;
  uv_47 = (((
    (0.5 * detailCoords_48.yz)
   / 
    abs(detailCoords_48.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_63;
  uv_63 = uv_47;
  highp vec2 uvCont_64;
  highp vec2 tmpvar_65;
  tmpvar_65 = abs((uv_63 - (0.5 * _DetailScale)));
  uvCont_64.x = max (tmpvar_65.x, tmpvar_65.y);
  uvCont_64.y = min (tmpvar_65.x, tmpvar_65.y);
  highp vec4 tmpvar_66;
  tmpvar_66.xy = dFdx(uvCont_64);
  tmpvar_66.zw = dFdy(uvCont_64);
  lowp vec4 tmpvar_67;
  tmpvar_67 = texture2DGradEXT (_DetailTex, uv_47, tmpvar_66.xy, tmpvar_66.zw);
  mediump vec4 tmpvar_68;
  tmpvar_68 = tmpvar_67;
  highp vec3 tmpvar_69;
  tmpvar_69 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_70;
  highp float tmpvar_71;
  tmpvar_71 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_69, tmpvar_69)
  )), 0.0, 1.0);
  tmpvar_70 = tmpvar_71;
  mediump vec4 tmpvar_72;
  tmpvar_72 = ((_Color * tmpvar_46) * mix (tmpvar_68, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_70)));
  color_2 = tmpvar_72;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_73;
  tmpvar_73 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_73;
  mediump vec4 tmpvar_74;
  tmpvar_74 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_74;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
bool tb2;
highp float t4;
highp float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexxn;
uniform lowp sampler2D cube_MainTexxp;
uniform lowp sampler2D cube_MainTexyn;
uniform lowp sampler2D cube_MainTexyp;
uniform lowp sampler2D cube_MainTexzn;
uniform lowp sampler2D cube_MainTexzp;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
highp int ti2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
mediump vec4 t16_4;
highp vec3 t5;
bool tb5;
mediump vec4 t16_6;
lowp vec4 t10_6;
highp vec3 t7;
lowp vec4 t10_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
lowp vec3 t10_11;
mediump vec2 t16_12;
highp vec3 t13;
highp vec3 t14;
bool tb14;
highp vec3 t17;
mediump vec3 t16_17;
bool tb17;
highp vec2 t25;
bvec2 tb25;
highp vec2 t26;
highp int ti26;
highp int ti29;
bool tb37;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t13.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t13.y);
    tb14 = abs(t13.z)>=abs(t13.y);
    t14.x = tb14 ? 1.0 : float(0.0);
    t2.x = t14.x * t2.x + t13.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t13.z), abs(t13.y));
    tb2 = t2.x>=abs(t13.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t13.x;
    ti26 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti26) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t13.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t13.zyx + (-t4.xyz);
    t4.xyz = t14.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t13.xyz + t4.xyz;
    t1.xyz = t13.xyz * t16_3.xxy;
    tb37 = t16_3.y>=0.0;
    t16_0.x = (tb37) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_12.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_12.xy = t16_12.xy / abs(t1.xx);
    t16_12.xy = t16_12.xy + vec2(0.5, 0.5);
    t1.xy = t16_12.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb25.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb25.x) ? t1.x : (-t1.x);
    t1.y = (tb25.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_12.xy;
    t25.xy = t1.xy + vec2(-0.5, -0.5);
    t26.x = max(abs(t25.y), abs(t25.x));
    t25.x = min(abs(t25.y), abs(t25.x));
    t4.x = dFdx(t26.x);
    t5.x = dFdy(t26.x);
    t4.y = dFdx(t25.x);
    t5.y = dFdy(t25.x);
    t10_3 = textureGrad(cube_MainTexzp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = t10_3 + (-t10_6);
    t16_3 = t16_0.xxxx * t16_3 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t16_6 = t16_0.xxxx * t16_6 + t10_7;
    t16_3 = t16_3 + (-t16_6);
    t16_3 = t14.xxxx * t16_3 + t16_6;
    t10_6 = textureGrad(cube_MainTexyp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexyn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_4 = (-t10_1) + t10_6;
    t16_0 = t16_0.xxxx * t16_4 + t10_1;
    t16_1 = (-t16_0) + t16_3;
    t16_0 = t2.xxxx * t16_1 + t16_0;
    t16_0.xy = t16_0.xy * alphaMask1.xy;
    t16_0.x = t16_0.y + t16_0.x;
    t16_0.x = t16_0.z * alphaMask1.z + t16_0.x;
    t16_0.w = t16_0.w * alphaMask1.w + t16_0.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_8.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t14.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t5.x = vs_TEXCOORD5.z * t2.x + (-t14.y);
    tb17 = abs(t14.z)>=abs(t14.y);
    t17.x = tb17 ? 1.0 : float(0.0);
    t5.x = t17.x * t5.x + t14.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t5.x;
    t5.x = max(abs(t14.z), abs(t14.y));
    tb5 = t5.x>=abs(t14.x);
    t5.x = tb5 ? 1.0 : float(0.0);
    t2.x = t5.x * t2.x + t14.x;
    ti29 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti29) + ti2;
    t16_9.y = float(ti2);
    t16_8.y = (-t16_9.y);
    t7.xyz = t14.yzx * t16_8.xyz;
    t16_9.xz = vec2(1.0, -1.0);
    t10.xyz = t16_9.xyz * t14.zyx + (-t7.xyz);
    t17.xyz = t17.xxx * t10.xyz + t7.xyz;
    t17.xyz = (-t16_9.xxy) * t14.xyz + t17.xyz;
    t2.xyz = t14.xyz * t16_9.xxy;
    t2.xyz = t5.xxx * t17.xyz + t2.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(_DetailScale);
    t26.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t2.xy;
    t5.x = max(abs(t26.y), abs(t26.x));
    t26.x = min(abs(t26.y), abs(t26.x));
    t7.x = dFdx(t5.x);
    t5.x = dFdy(t5.x);
    t7.y = dFdx(t26.x);
    t5.y = dFdy(t26.x);
    t10_1 = textureGrad(_DetailTex, t2.xy, vec4(t7.xyxx).xy, vec4(t5.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_11.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_11.xyz = t10_11.xxx * t16_2.xyz;
    t10_11.xyz = clamp(t10_11.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_17.xyz = t10_11.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_17.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 288 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float3 tmpvar_2;
  tmpvar_2 = -(_mtl_i._glesVertex.xyz);
  float tmpvar_3;
  tmpvar_3 = sqrt(dot (tmpvar_2, tmpvar_2));
  float tmpvar_4;
  float4 tmpvar_5;
  tmpvar_5 = -(_mtl_u._SunDir);
  tmpvar_4 = dot (tmpvar_2, tmpvar_5.xyz);
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = sqrt((dot (tmpvar_2, tmpvar_2) - (tmpvar_4 * tmpvar_4)));
  tmpvar_6 = (tmpvar_7 * tmpvar_7);
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_2, tmpvar_2) - tmpvar_6));
  float tmpvar_9;
  tmpvar_9 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_6));
  planetPos_1 = (_mtl_u._MainRotation * (_mtl_i._glesVertex + (tmpvar_5 * 
    mix (mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 - tmpvar_9), float((tmpvar_4 >= 0.0))), mix ((tmpvar_9 - tmpvar_8), (tmpvar_4 + tmpvar_9), float((tmpvar_4 >= 0.0))), float((_mtl_u._Radius >= tmpvar_3)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_3)) * clamp ((
    dot (normalize(tmpvar_2), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD3 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
vec3 t2;
bool tb2;
float t4;
float t6;
bool tb6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0.x = dot((-in_POSITION0.xyz), (-in_POSITION0.xyz));
    t2.x = inversesqrt(t0.x);
    t2.xyz = t2.xxx * (-in_POSITION0.xyz);
    t2.x = dot(t2.xyz, _SunDir.xyz);
    t2.x = t2.x * 100.0;
    t2.x = clamp(t2.x, 0.0, 1.0);
    t4 = sqrt(t0.x);
    tb6 = _Radius>=t4;
    vs_TEXCOORD2 = t4;
    t4 = tb6 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t2.x * t4;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    vs_TEXCOORD3 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2.x = dot((-in_POSITION0.xyz), (-_SunDir.xyz));
    t6 = (-t2.x) * t2.x + t0.x;
    t6 = sqrt(t6);
    t0.x = (-t6) * t6 + t0.x;
    t6 = t6 * t6;
    t0.w = _Radius * _Radius + (-t6);
    t0.xw = sqrt(t0.xw);
    t0.x = (-t0.x) + t0.w;
    t1.x = t0.w + t2.x;
    t6 = (-t0.w) + t2.x;
    tb2 = t2.x>=0.0;
    t2.x = tb2 ? 1.0 : float(0.0);
    t6 = (-t0.x) + t6;
    t6 = t2.x * t6 + t0.x;
    t1.x = (-t0.x) + t1.x;
    t0.x = t2.x * t1.x + t0.x;
    t0.x = (-t6) + t0.x;
    t0.x = t4 * t0.x + t6;
    t0 = (-_SunDir) * t0.xxxx + in_POSITION0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexxn;
uniform  sampler2D cube_MainTexxp;
uniform  sampler2D cube_MainTexyn;
uniform  sampler2D cube_MainTexyp;
uniform  sampler2D cube_MainTexzn;
uniform  sampler2D cube_MainTexzp;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec4 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
vec4 t5;
mediump vec4 t16_5;
lowp vec4 t10_5;
vec4 t6;
mediump vec4 t16_6;
lowp vec4 t10_6;
lowp vec4 t10_7;
vec2 t8;
vec2 t9;
vec3 t10;
int ti10;
bvec2 tb10;
vec3 t11;
int ti11;
float t16;
vec2 t17;
float t24;
int ti24;
bool tb24;
float t25;
int ti25;
bool tb25;
float t26;
bool tb26;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t24 = inversesqrt(t24);
    t1.xyz = vec3(t24) * vs_TEXCOORD4.yxz;
    t25 = vs_TEXCOORD4.z * t24 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t25 = t2.x * t25 + t1.y;
    t24 = (-vs_TEXCOORD4.y) * t24 + t25;
    t25 = max(abs(t1.z), abs(t1.y));
    tb25 = t25>=abs(t1.x);
    t25 = tb25 ? 1.0 : float(0.0);
    t24 = t25 * t24 + t1.x;
    ti10 = int((0.0<t24) ? 0xFFFFFFFFu : uint(0u));
    ti24 = int((t24<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti24 = (-ti10) + ti24;
    t3.y = float(ti24);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t10.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t10.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb24 = t3.y>=0.0;
    t24 = tb24 ? 1.0 : float(0.0);
    t0.xyz = vec3(t25) * t0.xyz + t1.xyz;
    t8.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t8.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb10.x) ? t1.x : (-t1.x);
    t1.y = (tb10.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t16 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t16);
    t4.x = dFdy(t16);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexzp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_5 = t10_5 + (-t10_6);
    t5 = vec4(t24) * t16_5 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t6 = vec4(t24) * t16_6 + t10_7;
    t5 = t5 + (-t6);
    t2 = t2.xxxx * t5 + t6;
    t10_5 = textureGrad(cube_MainTexyp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexyn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t24) * t16_4 + t10_3;
    t2 = (-t0) + t2;
    t0 = vec4(t25) * t2 + t0;
    t0.xy = t0.xy * alphaMask1.xy;
    t0.x = t0.y + t0.x;
    t0.x = t0.z * alphaMask1.z + t0.x;
    t0.w = t0.w * alphaMask1.w + t0.x;
    t0.xyz = vec3(1.0, 1.0, 1.0);
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t25 = inversesqrt(t25);
    t2.xyz = vec3(t25) * vs_TEXCOORD5.yxz;
    t26 = vs_TEXCOORD5.z * t25 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t26 = t3.x * t26 + t2.y;
    t25 = (-vs_TEXCOORD5.y) * t25 + t26;
    t26 = max(abs(t2.z), abs(t2.y));
    tb26 = t26>=abs(t2.x);
    t26 = tb26 ? 1.0 : float(0.0);
    t25 = t26 * t25 + t2.x;
    ti11 = int((0.0<t25) ? 0xFFFFFFFFu : uint(0u));
    ti25 = int((t25<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti25 = (-ti11) + ti25;
    t4.y = float(ti25);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t11.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t11.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t26) * t1.xyz + t2.xyz;
    t9.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t9.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t25 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t25);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 133 math, 3 textures, 5 branches
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform sampler2D _MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec2 uv_5;
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = (min (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0) / max (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0));
  float tmpvar_8;
  tmpvar_8 = (tmpvar_7 * tmpvar_7);
  tmpvar_8 = (((
    ((((
      ((((-0.01213232 * tmpvar_8) + 0.05368138) * tmpvar_8) - 0.1173503)
     * tmpvar_8) + 0.1938925) * tmpvar_8) - 0.3326756)
   * tmpvar_8) + 0.9999793) * tmpvar_7);
  tmpvar_8 = (tmpvar_8 + (float(
    (abs((tmpvar_4.x / tmpvar_4.z)) > 1.0)
  ) * (
    (tmpvar_8 * -2.0)
   + 1.570796)));
  tmpvar_6 = (tmpvar_8 * sign((tmpvar_4.x / tmpvar_4.z)));
  if ((abs(tmpvar_4.z) > (1e-08 * abs(tmpvar_4.x)))) {
    if ((tmpvar_4.z < 0.0)) {
      if ((tmpvar_4.x >= 0.0)) {
        tmpvar_6 += 3.141593;
      } else {
        tmpvar_6 = (tmpvar_6 - 3.141593);
      };
    };
  } else {
    tmpvar_6 = (sign(tmpvar_4.x) * 1.570796);
  };
  uv_5.x = (0.5 + (0.1591549 * tmpvar_6));
  uv_5.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_4.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_4.y)
    )) * (1.570796 + (
      abs(tmpvar_4.y)
     * 
      (-0.2146018 + (abs(tmpvar_4.y) * (0.08656672 + (
        abs(tmpvar_4.y)
       * -0.03102955))))
    ))))
  )));
  uv_3 = uv_5;
  vec2 tmpvar_9;
  tmpvar_9 = (uv_5 / vec2(_UVNoiseScale));
  vec2 tmpvar_10;
  tmpvar_10 = (fract(abs(tmpvar_9)) * vec2(_UVNoiseScale));
  float tmpvar_11;
  if ((tmpvar_9.x >= 0.0)) {
    tmpvar_11 = tmpvar_10.x;
  } else {
    tmpvar_11 = -(tmpvar_10.x);
  };
  float tmpvar_12;
  if ((tmpvar_9.y >= 0.0)) {
    tmpvar_12 = tmpvar_10.y;
  } else {
    tmpvar_12 = -(tmpvar_10.y);
  };
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_11;
  tmpvar_13.y = tmpvar_12;
  uv_3 = (uv_5 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_13 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_14;
  uvCont_14.y = uv_3.y;
  uvCont_14.x = abs((uv_3.x - 0.5));
  vec4 tmpvar_15;
  tmpvar_15.xy = dFdx(uvCont_14);
  tmpvar_15.zw = dFdy(uvCont_14);
  vec2 uv_16;
  vec3 tmpvar_17;
  tmpvar_17 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_18;
  tmpvar_18 = abs(tmpvar_17);
  float tmpvar_19;
  tmpvar_19 = float((tmpvar_18.z >= tmpvar_18.x));
  float tmpvar_20;
  tmpvar_20 = float((max (tmpvar_18.x, tmpvar_18.z) >= tmpvar_18.y));
  float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_17.y, mix (tmpvar_17.x, tmpvar_17.z, tmpvar_19), tmpvar_20));
  vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(tmpvar_21);
  vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = tmpvar_21;
  vec3 tmpvar_24;
  tmpvar_24.xy = vec2(1.0, 1.0);
  tmpvar_24.z = tmpvar_21;
  vec3 tmpvar_25;
  tmpvar_25 = mix ((tmpvar_24 * tmpvar_17.yxz), mix ((tmpvar_22 * tmpvar_17.xzy), (tmpvar_23 * tmpvar_17.zxy), vec3(tmpvar_19)), vec3(tmpvar_20));
  uv_16 = (((
    (0.5 * tmpvar_25.yz)
   / 
    abs(tmpvar_25.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_26;
  vec2 tmpvar_27;
  tmpvar_27 = abs((uv_16 - (0.5 * _DetailScale)));
  uvCont_26.x = max (tmpvar_27.x, tmpvar_27.y);
  uvCont_26.y = min (tmpvar_27.x, tmpvar_27.y);
  vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_26);
  tmpvar_28.zw = dFdy(uvCont_26);
  vec3 tmpvar_29;
  tmpvar_29 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_30;
  tmpvar_30 = ((_Color * texture2DGradARB (_MainTex, uv_3, tmpvar_15.xy, tmpvar_15.zw)) * mix (texture2DGradARB (_DetailTex, uv_16, tmpvar_28.xy, tmpvar_28.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_29, tmpvar_29)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_30.w;
  color_1.xyz = clamp ((tmpvar_30.xyz * (1.0 - tmpvar_30.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_30.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 133 math, 3 textures, 5 branches
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform sampler2D _MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  highp vec2 uv_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD4);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  uv_6 = uv_8;
  highp vec2 tmpvar_12;
  tmpvar_12 = (uv_8 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_13;
  tmpvar_13 = (fract(abs(tmpvar_12)) * vec2(_UVNoiseScale));
  highp float tmpvar_14;
  if ((tmpvar_12.x >= 0.0)) {
    tmpvar_14 = tmpvar_13.x;
  } else {
    tmpvar_14 = -(tmpvar_13.x);
  };
  highp float tmpvar_15;
  if ((tmpvar_12.y >= 0.0)) {
    tmpvar_15 = tmpvar_13.y;
  } else {
    tmpvar_15 = -(tmpvar_13.y);
  };
  highp vec2 tmpvar_16;
  tmpvar_16.x = tmpvar_14;
  tmpvar_16.y = tmpvar_15;
  highp vec2 tmpvar_17;
  tmpvar_17 = ((tmpvar_16 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture2D (_UVNoiseTex, tmpvar_17);
  uv_6 = (uv_8 + ((tmpvar_18.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_19;
  uvCont_19.y = uv_6.y;
  uvCont_19.x = abs((uv_6.x - 0.5));
  highp vec4 tmpvar_20;
  tmpvar_20.xy = dFdx(uvCont_19);
  tmpvar_20.zw = dFdy(uvCont_19);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture2DGradEXT (_MainTex, uv_6, tmpvar_20.xy, tmpvar_20.zw);
  mediump vec4 tmpvar_22;
  tmpvar_22 = tmpvar_21;
  mediump vec2 uv_23;
  mediump vec3 detailCoords_24;
  mediump float s_25;
  mediump float nylerp_26;
  mediump float zxlerp_27;
  highp vec3 tmpvar_28;
  tmpvar_28 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_28);
  highp float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  zxlerp_27 = tmpvar_30;
  highp float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  nylerp_26 = tmpvar_31;
  highp float tmpvar_32;
  tmpvar_32 = mix (tmpvar_28.x, tmpvar_28.z, zxlerp_27);
  s_25 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = sign(mix (tmpvar_28.y, s_25, nylerp_26));
  s_25 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = -(s_25);
  mediump vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = s_25;
  highp vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_34 * tmpvar_28.xzy), (tmpvar_35 * tmpvar_28.zxy), vec3(zxlerp_27));
  detailCoords_24 = tmpvar_36;
  mediump vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = s_25;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_28.yxz), detailCoords_24, vec3(nylerp_26));
  detailCoords_24 = tmpvar_38;
  uv_23 = (((
    (0.5 * detailCoords_24.yz)
   / 
    abs(detailCoords_24.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_39;
  uv_39 = uv_23;
  highp vec2 uvCont_40;
  highp vec2 tmpvar_41;
  tmpvar_41 = abs((uv_39 - (0.5 * _DetailScale)));
  uvCont_40.x = max (tmpvar_41.x, tmpvar_41.y);
  uvCont_40.y = min (tmpvar_41.x, tmpvar_41.y);
  highp vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_40);
  tmpvar_42.zw = dFdy(uvCont_40);
  lowp vec4 tmpvar_43;
  tmpvar_43 = texture2DGradEXT (_DetailTex, uv_23, tmpvar_42.xy, tmpvar_42.zw);
  mediump vec4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  highp vec3 tmpvar_45;
  tmpvar_45 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_45, tmpvar_45)
  )), 0.0, 1.0);
  tmpvar_46 = tmpvar_47;
  mediump vec4 tmpvar_48;
  tmpvar_48 = ((_Color * tmpvar_22) * mix (tmpvar_44, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_46)));
  color_2 = tmpvar_48;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_49;
  tmpvar_49 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_49;
  mediump vec4 tmpvar_50;
  tmpvar_50 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_50;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec2 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
mediump vec3 t16_4;
highp vec3 t5;
bool tb5;
highp vec3 t6;
lowp vec3 t10_7;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t13;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t24;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = t16.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_0 = t10_0 * _Color;
    t16_3.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_4.y = float(ti1);
    t16_3.y = (-t16_4.y);
    t5.xyz = t9.yzx * t16_3.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t9.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_4.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_3.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_3.xy = t16_3.xy / abs(t1.xx);
    t16_3.xy = t16_3.xy + vec2(0.5, 0.5);
    t1.xy = t16_3.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t5.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t5.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t5.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_7.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_7.xyz = t10_7.xxx * t16_2.xyz;
    t10_7.xyz = clamp(t10_7.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_13.xyz = t10_7.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_13.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t13 = vs_TEXCOORD2 + 5.0;
    t13 = t13 + (-_PlanetRadius);
    t13 = t13 * 0.200000003;
    t13 = clamp(t13, 0.0, 1.0);
    t5.x = t13 * t5.x;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
int ti0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
bvec2 tb1;
vec3 t2;
mediump vec4 t16_2;
vec3 t3;
bool tb3;
vec3 t4;
vec2 t6;
vec3 t8;
int ti8;
vec2 t10;
mediump vec2 t16_10;
vec2 t11;
bool tb11;
float t15;
float t16;
int ti16;
float t17;
bool tb17;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t15 = max(abs(t0.y), abs(t0.x));
    t15 = float(1.0) / t15;
    t1.x = min(abs(t0.y), abs(t0.x));
    t15 = t15 * t1.x;
    t1.x = t15 * t15;
    t6.x = t1.x * 0.0208350997 + -0.0851330012;
    t6.x = t1.x * t6.x + 0.180141002;
    t6.x = t1.x * t6.x + -0.330299497;
    t1.x = t1.x * t6.x + 0.999866009;
    t6.x = t15 * t1.x;
    t6.x = t6.x * -2.0 + 1.57079637;
    tb11 = abs(t0.y)<abs(t0.x);
    t6.x = tb11 ? t6.x : float(0.0);
    t15 = t15 * t1.x + t6.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t15 = t15 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t15) : t15;
    t0.x = t0.x * 0.159154937 + 0.5;
    t15 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t15 = t15 * abs(t0.z) + -0.212114394;
    t15 = t15 * abs(t0.z) + 1.57072878;
    t10.x = -abs(t0.z) + 1.0;
    t10.x = sqrt(t10.x);
    t1.x = t10.x * t15;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t10.x = t15 * t10.x + t1.x;
    t0.y = t10.x * 0.318309873;
    t10.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t10.xyxx, (-t10.xyxx)).xy;
    t10.xy = fract(abs(t10.xy));
    t10.x = (tb1.x) ? t10.x : (-t10.x);
    t10.y = (tb1.x) ? t10.y : (-t10.y);
    t10.xy = t10.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = t10.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t10.xy;
    t10_1 = texture(_UVNoiseTex, t10.xy);
    t16_10.xy = t10_1.xy + vec2(-0.5, -0.5);
    t0.xy = t16_10.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t10.x = t0.x + -0.5;
    t0.z = abs(t10.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = t10_0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t16 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16 = inversesqrt(t16);
    t2.xyz = vec3(t16) * vs_TEXCOORD5.yxz;
    t17 = vs_TEXCOORD5.z * t16 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t17 = t3.x * t17 + t2.y;
    t16 = (-vs_TEXCOORD5.y) * t16 + t17;
    t17 = max(abs(t2.z), abs(t2.y));
    tb17 = t17>=abs(t2.x);
    t17 = tb17 ? 1.0 : float(0.0);
    t16 = t17 * t16 + t2.x;
    ti8 = int((0.0<t16) ? 0xFFFFFFFFu : uint(0u));
    ti16 = int((t16<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti16 = (-ti8) + ti16;
    t4.y = float(ti16);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t8.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t8.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t17) * t1.xyz + t2.xyz;
    t6.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t6.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t11.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t11.y), abs(t11.x));
    t11.x = min(abs(t11.y), abs(t11.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t11.x);
    t2.y = dFdy(t11.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t16 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t16);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1.x = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1.x ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t6.x = vs_TEXCOORD2 + 5.0;
    t6.x = t6.x + (-_PlanetRadius);
    t6.x = t6.x * 0.200000003;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t1.x = t6.x * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 138 math, 3 textures, 5 branches
Keywords { "MAP_TYPE_1" "ALPHAMAP_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec2 uv_5;
  float tmpvar_6;
  float tmpvar_7;
  tmpvar_7 = (min (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0) / max (abs(
    (tmpvar_4.x / tmpvar_4.z)
  ), 1.0));
  float tmpvar_8;
  tmpvar_8 = (tmpvar_7 * tmpvar_7);
  tmpvar_8 = (((
    ((((
      ((((-0.01213232 * tmpvar_8) + 0.05368138) * tmpvar_8) - 0.1173503)
     * tmpvar_8) + 0.1938925) * tmpvar_8) - 0.3326756)
   * tmpvar_8) + 0.9999793) * tmpvar_7);
  tmpvar_8 = (tmpvar_8 + (float(
    (abs((tmpvar_4.x / tmpvar_4.z)) > 1.0)
  ) * (
    (tmpvar_8 * -2.0)
   + 1.570796)));
  tmpvar_6 = (tmpvar_8 * sign((tmpvar_4.x / tmpvar_4.z)));
  if ((abs(tmpvar_4.z) > (1e-08 * abs(tmpvar_4.x)))) {
    if ((tmpvar_4.z < 0.0)) {
      if ((tmpvar_4.x >= 0.0)) {
        tmpvar_6 += 3.141593;
      } else {
        tmpvar_6 = (tmpvar_6 - 3.141593);
      };
    };
  } else {
    tmpvar_6 = (sign(tmpvar_4.x) * 1.570796);
  };
  uv_5.x = (0.5 + (0.1591549 * tmpvar_6));
  uv_5.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_4.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_4.y)
    )) * (1.570796 + (
      abs(tmpvar_4.y)
     * 
      (-0.2146018 + (abs(tmpvar_4.y) * (0.08656672 + (
        abs(tmpvar_4.y)
       * -0.03102955))))
    ))))
  )));
  uv_3 = uv_5;
  vec2 tmpvar_9;
  tmpvar_9 = (uv_5 / vec2(_UVNoiseScale));
  vec2 tmpvar_10;
  tmpvar_10 = (fract(abs(tmpvar_9)) * vec2(_UVNoiseScale));
  float tmpvar_11;
  if ((tmpvar_9.x >= 0.0)) {
    tmpvar_11 = tmpvar_10.x;
  } else {
    tmpvar_11 = -(tmpvar_10.x);
  };
  float tmpvar_12;
  if ((tmpvar_9.y >= 0.0)) {
    tmpvar_12 = tmpvar_10.y;
  } else {
    tmpvar_12 = -(tmpvar_10.y);
  };
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_11;
  tmpvar_13.y = tmpvar_12;
  uv_3 = (uv_5 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_13 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_14;
  uvCont_14.y = uv_3.y;
  uvCont_14.x = abs((uv_3.x - 0.5));
  vec4 tmpvar_15;
  tmpvar_15.xy = dFdx(uvCont_14);
  tmpvar_15.zw = dFdy(uvCont_14);
  vec4 v_16;
  v_16 = (texture2DGradARB (_MainTex, uv_3, tmpvar_15.xy, tmpvar_15.zw) * alphaMask1);
  vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  vec2 uv_18;
  vec3 tmpvar_19;
  tmpvar_19 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_20;
  tmpvar_20 = abs(tmpvar_19);
  float tmpvar_21;
  tmpvar_21 = float((tmpvar_20.z >= tmpvar_20.x));
  float tmpvar_22;
  tmpvar_22 = float((max (tmpvar_20.x, tmpvar_20.z) >= tmpvar_20.y));
  float tmpvar_23;
  tmpvar_23 = sign(mix (tmpvar_19.y, mix (tmpvar_19.x, tmpvar_19.z, tmpvar_21), tmpvar_22));
  vec3 tmpvar_24;
  tmpvar_24.xz = vec2(1.0, -1.0);
  tmpvar_24.y = -(tmpvar_23);
  vec3 tmpvar_25;
  tmpvar_25.xz = vec2(1.0, -1.0);
  tmpvar_25.y = tmpvar_23;
  vec3 tmpvar_26;
  tmpvar_26.xy = vec2(1.0, 1.0);
  tmpvar_26.z = tmpvar_23;
  vec3 tmpvar_27;
  tmpvar_27 = mix ((tmpvar_26 * tmpvar_19.yxz), mix ((tmpvar_24 * tmpvar_19.xzy), (tmpvar_25 * tmpvar_19.zxy), vec3(tmpvar_21)), vec3(tmpvar_22));
  uv_18 = (((
    (0.5 * tmpvar_27.yz)
   / 
    abs(tmpvar_27.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_28;
  vec2 tmpvar_29;
  tmpvar_29 = abs((uv_18 - (0.5 * _DetailScale)));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  vec4 tmpvar_30;
  tmpvar_30.xy = dFdx(uvCont_28);
  tmpvar_30.zw = dFdy(uvCont_28);
  vec3 tmpvar_31;
  tmpvar_31 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_32;
  tmpvar_32 = ((_Color * tmpvar_17) * mix (texture2DGradARB (_DetailTex, uv_18, tmpvar_30.xy, tmpvar_30.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_31, tmpvar_31)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_32.w;
  color_1.xyz = clamp ((tmpvar_32.xyz * (1.0 - tmpvar_32.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_32.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "MAP_TYPE_1" "ALPHAMAP_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "MAP_TYPE_1" "ALPHAMAP_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 138 math, 3 textures, 5 branches
Keywords { "MAP_TYPE_1" "ALPHAMAP_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D _MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  highp vec2 uv_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD4);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  uv_6 = uv_8;
  highp vec2 tmpvar_12;
  tmpvar_12 = (uv_8 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_13;
  tmpvar_13 = (fract(abs(tmpvar_12)) * vec2(_UVNoiseScale));
  highp float tmpvar_14;
  if ((tmpvar_12.x >= 0.0)) {
    tmpvar_14 = tmpvar_13.x;
  } else {
    tmpvar_14 = -(tmpvar_13.x);
  };
  highp float tmpvar_15;
  if ((tmpvar_12.y >= 0.0)) {
    tmpvar_15 = tmpvar_13.y;
  } else {
    tmpvar_15 = -(tmpvar_13.y);
  };
  highp vec2 tmpvar_16;
  tmpvar_16.x = tmpvar_14;
  tmpvar_16.y = tmpvar_15;
  highp vec2 tmpvar_17;
  tmpvar_17 = ((tmpvar_16 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_18;
  tmpvar_18 = texture2D (_UVNoiseTex, tmpvar_17);
  uv_6 = (uv_8 + ((tmpvar_18.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uvCont_19;
  uvCont_19.y = uv_6.y;
  uvCont_19.x = abs((uv_6.x - 0.5));
  highp vec4 tmpvar_20;
  tmpvar_20.xy = dFdx(uvCont_19);
  tmpvar_20.zw = dFdy(uvCont_19);
  lowp vec4 tmpvar_21;
  tmpvar_21 = texture2DGradEXT (_MainTex, uv_6, tmpvar_20.xy, tmpvar_20.zw);
  mediump vec4 tmpvar_22;
  tmpvar_22 = tmpvar_21;
  mediump vec4 v_23;
  v_23 = (tmpvar_22 * alphaMask1);
  mediump vec4 tmpvar_24;
  tmpvar_24.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_24.w = ((v_23.x + v_23.y) + (v_23.z + v_23.w));
  mediump vec2 uv_25;
  mediump vec3 detailCoords_26;
  mediump float s_27;
  mediump float nylerp_28;
  mediump float zxlerp_29;
  highp vec3 tmpvar_30;
  tmpvar_30 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_30);
  highp float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  zxlerp_29 = tmpvar_32;
  highp float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  nylerp_28 = tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = mix (tmpvar_30.x, tmpvar_30.z, zxlerp_29);
  s_27 = tmpvar_34;
  highp float tmpvar_35;
  tmpvar_35 = sign(mix (tmpvar_30.y, s_27, nylerp_28));
  s_27 = tmpvar_35;
  mediump vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = -(s_27);
  mediump vec3 tmpvar_37;
  tmpvar_37.xz = vec2(1.0, -1.0);
  tmpvar_37.y = s_27;
  highp vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_36 * tmpvar_30.xzy), (tmpvar_37 * tmpvar_30.zxy), vec3(zxlerp_29));
  detailCoords_26 = tmpvar_38;
  mediump vec3 tmpvar_39;
  tmpvar_39.xy = vec2(1.0, 1.0);
  tmpvar_39.z = s_27;
  highp vec3 tmpvar_40;
  tmpvar_40 = mix ((tmpvar_39 * tmpvar_30.yxz), detailCoords_26, vec3(nylerp_28));
  detailCoords_26 = tmpvar_40;
  uv_25 = (((
    (0.5 * detailCoords_26.yz)
   / 
    abs(detailCoords_26.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_41;
  uv_41 = uv_25;
  highp vec2 uvCont_42;
  highp vec2 tmpvar_43;
  tmpvar_43 = abs((uv_41 - (0.5 * _DetailScale)));
  uvCont_42.x = max (tmpvar_43.x, tmpvar_43.y);
  uvCont_42.y = min (tmpvar_43.x, tmpvar_43.y);
  highp vec4 tmpvar_44;
  tmpvar_44.xy = dFdx(uvCont_42);
  tmpvar_44.zw = dFdy(uvCont_42);
  lowp vec4 tmpvar_45;
  tmpvar_45 = texture2DGradEXT (_DetailTex, uv_25, tmpvar_44.xy, tmpvar_44.zw);
  mediump vec4 tmpvar_46;
  tmpvar_46 = tmpvar_45;
  highp vec3 tmpvar_47;
  tmpvar_47 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_47, tmpvar_47)
  )), 0.0, 1.0);
  tmpvar_48 = tmpvar_49;
  mediump vec4 tmpvar_50;
  tmpvar_50 = ((_Color * tmpvar_24) * mix (tmpvar_46, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_48)));
  color_2 = tmpvar_50;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_51;
  tmpvar_51 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_51;
  mediump vec4 tmpvar_52;
  tmpvar_52 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_52;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "MAP_TYPE_1" "ALPHAMAP_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
bvec2 tb1;
highp vec2 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
mediump vec3 t16_4;
highp vec3 t5;
bool tb5;
highp vec3 t6;
lowp vec3 t10_7;
highp vec3 t9;
highp vec3 t10;
bool tb10;
highp float t13;
mediump vec3 t16_13;
highp vec2 t16;
mediump vec2 t16_16;
lowp vec2 t10_16;
highp vec2 t17;
bool tb17;
highp int ti18;
highp float t24;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t24 = max(abs(t0.y), abs(t0.x));
    t24 = float(1.0) / t24;
    t1.x = min(abs(t0.y), abs(t0.x));
    t24 = t24 * t1.x;
    t1.x = t24 * t24;
    t9.x = t1.x * 0.0208350997 + -0.0851330012;
    t9.x = t1.x * t9.x + 0.180141002;
    t9.x = t1.x * t9.x + -0.330299497;
    t1.x = t1.x * t9.x + 0.999866009;
    t9.x = t24 * t1.x;
    t9.x = t9.x * -2.0 + 1.57079637;
    tb17 = abs(t0.y)<abs(t0.x);
    t9.x = tb17 ? t9.x : float(0.0);
    t24 = t24 * t1.x + t9.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t24 = t24 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t24) : t24;
    t0.x = t0.x * 0.159154937 + 0.5;
    t24 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t0.z) + -0.212114394;
    t24 = t24 * abs(t0.z) + 1.57072878;
    t16.x = -abs(t0.z) + 1.0;
    t16.x = sqrt(t16.x);
    t1.x = t16.x * t24;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t16.x = t24 * t16.x + t1.x;
    t0.y = t16.x * 0.318309873;
    t16.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t16.xyxx, (-t16.xyxx)).xy;
    t16.xy = fract(abs(t16.xy));
    t16.x = (tb1.x) ? t16.x : (-t16.x);
    t16.y = (tb1.x) ? t16.y : (-t16.y);
    t16.xy = t16.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = t16.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t16.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t16.xy;
    t10_16.xy = texture(_UVNoiseTex, t16.xy).xy;
    t16_16.xy = t10_16.xy + vec2(-0.5, -0.5);
    t0.xy = t16_16.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t16.x = t0.x + -0.5;
    t0.z = abs(t16.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t16_3.xy = t10_0.xy * alphaMask1.xy;
    t16_3.x = t16_3.y + t16_3.x;
    t16_3.x = t10_0.z * alphaMask1.z + t16_3.x;
    t16_0.w = t10_0.w * alphaMask1.w + t16_3.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_3.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t9.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t2.x = t10.x * t2.x + t9.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t9.z), abs(t9.y));
    tb2 = t2.x>=abs(t9.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t9.x;
    ti18 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti18) + ti1;
    t16_4.y = float(ti1);
    t16_3.y = (-t16_4.y);
    t5.xyz = t9.yzx * t16_3.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t9.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t9.xyz + t10.xyz;
    t1.xyz = t9.xyz * t16_4.xxy;
    t1.xyz = t2.xxx * t10.xyz + t1.xyz;
    t16_3.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_3.xy = t16_3.xy / abs(t1.xx);
    t16_3.xy = t16_3.xy + vec2(0.5, 0.5);
    t1.xy = t16_3.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t5.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t5.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t5.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_7.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_7.xyz = t10_7.xxx * t16_2.xyz;
    t10_7.xyz = clamp(t10_7.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_13.xyz = t10_7.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_13.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t13 = vs_TEXCOORD2 + 5.0;
    t13 = t13 + (-_PlanetRadius);
    t13 = t13 * 0.200000003;
    t13 = clamp(t13, 0.0, 1.0);
    t5.x = t13 * t5.x;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "MAP_TYPE_1" "ALPHAMAP_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "MAP_TYPE_1" "ALPHAMAP_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D _MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
int ti0;
bool tb0;
vec4 t1;
lowp vec4 t10_1;
bvec2 tb1;
vec3 t2;
mediump vec4 t16_2;
vec3 t3;
bool tb3;
vec3 t4;
vec2 t6;
vec3 t8;
int ti8;
vec2 t10;
mediump vec2 t16_10;
vec2 t11;
bool tb11;
float t15;
float t16;
int ti16;
float t17;
bool tb17;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xzy;
    t15 = max(abs(t0.y), abs(t0.x));
    t15 = float(1.0) / t15;
    t1.x = min(abs(t0.y), abs(t0.x));
    t15 = t15 * t1.x;
    t1.x = t15 * t15;
    t6.x = t1.x * 0.0208350997 + -0.0851330012;
    t6.x = t1.x * t6.x + 0.180141002;
    t6.x = t1.x * t6.x + -0.330299497;
    t1.x = t1.x * t6.x + 0.999866009;
    t6.x = t15 * t1.x;
    t6.x = t6.x * -2.0 + 1.57079637;
    tb11 = abs(t0.y)<abs(t0.x);
    t6.x = tb11 ? t6.x : float(0.0);
    t15 = t15 * t1.x + t6.x;
    tb1.xy = lessThan(t0.yzyy, (-t0.yzyy)).xy;
    t1.x = tb1.x ? -3.14159274 : float(0.0);
    t15 = t15 + t1.x;
    t1.x = min(t0.y, t0.x);
    tb1.x = t1.x<(-t1.x);
    t0.x = max(t0.y, t0.x);
    tb0 = t0.x>=(-t0.x);
    ti0 = int(uint(tb0) * 0xffffffffu & uint(tb1.x) * 0xffffffffu);
    t0.x = (ti0 != 0) ? (-t15) : t15;
    t0.x = t0.x * 0.159154937 + 0.5;
    t15 = abs(t0.z) * -0.0187292993 + 0.0742610022;
    t15 = t15 * abs(t0.z) + -0.212114394;
    t15 = t15 * abs(t0.z) + 1.57072878;
    t10.x = -abs(t0.z) + 1.0;
    t10.x = sqrt(t10.x);
    t1.x = t10.x * t15;
    t1.x = t1.x * -2.0 + 3.14159274;
    t1.x = tb1.y ? t1.x : float(0.0);
    t10.x = t15 * t10.x + t1.x;
    t0.y = t10.x * 0.318309873;
    t10.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb1.xy = greaterThanEqual(t10.xyxx, (-t10.xyxx)).xy;
    t10.xy = fract(abs(t10.xy));
    t10.x = (tb1.x) ? t10.x : (-t10.x);
    t10.y = (tb1.x) ? t10.y : (-t10.y);
    t10.xy = t10.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = t10.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t10.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t10.xy;
    t10_1 = texture(_UVNoiseTex, t10.xy);
    t16_10.xy = t10_1.xy + vec2(-0.5, -0.5);
    t0.xy = t16_10.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t10.x = t0.x + -0.5;
    t0.z = abs(t10.x);
    t1.xy = dFdx(t0.zy);
    t2.xy = dFdy(t0.zy);
    t10_0 = textureGrad(_MainTex, t0.xy, vec4(t1.xyxx).xy, vec4(t2.xyxx).xy);
    t0.xy = t10_0.xy * alphaMask1.xy;
    t0.x = t0.y + t0.x;
    t0.x = t10_0.z * alphaMask1.z + t0.x;
    t0.w = t10_0.w * alphaMask1.w + t0.x;
    t0.xyz = vec3(1.0, 1.0, 1.0);
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t16 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16 = inversesqrt(t16);
    t2.xyz = vec3(t16) * vs_TEXCOORD5.yxz;
    t17 = vs_TEXCOORD5.z * t16 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t17 = t3.x * t17 + t2.y;
    t16 = (-vs_TEXCOORD5.y) * t16 + t17;
    t17 = max(abs(t2.z), abs(t2.y));
    tb17 = t17>=abs(t2.x);
    t17 = tb17 ? 1.0 : float(0.0);
    t16 = t17 * t16 + t2.x;
    ti8 = int((0.0<t16) ? 0xFFFFFFFFu : uint(0u));
    ti16 = int((t16<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti16 = (-ti8) + ti16;
    t4.y = float(ti16);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t8.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t8.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t17) * t1.xyz + t2.xyz;
    t6.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t6.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t11.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t11.y), abs(t11.x));
    t11.x = min(abs(t11.y), abs(t11.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t11.x);
    t2.y = dFdy(t11.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t16 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t16);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1.x = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1.x ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t6.x = vs_TEXCOORD2 + 5.0;
    t6.x = t6.x + (-_PlanetRadius);
    t6.x = t6.x * 0.200000003;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t1.x = t6.x * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 71 math, 3 textures, 3 branches
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform samplerCube cube_MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec3 cubeVect_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  cubeVect_3 = tmpvar_4;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 / vec3(_UVNoiseScale));
  vec3 tmpvar_6;
  tmpvar_6 = (fract(abs(tmpvar_5)) * vec3(_UVNoiseScale));
  float tmpvar_7;
  if ((tmpvar_5.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  float tmpvar_8;
  if ((tmpvar_5.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  float tmpvar_9;
  if ((tmpvar_5.z >= 0.0)) {
    tmpvar_9 = tmpvar_6.z;
  } else {
    tmpvar_9 = -(tmpvar_6.z);
  };
  vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  cubeVect_3.xy = (tmpvar_4.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_10 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uv_11;
  vec3 tmpvar_12;
  tmpvar_12 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_13;
  tmpvar_13 = abs(tmpvar_12);
  float tmpvar_14;
  tmpvar_14 = float((tmpvar_13.z >= tmpvar_13.x));
  float tmpvar_15;
  tmpvar_15 = float((max (tmpvar_13.x, tmpvar_13.z) >= tmpvar_13.y));
  float tmpvar_16;
  tmpvar_16 = sign(mix (tmpvar_12.y, mix (tmpvar_12.x, tmpvar_12.z, tmpvar_14), tmpvar_15));
  vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = -(tmpvar_16);
  vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = tmpvar_16;
  vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = tmpvar_16;
  vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_12.yxz), mix ((tmpvar_17 * tmpvar_12.xzy), (tmpvar_18 * tmpvar_12.zxy), vec3(tmpvar_14)), vec3(tmpvar_15));
  uv_11 = (((
    (0.5 * tmpvar_20.yz)
   / 
    abs(tmpvar_20.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_21;
  vec2 tmpvar_22;
  tmpvar_22 = abs((uv_11 - (0.5 * _DetailScale)));
  uvCont_21.x = max (tmpvar_22.x, tmpvar_22.y);
  uvCont_21.y = min (tmpvar_22.x, tmpvar_22.y);
  vec4 tmpvar_23;
  tmpvar_23.xy = dFdx(uvCont_21);
  tmpvar_23.zw = dFdy(uvCont_21);
  vec3 tmpvar_24;
  tmpvar_24 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_25;
  tmpvar_25 = ((_Color * textureCube (cube_MainTex, cubeVect_3)) * mix (texture2DGradARB (_DetailTex, uv_11, tmpvar_23.xy, tmpvar_23.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_24, tmpvar_24)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_25.w;
  color_1.xyz = clamp ((tmpvar_25.xyz * (1.0 - tmpvar_25.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_25.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa
eefiecedmpppicmlcijlpdcfoemmnlfdjdhgilcnabaaaaaakmaiaaaaadaaaaaa
cmaaaaaahmaaaaaaemabaaaaejfdeheoeiaaaaaaacaaaaaaaiaaaaaadiaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaaaaaaaaaapapaaaaebaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaahaaaaaafaepfdejfeejepeoaaeoepfcenebemaaepfdeheo
miaaaaaaahaaaaaaaiaaaaaalaaaaaaaaaaaaaaaabaaaaaaadaaaaaaaaaaaaaa
apaaaaaalmaaaaaaaaaaaaaaaaaaaaaaadaaaaaaabaaaaaaapaaaaaalmaaaaaa
abaaaaaaaaaaaaaaadaaaaaaacaaaaaaabaoaaaalmaaaaaaacaaaaaaaaaaaaaa
adaaaaaaacaaaaaaacanaaaalmaaaaaaadaaaaaaaaaaaaaaadaaaaaaadaaaaaa
apaaaaaalmaaaaaaaeaaaaaaaaaaaaaaadaaaaaaaeaaaaaaahaiaaaalmaaaaaa
afaaaaaaaaaaaaaaadaaaaaaafaaaaaaahaiaaaafdfgfpfaepfdejfeejepeoaa
feeffiedepepfceeaaklklklfdeieefcfiahaaaaeaaaabaangabaaaafjaaaaae
egiocaaaaaaaaaaaccaaaaaafjaaaaaeegiocaaaabaaaaaabaaaaaaafpaaaaad
pcbabaaaaaaaaaaaghaaaaaepccabaaaaaaaaaaaabaaaaaagfaaaaadpccabaaa
abaaaaaagfaaaaadbccabaaaacaaaaaagfaaaaadcccabaaaacaaaaaagfaaaaad
pccabaaaadaaaaaagfaaaaadhccabaaaaeaaaaaagfaaaaadhccabaaaafaaaaaa
giaaaaacadaaaaaadiaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaaegiocaaa
abaaaaaaabaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaabaaaaaaaaaaaaaa
agbabaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaa
abaaaaaaacaaaaaakgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpccabaaa
aaaaaaaaegiocaaaabaaaaaaadaaaaaapgbpbaaaaaaaaaaaegaobaaaaaaaaaaa
diaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaaegiocaaaaaaaaaaabpaaaaaa
dcaaaaakpcaabaaaaaaaaaaaegiocaaaaaaaaaaaboaaaaaaagbabaaaaaaaaaaa
egaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaaaaaaaaacaaaaaaa
kgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpccabaaaabaaaaaaegiocaaa
aaaaaaaacbaaaaaapgbpbaaaaaaaaaaaegaobaaaaaaaaaaadiaaaaaipcaabaaa
aaaaaaaafgbfbaaaaaaaaaaaegiocaaaabaaaaaaanaaaaaadcaaaaakpcaabaaa
aaaaaaaaegiocaaaabaaaaaaamaaaaaaagbabaaaaaaaaaaaegaobaaaaaaaaaaa
dcaaaaakpcaabaaaaaaaaaaaegiocaaaabaaaaaaaoaaaaaakgbkbaaaaaaaaaaa
egaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaabaaaaaaapaaaaaa
pgbpbaaaaaaaaaaaegaobaaaaaaaaaaaaaaaaaajhcaabaaaabaaaaaaegacbaia
ebaaaaaaaaaaaaaaegiccaaaaaaaaaaabnaaaaaabaaaaaahicaabaaaabaaaaaa
egacbaaaabaaaaaaegacbaaaabaaaaaaeeaaaaafbcaabaaaacaaaaaadkaabaaa
abaaaaaadiaaaaahhcaabaaaacaaaaaaegacbaaaabaaaaaaagaabaaaacaaaaaa
baaaaaajbcaabaaaabaaaaaaegacbaaaabaaaaaaegiccaiaebaaaaaaaaaaaaaa
blaaaaaabaaaaaaiccaabaaaabaaaaaaegacbaaaacaaaaaaegiccaaaaaaaaaaa
blaaaaaadicaaaahccaabaaaabaaaaaabkaabaaaabaaaaaaabeaaaaaaaaamiec
elaaaaafecaabaaaabaaaaaadkaabaaaabaaaaaabnaaaaaibcaabaaaacaaaaaa
akiacaaaaaaaaaaabmaaaaaackaabaaaabaaaaaadgaaaaafcccabaaaacaaaaaa
ckaabaaaabaaaaaaabaaaaahecaabaaaabaaaaaaakaabaaaacaaaaaaabeaaaaa
aaaaiadpdiaaaaahbccabaaaacaaaaaabkaabaaaabaaaaaackaabaaaabaaaaaa
dgaaaaafpccabaaaadaaaaaaegaobaaaaaaaaaaadcaaaaakccaabaaaabaaaaaa
akaabaiaebaaaaaaabaaaaaaakaabaaaabaaaaaadkaabaaaabaaaaaaelaaaaaf
ccaabaaaabaaaaaabkaabaaaabaaaaaadiaaaaahbcaabaaaacaaaaaabkaabaaa
abaaaaaabkaabaaaabaaaaaadcaaaaakccaabaaaabaaaaaabkaabaiaebaaaaaa
abaaaaaabkaabaaaabaaaaaadkaabaaaabaaaaaadcaaaaamicaabaaaabaaaaaa
akiacaaaaaaaaaaabmaaaaaaakiacaaaaaaaaaaabmaaaaaaakaabaiaebaaaaaa
acaaaaaaelaaaaafkcaabaaaabaaaaaafganbaaaabaaaaaaaaaaaaahbcaabaaa
acaaaaaadkaabaaaabaaaaaaakaabaaaabaaaaaaaaaaaaaiccaabaaaabaaaaaa
bkaabaiaebaaaaaaabaaaaaadkaabaaaabaaaaaaaaaaaaaiicaabaaaabaaaaaa
dkaabaiaebaaaaaaabaaaaaaakaabaaaabaaaaaabnaaaaahbcaabaaaabaaaaaa
akaabaaaabaaaaaaabeaaaaaaaaaaaaaabaaaaahbcaabaaaabaaaaaaakaabaaa
abaaaaaaabeaaaaaaaaaiadpaaaaaaaiicaabaaaabaaaaaabkaabaiaebaaaaaa
abaaaaaadkaabaaaabaaaaaadcaaaaajicaabaaaabaaaaaaakaabaaaabaaaaaa
dkaabaaaabaaaaaabkaabaaaabaaaaaaaaaaaaaibcaabaaaacaaaaaabkaabaia
ebaaaaaaabaaaaaaakaabaaaacaaaaaadcaaaaajbcaabaaaabaaaaaaakaabaaa
abaaaaaaakaabaaaacaaaaaabkaabaaaabaaaaaaaaaaaaaibcaabaaaabaaaaaa
dkaabaiaebaaaaaaabaaaaaaakaabaaaabaaaaaadcaaaaajbcaabaaaabaaaaaa
ckaabaaaabaaaaaaakaabaaaabaaaaaadkaabaaaabaaaaaadcaaaaalpcaabaaa
aaaaaaaaegiocaiaebaaaaaaaaaaaaaablaaaaaaagaabaaaabaaaaaaegaobaaa
aaaaaaaadiaaaaaipcaabaaaabaaaaaafgafbaaaaaaaaaaaegiocaaaaaaaaaaa
akaaaaaadcaaaaakpcaabaaaabaaaaaaegiocaaaaaaaaaaaajaaaaaaagaabaaa
aaaaaaaaegaobaaaabaaaaaadcaaaaakpcaabaaaabaaaaaaegiocaaaaaaaaaaa
alaaaaaakgakbaaaaaaaaaaaegaobaaaabaaaaaadcaaaaakpcaabaaaaaaaaaaa
egiocaaaaaaaaaaaamaaaaaapgapbaaaaaaaaaaaegaobaaaabaaaaaadgaaaaaf
hccabaaaaeaaaaaaegacbaaaaaaaaaaadiaaaaaihcaabaaaabaaaaaafgafbaaa
aaaaaaaaegiccaaaaaaaaaaaaoaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaa
aaaaaaaaanaaaaaaagaabaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
aaaaaaaaegiccaaaaaaaaaaaapaaaaaakgakbaaaaaaaaaaaegacbaaaabaaaaaa
dcaaaaakhccabaaaafaaaaaaegiccaaaaaaaaaaabaaaaaaapgapbaaaaaaaaaaa
egacbaaaaaaaaaaadoaaaaab"
}
SubProgram "gles " {
// Stats: 71 math, 3 textures, 3 branches
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform lowp samplerCube cube_MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  highp vec3 cubeVect_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD4);
  cubeVect_6 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_9;
  tmpvar_9 = (fract(abs(tmpvar_8)) * vec3(_UVNoiseScale));
  highp float tmpvar_10;
  if ((tmpvar_8.x >= 0.0)) {
    tmpvar_10 = tmpvar_9.x;
  } else {
    tmpvar_10 = -(tmpvar_9.x);
  };
  highp float tmpvar_11;
  if ((tmpvar_8.y >= 0.0)) {
    tmpvar_11 = tmpvar_9.y;
  } else {
    tmpvar_11 = -(tmpvar_9.y);
  };
  highp float tmpvar_12;
  if ((tmpvar_8.z >= 0.0)) {
    tmpvar_12 = tmpvar_9.z;
  } else {
    tmpvar_12 = -(tmpvar_9.z);
  };
  highp vec3 tmpvar_13;
  tmpvar_13.x = tmpvar_10;
  tmpvar_13.y = tmpvar_11;
  tmpvar_13.z = tmpvar_12;
  highp vec2 tmpvar_14;
  tmpvar_14 = ((tmpvar_13 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (_UVNoiseTex, tmpvar_14);
  cubeVect_6.xy = (tmpvar_7.xy + ((tmpvar_15.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_16;
  tmpvar_16 = textureCube (cube_MainTex, cubeVect_6);
  mediump vec4 tmpvar_17;
  tmpvar_17 = tmpvar_16;
  mediump vec2 uv_18;
  mediump vec3 detailCoords_19;
  mediump float s_20;
  mediump float nylerp_21;
  mediump float zxlerp_22;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  zxlerp_22 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  nylerp_21 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_22);
  s_20 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = sign(mix (tmpvar_23.y, s_20, nylerp_21));
  s_20 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = -(s_20);
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = s_20;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_29 * tmpvar_23.xzy), (tmpvar_30 * tmpvar_23.zxy), vec3(zxlerp_22));
  detailCoords_19 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = s_20;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), detailCoords_19, vec3(nylerp_21));
  detailCoords_19 = tmpvar_33;
  uv_18 = (((
    (0.5 * detailCoords_19.yz)
   / 
    abs(detailCoords_19.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_34;
  uv_34 = uv_18;
  highp vec2 uvCont_35;
  highp vec2 tmpvar_36;
  tmpvar_36 = abs((uv_34 - (0.5 * _DetailScale)));
  uvCont_35.x = max (tmpvar_36.x, tmpvar_36.y);
  uvCont_35.y = min (tmpvar_36.x, tmpvar_36.y);
  highp vec4 tmpvar_37;
  tmpvar_37.xy = dFdx(uvCont_35);
  tmpvar_37.zw = dFdy(uvCont_35);
  lowp vec4 tmpvar_38;
  tmpvar_38 = texture2DGradEXT (_DetailTex, uv_18, tmpvar_37.xy, tmpvar_37.zw);
  mediump vec4 tmpvar_39;
  tmpvar_39 = tmpvar_38;
  highp vec3 tmpvar_40;
  tmpvar_40 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_40, tmpvar_40)
  )), 0.0, 1.0);
  tmpvar_41 = tmpvar_42;
  mediump vec4 tmpvar_43;
  tmpvar_43 = ((_Color * tmpvar_17) * mix (tmpvar_39, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_41)));
  color_2 = tmpvar_43;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_44;
  tmpvar_44 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_44;
  mediump vec4 tmpvar_45;
  tmpvar_45 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_45;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp samplerCube cube_MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
highp vec3 t4;
mediump vec2 t16_4;
lowp vec2 t10_4;
bool tb4;
highp vec3 t5;
lowp vec3 t10_6;
highp vec3 t8;
highp vec3 t9;
bool tb9;
highp float t11;
mediump vec3 t16_11;
highp vec2 t15;
highp int ti16;
bvec2 tb18;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t8.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t8.y);
    tb9 = abs(t8.z)>=abs(t8.y);
    t9.x = tb9 ? 1.0 : float(0.0);
    t2.x = t9.x * t2.x + t8.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t8.z), abs(t8.y));
    tb2 = t2.x>=abs(t8.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t8.x;
    ti16 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti16) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t8.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t8.zyx + (-t4.xyz);
    t9.xyz = t9.xxx * t5.xyz + t4.xyz;
    t9.xyz = (-t16_3.xxy) * t8.xyz + t9.xyz;
    t1.xyz = t8.xyz * t16_3.xxy;
    t1.xyz = t2.xxx * t9.xyz + t1.xyz;
    t16_0.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_0.xy = t16_0.xy / abs(t1.xx);
    t16_0.xy = t16_0.xy + vec2(0.5, 0.5);
    t1.xy = t16_0.xy * vec2(_DetailScale);
    t15.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t15.y), abs(t15.x));
    t15.x = min(abs(t15.y), abs(t15.x));
    t4.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t4.y = dFdx(t15.x);
    t2.y = dFdy(t15.x);
    t10_0 = textureGrad(_DetailTex, t1.xy, vec4(t4.xyxx).xy, vec4(t2.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t16_0 = t2.xxxx * t16_1 + t10_0;
    t2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD4.xyz;
    t4.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb18.xy = greaterThanEqual(t4.xyxy, (-t4.xyxy)).xy;
    t4.xy = fract(abs(t4.xy));
    t4.x = (tb18.x) ? t4.x : (-t4.x);
    t4.y = (tb18.y) ? t4.y : (-t4.y);
    t4.xy = t4.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = t4.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t4.xy;
    t10_4.xy = texture(_UVNoiseTex, t4.xy).xy;
    t16_4.xy = t10_4.xy + vec2(-0.5, -0.5);
    t2.xy = t16_4.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t2.xy;
    t10_1 = texture(cube_MainTex, t2.xyz);
    t16_1 = t10_1 * _Color;
    t10_6.x = (-t16_1.w) * t16_0.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_1.w * t16_0.w + -1.0;
    t10_6.xyz = t10_6.xxx * t16_2.xyz;
    t10_6.xyz = clamp(t10_6.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_11.xyz = t10_6.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_11.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t11 = vs_TEXCOORD2 + 5.0;
    t11 = t11 + (-_PlanetRadius);
    t11 = t11 * 0.200000003;
    t11 = clamp(t11, 0.0, 1.0);
    t4.x = t11 * t4.x;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
vec4 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec2 t16_2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
vec2 t4;
float t5;
vec3 t6;
int ti6;
vec2 t8;
bvec2 tb10;
float t12;
int ti12;
float t13;
bool tb13;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t12 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t12 = inversesqrt(t12);
    t1.xyz = vec3(t12) * vs_TEXCOORD5.yxz;
    t13 = vs_TEXCOORD5.z * t12 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t13 = t2.x * t13 + t1.y;
    t12 = (-vs_TEXCOORD5.y) * t12 + t13;
    t13 = max(abs(t1.z), abs(t1.y));
    tb13 = t13>=abs(t1.x);
    t13 = tb13 ? 1.0 : float(0.0);
    t12 = t13 * t12 + t1.x;
    ti6 = int((0.0<t12) ? 0xFFFFFFFFu : uint(0u));
    ti12 = int((t12<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti12 = (-ti6) + ti12;
    t3.y = float(ti12);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t6.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t6.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    t0.xyz = vec3(t13) * t0.xyz + t1.xyz;
    t4.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t4.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_DetailScale);
    t8.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t8.y), abs(t8.x));
    t8.x = min(abs(t8.y), abs(t8.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t8.x);
    t1.y = dFdy(t8.x);
    t10_0 = textureGrad(_DetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t0 = t2.xxxx * t16_1 + t10_0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t2.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t2.xyxy, (-t2.xyxy)).xy;
    t2.xy = fract(abs(t2.xy));
    t2.x = (tb10.x) ? t2.x : (-t2.x);
    t2.y = (tb10.y) ? t2.y : (-t2.y);
    t2.xy = t2.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t2.xy;
    t10_2 = texture(_UVNoiseTex, t2.xy);
    t16_2.xy = t10_2.xy + vec2(-0.5, -0.5);
    t1.xy = t16_2.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t10_1 = texture(cube_MainTex, t1.xyz);
    t1 = t10_1 * _Color;
    t2.x = (-t1.w) * t0.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t13 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t13);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t5 = vs_TEXCOORD2 + 5.0;
    t5 = t5 + (-_PlanetRadius);
    t5 = t5 * 0.200000003;
    t5 = clamp(t5, 0.0, 1.0);
    t1.x = t5 * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 76 math, 3 textures, 3 branches
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform samplerCube cube_MainTex;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec3 cubeVect_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  cubeVect_3 = tmpvar_4;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 / vec3(_UVNoiseScale));
  vec3 tmpvar_6;
  tmpvar_6 = (fract(abs(tmpvar_5)) * vec3(_UVNoiseScale));
  float tmpvar_7;
  if ((tmpvar_5.x >= 0.0)) {
    tmpvar_7 = tmpvar_6.x;
  } else {
    tmpvar_7 = -(tmpvar_6.x);
  };
  float tmpvar_8;
  if ((tmpvar_5.y >= 0.0)) {
    tmpvar_8 = tmpvar_6.y;
  } else {
    tmpvar_8 = -(tmpvar_6.y);
  };
  float tmpvar_9;
  if ((tmpvar_5.z >= 0.0)) {
    tmpvar_9 = tmpvar_6.z;
  } else {
    tmpvar_9 = -(tmpvar_6.z);
  };
  vec3 tmpvar_10;
  tmpvar_10.x = tmpvar_7;
  tmpvar_10.y = tmpvar_8;
  tmpvar_10.z = tmpvar_9;
  cubeVect_3.xy = (tmpvar_4.xy + ((texture2D (_UVNoiseTex, 
    ((tmpvar_10 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec4 v_11;
  v_11 = (textureCube (cube_MainTex, cubeVect_3) * alphaMask1);
  vec4 tmpvar_12;
  tmpvar_12.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_12.w = ((v_11.x + v_11.y) + (v_11.z + v_11.w));
  vec2 uv_13;
  vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_15;
  tmpvar_15 = abs(tmpvar_14);
  float tmpvar_16;
  tmpvar_16 = float((tmpvar_15.z >= tmpvar_15.x));
  float tmpvar_17;
  tmpvar_17 = float((max (tmpvar_15.x, tmpvar_15.z) >= tmpvar_15.y));
  float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_16), tmpvar_17));
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(tmpvar_18);
  vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = tmpvar_18;
  vec3 tmpvar_21;
  tmpvar_21.xy = vec2(1.0, 1.0);
  tmpvar_21.z = tmpvar_18;
  vec3 tmpvar_22;
  tmpvar_22 = mix ((tmpvar_21 * tmpvar_14.yxz), mix ((tmpvar_19 * tmpvar_14.xzy), (tmpvar_20 * tmpvar_14.zxy), vec3(tmpvar_16)), vec3(tmpvar_17));
  uv_13 = (((
    (0.5 * tmpvar_22.yz)
   / 
    abs(tmpvar_22.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_23;
  vec2 tmpvar_24;
  tmpvar_24 = abs((uv_13 - (0.5 * _DetailScale)));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  vec4 tmpvar_25;
  tmpvar_25.xy = dFdx(uvCont_23);
  tmpvar_25.zw = dFdy(uvCont_23);
  vec3 tmpvar_26;
  tmpvar_26 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_27;
  tmpvar_27 = ((_Color * tmpvar_12) * mix (texture2DGradARB (_DetailTex, uv_13, tmpvar_25.xy, tmpvar_25.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_26, tmpvar_26)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_27.w;
  color_1.xyz = clamp ((tmpvar_27.xyz * (1.0 - tmpvar_27.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_27.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 76 math, 3 textures, 3 branches
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_MainTex;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  highp vec3 cubeVect_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD4);
  cubeVect_6 = tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 / vec3(_UVNoiseScale));
  highp vec3 tmpvar_9;
  tmpvar_9 = (fract(abs(tmpvar_8)) * vec3(_UVNoiseScale));
  highp float tmpvar_10;
  if ((tmpvar_8.x >= 0.0)) {
    tmpvar_10 = tmpvar_9.x;
  } else {
    tmpvar_10 = -(tmpvar_9.x);
  };
  highp float tmpvar_11;
  if ((tmpvar_8.y >= 0.0)) {
    tmpvar_11 = tmpvar_9.y;
  } else {
    tmpvar_11 = -(tmpvar_9.y);
  };
  highp float tmpvar_12;
  if ((tmpvar_8.z >= 0.0)) {
    tmpvar_12 = tmpvar_9.z;
  } else {
    tmpvar_12 = -(tmpvar_9.z);
  };
  highp vec3 tmpvar_13;
  tmpvar_13.x = tmpvar_10;
  tmpvar_13.y = tmpvar_11;
  tmpvar_13.z = tmpvar_12;
  highp vec2 tmpvar_14;
  tmpvar_14 = ((tmpvar_13 / _UVNoiseScale).xy + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_15;
  tmpvar_15 = texture2D (_UVNoiseTex, tmpvar_14);
  cubeVect_6.xy = (tmpvar_7.xy + ((tmpvar_15.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  lowp vec4 tmpvar_16;
  tmpvar_16 = textureCube (cube_MainTex, cubeVect_6);
  mediump vec4 tmpvar_17;
  tmpvar_17 = tmpvar_16;
  mediump vec4 v_18;
  v_18 = (tmpvar_17 * alphaMask1);
  mediump vec4 tmpvar_19;
  tmpvar_19.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_19.w = ((v_18.x + v_18.y) + (v_18.z + v_18.w));
  mediump vec2 uv_20;
  mediump vec3 detailCoords_21;
  mediump float s_22;
  mediump float nylerp_23;
  mediump float zxlerp_24;
  highp vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_25);
  highp float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  zxlerp_24 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  nylerp_23 = tmpvar_28;
  highp float tmpvar_29;
  tmpvar_29 = mix (tmpvar_25.x, tmpvar_25.z, zxlerp_24);
  s_22 = tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = sign(mix (tmpvar_25.y, s_22, nylerp_23));
  s_22 = tmpvar_30;
  mediump vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = -(s_22);
  mediump vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = s_22;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_31 * tmpvar_25.xzy), (tmpvar_32 * tmpvar_25.zxy), vec3(zxlerp_24));
  detailCoords_21 = tmpvar_33;
  mediump vec3 tmpvar_34;
  tmpvar_34.xy = vec2(1.0, 1.0);
  tmpvar_34.z = s_22;
  highp vec3 tmpvar_35;
  tmpvar_35 = mix ((tmpvar_34 * tmpvar_25.yxz), detailCoords_21, vec3(nylerp_23));
  detailCoords_21 = tmpvar_35;
  uv_20 = (((
    (0.5 * detailCoords_21.yz)
   / 
    abs(detailCoords_21.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_36;
  uv_36 = uv_20;
  highp vec2 uvCont_37;
  highp vec2 tmpvar_38;
  tmpvar_38 = abs((uv_36 - (0.5 * _DetailScale)));
  uvCont_37.x = max (tmpvar_38.x, tmpvar_38.y);
  uvCont_37.y = min (tmpvar_38.x, tmpvar_38.y);
  highp vec4 tmpvar_39;
  tmpvar_39.xy = dFdx(uvCont_37);
  tmpvar_39.zw = dFdy(uvCont_37);
  lowp vec4 tmpvar_40;
  tmpvar_40 = texture2DGradEXT (_DetailTex, uv_20, tmpvar_39.xy, tmpvar_39.zw);
  mediump vec4 tmpvar_41;
  tmpvar_41 = tmpvar_40;
  highp vec3 tmpvar_42;
  tmpvar_42 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_43;
  highp float tmpvar_44;
  tmpvar_44 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_42, tmpvar_42)
  )), 0.0, 1.0);
  tmpvar_43 = tmpvar_44;
  mediump vec4 tmpvar_45;
  tmpvar_45 = ((_Color * tmpvar_19) * mix (tmpvar_41, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_43)));
  color_2 = tmpvar_45;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_46;
  tmpvar_46 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_46;
  mediump vec4 tmpvar_47;
  tmpvar_47 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_47;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp samplerCube cube_MainTex;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
lowp vec4 t10_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec3 t16_3;
highp vec3 t4;
mediump vec2 t16_4;
lowp vec2 t10_4;
bool tb4;
highp vec3 t5;
lowp vec3 t10_6;
highp vec3 t8;
highp vec3 t9;
bool tb9;
highp float t11;
mediump vec3 t16_11;
highp vec2 t15;
highp int ti16;
bvec2 tb18;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t8.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t8.y);
    tb9 = abs(t8.z)>=abs(t8.y);
    t9.x = tb9 ? 1.0 : float(0.0);
    t2.x = t9.x * t2.x + t8.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t8.z), abs(t8.y));
    tb2 = t2.x>=abs(t8.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t8.x;
    ti16 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti16) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t8.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t8.zyx + (-t4.xyz);
    t9.xyz = t9.xxx * t5.xyz + t4.xyz;
    t9.xyz = (-t16_3.xxy) * t8.xyz + t9.xyz;
    t1.xyz = t8.xyz * t16_3.xxy;
    t1.xyz = t2.xxx * t9.xyz + t1.xyz;
    t16_0.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_0.xy = t16_0.xy / abs(t1.xx);
    t16_0.xy = t16_0.xy + vec2(0.5, 0.5);
    t1.xy = t16_0.xy * vec2(_DetailScale);
    t15.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t15.y), abs(t15.x));
    t15.x = min(abs(t15.y), abs(t15.x));
    t4.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t4.y = dFdx(t15.x);
    t2.y = dFdy(t15.x);
    t10_0 = textureGrad(_DetailTex, t1.xy, vec4(t4.xyxx).xy, vec4(t2.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t16_0 = t2.xxxx * t16_1 + t10_0;
    t2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD4.xyz;
    t4.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb18.xy = greaterThanEqual(t4.xyxy, (-t4.xyxy)).xy;
    t4.xy = fract(abs(t4.xy));
    t4.x = (tb18.x) ? t4.x : (-t4.x);
    t4.y = (tb18.y) ? t4.y : (-t4.y);
    t4.xy = t4.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = t4.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t4.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t4.xy;
    t10_4.xy = texture(_UVNoiseTex, t4.xy).xy;
    t16_4.xy = t10_4.xy + vec2(-0.5, -0.5);
    t2.xy = t16_4.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t2.xy;
    t10_1 = texture(cube_MainTex, t2.xyz);
    t16_3.xy = t10_1.xy * alphaMask1.xy;
    t16_3.x = t16_3.y + t16_3.x;
    t16_3.x = t10_1.z * alphaMask1.z + t16_3.x;
    t16_1.w = t10_1.w * alphaMask1.w + t16_3.x;
    t16_1.xyz = vec3(1.0, 1.0, 1.0);
    t16_1 = t16_1 * _Color;
    t10_6.x = (-t16_1.w) * t16_0.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_1.w * t16_0.w + -1.0;
    t10_6.xyz = t10_6.xxx * t16_2.xyz;
    t10_6.xyz = clamp(t10_6.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_11.xyz = t10_6.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_11.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t11 = vs_TEXCOORD2 + 5.0;
    t11 = t11 + (-_PlanetRadius);
    t11 = t11 * 0.200000003;
    t11 = clamp(t11, 0.0, 1.0);
    t4.x = t11 * t4.x;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  samplerCube cube_MainTex;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
lowp vec4 t10_0;
vec4 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec2 t16_2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
vec2 t4;
float t5;
vec3 t6;
int ti6;
vec2 t8;
bvec2 tb10;
float t12;
int ti12;
float t13;
bool tb13;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t12 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t12 = inversesqrt(t12);
    t1.xyz = vec3(t12) * vs_TEXCOORD5.yxz;
    t13 = vs_TEXCOORD5.z * t12 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t13 = t2.x * t13 + t1.y;
    t12 = (-vs_TEXCOORD5.y) * t12 + t13;
    t13 = max(abs(t1.z), abs(t1.y));
    tb13 = t13>=abs(t1.x);
    t13 = tb13 ? 1.0 : float(0.0);
    t12 = t13 * t12 + t1.x;
    ti6 = int((0.0<t12) ? 0xFFFFFFFFu : uint(0u));
    ti12 = int((t12<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti12 = (-ti6) + ti12;
    t3.y = float(ti12);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t6.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t6.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    t0.xyz = vec3(t13) * t0.xyz + t1.xyz;
    t4.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t4.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_DetailScale);
    t8.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t8.y), abs(t8.x));
    t8.x = min(abs(t8.y), abs(t8.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t8.x);
    t1.y = dFdy(t8.x);
    t10_0 = textureGrad(_DetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_1 = (-t10_0) + vec4(1.0, 1.0, 1.0, 1.0);
    t2.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t2.x = dot(t2.xyz, t2.xyz);
    t2.x = sqrt(t2.x);
    t2.x = dot(t2.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t2.x = clamp(t2.x, 0.0, 1.0);
    t0 = t2.xxxx * t16_1 + t10_0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t2.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t2.xyxy, (-t2.xyxy)).xy;
    t2.xy = fract(abs(t2.xy));
    t2.x = (tb10.x) ? t2.x : (-t2.x);
    t2.y = (tb10.y) ? t2.y : (-t2.y);
    t2.xy = t2.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = t2.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t2.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t2.xy;
    t10_2 = texture(_UVNoiseTex, t2.xy);
    t16_2.xy = t10_2.xy + vec2(-0.5, -0.5);
    t1.xy = t16_2.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t1.xy;
    t10_1 = texture(cube_MainTex, t1.xyz);
    t1.xy = t10_1.xy * alphaMask1.xy;
    t1.x = t1.y + t1.x;
    t1.x = t10_1.z * alphaMask1.z + t1.x;
    t1.w = t10_1.w * alphaMask1.w + t1.x;
    t1.xyz = vec3(1.0, 1.0, 1.0);
    t1 = t1 * _Color;
    t2.x = (-t1.w) * t0.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t13 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t13);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t5 = vs_TEXCOORD2 + 5.0;
    t5 = t5 + (-_PlanetRadius);
    t5 = t5 * 0.200000003;
    t5 = clamp(t5, 0.0, 1.0);
    t1.x = t5 * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 102 math, 4 textures, 2 branches
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec4 tmpvar_22;
  tmpvar_22 = mix (texture2DGradARB (cube_MainTexNEG, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexPOS, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))));
  vec4 tmpvar_23;
  tmpvar_23.x = tmpvar_22.w;
  tmpvar_23.y = tmpvar_22.w;
  tmpvar_23.z = tmpvar_22.w;
  tmpvar_23.w = mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_6), tmpvar_7);
  vec2 uv_24;
  vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_25);
  float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_25.y, mix (tmpvar_25.x, tmpvar_25.z, tmpvar_27), tmpvar_28));
  vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(tmpvar_29);
  vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = tmpvar_29;
  vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = tmpvar_29;
  vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_25.yxz), mix ((tmpvar_30 * tmpvar_25.xzy), (tmpvar_31 * tmpvar_25.zxy), vec3(tmpvar_27)), vec3(tmpvar_28));
  uv_24 = (((
    (0.5 * tmpvar_33.yz)
   / 
    abs(tmpvar_33.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_34;
  vec2 tmpvar_35;
  tmpvar_35 = abs((uv_24 - (0.5 * _DetailScale)));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  vec4 tmpvar_36;
  tmpvar_36.xy = dFdx(uvCont_34);
  tmpvar_36.zw = dFdy(uvCont_34);
  vec3 tmpvar_37;
  tmpvar_37 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_38;
  tmpvar_38 = ((_Color * tmpvar_23) * mix (texture2DGradARB (_DetailTex, uv_24, tmpvar_36.xy, tmpvar_36.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_37, tmpvar_37)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_38.w;
  color_1.xyz = clamp ((tmpvar_38.xyz * (1.0 - tmpvar_38.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_38.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa
eefiecedmpppicmlcijlpdcfoemmnlfdjdhgilcnabaaaaaakmaiaaaaadaaaaaa
cmaaaaaahmaaaaaaemabaaaaejfdeheoeiaaaaaaacaaaaaaaiaaaaaadiaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaaaaaaaaaapapaaaaebaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaahaaaaaafaepfdejfeejepeoaaeoepfcenebemaaepfdeheo
miaaaaaaahaaaaaaaiaaaaaalaaaaaaaaaaaaaaaabaaaaaaadaaaaaaaaaaaaaa
apaaaaaalmaaaaaaaaaaaaaaaaaaaaaaadaaaaaaabaaaaaaapaaaaaalmaaaaaa
abaaaaaaaaaaaaaaadaaaaaaacaaaaaaabaoaaaalmaaaaaaacaaaaaaaaaaaaaa
adaaaaaaacaaaaaaacanaaaalmaaaaaaadaaaaaaaaaaaaaaadaaaaaaadaaaaaa
apaaaaaalmaaaaaaaeaaaaaaaaaaaaaaadaaaaaaaeaaaaaaahaiaaaalmaaaaaa
afaaaaaaaaaaaaaaadaaaaaaafaaaaaaahaiaaaafdfgfpfaepfdejfeejepeoaa
feeffiedepepfceeaaklklklfdeieefcfiahaaaaeaaaabaangabaaaafjaaaaae
egiocaaaaaaaaaaaccaaaaaafjaaaaaeegiocaaaabaaaaaabaaaaaaafpaaaaad
pcbabaaaaaaaaaaaghaaaaaepccabaaaaaaaaaaaabaaaaaagfaaaaadpccabaaa
abaaaaaagfaaaaadbccabaaaacaaaaaagfaaaaadcccabaaaacaaaaaagfaaaaad
pccabaaaadaaaaaagfaaaaadhccabaaaaeaaaaaagfaaaaadhccabaaaafaaaaaa
giaaaaacadaaaaaadiaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaaegiocaaa
abaaaaaaabaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaabaaaaaaaaaaaaaa
agbabaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaa
abaaaaaaacaaaaaakgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpccabaaa
aaaaaaaaegiocaaaabaaaaaaadaaaaaapgbpbaaaaaaaaaaaegaobaaaaaaaaaaa
diaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaaegiocaaaaaaaaaaabpaaaaaa
dcaaaaakpcaabaaaaaaaaaaaegiocaaaaaaaaaaaboaaaaaaagbabaaaaaaaaaaa
egaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaaaaaaaaacaaaaaaa
kgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpccabaaaabaaaaaaegiocaaa
aaaaaaaacbaaaaaapgbpbaaaaaaaaaaaegaobaaaaaaaaaaadiaaaaaipcaabaaa
aaaaaaaafgbfbaaaaaaaaaaaegiocaaaabaaaaaaanaaaaaadcaaaaakpcaabaaa
aaaaaaaaegiocaaaabaaaaaaamaaaaaaagbabaaaaaaaaaaaegaobaaaaaaaaaaa
dcaaaaakpcaabaaaaaaaaaaaegiocaaaabaaaaaaaoaaaaaakgbkbaaaaaaaaaaa
egaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaabaaaaaaapaaaaaa
pgbpbaaaaaaaaaaaegaobaaaaaaaaaaaaaaaaaajhcaabaaaabaaaaaaegacbaia
ebaaaaaaaaaaaaaaegiccaaaaaaaaaaabnaaaaaabaaaaaahicaabaaaabaaaaaa
egacbaaaabaaaaaaegacbaaaabaaaaaaeeaaaaafbcaabaaaacaaaaaadkaabaaa
abaaaaaadiaaaaahhcaabaaaacaaaaaaegacbaaaabaaaaaaagaabaaaacaaaaaa
baaaaaajbcaabaaaabaaaaaaegacbaaaabaaaaaaegiccaiaebaaaaaaaaaaaaaa
blaaaaaabaaaaaaiccaabaaaabaaaaaaegacbaaaacaaaaaaegiccaaaaaaaaaaa
blaaaaaadicaaaahccaabaaaabaaaaaabkaabaaaabaaaaaaabeaaaaaaaaamiec
elaaaaafecaabaaaabaaaaaadkaabaaaabaaaaaabnaaaaaibcaabaaaacaaaaaa
akiacaaaaaaaaaaabmaaaaaackaabaaaabaaaaaadgaaaaafcccabaaaacaaaaaa
ckaabaaaabaaaaaaabaaaaahecaabaaaabaaaaaaakaabaaaacaaaaaaabeaaaaa
aaaaiadpdiaaaaahbccabaaaacaaaaaabkaabaaaabaaaaaackaabaaaabaaaaaa
dgaaaaafpccabaaaadaaaaaaegaobaaaaaaaaaaadcaaaaakccaabaaaabaaaaaa
akaabaiaebaaaaaaabaaaaaaakaabaaaabaaaaaadkaabaaaabaaaaaaelaaaaaf
ccaabaaaabaaaaaabkaabaaaabaaaaaadiaaaaahbcaabaaaacaaaaaabkaabaaa
abaaaaaabkaabaaaabaaaaaadcaaaaakccaabaaaabaaaaaabkaabaiaebaaaaaa
abaaaaaabkaabaaaabaaaaaadkaabaaaabaaaaaadcaaaaamicaabaaaabaaaaaa
akiacaaaaaaaaaaabmaaaaaaakiacaaaaaaaaaaabmaaaaaaakaabaiaebaaaaaa
acaaaaaaelaaaaafkcaabaaaabaaaaaafganbaaaabaaaaaaaaaaaaahbcaabaaa
acaaaaaadkaabaaaabaaaaaaakaabaaaabaaaaaaaaaaaaaiccaabaaaabaaaaaa
bkaabaiaebaaaaaaabaaaaaadkaabaaaabaaaaaaaaaaaaaiicaabaaaabaaaaaa
dkaabaiaebaaaaaaabaaaaaaakaabaaaabaaaaaabnaaaaahbcaabaaaabaaaaaa
akaabaaaabaaaaaaabeaaaaaaaaaaaaaabaaaaahbcaabaaaabaaaaaaakaabaaa
abaaaaaaabeaaaaaaaaaiadpaaaaaaaiicaabaaaabaaaaaabkaabaiaebaaaaaa
abaaaaaadkaabaaaabaaaaaadcaaaaajicaabaaaabaaaaaaakaabaaaabaaaaaa
dkaabaaaabaaaaaabkaabaaaabaaaaaaaaaaaaaibcaabaaaacaaaaaabkaabaia
ebaaaaaaabaaaaaaakaabaaaacaaaaaadcaaaaajbcaabaaaabaaaaaaakaabaaa
abaaaaaaakaabaaaacaaaaaabkaabaaaabaaaaaaaaaaaaaibcaabaaaabaaaaaa
dkaabaiaebaaaaaaabaaaaaaakaabaaaabaaaaaadcaaaaajbcaabaaaabaaaaaa
ckaabaaaabaaaaaaakaabaaaabaaaaaadkaabaaaabaaaaaadcaaaaalpcaabaaa
aaaaaaaaegiocaiaebaaaaaaaaaaaaaablaaaaaaagaabaaaabaaaaaaegaobaaa
aaaaaaaadiaaaaaipcaabaaaabaaaaaafgafbaaaaaaaaaaaegiocaaaaaaaaaaa
akaaaaaadcaaaaakpcaabaaaabaaaaaaegiocaaaaaaaaaaaajaaaaaaagaabaaa
aaaaaaaaegaobaaaabaaaaaadcaaaaakpcaabaaaabaaaaaaegiocaaaaaaaaaaa
alaaaaaakgakbaaaaaaaaaaaegaobaaaabaaaaaadcaaaaakpcaabaaaaaaaaaaa
egiocaaaaaaaaaaaamaaaaaapgapbaaaaaaaaaaaegaobaaaabaaaaaadgaaaaaf
hccabaaaaeaaaaaaegacbaaaaaaaaaaadiaaaaaihcaabaaaabaaaaaafgafbaaa
aaaaaaaaegiccaaaaaaaaaaaaoaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaa
aaaaaaaaanaaaaaaagaabaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
aaaaaaaaegiccaaaaaaaaaaaapaaaaaakgakbaaaaaaaaaaaegacbaaaabaaaaaa
dcaaaaakhccabaaaafaaaaaaegiccaaaaaaaaaaabaaaaaaapgapbaaaaaaaaaaa
egacbaaaaaaaaaaadoaaaaab"
}
SubProgram "gles " {
// Stats: 102 math, 4 textures, 2 branches
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  mediump vec2 uv_6;
  mediump vec3 detailCoords_7;
  mediump float s_8;
  mediump float nylerp_9;
  mediump float zxlerp_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_12;
  tmpvar_12 = abs(tmpvar_11);
  highp float tmpvar_13;
  tmpvar_13 = float((tmpvar_12.z >= tmpvar_12.x));
  zxlerp_10 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = float((max (tmpvar_12.x, tmpvar_12.z) >= tmpvar_12.y));
  nylerp_9 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = mix (tmpvar_11.x, tmpvar_11.z, zxlerp_10);
  s_8 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = sign(mix (tmpvar_11.y, s_8, nylerp_9));
  s_8 = tmpvar_16;
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = -(s_8);
  mediump vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = s_8;
  highp vec3 tmpvar_19;
  tmpvar_19 = mix ((tmpvar_17 * tmpvar_11.xzy), (tmpvar_18 * tmpvar_11.zxy), vec3(zxlerp_10));
  detailCoords_7 = tmpvar_19;
  mediump vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = s_8;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_11.yxz), detailCoords_7, vec3(nylerp_9));
  detailCoords_7 = tmpvar_21;
  mediump vec2 tmpvar_22;
  tmpvar_22 = (((0.5 * detailCoords_7.yz) / abs(detailCoords_7.x)) + 0.5);
  uv_6 = tmpvar_22;
  highp vec2 tmpvar_23;
  tmpvar_23 = (tmpvar_22 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_24;
  tmpvar_24 = (fract(abs(tmpvar_23)) * vec2(_UVNoiseScale));
  highp float tmpvar_25;
  if ((tmpvar_23.x >= 0.0)) {
    tmpvar_25 = tmpvar_24.x;
  } else {
    tmpvar_25 = -(tmpvar_24.x);
  };
  highp float tmpvar_26;
  if ((tmpvar_23.y >= 0.0)) {
    tmpvar_26 = tmpvar_24.y;
  } else {
    tmpvar_26 = -(tmpvar_24.y);
  };
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_25;
  tmpvar_27.y = tmpvar_26;
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2D (_UVNoiseTex, tmpvar_28);
  uv_6 = (tmpvar_22 + ((tmpvar_29.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_30;
  uv_30 = uv_6;
  highp vec2 uvCont_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = abs((uv_30 - 0.5));
  uvCont_31.x = max (tmpvar_32.x, tmpvar_32.y);
  uvCont_31.y = min (tmpvar_32.x, tmpvar_32.y);
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_31);
  tmpvar_33.zw = dFdy(uvCont_31);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (cube_MainTexPOS, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (cube_MainTexNEG, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  mediump vec4 tmpvar_38;
  tmpvar_38 = mix (tmpvar_37, tmpvar_35, vec4(float((s_8 >= 0.0))));
  mediump vec4 tmpvar_39;
  tmpvar_39.x = tmpvar_38.w;
  tmpvar_39.y = tmpvar_38.w;
  tmpvar_39.z = tmpvar_38.w;
  tmpvar_39.w = mix (tmpvar_38.y, mix (tmpvar_38.x, tmpvar_38.z, zxlerp_10), nylerp_9);
  mediump vec2 uv_40;
  mediump vec3 detailCoords_41;
  mediump float s_42;
  mediump float nylerp_43;
  mediump float zxlerp_44;
  highp vec3 tmpvar_45;
  tmpvar_45 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_46;
  tmpvar_46 = abs(tmpvar_45);
  highp float tmpvar_47;
  tmpvar_47 = float((tmpvar_46.z >= tmpvar_46.x));
  zxlerp_44 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = float((max (tmpvar_46.x, tmpvar_46.z) >= tmpvar_46.y));
  nylerp_43 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (tmpvar_45.x, tmpvar_45.z, zxlerp_44);
  s_42 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_45.y, s_42, nylerp_43));
  s_42 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(s_42);
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = s_42;
  highp vec3 tmpvar_53;
  tmpvar_53 = mix ((tmpvar_51 * tmpvar_45.xzy), (tmpvar_52 * tmpvar_45.zxy), vec3(zxlerp_44));
  detailCoords_41 = tmpvar_53;
  mediump vec3 tmpvar_54;
  tmpvar_54.xy = vec2(1.0, 1.0);
  tmpvar_54.z = s_42;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_54 * tmpvar_45.yxz), detailCoords_41, vec3(nylerp_43));
  detailCoords_41 = tmpvar_55;
  uv_40 = (((
    (0.5 * detailCoords_41.yz)
   / 
    abs(detailCoords_41.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_56;
  uv_56 = uv_40;
  highp vec2 uvCont_57;
  highp vec2 tmpvar_58;
  tmpvar_58 = abs((uv_56 - (0.5 * _DetailScale)));
  uvCont_57.x = max (tmpvar_58.x, tmpvar_58.y);
  uvCont_57.y = min (tmpvar_58.x, tmpvar_58.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_57);
  tmpvar_59.zw = dFdy(uvCont_57);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_DetailTex, uv_40, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  highp vec3 tmpvar_62;
  tmpvar_62 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_62, tmpvar_62)
  )), 0.0, 1.0);
  tmpvar_63 = tmpvar_64;
  mediump vec4 tmpvar_65;
  tmpvar_65 = ((_Color * tmpvar_39) * mix (tmpvar_61, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_63)));
  color_2 = tmpvar_65;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_66;
  tmpvar_66 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_66;
  mediump vec4 tmpvar_67;
  tmpvar_67 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_67;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexPOS;
uniform lowp sampler2D cube_MainTexNEG;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
highp int ti2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
bool tb4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp vec3 t8;
lowp vec3 t10_9;
mediump vec2 t16_10;
highp vec3 t11;
highp vec3 t12;
bool tb12;
highp vec3 t14;
mediump vec3 t16_14;
bool tb14;
mediump float t16_20;
highp vec2 t21;
bvec2 tb21;
highp vec2 t22;
highp int ti22;
highp int ti24;
bool tb31;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t11.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t11.y);
    tb12 = abs(t11.z)>=abs(t11.y);
    t12.x = tb12 ? 1.0 : float(0.0);
    t2.x = t12.x * t2.x + t11.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t11.z), abs(t11.y));
    tb2 = t2.x>=abs(t11.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t11.x;
    ti22 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti22) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t11.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t11.zyx + (-t4.xyz);
    t4.xyz = t12.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t11.xyz + t4.xyz;
    t1.xyz = t11.xyz * t16_3.xxy;
    tb31 = t16_3.y>=0.0;
    t16_0.x = (tb31) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_10.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_10.xy = t16_10.xy / abs(t1.xx);
    t16_10.xy = t16_10.xy + vec2(0.5, 0.5);
    t1.xy = t16_10.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb21.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb21.x) ? t1.x : (-t1.x);
    t1.y = (tb21.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_10.xy;
    t21.xy = t1.xy + vec2(-0.5, -0.5);
    t22.x = max(abs(t21.y), abs(t21.x));
    t21.x = min(abs(t21.y), abs(t21.x));
    t4.x = dFdx(t22.x);
    t5.x = dFdy(t22.x);
    t4.y = dFdx(t21.x);
    t5.y = dFdy(t21.x);
    t10_3 = textureGrad(cube_MainTexPOS, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexNEG, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = (-t10_1) + t10_3;
    t16_0 = t16_0.xxxx * t16_3 + t10_1;
    t16_20 = (-t16_0.x) + t16_0.z;
    t16_0.x = t12.x * t16_20 + t16_0.x;
    t16_0.x = (-t16_0.y) + t16_0.x;
    t16_1.w = t2.x * t16_0.x + t16_0.y;
    t16_1.xyz = t16_0.www;
    t16_0 = t16_1 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t12.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t4.x = vs_TEXCOORD5.z * t2.x + (-t12.y);
    tb14 = abs(t12.z)>=abs(t12.y);
    t14.x = tb14 ? 1.0 : float(0.0);
    t4.x = t14.x * t4.x + t12.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t4.x;
    t4.x = max(abs(t12.z), abs(t12.y));
    tb4 = t4.x>=abs(t12.x);
    t4.x = tb4 ? 1.0 : float(0.0);
    t2.x = t4.x * t2.x + t12.x;
    ti24 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti24) + ti2;
    t16_7.y = float(ti2);
    t16_6.y = (-t16_7.y);
    t5.xyz = t12.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t8.xyz = t16_7.xyz * t12.zyx + (-t5.xyz);
    t14.xyz = t14.xxx * t8.xyz + t5.xyz;
    t14.xyz = (-t16_7.xxy) * t12.xyz + t14.xyz;
    t2.xyz = t12.xyz * t16_7.xxy;
    t2.xyz = t4.xxx * t14.xyz + t2.xyz;
    t16_6.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_6.xy = t16_6.xy / abs(t2.xx);
    t16_6.xy = t16_6.xy + vec2(0.5, 0.5);
    t2.xy = t16_6.xy * vec2(_DetailScale);
    t22.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t2.xy;
    t4.x = max(abs(t22.y), abs(t22.x));
    t22.x = min(abs(t22.y), abs(t22.x));
    t5.x = dFdx(t4.x);
    t4.x = dFdy(t4.x);
    t5.y = dFdx(t22.x);
    t4.y = dFdy(t22.x);
    t10_1 = textureGrad(_DetailTex, t2.xy, vec4(t5.xyxx).xy, vec4(t4.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t4.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t4.x = dot(t4.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t4.x = clamp(t4.x, 0.0, 1.0);
    t16_1 = t4.xxxx * t16_2 + t10_1;
    t10_9.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_9.xyz = t10_9.xxx * t16_2.xyz;
    t10_9.xyz = clamp(t10_9.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_14.xyz = t10_9.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_14.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t14.x = vs_TEXCOORD2 + 5.0;
    t14.x = t14.x + (-_PlanetRadius);
    t14.x = t14.x * 0.200000003;
    t14.x = clamp(t14.x, 0.0, 1.0);
    t4.x = t14.x * t4.x;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexPOS;
uniform  sampler2D cube_MainTexNEG;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
lowp vec4 t10_5;
vec2 t6;
vec2 t7;
vec3 t8;
int ti8;
bvec2 tb8;
vec3 t9;
int ti9;
float t12;
vec2 t13;
float t18;
int ti18;
bool tb18;
float t19;
int ti19;
bool tb19;
float t20;
bool tb20;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t18 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * vs_TEXCOORD4.yxz;
    t19 = vs_TEXCOORD4.z * t18 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t19 = t2.x * t19 + t1.y;
    t18 = (-vs_TEXCOORD4.y) * t18 + t19;
    t19 = max(abs(t1.z), abs(t1.y));
    tb19 = t19>=abs(t1.x);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.x;
    ti8 = int((0.0<t18) ? 0xFFFFFFFFu : uint(0u));
    ti18 = int((t18<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti18 = (-ti8) + ti18;
    t3.y = float(ti18);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t8.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb18 = t3.y>=0.0;
    t18 = tb18 ? 1.0 : float(0.0);
    t0.xyz = vec3(t19) * t0.xyz + t1.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb8.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb8.x) ? t1.x : (-t1.x);
    t1.y = (tb8.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t12 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t12);
    t4.x = dFdy(t12);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexPOS, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexNEG, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t18) * t16_4 + t10_3;
    t12 = (-t0.x) + t0.z;
    t0.x = t2.x * t12 + t0.x;
    t0.x = (-t0.y) + t0.x;
    t1.w = t19 * t0.x + t0.y;
    t1.xyz = t0.www;
    t0 = t1 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t2.xyz = vec3(t19) * vs_TEXCOORD5.yxz;
    t20 = vs_TEXCOORD5.z * t19 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t20 = t3.x * t20 + t2.y;
    t19 = (-vs_TEXCOORD5.y) * t19 + t20;
    t20 = max(abs(t2.z), abs(t2.y));
    tb20 = t20>=abs(t2.x);
    t20 = tb20 ? 1.0 : float(0.0);
    t19 = t20 * t19 + t2.x;
    ti9 = int((0.0<t19) ? 0xFFFFFFFFu : uint(0u));
    ti19 = int((t19<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti19 = (-ti9) + ti19;
    t4.y = float(ti19);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t9.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t9.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t20) * t1.xyz + t2.xyz;
    t7.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t7.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t13.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t13.y), abs(t13.x));
    t13.x = min(abs(t13.y), abs(t13.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t13.x);
    t2.y = dFdy(t13.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t19 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t19);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t7.x = vs_TEXCOORD2 + 5.0;
    t7.x = t7.x + (-_PlanetRadius);
    t7.x = t7.x * 0.200000003;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t1.x = t7.x * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 107 math, 4 textures, 2 branches
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec4 tmpvar_22;
  tmpvar_22 = mix (texture2DGradARB (cube_MainTexNEG, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexPOS, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))));
  vec4 tmpvar_23;
  tmpvar_23.x = tmpvar_22.w;
  tmpvar_23.y = tmpvar_22.w;
  tmpvar_23.z = tmpvar_22.w;
  tmpvar_23.w = mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_6), tmpvar_7);
  vec4 v_24;
  v_24 = (tmpvar_23 * alphaMask1);
  vec4 tmpvar_25;
  tmpvar_25.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_25.w = ((v_24.x + v_24.y) + (v_24.z + v_24.w));
  vec2 uv_26;
  vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_28;
  tmpvar_28 = abs(tmpvar_27);
  float tmpvar_29;
  tmpvar_29 = float((tmpvar_28.z >= tmpvar_28.x));
  float tmpvar_30;
  tmpvar_30 = float((max (tmpvar_28.x, tmpvar_28.z) >= tmpvar_28.y));
  float tmpvar_31;
  tmpvar_31 = sign(mix (tmpvar_27.y, mix (tmpvar_27.x, tmpvar_27.z, tmpvar_29), tmpvar_30));
  vec3 tmpvar_32;
  tmpvar_32.xz = vec2(1.0, -1.0);
  tmpvar_32.y = -(tmpvar_31);
  vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = tmpvar_31;
  vec3 tmpvar_34;
  tmpvar_34.xy = vec2(1.0, 1.0);
  tmpvar_34.z = tmpvar_31;
  vec3 tmpvar_35;
  tmpvar_35 = mix ((tmpvar_34 * tmpvar_27.yxz), mix ((tmpvar_32 * tmpvar_27.xzy), (tmpvar_33 * tmpvar_27.zxy), vec3(tmpvar_29)), vec3(tmpvar_30));
  uv_26 = (((
    (0.5 * tmpvar_35.yz)
   / 
    abs(tmpvar_35.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_36;
  vec2 tmpvar_37;
  tmpvar_37 = abs((uv_26 - (0.5 * _DetailScale)));
  uvCont_36.x = max (tmpvar_37.x, tmpvar_37.y);
  uvCont_36.y = min (tmpvar_37.x, tmpvar_37.y);
  vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_36);
  tmpvar_38.zw = dFdy(uvCont_36);
  vec3 tmpvar_39;
  tmpvar_39 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_40;
  tmpvar_40 = ((_Color * tmpvar_25) * mix (texture2DGradARB (_DetailTex, uv_26, tmpvar_38.xy, tmpvar_38.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_39, tmpvar_39)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_40.w;
  color_1.xyz = clamp ((tmpvar_40.xyz * (1.0 - tmpvar_40.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_40.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 107 math, 4 textures, 2 branches
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D cube_MainTexPOS;
uniform sampler2D cube_MainTexNEG;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  mediump vec2 uv_6;
  mediump vec3 detailCoords_7;
  mediump float s_8;
  mediump float nylerp_9;
  mediump float zxlerp_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_12;
  tmpvar_12 = abs(tmpvar_11);
  highp float tmpvar_13;
  tmpvar_13 = float((tmpvar_12.z >= tmpvar_12.x));
  zxlerp_10 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = float((max (tmpvar_12.x, tmpvar_12.z) >= tmpvar_12.y));
  nylerp_9 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = mix (tmpvar_11.x, tmpvar_11.z, zxlerp_10);
  s_8 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = sign(mix (tmpvar_11.y, s_8, nylerp_9));
  s_8 = tmpvar_16;
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = -(s_8);
  mediump vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = s_8;
  highp vec3 tmpvar_19;
  tmpvar_19 = mix ((tmpvar_17 * tmpvar_11.xzy), (tmpvar_18 * tmpvar_11.zxy), vec3(zxlerp_10));
  detailCoords_7 = tmpvar_19;
  mediump vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = s_8;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_11.yxz), detailCoords_7, vec3(nylerp_9));
  detailCoords_7 = tmpvar_21;
  mediump vec2 tmpvar_22;
  tmpvar_22 = (((0.5 * detailCoords_7.yz) / abs(detailCoords_7.x)) + 0.5);
  uv_6 = tmpvar_22;
  highp vec2 tmpvar_23;
  tmpvar_23 = (tmpvar_22 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_24;
  tmpvar_24 = (fract(abs(tmpvar_23)) * vec2(_UVNoiseScale));
  highp float tmpvar_25;
  if ((tmpvar_23.x >= 0.0)) {
    tmpvar_25 = tmpvar_24.x;
  } else {
    tmpvar_25 = -(tmpvar_24.x);
  };
  highp float tmpvar_26;
  if ((tmpvar_23.y >= 0.0)) {
    tmpvar_26 = tmpvar_24.y;
  } else {
    tmpvar_26 = -(tmpvar_24.y);
  };
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_25;
  tmpvar_27.y = tmpvar_26;
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2D (_UVNoiseTex, tmpvar_28);
  uv_6 = (tmpvar_22 + ((tmpvar_29.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_30;
  uv_30 = uv_6;
  highp vec2 uvCont_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = abs((uv_30 - 0.5));
  uvCont_31.x = max (tmpvar_32.x, tmpvar_32.y);
  uvCont_31.y = min (tmpvar_32.x, tmpvar_32.y);
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_31);
  tmpvar_33.zw = dFdy(uvCont_31);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (cube_MainTexPOS, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (cube_MainTexNEG, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  mediump vec4 tmpvar_38;
  tmpvar_38 = mix (tmpvar_37, tmpvar_35, vec4(float((s_8 >= 0.0))));
  mediump vec4 tmpvar_39;
  tmpvar_39.x = tmpvar_38.w;
  tmpvar_39.y = tmpvar_38.w;
  tmpvar_39.z = tmpvar_38.w;
  tmpvar_39.w = mix (tmpvar_38.y, mix (tmpvar_38.x, tmpvar_38.z, zxlerp_10), nylerp_9);
  mediump vec4 v_40;
  v_40 = (tmpvar_39 * alphaMask1);
  mediump vec4 tmpvar_41;
  tmpvar_41.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_41.w = ((v_40.x + v_40.y) + (v_40.z + v_40.w));
  mediump vec2 uv_42;
  mediump vec3 detailCoords_43;
  mediump float s_44;
  mediump float nylerp_45;
  mediump float zxlerp_46;
  highp vec3 tmpvar_47;
  tmpvar_47 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_48;
  tmpvar_48 = abs(tmpvar_47);
  highp float tmpvar_49;
  tmpvar_49 = float((tmpvar_48.z >= tmpvar_48.x));
  zxlerp_46 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = float((max (tmpvar_48.x, tmpvar_48.z) >= tmpvar_48.y));
  nylerp_45 = tmpvar_50;
  highp float tmpvar_51;
  tmpvar_51 = mix (tmpvar_47.x, tmpvar_47.z, zxlerp_46);
  s_44 = tmpvar_51;
  highp float tmpvar_52;
  tmpvar_52 = sign(mix (tmpvar_47.y, s_44, nylerp_45));
  s_44 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xz = vec2(1.0, -1.0);
  tmpvar_53.y = -(s_44);
  mediump vec3 tmpvar_54;
  tmpvar_54.xz = vec2(1.0, -1.0);
  tmpvar_54.y = s_44;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_53 * tmpvar_47.xzy), (tmpvar_54 * tmpvar_47.zxy), vec3(zxlerp_46));
  detailCoords_43 = tmpvar_55;
  mediump vec3 tmpvar_56;
  tmpvar_56.xy = vec2(1.0, 1.0);
  tmpvar_56.z = s_44;
  highp vec3 tmpvar_57;
  tmpvar_57 = mix ((tmpvar_56 * tmpvar_47.yxz), detailCoords_43, vec3(nylerp_45));
  detailCoords_43 = tmpvar_57;
  uv_42 = (((
    (0.5 * detailCoords_43.yz)
   / 
    abs(detailCoords_43.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_58;
  uv_58 = uv_42;
  highp vec2 uvCont_59;
  highp vec2 tmpvar_60;
  tmpvar_60 = abs((uv_58 - (0.5 * _DetailScale)));
  uvCont_59.x = max (tmpvar_60.x, tmpvar_60.y);
  uvCont_59.y = min (tmpvar_60.x, tmpvar_60.y);
  highp vec4 tmpvar_61;
  tmpvar_61.xy = dFdx(uvCont_59);
  tmpvar_61.zw = dFdy(uvCont_59);
  lowp vec4 tmpvar_62;
  tmpvar_62 = texture2DGradEXT (_DetailTex, uv_42, tmpvar_61.xy, tmpvar_61.zw);
  mediump vec4 tmpvar_63;
  tmpvar_63 = tmpvar_62;
  highp vec3 tmpvar_64;
  tmpvar_64 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_64, tmpvar_64)
  )), 0.0, 1.0);
  tmpvar_65 = tmpvar_66;
  mediump vec4 tmpvar_67;
  tmpvar_67 = ((_Color * tmpvar_41) * mix (tmpvar_63, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_65)));
  color_2 = tmpvar_67;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_68;
  tmpvar_68 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_68;
  mediump vec4 tmpvar_69;
  tmpvar_69 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_69;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexPOS;
uniform lowp sampler2D cube_MainTexNEG;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec2 t2;
mediump vec4 t16_2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
bool tb4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
lowp vec3 t10_8;
mediump vec3 t16_9;
highp vec3 t10;
highp vec3 t11;
bool tb11;
highp float t13;
mediump vec3 t16_13;
mediump float t16_18;
highp vec2 t19;
bvec2 tb19;
highp float t20;
highp int ti20;
bool tb28;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t10.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t10.y);
    tb11 = abs(t10.z)>=abs(t10.y);
    t11.x = tb11 ? 1.0 : float(0.0);
    t2.x = t11.x * t2.x + t10.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t10.z), abs(t10.y));
    tb2 = t2.x>=abs(t10.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t10.x;
    ti20 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti20) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t10.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t10.zyx + (-t4.xyz);
    t4.xyz = t11.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t10.xyz + t4.xyz;
    t1.xyz = t10.xyz * t16_3.xxy;
    tb28 = t16_3.y>=0.0;
    t16_0.x = (tb28) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_9.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_9.xy = t16_9.xy / abs(t1.xx);
    t16_9.xy = t16_9.xy + vec2(0.5, 0.5);
    t1.xy = t16_9.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb19.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb19.x) ? t1.x : (-t1.x);
    t1.y = (tb19.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_9.xy;
    t19.xy = t1.xy + vec2(-0.5, -0.5);
    t20 = max(abs(t19.y), abs(t19.x));
    t19.x = min(abs(t19.y), abs(t19.x));
    t4.x = dFdx(t20);
    t5.x = dFdy(t20);
    t4.y = dFdx(t19.x);
    t5.y = dFdy(t19.x);
    t10_3 = textureGrad(cube_MainTexPOS, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexNEG, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = (-t10_1) + t10_3;
    t16_0 = t16_0.xxxx * t16_3 + t10_1;
    t16_18 = (-t16_0.x) + t16_0.z;
    t16_0.x = t11.x * t16_18 + t16_0.x;
    t16_0.x = (-t16_0.y) + t16_0.x;
    t16_0.x = t2.x * t16_0.x + t16_0.y;
    t16_9.xyz = t16_0.www;
    t16_9.xy = t16_9.xy * alphaMask1.xy;
    t16_9.x = t16_9.y + t16_9.x;
    t16_9.x = t16_9.z * alphaMask1.z + t16_9.x;
    t16_0.w = t16_0.x * alphaMask1.w + t16_9.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_6.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t1.x = inversesqrt(t1.x);
    t10.xyz = t1.xxx * vs_TEXCOORD5.yxz;
    t2.x = vs_TEXCOORD5.z * t1.x + (-t10.y);
    tb11 = abs(t10.z)>=abs(t10.y);
    t11.x = tb11 ? 1.0 : float(0.0);
    t2.x = t11.x * t2.x + t10.y;
    t1.x = (-vs_TEXCOORD5.y) * t1.x + t2.x;
    t2.x = max(abs(t10.z), abs(t10.y));
    tb2 = t2.x>=abs(t10.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t10.x;
    ti20 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti20) + ti1;
    t16_7.y = float(ti1);
    t16_6.y = (-t16_7.y);
    t4.xyz = t10.yzx * t16_6.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t5.xyz = t16_7.xyz * t10.zyx + (-t4.xyz);
    t11.xyz = t11.xxx * t5.xyz + t4.xyz;
    t11.xyz = (-t16_7.xxy) * t10.xyz + t11.xyz;
    t1.xyz = t10.xyz * t16_7.xxy;
    t1.xyz = t2.xxx * t11.xyz + t1.xyz;
    t16_6.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_6.xy = t16_6.xy / abs(t1.xx);
    t16_6.xy = t16_6.xy + vec2(0.5, 0.5);
    t1.xy = t16_6.xy * vec2(_DetailScale);
    t19.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t19.y), abs(t19.x));
    t19.x = min(abs(t19.y), abs(t19.x));
    t4.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t4.y = dFdx(t19.x);
    t2.y = dFdy(t19.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t4.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t4.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t4.x = dot(t4.xyz, t4.xyz);
    t4.x = sqrt(t4.x);
    t4.x = dot(t4.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t4.x = clamp(t4.x, 0.0, 1.0);
    t16_1 = t4.xxxx * t16_2 + t10_1;
    t10_8.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_8.xyz = t10_8.xxx * t16_2.xyz;
    t10_8.xyz = clamp(t10_8.xyz, 0.0, 1.0);
    t4.x = t16_2.w * _ShadowFactor;
    t16_13.xyz = t10_8.xyz + vec3(-1.0, -1.0, -1.0);
    t4.xyz = t4.xxx * t16_13.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t4.xyz + vec3(-1.0, -1.0, -1.0);
    tb4 = vs_TEXCOORD0.w>=0.0;
    t4.x = tb4 ? 1.0 : float(0.0);
    t4.x = t4.x * vs_TEXCOORD1;
    t13 = vs_TEXCOORD2 + 5.0;
    t13 = t13 + (-_PlanetRadius);
    t13 = t13 * 0.200000003;
    t13 = clamp(t13, 0.0, 1.0);
    t4.x = t13 * t4.x;
    t16_0 = t4.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexPOS;
uniform  sampler2D cube_MainTexNEG;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec3 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
lowp vec4 t10_5;
vec3 t6;
vec2 t7;
vec3 t8;
int ti8;
bvec2 tb8;
vec3 t9;
int ti9;
float t12;
vec2 t13;
float t18;
int ti18;
bool tb18;
float t19;
int ti19;
bool tb19;
float t20;
bool tb20;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t18 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * vs_TEXCOORD4.yxz;
    t19 = vs_TEXCOORD4.z * t18 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t19 = t2.x * t19 + t1.y;
    t18 = (-vs_TEXCOORD4.y) * t18 + t19;
    t19 = max(abs(t1.z), abs(t1.y));
    tb19 = t19>=abs(t1.x);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.x;
    ti8 = int((0.0<t18) ? 0xFFFFFFFFu : uint(0u));
    ti18 = int((t18<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti18 = (-ti8) + ti18;
    t3.y = float(ti18);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t8.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb18 = t3.y>=0.0;
    t18 = tb18 ? 1.0 : float(0.0);
    t0.xyz = vec3(t19) * t0.xyz + t1.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb8.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb8.x) ? t1.x : (-t1.x);
    t1.y = (tb8.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t12 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t12);
    t4.x = dFdy(t12);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexPOS, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexNEG, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t18) * t16_4 + t10_3;
    t12 = (-t0.x) + t0.z;
    t0.x = t2.x * t12 + t0.x;
    t0.x = (-t0.y) + t0.x;
    t0.x = t19 * t0.x + t0.y;
    t6.xyz = t0.www;
    t6.xy = t6.xy * alphaMask1.xy;
    t6.x = t6.y + t6.x;
    t6.x = t6.z * alphaMask1.z + t6.x;
    t0.w = t0.x * alphaMask1.w + t6.x;
    t0.xyz = vec3(1.0, 1.0, 1.0);
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t2.xyz = vec3(t19) * vs_TEXCOORD5.yxz;
    t20 = vs_TEXCOORD5.z * t19 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t20 = t3.x * t20 + t2.y;
    t19 = (-vs_TEXCOORD5.y) * t19 + t20;
    t20 = max(abs(t2.z), abs(t2.y));
    tb20 = t20>=abs(t2.x);
    t20 = tb20 ? 1.0 : float(0.0);
    t19 = t20 * t19 + t2.x;
    ti9 = int((0.0<t19) ? 0xFFFFFFFFu : uint(0u));
    ti19 = int((t19<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti19 = (-ti9) + ti19;
    t4.y = float(ti19);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t9.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t9.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t20) * t1.xyz + t2.xyz;
    t7.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t7.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t13.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t13.y), abs(t13.x));
    t13.x = min(abs(t13.y), abs(t13.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t13.x);
    t2.y = dFdy(t13.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t19 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t19);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t7.x = vs_TEXCOORD2 + 5.0;
    t7.x = t7.x + (-_PlanetRadius);
    t7.x = t7.x * 0.200000003;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t1.x = t7.x * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 108 math, 8 textures, 2 branches
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec2 uv_22;
  vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_23.yxz), mix ((tmpvar_28 * tmpvar_23.xzy), (tmpvar_29 * tmpvar_23.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_22 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  tmpvar_33 = abs((uv_22 - (0.5 * _DetailScale)));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_34;
  tmpvar_34.xy = dFdx(uvCont_32);
  tmpvar_34.zw = dFdy(uvCont_32);
  vec3 tmpvar_35;
  tmpvar_35 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_36;
  tmpvar_36 = ((_Color * mix (
    mix (texture2DGradARB (cube_MainTexyn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexyp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))))
  , 
    mix (mix (texture2DGradARB (cube_MainTexxn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexxp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0)))), mix (texture2DGradARB (cube_MainTexzn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexzp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0)))), vec4(tmpvar_6))
  , vec4(tmpvar_7))) * mix (texture2DGradARB (_DetailTex, uv_22, tmpvar_34.xy, tmpvar_34.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_35, tmpvar_35)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_36.w;
  color_1.xyz = clamp ((tmpvar_36.xyz * (1.0 - tmpvar_36.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_36.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 108 math, 8 textures, 2 branches
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  mediump vec2 uv_6;
  mediump vec3 detailCoords_7;
  mediump float s_8;
  mediump float nylerp_9;
  mediump float zxlerp_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_12;
  tmpvar_12 = abs(tmpvar_11);
  highp float tmpvar_13;
  tmpvar_13 = float((tmpvar_12.z >= tmpvar_12.x));
  zxlerp_10 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = float((max (tmpvar_12.x, tmpvar_12.z) >= tmpvar_12.y));
  nylerp_9 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = mix (tmpvar_11.x, tmpvar_11.z, zxlerp_10);
  s_8 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = sign(mix (tmpvar_11.y, s_8, nylerp_9));
  s_8 = tmpvar_16;
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = -(s_8);
  mediump vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = s_8;
  highp vec3 tmpvar_19;
  tmpvar_19 = mix ((tmpvar_17 * tmpvar_11.xzy), (tmpvar_18 * tmpvar_11.zxy), vec3(zxlerp_10));
  detailCoords_7 = tmpvar_19;
  mediump vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = s_8;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_11.yxz), detailCoords_7, vec3(nylerp_9));
  detailCoords_7 = tmpvar_21;
  mediump vec2 tmpvar_22;
  tmpvar_22 = (((0.5 * detailCoords_7.yz) / abs(detailCoords_7.x)) + 0.5);
  uv_6 = tmpvar_22;
  highp vec2 tmpvar_23;
  tmpvar_23 = (tmpvar_22 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_24;
  tmpvar_24 = (fract(abs(tmpvar_23)) * vec2(_UVNoiseScale));
  highp float tmpvar_25;
  if ((tmpvar_23.x >= 0.0)) {
    tmpvar_25 = tmpvar_24.x;
  } else {
    tmpvar_25 = -(tmpvar_24.x);
  };
  highp float tmpvar_26;
  if ((tmpvar_23.y >= 0.0)) {
    tmpvar_26 = tmpvar_24.y;
  } else {
    tmpvar_26 = -(tmpvar_24.y);
  };
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_25;
  tmpvar_27.y = tmpvar_26;
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2D (_UVNoiseTex, tmpvar_28);
  uv_6 = (tmpvar_22 + ((tmpvar_29.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_30;
  uv_30 = uv_6;
  highp vec2 uvCont_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = abs((uv_30 - 0.5));
  uvCont_31.x = max (tmpvar_32.x, tmpvar_32.y);
  uvCont_31.y = min (tmpvar_32.x, tmpvar_32.y);
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_31);
  tmpvar_33.zw = dFdy(uvCont_31);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (cube_MainTexxn, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (cube_MainTexxp, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  lowp vec4 tmpvar_38;
  tmpvar_38 = texture2DGradEXT (cube_MainTexyn, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_39;
  tmpvar_39 = tmpvar_38;
  lowp vec4 tmpvar_40;
  tmpvar_40 = texture2DGradEXT (cube_MainTexyp, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_41;
  tmpvar_41 = tmpvar_40;
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture2DGradEXT (cube_MainTexzn, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_43;
  tmpvar_43 = tmpvar_42;
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture2DGradEXT (cube_MainTexzp, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_45;
  tmpvar_45 = tmpvar_44;
  mediump vec2 uv_46;
  mediump vec3 detailCoords_47;
  mediump float s_48;
  mediump float nylerp_49;
  mediump float zxlerp_50;
  highp vec3 tmpvar_51;
  tmpvar_51 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_52;
  tmpvar_52 = abs(tmpvar_51);
  highp float tmpvar_53;
  tmpvar_53 = float((tmpvar_52.z >= tmpvar_52.x));
  zxlerp_50 = tmpvar_53;
  highp float tmpvar_54;
  tmpvar_54 = float((max (tmpvar_52.x, tmpvar_52.z) >= tmpvar_52.y));
  nylerp_49 = tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = mix (tmpvar_51.x, tmpvar_51.z, zxlerp_50);
  s_48 = tmpvar_55;
  highp float tmpvar_56;
  tmpvar_56 = sign(mix (tmpvar_51.y, s_48, nylerp_49));
  s_48 = tmpvar_56;
  mediump vec3 tmpvar_57;
  tmpvar_57.xz = vec2(1.0, -1.0);
  tmpvar_57.y = -(s_48);
  mediump vec3 tmpvar_58;
  tmpvar_58.xz = vec2(1.0, -1.0);
  tmpvar_58.y = s_48;
  highp vec3 tmpvar_59;
  tmpvar_59 = mix ((tmpvar_57 * tmpvar_51.xzy), (tmpvar_58 * tmpvar_51.zxy), vec3(zxlerp_50));
  detailCoords_47 = tmpvar_59;
  mediump vec3 tmpvar_60;
  tmpvar_60.xy = vec2(1.0, 1.0);
  tmpvar_60.z = s_48;
  highp vec3 tmpvar_61;
  tmpvar_61 = mix ((tmpvar_60 * tmpvar_51.yxz), detailCoords_47, vec3(nylerp_49));
  detailCoords_47 = tmpvar_61;
  uv_46 = (((
    (0.5 * detailCoords_47.yz)
   / 
    abs(detailCoords_47.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_62;
  uv_62 = uv_46;
  highp vec2 uvCont_63;
  highp vec2 tmpvar_64;
  tmpvar_64 = abs((uv_62 - (0.5 * _DetailScale)));
  uvCont_63.x = max (tmpvar_64.x, tmpvar_64.y);
  uvCont_63.y = min (tmpvar_64.x, tmpvar_64.y);
  highp vec4 tmpvar_65;
  tmpvar_65.xy = dFdx(uvCont_63);
  tmpvar_65.zw = dFdy(uvCont_63);
  lowp vec4 tmpvar_66;
  tmpvar_66 = texture2DGradEXT (_DetailTex, uv_46, tmpvar_65.xy, tmpvar_65.zw);
  mediump vec4 tmpvar_67;
  tmpvar_67 = tmpvar_66;
  highp vec3 tmpvar_68;
  tmpvar_68 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_68, tmpvar_68)
  )), 0.0, 1.0);
  tmpvar_69 = tmpvar_70;
  mediump vec4 tmpvar_71;
  tmpvar_71 = ((_Color * mix (
    mix (tmpvar_39, tmpvar_41, vec4(float((s_8 >= 0.0))))
  , 
    mix (mix (tmpvar_35, tmpvar_37, vec4(float((s_8 >= 0.0)))), mix (tmpvar_43, tmpvar_45, vec4(float((s_8 >= 0.0)))), vec4(zxlerp_10))
  , vec4(nylerp_9))) * mix (tmpvar_67, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_69)));
  color_2 = tmpvar_71;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_72;
  tmpvar_72 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_72;
  mediump vec4 tmpvar_73;
  tmpvar_73 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_73;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexxn;
uniform lowp sampler2D cube_MainTexxp;
uniform lowp sampler2D cube_MainTexyn;
uniform lowp sampler2D cube_MainTexyp;
uniform lowp sampler2D cube_MainTexzn;
uniform lowp sampler2D cube_MainTexzp;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
highp int ti2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
mediump vec4 t16_4;
highp vec3 t5;
bool tb5;
mediump vec4 t16_6;
lowp vec4 t10_6;
highp vec3 t7;
lowp vec4 t10_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
lowp vec3 t10_11;
mediump vec2 t16_12;
highp vec3 t13;
highp vec3 t14;
bool tb14;
highp vec3 t17;
mediump vec3 t16_17;
bool tb17;
highp vec2 t25;
bvec2 tb25;
highp vec2 t26;
highp int ti26;
highp int ti29;
bool tb37;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t13.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t13.y);
    tb14 = abs(t13.z)>=abs(t13.y);
    t14.x = tb14 ? 1.0 : float(0.0);
    t2.x = t14.x * t2.x + t13.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t13.z), abs(t13.y));
    tb2 = t2.x>=abs(t13.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t13.x;
    ti26 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti26) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t13.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t13.zyx + (-t4.xyz);
    t4.xyz = t14.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t13.xyz + t4.xyz;
    t1.xyz = t13.xyz * t16_3.xxy;
    tb37 = t16_3.y>=0.0;
    t16_0.x = (tb37) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_12.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_12.xy = t16_12.xy / abs(t1.xx);
    t16_12.xy = t16_12.xy + vec2(0.5, 0.5);
    t1.xy = t16_12.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb25.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb25.x) ? t1.x : (-t1.x);
    t1.y = (tb25.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_12.xy;
    t25.xy = t1.xy + vec2(-0.5, -0.5);
    t26.x = max(abs(t25.y), abs(t25.x));
    t25.x = min(abs(t25.y), abs(t25.x));
    t4.x = dFdx(t26.x);
    t5.x = dFdy(t26.x);
    t4.y = dFdx(t25.x);
    t5.y = dFdy(t25.x);
    t10_3 = textureGrad(cube_MainTexzp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = t10_3 + (-t10_6);
    t16_3 = t16_0.xxxx * t16_3 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t16_6 = t16_0.xxxx * t16_6 + t10_7;
    t16_3 = t16_3 + (-t16_6);
    t16_3 = t14.xxxx * t16_3 + t16_6;
    t10_6 = textureGrad(cube_MainTexyp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexyn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_4 = (-t10_1) + t10_6;
    t16_0 = t16_0.xxxx * t16_4 + t10_1;
    t16_1 = (-t16_0) + t16_3;
    t16_0 = t2.xxxx * t16_1 + t16_0;
    t16_0 = t16_0 * _Color;
    t16_8.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t14.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t5.x = vs_TEXCOORD5.z * t2.x + (-t14.y);
    tb17 = abs(t14.z)>=abs(t14.y);
    t17.x = tb17 ? 1.0 : float(0.0);
    t5.x = t17.x * t5.x + t14.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t5.x;
    t5.x = max(abs(t14.z), abs(t14.y));
    tb5 = t5.x>=abs(t14.x);
    t5.x = tb5 ? 1.0 : float(0.0);
    t2.x = t5.x * t2.x + t14.x;
    ti29 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti29) + ti2;
    t16_9.y = float(ti2);
    t16_8.y = (-t16_9.y);
    t7.xyz = t14.yzx * t16_8.xyz;
    t16_9.xz = vec2(1.0, -1.0);
    t10.xyz = t16_9.xyz * t14.zyx + (-t7.xyz);
    t17.xyz = t17.xxx * t10.xyz + t7.xyz;
    t17.xyz = (-t16_9.xxy) * t14.xyz + t17.xyz;
    t2.xyz = t14.xyz * t16_9.xxy;
    t2.xyz = t5.xxx * t17.xyz + t2.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(_DetailScale);
    t26.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t2.xy;
    t5.x = max(abs(t26.y), abs(t26.x));
    t26.x = min(abs(t26.y), abs(t26.x));
    t7.x = dFdx(t5.x);
    t5.x = dFdy(t5.x);
    t7.y = dFdx(t26.x);
    t5.y = dFdy(t26.x);
    t10_1 = textureGrad(_DetailTex, t2.xy, vec4(t7.xyxx).xy, vec4(t5.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_11.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_11.xyz = t10_11.xxx * t16_2.xyz;
    t10_11.xyz = clamp(t10_11.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_17.xyz = t10_11.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_17.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t17.x = vs_TEXCOORD2 + 5.0;
    t17.x = t17.x + (-_PlanetRadius);
    t17.x = t17.x * 0.200000003;
    t17.x = clamp(t17.x, 0.0, 1.0);
    t5.x = t17.x * t5.x;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexxn;
uniform  sampler2D cube_MainTexxp;
uniform  sampler2D cube_MainTexyn;
uniform  sampler2D cube_MainTexyp;
uniform  sampler2D cube_MainTexzn;
uniform  sampler2D cube_MainTexzp;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec4 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
vec4 t5;
mediump vec4 t16_5;
lowp vec4 t10_5;
vec4 t6;
mediump vec4 t16_6;
lowp vec4 t10_6;
lowp vec4 t10_7;
vec2 t8;
vec2 t9;
vec3 t10;
int ti10;
bvec2 tb10;
vec3 t11;
int ti11;
float t16;
vec2 t17;
float t24;
int ti24;
bool tb24;
float t25;
int ti25;
bool tb25;
float t26;
bool tb26;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t24 = inversesqrt(t24);
    t1.xyz = vec3(t24) * vs_TEXCOORD4.yxz;
    t25 = vs_TEXCOORD4.z * t24 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t25 = t2.x * t25 + t1.y;
    t24 = (-vs_TEXCOORD4.y) * t24 + t25;
    t25 = max(abs(t1.z), abs(t1.y));
    tb25 = t25>=abs(t1.x);
    t25 = tb25 ? 1.0 : float(0.0);
    t24 = t25 * t24 + t1.x;
    ti10 = int((0.0<t24) ? 0xFFFFFFFFu : uint(0u));
    ti24 = int((t24<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti24 = (-ti10) + ti24;
    t3.y = float(ti24);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t10.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t10.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb24 = t3.y>=0.0;
    t24 = tb24 ? 1.0 : float(0.0);
    t0.xyz = vec3(t25) * t0.xyz + t1.xyz;
    t8.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t8.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb10.x) ? t1.x : (-t1.x);
    t1.y = (tb10.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t16 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t16);
    t4.x = dFdy(t16);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexzp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_5 = t10_5 + (-t10_6);
    t5 = vec4(t24) * t16_5 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t6 = vec4(t24) * t16_6 + t10_7;
    t5 = t5 + (-t6);
    t2 = t2.xxxx * t5 + t6;
    t10_5 = textureGrad(cube_MainTexyp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexyn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t24) * t16_4 + t10_3;
    t2 = (-t0) + t2;
    t0 = vec4(t25) * t2 + t0;
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t25 = inversesqrt(t25);
    t2.xyz = vec3(t25) * vs_TEXCOORD5.yxz;
    t26 = vs_TEXCOORD5.z * t25 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t26 = t3.x * t26 + t2.y;
    t25 = (-vs_TEXCOORD5.y) * t25 + t26;
    t26 = max(abs(t2.z), abs(t2.y));
    tb26 = t26>=abs(t2.x);
    t26 = tb26 ? 1.0 : float(0.0);
    t25 = t26 * t25 + t2.x;
    ti11 = int((0.0<t25) ? 0xFFFFFFFFu : uint(0u));
    ti25 = int((t25<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti25 = (-ti11) + ti25;
    t4.y = float(ti25);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t11.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t11.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t26) * t1.xyz + t2.xyz;
    t9.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t9.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t25 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t25);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t9.x = vs_TEXCOORD2 + 5.0;
    t9.x = t9.x + (-_PlanetRadius);
    t9.x = t9.x * 0.200000003;
    t9.x = clamp(t9.x, 0.0, 1.0);
    t1.x = t9.x * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 113 math, 8 textures, 2 branches
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GLSL#version 120

#ifdef VERTEX

uniform mat4 _Object2World;
uniform mat4 _MainRotation;
uniform mat4 _DetailRotation;
uniform vec4 _SunDir;
uniform float _Radius;
uniform vec3 _PlanetOrigin;
uniform mat4 _Projector;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 planetPos_1;
  vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * gl_Vertex);
  vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = (_Projector * gl_Vertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _Time;
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 alphaMask1;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform float _DetailScale;
uniform float _DetailDist;
uniform float _UVNoiseScale;
uniform float _UVNoiseStrength;
uniform vec2 _UVNoiseAnimation;
uniform float _PlanetRadius;
uniform float _ShadowFactor;
varying vec4 xlv_TEXCOORD0;
varying float xlv_TEXCOORD1;
varying float xlv_TEXCOORD2;
varying vec4 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 color_1;
  float shadowCheck_2;
  shadowCheck_2 = ((float(
    (xlv_TEXCOORD0.w >= 0.0)
  ) * xlv_TEXCOORD1) * clamp ((0.2 * 
    ((xlv_TEXCOORD2 + 5.0) - _PlanetRadius)
  ), 0.0, 1.0));
  vec2 uv_3;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD4);
  vec3 tmpvar_5;
  tmpvar_5 = abs(tmpvar_4);
  float tmpvar_6;
  tmpvar_6 = float((tmpvar_5.z >= tmpvar_5.x));
  float tmpvar_7;
  tmpvar_7 = float((max (tmpvar_5.x, tmpvar_5.z) >= tmpvar_5.y));
  float tmpvar_8;
  tmpvar_8 = sign(mix (tmpvar_4.y, mix (tmpvar_4.x, tmpvar_4.z, tmpvar_6), tmpvar_7));
  vec3 tmpvar_9;
  tmpvar_9.xz = vec2(1.0, -1.0);
  tmpvar_9.y = -(tmpvar_8);
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = tmpvar_8;
  vec3 tmpvar_11;
  tmpvar_11.xy = vec2(1.0, 1.0);
  tmpvar_11.z = tmpvar_8;
  vec3 tmpvar_12;
  tmpvar_12 = mix ((tmpvar_11 * tmpvar_4.yxz), mix ((tmpvar_9 * tmpvar_4.xzy), (tmpvar_10 * tmpvar_4.zxy), vec3(tmpvar_6)), vec3(tmpvar_7));
  vec2 tmpvar_13;
  tmpvar_13 = (((0.5 * tmpvar_12.yz) / abs(tmpvar_12.x)) + 0.5);
  uv_3 = tmpvar_13;
  vec2 tmpvar_14;
  tmpvar_14 = (tmpvar_13 / vec2(_UVNoiseScale));
  vec2 tmpvar_15;
  tmpvar_15 = (fract(abs(tmpvar_14)) * vec2(_UVNoiseScale));
  float tmpvar_16;
  if ((tmpvar_14.x >= 0.0)) {
    tmpvar_16 = tmpvar_15.x;
  } else {
    tmpvar_16 = -(tmpvar_15.x);
  };
  float tmpvar_17;
  if ((tmpvar_14.y >= 0.0)) {
    tmpvar_17 = tmpvar_15.y;
  } else {
    tmpvar_17 = -(tmpvar_15.y);
  };
  vec2 tmpvar_18;
  tmpvar_18.x = tmpvar_16;
  tmpvar_18.y = tmpvar_17;
  uv_3 = (tmpvar_13 + ((texture2D (_UVNoiseTex, 
    ((tmpvar_18 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx))
  ).xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  vec2 uvCont_19;
  vec2 tmpvar_20;
  tmpvar_20 = abs((uv_3 - 0.5));
  uvCont_19.x = max (tmpvar_20.x, tmpvar_20.y);
  uvCont_19.y = min (tmpvar_20.x, tmpvar_20.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_19);
  tmpvar_21.zw = dFdy(uvCont_19);
  vec4 v_22;
  v_22 = (mix (mix (texture2DGradARB (cube_MainTexyn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexyp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(
    float((tmpvar_8 >= 0.0))
  )), mix (
    mix (texture2DGradARB (cube_MainTexxn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexxp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))))
  , 
    mix (texture2DGradARB (cube_MainTexzn, uv_3, tmpvar_21.xy, tmpvar_21.zw), texture2DGradARB (cube_MainTexzp, uv_3, tmpvar_21.xy, tmpvar_21.zw), vec4(float((tmpvar_8 >= 0.0))))
  , vec4(tmpvar_6)), vec4(tmpvar_7)) * alphaMask1);
  vec4 tmpvar_23;
  tmpvar_23.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_23.w = ((v_22.x + v_22.y) + (v_22.z + v_22.w));
  vec2 uv_24;
  vec3 tmpvar_25;
  tmpvar_25 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_25);
  float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_25.y, mix (tmpvar_25.x, tmpvar_25.z, tmpvar_27), tmpvar_28));
  vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(tmpvar_29);
  vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = tmpvar_29;
  vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = tmpvar_29;
  vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_25.yxz), mix ((tmpvar_30 * tmpvar_25.xzy), (tmpvar_31 * tmpvar_25.zxy), vec3(tmpvar_27)), vec3(tmpvar_28));
  uv_24 = (((
    (0.5 * tmpvar_33.yz)
   / 
    abs(tmpvar_33.x)
  ) + 0.5) * _DetailScale);
  vec2 uvCont_34;
  vec2 tmpvar_35;
  tmpvar_35 = abs((uv_24 - (0.5 * _DetailScale)));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  vec4 tmpvar_36;
  tmpvar_36.xy = dFdx(uvCont_34);
  tmpvar_36.zw = dFdy(uvCont_34);
  vec3 tmpvar_37;
  tmpvar_37 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_38;
  tmpvar_38 = ((_Color * tmpvar_23) * mix (texture2DGradARB (_DetailTex, uv_24, tmpvar_36.xy, tmpvar_36.zw), vec4(1.0, 1.0, 1.0, 1.0), vec4(clamp (
    ((2.0 * _DetailDist) * sqrt(dot (tmpvar_37, tmpvar_37)))
  , 0.0, 1.0))));
  color_1.w = tmpvar_38.w;
  color_1.xyz = clamp ((tmpvar_38.xyz * (1.0 - tmpvar_38.w)), 0.0, 1.0);
  color_1.xyz = vec3(mix (1.0, color_1.x, (_ShadowFactor * tmpvar_38.w)));
  gl_FragData[0] = vec4(mix (1.0, color_1.x, shadowCheck_2));
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 53 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
Matrix 16 [_DetailRotation] 3
Matrix 8 [_MainRotation]
Matrix 4 [_Object2World]
Matrix 12 [_Projector]
Matrix 0 [glstate_matrix_mvp]
Vector 21 [_PlanetOrigin]
Float 20 [_Radius]
Vector 19 [_SunDir]
"vs_3_0
def c22, 100, 0, 0, 0
dcl_position v0
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2.x
dcl_texcoord2 o3.x
dcl_texcoord3 o4
dcl_texcoord4 o5.xyz
dcl_texcoord5 o6.xyz
dp4 o1.x, c12, v0
dp4 o1.y, c13, v0
dp4 o1.z, c14, v0
dp4 o1.w, c15, v0
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, -r0, c21
dp3 r1.w, r1, r1
rsq r2.x, r1.w
mul r2.yzw, r1.xxyz, r2.x
rcp r2.x, r2.x
dp3 r1.x, r1, -c19
dp3 r1.y, r2.yzww, c19
mul_sat r1.y, r1.y, c22.x
sge r1.z, c20.x, r2.x
mov o3.x, r2.x
mul o2.x, r1.y, r1.z
mad r1.y, r1.x, -r1.x, r1.w
rsq r1.y, r1.y
rcp r1.y, r1.y
mad r1.w, r1.y, -r1.y, r1.w
mul r1.y, r1.y, r1.y
mad r1.y, c20.x, c20.x, -r1.y
rsq r1.y, r1.y
rcp r1.y, r1.y
rsq r1.w, r1.w
rcp r1.w, r1.w
add r1.w, -r1.w, r1.y
add r2.x, -r1.y, r1.x
add r1.y, r1.y, r1.x
sge r1.x, r1.x, c22.y
lrp r2.y, r1.x, r1.y, r1.w
lrp r3.x, r1.x, r2.x, r1.w
lrp r4.x, r1.z, r2.y, r3.x
dp4 r0.w, c7, v0
mad r1, -c19, r4.x, r0
mov o4, r0
dp4 r0.w, c11, r1
dp4 r0.x, c8, r1
dp4 r0.y, c9, r1
dp4 r0.z, c10, r1
dp4 o6.x, c16, r0
dp4 o6.y, c17, r0
dp4 o6.z, c18, r0
mov o5.xyz, r0

"
}
SubProgram "d3d11 " {
// Stats: 49 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
Bind "vertex" Vertex
ConstBuffer "$Globals" 544
Matrix 144 [_MainRotation]
Matrix 208 [_DetailRotation]
Matrix 480 [_Projector]
Vector 432 [_SunDir]
Float 448 [_Radius]
Vector 464 [_PlanetOrigin] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerDraw" 1
"vs_4_0
root12:aaacaaaa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"
}
SubProgram "gles " {
// Stats: 113 math, 8 textures, 2 branches
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _MainRotation;
uniform highp mat4 _DetailRotation;
uniform highp vec4 _SunDir;
uniform highp float _Radius;
uniform highp vec3 _PlanetOrigin;
uniform highp mat4 _Projector;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec4 planetPos_1;
  highp vec4 tmpvar_2;
  tmpvar_2 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_3;
  tmpvar_3 = (_PlanetOrigin - tmpvar_2.xyz);
  highp float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  highp float tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6 = -(_SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  highp float tmpvar_7;
  highp float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  highp float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  highp float tmpvar_10;
  tmpvar_10 = sqrt(((_Radius * _Radius) - tmpvar_7));
  planetPos_1 = (_MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_Radius >= tmpvar_4)))
  )));
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = (_Projector * _glesVertex);
  xlv_TEXCOORD1 = (float((_Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _SunDir.xyz)
   * 100.0), 0.0, 1.0));
  xlv_TEXCOORD2 = tmpvar_4;
  xlv_TEXCOORD3 = tmpvar_2;
  xlv_TEXCOORD4 = planetPos_1.xyz;
  xlv_TEXCOORD5 = (_DetailRotation * planetPos_1).xyz;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform highp vec4 _Time;
uniform highp vec3 _WorldSpaceCameraPos;
uniform mediump vec4 alphaMask1;
uniform sampler2D cube_MainTexxn;
uniform sampler2D cube_MainTexxp;
uniform sampler2D cube_MainTexyn;
uniform sampler2D cube_MainTexyp;
uniform sampler2D cube_MainTexzn;
uniform sampler2D cube_MainTexzp;
uniform lowp vec4 _Color;
uniform sampler2D _DetailTex;
uniform sampler2D _UVNoiseTex;
uniform highp float _DetailScale;
uniform highp float _DetailDist;
uniform highp float _UVNoiseScale;
uniform highp float _UVNoiseStrength;
uniform highp vec2 _UVNoiseAnimation;
uniform highp float _PlanetRadius;
uniform highp float _ShadowFactor;
varying highp vec4 xlv_TEXCOORD0;
varying highp float xlv_TEXCOORD1;
varying highp float xlv_TEXCOORD2;
varying highp vec4 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  lowp vec4 color_2;
  mediump float shadowCheck_3;
  highp float tmpvar_4;
  tmpvar_4 = (float((xlv_TEXCOORD0.w >= 0.0)) * xlv_TEXCOORD1);
  shadowCheck_3 = tmpvar_4;
  highp float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (xlv_TEXCOORD2 + 5.0)
   - _PlanetRadius)), 0.0, 1.0);
  shadowCheck_3 = (shadowCheck_3 * tmpvar_5);
  mediump vec2 uv_6;
  mediump vec3 detailCoords_7;
  mediump float s_8;
  mediump float nylerp_9;
  mediump float zxlerp_10;
  highp vec3 tmpvar_11;
  tmpvar_11 = normalize(xlv_TEXCOORD4);
  highp vec3 tmpvar_12;
  tmpvar_12 = abs(tmpvar_11);
  highp float tmpvar_13;
  tmpvar_13 = float((tmpvar_12.z >= tmpvar_12.x));
  zxlerp_10 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = float((max (tmpvar_12.x, tmpvar_12.z) >= tmpvar_12.y));
  nylerp_9 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = mix (tmpvar_11.x, tmpvar_11.z, zxlerp_10);
  s_8 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = sign(mix (tmpvar_11.y, s_8, nylerp_9));
  s_8 = tmpvar_16;
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = -(s_8);
  mediump vec3 tmpvar_18;
  tmpvar_18.xz = vec2(1.0, -1.0);
  tmpvar_18.y = s_8;
  highp vec3 tmpvar_19;
  tmpvar_19 = mix ((tmpvar_17 * tmpvar_11.xzy), (tmpvar_18 * tmpvar_11.zxy), vec3(zxlerp_10));
  detailCoords_7 = tmpvar_19;
  mediump vec3 tmpvar_20;
  tmpvar_20.xy = vec2(1.0, 1.0);
  tmpvar_20.z = s_8;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_20 * tmpvar_11.yxz), detailCoords_7, vec3(nylerp_9));
  detailCoords_7 = tmpvar_21;
  mediump vec2 tmpvar_22;
  tmpvar_22 = (((0.5 * detailCoords_7.yz) / abs(detailCoords_7.x)) + 0.5);
  uv_6 = tmpvar_22;
  highp vec2 tmpvar_23;
  tmpvar_23 = (tmpvar_22 / vec2(_UVNoiseScale));
  highp vec2 tmpvar_24;
  tmpvar_24 = (fract(abs(tmpvar_23)) * vec2(_UVNoiseScale));
  highp float tmpvar_25;
  if ((tmpvar_23.x >= 0.0)) {
    tmpvar_25 = tmpvar_24.x;
  } else {
    tmpvar_25 = -(tmpvar_24.x);
  };
  highp float tmpvar_26;
  if ((tmpvar_23.y >= 0.0)) {
    tmpvar_26 = tmpvar_24.y;
  } else {
    tmpvar_26 = -(tmpvar_24.y);
  };
  highp vec2 tmpvar_27;
  tmpvar_27.x = tmpvar_25;
  tmpvar_27.y = tmpvar_26;
  highp vec2 tmpvar_28;
  tmpvar_28 = ((tmpvar_27 / _UVNoiseScale) + (_UVNoiseAnimation * _Time.xx));
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2D (_UVNoiseTex, tmpvar_28);
  uv_6 = (tmpvar_22 + ((tmpvar_29.xy - vec2(0.5, 0.5)) * _UVNoiseStrength));
  highp vec2 uv_30;
  uv_30 = uv_6;
  highp vec2 uvCont_31;
  highp vec2 tmpvar_32;
  tmpvar_32 = abs((uv_30 - 0.5));
  uvCont_31.x = max (tmpvar_32.x, tmpvar_32.y);
  uvCont_31.y = min (tmpvar_32.x, tmpvar_32.y);
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_31);
  tmpvar_33.zw = dFdy(uvCont_31);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (cube_MainTexxn, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (cube_MainTexxp, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  lowp vec4 tmpvar_38;
  tmpvar_38 = texture2DGradEXT (cube_MainTexyn, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_39;
  tmpvar_39 = tmpvar_38;
  lowp vec4 tmpvar_40;
  tmpvar_40 = texture2DGradEXT (cube_MainTexyp, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_41;
  tmpvar_41 = tmpvar_40;
  lowp vec4 tmpvar_42;
  tmpvar_42 = texture2DGradEXT (cube_MainTexzn, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_43;
  tmpvar_43 = tmpvar_42;
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture2DGradEXT (cube_MainTexzp, uv_6, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_45;
  tmpvar_45 = tmpvar_44;
  mediump vec4 v_46;
  v_46 = (mix (mix (tmpvar_39, tmpvar_41, vec4(
    float((s_8 >= 0.0))
  )), mix (
    mix (tmpvar_35, tmpvar_37, vec4(float((s_8 >= 0.0))))
  , 
    mix (tmpvar_43, tmpvar_45, vec4(float((s_8 >= 0.0))))
  , vec4(zxlerp_10)), vec4(nylerp_9)) * alphaMask1);
  mediump vec4 tmpvar_47;
  tmpvar_47.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_47.w = ((v_46.x + v_46.y) + (v_46.z + v_46.w));
  mediump vec2 uv_48;
  mediump vec3 detailCoords_49;
  mediump float s_50;
  mediump float nylerp_51;
  mediump float zxlerp_52;
  highp vec3 tmpvar_53;
  tmpvar_53 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_54;
  tmpvar_54 = abs(tmpvar_53);
  highp float tmpvar_55;
  tmpvar_55 = float((tmpvar_54.z >= tmpvar_54.x));
  zxlerp_52 = tmpvar_55;
  highp float tmpvar_56;
  tmpvar_56 = float((max (tmpvar_54.x, tmpvar_54.z) >= tmpvar_54.y));
  nylerp_51 = tmpvar_56;
  highp float tmpvar_57;
  tmpvar_57 = mix (tmpvar_53.x, tmpvar_53.z, zxlerp_52);
  s_50 = tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = sign(mix (tmpvar_53.y, s_50, nylerp_51));
  s_50 = tmpvar_58;
  mediump vec3 tmpvar_59;
  tmpvar_59.xz = vec2(1.0, -1.0);
  tmpvar_59.y = -(s_50);
  mediump vec3 tmpvar_60;
  tmpvar_60.xz = vec2(1.0, -1.0);
  tmpvar_60.y = s_50;
  highp vec3 tmpvar_61;
  tmpvar_61 = mix ((tmpvar_59 * tmpvar_53.xzy), (tmpvar_60 * tmpvar_53.zxy), vec3(zxlerp_52));
  detailCoords_49 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62.xy = vec2(1.0, 1.0);
  tmpvar_62.z = s_50;
  highp vec3 tmpvar_63;
  tmpvar_63 = mix ((tmpvar_62 * tmpvar_53.yxz), detailCoords_49, vec3(nylerp_51));
  detailCoords_49 = tmpvar_63;
  uv_48 = (((
    (0.5 * detailCoords_49.yz)
   / 
    abs(detailCoords_49.x)
  ) + 0.5) * _DetailScale);
  highp vec2 uv_64;
  uv_64 = uv_48;
  highp vec2 uvCont_65;
  highp vec2 tmpvar_66;
  tmpvar_66 = abs((uv_64 - (0.5 * _DetailScale)));
  uvCont_65.x = max (tmpvar_66.x, tmpvar_66.y);
  uvCont_65.y = min (tmpvar_66.x, tmpvar_66.y);
  highp vec4 tmpvar_67;
  tmpvar_67.xy = dFdx(uvCont_65);
  tmpvar_67.zw = dFdy(uvCont_65);
  lowp vec4 tmpvar_68;
  tmpvar_68 = texture2DGradEXT (_DetailTex, uv_48, tmpvar_67.xy, tmpvar_67.zw);
  mediump vec4 tmpvar_69;
  tmpvar_69 = tmpvar_68;
  highp vec3 tmpvar_70;
  tmpvar_70 = (xlv_TEXCOORD3.xyz - _WorldSpaceCameraPos);
  mediump float tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = clamp (((2.0 * _DetailDist) * sqrt(
    dot (tmpvar_70, tmpvar_70)
  )), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  mediump vec4 tmpvar_73;
  tmpvar_73 = ((_Color * tmpvar_47) * mix (tmpvar_69, vec4(1.0, 1.0, 1.0, 1.0), vec4(tmpvar_71)));
  color_2 = tmpvar_73;
  color_2.xyz = clamp ((color_2.xyz * (1.0 - color_2.w)), 0.0, 1.0);
  highp vec3 tmpvar_74;
  tmpvar_74 = vec3(mix (1.0, color_2.x, (_ShadowFactor * color_2.w)));
  color_2.xyz = tmpvar_74;
  mediump vec4 tmpvar_75;
  tmpvar_75 = vec4(mix (1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_75;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in highp vec4 in_POSITION0;
out highp vec4 vs_TEXCOORD0;
out highp float vs_TEXCOORD1;
out highp float vs_TEXCOORD2;
out highp vec4 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD4;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec4 t1;
bool tb1;
highp vec3 t2;
bool tb2;
highp vec3 t4;
highp float t7;
highp float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	lowp vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform lowp sampler2D _UVNoiseTex;
uniform lowp sampler2D cube_MainTexxn;
uniform lowp sampler2D cube_MainTexxp;
uniform lowp sampler2D cube_MainTexyn;
uniform lowp sampler2D cube_MainTexyp;
uniform lowp sampler2D cube_MainTexzn;
uniform lowp sampler2D cube_MainTexzp;
uniform lowp sampler2D _DetailTex;
in highp vec4 vs_TEXCOORD0;
in highp float vs_TEXCOORD1;
in highp float vs_TEXCOORD2;
in highp vec4 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
highp int ti1;
highp vec3 t2;
mediump vec4 t16_2;
highp int ti2;
bool tb2;
mediump vec4 t16_3;
lowp vec4 t10_3;
highp vec3 t4;
mediump vec4 t16_4;
highp vec3 t5;
bool tb5;
mediump vec4 t16_6;
lowp vec4 t10_6;
highp vec3 t7;
lowp vec4 t10_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
lowp vec3 t10_11;
mediump vec2 t16_12;
highp vec3 t13;
highp vec3 t14;
bool tb14;
highp vec3 t17;
mediump vec3 t16_17;
bool tb17;
highp vec2 t25;
bvec2 tb25;
highp vec2 t26;
highp int ti26;
highp int ti29;
bool tb37;
void main()
{
    t16_0.xz = vec2(1.0, -1.0);
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t13.xyz = t1.xxx * vs_TEXCOORD4.yxz;
    t2.x = vs_TEXCOORD4.z * t1.x + (-t13.y);
    tb14 = abs(t13.z)>=abs(t13.y);
    t14.x = tb14 ? 1.0 : float(0.0);
    t2.x = t14.x * t2.x + t13.y;
    t1.x = (-vs_TEXCOORD4.y) * t1.x + t2.x;
    t2.x = max(abs(t13.z), abs(t13.y));
    tb2 = t2.x>=abs(t13.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t1.x = t2.x * t1.x + t13.x;
    ti26 = int((0.0<t1.x) ? 0xFFFFFFFFu : uint(0u));
    ti1 = int((t1.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti1 = (-ti26) + ti1;
    t16_3.y = float(ti1);
    t16_0.y = (-t16_3.y);
    t4.xyz = t16_0.xyz * t13.yzx;
    t16_3.xz = vec2(1.0, -1.0);
    t5.xyz = t16_3.xyz * t13.zyx + (-t4.xyz);
    t4.xyz = t14.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t16_3.xxy) * t13.xyz + t4.xyz;
    t1.xyz = t13.xyz * t16_3.xxy;
    tb37 = t16_3.y>=0.0;
    t16_0.x = (tb37) ? 1.0 : 0.0;
    t1.xyz = t2.xxx * t4.xyz + t1.xyz;
    t16_12.xy = vec2(t1.y * float(0.5), t1.z * float(0.5));
    t16_12.xy = t16_12.xy / abs(t1.xx);
    t16_12.xy = t16_12.xy + vec2(0.5, 0.5);
    t1.xy = t16_12.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb25.xy = greaterThanEqual(t1.xyxy, (-t1.xyxy)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb25.x) ? t1.x : (-t1.x);
    t1.y = (tb25.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_1.xy = texture(_UVNoiseTex, t1.xy).xy;
    t16_1.xy = t10_1.xy + vec2(-0.5, -0.5);
    t1.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t16_12.xy;
    t25.xy = t1.xy + vec2(-0.5, -0.5);
    t26.x = max(abs(t25.y), abs(t25.x));
    t25.x = min(abs(t25.y), abs(t25.x));
    t4.x = dFdx(t26.x);
    t5.x = dFdy(t26.x);
    t4.y = dFdx(t25.x);
    t5.y = dFdy(t25.x);
    t10_3 = textureGrad(cube_MainTexzp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_3 = t10_3 + (-t10_6);
    t16_3 = t16_0.xxxx * t16_3 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t16_6 = t16_0.xxxx * t16_6 + t10_7;
    t16_3 = t16_3 + (-t16_6);
    t16_3 = t14.xxxx * t16_3 + t16_6;
    t10_6 = textureGrad(cube_MainTexyp, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_1 = textureGrad(cube_MainTexyn, t1.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_4 = (-t10_1) + t10_6;
    t16_0 = t16_0.xxxx * t16_4 + t10_1;
    t16_1 = (-t16_0) + t16_3;
    t16_0 = t2.xxxx * t16_1 + t16_0;
    t16_0.xy = t16_0.xy * alphaMask1.xy;
    t16_0.x = t16_0.y + t16_0.x;
    t16_0.x = t16_0.z * alphaMask1.z + t16_0.x;
    t16_0.w = t16_0.w * alphaMask1.w + t16_0.x;
    t16_0.xyz = vec3(1.0, 1.0, 1.0);
    t16_0 = t16_0 * _Color;
    t16_8.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t14.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t5.x = vs_TEXCOORD5.z * t2.x + (-t14.y);
    tb17 = abs(t14.z)>=abs(t14.y);
    t17.x = tb17 ? 1.0 : float(0.0);
    t5.x = t17.x * t5.x + t14.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t5.x;
    t5.x = max(abs(t14.z), abs(t14.y));
    tb5 = t5.x>=abs(t14.x);
    t5.x = tb5 ? 1.0 : float(0.0);
    t2.x = t5.x * t2.x + t14.x;
    ti29 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti29) + ti2;
    t16_9.y = float(ti2);
    t16_8.y = (-t16_9.y);
    t7.xyz = t14.yzx * t16_8.xyz;
    t16_9.xz = vec2(1.0, -1.0);
    t10.xyz = t16_9.xyz * t14.zyx + (-t7.xyz);
    t17.xyz = t17.xxx * t10.xyz + t7.xyz;
    t17.xyz = (-t16_9.xxy) * t14.xyz + t17.xyz;
    t2.xyz = t14.xyz * t16_9.xxy;
    t2.xyz = t5.xxx * t17.xyz + t2.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(_DetailScale);
    t26.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t2.xy;
    t5.x = max(abs(t26.y), abs(t26.x));
    t26.x = min(abs(t26.y), abs(t26.x));
    t7.x = dFdx(t5.x);
    t5.x = dFdy(t5.x);
    t7.y = dFdx(t26.x);
    t5.y = dFdy(t26.x);
    t10_1 = textureGrad(_DetailTex, t2.xy, vec4(t7.xyxx).xy, vec4(t5.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t5.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t5.x = dot(t5.xyz, t5.xyz);
    t5.x = sqrt(t5.x);
    t5.x = dot(t5.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t5.x = clamp(t5.x, 0.0, 1.0);
    t16_1 = t5.xxxx * t16_2 + t10_1;
    t10_11.x = (-t16_0.w) * t16_1.w + 1.0;
    t16_2 = t16_0 * t16_1;
    t16_0.w = t16_0.w * t16_1.w + -1.0;
    t10_11.xyz = t10_11.xxx * t16_2.xyz;
    t10_11.xyz = clamp(t10_11.xyz, 0.0, 1.0);
    t5.x = t16_2.w * _ShadowFactor;
    t16_17.xyz = t10_11.xyz + vec3(-1.0, -1.0, -1.0);
    t5.xyz = t5.xxx * t16_17.xyz + vec3(1.0, 1.0, 1.0);
    t16_0.xyz = t5.xyz + vec3(-1.0, -1.0, -1.0);
    tb5 = vs_TEXCOORD0.w>=0.0;
    t5.x = tb5 ? 1.0 : float(0.0);
    t5.x = t5.x * vs_TEXCOORD1;
    t17.x = vs_TEXCOORD2 + 5.0;
    t17.x = t17.x + (-_PlanetRadius);
    t17.x = t17.x * 0.200000003;
    t17.x = clamp(t17.x, 0.0, 1.0);
    t5.x = t17.x * t5.x;
    t16_0 = t5.xxxx * t16_0 + vec4(1.0, 1.0, 1.0, 1.0);
    SV_Target0 = t16_0;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 43 math
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
Bind "vertex" ATTR0
ConstBuffer "$Globals" 368
Matrix 0 [glstate_matrix_mvp]
Matrix 64 [_Object2World]
Matrix 128 [_MainRotation]
Matrix 192 [_DetailRotation]
Matrix 304 [_Projector]
Vector 256 [_SunDir]
Float 272 [_Radius]
Vector 288 [_PlanetOrigin] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _MainRotation;
  float4x4 _DetailRotation;
  float4 _SunDir;
  float _Radius;
  float3 _PlanetOrigin;
  float4x4 _Projector;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 planetPos_1;
  float4 tmpvar_2;
  tmpvar_2 = (_mtl_u._Object2World * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = (_mtl_u._PlanetOrigin - tmpvar_2.xyz);
  float tmpvar_4;
  tmpvar_4 = sqrt(dot (tmpvar_3, tmpvar_3));
  float tmpvar_5;
  float4 tmpvar_6;
  tmpvar_6 = -(_mtl_u._SunDir);
  tmpvar_5 = dot (tmpvar_3, tmpvar_6.xyz);
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = sqrt((dot (tmpvar_3, tmpvar_3) - (tmpvar_5 * tmpvar_5)));
  tmpvar_7 = (tmpvar_8 * tmpvar_8);
  float tmpvar_9;
  tmpvar_9 = sqrt((dot (tmpvar_3, tmpvar_3) - tmpvar_7));
  float tmpvar_10;
  tmpvar_10 = sqrt(((_mtl_u._Radius * _mtl_u._Radius) - tmpvar_7));
  planetPos_1 = (_mtl_u._MainRotation * (tmpvar_2 + (tmpvar_6 * 
    mix (mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 - tmpvar_10), float((tmpvar_5 >= 0.0))), mix ((tmpvar_10 - tmpvar_9), (tmpvar_5 + tmpvar_10), float((tmpvar_5 >= 0.0))), float((_mtl_u._Radius >= tmpvar_4)))
  )));
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = (_mtl_u._Projector * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD1 = (float((_mtl_u._Radius >= tmpvar_4)) * clamp ((
    dot (normalize(tmpvar_3), _mtl_u._SunDir.xyz)
   * 100.0), 0.0, 1.0));
  _mtl_o.xlv_TEXCOORD2 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD3 = tmpvar_2;
  _mtl_o.xlv_TEXCOORD4 = planetPos_1.xyz;
  _mtl_o.xlv_TEXCOORD5 = (_mtl_u._DetailRotation * planetPos_1).xyz;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" "WORLD_SPACE_ON" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
in  vec4 in_POSITION0;
out vec4 vs_TEXCOORD0;
out float vs_TEXCOORD1;
out float vs_TEXCOORD2;
out vec4 vs_TEXCOORD3;
out vec3 vs_TEXCOORD4;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec4 t1;
bool tb1;
vec3 t2;
bool tb2;
vec3 t4;
float t7;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Projector[1];
    t0 = _Projector[0] * in_POSITION0.xxxx + t0;
    t0 = _Projector[2] * in_POSITION0.zzzz + t0;
    vs_TEXCOORD0 = _Projector[3] * in_POSITION0.wwww + t0;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1.xyz = (-t0.xyz) + _PlanetOrigin.xyzx.xyz;
    t10 = dot(t1.xyz, t1.xyz);
    t2.x = inversesqrt(t10);
    t2.xyz = t1.xyz * t2.xxx;
    t1.x = dot(t1.xyz, (-_SunDir.xyz));
    t4.x = dot(t2.xyz, _SunDir.xyz);
    t4.x = t4.x * 100.0;
    t4.x = clamp(t4.x, 0.0, 1.0);
    t7 = sqrt(t10);
    tb2 = _Radius>=t7;
    vs_TEXCOORD2 = t7;
    t7 = tb2 ? 1.0 : float(0.0);
    vs_TEXCOORD1 = t4.x * t7;
    vs_TEXCOORD3 = t0;
    t4.x = (-t1.x) * t1.x + t10;
    t4.x = sqrt(t4.x);
    t2.x = t4.x * t4.x;
    t4.x = (-t4.x) * t4.x + t10;
    t4.z = _Radius * _Radius + (-t2.x);
    t4.xz = sqrt(t4.xz);
    t2.x = t4.z + t1.x;
    t4.x = (-t4.x) + t4.z;
    t10 = (-t4.z) + t1.x;
    tb1 = t1.x>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t10 = (-t4.x) + t10;
    t10 = t1.x * t10 + t4.x;
    t2.x = (-t4.x) + t2.x;
    t1.x = t1.x * t2.x + t4.x;
    t1.x = (-t10) + t1.x;
    t1.x = t7 * t1.x + t10;
    t0 = (-_SunDir) * t1.xxxx + t0;
    t1 = t0.yyyy * _MainRotation[1];
    t1 = _MainRotation[0] * t0.xxxx + t1;
    t1 = _MainRotation[2] * t0.zzzz + t1;
    t0 = _MainRotation[3] * t0.wwww + t1;
    vs_TEXCOORD4.xyz = t0.xyz;
    t1.xyz = t0.yyy * _DetailRotation[1].xyz;
    t1.xyz = _DetailRotation[0].xyz * t0.xxx + t1.xyz;
    t0.xyz = _DetailRotation[2].xyz * t0.zzz + t1.xyz;
    vs_TEXCOORD5.xyz = _DetailRotation[3].xyz * t0.www + t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	vec4 _DetailOffset;
uniform 	float _DetailScale;
uniform 	float _DetailDist;
uniform 	float _UVNoiseScale;
uniform 	float _UVNoiseStrength;
uniform 	vec2 _UVNoiseAnimation;
uniform 	vec4 _SunDir;
uniform 	float _Radius;
uniform 	float _PlanetRadius;
uniform 	float _ShadowFactor;
uniform 	vec3 _PlanetOrigin;
uniform 	mat4 _Projector;
uniform  sampler2D _UVNoiseTex;
uniform  sampler2D cube_MainTexxn;
uniform  sampler2D cube_MainTexxp;
uniform  sampler2D cube_MainTexyn;
uniform  sampler2D cube_MainTexyp;
uniform  sampler2D cube_MainTexzn;
uniform  sampler2D cube_MainTexzp;
uniform  sampler2D _DetailTex;
in  vec4 vs_TEXCOORD0;
in  float vs_TEXCOORD1;
in  float vs_TEXCOORD2;
in  vec4 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
mediump vec2 t16_1;
lowp vec4 t10_1;
bool tb1;
vec4 t2;
mediump vec4 t16_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
bool tb3;
vec3 t4;
mediump vec4 t16_4;
vec4 t5;
mediump vec4 t16_5;
lowp vec4 t10_5;
vec4 t6;
mediump vec4 t16_6;
lowp vec4 t10_6;
lowp vec4 t10_7;
vec2 t8;
vec2 t9;
vec3 t10;
int ti10;
bvec2 tb10;
vec3 t11;
int ti11;
float t16;
vec2 t17;
float t24;
int ti24;
bool tb24;
float t25;
int ti25;
bool tb25;
float t26;
bool tb26;
void main()
{
    t0.xz = vec2(1.0, -1.0);
    t24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t24 = inversesqrt(t24);
    t1.xyz = vec3(t24) * vs_TEXCOORD4.yxz;
    t25 = vs_TEXCOORD4.z * t24 + (-t1.y);
    tb2 = abs(t1.z)>=abs(t1.y);
    t2.x = tb2 ? 1.0 : float(0.0);
    t25 = t2.x * t25 + t1.y;
    t24 = (-vs_TEXCOORD4.y) * t24 + t25;
    t25 = max(abs(t1.z), abs(t1.y));
    tb25 = t25>=abs(t1.x);
    t25 = tb25 ? 1.0 : float(0.0);
    t24 = t25 * t24 + t1.x;
    ti10 = int((0.0<t24) ? 0xFFFFFFFFu : uint(0u));
    ti24 = int((t24<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti24 = (-ti10) + ti24;
    t3.y = float(ti24);
    t0.y = (-t3.y);
    t0.xyz = t0.xyz * t1.yzx;
    t3.xz = vec2(1.0, -1.0);
    t10.xyz = t3.xyz * t1.zyx + (-t0.xyz);
    t0.xyz = t2.xxx * t10.xyz + t0.xyz;
    t0.xyz = (-t3.xxy) * t1.xyz + t0.xyz;
    t1.xyz = t1.xyz * t3.xxy;
    tb24 = t3.y>=0.0;
    t24 = tb24 ? 1.0 : float(0.0);
    t0.xyz = vec3(t25) * t0.xyz + t1.xyz;
    t8.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t8.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t1.xy = t0.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    tb10.xy = greaterThanEqual(t1.xyxx, (-t1.xyxx)).xy;
    t1.xy = fract(abs(t1.xy));
    t1.x = (tb10.x) ? t1.x : (-t1.x);
    t1.y = (tb10.y) ? t1.y : (-t1.y);
    t1.xy = t1.xy * vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = t1.xy / vec2(vec2(_UVNoiseScale, _UVNoiseScale));
    t1.xy = _UVNoiseAnimation.xyxx.xy * _Time.xx + t1.xy;
    t10_3 = texture(_UVNoiseTex, t1.xy);
    t16_1.xy = t10_3.xy + vec2(-0.5, -0.5);
    t0.xy = t16_1.xy * vec2(vec2(_UVNoiseStrength, _UVNoiseStrength)) + t0.xy;
    t1.xy = t0.xy + vec2(-0.5, -0.5);
    t16 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t16);
    t4.x = dFdy(t16);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t10_5 = textureGrad(cube_MainTexzp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_6 = textureGrad(cube_MainTexzn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_5 = t10_5 + (-t10_6);
    t5 = vec4(t24) * t16_5 + t10_6;
    t10_6 = textureGrad(cube_MainTexxp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_7 = textureGrad(cube_MainTexxn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_6 = t10_6 + (-t10_7);
    t6 = vec4(t24) * t16_6 + t10_7;
    t5 = t5 + (-t6);
    t2 = t2.xxxx * t5 + t6;
    t10_5 = textureGrad(cube_MainTexyp, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t10_3 = textureGrad(cube_MainTexyn, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t16_4 = (-t10_3) + t10_5;
    t0 = vec4(t24) * t16_4 + t10_3;
    t2 = (-t0) + t2;
    t0 = vec4(t25) * t2 + t0;
    t0.xy = t0.xy * alphaMask1.xy;
    t0.x = t0.y + t0.x;
    t0.x = t0.z * alphaMask1.z + t0.x;
    t0.w = t0.w * alphaMask1.w + t0.x;
    t0.xyz = vec3(1.0, 1.0, 1.0);
    t0 = t0 * _Color;
    t1.xz = vec2(1.0, -1.0);
    t25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t25 = inversesqrt(t25);
    t2.xyz = vec3(t25) * vs_TEXCOORD5.yxz;
    t26 = vs_TEXCOORD5.z * t25 + (-t2.y);
    tb3 = abs(t2.z)>=abs(t2.y);
    t3.x = tb3 ? 1.0 : float(0.0);
    t26 = t3.x * t26 + t2.y;
    t25 = (-vs_TEXCOORD5.y) * t25 + t26;
    t26 = max(abs(t2.z), abs(t2.y));
    tb26 = t26>=abs(t2.x);
    t26 = tb26 ? 1.0 : float(0.0);
    t25 = t26 * t25 + t2.x;
    ti11 = int((0.0<t25) ? 0xFFFFFFFFu : uint(0u));
    ti25 = int((t25<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti25 = (-ti11) + ti25;
    t4.y = float(ti25);
    t1.y = (-t4.y);
    t1.xyz = t1.xyz * t2.yzx;
    t4.xz = vec2(1.0, -1.0);
    t11.xyz = t4.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = t3.xxx * t11.xyz + t1.xyz;
    t1.xyz = (-t4.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t4.xxy;
    t1.xyz = vec3(t26) * t1.xyz + t2.xyz;
    t9.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t9.xy / abs(t1.xx);
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t1.xy = t1.xy * vec2(_DetailScale);
    t17.xy = (-vec2(_DetailScale)) * vec2(0.5, 0.5) + t1.xy;
    t2.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t17.x);
    t2.y = dFdy(t17.x);
    t10_1 = textureGrad(_DetailTex, t1.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t16_2 = (-t10_1) + vec4(1.0, 1.0, 1.0, 1.0);
    t3.xyz = vs_TEXCOORD3.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t3.x = dot(t3.xyz, t3.xyz);
    t3.x = sqrt(t3.x);
    t3.x = dot(t3.xx, vec2(vec2(_DetailDist, _DetailDist)));
    t3.x = clamp(t3.x, 0.0, 1.0);
    t1 = t3.xxxx * t16_2 + t10_1;
    t2.x = (-t0.w) * t1.w + 1.0;
    t0 = t0 * t1;
    t1.xyz = t2.xxx * t0.xyz;
    t1.xyz = clamp(t1.xyz, 0.0, 1.0);
    t1.xyz = t1.xyz + vec3(-1.0, -1.0, -1.0);
    t25 = t0.w * _ShadowFactor;
    t0.xyz = t1.xyz * vec3(t25);
    t0 = t0 + vec4(0.0, 0.0, 0.0, -1.0);
    tb1 = vs_TEXCOORD0.w>=0.0;
    t1.x = tb1 ? 1.0 : float(0.0);
    t1.x = t1.x * vs_TEXCOORD1;
    t9.x = vs_TEXCOORD2 + 5.0;
    t9.x = t9.x + (-_PlanetRadius);
    t9.x = t9.x * 0.200000003;
    t9.x = clamp(t9.x, 0.0, 1.0);
    t1.x = t9.x * t1.x;
    SV_Target0 = t1.xxxx * t0 + vec4(1.0, 1.0, 1.0, 1.0);
    return;
}

#endif
"
}
}
Program "fp" {
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 101 math, 7 textures
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Vector 2 [_Color]
Float 4 [_DetailDist]
Float 3 [_DetailScale]
Float 8 [_ShadowFactor]
Vector 0 [_Time]
Vector 7 [_UVNoiseAnimation]
Float 5 [_UVNoiseScale]
Float 6 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
"ps_3_0
def c9, 0, 0.0208350997, -0.0851330012, 0.180141002
def c10, -0.330299497, 0.999866009, 0, 1
def c11, -2, 1.57079637, 0.159154937, 0.5
def c12, -0.0187292993, 0.0742610022, -0.212114394, 1.57072878
def c13, -2, 3.14159274, 0.318309873, 0
def c14, -0, 0, -3.14159274, 1
def c15, 1, -1, 0, 0
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_2d s0
dcl_2d s1
dcl_2d s2
dp3 r0.x, v3, v3
rsq r0.x, r0.x
mul r0.yzw, r0.x, v3.xzxy
mad r0.x, v3.x, r0.x, -r0.y
cmp r1.xy, r0.x, r0.yzzw, r0.zyzw
add r1.zw, -r0_abs.xyyz, r0_abs.xyzy
cmp r0.xz, r1.z, r0_abs.yyzw, r0_abs.zyyw
cmp r1.yz, r1.xyww, c10.xwzw, c10.xzww
rcp r0.z, r0.z
mul r0.x, r0.z, r0.x
mul r0.z, r0.x, r0.x
mad r1.w, r0.z, c9.y, c9.z
mad r1.w, r0.z, r1.w, c9.w
mad r1.w, r0.z, r1.w, c10.x
mad r0.z, r0.z, r1.w, c10.y
mul r0.x, r0.z, r0.x
mad r0.z, r0.x, c11.x, c11.y
mad r0.x, r0.z, r1.z, r0.x
cmp r0.yz, r0.xyww, c14.xxyw, c14.xzww
add r0.x, r0.y, r0.x
add r0.y, r0.x, r0.x
cmp r1.x, r1.x, c9.x, r1.y
mad r0.x, r1.x, -r0.y, r0.x
mad r0.x, r0.x, c11.z, c11.w
mad r1.x, r0_abs.w, c12.x, c12.y
mad r1.x, r1.x, r0_abs.w, c12.z
mad r1.x, r1.x, r0_abs.w, c12.w
add r0.w, -r0_abs.w, c10.w
rsq r0.w, r0.w
rcp r0.w, r0.w
mul r0.w, r0.w, r1.x
mad r1.x, r0.w, c13.x, c13.y
mad r0.z, r1.x, r0.z, r0.w
mul r0.y, r0.z, c13.z
rcp r0.z, c5.x
mul r1.xy, r0.z, r0
frc r1.zw, r1_abs.xyxy
cmp r1.xy, r1, r1.zwzw, -r1.zwzw
mul r1.xy, r1, c5.x
mov r2.xy, c7
mul r1.zw, r2.xyxy, c0.x
mad r0.zw, r1.xyxy, r0.z, r1
texld r1, r0.zwzw, s2
add r0.zw, r1.xyxy, -c11.w
mad r0.xy, r0.zwzw, c6.x, r0
add r0.z, r0.x, -c11.w
abs r0.z, r0.z
dsx r1.xy, r0.zyzw
dsy r2.xy, r0.zyzw
texldd_pp r0, r0, s0, r1, r2
mul_pp r0, r0, c2
mov r1.xz, c15.xyyw
dp3 r1.w, v4, v4
rsq r1.w, r1.w
mul r2.xyz, r1.w, v4.yxzw
max r1.w, r2_abs.y, r2_abs.z
add r1.w, -r2_abs.x, r1.w
add r2.w, -r2_abs.y, r2_abs.z
cmp_pp r3.x, r2.w, r2.z, r2.y
cmp r3.x, r1.w, r3.x, r2.x
cmp r3.y, -r3.x, c10.z, c10.w
cmp r3.x, r3.x, -c10.z, -c10.w
add_pp r3.y, r3.x, r3.y
mov_pp r1.y, -r3.y
mul_pp r1.xyz, r1, r2.yzxw
mov r3.xz, c15.xyyw
mul_pp r4.xyz, r2.zyxw, r3
mul_pp r2.xyz, r2, r3.xxyw
cmp_pp r1.xyz, r2.w, r4, r1
cmp_pp r1.xyz, r1.w, r1, r2
mul_pp r1.yz, r1, c11.w
rcp r1.x, r1_abs.x
mad_pp r1.xy, r1.yzzw, r1.x, c11.w
mul_pp r1.xy, r1, c3.x
mov r1.w, c11.w
mad r1.zw, c3.x, -r1.w, r1.xyxy
add r2.x, -r1_abs.w, r1_abs.z
cmp r1.zw, r2.x, r1_abs, r1_abs.xywz
dsx r2.xy, r1.zwzw
dsy r1.zw, r1
texldd_pp r1, r1, s1, r2, r1.zwzw
add r2.xyz, -c1, v2
dp3 r2.x, r2, r2
rsq r2.x, r2.x
rcp r2.x, r2.x
mov r3.x, c9.x
dp2add_sat_pp r2.x, r2.x, c4.x, r3.x
lrp_pp r4, r2.x, c10.w, r1
mad_pp r1.x, r0.w, -r4.w, c10.w
mul_pp r0, r0, r4
mul_sat_pp r1.xyz, r1.x, r0
add r1.xyz, r1, -c10.w
mul r1.w, r0.w, c8.x
mul r0.xyz, r1, r1.w
add_pp r0, r0, -c14.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r3.x
mad_pp oC0, r1.x, r0, c10.w

"
}
SubProgram "d3d11 " {
// Stats: 98 math, 1 textures
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
SetTexture 0 [_UVNoiseTex] 2D 2
SetTexture 1 [_MainTex] 2D 0
SetTexture 2 [_DetailTex] 2D 1
ConstBuffer "$Globals" 544
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:adacadaa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"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 128 math, 3 textures, 5 branches
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
ConstBuffer "$Globals" 68
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [_Color] 4
Float 40 [_DetailScale]
Float 44 [_DetailDist]
Float 48 [_UVNoiseScale]
Float 52 [_UVNoiseStrength]
Vector 56 [_UVNoiseAnimation] 2
Float 64 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> _MainTex [[texture(0)]], sampler _mtlsmp__MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]]
  ,   texture2d<half> _UVNoiseTex [[texture(2)]], sampler _mtlsmp__UVNoiseTex [[sampler(2)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  float2 uv_5;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i.xlv_TEXCOORD4);
  float2 uv_7;
  float tmpvar_8;
  float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  uv_5 = uv_7;
  float2 tmpvar_11;
  tmpvar_11 = (uv_7 / float2(_mtl_u._UVNoiseScale));
  float2 tmpvar_12;
  tmpvar_12 = (fract(abs(tmpvar_11)) * float2(_mtl_u._UVNoiseScale));
  float tmpvar_13;
  if ((tmpvar_11.x >= 0.0)) {
    tmpvar_13 = tmpvar_12.x;
  } else {
    tmpvar_13 = -(tmpvar_12.x);
  };
  float tmpvar_14;
  if ((tmpvar_11.y >= 0.0)) {
    tmpvar_14 = tmpvar_12.y;
  } else {
    tmpvar_14 = -(tmpvar_12.y);
  };
  float2 tmpvar_15;
  tmpvar_15.x = tmpvar_13;
  tmpvar_15.y = tmpvar_14;
  float2 tmpvar_16;
  tmpvar_16 = ((tmpvar_15 / _mtl_u._UVNoiseScale) + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_17;
  tmpvar_17 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_16));
  uv_5 = (uv_7 + ((float2)(tmpvar_17.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength));
  float2 uvCont_18;
  uvCont_18.y = uv_5.y;
  uvCont_18.x = abs((uv_5.x - 0.5));
  float4 tmpvar_19;
  tmpvar_19.xy = dfdx(uvCont_18);
  tmpvar_19.zw = dfdy(uvCont_18);
  half4 tmpvar_20;
  tmpvar_20 = _MainTex.sample(_mtlsmp__MainTex, (float2)(uv_5), gradient2d((float2)(tmpvar_19.xy), (float2)(tmpvar_19.zw)));
  half4 tmpvar_21;
  tmpvar_21 = tmpvar_20;
  half2 uv_22;
  half3 detailCoords_23;
  half s_24;
  half nylerp_25;
  half zxlerp_26;
  float3 tmpvar_27;
  tmpvar_27 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_28;
  tmpvar_28 = abs(tmpvar_27);
  float tmpvar_29;
  tmpvar_29 = float((tmpvar_28.z >= tmpvar_28.x));
  zxlerp_26 = half(tmpvar_29);
  float tmpvar_30;
  tmpvar_30 = float((max (tmpvar_28.x, tmpvar_28.z) >= tmpvar_28.y));
  nylerp_25 = half(tmpvar_30);
  float tmpvar_31;
  tmpvar_31 = mix (tmpvar_27.x, tmpvar_27.z, (float)zxlerp_26);
  s_24 = half(tmpvar_31);
  float tmpvar_32;
  tmpvar_32 = sign(mix (tmpvar_27.y, (float)s_24, (float)nylerp_25));
  s_24 = half(tmpvar_32);
  half3 tmpvar_33;
  tmpvar_33.xz = half2(float2(1.0, -1.0));
  tmpvar_33.y = -(s_24);
  half3 tmpvar_34;
  tmpvar_34.xz = half2(float2(1.0, -1.0));
  tmpvar_34.y = s_24;
  float3 tmpvar_35;
  tmpvar_35 = mix (((float3)tmpvar_33 * tmpvar_27.xzy), ((float3)tmpvar_34 * tmpvar_27.zxy), (float3)half3(zxlerp_26));
  detailCoords_23 = half3(tmpvar_35);
  half3 tmpvar_36;
  tmpvar_36.xy = half2(float2(1.0, 1.0));
  tmpvar_36.z = s_24;
  float3 tmpvar_37;
  tmpvar_37 = mix (((float3)tmpvar_36 * tmpvar_27.yxz), (float3)detailCoords_23, (float3)half3(nylerp_25));
  detailCoords_23 = half3(tmpvar_37);
  uv_22 = half2(((float2)((
    ((half)0.5 * detailCoords_23.yz)
   / 
    abs(detailCoords_23.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_38;
  uv_38 = float2(uv_22);
  float2 uvCont_39;
  float2 tmpvar_40;
  tmpvar_40 = abs((uv_38 - (0.5 * _mtl_u._DetailScale)));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  float4 tmpvar_41;
  tmpvar_41.xy = dfdx(uvCont_39);
  tmpvar_41.zw = dfdy(uvCont_39);
  half4 tmpvar_42;
  tmpvar_42 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_22), gradient2d((float2)(tmpvar_41.xy), (float2)(tmpvar_41.zw)));
  half4 tmpvar_43;
  tmpvar_43 = tmpvar_42;
  float3 tmpvar_44;
  tmpvar_44 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_45;
  float tmpvar_46;
  tmpvar_46 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_44, tmpvar_44)
  )), 0.0, 1.0);
  tmpvar_45 = half(tmpvar_46);
  half4 tmpvar_47;
  tmpvar_47 = ((_mtl_u._Color * tmpvar_21) * mix (tmpvar_43, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_45)));
  color_2 = tmpvar_47;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_48;
  tmpvar_48 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_48);
  half4 tmpvar_49;
  tmpvar_49 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_49;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 106 math, 7 textures
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Vector 3 [_Color]
Float 5 [_DetailDist]
Float 4 [_DetailScale]
Float 9 [_ShadowFactor]
Vector 0 [_Time]
Vector 8 [_UVNoiseAnimation]
Float 6 [_UVNoiseScale]
Float 7 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
Vector 2 [alphaMask1]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
"ps_3_0
def c10, -2, 1.57079637, 0.159154937, 0.5
def c11, 0, 0.0208350997, -0.0851330012, 0.180141002
def c12, -0.330299497, 0.999866009, 0, 1
def c13, -0.0187292993, 0.0742610022, -0.212114394, 1.57072878
def c14, -2, 3.14159274, 0.318309873, 0
def c15, 1, -1, 0, 0
def c16, -0, 0, -3.14159274, 1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_2d s0
dcl_2d s1
dcl_2d s2
dp3 r0.x, v3, v3
rsq r0.x, r0.x
mul r0.yzw, r0.x, v3.xzxy
mad r0.x, v3.x, r0.x, -r0.y
cmp r1.xy, r0.x, r0.yzzw, r0.zyzw
add r1.zw, -r0_abs.xyyz, r0_abs.xyzy
cmp r0.xz, r1.z, r0_abs.yyzw, r0_abs.zyyw
cmp r1.yz, r1.xyww, c12.xwzw, c12.xzww
rcp r0.z, r0.z
mul r0.x, r0.z, r0.x
mul r0.z, r0.x, r0.x
mad r1.w, r0.z, c11.y, c11.z
mad r1.w, r0.z, r1.w, c11.w
mad r1.w, r0.z, r1.w, c12.x
mad r0.z, r0.z, r1.w, c12.y
mul r0.x, r0.z, r0.x
mad r0.z, r0.x, c10.x, c10.y
mad r0.x, r0.z, r1.z, r0.x
cmp r0.yz, r0.xyww, c16.xxyw, c16.xzww
add r0.x, r0.y, r0.x
add r0.y, r0.x, r0.x
cmp r1.x, r1.x, c11.x, r1.y
mad r0.x, r1.x, -r0.y, r0.x
mad r0.x, r0.x, c10.z, c10.w
mad r1.x, r0_abs.w, c13.x, c13.y
mad r1.x, r1.x, r0_abs.w, c13.z
mad r1.x, r1.x, r0_abs.w, c13.w
add r0.w, -r0_abs.w, c12.w
rsq r0.w, r0.w
rcp r0.w, r0.w
mul r0.w, r0.w, r1.x
mad r1.x, r0.w, c14.x, c14.y
mad r0.z, r1.x, r0.z, r0.w
mul r0.y, r0.z, c14.z
rcp r0.z, c6.x
mul r1.xy, r0.z, r0
frc r1.zw, r1_abs.xyxy
cmp r1.xy, r1, r1.zwzw, -r1.zwzw
mul r1.xy, r1, c6.x
mov r2.xy, c8
mul r1.zw, r2.xyxy, c0.x
mad r0.zw, r1.xyxy, r0.z, r1
texld r1, r0.zwzw, s2
add r0.zw, r1.xyxy, -c10.w
mad r0.xy, r0.zwzw, c7.x, r0
add r0.z, r0.x, -c10.w
abs r0.z, r0.z
dsx r1.xy, r0.zyzw
dsy r2.xy, r0.zyzw
texldd_pp r0, r0, s0, r1, r2
mul_pp r0.xy, r0, c2
add_pp r0.x, r0.y, r0.x
mad_pp r0.x, r0.z, c2.z, r0.x
mad_pp r0.w, r0.w, c2.w, r0.x
mov r0.xyz, c12.w
mul_pp r0, r0, c3
mov r1.xz, c15.xyyw
dp3 r1.w, v4, v4
rsq r1.w, r1.w
mul r2.xyz, r1.w, v4.yxzw
max r1.w, r2_abs.y, r2_abs.z
add r1.w, -r2_abs.x, r1.w
add r2.w, -r2_abs.y, r2_abs.z
cmp_pp r3.x, r2.w, r2.z, r2.y
cmp r3.x, r1.w, r3.x, r2.x
cmp r3.y, -r3.x, c12.z, c12.w
cmp r3.x, r3.x, -c12.z, -c12.w
add_pp r3.y, r3.x, r3.y
mov_pp r1.y, -r3.y
mul_pp r1.xyz, r1, r2.yzxw
mov r3.xz, c15.xyyw
mul_pp r4.xyz, r2.zyxw, r3
mul_pp r2.xyz, r2, r3.xxyw
cmp_pp r1.xyz, r2.w, r4, r1
cmp_pp r1.xyz, r1.w, r1, r2
mul_pp r1.yz, r1, c10.w
rcp r1.x, r1_abs.x
mad_pp r1.xy, r1.yzzw, r1.x, c10.w
mul_pp r1.xy, r1, c4.x
mov r1.w, c10.w
mad r1.zw, c4.x, -r1.w, r1.xyxy
add r2.x, -r1_abs.w, r1_abs.z
cmp r1.zw, r2.x, r1_abs, r1_abs.xywz
dsx r2.xy, r1.zwzw
dsy r1.zw, r1
texldd_pp r1, r1, s1, r2, r1.zwzw
add r2.xyz, -c1, v2
dp3 r2.x, r2, r2
rsq r2.x, r2.x
rcp r2.x, r2.x
mov r3.x, c11.x
dp2add_sat_pp r2.x, r2.x, c5.x, r3.x
lrp_pp r4, r2.x, c12.w, r1
mad_pp r1.x, r0.w, -r4.w, c12.w
mul_pp r0, r0, r4
mul_sat_pp r1.xyz, r1.x, r0
add r1.xyz, r1, -c12.w
mul r1.w, r0.w, c9.x
mul r0.xyz, r1, r1.w
add_pp r0, r0, -c16.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r3.x
mad_pp oC0, r1.x, r0, c12.w

"
}
SubProgram "d3d11 " {
// Stats: 102 math, 1 textures
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
SetTexture 0 [_UVNoiseTex] 2D 2
SetTexture 1 [_MainTex] 2D 0
SetTexture 2 [_DetailTex] 2D 1
ConstBuffer "$Globals" 544
Vector 352 [alphaMask1]
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:adacadaa
eefiecedkhdbiibdidmkobnblobonicdgpaceecaabaaaaaaembaaaaaadaaaaaa
cmaaaaaapmaaaaaadaabaaaaejfdeheomiaaaaaaahaaaaaaaiaaaaaalaaaaaaa
aaaaaaaaabaaaaaaadaaaaaaaaaaaaaaapaaaaaalmaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaapaiaaaalmaaaaaaabaaaaaaaaaaaaaaadaaaaaaacaaaaaa
ababaaaalmaaaaaaacaaaaaaaaaaaaaaadaaaaaaacaaaaaaacaaaaaalmaaaaaa
adaaaaaaaaaaaaaaadaaaaaaadaaaaaaapahaaaalmaaaaaaaeaaaaaaaaaaaaaa
adaaaaaaaeaaaaaaahahaaaalmaaaaaaafaaaaaaaaaaaaaaadaaaaaaafaaaaaa
ahahaaaafdfgfpfaepfdejfeejepeoaafeeffiedepepfceeaaklklklepfdeheo
cmaaaaaaabaaaaaaaiaaaaaacaaaaaaaaaaaaaaaaaaaaaaaadaaaaaaaaaaaaaa
apaaaaaafdfgfpfegbhcghgfheaaklklfdeieefcbeapaaaaeaaaaaaamfadaaaa
fjaaaaaeegiocaaaaaaaaaaabnaaaaaafjaaaaaeegiocaaaabaaaaaaafaaaaaa
fkaaaaadaagabaaaaaaaaaaafkaaaaadaagabaaaabaaaaaafkaaaaadaagabaaa
acaaaaaafibiaaaeaahabaaaaaaaaaaaffffaaaafibiaaaeaahabaaaabaaaaaa
ffffaaaafibiaaaeaahabaaaacaaaaaaffffaaaagcbaaaadicbabaaaabaaaaaa
gcbaaaadbcbabaaaacaaaaaagcbaaaadhcbabaaaadaaaaaagcbaaaadhcbabaaa
aeaaaaaagcbaaaadhcbabaaaafaaaaaagfaaaaadpccabaaaaaaaaaaagiaaaaac
afaaaaaabaaaaaahbcaabaaaaaaaaaaaegbcbaaaaeaaaaaaegbcbaaaaeaaaaaa
eeaaaaafbcaabaaaaaaaaaaaakaabaaaaaaaaaaadiaaaaahhcaabaaaaaaaaaaa
agaabaaaaaaaaaaaigbbbaaaaeaaaaaadeaaaaajicaabaaaaaaaaaaabkaabaia
ibaaaaaaaaaaaaaaakaabaiaibaaaaaaaaaaaaaaaoaaaaakicaabaaaaaaaaaaa
aceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadpdkaabaaaaaaaaaaaddaaaaaj
bcaabaaaabaaaaaabkaabaiaibaaaaaaaaaaaaaaakaabaiaibaaaaaaaaaaaaaa
diaaaaahicaabaaaaaaaaaaadkaabaaaaaaaaaaaakaabaaaabaaaaaadiaaaaah
bcaabaaaabaaaaaadkaabaaaaaaaaaaadkaabaaaaaaaaaaadcaaaaajccaabaaa
abaaaaaaakaabaaaabaaaaaaabeaaaaafpkokkdmabeaaaaadgfkkolndcaaaaaj
ccaabaaaabaaaaaaakaabaaaabaaaaaabkaabaaaabaaaaaaabeaaaaaochgdido
dcaaaaajccaabaaaabaaaaaaakaabaaaabaaaaaabkaabaaaabaaaaaaabeaaaaa
aebnkjlodcaaaaajbcaabaaaabaaaaaaakaabaaaabaaaaaabkaabaaaabaaaaaa
abeaaaaadiphhpdpdiaaaaahccaabaaaabaaaaaadkaabaaaaaaaaaaaakaabaaa
abaaaaaadcaaaaajccaabaaaabaaaaaabkaabaaaabaaaaaaabeaaaaaaaaaaama
abeaaaaanlapmjdpdbaaaaajecaabaaaabaaaaaabkaabaiaibaaaaaaaaaaaaaa
akaabaiaibaaaaaaaaaaaaaaabaaaaahccaabaaaabaaaaaackaabaaaabaaaaaa
bkaabaaaabaaaaaadcaaaaajicaabaaaaaaaaaaadkaabaaaaaaaaaaaakaabaaa
abaaaaaabkaabaaaabaaaaaadbaaaaaidcaabaaaabaaaaaajgafbaaaaaaaaaaa
jgafbaiaebaaaaaaaaaaaaaaabaaaaahbcaabaaaabaaaaaaakaabaaaabaaaaaa
abeaaaaanlapejmaaaaaaaahicaabaaaaaaaaaaadkaabaaaaaaaaaaaakaabaaa
abaaaaaaddaaaaahbcaabaaaabaaaaaabkaabaaaaaaaaaaaakaabaaaaaaaaaaa
dbaaaaaibcaabaaaabaaaaaaakaabaaaabaaaaaaakaabaiaebaaaaaaabaaaaaa
deaaaaahbcaabaaaaaaaaaaabkaabaaaaaaaaaaaakaabaaaaaaaaaaabnaaaaai
bcaabaaaaaaaaaaaakaabaaaaaaaaaaaakaabaiaebaaaaaaaaaaaaaaabaaaaah
bcaabaaaaaaaaaaaakaabaaaaaaaaaaaakaabaaaabaaaaaadhaaaaakbcaabaaa
aaaaaaaaakaabaaaaaaaaaaadkaabaiaebaaaaaaaaaaaaaadkaabaaaaaaaaaaa
dcaaaaajbcaabaaaaaaaaaaaakaabaaaaaaaaaaaabeaaaaaidpjccdoabeaaaaa
aaaaaadpdcaaaaakicaabaaaaaaaaaaackaabaiaibaaaaaaaaaaaaaaabeaaaaa
dagojjlmabeaaaaachbgjidndcaaaaakicaabaaaaaaaaaaadkaabaaaaaaaaaaa
ckaabaiaibaaaaaaaaaaaaaaabeaaaaaiedefjlodcaaaaakicaabaaaaaaaaaaa
dkaabaaaaaaaaaaackaabaiaibaaaaaaaaaaaaaaabeaaaaakeanmjdpaaaaaaai
ecaabaaaaaaaaaaackaabaiambaaaaaaaaaaaaaaabeaaaaaaaaaiadpelaaaaaf
ecaabaaaaaaaaaaackaabaaaaaaaaaaadiaaaaahbcaabaaaabaaaaaackaabaaa
aaaaaaaadkaabaaaaaaaaaaadcaaaaajbcaabaaaabaaaaaaakaabaaaabaaaaaa
abeaaaaaaaaaaamaabeaaaaanlapejeaabaaaaahbcaabaaaabaaaaaabkaabaaa
abaaaaaaakaabaaaabaaaaaadcaaaaajecaabaaaaaaaaaaadkaabaaaaaaaaaaa
ckaabaaaaaaaaaaaakaabaaaabaaaaaadiaaaaahccaabaaaaaaaaaaackaabaaa
aaaaaaaaabeaaaaaidpjkcdoaoaaaaaimcaabaaaaaaaaaaaagaebaaaaaaaaaaa
kgikcaaaaaaaaaaabjaaaaaabnaaaaaidcaabaaaabaaaaaaogakbaaaaaaaaaaa
ogakbaiaebaaaaaaaaaaaaaabkaaaaagmcaabaaaaaaaaaaakgaobaiaibaaaaaa
aaaaaaaadhaaaaakmcaabaaaaaaaaaaaagaebaaaabaaaaaakgaobaaaaaaaaaaa
kgaobaiaebaaaaaaaaaaaaaadiaaaaaimcaabaaaaaaaaaaakgaobaaaaaaaaaaa
kgikcaaaaaaaaaaabjaaaaaaaoaaaaaimcaabaaaaaaaaaaakgaobaaaaaaaaaaa
kgikcaaaaaaaaaaabjaaaaaadcaaaaalmcaabaaaaaaaaaaaagiecaaaaaaaaaaa
bkaaaaaaagiacaaaabaaaaaaaaaaaaaakgaobaaaaaaaaaaaefaaaaajpcaabaaa
abaaaaaaogakbaaaaaaaaaaaeghobaaaaaaaaaaaaagabaaaacaaaaaaaaaaaaak
mcaabaaaaaaaaaaaagaebaaaabaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaalp
aaaaaalpdcaaaaakdcaabaaaaaaaaaaaogakbaaaaaaaaaaapgipcaaaaaaaaaaa
bjaaaaaaegaabaaaaaaaaaaaaaaaaaahecaabaaaaaaaaaaaakaabaaaaaaaaaaa
abeaaaaaaaaaaalpdgaaaaagecaabaaaaaaaaaaackaabaiaibaaaaaaaaaaaaaa
alaaaaafdcaabaaaabaaaaaaggakbaaaaaaaaaaaamaaaaafdcaabaaaacaaaaaa
ggakbaaaaaaaaaaaejaaaaanpcaabaaaaaaaaaaaegaabaaaaaaaaaaaeghobaaa
abaaaaaaaagabaaaaaaaaaaaegaabaaaabaaaaaaegaabaaaacaaaaaadiaaaaai
dcaabaaaaaaaaaaaegaabaaaaaaaaaaaegiacaaaaaaaaaaabgaaaaaaaaaaaaah
bcaabaaaaaaaaaaabkaabaaaaaaaaaaaakaabaaaaaaaaaaadcaaaaakbcaabaaa
aaaaaaaackaabaaaaaaaaaaackiacaaaaaaaaaaabgaaaaaaakaabaaaaaaaaaaa
dcaaaaakicaabaaaaaaaaaaadkaabaaaaaaaaaaadkiacaaaaaaaaaaabgaaaaaa
akaabaaaaaaaaaaadgaaaaaihcaabaaaaaaaaaaaaceaaaaaaaaaiadpaaaaiadp
aaaaiadpaaaaaaaadiaaaaaipcaabaaaaaaaaaaaegaobaaaaaaaaaaaegiocaaa
aaaaaaaabhaaaaaadgaaaaaifcaabaaaabaaaaaaaceaaaaaaaaaiadpaaaaaaaa
aaaaialpaaaaaaaabaaaaaahicaabaaaabaaaaaaegbcbaaaafaaaaaaegbcbaaa
afaaaaaaeeaaaaaficaabaaaabaaaaaadkaabaaaabaaaaaadiaaaaahhcaabaaa
acaaaaaapgapbaaaabaaaaaabgbgbaaaafaaaaaadcaaaaakicaabaaaacaaaaaa
ckbabaaaafaaaaaadkaabaaaabaaaaaabkaabaiaebaaaaaaacaaaaaabnaaaaaj
bcaabaaaadaaaaaackaabaiaibaaaaaaacaaaaaabkaabaiaibaaaaaaacaaaaaa
abaaaaahbcaabaaaadaaaaaaakaabaaaadaaaaaaabeaaaaaaaaaiadpdcaaaaaj
icaabaaaacaaaaaaakaabaaaadaaaaaadkaabaaaacaaaaaabkaabaaaacaaaaaa
dcaaaaakicaabaaaabaaaaaabkbabaiaebaaaaaaafaaaaaadkaabaaaabaaaaaa
dkaabaaaacaaaaaadeaaaaajicaabaaaacaaaaaackaabaiaibaaaaaaacaaaaaa
bkaabaiaibaaaaaaacaaaaaabnaaaaaiicaabaaaacaaaaaadkaabaaaacaaaaaa
akaabaiaibaaaaaaacaaaaaaabaaaaahicaabaaaacaaaaaadkaabaaaacaaaaaa
abeaaaaaaaaaiadpdcaaaaajicaabaaaabaaaaaadkaabaaaacaaaaaadkaabaaa
abaaaaaaakaabaaaacaaaaaadbaaaaahccaabaaaadaaaaaaabeaaaaaaaaaaaaa
dkaabaaaabaaaaaadbaaaaahicaabaaaabaaaaaadkaabaaaabaaaaaaabeaaaaa
aaaaaaaaboaaaaaiicaabaaaabaaaaaabkaabaiaebaaaaaaadaaaaaadkaabaaa
abaaaaaaclaaaaafccaabaaaaeaaaaaadkaabaaaabaaaaaadgaaaaagccaabaaa
abaaaaaabkaabaiaebaaaaaaaeaaaaaadiaaaaahhcaabaaaabaaaaaaegacbaaa
abaaaaaajgaebaaaacaaaaaadgaaaaaifcaabaaaaeaaaaaaaceaaaaaaaaaiadp
aaaaaaaaaaaaialpaaaaaaaadcaaaaakocaabaaaadaaaaaaagajbaaaaeaaaaaa
kgabbaaaacaaaaaaagajbaiaebaaaaaaabaaaaaadcaaaaajhcaabaaaabaaaaaa
agaabaaaadaaaaaajgahbaaaadaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
abaaaaaaagabbaiaebaaaaaaaeaaaaaaegacbaaaacaaaaaaegacbaaaabaaaaaa
diaaaaahhcaabaaaacaaaaaaegacbaaaacaaaaaaagabbaaaaeaaaaaadcaaaaaj
hcaabaaaabaaaaaapgapbaaaacaaaaaaegacbaaaabaaaaaaegacbaaaacaaaaaa
diaaaaakgcaabaaaabaaaaaafgagbaaaabaaaaaaaceaaaaaaaaaaaaaaaaaaadp
aaaaaadpaaaaaaaaaoaaaaaidcaabaaaabaaaaaajgafbaaaabaaaaaaagaabaia
ibaaaaaaabaaaaaaaaaaaaakdcaabaaaabaaaaaaegaabaaaabaaaaaaaceaaaaa
aaaaaadpaaaaaadpaaaaaaaaaaaaaaaadiaaaaaidcaabaaaabaaaaaaegaabaaa
abaaaaaaagiacaaaaaaaaaaabjaaaaaadcaaaaaomcaabaaaabaaaaaaagiacaia
ebaaaaaaaaaaaaaabjaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaadpaaaaaadp
agaebaaaabaaaaaadeaaaaajbcaabaaaacaaaaaadkaabaiaibaaaaaaabaaaaaa
ckaabaiaibaaaaaaabaaaaaaddaaaaajecaabaaaabaaaaaadkaabaiaibaaaaaa
abaaaaaackaabaiaibaaaaaaabaaaaaaalaaaaafbcaabaaaadaaaaaaakaabaaa
acaaaaaaamaaaaafbcaabaaaacaaaaaaakaabaaaacaaaaaaalaaaaafccaabaaa
adaaaaaackaabaaaabaaaaaaamaaaaafccaabaaaacaaaaaackaabaaaabaaaaaa
ejaaaaanpcaabaaaabaaaaaaegaabaaaabaaaaaaeghobaaaacaaaaaaaagabaaa
abaaaaaaegaabaaaadaaaaaaegaabaaaacaaaaaaaaaaaaalpcaabaaaacaaaaaa
egaobaiaebaaaaaaabaaaaaaaceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadp
aaaaaaajhcaabaaaadaaaaaaegbcbaaaadaaaaaaegiccaiaebaaaaaaabaaaaaa
aeaaaaaabaaaaaahbcaabaaaadaaaaaaegacbaaaadaaaaaaegacbaaaadaaaaaa
elaaaaafbcaabaaaadaaaaaaakaabaaaadaaaaaaapcaaaaibcaabaaaadaaaaaa
agaabaaaadaaaaaafgifcaaaaaaaaaaabjaaaaaadcaaaaajpcaabaaaabaaaaaa
agaabaaaadaaaaaaegaobaaaacaaaaaaegaobaaaabaaaaaadcaaaaakbcaabaaa
acaaaaaadkaabaiaebaaaaaaaaaaaaaadkaabaaaabaaaaaaabeaaaaaaaaaiadp
diaaaaahpcaabaaaaaaaaaaaegaobaaaaaaaaaaaegaobaaaabaaaaaadicaaaah
hcaabaaaabaaaaaaagaabaaaacaaaaaaegacbaaaaaaaaaaaaaaaaaakhcaabaaa
abaaaaaaegacbaaaabaaaaaaaceaaaaaaaaaialpaaaaialpaaaaialpaaaaaaaa
diaaaaaiicaabaaaabaaaaaadkaabaaaaaaaaaaackiacaaaaaaaaaaabmaaaaaa
diaaaaahhcaabaaaaaaaaaaaegacbaaaabaaaaaapgapbaaaabaaaaaaaaaaaaak
pcaabaaaaaaaaaaaegaobaaaaaaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
aaaaialpbnaaaaahbcaabaaaabaaaaaadkbabaaaabaaaaaaabeaaaaaaaaaaaaa
abaaaaahbcaabaaaabaaaaaaakaabaaaabaaaaaaabeaaaaaaaaaiadpdiaaaaah
bcaabaaaabaaaaaaakaabaaaabaaaaaaakbabaaaacaaaaaadcaaaaampccabaaa
aaaaaaaaagaabaaaabaaaaaaegaobaaaaaaaaaaaaceaaaaaaaaaiadpaaaaiadp
aaaaiadpaaaaiadpdoaaaaab"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 133 math, 3 textures, 5 branches
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
ConstBuffer "$Globals" 76
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [alphaMask1] 4
VectorHalf 40 [_Color] 4
Float 48 [_DetailScale]
Float 52 [_DetailDist]
Float 56 [_UVNoiseScale]
Float 60 [_UVNoiseStrength]
Vector 64 [_UVNoiseAnimation] 2
Float 72 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 alphaMask1;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> _MainTex [[texture(0)]], sampler _mtlsmp__MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]]
  ,   texture2d<half> _UVNoiseTex [[texture(2)]], sampler _mtlsmp__UVNoiseTex [[sampler(2)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  float2 uv_5;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i.xlv_TEXCOORD4);
  float2 uv_7;
  float tmpvar_8;
  float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  uv_5 = uv_7;
  float2 tmpvar_11;
  tmpvar_11 = (uv_7 / float2(_mtl_u._UVNoiseScale));
  float2 tmpvar_12;
  tmpvar_12 = (fract(abs(tmpvar_11)) * float2(_mtl_u._UVNoiseScale));
  float tmpvar_13;
  if ((tmpvar_11.x >= 0.0)) {
    tmpvar_13 = tmpvar_12.x;
  } else {
    tmpvar_13 = -(tmpvar_12.x);
  };
  float tmpvar_14;
  if ((tmpvar_11.y >= 0.0)) {
    tmpvar_14 = tmpvar_12.y;
  } else {
    tmpvar_14 = -(tmpvar_12.y);
  };
  float2 tmpvar_15;
  tmpvar_15.x = tmpvar_13;
  tmpvar_15.y = tmpvar_14;
  float2 tmpvar_16;
  tmpvar_16 = ((tmpvar_15 / _mtl_u._UVNoiseScale) + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_17;
  tmpvar_17 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_16));
  uv_5 = (uv_7 + ((float2)(tmpvar_17.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength));
  float2 uvCont_18;
  uvCont_18.y = uv_5.y;
  uvCont_18.x = abs((uv_5.x - 0.5));
  float4 tmpvar_19;
  tmpvar_19.xy = dfdx(uvCont_18);
  tmpvar_19.zw = dfdy(uvCont_18);
  half4 tmpvar_20;
  tmpvar_20 = _MainTex.sample(_mtlsmp__MainTex, (float2)(uv_5), gradient2d((float2)(tmpvar_19.xy), (float2)(tmpvar_19.zw)));
  half4 tmpvar_21;
  tmpvar_21 = tmpvar_20;
  half4 v_22;
  v_22 = (tmpvar_21 * _mtl_u.alphaMask1);
  half4 tmpvar_23;
  tmpvar_23.xyz = half3(float3(1.0, 1.0, 1.0));
  tmpvar_23.w = ((v_22.x + v_22.y) + (v_22.z + v_22.w));
  half2 uv_24;
  half3 detailCoords_25;
  half s_26;
  half nylerp_27;
  half zxlerp_28;
  float3 tmpvar_29;
  tmpvar_29 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_30;
  tmpvar_30 = abs(tmpvar_29);
  float tmpvar_31;
  tmpvar_31 = float((tmpvar_30.z >= tmpvar_30.x));
  zxlerp_28 = half(tmpvar_31);
  float tmpvar_32;
  tmpvar_32 = float((max (tmpvar_30.x, tmpvar_30.z) >= tmpvar_30.y));
  nylerp_27 = half(tmpvar_32);
  float tmpvar_33;
  tmpvar_33 = mix (tmpvar_29.x, tmpvar_29.z, (float)zxlerp_28);
  s_26 = half(tmpvar_33);
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_29.y, (float)s_26, (float)nylerp_27));
  s_26 = half(tmpvar_34);
  half3 tmpvar_35;
  tmpvar_35.xz = half2(float2(1.0, -1.0));
  tmpvar_35.y = -(s_26);
  half3 tmpvar_36;
  tmpvar_36.xz = half2(float2(1.0, -1.0));
  tmpvar_36.y = s_26;
  float3 tmpvar_37;
  tmpvar_37 = mix (((float3)tmpvar_35 * tmpvar_29.xzy), ((float3)tmpvar_36 * tmpvar_29.zxy), (float3)half3(zxlerp_28));
  detailCoords_25 = half3(tmpvar_37);
  half3 tmpvar_38;
  tmpvar_38.xy = half2(float2(1.0, 1.0));
  tmpvar_38.z = s_26;
  float3 tmpvar_39;
  tmpvar_39 = mix (((float3)tmpvar_38 * tmpvar_29.yxz), (float3)detailCoords_25, (float3)half3(nylerp_27));
  detailCoords_25 = half3(tmpvar_39);
  uv_24 = half2(((float2)((
    ((half)0.5 * detailCoords_25.yz)
   / 
    abs(detailCoords_25.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_40;
  uv_40 = float2(uv_24);
  float2 uvCont_41;
  float2 tmpvar_42;
  tmpvar_42 = abs((uv_40 - (0.5 * _mtl_u._DetailScale)));
  uvCont_41.x = max (tmpvar_42.x, tmpvar_42.y);
  uvCont_41.y = min (tmpvar_42.x, tmpvar_42.y);
  float4 tmpvar_43;
  tmpvar_43.xy = dfdx(uvCont_41);
  tmpvar_43.zw = dfdy(uvCont_41);
  half4 tmpvar_44;
  tmpvar_44 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_24), gradient2d((float2)(tmpvar_43.xy), (float2)(tmpvar_43.zw)));
  half4 tmpvar_45;
  tmpvar_45 = tmpvar_44;
  float3 tmpvar_46;
  tmpvar_46 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_47;
  float tmpvar_48;
  tmpvar_48 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_46, tmpvar_46)
  )), 0.0, 1.0);
  tmpvar_47 = half(tmpvar_48);
  half4 tmpvar_49;
  tmpvar_49 = ((_mtl_u._Color * tmpvar_23) * mix (tmpvar_45, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_47)));
  color_2 = tmpvar_49;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_50;
  tmpvar_50 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_50);
  half4 tmpvar_51;
  tmpvar_51 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_51;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 63 math, 5 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Vector 2 [_Color]
Float 4 [_DetailDist]
Float 3 [_DetailScale]
Float 8 [_ShadowFactor]
Vector 0 [_Time]
Vector 7 [_UVNoiseAnimation]
Float 5 [_UVNoiseScale]
Float 6 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
SetTexture 0 [cube_MainTex] CUBE 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
"ps_3_0
def c9, 0, -0.5, 1, -1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_cube s0
dcl_2d s1
dcl_2d s2
mov r0.xz, c9.zyww
dp3 r0.w, v4, v4
rsq r0.w, r0.w
mul r1.xyz, r0.w, v4.yxzw
max r0.w, r1_abs.y, r1_abs.z
add r0.w, -r1_abs.x, r0.w
add r1.w, -r1_abs.y, r1_abs.z
cmp_pp r2.x, r1.w, r1.z, r1.y
cmp r2.x, r0.w, r2.x, r1.x
cmp r2.y, -r2.x, c9.x, c9.z
cmp r2.x, r2.x, -c9.x, -c9.z
add_pp r2.y, r2.x, r2.y
mov_pp r0.y, -r2.y
mul_pp r0.xyz, r0, r1.yzxw
mov r2.xz, c9.zyww
mul_pp r3.xyz, r1.zyxw, r2
mul_pp r1.xyz, r1, r2.xxyw
cmp_pp r0.xyz, r1.w, r3, r0
cmp_pp r0.xyz, r0.w, r0, r1
mul_pp r0.yz, r0, -c9.y
rcp r0.x, r0_abs.x
mad_pp r0.xy, r0.yzzw, r0.x, -c9.y
mul_pp r0.xy, r0, c3.x
mov r1.xy, c9
mad r0.zw, c3.x, r1.y, r0.xyxy
add r1.y, -r0_abs.w, r0_abs.z
cmp r0.zw, r1.y, r0_abs, r0_abs.xywz
dsx r1.yz, r0.xzww
dsy r0.zw, r0
texldd_pp r0, r0, s1, r1.yzzw, r0.zwzw
add r1.yzw, -c1.xxyz, v2.xxyz
dp3 r1.y, r1.yzww, r1.yzww
rsq r1.y, r1.y
rcp r1.y, r1.y
dp2add_sat_pp r1.y, r1.y, c4.x, r1.x
lrp_pp r2, r1.y, c9.z, r0
mov r0.xy, c7
mul r0.xy, r0, c0.x
rcp r0.z, c5.x
nrm r3.xyz, v3
mul r1.yz, r0.z, r3.xxyw
frc r4.xy, r1_abs.yzzw
cmp r1.yz, r1, r4.xxyw, -r4.xxyw
mul r1.yz, r1, c5.x
mad r0.xy, r1.yzzw, r0.z, r0
texld r0, r0, s2
add r0.xy, r0, c9.y
mad r3.xy, r0, c6.x, r3
texld_pp r0, r3, s0
mul_pp r0, r0, c2
mad_pp r1.y, r0.w, -r2.w, c9.z
mul_pp r0, r2, r0
mul_sat_pp r1.yzw, r1.y, r0.xxyz
add r1.yzw, r1, c9.w
mul r2.x, r0.w, c8.x
mul r0.xyz, r1.yzww, r2.x
add_pp r0, r0, c9.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r1.x
mad_pp oC0, r1.x, r0, c9.z

"
}
SubProgram "d3d11 " {
// Stats: 62 math, 2 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
SetTexture 0 [_UVNoiseTex] 2D 2
SetTexture 1 [cube_MainTex] CUBE 0
SetTexture 2 [_DetailTex] 2D 1
ConstBuffer "$Globals" 544
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:adacadaa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"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 66 math, 3 textures, 3 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
SetTexture 0 [cube_MainTex] CUBE 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
ConstBuffer "$Globals" 68
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [_Color] 4
Float 40 [_DetailScale]
Float 44 [_DetailDist]
Float 48 [_UVNoiseScale]
Float 52 [_UVNoiseStrength]
Vector 56 [_UVNoiseAnimation] 2
Float 64 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texturecube<half> cube_MainTex [[texture(0)]], sampler _mtlsmp_cube_MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]]
  ,   texture2d<half> _UVNoiseTex [[texture(2)]], sampler _mtlsmp__UVNoiseTex [[sampler(2)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  float3 cubeVect_5;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i.xlv_TEXCOORD4);
  cubeVect_5 = tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (tmpvar_6 / float3(_mtl_u._UVNoiseScale));
  float3 tmpvar_8;
  tmpvar_8 = (fract(abs(tmpvar_7)) * float3(_mtl_u._UVNoiseScale));
  float tmpvar_9;
  if ((tmpvar_7.x >= 0.0)) {
    tmpvar_9 = tmpvar_8.x;
  } else {
    tmpvar_9 = -(tmpvar_8.x);
  };
  float tmpvar_10;
  if ((tmpvar_7.y >= 0.0)) {
    tmpvar_10 = tmpvar_8.y;
  } else {
    tmpvar_10 = -(tmpvar_8.y);
  };
  float tmpvar_11;
  if ((tmpvar_7.z >= 0.0)) {
    tmpvar_11 = tmpvar_8.z;
  } else {
    tmpvar_11 = -(tmpvar_8.z);
  };
  float3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  float2 tmpvar_13;
  tmpvar_13 = ((tmpvar_12 / _mtl_u._UVNoiseScale).xy + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_14;
  tmpvar_14 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_13));
  cubeVect_5.xy = (tmpvar_6.xy + ((float2)(tmpvar_14.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength));
  half4 tmpvar_15;
  tmpvar_15 = cube_MainTex.sample(_mtlsmp_cube_MainTex, (float3)(cubeVect_5));
  half4 tmpvar_16;
  tmpvar_16 = tmpvar_15;
  half2 uv_17;
  half3 detailCoords_18;
  half s_19;
  half nylerp_20;
  half zxlerp_21;
  float3 tmpvar_22;
  tmpvar_22 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_23;
  tmpvar_23 = abs(tmpvar_22);
  float tmpvar_24;
  tmpvar_24 = float((tmpvar_23.z >= tmpvar_23.x));
  zxlerp_21 = half(tmpvar_24);
  float tmpvar_25;
  tmpvar_25 = float((max (tmpvar_23.x, tmpvar_23.z) >= tmpvar_23.y));
  nylerp_20 = half(tmpvar_25);
  float tmpvar_26;
  tmpvar_26 = mix (tmpvar_22.x, tmpvar_22.z, (float)zxlerp_21);
  s_19 = half(tmpvar_26);
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_22.y, (float)s_19, (float)nylerp_20));
  s_19 = half(tmpvar_27);
  half3 tmpvar_28;
  tmpvar_28.xz = half2(float2(1.0, -1.0));
  tmpvar_28.y = -(s_19);
  half3 tmpvar_29;
  tmpvar_29.xz = half2(float2(1.0, -1.0));
  tmpvar_29.y = s_19;
  float3 tmpvar_30;
  tmpvar_30 = mix (((float3)tmpvar_28 * tmpvar_22.xzy), ((float3)tmpvar_29 * tmpvar_22.zxy), (float3)half3(zxlerp_21));
  detailCoords_18 = half3(tmpvar_30);
  half3 tmpvar_31;
  tmpvar_31.xy = half2(float2(1.0, 1.0));
  tmpvar_31.z = s_19;
  float3 tmpvar_32;
  tmpvar_32 = mix (((float3)tmpvar_31 * tmpvar_22.yxz), (float3)detailCoords_18, (float3)half3(nylerp_20));
  detailCoords_18 = half3(tmpvar_32);
  uv_17 = half2(((float2)((
    ((half)0.5 * detailCoords_18.yz)
   / 
    abs(detailCoords_18.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_33;
  uv_33 = float2(uv_17);
  float2 uvCont_34;
  float2 tmpvar_35;
  tmpvar_35 = abs((uv_33 - (0.5 * _mtl_u._DetailScale)));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  float4 tmpvar_36;
  tmpvar_36.xy = dfdx(uvCont_34);
  tmpvar_36.zw = dfdy(uvCont_34);
  half4 tmpvar_37;
  tmpvar_37 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_17), gradient2d((float2)(tmpvar_36.xy), (float2)(tmpvar_36.zw)));
  half4 tmpvar_38;
  tmpvar_38 = tmpvar_37;
  float3 tmpvar_39;
  tmpvar_39 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_40;
  float tmpvar_41;
  tmpvar_41 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_39, tmpvar_39)
  )), 0.0, 1.0);
  tmpvar_40 = half(tmpvar_41);
  half4 tmpvar_42;
  tmpvar_42 = ((_mtl_u._Color * tmpvar_16) * mix (tmpvar_38, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_40)));
  color_2 = tmpvar_42;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_43;
  tmpvar_43 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_43);
  half4 tmpvar_44;
  tmpvar_44 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_44;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 68 math, 5 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Vector 3 [_Color]
Float 5 [_DetailDist]
Float 4 [_DetailScale]
Float 9 [_ShadowFactor]
Vector 0 [_Time]
Vector 8 [_UVNoiseAnimation]
Float 6 [_UVNoiseScale]
Float 7 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
Vector 2 [alphaMask1]
SetTexture 0 [cube_MainTex] CUBE 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
"ps_3_0
def c10, 0, -0.5, 1, -1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_cube s0
dcl_2d s1
dcl_2d s2
mov r0.xz, c10.zyww
dp3 r0.w, v4, v4
rsq r0.w, r0.w
mul r1.xyz, r0.w, v4.yxzw
max r0.w, r1_abs.y, r1_abs.z
add r0.w, -r1_abs.x, r0.w
add r1.w, -r1_abs.y, r1_abs.z
cmp_pp r2.x, r1.w, r1.z, r1.y
cmp r2.x, r0.w, r2.x, r1.x
cmp r2.y, -r2.x, c10.x, c10.z
cmp r2.x, r2.x, -c10.x, -c10.z
add_pp r2.y, r2.x, r2.y
mov_pp r0.y, -r2.y
mul_pp r0.xyz, r0, r1.yzxw
mov r2.xz, c10.zyww
mul_pp r3.xyz, r1.zyxw, r2
mul_pp r1.xyz, r1, r2.xxyw
cmp_pp r0.xyz, r1.w, r3, r0
cmp_pp r0.xyz, r0.w, r0, r1
mul_pp r0.yz, r0, -c10.y
rcp r0.x, r0_abs.x
mad_pp r0.xy, r0.yzzw, r0.x, -c10.y
mul_pp r0.xy, r0, c4.x
mov r1.xy, c10
mad r0.zw, c4.x, r1.y, r0.xyxy
add r1.y, -r0_abs.w, r0_abs.z
cmp r0.zw, r1.y, r0_abs, r0_abs.xywz
dsx r1.yz, r0.xzww
dsy r0.zw, r0
texldd_pp r0, r0, s1, r1.yzzw, r0.zwzw
add r1.yzw, -c1.xxyz, v2.xxyz
dp3 r1.y, r1.yzww, r1.yzww
rsq r1.y, r1.y
rcp r1.y, r1.y
dp2add_sat_pp r1.y, r1.y, c5.x, r1.x
lrp_pp r2, r1.y, c10.z, r0
mov r0.xy, c8
mul r0.xy, r0, c0.x
rcp r0.z, c6.x
nrm r3.xyz, v3
mul r1.yz, r0.z, r3.xxyw
frc r4.xy, r1_abs.yzzw
cmp r1.yz, r1, r4.xxyw, -r4.xxyw
mul r1.yz, r1, c6.x
mad r0.xy, r1.yzzw, r0.z, r0
texld r0, r0, s2
add r0.xy, r0, c10.y
mad r3.xy, r0, c7.x, r3
texld_pp r0, r3, s0
mul_pp r0.xy, r0, c2
add_pp r0.x, r0.y, r0.x
mad_pp r0.x, r0.z, c2.z, r0.x
mad_pp r0.w, r0.w, c2.w, r0.x
mov r0.xyz, c10.z
mul_pp r0, r0, c3
mad_pp r1.y, r0.w, -r2.w, c10.z
mul_pp r0, r2, r0
mul_sat_pp r1.yzw, r1.y, r0.xxyz
add r1.yzw, r1, c10.w
mul r2.x, r0.w, c9.x
mul r0.xyz, r1.yzww, r2.x
add_pp r0, r0, c10.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r1.x
mad_pp oC0, r1.x, r0, c10.z

"
}
SubProgram "d3d11 " {
// Stats: 66 math, 2 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
SetTexture 0 [_UVNoiseTex] 2D 2
SetTexture 1 [cube_MainTex] CUBE 0
SetTexture 2 [_DetailTex] 2D 1
ConstBuffer "$Globals" 544
Vector 352 [alphaMask1]
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:adacadaa
eefiecednplgccgegjolgdkdcghmpnajpmbnigbgabaaaaaaiealaaaaadaaaaaa
cmaaaaaapmaaaaaadaabaaaaejfdeheomiaaaaaaahaaaaaaaiaaaaaalaaaaaaa
aaaaaaaaabaaaaaaadaaaaaaaaaaaaaaapaaaaaalmaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaapaiaaaalmaaaaaaabaaaaaaaaaaaaaaadaaaaaaacaaaaaa
ababaaaalmaaaaaaacaaaaaaaaaaaaaaadaaaaaaacaaaaaaacaaaaaalmaaaaaa
adaaaaaaaaaaaaaaadaaaaaaadaaaaaaapahaaaalmaaaaaaaeaaaaaaaaaaaaaa
adaaaaaaaeaaaaaaahahaaaalmaaaaaaafaaaaaaaaaaaaaaadaaaaaaafaaaaaa
ahahaaaafdfgfpfaepfdejfeejepeoaafeeffiedepepfceeaaklklklepfdeheo
cmaaaaaaabaaaaaaaiaaaaaacaaaaaaaaaaaaaaaaaaaaaaaadaaaaaaaaaaaaaa
apaaaaaafdfgfpfegbhcghgfheaaklklfdeieefcemakaaaaeaaaaaaajdacaaaa
fjaaaaaeegiocaaaaaaaaaaabnaaaaaafjaaaaaeegiocaaaabaaaaaaafaaaaaa
fkaaaaadaagabaaaaaaaaaaafkaaaaadaagabaaaabaaaaaafkaaaaadaagabaaa
acaaaaaafibiaaaeaahabaaaaaaaaaaaffffaaaafidaaaaeaahabaaaabaaaaaa
ffffaaaafibiaaaeaahabaaaacaaaaaaffffaaaagcbaaaadicbabaaaabaaaaaa
gcbaaaadbcbabaaaacaaaaaagcbaaaadhcbabaaaadaaaaaagcbaaaadhcbabaaa
aeaaaaaagcbaaaadhcbabaaaafaaaaaagfaaaaadpccabaaaaaaaaaaagiaaaaac
aeaaaaaadgaaaaaifcaabaaaaaaaaaaaaceaaaaaaaaaiadpaaaaaaaaaaaaialp
aaaaaaaabaaaaaahicaabaaaaaaaaaaaegbcbaaaafaaaaaaegbcbaaaafaaaaaa
eeaaaaaficaabaaaaaaaaaaadkaabaaaaaaaaaaadiaaaaahhcaabaaaabaaaaaa
pgapbaaaaaaaaaaabgbgbaaaafaaaaaadcaaaaakicaabaaaabaaaaaackbabaaa
afaaaaaadkaabaaaaaaaaaaabkaabaiaebaaaaaaabaaaaaabnaaaaajbcaabaaa
acaaaaaackaabaiaibaaaaaaabaaaaaabkaabaiaibaaaaaaabaaaaaaabaaaaah
bcaabaaaacaaaaaaakaabaaaacaaaaaaabeaaaaaaaaaiadpdcaaaaajicaabaaa
abaaaaaaakaabaaaacaaaaaadkaabaaaabaaaaaabkaabaaaabaaaaaadcaaaaak
icaabaaaaaaaaaaabkbabaiaebaaaaaaafaaaaaadkaabaaaaaaaaaaadkaabaaa
abaaaaaadeaaaaajicaabaaaabaaaaaackaabaiaibaaaaaaabaaaaaabkaabaia
ibaaaaaaabaaaaaabnaaaaaiicaabaaaabaaaaaadkaabaaaabaaaaaaakaabaia
ibaaaaaaabaaaaaaabaaaaahicaabaaaabaaaaaadkaabaaaabaaaaaaabeaaaaa
aaaaiadpdcaaaaajicaabaaaaaaaaaaadkaabaaaabaaaaaadkaabaaaaaaaaaaa
akaabaaaabaaaaaadbaaaaahccaabaaaacaaaaaaabeaaaaaaaaaaaaadkaabaaa
aaaaaaaadbaaaaahicaabaaaaaaaaaaadkaabaaaaaaaaaaaabeaaaaaaaaaaaaa
boaaaaaiicaabaaaaaaaaaaabkaabaiaebaaaaaaacaaaaaadkaabaaaaaaaaaaa
claaaaafccaabaaaadaaaaaadkaabaaaaaaaaaaadgaaaaagccaabaaaaaaaaaaa
bkaabaiaebaaaaaaadaaaaaadiaaaaahhcaabaaaaaaaaaaaegacbaaaaaaaaaaa
jgaebaaaabaaaaaadgaaaaaifcaabaaaadaaaaaaaceaaaaaaaaaiadpaaaaaaaa
aaaaialpaaaaaaaadcaaaaakocaabaaaacaaaaaaagajbaaaadaaaaaakgabbaaa
abaaaaaaagajbaiaebaaaaaaaaaaaaaadcaaaaajhcaabaaaaaaaaaaaagaabaaa
acaaaaaajgahbaaaacaaaaaaegacbaaaaaaaaaaadcaaaaakhcaabaaaaaaaaaaa
agabbaiaebaaaaaaadaaaaaaegacbaaaabaaaaaaegacbaaaaaaaaaaadiaaaaah
hcaabaaaabaaaaaaegacbaaaabaaaaaaagabbaaaadaaaaaadcaaaaajhcaabaaa
aaaaaaaapgapbaaaabaaaaaaegacbaaaaaaaaaaaegacbaaaabaaaaaadiaaaaak
gcaabaaaaaaaaaaafgagbaaaaaaaaaaaaceaaaaaaaaaaaaaaaaaaadpaaaaaadp
aaaaaaaaaoaaaaaidcaabaaaaaaaaaaajgafbaaaaaaaaaaaagaabaiaibaaaaaa
aaaaaaaaaaaaaaakdcaabaaaaaaaaaaaegaabaaaaaaaaaaaaceaaaaaaaaaaadp
aaaaaadpaaaaaaaaaaaaaaaadiaaaaaidcaabaaaaaaaaaaaegaabaaaaaaaaaaa
agiacaaaaaaaaaaabjaaaaaadcaaaaaomcaabaaaaaaaaaaaagiacaiaebaaaaaa
aaaaaaaabjaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaadpaaaaaadpagaebaaa
aaaaaaaadeaaaaajbcaabaaaabaaaaaadkaabaiaibaaaaaaaaaaaaaackaabaia
ibaaaaaaaaaaaaaaddaaaaajecaabaaaaaaaaaaadkaabaiaibaaaaaaaaaaaaaa
ckaabaiaibaaaaaaaaaaaaaaalaaaaafbcaabaaaacaaaaaaakaabaaaabaaaaaa
amaaaaafbcaabaaaabaaaaaaakaabaaaabaaaaaaalaaaaafccaabaaaacaaaaaa
ckaabaaaaaaaaaaaamaaaaafccaabaaaabaaaaaackaabaaaaaaaaaaaejaaaaan
pcaabaaaaaaaaaaaegaabaaaaaaaaaaaeghobaaaacaaaaaaaagabaaaabaaaaaa
egaabaaaacaaaaaaegaabaaaabaaaaaaaaaaaaalpcaabaaaabaaaaaaegaobaia
ebaaaaaaaaaaaaaaaceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadpaaaaaaaj
hcaabaaaacaaaaaaegbcbaaaadaaaaaaegiccaiaebaaaaaaabaaaaaaaeaaaaaa
baaaaaahbcaabaaaacaaaaaaegacbaaaacaaaaaaegacbaaaacaaaaaaelaaaaaf
bcaabaaaacaaaaaaakaabaaaacaaaaaaapcaaaaibcaabaaaacaaaaaaagaabaaa
acaaaaaafgifcaaaaaaaaaaabjaaaaaadcaaaaajpcaabaaaaaaaaaaaagaabaaa
acaaaaaaegaobaaaabaaaaaaegaobaaaaaaaaaaabaaaaaahbcaabaaaabaaaaaa
egbcbaaaaeaaaaaaegbcbaaaaeaaaaaaeeaaaaafbcaabaaaabaaaaaaakaabaaa
abaaaaaadiaaaaahhcaabaaaabaaaaaaagaabaaaabaaaaaaegbcbaaaaeaaaaaa
aoaaaaaidcaabaaaacaaaaaaegaabaaaabaaaaaakgikcaaaaaaaaaaabjaaaaaa
bnaaaaaimcaabaaaacaaaaaaagaebaaaacaaaaaaagaebaiaebaaaaaaacaaaaaa
bkaaaaagdcaabaaaacaaaaaaegaabaiaibaaaaaaacaaaaaadhaaaaakdcaabaaa
acaaaaaaogakbaaaacaaaaaaegaabaaaacaaaaaaegaabaiaebaaaaaaacaaaaaa
diaaaaaidcaabaaaacaaaaaaegaabaaaacaaaaaakgikcaaaaaaaaaaabjaaaaaa
aoaaaaaidcaabaaaacaaaaaaegaabaaaacaaaaaakgikcaaaaaaaaaaabjaaaaaa
dcaaaaaldcaabaaaacaaaaaaegiacaaaaaaaaaaabkaaaaaaagiacaaaabaaaaaa
aaaaaaaaegaabaaaacaaaaaaefaaaaajpcaabaaaacaaaaaaegaabaaaacaaaaaa
eghobaaaaaaaaaaaaagabaaaacaaaaaaaaaaaaakdcaabaaaacaaaaaaegaabaaa
acaaaaaaaceaaaaaaaaaaalpaaaaaalpaaaaaaaaaaaaaaaadcaaaaakdcaabaaa
abaaaaaaegaabaaaacaaaaaapgipcaaaaaaaaaaabjaaaaaaegaabaaaabaaaaaa
efaaaaajpcaabaaaabaaaaaaegacbaaaabaaaaaaeghobaaaabaaaaaaaagabaaa
aaaaaaaadiaaaaaidcaabaaaabaaaaaaegaabaaaabaaaaaaegiacaaaaaaaaaaa
bgaaaaaaaaaaaaahbcaabaaaabaaaaaabkaabaaaabaaaaaaakaabaaaabaaaaaa
dcaaaaakbcaabaaaabaaaaaackaabaaaabaaaaaackiacaaaaaaaaaaabgaaaaaa
akaabaaaabaaaaaadcaaaaakicaabaaaabaaaaaadkaabaaaabaaaaaadkiacaaa
aaaaaaaabgaaaaaaakaabaaaabaaaaaadgaaaaaihcaabaaaabaaaaaaaceaaaaa
aaaaiadpaaaaiadpaaaaiadpaaaaaaaadiaaaaaipcaabaaaabaaaaaaegaobaaa
abaaaaaaegiocaaaaaaaaaaabhaaaaaadcaaaaakbcaabaaaacaaaaaadkaabaia
ebaaaaaaabaaaaaadkaabaaaaaaaaaaaabeaaaaaaaaaiadpdiaaaaahpcaabaaa
aaaaaaaaegaobaaaaaaaaaaaegaobaaaabaaaaaadicaaaahhcaabaaaabaaaaaa
agaabaaaacaaaaaaegacbaaaaaaaaaaaaaaaaaakhcaabaaaabaaaaaaegacbaaa
abaaaaaaaceaaaaaaaaaialpaaaaialpaaaaialpaaaaaaaadiaaaaaiicaabaaa
abaaaaaadkaabaaaaaaaaaaackiacaaaaaaaaaaabmaaaaaadiaaaaahhcaabaaa
aaaaaaaaegacbaaaabaaaaaapgapbaaaabaaaaaaaaaaaaakpcaabaaaaaaaaaaa
egaobaaaaaaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaialpbnaaaaah
bcaabaaaabaaaaaadkbabaaaabaaaaaaabeaaaaaaaaaaaaaabaaaaahbcaabaaa
abaaaaaaakaabaaaabaaaaaaabeaaaaaaaaaiadpdiaaaaahbcaabaaaabaaaaaa
akaabaaaabaaaaaaakbabaaaacaaaaaadcaaaaampccabaaaaaaaaaaaagaabaaa
abaaaaaaegaobaaaaaaaaaaaaceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadp
doaaaaab"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 71 math, 3 textures, 3 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
SetTexture 0 [cube_MainTex] CUBE 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
ConstBuffer "$Globals" 76
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [alphaMask1] 4
VectorHalf 40 [_Color] 4
Float 48 [_DetailScale]
Float 52 [_DetailDist]
Float 56 [_UVNoiseScale]
Float 60 [_UVNoiseStrength]
Vector 64 [_UVNoiseAnimation] 2
Float 72 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 alphaMask1;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texturecube<half> cube_MainTex [[texture(0)]], sampler _mtlsmp_cube_MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]]
  ,   texture2d<half> _UVNoiseTex [[texture(2)]], sampler _mtlsmp__UVNoiseTex [[sampler(2)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  float3 cubeVect_5;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i.xlv_TEXCOORD4);
  cubeVect_5 = tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (tmpvar_6 / float3(_mtl_u._UVNoiseScale));
  float3 tmpvar_8;
  tmpvar_8 = (fract(abs(tmpvar_7)) * float3(_mtl_u._UVNoiseScale));
  float tmpvar_9;
  if ((tmpvar_7.x >= 0.0)) {
    tmpvar_9 = tmpvar_8.x;
  } else {
    tmpvar_9 = -(tmpvar_8.x);
  };
  float tmpvar_10;
  if ((tmpvar_7.y >= 0.0)) {
    tmpvar_10 = tmpvar_8.y;
  } else {
    tmpvar_10 = -(tmpvar_8.y);
  };
  float tmpvar_11;
  if ((tmpvar_7.z >= 0.0)) {
    tmpvar_11 = tmpvar_8.z;
  } else {
    tmpvar_11 = -(tmpvar_8.z);
  };
  float3 tmpvar_12;
  tmpvar_12.x = tmpvar_9;
  tmpvar_12.y = tmpvar_10;
  tmpvar_12.z = tmpvar_11;
  float2 tmpvar_13;
  tmpvar_13 = ((tmpvar_12 / _mtl_u._UVNoiseScale).xy + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_14;
  tmpvar_14 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_13));
  cubeVect_5.xy = (tmpvar_6.xy + ((float2)(tmpvar_14.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength));
  half4 tmpvar_15;
  tmpvar_15 = cube_MainTex.sample(_mtlsmp_cube_MainTex, (float3)(cubeVect_5));
  half4 tmpvar_16;
  tmpvar_16 = tmpvar_15;
  half4 v_17;
  v_17 = (tmpvar_16 * _mtl_u.alphaMask1);
  half4 tmpvar_18;
  tmpvar_18.xyz = half3(float3(1.0, 1.0, 1.0));
  tmpvar_18.w = ((v_17.x + v_17.y) + (v_17.z + v_17.w));
  half2 uv_19;
  half3 detailCoords_20;
  half s_21;
  half nylerp_22;
  half zxlerp_23;
  float3 tmpvar_24;
  tmpvar_24 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_25;
  tmpvar_25 = abs(tmpvar_24);
  float tmpvar_26;
  tmpvar_26 = float((tmpvar_25.z >= tmpvar_25.x));
  zxlerp_23 = half(tmpvar_26);
  float tmpvar_27;
  tmpvar_27 = float((max (tmpvar_25.x, tmpvar_25.z) >= tmpvar_25.y));
  nylerp_22 = half(tmpvar_27);
  float tmpvar_28;
  tmpvar_28 = mix (tmpvar_24.x, tmpvar_24.z, (float)zxlerp_23);
  s_21 = half(tmpvar_28);
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_24.y, (float)s_21, (float)nylerp_22));
  s_21 = half(tmpvar_29);
  half3 tmpvar_30;
  tmpvar_30.xz = half2(float2(1.0, -1.0));
  tmpvar_30.y = -(s_21);
  half3 tmpvar_31;
  tmpvar_31.xz = half2(float2(1.0, -1.0));
  tmpvar_31.y = s_21;
  float3 tmpvar_32;
  tmpvar_32 = mix (((float3)tmpvar_30 * tmpvar_24.xzy), ((float3)tmpvar_31 * tmpvar_24.zxy), (float3)half3(zxlerp_23));
  detailCoords_20 = half3(tmpvar_32);
  half3 tmpvar_33;
  tmpvar_33.xy = half2(float2(1.0, 1.0));
  tmpvar_33.z = s_21;
  float3 tmpvar_34;
  tmpvar_34 = mix (((float3)tmpvar_33 * tmpvar_24.yxz), (float3)detailCoords_20, (float3)half3(nylerp_22));
  detailCoords_20 = half3(tmpvar_34);
  uv_19 = half2(((float2)((
    ((half)0.5 * detailCoords_20.yz)
   / 
    abs(detailCoords_20.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_35;
  uv_35 = float2(uv_19);
  float2 uvCont_36;
  float2 tmpvar_37;
  tmpvar_37 = abs((uv_35 - (0.5 * _mtl_u._DetailScale)));
  uvCont_36.x = max (tmpvar_37.x, tmpvar_37.y);
  uvCont_36.y = min (tmpvar_37.x, tmpvar_37.y);
  float4 tmpvar_38;
  tmpvar_38.xy = dfdx(uvCont_36);
  tmpvar_38.zw = dfdy(uvCont_36);
  half4 tmpvar_39;
  tmpvar_39 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_19), gradient2d((float2)(tmpvar_38.xy), (float2)(tmpvar_38.zw)));
  half4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  float3 tmpvar_41;
  tmpvar_41 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_42;
  float tmpvar_43;
  tmpvar_43 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_41, tmpvar_41)
  )), 0.0, 1.0);
  tmpvar_42 = half(tmpvar_43);
  half4 tmpvar_44;
  tmpvar_44 = ((_mtl_u._Color * tmpvar_18) * mix (tmpvar_40, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_42)));
  color_2 = tmpvar_44;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_45;
  tmpvar_45 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_45);
  half4 tmpvar_46;
  tmpvar_46 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_46;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 94 math, 10 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Vector 2 [_Color]
Float 4 [_DetailDist]
Float 3 [_DetailScale]
Float 8 [_ShadowFactor]
Vector 0 [_Time]
Vector 7 [_UVNoiseAnimation]
Float 5 [_UVNoiseScale]
Float 6 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
SetTexture 0 [cube_MainTexPOS] 2D 0
SetTexture 1 [cube_MainTexNEG] 2D 1
SetTexture 2 [_DetailTex] 2D 2
SetTexture 3 [_UVNoiseTex] 2D 3
"ps_3_0
def c9, 0.5, -0.5, 0, 0
def c10, 0, 1, -0, -1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_2d s0
dcl_2d s1
dcl_2d s2
dcl_2d s3
mov r0.xz, c10.yyww
dp3 r0.w, v3, v3
rsq r0.w, r0.w
mul r1.xyz, r0.w, v3.yxzw
max r0.w, r1_abs.y, r1_abs.z
add r0.w, -r1_abs.x, r0.w
add r1.w, -r1_abs.y, r1_abs.z
cmp_pp r2.x, r1.w, r1.z, r1.y
cmp r2.x, r0.w, r2.x, r1.x
cmp r2.y, -r2.x, c10.x, c10.y
cmp r2.x, r2.x, c10.z, c10.w
add_pp r2.y, r2.x, r2.y
mov_pp r0.y, -r2.y
mul_pp r0.xyz, r0, r1.yzxw
mov r2.xz, c10.yyww
mul_pp r3.xyz, r1.zyxw, r2
mul_pp r1.xyz, r1, r2.xxyw
cmp_pp r0.xyz, r1.w, r3, r0
cmp_pp r0.xyz, r0.w, r0, r1
mul_pp r0.yz, r0, c9.x
rcp r0.x, r0_abs.x
mad_pp r0.xy, r0.yzzw, r0.x, c9.x
rcp r0.z, c5.x
mul r1.xy, r0.z, r0
frc r2.xz, r1_abs.xyyw
cmp r1.xy, r1, r2.xzzw, -r2.xzzw
mul r1.xy, r1, c5.x
mov r3.xy, c7
mul r2.xz, r3.xyyw, c0.x
mad r1.xy, r1, r0.z, r2.xzzw
texld r3, r1, s3
add r1.xy, r3, c9.y
mad_pp r0.xy, r1, c6.x, r0
add r1.xy, r0, c9.y
add r0.z, -r1_abs.y, r1_abs.x
cmp r1.xy, r0.z, r1_abs, r1_abs.yxzw
dsx r2.xz, r1.xyyw
dsy r1.xy, r1
texldd_pp r3, r0, s0, r2.xzzw, r1
texldd_pp r4, r0, s1, r2.xzzw, r1
cmp_pp r2, r2.y, r3, r4
cmp_pp r0.x, r1.w, r2.z, r2.x
cmp_pp r0.w, r0.w, r0.x, r2.y
mov_pp r0.xyz, r2.w
mul_pp r0, r0, c2
mov r1.xz, c10.yyww
dp3 r1.w, v4, v4
rsq r1.w, r1.w
mul r2.xyz, r1.w, v4.yxzw
max r1.w, r2_abs.y, r2_abs.z
add r1.w, -r2_abs.x, r1.w
add r2.w, -r2_abs.y, r2_abs.z
cmp_pp r3.x, r2.w, r2.z, r2.y
cmp r3.x, r1.w, r3.x, r2.x
cmp r3.y, -r3.x, c10.x, c10.y
cmp r3.x, r3.x, c10.z, c10.w
add_pp r3.y, r3.x, r3.y
mov_pp r1.y, -r3.y
mul_pp r1.xyz, r1, r2.yzxw
mov r3.xz, c10.yyww
mul_pp r4.xyz, r2.zyxw, r3
mul_pp r2.xyz, r2, r3.xxyw
cmp_pp r1.xyz, r2.w, r4, r1
cmp_pp r1.xyz, r1.w, r1, r2
mul_pp r1.yz, r1, c9.x
rcp r1.x, r1_abs.x
mad_pp r1.xy, r1.yzzw, r1.x, c9.x
mul_pp r1.xy, r1, c3.x
mov r2.x, c9.x
mad r1.zw, c3.x, -r2.x, r1.xyxy
add r2.x, -r1_abs.w, r1_abs.z
cmp r1.zw, r2.x, r1_abs, r1_abs.xywz
dsx r2.xy, r1.zwzw
dsy r1.zw, r1
texldd_pp r1, r1, s2, r2, r1.zwzw
add r2.xyz, -c1, v2
dp3 r2.x, r2, r2
rsq r2.x, r2.x
rcp r2.x, r2.x
mov r3.x, c10.x
dp2add_sat_pp r2.x, r2.x, c4.x, r3.x
lrp_pp r4, r2.x, c10.y, r1
mad_pp r1.x, r0.w, -r4.w, c10.y
mul_pp r0, r0, r4
mul_sat_pp r1.xyz, r1.x, r0
add r1.xyz, r1, c10.w
mul r1.w, r0.w, c8.x
mul r0.xyz, r1, r1.w
add_pp r0, r0, c10.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r3.x
mad_pp oC0, r1.x, r0, c10.y

"
}
SubProgram "d3d11 " {
// Stats: 99 math, 1 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
SetTexture 0 [_UVNoiseTex] 2D 3
SetTexture 1 [cube_MainTexPOS] 2D 0
SetTexture 2 [cube_MainTexNEG] 2D 1
SetTexture 3 [_DetailTex] 2D 2
ConstBuffer "$Globals" 544
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:aeacaeaa
eefiecedjjehidomgjimloamihgpgfgnccpnnbpaabaaaaaaembaaaaaadaaaaaa
cmaaaaaapmaaaaaadaabaaaaejfdeheomiaaaaaaahaaaaaaaiaaaaaalaaaaaaa
aaaaaaaaabaaaaaaadaaaaaaaaaaaaaaapaaaaaalmaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaapaiaaaalmaaaaaaabaaaaaaaaaaaaaaadaaaaaaacaaaaaa
ababaaaalmaaaaaaacaaaaaaaaaaaaaaadaaaaaaacaaaaaaacaaaaaalmaaaaaa
adaaaaaaaaaaaaaaadaaaaaaadaaaaaaapahaaaalmaaaaaaaeaaaaaaaaaaaaaa
adaaaaaaaeaaaaaaahahaaaalmaaaaaaafaaaaaaaaaaaaaaadaaaaaaafaaaaaa
ahahaaaafdfgfpfaepfdejfeejepeoaafeeffiedepepfceeaaklklklepfdeheo
cmaaaaaaabaaaaaaaiaaaaaacaaaaaaaaaaaaaaaaaaaaaaaadaaaaaaaaaaaaaa
apaaaaaafdfgfpfegbhcghgfheaaklklfdeieefcbeapaaaaeaaaaaaamfadaaaa
fjaaaaaeegiocaaaaaaaaaaabnaaaaaafjaaaaaeegiocaaaabaaaaaaafaaaaaa
fkaaaaadaagabaaaaaaaaaaafkaaaaadaagabaaaabaaaaaafkaaaaadaagabaaa
acaaaaaafkaaaaadaagabaaaadaaaaaafibiaaaeaahabaaaaaaaaaaaffffaaaa
fibiaaaeaahabaaaabaaaaaaffffaaaafibiaaaeaahabaaaacaaaaaaffffaaaa
fibiaaaeaahabaaaadaaaaaaffffaaaagcbaaaadicbabaaaabaaaaaagcbaaaad
bcbabaaaacaaaaaagcbaaaadhcbabaaaadaaaaaagcbaaaadhcbabaaaaeaaaaaa
gcbaaaadhcbabaaaafaaaaaagfaaaaadpccabaaaaaaaaaaagiaaaaacagaaaaaa
dgaaaaaifcaabaaaaaaaaaaaaceaaaaaaaaaiadpaaaaaaaaaaaaialpaaaaaaaa
baaaaaahicaabaaaaaaaaaaaegbcbaaaaeaaaaaaegbcbaaaaeaaaaaaeeaaaaaf
icaabaaaaaaaaaaadkaabaaaaaaaaaaadiaaaaahhcaabaaaabaaaaaapgapbaaa
aaaaaaaabgbgbaaaaeaaaaaadcaaaaakicaabaaaabaaaaaackbabaaaaeaaaaaa
dkaabaaaaaaaaaaabkaabaiaebaaaaaaabaaaaaabnaaaaajbcaabaaaacaaaaaa
ckaabaiaibaaaaaaabaaaaaabkaabaiaibaaaaaaabaaaaaaabaaaaahbcaabaaa
acaaaaaaakaabaaaacaaaaaaabeaaaaaaaaaiadpdcaaaaajicaabaaaabaaaaaa
akaabaaaacaaaaaadkaabaaaabaaaaaabkaabaaaabaaaaaadcaaaaakicaabaaa
aaaaaaaabkbabaiaebaaaaaaaeaaaaaadkaabaaaaaaaaaaadkaabaaaabaaaaaa
deaaaaajicaabaaaabaaaaaackaabaiaibaaaaaaabaaaaaabkaabaiaibaaaaaa
abaaaaaabnaaaaaiicaabaaaabaaaaaadkaabaaaabaaaaaaakaabaiaibaaaaaa
abaaaaaaabaaaaahicaabaaaabaaaaaadkaabaaaabaaaaaaabeaaaaaaaaaiadp
dcaaaaajicaabaaaaaaaaaaadkaabaaaabaaaaaadkaabaaaaaaaaaaaakaabaaa
abaaaaaadbaaaaahccaabaaaacaaaaaaabeaaaaaaaaaaaaadkaabaaaaaaaaaaa
dbaaaaahicaabaaaaaaaaaaadkaabaaaaaaaaaaaabeaaaaaaaaaaaaaboaaaaai
icaabaaaaaaaaaaabkaabaiaebaaaaaaacaaaaaadkaabaaaaaaaaaaaclaaaaaf
ccaabaaaadaaaaaadkaabaaaaaaaaaaadgaaaaagccaabaaaaaaaaaaabkaabaia
ebaaaaaaadaaaaaadiaaaaahhcaabaaaaaaaaaaaegacbaaaaaaaaaaajgaebaaa
abaaaaaadgaaaaaifcaabaaaadaaaaaaaceaaaaaaaaaiadpaaaaaaaaaaaaialp
aaaaaaaadcaaaaakocaabaaaacaaaaaaagajbaaaadaaaaaakgabbaaaabaaaaaa
agajbaiaebaaaaaaaaaaaaaadcaaaaajhcaabaaaaaaaaaaaagaabaaaacaaaaaa
jgahbaaaacaaaaaaegacbaaaaaaaaaaadcaaaaakhcaabaaaaaaaaaaaagabbaia
ebaaaaaaadaaaaaaegacbaaaabaaaaaaegacbaaaaaaaaaaadiaaaaahhcaabaaa
abaaaaaaegacbaaaabaaaaaaagabbaaaadaaaaaabnaaaaahicaabaaaaaaaaaaa
bkaabaaaadaaaaaaabeaaaaaaaaaaaaaabaaaaahicaabaaaaaaaaaaadkaabaaa
aaaaaaaaabeaaaaaaaaaiadpdcaaaaajhcaabaaaaaaaaaaapgapbaaaabaaaaaa
egacbaaaaaaaaaaaegacbaaaabaaaaaadiaaaaakgcaabaaaaaaaaaaafgagbaaa
aaaaaaaaaceaaaaaaaaaaaaaaaaaaadpaaaaaadpaaaaaaaaaoaaaaaidcaabaaa
aaaaaaaajgafbaaaaaaaaaaaagaabaiaibaaaaaaaaaaaaaaaaaaaaakdcaabaaa
aaaaaaaaegaabaaaaaaaaaaaaceaaaaaaaaaaadpaaaaaadpaaaaaaaaaaaaaaaa
aoaaaaaidcaabaaaabaaaaaaegaabaaaaaaaaaaakgikcaaaaaaaaaaabjaaaaaa
bnaaaaaigcaabaaaacaaaaaaagabbaaaabaaaaaaagabbaiaebaaaaaaabaaaaaa
bkaaaaagdcaabaaaabaaaaaaegaabaiaibaaaaaaabaaaaaadhaaaaakdcaabaaa
abaaaaaajgafbaaaacaaaaaaegaabaaaabaaaaaaegaabaiaebaaaaaaabaaaaaa
diaaaaaidcaabaaaabaaaaaaegaabaaaabaaaaaakgikcaaaaaaaaaaabjaaaaaa
aoaaaaaidcaabaaaabaaaaaaegaabaaaabaaaaaakgikcaaaaaaaaaaabjaaaaaa
dcaaaaaldcaabaaaabaaaaaaegiacaaaaaaaaaaabkaaaaaaagiacaaaabaaaaaa
aaaaaaaaegaabaaaabaaaaaaefaaaaajpcaabaaaadaaaaaaegaabaaaabaaaaaa
eghobaaaaaaaaaaaaagabaaaadaaaaaaaaaaaaakdcaabaaaabaaaaaaegaabaaa
adaaaaaaaceaaaaaaaaaaalpaaaaaalpaaaaaaaaaaaaaaaadcaaaaakdcaabaaa
aaaaaaaaegaabaaaabaaaaaapgipcaaaaaaaaaaabjaaaaaaegaabaaaaaaaaaaa
aaaaaaakdcaabaaaabaaaaaaegaabaaaaaaaaaaaaceaaaaaaaaaaalpaaaaaalp
aaaaaaaaaaaaaaaadeaaaaajecaabaaaaaaaaaaabkaabaiaibaaaaaaabaaaaaa
akaabaiaibaaaaaaabaaaaaaddaaaaajbcaabaaaabaaaaaabkaabaiaibaaaaaa
abaaaaaaakaabaiaibaaaaaaabaaaaaaalaaaaafbcaabaaaadaaaaaackaabaaa
aaaaaaaaamaaaaafbcaabaaaaeaaaaaackaabaaaaaaaaaaaalaaaaafccaabaaa
adaaaaaaakaabaaaabaaaaaaamaaaaafccaabaaaaeaaaaaaakaabaaaabaaaaaa
ejaaaaanpcaabaaaafaaaaaaegaabaaaaaaaaaaaeghobaaaabaaaaaaaagabaaa
aaaaaaaaegaabaaaadaaaaaaegaabaaaaeaaaaaaejaaaaanpcaabaaaadaaaaaa
egaabaaaaaaaaaaaeghobaaaacaaaaaaaagabaaaabaaaaaaegaabaaaadaaaaaa
egaabaaaaeaaaaaaaaaaaaaipcaabaaaaeaaaaaaegaobaiaebaaaaaaadaaaaaa
egaobaaaafaaaaaadcaaaaajpcaabaaaaaaaaaaapgapbaaaaaaaaaaaegaobaaa
aeaaaaaaegaobaaaadaaaaaaaaaaaaaiecaabaaaaaaaaaaaakaabaiaebaaaaaa
aaaaaaaackaabaaaaaaaaaaadcaaaaajbcaabaaaaaaaaaaaakaabaaaacaaaaaa
ckaabaaaaaaaaaaaakaabaaaaaaaaaaaaaaaaaaibcaabaaaaaaaaaaabkaabaia
ebaaaaaaaaaaaaaaakaabaaaaaaaaaaadcaaaaajicaabaaaabaaaaaadkaabaaa
abaaaaaaakaabaaaaaaaaaaabkaabaaaaaaaaaaadgaaaaafhcaabaaaabaaaaaa
pgapbaaaaaaaaaaadiaaaaaipcaabaaaaaaaaaaaegaobaaaabaaaaaaegiocaaa
aaaaaaaabhaaaaaadgaaaaaifcaabaaaabaaaaaaaceaaaaaaaaaiadpaaaaaaaa
aaaaialpaaaaaaaabaaaaaahicaabaaaabaaaaaaegbcbaaaafaaaaaaegbcbaaa
afaaaaaaeeaaaaaficaabaaaabaaaaaadkaabaaaabaaaaaadiaaaaahhcaabaaa
acaaaaaapgapbaaaabaaaaaabgbgbaaaafaaaaaadcaaaaakicaabaaaacaaaaaa
ckbabaaaafaaaaaadkaabaaaabaaaaaabkaabaiaebaaaaaaacaaaaaabnaaaaaj
bcaabaaaadaaaaaackaabaiaibaaaaaaacaaaaaabkaabaiaibaaaaaaacaaaaaa
abaaaaahbcaabaaaadaaaaaaakaabaaaadaaaaaaabeaaaaaaaaaiadpdcaaaaaj
icaabaaaacaaaaaaakaabaaaadaaaaaadkaabaaaacaaaaaabkaabaaaacaaaaaa
dcaaaaakicaabaaaabaaaaaabkbabaiaebaaaaaaafaaaaaadkaabaaaabaaaaaa
dkaabaaaacaaaaaadeaaaaajicaabaaaacaaaaaackaabaiaibaaaaaaacaaaaaa
bkaabaiaibaaaaaaacaaaaaabnaaaaaiicaabaaaacaaaaaadkaabaaaacaaaaaa
akaabaiaibaaaaaaacaaaaaaabaaaaahicaabaaaacaaaaaadkaabaaaacaaaaaa
abeaaaaaaaaaiadpdcaaaaajicaabaaaabaaaaaadkaabaaaacaaaaaadkaabaaa
abaaaaaaakaabaaaacaaaaaadbaaaaahccaabaaaadaaaaaaabeaaaaaaaaaaaaa
dkaabaaaabaaaaaadbaaaaahicaabaaaabaaaaaadkaabaaaabaaaaaaabeaaaaa
aaaaaaaaboaaaaaiicaabaaaabaaaaaabkaabaiaebaaaaaaadaaaaaadkaabaaa
abaaaaaaclaaaaafccaabaaaaeaaaaaadkaabaaaabaaaaaadgaaaaagccaabaaa
abaaaaaabkaabaiaebaaaaaaaeaaaaaadiaaaaahhcaabaaaabaaaaaaegacbaaa
abaaaaaajgaebaaaacaaaaaadgaaaaaifcaabaaaaeaaaaaaaceaaaaaaaaaiadp
aaaaaaaaaaaaialpaaaaaaaadcaaaaakocaabaaaadaaaaaaagajbaaaaeaaaaaa
kgabbaaaacaaaaaaagajbaiaebaaaaaaabaaaaaadcaaaaajhcaabaaaabaaaaaa
agaabaaaadaaaaaajgahbaaaadaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
abaaaaaaagabbaiaebaaaaaaaeaaaaaaegacbaaaacaaaaaaegacbaaaabaaaaaa
diaaaaahhcaabaaaacaaaaaaegacbaaaacaaaaaaagabbaaaaeaaaaaadcaaaaaj
hcaabaaaabaaaaaapgapbaaaacaaaaaaegacbaaaabaaaaaaegacbaaaacaaaaaa
diaaaaakgcaabaaaabaaaaaafgagbaaaabaaaaaaaceaaaaaaaaaaaaaaaaaaadp
aaaaaadpaaaaaaaaaoaaaaaidcaabaaaabaaaaaajgafbaaaabaaaaaaagaabaia
ibaaaaaaabaaaaaaaaaaaaakdcaabaaaabaaaaaaegaabaaaabaaaaaaaceaaaaa
aaaaaadpaaaaaadpaaaaaaaaaaaaaaaadiaaaaaidcaabaaaabaaaaaaegaabaaa
abaaaaaaagiacaaaaaaaaaaabjaaaaaadcaaaaaomcaabaaaabaaaaaaagiacaia
ebaaaaaaaaaaaaaabjaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaadpaaaaaadp
agaebaaaabaaaaaadeaaaaajbcaabaaaacaaaaaadkaabaiaibaaaaaaabaaaaaa
ckaabaiaibaaaaaaabaaaaaaddaaaaajecaabaaaabaaaaaadkaabaiaibaaaaaa
abaaaaaackaabaiaibaaaaaaabaaaaaaalaaaaafbcaabaaaadaaaaaaakaabaaa
acaaaaaaamaaaaafbcaabaaaacaaaaaaakaabaaaacaaaaaaalaaaaafccaabaaa
adaaaaaackaabaaaabaaaaaaamaaaaafccaabaaaacaaaaaackaabaaaabaaaaaa
ejaaaaanpcaabaaaabaaaaaaegaabaaaabaaaaaaeghobaaaadaaaaaaaagabaaa
acaaaaaaegaabaaaadaaaaaaegaabaaaacaaaaaaaaaaaaalpcaabaaaacaaaaaa
egaobaiaebaaaaaaabaaaaaaaceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadp
aaaaaaajhcaabaaaadaaaaaaegbcbaaaadaaaaaaegiccaiaebaaaaaaabaaaaaa
aeaaaaaabaaaaaahbcaabaaaadaaaaaaegacbaaaadaaaaaaegacbaaaadaaaaaa
elaaaaafbcaabaaaadaaaaaaakaabaaaadaaaaaaapcaaaaibcaabaaaadaaaaaa
agaabaaaadaaaaaafgifcaaaaaaaaaaabjaaaaaadcaaaaajpcaabaaaabaaaaaa
agaabaaaadaaaaaaegaobaaaacaaaaaaegaobaaaabaaaaaadcaaaaakbcaabaaa
acaaaaaadkaabaiaebaaaaaaaaaaaaaadkaabaaaabaaaaaaabeaaaaaaaaaiadp
diaaaaahpcaabaaaaaaaaaaaegaobaaaaaaaaaaaegaobaaaabaaaaaadicaaaah
hcaabaaaabaaaaaaagaabaaaacaaaaaaegacbaaaaaaaaaaaaaaaaaakhcaabaaa
abaaaaaaegacbaaaabaaaaaaaceaaaaaaaaaialpaaaaialpaaaaialpaaaaaaaa
diaaaaaiicaabaaaabaaaaaadkaabaaaaaaaaaaackiacaaaaaaaaaaabmaaaaaa
diaaaaahhcaabaaaaaaaaaaaegacbaaaabaaaaaapgapbaaaabaaaaaaaaaaaaak
pcaabaaaaaaaaaaaegaobaaaaaaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
aaaaialpbnaaaaahbcaabaaaabaaaaaadkbabaaaabaaaaaaabeaaaaaaaaaaaaa
abaaaaahbcaabaaaabaaaaaaakaabaaaabaaaaaaabeaaaaaaaaaiadpdiaaaaah
bcaabaaaabaaaaaaakaabaaaabaaaaaaakbabaaaacaaaaaadcaaaaampccabaaa
aaaaaaaaagaabaaaabaaaaaaegaobaaaaaaaaaaaaceaaaaaaaaaiadpaaaaiadp
aaaaiadpaaaaiadpdoaaaaab"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 97 math, 4 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
SetTexture 0 [cube_MainTexPOS] 2D 0
SetTexture 1 [cube_MainTexNEG] 2D 1
SetTexture 2 [_DetailTex] 2D 2
SetTexture 3 [_UVNoiseTex] 2D 3
ConstBuffer "$Globals" 68
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [_Color] 4
Float 40 [_DetailScale]
Float 44 [_DetailDist]
Float 48 [_UVNoiseScale]
Float 52 [_UVNoiseStrength]
Vector 56 [_UVNoiseAnimation] 2
Float 64 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> cube_MainTexPOS [[texture(0)]], sampler _mtlsmp_cube_MainTexPOS [[sampler(0)]]
  ,   texture2d<half> cube_MainTexNEG [[texture(1)]], sampler _mtlsmp_cube_MainTexNEG [[sampler(1)]]
  ,   texture2d<half> _DetailTex [[texture(2)]], sampler _mtlsmp__DetailTex [[sampler(2)]]
  ,   texture2d<half> _UVNoiseTex [[texture(3)]], sampler _mtlsmp__UVNoiseTex [[sampler(3)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  half2 uv_5;
  half3 detailCoords_6;
  half s_7;
  half nylerp_8;
  half zxlerp_9;
  float3 tmpvar_10;
  tmpvar_10 = normalize(_mtl_i.xlv_TEXCOORD4);
  float3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = half(tmpvar_12);
  float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = half(tmpvar_13);
  float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, (float)zxlerp_9);
  s_7 = half(tmpvar_14);
  float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, (float)s_7, (float)nylerp_8));
  s_7 = half(tmpvar_15);
  half3 tmpvar_16;
  tmpvar_16.xz = half2(float2(1.0, -1.0));
  tmpvar_16.y = -(s_7);
  half3 tmpvar_17;
  tmpvar_17.xz = half2(float2(1.0, -1.0));
  tmpvar_17.y = s_7;
  float3 tmpvar_18;
  tmpvar_18 = mix (((float3)tmpvar_16 * tmpvar_10.xzy), ((float3)tmpvar_17 * tmpvar_10.zxy), (float3)half3(zxlerp_9));
  detailCoords_6 = half3(tmpvar_18);
  half3 tmpvar_19;
  tmpvar_19.xy = half2(float2(1.0, 1.0));
  tmpvar_19.z = s_7;
  float3 tmpvar_20;
  tmpvar_20 = mix (((float3)tmpvar_19 * tmpvar_10.yxz), (float3)detailCoords_6, (float3)half3(nylerp_8));
  detailCoords_6 = half3(tmpvar_20);
  half2 tmpvar_21;
  tmpvar_21 = ((((half)0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + (half)0.5);
  uv_5 = tmpvar_21;
  float2 tmpvar_22;
  tmpvar_22 = ((float2)tmpvar_21 / float2(_mtl_u._UVNoiseScale));
  float2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * float2(_mtl_u._UVNoiseScale));
  float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  float2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  float2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _mtl_u._UVNoiseScale) + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_28;
  tmpvar_28 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_27));
  uv_5 = half2(((float2)tmpvar_21 + ((float2)(tmpvar_28.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength)));
  float2 uv_29;
  uv_29 = float2(uv_5);
  float2 uvCont_30;
  float2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  float4 tmpvar_32;
  tmpvar_32.xy = dfdx(uvCont_30);
  tmpvar_32.zw = dfdy(uvCont_30);
  half4 tmpvar_33;
  tmpvar_33 = cube_MainTexPOS.sample(_mtlsmp_cube_MainTexPOS, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  half4 tmpvar_35;
  tmpvar_35 = cube_MainTexNEG.sample(_mtlsmp_cube_MainTexNEG, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  half4 tmpvar_37;
  tmpvar_37 = mix (tmpvar_36, tmpvar_34, half4(half((s_7 >= (half)0.0))));
  half4 tmpvar_38;
  tmpvar_38.x = tmpvar_37.w;
  tmpvar_38.y = tmpvar_37.w;
  tmpvar_38.z = tmpvar_37.w;
  tmpvar_38.w = mix (tmpvar_37.y, mix (tmpvar_37.x, tmpvar_37.z, zxlerp_9), nylerp_8);
  half2 uv_39;
  half3 detailCoords_40;
  half s_41;
  half nylerp_42;
  half zxlerp_43;
  float3 tmpvar_44;
  tmpvar_44 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = half(tmpvar_46);
  float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = half(tmpvar_47);
  float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, (float)zxlerp_43);
  s_41 = half(tmpvar_48);
  float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, (float)s_41, (float)nylerp_42));
  s_41 = half(tmpvar_49);
  half3 tmpvar_50;
  tmpvar_50.xz = half2(float2(1.0, -1.0));
  tmpvar_50.y = -(s_41);
  half3 tmpvar_51;
  tmpvar_51.xz = half2(float2(1.0, -1.0));
  tmpvar_51.y = s_41;
  float3 tmpvar_52;
  tmpvar_52 = mix (((float3)tmpvar_50 * tmpvar_44.xzy), ((float3)tmpvar_51 * tmpvar_44.zxy), (float3)half3(zxlerp_43));
  detailCoords_40 = half3(tmpvar_52);
  half3 tmpvar_53;
  tmpvar_53.xy = half2(float2(1.0, 1.0));
  tmpvar_53.z = s_41;
  float3 tmpvar_54;
  tmpvar_54 = mix (((float3)tmpvar_53 * tmpvar_44.yxz), (float3)detailCoords_40, (float3)half3(nylerp_42));
  detailCoords_40 = half3(tmpvar_54);
  uv_39 = half2(((float2)((
    ((half)0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_55;
  uv_55 = float2(uv_39);
  float2 uvCont_56;
  float2 tmpvar_57;
  tmpvar_57 = abs((uv_55 - (0.5 * _mtl_u._DetailScale)));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  float4 tmpvar_58;
  tmpvar_58.xy = dfdx(uvCont_56);
  tmpvar_58.zw = dfdy(uvCont_56);
  half4 tmpvar_59;
  tmpvar_59 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_39), gradient2d((float2)(tmpvar_58.xy), (float2)(tmpvar_58.zw)));
  half4 tmpvar_60;
  tmpvar_60 = tmpvar_59;
  float3 tmpvar_61;
  tmpvar_61 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_62;
  float tmpvar_63;
  tmpvar_63 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_61, tmpvar_61)
  )), 0.0, 1.0);
  tmpvar_62 = half(tmpvar_63);
  half4 tmpvar_64;
  tmpvar_64 = ((_mtl_u._Color * tmpvar_38) * mix (tmpvar_60, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_62)));
  color_2 = tmpvar_64;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_65;
  tmpvar_65 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_65);
  half4 tmpvar_66;
  tmpvar_66 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_66;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 99 math, 10 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
Vector 3 [_Color]
Float 5 [_DetailDist]
Float 4 [_DetailScale]
Float 9 [_ShadowFactor]
Vector 0 [_Time]
Vector 8 [_UVNoiseAnimation]
Float 6 [_UVNoiseScale]
Float 7 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
Vector 2 [alphaMask1]
SetTexture 0 [cube_MainTexPOS] 2D 0
SetTexture 1 [cube_MainTexNEG] 2D 1
SetTexture 2 [_DetailTex] 2D 2
SetTexture 3 [_UVNoiseTex] 2D 3
"ps_3_0
def c10, 0.5, -0.5, 0, 0
def c11, 0, 1, -0, -1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_2d s0
dcl_2d s1
dcl_2d s2
dcl_2d s3
mov r0.xz, c11.yyww
dp3 r0.w, v3, v3
rsq r0.w, r0.w
mul r1.xyz, r0.w, v3.yxzw
max r0.w, r1_abs.y, r1_abs.z
add r0.w, -r1_abs.x, r0.w
add r1.w, -r1_abs.y, r1_abs.z
cmp_pp r2.x, r1.w, r1.z, r1.y
cmp r2.x, r0.w, r2.x, r1.x
cmp r2.y, -r2.x, c11.x, c11.y
cmp r2.x, r2.x, c11.z, c11.w
add_pp r2.y, r2.x, r2.y
mov_pp r0.y, -r2.y
mul_pp r0.xyz, r0, r1.yzxw
mov r2.xz, c11.yyww
mul_pp r3.xyz, r1.zyxw, r2
mul_pp r1.xyz, r1, r2.xxyw
cmp_pp r0.xyz, r1.w, r3, r0
cmp_pp r0.xyz, r0.w, r0, r1
mul_pp r0.yz, r0, c10.x
rcp r0.x, r0_abs.x
mad_pp r0.xy, r0.yzzw, r0.x, c10.x
rcp r0.z, c6.x
mul r1.xy, r0.z, r0
frc r2.xz, r1_abs.xyyw
cmp r1.xy, r1, r2.xzzw, -r2.xzzw
mul r1.xy, r1, c6.x
mov r3.xy, c8
mul r2.xz, r3.xyyw, c0.x
mad r1.xy, r1, r0.z, r2.xzzw
texld r3, r1, s3
add r1.xy, r3, c10.y
mad_pp r0.xy, r1, c7.x, r0
add r1.xy, r0, c10.y
add r0.z, -r1_abs.y, r1_abs.x
cmp r1.xy, r0.z, r1_abs, r1_abs.yxzw
dsx r2.xz, r1.xyyw
dsy r1.xy, r1
texldd_pp r3, r0, s0, r2.xzzw, r1
texldd_pp r4, r0, s1, r2.xzzw, r1
cmp_pp r2, r2.y, r3, r4
cmp_pp r0.x, r1.w, r2.z, r2.x
cmp_pp r0.x, r0.w, r0.x, r2.y
mov_pp r0.yzw, r2.w
mul_pp r0.yz, r0, c2.xxyw
add_pp r0.y, r0.z, r0.y
mad_pp r0.y, r0.w, c2.z, r0.y
mad_pp r0.w, r0.x, c2.w, r0.y
mov r0.xyz, c11.y
mul_pp r0, r0, c3
mov r1.xz, c11.yyww
dp3 r1.w, v4, v4
rsq r1.w, r1.w
mul r2.xyz, r1.w, v4.yxzw
max r1.w, r2_abs.y, r2_abs.z
add r1.w, -r2_abs.x, r1.w
add r2.w, -r2_abs.y, r2_abs.z
cmp_pp r3.x, r2.w, r2.z, r2.y
cmp r3.x, r1.w, r3.x, r2.x
cmp r3.y, -r3.x, c11.x, c11.y
cmp r3.x, r3.x, c11.z, c11.w
add_pp r3.y, r3.x, r3.y
mov_pp r1.y, -r3.y
mul_pp r1.xyz, r1, r2.yzxw
mov r3.xz, c11.yyww
mul_pp r4.xyz, r2.zyxw, r3
mul_pp r2.xyz, r2, r3.xxyw
cmp_pp r1.xyz, r2.w, r4, r1
cmp_pp r1.xyz, r1.w, r1, r2
mul_pp r1.yz, r1, c10.x
rcp r1.x, r1_abs.x
mad_pp r1.xy, r1.yzzw, r1.x, c10.x
mul_pp r1.xy, r1, c4.x
mov r2.x, c10.x
mad r1.zw, c4.x, -r2.x, r1.xyxy
add r2.x, -r1_abs.w, r1_abs.z
cmp r1.zw, r2.x, r1_abs, r1_abs.xywz
dsx r2.xy, r1.zwzw
dsy r1.zw, r1
texldd_pp r1, r1, s2, r2, r1.zwzw
add r2.xyz, -c1, v2
dp3 r2.x, r2, r2
rsq r2.x, r2.x
rcp r2.x, r2.x
mov r3.x, c11.x
dp2add_sat_pp r2.x, r2.x, c5.x, r3.x
lrp_pp r4, r2.x, c11.y, r1
mad_pp r1.x, r0.w, -r4.w, c11.y
mul_pp r0, r0, r4
mul_sat_pp r1.xyz, r1.x, r0
add r1.xyz, r1, c11.w
mul r1.w, r0.w, c9.x
mul r0.xyz, r1, r1.w
add_pp r0, r0, c11.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r3.x
mad_pp oC0, r1.x, r0, c11.y

"
}
SubProgram "d3d11 " {
// Stats: 103 math, 1 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
SetTexture 0 [_UVNoiseTex] 2D 3
SetTexture 1 [cube_MainTexPOS] 2D 0
SetTexture 2 [cube_MainTexNEG] 2D 1
SetTexture 3 [_DetailTex] 2D 2
ConstBuffer "$Globals" 544
Vector 352 [alphaMask1]
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:aeacaeaa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"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 102 math, 4 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
SetTexture 0 [cube_MainTexPOS] 2D 0
SetTexture 1 [cube_MainTexNEG] 2D 1
SetTexture 2 [_DetailTex] 2D 2
SetTexture 3 [_UVNoiseTex] 2D 3
ConstBuffer "$Globals" 76
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [alphaMask1] 4
VectorHalf 40 [_Color] 4
Float 48 [_DetailScale]
Float 52 [_DetailDist]
Float 56 [_UVNoiseScale]
Float 60 [_UVNoiseStrength]
Vector 64 [_UVNoiseAnimation] 2
Float 72 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 alphaMask1;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> cube_MainTexPOS [[texture(0)]], sampler _mtlsmp_cube_MainTexPOS [[sampler(0)]]
  ,   texture2d<half> cube_MainTexNEG [[texture(1)]], sampler _mtlsmp_cube_MainTexNEG [[sampler(1)]]
  ,   texture2d<half> _DetailTex [[texture(2)]], sampler _mtlsmp__DetailTex [[sampler(2)]]
  ,   texture2d<half> _UVNoiseTex [[texture(3)]], sampler _mtlsmp__UVNoiseTex [[sampler(3)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  half2 uv_5;
  half3 detailCoords_6;
  half s_7;
  half nylerp_8;
  half zxlerp_9;
  float3 tmpvar_10;
  tmpvar_10 = normalize(_mtl_i.xlv_TEXCOORD4);
  float3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = half(tmpvar_12);
  float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = half(tmpvar_13);
  float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, (float)zxlerp_9);
  s_7 = half(tmpvar_14);
  float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, (float)s_7, (float)nylerp_8));
  s_7 = half(tmpvar_15);
  half3 tmpvar_16;
  tmpvar_16.xz = half2(float2(1.0, -1.0));
  tmpvar_16.y = -(s_7);
  half3 tmpvar_17;
  tmpvar_17.xz = half2(float2(1.0, -1.0));
  tmpvar_17.y = s_7;
  float3 tmpvar_18;
  tmpvar_18 = mix (((float3)tmpvar_16 * tmpvar_10.xzy), ((float3)tmpvar_17 * tmpvar_10.zxy), (float3)half3(zxlerp_9));
  detailCoords_6 = half3(tmpvar_18);
  half3 tmpvar_19;
  tmpvar_19.xy = half2(float2(1.0, 1.0));
  tmpvar_19.z = s_7;
  float3 tmpvar_20;
  tmpvar_20 = mix (((float3)tmpvar_19 * tmpvar_10.yxz), (float3)detailCoords_6, (float3)half3(nylerp_8));
  detailCoords_6 = half3(tmpvar_20);
  half2 tmpvar_21;
  tmpvar_21 = ((((half)0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + (half)0.5);
  uv_5 = tmpvar_21;
  float2 tmpvar_22;
  tmpvar_22 = ((float2)tmpvar_21 / float2(_mtl_u._UVNoiseScale));
  float2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * float2(_mtl_u._UVNoiseScale));
  float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  float2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  float2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _mtl_u._UVNoiseScale) + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_28;
  tmpvar_28 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_27));
  uv_5 = half2(((float2)tmpvar_21 + ((float2)(tmpvar_28.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength)));
  float2 uv_29;
  uv_29 = float2(uv_5);
  float2 uvCont_30;
  float2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  float4 tmpvar_32;
  tmpvar_32.xy = dfdx(uvCont_30);
  tmpvar_32.zw = dfdy(uvCont_30);
  half4 tmpvar_33;
  tmpvar_33 = cube_MainTexPOS.sample(_mtlsmp_cube_MainTexPOS, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  half4 tmpvar_35;
  tmpvar_35 = cube_MainTexNEG.sample(_mtlsmp_cube_MainTexNEG, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  half4 tmpvar_37;
  tmpvar_37 = mix (tmpvar_36, tmpvar_34, half4(half((s_7 >= (half)0.0))));
  half4 tmpvar_38;
  tmpvar_38.x = tmpvar_37.w;
  tmpvar_38.y = tmpvar_37.w;
  tmpvar_38.z = tmpvar_37.w;
  tmpvar_38.w = mix (tmpvar_37.y, mix (tmpvar_37.x, tmpvar_37.z, zxlerp_9), nylerp_8);
  half4 v_39;
  v_39 = (tmpvar_38 * _mtl_u.alphaMask1);
  half4 tmpvar_40;
  tmpvar_40.xyz = half3(float3(1.0, 1.0, 1.0));
  tmpvar_40.w = ((v_39.x + v_39.y) + (v_39.z + v_39.w));
  half2 uv_41;
  half3 detailCoords_42;
  half s_43;
  half nylerp_44;
  half zxlerp_45;
  float3 tmpvar_46;
  tmpvar_46 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_47;
  tmpvar_47 = abs(tmpvar_46);
  float tmpvar_48;
  tmpvar_48 = float((tmpvar_47.z >= tmpvar_47.x));
  zxlerp_45 = half(tmpvar_48);
  float tmpvar_49;
  tmpvar_49 = float((max (tmpvar_47.x, tmpvar_47.z) >= tmpvar_47.y));
  nylerp_44 = half(tmpvar_49);
  float tmpvar_50;
  tmpvar_50 = mix (tmpvar_46.x, tmpvar_46.z, (float)zxlerp_45);
  s_43 = half(tmpvar_50);
  float tmpvar_51;
  tmpvar_51 = sign(mix (tmpvar_46.y, (float)s_43, (float)nylerp_44));
  s_43 = half(tmpvar_51);
  half3 tmpvar_52;
  tmpvar_52.xz = half2(float2(1.0, -1.0));
  tmpvar_52.y = -(s_43);
  half3 tmpvar_53;
  tmpvar_53.xz = half2(float2(1.0, -1.0));
  tmpvar_53.y = s_43;
  float3 tmpvar_54;
  tmpvar_54 = mix (((float3)tmpvar_52 * tmpvar_46.xzy), ((float3)tmpvar_53 * tmpvar_46.zxy), (float3)half3(zxlerp_45));
  detailCoords_42 = half3(tmpvar_54);
  half3 tmpvar_55;
  tmpvar_55.xy = half2(float2(1.0, 1.0));
  tmpvar_55.z = s_43;
  float3 tmpvar_56;
  tmpvar_56 = mix (((float3)tmpvar_55 * tmpvar_46.yxz), (float3)detailCoords_42, (float3)half3(nylerp_44));
  detailCoords_42 = half3(tmpvar_56);
  uv_41 = half2(((float2)((
    ((half)0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_57;
  uv_57 = float2(uv_41);
  float2 uvCont_58;
  float2 tmpvar_59;
  tmpvar_59 = abs((uv_57 - (0.5 * _mtl_u._DetailScale)));
  uvCont_58.x = max (tmpvar_59.x, tmpvar_59.y);
  uvCont_58.y = min (tmpvar_59.x, tmpvar_59.y);
  float4 tmpvar_60;
  tmpvar_60.xy = dfdx(uvCont_58);
  tmpvar_60.zw = dfdy(uvCont_58);
  half4 tmpvar_61;
  tmpvar_61 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_41), gradient2d((float2)(tmpvar_60.xy), (float2)(tmpvar_60.zw)));
  half4 tmpvar_62;
  tmpvar_62 = tmpvar_61;
  float3 tmpvar_63;
  tmpvar_63 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_64;
  float tmpvar_65;
  tmpvar_65 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_63, tmpvar_63)
  )), 0.0, 1.0);
  tmpvar_64 = half(tmpvar_65);
  half4 tmpvar_66;
  tmpvar_66 = ((_mtl_u._Color * tmpvar_40) * mix (tmpvar_62, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_64)));
  color_2 = tmpvar_66;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_67;
  tmpvar_67 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_67);
  half4 tmpvar_68;
  tmpvar_68 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_68;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE2_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 95 math, 22 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
Vector 2 [_Color]
Float 4 [_DetailDist]
Float 3 [_DetailScale]
Float 8 [_ShadowFactor]
Vector 0 [_Time]
Vector 7 [_UVNoiseAnimation]
Float 5 [_UVNoiseScale]
Float 6 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
SetTexture 0 [cube_MainTexxn] 2D 0
SetTexture 1 [cube_MainTexxp] 2D 1
SetTexture 2 [cube_MainTexyn] 2D 2
SetTexture 3 [cube_MainTexyp] 2D 3
SetTexture 4 [cube_MainTexzn] 2D 4
SetTexture 5 [cube_MainTexzp] 2D 5
SetTexture 6 [_DetailTex] 2D 6
SetTexture 7 [_UVNoiseTex] 2D 7
"ps_3_0
def c9, 0.5, -0.5, 0, 0
def c10, 0, 1, -0, -1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_2d s0
dcl_2d s1
dcl_2d s2
dcl_2d s3
dcl_2d s4
dcl_2d s5
dcl_2d s6
dcl_2d s7
mov r0.xz, c10.yyww
dp3 r0.w, v3, v3
rsq r0.w, r0.w
mul r1.xyz, r0.w, v3.yxzw
max r0.w, r1_abs.y, r1_abs.z
add r0.w, -r1_abs.x, r0.w
add r1.w, -r1_abs.y, r1_abs.z
cmp_pp r2.x, r1.w, r1.z, r1.y
cmp r2.x, r0.w, r2.x, r1.x
cmp r2.y, -r2.x, c10.x, c10.y
cmp r2.x, r2.x, c10.z, c10.w
add_pp r2.y, r2.x, r2.y
mov_pp r0.y, -r2.y
mul_pp r0.xyz, r0, r1.yzxw
mov r2.xz, c10.yyww
mul_pp r3.xyz, r1.zyxw, r2
mul_pp r1.xyz, r1, r2.xxyw
cmp_pp r0.xyz, r1.w, r3, r0
cmp_pp r0.xyz, r0.w, r0, r1
mul_pp r0.yz, r0, c9.x
rcp r0.x, r0_abs.x
mad_pp r0.xy, r0.yzzw, r0.x, c9.x
rcp r0.z, c5.x
mul r1.xy, r0.z, r0
frc r2.xz, r1_abs.xyyw
cmp r1.xy, r1, r2.xzzw, -r2.xzzw
mul r1.xy, r1, c5.x
mov r3.xy, c7
mul r2.xz, r3.xyyw, c0.x
mad r1.xy, r1, r0.z, r2.xzzw
texld r3, r1, s7
add r1.xy, r3, c9.y
mad_pp r0.xy, r1, c6.x, r0
add r1.xy, r0, c9.y
add r0.z, -r1_abs.y, r1_abs.x
cmp r1.xy, r0.z, r1_abs, r1_abs.yxzw
dsx r2.xz, r1.xyyw
dsy r1.xy, r1
texldd_pp r3, r0, s0, r2.xzzw, r1
texldd_pp r4, r0, s1, r2.xzzw, r1
cmp_pp r3, r2.y, r4, r3
texldd_pp r4, r0, s4, r2.xzzw, r1
texldd_pp r5, r0, s5, r2.xzzw, r1
cmp_pp r4, r2.y, r5, r4
cmp_pp r3, r1.w, r4, r3
texldd_pp r4, r0, s2, r2.xzzw, r1
texldd_pp r1, r0, s3, r2.xzzw, r1
cmp_pp r1, r2.y, r1, r4
cmp_pp r0, r0.w, r3, r1
mul_pp r0, r0, c2
mov r1.xz, c10.yyww
dp3 r1.w, v4, v4
rsq r1.w, r1.w
mul r2.xyz, r1.w, v4.yxzw
max r1.w, r2_abs.y, r2_abs.z
add r1.w, -r2_abs.x, r1.w
add r2.w, -r2_abs.y, r2_abs.z
cmp_pp r3.x, r2.w, r2.z, r2.y
cmp r3.x, r1.w, r3.x, r2.x
cmp r3.y, -r3.x, c10.x, c10.y
cmp r3.x, r3.x, c10.z, c10.w
add_pp r3.y, r3.x, r3.y
mov_pp r1.y, -r3.y
mul_pp r1.xyz, r1, r2.yzxw
mov r3.xz, c10.yyww
mul_pp r4.xyz, r2.zyxw, r3
mul_pp r2.xyz, r2, r3.xxyw
cmp_pp r1.xyz, r2.w, r4, r1
cmp_pp r1.xyz, r1.w, r1, r2
mul_pp r1.yz, r1, c9.x
rcp r1.x, r1_abs.x
mad_pp r1.xy, r1.yzzw, r1.x, c9.x
mul_pp r1.xy, r1, c3.x
mov r2.x, c9.x
mad r1.zw, c3.x, -r2.x, r1.xyxy
add r2.x, -r1_abs.w, r1_abs.z
cmp r1.zw, r2.x, r1_abs, r1_abs.xywz
dsx r2.xy, r1.zwzw
dsy r1.zw, r1
texldd_pp r1, r1, s6, r2, r1.zwzw
add r2.xyz, -c1, v2
dp3 r2.x, r2, r2
rsq r2.x, r2.x
rcp r2.x, r2.x
mov r3.x, c10.x
dp2add_sat_pp r2.x, r2.x, c4.x, r3.x
lrp_pp r4, r2.x, c10.y, r1
mad_pp r1.x, r0.w, -r4.w, c10.y
mul_pp r0, r0, r4
mul_sat_pp r1.xyz, r1.x, r0
add r1.xyz, r1, c10.w
mul r1.w, r0.w, c8.x
mul r0.xyz, r1, r1.w
add_pp r0, r0, c10.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r3.x
mad_pp oC0, r1.x, r0, c10.y

"
}
SubProgram "d3d11 " {
// Stats: 103 math, 1 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
SetTexture 0 [_UVNoiseTex] 2D 7
SetTexture 1 [cube_MainTexxn] 2D 0
SetTexture 2 [cube_MainTexxp] 2D 1
SetTexture 3 [cube_MainTexyn] 2D 2
SetTexture 4 [cube_MainTexyp] 2D 3
SetTexture 5 [cube_MainTexzn] 2D 4
SetTexture 6 [cube_MainTexzp] 2D 5
SetTexture 7 [_DetailTex] 2D 6
ConstBuffer "$Globals" 544
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:aiacaiaa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"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 103 math, 8 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
SetTexture 0 [cube_MainTexxn] 2D 0
SetTexture 1 [cube_MainTexxp] 2D 1
SetTexture 2 [cube_MainTexyn] 2D 2
SetTexture 3 [cube_MainTexyp] 2D 3
SetTexture 4 [cube_MainTexzn] 2D 4
SetTexture 5 [cube_MainTexzp] 2D 5
SetTexture 6 [_DetailTex] 2D 6
SetTexture 7 [_UVNoiseTex] 2D 7
ConstBuffer "$Globals" 68
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [_Color] 4
Float 40 [_DetailScale]
Float 44 [_DetailDist]
Float 48 [_UVNoiseScale]
Float 52 [_UVNoiseStrength]
Vector 56 [_UVNoiseAnimation] 2
Float 64 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> cube_MainTexxn [[texture(0)]], sampler _mtlsmp_cube_MainTexxn [[sampler(0)]]
  ,   texture2d<half> cube_MainTexxp [[texture(1)]], sampler _mtlsmp_cube_MainTexxp [[sampler(1)]]
  ,   texture2d<half> cube_MainTexyn [[texture(2)]], sampler _mtlsmp_cube_MainTexyn [[sampler(2)]]
  ,   texture2d<half> cube_MainTexyp [[texture(3)]], sampler _mtlsmp_cube_MainTexyp [[sampler(3)]]
  ,   texture2d<half> cube_MainTexzn [[texture(4)]], sampler _mtlsmp_cube_MainTexzn [[sampler(4)]]
  ,   texture2d<half> cube_MainTexzp [[texture(5)]], sampler _mtlsmp_cube_MainTexzp [[sampler(5)]]
  ,   texture2d<half> _DetailTex [[texture(6)]], sampler _mtlsmp__DetailTex [[sampler(6)]]
  ,   texture2d<half> _UVNoiseTex [[texture(7)]], sampler _mtlsmp__UVNoiseTex [[sampler(7)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  half2 uv_5;
  half3 detailCoords_6;
  half s_7;
  half nylerp_8;
  half zxlerp_9;
  float3 tmpvar_10;
  tmpvar_10 = normalize(_mtl_i.xlv_TEXCOORD4);
  float3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = half(tmpvar_12);
  float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = half(tmpvar_13);
  float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, (float)zxlerp_9);
  s_7 = half(tmpvar_14);
  float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, (float)s_7, (float)nylerp_8));
  s_7 = half(tmpvar_15);
  half3 tmpvar_16;
  tmpvar_16.xz = half2(float2(1.0, -1.0));
  tmpvar_16.y = -(s_7);
  half3 tmpvar_17;
  tmpvar_17.xz = half2(float2(1.0, -1.0));
  tmpvar_17.y = s_7;
  float3 tmpvar_18;
  tmpvar_18 = mix (((float3)tmpvar_16 * tmpvar_10.xzy), ((float3)tmpvar_17 * tmpvar_10.zxy), (float3)half3(zxlerp_9));
  detailCoords_6 = half3(tmpvar_18);
  half3 tmpvar_19;
  tmpvar_19.xy = half2(float2(1.0, 1.0));
  tmpvar_19.z = s_7;
  float3 tmpvar_20;
  tmpvar_20 = mix (((float3)tmpvar_19 * tmpvar_10.yxz), (float3)detailCoords_6, (float3)half3(nylerp_8));
  detailCoords_6 = half3(tmpvar_20);
  half2 tmpvar_21;
  tmpvar_21 = ((((half)0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + (half)0.5);
  uv_5 = tmpvar_21;
  float2 tmpvar_22;
  tmpvar_22 = ((float2)tmpvar_21 / float2(_mtl_u._UVNoiseScale));
  float2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * float2(_mtl_u._UVNoiseScale));
  float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  float2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  float2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _mtl_u._UVNoiseScale) + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_28;
  tmpvar_28 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_27));
  uv_5 = half2(((float2)tmpvar_21 + ((float2)(tmpvar_28.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength)));
  float2 uv_29;
  uv_29 = float2(uv_5);
  float2 uvCont_30;
  float2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  float4 tmpvar_32;
  tmpvar_32.xy = dfdx(uvCont_30);
  tmpvar_32.zw = dfdy(uvCont_30);
  half4 tmpvar_33;
  tmpvar_33 = cube_MainTexxn.sample(_mtlsmp_cube_MainTexxn, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  half4 tmpvar_35;
  tmpvar_35 = cube_MainTexxp.sample(_mtlsmp_cube_MainTexxp, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  half4 tmpvar_37;
  tmpvar_37 = cube_MainTexyn.sample(_mtlsmp_cube_MainTexyn, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_38;
  tmpvar_38 = tmpvar_37;
  half4 tmpvar_39;
  tmpvar_39 = cube_MainTexyp.sample(_mtlsmp_cube_MainTexyp, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  half4 tmpvar_41;
  tmpvar_41 = cube_MainTexzn.sample(_mtlsmp_cube_MainTexzn, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  half4 tmpvar_43;
  tmpvar_43 = cube_MainTexzp.sample(_mtlsmp_cube_MainTexzp, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  half2 uv_45;
  half3 detailCoords_46;
  half s_47;
  half nylerp_48;
  half zxlerp_49;
  float3 tmpvar_50;
  tmpvar_50 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_51;
  tmpvar_51 = abs(tmpvar_50);
  float tmpvar_52;
  tmpvar_52 = float((tmpvar_51.z >= tmpvar_51.x));
  zxlerp_49 = half(tmpvar_52);
  float tmpvar_53;
  tmpvar_53 = float((max (tmpvar_51.x, tmpvar_51.z) >= tmpvar_51.y));
  nylerp_48 = half(tmpvar_53);
  float tmpvar_54;
  tmpvar_54 = mix (tmpvar_50.x, tmpvar_50.z, (float)zxlerp_49);
  s_47 = half(tmpvar_54);
  float tmpvar_55;
  tmpvar_55 = sign(mix (tmpvar_50.y, (float)s_47, (float)nylerp_48));
  s_47 = half(tmpvar_55);
  half3 tmpvar_56;
  tmpvar_56.xz = half2(float2(1.0, -1.0));
  tmpvar_56.y = -(s_47);
  half3 tmpvar_57;
  tmpvar_57.xz = half2(float2(1.0, -1.0));
  tmpvar_57.y = s_47;
  float3 tmpvar_58;
  tmpvar_58 = mix (((float3)tmpvar_56 * tmpvar_50.xzy), ((float3)tmpvar_57 * tmpvar_50.zxy), (float3)half3(zxlerp_49));
  detailCoords_46 = half3(tmpvar_58);
  half3 tmpvar_59;
  tmpvar_59.xy = half2(float2(1.0, 1.0));
  tmpvar_59.z = s_47;
  float3 tmpvar_60;
  tmpvar_60 = mix (((float3)tmpvar_59 * tmpvar_50.yxz), (float3)detailCoords_46, (float3)half3(nylerp_48));
  detailCoords_46 = half3(tmpvar_60);
  uv_45 = half2(((float2)((
    ((half)0.5 * detailCoords_46.yz)
   / 
    abs(detailCoords_46.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_61;
  uv_61 = float2(uv_45);
  float2 uvCont_62;
  float2 tmpvar_63;
  tmpvar_63 = abs((uv_61 - (0.5 * _mtl_u._DetailScale)));
  uvCont_62.x = max (tmpvar_63.x, tmpvar_63.y);
  uvCont_62.y = min (tmpvar_63.x, tmpvar_63.y);
  float4 tmpvar_64;
  tmpvar_64.xy = dfdx(uvCont_62);
  tmpvar_64.zw = dfdy(uvCont_62);
  half4 tmpvar_65;
  tmpvar_65 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_45), gradient2d((float2)(tmpvar_64.xy), (float2)(tmpvar_64.zw)));
  half4 tmpvar_66;
  tmpvar_66 = tmpvar_65;
  float3 tmpvar_67;
  tmpvar_67 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_68;
  float tmpvar_69;
  tmpvar_69 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_67, tmpvar_67)
  )), 0.0, 1.0);
  tmpvar_68 = half(tmpvar_69);
  half4 tmpvar_70;
  tmpvar_70 = ((_mtl_u._Color * mix (
    mix (tmpvar_38, tmpvar_40, half4(half((s_7 >= (half)0.0))))
  , 
    mix (mix (tmpvar_34, tmpvar_36, half4(half((s_7 >= (half)0.0)))), mix (tmpvar_42, tmpvar_44, half4(half((s_7 >= (half)0.0)))), half4(zxlerp_9))
  , half4(nylerp_8))) * mix (tmpvar_66, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_68)));
  color_2 = tmpvar_70;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_71;
  tmpvar_71 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_71);
  half4 tmpvar_72;
  tmpvar_72 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_72;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE6_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 100 math, 22 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
Vector 3 [_Color]
Float 5 [_DetailDist]
Float 4 [_DetailScale]
Float 9 [_ShadowFactor]
Vector 0 [_Time]
Vector 8 [_UVNoiseAnimation]
Float 6 [_UVNoiseScale]
Float 7 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
Vector 2 [alphaMask1]
SetTexture 0 [cube_MainTexxn] 2D 0
SetTexture 1 [cube_MainTexxp] 2D 1
SetTexture 2 [cube_MainTexyn] 2D 2
SetTexture 3 [cube_MainTexyp] 2D 3
SetTexture 4 [cube_MainTexzn] 2D 4
SetTexture 5 [cube_MainTexzp] 2D 5
SetTexture 6 [_DetailTex] 2D 6
SetTexture 7 [_UVNoiseTex] 2D 7
"ps_3_0
def c10, 0.5, -0.5, 0, 0
def c11, 0, 1, -0, -1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord3 v2.xyz
dcl_texcoord4 v3.xyz
dcl_texcoord5 v4.xyz
dcl_2d s0
dcl_2d s1
dcl_2d s2
dcl_2d s3
dcl_2d s4
dcl_2d s5
dcl_2d s6
dcl_2d s7
mov r0.xz, c11.yyww
dp3 r0.w, v3, v3
rsq r0.w, r0.w
mul r1.xyz, r0.w, v3.yxzw
max r0.w, r1_abs.y, r1_abs.z
add r0.w, -r1_abs.x, r0.w
add r1.w, -r1_abs.y, r1_abs.z
cmp_pp r2.x, r1.w, r1.z, r1.y
cmp r2.x, r0.w, r2.x, r1.x
cmp r2.y, -r2.x, c11.x, c11.y
cmp r2.x, r2.x, c11.z, c11.w
add_pp r2.y, r2.x, r2.y
mov_pp r0.y, -r2.y
mul_pp r0.xyz, r0, r1.yzxw
mov r2.xz, c11.yyww
mul_pp r3.xyz, r1.zyxw, r2
mul_pp r1.xyz, r1, r2.xxyw
cmp_pp r0.xyz, r1.w, r3, r0
cmp_pp r0.xyz, r0.w, r0, r1
mul_pp r0.yz, r0, c10.x
rcp r0.x, r0_abs.x
mad_pp r0.xy, r0.yzzw, r0.x, c10.x
rcp r0.z, c6.x
mul r1.xy, r0.z, r0
frc r2.xz, r1_abs.xyyw
cmp r1.xy, r1, r2.xzzw, -r2.xzzw
mul r1.xy, r1, c6.x
mov r3.xy, c8
mul r2.xz, r3.xyyw, c0.x
mad r1.xy, r1, r0.z, r2.xzzw
texld r3, r1, s7
add r1.xy, r3, c10.y
mad_pp r0.xy, r1, c7.x, r0
add r1.xy, r0, c10.y
add r0.z, -r1_abs.y, r1_abs.x
cmp r1.xy, r0.z, r1_abs, r1_abs.yxzw
dsx r2.xz, r1.xyyw
dsy r1.xy, r1
texldd_pp r3, r0, s0, r2.xzzw, r1
texldd_pp r4, r0, s1, r2.xzzw, r1
cmp_pp r3, r2.y, r4, r3
texldd_pp r4, r0, s4, r2.xzzw, r1
texldd_pp r5, r0, s5, r2.xzzw, r1
cmp_pp r4, r2.y, r5, r4
cmp_pp r3, r1.w, r4, r3
texldd_pp r4, r0, s2, r2.xzzw, r1
texldd_pp r1, r0, s3, r2.xzzw, r1
cmp_pp r1, r2.y, r1, r4
cmp_pp r0, r0.w, r3, r1
mul_pp r0.xy, r0, c2
add_pp r0.x, r0.y, r0.x
mad_pp r0.x, r0.z, c2.z, r0.x
mad_pp r0.w, r0.w, c2.w, r0.x
mov r0.xyz, c11.y
mul_pp r0, r0, c3
mov r1.xz, c11.yyww
dp3 r1.w, v4, v4
rsq r1.w, r1.w
mul r2.xyz, r1.w, v4.yxzw
max r1.w, r2_abs.y, r2_abs.z
add r1.w, -r2_abs.x, r1.w
add r2.w, -r2_abs.y, r2_abs.z
cmp_pp r3.x, r2.w, r2.z, r2.y
cmp r3.x, r1.w, r3.x, r2.x
cmp r3.y, -r3.x, c11.x, c11.y
cmp r3.x, r3.x, c11.z, c11.w
add_pp r3.y, r3.x, r3.y
mov_pp r1.y, -r3.y
mul_pp r1.xyz, r1, r2.yzxw
mov r3.xz, c11.yyww
mul_pp r4.xyz, r2.zyxw, r3
mul_pp r2.xyz, r2, r3.xxyw
cmp_pp r1.xyz, r2.w, r4, r1
cmp_pp r1.xyz, r1.w, r1, r2
mul_pp r1.yz, r1, c10.x
rcp r1.x, r1_abs.x
mad_pp r1.xy, r1.yzzw, r1.x, c10.x
mul_pp r1.xy, r1, c4.x
mov r2.x, c10.x
mad r1.zw, c4.x, -r2.x, r1.xyxy
add r2.x, -r1_abs.w, r1_abs.z
cmp r1.zw, r2.x, r1_abs, r1_abs.xywz
dsx r2.xy, r1.zwzw
dsy r1.zw, r1
texldd_pp r1, r1, s6, r2, r1.zwzw
add r2.xyz, -c1, v2
dp3 r2.x, r2, r2
rsq r2.x, r2.x
rcp r2.x, r2.x
mov r3.x, c11.x
dp2add_sat_pp r2.x, r2.x, c5.x, r3.x
lrp_pp r4, r2.x, c11.y, r1
mad_pp r1.x, r0.w, -r4.w, c11.y
mul_pp r0, r0, r4
mul_sat_pp r1.xyz, r1.x, r0
add r1.xyz, r1, c11.w
mul r1.w, r0.w, c9.x
mul r0.xyz, r1, r1.w
add_pp r0, r0, c11.xxxw
mov r1.w, v0.w
cmp_pp r1.x, r1.w, v1.x, r3.x
mad_pp oC0, r1.x, r0, c11.y

"
}
SubProgram "d3d11 " {
// Stats: 107 math, 1 textures
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
SetTexture 0 [_UVNoiseTex] 2D 7
SetTexture 1 [cube_MainTexxn] 2D 0
SetTexture 2 [cube_MainTexxp] 2D 1
SetTexture 3 [cube_MainTexyn] 2D 2
SetTexture 4 [cube_MainTexyp] 2D 3
SetTexture 5 [cube_MainTexzn] 2D 4
SetTexture 6 [cube_MainTexzp] 2D 5
SetTexture 7 [_DetailTex] 2D 6
ConstBuffer "$Globals" 544
Vector 352 [alphaMask1]
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:aiacaiaa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"
}
SubProgram "gles " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 108 math, 8 textures, 2 branches
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
SetTexture 0 [cube_MainTexxn] 2D 0
SetTexture 1 [cube_MainTexxp] 2D 1
SetTexture 2 [cube_MainTexyn] 2D 2
SetTexture 3 [cube_MainTexyp] 2D 3
SetTexture 4 [cube_MainTexzn] 2D 4
SetTexture 5 [cube_MainTexzp] 2D 5
SetTexture 6 [_DetailTex] 2D 6
SetTexture 7 [_UVNoiseTex] 2D 7
ConstBuffer "$Globals" 76
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [alphaMask1] 4
VectorHalf 40 [_Color] 4
Float 48 [_DetailScale]
Float 52 [_DetailDist]
Float 56 [_UVNoiseScale]
Float 60 [_UVNoiseStrength]
Vector 64 [_UVNoiseAnimation] 2
Float 72 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 alphaMask1;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> cube_MainTexxn [[texture(0)]], sampler _mtlsmp_cube_MainTexxn [[sampler(0)]]
  ,   texture2d<half> cube_MainTexxp [[texture(1)]], sampler _mtlsmp_cube_MainTexxp [[sampler(1)]]
  ,   texture2d<half> cube_MainTexyn [[texture(2)]], sampler _mtlsmp_cube_MainTexyn [[sampler(2)]]
  ,   texture2d<half> cube_MainTexyp [[texture(3)]], sampler _mtlsmp_cube_MainTexyp [[sampler(3)]]
  ,   texture2d<half> cube_MainTexzn [[texture(4)]], sampler _mtlsmp_cube_MainTexzn [[sampler(4)]]
  ,   texture2d<half> cube_MainTexzp [[texture(5)]], sampler _mtlsmp_cube_MainTexzp [[sampler(5)]]
  ,   texture2d<half> _DetailTex [[texture(6)]], sampler _mtlsmp__DetailTex [[sampler(6)]]
  ,   texture2d<half> _UVNoiseTex [[texture(7)]], sampler _mtlsmp__UVNoiseTex [[sampler(7)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  half2 uv_5;
  half3 detailCoords_6;
  half s_7;
  half nylerp_8;
  half zxlerp_9;
  float3 tmpvar_10;
  tmpvar_10 = normalize(_mtl_i.xlv_TEXCOORD4);
  float3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = half(tmpvar_12);
  float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = half(tmpvar_13);
  float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, (float)zxlerp_9);
  s_7 = half(tmpvar_14);
  float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, (float)s_7, (float)nylerp_8));
  s_7 = half(tmpvar_15);
  half3 tmpvar_16;
  tmpvar_16.xz = half2(float2(1.0, -1.0));
  tmpvar_16.y = -(s_7);
  half3 tmpvar_17;
  tmpvar_17.xz = half2(float2(1.0, -1.0));
  tmpvar_17.y = s_7;
  float3 tmpvar_18;
  tmpvar_18 = mix (((float3)tmpvar_16 * tmpvar_10.xzy), ((float3)tmpvar_17 * tmpvar_10.zxy), (float3)half3(zxlerp_9));
  detailCoords_6 = half3(tmpvar_18);
  half3 tmpvar_19;
  tmpvar_19.xy = half2(float2(1.0, 1.0));
  tmpvar_19.z = s_7;
  float3 tmpvar_20;
  tmpvar_20 = mix (((float3)tmpvar_19 * tmpvar_10.yxz), (float3)detailCoords_6, (float3)half3(nylerp_8));
  detailCoords_6 = half3(tmpvar_20);
  half2 tmpvar_21;
  tmpvar_21 = ((((half)0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + (half)0.5);
  uv_5 = tmpvar_21;
  float2 tmpvar_22;
  tmpvar_22 = ((float2)tmpvar_21 / float2(_mtl_u._UVNoiseScale));
  float2 tmpvar_23;
  tmpvar_23 = (fract(abs(tmpvar_22)) * float2(_mtl_u._UVNoiseScale));
  float tmpvar_24;
  if ((tmpvar_22.x >= 0.0)) {
    tmpvar_24 = tmpvar_23.x;
  } else {
    tmpvar_24 = -(tmpvar_23.x);
  };
  float tmpvar_25;
  if ((tmpvar_22.y >= 0.0)) {
    tmpvar_25 = tmpvar_23.y;
  } else {
    tmpvar_25 = -(tmpvar_23.y);
  };
  float2 tmpvar_26;
  tmpvar_26.x = tmpvar_24;
  tmpvar_26.y = tmpvar_25;
  float2 tmpvar_27;
  tmpvar_27 = ((tmpvar_26 / _mtl_u._UVNoiseScale) + (_mtl_u._UVNoiseAnimation * _mtl_u._Time.xx));
  half4 tmpvar_28;
  tmpvar_28 = _UVNoiseTex.sample(_mtlsmp__UVNoiseTex, (float2)(tmpvar_27));
  uv_5 = half2(((float2)tmpvar_21 + ((float2)(tmpvar_28.xy - (half2)float2(0.5, 0.5)) * _mtl_u._UVNoiseStrength)));
  float2 uv_29;
  uv_29 = float2(uv_5);
  float2 uvCont_30;
  float2 tmpvar_31;
  tmpvar_31 = abs((uv_29 - 0.5));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  float4 tmpvar_32;
  tmpvar_32.xy = dfdx(uvCont_30);
  tmpvar_32.zw = dfdy(uvCont_30);
  half4 tmpvar_33;
  tmpvar_33 = cube_MainTexxn.sample(_mtlsmp_cube_MainTexxn, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_34;
  tmpvar_34 = tmpvar_33;
  half4 tmpvar_35;
  tmpvar_35 = cube_MainTexxp.sample(_mtlsmp_cube_MainTexxp, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_36;
  tmpvar_36 = tmpvar_35;
  half4 tmpvar_37;
  tmpvar_37 = cube_MainTexyn.sample(_mtlsmp_cube_MainTexyn, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_38;
  tmpvar_38 = tmpvar_37;
  half4 tmpvar_39;
  tmpvar_39 = cube_MainTexyp.sample(_mtlsmp_cube_MainTexyp, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  half4 tmpvar_41;
  tmpvar_41 = cube_MainTexzn.sample(_mtlsmp_cube_MainTexzn, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_42;
  tmpvar_42 = tmpvar_41;
  half4 tmpvar_43;
  tmpvar_43 = cube_MainTexzp.sample(_mtlsmp_cube_MainTexzp, (float2)(uv_5), gradient2d((float2)(tmpvar_32.xy), (float2)(tmpvar_32.zw)));
  half4 tmpvar_44;
  tmpvar_44 = tmpvar_43;
  half4 v_45;
  v_45 = (mix (mix (tmpvar_38, tmpvar_40, half4(
    half((s_7 >= (half)0.0))
  )), mix (
    mix (tmpvar_34, tmpvar_36, half4(half((s_7 >= (half)0.0))))
  , 
    mix (tmpvar_42, tmpvar_44, half4(half((s_7 >= (half)0.0))))
  , half4(zxlerp_9)), half4(nylerp_8)) * _mtl_u.alphaMask1);
  half4 tmpvar_46;
  tmpvar_46.xyz = half3(float3(1.0, 1.0, 1.0));
  tmpvar_46.w = ((v_45.x + v_45.y) + (v_45.z + v_45.w));
  half2 uv_47;
  half3 detailCoords_48;
  half s_49;
  half nylerp_50;
  half zxlerp_51;
  float3 tmpvar_52;
  tmpvar_52 = normalize(_mtl_i.xlv_TEXCOORD5);
  float3 tmpvar_53;
  tmpvar_53 = abs(tmpvar_52);
  float tmpvar_54;
  tmpvar_54 = float((tmpvar_53.z >= tmpvar_53.x));
  zxlerp_51 = half(tmpvar_54);
  float tmpvar_55;
  tmpvar_55 = float((max (tmpvar_53.x, tmpvar_53.z) >= tmpvar_53.y));
  nylerp_50 = half(tmpvar_55);
  float tmpvar_56;
  tmpvar_56 = mix (tmpvar_52.x, tmpvar_52.z, (float)zxlerp_51);
  s_49 = half(tmpvar_56);
  float tmpvar_57;
  tmpvar_57 = sign(mix (tmpvar_52.y, (float)s_49, (float)nylerp_50));
  s_49 = half(tmpvar_57);
  half3 tmpvar_58;
  tmpvar_58.xz = half2(float2(1.0, -1.0));
  tmpvar_58.y = -(s_49);
  half3 tmpvar_59;
  tmpvar_59.xz = half2(float2(1.0, -1.0));
  tmpvar_59.y = s_49;
  float3 tmpvar_60;
  tmpvar_60 = mix (((float3)tmpvar_58 * tmpvar_52.xzy), ((float3)tmpvar_59 * tmpvar_52.zxy), (float3)half3(zxlerp_51));
  detailCoords_48 = half3(tmpvar_60);
  half3 tmpvar_61;
  tmpvar_61.xy = half2(float2(1.0, 1.0));
  tmpvar_61.z = s_49;
  float3 tmpvar_62;
  tmpvar_62 = mix (((float3)tmpvar_61 * tmpvar_52.yxz), (float3)detailCoords_48, (float3)half3(nylerp_50));
  detailCoords_48 = half3(tmpvar_62);
  uv_47 = half2(((float2)((
    ((half)0.5 * detailCoords_48.yz)
   / 
    abs(detailCoords_48.x)
  ) + (half)0.5) * _mtl_u._DetailScale));
  float2 uv_63;
  uv_63 = float2(uv_47);
  float2 uvCont_64;
  float2 tmpvar_65;
  tmpvar_65 = abs((uv_63 - (0.5 * _mtl_u._DetailScale)));
  uvCont_64.x = max (tmpvar_65.x, tmpvar_65.y);
  uvCont_64.y = min (tmpvar_65.x, tmpvar_65.y);
  float4 tmpvar_66;
  tmpvar_66.xy = dfdx(uvCont_64);
  tmpvar_66.zw = dfdy(uvCont_64);
  half4 tmpvar_67;
  tmpvar_67 = _DetailTex.sample(_mtlsmp__DetailTex, (float2)(uv_47), gradient2d((float2)(tmpvar_66.xy), (float2)(tmpvar_66.zw)));
  half4 tmpvar_68;
  tmpvar_68 = tmpvar_67;
  float3 tmpvar_69;
  tmpvar_69 = (_mtl_i.xlv_TEXCOORD3.xyz - _mtl_u._WorldSpaceCameraPos);
  half tmpvar_70;
  float tmpvar_71;
  tmpvar_71 = clamp (((2.0 * _mtl_u._DetailDist) * sqrt(
    dot (tmpvar_69, tmpvar_69)
  )), 0.0, 1.0);
  tmpvar_70 = half(tmpvar_71);
  half4 tmpvar_72;
  tmpvar_72 = ((_mtl_u._Color * tmpvar_46) * mix (tmpvar_68, (half4)float4(1.0, 1.0, 1.0, 1.0), half4(tmpvar_70)));
  color_2 = tmpvar_72;
  color_2.xyz = clamp ((color_2.xyz * ((half)1.0 - color_2.w)), (half)0.0, (half)1.0);
  float3 tmpvar_73;
  tmpvar_73 = float3(mix (1.0, (float)color_2.x, (_mtl_u._ShadowFactor * (float)color_2.w)));
  color_2.xyz = half3(tmpvar_73);
  half4 tmpvar_74;
  tmpvar_74 = half4(mix ((half)1.0, color_2.x, shadowCheck_3));
  tmpvar_1 = tmpvar_74;
  _mtl_o._glesFragData_0 = tmpvar_1;
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "WORLD_SPACE_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE6_1" }
"!!GL3x"
}
SubProgram "opengl " {
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
"!!GLSL"
}
SubProgram "d3d9 " {
// Stats: 104 math, 7 textures
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
Vector 2 [_Color]
Float 4 [_DetailDist]
Float 3 [_DetailScale]
Float 8 [_PlanetRadius]
Float 9 [_ShadowFactor]
Vector 0 [_Time]
Vector 7 [_UVNoiseAnimation]
Float 5 [_UVNoiseScale]
Float 6 [_UVNoiseStrength]
Vector 1 [_WorldSpaceCameraPos]
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
"ps_3_0
def c10, 5, 0.200000003, 0, 0.180141002
def c11, 0.0208350997, -0.0851330012, -0.330299497, 0.999866009
def c12, 0, 1, -2, 1.57079637
def c13, 0.159154937, 0.5, -0.0187292993, 0.0742610022
def c14, -0.212114394, 1.57072878, -2, 3.14159274
def c15, 0.318309873, 1, -1, 0
def c16, -0, 0, -3.14159274, 1
dcl_texcoord v0.w
dcl_texcoord1 v1.x
dcl_texcoord2 v2.x
dcl_texcoord3 v3.xyz
dcl_texcoord4 v4.xyz
dcl_texcoord5 v5.xyz
dcl_2d s0
dcl_2d s1
dcl_2d s2
dp3 r0.x, v4, v4
rsq r0.x, r0.x
mul r0.yzw, r0.x, v4.xzxy
mad r0.x, v4.x, r0.x, -r0.y
cmp r1.xy, r0.x, r0.yzzw, r0.zyzw
add r1.zw, -r0_abs.xyyz, r0_abs.xyzy
cmp r0.xz, r1.z, r0_abs.yyzw, r0_abs.zyyw
cmp r1.yz, r1.xyww, c12.xyxw, c12.xxyw
rcp r0.z, r0.z
mul r0.x, r0.z, r0.x
mul r0.z, r0.x, r0.x
mad r1.w, r0.z, c11.x, c11.y
mad r1.w, r0.z, r1.w, c10.w
mad r1.w, r0.z, r1.w, c11.z
mad r0.z, r0.z, r1.w, c11.w
mul r0.x, r0.z, r0.x
mad r0.z, r0.x, c12.z, c12.w
mad r0.x, r0.z, r1.z, r0.x
cmp r0.yz, r0.xyww, c16.xxyw, c16.xzww
add r0.x, r0.y, r0.x
add r0.y, r0.x, r0.x
cmp r1.x, r1.x, c10.z, r1.y
mad r0.x, r1.x, -r0.y, r0.x
mad r0.x, r0.x, c13.x, c13.y
mad r1.x, r0_abs.w, c13.z, c13.w
mad r1.x, r1.x, r0_abs.w, c14.x
mad r1.x, r1.x, r0_abs.w, c14.y
add r0.w, -r0_abs.w, c12.y
rsq r0.w, r0.w
rcp r0.w, r0.w
mul r0.w, r0.w, r1.x
mad r1.x, r0.w, c14.z, c14.w
mad r0.z, r1.x, r0.z, r0.w
mul r0.y, r0.z, c15.x
rcp r0.z, c5.x
mul r1.xy, r0.z, r0
frc r1.zw, r1_abs.xyxy
cmp r1.xy, r1, r1.zwzw, -r1.zwzw
mul r1.xy, r1, c5.x
mov r2.xy, c7
mul r1.zw, r2.xyxy, c0.x
mad r0.zw, r1.xyxy, r0.z, r1
texld r1, r0.zwzw, s2
add r0.zw, r1.xyxy, -c13.y
mad r0.xy, r0.zwzw, c6.x, r0
add r0.z, r0.x, -c13.y
abs r0.z, r0.z
dsx r1.xy, r0.zyzw
dsy r2.xy, r0.zyzw
texldd_pp r0, r0, s0, r1, r2
mul_pp r0, r0, c2
mov r1.xz, c15.yyzw
dp3 r1.w, v5, v5
rsq r1.w, r1.w
mul r2.xyz, r1.w, v5.yxzw
max r1.w, r2_abs.y, r2_abs.z
add r1.w, -r2_abs.x, r1.w
add r2.w, -r2_abs.y, r2_abs.z
cmp_pp r3.x, r2.w, r2.z, r2.y
cmp r3.x, r1.w, r3.x, r2.x
cmp r3.y, -r3.x, c12.x, c12.y
cmp r3.x, r3.x, -c12.x, -c12.y
add_pp r3.y, r3.x, r3.y
mov_pp r1.y, -r3.y
mul_pp r1.xyz, r1, r2.yzxw
mov r3.xz, c15.yyzw
mul_pp r4.xyz, r2.zyxw, r3
mul_pp r2.xyz, r2, r3.xxyw
cmp_pp r1.xyz, r2.w, r4, r1
cmp_pp r1.xyz, r1.w, r1, r2
mul_pp r1.yz, r1, c13.y
rcp r1.x, r1_abs.x
mad_pp r1.xy, r1.yzzw, r1.x, c13.y
mul_pp r1.xy, r1, c3.x
mov r2.y, c13.y
mad r1.zw, c3.x, -r2.y, r1.xyxy
add r2.x, -r1_abs.w, r1_abs.z
cmp r1.zw, r2.x, r1_abs, r1_abs.xywz
dsx r2.xy, r1.zwzw
dsy r1.zw, r1
texldd_pp r1, r1, s1, r2, r1.zwzw
add r2.xyz, -c1, v3
dp3 r2.x, r2, r2
rsq r2.x, r2.x
rcp r2.x, r2.x
mov r2.z, c10.z
dp2add_sat_pp r2.x, r2.x, c4.x, r2.z
lrp_pp r3, r2.x, c12.y, r1
mad_pp r1.x, r0.w, -r3.w, c12.y
mul_pp r0, r0, r3
mul_sat_pp r1.xyz, r1.x, r0
add r1.xyz, r1, -c12.y
mul r1.w, r0.w, c9.x
mul r0.xyz, r1, r1.w
add_pp r0, r0, -c16.xxxw
add r1.x, c10.x, v2.x
add r1.x, r1.x, -c8.x
mul_sat r1.x, r1.x, c10.y
mul_pp r1.x, r1.x, v1.x
cmp_pp r1.x, v0.w, r1.x, c10.z
mad_pp oC0, r1.x, r0, c12.y

"
}
SubProgram "d3d11 " {
// Stats: 102 math, 1 textures
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
SetTexture 0 [_UVNoiseTex] 2D 2
SetTexture 1 [_MainTex] 2D 0
SetTexture 2 [_DetailTex] 2D 1
ConstBuffer "$Globals" 544
Vector 368 [_Color]
Float 400 [_DetailScale]
Float 404 [_DetailDist]
Float 408 [_UVNoiseScale]
Float 412 [_UVNoiseStrength]
Vector 416 [_UVNoiseAnimation] 2
Float 452 [_PlanetRadius]
Float 456 [_ShadowFactor]
ConstBuffer "UnityPerCamera" 144
Vector 0 [_Time]
Vector 64 [_WorldSpaceCameraPos] 3
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
"ps_4_0
root12:adacadaa
eefiecedkjmfiemocnpfnglbclhnkfpofnamfdjdabaaaaaacebaaaaaadaaaaaa
cmaaaaaapmaaaaaadaabaaaaejfdeheomiaaaaaaahaaaaaaaiaaaaaalaaaaaaa
aaaaaaaaabaaaaaaadaaaaaaaaaaaaaaapaaaaaalmaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaapaiaaaalmaaaaaaabaaaaaaaaaaaaaaadaaaaaaacaaaaaa
ababaaaalmaaaaaaacaaaaaaaaaaaaaaadaaaaaaacaaaaaaacacaaaalmaaaaaa
adaaaaaaaaaaaaaaadaaaaaaadaaaaaaapahaaaalmaaaaaaaeaaaaaaaaaaaaaa
adaaaaaaaeaaaaaaahahaaaalmaaaaaaafaaaaaaaaaaaaaaadaaaaaaafaaaaaa
ahahaaaafdfgfpfaepfdejfeejepeoaafeeffiedepepfceeaaklklklepfdeheo
cmaaaaaaabaaaaaaaiaaaaaacaaaaaaaaaaaaaaaaaaaaaaaadaaaaaaaaaaaaaa
apaaaaaafdfgfpfegbhcghgfheaaklklfdeieefcomaoaaaaeaaaaaaalladaaaa
fjaaaaaeegiocaaaaaaaaaaabnaaaaaafjaaaaaeegiocaaaabaaaaaaafaaaaaa
fkaaaaadaagabaaaaaaaaaaafkaaaaadaagabaaaabaaaaaafkaaaaadaagabaaa
acaaaaaafibiaaaeaahabaaaaaaaaaaaffffaaaafibiaaaeaahabaaaabaaaaaa
ffffaaaafibiaaaeaahabaaaacaaaaaaffffaaaagcbaaaadicbabaaaabaaaaaa
gcbaaaadbcbabaaaacaaaaaagcbaaaadccbabaaaacaaaaaagcbaaaadhcbabaaa
adaaaaaagcbaaaadhcbabaaaaeaaaaaagcbaaaadhcbabaaaafaaaaaagfaaaaad
pccabaaaaaaaaaaagiaaaaacafaaaaaabaaaaaahbcaabaaaaaaaaaaaegbcbaaa
aeaaaaaaegbcbaaaaeaaaaaaeeaaaaafbcaabaaaaaaaaaaaakaabaaaaaaaaaaa
diaaaaahhcaabaaaaaaaaaaaagaabaaaaaaaaaaaigbbbaaaaeaaaaaadeaaaaaj
icaabaaaaaaaaaaabkaabaiaibaaaaaaaaaaaaaaakaabaiaibaaaaaaaaaaaaaa
aoaaaaakicaabaaaaaaaaaaaaceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadp
dkaabaaaaaaaaaaaddaaaaajbcaabaaaabaaaaaabkaabaiaibaaaaaaaaaaaaaa
akaabaiaibaaaaaaaaaaaaaadiaaaaahicaabaaaaaaaaaaadkaabaaaaaaaaaaa
akaabaaaabaaaaaadiaaaaahbcaabaaaabaaaaaadkaabaaaaaaaaaaadkaabaaa
aaaaaaaadcaaaaajccaabaaaabaaaaaaakaabaaaabaaaaaaabeaaaaafpkokkdm
abeaaaaadgfkkolndcaaaaajccaabaaaabaaaaaaakaabaaaabaaaaaabkaabaaa
abaaaaaaabeaaaaaochgdidodcaaaaajccaabaaaabaaaaaaakaabaaaabaaaaaa
bkaabaaaabaaaaaaabeaaaaaaebnkjlodcaaaaajbcaabaaaabaaaaaaakaabaaa
abaaaaaabkaabaaaabaaaaaaabeaaaaadiphhpdpdiaaaaahccaabaaaabaaaaaa
dkaabaaaaaaaaaaaakaabaaaabaaaaaadcaaaaajccaabaaaabaaaaaabkaabaaa
abaaaaaaabeaaaaaaaaaaamaabeaaaaanlapmjdpdbaaaaajecaabaaaabaaaaaa
bkaabaiaibaaaaaaaaaaaaaaakaabaiaibaaaaaaaaaaaaaaabaaaaahccaabaaa
abaaaaaackaabaaaabaaaaaabkaabaaaabaaaaaadcaaaaajicaabaaaaaaaaaaa
dkaabaaaaaaaaaaaakaabaaaabaaaaaabkaabaaaabaaaaaadbaaaaaidcaabaaa
abaaaaaajgafbaaaaaaaaaaajgafbaiaebaaaaaaaaaaaaaaabaaaaahbcaabaaa
abaaaaaaakaabaaaabaaaaaaabeaaaaanlapejmaaaaaaaahicaabaaaaaaaaaaa
dkaabaaaaaaaaaaaakaabaaaabaaaaaaddaaaaahbcaabaaaabaaaaaabkaabaaa
aaaaaaaaakaabaaaaaaaaaaadbaaaaaibcaabaaaabaaaaaaakaabaaaabaaaaaa
akaabaiaebaaaaaaabaaaaaadeaaaaahbcaabaaaaaaaaaaabkaabaaaaaaaaaaa
akaabaaaaaaaaaaabnaaaaaibcaabaaaaaaaaaaaakaabaaaaaaaaaaaakaabaia
ebaaaaaaaaaaaaaaabaaaaahbcaabaaaaaaaaaaaakaabaaaaaaaaaaaakaabaaa
abaaaaaadhaaaaakbcaabaaaaaaaaaaaakaabaaaaaaaaaaadkaabaiaebaaaaaa
aaaaaaaadkaabaaaaaaaaaaadcaaaaajbcaabaaaaaaaaaaaakaabaaaaaaaaaaa
abeaaaaaidpjccdoabeaaaaaaaaaaadpdcaaaaakicaabaaaaaaaaaaackaabaia
ibaaaaaaaaaaaaaaabeaaaaadagojjlmabeaaaaachbgjidndcaaaaakicaabaaa
aaaaaaaadkaabaaaaaaaaaaackaabaiaibaaaaaaaaaaaaaaabeaaaaaiedefjlo
dcaaaaakicaabaaaaaaaaaaadkaabaaaaaaaaaaackaabaiaibaaaaaaaaaaaaaa
abeaaaaakeanmjdpaaaaaaaiecaabaaaaaaaaaaackaabaiambaaaaaaaaaaaaaa
abeaaaaaaaaaiadpelaaaaafecaabaaaaaaaaaaackaabaaaaaaaaaaadiaaaaah
bcaabaaaabaaaaaackaabaaaaaaaaaaadkaabaaaaaaaaaaadcaaaaajbcaabaaa
abaaaaaaakaabaaaabaaaaaaabeaaaaaaaaaaamaabeaaaaanlapejeaabaaaaah
bcaabaaaabaaaaaabkaabaaaabaaaaaaakaabaaaabaaaaaadcaaaaajecaabaaa
aaaaaaaadkaabaaaaaaaaaaackaabaaaaaaaaaaaakaabaaaabaaaaaadiaaaaah
ccaabaaaaaaaaaaackaabaaaaaaaaaaaabeaaaaaidpjkcdoaoaaaaaimcaabaaa
aaaaaaaaagaebaaaaaaaaaaakgikcaaaaaaaaaaabjaaaaaabnaaaaaidcaabaaa
abaaaaaaogakbaaaaaaaaaaaogakbaiaebaaaaaaaaaaaaaabkaaaaagmcaabaaa
aaaaaaaakgaobaiaibaaaaaaaaaaaaaadhaaaaakmcaabaaaaaaaaaaaagaebaaa
abaaaaaakgaobaaaaaaaaaaakgaobaiaebaaaaaaaaaaaaaadiaaaaaimcaabaaa
aaaaaaaakgaobaaaaaaaaaaakgikcaaaaaaaaaaabjaaaaaaaoaaaaaimcaabaaa
aaaaaaaakgaobaaaaaaaaaaakgikcaaaaaaaaaaabjaaaaaadcaaaaalmcaabaaa
aaaaaaaaagiecaaaaaaaaaaabkaaaaaaagiacaaaabaaaaaaaaaaaaaakgaobaaa
aaaaaaaaefaaaaajpcaabaaaabaaaaaaogakbaaaaaaaaaaaeghobaaaaaaaaaaa
aagabaaaacaaaaaaaaaaaaakmcaabaaaaaaaaaaaagaebaaaabaaaaaaaceaaaaa
aaaaaaaaaaaaaaaaaaaaaalpaaaaaalpdcaaaaakdcaabaaaaaaaaaaaogakbaaa
aaaaaaaapgipcaaaaaaaaaaabjaaaaaaegaabaaaaaaaaaaaaaaaaaahecaabaaa
aaaaaaaaakaabaaaaaaaaaaaabeaaaaaaaaaaalpdgaaaaagecaabaaaaaaaaaaa
ckaabaiaibaaaaaaaaaaaaaaalaaaaafdcaabaaaabaaaaaaggakbaaaaaaaaaaa
amaaaaafdcaabaaaacaaaaaaggakbaaaaaaaaaaaejaaaaanpcaabaaaaaaaaaaa
egaabaaaaaaaaaaaeghobaaaabaaaaaaaagabaaaaaaaaaaaegaabaaaabaaaaaa
egaabaaaacaaaaaadiaaaaaipcaabaaaaaaaaaaaegaobaaaaaaaaaaaegiocaaa
aaaaaaaabhaaaaaadgaaaaaifcaabaaaabaaaaaaaceaaaaaaaaaiadpaaaaaaaa
aaaaialpaaaaaaaabaaaaaahicaabaaaabaaaaaaegbcbaaaafaaaaaaegbcbaaa
afaaaaaaeeaaaaaficaabaaaabaaaaaadkaabaaaabaaaaaadiaaaaahhcaabaaa
acaaaaaapgapbaaaabaaaaaabgbgbaaaafaaaaaadcaaaaakicaabaaaacaaaaaa
ckbabaaaafaaaaaadkaabaaaabaaaaaabkaabaiaebaaaaaaacaaaaaabnaaaaaj
bcaabaaaadaaaaaackaabaiaibaaaaaaacaaaaaabkaabaiaibaaaaaaacaaaaaa
abaaaaahbcaabaaaadaaaaaaakaabaaaadaaaaaaabeaaaaaaaaaiadpdcaaaaaj
icaabaaaacaaaaaaakaabaaaadaaaaaadkaabaaaacaaaaaabkaabaaaacaaaaaa
dcaaaaakicaabaaaabaaaaaabkbabaiaebaaaaaaafaaaaaadkaabaaaabaaaaaa
dkaabaaaacaaaaaadeaaaaajicaabaaaacaaaaaackaabaiaibaaaaaaacaaaaaa
bkaabaiaibaaaaaaacaaaaaabnaaaaaiicaabaaaacaaaaaadkaabaaaacaaaaaa
akaabaiaibaaaaaaacaaaaaaabaaaaahicaabaaaacaaaaaadkaabaaaacaaaaaa
abeaaaaaaaaaiadpdcaaaaajicaabaaaabaaaaaadkaabaaaacaaaaaadkaabaaa
abaaaaaaakaabaaaacaaaaaadbaaaaahccaabaaaadaaaaaaabeaaaaaaaaaaaaa
dkaabaaaabaaaaaadbaaaaahicaabaaaabaaaaaadkaabaaaabaaaaaaabeaaaaa
aaaaaaaaboaaaaaiicaabaaaabaaaaaabkaabaiaebaaaaaaadaaaaaadkaabaaa
abaaaaaaclaaaaafccaabaaaaeaaaaaadkaabaaaabaaaaaadgaaaaagccaabaaa
abaaaaaabkaabaiaebaaaaaaaeaaaaaadiaaaaahhcaabaaaabaaaaaaegacbaaa
abaaaaaajgaebaaaacaaaaaadgaaaaaifcaabaaaaeaaaaaaaceaaaaaaaaaiadp
aaaaaaaaaaaaialpaaaaaaaadcaaaaakocaabaaaadaaaaaaagajbaaaaeaaaaaa
kgabbaaaacaaaaaaagajbaiaebaaaaaaabaaaaaadcaaaaajhcaabaaaabaaaaaa
agaabaaaadaaaaaajgahbaaaadaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
abaaaaaaagabbaiaebaaaaaaaeaaaaaaegacbaaaacaaaaaaegacbaaaabaaaaaa
diaaaaahhcaabaaaacaaaaaaegacbaaaacaaaaaaagabbaaaaeaaaaaadcaaaaaj
hcaabaaaabaaaaaapgapbaaaacaaaaaaegacbaaaabaaaaaaegacbaaaacaaaaaa
diaaaaakgcaabaaaabaaaaaafgagbaaaabaaaaaaaceaaaaaaaaaaaaaaaaaaadp
aaaaaadpaaaaaaaaaoaaaaaidcaabaaaabaaaaaajgafbaaaabaaaaaaagaabaia
ibaaaaaaabaaaaaaaaaaaaakdcaabaaaabaaaaaaegaabaaaabaaaaaaaceaaaaa
aaaaaadpaaaaaadpaaaaaaaaaaaaaaaadiaaaaaidcaabaaaabaaaaaaegaabaaa
abaaaaaaagiacaaaaaaaaaaabjaaaaaadcaaaaaomcaabaaaabaaaaaaagiacaia
ebaaaaaaaaaaaaaabjaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaadpaaaaaadp
agaebaaaabaaaaaadeaaaaajbcaabaaaacaaaaaadkaabaiaibaaaaaaabaaaaaa
ckaabaiaibaaaaaaabaaaaaaddaaaaajecaabaaaabaaaaaadkaabaiaibaaaaaa
abaaaaaackaabaiaibaaaaaaabaaaaaaalaaaaafbcaabaaaadaaaaaaakaabaaa
acaaaaaaamaaaaafbcaabaaaacaaaaaaakaabaaaacaaaaaaalaaaaafccaabaaa
adaaaaaackaabaaaabaaaaaaamaaaaafccaabaaaacaaaaaackaabaaaabaaaaaa
ejaaaaanpcaabaaaabaaaaaaegaabaaaabaaaaaaeghobaaaacaaaaaaaagabaaa
abaaaaaaegaabaaaadaaaaaaegaabaaaacaaaaaaaaaaaaalpcaabaaaacaaaaaa
egaobaiaebaaaaaaabaaaaaaaceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadp
aaaaaaajhcaabaaaadaaaaaaegbcbaaaadaaaaaaegiccaiaebaaaaaaabaaaaaa
aeaaaaaabaaaaaahbcaabaaaadaaaaaaegacbaaaadaaaaaaegacbaaaadaaaaaa
elaaaaafbcaabaaaadaaaaaaakaabaaaadaaaaaaapcaaaaibcaabaaaadaaaaaa
agaabaaaadaaaaaafgifcaaaaaaaaaaabjaaaaaadcaaaaajpcaabaaaabaaaaaa
agaabaaaadaaaaaaegaobaaaacaaaaaaegaobaaaabaaaaaadcaaaaakbcaabaaa
acaaaaaadkaabaiaebaaaaaaaaaaaaaadkaabaaaabaaaaaaabeaaaaaaaaaiadp
diaaaaahpcaabaaaaaaaaaaaegaobaaaaaaaaaaaegaobaaaabaaaaaadicaaaah
hcaabaaaabaaaaaaagaabaaaacaaaaaaegacbaaaaaaaaaaaaaaaaaakhcaabaaa
abaaaaaaegacbaaaabaaaaaaaceaaaaaaaaaialpaaaaialpaaaaialpaaaaaaaa
diaaaaaiicaabaaaabaaaaaadkaabaaaaaaaaaaackiacaaaaaaaaaaabmaaaaaa
diaaaaahhcaabaaaaaaaaaaaegacbaaaabaaaaaapgapbaaaabaaaaaaaaaaaaak
pcaabaaaaaaaaaaaegaobaaaaaaaaaaaaceaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
aaaaialpbnaaaaahbcaabaaaabaaaaaadkbabaaaabaaaaaaabeaaaaaaaaaaaaa
abaaaaahbcaabaaaabaaaaaaakaabaaaabaaaaaaabeaaaaaaaaaiadpdiaaaaah
bcaabaaaabaaaaaaakaabaaaabaaaaaaakbabaaaacaaaaaaaaaaaaahccaabaaa
abaaaaaabkbabaaaacaaaaaaabeaaaaaaaaakaeaaaaaaaajccaabaaaabaaaaaa
bkaabaaaabaaaaaabkiacaiaebaaaaaaaaaaaaaabmaaaaaadicaaaahccaabaaa
abaaaaaabkaabaaaabaaaaaaabeaaaaamnmmemdodiaaaaahbcaabaaaabaaaaaa
bkaabaaaabaaaaaaakaabaaaabaaaaaadcaaaaampccabaaaaaaaaaaaagaabaaa
abaaaaaaegaobaaaaaaaaaaaaceaaaaaaaaaiadpaaaaiadpaaaaiadpaaaaiadp
doaaaaab"
}
SubProgram "gles " {
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
"!!GLES"
}
SubProgram "gles3 " {
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
"!!GLES3"
}
SubProgram "metal " {
// Stats: 133 math, 3 textures, 5 branches
Keywords { "MAP_TYPE_1" "ALPHAMAP_N_1" "WORLD_SPACE_ON" }
SetTexture 0 [_MainTex] 2D 0
SetTexture 1 [_DetailTex] 2D 1
SetTexture 2 [_UVNoiseTex] 2D 2
ConstBuffer "$Globals" 72
Vector 0 [_Time]
Vector 16 [_WorldSpaceCameraPos] 3
VectorHalf 32 [_Color] 4
Float 40 [_DetailScale]
Float 44 [_DetailDist]
Float 48 [_UVNoiseScale]
Float 52 [_UVNoiseStrength]
Vector 56 [_UVNoiseAnimation] 2
Float 64 [_PlanetRadius]
Float 68 [_ShadowFactor]
"metal_fs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 xlv_TEXCOORD0;
  float xlv_TEXCOORD1;
  float xlv_TEXCOORD2;
  float4 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderOutput {
  half4 _glesFragData_0 [[color(0)]];
};
struct xlatMtlShaderUniform {
  float4 _Time;
  float3 _WorldSpaceCameraPos;
  half4 _Color;
  float _DetailScale;
  float _DetailDist;
  float _UVNoiseScale;
  float _UVNoiseStrength;
  float2 _UVNoiseAnimation;
  float _PlanetRadius;
  float _ShadowFactor;
};
fragment xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]]
  ,   texture2d<half> _MainTex [[texture(0)]], sampler _mtlsmp__MainTex [[sampler(0)]]
  ,   texture2d<half> _DetailTex [[texture(1)]], sampler _mtlsmp__DetailTex [[sampler(1)]]
  ,   texture2d<half> _UVNoiseTex [[texture(2)]], sampler _mtlsmp__UVNoiseTex [[sampler(2)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  half4 color_2;
  half shadowCheck_3;
  float tmpvar_4;
  tmpvar_4 = (float((_mtl_i.xlv_TEXCOORD0.w >= 0.0)) * _mtl_i.xlv_TEXCOORD1);
  shadowCheck_3 = half(tmpvar_4);
  float tmpvar_5;
  tmpvar_5 = clamp ((0.2 * (
    (_mtl_i.xlv_TEXCOORD2 + 5