// Compiled shader for all platforms, uncompressed size: 2135.6KB

// Skipping shader variants that would not be included into build of current scene.

Shader "EVE/TerrainCityLight" {
Properties {
 _Color ("Color Tint", Color) = (1,1,1,1)
 _SpecularColor ("Specular tint", Color) = (1,1,1,1)
 _CityOverlayTex ("Overlay (RGBA)", 2D) = "white" { }
 _CityOverlayDetailScale ("Overlay Detail Scale", Range(0,1000)) = 80
 _CityDarkOverlayDetailTex ("Overlay Detail (RGB) (A)", 2D) = "white" { }
 _CityLightOverlayDetailTex ("Overlay Detail (RGB) (A)", 2D) = "white" { }
 _PlanetOpacity ("PlanetOpacity", Float) = 1
 _PlanetOrigin ("Sphere Center", Vector) = (0,0,0,1)
 _SunDir ("SunDir", Vector) = (0,0,0,1)
}
SubShader { 
 Tags { "QUEUE"="Geometry+2" "IGNOREPROJECTOR"="true" "RenderMode"="Transparent" }


 // Stats for Vertex shader:
 //       d3d11 : 27 avg math (26..29)
 //        d3d9 : 36 avg math (33..39)
 //        gles : 140 avg math (100..176), 5 avg texture (3..9), 0 avg branch (0..3)
 //       metal : 20 avg math (19..22)
 //      opengl : 136 avg math (99..171), 5 avg texture (3..9), 0 avg branch (0..3)
 // Stats for Fragment shader:
 //       d3d11 : 76 avg math (57..98), 0 avg texture (0..2)
 //        d3d9 : 75 avg math (56..104), 13 avg texture (7..25)
 //       metal : 137 avg math (100..172), 5 avg texture (3..9), 0 avg branch (0..3)
 Pass {
  Tags { "QUEUE"="Geometry+2" "IGNOREPROJECTOR"="true" "SHADOWSUPPORT"="true" "RenderMode"="Transparent" }
  ZWrite Off
  Blend SrcAlpha OneMinusSrcAlpha
  GpuProgramID 14759
Program "vp" {
SubProgram "opengl " {
// Stats: 164 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  cityoverlay_3.xyz = tmpvar_12.xyz;
  vec2 uv_13;
  vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_15;
  tmpvar_15 = abs(tmpvar_14);
  float tmpvar_16;
  tmpvar_16 = float((tmpvar_15.z >= tmpvar_15.x));
  float tmpvar_17;
  tmpvar_17 = float((max (tmpvar_15.x, tmpvar_15.z) >= tmpvar_15.y));
  float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_16), tmpvar_17));
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(tmpvar_18);
  vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = tmpvar_18;
  vec3 tmpvar_21;
  tmpvar_21.xy = vec2(1.0, 1.0);
  tmpvar_21.z = tmpvar_18;
  vec3 tmpvar_22;
  tmpvar_22 = mix ((tmpvar_21 * tmpvar_14.yxz), mix ((tmpvar_19 * tmpvar_14.xzy), (tmpvar_20 * tmpvar_14.zxy), vec3(tmpvar_16)), vec3(tmpvar_17));
  uv_13 = (((
    (0.5 * tmpvar_22.yz)
   / 
    abs(tmpvar_22.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_23;
  vec2 tmpvar_24;
  float tmpvar_25;
  tmpvar_25 = (0.5 * _CityOverlayDetailScale);
  tmpvar_24 = abs((uv_13 - tmpvar_25));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  vec4 tmpvar_26;
  tmpvar_26.xy = dFdx(uvCont_23);
  tmpvar_26.zw = dFdy(uvCont_23);
  vec4 tmpvar_27;
  tmpvar_27 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_13, tmpvar_26.xy, tmpvar_26.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_27.xyz;
  vec2 uv_28;
  vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_14);
  float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  float tmpvar_32;
  tmpvar_32 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_30), tmpvar_31));
  vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = -(tmpvar_32);
  vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = tmpvar_32;
  vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = tmpvar_32;
  vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_14.yxz), mix ((tmpvar_33 * tmpvar_14.xzy), (tmpvar_34 * tmpvar_14.zxy), vec3(tmpvar_30)), vec3(tmpvar_31));
  uv_28 = (((
    (0.5 * tmpvar_36.yz)
   / 
    abs(tmpvar_36.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_37;
  vec2 tmpvar_38;
  tmpvar_38 = abs((uv_28 - tmpvar_25));
  uvCont_37.x = max (tmpvar_38.x, tmpvar_38.y);
  uvCont_37.y = min (tmpvar_38.x, tmpvar_38.y);
  vec4 tmpvar_39;
  tmpvar_39.xy = dFdx(uvCont_37);
  tmpvar_39.zw = dFdy(uvCont_37);
  vec4 tmpvar_40;
  tmpvar_40 = texture2DGradARB (_CityLightOverlayDetailTex, uv_28, tmpvar_39.xy, tmpvar_39.zw);
  citylightoverlaydetail_1.xyz = tmpvar_40.xyz;
  cityoverlay_3.w = (tmpvar_12.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_27.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_40.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_40.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_41;
  vec3 tmpvar_42;
  tmpvar_42 = normalize(_SunDir);
  vec3 tmpvar_43;
  tmpvar_43 = normalize(xlv_TEXCOORD4);
  float tmpvar_44;
  tmpvar_44 = dot (tmpvar_43, tmpvar_42);
  c_41.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_44) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_42 + normalize(xlv_TEXCOORD7)))
    , tmpvar_43), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_41.w = (tmpvar_44 * 2.0);
  float tmpvar_45;
  tmpvar_45 = dot (xlv_TEXCOORD4, tmpvar_42);
  color_4 = (c_41 * mix (1.0, clamp (
    floor((1.01 + tmpvar_45))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_45))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_46;
  tmpvar_46 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_46.xyz;
  color_4.w = (tmpvar_46.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 165 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  cityoverlay_4.xyz = tmpvar_14.xyz;
  mediump vec2 uv_15;
  mediump vec3 detailCoords_16;
  mediump float s_17;
  mediump float nylerp_18;
  mediump float zxlerp_19;
  highp vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  zxlerp_19 = tmpvar_22;
  highp float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  nylerp_18 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_19);
  s_17 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_20.y, s_17, nylerp_18));
  s_17 = tmpvar_25;
  mediump vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(s_17);
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = s_17;
  highp vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_26 * tmpvar_20.xzy), (tmpvar_27 * tmpvar_20.zxy), vec3(zxlerp_19));
  detailCoords_16 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xy = vec2(1.0, 1.0);
  tmpvar_29.z = s_17;
  highp vec3 tmpvar_30;
  tmpvar_30 = mix ((tmpvar_29 * tmpvar_20.yxz), detailCoords_16, vec3(nylerp_18));
  detailCoords_16 = tmpvar_30;
  uv_15 = (((
    (0.5 * detailCoords_16.yz)
   / 
    abs(detailCoords_16.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_31;
  uv_31 = uv_15;
  highp vec2 uvCont_32;
  highp vec2 tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_31 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_15, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  citydarkoverlaydetail_3.xyz = tmpvar_37.xyz;
  mediump vec2 uv_38;
  mediump vec3 detailCoords_39;
  mediump float s_40;
  mediump float nylerp_41;
  mediump float zxlerp_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = abs(tmpvar_20);
  highp float tmpvar_44;
  tmpvar_44 = float((tmpvar_43.z >= tmpvar_43.x));
  zxlerp_42 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = float((max (tmpvar_43.x, tmpvar_43.z) >= tmpvar_43.y));
  nylerp_41 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_42);
  s_40 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = sign(mix (tmpvar_20.y, s_40, nylerp_41));
  s_40 = tmpvar_47;
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = -(s_40);
  mediump vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = s_40;
  highp vec3 tmpvar_50;
  tmpvar_50 = mix ((tmpvar_48 * tmpvar_20.xzy), (tmpvar_49 * tmpvar_20.zxy), vec3(zxlerp_42));
  detailCoords_39 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = s_40;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_20.yxz), detailCoords_39, vec3(nylerp_41));
  detailCoords_39 = tmpvar_52;
  uv_38 = (((
    (0.5 * detailCoords_39.yz)
   / 
    abs(detailCoords_39.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_53;
  uv_53 = uv_38;
  highp vec2 uvCont_54;
  highp vec2 tmpvar_55;
  tmpvar_55 = abs((uv_53 - tmpvar_34));
  uvCont_54.x = max (tmpvar_55.x, tmpvar_55.y);
  uvCont_54.y = min (tmpvar_55.x, tmpvar_55.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_54);
  tmpvar_56.zw = dFdy(uvCont_54);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_38, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citylightoverlaydetail_2.xyz = tmpvar_58.xyz;
  highp float tmpvar_59;
  tmpvar_59 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_14.w * (1.0 - tmpvar_59));
  citydarkoverlaydetail_3.w = (tmpvar_37.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_58.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_58.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_60;
  lightDir_60 = _SunDir;
  mediump vec3 viewDir_61;
  viewDir_61 = xlv_TEXCOORD7;
  mediump vec3 normal_62;
  normal_62 = xlv_TEXCOORD4;
  mediump vec4 c_63;
  mediump vec3 tmpvar_64;
  tmpvar_64 = normalize(lightDir_60);
  lightDir_60 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65 = normalize(viewDir_61);
  viewDir_61 = tmpvar_65;
  mediump vec3 tmpvar_66;
  tmpvar_66 = normalize(normal_62);
  normal_62 = tmpvar_66;
  mediump float tmpvar_67;
  tmpvar_67 = dot (tmpvar_66, tmpvar_64);
  highp float tmpvar_68;
  mediump float tmpvar_69;
  tmpvar_69 = clamp (dot (normalize(
    (tmpvar_64 + tmpvar_65)
  ), tmpvar_66), 0.0, 1.0);
  tmpvar_68 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (pow (tmpvar_68, _SpecularPower) * _SpecularColor.w);
  c_63.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_67) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_70)) * 2.0);
  c_63.w = (tmpvar_67 * 2.0);
  highp vec3 tmpvar_71;
  tmpvar_71 = normalize(_SunDir);
  mediump vec3 lightDir_72;
  lightDir_72 = tmpvar_71;
  mediump vec3 normal_73;
  normal_73 = xlv_TEXCOORD4;
  mediump float tmpvar_74;
  tmpvar_74 = dot (normal_73, lightDir_72);
  color_5 = (c_63 * mix (1.0, clamp (
    floor((1.01 + tmpvar_74))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_74))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_75;
  tmpvar_75 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_75.xyz;
  color_5.w = (tmpvar_75.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec2 t3;
lowp float t10_3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
highp vec3 t7;
mediump vec3 t16_8;
highp float t10;
highp int ti10;
bvec2 tb10;
highp vec2 t14;
mediump float t16_15;
highp float t17;
bool tb17;
highp float t18;
mediump float t16_22;
highp float t24;
highp int ti24;
bool tb24;
highp float t25;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_8.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_8.x = floor(t16_8.x);
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_8.x = t16_8.x + -1.0;
    t16_1.x = t16_1.x * t16_8.x + 1.0;
    t16_8.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_8.x = inversesqrt(t16_8.x);
    t16_8.xyz = t16_8.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_8.x = dot(t16_2.xyz, t16_8.xyz);
    t16_8.x = t16_8.x + t16_8.x;
    t16_1.x = t16_1.x * t16_8.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t7.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t7.z), abs(t7.y));
    t3.x = float(1.0) / t3.x;
    t10 = min(abs(t7.z), abs(t7.y));
    t3.x = t3.x * t10;
    t10 = t3.x * t3.x;
    t17 = t10 * 0.0208350997 + -0.0851330012;
    t17 = t10 * t17 + 0.180141002;
    t17 = t10 * t17 + -0.330299497;
    t10 = t10 * t17 + 0.999866009;
    t17 = t10 * t3.x;
    t17 = t17 * -2.0 + 1.57079637;
    tb24 = abs(t7.z)<abs(t7.y);
    t17 = tb24 ? t17 : float(0.0);
    t3.x = t3.x * t10 + t17;
    tb10.xy = lessThan(t7.zxzz, (-t7.zxzz)).xy;
    t10 = tb10.x ? -3.14159274 : float(0.0);
    t3.x = t10 + t3.x;
    t10 = min(t7.z, t7.y);
    tb10.x = t10<(-t10);
    t24 = max(t7.z, t7.y);
    tb24 = t24>=(-t24);
    ti10 = int(uint(tb24) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t3.x = (ti10 != 0) ? (-t3.x) : t3.x;
    t10 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t10);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t24 = abs(t7.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t7.x) + -0.212114394;
    t24 = t24 * abs(t7.x) + 1.57072878;
    t18 = -abs(t7.x) + 1.0;
    t18 = sqrt(t18);
    t25 = t24 * t18;
    t25 = t25 * -2.0 + 3.14159274;
    t17 = tb10.y ? t25 : float(0.0);
    t17 = t24 * t18 + t17;
    t4.y = t17 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_3 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy).w;
    tb10.x = 0.0>=vs_TEXCOORD0.w;
    t10 = (tb10.x) ? 0.0 : 1.0;
    t3.x = t10 * t10_3;
    t10 = vs_TEXCOORD5.z * t0.x + (-t7.y);
    tb17 = abs(t7.z)>=abs(t7.y);
    t17 = tb17 ? 1.0 : float(0.0);
    t10 = t17 * t10 + t7.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t10;
    t10 = max(abs(t7.z), abs(t7.y));
    tb10.x = t10>=abs(t7.x);
    t10 = tb10.x ? 1.0 : float(0.0);
    t0.x = t10 * t0.x + t7.x;
    ti24 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti24) + ti0;
    t16_2.y = float(ti0);
    t16_6.y = (-t16_2.y);
    t16_6.xz = vec2(1.0, -1.0);
    t4.xyz = t7.yzx * t16_6.xyz;
    t16_2.xz = vec2(1.0, -1.0);
    t5.xyz = t16_2.xyz * t7.zyx + (-t4.xyz);
    t4.xyz = vec3(t17) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_2.xxy) * t7.xyz + t4.xyz;
    t0.xyz = t7.xyz * t16_2.xxy;
    t0.xyz = vec3(t10) * t4.xyz + t0.xyz;
    t16_8.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t0.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t0.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t14.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t0.xy;
    t10 = max(abs(t14.y), abs(t14.x));
    t14.x = min(abs(t14.y), abs(t14.x));
    t4.x = dFdx(t10);
    t5.x = dFdy(t10);
    t4.y = dFdx(t14.x);
    t5.y = dFdy(t14.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_8.x = t3.x * t10_2.w;
    t16_15 = t3.x * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_2.xyz;
    t16_22 = t16_8.x * t16_1.x + (-t16_15);
    t16_1.x = t16_1.x * t16_8.x;
    t16_8.x = t16_1.x * t16_22 + t16_15;
    t16_1.xzw = t16_1.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
float t12;
bool tb12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t18 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t18 + 1.00999999;
    t18 = t18 * -10.0;
    t18 = clamp(t18, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t18 = t18 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t18 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12 = max(abs(t1.z), abs(t1.y));
    t12 = float(1.0) / t12;
    t18 = min(abs(t1.z), abs(t1.y));
    t12 = t12 * t18;
    t18 = t12 * t12;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12 = t12 * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12 = t18 + t12;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12 = (ti18 != 0) ? (-t12) : t12;
    t18 = t12 * 0.159154937;
    t3.x = t12 * 0.159154937 + 0.5;
    t12 = abs(t18);
    t4.x = dFdx(t12);
    t5.x = dFdy(t12);
    t12 = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12 = t12 * abs(t1.x) + -0.212114394;
    t12 = t12 * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12 = t12 * t18 + t19;
    t3.y = t12 * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    tb12 = 0.0>=vs_TEXCOORD0.w;
    t12 = (tb12) ? 0.0 : 1.0;
    t12 = t12 * t10_2.w;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12 * t1.w;
    t2.w = t12 * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 166 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  cityoverlay_3.xyz = tmpvar_12.xyz;
  vec2 uv_13;
  vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_15;
  tmpvar_15 = abs(tmpvar_14);
  float tmpvar_16;
  tmpvar_16 = float((tmpvar_15.z >= tmpvar_15.x));
  float tmpvar_17;
  tmpvar_17 = float((max (tmpvar_15.x, tmpvar_15.z) >= tmpvar_15.y));
  float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_16), tmpvar_17));
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(tmpvar_18);
  vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = tmpvar_18;
  vec3 tmpvar_21;
  tmpvar_21.xy = vec2(1.0, 1.0);
  tmpvar_21.z = tmpvar_18;
  vec3 tmpvar_22;
  tmpvar_22 = mix ((tmpvar_21 * tmpvar_14.yxz), mix ((tmpvar_19 * tmpvar_14.xzy), (tmpvar_20 * tmpvar_14.zxy), vec3(tmpvar_16)), vec3(tmpvar_17));
  uv_13 = (((
    (0.5 * tmpvar_22.yz)
   / 
    abs(tmpvar_22.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_23;
  vec2 tmpvar_24;
  float tmpvar_25;
  tmpvar_25 = (0.5 * _CityOverlayDetailScale);
  tmpvar_24 = abs((uv_13 - tmpvar_25));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  vec4 tmpvar_26;
  tmpvar_26.xy = dFdx(uvCont_23);
  tmpvar_26.zw = dFdy(uvCont_23);
  vec4 tmpvar_27;
  tmpvar_27 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_13, tmpvar_26.xy, tmpvar_26.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_27.xyz;
  vec2 uv_28;
  vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_14);
  float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  float tmpvar_32;
  tmpvar_32 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_30), tmpvar_31));
  vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = -(tmpvar_32);
  vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = tmpvar_32;
  vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = tmpvar_32;
  vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_14.yxz), mix ((tmpvar_33 * tmpvar_14.xzy), (tmpvar_34 * tmpvar_14.zxy), vec3(tmpvar_30)), vec3(tmpvar_31));
  uv_28 = (((
    (0.5 * tmpvar_36.yz)
   / 
    abs(tmpvar_36.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_37;
  vec2 tmpvar_38;
  tmpvar_38 = abs((uv_28 - tmpvar_25));
  uvCont_37.x = max (tmpvar_38.x, tmpvar_38.y);
  uvCont_37.y = min (tmpvar_38.x, tmpvar_38.y);
  vec4 tmpvar_39;
  tmpvar_39.xy = dFdx(uvCont_37);
  tmpvar_39.zw = dFdy(uvCont_37);
  vec4 tmpvar_40;
  tmpvar_40 = texture2DGradARB (_CityLightOverlayDetailTex, uv_28, tmpvar_39.xy, tmpvar_39.zw);
  citylightoverlaydetail_1.xyz = tmpvar_40.xyz;
  cityoverlay_3.w = (tmpvar_12.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_27.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_40.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_40.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_41;
  tmpvar_41 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_42;
  vec3 tmpvar_43;
  tmpvar_43 = normalize(_SunDir);
  vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD4);
  float tmpvar_45;
  tmpvar_45 = dot (tmpvar_44, tmpvar_43);
  c_42.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_45) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_43 + normalize(xlv_TEXCOORD7)))
    , tmpvar_44), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_41.x * 2.0));
  c_42.w = (tmpvar_45 * (tmpvar_41.x * 2.0));
  float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD4, tmpvar_43);
  color_4 = (c_42 * mix (1.0, clamp (
    floor((1.01 + tmpvar_46))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_46))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_47;
  tmpvar_47 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_47.xyz;
  color_4.w = (tmpvar_47.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 171 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  cityoverlay_4.xyz = tmpvar_14.xyz;
  mediump vec2 uv_15;
  mediump vec3 detailCoords_16;
  mediump float s_17;
  mediump float nylerp_18;
  mediump float zxlerp_19;
  highp vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  zxlerp_19 = tmpvar_22;
  highp float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  nylerp_18 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_19);
  s_17 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_20.y, s_17, nylerp_18));
  s_17 = tmpvar_25;
  mediump vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(s_17);
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = s_17;
  highp vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_26 * tmpvar_20.xzy), (tmpvar_27 * tmpvar_20.zxy), vec3(zxlerp_19));
  detailCoords_16 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xy = vec2(1.0, 1.0);
  tmpvar_29.z = s_17;
  highp vec3 tmpvar_30;
  tmpvar_30 = mix ((tmpvar_29 * tmpvar_20.yxz), detailCoords_16, vec3(nylerp_18));
  detailCoords_16 = tmpvar_30;
  uv_15 = (((
    (0.5 * detailCoords_16.yz)
   / 
    abs(detailCoords_16.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_31;
  uv_31 = uv_15;
  highp vec2 uvCont_32;
  highp vec2 tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_31 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_15, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  citydarkoverlaydetail_3.xyz = tmpvar_37.xyz;
  mediump vec2 uv_38;
  mediump vec3 detailCoords_39;
  mediump float s_40;
  mediump float nylerp_41;
  mediump float zxlerp_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = abs(tmpvar_20);
  highp float tmpvar_44;
  tmpvar_44 = float((tmpvar_43.z >= tmpvar_43.x));
  zxlerp_42 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = float((max (tmpvar_43.x, tmpvar_43.z) >= tmpvar_43.y));
  nylerp_41 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_42);
  s_40 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = sign(mix (tmpvar_20.y, s_40, nylerp_41));
  s_40 = tmpvar_47;
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = -(s_40);
  mediump vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = s_40;
  highp vec3 tmpvar_50;
  tmpvar_50 = mix ((tmpvar_48 * tmpvar_20.xzy), (tmpvar_49 * tmpvar_20.zxy), vec3(zxlerp_42));
  detailCoords_39 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = s_40;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_20.yxz), detailCoords_39, vec3(nylerp_41));
  detailCoords_39 = tmpvar_52;
  uv_38 = (((
    (0.5 * detailCoords_39.yz)
   / 
    abs(detailCoords_39.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_53;
  uv_53 = uv_38;
  highp vec2 uvCont_54;
  highp vec2 tmpvar_55;
  tmpvar_55 = abs((uv_53 - tmpvar_34));
  uvCont_54.x = max (tmpvar_55.x, tmpvar_55.y);
  uvCont_54.y = min (tmpvar_55.x, tmpvar_55.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_54);
  tmpvar_56.zw = dFdy(uvCont_54);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_38, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citylightoverlaydetail_2.xyz = tmpvar_58.xyz;
  highp float tmpvar_59;
  tmpvar_59 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_14.w * (1.0 - tmpvar_59));
  citydarkoverlaydetail_3.w = (tmpvar_37.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_58.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_58.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_60 = tmpvar_61;
  mediump vec3 lightDir_62;
  lightDir_62 = _SunDir;
  mediump vec3 viewDir_63;
  viewDir_63 = xlv_TEXCOORD7;
  mediump vec3 normal_64;
  normal_64 = xlv_TEXCOORD4;
  mediump float atten_65;
  atten_65 = tmpvar_60;
  mediump vec4 c_66;
  mediump vec3 tmpvar_67;
  tmpvar_67 = normalize(lightDir_62);
  lightDir_62 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68 = normalize(viewDir_63);
  viewDir_63 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69 = normalize(normal_64);
  normal_64 = tmpvar_69;
  mediump float tmpvar_70;
  tmpvar_70 = dot (tmpvar_69, tmpvar_67);
  highp float tmpvar_71;
  mediump float tmpvar_72;
  tmpvar_72 = clamp (dot (normalize(
    (tmpvar_67 + tmpvar_68)
  ), tmpvar_69), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = (pow (tmpvar_71, _SpecularPower) * _SpecularColor.w);
  c_66.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_70) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_73)) * (atten_65 * 2.0));
  c_66.w = (tmpvar_70 * (atten_65 * 2.0));
  highp vec3 tmpvar_74;
  tmpvar_74 = normalize(_SunDir);
  mediump vec3 lightDir_75;
  lightDir_75 = tmpvar_74;
  mediump vec3 normal_76;
  normal_76 = xlv_TEXCOORD4;
  mediump float tmpvar_77;
  tmpvar_77 = dot (normal_76, lightDir_75);
  color_5 = (c_66 * mix (1.0, clamp (
    floor((1.01 + tmpvar_77))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_77))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_78;
  tmpvar_78 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_78.xyz;
  color_5.w = (tmpvar_78.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
vec2 t12;
bool tb12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t18 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t12.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t12.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t12.x = t6.x + 1.00999999;
    t6.x = t6.x * -10.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t12.x = floor(t12.x);
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = t6.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12.x = max(abs(t1.z), abs(t1.y));
    t12.x = float(1.0) / t12.x;
    t18 = min(abs(t1.z), abs(t1.y));
    t12.x = t12.x * t18;
    t18 = t12.x * t12.x;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12.x = t18 + t12.x;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12.x = (ti18 != 0) ? (-t12.x) : t12.x;
    t18 = t12.x * 0.159154937;
    t3.x = t12.x * 0.159154937 + 0.5;
    t12.x = abs(t18);
    t4.x = dFdx(t12.x);
    t5.x = dFdy(t12.x);
    t12.x = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12.x = t12.x * abs(t1.x) + -0.212114394;
    t12.x = t12.x * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    t3.y = t12.x * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    tb12 = 0.0>=vs_TEXCOORD0.w;
    t12.x = (tb12) ? 0.0 : 1.0;
    t12.x = t12.x * t10_2.w;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12.x * t1.w;
    t2.w = t12.x * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 164 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  cityoverlay_3.xyz = tmpvar_12.xyz;
  vec2 uv_13;
  vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_15;
  tmpvar_15 = abs(tmpvar_14);
  float tmpvar_16;
  tmpvar_16 = float((tmpvar_15.z >= tmpvar_15.x));
  float tmpvar_17;
  tmpvar_17 = float((max (tmpvar_15.x, tmpvar_15.z) >= tmpvar_15.y));
  float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_16), tmpvar_17));
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(tmpvar_18);
  vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = tmpvar_18;
  vec3 tmpvar_21;
  tmpvar_21.xy = vec2(1.0, 1.0);
  tmpvar_21.z = tmpvar_18;
  vec3 tmpvar_22;
  tmpvar_22 = mix ((tmpvar_21 * tmpvar_14.yxz), mix ((tmpvar_19 * tmpvar_14.xzy), (tmpvar_20 * tmpvar_14.zxy), vec3(tmpvar_16)), vec3(tmpvar_17));
  uv_13 = (((
    (0.5 * tmpvar_22.yz)
   / 
    abs(tmpvar_22.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_23;
  vec2 tmpvar_24;
  float tmpvar_25;
  tmpvar_25 = (0.5 * _CityOverlayDetailScale);
  tmpvar_24 = abs((uv_13 - tmpvar_25));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  vec4 tmpvar_26;
  tmpvar_26.xy = dFdx(uvCont_23);
  tmpvar_26.zw = dFdy(uvCont_23);
  vec4 tmpvar_27;
  tmpvar_27 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_13, tmpvar_26.xy, tmpvar_26.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_27.xyz;
  vec2 uv_28;
  vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_14);
  float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  float tmpvar_32;
  tmpvar_32 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_30), tmpvar_31));
  vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = -(tmpvar_32);
  vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = tmpvar_32;
  vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = tmpvar_32;
  vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_14.yxz), mix ((tmpvar_33 * tmpvar_14.xzy), (tmpvar_34 * tmpvar_14.zxy), vec3(tmpvar_30)), vec3(tmpvar_31));
  uv_28 = (((
    (0.5 * tmpvar_36.yz)
   / 
    abs(tmpvar_36.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_37;
  vec2 tmpvar_38;
  tmpvar_38 = abs((uv_28 - tmpvar_25));
  uvCont_37.x = max (tmpvar_38.x, tmpvar_38.y);
  uvCont_37.y = min (tmpvar_38.x, tmpvar_38.y);
  vec4 tmpvar_39;
  tmpvar_39.xy = dFdx(uvCont_37);
  tmpvar_39.zw = dFdy(uvCont_37);
  vec4 tmpvar_40;
  tmpvar_40 = texture2DGradARB (_CityLightOverlayDetailTex, uv_28, tmpvar_39.xy, tmpvar_39.zw);
  citylightoverlaydetail_1.xyz = tmpvar_40.xyz;
  cityoverlay_3.w = (tmpvar_12.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_27.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_40.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_40.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_41;
  vec3 tmpvar_42;
  tmpvar_42 = normalize(_SunDir);
  vec3 tmpvar_43;
  tmpvar_43 = normalize(xlv_TEXCOORD4);
  float tmpvar_44;
  tmpvar_44 = dot (tmpvar_43, tmpvar_42);
  c_41.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_44) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_42 + normalize(xlv_TEXCOORD7)))
    , tmpvar_43), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_41.w = (tmpvar_44 * 2.0);
  float tmpvar_45;
  tmpvar_45 = dot (xlv_TEXCOORD4, tmpvar_42);
  color_4 = (c_41 * mix (1.0, clamp (
    floor((1.01 + tmpvar_45))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_45))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_46;
  tmpvar_46 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_46.xyz;
  color_4.w = (tmpvar_46.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 165 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  cityoverlay_4.xyz = tmpvar_14.xyz;
  mediump vec2 uv_15;
  mediump vec3 detailCoords_16;
  mediump float s_17;
  mediump float nylerp_18;
  mediump float zxlerp_19;
  highp vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  zxlerp_19 = tmpvar_22;
  highp float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  nylerp_18 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_19);
  s_17 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_20.y, s_17, nylerp_18));
  s_17 = tmpvar_25;
  mediump vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(s_17);
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = s_17;
  highp vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_26 * tmpvar_20.xzy), (tmpvar_27 * tmpvar_20.zxy), vec3(zxlerp_19));
  detailCoords_16 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xy = vec2(1.0, 1.0);
  tmpvar_29.z = s_17;
  highp vec3 tmpvar_30;
  tmpvar_30 = mix ((tmpvar_29 * tmpvar_20.yxz), detailCoords_16, vec3(nylerp_18));
  detailCoords_16 = tmpvar_30;
  uv_15 = (((
    (0.5 * detailCoords_16.yz)
   / 
    abs(detailCoords_16.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_31;
  uv_31 = uv_15;
  highp vec2 uvCont_32;
  highp vec2 tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_31 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_15, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  citydarkoverlaydetail_3.xyz = tmpvar_37.xyz;
  mediump vec2 uv_38;
  mediump vec3 detailCoords_39;
  mediump float s_40;
  mediump float nylerp_41;
  mediump float zxlerp_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = abs(tmpvar_20);
  highp float tmpvar_44;
  tmpvar_44 = float((tmpvar_43.z >= tmpvar_43.x));
  zxlerp_42 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = float((max (tmpvar_43.x, tmpvar_43.z) >= tmpvar_43.y));
  nylerp_41 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_42);
  s_40 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = sign(mix (tmpvar_20.y, s_40, nylerp_41));
  s_40 = tmpvar_47;
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = -(s_40);
  mediump vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = s_40;
  highp vec3 tmpvar_50;
  tmpvar_50 = mix ((tmpvar_48 * tmpvar_20.xzy), (tmpvar_49 * tmpvar_20.zxy), vec3(zxlerp_42));
  detailCoords_39 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = s_40;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_20.yxz), detailCoords_39, vec3(nylerp_41));
  detailCoords_39 = tmpvar_52;
  uv_38 = (((
    (0.5 * detailCoords_39.yz)
   / 
    abs(detailCoords_39.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_53;
  uv_53 = uv_38;
  highp vec2 uvCont_54;
  highp vec2 tmpvar_55;
  tmpvar_55 = abs((uv_53 - tmpvar_34));
  uvCont_54.x = max (tmpvar_55.x, tmpvar_55.y);
  uvCont_54.y = min (tmpvar_55.x, tmpvar_55.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_54);
  tmpvar_56.zw = dFdy(uvCont_54);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_38, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citylightoverlaydetail_2.xyz = tmpvar_58.xyz;
  highp float tmpvar_59;
  tmpvar_59 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_14.w * (1.0 - tmpvar_59));
  citydarkoverlaydetail_3.w = (tmpvar_37.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_58.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_58.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_60;
  lightDir_60 = _SunDir;
  mediump vec3 viewDir_61;
  viewDir_61 = xlv_TEXCOORD7;
  mediump vec3 normal_62;
  normal_62 = xlv_TEXCOORD4;
  mediump vec4 c_63;
  mediump vec3 tmpvar_64;
  tmpvar_64 = normalize(lightDir_60);
  lightDir_60 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65 = normalize(viewDir_61);
  viewDir_61 = tmpvar_65;
  mediump vec3 tmpvar_66;
  tmpvar_66 = normalize(normal_62);
  normal_62 = tmpvar_66;
  mediump float tmpvar_67;
  tmpvar_67 = dot (tmpvar_66, tmpvar_64);
  highp float tmpvar_68;
  mediump float tmpvar_69;
  tmpvar_69 = clamp (dot (normalize(
    (tmpvar_64 + tmpvar_65)
  ), tmpvar_66), 0.0, 1.0);
  tmpvar_68 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = (pow (tmpvar_68, _SpecularPower) * _SpecularColor.w);
  c_63.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_67) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_70)) * 2.0);
  c_63.w = (tmpvar_67 * 2.0);
  highp vec3 tmpvar_71;
  tmpvar_71 = normalize(_SunDir);
  mediump vec3 lightDir_72;
  lightDir_72 = tmpvar_71;
  mediump vec3 normal_73;
  normal_73 = xlv_TEXCOORD4;
  mediump float tmpvar_74;
  tmpvar_74 = dot (normal_73, lightDir_72);
  color_5 = (c_63 * mix (1.0, clamp (
    floor((1.01 + tmpvar_74))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_74))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_75;
  tmpvar_75 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_75.xyz;
  color_5.w = (tmpvar_75.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec2 t3;
lowp float t10_3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
highp vec3 t7;
mediump vec3 t16_8;
highp float t10;
highp int ti10;
bvec2 tb10;
highp vec2 t14;
mediump float t16_15;
highp float t17;
bool tb17;
highp float t18;
mediump float t16_22;
highp float t24;
highp int ti24;
bool tb24;
highp float t25;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_8.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_8.x = floor(t16_8.x);
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_8.x = t16_8.x + -1.0;
    t16_1.x = t16_1.x * t16_8.x + 1.0;
    t16_8.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_8.x = inversesqrt(t16_8.x);
    t16_8.xyz = t16_8.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_8.x = dot(t16_2.xyz, t16_8.xyz);
    t16_8.x = t16_8.x + t16_8.x;
    t16_1.x = t16_1.x * t16_8.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t7.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t7.z), abs(t7.y));
    t3.x = float(1.0) / t3.x;
    t10 = min(abs(t7.z), abs(t7.y));
    t3.x = t3.x * t10;
    t10 = t3.x * t3.x;
    t17 = t10 * 0.0208350997 + -0.0851330012;
    t17 = t10 * t17 + 0.180141002;
    t17 = t10 * t17 + -0.330299497;
    t10 = t10 * t17 + 0.999866009;
    t17 = t10 * t3.x;
    t17 = t17 * -2.0 + 1.57079637;
    tb24 = abs(t7.z)<abs(t7.y);
    t17 = tb24 ? t17 : float(0.0);
    t3.x = t3.x * t10 + t17;
    tb10.xy = lessThan(t7.zxzz, (-t7.zxzz)).xy;
    t10 = tb10.x ? -3.14159274 : float(0.0);
    t3.x = t10 + t3.x;
    t10 = min(t7.z, t7.y);
    tb10.x = t10<(-t10);
    t24 = max(t7.z, t7.y);
    tb24 = t24>=(-t24);
    ti10 = int(uint(tb24) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t3.x = (ti10 != 0) ? (-t3.x) : t3.x;
    t10 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t10);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t24 = abs(t7.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t7.x) + -0.212114394;
    t24 = t24 * abs(t7.x) + 1.57072878;
    t18 = -abs(t7.x) + 1.0;
    t18 = sqrt(t18);
    t25 = t24 * t18;
    t25 = t25 * -2.0 + 3.14159274;
    t17 = tb10.y ? t25 : float(0.0);
    t17 = t24 * t18 + t17;
    t4.y = t17 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_3 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy).w;
    tb10.x = 0.0>=vs_TEXCOORD0.w;
    t10 = (tb10.x) ? 0.0 : 1.0;
    t3.x = t10 * t10_3;
    t10 = vs_TEXCOORD5.z * t0.x + (-t7.y);
    tb17 = abs(t7.z)>=abs(t7.y);
    t17 = tb17 ? 1.0 : float(0.0);
    t10 = t17 * t10 + t7.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t10;
    t10 = max(abs(t7.z), abs(t7.y));
    tb10.x = t10>=abs(t7.x);
    t10 = tb10.x ? 1.0 : float(0.0);
    t0.x = t10 * t0.x + t7.x;
    ti24 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti24) + ti0;
    t16_2.y = float(ti0);
    t16_6.y = (-t16_2.y);
    t16_6.xz = vec2(1.0, -1.0);
    t4.xyz = t7.yzx * t16_6.xyz;
    t16_2.xz = vec2(1.0, -1.0);
    t5.xyz = t16_2.xyz * t7.zyx + (-t4.xyz);
    t4.xyz = vec3(t17) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_2.xxy) * t7.xyz + t4.xyz;
    t0.xyz = t7.xyz * t16_2.xxy;
    t0.xyz = vec3(t10) * t4.xyz + t0.xyz;
    t16_8.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t0.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t0.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t14.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t0.xy;
    t10 = max(abs(t14.y), abs(t14.x));
    t14.x = min(abs(t14.y), abs(t14.x));
    t4.x = dFdx(t10);
    t5.x = dFdy(t10);
    t4.y = dFdx(t14.x);
    t5.y = dFdy(t14.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_8.x = t3.x * t10_2.w;
    t16_15 = t3.x * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_2.xyz;
    t16_22 = t16_8.x * t16_1.x + (-t16_15);
    t16_1.x = t16_1.x * t16_8.x;
    t16_8.x = t16_1.x * t16_22 + t16_15;
    t16_1.xzw = t16_1.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
float t12;
bool tb12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t18 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t18 + 1.00999999;
    t18 = t18 * -10.0;
    t18 = clamp(t18, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t18 = t18 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t18 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12 = max(abs(t1.z), abs(t1.y));
    t12 = float(1.0) / t12;
    t18 = min(abs(t1.z), abs(t1.y));
    t12 = t12 * t18;
    t18 = t12 * t12;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12 = t12 * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12 = t18 + t12;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12 = (ti18 != 0) ? (-t12) : t12;
    t18 = t12 * 0.159154937;
    t3.x = t12 * 0.159154937 + 0.5;
    t12 = abs(t18);
    t4.x = dFdx(t12);
    t5.x = dFdy(t12);
    t12 = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12 = t12 * abs(t1.x) + -0.212114394;
    t12 = t12 * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12 = t12 * t18 + t19;
    t3.y = t12 * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    tb12 = 0.0>=vs_TEXCOORD0.w;
    t12 = (tb12) ? 0.0 : 1.0;
    t12 = t12 * t10_2.w;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12 * t1.w;
    t2.w = t12 * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 166 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  cityoverlay_3.xyz = tmpvar_12.xyz;
  vec2 uv_13;
  vec3 tmpvar_14;
  tmpvar_14 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_15;
  tmpvar_15 = abs(tmpvar_14);
  float tmpvar_16;
  tmpvar_16 = float((tmpvar_15.z >= tmpvar_15.x));
  float tmpvar_17;
  tmpvar_17 = float((max (tmpvar_15.x, tmpvar_15.z) >= tmpvar_15.y));
  float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_16), tmpvar_17));
  vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(tmpvar_18);
  vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = tmpvar_18;
  vec3 tmpvar_21;
  tmpvar_21.xy = vec2(1.0, 1.0);
  tmpvar_21.z = tmpvar_18;
  vec3 tmpvar_22;
  tmpvar_22 = mix ((tmpvar_21 * tmpvar_14.yxz), mix ((tmpvar_19 * tmpvar_14.xzy), (tmpvar_20 * tmpvar_14.zxy), vec3(tmpvar_16)), vec3(tmpvar_17));
  uv_13 = (((
    (0.5 * tmpvar_22.yz)
   / 
    abs(tmpvar_22.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_23;
  vec2 tmpvar_24;
  float tmpvar_25;
  tmpvar_25 = (0.5 * _CityOverlayDetailScale);
  tmpvar_24 = abs((uv_13 - tmpvar_25));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  vec4 tmpvar_26;
  tmpvar_26.xy = dFdx(uvCont_23);
  tmpvar_26.zw = dFdy(uvCont_23);
  vec4 tmpvar_27;
  tmpvar_27 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_13, tmpvar_26.xy, tmpvar_26.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_27.xyz;
  vec2 uv_28;
  vec3 tmpvar_29;
  tmpvar_29 = abs(tmpvar_14);
  float tmpvar_30;
  tmpvar_30 = float((tmpvar_29.z >= tmpvar_29.x));
  float tmpvar_31;
  tmpvar_31 = float((max (tmpvar_29.x, tmpvar_29.z) >= tmpvar_29.y));
  float tmpvar_32;
  tmpvar_32 = sign(mix (tmpvar_14.y, mix (tmpvar_14.x, tmpvar_14.z, tmpvar_30), tmpvar_31));
  vec3 tmpvar_33;
  tmpvar_33.xz = vec2(1.0, -1.0);
  tmpvar_33.y = -(tmpvar_32);
  vec3 tmpvar_34;
  tmpvar_34.xz = vec2(1.0, -1.0);
  tmpvar_34.y = tmpvar_32;
  vec3 tmpvar_35;
  tmpvar_35.xy = vec2(1.0, 1.0);
  tmpvar_35.z = tmpvar_32;
  vec3 tmpvar_36;
  tmpvar_36 = mix ((tmpvar_35 * tmpvar_14.yxz), mix ((tmpvar_33 * tmpvar_14.xzy), (tmpvar_34 * tmpvar_14.zxy), vec3(tmpvar_30)), vec3(tmpvar_31));
  uv_28 = (((
    (0.5 * tmpvar_36.yz)
   / 
    abs(tmpvar_36.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_37;
  vec2 tmpvar_38;
  tmpvar_38 = abs((uv_28 - tmpvar_25));
  uvCont_37.x = max (tmpvar_38.x, tmpvar_38.y);
  uvCont_37.y = min (tmpvar_38.x, tmpvar_38.y);
  vec4 tmpvar_39;
  tmpvar_39.xy = dFdx(uvCont_37);
  tmpvar_39.zw = dFdy(uvCont_37);
  vec4 tmpvar_40;
  tmpvar_40 = texture2DGradARB (_CityLightOverlayDetailTex, uv_28, tmpvar_39.xy, tmpvar_39.zw);
  citylightoverlaydetail_1.xyz = tmpvar_40.xyz;
  cityoverlay_3.w = (tmpvar_12.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_27.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_40.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_40.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_41;
  tmpvar_41 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_42;
  vec3 tmpvar_43;
  tmpvar_43 = normalize(_SunDir);
  vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD4);
  float tmpvar_45;
  tmpvar_45 = dot (tmpvar_44, tmpvar_43);
  c_42.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_45) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_43 + normalize(xlv_TEXCOORD7)))
    , tmpvar_44), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_41.x * 2.0));
  c_42.w = (tmpvar_45 * (tmpvar_41.x * 2.0));
  float tmpvar_46;
  tmpvar_46 = dot (xlv_TEXCOORD4, tmpvar_43);
  color_4 = (c_42 * mix (1.0, clamp (
    floor((1.01 + tmpvar_46))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_46))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_47;
  tmpvar_47 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_47.xyz;
  color_4.w = (tmpvar_47.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 171 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  cityoverlay_4.xyz = tmpvar_14.xyz;
  mediump vec2 uv_15;
  mediump vec3 detailCoords_16;
  mediump float s_17;
  mediump float nylerp_18;
  mediump float zxlerp_19;
  highp vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  zxlerp_19 = tmpvar_22;
  highp float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  nylerp_18 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_19);
  s_17 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_20.y, s_17, nylerp_18));
  s_17 = tmpvar_25;
  mediump vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(s_17);
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = s_17;
  highp vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_26 * tmpvar_20.xzy), (tmpvar_27 * tmpvar_20.zxy), vec3(zxlerp_19));
  detailCoords_16 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xy = vec2(1.0, 1.0);
  tmpvar_29.z = s_17;
  highp vec3 tmpvar_30;
  tmpvar_30 = mix ((tmpvar_29 * tmpvar_20.yxz), detailCoords_16, vec3(nylerp_18));
  detailCoords_16 = tmpvar_30;
  uv_15 = (((
    (0.5 * detailCoords_16.yz)
   / 
    abs(detailCoords_16.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_31;
  uv_31 = uv_15;
  highp vec2 uvCont_32;
  highp vec2 tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_31 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_15, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  citydarkoverlaydetail_3.xyz = tmpvar_37.xyz;
  mediump vec2 uv_38;
  mediump vec3 detailCoords_39;
  mediump float s_40;
  mediump float nylerp_41;
  mediump float zxlerp_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = abs(tmpvar_20);
  highp float tmpvar_44;
  tmpvar_44 = float((tmpvar_43.z >= tmpvar_43.x));
  zxlerp_42 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = float((max (tmpvar_43.x, tmpvar_43.z) >= tmpvar_43.y));
  nylerp_41 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_42);
  s_40 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = sign(mix (tmpvar_20.y, s_40, nylerp_41));
  s_40 = tmpvar_47;
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = -(s_40);
  mediump vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = s_40;
  highp vec3 tmpvar_50;
  tmpvar_50 = mix ((tmpvar_48 * tmpvar_20.xzy), (tmpvar_49 * tmpvar_20.zxy), vec3(zxlerp_42));
  detailCoords_39 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = s_40;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_20.yxz), detailCoords_39, vec3(nylerp_41));
  detailCoords_39 = tmpvar_52;
  uv_38 = (((
    (0.5 * detailCoords_39.yz)
   / 
    abs(detailCoords_39.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_53;
  uv_53 = uv_38;
  highp vec2 uvCont_54;
  highp vec2 tmpvar_55;
  tmpvar_55 = abs((uv_53 - tmpvar_34));
  uvCont_54.x = max (tmpvar_55.x, tmpvar_55.y);
  uvCont_54.y = min (tmpvar_55.x, tmpvar_55.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_54);
  tmpvar_56.zw = dFdy(uvCont_54);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_38, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citylightoverlaydetail_2.xyz = tmpvar_58.xyz;
  highp float tmpvar_59;
  tmpvar_59 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_14.w * (1.0 - tmpvar_59));
  citydarkoverlaydetail_3.w = (tmpvar_37.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_58.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_58.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_60 = tmpvar_61;
  mediump vec3 lightDir_62;
  lightDir_62 = _SunDir;
  mediump vec3 viewDir_63;
  viewDir_63 = xlv_TEXCOORD7;
  mediump vec3 normal_64;
  normal_64 = xlv_TEXCOORD4;
  mediump float atten_65;
  atten_65 = tmpvar_60;
  mediump vec4 c_66;
  mediump vec3 tmpvar_67;
  tmpvar_67 = normalize(lightDir_62);
  lightDir_62 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68 = normalize(viewDir_63);
  viewDir_63 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69 = normalize(normal_64);
  normal_64 = tmpvar_69;
  mediump float tmpvar_70;
  tmpvar_70 = dot (tmpvar_69, tmpvar_67);
  highp float tmpvar_71;
  mediump float tmpvar_72;
  tmpvar_72 = clamp (dot (normalize(
    (tmpvar_67 + tmpvar_68)
  ), tmpvar_69), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = (pow (tmpvar_71, _SpecularPower) * _SpecularColor.w);
  c_66.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_70) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_73)) * (atten_65 * 2.0));
  c_66.w = (tmpvar_70 * (atten_65 * 2.0));
  highp vec3 tmpvar_74;
  tmpvar_74 = normalize(_SunDir);
  mediump vec3 lightDir_75;
  lightDir_75 = tmpvar_74;
  mediump vec3 normal_76;
  normal_76 = xlv_TEXCOORD4;
  mediump float tmpvar_77;
  tmpvar_77 = dot (normal_76, lightDir_75);
  color_5 = (c_66 * mix (1.0, clamp (
    floor((1.01 + tmpvar_77))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_77))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_78;
  tmpvar_78 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_78.xyz;
  color_5.w = (tmpvar_78.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
vec2 t12;
bool tb12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t18 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t12.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t12.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t12.x = t6.x + 1.00999999;
    t6.x = t6.x * -10.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t12.x = floor(t12.x);
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = t6.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12.x = max(abs(t1.z), abs(t1.y));
    t12.x = float(1.0) / t12.x;
    t18 = min(abs(t1.z), abs(t1.y));
    t12.x = t12.x * t18;
    t18 = t12.x * t12.x;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12.x = t18 + t12.x;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12.x = (ti18 != 0) ? (-t12.x) : t12.x;
    t18 = t12.x * 0.159154937;
    t3.x = t12.x * 0.159154937 + 0.5;
    t12.x = abs(t18);
    t4.x = dFdx(t12.x);
    t5.x = dFdy(t12.x);
    t12.x = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12.x = t12.x * abs(t1.x) + -0.212114394;
    t12.x = t12.x * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    t3.y = t12.x * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    tb12 = 0.0>=vs_TEXCOORD0.w;
    t12.x = (tb12) ? 0.0 : 1.0;
    t12.x = t12.x * t10_2.w;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12.x * t1.w;
    t2.w = t12.x * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 170 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  cityoverlay_4.xyz = tmpvar_14.xyz;
  mediump vec2 uv_15;
  mediump vec3 detailCoords_16;
  mediump float s_17;
  mediump float nylerp_18;
  mediump float zxlerp_19;
  highp vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  zxlerp_19 = tmpvar_22;
  highp float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  nylerp_18 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_19);
  s_17 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_20.y, s_17, nylerp_18));
  s_17 = tmpvar_25;
  mediump vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(s_17);
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = s_17;
  highp vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_26 * tmpvar_20.xzy), (tmpvar_27 * tmpvar_20.zxy), vec3(zxlerp_19));
  detailCoords_16 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xy = vec2(1.0, 1.0);
  tmpvar_29.z = s_17;
  highp vec3 tmpvar_30;
  tmpvar_30 = mix ((tmpvar_29 * tmpvar_20.yxz), detailCoords_16, vec3(nylerp_18));
  detailCoords_16 = tmpvar_30;
  uv_15 = (((
    (0.5 * detailCoords_16.yz)
   / 
    abs(detailCoords_16.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_31;
  uv_31 = uv_15;
  highp vec2 uvCont_32;
  highp vec2 tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_31 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_15, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  citydarkoverlaydetail_3.xyz = tmpvar_37.xyz;
  mediump vec2 uv_38;
  mediump vec3 detailCoords_39;
  mediump float s_40;
  mediump float nylerp_41;
  mediump float zxlerp_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = abs(tmpvar_20);
  highp float tmpvar_44;
  tmpvar_44 = float((tmpvar_43.z >= tmpvar_43.x));
  zxlerp_42 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = float((max (tmpvar_43.x, tmpvar_43.z) >= tmpvar_43.y));
  nylerp_41 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_42);
  s_40 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = sign(mix (tmpvar_20.y, s_40, nylerp_41));
  s_40 = tmpvar_47;
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = -(s_40);
  mediump vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = s_40;
  highp vec3 tmpvar_50;
  tmpvar_50 = mix ((tmpvar_48 * tmpvar_20.xzy), (tmpvar_49 * tmpvar_20.zxy), vec3(zxlerp_42));
  detailCoords_39 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = s_40;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_20.yxz), detailCoords_39, vec3(nylerp_41));
  detailCoords_39 = tmpvar_52;
  uv_38 = (((
    (0.5 * detailCoords_39.yz)
   / 
    abs(detailCoords_39.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_53;
  uv_53 = uv_38;
  highp vec2 uvCont_54;
  highp vec2 tmpvar_55;
  tmpvar_55 = abs((uv_53 - tmpvar_34));
  uvCont_54.x = max (tmpvar_55.x, tmpvar_55.y);
  uvCont_54.y = min (tmpvar_55.x, tmpvar_55.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_54);
  tmpvar_56.zw = dFdy(uvCont_54);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_38, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citylightoverlaydetail_2.xyz = tmpvar_58.xyz;
  highp float tmpvar_59;
  tmpvar_59 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_14.w * (1.0 - tmpvar_59));
  citydarkoverlaydetail_3.w = (tmpvar_37.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_58.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_58.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_60;
  shadow_60 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_61;
  lightDir_61 = _SunDir;
  mediump vec3 viewDir_62;
  viewDir_62 = xlv_TEXCOORD7;
  mediump vec3 normal_63;
  normal_63 = xlv_TEXCOORD4;
  mediump float atten_64;
  atten_64 = shadow_60;
  mediump vec4 c_65;
  mediump vec3 tmpvar_66;
  tmpvar_66 = normalize(lightDir_61);
  lightDir_61 = tmpvar_66;
  mediump vec3 tmpvar_67;
  tmpvar_67 = normalize(viewDir_62);
  viewDir_62 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68 = normalize(normal_63);
  normal_63 = tmpvar_68;
  mediump float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, tmpvar_66);
  highp float tmpvar_70;
  mediump float tmpvar_71;
  tmpvar_71 = clamp (dot (normalize(
    (tmpvar_66 + tmpvar_67)
  ), tmpvar_68), 0.0, 1.0);
  tmpvar_70 = tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = (pow (tmpvar_70, _SpecularPower) * _SpecularColor.w);
  c_65.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_69) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_72)) * (atten_64 * 2.0));
  c_65.w = (tmpvar_69 * (atten_64 * 2.0));
  highp vec3 tmpvar_73;
  tmpvar_73 = normalize(_SunDir);
  mediump vec3 lightDir_74;
  lightDir_74 = tmpvar_73;
  mediump vec3 normal_75;
  normal_75 = xlv_TEXCOORD4;
  mediump float tmpvar_76;
  tmpvar_76 = dot (normal_75, lightDir_74);
  color_5 = (c_65 * mix (1.0, clamp (
    floor((1.01 + tmpvar_76))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_76))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_77;
  tmpvar_77 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_77.xyz;
  color_5.w = (tmpvar_77.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp vec4 t10_2;
highp int ti2;
highp vec2 t3;
lowp float t10_3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec2 t16_7;
highp vec3 t9;
highp float t10;
highp int ti10;
bvec2 tb10;
mediump float t16_14;
highp vec2 t16;
highp float t17;
bool tb17;
highp float t18;
mediump float t16_21;
highp float t24;
highp int ti24;
bool tb24;
highp float t25;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_21 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_21 = inversesqrt(t16_21);
    t16_1.xyz = vec3(t16_21) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec19 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_7.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec19, 0.0);
    t16_14 = (-_LightShadowData.x) + 1.0;
    t16_7.x = t16_7.x * t16_14 + _LightShadowData.x;
    t16_0.x = dot(t16_7.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_7.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_14 = t16_7.x + 1.00999999;
    t16_7.x = t16_7.x * -10.0;
    t16_7.x = clamp(t16_7.x, 0.0, 1.0);
    t16_14 = floor(t16_14);
    t16_14 = clamp(t16_14, 0.0, 1.0);
    t16_14 = t16_14 + -1.0;
    t16_7.x = t16_7.x * t16_14 + 1.0;
    t16_0.x = t16_7.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t9.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t9.z), abs(t9.y));
    t3.x = float(1.0) / t3.x;
    t10 = min(abs(t9.z), abs(t9.y));
    t3.x = t3.x * t10;
    t10 = t3.x * t3.x;
    t17 = t10 * 0.0208350997 + -0.0851330012;
    t17 = t10 * t17 + 0.180141002;
    t17 = t10 * t17 + -0.330299497;
    t10 = t10 * t17 + 0.999866009;
    t17 = t10 * t3.x;
    t17 = t17 * -2.0 + 1.57079637;
    tb24 = abs(t9.z)<abs(t9.y);
    t17 = tb24 ? t17 : float(0.0);
    t3.x = t3.x * t10 + t17;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10 = tb10.x ? -3.14159274 : float(0.0);
    t3.x = t10 + t3.x;
    t10 = min(t9.z, t9.y);
    tb10.x = t10<(-t10);
    t24 = max(t9.z, t9.y);
    tb24 = t24>=(-t24);
    ti10 = int(uint(tb24) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t3.x = (ti10 != 0) ? (-t3.x) : t3.x;
    t10 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t10);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t24 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t9.x) + -0.212114394;
    t24 = t24 * abs(t9.x) + 1.57072878;
    t18 = -abs(t9.x) + 1.0;
    t18 = sqrt(t18);
    t25 = t24 * t18;
    t25 = t25 * -2.0 + 3.14159274;
    t17 = tb10.y ? t25 : float(0.0);
    t17 = t24 * t18 + t17;
    t4.y = t17 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_3 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy).w;
    tb10.x = 0.0>=vs_TEXCOORD0.w;
    t10 = (tb10.x) ? 0.0 : 1.0;
    t3.x = t10 * t10_3;
    t10 = vs_TEXCOORD5.z * t2.x + (-t9.y);
    tb17 = abs(t9.z)>=abs(t9.y);
    t17 = tb17 ? 1.0 : float(0.0);
    t10 = t17 * t10 + t9.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t10;
    t10 = max(abs(t9.z), abs(t9.y));
    tb10.x = t10>=abs(t9.x);
    t10 = tb10.x ? 1.0 : float(0.0);
    t2.x = t10 * t2.x + t9.x;
    ti24 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti24) + ti2;
    t16_1.y = float(ti2);
    t16_6.y = (-t16_1.y);
    t16_6.xz = vec2(1.0, -1.0);
    t4.xyz = t9.yzx * t16_6.xyz;
    t16_1.xz = vec2(1.0, -1.0);
    t5.xyz = t16_1.xyz * t9.zyx + (-t4.xyz);
    t4.xyz = vec3(t17) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_1.xxy) * t9.xyz + t4.xyz;
    t2.xyz = t9.xyz * t16_1.xxy;
    t2.xyz = vec3(t10) * t4.xyz + t2.xyz;
    t16_7.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_7.xy = t16_7.xy / abs(t2.xx);
    t16_7.xy = t16_7.xy + vec2(0.5, 0.5);
    t2.xy = t16_7.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t16.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t2.xy;
    t10 = max(abs(t16.y), abs(t16.x));
    t16.x = min(abs(t16.y), abs(t16.x));
    t4.x = dFdx(t10);
    t5.x = dFdy(t10);
    t4.y = dFdx(t16.x);
    t5.y = dFdy(t16.x);
    t10_1 = textureGrad(_CityDarkOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_2 = textureGrad(_CityLightOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_7.x = t3.x * t10_1.w;
    t16_14 = t3.x * t10_2.w;
    t16_6.xyz = t10_1.xyz + (-t10_2.xyz);
    t16_21 = t16_7.x * t16_0.x + (-t16_14);
    t16_0.x = t16_0.x * t16_7.x;
    t16_7.x = t16_0.x * t16_21 + t16_14;
    t16_0.xzw = t16_0.xxx * t16_6.xyz + t10_2.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_7.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 170 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  cityoverlay_4.xyz = tmpvar_14.xyz;
  mediump vec2 uv_15;
  mediump vec3 detailCoords_16;
  mediump float s_17;
  mediump float nylerp_18;
  mediump float zxlerp_19;
  highp vec3 tmpvar_20;
  tmpvar_20 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_21;
  tmpvar_21 = abs(tmpvar_20);
  highp float tmpvar_22;
  tmpvar_22 = float((tmpvar_21.z >= tmpvar_21.x));
  zxlerp_19 = tmpvar_22;
  highp float tmpvar_23;
  tmpvar_23 = float((max (tmpvar_21.x, tmpvar_21.z) >= tmpvar_21.y));
  nylerp_18 = tmpvar_23;
  highp float tmpvar_24;
  tmpvar_24 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_19);
  s_17 = tmpvar_24;
  highp float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_20.y, s_17, nylerp_18));
  s_17 = tmpvar_25;
  mediump vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(s_17);
  mediump vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = s_17;
  highp vec3 tmpvar_28;
  tmpvar_28 = mix ((tmpvar_26 * tmpvar_20.xzy), (tmpvar_27 * tmpvar_20.zxy), vec3(zxlerp_19));
  detailCoords_16 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xy = vec2(1.0, 1.0);
  tmpvar_29.z = s_17;
  highp vec3 tmpvar_30;
  tmpvar_30 = mix ((tmpvar_29 * tmpvar_20.yxz), detailCoords_16, vec3(nylerp_18));
  detailCoords_16 = tmpvar_30;
  uv_15 = (((
    (0.5 * detailCoords_16.yz)
   / 
    abs(detailCoords_16.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_31;
  uv_31 = uv_15;
  highp vec2 uvCont_32;
  highp vec2 tmpvar_33;
  highp float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_31 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  highp vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_36;
  tmpvar_36 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_15, tmpvar_35.xy, tmpvar_35.zw);
  mediump vec4 tmpvar_37;
  tmpvar_37 = tmpvar_36;
  citydarkoverlaydetail_3.xyz = tmpvar_37.xyz;
  mediump vec2 uv_38;
  mediump vec3 detailCoords_39;
  mediump float s_40;
  mediump float nylerp_41;
  mediump float zxlerp_42;
  highp vec3 tmpvar_43;
  tmpvar_43 = abs(tmpvar_20);
  highp float tmpvar_44;
  tmpvar_44 = float((tmpvar_43.z >= tmpvar_43.x));
  zxlerp_42 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = float((max (tmpvar_43.x, tmpvar_43.z) >= tmpvar_43.y));
  nylerp_41 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = mix (tmpvar_20.x, tmpvar_20.z, zxlerp_42);
  s_40 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = sign(mix (tmpvar_20.y, s_40, nylerp_41));
  s_40 = tmpvar_47;
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = -(s_40);
  mediump vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = s_40;
  highp vec3 tmpvar_50;
  tmpvar_50 = mix ((tmpvar_48 * tmpvar_20.xzy), (tmpvar_49 * tmpvar_20.zxy), vec3(zxlerp_42));
  detailCoords_39 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = s_40;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_20.yxz), detailCoords_39, vec3(nylerp_41));
  detailCoords_39 = tmpvar_52;
  uv_38 = (((
    (0.5 * detailCoords_39.yz)
   / 
    abs(detailCoords_39.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_53;
  uv_53 = uv_38;
  highp vec2 uvCont_54;
  highp vec2 tmpvar_55;
  tmpvar_55 = abs((uv_53 - tmpvar_34));
  uvCont_54.x = max (tmpvar_55.x, tmpvar_55.y);
  uvCont_54.y = min (tmpvar_55.x, tmpvar_55.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_54);
  tmpvar_56.zw = dFdy(uvCont_54);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_38, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citylightoverlaydetail_2.xyz = tmpvar_58.xyz;
  highp float tmpvar_59;
  tmpvar_59 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_14.w * (1.0 - tmpvar_59));
  citydarkoverlaydetail_3.w = (tmpvar_37.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_58.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_58.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_60;
  shadow_60 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_61;
  lightDir_61 = _SunDir;
  mediump vec3 viewDir_62;
  viewDir_62 = xlv_TEXCOORD7;
  mediump vec3 normal_63;
  normal_63 = xlv_TEXCOORD4;
  mediump float atten_64;
  atten_64 = shadow_60;
  mediump vec4 c_65;
  mediump vec3 tmpvar_66;
  tmpvar_66 = normalize(lightDir_61);
  lightDir_61 = tmpvar_66;
  mediump vec3 tmpvar_67;
  tmpvar_67 = normalize(viewDir_62);
  viewDir_62 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68 = normalize(normal_63);
  normal_63 = tmpvar_68;
  mediump float tmpvar_69;
  tmpvar_69 = dot (tmpvar_68, tmpvar_66);
  highp float tmpvar_70;
  mediump float tmpvar_71;
  tmpvar_71 = clamp (dot (normalize(
    (tmpvar_66 + tmpvar_67)
  ), tmpvar_68), 0.0, 1.0);
  tmpvar_70 = tmpvar_71;
  highp float tmpvar_72;
  tmpvar_72 = (pow (tmpvar_70, _SpecularPower) * _SpecularColor.w);
  c_65.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_69) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_72)) * (atten_64 * 2.0));
  c_65.w = (tmpvar_69 * (atten_64 * 2.0));
  highp vec3 tmpvar_73;
  tmpvar_73 = normalize(_SunDir);
  mediump vec3 lightDir_74;
  lightDir_74 = tmpvar_73;
  mediump vec3 normal_75;
  normal_75 = xlv_TEXCOORD4;
  mediump float tmpvar_76;
  tmpvar_76 = dot (normal_75, lightDir_74);
  color_5 = (c_65 * mix (1.0, clamp (
    floor((1.01 + tmpvar_76))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_76))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_77;
  tmpvar_77 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_77.xyz;
  color_5.w = (tmpvar_77.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp vec4 t10_2;
highp int ti2;
highp vec2 t3;
lowp float t10_3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec2 t16_7;
highp vec3 t9;
highp float t10;
highp int ti10;
bvec2 tb10;
mediump float t16_14;
highp vec2 t16;
highp float t17;
bool tb17;
highp float t18;
mediump float t16_21;
highp float t24;
highp int ti24;
bool tb24;
highp float t25;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_21 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_21 = inversesqrt(t16_21);
    t16_1.xyz = vec3(t16_21) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec25 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_7.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec25, 0.0);
    t16_14 = (-_LightShadowData.x) + 1.0;
    t16_7.x = t16_7.x * t16_14 + _LightShadowData.x;
    t16_0.x = dot(t16_7.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_7.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_14 = t16_7.x + 1.00999999;
    t16_7.x = t16_7.x * -10.0;
    t16_7.x = clamp(t16_7.x, 0.0, 1.0);
    t16_14 = floor(t16_14);
    t16_14 = clamp(t16_14, 0.0, 1.0);
    t16_14 = t16_14 + -1.0;
    t16_7.x = t16_7.x * t16_14 + 1.0;
    t16_0.x = t16_7.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t9.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t9.z), abs(t9.y));
    t3.x = float(1.0) / t3.x;
    t10 = min(abs(t9.z), abs(t9.y));
    t3.x = t3.x * t10;
    t10 = t3.x * t3.x;
    t17 = t10 * 0.0208350997 + -0.0851330012;
    t17 = t10 * t17 + 0.180141002;
    t17 = t10 * t17 + -0.330299497;
    t10 = t10 * t17 + 0.999866009;
    t17 = t10 * t3.x;
    t17 = t17 * -2.0 + 1.57079637;
    tb24 = abs(t9.z)<abs(t9.y);
    t17 = tb24 ? t17 : float(0.0);
    t3.x = t3.x * t10 + t17;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10 = tb10.x ? -3.14159274 : float(0.0);
    t3.x = t10 + t3.x;
    t10 = min(t9.z, t9.y);
    tb10.x = t10<(-t10);
    t24 = max(t9.z, t9.y);
    tb24 = t24>=(-t24);
    ti10 = int(uint(tb24) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t3.x = (ti10 != 0) ? (-t3.x) : t3.x;
    t10 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t10);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t24 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t24 = t24 * abs(t9.x) + -0.212114394;
    t24 = t24 * abs(t9.x) + 1.57072878;
    t18 = -abs(t9.x) + 1.0;
    t18 = sqrt(t18);
    t25 = t24 * t18;
    t25 = t25 * -2.0 + 3.14159274;
    t17 = tb10.y ? t25 : float(0.0);
    t17 = t24 * t18 + t17;
    t4.y = t17 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_3 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy).w;
    tb10.x = 0.0>=vs_TEXCOORD0.w;
    t10 = (tb10.x) ? 0.0 : 1.0;
    t3.x = t10 * t10_3;
    t10 = vs_TEXCOORD5.z * t2.x + (-t9.y);
    tb17 = abs(t9.z)>=abs(t9.y);
    t17 = tb17 ? 1.0 : float(0.0);
    t10 = t17 * t10 + t9.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t10;
    t10 = max(abs(t9.z), abs(t9.y));
    tb10.x = t10>=abs(t9.x);
    t10 = tb10.x ? 1.0 : float(0.0);
    t2.x = t10 * t2.x + t9.x;
    ti24 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti24) + ti2;
    t16_1.y = float(ti2);
    t16_6.y = (-t16_1.y);
    t16_6.xz = vec2(1.0, -1.0);
    t4.xyz = t9.yzx * t16_6.xyz;
    t16_1.xz = vec2(1.0, -1.0);
    t5.xyz = t16_1.xyz * t9.zyx + (-t4.xyz);
    t4.xyz = vec3(t17) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_1.xxy) * t9.xyz + t4.xyz;
    t2.xyz = t9.xyz * t16_1.xxy;
    t2.xyz = vec3(t10) * t4.xyz + t2.xyz;
    t16_7.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_7.xy = t16_7.xy / abs(t2.xx);
    t16_7.xy = t16_7.xy + vec2(0.5, 0.5);
    t2.xy = t16_7.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t16.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t2.xy;
    t10 = max(abs(t16.y), abs(t16.x));
    t16.x = min(abs(t16.y), abs(t16.x));
    t4.x = dFdx(t10);
    t5.x = dFdy(t10);
    t4.y = dFdx(t16.x);
    t5.y = dFdy(t16.x);
    t10_1 = textureGrad(_CityDarkOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_2 = textureGrad(_CityLightOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_7.x = t3.x * t10_1.w;
    t16_14 = t3.x * t10_2.w;
    t16_6.xyz = t10_1.xyz + (-t10_2.xyz);
    t16_21 = t16_7.x * t16_0.x + (-t16_14);
    t16_0.x = t16_0.x * t16_7.x;
    t16_7.x = t16_0.x * t16_21 + t16_14;
    t16_0.xzw = t16_0.xxx * t16_6.xyz + t10_2.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_7.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 169 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  float tmpvar_12;
  vec4 v_13;
  v_13 = (texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw) * alphaMask1);
  tmpvar_12 = ((v_13.x + v_13.y) + (v_13.z + v_13.w));
  vec4 tmpvar_14;
  tmpvar_14.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_14.w = tmpvar_12;
  cityoverlay_3.xyz = tmpvar_14.xyz;
  vec2 uv_15;
  vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_16);
  float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  float tmpvar_20;
  tmpvar_20 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_18), tmpvar_19));
  vec3 tmpvar_21;
  tmpvar_21.xz = vec2(1.0, -1.0);
  tmpvar_21.y = -(tmpvar_20);
  vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = tmpvar_20;
  vec3 tmpvar_23;
  tmpvar_23.xy = vec2(1.0, 1.0);
  tmpvar_23.z = tmpvar_20;
  vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_23 * tmpvar_16.yxz), mix ((tmpvar_21 * tmpvar_16.xzy), (tmpvar_22 * tmpvar_16.zxy), vec3(tmpvar_18)), vec3(tmpvar_19));
  uv_15 = (((
    (0.5 * tmpvar_24.yz)
   / 
    abs(tmpvar_24.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_25;
  vec2 tmpvar_26;
  float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_15 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  vec4 tmpvar_29;
  tmpvar_29 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_15, tmpvar_28.xy, tmpvar_28.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_29.xyz;
  vec2 uv_30;
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_16);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_16.yxz), mix ((tmpvar_35 * tmpvar_16.xzy), (tmpvar_36 * tmpvar_16.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_30 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  tmpvar_40 = abs((uv_30 - tmpvar_27));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_41;
  tmpvar_41.xy = dFdx(uvCont_39);
  tmpvar_41.zw = dFdy(uvCont_39);
  vec4 tmpvar_42;
  tmpvar_42 = texture2DGradARB (_CityLightOverlayDetailTex, uv_30, tmpvar_41.xy, tmpvar_41.zw);
  citylightoverlaydetail_1.xyz = tmpvar_42.xyz;
  cityoverlay_3.w = (tmpvar_12 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_29.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_42.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_42.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_43;
  vec3 tmpvar_44;
  tmpvar_44 = normalize(_SunDir);
  vec3 tmpvar_45;
  tmpvar_45 = normalize(xlv_TEXCOORD4);
  float tmpvar_46;
  tmpvar_46 = dot (tmpvar_45, tmpvar_44);
  c_43.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_46) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_44 + normalize(xlv_TEXCOORD7)))
    , tmpvar_45), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_43.w = (tmpvar_46 * 2.0);
  float tmpvar_47;
  tmpvar_47 = dot (xlv_TEXCOORD4, tmpvar_44);
  color_4 = (c_43 * mix (1.0, clamp (
    floor((1.01 + tmpvar_47))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_47))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_48;
  tmpvar_48 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_48.xyz;
  color_4.w = (tmpvar_48.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 170 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  mediump float tmpvar_15;
  mediump vec4 v_16;
  v_16 = (tmpvar_14 * alphaMask1);
  tmpvar_15 = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  mediump vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = tmpvar_15;
  cityoverlay_4.xyz = tmpvar_17.xyz;
  mediump vec2 uv_18;
  mediump vec3 detailCoords_19;
  mediump float s_20;
  mediump float nylerp_21;
  mediump float zxlerp_22;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  zxlerp_22 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  nylerp_21 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_22);
  s_20 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = sign(mix (tmpvar_23.y, s_20, nylerp_21));
  s_20 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = -(s_20);
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = s_20;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_29 * tmpvar_23.xzy), (tmpvar_30 * tmpvar_23.zxy), vec3(zxlerp_22));
  detailCoords_19 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = s_20;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), detailCoords_19, vec3(nylerp_21));
  detailCoords_19 = tmpvar_33;
  uv_18 = (((
    (0.5 * detailCoords_19.yz)
   / 
    abs(detailCoords_19.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_34;
  uv_34 = uv_18;
  highp vec2 uvCont_35;
  highp vec2 tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = (0.5 * _CityOverlayDetailScale);
  tmpvar_36 = abs((uv_34 - tmpvar_37));
  uvCont_35.x = max (tmpvar_36.x, tmpvar_36.y);
  uvCont_35.y = min (tmpvar_36.x, tmpvar_36.y);
  highp vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_35);
  tmpvar_38.zw = dFdy(uvCont_35);
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_18, tmpvar_38.xy, tmpvar_38.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  citydarkoverlaydetail_3.xyz = tmpvar_40.xyz;
  mediump vec2 uv_41;
  mediump vec3 detailCoords_42;
  mediump float s_43;
  mediump float nylerp_44;
  mediump float zxlerp_45;
  highp vec3 tmpvar_46;
  tmpvar_46 = abs(tmpvar_23);
  highp float tmpvar_47;
  tmpvar_47 = float((tmpvar_46.z >= tmpvar_46.x));
  zxlerp_45 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = float((max (tmpvar_46.x, tmpvar_46.z) >= tmpvar_46.y));
  nylerp_44 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_45);
  s_43 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_23.y, s_43, nylerp_44));
  s_43 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(s_43);
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = s_43;
  highp vec3 tmpvar_53;
  tmpvar_53 = mix ((tmpvar_51 * tmpvar_23.xzy), (tmpvar_52 * tmpvar_23.zxy), vec3(zxlerp_45));
  detailCoords_42 = tmpvar_53;
  mediump vec3 tmpvar_54;
  tmpvar_54.xy = vec2(1.0, 1.0);
  tmpvar_54.z = s_43;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_54 * tmpvar_23.yxz), detailCoords_42, vec3(nylerp_44));
  detailCoords_42 = tmpvar_55;
  uv_41 = (((
    (0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_56;
  uv_56 = uv_41;
  highp vec2 uvCont_57;
  highp vec2 tmpvar_58;
  tmpvar_58 = abs((uv_56 - tmpvar_37));
  uvCont_57.x = max (tmpvar_58.x, tmpvar_58.y);
  uvCont_57.y = min (tmpvar_58.x, tmpvar_58.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_57);
  tmpvar_59.zw = dFdy(uvCont_57);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_41, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citylightoverlaydetail_2.xyz = tmpvar_61.xyz;
  highp float tmpvar_62;
  tmpvar_62 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_15 * (1.0 - tmpvar_62));
  citydarkoverlaydetail_3.w = (tmpvar_40.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_61.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_61.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_63;
  lightDir_63 = _SunDir;
  mediump vec3 viewDir_64;
  viewDir_64 = xlv_TEXCOORD7;
  mediump vec3 normal_65;
  normal_65 = xlv_TEXCOORD4;
  mediump vec4 c_66;
  mediump vec3 tmpvar_67;
  tmpvar_67 = normalize(lightDir_63);
  lightDir_63 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68 = normalize(viewDir_64);
  viewDir_64 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69 = normalize(normal_65);
  normal_65 = tmpvar_69;
  mediump float tmpvar_70;
  tmpvar_70 = dot (tmpvar_69, tmpvar_67);
  highp float tmpvar_71;
  mediump float tmpvar_72;
  tmpvar_72 = clamp (dot (normalize(
    (tmpvar_67 + tmpvar_68)
  ), tmpvar_69), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = (pow (tmpvar_71, _SpecularPower) * _SpecularColor.w);
  c_66.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_70) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_73)) * 2.0);
  c_66.w = (tmpvar_70 * 2.0);
  highp vec3 tmpvar_74;
  tmpvar_74 = normalize(_SunDir);
  mediump vec3 lightDir_75;
  lightDir_75 = tmpvar_74;
  mediump vec3 normal_76;
  normal_76 = xlv_TEXCOORD4;
  mediump float tmpvar_77;
  tmpvar_77 = dot (normal_76, lightDir_75);
  color_5 = (c_66 * mix (1.0, clamp (
    floor((1.01 + tmpvar_77))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_77))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_78;
  tmpvar_78 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_78.xyz;
  color_5.w = (tmpvar_78.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec2 t3;
bool tb3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp vec3 t8;
mediump vec3 t16_9;
highp float t11;
highp int ti11;
bvec2 tb11;
highp vec2 t16;
mediump float t16_17;
highp float t19;
bool tb19;
highp float t20;
mediump float t16_25;
highp float t27;
highp int ti27;
bool tb27;
highp float t28;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_9.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_9.x = floor(t16_9.x);
    t16_9.x = clamp(t16_9.x, 0.0, 1.0);
    t16_9.x = t16_9.x + -1.0;
    t16_1.x = t16_1.x * t16_9.x + 1.0;
    t16_9.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_9.x = inversesqrt(t16_9.x);
    t16_9.xyz = t16_9.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_9.x = dot(t16_2.xyz, t16_9.xyz);
    t16_9.x = t16_9.x + t16_9.x;
    t16_1.x = t16_1.x * t16_9.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t8.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t8.z), abs(t8.y));
    t3.x = float(1.0) / t3.x;
    t11 = min(abs(t8.z), abs(t8.y));
    t3.x = t3.x * t11;
    t11 = t3.x * t3.x;
    t19 = t11 * 0.0208350997 + -0.0851330012;
    t19 = t11 * t19 + 0.180141002;
    t19 = t11 * t19 + -0.330299497;
    t11 = t11 * t19 + 0.999866009;
    t19 = t11 * t3.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb27 = abs(t8.z)<abs(t8.y);
    t19 = tb27 ? t19 : float(0.0);
    t3.x = t3.x * t11 + t19;
    tb11.xy = lessThan(t8.zxzz, (-t8.zxzz)).xy;
    t11 = tb11.x ? -3.14159274 : float(0.0);
    t3.x = t11 + t3.x;
    t11 = min(t8.z, t8.y);
    tb11.x = t11<(-t11);
    t27 = max(t8.z, t8.y);
    tb27 = t27>=(-t27);
    ti11 = int(uint(tb27) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t3.x = (ti11 != 0) ? (-t3.x) : t3.x;
    t11 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t11);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t27 = abs(t8.x) * -0.0187292993 + 0.0742610022;
    t27 = t27 * abs(t8.x) + -0.212114394;
    t27 = t27 * abs(t8.x) + 1.57072878;
    t20 = -abs(t8.x) + 1.0;
    t20 = sqrt(t20);
    t28 = t27 * t20;
    t28 = t28 * -2.0 + 3.14159274;
    t19 = tb11.y ? t28 : float(0.0);
    t19 = t27 * t20 + t19;
    t4.y = t19 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_2 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t16_9.xy = t10_2.xy * alphaMask1.xy;
    t16_9.x = t16_9.y + t16_9.x;
    t16_9.x = t10_2.z * alphaMask1.z + t16_9.x;
    t16_9.x = t10_2.w * alphaMask1.w + t16_9.x;
    tb3 = 0.0>=vs_TEXCOORD0.w;
    t3.x = (tb3) ? 0.0 : 1.0;
    t3.x = t16_9.x * t3.x;
    t11 = vs_TEXCOORD5.z * t0.x + (-t8.y);
    tb19 = abs(t8.z)>=abs(t8.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t11 = t19 * t11 + t8.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t11;
    t11 = max(abs(t8.z), abs(t8.y));
    tb11.x = t11>=abs(t8.x);
    t11 = tb11.x ? 1.0 : float(0.0);
    t0.x = t11 * t0.x + t8.x;
    ti27 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti27) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t8.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t5.xyz = t16_6.xyz * t8.zyx + (-t4.xyz);
    t4.xyz = vec3(t19) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_6.xxy) * t8.xyz + t4.xyz;
    t0.xyz = t8.xyz * t16_6.xxy;
    t0.xyz = vec3(t11) * t4.xyz + t0.xyz;
    t16_9.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_9.xy = t16_9.xy / abs(t0.xx);
    t16_9.xy = t16_9.xy + vec2(0.5, 0.5);
    t0.xy = t16_9.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t16.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t0.xy;
    t11 = max(abs(t16.y), abs(t16.x));
    t16.x = min(abs(t16.y), abs(t16.x));
    t4.x = dFdx(t11);
    t5.x = dFdy(t11);
    t4.y = dFdx(t16.x);
    t5.y = dFdy(t16.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_9.x = t3.x * t10_2.w;
    t16_17 = t3.x * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_2.xyz;
    t16_25 = t16_9.x * t16_1.x + (-t16_17);
    t16_1.x = t16_1.x * t16_9.x;
    t16_9.x = t16_1.x * t16_25 + t16_17;
    t16_1.xzw = t16_1.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_9.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
vec2 t12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t18 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t18 + 1.00999999;
    t18 = t18 * -10.0;
    t18 = clamp(t18, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t18 = t18 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t18 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12.x = max(abs(t1.z), abs(t1.y));
    t12.x = float(1.0) / t12.x;
    t18 = min(abs(t1.z), abs(t1.y));
    t12.x = t12.x * t18;
    t18 = t12.x * t12.x;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12.x = t18 + t12.x;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12.x = (ti18 != 0) ? (-t12.x) : t12.x;
    t18 = t12.x * 0.159154937;
    t3.x = t12.x * 0.159154937 + 0.5;
    t12.x = abs(t18);
    t4.x = dFdx(t12.x);
    t5.x = dFdy(t12.x);
    t12.x = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12.x = t12.x * abs(t1.x) + -0.212114394;
    t12.x = t12.x * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    t3.y = t12.x * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t12.xy = t10_2.xy * alphaMask1.xy;
    t12.x = t12.y + t12.x;
    t12.x = t10_2.z * alphaMask1.z + t12.x;
    t12.x = t10_2.w * alphaMask1.w + t12.x;
    tb18 = 0.0>=vs_TEXCOORD0.w;
    t18 = (tb18) ? 0.0 : 1.0;
    t12.x = t18 * t12.x;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12.x * t1.w;
    t2.w = t12.x * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 171 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  float tmpvar_12;
  vec4 v_13;
  v_13 = (texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw) * alphaMask1);
  tmpvar_12 = ((v_13.x + v_13.y) + (v_13.z + v_13.w));
  vec4 tmpvar_14;
  tmpvar_14.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_14.w = tmpvar_12;
  cityoverlay_3.xyz = tmpvar_14.xyz;
  vec2 uv_15;
  vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_16);
  float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  float tmpvar_20;
  tmpvar_20 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_18), tmpvar_19));
  vec3 tmpvar_21;
  tmpvar_21.xz = vec2(1.0, -1.0);
  tmpvar_21.y = -(tmpvar_20);
  vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = tmpvar_20;
  vec3 tmpvar_23;
  tmpvar_23.xy = vec2(1.0, 1.0);
  tmpvar_23.z = tmpvar_20;
  vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_23 * tmpvar_16.yxz), mix ((tmpvar_21 * tmpvar_16.xzy), (tmpvar_22 * tmpvar_16.zxy), vec3(tmpvar_18)), vec3(tmpvar_19));
  uv_15 = (((
    (0.5 * tmpvar_24.yz)
   / 
    abs(tmpvar_24.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_25;
  vec2 tmpvar_26;
  float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_15 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  vec4 tmpvar_29;
  tmpvar_29 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_15, tmpvar_28.xy, tmpvar_28.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_29.xyz;
  vec2 uv_30;
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_16);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_16.yxz), mix ((tmpvar_35 * tmpvar_16.xzy), (tmpvar_36 * tmpvar_16.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_30 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  tmpvar_40 = abs((uv_30 - tmpvar_27));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_41;
  tmpvar_41.xy = dFdx(uvCont_39);
  tmpvar_41.zw = dFdy(uvCont_39);
  vec4 tmpvar_42;
  tmpvar_42 = texture2DGradARB (_CityLightOverlayDetailTex, uv_30, tmpvar_41.xy, tmpvar_41.zw);
  citylightoverlaydetail_1.xyz = tmpvar_42.xyz;
  cityoverlay_3.w = (tmpvar_12 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_29.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_42.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_42.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_43;
  tmpvar_43 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_44;
  vec3 tmpvar_45;
  tmpvar_45 = normalize(_SunDir);
  vec3 tmpvar_46;
  tmpvar_46 = normalize(xlv_TEXCOORD4);
  float tmpvar_47;
  tmpvar_47 = dot (tmpvar_46, tmpvar_45);
  c_44.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_47) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_45 + normalize(xlv_TEXCOORD7)))
    , tmpvar_46), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_43.x * 2.0));
  c_44.w = (tmpvar_47 * (tmpvar_43.x * 2.0));
  float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD4, tmpvar_45);
  color_4 = (c_44 * mix (1.0, clamp (
    floor((1.01 + tmpvar_48))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_48))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_49;
  tmpvar_49 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_49.xyz;
  color_4.w = (tmpvar_49.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 176 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  mediump float tmpvar_15;
  mediump vec4 v_16;
  v_16 = (tmpvar_14 * alphaMask1);
  tmpvar_15 = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  mediump vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = tmpvar_15;
  cityoverlay_4.xyz = tmpvar_17.xyz;
  mediump vec2 uv_18;
  mediump vec3 detailCoords_19;
  mediump float s_20;
  mediump float nylerp_21;
  mediump float zxlerp_22;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  zxlerp_22 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  nylerp_21 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_22);
  s_20 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = sign(mix (tmpvar_23.y, s_20, nylerp_21));
  s_20 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = -(s_20);
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = s_20;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_29 * tmpvar_23.xzy), (tmpvar_30 * tmpvar_23.zxy), vec3(zxlerp_22));
  detailCoords_19 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = s_20;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), detailCoords_19, vec3(nylerp_21));
  detailCoords_19 = tmpvar_33;
  uv_18 = (((
    (0.5 * detailCoords_19.yz)
   / 
    abs(detailCoords_19.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_34;
  uv_34 = uv_18;
  highp vec2 uvCont_35;
  highp vec2 tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = (0.5 * _CityOverlayDetailScale);
  tmpvar_36 = abs((uv_34 - tmpvar_37));
  uvCont_35.x = max (tmpvar_36.x, tmpvar_36.y);
  uvCont_35.y = min (tmpvar_36.x, tmpvar_36.y);
  highp vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_35);
  tmpvar_38.zw = dFdy(uvCont_35);
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_18, tmpvar_38.xy, tmpvar_38.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  citydarkoverlaydetail_3.xyz = tmpvar_40.xyz;
  mediump vec2 uv_41;
  mediump vec3 detailCoords_42;
  mediump float s_43;
  mediump float nylerp_44;
  mediump float zxlerp_45;
  highp vec3 tmpvar_46;
  tmpvar_46 = abs(tmpvar_23);
  highp float tmpvar_47;
  tmpvar_47 = float((tmpvar_46.z >= tmpvar_46.x));
  zxlerp_45 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = float((max (tmpvar_46.x, tmpvar_46.z) >= tmpvar_46.y));
  nylerp_44 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_45);
  s_43 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_23.y, s_43, nylerp_44));
  s_43 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(s_43);
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = s_43;
  highp vec3 tmpvar_53;
  tmpvar_53 = mix ((tmpvar_51 * tmpvar_23.xzy), (tmpvar_52 * tmpvar_23.zxy), vec3(zxlerp_45));
  detailCoords_42 = tmpvar_53;
  mediump vec3 tmpvar_54;
  tmpvar_54.xy = vec2(1.0, 1.0);
  tmpvar_54.z = s_43;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_54 * tmpvar_23.yxz), detailCoords_42, vec3(nylerp_44));
  detailCoords_42 = tmpvar_55;
  uv_41 = (((
    (0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_56;
  uv_56 = uv_41;
  highp vec2 uvCont_57;
  highp vec2 tmpvar_58;
  tmpvar_58 = abs((uv_56 - tmpvar_37));
  uvCont_57.x = max (tmpvar_58.x, tmpvar_58.y);
  uvCont_57.y = min (tmpvar_58.x, tmpvar_58.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_57);
  tmpvar_59.zw = dFdy(uvCont_57);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_41, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citylightoverlaydetail_2.xyz = tmpvar_61.xyz;
  highp float tmpvar_62;
  tmpvar_62 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_15 * (1.0 - tmpvar_62));
  citydarkoverlaydetail_3.w = (tmpvar_40.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_61.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_61.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_63 = tmpvar_64;
  mediump vec3 lightDir_65;
  lightDir_65 = _SunDir;
  mediump vec3 viewDir_66;
  viewDir_66 = xlv_TEXCOORD7;
  mediump vec3 normal_67;
  normal_67 = xlv_TEXCOORD4;
  mediump float atten_68;
  atten_68 = tmpvar_63;
  mediump vec4 c_69;
  mediump vec3 tmpvar_70;
  tmpvar_70 = normalize(lightDir_65);
  lightDir_65 = tmpvar_70;
  mediump vec3 tmpvar_71;
  tmpvar_71 = normalize(viewDir_66);
  viewDir_66 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72 = normalize(normal_67);
  normal_67 = tmpvar_72;
  mediump float tmpvar_73;
  tmpvar_73 = dot (tmpvar_72, tmpvar_70);
  highp float tmpvar_74;
  mediump float tmpvar_75;
  tmpvar_75 = clamp (dot (normalize(
    (tmpvar_70 + tmpvar_71)
  ), tmpvar_72), 0.0, 1.0);
  tmpvar_74 = tmpvar_75;
  highp float tmpvar_76;
  tmpvar_76 = (pow (tmpvar_74, _SpecularPower) * _SpecularColor.w);
  c_69.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_73) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_76)) * (atten_68 * 2.0));
  c_69.w = (tmpvar_73 * (atten_68 * 2.0));
  highp vec3 tmpvar_77;
  tmpvar_77 = normalize(_SunDir);
  mediump vec3 lightDir_78;
  lightDir_78 = tmpvar_77;
  mediump vec3 normal_79;
  normal_79 = xlv_TEXCOORD4;
  mediump float tmpvar_80;
  tmpvar_80 = dot (normal_79, lightDir_78);
  color_5 = (c_69 * mix (1.0, clamp (
    floor((1.01 + tmpvar_80))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_80))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_81;
  tmpvar_81 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_81.xyz;
  color_5.w = (tmpvar_81.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
vec2 t12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t18 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t12.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t12.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t12.x = t6.x + 1.00999999;
    t6.x = t6.x * -10.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t12.x = floor(t12.x);
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = t6.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12.x = max(abs(t1.z), abs(t1.y));
    t12.x = float(1.0) / t12.x;
    t18 = min(abs(t1.z), abs(t1.y));
    t12.x = t12.x * t18;
    t18 = t12.x * t12.x;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12.x = t18 + t12.x;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12.x = (ti18 != 0) ? (-t12.x) : t12.x;
    t18 = t12.x * 0.159154937;
    t3.x = t12.x * 0.159154937 + 0.5;
    t12.x = abs(t18);
    t4.x = dFdx(t12.x);
    t5.x = dFdy(t12.x);
    t12.x = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12.x = t12.x * abs(t1.x) + -0.212114394;
    t12.x = t12.x * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    t3.y = t12.x * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t12.xy = t10_2.xy * alphaMask1.xy;
    t12.x = t12.y + t12.x;
    t12.x = t10_2.z * alphaMask1.z + t12.x;
    t12.x = t10_2.w * alphaMask1.w + t12.x;
    tb18 = 0.0>=vs_TEXCOORD0.w;
    t18 = (tb18) ? 0.0 : 1.0;
    t12.x = t18 * t12.x;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12.x * t1.w;
    t2.w = t12.x * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 169 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  float tmpvar_12;
  vec4 v_13;
  v_13 = (texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw) * alphaMask1);
  tmpvar_12 = ((v_13.x + v_13.y) + (v_13.z + v_13.w));
  vec4 tmpvar_14;
  tmpvar_14.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_14.w = tmpvar_12;
  cityoverlay_3.xyz = tmpvar_14.xyz;
  vec2 uv_15;
  vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_16);
  float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  float tmpvar_20;
  tmpvar_20 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_18), tmpvar_19));
  vec3 tmpvar_21;
  tmpvar_21.xz = vec2(1.0, -1.0);
  tmpvar_21.y = -(tmpvar_20);
  vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = tmpvar_20;
  vec3 tmpvar_23;
  tmpvar_23.xy = vec2(1.0, 1.0);
  tmpvar_23.z = tmpvar_20;
  vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_23 * tmpvar_16.yxz), mix ((tmpvar_21 * tmpvar_16.xzy), (tmpvar_22 * tmpvar_16.zxy), vec3(tmpvar_18)), vec3(tmpvar_19));
  uv_15 = (((
    (0.5 * tmpvar_24.yz)
   / 
    abs(tmpvar_24.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_25;
  vec2 tmpvar_26;
  float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_15 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  vec4 tmpvar_29;
  tmpvar_29 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_15, tmpvar_28.xy, tmpvar_28.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_29.xyz;
  vec2 uv_30;
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_16);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_16.yxz), mix ((tmpvar_35 * tmpvar_16.xzy), (tmpvar_36 * tmpvar_16.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_30 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  tmpvar_40 = abs((uv_30 - tmpvar_27));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_41;
  tmpvar_41.xy = dFdx(uvCont_39);
  tmpvar_41.zw = dFdy(uvCont_39);
  vec4 tmpvar_42;
  tmpvar_42 = texture2DGradARB (_CityLightOverlayDetailTex, uv_30, tmpvar_41.xy, tmpvar_41.zw);
  citylightoverlaydetail_1.xyz = tmpvar_42.xyz;
  cityoverlay_3.w = (tmpvar_12 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_29.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_42.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_42.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_43;
  vec3 tmpvar_44;
  tmpvar_44 = normalize(_SunDir);
  vec3 tmpvar_45;
  tmpvar_45 = normalize(xlv_TEXCOORD4);
  float tmpvar_46;
  tmpvar_46 = dot (tmpvar_45, tmpvar_44);
  c_43.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_46) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_44 + normalize(xlv_TEXCOORD7)))
    , tmpvar_45), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_43.w = (tmpvar_46 * 2.0);
  float tmpvar_47;
  tmpvar_47 = dot (xlv_TEXCOORD4, tmpvar_44);
  color_4 = (c_43 * mix (1.0, clamp (
    floor((1.01 + tmpvar_47))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_47))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_48;
  tmpvar_48 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_48.xyz;
  color_4.w = (tmpvar_48.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 170 math, 3 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  mediump float tmpvar_15;
  mediump vec4 v_16;
  v_16 = (tmpvar_14 * alphaMask1);
  tmpvar_15 = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  mediump vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = tmpvar_15;
  cityoverlay_4.xyz = tmpvar_17.xyz;
  mediump vec2 uv_18;
  mediump vec3 detailCoords_19;
  mediump float s_20;
  mediump float nylerp_21;
  mediump float zxlerp_22;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  zxlerp_22 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  nylerp_21 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_22);
  s_20 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = sign(mix (tmpvar_23.y, s_20, nylerp_21));
  s_20 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = -(s_20);
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = s_20;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_29 * tmpvar_23.xzy), (tmpvar_30 * tmpvar_23.zxy), vec3(zxlerp_22));
  detailCoords_19 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = s_20;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), detailCoords_19, vec3(nylerp_21));
  detailCoords_19 = tmpvar_33;
  uv_18 = (((
    (0.5 * detailCoords_19.yz)
   / 
    abs(detailCoords_19.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_34;
  uv_34 = uv_18;
  highp vec2 uvCont_35;
  highp vec2 tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = (0.5 * _CityOverlayDetailScale);
  tmpvar_36 = abs((uv_34 - tmpvar_37));
  uvCont_35.x = max (tmpvar_36.x, tmpvar_36.y);
  uvCont_35.y = min (tmpvar_36.x, tmpvar_36.y);
  highp vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_35);
  tmpvar_38.zw = dFdy(uvCont_35);
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_18, tmpvar_38.xy, tmpvar_38.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  citydarkoverlaydetail_3.xyz = tmpvar_40.xyz;
  mediump vec2 uv_41;
  mediump vec3 detailCoords_42;
  mediump float s_43;
  mediump float nylerp_44;
  mediump float zxlerp_45;
  highp vec3 tmpvar_46;
  tmpvar_46 = abs(tmpvar_23);
  highp float tmpvar_47;
  tmpvar_47 = float((tmpvar_46.z >= tmpvar_46.x));
  zxlerp_45 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = float((max (tmpvar_46.x, tmpvar_46.z) >= tmpvar_46.y));
  nylerp_44 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_45);
  s_43 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_23.y, s_43, nylerp_44));
  s_43 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(s_43);
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = s_43;
  highp vec3 tmpvar_53;
  tmpvar_53 = mix ((tmpvar_51 * tmpvar_23.xzy), (tmpvar_52 * tmpvar_23.zxy), vec3(zxlerp_45));
  detailCoords_42 = tmpvar_53;
  mediump vec3 tmpvar_54;
  tmpvar_54.xy = vec2(1.0, 1.0);
  tmpvar_54.z = s_43;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_54 * tmpvar_23.yxz), detailCoords_42, vec3(nylerp_44));
  detailCoords_42 = tmpvar_55;
  uv_41 = (((
    (0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_56;
  uv_56 = uv_41;
  highp vec2 uvCont_57;
  highp vec2 tmpvar_58;
  tmpvar_58 = abs((uv_56 - tmpvar_37));
  uvCont_57.x = max (tmpvar_58.x, tmpvar_58.y);
  uvCont_57.y = min (tmpvar_58.x, tmpvar_58.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_57);
  tmpvar_59.zw = dFdy(uvCont_57);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_41, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citylightoverlaydetail_2.xyz = tmpvar_61.xyz;
  highp float tmpvar_62;
  tmpvar_62 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_15 * (1.0 - tmpvar_62));
  citydarkoverlaydetail_3.w = (tmpvar_40.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_61.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_61.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_63;
  lightDir_63 = _SunDir;
  mediump vec3 viewDir_64;
  viewDir_64 = xlv_TEXCOORD7;
  mediump vec3 normal_65;
  normal_65 = xlv_TEXCOORD4;
  mediump vec4 c_66;
  mediump vec3 tmpvar_67;
  tmpvar_67 = normalize(lightDir_63);
  lightDir_63 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68 = normalize(viewDir_64);
  viewDir_64 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69 = normalize(normal_65);
  normal_65 = tmpvar_69;
  mediump float tmpvar_70;
  tmpvar_70 = dot (tmpvar_69, tmpvar_67);
  highp float tmpvar_71;
  mediump float tmpvar_72;
  tmpvar_72 = clamp (dot (normalize(
    (tmpvar_67 + tmpvar_68)
  ), tmpvar_69), 0.0, 1.0);
  tmpvar_71 = tmpvar_72;
  highp float tmpvar_73;
  tmpvar_73 = (pow (tmpvar_71, _SpecularPower) * _SpecularColor.w);
  c_66.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_70) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_73)) * 2.0);
  c_66.w = (tmpvar_70 * 2.0);
  highp vec3 tmpvar_74;
  tmpvar_74 = normalize(_SunDir);
  mediump vec3 lightDir_75;
  lightDir_75 = tmpvar_74;
  mediump vec3 normal_76;
  normal_76 = xlv_TEXCOORD4;
  mediump float tmpvar_77;
  tmpvar_77 = dot (normal_76, lightDir_75);
  color_5 = (c_66 * mix (1.0, clamp (
    floor((1.01 + tmpvar_77))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_77))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_78;
  tmpvar_78 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_78.xyz;
  color_5.w = (tmpvar_78.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec2 t3;
bool tb3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
highp vec3 t8;
mediump vec3 t16_9;
highp float t11;
highp int ti11;
bvec2 tb11;
highp vec2 t16;
mediump float t16_17;
highp float t19;
bool tb19;
highp float t20;
mediump float t16_25;
highp float t27;
highp int ti27;
bool tb27;
highp float t28;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_9.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_9.x = floor(t16_9.x);
    t16_9.x = clamp(t16_9.x, 0.0, 1.0);
    t16_9.x = t16_9.x + -1.0;
    t16_1.x = t16_1.x * t16_9.x + 1.0;
    t16_9.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_9.x = inversesqrt(t16_9.x);
    t16_9.xyz = t16_9.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_9.x = dot(t16_2.xyz, t16_9.xyz);
    t16_9.x = t16_9.x + t16_9.x;
    t16_1.x = t16_1.x * t16_9.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t8.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t8.z), abs(t8.y));
    t3.x = float(1.0) / t3.x;
    t11 = min(abs(t8.z), abs(t8.y));
    t3.x = t3.x * t11;
    t11 = t3.x * t3.x;
    t19 = t11 * 0.0208350997 + -0.0851330012;
    t19 = t11 * t19 + 0.180141002;
    t19 = t11 * t19 + -0.330299497;
    t11 = t11 * t19 + 0.999866009;
    t19 = t11 * t3.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb27 = abs(t8.z)<abs(t8.y);
    t19 = tb27 ? t19 : float(0.0);
    t3.x = t3.x * t11 + t19;
    tb11.xy = lessThan(t8.zxzz, (-t8.zxzz)).xy;
    t11 = tb11.x ? -3.14159274 : float(0.0);
    t3.x = t11 + t3.x;
    t11 = min(t8.z, t8.y);
    tb11.x = t11<(-t11);
    t27 = max(t8.z, t8.y);
    tb27 = t27>=(-t27);
    ti11 = int(uint(tb27) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t3.x = (ti11 != 0) ? (-t3.x) : t3.x;
    t11 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t11);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t27 = abs(t8.x) * -0.0187292993 + 0.0742610022;
    t27 = t27 * abs(t8.x) + -0.212114394;
    t27 = t27 * abs(t8.x) + 1.57072878;
    t20 = -abs(t8.x) + 1.0;
    t20 = sqrt(t20);
    t28 = t27 * t20;
    t28 = t28 * -2.0 + 3.14159274;
    t19 = tb11.y ? t28 : float(0.0);
    t19 = t27 * t20 + t19;
    t4.y = t19 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_2 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t16_9.xy = t10_2.xy * alphaMask1.xy;
    t16_9.x = t16_9.y + t16_9.x;
    t16_9.x = t10_2.z * alphaMask1.z + t16_9.x;
    t16_9.x = t10_2.w * alphaMask1.w + t16_9.x;
    tb3 = 0.0>=vs_TEXCOORD0.w;
    t3.x = (tb3) ? 0.0 : 1.0;
    t3.x = t16_9.x * t3.x;
    t11 = vs_TEXCOORD5.z * t0.x + (-t8.y);
    tb19 = abs(t8.z)>=abs(t8.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t11 = t19 * t11 + t8.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t11;
    t11 = max(abs(t8.z), abs(t8.y));
    tb11.x = t11>=abs(t8.x);
    t11 = tb11.x ? 1.0 : float(0.0);
    t0.x = t11 * t0.x + t8.x;
    ti27 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti27) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t8.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t5.xyz = t16_6.xyz * t8.zyx + (-t4.xyz);
    t4.xyz = vec3(t19) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_6.xxy) * t8.xyz + t4.xyz;
    t0.xyz = t8.xyz * t16_6.xxy;
    t0.xyz = vec3(t11) * t4.xyz + t0.xyz;
    t16_9.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_9.xy = t16_9.xy / abs(t0.xx);
    t16_9.xy = t16_9.xy + vec2(0.5, 0.5);
    t0.xy = t16_9.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t16.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t0.xy;
    t11 = max(abs(t16.y), abs(t16.x));
    t16.x = min(abs(t16.y), abs(t16.x));
    t4.x = dFdx(t11);
    t5.x = dFdy(t11);
    t4.y = dFdx(t16.x);
    t5.y = dFdy(t16.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_9.x = t3.x * t10_2.w;
    t16_17 = t3.x * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_2.xyz;
    t16_25 = t16_9.x * t16_1.x + (-t16_17);
    t16_1.x = t16_1.x * t16_9.x;
    t16_9.x = t16_1.x * t16_25 + t16_17;
    t16_1.xzw = t16_1.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_9.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
vec2 t12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t18 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t18 + 1.00999999;
    t18 = t18 * -10.0;
    t18 = clamp(t18, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t18 = t18 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t18 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12.x = max(abs(t1.z), abs(t1.y));
    t12.x = float(1.0) / t12.x;
    t18 = min(abs(t1.z), abs(t1.y));
    t12.x = t12.x * t18;
    t18 = t12.x * t12.x;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12.x = t18 + t12.x;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12.x = (ti18 != 0) ? (-t12.x) : t12.x;
    t18 = t12.x * 0.159154937;
    t3.x = t12.x * 0.159154937 + 0.5;
    t12.x = abs(t18);
    t4.x = dFdx(t12.x);
    t5.x = dFdy(t12.x);
    t12.x = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12.x = t12.x * abs(t1.x) + -0.212114394;
    t12.x = t12.x * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    t3.y = t12.x * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t12.xy = t10_2.xy * alphaMask1.xy;
    t12.x = t12.y + t12.x;
    t12.x = t10_2.z * alphaMask1.z + t12.x;
    t12.x = t10_2.w * alphaMask1.w + t12.x;
    tb18 = 0.0>=vs_TEXCOORD0.w;
    t18 = (tb18) ? 0.0 : 1.0;
    t12.x = t18 * t12.x;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12.x * t1.w;
    t2.w = t12.x * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 171 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  float tmpvar_12;
  vec4 v_13;
  v_13 = (texture2DGradARB (_CityOverlayTex, uv_6, tmpvar_11.xy, tmpvar_11.zw) * alphaMask1);
  tmpvar_12 = ((v_13.x + v_13.y) + (v_13.z + v_13.w));
  vec4 tmpvar_14;
  tmpvar_14.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_14.w = tmpvar_12;
  cityoverlay_3.xyz = tmpvar_14.xyz;
  vec2 uv_15;
  vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_16);
  float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  float tmpvar_20;
  tmpvar_20 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_18), tmpvar_19));
  vec3 tmpvar_21;
  tmpvar_21.xz = vec2(1.0, -1.0);
  tmpvar_21.y = -(tmpvar_20);
  vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = tmpvar_20;
  vec3 tmpvar_23;
  tmpvar_23.xy = vec2(1.0, 1.0);
  tmpvar_23.z = tmpvar_20;
  vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_23 * tmpvar_16.yxz), mix ((tmpvar_21 * tmpvar_16.xzy), (tmpvar_22 * tmpvar_16.zxy), vec3(tmpvar_18)), vec3(tmpvar_19));
  uv_15 = (((
    (0.5 * tmpvar_24.yz)
   / 
    abs(tmpvar_24.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_25;
  vec2 tmpvar_26;
  float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_15 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  vec4 tmpvar_29;
  tmpvar_29 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_15, tmpvar_28.xy, tmpvar_28.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_29.xyz;
  vec2 uv_30;
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_16);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_16.y, mix (tmpvar_16.x, tmpvar_16.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_16.yxz), mix ((tmpvar_35 * tmpvar_16.xzy), (tmpvar_36 * tmpvar_16.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_30 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  tmpvar_40 = abs((uv_30 - tmpvar_27));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_41;
  tmpvar_41.xy = dFdx(uvCont_39);
  tmpvar_41.zw = dFdy(uvCont_39);
  vec4 tmpvar_42;
  tmpvar_42 = texture2DGradARB (_CityLightOverlayDetailTex, uv_30, tmpvar_41.xy, tmpvar_41.zw);
  citylightoverlaydetail_1.xyz = tmpvar_42.xyz;
  cityoverlay_3.w = (tmpvar_12 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_29.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_42.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_42.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_43;
  tmpvar_43 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_44;
  vec3 tmpvar_45;
  tmpvar_45 = normalize(_SunDir);
  vec3 tmpvar_46;
  tmpvar_46 = normalize(xlv_TEXCOORD4);
  float tmpvar_47;
  tmpvar_47 = dot (tmpvar_46, tmpvar_45);
  c_44.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_47) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_45 + normalize(xlv_TEXCOORD7)))
    , tmpvar_46), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_43.x * 2.0));
  c_44.w = (tmpvar_47 * (tmpvar_43.x * 2.0));
  float tmpvar_48;
  tmpvar_48 = dot (xlv_TEXCOORD4, tmpvar_45);
  color_4 = (c_44 * mix (1.0, clamp (
    floor((1.01 + tmpvar_48))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_48))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_49;
  tmpvar_49 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_49.xyz;
  color_4.w = (tmpvar_49.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 176 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  mediump float tmpvar_15;
  mediump vec4 v_16;
  v_16 = (tmpvar_14 * alphaMask1);
  tmpvar_15 = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  mediump vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = tmpvar_15;
  cityoverlay_4.xyz = tmpvar_17.xyz;
  mediump vec2 uv_18;
  mediump vec3 detailCoords_19;
  mediump float s_20;
  mediump float nylerp_21;
  mediump float zxlerp_22;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  zxlerp_22 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  nylerp_21 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_22);
  s_20 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = sign(mix (tmpvar_23.y, s_20, nylerp_21));
  s_20 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = -(s_20);
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = s_20;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_29 * tmpvar_23.xzy), (tmpvar_30 * tmpvar_23.zxy), vec3(zxlerp_22));
  detailCoords_19 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = s_20;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), detailCoords_19, vec3(nylerp_21));
  detailCoords_19 = tmpvar_33;
  uv_18 = (((
    (0.5 * detailCoords_19.yz)
   / 
    abs(detailCoords_19.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_34;
  uv_34 = uv_18;
  highp vec2 uvCont_35;
  highp vec2 tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = (0.5 * _CityOverlayDetailScale);
  tmpvar_36 = abs((uv_34 - tmpvar_37));
  uvCont_35.x = max (tmpvar_36.x, tmpvar_36.y);
  uvCont_35.y = min (tmpvar_36.x, tmpvar_36.y);
  highp vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_35);
  tmpvar_38.zw = dFdy(uvCont_35);
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_18, tmpvar_38.xy, tmpvar_38.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  citydarkoverlaydetail_3.xyz = tmpvar_40.xyz;
  mediump vec2 uv_41;
  mediump vec3 detailCoords_42;
  mediump float s_43;
  mediump float nylerp_44;
  mediump float zxlerp_45;
  highp vec3 tmpvar_46;
  tmpvar_46 = abs(tmpvar_23);
  highp float tmpvar_47;
  tmpvar_47 = float((tmpvar_46.z >= tmpvar_46.x));
  zxlerp_45 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = float((max (tmpvar_46.x, tmpvar_46.z) >= tmpvar_46.y));
  nylerp_44 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_45);
  s_43 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_23.y, s_43, nylerp_44));
  s_43 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(s_43);
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = s_43;
  highp vec3 tmpvar_53;
  tmpvar_53 = mix ((tmpvar_51 * tmpvar_23.xzy), (tmpvar_52 * tmpvar_23.zxy), vec3(zxlerp_45));
  detailCoords_42 = tmpvar_53;
  mediump vec3 tmpvar_54;
  tmpvar_54.xy = vec2(1.0, 1.0);
  tmpvar_54.z = s_43;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_54 * tmpvar_23.yxz), detailCoords_42, vec3(nylerp_44));
  detailCoords_42 = tmpvar_55;
  uv_41 = (((
    (0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_56;
  uv_56 = uv_41;
  highp vec2 uvCont_57;
  highp vec2 tmpvar_58;
  tmpvar_58 = abs((uv_56 - tmpvar_37));
  uvCont_57.x = max (tmpvar_58.x, tmpvar_58.y);
  uvCont_57.y = min (tmpvar_58.x, tmpvar_58.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_57);
  tmpvar_59.zw = dFdy(uvCont_57);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_41, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citylightoverlaydetail_2.xyz = tmpvar_61.xyz;
  highp float tmpvar_62;
  tmpvar_62 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_15 * (1.0 - tmpvar_62));
  citydarkoverlaydetail_3.w = (tmpvar_40.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_61.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_61.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_63 = tmpvar_64;
  mediump vec3 lightDir_65;
  lightDir_65 = _SunDir;
  mediump vec3 viewDir_66;
  viewDir_66 = xlv_TEXCOORD7;
  mediump vec3 normal_67;
  normal_67 = xlv_TEXCOORD4;
  mediump float atten_68;
  atten_68 = tmpvar_63;
  mediump vec4 c_69;
  mediump vec3 tmpvar_70;
  tmpvar_70 = normalize(lightDir_65);
  lightDir_65 = tmpvar_70;
  mediump vec3 tmpvar_71;
  tmpvar_71 = normalize(viewDir_66);
  viewDir_66 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72 = normalize(normal_67);
  normal_67 = tmpvar_72;
  mediump float tmpvar_73;
  tmpvar_73 = dot (tmpvar_72, tmpvar_70);
  highp float tmpvar_74;
  mediump float tmpvar_75;
  tmpvar_75 = clamp (dot (normalize(
    (tmpvar_70 + tmpvar_71)
  ), tmpvar_72), 0.0, 1.0);
  tmpvar_74 = tmpvar_75;
  highp float tmpvar_76;
  tmpvar_76 = (pow (tmpvar_74, _SpecularPower) * _SpecularColor.w);
  c_69.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_73) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_76)) * (atten_68 * 2.0));
  c_69.w = (tmpvar_73 * (atten_68 * 2.0));
  highp vec3 tmpvar_77;
  tmpvar_77 = normalize(_SunDir);
  mediump vec3 lightDir_78;
  lightDir_78 = tmpvar_77;
  mediump vec3 normal_79;
  normal_79 = xlv_TEXCOORD4;
  mediump float tmpvar_80;
  tmpvar_80 = dot (normal_79, lightDir_78);
  color_5 = (c_69 * mix (1.0, clamp (
    floor((1.01 + tmpvar_80))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_80))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_81;
  tmpvar_81 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_81.xyz;
  color_5.w = (tmpvar_81.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec4 t2;
lowp vec4 t10_2;
int ti2;
bvec2 tb2;
vec3 t3;
vec3 t4;
vec2 t5;
vec3 t6;
int ti6;
vec2 t12;
float t18;
int ti18;
bool tb18;
float t19;
bool tb19;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t18 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t18 = inversesqrt(t18);
    t1.xyz = vec3(t18) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t6.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t12.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t12.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t12.x = t6.x + 1.00999999;
    t6.x = t6.x * -10.0;
    t6.x = clamp(t6.x, 0.0, 1.0);
    t12.x = floor(t12.x);
    t12.x = clamp(t12.x, 0.0, 1.0);
    t12.x = t12.x + -1.0;
    t6.x = t6.x * t12.x + 1.0;
    t0.x = t6.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t6.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t6.x = inversesqrt(t6.x);
    t1.xyz = t6.xxx * vs_TEXCOORD5.yxz;
    t12.x = max(abs(t1.z), abs(t1.y));
    t12.x = float(1.0) / t12.x;
    t18 = min(abs(t1.z), abs(t1.y));
    t12.x = t12.x * t18;
    t18 = t12.x * t12.x;
    t19 = t18 * 0.0208350997 + -0.0851330012;
    t19 = t18 * t19 + 0.180141002;
    t19 = t18 * t19 + -0.330299497;
    t18 = t18 * t19 + 0.999866009;
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb2.x = abs(t1.z)<abs(t1.y);
    t19 = tb2.x ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    tb2.xy = lessThan(t1.zxzz, (-t1.zxzz)).xy;
    t18 = tb2.x ? -3.14159274 : float(0.0);
    t12.x = t18 + t12.x;
    t18 = min(t1.z, t1.y);
    tb18 = t18<(-t18);
    t19 = max(t1.z, t1.y);
    tb19 = t19>=(-t19);
    ti18 = int(uint(tb18) * 0xffffffffu & uint(tb19) * 0xffffffffu);
    t12.x = (ti18 != 0) ? (-t12.x) : t12.x;
    t18 = t12.x * 0.159154937;
    t3.x = t12.x * 0.159154937 + 0.5;
    t12.x = abs(t18);
    t4.x = dFdx(t12.x);
    t5.x = dFdy(t12.x);
    t12.x = abs(t1.x) * -0.0187292993 + 0.0742610022;
    t12.x = t12.x * abs(t1.x) + -0.212114394;
    t12.x = t12.x * abs(t1.x) + 1.57072878;
    t18 = -abs(t1.x) + 1.0;
    t18 = sqrt(t18);
    t19 = t18 * t12.x;
    t19 = t19 * -2.0 + 3.14159274;
    t19 = tb2.y ? t19 : float(0.0);
    t12.x = t12.x * t18 + t19;
    t3.y = t12.x * 0.318309873;
    t4.y = dFdx(t3.y);
    t5.y = dFdy(t3.y);
    t10_2 = textureGrad(_CityOverlayTex, t3.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t12.xy = t10_2.xy * alphaMask1.xy;
    t12.x = t12.y + t12.x;
    t12.x = t10_2.z * alphaMask1.z + t12.x;
    t12.x = t10_2.w * alphaMask1.w + t12.x;
    tb18 = 0.0>=vs_TEXCOORD0.w;
    t18 = (tb18) ? 0.0 : 1.0;
    t12.x = t18 * t12.x;
    t18 = vs_TEXCOORD5.z * t6.x + (-t1.y);
    tb19 = abs(t1.z)>=abs(t1.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t18 = t19 * t18 + t1.y;
    t6.x = (-vs_TEXCOORD5.y) * t6.x + t18;
    t18 = max(abs(t1.z), abs(t1.y));
    tb18 = t18>=abs(t1.x);
    t18 = tb18 ? 1.0 : float(0.0);
    t6.x = t18 * t6.x + t1.x;
    ti2 = int((0.0<t6.x) ? 0xFFFFFFFFu : uint(0u));
    ti6 = int((t6.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti6 = (-ti2) + ti6;
    t2.y = float(ti6);
    t3.y = (-t2.y);
    t3.xz = vec2(1.0, -1.0);
    t3.xyz = t1.yzx * t3.xyz;
    t2.xz = vec2(1.0, -1.0);
    t4.xyz = t2.xyz * t1.zyx + (-t3.xyz);
    t3.xyz = vec3(t19) * t4.xyz + t3.xyz;
    t3.xyz = (-t2.xxy) * t1.xyz + t3.xyz;
    t1.xyz = t1.xyz * t2.xxy;
    t1.xyz = vec3(t18) * t3.xyz + t1.xyz;
    t6.xz = t1.yz * vec2(0.5, 0.5);
    t6.xz = t6.xz / abs(t1.xx);
    t6.xz = t6.xz + vec2(0.5, 0.5);
    t6.xz = t6.xz * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t6.xz;
    t1.z = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.xy = dFdx(t1.zx);
    t3.xy = dFdy(t1.zx);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t2 = textureGrad(_CityLightOverlayDetailTex, t6.xz, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t6.x = t12.x * t1.w;
    t2.w = t12.x * t2.w;
    t1.w = t0.x * t6.x;
    t0 = (-t2) + t1;
    t0 = t1.wwww * t0 + t2;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 175 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  mediump float tmpvar_15;
  mediump vec4 v_16;
  v_16 = (tmpvar_14 * alphaMask1);
  tmpvar_15 = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  mediump vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = tmpvar_15;
  cityoverlay_4.xyz = tmpvar_17.xyz;
  mediump vec2 uv_18;
  mediump vec3 detailCoords_19;
  mediump float s_20;
  mediump float nylerp_21;
  mediump float zxlerp_22;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  zxlerp_22 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  nylerp_21 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_22);
  s_20 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = sign(mix (tmpvar_23.y, s_20, nylerp_21));
  s_20 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = -(s_20);
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = s_20;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_29 * tmpvar_23.xzy), (tmpvar_30 * tmpvar_23.zxy), vec3(zxlerp_22));
  detailCoords_19 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = s_20;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), detailCoords_19, vec3(nylerp_21));
  detailCoords_19 = tmpvar_33;
  uv_18 = (((
    (0.5 * detailCoords_19.yz)
   / 
    abs(detailCoords_19.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_34;
  uv_34 = uv_18;
  highp vec2 uvCont_35;
  highp vec2 tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = (0.5 * _CityOverlayDetailScale);
  tmpvar_36 = abs((uv_34 - tmpvar_37));
  uvCont_35.x = max (tmpvar_36.x, tmpvar_36.y);
  uvCont_35.y = min (tmpvar_36.x, tmpvar_36.y);
  highp vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_35);
  tmpvar_38.zw = dFdy(uvCont_35);
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_18, tmpvar_38.xy, tmpvar_38.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  citydarkoverlaydetail_3.xyz = tmpvar_40.xyz;
  mediump vec2 uv_41;
  mediump vec3 detailCoords_42;
  mediump float s_43;
  mediump float nylerp_44;
  mediump float zxlerp_45;
  highp vec3 tmpvar_46;
  tmpvar_46 = abs(tmpvar_23);
  highp float tmpvar_47;
  tmpvar_47 = float((tmpvar_46.z >= tmpvar_46.x));
  zxlerp_45 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = float((max (tmpvar_46.x, tmpvar_46.z) >= tmpvar_46.y));
  nylerp_44 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_45);
  s_43 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_23.y, s_43, nylerp_44));
  s_43 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(s_43);
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = s_43;
  highp vec3 tmpvar_53;
  tmpvar_53 = mix ((tmpvar_51 * tmpvar_23.xzy), (tmpvar_52 * tmpvar_23.zxy), vec3(zxlerp_45));
  detailCoords_42 = tmpvar_53;
  mediump vec3 tmpvar_54;
  tmpvar_54.xy = vec2(1.0, 1.0);
  tmpvar_54.z = s_43;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_54 * tmpvar_23.yxz), detailCoords_42, vec3(nylerp_44));
  detailCoords_42 = tmpvar_55;
  uv_41 = (((
    (0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_56;
  uv_56 = uv_41;
  highp vec2 uvCont_57;
  highp vec2 tmpvar_58;
  tmpvar_58 = abs((uv_56 - tmpvar_37));
  uvCont_57.x = max (tmpvar_58.x, tmpvar_58.y);
  uvCont_57.y = min (tmpvar_58.x, tmpvar_58.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_57);
  tmpvar_59.zw = dFdy(uvCont_57);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_41, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citylightoverlaydetail_2.xyz = tmpvar_61.xyz;
  highp float tmpvar_62;
  tmpvar_62 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_15 * (1.0 - tmpvar_62));
  citydarkoverlaydetail_3.w = (tmpvar_40.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_61.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_61.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_63;
  shadow_63 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_64;
  lightDir_64 = _SunDir;
  mediump vec3 viewDir_65;
  viewDir_65 = xlv_TEXCOORD7;
  mediump vec3 normal_66;
  normal_66 = xlv_TEXCOORD4;
  mediump float atten_67;
  atten_67 = shadow_63;
  mediump vec4 c_68;
  mediump vec3 tmpvar_69;
  tmpvar_69 = normalize(lightDir_64);
  lightDir_64 = tmpvar_69;
  mediump vec3 tmpvar_70;
  tmpvar_70 = normalize(viewDir_65);
  viewDir_65 = tmpvar_70;
  mediump vec3 tmpvar_71;
  tmpvar_71 = normalize(normal_66);
  normal_66 = tmpvar_71;
  mediump float tmpvar_72;
  tmpvar_72 = dot (tmpvar_71, tmpvar_69);
  highp float tmpvar_73;
  mediump float tmpvar_74;
  tmpvar_74 = clamp (dot (normalize(
    (tmpvar_69 + tmpvar_70)
  ), tmpvar_71), 0.0, 1.0);
  tmpvar_73 = tmpvar_74;
  highp float tmpvar_75;
  tmpvar_75 = (pow (tmpvar_73, _SpecularPower) * _SpecularColor.w);
  c_68.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_72) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_75)) * (atten_67 * 2.0));
  c_68.w = (tmpvar_72 * (atten_67 * 2.0));
  highp vec3 tmpvar_76;
  tmpvar_76 = normalize(_SunDir);
  mediump vec3 lightDir_77;
  lightDir_77 = tmpvar_76;
  mediump vec3 normal_78;
  normal_78 = xlv_TEXCOORD4;
  mediump float tmpvar_79;
  tmpvar_79 = dot (normal_78, lightDir_77);
  color_5 = (c_68 * mix (1.0, clamp (
    floor((1.01 + tmpvar_79))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_79))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_80;
  tmpvar_80 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_80.xyz;
  color_5.w = (tmpvar_80.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp vec4 t10_2;
highp int ti2;
highp vec2 t3;
bool tb3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec2 t16_8;
highp vec3 t10;
highp float t11;
highp int ti11;
bvec2 tb11;
mediump float t16_16;
highp vec2 t18;
highp float t19;
bool tb19;
highp float t20;
mediump float t16_24;
highp float t27;
highp int ti27;
bool tb27;
highp float t28;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_24 = inversesqrt(t16_24);
    t16_1.xyz = vec3(t16_24) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec20 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_8.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec20, 0.0);
    t16_16 = (-_LightShadowData.x) + 1.0;
    t16_8.x = t16_8.x * t16_16 + _LightShadowData.x;
    t16_0.x = dot(t16_8.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_8.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_16 = t16_8.x + 1.00999999;
    t16_8.x = t16_8.x * -10.0;
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_16 = floor(t16_16);
    t16_16 = clamp(t16_16, 0.0, 1.0);
    t16_16 = t16_16 + -1.0;
    t16_8.x = t16_8.x * t16_16 + 1.0;
    t16_0.x = t16_8.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t10.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t10.z), abs(t10.y));
    t3.x = float(1.0) / t3.x;
    t11 = min(abs(t10.z), abs(t10.y));
    t3.x = t3.x * t11;
    t11 = t3.x * t3.x;
    t19 = t11 * 0.0208350997 + -0.0851330012;
    t19 = t11 * t19 + 0.180141002;
    t19 = t11 * t19 + -0.330299497;
    t11 = t11 * t19 + 0.999866009;
    t19 = t11 * t3.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb27 = abs(t10.z)<abs(t10.y);
    t19 = tb27 ? t19 : float(0.0);
    t3.x = t3.x * t11 + t19;
    tb11.xy = lessThan(t10.zxzz, (-t10.zxzz)).xy;
    t11 = tb11.x ? -3.14159274 : float(0.0);
    t3.x = t11 + t3.x;
    t11 = min(t10.z, t10.y);
    tb11.x = t11<(-t11);
    t27 = max(t10.z, t10.y);
    tb27 = t27>=(-t27);
    ti11 = int(uint(tb27) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t3.x = (ti11 != 0) ? (-t3.x) : t3.x;
    t11 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t11);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t27 = abs(t10.x) * -0.0187292993 + 0.0742610022;
    t27 = t27 * abs(t10.x) + -0.212114394;
    t27 = t27 * abs(t10.x) + 1.57072878;
    t20 = -abs(t10.x) + 1.0;
    t20 = sqrt(t20);
    t28 = t27 * t20;
    t28 = t28 * -2.0 + 3.14159274;
    t19 = tb11.y ? t28 : float(0.0);
    t19 = t27 * t20 + t19;
    t4.y = t19 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_1 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t16_8.xy = t10_1.xy * alphaMask1.xy;
    t16_8.x = t16_8.y + t16_8.x;
    t16_8.x = t10_1.z * alphaMask1.z + t16_8.x;
    t16_8.x = t10_1.w * alphaMask1.w + t16_8.x;
    tb3 = 0.0>=vs_TEXCOORD0.w;
    t3.x = (tb3) ? 0.0 : 1.0;
    t3.x = t16_8.x * t3.x;
    t11 = vs_TEXCOORD5.z * t2.x + (-t10.y);
    tb19 = abs(t10.z)>=abs(t10.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t11 = t19 * t11 + t10.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t11;
    t11 = max(abs(t10.z), abs(t10.y));
    tb11.x = t11>=abs(t10.x);
    t11 = tb11.x ? 1.0 : float(0.0);
    t2.x = t11 * t2.x + t10.x;
    ti27 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti27) + ti2;
    t16_6.y = float(ti2);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t10.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t5.xyz = t16_6.xyz * t10.zyx + (-t4.xyz);
    t4.xyz = vec3(t19) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_6.xxy) * t10.xyz + t4.xyz;
    t2.xyz = t10.xyz * t16_6.xxy;
    t2.xyz = vec3(t11) * t4.xyz + t2.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t18.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t2.xy;
    t11 = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t4.x = dFdx(t11);
    t5.x = dFdy(t11);
    t4.y = dFdx(t18.x);
    t5.y = dFdy(t18.x);
    t10_1 = textureGrad(_CityDarkOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_2 = textureGrad(_CityLightOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_8.x = t3.x * t10_1.w;
    t16_16 = t3.x * t10_2.w;
    t16_6.xyz = t10_1.xyz + (-t10_2.xyz);
    t16_24 = t16_8.x * t16_0.x + (-t16_16);
    t16_0.x = t16_0.x * t16_8.x;
    t16_8.x = t16_0.x * t16_24 + t16_16;
    t16_0.xzw = t16_0.xxx * t16_6.xyz + t10_2.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 175 math, 4 textures, 3 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  highp vec2 uv_7;
  highp float tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = (min (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0) / max (abs(
    (tmpvar_6.x / tmpvar_6.z)
  ), 1.0));
  highp float tmpvar_10;
  tmpvar_10 = (tmpvar_9 * tmpvar_9);
  tmpvar_10 = (((
    ((((
      ((((-0.01213232 * tmpvar_10) + 0.05368138) * tmpvar_10) - 0.1173503)
     * tmpvar_10) + 0.1938925) * tmpvar_10) - 0.3326756)
   * tmpvar_10) + 0.9999793) * tmpvar_9);
  tmpvar_10 = (tmpvar_10 + (float(
    (abs((tmpvar_6.x / tmpvar_6.z)) > 1.0)
  ) * (
    (tmpvar_10 * -2.0)
   + 1.570796)));
  tmpvar_8 = (tmpvar_10 * sign((tmpvar_6.x / tmpvar_6.z)));
  if ((abs(tmpvar_6.z) > (1e-08 * abs(tmpvar_6.x)))) {
    if ((tmpvar_6.z < 0.0)) {
      if ((tmpvar_6.x >= 0.0)) {
        tmpvar_8 += 3.141593;
      } else {
        tmpvar_8 = (tmpvar_8 - 3.141593);
      };
    };
  } else {
    tmpvar_8 = (sign(tmpvar_6.x) * 1.570796);
  };
  uv_7.x = (0.5 + (0.1591549 * tmpvar_8));
  uv_7.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_6.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_6.y)
    )) * (1.570796 + (
      abs(tmpvar_6.y)
     * 
      (-0.2146018 + (abs(tmpvar_6.y) * (0.08656672 + (
        abs(tmpvar_6.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_11;
  uvCont_11.y = uv_7.y;
  uvCont_11.x = abs((uv_7.x - 0.5));
  highp vec4 tmpvar_12;
  tmpvar_12.xy = dFdx(uvCont_11);
  tmpvar_12.zw = dFdy(uvCont_11);
  lowp vec4 tmpvar_13;
  tmpvar_13 = texture2DGradEXT (_CityOverlayTex, uv_7, tmpvar_12.xy, tmpvar_12.zw);
  mediump vec4 tmpvar_14;
  tmpvar_14 = tmpvar_13;
  mediump float tmpvar_15;
  mediump vec4 v_16;
  v_16 = (tmpvar_14 * alphaMask1);
  tmpvar_15 = ((v_16.x + v_16.y) + (v_16.z + v_16.w));
  mediump vec4 tmpvar_17;
  tmpvar_17.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_17.w = tmpvar_15;
  cityoverlay_4.xyz = tmpvar_17.xyz;
  mediump vec2 uv_18;
  mediump vec3 detailCoords_19;
  mediump float s_20;
  mediump float nylerp_21;
  mediump float zxlerp_22;
  highp vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_23);
  highp float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  zxlerp_22 = tmpvar_25;
  highp float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  nylerp_21 = tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_22);
  s_20 = tmpvar_27;
  highp float tmpvar_28;
  tmpvar_28 = sign(mix (tmpvar_23.y, s_20, nylerp_21));
  s_20 = tmpvar_28;
  mediump vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = -(s_20);
  mediump vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = s_20;
  highp vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_29 * tmpvar_23.xzy), (tmpvar_30 * tmpvar_23.zxy), vec3(zxlerp_22));
  detailCoords_19 = tmpvar_31;
  mediump vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = s_20;
  highp vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), detailCoords_19, vec3(nylerp_21));
  detailCoords_19 = tmpvar_33;
  uv_18 = (((
    (0.5 * detailCoords_19.yz)
   / 
    abs(detailCoords_19.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_34;
  uv_34 = uv_18;
  highp vec2 uvCont_35;
  highp vec2 tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = (0.5 * _CityOverlayDetailScale);
  tmpvar_36 = abs((uv_34 - tmpvar_37));
  uvCont_35.x = max (tmpvar_36.x, tmpvar_36.y);
  uvCont_35.y = min (tmpvar_36.x, tmpvar_36.y);
  highp vec4 tmpvar_38;
  tmpvar_38.xy = dFdx(uvCont_35);
  tmpvar_38.zw = dFdy(uvCont_35);
  lowp vec4 tmpvar_39;
  tmpvar_39 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_18, tmpvar_38.xy, tmpvar_38.zw);
  mediump vec4 tmpvar_40;
  tmpvar_40 = tmpvar_39;
  citydarkoverlaydetail_3.xyz = tmpvar_40.xyz;
  mediump vec2 uv_41;
  mediump vec3 detailCoords_42;
  mediump float s_43;
  mediump float nylerp_44;
  mediump float zxlerp_45;
  highp vec3 tmpvar_46;
  tmpvar_46 = abs(tmpvar_23);
  highp float tmpvar_47;
  tmpvar_47 = float((tmpvar_46.z >= tmpvar_46.x));
  zxlerp_45 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = float((max (tmpvar_46.x, tmpvar_46.z) >= tmpvar_46.y));
  nylerp_44 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = mix (tmpvar_23.x, tmpvar_23.z, zxlerp_45);
  s_43 = tmpvar_49;
  highp float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_23.y, s_43, nylerp_44));
  s_43 = tmpvar_50;
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(s_43);
  mediump vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = s_43;
  highp vec3 tmpvar_53;
  tmpvar_53 = mix ((tmpvar_51 * tmpvar_23.xzy), (tmpvar_52 * tmpvar_23.zxy), vec3(zxlerp_45));
  detailCoords_42 = tmpvar_53;
  mediump vec3 tmpvar_54;
  tmpvar_54.xy = vec2(1.0, 1.0);
  tmpvar_54.z = s_43;
  highp vec3 tmpvar_55;
  tmpvar_55 = mix ((tmpvar_54 * tmpvar_23.yxz), detailCoords_42, vec3(nylerp_44));
  detailCoords_42 = tmpvar_55;
  uv_41 = (((
    (0.5 * detailCoords_42.yz)
   / 
    abs(detailCoords_42.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_56;
  uv_56 = uv_41;
  highp vec2 uvCont_57;
  highp vec2 tmpvar_58;
  tmpvar_58 = abs((uv_56 - tmpvar_37));
  uvCont_57.x = max (tmpvar_58.x, tmpvar_58.y);
  uvCont_57.y = min (tmpvar_58.x, tmpvar_58.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_57);
  tmpvar_59.zw = dFdy(uvCont_57);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_41, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citylightoverlaydetail_2.xyz = tmpvar_61.xyz;
  highp float tmpvar_62;
  tmpvar_62 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_15 * (1.0 - tmpvar_62));
  citydarkoverlaydetail_3.w = (tmpvar_40.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_61.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_61.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_63;
  shadow_63 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_64;
  lightDir_64 = _SunDir;
  mediump vec3 viewDir_65;
  viewDir_65 = xlv_TEXCOORD7;
  mediump vec3 normal_66;
  normal_66 = xlv_TEXCOORD4;
  mediump float atten_67;
  atten_67 = shadow_63;
  mediump vec4 c_68;
  mediump vec3 tmpvar_69;
  tmpvar_69 = normalize(lightDir_64);
  lightDir_64 = tmpvar_69;
  mediump vec3 tmpvar_70;
  tmpvar_70 = normalize(viewDir_65);
  viewDir_65 = tmpvar_70;
  mediump vec3 tmpvar_71;
  tmpvar_71 = normalize(normal_66);
  normal_66 = tmpvar_71;
  mediump float tmpvar_72;
  tmpvar_72 = dot (tmpvar_71, tmpvar_69);
  highp float tmpvar_73;
  mediump float tmpvar_74;
  tmpvar_74 = clamp (dot (normalize(
    (tmpvar_69 + tmpvar_70)
  ), tmpvar_71), 0.0, 1.0);
  tmpvar_73 = tmpvar_74;
  highp float tmpvar_75;
  tmpvar_75 = (pow (tmpvar_73, _SpecularPower) * _SpecularColor.w);
  c_68.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_72) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_75)) * (atten_67 * 2.0));
  c_68.w = (tmpvar_72 * (atten_67 * 2.0));
  highp vec3 tmpvar_76;
  tmpvar_76 = normalize(_SunDir);
  mediump vec3 lightDir_77;
  lightDir_77 = tmpvar_76;
  mediump vec3 normal_78;
  normal_78 = xlv_TEXCOORD4;
  mediump float tmpvar_79;
  tmpvar_79 = dot (normal_78, lightDir_77);
  color_5 = (c_68 * mix (1.0, clamp (
    floor((1.01 + tmpvar_79))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_79))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_80;
  tmpvar_80 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_80.xyz;
  color_5.w = (tmpvar_80.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp vec4 t10_2;
highp int ti2;
highp vec2 t3;
bool tb3;
highp vec3 t4;
highp vec3 t5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec2 t16_8;
highp vec3 t10;
highp float t11;
highp int ti11;
bvec2 tb11;
mediump float t16_16;
highp vec2 t18;
highp float t19;
bool tb19;
highp float t20;
mediump float t16_24;
highp float t27;
highp int ti27;
bool tb27;
highp float t28;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_24 = inversesqrt(t16_24);
    t16_1.xyz = vec3(t16_24) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec19 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_8.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec19, 0.0);
    t16_16 = (-_LightShadowData.x) + 1.0;
    t16_8.x = t16_8.x * t16_16 + _LightShadowData.x;
    t16_0.x = dot(t16_8.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_8.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_16 = t16_8.x + 1.00999999;
    t16_8.x = t16_8.x * -10.0;
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_16 = floor(t16_16);
    t16_16 = clamp(t16_16, 0.0, 1.0);
    t16_16 = t16_16 + -1.0;
    t16_8.x = t16_8.x * t16_16 + 1.0;
    t16_0.x = t16_8.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t10.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = max(abs(t10.z), abs(t10.y));
    t3.x = float(1.0) / t3.x;
    t11 = min(abs(t10.z), abs(t10.y));
    t3.x = t3.x * t11;
    t11 = t3.x * t3.x;
    t19 = t11 * 0.0208350997 + -0.0851330012;
    t19 = t11 * t19 + 0.180141002;
    t19 = t11 * t19 + -0.330299497;
    t11 = t11 * t19 + 0.999866009;
    t19 = t11 * t3.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb27 = abs(t10.z)<abs(t10.y);
    t19 = tb27 ? t19 : float(0.0);
    t3.x = t3.x * t11 + t19;
    tb11.xy = lessThan(t10.zxzz, (-t10.zxzz)).xy;
    t11 = tb11.x ? -3.14159274 : float(0.0);
    t3.x = t11 + t3.x;
    t11 = min(t10.z, t10.y);
    tb11.x = t11<(-t11);
    t27 = max(t10.z, t10.y);
    tb27 = t27>=(-t27);
    ti11 = int(uint(tb27) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t3.x = (ti11 != 0) ? (-t3.x) : t3.x;
    t11 = t3.x * 0.159154937;
    t4.x = t3.x * 0.159154937 + 0.5;
    t3.x = abs(t11);
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t27 = abs(t10.x) * -0.0187292993 + 0.0742610022;
    t27 = t27 * abs(t10.x) + -0.212114394;
    t27 = t27 * abs(t10.x) + 1.57072878;
    t20 = -abs(t10.x) + 1.0;
    t20 = sqrt(t20);
    t28 = t27 * t20;
    t28 = t28 * -2.0 + 3.14159274;
    t19 = tb11.y ? t28 : float(0.0);
    t19 = t27 * t20 + t19;
    t4.y = t19 * 0.318309873;
    t5.y = dFdx(t4.y);
    t3.y = dFdy(t4.y);
    t10_1 = textureGrad(_CityOverlayTex, t4.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t16_8.xy = t10_1.xy * alphaMask1.xy;
    t16_8.x = t16_8.y + t16_8.x;
    t16_8.x = t10_1.z * alphaMask1.z + t16_8.x;
    t16_8.x = t10_1.w * alphaMask1.w + t16_8.x;
    tb3 = 0.0>=vs_TEXCOORD0.w;
    t3.x = (tb3) ? 0.0 : 1.0;
    t3.x = t16_8.x * t3.x;
    t11 = vs_TEXCOORD5.z * t2.x + (-t10.y);
    tb19 = abs(t10.z)>=abs(t10.y);
    t19 = tb19 ? 1.0 : float(0.0);
    t11 = t19 * t11 + t10.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t11;
    t11 = max(abs(t10.z), abs(t10.y));
    tb11.x = t11>=abs(t10.x);
    t11 = tb11.x ? 1.0 : float(0.0);
    t2.x = t11 * t2.x + t10.x;
    ti27 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti27) + ti2;
    t16_6.y = float(ti2);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t4.xyz = t10.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t5.xyz = t16_6.xyz * t10.zyx + (-t4.xyz);
    t4.xyz = vec3(t19) * t5.xyz + t4.xyz;
    t4.xyz = (-t16_6.xxy) * t10.xyz + t4.xyz;
    t2.xyz = t10.xyz * t16_6.xxy;
    t2.xyz = vec3(t11) * t4.xyz + t2.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t18.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t2.xy;
    t11 = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t4.x = dFdx(t11);
    t5.x = dFdy(t11);
    t4.y = dFdx(t18.x);
    t5.y = dFdy(t18.x);
    t10_1 = textureGrad(_CityDarkOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t10_2 = textureGrad(_CityLightOverlayDetailTex, t2.xy, vec4(t4.xyxx).xy, vec4(t5.xyxx).xy);
    t16_8.x = t3.x * t10_1.w;
    t16_16 = t3.x * t10_2.w;
    t16_6.xyz = t10_1.xyz + (-t10_2.xyz);
    t16_24 = t16_8.x * t16_0.x + (-t16_16);
    t16_0.x = t16_0.x * t16_8.x;
    t16_8.x = t16_0.x * t16_24 + t16_16;
    t16_0.xzw = t16_0.xxx * t16_6.xyz + t10_2.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 99 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec4 tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  tmpvar_5 = textureCube (cube_CityOverlayTex, tmpvar_6);
  cityoverlay_3.xyz = tmpvar_5.xyz;
  vec2 uv_7;
  vec3 tmpvar_8;
  tmpvar_8 = abs(tmpvar_6);
  float tmpvar_9;
  tmpvar_9 = float((tmpvar_8.z >= tmpvar_8.x));
  float tmpvar_10;
  tmpvar_10 = float((max (tmpvar_8.x, tmpvar_8.z) >= tmpvar_8.y));
  float tmpvar_11;
  tmpvar_11 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_9), tmpvar_10));
  vec3 tmpvar_12;
  tmpvar_12.xz = vec2(1.0, -1.0);
  tmpvar_12.y = -(tmpvar_11);
  vec3 tmpvar_13;
  tmpvar_13.xz = vec2(1.0, -1.0);
  tmpvar_13.y = tmpvar_11;
  vec3 tmpvar_14;
  tmpvar_14.xy = vec2(1.0, 1.0);
  tmpvar_14.z = tmpvar_11;
  vec3 tmpvar_15;
  tmpvar_15 = mix ((tmpvar_14 * tmpvar_6.yxz), mix ((tmpvar_12 * tmpvar_6.xzy), (tmpvar_13 * tmpvar_6.zxy), vec3(tmpvar_9)), vec3(tmpvar_10));
  uv_7 = (((
    (0.5 * tmpvar_15.yz)
   / 
    abs(tmpvar_15.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_16;
  vec2 tmpvar_17;
  float tmpvar_18;
  tmpvar_18 = (0.5 * _CityOverlayDetailScale);
  tmpvar_17 = abs((uv_7 - tmpvar_18));
  uvCont_16.x = max (tmpvar_17.x, tmpvar_17.y);
  uvCont_16.y = min (tmpvar_17.x, tmpvar_17.y);
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_16);
  tmpvar_19.zw = dFdy(uvCont_16);
  vec4 tmpvar_20;
  tmpvar_20 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_7, tmpvar_19.xy, tmpvar_19.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_20.xyz;
  vec2 uv_21;
  vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_6);
  float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_23), tmpvar_24));
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(tmpvar_25);
  vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = tmpvar_25;
  vec3 tmpvar_28;
  tmpvar_28.xy = vec2(1.0, 1.0);
  tmpvar_28.z = tmpvar_25;
  vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_28 * tmpvar_6.yxz), mix ((tmpvar_26 * tmpvar_6.xzy), (tmpvar_27 * tmpvar_6.zxy), vec3(tmpvar_23)), vec3(tmpvar_24));
  uv_21 = (((
    (0.5 * tmpvar_29.yz)
   / 
    abs(tmpvar_29.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_30;
  vec2 tmpvar_31;
  tmpvar_31 = abs((uv_21 - tmpvar_18));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  vec4 tmpvar_33;
  tmpvar_33 = texture2DGradARB (_CityLightOverlayDetailTex, uv_21, tmpvar_32.xy, tmpvar_32.zw);
  citylightoverlaydetail_1.xyz = tmpvar_33.xyz;
  cityoverlay_3.w = (tmpvar_5.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_20.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_33.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_33.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_34;
  vec3 tmpvar_35;
  tmpvar_35 = normalize(_SunDir);
  vec3 tmpvar_36;
  tmpvar_36 = normalize(xlv_TEXCOORD4);
  float tmpvar_37;
  tmpvar_37 = dot (tmpvar_36, tmpvar_35);
  c_34.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_37) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_35 + normalize(xlv_TEXCOORD7)))
    , tmpvar_36), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_34.w = (tmpvar_37 * 2.0);
  float tmpvar_38;
  tmpvar_38 = dot (xlv_TEXCOORD4, tmpvar_35);
  color_4 = (c_34 * mix (1.0, clamp (
    floor((1.01 + tmpvar_38))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_38))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_39;
  tmpvar_39 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_39.xyz;
  color_4.w = (tmpvar_39.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 100 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  cityoverlay_4.xyz = tmpvar_8.xyz;
  mediump vec2 uv_9;
  mediump vec3 detailCoords_10;
  mediump float s_11;
  mediump float nylerp_12;
  mediump float zxlerp_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_6);
  highp float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  zxlerp_13 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  nylerp_12 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_13);
  s_11 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_6.y, s_11, nylerp_12));
  s_11 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(s_11);
  mediump vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = s_11;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_19 * tmpvar_6.xzy), (tmpvar_20 * tmpvar_6.zxy), vec3(zxlerp_13));
  detailCoords_10 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xy = vec2(1.0, 1.0);
  tmpvar_22.z = s_11;
  highp vec3 tmpvar_23;
  tmpvar_23 = mix ((tmpvar_22 * tmpvar_6.yxz), detailCoords_10, vec3(nylerp_12));
  detailCoords_10 = tmpvar_23;
  uv_9 = (((
    (0.5 * detailCoords_10.yz)
   / 
    abs(detailCoords_10.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_24;
  uv_24 = uv_9;
  highp vec2 uvCont_25;
  highp vec2 tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_24 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_9, tmpvar_28.xy, tmpvar_28.zw);
  mediump vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  citydarkoverlaydetail_3.xyz = tmpvar_30.xyz;
  mediump vec2 uv_31;
  mediump vec3 detailCoords_32;
  mediump float s_33;
  mediump float nylerp_34;
  mediump float zxlerp_35;
  highp vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_6);
  highp float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  zxlerp_35 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  nylerp_34 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_35);
  s_33 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = sign(mix (tmpvar_6.y, s_33, nylerp_34));
  s_33 = tmpvar_40;
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = -(s_33);
  mediump vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = s_33;
  highp vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_41 * tmpvar_6.xzy), (tmpvar_42 * tmpvar_6.zxy), vec3(zxlerp_35));
  detailCoords_32 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = s_33;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_6.yxz), detailCoords_32, vec3(nylerp_34));
  detailCoords_32 = tmpvar_45;
  uv_31 = (((
    (0.5 * detailCoords_32.yz)
   / 
    abs(detailCoords_32.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_46;
  uv_46 = uv_31;
  highp vec2 uvCont_47;
  highp vec2 tmpvar_48;
  tmpvar_48 = abs((uv_46 - tmpvar_27));
  uvCont_47.x = max (tmpvar_48.x, tmpvar_48.y);
  uvCont_47.y = min (tmpvar_48.x, tmpvar_48.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_47);
  tmpvar_49.zw = dFdy(uvCont_47);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_31, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citylightoverlaydetail_2.xyz = tmpvar_51.xyz;
  highp float tmpvar_52;
  tmpvar_52 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_8.w * (1.0 - tmpvar_52));
  citydarkoverlaydetail_3.w = (tmpvar_30.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_51.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_51.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_53;
  lightDir_53 = _SunDir;
  mediump vec3 viewDir_54;
  viewDir_54 = xlv_TEXCOORD7;
  mediump vec3 normal_55;
  normal_55 = xlv_TEXCOORD4;
  mediump vec4 c_56;
  mediump vec3 tmpvar_57;
  tmpvar_57 = normalize(lightDir_53);
  lightDir_53 = tmpvar_57;
  mediump vec3 tmpvar_58;
  tmpvar_58 = normalize(viewDir_54);
  viewDir_54 = tmpvar_58;
  mediump vec3 tmpvar_59;
  tmpvar_59 = normalize(normal_55);
  normal_55 = tmpvar_59;
  mediump float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, tmpvar_57);
  highp float tmpvar_61;
  mediump float tmpvar_62;
  tmpvar_62 = clamp (dot (normalize(
    (tmpvar_57 + tmpvar_58)
  ), tmpvar_59), 0.0, 1.0);
  tmpvar_61 = tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = (pow (tmpvar_61, _SpecularPower) * _SpecularColor.w);
  c_56.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_60) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_63)) * 2.0);
  c_56.w = (tmpvar_60 * 2.0);
  highp vec3 tmpvar_64;
  tmpvar_64 = normalize(_SunDir);
  mediump vec3 lightDir_65;
  lightDir_65 = tmpvar_64;
  mediump vec3 normal_66;
  normal_66 = xlv_TEXCOORD4;
  mediump float tmpvar_67;
  tmpvar_67 = dot (normal_66, lightDir_65);
  color_5 = (c_56 * mix (1.0, clamp (
    floor((1.01 + tmpvar_67))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_67))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_68;
  tmpvar_68 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_68.xyz;
  color_5.w = (tmpvar_68.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp float t10_0;
highp int ti0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec2 t3;
lowp vec4 t10_3;
bool tb3;
mediump vec3 t16_4;
highp vec3 t5;
highp vec3 t6;
highp vec3 t7;
bool tb7;
mediump vec3 t16_8;
highp vec3 t10;
bool tb10;
mediump float t16_15;
highp int ti17;
highp float t21;
mediump float t16_22;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_8.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_8.x = floor(t16_8.x);
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_8.x = t16_8.x + -1.0;
    t16_1.x = t16_1.x * t16_8.x + 1.0;
    t16_8.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_8.x = inversesqrt(t16_8.x);
    t16_8.xyz = t16_8.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_8.x = dot(t16_2.xyz, t16_8.xyz);
    t16_8.x = t16_8.x + t16_8.x;
    t16_1.x = t16_1.x * t16_8.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t16_2.xz = vec2(1.0, -1.0);
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t7.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t0.x + (-t7.y);
    tb10 = abs(t7.z)>=abs(t7.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t3.x = t10.x * t3.x + t7.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t3.x;
    t3.x = max(abs(t7.z), abs(t7.y));
    tb3 = t3.x>=abs(t7.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t0.x = t3.x * t0.x + t7.x;
    ti17 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti17) + ti0;
    t16_4.y = float(ti0);
    t16_2.y = (-t16_4.y);
    t5.xyz = t7.yzx * t16_2.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t7.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t7.xyz + t10.xyz;
    t5.xyz = t7.xyz * t16_4.xxy;
    t10_0 = texture(cube_CityOverlayTex, t7.yxz).w;
    t7.xyz = t3.xxx * t10.xyz + t5.xyz;
    t16_8.xy = vec2(t7.y * float(0.5), t7.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t7.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t7.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t3.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t7.xy;
    t21 = max(abs(t3.y), abs(t3.x));
    t3.x = min(abs(t3.y), abs(t3.x));
    t5.x = dFdx(t21);
    t6.x = dFdy(t21);
    t5.y = dFdx(t3.x);
    t6.y = dFdy(t3.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t7.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    t10_3 = textureGrad(_CityLightOverlayDetailTex, t7.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    tb7 = 0.0>=vs_TEXCOORD0.w;
    t7.x = (tb7) ? 0.0 : 1.0;
    t0.x = t7.x * t10_0;
    t16_8.x = t0.x * t10_2.w;
    t16_4.xyz = t10_2.xyz + (-t10_3.xyz);
    t16_15 = t0.x * t10_3.w;
    t16_22 = t16_8.x * t16_1.x + (-t16_15);
    t16_1.x = t16_1.x * t16_8.x;
    t16_8.x = t16_1.x * t16_22 + t16_15;
    t16_1.xzw = t16_1.xxx * t16_4.xyz + t10_3.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
bool tb5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t15 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t15 + 1.00999999;
    t15 = t15 * -10.0;
    t15 = clamp(t15, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t15 = t15 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t15 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.x = dFdx(t15);
    t3.x = dFdy(t15);
    t2.y = dFdx(t1.x);
    t3.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    tb5 = 0.0>=vs_TEXCOORD0.w;
    t5.x = (tb5) ? 0.0 : 1.0;
    t5.x = t5.x * t10_2.w;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 101 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec4 tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  tmpvar_5 = textureCube (cube_CityOverlayTex, tmpvar_6);
  cityoverlay_3.xyz = tmpvar_5.xyz;
  vec2 uv_7;
  vec3 tmpvar_8;
  tmpvar_8 = abs(tmpvar_6);
  float tmpvar_9;
  tmpvar_9 = float((tmpvar_8.z >= tmpvar_8.x));
  float tmpvar_10;
  tmpvar_10 = float((max (tmpvar_8.x, tmpvar_8.z) >= tmpvar_8.y));
  float tmpvar_11;
  tmpvar_11 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_9), tmpvar_10));
  vec3 tmpvar_12;
  tmpvar_12.xz = vec2(1.0, -1.0);
  tmpvar_12.y = -(tmpvar_11);
  vec3 tmpvar_13;
  tmpvar_13.xz = vec2(1.0, -1.0);
  tmpvar_13.y = tmpvar_11;
  vec3 tmpvar_14;
  tmpvar_14.xy = vec2(1.0, 1.0);
  tmpvar_14.z = tmpvar_11;
  vec3 tmpvar_15;
  tmpvar_15 = mix ((tmpvar_14 * tmpvar_6.yxz), mix ((tmpvar_12 * tmpvar_6.xzy), (tmpvar_13 * tmpvar_6.zxy), vec3(tmpvar_9)), vec3(tmpvar_10));
  uv_7 = (((
    (0.5 * tmpvar_15.yz)
   / 
    abs(tmpvar_15.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_16;
  vec2 tmpvar_17;
  float tmpvar_18;
  tmpvar_18 = (0.5 * _CityOverlayDetailScale);
  tmpvar_17 = abs((uv_7 - tmpvar_18));
  uvCont_16.x = max (tmpvar_17.x, tmpvar_17.y);
  uvCont_16.y = min (tmpvar_17.x, tmpvar_17.y);
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_16);
  tmpvar_19.zw = dFdy(uvCont_16);
  vec4 tmpvar_20;
  tmpvar_20 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_7, tmpvar_19.xy, tmpvar_19.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_20.xyz;
  vec2 uv_21;
  vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_6);
  float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_23), tmpvar_24));
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(tmpvar_25);
  vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = tmpvar_25;
  vec3 tmpvar_28;
  tmpvar_28.xy = vec2(1.0, 1.0);
  tmpvar_28.z = tmpvar_25;
  vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_28 * tmpvar_6.yxz), mix ((tmpvar_26 * tmpvar_6.xzy), (tmpvar_27 * tmpvar_6.zxy), vec3(tmpvar_23)), vec3(tmpvar_24));
  uv_21 = (((
    (0.5 * tmpvar_29.yz)
   / 
    abs(tmpvar_29.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_30;
  vec2 tmpvar_31;
  tmpvar_31 = abs((uv_21 - tmpvar_18));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  vec4 tmpvar_33;
  tmpvar_33 = texture2DGradARB (_CityLightOverlayDetailTex, uv_21, tmpvar_32.xy, tmpvar_32.zw);
  citylightoverlaydetail_1.xyz = tmpvar_33.xyz;
  cityoverlay_3.w = (tmpvar_5.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_20.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_33.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_33.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_34;
  tmpvar_34 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_35;
  vec3 tmpvar_36;
  tmpvar_36 = normalize(_SunDir);
  vec3 tmpvar_37;
  tmpvar_37 = normalize(xlv_TEXCOORD4);
  float tmpvar_38;
  tmpvar_38 = dot (tmpvar_37, tmpvar_36);
  c_35.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_38) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_36 + normalize(xlv_TEXCOORD7)))
    , tmpvar_37), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_34.x * 2.0));
  c_35.w = (tmpvar_38 * (tmpvar_34.x * 2.0));
  float tmpvar_39;
  tmpvar_39 = dot (xlv_TEXCOORD4, tmpvar_36);
  color_4 = (c_35 * mix (1.0, clamp (
    floor((1.01 + tmpvar_39))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_39))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_40;
  tmpvar_40 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_40.xyz;
  color_4.w = (tmpvar_40.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 106 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  cityoverlay_4.xyz = tmpvar_8.xyz;
  mediump vec2 uv_9;
  mediump vec3 detailCoords_10;
  mediump float s_11;
  mediump float nylerp_12;
  mediump float zxlerp_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_6);
  highp float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  zxlerp_13 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  nylerp_12 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_13);
  s_11 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_6.y, s_11, nylerp_12));
  s_11 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(s_11);
  mediump vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = s_11;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_19 * tmpvar_6.xzy), (tmpvar_20 * tmpvar_6.zxy), vec3(zxlerp_13));
  detailCoords_10 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xy = vec2(1.0, 1.0);
  tmpvar_22.z = s_11;
  highp vec3 tmpvar_23;
  tmpvar_23 = mix ((tmpvar_22 * tmpvar_6.yxz), detailCoords_10, vec3(nylerp_12));
  detailCoords_10 = tmpvar_23;
  uv_9 = (((
    (0.5 * detailCoords_10.yz)
   / 
    abs(detailCoords_10.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_24;
  uv_24 = uv_9;
  highp vec2 uvCont_25;
  highp vec2 tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_24 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_9, tmpvar_28.xy, tmpvar_28.zw);
  mediump vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  citydarkoverlaydetail_3.xyz = tmpvar_30.xyz;
  mediump vec2 uv_31;
  mediump vec3 detailCoords_32;
  mediump float s_33;
  mediump float nylerp_34;
  mediump float zxlerp_35;
  highp vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_6);
  highp float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  zxlerp_35 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  nylerp_34 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_35);
  s_33 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = sign(mix (tmpvar_6.y, s_33, nylerp_34));
  s_33 = tmpvar_40;
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = -(s_33);
  mediump vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = s_33;
  highp vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_41 * tmpvar_6.xzy), (tmpvar_42 * tmpvar_6.zxy), vec3(zxlerp_35));
  detailCoords_32 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = s_33;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_6.yxz), detailCoords_32, vec3(nylerp_34));
  detailCoords_32 = tmpvar_45;
  uv_31 = (((
    (0.5 * detailCoords_32.yz)
   / 
    abs(detailCoords_32.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_46;
  uv_46 = uv_31;
  highp vec2 uvCont_47;
  highp vec2 tmpvar_48;
  tmpvar_48 = abs((uv_46 - tmpvar_27));
  uvCont_47.x = max (tmpvar_48.x, tmpvar_48.y);
  uvCont_47.y = min (tmpvar_48.x, tmpvar_48.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_47);
  tmpvar_49.zw = dFdy(uvCont_47);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_31, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citylightoverlaydetail_2.xyz = tmpvar_51.xyz;
  highp float tmpvar_52;
  tmpvar_52 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_8.w * (1.0 - tmpvar_52));
  citydarkoverlaydetail_3.w = (tmpvar_30.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_51.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_51.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_53;
  highp float tmpvar_54;
  tmpvar_54 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_53 = tmpvar_54;
  mediump vec3 lightDir_55;
  lightDir_55 = _SunDir;
  mediump vec3 viewDir_56;
  viewDir_56 = xlv_TEXCOORD7;
  mediump vec3 normal_57;
  normal_57 = xlv_TEXCOORD4;
  mediump float atten_58;
  atten_58 = tmpvar_53;
  mediump vec4 c_59;
  mediump vec3 tmpvar_60;
  tmpvar_60 = normalize(lightDir_55);
  lightDir_55 = tmpvar_60;
  mediump vec3 tmpvar_61;
  tmpvar_61 = normalize(viewDir_56);
  viewDir_56 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62 = normalize(normal_57);
  normal_57 = tmpvar_62;
  mediump float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, tmpvar_60);
  highp float tmpvar_64;
  mediump float tmpvar_65;
  tmpvar_65 = clamp (dot (normalize(
    (tmpvar_60 + tmpvar_61)
  ), tmpvar_62), 0.0, 1.0);
  tmpvar_64 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = (pow (tmpvar_64, _SpecularPower) * _SpecularColor.w);
  c_59.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_63) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_66)) * (atten_58 * 2.0));
  c_59.w = (tmpvar_63 * (atten_58 * 2.0));
  highp vec3 tmpvar_67;
  tmpvar_67 = normalize(_SunDir);
  mediump vec3 lightDir_68;
  lightDir_68 = tmpvar_67;
  mediump vec3 normal_69;
  normal_69 = xlv_TEXCOORD4;
  mediump float tmpvar_70;
  tmpvar_70 = dot (normal_69, lightDir_68);
  color_5 = (c_59 * mix (1.0, clamp (
    floor((1.01 + tmpvar_70))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_70))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_71;
  tmpvar_71 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_71.xyz;
  color_5.w = (tmpvar_71.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
bool tb5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t15 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t15 = inversesqrt(t15);
    t1.xyz = vec3(t15) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t5.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t10.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t10.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t10.x = t5.x + 1.00999999;
    t5.x = t5.x * -10.0;
    t5.x = clamp(t5.x, 0.0, 1.0);
    t10.x = floor(t10.x);
    t10.x = clamp(t10.x, 0.0, 1.0);
    t10.x = t10.x + -1.0;
    t5.x = t5.x * t10.x + 1.0;
    t0.x = t5.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.x = dFdx(t15);
    t3.x = dFdy(t15);
    t2.y = dFdx(t1.x);
    t3.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    tb5 = 0.0>=vs_TEXCOORD0.w;
    t5.x = (tb5) ? 0.0 : 1.0;
    t5.x = t5.x * t10_2.w;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 99 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec4 tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  tmpvar_5 = textureCube (cube_CityOverlayTex, tmpvar_6);
  cityoverlay_3.xyz = tmpvar_5.xyz;
  vec2 uv_7;
  vec3 tmpvar_8;
  tmpvar_8 = abs(tmpvar_6);
  float tmpvar_9;
  tmpvar_9 = float((tmpvar_8.z >= tmpvar_8.x));
  float tmpvar_10;
  tmpvar_10 = float((max (tmpvar_8.x, tmpvar_8.z) >= tmpvar_8.y));
  float tmpvar_11;
  tmpvar_11 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_9), tmpvar_10));
  vec3 tmpvar_12;
  tmpvar_12.xz = vec2(1.0, -1.0);
  tmpvar_12.y = -(tmpvar_11);
  vec3 tmpvar_13;
  tmpvar_13.xz = vec2(1.0, -1.0);
  tmpvar_13.y = tmpvar_11;
  vec3 tmpvar_14;
  tmpvar_14.xy = vec2(1.0, 1.0);
  tmpvar_14.z = tmpvar_11;
  vec3 tmpvar_15;
  tmpvar_15 = mix ((tmpvar_14 * tmpvar_6.yxz), mix ((tmpvar_12 * tmpvar_6.xzy), (tmpvar_13 * tmpvar_6.zxy), vec3(tmpvar_9)), vec3(tmpvar_10));
  uv_7 = (((
    (0.5 * tmpvar_15.yz)
   / 
    abs(tmpvar_15.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_16;
  vec2 tmpvar_17;
  float tmpvar_18;
  tmpvar_18 = (0.5 * _CityOverlayDetailScale);
  tmpvar_17 = abs((uv_7 - tmpvar_18));
  uvCont_16.x = max (tmpvar_17.x, tmpvar_17.y);
  uvCont_16.y = min (tmpvar_17.x, tmpvar_17.y);
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_16);
  tmpvar_19.zw = dFdy(uvCont_16);
  vec4 tmpvar_20;
  tmpvar_20 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_7, tmpvar_19.xy, tmpvar_19.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_20.xyz;
  vec2 uv_21;
  vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_6);
  float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_23), tmpvar_24));
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(tmpvar_25);
  vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = tmpvar_25;
  vec3 tmpvar_28;
  tmpvar_28.xy = vec2(1.0, 1.0);
  tmpvar_28.z = tmpvar_25;
  vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_28 * tmpvar_6.yxz), mix ((tmpvar_26 * tmpvar_6.xzy), (tmpvar_27 * tmpvar_6.zxy), vec3(tmpvar_23)), vec3(tmpvar_24));
  uv_21 = (((
    (0.5 * tmpvar_29.yz)
   / 
    abs(tmpvar_29.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_30;
  vec2 tmpvar_31;
  tmpvar_31 = abs((uv_21 - tmpvar_18));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  vec4 tmpvar_33;
  tmpvar_33 = texture2DGradARB (_CityLightOverlayDetailTex, uv_21, tmpvar_32.xy, tmpvar_32.zw);
  citylightoverlaydetail_1.xyz = tmpvar_33.xyz;
  cityoverlay_3.w = (tmpvar_5.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_20.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_33.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_33.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_34;
  vec3 tmpvar_35;
  tmpvar_35 = normalize(_SunDir);
  vec3 tmpvar_36;
  tmpvar_36 = normalize(xlv_TEXCOORD4);
  float tmpvar_37;
  tmpvar_37 = dot (tmpvar_36, tmpvar_35);
  c_34.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_37) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_35 + normalize(xlv_TEXCOORD7)))
    , tmpvar_36), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_34.w = (tmpvar_37 * 2.0);
  float tmpvar_38;
  tmpvar_38 = dot (xlv_TEXCOORD4, tmpvar_35);
  color_4 = (c_34 * mix (1.0, clamp (
    floor((1.01 + tmpvar_38))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_38))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_39;
  tmpvar_39 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_39.xyz;
  color_4.w = (tmpvar_39.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 100 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  cityoverlay_4.xyz = tmpvar_8.xyz;
  mediump vec2 uv_9;
  mediump vec3 detailCoords_10;
  mediump float s_11;
  mediump float nylerp_12;
  mediump float zxlerp_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_6);
  highp float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  zxlerp_13 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  nylerp_12 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_13);
  s_11 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_6.y, s_11, nylerp_12));
  s_11 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(s_11);
  mediump vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = s_11;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_19 * tmpvar_6.xzy), (tmpvar_20 * tmpvar_6.zxy), vec3(zxlerp_13));
  detailCoords_10 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xy = vec2(1.0, 1.0);
  tmpvar_22.z = s_11;
  highp vec3 tmpvar_23;
  tmpvar_23 = mix ((tmpvar_22 * tmpvar_6.yxz), detailCoords_10, vec3(nylerp_12));
  detailCoords_10 = tmpvar_23;
  uv_9 = (((
    (0.5 * detailCoords_10.yz)
   / 
    abs(detailCoords_10.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_24;
  uv_24 = uv_9;
  highp vec2 uvCont_25;
  highp vec2 tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_24 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_9, tmpvar_28.xy, tmpvar_28.zw);
  mediump vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  citydarkoverlaydetail_3.xyz = tmpvar_30.xyz;
  mediump vec2 uv_31;
  mediump vec3 detailCoords_32;
  mediump float s_33;
  mediump float nylerp_34;
  mediump float zxlerp_35;
  highp vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_6);
  highp float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  zxlerp_35 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  nylerp_34 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_35);
  s_33 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = sign(mix (tmpvar_6.y, s_33, nylerp_34));
  s_33 = tmpvar_40;
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = -(s_33);
  mediump vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = s_33;
  highp vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_41 * tmpvar_6.xzy), (tmpvar_42 * tmpvar_6.zxy), vec3(zxlerp_35));
  detailCoords_32 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = s_33;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_6.yxz), detailCoords_32, vec3(nylerp_34));
  detailCoords_32 = tmpvar_45;
  uv_31 = (((
    (0.5 * detailCoords_32.yz)
   / 
    abs(detailCoords_32.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_46;
  uv_46 = uv_31;
  highp vec2 uvCont_47;
  highp vec2 tmpvar_48;
  tmpvar_48 = abs((uv_46 - tmpvar_27));
  uvCont_47.x = max (tmpvar_48.x, tmpvar_48.y);
  uvCont_47.y = min (tmpvar_48.x, tmpvar_48.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_47);
  tmpvar_49.zw = dFdy(uvCont_47);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_31, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citylightoverlaydetail_2.xyz = tmpvar_51.xyz;
  highp float tmpvar_52;
  tmpvar_52 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_8.w * (1.0 - tmpvar_52));
  citydarkoverlaydetail_3.w = (tmpvar_30.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_51.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_51.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_53;
  lightDir_53 = _SunDir;
  mediump vec3 viewDir_54;
  viewDir_54 = xlv_TEXCOORD7;
  mediump vec3 normal_55;
  normal_55 = xlv_TEXCOORD4;
  mediump vec4 c_56;
  mediump vec3 tmpvar_57;
  tmpvar_57 = normalize(lightDir_53);
  lightDir_53 = tmpvar_57;
  mediump vec3 tmpvar_58;
  tmpvar_58 = normalize(viewDir_54);
  viewDir_54 = tmpvar_58;
  mediump vec3 tmpvar_59;
  tmpvar_59 = normalize(normal_55);
  normal_55 = tmpvar_59;
  mediump float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, tmpvar_57);
  highp float tmpvar_61;
  mediump float tmpvar_62;
  tmpvar_62 = clamp (dot (normalize(
    (tmpvar_57 + tmpvar_58)
  ), tmpvar_59), 0.0, 1.0);
  tmpvar_61 = tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = (pow (tmpvar_61, _SpecularPower) * _SpecularColor.w);
  c_56.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_60) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_63)) * 2.0);
  c_56.w = (tmpvar_60 * 2.0);
  highp vec3 tmpvar_64;
  tmpvar_64 = normalize(_SunDir);
  mediump vec3 lightDir_65;
  lightDir_65 = tmpvar_64;
  mediump vec3 normal_66;
  normal_66 = xlv_TEXCOORD4;
  mediump float tmpvar_67;
  tmpvar_67 = dot (normal_66, lightDir_65);
  color_5 = (c_56 * mix (1.0, clamp (
    floor((1.01 + tmpvar_67))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_67))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_68;
  tmpvar_68 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_68.xyz;
  color_5.w = (tmpvar_68.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp float t10_0;
highp int ti0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec2 t3;
lowp vec4 t10_3;
bool tb3;
mediump vec3 t16_4;
highp vec3 t5;
highp vec3 t6;
highp vec3 t7;
bool tb7;
mediump vec3 t16_8;
highp vec3 t10;
bool tb10;
mediump float t16_15;
highp int ti17;
highp float t21;
mediump float t16_22;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_8.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_8.x = floor(t16_8.x);
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_8.x = t16_8.x + -1.0;
    t16_1.x = t16_1.x * t16_8.x + 1.0;
    t16_8.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_8.x = inversesqrt(t16_8.x);
    t16_8.xyz = t16_8.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_8.x = dot(t16_2.xyz, t16_8.xyz);
    t16_8.x = t16_8.x + t16_8.x;
    t16_1.x = t16_1.x * t16_8.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t16_2.xz = vec2(1.0, -1.0);
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t7.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t0.x + (-t7.y);
    tb10 = abs(t7.z)>=abs(t7.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t3.x = t10.x * t3.x + t7.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t3.x;
    t3.x = max(abs(t7.z), abs(t7.y));
    tb3 = t3.x>=abs(t7.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t0.x = t3.x * t0.x + t7.x;
    ti17 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti17) + ti0;
    t16_4.y = float(ti0);
    t16_2.y = (-t16_4.y);
    t5.xyz = t7.yzx * t16_2.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t7.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t7.xyz + t10.xyz;
    t5.xyz = t7.xyz * t16_4.xxy;
    t10_0 = texture(cube_CityOverlayTex, t7.yxz).w;
    t7.xyz = t3.xxx * t10.xyz + t5.xyz;
    t16_8.xy = vec2(t7.y * float(0.5), t7.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t7.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t7.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t3.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t7.xy;
    t21 = max(abs(t3.y), abs(t3.x));
    t3.x = min(abs(t3.y), abs(t3.x));
    t5.x = dFdx(t21);
    t6.x = dFdy(t21);
    t5.y = dFdx(t3.x);
    t6.y = dFdy(t3.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t7.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    t10_3 = textureGrad(_CityLightOverlayDetailTex, t7.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    tb7 = 0.0>=vs_TEXCOORD0.w;
    t7.x = (tb7) ? 0.0 : 1.0;
    t0.x = t7.x * t10_0;
    t16_8.x = t0.x * t10_2.w;
    t16_4.xyz = t10_2.xyz + (-t10_3.xyz);
    t16_15 = t0.x * t10_3.w;
    t16_22 = t16_8.x * t16_1.x + (-t16_15);
    t16_1.x = t16_1.x * t16_8.x;
    t16_8.x = t16_1.x * t16_22 + t16_15;
    t16_1.xzw = t16_1.xxx * t16_4.xyz + t10_3.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
bool tb5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t15 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t15 + 1.00999999;
    t15 = t15 * -10.0;
    t15 = clamp(t15, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t15 = t15 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t15 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.x = dFdx(t15);
    t3.x = dFdy(t15);
    t2.y = dFdx(t1.x);
    t3.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    tb5 = 0.0>=vs_TEXCOORD0.w;
    t5.x = (tb5) ? 0.0 : 1.0;
    t5.x = t5.x * t10_2.w;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 101 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec4 tmpvar_5;
  vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  tmpvar_5 = textureCube (cube_CityOverlayTex, tmpvar_6);
  cityoverlay_3.xyz = tmpvar_5.xyz;
  vec2 uv_7;
  vec3 tmpvar_8;
  tmpvar_8 = abs(tmpvar_6);
  float tmpvar_9;
  tmpvar_9 = float((tmpvar_8.z >= tmpvar_8.x));
  float tmpvar_10;
  tmpvar_10 = float((max (tmpvar_8.x, tmpvar_8.z) >= tmpvar_8.y));
  float tmpvar_11;
  tmpvar_11 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_9), tmpvar_10));
  vec3 tmpvar_12;
  tmpvar_12.xz = vec2(1.0, -1.0);
  tmpvar_12.y = -(tmpvar_11);
  vec3 tmpvar_13;
  tmpvar_13.xz = vec2(1.0, -1.0);
  tmpvar_13.y = tmpvar_11;
  vec3 tmpvar_14;
  tmpvar_14.xy = vec2(1.0, 1.0);
  tmpvar_14.z = tmpvar_11;
  vec3 tmpvar_15;
  tmpvar_15 = mix ((tmpvar_14 * tmpvar_6.yxz), mix ((tmpvar_12 * tmpvar_6.xzy), (tmpvar_13 * tmpvar_6.zxy), vec3(tmpvar_9)), vec3(tmpvar_10));
  uv_7 = (((
    (0.5 * tmpvar_15.yz)
   / 
    abs(tmpvar_15.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_16;
  vec2 tmpvar_17;
  float tmpvar_18;
  tmpvar_18 = (0.5 * _CityOverlayDetailScale);
  tmpvar_17 = abs((uv_7 - tmpvar_18));
  uvCont_16.x = max (tmpvar_17.x, tmpvar_17.y);
  uvCont_16.y = min (tmpvar_17.x, tmpvar_17.y);
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_16);
  tmpvar_19.zw = dFdy(uvCont_16);
  vec4 tmpvar_20;
  tmpvar_20 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_7, tmpvar_19.xy, tmpvar_19.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_20.xyz;
  vec2 uv_21;
  vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_6);
  float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_6.y, mix (tmpvar_6.x, tmpvar_6.z, tmpvar_23), tmpvar_24));
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(tmpvar_25);
  vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = tmpvar_25;
  vec3 tmpvar_28;
  tmpvar_28.xy = vec2(1.0, 1.0);
  tmpvar_28.z = tmpvar_25;
  vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_28 * tmpvar_6.yxz), mix ((tmpvar_26 * tmpvar_6.xzy), (tmpvar_27 * tmpvar_6.zxy), vec3(tmpvar_23)), vec3(tmpvar_24));
  uv_21 = (((
    (0.5 * tmpvar_29.yz)
   / 
    abs(tmpvar_29.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_30;
  vec2 tmpvar_31;
  tmpvar_31 = abs((uv_21 - tmpvar_18));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  vec4 tmpvar_32;
  tmpvar_32.xy = dFdx(uvCont_30);
  tmpvar_32.zw = dFdy(uvCont_30);
  vec4 tmpvar_33;
  tmpvar_33 = texture2DGradARB (_CityLightOverlayDetailTex, uv_21, tmpvar_32.xy, tmpvar_32.zw);
  citylightoverlaydetail_1.xyz = tmpvar_33.xyz;
  cityoverlay_3.w = (tmpvar_5.w * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_20.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_33.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_33.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_34;
  tmpvar_34 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_35;
  vec3 tmpvar_36;
  tmpvar_36 = normalize(_SunDir);
  vec3 tmpvar_37;
  tmpvar_37 = normalize(xlv_TEXCOORD4);
  float tmpvar_38;
  tmpvar_38 = dot (tmpvar_37, tmpvar_36);
  c_35.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_38) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_36 + normalize(xlv_TEXCOORD7)))
    , tmpvar_37), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_34.x * 2.0));
  c_35.w = (tmpvar_38 * (tmpvar_34.x * 2.0));
  float tmpvar_39;
  tmpvar_39 = dot (xlv_TEXCOORD4, tmpvar_36);
  color_4 = (c_35 * mix (1.0, clamp (
    floor((1.01 + tmpvar_39))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_39))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_40;
  tmpvar_40 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_40.xyz;
  color_4.w = (tmpvar_40.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 106 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  cityoverlay_4.xyz = tmpvar_8.xyz;
  mediump vec2 uv_9;
  mediump vec3 detailCoords_10;
  mediump float s_11;
  mediump float nylerp_12;
  mediump float zxlerp_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_6);
  highp float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  zxlerp_13 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  nylerp_12 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_13);
  s_11 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_6.y, s_11, nylerp_12));
  s_11 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(s_11);
  mediump vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = s_11;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_19 * tmpvar_6.xzy), (tmpvar_20 * tmpvar_6.zxy), vec3(zxlerp_13));
  detailCoords_10 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xy = vec2(1.0, 1.0);
  tmpvar_22.z = s_11;
  highp vec3 tmpvar_23;
  tmpvar_23 = mix ((tmpvar_22 * tmpvar_6.yxz), detailCoords_10, vec3(nylerp_12));
  detailCoords_10 = tmpvar_23;
  uv_9 = (((
    (0.5 * detailCoords_10.yz)
   / 
    abs(detailCoords_10.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_24;
  uv_24 = uv_9;
  highp vec2 uvCont_25;
  highp vec2 tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_24 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_9, tmpvar_28.xy, tmpvar_28.zw);
  mediump vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  citydarkoverlaydetail_3.xyz = tmpvar_30.xyz;
  mediump vec2 uv_31;
  mediump vec3 detailCoords_32;
  mediump float s_33;
  mediump float nylerp_34;
  mediump float zxlerp_35;
  highp vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_6);
  highp float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  zxlerp_35 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  nylerp_34 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_35);
  s_33 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = sign(mix (tmpvar_6.y, s_33, nylerp_34));
  s_33 = tmpvar_40;
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = -(s_33);
  mediump vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = s_33;
  highp vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_41 * tmpvar_6.xzy), (tmpvar_42 * tmpvar_6.zxy), vec3(zxlerp_35));
  detailCoords_32 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = s_33;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_6.yxz), detailCoords_32, vec3(nylerp_34));
  detailCoords_32 = tmpvar_45;
  uv_31 = (((
    (0.5 * detailCoords_32.yz)
   / 
    abs(detailCoords_32.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_46;
  uv_46 = uv_31;
  highp vec2 uvCont_47;
  highp vec2 tmpvar_48;
  tmpvar_48 = abs((uv_46 - tmpvar_27));
  uvCont_47.x = max (tmpvar_48.x, tmpvar_48.y);
  uvCont_47.y = min (tmpvar_48.x, tmpvar_48.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_47);
  tmpvar_49.zw = dFdy(uvCont_47);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_31, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citylightoverlaydetail_2.xyz = tmpvar_51.xyz;
  highp float tmpvar_52;
  tmpvar_52 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_8.w * (1.0 - tmpvar_52));
  citydarkoverlaydetail_3.w = (tmpvar_30.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_51.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_51.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_53;
  highp float tmpvar_54;
  tmpvar_54 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_53 = tmpvar_54;
  mediump vec3 lightDir_55;
  lightDir_55 = _SunDir;
  mediump vec3 viewDir_56;
  viewDir_56 = xlv_TEXCOORD7;
  mediump vec3 normal_57;
  normal_57 = xlv_TEXCOORD4;
  mediump float atten_58;
  atten_58 = tmpvar_53;
  mediump vec4 c_59;
  mediump vec3 tmpvar_60;
  tmpvar_60 = normalize(lightDir_55);
  lightDir_55 = tmpvar_60;
  mediump vec3 tmpvar_61;
  tmpvar_61 = normalize(viewDir_56);
  viewDir_56 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62 = normalize(normal_57);
  normal_57 = tmpvar_62;
  mediump float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, tmpvar_60);
  highp float tmpvar_64;
  mediump float tmpvar_65;
  tmpvar_65 = clamp (dot (normalize(
    (tmpvar_60 + tmpvar_61)
  ), tmpvar_62), 0.0, 1.0);
  tmpvar_64 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = (pow (tmpvar_64, _SpecularPower) * _SpecularColor.w);
  c_59.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_63) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_66)) * (atten_58 * 2.0));
  c_59.w = (tmpvar_63 * (atten_58 * 2.0));
  highp vec3 tmpvar_67;
  tmpvar_67 = normalize(_SunDir);
  mediump vec3 lightDir_68;
  lightDir_68 = tmpvar_67;
  mediump vec3 normal_69;
  normal_69 = xlv_TEXCOORD4;
  mediump float tmpvar_70;
  tmpvar_70 = dot (normal_69, lightDir_68);
  color_5 = (c_59 * mix (1.0, clamp (
    floor((1.01 + tmpvar_70))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_70))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_71;
  tmpvar_71 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_71.xyz;
  color_5.w = (tmpvar_71.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
bool tb5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t15 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t15 = inversesqrt(t15);
    t1.xyz = vec3(t15) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t5.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t10.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t10.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t10.x = t5.x + 1.00999999;
    t5.x = t5.x * -10.0;
    t5.x = clamp(t5.x, 0.0, 1.0);
    t10.x = floor(t10.x);
    t10.x = clamp(t10.x, 0.0, 1.0);
    t10.x = t10.x + -1.0;
    t5.x = t5.x * t10.x + 1.0;
    t0.x = t5.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t2.x = dFdx(t15);
    t3.x = dFdy(t15);
    t2.y = dFdx(t1.x);
    t3.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    tb5 = 0.0>=vs_TEXCOORD0.w;
    t5.x = (tb5) ? 0.0 : 1.0;
    t5.x = t5.x * t10_2.w;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 105 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  cityoverlay_4.xyz = tmpvar_8.xyz;
  mediump vec2 uv_9;
  mediump vec3 detailCoords_10;
  mediump float s_11;
  mediump float nylerp_12;
  mediump float zxlerp_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_6);
  highp float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  zxlerp_13 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  nylerp_12 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_13);
  s_11 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_6.y, s_11, nylerp_12));
  s_11 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(s_11);
  mediump vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = s_11;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_19 * tmpvar_6.xzy), (tmpvar_20 * tmpvar_6.zxy), vec3(zxlerp_13));
  detailCoords_10 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xy = vec2(1.0, 1.0);
  tmpvar_22.z = s_11;
  highp vec3 tmpvar_23;
  tmpvar_23 = mix ((tmpvar_22 * tmpvar_6.yxz), detailCoords_10, vec3(nylerp_12));
  detailCoords_10 = tmpvar_23;
  uv_9 = (((
    (0.5 * detailCoords_10.yz)
   / 
    abs(detailCoords_10.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_24;
  uv_24 = uv_9;
  highp vec2 uvCont_25;
  highp vec2 tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_24 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_9, tmpvar_28.xy, tmpvar_28.zw);
  mediump vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  citydarkoverlaydetail_3.xyz = tmpvar_30.xyz;
  mediump vec2 uv_31;
  mediump vec3 detailCoords_32;
  mediump float s_33;
  mediump float nylerp_34;
  mediump float zxlerp_35;
  highp vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_6);
  highp float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  zxlerp_35 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  nylerp_34 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_35);
  s_33 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = sign(mix (tmpvar_6.y, s_33, nylerp_34));
  s_33 = tmpvar_40;
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = -(s_33);
  mediump vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = s_33;
  highp vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_41 * tmpvar_6.xzy), (tmpvar_42 * tmpvar_6.zxy), vec3(zxlerp_35));
  detailCoords_32 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = s_33;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_6.yxz), detailCoords_32, vec3(nylerp_34));
  detailCoords_32 = tmpvar_45;
  uv_31 = (((
    (0.5 * detailCoords_32.yz)
   / 
    abs(detailCoords_32.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_46;
  uv_46 = uv_31;
  highp vec2 uvCont_47;
  highp vec2 tmpvar_48;
  tmpvar_48 = abs((uv_46 - tmpvar_27));
  uvCont_47.x = max (tmpvar_48.x, tmpvar_48.y);
  uvCont_47.y = min (tmpvar_48.x, tmpvar_48.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_47);
  tmpvar_49.zw = dFdy(uvCont_47);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_31, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citylightoverlaydetail_2.xyz = tmpvar_51.xyz;
  highp float tmpvar_52;
  tmpvar_52 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_8.w * (1.0 - tmpvar_52));
  citydarkoverlaydetail_3.w = (tmpvar_30.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_51.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_51.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_53;
  shadow_53 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_54;
  lightDir_54 = _SunDir;
  mediump vec3 viewDir_55;
  viewDir_55 = xlv_TEXCOORD7;
  mediump vec3 normal_56;
  normal_56 = xlv_TEXCOORD4;
  mediump float atten_57;
  atten_57 = shadow_53;
  mediump vec4 c_58;
  mediump vec3 tmpvar_59;
  tmpvar_59 = normalize(lightDir_54);
  lightDir_54 = tmpvar_59;
  mediump vec3 tmpvar_60;
  tmpvar_60 = normalize(viewDir_55);
  viewDir_55 = tmpvar_60;
  mediump vec3 tmpvar_61;
  tmpvar_61 = normalize(normal_56);
  normal_56 = tmpvar_61;
  mediump float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, tmpvar_59);
  highp float tmpvar_63;
  mediump float tmpvar_64;
  tmpvar_64 = clamp (dot (normalize(
    (tmpvar_59 + tmpvar_60)
  ), tmpvar_61), 0.0, 1.0);
  tmpvar_63 = tmpvar_64;
  highp float tmpvar_65;
  tmpvar_65 = (pow (tmpvar_63, _SpecularPower) * _SpecularColor.w);
  c_58.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_62) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_65)) * (atten_57 * 2.0));
  c_58.w = (tmpvar_62 * (atten_57 * 2.0));
  highp vec3 tmpvar_66;
  tmpvar_66 = normalize(_SunDir);
  mediump vec3 lightDir_67;
  lightDir_67 = tmpvar_66;
  mediump vec3 normal_68;
  normal_68 = xlv_TEXCOORD4;
  mediump float tmpvar_69;
  tmpvar_69 = dot (normal_68, lightDir_67);
  color_5 = (c_58 * mix (1.0, clamp (
    floor((1.01 + tmpvar_69))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_69))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_70;
  tmpvar_70 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_70.xyz;
  color_5.w = (tmpvar_70.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp float t10_2;
highp int ti2;
highp vec2 t3;
lowp vec4 t10_3;
bool tb3;
mediump vec3 t16_4;
highp vec3 t5;
highp vec3 t6;
mediump vec2 t16_7;
highp vec3 t9;
bool tb9;
highp vec3 t10;
bool tb10;
mediump float t16_14;
highp int ti17;
mediump float t16_21;
highp float t23;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_21 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_21 = inversesqrt(t16_21);
    t16_1.xyz = vec3(t16_21) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec26 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_7.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec26, 0.0);
    t16_14 = (-_LightShadowData.x) + 1.0;
    t16_7.x = t16_7.x * t16_14 + _LightShadowData.x;
    t16_0.x = dot(t16_7.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_7.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_14 = t16_7.x + 1.00999999;
    t16_7.x = t16_7.x * -10.0;
    t16_7.x = clamp(t16_7.x, 0.0, 1.0);
    t16_14 = floor(t16_14);
    t16_14 = clamp(t16_14, 0.0, 1.0);
    t16_14 = t16_14 + -1.0;
    t16_7.x = t16_7.x * t16_14 + 1.0;
    t16_0.x = t16_7.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t16_1.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t9.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t2.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t3.x = t10.x * t3.x + t9.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t3.x;
    t3.x = max(abs(t9.z), abs(t9.y));
    tb3 = t3.x>=abs(t9.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t2.x = t3.x * t2.x + t9.x;
    ti17 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti17) + ti2;
    t16_4.y = float(ti2);
    t16_1.y = (-t16_4.y);
    t5.xyz = t16_1.xyz * t9.yzx;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t9.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t9.xyz + t10.xyz;
    t5.xyz = t9.xyz * t16_4.xxy;
    t10_2 = texture(cube_CityOverlayTex, t9.yxz).w;
    t9.xyz = t3.xxx * t10.xyz + t5.xyz;
    t16_7.xy = vec2(t9.y * float(0.5), t9.z * float(0.5));
    t16_7.xy = t16_7.xy / abs(t9.xx);
    t16_7.xy = t16_7.xy + vec2(0.5, 0.5);
    t9.xy = t16_7.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t3.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t9.xy;
    t23 = max(abs(t3.y), abs(t3.x));
    t3.x = min(abs(t3.y), abs(t3.x));
    t5.x = dFdx(t23);
    t6.x = dFdy(t23);
    t5.y = dFdx(t3.x);
    t6.y = dFdy(t3.x);
    t10_1 = textureGrad(_CityDarkOverlayDetailTex, t9.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    t10_3 = textureGrad(_CityLightOverlayDetailTex, t9.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    tb9 = 0.0>=vs_TEXCOORD0.w;
    t9.x = (tb9) ? 0.0 : 1.0;
    t2.x = t9.x * t10_2;
    t16_7.x = t10_1.w * t2.x;
    t16_4.xyz = t10_1.xyz + (-t10_3.xyz);
    t16_14 = t2.x * t10_3.w;
    t16_21 = t16_7.x * t16_0.x + (-t16_14);
    t16_0.x = t16_0.x * t16_7.x;
    t16_7.x = t16_0.x * t16_21 + t16_14;
    t16_0.xzw = t16_0.xxx * t16_4.xyz + t10_3.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_7.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 105 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  cityoverlay_4.xyz = tmpvar_8.xyz;
  mediump vec2 uv_9;
  mediump vec3 detailCoords_10;
  mediump float s_11;
  mediump float nylerp_12;
  mediump float zxlerp_13;
  highp vec3 tmpvar_14;
  tmpvar_14 = abs(tmpvar_6);
  highp float tmpvar_15;
  tmpvar_15 = float((tmpvar_14.z >= tmpvar_14.x));
  zxlerp_13 = tmpvar_15;
  highp float tmpvar_16;
  tmpvar_16 = float((max (tmpvar_14.x, tmpvar_14.z) >= tmpvar_14.y));
  nylerp_12 = tmpvar_16;
  highp float tmpvar_17;
  tmpvar_17 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_13);
  s_11 = tmpvar_17;
  highp float tmpvar_18;
  tmpvar_18 = sign(mix (tmpvar_6.y, s_11, nylerp_12));
  s_11 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xz = vec2(1.0, -1.0);
  tmpvar_19.y = -(s_11);
  mediump vec3 tmpvar_20;
  tmpvar_20.xz = vec2(1.0, -1.0);
  tmpvar_20.y = s_11;
  highp vec3 tmpvar_21;
  tmpvar_21 = mix ((tmpvar_19 * tmpvar_6.xzy), (tmpvar_20 * tmpvar_6.zxy), vec3(zxlerp_13));
  detailCoords_10 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xy = vec2(1.0, 1.0);
  tmpvar_22.z = s_11;
  highp vec3 tmpvar_23;
  tmpvar_23 = mix ((tmpvar_22 * tmpvar_6.yxz), detailCoords_10, vec3(nylerp_12));
  detailCoords_10 = tmpvar_23;
  uv_9 = (((
    (0.5 * detailCoords_10.yz)
   / 
    abs(detailCoords_10.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_24;
  uv_24 = uv_9;
  highp vec2 uvCont_25;
  highp vec2 tmpvar_26;
  highp float tmpvar_27;
  tmpvar_27 = (0.5 * _CityOverlayDetailScale);
  tmpvar_26 = abs((uv_24 - tmpvar_27));
  uvCont_25.x = max (tmpvar_26.x, tmpvar_26.y);
  uvCont_25.y = min (tmpvar_26.x, tmpvar_26.y);
  highp vec4 tmpvar_28;
  tmpvar_28.xy = dFdx(uvCont_25);
  tmpvar_28.zw = dFdy(uvCont_25);
  lowp vec4 tmpvar_29;
  tmpvar_29 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_9, tmpvar_28.xy, tmpvar_28.zw);
  mediump vec4 tmpvar_30;
  tmpvar_30 = tmpvar_29;
  citydarkoverlaydetail_3.xyz = tmpvar_30.xyz;
  mediump vec2 uv_31;
  mediump vec3 detailCoords_32;
  mediump float s_33;
  mediump float nylerp_34;
  mediump float zxlerp_35;
  highp vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_6);
  highp float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  zxlerp_35 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  nylerp_34 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_35);
  s_33 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = sign(mix (tmpvar_6.y, s_33, nylerp_34));
  s_33 = tmpvar_40;
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = -(s_33);
  mediump vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = s_33;
  highp vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_41 * tmpvar_6.xzy), (tmpvar_42 * tmpvar_6.zxy), vec3(zxlerp_35));
  detailCoords_32 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = s_33;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_6.yxz), detailCoords_32, vec3(nylerp_34));
  detailCoords_32 = tmpvar_45;
  uv_31 = (((
    (0.5 * detailCoords_32.yz)
   / 
    abs(detailCoords_32.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_46;
  uv_46 = uv_31;
  highp vec2 uvCont_47;
  highp vec2 tmpvar_48;
  tmpvar_48 = abs((uv_46 - tmpvar_27));
  uvCont_47.x = max (tmpvar_48.x, tmpvar_48.y);
  uvCont_47.y = min (tmpvar_48.x, tmpvar_48.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_47);
  tmpvar_49.zw = dFdy(uvCont_47);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_31, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citylightoverlaydetail_2.xyz = tmpvar_51.xyz;
  highp float tmpvar_52;
  tmpvar_52 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_8.w * (1.0 - tmpvar_52));
  citydarkoverlaydetail_3.w = (tmpvar_30.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_51.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_51.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_53;
  shadow_53 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_54;
  lightDir_54 = _SunDir;
  mediump vec3 viewDir_55;
  viewDir_55 = xlv_TEXCOORD7;
  mediump vec3 normal_56;
  normal_56 = xlv_TEXCOORD4;
  mediump float atten_57;
  atten_57 = shadow_53;
  mediump vec4 c_58;
  mediump vec3 tmpvar_59;
  tmpvar_59 = normalize(lightDir_54);
  lightDir_54 = tmpvar_59;
  mediump vec3 tmpvar_60;
  tmpvar_60 = normalize(viewDir_55);
  viewDir_55 = tmpvar_60;
  mediump vec3 tmpvar_61;
  tmpvar_61 = normalize(normal_56);
  normal_56 = tmpvar_61;
  mediump float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, tmpvar_59);
  highp float tmpvar_63;
  mediump float tmpvar_64;
  tmpvar_64 = clamp (dot (normalize(
    (tmpvar_59 + tmpvar_60)
  ), tmpvar_61), 0.0, 1.0);
  tmpvar_63 = tmpvar_64;
  highp float tmpvar_65;
  tmpvar_65 = (pow (tmpvar_63, _SpecularPower) * _SpecularColor.w);
  c_58.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_62) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_65)) * (atten_57 * 2.0));
  c_58.w = (tmpvar_62 * (atten_57 * 2.0));
  highp vec3 tmpvar_66;
  tmpvar_66 = normalize(_SunDir);
  mediump vec3 lightDir_67;
  lightDir_67 = tmpvar_66;
  mediump vec3 normal_68;
  normal_68 = xlv_TEXCOORD4;
  mediump float tmpvar_69;
  tmpvar_69 = dot (normal_68, lightDir_67);
  color_5 = (c_58 * mix (1.0, clamp (
    floor((1.01 + tmpvar_69))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_69))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_70;
  tmpvar_70 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_70.xyz;
  color_5.w = (tmpvar_70.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp float t10_2;
highp int ti2;
highp vec2 t3;
lowp vec4 t10_3;
bool tb3;
mediump vec3 t16_4;
highp vec3 t5;
highp vec3 t6;
mediump vec2 t16_7;
highp vec3 t9;
bool tb9;
highp vec3 t10;
bool tb10;
mediump float t16_14;
highp int ti17;
mediump float t16_21;
highp float t23;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_21 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_21 = inversesqrt(t16_21);
    t16_1.xyz = vec3(t16_21) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec20 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_7.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec20, 0.0);
    t16_14 = (-_LightShadowData.x) + 1.0;
    t16_7.x = t16_7.x * t16_14 + _LightShadowData.x;
    t16_0.x = dot(t16_7.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_7.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_14 = t16_7.x + 1.00999999;
    t16_7.x = t16_7.x * -10.0;
    t16_7.x = clamp(t16_7.x, 0.0, 1.0);
    t16_14 = floor(t16_14);
    t16_14 = clamp(t16_14, 0.0, 1.0);
    t16_14 = t16_14 + -1.0;
    t16_7.x = t16_7.x * t16_14 + 1.0;
    t16_0.x = t16_7.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t16_1.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t9.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t2.x + (-t9.y);
    tb10 = abs(t9.z)>=abs(t9.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t3.x = t10.x * t3.x + t9.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t3.x;
    t3.x = max(abs(t9.z), abs(t9.y));
    tb3 = t3.x>=abs(t9.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t2.x = t3.x * t2.x + t9.x;
    ti17 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti17) + ti2;
    t16_4.y = float(ti2);
    t16_1.y = (-t16_4.y);
    t5.xyz = t16_1.xyz * t9.yzx;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t9.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t9.xyz + t10.xyz;
    t5.xyz = t9.xyz * t16_4.xxy;
    t10_2 = texture(cube_CityOverlayTex, t9.yxz).w;
    t9.xyz = t3.xxx * t10.xyz + t5.xyz;
    t16_7.xy = vec2(t9.y * float(0.5), t9.z * float(0.5));
    t16_7.xy = t16_7.xy / abs(t9.xx);
    t16_7.xy = t16_7.xy + vec2(0.5, 0.5);
    t9.xy = t16_7.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t3.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t9.xy;
    t23 = max(abs(t3.y), abs(t3.x));
    t3.x = min(abs(t3.y), abs(t3.x));
    t5.x = dFdx(t23);
    t6.x = dFdy(t23);
    t5.y = dFdx(t3.x);
    t6.y = dFdy(t3.x);
    t10_1 = textureGrad(_CityDarkOverlayDetailTex, t9.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    t10_3 = textureGrad(_CityLightOverlayDetailTex, t9.xy, vec4(t5.xyxx).xy, vec4(t6.xyxx).xy);
    tb9 = 0.0>=vs_TEXCOORD0.w;
    t9.x = (tb9) ? 0.0 : 1.0;
    t2.x = t9.x * t10_2;
    t16_7.x = t10_1.w * t2.x;
    t16_4.xyz = t10_1.xyz + (-t10_3.xyz);
    t16_14 = t2.x * t10_3.w;
    t16_21 = t16_7.x * t16_0.x + (-t16_14);
    t16_0.x = t16_0.x * t16_7.x;
    t16_7.x = t16_0.x * t16_21 + t16_14;
    t16_0.xzw = t16_0.xxx * t16_4.xyz + t10_3.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_7.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 104 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  float tmpvar_5;
  vec4 v_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5);
  v_6 = (textureCube (cube_CityOverlayTex, tmpvar_7) * alphaMask1);
  tmpvar_5 = ((v_6.x + v_6.y) + (v_6.z + v_6.w));
  vec4 tmpvar_8;
  tmpvar_8.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_8.w = tmpvar_5;
  cityoverlay_3.xyz = tmpvar_8.xyz;
  vec2 uv_9;
  vec3 tmpvar_10;
  tmpvar_10 = abs(tmpvar_7);
  float tmpvar_11;
  tmpvar_11 = float((tmpvar_10.z >= tmpvar_10.x));
  float tmpvar_12;
  tmpvar_12 = float((max (tmpvar_10.x, tmpvar_10.z) >= tmpvar_10.y));
  float tmpvar_13;
  tmpvar_13 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_11), tmpvar_12));
  vec3 tmpvar_14;
  tmpvar_14.xz = vec2(1.0, -1.0);
  tmpvar_14.y = -(tmpvar_13);
  vec3 tmpvar_15;
  tmpvar_15.xz = vec2(1.0, -1.0);
  tmpvar_15.y = tmpvar_13;
  vec3 tmpvar_16;
  tmpvar_16.xy = vec2(1.0, 1.0);
  tmpvar_16.z = tmpvar_13;
  vec3 tmpvar_17;
  tmpvar_17 = mix ((tmpvar_16 * tmpvar_7.yxz), mix ((tmpvar_14 * tmpvar_7.xzy), (tmpvar_15 * tmpvar_7.zxy), vec3(tmpvar_11)), vec3(tmpvar_12));
  uv_9 = (((
    (0.5 * tmpvar_17.yz)
   / 
    abs(tmpvar_17.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_18;
  vec2 tmpvar_19;
  float tmpvar_20;
  tmpvar_20 = (0.5 * _CityOverlayDetailScale);
  tmpvar_19 = abs((uv_9 - tmpvar_20));
  uvCont_18.x = max (tmpvar_19.x, tmpvar_19.y);
  uvCont_18.y = min (tmpvar_19.x, tmpvar_19.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_18);
  tmpvar_21.zw = dFdy(uvCont_18);
  vec4 tmpvar_22;
  tmpvar_22 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_9, tmpvar_21.xy, tmpvar_21.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_22.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_7);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_7.yxz), mix ((tmpvar_28 * tmpvar_7.xzy), (tmpvar_29 * tmpvar_7.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  tmpvar_33 = abs((uv_23 - tmpvar_20));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_34;
  tmpvar_34.xy = dFdx(uvCont_32);
  tmpvar_34.zw = dFdy(uvCont_32);
  vec4 tmpvar_35;
  tmpvar_35 = texture2DGradARB (_CityLightOverlayDetailTex, uv_23, tmpvar_34.xy, tmpvar_34.zw);
  citylightoverlaydetail_1.xyz = tmpvar_35.xyz;
  cityoverlay_3.w = (tmpvar_5 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_22.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_35.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_35.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_36;
  vec3 tmpvar_37;
  tmpvar_37 = normalize(_SunDir);
  vec3 tmpvar_38;
  tmpvar_38 = normalize(xlv_TEXCOORD4);
  float tmpvar_39;
  tmpvar_39 = dot (tmpvar_38, tmpvar_37);
  c_36.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_39) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_37 + normalize(xlv_TEXCOORD7)))
    , tmpvar_38), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_36.w = (tmpvar_39 * 2.0);
  float tmpvar_40;
  tmpvar_40 = dot (xlv_TEXCOORD4, tmpvar_37);
  color_4 = (c_36 * mix (1.0, clamp (
    floor((1.01 + tmpvar_40))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_40))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_41;
  tmpvar_41 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_41.xyz;
  color_4.w = (tmpvar_41.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 105 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  mediump float tmpvar_9;
  mediump vec4 v_10;
  v_10 = (tmpvar_8 * alphaMask1);
  tmpvar_9 = ((v_10.x + v_10.y) + (v_10.z + v_10.w));
  mediump vec4 tmpvar_11;
  tmpvar_11.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_11.w = tmpvar_9;
  cityoverlay_4.xyz = tmpvar_11.xyz;
  mediump vec2 uv_12;
  mediump vec3 detailCoords_13;
  mediump float s_14;
  mediump float nylerp_15;
  mediump float zxlerp_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_6);
  highp float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  zxlerp_16 = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  nylerp_15 = tmpvar_19;
  highp float tmpvar_20;
  tmpvar_20 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_16);
  s_14 = tmpvar_20;
  highp float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_6.y, s_14, nylerp_15));
  s_14 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(s_14);
  mediump vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = s_14;
  highp vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_22 * tmpvar_6.xzy), (tmpvar_23 * tmpvar_6.zxy), vec3(zxlerp_16));
  detailCoords_13 = tmpvar_24;
  mediump vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = s_14;
  highp vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_6.yxz), detailCoords_13, vec3(nylerp_15));
  detailCoords_13 = tmpvar_26;
  uv_12 = (((
    (0.5 * detailCoords_13.yz)
   / 
    abs(detailCoords_13.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_27;
  uv_27 = uv_12;
  highp vec2 uvCont_28;
  highp vec2 tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (0.5 * _CityOverlayDetailScale);
  tmpvar_29 = abs((uv_27 - tmpvar_30));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_28);
  tmpvar_31.zw = dFdy(uvCont_28);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_12, tmpvar_31.xy, tmpvar_31.zw);
  mediump vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  citydarkoverlaydetail_3.xyz = tmpvar_33.xyz;
  mediump vec2 uv_34;
  mediump vec3 detailCoords_35;
  mediump float s_36;
  mediump float nylerp_37;
  mediump float zxlerp_38;
  highp vec3 tmpvar_39;
  tmpvar_39 = abs(tmpvar_6);
  highp float tmpvar_40;
  tmpvar_40 = float((tmpvar_39.z >= tmpvar_39.x));
  zxlerp_38 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = float((max (tmpvar_39.x, tmpvar_39.z) >= tmpvar_39.y));
  nylerp_37 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_38);
  s_36 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_6.y, s_36, nylerp_37));
  s_36 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(s_36);
  mediump vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = s_36;
  highp vec3 tmpvar_46;
  tmpvar_46 = mix ((tmpvar_44 * tmpvar_6.xzy), (tmpvar_45 * tmpvar_6.zxy), vec3(zxlerp_38));
  detailCoords_35 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xy = vec2(1.0, 1.0);
  tmpvar_47.z = s_36;
  highp vec3 tmpvar_48;
  tmpvar_48 = mix ((tmpvar_47 * tmpvar_6.yxz), detailCoords_35, vec3(nylerp_37));
  detailCoords_35 = tmpvar_48;
  uv_34 = (((
    (0.5 * detailCoords_35.yz)
   / 
    abs(detailCoords_35.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_49;
  uv_49 = uv_34;
  highp vec2 uvCont_50;
  highp vec2 tmpvar_51;
  tmpvar_51 = abs((uv_49 - tmpvar_30));
  uvCont_50.x = max (tmpvar_51.x, tmpvar_51.y);
  uvCont_50.y = min (tmpvar_51.x, tmpvar_51.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_50);
  tmpvar_52.zw = dFdy(uvCont_50);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_34, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citylightoverlaydetail_2.xyz = tmpvar_54.xyz;
  highp float tmpvar_55;
  tmpvar_55 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_9 * (1.0 - tmpvar_55));
  citydarkoverlaydetail_3.w = (tmpvar_33.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_54.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_54.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_56;
  lightDir_56 = _SunDir;
  mediump vec3 viewDir_57;
  viewDir_57 = xlv_TEXCOORD7;
  mediump vec3 normal_58;
  normal_58 = xlv_TEXCOORD4;
  mediump vec4 c_59;
  mediump vec3 tmpvar_60;
  tmpvar_60 = normalize(lightDir_56);
  lightDir_56 = tmpvar_60;
  mediump vec3 tmpvar_61;
  tmpvar_61 = normalize(viewDir_57);
  viewDir_57 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62 = normalize(normal_58);
  normal_58 = tmpvar_62;
  mediump float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, tmpvar_60);
  highp float tmpvar_64;
  mediump float tmpvar_65;
  tmpvar_65 = clamp (dot (normalize(
    (tmpvar_60 + tmpvar_61)
  ), tmpvar_62), 0.0, 1.0);
  tmpvar_64 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = (pow (tmpvar_64, _SpecularPower) * _SpecularColor.w);
  c_59.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_63) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_66)) * 2.0);
  c_59.w = (tmpvar_63 * 2.0);
  highp vec3 tmpvar_67;
  tmpvar_67 = normalize(_SunDir);
  mediump vec3 lightDir_68;
  lightDir_68 = tmpvar_67;
  mediump vec3 normal_69;
  normal_69 = xlv_TEXCOORD4;
  mediump float tmpvar_70;
  tmpvar_70 = dot (normal_69, lightDir_68);
  color_5 = (c_59 * mix (1.0, clamp (
    floor((1.01 + tmpvar_70))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_70))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_71;
  tmpvar_71 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_71.xyz;
  color_5.w = (tmpvar_71.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec3 t3;
lowp vec4 t10_3;
bool tb3;
mediump vec3 t16_4;
highp vec3 t5;
highp vec3 t6;
highp vec3 t7;
mediump vec3 t16_8;
highp vec3 t10;
bool tb10;
mediump float t16_15;
highp vec2 t17;
highp int ti17;
mediump float t16_22;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_8.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_8.x = floor(t16_8.x);
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_8.x = t16_8.x + -1.0;
    t16_1.x = t16_1.x * t16_8.x + 1.0;
    t16_8.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_8.x = inversesqrt(t16_8.x);
    t16_8.xyz = t16_8.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_8.x = dot(t16_2.xyz, t16_8.xyz);
    t16_8.x = t16_8.x + t16_8.x;
    t16_1.x = t16_1.x * t16_8.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t16_2.xz = vec2(1.0, -1.0);
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t7.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t0.x + (-t7.y);
    tb10 = abs(t7.z)>=abs(t7.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t3.x = t10.x * t3.x + t7.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t3.x;
    t3.x = max(abs(t7.z), abs(t7.y));
    tb3 = t3.x>=abs(t7.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t0.x = t3.x * t0.x + t7.x;
    ti17 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti17) + ti0;
    t16_4.y = float(ti0);
    t16_2.y = (-t16_4.y);
    t5.xyz = t7.yzx * t16_2.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t7.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t7.xyz + t10.xyz;
    t5.xyz = t7.xyz * t16_4.xxy;
    t10_0 = texture(cube_CityOverlayTex, t7.yxz);
    t3.xyz = t3.xxx * t10.xyz + t5.xyz;
    t16_8.xy = vec2(t3.y * float(0.5), t3.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t3.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t3.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t17.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t3.xy;
    t5.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t6.x = dFdx(t5.x);
    t5.x = dFdy(t5.x);
    t6.y = dFdx(t17.x);
    t5.y = dFdy(t17.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t3.xy, vec4(t6.xyxx).xy, vec4(t5.xyxx).xy);
    t10_3 = textureGrad(_CityLightOverlayDetailTex, t3.xy, vec4(t6.xyxx).xy, vec4(t5.xyxx).xy);
    t16_8.xy = t10_0.xy * alphaMask1.xy;
    t16_8.x = t16_8.y + t16_8.x;
    t16_8.x = t10_0.z * alphaMask1.z + t16_8.x;
    t16_8.x = t10_0.w * alphaMask1.w + t16_8.x;
    tb0 = 0.0>=vs_TEXCOORD0.w;
    t0.x = (tb0) ? 0.0 : 1.0;
    t0.x = t0.x * t16_8.x;
    t16_8.x = t0.x * t10_2.w;
    t16_4.xyz = t10_2.xyz + (-t10_3.xyz);
    t16_15 = t0.x * t10_3.w;
    t16_22 = t16_8.x * t16_1.x + (-t16_15);
    t16_1.x = t16_1.x * t16_8.x;
    t16_8.x = t16_1.x * t16_22 + t16_15;
    t16_1.xzw = t16_1.xxx * t16_4.xyz + t10_3.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t15 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t15 + 1.00999999;
    t15 = t15 * -10.0;
    t15 = clamp(t15, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t15 = t15 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t15 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t15);
    t4.x = dFdy(t15);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t5.xy = t10_2.xy * alphaMask1.xy;
    t5.x = t5.y + t5.x;
    t5.x = t10_2.z * alphaMask1.z + t5.x;
    t5.x = t10_2.w * alphaMask1.w + t5.x;
    tb10 = 0.0>=vs_TEXCOORD0.w;
    t10.x = (tb10) ? 0.0 : 1.0;
    t5.x = t10.x * t5.x;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 106 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  float tmpvar_5;
  vec4 v_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5);
  v_6 = (textureCube (cube_CityOverlayTex, tmpvar_7) * alphaMask1);
  tmpvar_5 = ((v_6.x + v_6.y) + (v_6.z + v_6.w));
  vec4 tmpvar_8;
  tmpvar_8.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_8.w = tmpvar_5;
  cityoverlay_3.xyz = tmpvar_8.xyz;
  vec2 uv_9;
  vec3 tmpvar_10;
  tmpvar_10 = abs(tmpvar_7);
  float tmpvar_11;
  tmpvar_11 = float((tmpvar_10.z >= tmpvar_10.x));
  float tmpvar_12;
  tmpvar_12 = float((max (tmpvar_10.x, tmpvar_10.z) >= tmpvar_10.y));
  float tmpvar_13;
  tmpvar_13 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_11), tmpvar_12));
  vec3 tmpvar_14;
  tmpvar_14.xz = vec2(1.0, -1.0);
  tmpvar_14.y = -(tmpvar_13);
  vec3 tmpvar_15;
  tmpvar_15.xz = vec2(1.0, -1.0);
  tmpvar_15.y = tmpvar_13;
  vec3 tmpvar_16;
  tmpvar_16.xy = vec2(1.0, 1.0);
  tmpvar_16.z = tmpvar_13;
  vec3 tmpvar_17;
  tmpvar_17 = mix ((tmpvar_16 * tmpvar_7.yxz), mix ((tmpvar_14 * tmpvar_7.xzy), (tmpvar_15 * tmpvar_7.zxy), vec3(tmpvar_11)), vec3(tmpvar_12));
  uv_9 = (((
    (0.5 * tmpvar_17.yz)
   / 
    abs(tmpvar_17.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_18;
  vec2 tmpvar_19;
  float tmpvar_20;
  tmpvar_20 = (0.5 * _CityOverlayDetailScale);
  tmpvar_19 = abs((uv_9 - tmpvar_20));
  uvCont_18.x = max (tmpvar_19.x, tmpvar_19.y);
  uvCont_18.y = min (tmpvar_19.x, tmpvar_19.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_18);
  tmpvar_21.zw = dFdy(uvCont_18);
  vec4 tmpvar_22;
  tmpvar_22 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_9, tmpvar_21.xy, tmpvar_21.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_22.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_7);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_7.yxz), mix ((tmpvar_28 * tmpvar_7.xzy), (tmpvar_29 * tmpvar_7.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  tmpvar_33 = abs((uv_23 - tmpvar_20));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_34;
  tmpvar_34.xy = dFdx(uvCont_32);
  tmpvar_34.zw = dFdy(uvCont_32);
  vec4 tmpvar_35;
  tmpvar_35 = texture2DGradARB (_CityLightOverlayDetailTex, uv_23, tmpvar_34.xy, tmpvar_34.zw);
  citylightoverlaydetail_1.xyz = tmpvar_35.xyz;
  cityoverlay_3.w = (tmpvar_5 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_22.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_35.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_35.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_36;
  tmpvar_36 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_37;
  vec3 tmpvar_38;
  tmpvar_38 = normalize(_SunDir);
  vec3 tmpvar_39;
  tmpvar_39 = normalize(xlv_TEXCOORD4);
  float tmpvar_40;
  tmpvar_40 = dot (tmpvar_39, tmpvar_38);
  c_37.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_40) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_38 + normalize(xlv_TEXCOORD7)))
    , tmpvar_39), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_36.x * 2.0));
  c_37.w = (tmpvar_40 * (tmpvar_36.x * 2.0));
  float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD4, tmpvar_38);
  color_4 = (c_37 * mix (1.0, clamp (
    floor((1.01 + tmpvar_41))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_41))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_42;
  tmpvar_42 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_42.xyz;
  color_4.w = (tmpvar_42.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 111 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  mediump float tmpvar_9;
  mediump vec4 v_10;
  v_10 = (tmpvar_8 * alphaMask1);
  tmpvar_9 = ((v_10.x + v_10.y) + (v_10.z + v_10.w));
  mediump vec4 tmpvar_11;
  tmpvar_11.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_11.w = tmpvar_9;
  cityoverlay_4.xyz = tmpvar_11.xyz;
  mediump vec2 uv_12;
  mediump vec3 detailCoords_13;
  mediump float s_14;
  mediump float nylerp_15;
  mediump float zxlerp_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_6);
  highp float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  zxlerp_16 = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  nylerp_15 = tmpvar_19;
  highp float tmpvar_20;
  tmpvar_20 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_16);
  s_14 = tmpvar_20;
  highp float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_6.y, s_14, nylerp_15));
  s_14 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(s_14);
  mediump vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = s_14;
  highp vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_22 * tmpvar_6.xzy), (tmpvar_23 * tmpvar_6.zxy), vec3(zxlerp_16));
  detailCoords_13 = tmpvar_24;
  mediump vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = s_14;
  highp vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_6.yxz), detailCoords_13, vec3(nylerp_15));
  detailCoords_13 = tmpvar_26;
  uv_12 = (((
    (0.5 * detailCoords_13.yz)
   / 
    abs(detailCoords_13.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_27;
  uv_27 = uv_12;
  highp vec2 uvCont_28;
  highp vec2 tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (0.5 * _CityOverlayDetailScale);
  tmpvar_29 = abs((uv_27 - tmpvar_30));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_28);
  tmpvar_31.zw = dFdy(uvCont_28);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_12, tmpvar_31.xy, tmpvar_31.zw);
  mediump vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  citydarkoverlaydetail_3.xyz = tmpvar_33.xyz;
  mediump vec2 uv_34;
  mediump vec3 detailCoords_35;
  mediump float s_36;
  mediump float nylerp_37;
  mediump float zxlerp_38;
  highp vec3 tmpvar_39;
  tmpvar_39 = abs(tmpvar_6);
  highp float tmpvar_40;
  tmpvar_40 = float((tmpvar_39.z >= tmpvar_39.x));
  zxlerp_38 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = float((max (tmpvar_39.x, tmpvar_39.z) >= tmpvar_39.y));
  nylerp_37 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_38);
  s_36 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_6.y, s_36, nylerp_37));
  s_36 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(s_36);
  mediump vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = s_36;
  highp vec3 tmpvar_46;
  tmpvar_46 = mix ((tmpvar_44 * tmpvar_6.xzy), (tmpvar_45 * tmpvar_6.zxy), vec3(zxlerp_38));
  detailCoords_35 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xy = vec2(1.0, 1.0);
  tmpvar_47.z = s_36;
  highp vec3 tmpvar_48;
  tmpvar_48 = mix ((tmpvar_47 * tmpvar_6.yxz), detailCoords_35, vec3(nylerp_37));
  detailCoords_35 = tmpvar_48;
  uv_34 = (((
    (0.5 * detailCoords_35.yz)
   / 
    abs(detailCoords_35.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_49;
  uv_49 = uv_34;
  highp vec2 uvCont_50;
  highp vec2 tmpvar_51;
  tmpvar_51 = abs((uv_49 - tmpvar_30));
  uvCont_50.x = max (tmpvar_51.x, tmpvar_51.y);
  uvCont_50.y = min (tmpvar_51.x, tmpvar_51.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_50);
  tmpvar_52.zw = dFdy(uvCont_50);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_34, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citylightoverlaydetail_2.xyz = tmpvar_54.xyz;
  highp float tmpvar_55;
  tmpvar_55 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_9 * (1.0 - tmpvar_55));
  citydarkoverlaydetail_3.w = (tmpvar_33.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_54.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_54.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_56;
  highp float tmpvar_57;
  tmpvar_57 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_56 = tmpvar_57;
  mediump vec3 lightDir_58;
  lightDir_58 = _SunDir;
  mediump vec3 viewDir_59;
  viewDir_59 = xlv_TEXCOORD7;
  mediump vec3 normal_60;
  normal_60 = xlv_TEXCOORD4;
  mediump float atten_61;
  atten_61 = tmpvar_56;
  mediump vec4 c_62;
  mediump vec3 tmpvar_63;
  tmpvar_63 = normalize(lightDir_58);
  lightDir_58 = tmpvar_63;
  mediump vec3 tmpvar_64;
  tmpvar_64 = normalize(viewDir_59);
  viewDir_59 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65 = normalize(normal_60);
  normal_60 = tmpvar_65;
  mediump float tmpvar_66;
  tmpvar_66 = dot (tmpvar_65, tmpvar_63);
  highp float tmpvar_67;
  mediump float tmpvar_68;
  tmpvar_68 = clamp (dot (normalize(
    (tmpvar_63 + tmpvar_64)
  ), tmpvar_65), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = (pow (tmpvar_67, _SpecularPower) * _SpecularColor.w);
  c_62.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_66) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_69)) * (atten_61 * 2.0));
  c_62.w = (tmpvar_66 * (atten_61 * 2.0));
  highp vec3 tmpvar_70;
  tmpvar_70 = normalize(_SunDir);
  mediump vec3 lightDir_71;
  lightDir_71 = tmpvar_70;
  mediump vec3 normal_72;
  normal_72 = xlv_TEXCOORD4;
  mediump float tmpvar_73;
  tmpvar_73 = dot (normal_72, lightDir_71);
  color_5 = (c_62 * mix (1.0, clamp (
    floor((1.01 + tmpvar_73))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_73))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_74;
  tmpvar_74 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_74.xyz;
  color_5.w = (tmpvar_74.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t15 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t15 = inversesqrt(t15);
    t1.xyz = vec3(t15) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t5.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t10.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t10.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t10.x = t5.x + 1.00999999;
    t5.x = t5.x * -10.0;
    t5.x = clamp(t5.x, 0.0, 1.0);
    t10.x = floor(t10.x);
    t10.x = clamp(t10.x, 0.0, 1.0);
    t10.x = t10.x + -1.0;
    t5.x = t5.x * t10.x + 1.0;
    t0.x = t5.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t15);
    t4.x = dFdy(t15);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t5.xy = t10_2.xy * alphaMask1.xy;
    t5.x = t5.y + t5.x;
    t5.x = t10_2.z * alphaMask1.z + t5.x;
    t5.x = t10_2.w * alphaMask1.w + t5.x;
    tb10 = 0.0>=vs_TEXCOORD0.w;
    t10.x = (tb10) ? 0.0 : 1.0;
    t5.x = t10.x * t5.x;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 104 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  float tmpvar_5;
  vec4 v_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5);
  v_6 = (textureCube (cube_CityOverlayTex, tmpvar_7) * alphaMask1);
  tmpvar_5 = ((v_6.x + v_6.y) + (v_6.z + v_6.w));
  vec4 tmpvar_8;
  tmpvar_8.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_8.w = tmpvar_5;
  cityoverlay_3.xyz = tmpvar_8.xyz;
  vec2 uv_9;
  vec3 tmpvar_10;
  tmpvar_10 = abs(tmpvar_7);
  float tmpvar_11;
  tmpvar_11 = float((tmpvar_10.z >= tmpvar_10.x));
  float tmpvar_12;
  tmpvar_12 = float((max (tmpvar_10.x, tmpvar_10.z) >= tmpvar_10.y));
  float tmpvar_13;
  tmpvar_13 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_11), tmpvar_12));
  vec3 tmpvar_14;
  tmpvar_14.xz = vec2(1.0, -1.0);
  tmpvar_14.y = -(tmpvar_13);
  vec3 tmpvar_15;
  tmpvar_15.xz = vec2(1.0, -1.0);
  tmpvar_15.y = tmpvar_13;
  vec3 tmpvar_16;
  tmpvar_16.xy = vec2(1.0, 1.0);
  tmpvar_16.z = tmpvar_13;
  vec3 tmpvar_17;
  tmpvar_17 = mix ((tmpvar_16 * tmpvar_7.yxz), mix ((tmpvar_14 * tmpvar_7.xzy), (tmpvar_15 * tmpvar_7.zxy), vec3(tmpvar_11)), vec3(tmpvar_12));
  uv_9 = (((
    (0.5 * tmpvar_17.yz)
   / 
    abs(tmpvar_17.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_18;
  vec2 tmpvar_19;
  float tmpvar_20;
  tmpvar_20 = (0.5 * _CityOverlayDetailScale);
  tmpvar_19 = abs((uv_9 - tmpvar_20));
  uvCont_18.x = max (tmpvar_19.x, tmpvar_19.y);
  uvCont_18.y = min (tmpvar_19.x, tmpvar_19.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_18);
  tmpvar_21.zw = dFdy(uvCont_18);
  vec4 tmpvar_22;
  tmpvar_22 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_9, tmpvar_21.xy, tmpvar_21.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_22.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_7);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_7.yxz), mix ((tmpvar_28 * tmpvar_7.xzy), (tmpvar_29 * tmpvar_7.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  tmpvar_33 = abs((uv_23 - tmpvar_20));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_34;
  tmpvar_34.xy = dFdx(uvCont_32);
  tmpvar_34.zw = dFdy(uvCont_32);
  vec4 tmpvar_35;
  tmpvar_35 = texture2DGradARB (_CityLightOverlayDetailTex, uv_23, tmpvar_34.xy, tmpvar_34.zw);
  citylightoverlaydetail_1.xyz = tmpvar_35.xyz;
  cityoverlay_3.w = (tmpvar_5 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_22.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_35.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_35.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_36;
  vec3 tmpvar_37;
  tmpvar_37 = normalize(_SunDir);
  vec3 tmpvar_38;
  tmpvar_38 = normalize(xlv_TEXCOORD4);
  float tmpvar_39;
  tmpvar_39 = dot (tmpvar_38, tmpvar_37);
  c_36.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_39) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_37 + normalize(xlv_TEXCOORD7)))
    , tmpvar_38), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_36.w = (tmpvar_39 * 2.0);
  float tmpvar_40;
  tmpvar_40 = dot (xlv_TEXCOORD4, tmpvar_37);
  color_4 = (c_36 * mix (1.0, clamp (
    floor((1.01 + tmpvar_40))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_40))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_41;
  tmpvar_41 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_41.xyz;
  color_4.w = (tmpvar_41.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 105 math, 3 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  mediump float tmpvar_9;
  mediump vec4 v_10;
  v_10 = (tmpvar_8 * alphaMask1);
  tmpvar_9 = ((v_10.x + v_10.y) + (v_10.z + v_10.w));
  mediump vec4 tmpvar_11;
  tmpvar_11.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_11.w = tmpvar_9;
  cityoverlay_4.xyz = tmpvar_11.xyz;
  mediump vec2 uv_12;
  mediump vec3 detailCoords_13;
  mediump float s_14;
  mediump float nylerp_15;
  mediump float zxlerp_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_6);
  highp float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  zxlerp_16 = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  nylerp_15 = tmpvar_19;
  highp float tmpvar_20;
  tmpvar_20 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_16);
  s_14 = tmpvar_20;
  highp float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_6.y, s_14, nylerp_15));
  s_14 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(s_14);
  mediump vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = s_14;
  highp vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_22 * tmpvar_6.xzy), (tmpvar_23 * tmpvar_6.zxy), vec3(zxlerp_16));
  detailCoords_13 = tmpvar_24;
  mediump vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = s_14;
  highp vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_6.yxz), detailCoords_13, vec3(nylerp_15));
  detailCoords_13 = tmpvar_26;
  uv_12 = (((
    (0.5 * detailCoords_13.yz)
   / 
    abs(detailCoords_13.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_27;
  uv_27 = uv_12;
  highp vec2 uvCont_28;
  highp vec2 tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (0.5 * _CityOverlayDetailScale);
  tmpvar_29 = abs((uv_27 - tmpvar_30));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_28);
  tmpvar_31.zw = dFdy(uvCont_28);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_12, tmpvar_31.xy, tmpvar_31.zw);
  mediump vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  citydarkoverlaydetail_3.xyz = tmpvar_33.xyz;
  mediump vec2 uv_34;
  mediump vec3 detailCoords_35;
  mediump float s_36;
  mediump float nylerp_37;
  mediump float zxlerp_38;
  highp vec3 tmpvar_39;
  tmpvar_39 = abs(tmpvar_6);
  highp float tmpvar_40;
  tmpvar_40 = float((tmpvar_39.z >= tmpvar_39.x));
  zxlerp_38 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = float((max (tmpvar_39.x, tmpvar_39.z) >= tmpvar_39.y));
  nylerp_37 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_38);
  s_36 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_6.y, s_36, nylerp_37));
  s_36 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(s_36);
  mediump vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = s_36;
  highp vec3 tmpvar_46;
  tmpvar_46 = mix ((tmpvar_44 * tmpvar_6.xzy), (tmpvar_45 * tmpvar_6.zxy), vec3(zxlerp_38));
  detailCoords_35 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xy = vec2(1.0, 1.0);
  tmpvar_47.z = s_36;
  highp vec3 tmpvar_48;
  tmpvar_48 = mix ((tmpvar_47 * tmpvar_6.yxz), detailCoords_35, vec3(nylerp_37));
  detailCoords_35 = tmpvar_48;
  uv_34 = (((
    (0.5 * detailCoords_35.yz)
   / 
    abs(detailCoords_35.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_49;
  uv_49 = uv_34;
  highp vec2 uvCont_50;
  highp vec2 tmpvar_51;
  tmpvar_51 = abs((uv_49 - tmpvar_30));
  uvCont_50.x = max (tmpvar_51.x, tmpvar_51.y);
  uvCont_50.y = min (tmpvar_51.x, tmpvar_51.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_50);
  tmpvar_52.zw = dFdy(uvCont_50);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_34, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citylightoverlaydetail_2.xyz = tmpvar_54.xyz;
  highp float tmpvar_55;
  tmpvar_55 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_9 * (1.0 - tmpvar_55));
  citydarkoverlaydetail_3.w = (tmpvar_33.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_54.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_54.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_56;
  lightDir_56 = _SunDir;
  mediump vec3 viewDir_57;
  viewDir_57 = xlv_TEXCOORD7;
  mediump vec3 normal_58;
  normal_58 = xlv_TEXCOORD4;
  mediump vec4 c_59;
  mediump vec3 tmpvar_60;
  tmpvar_60 = normalize(lightDir_56);
  lightDir_56 = tmpvar_60;
  mediump vec3 tmpvar_61;
  tmpvar_61 = normalize(viewDir_57);
  viewDir_57 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62 = normalize(normal_58);
  normal_58 = tmpvar_62;
  mediump float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, tmpvar_60);
  highp float tmpvar_64;
  mediump float tmpvar_65;
  tmpvar_65 = clamp (dot (normalize(
    (tmpvar_60 + tmpvar_61)
  ), tmpvar_62), 0.0, 1.0);
  tmpvar_64 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = (pow (tmpvar_64, _SpecularPower) * _SpecularColor.w);
  c_59.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_63) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_66)) * 2.0);
  c_59.w = (tmpvar_63 * 2.0);
  highp vec3 tmpvar_67;
  tmpvar_67 = normalize(_SunDir);
  mediump vec3 lightDir_68;
  lightDir_68 = tmpvar_67;
  mediump vec3 normal_69;
  normal_69 = xlv_TEXCOORD4;
  mediump float tmpvar_70;
  tmpvar_70 = dot (normal_69, lightDir_68);
  color_5 = (c_59 * mix (1.0, clamp (
    floor((1.01 + tmpvar_70))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_70))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_71;
  tmpvar_71 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_71.xyz;
  color_5.w = (tmpvar_71.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
bool tb0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec3 t3;
lowp vec4 t10_3;
bool tb3;
mediump vec3 t16_4;
highp vec3 t5;
highp vec3 t6;
highp vec3 t7;
mediump vec3 t16_8;
highp vec3 t10;
bool tb10;
mediump float t16_15;
highp vec2 t17;
highp int ti17;
mediump float t16_22;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_8.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_8.x = floor(t16_8.x);
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_8.x = t16_8.x + -1.0;
    t16_1.x = t16_1.x * t16_8.x + 1.0;
    t16_8.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_8.x = inversesqrt(t16_8.x);
    t16_8.xyz = t16_8.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_8.x = dot(t16_2.xyz, t16_8.xyz);
    t16_8.x = t16_8.x + t16_8.x;
    t16_1.x = t16_1.x * t16_8.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t16_2.xz = vec2(1.0, -1.0);
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t7.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t0.x + (-t7.y);
    tb10 = abs(t7.z)>=abs(t7.y);
    t10.x = tb10 ? 1.0 : float(0.0);
    t3.x = t10.x * t3.x + t7.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t3.x;
    t3.x = max(abs(t7.z), abs(t7.y));
    tb3 = t3.x>=abs(t7.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t0.x = t3.x * t0.x + t7.x;
    ti17 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti17) + ti0;
    t16_4.y = float(ti0);
    t16_2.y = (-t16_4.y);
    t5.xyz = t7.yzx * t16_2.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t7.zyx + (-t5.xyz);
    t10.xyz = t10.xxx * t6.xyz + t5.xyz;
    t10.xyz = (-t16_4.xxy) * t7.xyz + t10.xyz;
    t5.xyz = t7.xyz * t16_4.xxy;
    t10_0 = texture(cube_CityOverlayTex, t7.yxz);
    t3.xyz = t3.xxx * t10.xyz + t5.xyz;
    t16_8.xy = vec2(t3.y * float(0.5), t3.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t3.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t3.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t17.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t3.xy;
    t5.x = max(abs(t17.y), abs(t17.x));
    t17.x = min(abs(t17.y), abs(t17.x));
    t6.x = dFdx(t5.x);
    t5.x = dFdy(t5.x);
    t6.y = dFdx(t17.x);
    t5.y = dFdy(t17.x);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t3.xy, vec4(t6.xyxx).xy, vec4(t5.xyxx).xy);
    t10_3 = textureGrad(_CityLightOverlayDetailTex, t3.xy, vec4(t6.xyxx).xy, vec4(t5.xyxx).xy);
    t16_8.xy = t10_0.xy * alphaMask1.xy;
    t16_8.x = t16_8.y + t16_8.x;
    t16_8.x = t10_0.z * alphaMask1.z + t16_8.x;
    t16_8.x = t10_0.w * alphaMask1.w + t16_8.x;
    tb0 = 0.0>=vs_TEXCOORD0.w;
    t0.x = (tb0) ? 0.0 : 1.0;
    t0.x = t0.x * t16_8.x;
    t16_8.x = t0.x * t10_2.w;
    t16_4.xyz = t10_2.xyz + (-t10_3.xyz);
    t16_15 = t0.x * t10_3.w;
    t16_22 = t16_8.x * t16_1.x + (-t16_15);
    t16_1.x = t16_1.x * t16_8.x;
    t16_8.x = t16_1.x * t16_22 + t16_15;
    t16_1.xzw = t16_1.xxx * t16_4.xyz + t10_3.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t15 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t15 + 1.00999999;
    t15 = t15 * -10.0;
    t15 = clamp(t15, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t15 = t15 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t15 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t15);
    t4.x = dFdy(t15);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t5.xy = t10_2.xy * alphaMask1.xy;
    t5.x = t5.y + t5.x;
    t5.x = t10_2.z * alphaMask1.z + t5.x;
    t5.x = t10_2.w * alphaMask1.w + t5.x;
    tb10 = 0.0>=vs_TEXCOORD0.w;
    t10.x = (tb10) ? 0.0 : 1.0;
    t5.x = t10.x * t5.x;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 106 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  float tmpvar_5;
  vec4 v_6;
  vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD5);
  v_6 = (textureCube (cube_CityOverlayTex, tmpvar_7) * alphaMask1);
  tmpvar_5 = ((v_6.x + v_6.y) + (v_6.z + v_6.w));
  vec4 tmpvar_8;
  tmpvar_8.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_8.w = tmpvar_5;
  cityoverlay_3.xyz = tmpvar_8.xyz;
  vec2 uv_9;
  vec3 tmpvar_10;
  tmpvar_10 = abs(tmpvar_7);
  float tmpvar_11;
  tmpvar_11 = float((tmpvar_10.z >= tmpvar_10.x));
  float tmpvar_12;
  tmpvar_12 = float((max (tmpvar_10.x, tmpvar_10.z) >= tmpvar_10.y));
  float tmpvar_13;
  tmpvar_13 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_11), tmpvar_12));
  vec3 tmpvar_14;
  tmpvar_14.xz = vec2(1.0, -1.0);
  tmpvar_14.y = -(tmpvar_13);
  vec3 tmpvar_15;
  tmpvar_15.xz = vec2(1.0, -1.0);
  tmpvar_15.y = tmpvar_13;
  vec3 tmpvar_16;
  tmpvar_16.xy = vec2(1.0, 1.0);
  tmpvar_16.z = tmpvar_13;
  vec3 tmpvar_17;
  tmpvar_17 = mix ((tmpvar_16 * tmpvar_7.yxz), mix ((tmpvar_14 * tmpvar_7.xzy), (tmpvar_15 * tmpvar_7.zxy), vec3(tmpvar_11)), vec3(tmpvar_12));
  uv_9 = (((
    (0.5 * tmpvar_17.yz)
   / 
    abs(tmpvar_17.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_18;
  vec2 tmpvar_19;
  float tmpvar_20;
  tmpvar_20 = (0.5 * _CityOverlayDetailScale);
  tmpvar_19 = abs((uv_9 - tmpvar_20));
  uvCont_18.x = max (tmpvar_19.x, tmpvar_19.y);
  uvCont_18.y = min (tmpvar_19.x, tmpvar_19.y);
  vec4 tmpvar_21;
  tmpvar_21.xy = dFdx(uvCont_18);
  tmpvar_21.zw = dFdy(uvCont_18);
  vec4 tmpvar_22;
  tmpvar_22 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_9, tmpvar_21.xy, tmpvar_21.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_22.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_7);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_7.y, mix (tmpvar_7.x, tmpvar_7.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_7.yxz), mix ((tmpvar_28 * tmpvar_7.xzy), (tmpvar_29 * tmpvar_7.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  tmpvar_33 = abs((uv_23 - tmpvar_20));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_34;
  tmpvar_34.xy = dFdx(uvCont_32);
  tmpvar_34.zw = dFdy(uvCont_32);
  vec4 tmpvar_35;
  tmpvar_35 = texture2DGradARB (_CityLightOverlayDetailTex, uv_23, tmpvar_34.xy, tmpvar_34.zw);
  citylightoverlaydetail_1.xyz = tmpvar_35.xyz;
  cityoverlay_3.w = (tmpvar_5 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_22.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_35.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_35.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_36;
  tmpvar_36 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_37;
  vec3 tmpvar_38;
  tmpvar_38 = normalize(_SunDir);
  vec3 tmpvar_39;
  tmpvar_39 = normalize(xlv_TEXCOORD4);
  float tmpvar_40;
  tmpvar_40 = dot (tmpvar_39, tmpvar_38);
  c_37.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_40) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_38 + normalize(xlv_TEXCOORD7)))
    , tmpvar_39), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_36.x * 2.0));
  c_37.w = (tmpvar_40 * (tmpvar_36.x * 2.0));
  float tmpvar_41;
  tmpvar_41 = dot (xlv_TEXCOORD4, tmpvar_38);
  color_4 = (c_37 * mix (1.0, clamp (
    floor((1.01 + tmpvar_41))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_41))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_42;
  tmpvar_42 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_42.xyz;
  color_4.w = (tmpvar_42.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa
eefiecedhmjijjfdbkihppipiehjkbnihlhbpipmabaaaaaaoeagaaaaadaaaaaa
cmaaaaaapeaaaaaanmabaaaaejfdeheomaaaaaaaagaaaaaaaiaaaaaajiaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaaaaaaaaaapapaaaakbaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaapapaaaakhaaaaaaaaaaaaaaaaaaaaaaadaaaaaaacaaaaaa
ahahaaaakoaaaaaaaaaaaaaaaaaaaaaaadaaaaaaadaaaaaaapadaaaakoaaaaaa
abaaaaaaaaaaaaaaadaaaaaaaeaaaaaaapabaaaalhaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaafaaaaaaahaaaaaafaepfdejfeejepeoaaedepemepfcaaeoepfceneb
emaafeeffiedepepfceeaafeebeoehefeofeaaklepfdeheooaaaaaaaaiaaaaaa
aiaaaaaamiaaaaaaaaaaaaaaabaaaaaaadaaaaaaaaaaaaaaapaaaaaaneaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaabaaaaaaapaaaaaaneaaaaaaabaaaaaaaaaaaaaa
adaaaaaaacaaaaaaapaaaaaaneaaaaaaacaaaaaaaaaaaaaaadaaaaaaadaaaaaa
apaaaaaaneaaaaaaaeaaaaaaaaaaaaaaadaaaaaaaeaaaaaaahaiaaaaneaaaaaa
agaaaaaaaaaaaaaaadaaaaaaaeaaaaaaaiahaaaaneaaaaaaafaaaaaaaaaaaaaa
adaaaaaaafaaaaaaahaiaaaaneaaaaaaahaaaaaaaaaaaaaaadaaaaaaagaaaaaa
ahaiaaaafdfgfpfaepfdejfeejepeoaafeeffiedepepfceeaaklklklfdeieefc
aaafaaaaeaaaabaaeaabaaaafjaaaaaeegiocaaaaaaaaaaabnaaaaaafjaaaaae
egiocaaaabaaaaaaagaaaaaafjaaaaaeegiocaaaacaaaaaabaaaaaaafpaaaaad
pcbabaaaaaaaaaaafpaaaaadpcbabaaaabaaaaaafpaaaaadhcbabaaaacaaaaaa
fpaaaaaddcbabaaaadaaaaaafpaaaaadbcbabaaaaeaaaaaaghaaaaaepccabaaa
aaaaaaaaabaaaaaagfaaaaadpccabaaaabaaaaaagfaaaaadpccabaaaacaaaaaa
gfaaaaadpccabaaaadaaaaaagfaaaaadhccabaaaaeaaaaaagfaaaaadiccabaaa
aeaaaaaagfaaaaadhccabaaaafaaaaaagfaaaaadhccabaaaagaaaaaagiaaaaac
adaaaaaadiaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaaegiocaaaacaaaaaa
abaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaaaaaaaaaaagbabaaa
aaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaa
acaaaaaakgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaa
egiocaaaacaaaaaaadaaaaaapgbpbaaaaaaaaaaaegaobaaaaaaaaaaadgaaaaaf
pccabaaaaaaaaaaaegaobaaaaaaaaaaadgaaaaafpccabaaaabaaaaaaegbobaaa
abaaaaaadiaaaaaihcaabaaaabaaaaaafgbfbaaaaaaaaaaaegiccaaaacaaaaaa
anaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaamaaaaaaagbabaaa
aaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaa
aoaaaaaakgbkbaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaa
egiccaaaacaaaaaaapaaaaaapgbpbaaaaaaaaaaaegacbaaaabaaaaaaaaaaaaaj
hcaabaaaacaaaaaaegacbaaaabaaaaaaegiccaiaebaaaaaaabaaaaaaaeaaaaaa
aaaaaaajhcaabaaaabaaaaaaegacbaaaabaaaaaaegiccaiaebaaaaaaaaaaaaaa
blaaaaaabaaaaaahicaabaaaabaaaaaaegacbaaaacaaaaaaegacbaaaacaaaaaa
elaaaaaficcabaaaacaaaaaadkaabaaaabaaaaaaeeaaaaaficaabaaaabaaaaaa
dkaabaaaabaaaaaadiaaaaahhccabaaaagaaaaaapgapbaaaabaaaaaaegacbaaa
acaaaaaadgaaaaafhccabaaaacaaaaaaegbcbaaaacaaaaaadiaaaaaiccaabaaa
aaaaaaaabkaabaaaaaaaaaaaakiacaaaabaaaaaaafaaaaaadiaaaaakncaabaaa
acaaaaaaagahbaaaaaaaaaaaaceaaaaaaaaaaadpaaaaaaaaaaaaaadpaaaaaadp
dgaaaaafmccabaaaadaaaaaakgaobaaaaaaaaaaaaaaaaaahdccabaaaadaaaaaa
kgakbaaaacaaaaaamgaabaaaacaaaaaabaaaaaahbcaabaaaaaaaaaaaegacbaaa
abaaaaaaegacbaaaabaaaaaaeeaaaaafbcaabaaaaaaaaaaaakaabaaaaaaaaaaa
diaaaaahhccabaaaaeaaaaaaagaabaaaaaaaaaaaegacbaaaabaaaaaabaaaaaaj
bcaabaaaaaaaaaaaegiccaaaaaaaaaaabmaaaaaaegiccaaaaaaaaaaabmaaaaaa
eeaaaaafbcaabaaaaaaaaaaaakaabaaaaaaaaaaadiaaaaaihcaabaaaaaaaaaaa
agaabaaaaaaaaaaaegiccaaaaaaaaaaabmaaaaaadgaaaaafdcaabaaaabaaaaaa
egbabaaaadaaaaaadgaaaaafecaabaaaabaaaaaaakbabaaaaeaaaaaabaaaaaai
bcaabaaaaaaaaaaaegacbaiaebaaaaaaabaaaaaaegacbaaaaaaaaaaadgaaaaag
hccabaaaafaaaaaaegacbaiaebaaaaaaabaaaaaaaaaaaaahccaabaaaaaaaaaaa
akaabaaaaaaaaaaaabeaaaaakoehibdpdicaaaahbcaabaaaaaaaaaaaakaabaaa
aaaaaaaaabeaaaaaaaaacambebcaaaafccaabaaaaaaaaaaabkaabaaaaaaaaaaa
aaaaaaahccaabaaaaaaaaaaabkaabaaaaaaaaaaaabeaaaaaaaaaialpdcaaaaaj
iccabaaaaeaaaaaaakaabaaaaaaaaaaabkaabaaaaaaaaaaaabeaaaaaaaaaiadp
doaaaaab"
}
SubProgram "gles " {
// Stats: 111 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  mediump float tmpvar_9;
  mediump vec4 v_10;
  v_10 = (tmpvar_8 * alphaMask1);
  tmpvar_9 = ((v_10.x + v_10.y) + (v_10.z + v_10.w));
  mediump vec4 tmpvar_11;
  tmpvar_11.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_11.w = tmpvar_9;
  cityoverlay_4.xyz = tmpvar_11.xyz;
  mediump vec2 uv_12;
  mediump vec3 detailCoords_13;
  mediump float s_14;
  mediump float nylerp_15;
  mediump float zxlerp_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_6);
  highp float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  zxlerp_16 = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  nylerp_15 = tmpvar_19;
  highp float tmpvar_20;
  tmpvar_20 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_16);
  s_14 = tmpvar_20;
  highp float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_6.y, s_14, nylerp_15));
  s_14 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(s_14);
  mediump vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = s_14;
  highp vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_22 * tmpvar_6.xzy), (tmpvar_23 * tmpvar_6.zxy), vec3(zxlerp_16));
  detailCoords_13 = tmpvar_24;
  mediump vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = s_14;
  highp vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_6.yxz), detailCoords_13, vec3(nylerp_15));
  detailCoords_13 = tmpvar_26;
  uv_12 = (((
    (0.5 * detailCoords_13.yz)
   / 
    abs(detailCoords_13.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_27;
  uv_27 = uv_12;
  highp vec2 uvCont_28;
  highp vec2 tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (0.5 * _CityOverlayDetailScale);
  tmpvar_29 = abs((uv_27 - tmpvar_30));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_28);
  tmpvar_31.zw = dFdy(uvCont_28);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_12, tmpvar_31.xy, tmpvar_31.zw);
  mediump vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  citydarkoverlaydetail_3.xyz = tmpvar_33.xyz;
  mediump vec2 uv_34;
  mediump vec3 detailCoords_35;
  mediump float s_36;
  mediump float nylerp_37;
  mediump float zxlerp_38;
  highp vec3 tmpvar_39;
  tmpvar_39 = abs(tmpvar_6);
  highp float tmpvar_40;
  tmpvar_40 = float((tmpvar_39.z >= tmpvar_39.x));
  zxlerp_38 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = float((max (tmpvar_39.x, tmpvar_39.z) >= tmpvar_39.y));
  nylerp_37 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_38);
  s_36 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_6.y, s_36, nylerp_37));
  s_36 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(s_36);
  mediump vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = s_36;
  highp vec3 tmpvar_46;
  tmpvar_46 = mix ((tmpvar_44 * tmpvar_6.xzy), (tmpvar_45 * tmpvar_6.zxy), vec3(zxlerp_38));
  detailCoords_35 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xy = vec2(1.0, 1.0);
  tmpvar_47.z = s_36;
  highp vec3 tmpvar_48;
  tmpvar_48 = mix ((tmpvar_47 * tmpvar_6.yxz), detailCoords_35, vec3(nylerp_37));
  detailCoords_35 = tmpvar_48;
  uv_34 = (((
    (0.5 * detailCoords_35.yz)
   / 
    abs(detailCoords_35.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_49;
  uv_49 = uv_34;
  highp vec2 uvCont_50;
  highp vec2 tmpvar_51;
  tmpvar_51 = abs((uv_49 - tmpvar_30));
  uvCont_50.x = max (tmpvar_51.x, tmpvar_51.y);
  uvCont_50.y = min (tmpvar_51.x, tmpvar_51.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_50);
  tmpvar_52.zw = dFdy(uvCont_50);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_34, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citylightoverlaydetail_2.xyz = tmpvar_54.xyz;
  highp float tmpvar_55;
  tmpvar_55 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_9 * (1.0 - tmpvar_55));
  citydarkoverlaydetail_3.w = (tmpvar_33.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_54.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_54.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_56;
  highp float tmpvar_57;
  tmpvar_57 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_56 = tmpvar_57;
  mediump vec3 lightDir_58;
  lightDir_58 = _SunDir;
  mediump vec3 viewDir_59;
  viewDir_59 = xlv_TEXCOORD7;
  mediump vec3 normal_60;
  normal_60 = xlv_TEXCOORD4;
  mediump float atten_61;
  atten_61 = tmpvar_56;
  mediump vec4 c_62;
  mediump vec3 tmpvar_63;
  tmpvar_63 = normalize(lightDir_58);
  lightDir_58 = tmpvar_63;
  mediump vec3 tmpvar_64;
  tmpvar_64 = normalize(viewDir_59);
  viewDir_59 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65 = normalize(normal_60);
  normal_60 = tmpvar_65;
  mediump float tmpvar_66;
  tmpvar_66 = dot (tmpvar_65, tmpvar_63);
  highp float tmpvar_67;
  mediump float tmpvar_68;
  tmpvar_68 = clamp (dot (normalize(
    (tmpvar_63 + tmpvar_64)
  ), tmpvar_65), 0.0, 1.0);
  tmpvar_67 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = (pow (tmpvar_67, _SpecularPower) * _SpecularColor.w);
  c_62.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_66) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_69)) * (atten_61 * 2.0));
  c_62.w = (tmpvar_66 * (atten_61 * 2.0));
  highp vec3 tmpvar_70;
  tmpvar_70 = normalize(_SunDir);
  mediump vec3 lightDir_71;
  lightDir_71 = tmpvar_70;
  mediump vec3 normal_72;
  normal_72 = xlv_TEXCOORD4;
  mediump float tmpvar_73;
  tmpvar_73 = dot (normal_72, lightDir_71);
  color_5 = (c_62 * mix (1.0, clamp (
    floor((1.01 + tmpvar_73))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_73))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_74;
  tmpvar_74 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_74.xyz;
  color_5.w = (tmpvar_74.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
lowp vec4 t10_2;
vec4 t3;
vec3 t4;
vec3 t5;
int ti5;
vec2 t10;
bool tb10;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t15 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t15 = inversesqrt(t15);
    t1.xyz = vec3(t15) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t5.x = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t10.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t10.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t10.x = t5.x + 1.00999999;
    t5.x = t5.x * -10.0;
    t5.x = clamp(t5.x, 0.0, 1.0);
    t10.x = floor(t10.x);
    t10.x = clamp(t10.x, 0.0, 1.0);
    t10.x = t10.x + -1.0;
    t5.x = t5.x * t10.x + 1.0;
    t0.x = t5.x * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5.x = inversesqrt(t5.x);
    t2.xyz = t5.xxx * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5.x + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5.x = (-vs_TEXCOORD5.y) * t5.x + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5.x = t10.x * t5.x + t2.x;
    ti16 = int((0.0<t5.x) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t3.xyz = t2.xyz * t3.xxy;
    t10_2 = texture(cube_CityOverlayTex, t2.yxz);
    t5.xyz = t10.xxx * t1.xyz + t3.xyz;
    t10.xy = t5.yz * vec2(0.5, 0.5);
    t5.xy = t10.xy / abs(t5.xx);
    t5.xy = t5.xy + vec2(0.5, 0.5);
    t5.xy = t5.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t1.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t5.xy;
    t15 = max(abs(t1.y), abs(t1.x));
    t1.x = min(abs(t1.y), abs(t1.x));
    t3.x = dFdx(t15);
    t4.x = dFdy(t15);
    t3.y = dFdx(t1.x);
    t4.y = dFdy(t1.x);
    t1 = textureGrad(_CityDarkOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t3 = textureGrad(_CityLightOverlayDetailTex, t5.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t5.xy = t10_2.xy * alphaMask1.xy;
    t5.x = t5.y + t5.x;
    t5.x = t10_2.z * alphaMask1.z + t5.x;
    t5.x = t10_2.w * alphaMask1.w + t5.x;
    tb10 = 0.0>=vs_TEXCOORD0.w;
    t10.x = (tb10) ? 0.0 : 1.0;
    t5.x = t10.x * t5.x;
    t10.x = t5.x * t1.w;
    t3.w = t5.x * t3.w;
    t1.w = t0.x * t10.x;
    t0 = t1 + (-t3);
    t0 = t1.wwww * t0 + t3;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 110 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  mediump float tmpvar_9;
  mediump vec4 v_10;
  v_10 = (tmpvar_8 * alphaMask1);
  tmpvar_9 = ((v_10.x + v_10.y) + (v_10.z + v_10.w));
  mediump vec4 tmpvar_11;
  tmpvar_11.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_11.w = tmpvar_9;
  cityoverlay_4.xyz = tmpvar_11.xyz;
  mediump vec2 uv_12;
  mediump vec3 detailCoords_13;
  mediump float s_14;
  mediump float nylerp_15;
  mediump float zxlerp_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_6);
  highp float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  zxlerp_16 = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  nylerp_15 = tmpvar_19;
  highp float tmpvar_20;
  tmpvar_20 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_16);
  s_14 = tmpvar_20;
  highp float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_6.y, s_14, nylerp_15));
  s_14 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(s_14);
  mediump vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = s_14;
  highp vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_22 * tmpvar_6.xzy), (tmpvar_23 * tmpvar_6.zxy), vec3(zxlerp_16));
  detailCoords_13 = tmpvar_24;
  mediump vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = s_14;
  highp vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_6.yxz), detailCoords_13, vec3(nylerp_15));
  detailCoords_13 = tmpvar_26;
  uv_12 = (((
    (0.5 * detailCoords_13.yz)
   / 
    abs(detailCoords_13.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_27;
  uv_27 = uv_12;
  highp vec2 uvCont_28;
  highp vec2 tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (0.5 * _CityOverlayDetailScale);
  tmpvar_29 = abs((uv_27 - tmpvar_30));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_28);
  tmpvar_31.zw = dFdy(uvCont_28);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_12, tmpvar_31.xy, tmpvar_31.zw);
  mediump vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  citydarkoverlaydetail_3.xyz = tmpvar_33.xyz;
  mediump vec2 uv_34;
  mediump vec3 detailCoords_35;
  mediump float s_36;
  mediump float nylerp_37;
  mediump float zxlerp_38;
  highp vec3 tmpvar_39;
  tmpvar_39 = abs(tmpvar_6);
  highp float tmpvar_40;
  tmpvar_40 = float((tmpvar_39.z >= tmpvar_39.x));
  zxlerp_38 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = float((max (tmpvar_39.x, tmpvar_39.z) >= tmpvar_39.y));
  nylerp_37 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_38);
  s_36 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_6.y, s_36, nylerp_37));
  s_36 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(s_36);
  mediump vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = s_36;
  highp vec3 tmpvar_46;
  tmpvar_46 = mix ((tmpvar_44 * tmpvar_6.xzy), (tmpvar_45 * tmpvar_6.zxy), vec3(zxlerp_38));
  detailCoords_35 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xy = vec2(1.0, 1.0);
  tmpvar_47.z = s_36;
  highp vec3 tmpvar_48;
  tmpvar_48 = mix ((tmpvar_47 * tmpvar_6.yxz), detailCoords_35, vec3(nylerp_37));
  detailCoords_35 = tmpvar_48;
  uv_34 = (((
    (0.5 * detailCoords_35.yz)
   / 
    abs(detailCoords_35.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_49;
  uv_49 = uv_34;
  highp vec2 uvCont_50;
  highp vec2 tmpvar_51;
  tmpvar_51 = abs((uv_49 - tmpvar_30));
  uvCont_50.x = max (tmpvar_51.x, tmpvar_51.y);
  uvCont_50.y = min (tmpvar_51.x, tmpvar_51.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_50);
  tmpvar_52.zw = dFdy(uvCont_50);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_34, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citylightoverlaydetail_2.xyz = tmpvar_54.xyz;
  highp float tmpvar_55;
  tmpvar_55 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_9 * (1.0 - tmpvar_55));
  citydarkoverlaydetail_3.w = (tmpvar_33.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_54.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_54.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_56;
  shadow_56 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_57;
  lightDir_57 = _SunDir;
  mediump vec3 viewDir_58;
  viewDir_58 = xlv_TEXCOORD7;
  mediump vec3 normal_59;
  normal_59 = xlv_TEXCOORD4;
  mediump float atten_60;
  atten_60 = shadow_56;
  mediump vec4 c_61;
  mediump vec3 tmpvar_62;
  tmpvar_62 = normalize(lightDir_57);
  lightDir_57 = tmpvar_62;
  mediump vec3 tmpvar_63;
  tmpvar_63 = normalize(viewDir_58);
  viewDir_58 = tmpvar_63;
  mediump vec3 tmpvar_64;
  tmpvar_64 = normalize(normal_59);
  normal_59 = tmpvar_64;
  mediump float tmpvar_65;
  tmpvar_65 = dot (tmpvar_64, tmpvar_62);
  highp float tmpvar_66;
  mediump float tmpvar_67;
  tmpvar_67 = clamp (dot (normalize(
    (tmpvar_62 + tmpvar_63)
  ), tmpvar_64), 0.0, 1.0);
  tmpvar_66 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = (pow (tmpvar_66, _SpecularPower) * _SpecularColor.w);
  c_61.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_65) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_68)) * (atten_60 * 2.0));
  c_61.w = (tmpvar_65 * (atten_60 * 2.0));
  highp vec3 tmpvar_69;
  tmpvar_69 = normalize(_SunDir);
  mediump vec3 lightDir_70;
  lightDir_70 = tmpvar_69;
  mediump vec3 normal_71;
  normal_71 = xlv_TEXCOORD4;
  mediump float tmpvar_72;
  tmpvar_72 = dot (normal_71, lightDir_70);
  color_5 = (c_61 * mix (1.0, clamp (
    floor((1.01 + tmpvar_72))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_72))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_73;
  tmpvar_73 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_73.xyz;
  color_5.w = (tmpvar_73.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp vec4 t10_2;
highp int ti2;
highp vec2 t3;
bool tb3;
mediump vec3 t16_4;
lowp vec4 t10_4;
highp vec3 t5;
highp vec3 t6;
mediump vec3 t16_7;
mediump vec2 t16_8;
highp vec3 t10;
highp vec3 t11;
bool tb11;
mediump float t16_16;
highp vec2 t18;
highp int ti19;
mediump float t16_24;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_24 = inversesqrt(t16_24);
    t16_1.xyz = vec3(t16_24) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec21 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_8.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec21, 0.0);
    t16_16 = (-_LightShadowData.x) + 1.0;
    t16_8.x = t16_8.x * t16_16 + _LightShadowData.x;
    t16_0.x = dot(t16_8.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_8.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_16 = t16_8.x + 1.00999999;
    t16_8.x = t16_8.x * -10.0;
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_16 = floor(t16_16);
    t16_16 = clamp(t16_16, 0.0, 1.0);
    t16_16 = t16_16 + -1.0;
    t16_8.x = t16_8.x * t16_16 + 1.0;
    t16_0.x = t16_8.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t16_1.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t10.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t2.x + (-t10.y);
    tb11 = abs(t10.z)>=abs(t10.y);
    t11.x = tb11 ? 1.0 : float(0.0);
    t3.x = t11.x * t3.x + t10.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t3.x;
    t3.x = max(abs(t10.z), abs(t10.y));
    tb3 = t3.x>=abs(t10.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t2.x = t3.x * t2.x + t10.x;
    ti19 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti19) + ti2;
    t16_4.y = float(ti2);
    t16_1.y = (-t16_4.y);
    t5.xyz = t16_1.xyz * t10.yzx;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t10.zyx + (-t5.xyz);
    t11.xyz = t11.xxx * t6.xyz + t5.xyz;
    t11.xyz = (-t16_4.xxy) * t10.xyz + t11.xyz;
    t5.xyz = t10.xyz * t16_4.xxy;
    t10_1 = texture(cube_CityOverlayTex, t10.yxz);
    t2.xyz = t3.xxx * t11.xyz + t5.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t18.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t2.xy;
    t3.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t5.y = dFdx(t18.x);
    t3.y = dFdy(t18.x);
    t10_4 = textureGrad(_CityDarkOverlayDetailTex, t2.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t10_2 = textureGrad(_CityLightOverlayDetailTex, t2.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t16_8.xy = t10_1.xy * alphaMask1.xy;
    t16_8.x = t16_8.y + t16_8.x;
    t16_8.x = t10_1.z * alphaMask1.z + t16_8.x;
    t16_8.x = t10_1.w * alphaMask1.w + t16_8.x;
    tb3 = 0.0>=vs_TEXCOORD0.w;
    t3.x = (tb3) ? 0.0 : 1.0;
    t3.x = t16_8.x * t3.x;
    t16_8.x = t3.x * t10_4.w;
    t16_7.xyz = (-t10_2.xyz) + t10_4.xyz;
    t16_16 = t10_2.w * t3.x;
    t16_24 = t16_8.x * t16_0.x + (-t16_16);
    t16_0.x = t16_0.x * t16_8.x;
    t16_8.x = t16_0.x * t16_24 + t16_16;
    t16_0.xzw = t16_0.xxx * t16_7.xyz + t10_2.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 110 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(xlv_TEXCOORD5);
  lowp vec4 tmpvar_7;
  tmpvar_7 = textureCube (cube_CityOverlayTex, tmpvar_6);
  mediump vec4 tmpvar_8;
  tmpvar_8 = tmpvar_7;
  mediump float tmpvar_9;
  mediump vec4 v_10;
  v_10 = (tmpvar_8 * alphaMask1);
  tmpvar_9 = ((v_10.x + v_10.y) + (v_10.z + v_10.w));
  mediump vec4 tmpvar_11;
  tmpvar_11.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_11.w = tmpvar_9;
  cityoverlay_4.xyz = tmpvar_11.xyz;
  mediump vec2 uv_12;
  mediump vec3 detailCoords_13;
  mediump float s_14;
  mediump float nylerp_15;
  mediump float zxlerp_16;
  highp vec3 tmpvar_17;
  tmpvar_17 = abs(tmpvar_6);
  highp float tmpvar_18;
  tmpvar_18 = float((tmpvar_17.z >= tmpvar_17.x));
  zxlerp_16 = tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = float((max (tmpvar_17.x, tmpvar_17.z) >= tmpvar_17.y));
  nylerp_15 = tmpvar_19;
  highp float tmpvar_20;
  tmpvar_20 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_16);
  s_14 = tmpvar_20;
  highp float tmpvar_21;
  tmpvar_21 = sign(mix (tmpvar_6.y, s_14, nylerp_15));
  s_14 = tmpvar_21;
  mediump vec3 tmpvar_22;
  tmpvar_22.xz = vec2(1.0, -1.0);
  tmpvar_22.y = -(s_14);
  mediump vec3 tmpvar_23;
  tmpvar_23.xz = vec2(1.0, -1.0);
  tmpvar_23.y = s_14;
  highp vec3 tmpvar_24;
  tmpvar_24 = mix ((tmpvar_22 * tmpvar_6.xzy), (tmpvar_23 * tmpvar_6.zxy), vec3(zxlerp_16));
  detailCoords_13 = tmpvar_24;
  mediump vec3 tmpvar_25;
  tmpvar_25.xy = vec2(1.0, 1.0);
  tmpvar_25.z = s_14;
  highp vec3 tmpvar_26;
  tmpvar_26 = mix ((tmpvar_25 * tmpvar_6.yxz), detailCoords_13, vec3(nylerp_15));
  detailCoords_13 = tmpvar_26;
  uv_12 = (((
    (0.5 * detailCoords_13.yz)
   / 
    abs(detailCoords_13.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_27;
  uv_27 = uv_12;
  highp vec2 uvCont_28;
  highp vec2 tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (0.5 * _CityOverlayDetailScale);
  tmpvar_29 = abs((uv_27 - tmpvar_30));
  uvCont_28.x = max (tmpvar_29.x, tmpvar_29.y);
  uvCont_28.y = min (tmpvar_29.x, tmpvar_29.y);
  highp vec4 tmpvar_31;
  tmpvar_31.xy = dFdx(uvCont_28);
  tmpvar_31.zw = dFdy(uvCont_28);
  lowp vec4 tmpvar_32;
  tmpvar_32 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_12, tmpvar_31.xy, tmpvar_31.zw);
  mediump vec4 tmpvar_33;
  tmpvar_33 = tmpvar_32;
  citydarkoverlaydetail_3.xyz = tmpvar_33.xyz;
  mediump vec2 uv_34;
  mediump vec3 detailCoords_35;
  mediump float s_36;
  mediump float nylerp_37;
  mediump float zxlerp_38;
  highp vec3 tmpvar_39;
  tmpvar_39 = abs(tmpvar_6);
  highp float tmpvar_40;
  tmpvar_40 = float((tmpvar_39.z >= tmpvar_39.x));
  zxlerp_38 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = float((max (tmpvar_39.x, tmpvar_39.z) >= tmpvar_39.y));
  nylerp_37 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = mix (tmpvar_6.x, tmpvar_6.z, zxlerp_38);
  s_36 = tmpvar_42;
  highp float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_6.y, s_36, nylerp_37));
  s_36 = tmpvar_43;
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(s_36);
  mediump vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = s_36;
  highp vec3 tmpvar_46;
  tmpvar_46 = mix ((tmpvar_44 * tmpvar_6.xzy), (tmpvar_45 * tmpvar_6.zxy), vec3(zxlerp_38));
  detailCoords_35 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xy = vec2(1.0, 1.0);
  tmpvar_47.z = s_36;
  highp vec3 tmpvar_48;
  tmpvar_48 = mix ((tmpvar_47 * tmpvar_6.yxz), detailCoords_35, vec3(nylerp_37));
  detailCoords_35 = tmpvar_48;
  uv_34 = (((
    (0.5 * detailCoords_35.yz)
   / 
    abs(detailCoords_35.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_49;
  uv_49 = uv_34;
  highp vec2 uvCont_50;
  highp vec2 tmpvar_51;
  tmpvar_51 = abs((uv_49 - tmpvar_30));
  uvCont_50.x = max (tmpvar_51.x, tmpvar_51.y);
  uvCont_50.y = min (tmpvar_51.x, tmpvar_51.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_50);
  tmpvar_52.zw = dFdy(uvCont_50);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_34, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citylightoverlaydetail_2.xyz = tmpvar_54.xyz;
  highp float tmpvar_55;
  tmpvar_55 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_9 * (1.0 - tmpvar_55));
  citydarkoverlaydetail_3.w = (tmpvar_33.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_54.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_54.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float shadow_56;
  shadow_56 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD2.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_57;
  lightDir_57 = _SunDir;
  mediump vec3 viewDir_58;
  viewDir_58 = xlv_TEXCOORD7;
  mediump vec3 normal_59;
  normal_59 = xlv_TEXCOORD4;
  mediump float atten_60;
  atten_60 = shadow_56;
  mediump vec4 c_61;
  mediump vec3 tmpvar_62;
  tmpvar_62 = normalize(lightDir_57);
  lightDir_57 = tmpvar_62;
  mediump vec3 tmpvar_63;
  tmpvar_63 = normalize(viewDir_58);
  viewDir_58 = tmpvar_63;
  mediump vec3 tmpvar_64;
  tmpvar_64 = normalize(normal_59);
  normal_59 = tmpvar_64;
  mediump float tmpvar_65;
  tmpvar_65 = dot (tmpvar_64, tmpvar_62);
  highp float tmpvar_66;
  mediump float tmpvar_67;
  tmpvar_67 = clamp (dot (normalize(
    (tmpvar_62 + tmpvar_63)
  ), tmpvar_64), 0.0, 1.0);
  tmpvar_66 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = (pow (tmpvar_66, _SpecularPower) * _SpecularColor.w);
  c_61.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_65) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_68)) * (atten_60 * 2.0));
  c_61.w = (tmpvar_65 * (atten_60 * 2.0));
  highp vec3 tmpvar_69;
  tmpvar_69 = normalize(_SunDir);
  mediump vec3 lightDir_70;
  lightDir_70 = tmpvar_69;
  mediump vec3 normal_71;
  normal_71 = xlv_TEXCOORD4;
  mediump float tmpvar_72;
  tmpvar_72 = dot (normal_71, lightDir_70);
  color_5 = (c_61 * mix (1.0, clamp (
    floor((1.01 + tmpvar_72))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_72))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_73;
  tmpvar_73 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_73.xyz;
  color_5.w = (tmpvar_73.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out mediump vec4 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec4 t1;
highp vec4 t2;
mediump float t16_3;
mediump float t16_7;
highp float t12;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t12 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t12);
    t12 = inversesqrt(t12);
    vs_TEXCOORD7.xyz = vec3(t12) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t1 = in_POSITION0.yyyy * _Object2World[1];
    t1 = _Object2World[0] * in_POSITION0.xxxx + t1;
    t1 = _Object2World[2] * in_POSITION0.zzzz + t1;
    t1 = _Object2World[3] * in_POSITION0.wwww + t1;
    t2 = t1.yyyy * unity_World2Shadow[0][1];
    t2 = unity_World2Shadow[0][0] * t1.xxxx + t2;
    t2 = unity_World2Shadow[0][2] * t1.zzzz + t2;
    t1 = unity_World2Shadow[0][3] * t1.wwww + t2;
    vs_TEXCOORD2 = t1;
    t12 = dot(t0.xyz, t0.xyz);
    t12 = inversesqrt(t12);
    vs_TEXCOORD4.xyz = vec3(t12) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_3 = t0.x + 1.00999999;
    t16_7 = t0.x * -10.0;
    t16_7 = clamp(t16_7, 0.0, 1.0);
    t16_3 = floor(t16_3);
    t16_3 = clamp(t16_3, 0.0, 1.0);
    t16_3 = t16_3 + -1.0;
    t16_3 = t16_7 * t16_3 + 1.0;
    vs_TEXCOORD6 = t16_3;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec4 vs_TEXCOORD0;
in mediump vec4 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
mediump vec4 t16_0;
mediump vec3 t16_1;
lowp vec4 t10_1;
highp vec3 t2;
lowp vec4 t10_2;
highp int ti2;
highp vec2 t3;
bool tb3;
mediump vec3 t16_4;
lowp vec4 t10_4;
highp vec3 t5;
highp vec3 t6;
mediump vec3 t16_7;
mediump vec2 t16_8;
highp vec3 t10;
highp vec3 t11;
bool tb11;
mediump float t16_16;
highp vec2 t18;
highp int ti19;
mediump float t16_24;
void main()
{
    t16_0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_0.x = inversesqrt(t16_0.x);
    t16_0.xyz = t16_0.xxx * _SunDir.xyzx.xyz;
    t16_24 = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_24 = inversesqrt(t16_24);
    t16_1.xyz = vec3(t16_24) * vs_TEXCOORD4.xyz;
    t16_0.x = dot(t16_1.xyz, t16_0.xyz);
    vec3 txVec21 = vec3(vs_TEXCOORD2.xy,vs_TEXCOORD2.z);
    t16_8.x = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec21, 0.0);
    t16_16 = (-_LightShadowData.x) + 1.0;
    t16_8.x = t16_8.x * t16_16 + _LightShadowData.x;
    t16_0.x = dot(t16_8.xx, t16_0.xx);
    t2.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * _SunDir.xyzx.xyz;
    t16_8.x = dot(vs_TEXCOORD4.xyz, t2.xyz);
    t16_16 = t16_8.x + 1.00999999;
    t16_8.x = t16_8.x * -10.0;
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_16 = floor(t16_16);
    t16_16 = clamp(t16_16, 0.0, 1.0);
    t16_16 = t16_16 + -1.0;
    t16_8.x = t16_8.x * t16_16 + 1.0;
    t16_0.x = t16_8.x * t16_0.x;
    t16_0.x = clamp(t16_0.x, 0.0, 1.0);
    t16_0.x = (-t16_0.x) + 1.0;
    t16_1.xz = vec2(1.0, -1.0);
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t10.xyz = t2.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t2.x + (-t10.y);
    tb11 = abs(t10.z)>=abs(t10.y);
    t11.x = tb11 ? 1.0 : float(0.0);
    t3.x = t11.x * t3.x + t10.y;
    t2.x = (-vs_TEXCOORD5.y) * t2.x + t3.x;
    t3.x = max(abs(t10.z), abs(t10.y));
    tb3 = t3.x>=abs(t10.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t2.x = t3.x * t2.x + t10.x;
    ti19 = int((0.0<t2.x) ? 0xFFFFFFFFu : uint(0u));
    ti2 = int((t2.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti2 = (-ti19) + ti2;
    t16_4.y = float(ti2);
    t16_1.y = (-t16_4.y);
    t5.xyz = t16_1.xyz * t10.yzx;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t10.zyx + (-t5.xyz);
    t11.xyz = t11.xxx * t6.xyz + t5.xyz;
    t11.xyz = (-t16_4.xxy) * t10.xyz + t11.xyz;
    t5.xyz = t10.xyz * t16_4.xxy;
    t10_1 = texture(cube_CityOverlayTex, t10.yxz);
    t2.xyz = t3.xxx * t11.xyz + t5.xyz;
    t16_8.xy = vec2(t2.y * float(0.5), t2.z * float(0.5));
    t16_8.xy = t16_8.xy / abs(t2.xx);
    t16_8.xy = t16_8.xy + vec2(0.5, 0.5);
    t2.xy = t16_8.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t18.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t2.xy;
    t3.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t5.x = dFdx(t3.x);
    t3.x = dFdy(t3.x);
    t5.y = dFdx(t18.x);
    t3.y = dFdy(t18.x);
    t10_4 = textureGrad(_CityDarkOverlayDetailTex, t2.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t10_2 = textureGrad(_CityLightOverlayDetailTex, t2.xy, vec4(t5.xyxx).xy, vec4(t3.xyxx).xy);
    t16_8.xy = t10_1.xy * alphaMask1.xy;
    t16_8.x = t16_8.y + t16_8.x;
    t16_8.x = t10_1.z * alphaMask1.z + t16_8.x;
    t16_8.x = t10_1.w * alphaMask1.w + t16_8.x;
    tb3 = 0.0>=vs_TEXCOORD0.w;
    t3.x = (tb3) ? 0.0 : 1.0;
    t3.x = t16_8.x * t3.x;
    t16_8.x = t3.x * t10_4.w;
    t16_7.xyz = (-t10_2.xyz) + t10_4.xyz;
    t16_16 = t10_2.w * t3.x;
    t16_24 = t16_8.x * t16_0.x + (-t16_16);
    t16_0.x = t16_0.x * t16_8.x;
    t16_8.x = t16_0.x * t16_24 + t16_16;
    t16_0.xzw = t16_0.xxx * t16_7.xyz + t10_2.xyz;
    SV_Target0.xyz = t16_0.xzw;
    t2.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t2.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 22 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 192
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 160 [_PlanetOrigin] 3
Vector 176 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  half4 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float4 tmpvar_5;
  half4 tmpvar_6;
  float3 tmpvar_7;
  float tmpvar_8;
  tmpvar_3 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_9;
  tmpvar_9 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_10;
  tmpvar_10 = (tmpvar_9 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  float4 tmpvar_11;
  tmpvar_11.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_11.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_11.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = float4(tmpvar_1);
  tmpvar_5.xyz = _mtl_i._glesNormal;
  float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_12);
  half tmpvar_13;
  tmpvar_13 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_8 = float(tmpvar_13);
  float4 o_14;
  float4 tmpvar_15;
  tmpvar_15 = (tmpvar_3 * 0.5);
  float2 tmpvar_16;
  tmpvar_16.x = tmpvar_15.x;
  tmpvar_16.y = (tmpvar_15.y * _mtl_u._ProjectionParams.x);
  o_14.xy = (tmpvar_16 + tmpvar_15.w);
  o_14.zw = tmpvar_3.zw;
  tmpvar_6 = half4(o_14);
  _mtl_o.gl_Position = tmpvar_3;
  _mtl_o.xlv_TEXCOORD0 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD2 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_9 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_7;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_8;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_9 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 132 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform sampler2D cube_CityOverlayTexPOS;
uniform sampler2D cube_CityOverlayTexNEG;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_6;
  tmpvar_6 = abs(tmpvar_5);
  float tmpvar_7;
  tmpvar_7 = float((tmpvar_6.z >= tmpvar_6.x));
  float tmpvar_8;
  tmpvar_8 = float((max (tmpvar_6.x, tmpvar_6.z) >= tmpvar_6.y));
  float tmpvar_9;
  tmpvar_9 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_7), tmpvar_8));
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = -(tmpvar_9);
  vec3 tmpvar_11;
  tmpvar_11.xz = vec2(1.0, -1.0);
  tmpvar_11.y = tmpvar_9;
  vec3 tmpvar_12;
  tmpvar_12.xy = vec2(1.0, 1.0);
  tmpvar_12.z = tmpvar_9;
  vec3 tmpvar_13;
  tmpvar_13 = mix ((tmpvar_12 * tmpvar_5.yxz), mix ((tmpvar_10 * tmpvar_5.xzy), (tmpvar_11 * tmpvar_5.zxy), vec3(tmpvar_7)), vec3(tmpvar_8));
  vec2 tmpvar_14;
  tmpvar_14 = (((0.5 * tmpvar_13.yz) / abs(tmpvar_13.x)) + 0.5);
  vec2 uvCont_15;
  vec2 tmpvar_16;
  tmpvar_16 = abs((tmpvar_14 - 0.5));
  uvCont_15.x = max (tmpvar_16.x, tmpvar_16.y);
  uvCont_15.y = min (tmpvar_16.x, tmpvar_16.y);
  vec4 tmpvar_17;
  tmpvar_17.xy = dFdx(uvCont_15);
  tmpvar_17.zw = dFdy(uvCont_15);
  vec4 tmpvar_18;
  tmpvar_18 = mix (texture2DGradARB (cube_CityOverlayTexNEG, tmpvar_14, tmpvar_17.xy, tmpvar_17.zw), texture2DGradARB (cube_CityOverlayTexPOS, tmpvar_14, tmpvar_17.xy, tmpvar_17.zw), vec4(float((tmpvar_9 >= 0.0))));
  float tmpvar_19;
  tmpvar_19 = mix (tmpvar_18.y, mix (tmpvar_18.x, tmpvar_18.z, tmpvar_7), tmpvar_8);
  vec4 tmpvar_20;
  tmpvar_20.x = tmpvar_18.w;
  tmpvar_20.y = tmpvar_18.w;
  tmpvar_20.z = tmpvar_18.w;
  tmpvar_20.w = tmpvar_19;
  cityoverlay_3.xyz = tmpvar_20.xyz;
  vec2 uv_21;
  vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_5);
  float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_23), tmpvar_24));
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(tmpvar_25);
  vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = tmpvar_25;
  vec3 tmpvar_28;
  tmpvar_28.xy = vec2(1.0, 1.0);
  tmpvar_28.z = tmpvar_25;
  vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_28 * tmpvar_5.yxz), mix ((tmpvar_26 * tmpvar_5.xzy), (tmpvar_27 * tmpvar_5.zxy), vec3(tmpvar_23)), vec3(tmpvar_24));
  uv_21 = (((
    (0.5 * tmpvar_29.yz)
   / 
    abs(tmpvar_29.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_30;
  vec2 tmpvar_31;
  float tmpvar_32;
  tmpvar_32 = (0.5 * _CityOverlayDetailScale);
  tmpvar_31 = abs((uv_21 - tmpvar_32));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_30);
  tmpvar_33.zw = dFdy(uvCont_30);
  vec4 tmpvar_34;
  tmpvar_34 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_21, tmpvar_33.xy, tmpvar_33.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_34.xyz;
  vec2 uv_35;
  vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_5);
  float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_37), tmpvar_38));
  vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(tmpvar_39);
  vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = tmpvar_39;
  vec3 tmpvar_42;
  tmpvar_42.xy = vec2(1.0, 1.0);
  tmpvar_42.z = tmpvar_39;
  vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_42 * tmpvar_5.yxz), mix ((tmpvar_40 * tmpvar_5.xzy), (tmpvar_41 * tmpvar_5.zxy), vec3(tmpvar_37)), vec3(tmpvar_38));
  uv_35 = (((
    (0.5 * tmpvar_43.yz)
   / 
    abs(tmpvar_43.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_44;
  vec2 tmpvar_45;
  tmpvar_45 = abs((uv_35 - tmpvar_32));
  uvCont_44.x = max (tmpvar_45.x, tmpvar_45.y);
  uvCont_44.y = min (tmpvar_45.x, tmpvar_45.y);
  vec4 tmpvar_46;
  tmpvar_46.xy = dFdx(uvCont_44);
  tmpvar_46.zw = dFdy(uvCont_44);
  vec4 tmpvar_47;
  tmpvar_47 = texture2DGradARB (_CityLightOverlayDetailTex, uv_35, tmpvar_46.xy, tmpvar_46.zw);
  citylightoverlaydetail_1.xyz = tmpvar_47.xyz;
  cityoverlay_3.w = (tmpvar_19 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_34.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_47.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_47.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_48;
  vec3 tmpvar_49;
  tmpvar_49 = normalize(_SunDir);
  vec3 tmpvar_50;
  tmpvar_50 = normalize(xlv_TEXCOORD4);
  float tmpvar_51;
  tmpvar_51 = dot (tmpvar_50, tmpvar_49);
  c_48.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_51) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_49 + normalize(xlv_TEXCOORD7)))
    , tmpvar_50), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_48.w = (tmpvar_51 * 2.0);
  float tmpvar_52;
  tmpvar_52 = dot (xlv_TEXCOORD4, tmpvar_49);
  color_4 = (c_48 * mix (1.0, clamp (
    floor((1.01 + tmpvar_52))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_52))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_53;
  tmpvar_53 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_53.xyz;
  color_4.w = (tmpvar_53.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 133 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D cube_CityOverlayTexPOS;
uniform sampler2D cube_CityOverlayTexNEG;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  mediump vec3 detailCoords_6;
  mediump float s_7;
  mediump float nylerp_8;
  mediump float zxlerp_9;
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_9);
  s_7 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, s_7, nylerp_8));
  s_7 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16.xz = vec2(1.0, -1.0);
  tmpvar_16.y = -(s_7);
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = s_7;
  highp vec3 tmpvar_18;
  tmpvar_18 = mix ((tmpvar_16 * tmpvar_10.xzy), (tmpvar_17 * tmpvar_10.zxy), vec3(zxlerp_9));
  detailCoords_6 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = s_7;
  highp vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_10.yxz), detailCoords_6, vec3(nylerp_8));
  detailCoords_6 = tmpvar_20;
  mediump vec2 tmpvar_21;
  tmpvar_21 = (((0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + 0.5);
  highp vec2 uv_22;
  uv_22 = tmpvar_21;
  highp vec2 uvCont_23;
  highp vec2 tmpvar_24;
  tmpvar_24 = abs((uv_22 - 0.5));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  highp vec4 tmpvar_25;
  tmpvar_25.xy = dFdx(uvCont_23);
  tmpvar_25.zw = dFdy(uvCont_23);
  lowp vec4 tmpvar_26;
  tmpvar_26 = texture2DGradEXT (cube_CityOverlayTexPOS, tmpvar_21, tmpvar_25.xy, tmpvar_25.zw);
  mediump vec4 tmpvar_27;
  tmpvar_27 = tmpvar_26;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture2DGradEXT (cube_CityOverlayTexNEG, tmpvar_21, tmpvar_25.xy, tmpvar_25.zw);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  mediump vec4 tmpvar_30;
  tmpvar_30 = mix (tmpvar_29, tmpvar_27, vec4(float((s_7 >= 0.0))));
  mediump float tmpvar_31;
  tmpvar_31 = mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, zxlerp_9), nylerp_8);
  mediump vec4 tmpvar_32;
  tmpvar_32.x = tmpvar_30.w;
  tmpvar_32.y = tmpvar_30.w;
  tmpvar_32.z = tmpvar_30.w;
  tmpvar_32.w = tmpvar_31;
  cityoverlay_4.xyz = tmpvar_32.xyz;
  mediump vec2 uv_33;
  mediump vec3 detailCoords_34;
  mediump float s_35;
  mediump float nylerp_36;
  mediump float zxlerp_37;
  highp vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_10);
  highp float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  zxlerp_37 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  nylerp_36 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_37);
  s_35 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = sign(mix (tmpvar_10.y, s_35, nylerp_36));
  s_35 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = -(s_35);
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = s_35;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_43 * tmpvar_10.xzy), (tmpvar_44 * tmpvar_10.zxy), vec3(zxlerp_37));
  detailCoords_34 = tmpvar_45;
  mediump vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = s_35;
  highp vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_10.yxz), detailCoords_34, vec3(nylerp_36));
  detailCoords_34 = tmpvar_47;
  uv_33 = (((
    (0.5 * detailCoords_34.yz)
   / 
    abs(detailCoords_34.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_48;
  uv_48 = uv_33;
  highp vec2 uvCont_49;
  highp vec2 tmpvar_50;
  highp float tmpvar_51;
  tmpvar_51 = (0.5 * _CityOverlayDetailScale);
  tmpvar_50 = abs((uv_48 - tmpvar_51));
  uvCont_49.x = max (tmpvar_50.x, tmpvar_50.y);
  uvCont_49.y = min (tmpvar_50.x, tmpvar_50.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_49);
  tmpvar_52.zw = dFdy(uvCont_49);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_33, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citydarkoverlaydetail_3.xyz = tmpvar_54.xyz;
  mediump vec2 uv_55;
  mediump vec3 detailCoords_56;
  mediump float s_57;
  mediump float nylerp_58;
  mediump float zxlerp_59;
  highp vec3 tmpvar_60;
  tmpvar_60 = abs(tmpvar_10);
  highp float tmpvar_61;
  tmpvar_61 = float((tmpvar_60.z >= tmpvar_60.x));
  zxlerp_59 = tmpvar_61;
  highp float tmpvar_62;
  tmpvar_62 = float((max (tmpvar_60.x, tmpvar_60.z) >= tmpvar_60.y));
  nylerp_58 = tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_59);
  s_57 = tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = sign(mix (tmpvar_10.y, s_57, nylerp_58));
  s_57 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xz = vec2(1.0, -1.0);
  tmpvar_65.y = -(s_57);
  mediump vec3 tmpvar_66;
  tmpvar_66.xz = vec2(1.0, -1.0);
  tmpvar_66.y = s_57;
  highp vec3 tmpvar_67;
  tmpvar_67 = mix ((tmpvar_65 * tmpvar_10.xzy), (tmpvar_66 * tmpvar_10.zxy), vec3(zxlerp_59));
  detailCoords_56 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68.xy = vec2(1.0, 1.0);
  tmpvar_68.z = s_57;
  highp vec3 tmpvar_69;
  tmpvar_69 = mix ((tmpvar_68 * tmpvar_10.yxz), detailCoords_56, vec3(nylerp_58));
  detailCoords_56 = tmpvar_69;
  uv_55 = (((
    (0.5 * detailCoords_56.yz)
   / 
    abs(detailCoords_56.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_70;
  uv_70 = uv_55;
  highp vec2 uvCont_71;
  highp vec2 tmpvar_72;
  tmpvar_72 = abs((uv_70 - tmpvar_51));
  uvCont_71.x = max (tmpvar_72.x, tmpvar_72.y);
  uvCont_71.y = min (tmpvar_72.x, tmpvar_72.y);
  highp vec4 tmpvar_73;
  tmpvar_73.xy = dFdx(uvCont_71);
  tmpvar_73.zw = dFdy(uvCont_71);
  lowp vec4 tmpvar_74;
  tmpvar_74 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_55, tmpvar_73.xy, tmpvar_73.zw);
  mediump vec4 tmpvar_75;
  tmpvar_75 = tmpvar_74;
  citylightoverlaydetail_2.xyz = tmpvar_75.xyz;
  highp float tmpvar_76;
  tmpvar_76 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_31 * (1.0 - tmpvar_76));
  citydarkoverlaydetail_3.w = (tmpvar_54.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_75.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_75.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  mediump vec3 lightDir_77;
  lightDir_77 = _SunDir;
  mediump vec3 viewDir_78;
  viewDir_78 = xlv_TEXCOORD7;
  mediump vec3 normal_79;
  normal_79 = xlv_TEXCOORD4;
  mediump vec4 c_80;
  mediump vec3 tmpvar_81;
  tmpvar_81 = normalize(lightDir_77);
  lightDir_77 = tmpvar_81;
  mediump vec3 tmpvar_82;
  tmpvar_82 = normalize(viewDir_78);
  viewDir_78 = tmpvar_82;
  mediump vec3 tmpvar_83;
  tmpvar_83 = normalize(normal_79);
  normal_79 = tmpvar_83;
  mediump float tmpvar_84;
  tmpvar_84 = dot (tmpvar_83, tmpvar_81);
  highp float tmpvar_85;
  mediump float tmpvar_86;
  tmpvar_86 = clamp (dot (normalize(
    (tmpvar_81 + tmpvar_82)
  ), tmpvar_83), 0.0, 1.0);
  tmpvar_85 = tmpvar_86;
  highp float tmpvar_87;
  tmpvar_87 = (pow (tmpvar_85, _SpecularPower) * _SpecularColor.w);
  c_80.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_84) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_87)) * 2.0);
  c_80.w = (tmpvar_84 * 2.0);
  highp vec3 tmpvar_88;
  tmpvar_88 = normalize(_SunDir);
  mediump vec3 lightDir_89;
  lightDir_89 = tmpvar_88;
  mediump vec3 normal_90;
  normal_90 = xlv_TEXCOORD4;
  mediump float tmpvar_91;
  tmpvar_91 = dot (normal_90, lightDir_89);
  color_5 = (c_80 * mix (1.0, clamp (
    floor((1.01 + tmpvar_91))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_91))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_92;
  tmpvar_92 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_92.xyz;
  color_5.w = (tmpvar_92.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in lowp vec4 in_COLOR0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TEXCOORD0;
in highp vec4 in_TEXCOORD1;
out highp vec4 vs_TEXCOORD0;
out highp vec4 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD4;
out highp float vs_TEXCOORD6;
out highp vec3 vs_TEXCOORD5;
out highp vec3 vs_TEXCOORD7;
highp vec4 t0;
highp vec3 t1;
mediump float t16_2;
mediump float t16_5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t9);
    t9 = inversesqrt(t9);
    vs_TEXCOORD7.xyz = vec3(t9) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD4.xyz = vec3(t9) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t16_2 = t0.x + 1.00999999;
    t16_5 = t0.x * -10.0;
    t16_5 = clamp(t16_5, 0.0, 1.0);
    t16_2 = floor(t16_2);
    t16_2 = clamp(t16_2, 0.0, 1.0);
    t16_2 = t16_2 + -1.0;
    t16_2 = t16_5 * t16_2 + 1.0;
    vs_TEXCOORD6 = t16_2;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D cube_CityOverlayTexPOS;
uniform lowp sampler2D cube_CityOverlayTexNEG;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec4 vs_TEXCOORD0;
in highp vec3 vs_TEXCOORD4;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec3 t10_0;
highp int ti0;
bool tb0;
mediump vec4 t16_1;
mediump vec3 t16_2;
lowp vec4 t10_2;
highp vec2 t3;
lowp vec4 t10_3;
bool tb3;
mediump vec3 t16_4;
highp vec3 t5;
highp vec3 t6;
lowp vec3 t10_6;
highp vec3 t7;
mediump vec3 t16_8;
highp float t10;
bool tb10;
mediump vec2 t16_15;
highp vec2 t17;
highp int ti17;
bool tb21;
mediump float t16_22;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t16_1.x = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t16_8.x = t16_1.x + 1.00999999;
    t16_1.x = t16_1.x * -10.0;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_8.x = floor(t16_8.x);
    t16_8.x = clamp(t16_8.x, 0.0, 1.0);
    t16_8.x = t16_8.x + -1.0;
    t16_1.x = t16_1.x * t16_8.x + 1.0;
    t16_8.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t16_8.x = inversesqrt(t16_8.x);
    t16_8.xyz = t16_8.xxx * _SunDir.xyzx.xyz;
    t16_2.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t16_2.x = inversesqrt(t16_2.x);
    t16_2.xyz = t16_2.xxx * vs_TEXCOORD4.xyz;
    t16_8.x = dot(t16_2.xyz, t16_8.xyz);
    t16_8.x = t16_8.x + t16_8.x;
    t16_1.x = t16_1.x * t16_8.x;
    t16_1.x = clamp(t16_1.x, 0.0, 1.0);
    t16_1.x = (-t16_1.x) + 1.0;
    t16_2.xz = vec2(1.0, -1.0);
    t0.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t0.x = inversesqrt(t0.x);
    t7.xyz = t0.xxx * vs_TEXCOORD5.yxz;
    t3.x = vs_TEXCOORD5.z * t0.x + (-t7.y);
    tb10 = abs(t7.z)>=abs(t7.y);
    t10 = tb10 ? 1.0 : float(0.0);
    t3.x = t10 * t3.x + t7.y;
    t0.x = (-vs_TEXCOORD5.y) * t0.x + t3.x;
    t3.x = max(abs(t7.z), abs(t7.y));
    tb3 = t3.x>=abs(t7.x);
    t3.x = tb3 ? 1.0 : float(0.0);
    t0.x = t3.x * t0.x + t7.x;
    ti17 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti17) + ti0;
    t16_4.y = float(ti0);
    t16_2.y = (-t16_4.y);
    t5.xyz = t7.yzx * t16_2.xyz;
    t16_4.xz = vec2(1.0, -1.0);
    t6.xyz = t16_4.xyz * t7.zyx + (-t5.xyz);
    t5.xyz = vec3(t10) * t6.xyz + t5.xyz;
    t5.xyz = (-t16_4.xxy) * t7.xyz + t5.xyz;
    t0.xyz = t7.xyz * t16_4.xxy;
    tb21 = t16_4.y>=0.0;
    t16_8.x = (tb21) ? 1.0 : 0.0;
    t0.xyz = t3.xxx * t5.xyz + t0.xyz;
    t16_15.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_15.xy = t16_15.xy / abs(t0.xx);
    t0.x = max(abs(t16_15.y), abs(t16_15.x));
    t5.x = dFdx(t0.x);
    t0.z = min(abs(t16_15.y), abs(t16_15.x));
    t16_15.xy = t16_15.xy + vec2(0.5, 0.5);
    t5.y = dFdx(t0.z);
    t0.xy = dFdy(t0.xz);
    t10_6.xyz = textureGrad(cube_CityOverlayTexPOS, t16_15.xy, vec4(t5.xyxx).xy, vec4(t0.xyxx).xy).xyz;
    t10_0.xyz = textureGrad(cube_CityOverlayTexNEG, t16_15.xy, vec4(t5.xyxx).xy, vec4(t0.xyxx).xy).xyz;
    t17.xy = t16_15.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t16_2.xyz = (-t10_0.xyz) + t10_6.xyz;
    t16_8.xyz = t16_8.xxx * t16_2.xyz + t10_0.xyz;
    t16_22 = (-t16_8.x) + t16_8.z;
    t16_8.x = t10 * t16_22 + t16_8.x;
    t16_8.x = (-t16_8.y) + t16_8.x;
    t16_8.x = t3.x * t16_8.x + t16_8.y;
    tb0 = 0.0>=vs_TEXCOORD0.w;
    t0.x = (tb0) ? 0.0 : 1.0;
    t0.x = t0.x * t16_8.x;
    t7.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t17.xy;
    t7.z = max(abs(t7.y), abs(t7.x));
    t7.x = min(abs(t7.y), abs(t7.x));
    t3.xy = dFdx(t7.zx);
    t5.xy = dFdy(t7.zx);
    t10_2 = textureGrad(_CityDarkOverlayDetailTex, t17.xy, vec4(t3.xyxx).xy, vec4(t5.xyxx).xy);
    t10_3 = textureGrad(_CityLightOverlayDetailTex, t17.xy, vec4(t3.xyxx).xy, vec4(t5.xyxx).xy);
    t16_8.x = t0.x * t10_2.w;
    t16_15.x = t0.x * t10_3.w;
    t16_4.xyz = t10_2.xyz + (-t10_3.xyz);
    t16_22 = t16_8.x * t16_1.x + (-t16_15.x);
    t16_1.x = t16_1.x * t16_8.x;
    t16_8.x = t16_1.x * t16_22 + t16_15.x;
    t16_1.xzw = t16_1.xxx * t16_4.xyz + t10_3.xyz;
    SV_Target0.xyz = t16_1.xzw;
    t0.x = t16_8.x * _PlanetOpacity;
    SV_Target0.w = t0.x;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 19 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" ATTR0
Bind "color" ATTR1
Bind "normal" ATTR2
Bind "texcoord" ATTR3
Bind "texcoord1" ATTR4
ConstBuffer "$Globals" 176
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 144 [_PlanetOrigin] 3
Vector 160 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesVertex [[attribute(0)]];
  float4 _glesColor [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
  float4 _glesMultiTexCoord0 [[attribute(3)]];
  float4 _glesMultiTexCoord1 [[attribute(4)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float4 xlv_TEXCOORD0;
  float4 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD4;
  float3 xlv_TEXCOORD5;
  float xlv_TEXCOORD6;
  float3 xlv_TEXCOORD7;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float3 _PlanetOrigin;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  half4 tmpvar_1;
  tmpvar_1 = half4(_mtl_i._glesColor);
  half NdotL_2;
  float4 tmpvar_3;
  float4 tmpvar_4;
  float3 tmpvar_5;
  float tmpvar_6;
  float3 tmpvar_7;
  tmpvar_7 = (_mtl_u._Object2World * _mtl_i._glesVertex).xyz;
  float3 tmpvar_8;
  tmpvar_8 = (tmpvar_7 - _mtl_u._WorldSpaceCameraPos);
  tmpvar_4.w = sqrt(dot (tmpvar_8, tmpvar_8));
  float4 tmpvar_9;
  tmpvar_9.xy = _mtl_i._glesMultiTexCoord0.xy;
  tmpvar_9.z = _mtl_i._glesMultiTexCoord1.x;
  tmpvar_9.w = _mtl_i._glesMultiTexCoord1.y;
  tmpvar_5 = -(tmpvar_9.xyz);
  tmpvar_3 = float4(tmpvar_1);
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float tmpvar_10;
  tmpvar_10 = dot (tmpvar_5, normalize(_mtl_u._SunDir));
  NdotL_2 = half(tmpvar_10);
  half tmpvar_11;
  tmpvar_11 = mix ((half)1.0, clamp (floor(
    ((half)1.01 + NdotL_2)
  ), (half)0.0, (half)1.0), clamp (((half)10.0 * 
    -(NdotL_2)
  ), (half)0.0, (half)1.0));
  tmpvar_6 = float(tmpvar_11);
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = tmpvar_3;
  _mtl_o.xlv_TEXCOORD1 = tmpvar_4;
  _mtl_o.xlv_TEXCOORD4 = normalize((tmpvar_7 - _mtl_u._PlanetOrigin));
  _mtl_o.xlv_TEXCOORD5 = tmpvar_5;
  _mtl_o.xlv_TEXCOORD6 = tmpvar_6;
  _mtl_o.xlv_TEXCOORD7 = normalize((tmpvar_7 - _mtl_u._WorldSpaceCameraPos));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
float t2;
float t6;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    vs_TEXCOORD0 = in_COLOR0;
    t0.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t0.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t0.xyz;
    t0.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t0.xyz;
    t0.xyz = _Object2World[3].xyz * in_POSITION0.www + t0.xyz;
    t1.xyz = t0.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t0.xyz = t0.xyz + (-_PlanetOrigin.xyzx.xyz);
    t6 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD1.w = sqrt(t6);
    t6 = inversesqrt(t6);
    vs_TEXCOORD7.xyz = vec3(t6) * t1.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t6 = dot(t0.xyz, t0.xyz);
    t6 = inversesqrt(t6);
    vs_TEXCOORD4.xyz = vec3(t6) * t0.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t2 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t2 = floor(t2);
    t2 = clamp(t2, 0.0, 1.0);
    t2 = t2 + -1.0;
    vs_TEXCOORD6 = t0.x * t2 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D cube_CityOverlayTexPOS;
uniform  sampler2D cube_CityOverlayTexNEG;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec4 vs_TEXCOORD0;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
mediump vec3 t16_3;
vec4 t4;
lowp vec4 t10_4;
float t5;
int ti5;
bool tb5;
vec2 t6;
vec2 t10;
bool tb10;
float t11;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t15 = dot(vs_TEXCOORD4.xyz, t0.xyz);
    t1.x = t15 + 1.00999999;
    t15 = t15 * -10.0;
    t15 = clamp(t15, 0.0, 1.0);
    t1.x = floor(t1.x);
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = t1.x + -1.0;
    t15 = t15 * t1.x + 1.0;
    t1.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * vs_TEXCOORD4.xyz;
    t0.x = dot(t1.xyz, t0.xyz);
    t0.x = t0.x + t0.x;
    t0.x = t15 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5 = inversesqrt(t5);
    t2.xyz = vec3(t5) * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5 + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5 = (-vs_TEXCOORD5.y) * t5 + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5 = t10.x * t5 + t2.x;
    ti16 = int((0.0<t5) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t3.xxy;
    tb5 = t3.y>=0.0;
    t5 = tb5 ? 1.0 : float(0.0);
    t1.xyz = t10.xxx * t1.xyz + t2.xyz;
    t6.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t6.xy / abs(t1.xx);
    t11 = max(abs(t1.y), abs(t1.x));
    t2.x = dFdx(t11);
    t3.x = dFdy(t11);
    t11 = min(abs(t1.y), abs(t1.x));
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t2.y = dFdx(t11);
    t3.y = dFdy(t11);
    t10_4 = textureGrad(cube_CityOverlayTexPOS, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t10_2 = textureGrad(cube_CityOverlayTexNEG, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t1.xy = t1.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t16_3.xyz = (-t10_2.xyz) + t10_4.xyz;
    t2.xyz = vec3(t5) * t16_3.xyz + t10_2.xyz;
    t5 = (-t2.x) + t2.z;
    t5 = t15 * t5 + t2.x;
    t5 = (-t2.y) + t5;
    t5 = t10.x * t5 + t2.y;
    tb10 = 0.0>=vs_TEXCOORD0.w;
    t10.x = (tb10) ? 0.0 : 1.0;
    t5 = t10.x * t5;
    t10.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t11 = max(abs(t10.y), abs(t10.x));
    t10.x = min(abs(t10.y), abs(t10.x));
    t2.x = dFdx(t11);
    t3.x = dFdy(t11);
    t2.y = dFdx(t10.x);
    t3.y = dFdy(t10.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t1 = textureGrad(_CityLightOverlayDetailTex, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t10.x = t5 * t4.w;
    t1.w = t5 * t1.w;
    t4.w = t0.x * t10.x;
    t0 = (-t1) + t4;
    t0 = t4.wwww * t0 + t1;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 134 math, 5 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec4 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_4;
  tmpvar_4 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_4 - _WorldSpaceCameraPos);
  tmpvar_2.w = sqrt(dot (tmpvar_5, tmpvar_5));
  vec4 tmpvar_6;
  tmpvar_6.xy = gl_MultiTexCoord0.xy;
  tmpvar_6.z = gl_MultiTexCoord1.x;
  tmpvar_6.w = gl_MultiTexCoord1.y;
  tmpvar_3 = -(tmpvar_6.xyz);
  tmpvar_2.xyz = gl_Normal;
  float tmpvar_7;
  tmpvar_7 = dot (tmpvar_3, normalize(_SunDir));
  vec4 o_8;
  vec4 tmpvar_9;
  tmpvar_9 = (tmpvar_1 * 0.5);
  vec2 tmpvar_10;
  tmpvar_10.x = tmpvar_9.x;
  tmpvar_10.y = (tmpvar_9.y * _ProjectionParams.x);
  o_8.xy = (tmpvar_10 + tmpvar_9.w);
  o_8.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_2;
  xlv_TEXCOORD2 = o_8;
  xlv_TEXCOORD4 = normalize((tmpvar_4 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_3;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_7)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_7)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_4 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform sampler2D cube_CityOverlayTexPOS;
uniform sampler2D cube_CityOverlayTexNEG;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_6;
  tmpvar_6 = abs(tmpvar_5);
  float tmpvar_7;
  tmpvar_7 = float((tmpvar_6.z >= tmpvar_6.x));
  float tmpvar_8;
  tmpvar_8 = float((max (tmpvar_6.x, tmpvar_6.z) >= tmpvar_6.y));
  float tmpvar_9;
  tmpvar_9 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_7), tmpvar_8));
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = -(tmpvar_9);
  vec3 tmpvar_11;
  tmpvar_11.xz = vec2(1.0, -1.0);
  tmpvar_11.y = tmpvar_9;
  vec3 tmpvar_12;
  tmpvar_12.xy = vec2(1.0, 1.0);
  tmpvar_12.z = tmpvar_9;
  vec3 tmpvar_13;
  tmpvar_13 = mix ((tmpvar_12 * tmpvar_5.yxz), mix ((tmpvar_10 * tmpvar_5.xzy), (tmpvar_11 * tmpvar_5.zxy), vec3(tmpvar_7)), vec3(tmpvar_8));
  vec2 tmpvar_14;
  tmpvar_14 = (((0.5 * tmpvar_13.yz) / abs(tmpvar_13.x)) + 0.5);
  vec2 uvCont_15;
  vec2 tmpvar_16;
  tmpvar_16 = abs((tmpvar_14 - 0.5));
  uvCont_15.x = max (tmpvar_16.x, tmpvar_16.y);
  uvCont_15.y = min (tmpvar_16.x, tmpvar_16.y);
  vec4 tmpvar_17;
  tmpvar_17.xy = dFdx(uvCont_15);
  tmpvar_17.zw = dFdy(uvCont_15);
  vec4 tmpvar_18;
  tmpvar_18 = mix (texture2DGradARB (cube_CityOverlayTexNEG, tmpvar_14, tmpvar_17.xy, tmpvar_17.zw), texture2DGradARB (cube_CityOverlayTexPOS, tmpvar_14, tmpvar_17.xy, tmpvar_17.zw), vec4(float((tmpvar_9 >= 0.0))));
  float tmpvar_19;
  tmpvar_19 = mix (tmpvar_18.y, mix (tmpvar_18.x, tmpvar_18.z, tmpvar_7), tmpvar_8);
  vec4 tmpvar_20;
  tmpvar_20.x = tmpvar_18.w;
  tmpvar_20.y = tmpvar_18.w;
  tmpvar_20.z = tmpvar_18.w;
  tmpvar_20.w = tmpvar_19;
  cityoverlay_3.xyz = tmpvar_20.xyz;
  vec2 uv_21;
  vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_5);
  float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_23), tmpvar_24));
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(tmpvar_25);
  vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = tmpvar_25;
  vec3 tmpvar_28;
  tmpvar_28.xy = vec2(1.0, 1.0);
  tmpvar_28.z = tmpvar_25;
  vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_28 * tmpvar_5.yxz), mix ((tmpvar_26 * tmpvar_5.xzy), (tmpvar_27 * tmpvar_5.zxy), vec3(tmpvar_23)), vec3(tmpvar_24));
  uv_21 = (((
    (0.5 * tmpvar_29.yz)
   / 
    abs(tmpvar_29.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_30;
  vec2 tmpvar_31;
  float tmpvar_32;
  tmpvar_32 = (0.5 * _CityOverlayDetailScale);
  tmpvar_31 = abs((uv_21 - tmpvar_32));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_30);
  tmpvar_33.zw = dFdy(uvCont_30);
  vec4 tmpvar_34;
  tmpvar_34 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_21, tmpvar_33.xy, tmpvar_33.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_34.xyz;
  vec2 uv_35;
  vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_5);
  float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_37), tmpvar_38));
  vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(tmpvar_39);
  vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = tmpvar_39;
  vec3 tmpvar_42;
  tmpvar_42.xy = vec2(1.0, 1.0);
  tmpvar_42.z = tmpvar_39;
  vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_42 * tmpvar_5.yxz), mix ((tmpvar_40 * tmpvar_5.xzy), (tmpvar_41 * tmpvar_5.zxy), vec3(tmpvar_37)), vec3(tmpvar_38));
  uv_35 = (((
    (0.5 * tmpvar_43.yz)
   / 
    abs(tmpvar_43.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_44;
  vec2 tmpvar_45;
  tmpvar_45 = abs((uv_35 - tmpvar_32));
  uvCont_44.x = max (tmpvar_45.x, tmpvar_45.y);
  uvCont_44.y = min (tmpvar_45.x, tmpvar_45.y);
  vec4 tmpvar_46;
  tmpvar_46.xy = dFdx(uvCont_44);
  tmpvar_46.zw = dFdy(uvCont_44);
  vec4 tmpvar_47;
  tmpvar_47 = texture2DGradARB (_CityLightOverlayDetailTex, uv_35, tmpvar_46.xy, tmpvar_46.zw);
  citylightoverlaydetail_1.xyz = tmpvar_47.xyz;
  cityoverlay_3.w = (tmpvar_19 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_34.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_47.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_47.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_48;
  tmpvar_48 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2);
  vec4 c_49;
  vec3 tmpvar_50;
  tmpvar_50 = normalize(_SunDir);
  vec3 tmpvar_51;
  tmpvar_51 = normalize(xlv_TEXCOORD4);
  float tmpvar_52;
  tmpvar_52 = dot (tmpvar_51, tmpvar_50);
  c_49.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_52) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_50 + normalize(xlv_TEXCOORD7)))
    , tmpvar_51), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_48.x * 2.0));
  c_49.w = (tmpvar_52 * (tmpvar_48.x * 2.0));
  float tmpvar_53;
  tmpvar_53 = dot (xlv_TEXCOORD4, tmpvar_50);
  color_4 = (c_49 * mix (1.0, clamp (
    floor((1.01 + tmpvar_53))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_53))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_54;
  tmpvar_54 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_54.xyz;
  color_4.w = (tmpvar_54.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 39 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 10 [_PlanetOrigin]
Vector 8 [_ProjectionParams]
Vector 9 [_ScreenParams]
Vector 11 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c12, -10, 1.00999999, -1, 1
def c13, 0.5, 0, 0, 0
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord2 o3
dcl_texcoord4 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6.x
dcl_texcoord7 o7.xyz
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c10
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o7.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
nrm r0.xyz, c11
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o5.xyz, -r1
add r0.y, r0.x, c12.y
mul_sat r0.x, r0.x, c12.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c12.z
mad o6.x, r0.x, r0.y, c12.w
dp4 r0.y, c1, v0
mul r1.x, r0.y, c8.x
mul r1.w, r1.x, c13.x
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c13.x
mad o3.xy, r1.z, c9.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o3.zw, r0
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 29 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 139 math, 5 textures
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  mediump vec4 tmpvar_6;
  highp vec3 tmpvar_7;
  highp float tmpvar_8;
  highp vec4 tmpvar_9;
  tmpvar_9 = (_Object2World * _glesVertex);
  highp vec3 tmpvar_10;
  tmpvar_10 = (tmpvar_9.xyz - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_10, tmpvar_10));
  highp vec4 tmpvar_11;
  tmpvar_11.xy = _glesMultiTexCoord0.xy;
  tmpvar_11.z = tmpvar_2.x;
  tmpvar_11.w = tmpvar_2.y;
  tmpvar_7 = -(tmpvar_11.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_12;
  tmpvar_12 = dot (tmpvar_7, normalize(_SunDir));
  NdotL_3 = tmpvar_12;
  mediump float tmpvar_13;
  tmpvar_13 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_8 = tmpvar_13;
  tmpvar_6 = (unity_World2Shadow[0] * tmpvar_9);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD2 = tmpvar_6;
  xlv_TEXCOORD4 = normalize((tmpvar_9.xyz - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_7;
  xlv_TEXCOORD6 = tmpvar_8;
  xlv_TEXCOORD7 = normalize((tmpvar_9.xyz - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D cube_CityOverlayTexPOS;
uniform sampler2D cube_CityOverlayTexNEG;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying mediump vec4 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  mediump vec3 detailCoords_6;
  mediump float s_7;
  mediump float nylerp_8;
  mediump float zxlerp_9;
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_9);
  s_7 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, s_7, nylerp_8));
  s_7 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16.xz = vec2(1.0, -1.0);
  tmpvar_16.y = -(s_7);
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = s_7;
  highp vec3 tmpvar_18;
  tmpvar_18 = mix ((tmpvar_16 * tmpvar_10.xzy), (tmpvar_17 * tmpvar_10.zxy), vec3(zxlerp_9));
  detailCoords_6 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = s_7;
  highp vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_10.yxz), detailCoords_6, vec3(nylerp_8));
  detailCoords_6 = tmpvar_20;
  mediump vec2 tmpvar_21;
  tmpvar_21 = (((0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + 0.5);
  highp vec2 uv_22;
  uv_22 = tmpvar_21;
  highp vec2 uvCont_23;
  highp vec2 tmpvar_24;
  tmpvar_24 = abs((uv_22 - 0.5));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  highp vec4 tmpvar_25;
  tmpvar_25.xy = dFdx(uvCont_23);
  tmpvar_25.zw = dFdy(uvCont_23);
  lowp vec4 tmpvar_26;
  tmpvar_26 = texture2DGradEXT (cube_CityOverlayTexPOS, tmpvar_21, tmpvar_25.xy, tmpvar_25.zw);
  mediump vec4 tmpvar_27;
  tmpvar_27 = tmpvar_26;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture2DGradEXT (cube_CityOverlayTexNEG, tmpvar_21, tmpvar_25.xy, tmpvar_25.zw);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  mediump vec4 tmpvar_30;
  tmpvar_30 = mix (tmpvar_29, tmpvar_27, vec4(float((s_7 >= 0.0))));
  mediump float tmpvar_31;
  tmpvar_31 = mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, zxlerp_9), nylerp_8);
  mediump vec4 tmpvar_32;
  tmpvar_32.x = tmpvar_30.w;
  tmpvar_32.y = tmpvar_30.w;
  tmpvar_32.z = tmpvar_30.w;
  tmpvar_32.w = tmpvar_31;
  cityoverlay_4.xyz = tmpvar_32.xyz;
  mediump vec2 uv_33;
  mediump vec3 detailCoords_34;
  mediump float s_35;
  mediump float nylerp_36;
  mediump float zxlerp_37;
  highp vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_10);
  highp float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  zxlerp_37 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  nylerp_36 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_37);
  s_35 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = sign(mix (tmpvar_10.y, s_35, nylerp_36));
  s_35 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = -(s_35);
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = s_35;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_43 * tmpvar_10.xzy), (tmpvar_44 * tmpvar_10.zxy), vec3(zxlerp_37));
  detailCoords_34 = tmpvar_45;
  mediump vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = s_35;
  highp vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_10.yxz), detailCoords_34, vec3(nylerp_36));
  detailCoords_34 = tmpvar_47;
  uv_33 = (((
    (0.5 * detailCoords_34.yz)
   / 
    abs(detailCoords_34.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_48;
  uv_48 = uv_33;
  highp vec2 uvCont_49;
  highp vec2 tmpvar_50;
  highp float tmpvar_51;
  tmpvar_51 = (0.5 * _CityOverlayDetailScale);
  tmpvar_50 = abs((uv_48 - tmpvar_51));
  uvCont_49.x = max (tmpvar_50.x, tmpvar_50.y);
  uvCont_49.y = min (tmpvar_50.x, tmpvar_50.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_49);
  tmpvar_52.zw = dFdy(uvCont_49);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_33, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citydarkoverlaydetail_3.xyz = tmpvar_54.xyz;
  mediump vec2 uv_55;
  mediump vec3 detailCoords_56;
  mediump float s_57;
  mediump float nylerp_58;
  mediump float zxlerp_59;
  highp vec3 tmpvar_60;
  tmpvar_60 = abs(tmpvar_10);
  highp float tmpvar_61;
  tmpvar_61 = float((tmpvar_60.z >= tmpvar_60.x));
  zxlerp_59 = tmpvar_61;
  highp float tmpvar_62;
  tmpvar_62 = float((max (tmpvar_60.x, tmpvar_60.z) >= tmpvar_60.y));
  nylerp_58 = tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_59);
  s_57 = tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = sign(mix (tmpvar_10.y, s_57, nylerp_58));
  s_57 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xz = vec2(1.0, -1.0);
  tmpvar_65.y = -(s_57);
  mediump vec3 tmpvar_66;
  tmpvar_66.xz = vec2(1.0, -1.0);
  tmpvar_66.y = s_57;
  highp vec3 tmpvar_67;
  tmpvar_67 = mix ((tmpvar_65 * tmpvar_10.xzy), (tmpvar_66 * tmpvar_10.zxy), vec3(zxlerp_59));
  detailCoords_56 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68.xy = vec2(1.0, 1.0);
  tmpvar_68.z = s_57;
  highp vec3 tmpvar_69;
  tmpvar_69 = mix ((tmpvar_68 * tmpvar_10.yxz), detailCoords_56, vec3(nylerp_58));
  detailCoords_56 = tmpvar_69;
  uv_55 = (((
    (0.5 * detailCoords_56.yz)
   / 
    abs(detailCoords_56.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_70;
  uv_70 = uv_55;
  highp vec2 uvCont_71;
  highp vec2 tmpvar_72;
  tmpvar_72 = abs((uv_70 - tmpvar_51));
  uvCont_71.x = max (tmpvar_72.x, tmpvar_72.y);
  uvCont_71.y = min (tmpvar_72.x, tmpvar_72.y);
  highp vec4 tmpvar_73;
  tmpvar_73.xy = dFdx(uvCont_71);
  tmpvar_73.zw = dFdy(uvCont_71);
  lowp vec4 tmpvar_74;
  tmpvar_74 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_55, tmpvar_73.xy, tmpvar_73.zw);
  mediump vec4 tmpvar_75;
  tmpvar_75 = tmpvar_74;
  citylightoverlaydetail_2.xyz = tmpvar_75.xyz;
  highp float tmpvar_76;
  tmpvar_76 = float((0.0 >= xlv_TEXCOORD0.w));
  cityoverlay_4.w = (tmpvar_31 * (1.0 - tmpvar_76));
  citydarkoverlaydetail_3.w = (tmpvar_54.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_75.w * cityoverlay_4.w);
  color_5.xyz = (tmpvar_75.xyz * citylightoverlaydetail_2.www);
  color_5.w = 0.0;
  lowp float tmpvar_77;
  highp float tmpvar_78;
  tmpvar_78 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD2).x > 
    (xlv_TEXCOORD2.z / xlv_TEXCOORD2.w)
  )), _LightShadowData.x);
  tmpvar_77 = tmpvar_78;
  mediump vec3 lightDir_79;
  lightDir_79 = _SunDir;
  mediump vec3 viewDir_80;
  viewDir_80 = xlv_TEXCOORD7;
  mediump vec3 normal_81;
  normal_81 = xlv_TEXCOORD4;
  mediump float atten_82;
  atten_82 = tmpvar_77;
  mediump vec4 c_83;
  mediump vec3 tmpvar_84;
  tmpvar_84 = normalize(lightDir_79);
  lightDir_79 = tmpvar_84;
  mediump vec3 tmpvar_85;
  tmpvar_85 = normalize(viewDir_80);
  viewDir_80 = tmpvar_85;
  mediump vec3 tmpvar_86;
  tmpvar_86 = normalize(normal_81);
  normal_81 = tmpvar_86;
  mediump float tmpvar_87;
  tmpvar_87 = dot (tmpvar_86, tmpvar_84);
  highp float tmpvar_88;
  mediump float tmpvar_89;
  tmpvar_89 = clamp (dot (normalize(
    (tmpvar_84 + tmpvar_85)
  ), tmpvar_86), 0.0, 1.0);
  tmpvar_88 = tmpvar_89;
  highp float tmpvar_90;
  tmpvar_90 = (pow (tmpvar_88, _SpecularPower) * _SpecularColor.w);
  c_83.xyz = (((
    (color_5.xyz * _LightColor0.xyz)
   * tmpvar_87) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_90)) * (atten_82 * 2.0));
  c_83.w = (tmpvar_87 * (atten_82 * 2.0));
  highp vec3 tmpvar_91;
  tmpvar_91 = normalize(_SunDir);
  mediump vec3 lightDir_92;
  lightDir_92 = tmpvar_91;
  mediump vec3 normal_93;
  normal_93 = xlv_TEXCOORD4;
  mediump float tmpvar_94;
  tmpvar_94 = dot (normal_93, lightDir_92);
  color_5 = (c_83 * mix (1.0, clamp (
    floor((1.01 + tmpvar_94))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_94))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_5.w, 0.0, 1.0)));
  mediump vec4 tmpvar_95;
  tmpvar_95 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_5.xyz = tmpvar_95.xyz;
  color_5.w = (tmpvar_95.w * _PlanetOpacity);
  tmpvar_1 = color_5;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec4 in_COLOR0;
in  vec3 in_NORMAL0;
in  vec4 in_TEXCOORD0;
in  vec4 in_TEXCOORD1;
out vec4 vs_TEXCOORD0;
out vec4 vs_TEXCOORD1;
out vec4 vs_TEXCOORD2;
out vec3 vs_TEXCOORD4;
out float vs_TEXCOORD6;
out vec3 vs_TEXCOORD5;
out vec3 vs_TEXCOORD7;
vec4 t0;
vec3 t1;
vec4 t2;
float t3;
float t10;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    vs_TEXCOORD0 = in_COLOR0;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t2.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t1.xyz = t1.xyz + (-_PlanetOrigin.xyzx.xyz);
    t10 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD1.w = sqrt(t10);
    t10 = inversesqrt(t10);
    vs_TEXCOORD7.xyz = vec3(t10) * t2.xyz;
    vs_TEXCOORD1.xyz = in_NORMAL0.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t2.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD2.zw = t0.zw;
    vs_TEXCOORD2.xy = t2.zz + t2.xw;
    t0.x = dot(t1.xyz, t1.xyz);
    t0.x = inversesqrt(t0.x);
    vs_TEXCOORD4.xyz = t0.xxx * t1.xyz;
    t0.x = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * _SunDir.xyzx.xyz;
    t1.xy = in_TEXCOORD0.xy;
    t1.z = in_TEXCOORD1.x;
    t0.x = dot((-t1.xyz), t0.xyz);
    vs_TEXCOORD5.xyz = (-t1.xyz);
    t3 = t0.x + 1.00999999;
    t0.x = t0.x * -10.0;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t3 = floor(t3);
    t3 = clamp(t3, 0.0, 1.0);
    t3 = t3 + -1.0;
    vs_TEXCOORD6 = t0.x * t3 + 1.0;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	float _PlanetOpacity;
uniform 	vec3 _PlanetOrigin;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D cube_CityOverlayTexPOS;
uniform  sampler2D cube_CityOverlayTexNEG;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec4 vs_TEXCOORD0;
in  vec4 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD4;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
vec4 t1;
lowp vec4 t10_1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
mediump vec3 t16_3;
vec4 t4;
lowp vec4 t10_4;
float t5;
int ti5;
bool tb5;
vec2 t6;
vec2 t10;
bool tb10;
float t11;
float t15;
bool tb15;
int ti16;
void main()
{
    t0.x = dot(vs_TEXCOORD4.xyz, vs_TEXCOORD4.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * vs_TEXCOORD4.xyz;
    t15 = dot(_SunDir.xyzx.xyz, _SunDir.xyzx.xyz);
    t15 = inversesqrt(t15);
    t1.xyz = vec3(t15) * _SunDir.xyzx.xyz;
    t0.x = dot(t0.xyz, t1.xyz);
    t5 = dot(vs_TEXCOORD4.xyz, t1.xyz);
    t10.xy = vs_TEXCOORD2.xy / vs_TEXCOORD2.ww;
    t10_1 = texture(_ShadowMapTexture, t10.xy);
    t0.x = dot(t10_1.xx, t0.xx);
    t10.x = t5 + 1.00999999;
    t5 = t5 * -10.0;
    t5 = clamp(t5, 0.0, 1.0);
    t10.x = floor(t10.x);
    t10.x = clamp(t10.x, 0.0, 1.0);
    t10.x = t10.x + -1.0;
    t5 = t5 * t10.x + 1.0;
    t0.x = t5 * t0.x;
    t0.x = clamp(t0.x, 0.0, 1.0);
    t0.x = (-t0.x) + 1.0;
    t1.xz = vec2(1.0, -1.0);
    t5 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t5 = inversesqrt(t5);
    t2.xyz = vec3(t5) * vs_TEXCOORD5.yxz;
    t10.x = vs_TEXCOORD5.z * t5 + (-t2.y);
    tb15 = abs(t2.z)>=abs(t2.y);
    t15 = tb15 ? 1.0 : float(0.0);
    t10.x = t15 * t10.x + t2.y;
    t5 = (-vs_TEXCOORD5.y) * t5 + t10.x;
    t10.x = max(abs(t2.z), abs(t2.y));
    tb10 = t10.x>=abs(t2.x);
    t10.x = tb10 ? 1.0 : float(0.0);
    t5 = t10.x * t5 + t2.x;
    ti16 = int((0.0<t5) ? 0xFFFFFFFFu : uint(0u));
    ti5 = int((t5<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti5 = (-ti16) + ti5;
    t3.y = float(ti5);
    t1.y = (-t3.y);
    t1.xyz = t1.xyz * t2.yzx;
    t3.xz = vec2(1.0, -1.0);
    t4.xyz = t3.xyz * t2.zyx + (-t1.xyz);
    t1.xyz = vec3(t15) * t4.xyz + t1.xyz;
    t1.xyz = (-t3.xxy) * t2.xyz + t1.xyz;
    t2.xyz = t2.xyz * t3.xxy;
    tb5 = t3.y>=0.0;
    t5 = tb5 ? 1.0 : float(0.0);
    t1.xyz = t10.xxx * t1.xyz + t2.xyz;
    t6.xy = t1.yz * vec2(0.5, 0.5);
    t1.xy = t6.xy / abs(t1.xx);
    t11 = max(abs(t1.y), abs(t1.x));
    t2.x = dFdx(t11);
    t3.x = dFdy(t11);
    t11 = min(abs(t1.y), abs(t1.x));
    t1.xy = t1.xy + vec2(0.5, 0.5);
    t2.y = dFdx(t11);
    t3.y = dFdy(t11);
    t10_4 = textureGrad(cube_CityOverlayTexPOS, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t10_2 = textureGrad(cube_CityOverlayTexNEG, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t1.xy = t1.xy * vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale));
    t16_3.xyz = (-t10_2.xyz) + t10_4.xyz;
    t2.xyz = vec3(t5) * t16_3.xyz + t10_2.xyz;
    t5 = (-t2.x) + t2.z;
    t5 = t15 * t5 + t2.x;
    t5 = (-t2.y) + t5;
    t5 = t10.x * t5 + t2.y;
    tb10 = 0.0>=vs_TEXCOORD0.w;
    t10.x = (tb10) ? 0.0 : 1.0;
    t5 = t10.x * t5;
    t10.xy = (-vec2(vec2(_CityOverlayDetailScale, _CityOverlayDetailScale))) * vec2(0.5, 0.5) + t1.xy;
    t11 = max(abs(t10.y), abs(t10.x));
    t10.x = min(abs(t10.y), abs(t10.x));
    t2.x = dFdx(t11);
    t3.x = dFdy(t11);
    t2.y = dFdx(t10.x);
    t3.y = dFdy(t10.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t1 = textureGrad(_CityLightOverlayDetailTex, t1.xy, vec4(t2.xyxx).xy, vec4(t3.xyxx).xy);
    t10.x = t5 * t4.w;
    t1.w = t5 * t1.w;
    t4.w = t0.x * t10.x;
    t0 = (-t1) + t4;
    t0 = t4.wwww * t0 + t1;
    SV_Target0.w = t0.w * _PlanetOpacity;
    SV_Target0.xyz = t0.xyz;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 132 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform vec3 _PlanetOrigin;
uniform vec3 _SunDir;
varying vec4 xlv_TEXCOORD0;
varying vec4 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying float xlv_TEXCOORD6;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 tmpvar_1;
  vec3 tmpvar_2;
  vec3 tmpvar_3;
  tmpvar_3 = (_Object2World * gl_Vertex).xyz;
  vec3 tmpvar_4;
  tmpvar_4 = (tmpvar_3 - _WorldSpaceCameraPos);
  tmpvar_1.w = sqrt(dot (tmpvar_4, tmpvar_4));
  vec4 tmpvar_5;
  tmpvar_5.xy = gl_MultiTexCoord0.xy;
  tmpvar_5.z = gl_MultiTexCoord1.x;
  tmpvar_5.w = gl_MultiTexCoord1.y;
  tmpvar_2 = -(tmpvar_5.xyz);
  tmpvar_1.xyz = gl_Normal;
  float tmpvar_6;
  tmpvar_6 = dot (tmpvar_2, normalize(_SunDir));
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = gl_Color;
  xlv_TEXCOORD1 = tmpvar_1;
  xlv_TEXCOORD4 = normalize((tmpvar_3 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_2;
  xlv_TEXCOORD6 = mix (1.0, clamp (floor(
    (1.01 + tmpvar_6)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(tmpvar_6)
  ), 0.0, 1.0));
  xlv_TEXCOORD7 = normalize((tmpvar_3 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform sampler2D cube_CityOverlayTexPOS;
uniform sampler2D cube_CityOverlayTexNEG;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform float _PlanetOpacity;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec4 xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD4;
varying vec3 xlv_TEXCOORD5;
varying vec3 xlv_TEXCOORD7;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_6;
  tmpvar_6 = abs(tmpvar_5);
  float tmpvar_7;
  tmpvar_7 = float((tmpvar_6.z >= tmpvar_6.x));
  float tmpvar_8;
  tmpvar_8 = float((max (tmpvar_6.x, tmpvar_6.z) >= tmpvar_6.y));
  float tmpvar_9;
  tmpvar_9 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_7), tmpvar_8));
  vec3 tmpvar_10;
  tmpvar_10.xz = vec2(1.0, -1.0);
  tmpvar_10.y = -(tmpvar_9);
  vec3 tmpvar_11;
  tmpvar_11.xz = vec2(1.0, -1.0);
  tmpvar_11.y = tmpvar_9;
  vec3 tmpvar_12;
  tmpvar_12.xy = vec2(1.0, 1.0);
  tmpvar_12.z = tmpvar_9;
  vec3 tmpvar_13;
  tmpvar_13 = mix ((tmpvar_12 * tmpvar_5.yxz), mix ((tmpvar_10 * tmpvar_5.xzy), (tmpvar_11 * tmpvar_5.zxy), vec3(tmpvar_7)), vec3(tmpvar_8));
  vec2 tmpvar_14;
  tmpvar_14 = (((0.5 * tmpvar_13.yz) / abs(tmpvar_13.x)) + 0.5);
  vec2 uvCont_15;
  vec2 tmpvar_16;
  tmpvar_16 = abs((tmpvar_14 - 0.5));
  uvCont_15.x = max (tmpvar_16.x, tmpvar_16.y);
  uvCont_15.y = min (tmpvar_16.x, tmpvar_16.y);
  vec4 tmpvar_17;
  tmpvar_17.xy = dFdx(uvCont_15);
  tmpvar_17.zw = dFdy(uvCont_15);
  vec4 tmpvar_18;
  tmpvar_18 = mix (texture2DGradARB (cube_CityOverlayTexNEG, tmpvar_14, tmpvar_17.xy, tmpvar_17.zw), texture2DGradARB (cube_CityOverlayTexPOS, tmpvar_14, tmpvar_17.xy, tmpvar_17.zw), vec4(float((tmpvar_9 >= 0.0))));
  float tmpvar_19;
  tmpvar_19 = mix (tmpvar_18.y, mix (tmpvar_18.x, tmpvar_18.z, tmpvar_7), tmpvar_8);
  vec4 tmpvar_20;
  tmpvar_20.x = tmpvar_18.w;
  tmpvar_20.y = tmpvar_18.w;
  tmpvar_20.z = tmpvar_18.w;
  tmpvar_20.w = tmpvar_19;
  cityoverlay_3.xyz = tmpvar_20.xyz;
  vec2 uv_21;
  vec3 tmpvar_22;
  tmpvar_22 = abs(tmpvar_5);
  float tmpvar_23;
  tmpvar_23 = float((tmpvar_22.z >= tmpvar_22.x));
  float tmpvar_24;
  tmpvar_24 = float((max (tmpvar_22.x, tmpvar_22.z) >= tmpvar_22.y));
  float tmpvar_25;
  tmpvar_25 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_23), tmpvar_24));
  vec3 tmpvar_26;
  tmpvar_26.xz = vec2(1.0, -1.0);
  tmpvar_26.y = -(tmpvar_25);
  vec3 tmpvar_27;
  tmpvar_27.xz = vec2(1.0, -1.0);
  tmpvar_27.y = tmpvar_25;
  vec3 tmpvar_28;
  tmpvar_28.xy = vec2(1.0, 1.0);
  tmpvar_28.z = tmpvar_25;
  vec3 tmpvar_29;
  tmpvar_29 = mix ((tmpvar_28 * tmpvar_5.yxz), mix ((tmpvar_26 * tmpvar_5.xzy), (tmpvar_27 * tmpvar_5.zxy), vec3(tmpvar_23)), vec3(tmpvar_24));
  uv_21 = (((
    (0.5 * tmpvar_29.yz)
   / 
    abs(tmpvar_29.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_30;
  vec2 tmpvar_31;
  float tmpvar_32;
  tmpvar_32 = (0.5 * _CityOverlayDetailScale);
  tmpvar_31 = abs((uv_21 - tmpvar_32));
  uvCont_30.x = max (tmpvar_31.x, tmpvar_31.y);
  uvCont_30.y = min (tmpvar_31.x, tmpvar_31.y);
  vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_30);
  tmpvar_33.zw = dFdy(uvCont_30);
  vec4 tmpvar_34;
  tmpvar_34 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_21, tmpvar_33.xy, tmpvar_33.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_34.xyz;
  vec2 uv_35;
  vec3 tmpvar_36;
  tmpvar_36 = abs(tmpvar_5);
  float tmpvar_37;
  tmpvar_37 = float((tmpvar_36.z >= tmpvar_36.x));
  float tmpvar_38;
  tmpvar_38 = float((max (tmpvar_36.x, tmpvar_36.z) >= tmpvar_36.y));
  float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_5.y, mix (tmpvar_5.x, tmpvar_5.z, tmpvar_37), tmpvar_38));
  vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(tmpvar_39);
  vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = tmpvar_39;
  vec3 tmpvar_42;
  tmpvar_42.xy = vec2(1.0, 1.0);
  tmpvar_42.z = tmpvar_39;
  vec3 tmpvar_43;
  tmpvar_43 = mix ((tmpvar_42 * tmpvar_5.yxz), mix ((tmpvar_40 * tmpvar_5.xzy), (tmpvar_41 * tmpvar_5.zxy), vec3(tmpvar_37)), vec3(tmpvar_38));
  uv_35 = (((
    (0.5 * tmpvar_43.yz)
   / 
    abs(tmpvar_43.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_44;
  vec2 tmpvar_45;
  tmpvar_45 = abs((uv_35 - tmpvar_32));
  uvCont_44.x = max (tmpvar_45.x, tmpvar_45.y);
  uvCont_44.y = min (tmpvar_45.x, tmpvar_45.y);
  vec4 tmpvar_46;
  tmpvar_46.xy = dFdx(uvCont_44);
  tmpvar_46.zw = dFdy(uvCont_44);
  vec4 tmpvar_47;
  tmpvar_47 = texture2DGradARB (_CityLightOverlayDetailTex, uv_35, tmpvar_46.xy, tmpvar_46.zw);
  citylightoverlaydetail_1.xyz = tmpvar_47.xyz;
  cityoverlay_3.w = (tmpvar_19 * (1.0 - float(
    (0.0 >= xlv_TEXCOORD0.w)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_34.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_47.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_47.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_48;
  vec3 tmpvar_49;
  tmpvar_49 = normalize(_SunDir);
  vec3 tmpvar_50;
  tmpvar_50 = normalize(xlv_TEXCOORD4);
  float tmpvar_51;
  tmpvar_51 = dot (tmpvar_50, tmpvar_49);
  c_48.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_51) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_49 + normalize(xlv_TEXCOORD7)))
    , tmpvar_50), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_48.w = (tmpvar_51 * 2.0);
  float tmpvar_52;
  tmpvar_52 = dot (xlv_TEXCOORD4, tmpvar_49);
  color_4 = (c_48 * mix (1.0, clamp (
    floor((1.01 + tmpvar_52))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_52))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_53;
  tmpvar_53 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4.xyz = tmpvar_53.xyz;
  color_4.w = (tmpvar_53.w * _PlanetOpacity);
  gl_FragData[0] = color_4;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 33 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
Matrix 4 [_Object2World] 3
Matrix 0 [glstate_matrix_mvp]
Vector 8 [_PlanetOrigin]
Vector 9 [_SunDir]
Vector 7 [_WorldSpaceCameraPos]
"vs_3_0
def c10, -10, 1.00999999, -1, 1
dcl_position v0
dcl_color v1
dcl_normal v2
dcl_texcoord v3
dcl_texcoord1 v4
dcl_position o0
dcl_texcoord o1
dcl_texcoord1 o2
dcl_texcoord4 o3.xyz
dcl_texcoord5 o4.xyz
dcl_texcoord6 o5.x
dcl_texcoord7 o6.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r1.xyz, r0, -c7
add r0.xyz, r0, -c8
dp3 r0.w, r1, r1
rsq r0.w, r0.w
rcp o2.w, r0.w
mul o6.xyz, r0.w, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o3.xyz, r0.w, r0
nrm r0.xyz, c9
mov r1.xy, v3
mov r1.z, v4.x
dp3 r0.x, -r1, r0
mov o4.xyz, -r1
add r0.y, r0.x, c10.y
mul_sat r0.x, r0.x, c10.x
frc r0.z, r0.y
add_sat r0.y, -r0.z, r0.y
add r0.y, r0.y, c10.z
mad o5.x, r0.x, r0.y, c10.w
mov o1, v1
mov o2.xyz, v2

"
}
SubProgram "d3d11 " {
// Stats: 26 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
Bind "vertex" Vertex
Bind "color" Color
Bind "normal" Normal
Bind "texcoord" TexCoord0
Bind "texcoord1" TexCoord1
ConstBuffer "$Globals" 464
Vector 432 [_PlanetOrigin] 3
Vector 448 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 133 math, 4 textures
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE2_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesVertex;
attribute vec4 _glesColor;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
attribute vec4 _glesMultiTexCoord1;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp vec3 _PlanetOrigin;
uniform highp vec3 _SunDir;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec4 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp float xlv_TEXCOORD6;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  tmpvar_1 = _glesColor;
  highp vec4 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord1;
  mediump float NdotL_3;
  highp vec4 tmpvar_4;
  highp vec4 tmpvar_5;
  highp vec3 tmpvar_6;
  highp float tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_8 = (_Object2World * _glesVertex).xyz;
  highp vec3 tmpvar_9;
  tmpvar_9 = (tmpvar_8 - _WorldSpaceCameraPos);
  tmpvar_5.w = sqrt(dot (tmpvar_9, tmpvar_9));
  highp vec4 tmpvar_10;
  tmpvar_10.xy = _glesMultiTexCoord0.xy;
  tmpvar_10.z = tmpvar_2.x;
  tmpvar_10.w = tmpvar_2.y;
  tmpvar_6 = -(tmpvar_10.xyz);
  tmpvar_4 = tmpvar_1;
  tmpvar_5.xyz = _glesNormal;
  highp float tmpvar_11;
  tmpvar_11 = dot (tmpvar_6, normalize(_SunDir));
  NdotL_3 = tmpvar_11;
  mediump float tmpvar_12;
  tmpvar_12 = mix (1.0, clamp (floor(
    (1.01 + NdotL_3)
  ), 0.0, 1.0), clamp ((10.0 * 
    -(NdotL_3)
  ), 0.0, 1.0));
  tmpvar_7 = tmpvar_12;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = tmpvar_4;
  xlv_TEXCOORD1 = tmpvar_5;
  xlv_TEXCOORD4 = normalize((tmpvar_8 - _PlanetOrigin));
  xlv_TEXCOORD5 = tmpvar_6;
  xlv_TEXCOORD6 = tmpvar_7;
  xlv_TEXCOORD7 = normalize((tmpvar_8 - _WorldSpaceCameraPos));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D cube_CityOverlayTexPOS;
uniform sampler2D cube_CityOverlayTexNEG;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform highp float _PlanetOpacity;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec4 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD4;
varying highp vec3 xlv_TEXCOORD5;
varying highp vec3 xlv_TEXCOORD7;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec4 color_5;
  mediump vec3 detailCoords_6;
  mediump float s_7;
  mediump float nylerp_8;
  mediump float zxlerp_9;
  highp vec3 tmpvar_10;
  tmpvar_10 = normalize(xlv_TEXCOORD5);
  highp vec3 tmpvar_11;
  tmpvar_11 = abs(tmpvar_10);
  highp float tmpvar_12;
  tmpvar_12 = float((tmpvar_11.z >= tmpvar_11.x));
  zxlerp_9 = tmpvar_12;
  highp float tmpvar_13;
  tmpvar_13 = float((max (tmpvar_11.x, tmpvar_11.z) >= tmpvar_11.y));
  nylerp_8 = tmpvar_13;
  highp float tmpvar_14;
  tmpvar_14 = mix (tmpvar_10.x, tmpvar_10.z, zxlerp_9);
  s_7 = tmpvar_14;
  highp float tmpvar_15;
  tmpvar_15 = sign(mix (tmpvar_10.y, s_7, nylerp_8));
  s_7 = tmpvar_15;
  mediump vec3 tmpvar_16;
  tmpvar_16.xz = vec2(1.0, -1.0);
  tmpvar_16.y = -(s_7);
  mediump vec3 tmpvar_17;
  tmpvar_17.xz = vec2(1.0, -1.0);
  tmpvar_17.y = s_7;
  highp vec3 tmpvar_18;
  tmpvar_18 = mix ((tmpvar_16 * tmpvar_10.xzy), (tmpvar_17 * tmpvar_10.zxy), vec3(zxlerp_9));
  detailCoords_6 = tmpvar_18;
  mediump vec3 tmpvar_19;
  tmpvar_19.xy = vec2(1.0, 1.0);
  tmpvar_19.z = s_7;
  highp vec3 tmpvar_20;
  tmpvar_20 = mix ((tmpvar_19 * tmpvar_10.yxz), detailCoords_6, vec3(nylerp_8));
  detailCoords_6 = tmpvar_20;
  mediump vec2 tmpvar_21;
  tmpvar_21 = (((0.5 * detailCoords_6.yz) / abs(detailCoords_6.x)) + 0.5);
  highp vec2 uv_22;
  uv_22 = tmpvar_21;
  highp vec2 uvCont_23;
  highp vec2 tmpvar_24;
  tmpvar_24 = abs((uv_22 - 0.5));
  uvCont_23.x = max (tmpvar_24.x, tmpvar_24.y);
  uvCont_23.y = min (tmpvar_24.x, tmpvar_24.y);
  highp vec4 tmpvar_25;
  tmpvar_25.xy = dFdx(uvCont_23);
  tmpvar_25.zw = dFdy(uvCont_23);
  lowp vec4 tmpvar_26;
  tmpvar_26 = texture2DGradEXT (cube_CityOverlayTexPOS, tmpvar_21, tmpvar_25.xy, tmpvar_25.zw);
  mediump vec4 tmpvar_27;
  tmpvar_27 = tmpvar_26;
  lowp vec4 tmpvar_28;
  tmpvar_28 = texture2DGradEXT (cube_CityOverlayTexNEG, tmpvar_21, tmpvar_25.xy, tmpvar_25.zw);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  mediump vec4 tmpvar_30;
  tmpvar_30 = mix (tmpvar_29, tmpvar_27, vec4(float((s_7 >= 0.0))));
  mediump float tmpvar_31;
  tmpvar_31 = mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, zxlerp_9), nylerp_8);
  mediump vec4 