// Compiled shader for all platforms, uncompressed size: 2706.6KB

// Skipping shader variants that would not be included into build of current scene.

Shader "EVE/PlanetCityLight" {
Properties {
 _Color ("Color Tint", Color) = (1,1,1,1)
 _MainTex ("Main (RGB)", 2D) = "white" { }
 _BumpMap ("Normalmap", 2D) = "bump" { }
 _SpecularColor ("Specular tint", Color) = (1,1,1,1)
 _SpecularPower ("Shininess", Float) = 0.078125
 _DetailDist ("Detail Distance", Range(0,1)) = 0.00875
 _CityOverlayTex ("Overlay (RGB)", 2D) = "white" { }
 _CityOverlayDetailScale ("Overlay Detail Scale", Range(0,1000)) = 80
 _CityDarkOverlayDetailTex ("Overlay Detail (RGB) (A)", 2D) = "white" { }
 _CityLightOverlayDetailTex ("Overlay Detail (RGB) (A)", 2D) = "white" { }
 _PlanetOpacity ("PlanetOpacity", Float) = 1
 _SunDir ("SunDir", Vector) = (0,0,0,1)
}
SubShader { 
 Tags { "QUEUE"="Geometry+1" "IGNOREPROJECTOR"="true" "RenderMode"="Transparent" }


 // Stats for Vertex shader:
 //       d3d11 : 51 avg math (50..53)
 //        d3d9 : 55 avg math (52..58)
 //        gles : 271 avg math (231..307), 7 avg texture (5..11), 6 avg branch (6..9)
 //       metal : 26 avg math (25..28)
 //      opengl : 272 avg math (235..307), 7 avg texture (5..11), 6 avg branch (6..9)
 // Stats for Fragment shader:
 //       d3d11 : 112 avg math (102..125), 0 avg texture (0..2)
 //        d3d9 : 114 avg math (106..124), 19 avg texture (13..31)
 //       metal : 272 avg math (235..307), 7 avg texture (5..11), 6 avg branch (6..9)
 Pass {
  Tags { "QUEUE"="Geometry+1" "IGNOREPROJECTOR"="true" "SHADOWSUPPORT"="true" "RenderMode"="Transparent" }
  ZWrite Off
  Blend SrcAlpha OneMinusSrcAlpha
  GpuProgramID 2915
Program "vp" {
SubProgram "opengl " {
// Stats: 300 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  vec4 tmpvar_28;
  tmpvar_28 = texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw);
  cityoverlay_3.xyz = tmpvar_28.xyz;
  vec2 uv_29;
  vec3 tmpvar_30;
  tmpvar_30 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_30);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_30.yxz), mix ((tmpvar_35 * tmpvar_30.xzy), (tmpvar_36 * tmpvar_30.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_29 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  float tmpvar_41;
  tmpvar_41 = (0.5 * _CityOverlayDetailScale);
  tmpvar_40 = abs((uv_29 - tmpvar_41));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_39);
  tmpvar_42.zw = dFdy(uvCont_39);
  vec4 tmpvar_43;
  tmpvar_43 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_29, tmpvar_42.xy, tmpvar_42.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_43.xyz;
  vec2 uv_44;
  vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_30);
  float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  float tmpvar_48;
  tmpvar_48 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_46), tmpvar_47));
  vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = -(tmpvar_48);
  vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = tmpvar_48;
  vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = tmpvar_48;
  vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_30.yxz), mix ((tmpvar_49 * tmpvar_30.xzy), (tmpvar_50 * tmpvar_30.zxy), vec3(tmpvar_46)), vec3(tmpvar_47));
  uv_44 = (((
    (0.5 * tmpvar_52.yz)
   / 
    abs(tmpvar_52.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_53;
  vec2 tmpvar_54;
  tmpvar_54 = abs((uv_44 - tmpvar_41));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  vec4 tmpvar_55;
  tmpvar_55.xy = dFdx(uvCont_53);
  tmpvar_55.zw = dFdy(uvCont_53);
  vec4 tmpvar_56;
  tmpvar_56 = texture2DGradARB (_CityLightOverlayDetailTex, uv_44, tmpvar_55.xy, tmpvar_55.zw);
  citylightoverlaydetail_1.xyz = tmpvar_56.xyz;
  cityoverlay_3.w = (tmpvar_28.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_43.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_56.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_56.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_57;
  vec3 tmpvar_58;
  tmpvar_58 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_59;
  tmpvar_59 = normalize(normal_20);
  float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, tmpvar_58);
  c_57.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_60) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_58 + normalize(xlv_TEXCOORD1)))
    , tmpvar_59), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_57.w = (tmpvar_60 * 2.0);
  float tmpvar_61;
  tmpvar_61 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_57 * mix (1.0, clamp (
    floor((1.01 + tmpvar_61))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_61))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_62;
  tmpvar_62 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_62;
  gl_FragData[0] = tmpvar_62;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 296 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  cityoverlay_4.xyz = tmpvar_35.xyz;
  mediump vec2 uv_36;
  mediump vec3 detailCoords_37;
  mediump float s_38;
  mediump float nylerp_39;
  mediump float zxlerp_40;
  highp vec3 tmpvar_41;
  tmpvar_41 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_42;
  tmpvar_42 = abs(tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = float((tmpvar_42.z >= tmpvar_42.x));
  zxlerp_40 = tmpvar_43;
  highp float tmpvar_44;
  tmpvar_44 = float((max (tmpvar_42.x, tmpvar_42.z) >= tmpvar_42.y));
  nylerp_39 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_40);
  s_38 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = sign(mix (tmpvar_41.y, s_38, nylerp_39));
  s_38 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xz = vec2(1.0, -1.0);
  tmpvar_47.y = -(s_38);
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = s_38;
  highp vec3 tmpvar_49;
  tmpvar_49 = mix ((tmpvar_47 * tmpvar_41.xzy), (tmpvar_48 * tmpvar_41.zxy), vec3(zxlerp_40));
  detailCoords_37 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xy = vec2(1.0, 1.0);
  tmpvar_50.z = s_38;
  highp vec3 tmpvar_51;
  tmpvar_51 = mix ((tmpvar_50 * tmpvar_41.yxz), detailCoords_37, vec3(nylerp_39));
  detailCoords_37 = tmpvar_51;
  uv_36 = (((
    (0.5 * detailCoords_37.yz)
   / 
    abs(detailCoords_37.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_52;
  uv_52 = uv_36;
  highp vec2 uvCont_53;
  highp vec2 tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (0.5 * _CityOverlayDetailScale);
  tmpvar_54 = abs((uv_52 - tmpvar_55));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_53);
  tmpvar_56.zw = dFdy(uvCont_53);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_36, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citydarkoverlaydetail_3.xyz = tmpvar_58.xyz;
  mediump vec2 uv_59;
  mediump vec3 detailCoords_60;
  mediump float s_61;
  mediump float nylerp_62;
  mediump float zxlerp_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = abs(tmpvar_41);
  highp float tmpvar_65;
  tmpvar_65 = float((tmpvar_64.z >= tmpvar_64.x));
  zxlerp_63 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = float((max (tmpvar_64.x, tmpvar_64.z) >= tmpvar_64.y));
  nylerp_62 = tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_63);
  s_61 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = sign(mix (tmpvar_41.y, s_61, nylerp_62));
  s_61 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69.xz = vec2(1.0, -1.0);
  tmpvar_69.y = -(s_61);
  mediump vec3 tmpvar_70;
  tmpvar_70.xz = vec2(1.0, -1.0);
  tmpvar_70.y = s_61;
  highp vec3 tmpvar_71;
  tmpvar_71 = mix ((tmpvar_69 * tmpvar_41.xzy), (tmpvar_70 * tmpvar_41.zxy), vec3(zxlerp_63));
  detailCoords_60 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xy = vec2(1.0, 1.0);
  tmpvar_72.z = s_61;
  highp vec3 tmpvar_73;
  tmpvar_73 = mix ((tmpvar_72 * tmpvar_41.yxz), detailCoords_60, vec3(nylerp_62));
  detailCoords_60 = tmpvar_73;
  uv_59 = (((
    (0.5 * detailCoords_60.yz)
   / 
    abs(detailCoords_60.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_74;
  uv_74 = uv_59;
  highp vec2 uvCont_75;
  highp vec2 tmpvar_76;
  tmpvar_76 = abs((uv_74 - tmpvar_55));
  uvCont_75.x = max (tmpvar_76.x, tmpvar_76.y);
  uvCont_75.y = min (tmpvar_76.x, tmpvar_76.y);
  highp vec4 tmpvar_77;
  tmpvar_77.xy = dFdx(uvCont_75);
  tmpvar_77.zw = dFdy(uvCont_75);
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_59, tmpvar_77.xy, tmpvar_77.zw);
  mediump vec4 tmpvar_79;
  tmpvar_79 = tmpvar_78;
  citylightoverlaydetail_2.xyz = tmpvar_79.xyz;
  cityoverlay_4.w = (tmpvar_35.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_58.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_79.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_79.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_80;
  lightDir_80 = xlv_TEXCOORD5;
  mediump vec3 viewDir_81;
  viewDir_81 = xlv_TEXCOORD1;
  mediump vec4 c_82;
  mediump vec3 tmpvar_83;
  tmpvar_83 = normalize(lightDir_80);
  lightDir_80 = tmpvar_83;
  mediump vec3 tmpvar_84;
  tmpvar_84 = normalize(viewDir_81);
  viewDir_81 = tmpvar_84;
  mediump vec3 tmpvar_85;
  tmpvar_85 = normalize(normT_5);
  mediump float tmpvar_86;
  tmpvar_86 = dot (tmpvar_85, tmpvar_83);
  highp float tmpvar_87;
  mediump float tmpvar_88;
  tmpvar_88 = clamp (dot (normalize(
    (tmpvar_83 + tmpvar_84)
  ), tmpvar_85), 0.0, 1.0);
  tmpvar_87 = tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = (pow (tmpvar_87, _SpecularPower) * _SpecularColor.w);
  c_82.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_86) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_89)) * 2.0);
  c_82.w = (tmpvar_86 * 2.0);
  highp vec3 tmpvar_90;
  tmpvar_90 = normalize(_SunDir);
  mediump vec3 lightDir_91;
  lightDir_91 = tmpvar_90;
  mediump vec3 normal_92;
  normal_92 = xlv_TEXCOORD3;
  mediump float tmpvar_93;
  tmpvar_93 = dot (normal_92, lightDir_91);
  color_6 = (c_82 * mix (1.0, clamp (
    floor((1.01 + tmpvar_93))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_93))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_94;
  tmpvar_94 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_94;
  tmpvar_1 = tmpvar_94;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
mediump float t16_4;
lowp vec3 t10_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_13;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
bool tb19;
highp float t20;
mediump float t16_22;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_31;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    tb19 = t10_19>=1.0;
    t16_4 = (tb19) ? 0.0 : 1.0;
    t10_19 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_5.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    t16_4 = t16_4 * t10_19;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_13.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t0.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t0.xy = t16_13.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_13.x = t16_4 * t10_3.w;
    t16_4 = t16_4 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_22 = dot(t10_5.xyz, t10_5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_7.xyz = vec3(t16_22) * t10_5.xyz;
    t16_22 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_8.xyz = vec3(t16_22) * vs_TEXCOORD5.xyz;
    t16_22 = dot(t16_7.xyz, t16_8.xyz);
    t16_22 = t16_22 + t16_22;
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_31 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_31 + 1.00999999;
    t16_31 = t16_31 * -10.0;
    t16_31 = clamp(t16_31, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_31 = t16_31 * t16_33 + 1.0;
    t16_22 = t16_31 * t16_22;
    t16_22 = clamp(t16_22, 0.0, 1.0);
    t16_22 = (-t16_22) + 1.0;
    t16_31 = t16_13.x * t16_22 + (-t16_4);
    t16_13.x = t16_22 * t16_13.x;
    t16_1.w = t16_13.x * t16_31 + t16_4;
    t16_1.xyz = t16_13.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
float t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    tb13 = t10_4.w>=1.0;
    t13 = (tb13) ? 0.0 : 1.0;
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t1.x = t13 * t10_4.w;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13 = tb13 ? 1.0 : float(0.0);
    t7 = t13 * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = vec3(t13) * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t1.x = t1.x + t1.x;
    t13 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13 = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13 + 1.00999999;
    t13 = t13 * -10.0;
    t13 = clamp(t13, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13 = t13 * t19 + 1.0;
    t1.x = t13 * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 302 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 tmpvar_1;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = gl_Normal;
  vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(gl_Normal);
  vec3 tmpvar_6;
  tmpvar_6 = normalize(TANGENT.xyz);
  vec3 tmpvar_7;
  vec3 tmpvar_8;
  tmpvar_7 = TANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * TANGENT.w);
  mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = gl_Normal.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = gl_Normal.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = gl_Normal.z;
  vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  vec4 o_11;
  vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_1 * 0.5);
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_12.x;
  tmpvar_13.y = (tmpvar_12.y * _ProjectionParams.x);
  o_11.xy = (tmpvar_13 + tmpvar_12.w);
  o_11.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
  xlv_TEXCOORD6 = o_11;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  vec4 tmpvar_28;
  tmpvar_28 = texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw);
  cityoverlay_3.xyz = tmpvar_28.xyz;
  vec2 uv_29;
  vec3 tmpvar_30;
  tmpvar_30 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_30);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_30.yxz), mix ((tmpvar_35 * tmpvar_30.xzy), (tmpvar_36 * tmpvar_30.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_29 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  float tmpvar_41;
  tmpvar_41 = (0.5 * _CityOverlayDetailScale);
  tmpvar_40 = abs((uv_29 - tmpvar_41));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_39);
  tmpvar_42.zw = dFdy(uvCont_39);
  vec4 tmpvar_43;
  tmpvar_43 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_29, tmpvar_42.xy, tmpvar_42.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_43.xyz;
  vec2 uv_44;
  vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_30);
  float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  float tmpvar_48;
  tmpvar_48 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_46), tmpvar_47));
  vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = -(tmpvar_48);
  vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = tmpvar_48;
  vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = tmpvar_48;
  vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_30.yxz), mix ((tmpvar_49 * tmpvar_30.xzy), (tmpvar_50 * tmpvar_30.zxy), vec3(tmpvar_46)), vec3(tmpvar_47));
  uv_44 = (((
    (0.5 * tmpvar_52.yz)
   / 
    abs(tmpvar_52.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_53;
  vec2 tmpvar_54;
  tmpvar_54 = abs((uv_44 - tmpvar_41));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  vec4 tmpvar_55;
  tmpvar_55.xy = dFdx(uvCont_53);
  tmpvar_55.zw = dFdy(uvCont_53);
  vec4 tmpvar_56;
  tmpvar_56 = texture2DGradARB (_CityLightOverlayDetailTex, uv_44, tmpvar_55.xy, tmpvar_55.zw);
  citylightoverlaydetail_1.xyz = tmpvar_56.xyz;
  cityoverlay_3.w = (tmpvar_28.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_43.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_56.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_56.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_57;
  tmpvar_57 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_58;
  vec3 tmpvar_59;
  tmpvar_59 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_60;
  tmpvar_60 = normalize(normal_20);
  float tmpvar_61;
  tmpvar_61 = dot (tmpvar_60, tmpvar_59);
  c_58.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_61) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_59 + normalize(xlv_TEXCOORD1)))
    , tmpvar_60), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_57.x * 2.0));
  c_58.w = (tmpvar_61 * (tmpvar_57.x * 2.0));
  float tmpvar_62;
  tmpvar_62 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_58 * mix (1.0, clamp (
    floor((1.01 + tmpvar_62))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_62))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_63;
  tmpvar_63 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_63;
  gl_FragData[0] = tmpvar_63;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 58 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_ProjectionParams]
Vector 12 [_ScreenParams]
Vector 13 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c14, 1, 0, 0.5, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c13
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c14
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r1.x, r0.y, c11.x
mul r1.w, r1.x, c14.z
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c14.z
mad o6.xy, r1.z, c12.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o6.zw, r0

"
}
SubProgram "d3d11 " {
// Stats: 53 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 302 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  cityoverlay_4.xyz = tmpvar_35.xyz;
  mediump vec2 uv_36;
  mediump vec3 detailCoords_37;
  mediump float s_38;
  mediump float nylerp_39;
  mediump float zxlerp_40;
  highp vec3 tmpvar_41;
  tmpvar_41 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_42;
  tmpvar_42 = abs(tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = float((tmpvar_42.z >= tmpvar_42.x));
  zxlerp_40 = tmpvar_43;
  highp float tmpvar_44;
  tmpvar_44 = float((max (tmpvar_42.x, tmpvar_42.z) >= tmpvar_42.y));
  nylerp_39 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_40);
  s_38 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = sign(mix (tmpvar_41.y, s_38, nylerp_39));
  s_38 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xz = vec2(1.0, -1.0);
  tmpvar_47.y = -(s_38);
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = s_38;
  highp vec3 tmpvar_49;
  tmpvar_49 = mix ((tmpvar_47 * tmpvar_41.xzy), (tmpvar_48 * tmpvar_41.zxy), vec3(zxlerp_40));
  detailCoords_37 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xy = vec2(1.0, 1.0);
  tmpvar_50.z = s_38;
  highp vec3 tmpvar_51;
  tmpvar_51 = mix ((tmpvar_50 * tmpvar_41.yxz), detailCoords_37, vec3(nylerp_39));
  detailCoords_37 = tmpvar_51;
  uv_36 = (((
    (0.5 * detailCoords_37.yz)
   / 
    abs(detailCoords_37.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_52;
  uv_52 = uv_36;
  highp vec2 uvCont_53;
  highp vec2 tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (0.5 * _CityOverlayDetailScale);
  tmpvar_54 = abs((uv_52 - tmpvar_55));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_53);
  tmpvar_56.zw = dFdy(uvCont_53);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_36, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citydarkoverlaydetail_3.xyz = tmpvar_58.xyz;
  mediump vec2 uv_59;
  mediump vec3 detailCoords_60;
  mediump float s_61;
  mediump float nylerp_62;
  mediump float zxlerp_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = abs(tmpvar_41);
  highp float tmpvar_65;
  tmpvar_65 = float((tmpvar_64.z >= tmpvar_64.x));
  zxlerp_63 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = float((max (tmpvar_64.x, tmpvar_64.z) >= tmpvar_64.y));
  nylerp_62 = tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_63);
  s_61 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = sign(mix (tmpvar_41.y, s_61, nylerp_62));
  s_61 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69.xz = vec2(1.0, -1.0);
  tmpvar_69.y = -(s_61);
  mediump vec3 tmpvar_70;
  tmpvar_70.xz = vec2(1.0, -1.0);
  tmpvar_70.y = s_61;
  highp vec3 tmpvar_71;
  tmpvar_71 = mix ((tmpvar_69 * tmpvar_41.xzy), (tmpvar_70 * tmpvar_41.zxy), vec3(zxlerp_63));
  detailCoords_60 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xy = vec2(1.0, 1.0);
  tmpvar_72.z = s_61;
  highp vec3 tmpvar_73;
  tmpvar_73 = mix ((tmpvar_72 * tmpvar_41.yxz), detailCoords_60, vec3(nylerp_62));
  detailCoords_60 = tmpvar_73;
  uv_59 = (((
    (0.5 * detailCoords_60.yz)
   / 
    abs(detailCoords_60.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_74;
  uv_74 = uv_59;
  highp vec2 uvCont_75;
  highp vec2 tmpvar_76;
  tmpvar_76 = abs((uv_74 - tmpvar_55));
  uvCont_75.x = max (tmpvar_76.x, tmpvar_76.y);
  uvCont_75.y = min (tmpvar_76.x, tmpvar_76.y);
  highp vec4 tmpvar_77;
  tmpvar_77.xy = dFdx(uvCont_75);
  tmpvar_77.zw = dFdy(uvCont_75);
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_59, tmpvar_77.xy, tmpvar_77.zw);
  mediump vec4 tmpvar_79;
  tmpvar_79 = tmpvar_78;
  citylightoverlaydetail_2.xyz = tmpvar_79.xyz;
  cityoverlay_4.w = (tmpvar_35.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_58.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_79.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_79.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_80 = tmpvar_81;
  mediump vec3 lightDir_82;
  lightDir_82 = xlv_TEXCOORD5;
  mediump vec3 viewDir_83;
  viewDir_83 = xlv_TEXCOORD1;
  mediump float atten_84;
  atten_84 = tmpvar_80;
  mediump vec4 c_85;
  mediump vec3 tmpvar_86;
  tmpvar_86 = normalize(lightDir_82);
  lightDir_82 = tmpvar_86;
  mediump vec3 tmpvar_87;
  tmpvar_87 = normalize(viewDir_83);
  viewDir_83 = tmpvar_87;
  mediump vec3 tmpvar_88;
  tmpvar_88 = normalize(normT_5);
  mediump float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, tmpvar_86);
  highp float tmpvar_90;
  mediump float tmpvar_91;
  tmpvar_91 = clamp (dot (normalize(
    (tmpvar_86 + tmpvar_87)
  ), tmpvar_88), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = (pow (tmpvar_90, _SpecularPower) * _SpecularColor.w);
  c_85.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_89) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_92)) * (atten_84 * 2.0));
  c_85.w = (tmpvar_89 * (atten_84 * 2.0));
  highp vec3 tmpvar_93;
  tmpvar_93 = normalize(_SunDir);
  mediump vec3 lightDir_94;
  lightDir_94 = tmpvar_93;
  mediump vec3 normal_95;
  normal_95 = xlv_TEXCOORD3;
  mediump float tmpvar_96;
  tmpvar_96 = dot (normal_95, lightDir_94);
  color_6 = (c_85 * mix (1.0, clamp (
    floor((1.01 + tmpvar_96))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_96))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_97;
  tmpvar_97 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_97;
  tmpvar_1 = tmpvar_97;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
vec4 t0;
vec4 t1;
vec3 t2;
vec3 t3;
vec3 t7;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * in_NORMAL0.zxy;
    t13 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_TANGENT0.yzx;
    t3.xyz = t1.xyz * t2.xyz;
    t1.xyz = t1.zxy * t2.yzx + (-t3.xyz);
    t1.xyz = t1.xyz * in_TANGENT0.www;
    t2.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t2.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t2.xyz;
    t2.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t2.xyz;
    t2.xyz = t2.xyz + _World2Object[3].xyz;
    t2.xyz = t2.xyz + (-in_POSITION0.xyz);
    t7.y = dot(t1.xyz, t2.xyz);
    t7.x = dot(in_TANGENT0.xyz, t2.xyz);
    t7.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t7.xyz, t7.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD1.xyz = vec3(t13) * t7.xyz;
    t2.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t2.xyz;
    t2.xyz = _Object2World[3].xyz * in_POSITION0.www + t2.xyz;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t13 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD0 = sqrt(t13);
    t13 = dot(in_POSITION0, in_POSITION0);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t2.xyz);
    t2.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t2.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD3.xyz = vec3(t13) * t2.xyz;
    t2.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t2.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t2.xyz;
    t2.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t2.xyz;
    t1.y = dot(t1.xyz, t2.xyz);
    t1.x = dot(in_TANGENT0.xyz, t2.xyz);
    t1.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD6.zw = t0.zw;
    vs_TEXCOORD6.xy = t1.zz + t1.xw;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
vec2 t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13.x = t7 * 0.0208350997 + -0.0851330012;
    t13.x = t7 * t13.x + 0.180141002;
    t13.x = t7 * t13.x + -0.330299497;
    t7 = t7 * t13.x + 0.999866009;
    t13.x = t7 * t1.x;
    t13.x = t13.x * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13.x = tb19 ? t13.x : float(0.0);
    t1.x = t1.x * t7 + t13.x;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13.x = tb7.y ? t20 : float(0.0);
    t13.x = t19 * t14 + t13.x;
    t2.y = t13.x * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    tb13 = t10_4.w>=1.0;
    t13.x = (tb13) ? 0.0 : 1.0;
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t1.x = t13.x * t10_4.w;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13.x = tb13 ? 1.0 : float(0.0);
    t7 = t13.x * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = t13.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t13.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t13.xy);
    t1.x = dot(t10_2.xx, t1.xx);
    t13.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13.x = inversesqrt(t13.x);
    t2.xyz = t13.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13.x = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13.x + 1.00999999;
    t13.x = t13.x * -10.0;
    t13.x = clamp(t13.x, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13.x = t13.x * t19 + 1.0;
    t1.x = t13.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 300 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  vec4 tmpvar_28;
  tmpvar_28 = texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw);
  cityoverlay_3.xyz = tmpvar_28.xyz;
  vec2 uv_29;
  vec3 tmpvar_30;
  tmpvar_30 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_30);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_30.yxz), mix ((tmpvar_35 * tmpvar_30.xzy), (tmpvar_36 * tmpvar_30.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_29 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  float tmpvar_41;
  tmpvar_41 = (0.5 * _CityOverlayDetailScale);
  tmpvar_40 = abs((uv_29 - tmpvar_41));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_39);
  tmpvar_42.zw = dFdy(uvCont_39);
  vec4 tmpvar_43;
  tmpvar_43 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_29, tmpvar_42.xy, tmpvar_42.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_43.xyz;
  vec2 uv_44;
  vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_30);
  float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  float tmpvar_48;
  tmpvar_48 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_46), tmpvar_47));
  vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = -(tmpvar_48);
  vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = tmpvar_48;
  vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = tmpvar_48;
  vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_30.yxz), mix ((tmpvar_49 * tmpvar_30.xzy), (tmpvar_50 * tmpvar_30.zxy), vec3(tmpvar_46)), vec3(tmpvar_47));
  uv_44 = (((
    (0.5 * tmpvar_52.yz)
   / 
    abs(tmpvar_52.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_53;
  vec2 tmpvar_54;
  tmpvar_54 = abs((uv_44 - tmpvar_41));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  vec4 tmpvar_55;
  tmpvar_55.xy = dFdx(uvCont_53);
  tmpvar_55.zw = dFdy(uvCont_53);
  vec4 tmpvar_56;
  tmpvar_56 = texture2DGradARB (_CityLightOverlayDetailTex, uv_44, tmpvar_55.xy, tmpvar_55.zw);
  citylightoverlaydetail_1.xyz = tmpvar_56.xyz;
  cityoverlay_3.w = (tmpvar_28.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_43.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_56.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_56.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_57;
  vec3 tmpvar_58;
  tmpvar_58 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_59;
  tmpvar_59 = normalize(normal_20);
  float tmpvar_60;
  tmpvar_60 = dot (tmpvar_59, tmpvar_58);
  c_57.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_60) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_58 + normalize(xlv_TEXCOORD1)))
    , tmpvar_59), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_57.w = (tmpvar_60 * 2.0);
  float tmpvar_61;
  tmpvar_61 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_57 * mix (1.0, clamp (
    floor((1.01 + tmpvar_61))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_61))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_62;
  tmpvar_62 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_62;
  gl_FragData[0] = tmpvar_62;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 296 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  cityoverlay_4.xyz = tmpvar_35.xyz;
  mediump vec2 uv_36;
  mediump vec3 detailCoords_37;
  mediump float s_38;
  mediump float nylerp_39;
  mediump float zxlerp_40;
  highp vec3 tmpvar_41;
  tmpvar_41 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_42;
  tmpvar_42 = abs(tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = float((tmpvar_42.z >= tmpvar_42.x));
  zxlerp_40 = tmpvar_43;
  highp float tmpvar_44;
  tmpvar_44 = float((max (tmpvar_42.x, tmpvar_42.z) >= tmpvar_42.y));
  nylerp_39 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_40);
  s_38 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = sign(mix (tmpvar_41.y, s_38, nylerp_39));
  s_38 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xz = vec2(1.0, -1.0);
  tmpvar_47.y = -(s_38);
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = s_38;
  highp vec3 tmpvar_49;
  tmpvar_49 = mix ((tmpvar_47 * tmpvar_41.xzy), (tmpvar_48 * tmpvar_41.zxy), vec3(zxlerp_40));
  detailCoords_37 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xy = vec2(1.0, 1.0);
  tmpvar_50.z = s_38;
  highp vec3 tmpvar_51;
  tmpvar_51 = mix ((tmpvar_50 * tmpvar_41.yxz), detailCoords_37, vec3(nylerp_39));
  detailCoords_37 = tmpvar_51;
  uv_36 = (((
    (0.5 * detailCoords_37.yz)
   / 
    abs(detailCoords_37.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_52;
  uv_52 = uv_36;
  highp vec2 uvCont_53;
  highp vec2 tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (0.5 * _CityOverlayDetailScale);
  tmpvar_54 = abs((uv_52 - tmpvar_55));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_53);
  tmpvar_56.zw = dFdy(uvCont_53);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_36, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citydarkoverlaydetail_3.xyz = tmpvar_58.xyz;
  mediump vec2 uv_59;
  mediump vec3 detailCoords_60;
  mediump float s_61;
  mediump float nylerp_62;
  mediump float zxlerp_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = abs(tmpvar_41);
  highp float tmpvar_65;
  tmpvar_65 = float((tmpvar_64.z >= tmpvar_64.x));
  zxlerp_63 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = float((max (tmpvar_64.x, tmpvar_64.z) >= tmpvar_64.y));
  nylerp_62 = tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_63);
  s_61 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = sign(mix (tmpvar_41.y, s_61, nylerp_62));
  s_61 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69.xz = vec2(1.0, -1.0);
  tmpvar_69.y = -(s_61);
  mediump vec3 tmpvar_70;
  tmpvar_70.xz = vec2(1.0, -1.0);
  tmpvar_70.y = s_61;
  highp vec3 tmpvar_71;
  tmpvar_71 = mix ((tmpvar_69 * tmpvar_41.xzy), (tmpvar_70 * tmpvar_41.zxy), vec3(zxlerp_63));
  detailCoords_60 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xy = vec2(1.0, 1.0);
  tmpvar_72.z = s_61;
  highp vec3 tmpvar_73;
  tmpvar_73 = mix ((tmpvar_72 * tmpvar_41.yxz), detailCoords_60, vec3(nylerp_62));
  detailCoords_60 = tmpvar_73;
  uv_59 = (((
    (0.5 * detailCoords_60.yz)
   / 
    abs(detailCoords_60.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_74;
  uv_74 = uv_59;
  highp vec2 uvCont_75;
  highp vec2 tmpvar_76;
  tmpvar_76 = abs((uv_74 - tmpvar_55));
  uvCont_75.x = max (tmpvar_76.x, tmpvar_76.y);
  uvCont_75.y = min (tmpvar_76.x, tmpvar_76.y);
  highp vec4 tmpvar_77;
  tmpvar_77.xy = dFdx(uvCont_75);
  tmpvar_77.zw = dFdy(uvCont_75);
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_59, tmpvar_77.xy, tmpvar_77.zw);
  mediump vec4 tmpvar_79;
  tmpvar_79 = tmpvar_78;
  citylightoverlaydetail_2.xyz = tmpvar_79.xyz;
  cityoverlay_4.w = (tmpvar_35.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_58.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_79.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_79.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_80;
  lightDir_80 = xlv_TEXCOORD5;
  mediump vec3 viewDir_81;
  viewDir_81 = xlv_TEXCOORD1;
  mediump vec4 c_82;
  mediump vec3 tmpvar_83;
  tmpvar_83 = normalize(lightDir_80);
  lightDir_80 = tmpvar_83;
  mediump vec3 tmpvar_84;
  tmpvar_84 = normalize(viewDir_81);
  viewDir_81 = tmpvar_84;
  mediump vec3 tmpvar_85;
  tmpvar_85 = normalize(normT_5);
  mediump float tmpvar_86;
  tmpvar_86 = dot (tmpvar_85, tmpvar_83);
  highp float tmpvar_87;
  mediump float tmpvar_88;
  tmpvar_88 = clamp (dot (normalize(
    (tmpvar_83 + tmpvar_84)
  ), tmpvar_85), 0.0, 1.0);
  tmpvar_87 = tmpvar_88;
  highp float tmpvar_89;
  tmpvar_89 = (pow (tmpvar_87, _SpecularPower) * _SpecularColor.w);
  c_82.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_86) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_89)) * 2.0);
  c_82.w = (tmpvar_86 * 2.0);
  highp vec3 tmpvar_90;
  tmpvar_90 = normalize(_SunDir);
  mediump vec3 lightDir_91;
  lightDir_91 = tmpvar_90;
  mediump vec3 normal_92;
  normal_92 = xlv_TEXCOORD3;
  mediump float tmpvar_93;
  tmpvar_93 = dot (normal_92, lightDir_91);
  color_6 = (c_82 * mix (1.0, clamp (
    floor((1.01 + tmpvar_93))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_93))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_94;
  tmpvar_94 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_94;
  tmpvar_1 = tmpvar_94;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
mediump float t16_4;
lowp vec3 t10_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_13;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
bool tb19;
highp float t20;
mediump float t16_22;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_31;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    tb19 = t10_19>=1.0;
    t16_4 = (tb19) ? 0.0 : 1.0;
    t10_19 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_5.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    t16_4 = t16_4 * t10_19;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_13.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t0.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t0.xy = t16_13.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_13.x = t16_4 * t10_3.w;
    t16_4 = t16_4 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_22 = dot(t10_5.xyz, t10_5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_7.xyz = vec3(t16_22) * t10_5.xyz;
    t16_22 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_8.xyz = vec3(t16_22) * vs_TEXCOORD5.xyz;
    t16_22 = dot(t16_7.xyz, t16_8.xyz);
    t16_22 = t16_22 + t16_22;
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_31 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_31 + 1.00999999;
    t16_31 = t16_31 * -10.0;
    t16_31 = clamp(t16_31, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_31 = t16_31 * t16_33 + 1.0;
    t16_22 = t16_31 * t16_22;
    t16_22 = clamp(t16_22, 0.0, 1.0);
    t16_22 = (-t16_22) + 1.0;
    t16_31 = t16_13.x * t16_22 + (-t16_4);
    t16_13.x = t16_22 * t16_13.x;
    t16_1.w = t16_13.x * t16_31 + t16_4;
    t16_1.xyz = t16_13.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
float t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13 = t7 * 0.0208350997 + -0.0851330012;
    t13 = t7 * t13 + 0.180141002;
    t13 = t7 * t13 + -0.330299497;
    t7 = t7 * t13 + 0.999866009;
    t13 = t7 * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7 + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    tb13 = t10_4.w>=1.0;
    t13 = (tb13) ? 0.0 : 1.0;
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t1.x = t13 * t10_4.w;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13 = tb13 ? 1.0 : float(0.0);
    t7 = t13 * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = vec3(t13) * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t1.x = t1.x + t1.x;
    t13 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13 = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13 + 1.00999999;
    t13 = t13 * -10.0;
    t13 = clamp(t13, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13 = t13 * t19 + 1.0;
    t1.x = t13 * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 302 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 tmpvar_1;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = gl_Normal;
  vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(gl_Normal);
  vec3 tmpvar_6;
  tmpvar_6 = normalize(TANGENT.xyz);
  vec3 tmpvar_7;
  vec3 tmpvar_8;
  tmpvar_7 = TANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * TANGENT.w);
  mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = gl_Normal.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = gl_Normal.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = gl_Normal.z;
  vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  vec4 o_11;
  vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_1 * 0.5);
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_12.x;
  tmpvar_13.y = (tmpvar_12.y * _ProjectionParams.x);
  o_11.xy = (tmpvar_13 + tmpvar_12.w);
  o_11.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
  xlv_TEXCOORD6 = o_11;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  vec4 tmpvar_28;
  tmpvar_28 = texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw);
  cityoverlay_3.xyz = tmpvar_28.xyz;
  vec2 uv_29;
  vec3 tmpvar_30;
  tmpvar_30 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_31;
  tmpvar_31 = abs(tmpvar_30);
  float tmpvar_32;
  tmpvar_32 = float((tmpvar_31.z >= tmpvar_31.x));
  float tmpvar_33;
  tmpvar_33 = float((max (tmpvar_31.x, tmpvar_31.z) >= tmpvar_31.y));
  float tmpvar_34;
  tmpvar_34 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_32), tmpvar_33));
  vec3 tmpvar_35;
  tmpvar_35.xz = vec2(1.0, -1.0);
  tmpvar_35.y = -(tmpvar_34);
  vec3 tmpvar_36;
  tmpvar_36.xz = vec2(1.0, -1.0);
  tmpvar_36.y = tmpvar_34;
  vec3 tmpvar_37;
  tmpvar_37.xy = vec2(1.0, 1.0);
  tmpvar_37.z = tmpvar_34;
  vec3 tmpvar_38;
  tmpvar_38 = mix ((tmpvar_37 * tmpvar_30.yxz), mix ((tmpvar_35 * tmpvar_30.xzy), (tmpvar_36 * tmpvar_30.zxy), vec3(tmpvar_32)), vec3(tmpvar_33));
  uv_29 = (((
    (0.5 * tmpvar_38.yz)
   / 
    abs(tmpvar_38.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_39;
  vec2 tmpvar_40;
  float tmpvar_41;
  tmpvar_41 = (0.5 * _CityOverlayDetailScale);
  tmpvar_40 = abs((uv_29 - tmpvar_41));
  uvCont_39.x = max (tmpvar_40.x, tmpvar_40.y);
  uvCont_39.y = min (tmpvar_40.x, tmpvar_40.y);
  vec4 tmpvar_42;
  tmpvar_42.xy = dFdx(uvCont_39);
  tmpvar_42.zw = dFdy(uvCont_39);
  vec4 tmpvar_43;
  tmpvar_43 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_29, tmpvar_42.xy, tmpvar_42.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_43.xyz;
  vec2 uv_44;
  vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_30);
  float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  float tmpvar_48;
  tmpvar_48 = sign(mix (tmpvar_30.y, mix (tmpvar_30.x, tmpvar_30.z, tmpvar_46), tmpvar_47));
  vec3 tmpvar_49;
  tmpvar_49.xz = vec2(1.0, -1.0);
  tmpvar_49.y = -(tmpvar_48);
  vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = tmpvar_48;
  vec3 tmpvar_51;
  tmpvar_51.xy = vec2(1.0, 1.0);
  tmpvar_51.z = tmpvar_48;
  vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_51 * tmpvar_30.yxz), mix ((tmpvar_49 * tmpvar_30.xzy), (tmpvar_50 * tmpvar_30.zxy), vec3(tmpvar_46)), vec3(tmpvar_47));
  uv_44 = (((
    (0.5 * tmpvar_52.yz)
   / 
    abs(tmpvar_52.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_53;
  vec2 tmpvar_54;
  tmpvar_54 = abs((uv_44 - tmpvar_41));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  vec4 tmpvar_55;
  tmpvar_55.xy = dFdx(uvCont_53);
  tmpvar_55.zw = dFdy(uvCont_53);
  vec4 tmpvar_56;
  tmpvar_56 = texture2DGradARB (_CityLightOverlayDetailTex, uv_44, tmpvar_55.xy, tmpvar_55.zw);
  citylightoverlaydetail_1.xyz = tmpvar_56.xyz;
  cityoverlay_3.w = (tmpvar_28.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_43.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_56.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_56.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_57;
  tmpvar_57 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_58;
  vec3 tmpvar_59;
  tmpvar_59 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_60;
  tmpvar_60 = normalize(normal_20);
  float tmpvar_61;
  tmpvar_61 = dot (tmpvar_60, tmpvar_59);
  c_58.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_61) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_59 + normalize(xlv_TEXCOORD1)))
    , tmpvar_60), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_57.x * 2.0));
  c_58.w = (tmpvar_61 * (tmpvar_57.x * 2.0));
  float tmpvar_62;
  tmpvar_62 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_58 * mix (1.0, clamp (
    floor((1.01 + tmpvar_62))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_62))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_63;
  tmpvar_63 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_63;
  gl_FragData[0] = tmpvar_63;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 58 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_ProjectionParams]
Vector 12 [_ScreenParams]
Vector 13 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c14, 1, 0, 0.5, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c13
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c14
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r1.x, r0.y, c11.x
mul r1.w, r1.x, c14.z
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c14.z
mad o6.xy, r1.z, c12.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o6.zw, r0

"
}
SubProgram "d3d11 " {
// Stats: 53 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 302 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  cityoverlay_4.xyz = tmpvar_35.xyz;
  mediump vec2 uv_36;
  mediump vec3 detailCoords_37;
  mediump float s_38;
  mediump float nylerp_39;
  mediump float zxlerp_40;
  highp vec3 tmpvar_41;
  tmpvar_41 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_42;
  tmpvar_42 = abs(tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = float((tmpvar_42.z >= tmpvar_42.x));
  zxlerp_40 = tmpvar_43;
  highp float tmpvar_44;
  tmpvar_44 = float((max (tmpvar_42.x, tmpvar_42.z) >= tmpvar_42.y));
  nylerp_39 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_40);
  s_38 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = sign(mix (tmpvar_41.y, s_38, nylerp_39));
  s_38 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xz = vec2(1.0, -1.0);
  tmpvar_47.y = -(s_38);
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = s_38;
  highp vec3 tmpvar_49;
  tmpvar_49 = mix ((tmpvar_47 * tmpvar_41.xzy), (tmpvar_48 * tmpvar_41.zxy), vec3(zxlerp_40));
  detailCoords_37 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xy = vec2(1.0, 1.0);
  tmpvar_50.z = s_38;
  highp vec3 tmpvar_51;
  tmpvar_51 = mix ((tmpvar_50 * tmpvar_41.yxz), detailCoords_37, vec3(nylerp_39));
  detailCoords_37 = tmpvar_51;
  uv_36 = (((
    (0.5 * detailCoords_37.yz)
   / 
    abs(detailCoords_37.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_52;
  uv_52 = uv_36;
  highp vec2 uvCont_53;
  highp vec2 tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (0.5 * _CityOverlayDetailScale);
  tmpvar_54 = abs((uv_52 - tmpvar_55));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_53);
  tmpvar_56.zw = dFdy(uvCont_53);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_36, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citydarkoverlaydetail_3.xyz = tmpvar_58.xyz;
  mediump vec2 uv_59;
  mediump vec3 detailCoords_60;
  mediump float s_61;
  mediump float nylerp_62;
  mediump float zxlerp_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = abs(tmpvar_41);
  highp float tmpvar_65;
  tmpvar_65 = float((tmpvar_64.z >= tmpvar_64.x));
  zxlerp_63 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = float((max (tmpvar_64.x, tmpvar_64.z) >= tmpvar_64.y));
  nylerp_62 = tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_63);
  s_61 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = sign(mix (tmpvar_41.y, s_61, nylerp_62));
  s_61 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69.xz = vec2(1.0, -1.0);
  tmpvar_69.y = -(s_61);
  mediump vec3 tmpvar_70;
  tmpvar_70.xz = vec2(1.0, -1.0);
  tmpvar_70.y = s_61;
  highp vec3 tmpvar_71;
  tmpvar_71 = mix ((tmpvar_69 * tmpvar_41.xzy), (tmpvar_70 * tmpvar_41.zxy), vec3(zxlerp_63));
  detailCoords_60 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xy = vec2(1.0, 1.0);
  tmpvar_72.z = s_61;
  highp vec3 tmpvar_73;
  tmpvar_73 = mix ((tmpvar_72 * tmpvar_41.yxz), detailCoords_60, vec3(nylerp_62));
  detailCoords_60 = tmpvar_73;
  uv_59 = (((
    (0.5 * detailCoords_60.yz)
   / 
    abs(detailCoords_60.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_74;
  uv_74 = uv_59;
  highp vec2 uvCont_75;
  highp vec2 tmpvar_76;
  tmpvar_76 = abs((uv_74 - tmpvar_55));
  uvCont_75.x = max (tmpvar_76.x, tmpvar_76.y);
  uvCont_75.y = min (tmpvar_76.x, tmpvar_76.y);
  highp vec4 tmpvar_77;
  tmpvar_77.xy = dFdx(uvCont_75);
  tmpvar_77.zw = dFdy(uvCont_75);
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_59, tmpvar_77.xy, tmpvar_77.zw);
  mediump vec4 tmpvar_79;
  tmpvar_79 = tmpvar_78;
  citylightoverlaydetail_2.xyz = tmpvar_79.xyz;
  cityoverlay_4.w = (tmpvar_35.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_58.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_79.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_79.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float tmpvar_80;
  highp float tmpvar_81;
  tmpvar_81 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_80 = tmpvar_81;
  mediump vec3 lightDir_82;
  lightDir_82 = xlv_TEXCOORD5;
  mediump vec3 viewDir_83;
  viewDir_83 = xlv_TEXCOORD1;
  mediump float atten_84;
  atten_84 = tmpvar_80;
  mediump vec4 c_85;
  mediump vec3 tmpvar_86;
  tmpvar_86 = normalize(lightDir_82);
  lightDir_82 = tmpvar_86;
  mediump vec3 tmpvar_87;
  tmpvar_87 = normalize(viewDir_83);
  viewDir_83 = tmpvar_87;
  mediump vec3 tmpvar_88;
  tmpvar_88 = normalize(normT_5);
  mediump float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, tmpvar_86);
  highp float tmpvar_90;
  mediump float tmpvar_91;
  tmpvar_91 = clamp (dot (normalize(
    (tmpvar_86 + tmpvar_87)
  ), tmpvar_88), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = (pow (tmpvar_90, _SpecularPower) * _SpecularColor.w);
  c_85.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_89) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_92)) * (atten_84 * 2.0));
  c_85.w = (tmpvar_89 * (atten_84 * 2.0));
  highp vec3 tmpvar_93;
  tmpvar_93 = normalize(_SunDir);
  mediump vec3 lightDir_94;
  lightDir_94 = tmpvar_93;
  mediump vec3 normal_95;
  normal_95 = xlv_TEXCOORD3;
  mediump float tmpvar_96;
  tmpvar_96 = dot (normal_95, lightDir_94);
  color_6 = (c_85 * mix (1.0, clamp (
    floor((1.01 + tmpvar_96))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_96))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_97;
  tmpvar_97 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_97;
  tmpvar_1 = tmpvar_97;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
vec4 t0;
vec4 t1;
vec3 t2;
vec3 t3;
vec3 t7;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * in_NORMAL0.zxy;
    t13 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_TANGENT0.yzx;
    t3.xyz = t1.xyz * t2.xyz;
    t1.xyz = t1.zxy * t2.yzx + (-t3.xyz);
    t1.xyz = t1.xyz * in_TANGENT0.www;
    t2.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t2.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t2.xyz;
    t2.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t2.xyz;
    t2.xyz = t2.xyz + _World2Object[3].xyz;
    t2.xyz = t2.xyz + (-in_POSITION0.xyz);
    t7.y = dot(t1.xyz, t2.xyz);
    t7.x = dot(in_TANGENT0.xyz, t2.xyz);
    t7.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t7.xyz, t7.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD1.xyz = vec3(t13) * t7.xyz;
    t2.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t2.xyz;
    t2.xyz = _Object2World[3].xyz * in_POSITION0.www + t2.xyz;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t13 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD0 = sqrt(t13);
    t13 = dot(in_POSITION0, in_POSITION0);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t2.xyz);
    t2.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t2.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD3.xyz = vec3(t13) * t2.xyz;
    t2.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t2.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t2.xyz;
    t2.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t2.xyz;
    t1.y = dot(t1.xyz, t2.xyz);
    t1.x = dot(in_TANGENT0.xyz, t2.xyz);
    t1.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD6.zw = t0.zw;
    vs_TEXCOORD6.xy = t1.zz + t1.xw;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
vec2 t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13.x = t7 * 0.0208350997 + -0.0851330012;
    t13.x = t7 * t13.x + 0.180141002;
    t13.x = t7 * t13.x + -0.330299497;
    t7 = t7 * t13.x + 0.999866009;
    t13.x = t7 * t1.x;
    t13.x = t13.x * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13.x = tb19 ? t13.x : float(0.0);
    t1.x = t1.x * t7 + t13.x;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13.x = tb7.y ? t20 : float(0.0);
    t13.x = t19 * t14 + t13.x;
    t2.y = t13.x * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    tb13 = t10_4.w>=1.0;
    t13.x = (tb13) ? 0.0 : 1.0;
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    t1.x = t13.x * t10_4.w;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13.x = tb13 ? 1.0 : float(0.0);
    t7 = t13.x * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = t13.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t13.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t13.xy);
    t1.x = dot(t10_2.xx, t1.xx);
    t13.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13.x = inversesqrt(t13.x);
    t2.xyz = t13.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13.x = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13.x + 1.00999999;
    t13.x = t13.x * -10.0;
    t13.x = clamp(t13.x, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13.x = t13.x * t19 + 1.0;
    t1.x = t13.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 301 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  cityoverlay_4.xyz = tmpvar_35.xyz;
  mediump vec2 uv_36;
  mediump vec3 detailCoords_37;
  mediump float s_38;
  mediump float nylerp_39;
  mediump float zxlerp_40;
  highp vec3 tmpvar_41;
  tmpvar_41 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_42;
  tmpvar_42 = abs(tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = float((tmpvar_42.z >= tmpvar_42.x));
  zxlerp_40 = tmpvar_43;
  highp float tmpvar_44;
  tmpvar_44 = float((max (tmpvar_42.x, tmpvar_42.z) >= tmpvar_42.y));
  nylerp_39 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_40);
  s_38 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = sign(mix (tmpvar_41.y, s_38, nylerp_39));
  s_38 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xz = vec2(1.0, -1.0);
  tmpvar_47.y = -(s_38);
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = s_38;
  highp vec3 tmpvar_49;
  tmpvar_49 = mix ((tmpvar_47 * tmpvar_41.xzy), (tmpvar_48 * tmpvar_41.zxy), vec3(zxlerp_40));
  detailCoords_37 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xy = vec2(1.0, 1.0);
  tmpvar_50.z = s_38;
  highp vec3 tmpvar_51;
  tmpvar_51 = mix ((tmpvar_50 * tmpvar_41.yxz), detailCoords_37, vec3(nylerp_39));
  detailCoords_37 = tmpvar_51;
  uv_36 = (((
    (0.5 * detailCoords_37.yz)
   / 
    abs(detailCoords_37.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_52;
  uv_52 = uv_36;
  highp vec2 uvCont_53;
  highp vec2 tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (0.5 * _CityOverlayDetailScale);
  tmpvar_54 = abs((uv_52 - tmpvar_55));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_53);
  tmpvar_56.zw = dFdy(uvCont_53);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_36, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citydarkoverlaydetail_3.xyz = tmpvar_58.xyz;
  mediump vec2 uv_59;
  mediump vec3 detailCoords_60;
  mediump float s_61;
  mediump float nylerp_62;
  mediump float zxlerp_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = abs(tmpvar_41);
  highp float tmpvar_65;
  tmpvar_65 = float((tmpvar_64.z >= tmpvar_64.x));
  zxlerp_63 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = float((max (tmpvar_64.x, tmpvar_64.z) >= tmpvar_64.y));
  nylerp_62 = tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_63);
  s_61 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = sign(mix (tmpvar_41.y, s_61, nylerp_62));
  s_61 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69.xz = vec2(1.0, -1.0);
  tmpvar_69.y = -(s_61);
  mediump vec3 tmpvar_70;
  tmpvar_70.xz = vec2(1.0, -1.0);
  tmpvar_70.y = s_61;
  highp vec3 tmpvar_71;
  tmpvar_71 = mix ((tmpvar_69 * tmpvar_41.xzy), (tmpvar_70 * tmpvar_41.zxy), vec3(zxlerp_63));
  detailCoords_60 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xy = vec2(1.0, 1.0);
  tmpvar_72.z = s_61;
  highp vec3 tmpvar_73;
  tmpvar_73 = mix ((tmpvar_72 * tmpvar_41.yxz), detailCoords_60, vec3(nylerp_62));
  detailCoords_60 = tmpvar_73;
  uv_59 = (((
    (0.5 * detailCoords_60.yz)
   / 
    abs(detailCoords_60.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_74;
  uv_74 = uv_59;
  highp vec2 uvCont_75;
  highp vec2 tmpvar_76;
  tmpvar_76 = abs((uv_74 - tmpvar_55));
  uvCont_75.x = max (tmpvar_76.x, tmpvar_76.y);
  uvCont_75.y = min (tmpvar_76.x, tmpvar_76.y);
  highp vec4 tmpvar_77;
  tmpvar_77.xy = dFdx(uvCont_75);
  tmpvar_77.zw = dFdy(uvCont_75);
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_59, tmpvar_77.xy, tmpvar_77.zw);
  mediump vec4 tmpvar_79;
  tmpvar_79 = tmpvar_78;
  citylightoverlaydetail_2.xyz = tmpvar_79.xyz;
  cityoverlay_4.w = (tmpvar_35.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_58.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_79.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_79.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float shadow_80;
  shadow_80 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_81;
  lightDir_81 = xlv_TEXCOORD5;
  mediump vec3 viewDir_82;
  viewDir_82 = xlv_TEXCOORD1;
  mediump float atten_83;
  atten_83 = shadow_80;
  mediump vec4 c_84;
  mediump vec3 tmpvar_85;
  tmpvar_85 = normalize(lightDir_81);
  lightDir_81 = tmpvar_85;
  mediump vec3 tmpvar_86;
  tmpvar_86 = normalize(viewDir_82);
  viewDir_82 = tmpvar_86;
  mediump vec3 tmpvar_87;
  tmpvar_87 = normalize(normT_5);
  mediump float tmpvar_88;
  tmpvar_88 = dot (tmpvar_87, tmpvar_85);
  highp float tmpvar_89;
  mediump float tmpvar_90;
  tmpvar_90 = clamp (dot (normalize(
    (tmpvar_85 + tmpvar_86)
  ), tmpvar_87), 0.0, 1.0);
  tmpvar_89 = tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = (pow (tmpvar_89, _SpecularPower) * _SpecularColor.w);
  c_84.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_88) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_91)) * (atten_83 * 2.0));
  c_84.w = (tmpvar_88 * (atten_83 * 2.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = normalize(_SunDir);
  mediump vec3 lightDir_93;
  lightDir_93 = tmpvar_92;
  mediump vec3 normal_94;
  normal_94 = xlv_TEXCOORD3;
  mediump float tmpvar_95;
  tmpvar_95 = dot (normal_94, lightDir_93);
  color_6 = (c_84 * mix (1.0, clamp (
    floor((1.01 + tmpvar_95))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_95))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_96;
  tmpvar_96 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_96;
  tmpvar_1 = tmpvar_96;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1 = t0.yyyy * unity_World2Shadow[0][1];
    t1 = unity_World2Shadow[0][0] * t0.xxxx + t1;
    t1 = unity_World2Shadow[0][2] * t0.zzzz + t1;
    t0 = unity_World2Shadow[0][3] * t0.wwww + t1;
    vs_TEXCOORD6 = t0;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
mediump float t16_4;
lowp vec3 t10_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_13;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
bool tb19;
highp float t20;
mediump float t16_22;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_31;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    tb19 = t10_19>=1.0;
    t16_4 = (tb19) ? 0.0 : 1.0;
    t10_19 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_5.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    t16_4 = t16_4 * t10_19;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_13.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t0.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t0.xy = t16_13.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_13.x = t16_4 * t10_3.w;
    t16_4 = t16_4 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_22 = dot(t10_5.xyz, t10_5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_7.xyz = vec3(t16_22) * t10_5.xyz;
    t16_22 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_8.xyz = vec3(t16_22) * vs_TEXCOORD5.xyz;
    t16_22 = dot(t16_7.xyz, t16_8.xyz);
    vec3 txVec11 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_31 = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec11, 0.0);
    t16_33 = (-_LightShadowData.x) + 1.0;
    t16_31 = t16_31 * t16_33 + _LightShadowData.x;
    t16_22 = dot(vec2(t16_31), vec2(t16_22));
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_31 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_31 + 1.00999999;
    t16_31 = t16_31 * -10.0;
    t16_31 = clamp(t16_31, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_31 = t16_31 * t16_33 + 1.0;
    t16_22 = t16_31 * t16_22;
    t16_22 = clamp(t16_22, 0.0, 1.0);
    t16_22 = (-t16_22) + 1.0;
    t16_31 = t16_13.x * t16_22 + (-t16_4);
    t16_13.x = t16_22 * t16_13.x;
    t16_1.w = t16_13.x * t16_31 + t16_4;
    t16_1.xyz = t16_13.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 28 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 240
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Matrix 160 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 224 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  half4 tmpvar_2;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = _mtl_u._SunDir;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_7;
  tmpvar_7 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_8;
  float3 tmpvar_9;
  tmpvar_8 = _mtl_i._glesTANGENT.xyz;
  tmpvar_9 = (((tmpvar_6.yzx * tmpvar_7.zxy) - (tmpvar_6.zxy * tmpvar_7.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_10;
  tmpvar_10[0].x = tmpvar_8.x;
  tmpvar_10[0].y = tmpvar_9.x;
  tmpvar_10[0].z = _mtl_i._glesNormal.x;
  tmpvar_10[1].x = tmpvar_8.y;
  tmpvar_10[1].y = tmpvar_9.y;
  tmpvar_10[1].z = _mtl_i._glesNormal.y;
  tmpvar_10[2].x = tmpvar_8.z;
  tmpvar_10[2].y = tmpvar_9.z;
  tmpvar_10[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _mtl_u._WorldSpaceCameraPos;
  float4 o_12;
  float4 tmpvar_13;
  tmpvar_13 = (tmpvar_1 * 0.5);
  float2 tmpvar_14;
  tmpvar_14.x = tmpvar_13.x;
  tmpvar_14.y = (tmpvar_13.y * _mtl_u._ProjectionParams.x);
  o_12.xy = (tmpvar_14 + tmpvar_13.w);
  o_12.zw = tmpvar_1.zw;
  tmpvar_2 = half4(o_12);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_10 * (
    (_mtl_u._World2Object * tmpvar_11)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_4).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_10 * (_mtl_u._World2Object * tmpvar_5).xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_2;
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 301 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  cityoverlay_4.xyz = tmpvar_35.xyz;
  mediump vec2 uv_36;
  mediump vec3 detailCoords_37;
  mediump float s_38;
  mediump float nylerp_39;
  mediump float zxlerp_40;
  highp vec3 tmpvar_41;
  tmpvar_41 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_42;
  tmpvar_42 = abs(tmpvar_41);
  highp float tmpvar_43;
  tmpvar_43 = float((tmpvar_42.z >= tmpvar_42.x));
  zxlerp_40 = tmpvar_43;
  highp float tmpvar_44;
  tmpvar_44 = float((max (tmpvar_42.x, tmpvar_42.z) >= tmpvar_42.y));
  nylerp_39 = tmpvar_44;
  highp float tmpvar_45;
  tmpvar_45 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_40);
  s_38 = tmpvar_45;
  highp float tmpvar_46;
  tmpvar_46 = sign(mix (tmpvar_41.y, s_38, nylerp_39));
  s_38 = tmpvar_46;
  mediump vec3 tmpvar_47;
  tmpvar_47.xz = vec2(1.0, -1.0);
  tmpvar_47.y = -(s_38);
  mediump vec3 tmpvar_48;
  tmpvar_48.xz = vec2(1.0, -1.0);
  tmpvar_48.y = s_38;
  highp vec3 tmpvar_49;
  tmpvar_49 = mix ((tmpvar_47 * tmpvar_41.xzy), (tmpvar_48 * tmpvar_41.zxy), vec3(zxlerp_40));
  detailCoords_37 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xy = vec2(1.0, 1.0);
  tmpvar_50.z = s_38;
  highp vec3 tmpvar_51;
  tmpvar_51 = mix ((tmpvar_50 * tmpvar_41.yxz), detailCoords_37, vec3(nylerp_39));
  detailCoords_37 = tmpvar_51;
  uv_36 = (((
    (0.5 * detailCoords_37.yz)
   / 
    abs(detailCoords_37.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_52;
  uv_52 = uv_36;
  highp vec2 uvCont_53;
  highp vec2 tmpvar_54;
  highp float tmpvar_55;
  tmpvar_55 = (0.5 * _CityOverlayDetailScale);
  tmpvar_54 = abs((uv_52 - tmpvar_55));
  uvCont_53.x = max (tmpvar_54.x, tmpvar_54.y);
  uvCont_53.y = min (tmpvar_54.x, tmpvar_54.y);
  highp vec4 tmpvar_56;
  tmpvar_56.xy = dFdx(uvCont_53);
  tmpvar_56.zw = dFdy(uvCont_53);
  lowp vec4 tmpvar_57;
  tmpvar_57 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_36, tmpvar_56.xy, tmpvar_56.zw);
  mediump vec4 tmpvar_58;
  tmpvar_58 = tmpvar_57;
  citydarkoverlaydetail_3.xyz = tmpvar_58.xyz;
  mediump vec2 uv_59;
  mediump vec3 detailCoords_60;
  mediump float s_61;
  mediump float nylerp_62;
  mediump float zxlerp_63;
  highp vec3 tmpvar_64;
  tmpvar_64 = abs(tmpvar_41);
  highp float tmpvar_65;
  tmpvar_65 = float((tmpvar_64.z >= tmpvar_64.x));
  zxlerp_63 = tmpvar_65;
  highp float tmpvar_66;
  tmpvar_66 = float((max (tmpvar_64.x, tmpvar_64.z) >= tmpvar_64.y));
  nylerp_62 = tmpvar_66;
  highp float tmpvar_67;
  tmpvar_67 = mix (tmpvar_41.x, tmpvar_41.z, zxlerp_63);
  s_61 = tmpvar_67;
  highp float tmpvar_68;
  tmpvar_68 = sign(mix (tmpvar_41.y, s_61, nylerp_62));
  s_61 = tmpvar_68;
  mediump vec3 tmpvar_69;
  tmpvar_69.xz = vec2(1.0, -1.0);
  tmpvar_69.y = -(s_61);
  mediump vec3 tmpvar_70;
  tmpvar_70.xz = vec2(1.0, -1.0);
  tmpvar_70.y = s_61;
  highp vec3 tmpvar_71;
  tmpvar_71 = mix ((tmpvar_69 * tmpvar_41.xzy), (tmpvar_70 * tmpvar_41.zxy), vec3(zxlerp_63));
  detailCoords_60 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xy = vec2(1.0, 1.0);
  tmpvar_72.z = s_61;
  highp vec3 tmpvar_73;
  tmpvar_73 = mix ((tmpvar_72 * tmpvar_41.yxz), detailCoords_60, vec3(nylerp_62));
  detailCoords_60 = tmpvar_73;
  uv_59 = (((
    (0.5 * detailCoords_60.yz)
   / 
    abs(detailCoords_60.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_74;
  uv_74 = uv_59;
  highp vec2 uvCont_75;
  highp vec2 tmpvar_76;
  tmpvar_76 = abs((uv_74 - tmpvar_55));
  uvCont_75.x = max (tmpvar_76.x, tmpvar_76.y);
  uvCont_75.y = min (tmpvar_76.x, tmpvar_76.y);
  highp vec4 tmpvar_77;
  tmpvar_77.xy = dFdx(uvCont_75);
  tmpvar_77.zw = dFdy(uvCont_75);
  lowp vec4 tmpvar_78;
  tmpvar_78 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_59, tmpvar_77.xy, tmpvar_77.zw);
  mediump vec4 tmpvar_79;
  tmpvar_79 = tmpvar_78;
  citylightoverlaydetail_2.xyz = tmpvar_79.xyz;
  cityoverlay_4.w = (tmpvar_35.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_58.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_79.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_79.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float shadow_80;
  shadow_80 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_81;
  lightDir_81 = xlv_TEXCOORD5;
  mediump vec3 viewDir_82;
  viewDir_82 = xlv_TEXCOORD1;
  mediump float atten_83;
  atten_83 = shadow_80;
  mediump vec4 c_84;
  mediump vec3 tmpvar_85;
  tmpvar_85 = normalize(lightDir_81);
  lightDir_81 = tmpvar_85;
  mediump vec3 tmpvar_86;
  tmpvar_86 = normalize(viewDir_82);
  viewDir_82 = tmpvar_86;
  mediump vec3 tmpvar_87;
  tmpvar_87 = normalize(normT_5);
  mediump float tmpvar_88;
  tmpvar_88 = dot (tmpvar_87, tmpvar_85);
  highp float tmpvar_89;
  mediump float tmpvar_90;
  tmpvar_90 = clamp (dot (normalize(
    (tmpvar_85 + tmpvar_86)
  ), tmpvar_87), 0.0, 1.0);
  tmpvar_89 = tmpvar_90;
  highp float tmpvar_91;
  tmpvar_91 = (pow (tmpvar_89, _SpecularPower) * _SpecularColor.w);
  c_84.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_88) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_91)) * (atten_83 * 2.0));
  c_84.w = (tmpvar_88 * (atten_83 * 2.0));
  highp vec3 tmpvar_92;
  tmpvar_92 = normalize(_SunDir);
  mediump vec3 lightDir_93;
  lightDir_93 = tmpvar_92;
  mediump vec3 normal_94;
  normal_94 = xlv_TEXCOORD3;
  mediump float tmpvar_95;
  tmpvar_95 = dot (normal_94, lightDir_93);
  color_6 = (c_84 * mix (1.0, clamp (
    floor((1.01 + tmpvar_95))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_95))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_96;
  tmpvar_96 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_96;
  tmpvar_1 = tmpvar_96;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1 = t0.yyyy * unity_World2Shadow[0][1];
    t1 = unity_World2Shadow[0][0] * t0.xxxx + t1;
    t1 = unity_World2Shadow[0][2] * t0.zzzz + t1;
    t0 = unity_World2Shadow[0][3] * t0.wwww + t1;
    vs_TEXCOORD6 = t0;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
mediump float t16_4;
lowp vec3 t10_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_13;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
bool tb19;
highp float t20;
mediump float t16_22;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_31;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    tb19 = t10_19>=1.0;
    t16_4 = (tb19) ? 0.0 : 1.0;
    t10_19 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_5.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    t16_4 = t16_4 * t10_19;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_13.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_13.xy = t16_13.xy / abs(t0.xx);
    t16_13.xy = t16_13.xy + vec2(0.5, 0.5);
    t0.xy = t16_13.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_13.x = t16_4 * t10_3.w;
    t16_4 = t16_4 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_22 = dot(t10_5.xyz, t10_5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_7.xyz = vec3(t16_22) * t10_5.xyz;
    t16_22 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_22 = inversesqrt(t16_22);
    t16_8.xyz = vec3(t16_22) * vs_TEXCOORD5.xyz;
    t16_22 = dot(t16_7.xyz, t16_8.xyz);
    vec3 txVec21 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_31 = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec21, 0.0);
    t16_33 = (-_LightShadowData.x) + 1.0;
    t16_31 = t16_31 * t16_33 + _LightShadowData.x;
    t16_22 = dot(vec2(t16_31), vec2(t16_22));
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_31 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_31 + 1.00999999;
    t16_31 = t16_31 * -10.0;
    t16_31 = clamp(t16_31, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_31 = t16_31 * t16_33 + 1.0;
    t16_22 = t16_31 * t16_22;
    t16_22 = clamp(t16_22, 0.0, 1.0);
    t16_22 = (-t16_22) + 1.0;
    t16_31 = t16_13.x * t16_22 + (-t16_4);
    t16_13.x = t16_22 * t16_13.x;
    t16_1.w = t16_13.x * t16_31 + t16_4;
    t16_1.xyz = t16_13.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 28 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_N_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 240
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Matrix 160 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 224 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  half4 tmpvar_2;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = _mtl_u._SunDir;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_7;
  tmpvar_7 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_8;
  float3 tmpvar_9;
  tmpvar_8 = _mtl_i._glesTANGENT.xyz;
  tmpvar_9 = (((tmpvar_6.yzx * tmpvar_7.zxy) - (tmpvar_6.zxy * tmpvar_7.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_10;
  tmpvar_10[0].x = tmpvar_8.x;
  tmpvar_10[0].y = tmpvar_9.x;
  tmpvar_10[0].z = _mtl_i._glesNormal.x;
  tmpvar_10[1].x = tmpvar_8.y;
  tmpvar_10[1].y = tmpvar_9.y;
  tmpvar_10[1].z = _mtl_i._glesNormal.y;
  tmpvar_10[2].x = tmpvar_8.z;
  tmpvar_10[2].y = tmpvar_9.z;
  tmpvar_10[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _mtl_u._WorldSpaceCameraPos;
  float4 o_12;
  float4 tmpvar_13;
  tmpvar_13 = (tmpvar_1 * 0.5);
  float2 tmpvar_14;
  tmpvar_14.x = tmpvar_13.x;
  tmpvar_14.y = (tmpvar_13.y * _mtl_u._ProjectionParams.x);
  o_12.xy = (tmpvar_14 + tmpvar_13.w);
  o_12.zw = tmpvar_1.zw;
  tmpvar_2 = half4(o_12);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_10 * (
    (_mtl_u._World2Object * tmpvar_11)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_4).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_10 * (_mtl_u._World2Object * tmpvar_5).xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_2;
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 305 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  float tmpvar_28;
  vec4 v_29;
  v_29 = (texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw) * alphaMask1);
  tmpvar_28 = ((v_29.x + v_29.y) + (v_29.z + v_29.w));
  vec4 tmpvar_30;
  tmpvar_30.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_30.w = tmpvar_28;
  cityoverlay_3.xyz = tmpvar_30.xyz;
  vec2 uv_31;
  vec3 tmpvar_32;
  tmpvar_32 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_33;
  tmpvar_33 = abs(tmpvar_32);
  float tmpvar_34;
  tmpvar_34 = float((tmpvar_33.z >= tmpvar_33.x));
  float tmpvar_35;
  tmpvar_35 = float((max (tmpvar_33.x, tmpvar_33.z) >= tmpvar_33.y));
  float tmpvar_36;
  tmpvar_36 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_34), tmpvar_35));
  vec3 tmpvar_37;
  tmpvar_37.xz = vec2(1.0, -1.0);
  tmpvar_37.y = -(tmpvar_36);
  vec3 tmpvar_38;
  tmpvar_38.xz = vec2(1.0, -1.0);
  tmpvar_38.y = tmpvar_36;
  vec3 tmpvar_39;
  tmpvar_39.xy = vec2(1.0, 1.0);
  tmpvar_39.z = tmpvar_36;
  vec3 tmpvar_40;
  tmpvar_40 = mix ((tmpvar_39 * tmpvar_32.yxz), mix ((tmpvar_37 * tmpvar_32.xzy), (tmpvar_38 * tmpvar_32.zxy), vec3(tmpvar_34)), vec3(tmpvar_35));
  uv_31 = (((
    (0.5 * tmpvar_40.yz)
   / 
    abs(tmpvar_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_41;
  vec2 tmpvar_42;
  float tmpvar_43;
  tmpvar_43 = (0.5 * _CityOverlayDetailScale);
  tmpvar_42 = abs((uv_31 - tmpvar_43));
  uvCont_41.x = max (tmpvar_42.x, tmpvar_42.y);
  uvCont_41.y = min (tmpvar_42.x, tmpvar_42.y);
  vec4 tmpvar_44;
  tmpvar_44.xy = dFdx(uvCont_41);
  tmpvar_44.zw = dFdy(uvCont_41);
  vec4 tmpvar_45;
  tmpvar_45 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_31, tmpvar_44.xy, tmpvar_44.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_45.xyz;
  vec2 uv_46;
  vec3 tmpvar_47;
  tmpvar_47 = abs(tmpvar_32);
  float tmpvar_48;
  tmpvar_48 = float((tmpvar_47.z >= tmpvar_47.x));
  float tmpvar_49;
  tmpvar_49 = float((max (tmpvar_47.x, tmpvar_47.z) >= tmpvar_47.y));
  float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_48), tmpvar_49));
  vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(tmpvar_50);
  vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = tmpvar_50;
  vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = tmpvar_50;
  vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_32.yxz), mix ((tmpvar_51 * tmpvar_32.xzy), (tmpvar_52 * tmpvar_32.zxy), vec3(tmpvar_48)), vec3(tmpvar_49));
  uv_46 = (((
    (0.5 * tmpvar_54.yz)
   / 
    abs(tmpvar_54.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_55;
  vec2 tmpvar_56;
  tmpvar_56 = abs((uv_46 - tmpvar_43));
  uvCont_55.x = max (tmpvar_56.x, tmpvar_56.y);
  uvCont_55.y = min (tmpvar_56.x, tmpvar_56.y);
  vec4 tmpvar_57;
  tmpvar_57.xy = dFdx(uvCont_55);
  tmpvar_57.zw = dFdy(uvCont_55);
  vec4 tmpvar_58;
  tmpvar_58 = texture2DGradARB (_CityLightOverlayDetailTex, uv_46, tmpvar_57.xy, tmpvar_57.zw);
  citylightoverlaydetail_1.xyz = tmpvar_58.xyz;
  cityoverlay_3.w = (tmpvar_28 * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_45.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_58.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_58.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_59;
  vec3 tmpvar_60;
  tmpvar_60 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_61;
  tmpvar_61 = normalize(normal_20);
  float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, tmpvar_60);
  c_59.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_62) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_60 + normalize(xlv_TEXCOORD1)))
    , tmpvar_61), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_59.w = (tmpvar_62 * 2.0);
  float tmpvar_63;
  tmpvar_63 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_59 * mix (1.0, clamp (
    floor((1.01 + tmpvar_63))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_63))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_64;
  tmpvar_64 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_64;
  gl_FragData[0] = tmpvar_64;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 301 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  mediump float tmpvar_36;
  mediump vec4 v_37;
  v_37 = (tmpvar_35 * alphaMask1);
  tmpvar_36 = ((v_37.x + v_37.y) + (v_37.z + v_37.w));
  mediump vec4 tmpvar_38;
  tmpvar_38.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_38.w = tmpvar_36;
  cityoverlay_4.xyz = tmpvar_38.xyz;
  mediump vec2 uv_39;
  mediump vec3 detailCoords_40;
  mediump float s_41;
  mediump float nylerp_42;
  mediump float zxlerp_43;
  highp vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  highp float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_43);
  s_41 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, s_41, nylerp_42));
  s_41 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = -(s_41);
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = s_41;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_50 * tmpvar_44.xzy), (tmpvar_51 * tmpvar_44.zxy), vec3(zxlerp_43));
  detailCoords_40 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = s_41;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_44.yxz), detailCoords_40, vec3(nylerp_42));
  detailCoords_40 = tmpvar_54;
  uv_39 = (((
    (0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_55;
  uv_55 = uv_39;
  highp vec2 uvCont_56;
  highp vec2 tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = (0.5 * _CityOverlayDetailScale);
  tmpvar_57 = abs((uv_55 - tmpvar_58));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_56);
  tmpvar_59.zw = dFdy(uvCont_56);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_39, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citydarkoverlaydetail_3.xyz = tmpvar_61.xyz;
  mediump vec2 uv_62;
  mediump vec3 detailCoords_63;
  mediump float s_64;
  mediump float nylerp_65;
  mediump float zxlerp_66;
  highp vec3 tmpvar_67;
  tmpvar_67 = abs(tmpvar_44);
  highp float tmpvar_68;
  tmpvar_68 = float((tmpvar_67.z >= tmpvar_67.x));
  zxlerp_66 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = float((max (tmpvar_67.x, tmpvar_67.z) >= tmpvar_67.y));
  nylerp_65 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_66);
  s_64 = tmpvar_70;
  highp float tmpvar_71;
  tmpvar_71 = sign(mix (tmpvar_44.y, s_64, nylerp_65));
  s_64 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xz = vec2(1.0, -1.0);
  tmpvar_72.y = -(s_64);
  mediump vec3 tmpvar_73;
  tmpvar_73.xz = vec2(1.0, -1.0);
  tmpvar_73.y = s_64;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix ((tmpvar_72 * tmpvar_44.xzy), (tmpvar_73 * tmpvar_44.zxy), vec3(zxlerp_66));
  detailCoords_63 = tmpvar_74;
  mediump vec3 tmpvar_75;
  tmpvar_75.xy = vec2(1.0, 1.0);
  tmpvar_75.z = s_64;
  highp vec3 tmpvar_76;
  tmpvar_76 = mix ((tmpvar_75 * tmpvar_44.yxz), detailCoords_63, vec3(nylerp_65));
  detailCoords_63 = tmpvar_76;
  uv_62 = (((
    (0.5 * detailCoords_63.yz)
   / 
    abs(detailCoords_63.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_77;
  uv_77 = uv_62;
  highp vec2 uvCont_78;
  highp vec2 tmpvar_79;
  tmpvar_79 = abs((uv_77 - tmpvar_58));
  uvCont_78.x = max (tmpvar_79.x, tmpvar_79.y);
  uvCont_78.y = min (tmpvar_79.x, tmpvar_79.y);
  highp vec4 tmpvar_80;
  tmpvar_80.xy = dFdx(uvCont_78);
  tmpvar_80.zw = dFdy(uvCont_78);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_62, tmpvar_80.xy, tmpvar_80.zw);
  mediump vec4 tmpvar_82;
  tmpvar_82 = tmpvar_81;
  citylightoverlaydetail_2.xyz = tmpvar_82.xyz;
  cityoverlay_4.w = (tmpvar_36 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_61.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_82.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_82.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_83;
  lightDir_83 = xlv_TEXCOORD5;
  mediump vec3 viewDir_84;
  viewDir_84 = xlv_TEXCOORD1;
  mediump vec4 c_85;
  mediump vec3 tmpvar_86;
  tmpvar_86 = normalize(lightDir_83);
  lightDir_83 = tmpvar_86;
  mediump vec3 tmpvar_87;
  tmpvar_87 = normalize(viewDir_84);
  viewDir_84 = tmpvar_87;
  mediump vec3 tmpvar_88;
  tmpvar_88 = normalize(normT_5);
  mediump float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, tmpvar_86);
  highp float tmpvar_90;
  mediump float tmpvar_91;
  tmpvar_91 = clamp (dot (normalize(
    (tmpvar_86 + tmpvar_87)
  ), tmpvar_88), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = (pow (tmpvar_90, _SpecularPower) * _SpecularColor.w);
  c_85.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_89) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_92)) * 2.0);
  c_85.w = (tmpvar_89 * 2.0);
  highp vec3 tmpvar_93;
  tmpvar_93 = normalize(_SunDir);
  mediump vec3 lightDir_94;
  lightDir_94 = tmpvar_93;
  mediump vec3 normal_95;
  normal_95 = xlv_TEXCOORD3;
  mediump float tmpvar_96;
  tmpvar_96 = dot (normal_95, lightDir_94);
  color_6 = (c_85 * mix (1.0, clamp (
    floor((1.01 + tmpvar_96))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_96))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_97;
  tmpvar_97 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_97;
  tmpvar_1 = tmpvar_97;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec4 t10_4;
mediump vec2 t16_5;
lowp vec3 t10_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
highp vec3 t11;
highp int ti11;
bvec2 tb11;
mediump vec2 t16_15;
highp vec2 t20;
highp float t21;
lowp float t10_21;
highp int ti21;
highp float t22;
mediump float t16_25;
highp float t30;
highp float t31;
bool tb31;
highp float t32;
mediump float t16_35;
mediump float t16_37;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t10.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t10.z), abs(t10.y));
    t1.x = float(1.0) / t1.x;
    t11.x = min(abs(t10.z), abs(t10.y));
    t1.x = t1.x * t11.x;
    t11.x = t1.x * t1.x;
    t21 = t11.x * 0.0208350997 + -0.0851330012;
    t21 = t11.x * t21 + 0.180141002;
    t21 = t11.x * t21 + -0.330299497;
    t11.x = t11.x * t21 + 0.999866009;
    t21 = t11.x * t1.x;
    t21 = t21 * -2.0 + 1.57079637;
    tb31 = abs(t10.z)<abs(t10.y);
    t21 = tb31 ? t21 : float(0.0);
    t1.x = t1.x * t11.x + t21;
    tb11.xy = lessThan(t10.zxzz, (-t10.zxzz)).xy;
    t11.x = tb11.x ? -3.14159274 : float(0.0);
    t1.x = t11.x + t1.x;
    t11.x = min(t10.z, t10.y);
    tb11.x = t11.x<(-t11.x);
    t31 = max(t10.z, t10.y);
    tb31 = t31>=(-t31);
    ti11 = int(uint(tb31) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t1.x = (ti11 != 0) ? (-t1.x) : t1.x;
    t11.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t11.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t31 = abs(t10.x) * -0.0187292993 + 0.0742610022;
    t31 = t31 * abs(t10.x) + -0.212114394;
    t31 = t31 * abs(t10.x) + 1.57072878;
    t22 = -abs(t10.x) + 1.0;
    t22 = sqrt(t22);
    t32 = t31 * t22;
    t32 = t32 * -2.0 + 3.14159274;
    t21 = tb11.y ? t32 : float(0.0);
    t21 = t31 * t22 + t21;
    t2.y = t21 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t16_5.xy = t10_4.xy * alphaMask1.xy;
    t16_5.x = t16_5.y + t16_5.x;
    t16_5.x = t10_4.z * alphaMask1.z + t16_5.x;
    t16_5.x = t10_4.w * alphaMask1.w + t16_5.x;
    t10_21 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_6.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_21>=1.0;
    t16_15.x = (tb1) ? 0.0 : 1.0;
    t16_5.x = t16_15.x * t16_5.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t10.y);
    tb11.x = abs(t10.z)>=abs(t10.y);
    t11.x = tb11.x ? 1.0 : float(0.0);
    t1.x = t11.x * t1.x + t10.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t10.z), abs(t10.y));
    tb1 = t1.x>=abs(t10.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t10.x;
    ti21 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti21) + ti0;
    t16_7.y = float(ti0);
    t16_8.y = (-t16_7.y);
    t16_8.xz = vec2(1.0, -1.0);
    t2.xyz = t10.yzx * t16_8.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t3.xyz = t16_7.xyz * t10.zyx + (-t2.xyz);
    t11.xyz = t11.xxx * t3.xyz + t2.xyz;
    t11.xyz = (-t16_7.xxy) * t10.xyz + t11.xyz;
    t0.xyz = t10.xyz * t16_7.xxy;
    t0.xyz = t1.xxx * t11.xyz + t0.xyz;
    t16_15.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_15.xy = t16_15.xy / abs(t0.xx);
    t16_15.xy = t16_15.xy + vec2(0.5, 0.5);
    t0.xy = t16_15.xy * vec2(_CityOverlayDetailScale);
    t20.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t20.y), abs(t20.x));
    t20.x = min(abs(t20.y), abs(t20.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t20.x);
    t1.y = dFdy(t20.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_15.x = t16_5.x * t10_3.w;
    t16_5.x = t16_5.x * t10_0.w;
    t16_7.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_25 = dot(t10_6.xyz, t10_6.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_8.xyz = vec3(t16_25) * t10_6.xyz;
    t16_25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_9.xyz = vec3(t16_25) * vs_TEXCOORD5.xyz;
    t16_25 = dot(t16_8.xyz, t16_9.xyz);
    t16_25 = t16_25 + t16_25;
    t30 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t30 = inversesqrt(t30);
    t1.xyz = vec3(float(t30) * _SunDir.xxyz.y, float(t30) * _SunDir.xxyz.z, float(t30) * float(_SunDir.z));
    t16_35 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_37 = t16_35 + 1.00999999;
    t16_35 = t16_35 * -10.0;
    t16_35 = clamp(t16_35, 0.0, 1.0);
    t16_37 = floor(t16_37);
    t16_37 = clamp(t16_37, 0.0, 1.0);
    t16_37 = t16_37 + -1.0;
    t16_35 = t16_35 * t16_37 + 1.0;
    t16_25 = t16_35 * t16_25;
    t16_25 = clamp(t16_25, 0.0, 1.0);
    t16_25 = (-t16_25) + 1.0;
    t16_35 = t16_15.x * t16_25 + (-t16_5.x);
    t16_15.x = t16_25 * t16_15.x;
    t16_1.w = t16_15.x * t16_35 + t16_5.x;
    t16_1.xyz = t16_15.xxx * t16_7.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
bool tb1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
vec2 t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13.x = t7 * 0.0208350997 + -0.0851330012;
    t13.x = t7 * t13.x + 0.180141002;
    t13.x = t7 * t13.x + -0.330299497;
    t7 = t7 * t13.x + 0.999866009;
    t13.x = t7 * t1.x;
    t13.x = t13.x * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13.x = tb19 ? t13.x : float(0.0);
    t1.x = t1.x * t7 + t13.x;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13.x = tb7.y ? t20 : float(0.0);
    t13.x = t19 * t14 + t13.x;
    t2.y = t13.x * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t13.xy = t10_4.xy * alphaMask1.xy;
    t13.x = t13.y + t13.x;
    t13.x = t10_4.z * alphaMask1.z + t13.x;
    t13.x = t10_4.w * alphaMask1.w + t13.x;
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb1 = t10_4.w>=1.0;
    t1.x = (tb1) ? 0.0 : 1.0;
    t1.x = t1.x * t13.x;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13.x = tb13 ? 1.0 : float(0.0);
    t7 = t13.x * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = t13.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t1.x = t1.x + t1.x;
    t13.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13.x = inversesqrt(t13.x);
    t2.xyz = t13.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13.x = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13.x + 1.00999999;
    t13.x = t13.x * -10.0;
    t13.x = clamp(t13.x, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13.x = t13.x * t19 + 1.0;
    t1.x = t13.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 307 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 tmpvar_1;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = gl_Normal;
  vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(gl_Normal);
  vec3 tmpvar_6;
  tmpvar_6 = normalize(TANGENT.xyz);
  vec3 tmpvar_7;
  vec3 tmpvar_8;
  tmpvar_7 = TANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * TANGENT.w);
  mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = gl_Normal.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = gl_Normal.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = gl_Normal.z;
  vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  vec4 o_11;
  vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_1 * 0.5);
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_12.x;
  tmpvar_13.y = (tmpvar_12.y * _ProjectionParams.x);
  o_11.xy = (tmpvar_13 + tmpvar_12.w);
  o_11.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
  xlv_TEXCOORD6 = o_11;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  float tmpvar_28;
  vec4 v_29;
  v_29 = (texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw) * alphaMask1);
  tmpvar_28 = ((v_29.x + v_29.y) + (v_29.z + v_29.w));
  vec4 tmpvar_30;
  tmpvar_30.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_30.w = tmpvar_28;
  cityoverlay_3.xyz = tmpvar_30.xyz;
  vec2 uv_31;
  vec3 tmpvar_32;
  tmpvar_32 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_33;
  tmpvar_33 = abs(tmpvar_32);
  float tmpvar_34;
  tmpvar_34 = float((tmpvar_33.z >= tmpvar_33.x));
  float tmpvar_35;
  tmpvar_35 = float((max (tmpvar_33.x, tmpvar_33.z) >= tmpvar_33.y));
  float tmpvar_36;
  tmpvar_36 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_34), tmpvar_35));
  vec3 tmpvar_37;
  tmpvar_37.xz = vec2(1.0, -1.0);
  tmpvar_37.y = -(tmpvar_36);
  vec3 tmpvar_38;
  tmpvar_38.xz = vec2(1.0, -1.0);
  tmpvar_38.y = tmpvar_36;
  vec3 tmpvar_39;
  tmpvar_39.xy = vec2(1.0, 1.0);
  tmpvar_39.z = tmpvar_36;
  vec3 tmpvar_40;
  tmpvar_40 = mix ((tmpvar_39 * tmpvar_32.yxz), mix ((tmpvar_37 * tmpvar_32.xzy), (tmpvar_38 * tmpvar_32.zxy), vec3(tmpvar_34)), vec3(tmpvar_35));
  uv_31 = (((
    (0.5 * tmpvar_40.yz)
   / 
    abs(tmpvar_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_41;
  vec2 tmpvar_42;
  float tmpvar_43;
  tmpvar_43 = (0.5 * _CityOverlayDetailScale);
  tmpvar_42 = abs((uv_31 - tmpvar_43));
  uvCont_41.x = max (tmpvar_42.x, tmpvar_42.y);
  uvCont_41.y = min (tmpvar_42.x, tmpvar_42.y);
  vec4 tmpvar_44;
  tmpvar_44.xy = dFdx(uvCont_41);
  tmpvar_44.zw = dFdy(uvCont_41);
  vec4 tmpvar_45;
  tmpvar_45 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_31, tmpvar_44.xy, tmpvar_44.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_45.xyz;
  vec2 uv_46;
  vec3 tmpvar_47;
  tmpvar_47 = abs(tmpvar_32);
  float tmpvar_48;
  tmpvar_48 = float((tmpvar_47.z >= tmpvar_47.x));
  float tmpvar_49;
  tmpvar_49 = float((max (tmpvar_47.x, tmpvar_47.z) >= tmpvar_47.y));
  float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_48), tmpvar_49));
  vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(tmpvar_50);
  vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = tmpvar_50;
  vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = tmpvar_50;
  vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_32.yxz), mix ((tmpvar_51 * tmpvar_32.xzy), (tmpvar_52 * tmpvar_32.zxy), vec3(tmpvar_48)), vec3(tmpvar_49));
  uv_46 = (((
    (0.5 * tmpvar_54.yz)
   / 
    abs(tmpvar_54.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_55;
  vec2 tmpvar_56;
  tmpvar_56 = abs((uv_46 - tmpvar_43));
  uvCont_55.x = max (tmpvar_56.x, tmpvar_56.y);
  uvCont_55.y = min (tmpvar_56.x, tmpvar_56.y);
  vec4 tmpvar_57;
  tmpvar_57.xy = dFdx(uvCont_55);
  tmpvar_57.zw = dFdy(uvCont_55);
  vec4 tmpvar_58;
  tmpvar_58 = texture2DGradARB (_CityLightOverlayDetailTex, uv_46, tmpvar_57.xy, tmpvar_57.zw);
  citylightoverlaydetail_1.xyz = tmpvar_58.xyz;
  cityoverlay_3.w = (tmpvar_28 * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_45.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_58.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_58.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_59;
  tmpvar_59 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_60;
  vec3 tmpvar_61;
  tmpvar_61 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_62;
  tmpvar_62 = normalize(normal_20);
  float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, tmpvar_61);
  c_60.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_63) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_61 + normalize(xlv_TEXCOORD1)))
    , tmpvar_62), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_59.x * 2.0));
  c_60.w = (tmpvar_63 * (tmpvar_59.x * 2.0));
  float tmpvar_64;
  tmpvar_64 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_60 * mix (1.0, clamp (
    floor((1.01 + tmpvar_64))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_64))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_65;
  tmpvar_65 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_65;
  gl_FragData[0] = tmpvar_65;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 58 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_ProjectionParams]
Vector 12 [_ScreenParams]
Vector 13 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c14, 1, 0, 0.5, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c13
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c14
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r1.x, r0.y, c11.x
mul r1.w, r1.x, c14.z
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c14.z
mad o6.xy, r1.z, c12.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o6.zw, r0

"
}
SubProgram "d3d11 " {
// Stats: 53 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 307 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  mediump float tmpvar_36;
  mediump vec4 v_37;
  v_37 = (tmpvar_35 * alphaMask1);
  tmpvar_36 = ((v_37.x + v_37.y) + (v_37.z + v_37.w));
  mediump vec4 tmpvar_38;
  tmpvar_38.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_38.w = tmpvar_36;
  cityoverlay_4.xyz = tmpvar_38.xyz;
  mediump vec2 uv_39;
  mediump vec3 detailCoords_40;
  mediump float s_41;
  mediump float nylerp_42;
  mediump float zxlerp_43;
  highp vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  highp float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_43);
  s_41 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, s_41, nylerp_42));
  s_41 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = -(s_41);
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = s_41;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_50 * tmpvar_44.xzy), (tmpvar_51 * tmpvar_44.zxy), vec3(zxlerp_43));
  detailCoords_40 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = s_41;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_44.yxz), detailCoords_40, vec3(nylerp_42));
  detailCoords_40 = tmpvar_54;
  uv_39 = (((
    (0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_55;
  uv_55 = uv_39;
  highp vec2 uvCont_56;
  highp vec2 tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = (0.5 * _CityOverlayDetailScale);
  tmpvar_57 = abs((uv_55 - tmpvar_58));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_56);
  tmpvar_59.zw = dFdy(uvCont_56);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_39, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citydarkoverlaydetail_3.xyz = tmpvar_61.xyz;
  mediump vec2 uv_62;
  mediump vec3 detailCoords_63;
  mediump float s_64;
  mediump float nylerp_65;
  mediump float zxlerp_66;
  highp vec3 tmpvar_67;
  tmpvar_67 = abs(tmpvar_44);
  highp float tmpvar_68;
  tmpvar_68 = float((tmpvar_67.z >= tmpvar_67.x));
  zxlerp_66 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = float((max (tmpvar_67.x, tmpvar_67.z) >= tmpvar_67.y));
  nylerp_65 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_66);
  s_64 = tmpvar_70;
  highp float tmpvar_71;
  tmpvar_71 = sign(mix (tmpvar_44.y, s_64, nylerp_65));
  s_64 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xz = vec2(1.0, -1.0);
  tmpvar_72.y = -(s_64);
  mediump vec3 tmpvar_73;
  tmpvar_73.xz = vec2(1.0, -1.0);
  tmpvar_73.y = s_64;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix ((tmpvar_72 * tmpvar_44.xzy), (tmpvar_73 * tmpvar_44.zxy), vec3(zxlerp_66));
  detailCoords_63 = tmpvar_74;
  mediump vec3 tmpvar_75;
  tmpvar_75.xy = vec2(1.0, 1.0);
  tmpvar_75.z = s_64;
  highp vec3 tmpvar_76;
  tmpvar_76 = mix ((tmpvar_75 * tmpvar_44.yxz), detailCoords_63, vec3(nylerp_65));
  detailCoords_63 = tmpvar_76;
  uv_62 = (((
    (0.5 * detailCoords_63.yz)
   / 
    abs(detailCoords_63.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_77;
  uv_77 = uv_62;
  highp vec2 uvCont_78;
  highp vec2 tmpvar_79;
  tmpvar_79 = abs((uv_77 - tmpvar_58));
  uvCont_78.x = max (tmpvar_79.x, tmpvar_79.y);
  uvCont_78.y = min (tmpvar_79.x, tmpvar_79.y);
  highp vec4 tmpvar_80;
  tmpvar_80.xy = dFdx(uvCont_78);
  tmpvar_80.zw = dFdy(uvCont_78);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_62, tmpvar_80.xy, tmpvar_80.zw);
  mediump vec4 tmpvar_82;
  tmpvar_82 = tmpvar_81;
  citylightoverlaydetail_2.xyz = tmpvar_82.xyz;
  cityoverlay_4.w = (tmpvar_36 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_61.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_82.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_82.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_83 = tmpvar_84;
  mediump vec3 lightDir_85;
  lightDir_85 = xlv_TEXCOORD5;
  mediump vec3 viewDir_86;
  viewDir_86 = xlv_TEXCOORD1;
  mediump float atten_87;
  atten_87 = tmpvar_83;
  mediump vec4 c_88;
  mediump vec3 tmpvar_89;
  tmpvar_89 = normalize(lightDir_85);
  lightDir_85 = tmpvar_89;
  mediump vec3 tmpvar_90;
  tmpvar_90 = normalize(viewDir_86);
  viewDir_86 = tmpvar_90;
  mediump vec3 tmpvar_91;
  tmpvar_91 = normalize(normT_5);
  mediump float tmpvar_92;
  tmpvar_92 = dot (tmpvar_91, tmpvar_89);
  highp float tmpvar_93;
  mediump float tmpvar_94;
  tmpvar_94 = clamp (dot (normalize(
    (tmpvar_89 + tmpvar_90)
  ), tmpvar_91), 0.0, 1.0);
  tmpvar_93 = tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = (pow (tmpvar_93, _SpecularPower) * _SpecularColor.w);
  c_88.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_92) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_95)) * (atten_87 * 2.0));
  c_88.w = (tmpvar_92 * (atten_87 * 2.0));
  highp vec3 tmpvar_96;
  tmpvar_96 = normalize(_SunDir);
  mediump vec3 lightDir_97;
  lightDir_97 = tmpvar_96;
  mediump vec3 normal_98;
  normal_98 = xlv_TEXCOORD3;
  mediump float tmpvar_99;
  tmpvar_99 = dot (normal_98, lightDir_97);
  color_6 = (c_88 * mix (1.0, clamp (
    floor((1.01 + tmpvar_99))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_99))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_100;
  tmpvar_100 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_100;
  tmpvar_1 = tmpvar_100;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
vec4 t0;
vec4 t1;
vec3 t2;
vec3 t3;
vec3 t7;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * in_NORMAL0.zxy;
    t13 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_TANGENT0.yzx;
    t3.xyz = t1.xyz * t2.xyz;
    t1.xyz = t1.zxy * t2.yzx + (-t3.xyz);
    t1.xyz = t1.xyz * in_TANGENT0.www;
    t2.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t2.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t2.xyz;
    t2.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t2.xyz;
    t2.xyz = t2.xyz + _World2Object[3].xyz;
    t2.xyz = t2.xyz + (-in_POSITION0.xyz);
    t7.y = dot(t1.xyz, t2.xyz);
    t7.x = dot(in_TANGENT0.xyz, t2.xyz);
    t7.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t7.xyz, t7.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD1.xyz = vec3(t13) * t7.xyz;
    t2.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t2.xyz;
    t2.xyz = _Object2World[3].xyz * in_POSITION0.www + t2.xyz;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t13 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD0 = sqrt(t13);
    t13 = dot(in_POSITION0, in_POSITION0);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t2.xyz);
    t2.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t2.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD3.xyz = vec3(t13) * t2.xyz;
    t2.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t2.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t2.xyz;
    t2.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t2.xyz;
    t1.y = dot(t1.xyz, t2.xyz);
    t1.x = dot(in_TANGENT0.xyz, t2.xyz);
    t1.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD6.zw = t0.zw;
    vs_TEXCOORD6.xy = t1.zz + t1.xw;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
bool tb1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
vec2 t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13.x = t7 * 0.0208350997 + -0.0851330012;
    t13.x = t7 * t13.x + 0.180141002;
    t13.x = t7 * t13.x + -0.330299497;
    t7 = t7 * t13.x + 0.999866009;
    t13.x = t7 * t1.x;
    t13.x = t13.x * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13.x = tb19 ? t13.x : float(0.0);
    t1.x = t1.x * t7 + t13.x;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13.x = tb7.y ? t20 : float(0.0);
    t13.x = t19 * t14 + t13.x;
    t2.y = t13.x * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t13.xy = t10_4.xy * alphaMask1.xy;
    t13.x = t13.y + t13.x;
    t13.x = t10_4.z * alphaMask1.z + t13.x;
    t13.x = t10_4.w * alphaMask1.w + t13.x;
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb1 = t10_4.w>=1.0;
    t1.x = (tb1) ? 0.0 : 1.0;
    t1.x = t1.x * t13.x;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13.x = tb13 ? 1.0 : float(0.0);
    t7 = t13.x * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = t13.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t13.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t13.xy);
    t1.x = dot(t10_2.xx, t1.xx);
    t13.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13.x = inversesqrt(t13.x);
    t2.xyz = t13.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13.x = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13.x + 1.00999999;
    t13.x = t13.x * -10.0;
    t13.x = clamp(t13.x, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13.x = t13.x * t19 + 1.0;
    t1.x = t13.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 305 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  float tmpvar_28;
  vec4 v_29;
  v_29 = (texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw) * alphaMask1);
  tmpvar_28 = ((v_29.x + v_29.y) + (v_29.z + v_29.w));
  vec4 tmpvar_30;
  tmpvar_30.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_30.w = tmpvar_28;
  cityoverlay_3.xyz = tmpvar_30.xyz;
  vec2 uv_31;
  vec3 tmpvar_32;
  tmpvar_32 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_33;
  tmpvar_33 = abs(tmpvar_32);
  float tmpvar_34;
  tmpvar_34 = float((tmpvar_33.z >= tmpvar_33.x));
  float tmpvar_35;
  tmpvar_35 = float((max (tmpvar_33.x, tmpvar_33.z) >= tmpvar_33.y));
  float tmpvar_36;
  tmpvar_36 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_34), tmpvar_35));
  vec3 tmpvar_37;
  tmpvar_37.xz = vec2(1.0, -1.0);
  tmpvar_37.y = -(tmpvar_36);
  vec3 tmpvar_38;
  tmpvar_38.xz = vec2(1.0, -1.0);
  tmpvar_38.y = tmpvar_36;
  vec3 tmpvar_39;
  tmpvar_39.xy = vec2(1.0, 1.0);
  tmpvar_39.z = tmpvar_36;
  vec3 tmpvar_40;
  tmpvar_40 = mix ((tmpvar_39 * tmpvar_32.yxz), mix ((tmpvar_37 * tmpvar_32.xzy), (tmpvar_38 * tmpvar_32.zxy), vec3(tmpvar_34)), vec3(tmpvar_35));
  uv_31 = (((
    (0.5 * tmpvar_40.yz)
   / 
    abs(tmpvar_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_41;
  vec2 tmpvar_42;
  float tmpvar_43;
  tmpvar_43 = (0.5 * _CityOverlayDetailScale);
  tmpvar_42 = abs((uv_31 - tmpvar_43));
  uvCont_41.x = max (tmpvar_42.x, tmpvar_42.y);
  uvCont_41.y = min (tmpvar_42.x, tmpvar_42.y);
  vec4 tmpvar_44;
  tmpvar_44.xy = dFdx(uvCont_41);
  tmpvar_44.zw = dFdy(uvCont_41);
  vec4 tmpvar_45;
  tmpvar_45 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_31, tmpvar_44.xy, tmpvar_44.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_45.xyz;
  vec2 uv_46;
  vec3 tmpvar_47;
  tmpvar_47 = abs(tmpvar_32);
  float tmpvar_48;
  tmpvar_48 = float((tmpvar_47.z >= tmpvar_47.x));
  float tmpvar_49;
  tmpvar_49 = float((max (tmpvar_47.x, tmpvar_47.z) >= tmpvar_47.y));
  float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_48), tmpvar_49));
  vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(tmpvar_50);
  vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = tmpvar_50;
  vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = tmpvar_50;
  vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_32.yxz), mix ((tmpvar_51 * tmpvar_32.xzy), (tmpvar_52 * tmpvar_32.zxy), vec3(tmpvar_48)), vec3(tmpvar_49));
  uv_46 = (((
    (0.5 * tmpvar_54.yz)
   / 
    abs(tmpvar_54.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_55;
  vec2 tmpvar_56;
  tmpvar_56 = abs((uv_46 - tmpvar_43));
  uvCont_55.x = max (tmpvar_56.x, tmpvar_56.y);
  uvCont_55.y = min (tmpvar_56.x, tmpvar_56.y);
  vec4 tmpvar_57;
  tmpvar_57.xy = dFdx(uvCont_55);
  tmpvar_57.zw = dFdy(uvCont_55);
  vec4 tmpvar_58;
  tmpvar_58 = texture2DGradARB (_CityLightOverlayDetailTex, uv_46, tmpvar_57.xy, tmpvar_57.zw);
  citylightoverlaydetail_1.xyz = tmpvar_58.xyz;
  cityoverlay_3.w = (tmpvar_28 * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_45.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_58.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_58.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_59;
  vec3 tmpvar_60;
  tmpvar_60 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_61;
  tmpvar_61 = normalize(normal_20);
  float tmpvar_62;
  tmpvar_62 = dot (tmpvar_61, tmpvar_60);
  c_59.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_62) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_60 + normalize(xlv_TEXCOORD1)))
    , tmpvar_61), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_59.w = (tmpvar_62 * 2.0);
  float tmpvar_63;
  tmpvar_63 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_59 * mix (1.0, clamp (
    floor((1.01 + tmpvar_63))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_63))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_64;
  tmpvar_64 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_64;
  gl_FragData[0] = tmpvar_64;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 301 math, 5 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  mediump float tmpvar_36;
  mediump vec4 v_37;
  v_37 = (tmpvar_35 * alphaMask1);
  tmpvar_36 = ((v_37.x + v_37.y) + (v_37.z + v_37.w));
  mediump vec4 tmpvar_38;
  tmpvar_38.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_38.w = tmpvar_36;
  cityoverlay_4.xyz = tmpvar_38.xyz;
  mediump vec2 uv_39;
  mediump vec3 detailCoords_40;
  mediump float s_41;
  mediump float nylerp_42;
  mediump float zxlerp_43;
  highp vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  highp float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_43);
  s_41 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, s_41, nylerp_42));
  s_41 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = -(s_41);
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = s_41;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_50 * tmpvar_44.xzy), (tmpvar_51 * tmpvar_44.zxy), vec3(zxlerp_43));
  detailCoords_40 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = s_41;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_44.yxz), detailCoords_40, vec3(nylerp_42));
  detailCoords_40 = tmpvar_54;
  uv_39 = (((
    (0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_55;
  uv_55 = uv_39;
  highp vec2 uvCont_56;
  highp vec2 tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = (0.5 * _CityOverlayDetailScale);
  tmpvar_57 = abs((uv_55 - tmpvar_58));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_56);
  tmpvar_59.zw = dFdy(uvCont_56);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_39, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citydarkoverlaydetail_3.xyz = tmpvar_61.xyz;
  mediump vec2 uv_62;
  mediump vec3 detailCoords_63;
  mediump float s_64;
  mediump float nylerp_65;
  mediump float zxlerp_66;
  highp vec3 tmpvar_67;
  tmpvar_67 = abs(tmpvar_44);
  highp float tmpvar_68;
  tmpvar_68 = float((tmpvar_67.z >= tmpvar_67.x));
  zxlerp_66 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = float((max (tmpvar_67.x, tmpvar_67.z) >= tmpvar_67.y));
  nylerp_65 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_66);
  s_64 = tmpvar_70;
  highp float tmpvar_71;
  tmpvar_71 = sign(mix (tmpvar_44.y, s_64, nylerp_65));
  s_64 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xz = vec2(1.0, -1.0);
  tmpvar_72.y = -(s_64);
  mediump vec3 tmpvar_73;
  tmpvar_73.xz = vec2(1.0, -1.0);
  tmpvar_73.y = s_64;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix ((tmpvar_72 * tmpvar_44.xzy), (tmpvar_73 * tmpvar_44.zxy), vec3(zxlerp_66));
  detailCoords_63 = tmpvar_74;
  mediump vec3 tmpvar_75;
  tmpvar_75.xy = vec2(1.0, 1.0);
  tmpvar_75.z = s_64;
  highp vec3 tmpvar_76;
  tmpvar_76 = mix ((tmpvar_75 * tmpvar_44.yxz), detailCoords_63, vec3(nylerp_65));
  detailCoords_63 = tmpvar_76;
  uv_62 = (((
    (0.5 * detailCoords_63.yz)
   / 
    abs(detailCoords_63.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_77;
  uv_77 = uv_62;
  highp vec2 uvCont_78;
  highp vec2 tmpvar_79;
  tmpvar_79 = abs((uv_77 - tmpvar_58));
  uvCont_78.x = max (tmpvar_79.x, tmpvar_79.y);
  uvCont_78.y = min (tmpvar_79.x, tmpvar_79.y);
  highp vec4 tmpvar_80;
  tmpvar_80.xy = dFdx(uvCont_78);
  tmpvar_80.zw = dFdy(uvCont_78);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_62, tmpvar_80.xy, tmpvar_80.zw);
  mediump vec4 tmpvar_82;
  tmpvar_82 = tmpvar_81;
  citylightoverlaydetail_2.xyz = tmpvar_82.xyz;
  cityoverlay_4.w = (tmpvar_36 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_61.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_82.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_82.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_83;
  lightDir_83 = xlv_TEXCOORD5;
  mediump vec3 viewDir_84;
  viewDir_84 = xlv_TEXCOORD1;
  mediump vec4 c_85;
  mediump vec3 tmpvar_86;
  tmpvar_86 = normalize(lightDir_83);
  lightDir_83 = tmpvar_86;
  mediump vec3 tmpvar_87;
  tmpvar_87 = normalize(viewDir_84);
  viewDir_84 = tmpvar_87;
  mediump vec3 tmpvar_88;
  tmpvar_88 = normalize(normT_5);
  mediump float tmpvar_89;
  tmpvar_89 = dot (tmpvar_88, tmpvar_86);
  highp float tmpvar_90;
  mediump float tmpvar_91;
  tmpvar_91 = clamp (dot (normalize(
    (tmpvar_86 + tmpvar_87)
  ), tmpvar_88), 0.0, 1.0);
  tmpvar_90 = tmpvar_91;
  highp float tmpvar_92;
  tmpvar_92 = (pow (tmpvar_90, _SpecularPower) * _SpecularColor.w);
  c_85.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_89) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_92)) * 2.0);
  c_85.w = (tmpvar_89 * 2.0);
  highp vec3 tmpvar_93;
  tmpvar_93 = normalize(_SunDir);
  mediump vec3 lightDir_94;
  lightDir_94 = tmpvar_93;
  mediump vec3 normal_95;
  normal_95 = xlv_TEXCOORD3;
  mediump float tmpvar_96;
  tmpvar_96 = dot (normal_95, lightDir_94);
  color_6 = (c_85 * mix (1.0, clamp (
    floor((1.01 + tmpvar_96))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_96))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_97;
  tmpvar_97 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_97;
  tmpvar_1 = tmpvar_97;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec4 t10_4;
mediump vec2 t16_5;
lowp vec3 t10_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
highp vec3 t11;
highp int ti11;
bvec2 tb11;
mediump vec2 t16_15;
highp vec2 t20;
highp float t21;
lowp float t10_21;
highp int ti21;
highp float t22;
mediump float t16_25;
highp float t30;
highp float t31;
bool tb31;
highp float t32;
mediump float t16_35;
mediump float t16_37;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t10.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t10.z), abs(t10.y));
    t1.x = float(1.0) / t1.x;
    t11.x = min(abs(t10.z), abs(t10.y));
    t1.x = t1.x * t11.x;
    t11.x = t1.x * t1.x;
    t21 = t11.x * 0.0208350997 + -0.0851330012;
    t21 = t11.x * t21 + 0.180141002;
    t21 = t11.x * t21 + -0.330299497;
    t11.x = t11.x * t21 + 0.999866009;
    t21 = t11.x * t1.x;
    t21 = t21 * -2.0 + 1.57079637;
    tb31 = abs(t10.z)<abs(t10.y);
    t21 = tb31 ? t21 : float(0.0);
    t1.x = t1.x * t11.x + t21;
    tb11.xy = lessThan(t10.zxzz, (-t10.zxzz)).xy;
    t11.x = tb11.x ? -3.14159274 : float(0.0);
    t1.x = t11.x + t1.x;
    t11.x = min(t10.z, t10.y);
    tb11.x = t11.x<(-t11.x);
    t31 = max(t10.z, t10.y);
    tb31 = t31>=(-t31);
    ti11 = int(uint(tb31) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t1.x = (ti11 != 0) ? (-t1.x) : t1.x;
    t11.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t11.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t31 = abs(t10.x) * -0.0187292993 + 0.0742610022;
    t31 = t31 * abs(t10.x) + -0.212114394;
    t31 = t31 * abs(t10.x) + 1.57072878;
    t22 = -abs(t10.x) + 1.0;
    t22 = sqrt(t22);
    t32 = t31 * t22;
    t32 = t32 * -2.0 + 3.14159274;
    t21 = tb11.y ? t32 : float(0.0);
    t21 = t31 * t22 + t21;
    t2.y = t21 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t16_5.xy = t10_4.xy * alphaMask1.xy;
    t16_5.x = t16_5.y + t16_5.x;
    t16_5.x = t10_4.z * alphaMask1.z + t16_5.x;
    t16_5.x = t10_4.w * alphaMask1.w + t16_5.x;
    t10_21 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_6.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_21>=1.0;
    t16_15.x = (tb1) ? 0.0 : 1.0;
    t16_5.x = t16_15.x * t16_5.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t10.y);
    tb11.x = abs(t10.z)>=abs(t10.y);
    t11.x = tb11.x ? 1.0 : float(0.0);
    t1.x = t11.x * t1.x + t10.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t10.z), abs(t10.y));
    tb1 = t1.x>=abs(t10.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t10.x;
    ti21 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti21) + ti0;
    t16_7.y = float(ti0);
    t16_8.y = (-t16_7.y);
    t16_8.xz = vec2(1.0, -1.0);
    t2.xyz = t10.yzx * t16_8.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t3.xyz = t16_7.xyz * t10.zyx + (-t2.xyz);
    t11.xyz = t11.xxx * t3.xyz + t2.xyz;
    t11.xyz = (-t16_7.xxy) * t10.xyz + t11.xyz;
    t0.xyz = t10.xyz * t16_7.xxy;
    t0.xyz = t1.xxx * t11.xyz + t0.xyz;
    t16_15.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_15.xy = t16_15.xy / abs(t0.xx);
    t16_15.xy = t16_15.xy + vec2(0.5, 0.5);
    t0.xy = t16_15.xy * vec2(_CityOverlayDetailScale);
    t20.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t20.y), abs(t20.x));
    t20.x = min(abs(t20.y), abs(t20.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t20.x);
    t1.y = dFdy(t20.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_15.x = t16_5.x * t10_3.w;
    t16_5.x = t16_5.x * t10_0.w;
    t16_7.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_25 = dot(t10_6.xyz, t10_6.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_8.xyz = vec3(t16_25) * t10_6.xyz;
    t16_25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_9.xyz = vec3(t16_25) * vs_TEXCOORD5.xyz;
    t16_25 = dot(t16_8.xyz, t16_9.xyz);
    t16_25 = t16_25 + t16_25;
    t30 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t30 = inversesqrt(t30);
    t1.xyz = vec3(float(t30) * _SunDir.xxyz.y, float(t30) * _SunDir.xxyz.z, float(t30) * float(_SunDir.z));
    t16_35 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_37 = t16_35 + 1.00999999;
    t16_35 = t16_35 * -10.0;
    t16_35 = clamp(t16_35, 0.0, 1.0);
    t16_37 = floor(t16_37);
    t16_37 = clamp(t16_37, 0.0, 1.0);
    t16_37 = t16_37 + -1.0;
    t16_35 = t16_35 * t16_37 + 1.0;
    t16_25 = t16_35 * t16_25;
    t16_25 = clamp(t16_25, 0.0, 1.0);
    t16_25 = (-t16_25) + 1.0;
    t16_35 = t16_15.x * t16_25 + (-t16_5.x);
    t16_15.x = t16_25 * t16_15.x;
    t16_1.w = t16_15.x * t16_35 + t16_5.x;
    t16_1.xyz = t16_15.xxx * t16_7.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
bool tb1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
vec2 t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13.x = t7 * 0.0208350997 + -0.0851330012;
    t13.x = t7 * t13.x + 0.180141002;
    t13.x = t7 * t13.x + -0.330299497;
    t7 = t7 * t13.x + 0.999866009;
    t13.x = t7 * t1.x;
    t13.x = t13.x * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13.x = tb19 ? t13.x : float(0.0);
    t1.x = t1.x * t7 + t13.x;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13.x = tb7.y ? t20 : float(0.0);
    t13.x = t19 * t14 + t13.x;
    t2.y = t13.x * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t13.xy = t10_4.xy * alphaMask1.xy;
    t13.x = t13.y + t13.x;
    t13.x = t10_4.z * alphaMask1.z + t13.x;
    t13.x = t10_4.w * alphaMask1.w + t13.x;
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb1 = t10_4.w>=1.0;
    t1.x = (tb1) ? 0.0 : 1.0;
    t1.x = t1.x * t13.x;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13.x = tb13 ? 1.0 : float(0.0);
    t7 = t13.x * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = t13.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t1.x = t1.x + t1.x;
    t13.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13.x = inversesqrt(t13.x);
    t2.xyz = t13.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13.x = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13.x + 1.00999999;
    t13.x = t13.x * -10.0;
    t13.x = clamp(t13.x, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13.x = t13.x * t19 + 1.0;
    t1.x = t13.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 307 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 tmpvar_1;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = gl_Normal;
  vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(gl_Normal);
  vec3 tmpvar_6;
  tmpvar_6 = normalize(TANGENT.xyz);
  vec3 tmpvar_7;
  vec3 tmpvar_8;
  tmpvar_7 = TANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * TANGENT.w);
  mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = gl_Normal.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = gl_Normal.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = gl_Normal.z;
  vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  vec4 o_11;
  vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_1 * 0.5);
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_12.x;
  tmpvar_13.y = (tmpvar_12.y * _ProjectionParams.x);
  o_11.xy = (tmpvar_13 + tmpvar_12.w);
  o_11.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
  xlv_TEXCOORD6 = o_11;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec3 tmpvar_21;
  tmpvar_21 = normalize(xlv_TEXCOORD2);
  vec2 uv_22;
  float tmpvar_23;
  float tmpvar_24;
  tmpvar_24 = (min (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0) / max (abs(
    (tmpvar_21.x / tmpvar_21.z)
  ), 1.0));
  float tmpvar_25;
  tmpvar_25 = (tmpvar_24 * tmpvar_24);
  tmpvar_25 = (((
    ((((
      ((((-0.01213232 * tmpvar_25) + 0.05368138) * tmpvar_25) - 0.1173503)
     * tmpvar_25) + 0.1938925) * tmpvar_25) - 0.3326756)
   * tmpvar_25) + 0.9999793) * tmpvar_24);
  tmpvar_25 = (tmpvar_25 + (float(
    (abs((tmpvar_21.x / tmpvar_21.z)) > 1.0)
  ) * (
    (tmpvar_25 * -2.0)
   + 1.570796)));
  tmpvar_23 = (tmpvar_25 * sign((tmpvar_21.x / tmpvar_21.z)));
  if ((abs(tmpvar_21.z) > (1e-08 * abs(tmpvar_21.x)))) {
    if ((tmpvar_21.z < 0.0)) {
      if ((tmpvar_21.x >= 0.0)) {
        tmpvar_23 += 3.141593;
      } else {
        tmpvar_23 = (tmpvar_23 - 3.141593);
      };
    };
  } else {
    tmpvar_23 = (sign(tmpvar_21.x) * 1.570796);
  };
  uv_22.x = (0.5 + (0.1591549 * tmpvar_23));
  uv_22.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_21.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_21.y)
    )) * (1.570796 + (
      abs(tmpvar_21.y)
     * 
      (-0.2146018 + (abs(tmpvar_21.y) * (0.08656672 + (
        abs(tmpvar_21.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_26;
  uvCont_26.y = uv_22.y;
  uvCont_26.x = abs((uv_22.x - 0.5));
  vec4 tmpvar_27;
  tmpvar_27.xy = dFdx(uvCont_26);
  tmpvar_27.zw = dFdy(uvCont_26);
  float tmpvar_28;
  vec4 v_29;
  v_29 = (texture2DGradARB (_CityOverlayTex, uv_22, tmpvar_27.xy, tmpvar_27.zw) * alphaMask1);
  tmpvar_28 = ((v_29.x + v_29.y) + (v_29.z + v_29.w));
  vec4 tmpvar_30;
  tmpvar_30.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_30.w = tmpvar_28;
  cityoverlay_3.xyz = tmpvar_30.xyz;
  vec2 uv_31;
  vec3 tmpvar_32;
  tmpvar_32 = normalize(xlv_TEXCOORD2);
  vec3 tmpvar_33;
  tmpvar_33 = abs(tmpvar_32);
  float tmpvar_34;
  tmpvar_34 = float((tmpvar_33.z >= tmpvar_33.x));
  float tmpvar_35;
  tmpvar_35 = float((max (tmpvar_33.x, tmpvar_33.z) >= tmpvar_33.y));
  float tmpvar_36;
  tmpvar_36 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_34), tmpvar_35));
  vec3 tmpvar_37;
  tmpvar_37.xz = vec2(1.0, -1.0);
  tmpvar_37.y = -(tmpvar_36);
  vec3 tmpvar_38;
  tmpvar_38.xz = vec2(1.0, -1.0);
  tmpvar_38.y = tmpvar_36;
  vec3 tmpvar_39;
  tmpvar_39.xy = vec2(1.0, 1.0);
  tmpvar_39.z = tmpvar_36;
  vec3 tmpvar_40;
  tmpvar_40 = mix ((tmpvar_39 * tmpvar_32.yxz), mix ((tmpvar_37 * tmpvar_32.xzy), (tmpvar_38 * tmpvar_32.zxy), vec3(tmpvar_34)), vec3(tmpvar_35));
  uv_31 = (((
    (0.5 * tmpvar_40.yz)
   / 
    abs(tmpvar_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_41;
  vec2 tmpvar_42;
  float tmpvar_43;
  tmpvar_43 = (0.5 * _CityOverlayDetailScale);
  tmpvar_42 = abs((uv_31 - tmpvar_43));
  uvCont_41.x = max (tmpvar_42.x, tmpvar_42.y);
  uvCont_41.y = min (tmpvar_42.x, tmpvar_42.y);
  vec4 tmpvar_44;
  tmpvar_44.xy = dFdx(uvCont_41);
  tmpvar_44.zw = dFdy(uvCont_41);
  vec4 tmpvar_45;
  tmpvar_45 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_31, tmpvar_44.xy, tmpvar_44.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_45.xyz;
  vec2 uv_46;
  vec3 tmpvar_47;
  tmpvar_47 = abs(tmpvar_32);
  float tmpvar_48;
  tmpvar_48 = float((tmpvar_47.z >= tmpvar_47.x));
  float tmpvar_49;
  tmpvar_49 = float((max (tmpvar_47.x, tmpvar_47.z) >= tmpvar_47.y));
  float tmpvar_50;
  tmpvar_50 = sign(mix (tmpvar_32.y, mix (tmpvar_32.x, tmpvar_32.z, tmpvar_48), tmpvar_49));
  vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = -(tmpvar_50);
  vec3 tmpvar_52;
  tmpvar_52.xz = vec2(1.0, -1.0);
  tmpvar_52.y = tmpvar_50;
  vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = tmpvar_50;
  vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_32.yxz), mix ((tmpvar_51 * tmpvar_32.xzy), (tmpvar_52 * tmpvar_32.zxy), vec3(tmpvar_48)), vec3(tmpvar_49));
  uv_46 = (((
    (0.5 * tmpvar_54.yz)
   / 
    abs(tmpvar_54.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_55;
  vec2 tmpvar_56;
  tmpvar_56 = abs((uv_46 - tmpvar_43));
  uvCont_55.x = max (tmpvar_56.x, tmpvar_56.y);
  uvCont_55.y = min (tmpvar_56.x, tmpvar_56.y);
  vec4 tmpvar_57;
  tmpvar_57.xy = dFdx(uvCont_55);
  tmpvar_57.zw = dFdy(uvCont_55);
  vec4 tmpvar_58;
  tmpvar_58 = texture2DGradARB (_CityLightOverlayDetailTex, uv_46, tmpvar_57.xy, tmpvar_57.zw);
  citylightoverlaydetail_1.xyz = tmpvar_58.xyz;
  cityoverlay_3.w = (tmpvar_28 * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_45.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_58.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_58.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_59;
  tmpvar_59 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_60;
  vec3 tmpvar_61;
  tmpvar_61 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_62;
  tmpvar_62 = normalize(normal_20);
  float tmpvar_63;
  tmpvar_63 = dot (tmpvar_62, tmpvar_61);
  c_60.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_63) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_61 + normalize(xlv_TEXCOORD1)))
    , tmpvar_62), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_59.x * 2.0));
  c_60.w = (tmpvar_63 * (tmpvar_59.x * 2.0));
  float tmpvar_64;
  tmpvar_64 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_60 * mix (1.0, clamp (
    floor((1.01 + tmpvar_64))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_64))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_65;
  tmpvar_65 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_65;
  gl_FragData[0] = tmpvar_65;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 58 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_ProjectionParams]
Vector 12 [_ScreenParams]
Vector 13 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c14, 1, 0, 0.5, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c13
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c14
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r1.x, r0.y, c11.x
mul r1.w, r1.x, c14.z
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c14.z
mad o6.xy, r1.z, c12.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o6.zw, r0

"
}
SubProgram "d3d11 " {
// Stats: 53 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 307 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  mediump float tmpvar_36;
  mediump vec4 v_37;
  v_37 = (tmpvar_35 * alphaMask1);
  tmpvar_36 = ((v_37.x + v_37.y) + (v_37.z + v_37.w));
  mediump vec4 tmpvar_38;
  tmpvar_38.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_38.w = tmpvar_36;
  cityoverlay_4.xyz = tmpvar_38.xyz;
  mediump vec2 uv_39;
  mediump vec3 detailCoords_40;
  mediump float s_41;
  mediump float nylerp_42;
  mediump float zxlerp_43;
  highp vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  highp float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_43);
  s_41 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, s_41, nylerp_42));
  s_41 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = -(s_41);
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = s_41;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_50 * tmpvar_44.xzy), (tmpvar_51 * tmpvar_44.zxy), vec3(zxlerp_43));
  detailCoords_40 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = s_41;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_44.yxz), detailCoords_40, vec3(nylerp_42));
  detailCoords_40 = tmpvar_54;
  uv_39 = (((
    (0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_55;
  uv_55 = uv_39;
  highp vec2 uvCont_56;
  highp vec2 tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = (0.5 * _CityOverlayDetailScale);
  tmpvar_57 = abs((uv_55 - tmpvar_58));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_56);
  tmpvar_59.zw = dFdy(uvCont_56);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_39, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citydarkoverlaydetail_3.xyz = tmpvar_61.xyz;
  mediump vec2 uv_62;
  mediump vec3 detailCoords_63;
  mediump float s_64;
  mediump float nylerp_65;
  mediump float zxlerp_66;
  highp vec3 tmpvar_67;
  tmpvar_67 = abs(tmpvar_44);
  highp float tmpvar_68;
  tmpvar_68 = float((tmpvar_67.z >= tmpvar_67.x));
  zxlerp_66 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = float((max (tmpvar_67.x, tmpvar_67.z) >= tmpvar_67.y));
  nylerp_65 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_66);
  s_64 = tmpvar_70;
  highp float tmpvar_71;
  tmpvar_71 = sign(mix (tmpvar_44.y, s_64, nylerp_65));
  s_64 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xz = vec2(1.0, -1.0);
  tmpvar_72.y = -(s_64);
  mediump vec3 tmpvar_73;
  tmpvar_73.xz = vec2(1.0, -1.0);
  tmpvar_73.y = s_64;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix ((tmpvar_72 * tmpvar_44.xzy), (tmpvar_73 * tmpvar_44.zxy), vec3(zxlerp_66));
  detailCoords_63 = tmpvar_74;
  mediump vec3 tmpvar_75;
  tmpvar_75.xy = vec2(1.0, 1.0);
  tmpvar_75.z = s_64;
  highp vec3 tmpvar_76;
  tmpvar_76 = mix ((tmpvar_75 * tmpvar_44.yxz), detailCoords_63, vec3(nylerp_65));
  detailCoords_63 = tmpvar_76;
  uv_62 = (((
    (0.5 * detailCoords_63.yz)
   / 
    abs(detailCoords_63.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_77;
  uv_77 = uv_62;
  highp vec2 uvCont_78;
  highp vec2 tmpvar_79;
  tmpvar_79 = abs((uv_77 - tmpvar_58));
  uvCont_78.x = max (tmpvar_79.x, tmpvar_79.y);
  uvCont_78.y = min (tmpvar_79.x, tmpvar_79.y);
  highp vec4 tmpvar_80;
  tmpvar_80.xy = dFdx(uvCont_78);
  tmpvar_80.zw = dFdy(uvCont_78);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_62, tmpvar_80.xy, tmpvar_80.zw);
  mediump vec4 tmpvar_82;
  tmpvar_82 = tmpvar_81;
  citylightoverlaydetail_2.xyz = tmpvar_82.xyz;
  cityoverlay_4.w = (tmpvar_36 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_61.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_82.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_82.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_83 = tmpvar_84;
  mediump vec3 lightDir_85;
  lightDir_85 = xlv_TEXCOORD5;
  mediump vec3 viewDir_86;
  viewDir_86 = xlv_TEXCOORD1;
  mediump float atten_87;
  atten_87 = tmpvar_83;
  mediump vec4 c_88;
  mediump vec3 tmpvar_89;
  tmpvar_89 = normalize(lightDir_85);
  lightDir_85 = tmpvar_89;
  mediump vec3 tmpvar_90;
  tmpvar_90 = normalize(viewDir_86);
  viewDir_86 = tmpvar_90;
  mediump vec3 tmpvar_91;
  tmpvar_91 = normalize(normT_5);
  mediump float tmpvar_92;
  tmpvar_92 = dot (tmpvar_91, tmpvar_89);
  highp float tmpvar_93;
  mediump float tmpvar_94;
  tmpvar_94 = clamp (dot (normalize(
    (tmpvar_89 + tmpvar_90)
  ), tmpvar_91), 0.0, 1.0);
  tmpvar_93 = tmpvar_94;
  highp float tmpvar_95;
  tmpvar_95 = (pow (tmpvar_93, _SpecularPower) * _SpecularColor.w);
  c_88.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_92) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_95)) * (atten_87 * 2.0));
  c_88.w = (tmpvar_92 * (atten_87 * 2.0));
  highp vec3 tmpvar_96;
  tmpvar_96 = normalize(_SunDir);
  mediump vec3 lightDir_97;
  lightDir_97 = tmpvar_96;
  mediump vec3 normal_98;
  normal_98 = xlv_TEXCOORD3;
  mediump float tmpvar_99;
  tmpvar_99 = dot (normal_98, lightDir_97);
  color_6 = (c_88 * mix (1.0, clamp (
    floor((1.01 + tmpvar_99))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_99))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_100;
  tmpvar_100 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_100;
  tmpvar_1 = tmpvar_100;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
vec4 t0;
vec4 t1;
vec3 t2;
vec3 t3;
vec3 t7;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * in_NORMAL0.zxy;
    t13 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_TANGENT0.yzx;
    t3.xyz = t1.xyz * t2.xyz;
    t1.xyz = t1.zxy * t2.yzx + (-t3.xyz);
    t1.xyz = t1.xyz * in_TANGENT0.www;
    t2.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t2.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t2.xyz;
    t2.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t2.xyz;
    t2.xyz = t2.xyz + _World2Object[3].xyz;
    t2.xyz = t2.xyz + (-in_POSITION0.xyz);
    t7.y = dot(t1.xyz, t2.xyz);
    t7.x = dot(in_TANGENT0.xyz, t2.xyz);
    t7.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t7.xyz, t7.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD1.xyz = vec3(t13) * t7.xyz;
    t2.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t2.xyz;
    t2.xyz = _Object2World[3].xyz * in_POSITION0.www + t2.xyz;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t13 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD0 = sqrt(t13);
    t13 = dot(in_POSITION0, in_POSITION0);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t2.xyz);
    t2.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t2.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD3.xyz = vec3(t13) * t2.xyz;
    t2.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t2.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t2.xyz;
    t2.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t2.xyz;
    t1.y = dot(t1.xyz, t2.xyz);
    t1.x = dot(in_TANGENT0.xyz, t2.xyz);
    t1.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD6.zw = t0.zw;
    vs_TEXCOORD6.xy = t1.zz + t1.xw;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  sampler2D _CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
bool tb1;
vec3 t2;
lowp vec4 t10_2;
vec3 t3;
vec3 t4;
lowp vec4 t10_4;
vec4 t5;
vec3 t6;
float t7;
int ti7;
bvec2 tb7;
vec2 t12;
vec2 t13;
bool tb13;
float t14;
float t19;
int ti19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7 = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7;
    t7 = t1.x * t1.x;
    t13.x = t7 * 0.0208350997 + -0.0851330012;
    t13.x = t7 * t13.x + 0.180141002;
    t13.x = t7 * t13.x + -0.330299497;
    t7 = t7 * t13.x + 0.999866009;
    t13.x = t7 * t1.x;
    t13.x = t13.x * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13.x = tb19 ? t13.x : float(0.0);
    t1.x = t1.x * t7 + t13.x;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7 = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7 + t1.x;
    t7 = min(t6.z, t6.y);
    tb7.x = t7<(-t7);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7 = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13.x = tb7.y ? t20 : float(0.0);
    t13.x = t19 * t14 + t13.x;
    t2.y = t13.x * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t13.xy = t10_4.xy * alphaMask1.xy;
    t13.x = t13.y + t13.x;
    t13.x = t10_4.z * alphaMask1.z + t13.x;
    t13.x = t10_4.w * alphaMask1.w + t13.x;
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_2 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t2.xy = t10_2.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb1 = t10_4.w>=1.0;
    t1.x = (tb1) ? 0.0 : 1.0;
    t1.x = t1.x * t13.x;
    t7 = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb13 = abs(t6.z)>=abs(t6.y);
    t13.x = tb13 ? 1.0 : float(0.0);
    t7 = t13.x * t7 + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t7;
    t7 = max(abs(t6.z), abs(t6.y));
    tb7.x = t7>=abs(t6.x);
    t7 = tb7.x ? 1.0 : float(0.0);
    t0.x = t7 * t0.x + t6.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t4.xyz = t13.xxx * t5.xyz + t4.xyz;
    t4.xyz = (-t3.xxy) * t6.xyz + t4.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = vec3(t7) * t4.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t7 = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t7);
    t4.x = dFdy(t7);
    t3.y = dFdx(t12.x);
    t4.y = dFdy(t12.x);
    t5 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t4.xyxx).xy);
    t7 = t1.x * t5.w;
    t0.w = t1.x * t0.w;
    t1.x = dot(t2.xy, t2.xy);
    t1.x = min(t1.x, 1.0);
    t1.x = (-t1.x) + 1.0;
    t2.z = sqrt(t1.x);
    t1.x = dot(t2.xyz, t2.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xzw = t1.xxx * t2.xyz;
    t2.x = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t2.x = inversesqrt(t2.x);
    t2.xyz = t2.xxx * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xzw, t2.xyz);
    t13.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_2 = texture(_ShadowMapTexture, t13.xy);
    t1.x = dot(t10_2.xx, t1.xx);
    t13.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t13.x = inversesqrt(t13.x);
    t2.xyz = t13.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t13.x = dot(vs_TEXCOORD3.xyz, t2.xyz);
    t19 = t13.x + 1.00999999;
    t13.x = t13.x * -10.0;
    t13.x = clamp(t13.x, 0.0, 1.0);
    t19 = floor(t19);
    t19 = clamp(t19, 0.0, 1.0);
    t19 = t19 + -1.0;
    t13.x = t13.x * t19 + 1.0;
    t1.x = t13.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t5.w = t1.x * t7;
    t1 = (-t0) + t5;
    SV_Target0 = t5.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 306 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  mediump float tmpvar_36;
  mediump vec4 v_37;
  v_37 = (tmpvar_35 * alphaMask1);
  tmpvar_36 = ((v_37.x + v_37.y) + (v_37.z + v_37.w));
  mediump vec4 tmpvar_38;
  tmpvar_38.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_38.w = tmpvar_36;
  cityoverlay_4.xyz = tmpvar_38.xyz;
  mediump vec2 uv_39;
  mediump vec3 detailCoords_40;
  mediump float s_41;
  mediump float nylerp_42;
  mediump float zxlerp_43;
  highp vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  highp float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_43);
  s_41 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, s_41, nylerp_42));
  s_41 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = -(s_41);
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = s_41;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_50 * tmpvar_44.xzy), (tmpvar_51 * tmpvar_44.zxy), vec3(zxlerp_43));
  detailCoords_40 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = s_41;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_44.yxz), detailCoords_40, vec3(nylerp_42));
  detailCoords_40 = tmpvar_54;
  uv_39 = (((
    (0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_55;
  uv_55 = uv_39;
  highp vec2 uvCont_56;
  highp vec2 tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = (0.5 * _CityOverlayDetailScale);
  tmpvar_57 = abs((uv_55 - tmpvar_58));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_56);
  tmpvar_59.zw = dFdy(uvCont_56);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_39, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citydarkoverlaydetail_3.xyz = tmpvar_61.xyz;
  mediump vec2 uv_62;
  mediump vec3 detailCoords_63;
  mediump float s_64;
  mediump float nylerp_65;
  mediump float zxlerp_66;
  highp vec3 tmpvar_67;
  tmpvar_67 = abs(tmpvar_44);
  highp float tmpvar_68;
  tmpvar_68 = float((tmpvar_67.z >= tmpvar_67.x));
  zxlerp_66 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = float((max (tmpvar_67.x, tmpvar_67.z) >= tmpvar_67.y));
  nylerp_65 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_66);
  s_64 = tmpvar_70;
  highp float tmpvar_71;
  tmpvar_71 = sign(mix (tmpvar_44.y, s_64, nylerp_65));
  s_64 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xz = vec2(1.0, -1.0);
  tmpvar_72.y = -(s_64);
  mediump vec3 tmpvar_73;
  tmpvar_73.xz = vec2(1.0, -1.0);
  tmpvar_73.y = s_64;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix ((tmpvar_72 * tmpvar_44.xzy), (tmpvar_73 * tmpvar_44.zxy), vec3(zxlerp_66));
  detailCoords_63 = tmpvar_74;
  mediump vec3 tmpvar_75;
  tmpvar_75.xy = vec2(1.0, 1.0);
  tmpvar_75.z = s_64;
  highp vec3 tmpvar_76;
  tmpvar_76 = mix ((tmpvar_75 * tmpvar_44.yxz), detailCoords_63, vec3(nylerp_65));
  detailCoords_63 = tmpvar_76;
  uv_62 = (((
    (0.5 * detailCoords_63.yz)
   / 
    abs(detailCoords_63.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_77;
  uv_77 = uv_62;
  highp vec2 uvCont_78;
  highp vec2 tmpvar_79;
  tmpvar_79 = abs((uv_77 - tmpvar_58));
  uvCont_78.x = max (tmpvar_79.x, tmpvar_79.y);
  uvCont_78.y = min (tmpvar_79.x, tmpvar_79.y);
  highp vec4 tmpvar_80;
  tmpvar_80.xy = dFdx(uvCont_78);
  tmpvar_80.zw = dFdy(uvCont_78);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_62, tmpvar_80.xy, tmpvar_80.zw);
  mediump vec4 tmpvar_82;
  tmpvar_82 = tmpvar_81;
  citylightoverlaydetail_2.xyz = tmpvar_82.xyz;
  cityoverlay_4.w = (tmpvar_36 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_61.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_82.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_82.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float shadow_83;
  shadow_83 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_84;
  lightDir_84 = xlv_TEXCOORD5;
  mediump vec3 viewDir_85;
  viewDir_85 = xlv_TEXCOORD1;
  mediump float atten_86;
  atten_86 = shadow_83;
  mediump vec4 c_87;
  mediump vec3 tmpvar_88;
  tmpvar_88 = normalize(lightDir_84);
  lightDir_84 = tmpvar_88;
  mediump vec3 tmpvar_89;
  tmpvar_89 = normalize(viewDir_85);
  viewDir_85 = tmpvar_89;
  mediump vec3 tmpvar_90;
  tmpvar_90 = normalize(normT_5);
  mediump float tmpvar_91;
  tmpvar_91 = dot (tmpvar_90, tmpvar_88);
  highp float tmpvar_92;
  mediump float tmpvar_93;
  tmpvar_93 = clamp (dot (normalize(
    (tmpvar_88 + tmpvar_89)
  ), tmpvar_90), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  highp float tmpvar_94;
  tmpvar_94 = (pow (tmpvar_92, _SpecularPower) * _SpecularColor.w);
  c_87.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_91) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_94)) * (atten_86 * 2.0));
  c_87.w = (tmpvar_91 * (atten_86 * 2.0));
  highp vec3 tmpvar_95;
  tmpvar_95 = normalize(_SunDir);
  mediump vec3 lightDir_96;
  lightDir_96 = tmpvar_95;
  mediump vec3 normal_97;
  normal_97 = xlv_TEXCOORD3;
  mediump float tmpvar_98;
  tmpvar_98 = dot (normal_97, lightDir_96);
  color_6 = (c_87 * mix (1.0, clamp (
    floor((1.01 + tmpvar_98))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_98))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_99;
  tmpvar_99 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_99;
  tmpvar_1 = tmpvar_99;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1 = t0.yyyy * unity_World2Shadow[0][1];
    t1 = unity_World2Shadow[0][0] * t0.xxxx + t1;
    t1 = unity_World2Shadow[0][2] * t0.zzzz + t1;
    t0 = unity_World2Shadow[0][3] * t0.wwww + t1;
    vs_TEXCOORD6 = t0;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec4 t10_4;
mediump vec2 t16_5;
lowp vec3 t10_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
highp vec3 t11;
highp int ti11;
bvec2 tb11;
mediump vec2 t16_15;
highp vec2 t20;
highp float t21;
lowp float t10_21;
highp int ti21;
highp float t22;
mediump float t16_25;
highp float t30;
highp float t31;
bool tb31;
highp float t32;
mediump float t16_35;
mediump float t16_37;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t10.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t10.z), abs(t10.y));
    t1.x = float(1.0) / t1.x;
    t11.x = min(abs(t10.z), abs(t10.y));
    t1.x = t1.x * t11.x;
    t11.x = t1.x * t1.x;
    t21 = t11.x * 0.0208350997 + -0.0851330012;
    t21 = t11.x * t21 + 0.180141002;
    t21 = t11.x * t21 + -0.330299497;
    t11.x = t11.x * t21 + 0.999866009;
    t21 = t11.x * t1.x;
    t21 = t21 * -2.0 + 1.57079637;
    tb31 = abs(t10.z)<abs(t10.y);
    t21 = tb31 ? t21 : float(0.0);
    t1.x = t1.x * t11.x + t21;
    tb11.xy = lessThan(t10.zxzz, (-t10.zxzz)).xy;
    t11.x = tb11.x ? -3.14159274 : float(0.0);
    t1.x = t11.x + t1.x;
    t11.x = min(t10.z, t10.y);
    tb11.x = t11.x<(-t11.x);
    t31 = max(t10.z, t10.y);
    tb31 = t31>=(-t31);
    ti11 = int(uint(tb31) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t1.x = (ti11 != 0) ? (-t1.x) : t1.x;
    t11.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t11.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t31 = abs(t10.x) * -0.0187292993 + 0.0742610022;
    t31 = t31 * abs(t10.x) + -0.212114394;
    t31 = t31 * abs(t10.x) + 1.57072878;
    t22 = -abs(t10.x) + 1.0;
    t22 = sqrt(t22);
    t32 = t31 * t22;
    t32 = t32 * -2.0 + 3.14159274;
    t21 = tb11.y ? t32 : float(0.0);
    t21 = t31 * t22 + t21;
    t2.y = t21 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t16_5.xy = t10_4.xy * alphaMask1.xy;
    t16_5.x = t16_5.y + t16_5.x;
    t16_5.x = t10_4.z * alphaMask1.z + t16_5.x;
    t16_5.x = t10_4.w * alphaMask1.w + t16_5.x;
    t10_21 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_6.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_21>=1.0;
    t16_15.x = (tb1) ? 0.0 : 1.0;
    t16_5.x = t16_15.x * t16_5.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t10.y);
    tb11.x = abs(t10.z)>=abs(t10.y);
    t11.x = tb11.x ? 1.0 : float(0.0);
    t1.x = t11.x * t1.x + t10.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t10.z), abs(t10.y));
    tb1 = t1.x>=abs(t10.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t10.x;
    ti21 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti21) + ti0;
    t16_7.y = float(ti0);
    t16_8.y = (-t16_7.y);
    t16_8.xz = vec2(1.0, -1.0);
    t2.xyz = t10.yzx * t16_8.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t3.xyz = t16_7.xyz * t10.zyx + (-t2.xyz);
    t11.xyz = t11.xxx * t3.xyz + t2.xyz;
    t11.xyz = (-t16_7.xxy) * t10.xyz + t11.xyz;
    t0.xyz = t10.xyz * t16_7.xxy;
    t0.xyz = t1.xxx * t11.xyz + t0.xyz;
    t16_15.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_15.xy = t16_15.xy / abs(t0.xx);
    t16_15.xy = t16_15.xy + vec2(0.5, 0.5);
    t0.xy = t16_15.xy * vec2(_CityOverlayDetailScale);
    t20.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t20.y), abs(t20.x));
    t20.x = min(abs(t20.y), abs(t20.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t20.x);
    t1.y = dFdy(t20.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_15.x = t16_5.x * t10_3.w;
    t16_5.x = t16_5.x * t10_0.w;
    t16_7.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_25 = dot(t10_6.xyz, t10_6.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_8.xyz = vec3(t16_25) * t10_6.xyz;
    t16_25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_9.xyz = vec3(t16_25) * vs_TEXCOORD5.xyz;
    t16_25 = dot(t16_8.xyz, t16_9.xyz);
    vec3 txVec14 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_35 = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec14, 0.0);
    t16_37 = (-_LightShadowData.x) + 1.0;
    t16_35 = t16_35 * t16_37 + _LightShadowData.x;
    t16_25 = dot(vec2(t16_35), vec2(t16_25));
    t30 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t30 = inversesqrt(t30);
    t1.xyz = vec3(float(t30) * _SunDir.xxyz.y, float(t30) * _SunDir.xxyz.z, float(t30) * float(_SunDir.z));
    t16_35 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_37 = t16_35 + 1.00999999;
    t16_35 = t16_35 * -10.0;
    t16_35 = clamp(t16_35, 0.0, 1.0);
    t16_37 = floor(t16_37);
    t16_37 = clamp(t16_37, 0.0, 1.0);
    t16_37 = t16_37 + -1.0;
    t16_35 = t16_35 * t16_37 + 1.0;
    t16_25 = t16_35 * t16_25;
    t16_25 = clamp(t16_25, 0.0, 1.0);
    t16_25 = (-t16_25) + 1.0;
    t16_35 = t16_15.x * t16_25 + (-t16_5.x);
    t16_15.x = t16_25 * t16_15.x;
    t16_1.w = t16_15.x * t16_35 + t16_5.x;
    t16_1.xyz = t16_15.xxx * t16_7.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 28 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 240
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Matrix 160 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 224 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  half4 tmpvar_2;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = _mtl_u._SunDir;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_7;
  tmpvar_7 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_8;
  float3 tmpvar_9;
  tmpvar_8 = _mtl_i._glesTANGENT.xyz;
  tmpvar_9 = (((tmpvar_6.yzx * tmpvar_7.zxy) - (tmpvar_6.zxy * tmpvar_7.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_10;
  tmpvar_10[0].x = tmpvar_8.x;
  tmpvar_10[0].y = tmpvar_9.x;
  tmpvar_10[0].z = _mtl_i._glesNormal.x;
  tmpvar_10[1].x = tmpvar_8.y;
  tmpvar_10[1].y = tmpvar_9.y;
  tmpvar_10[1].z = _mtl_i._glesNormal.y;
  tmpvar_10[2].x = tmpvar_8.z;
  tmpvar_10[2].y = tmpvar_9.z;
  tmpvar_10[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _mtl_u._WorldSpaceCameraPos;
  float4 o_12;
  float4 tmpvar_13;
  tmpvar_13 = (tmpvar_1 * 0.5);
  float2 tmpvar_14;
  tmpvar_14.x = tmpvar_13.x;
  tmpvar_14.y = (tmpvar_13.y * _mtl_u._ProjectionParams.x);
  o_12.xy = (tmpvar_14 + tmpvar_13.w);
  o_12.zw = tmpvar_1.zw;
  tmpvar_2 = half4(o_12);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_10 * (
    (_mtl_u._World2Object * tmpvar_11)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_4).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_10 * (_mtl_u._World2Object * tmpvar_5).xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_2;
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 306 math, 6 textures, 9 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform sampler2D _CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_28;
  highp float tmpvar_29;
  highp float tmpvar_30;
  tmpvar_30 = (min (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0) / max (abs(
    (tmpvar_27.x / tmpvar_27.z)
  ), 1.0));
  highp float tmpvar_31;
  tmpvar_31 = (tmpvar_30 * tmpvar_30);
  tmpvar_31 = (((
    ((((
      ((((-0.01213232 * tmpvar_31) + 0.05368138) * tmpvar_31) - 0.1173503)
     * tmpvar_31) + 0.1938925) * tmpvar_31) - 0.3326756)
   * tmpvar_31) + 0.9999793) * tmpvar_30);
  tmpvar_31 = (tmpvar_31 + (float(
    (abs((tmpvar_27.x / tmpvar_27.z)) > 1.0)
  ) * (
    (tmpvar_31 * -2.0)
   + 1.570796)));
  tmpvar_29 = (tmpvar_31 * sign((tmpvar_27.x / tmpvar_27.z)));
  if ((abs(tmpvar_27.z) > (1e-08 * abs(tmpvar_27.x)))) {
    if ((tmpvar_27.z < 0.0)) {
      if ((tmpvar_27.x >= 0.0)) {
        tmpvar_29 += 3.141593;
      } else {
        tmpvar_29 = (tmpvar_29 - 3.141593);
      };
    };
  } else {
    tmpvar_29 = (sign(tmpvar_27.x) * 1.570796);
  };
  uv_28.x = (0.5 + (0.1591549 * tmpvar_29));
  uv_28.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_27.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_27.y)
    )) * (1.570796 + (
      abs(tmpvar_27.y)
     * 
      (-0.2146018 + (abs(tmpvar_27.y) * (0.08656672 + (
        abs(tmpvar_27.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_32;
  uvCont_32.y = uv_28.y;
  uvCont_32.x = abs((uv_28.x - 0.5));
  highp vec4 tmpvar_33;
  tmpvar_33.xy = dFdx(uvCont_32);
  tmpvar_33.zw = dFdy(uvCont_32);
  lowp vec4 tmpvar_34;
  tmpvar_34 = texture2DGradEXT (_CityOverlayTex, uv_28, tmpvar_33.xy, tmpvar_33.zw);
  mediump vec4 tmpvar_35;
  tmpvar_35 = tmpvar_34;
  mediump float tmpvar_36;
  mediump vec4 v_37;
  v_37 = (tmpvar_35 * alphaMask1);
  tmpvar_36 = ((v_37.x + v_37.y) + (v_37.z + v_37.w));
  mediump vec4 tmpvar_38;
  tmpvar_38.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_38.w = tmpvar_36;
  cityoverlay_4.xyz = tmpvar_38.xyz;
  mediump vec2 uv_39;
  mediump vec3 detailCoords_40;
  mediump float s_41;
  mediump float nylerp_42;
  mediump float zxlerp_43;
  highp vec3 tmpvar_44;
  tmpvar_44 = normalize(xlv_TEXCOORD2);
  highp vec3 tmpvar_45;
  tmpvar_45 = abs(tmpvar_44);
  highp float tmpvar_46;
  tmpvar_46 = float((tmpvar_45.z >= tmpvar_45.x));
  zxlerp_43 = tmpvar_46;
  highp float tmpvar_47;
  tmpvar_47 = float((max (tmpvar_45.x, tmpvar_45.z) >= tmpvar_45.y));
  nylerp_42 = tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_43);
  s_41 = tmpvar_48;
  highp float tmpvar_49;
  tmpvar_49 = sign(mix (tmpvar_44.y, s_41, nylerp_42));
  s_41 = tmpvar_49;
  mediump vec3 tmpvar_50;
  tmpvar_50.xz = vec2(1.0, -1.0);
  tmpvar_50.y = -(s_41);
  mediump vec3 tmpvar_51;
  tmpvar_51.xz = vec2(1.0, -1.0);
  tmpvar_51.y = s_41;
  highp vec3 tmpvar_52;
  tmpvar_52 = mix ((tmpvar_50 * tmpvar_44.xzy), (tmpvar_51 * tmpvar_44.zxy), vec3(zxlerp_43));
  detailCoords_40 = tmpvar_52;
  mediump vec3 tmpvar_53;
  tmpvar_53.xy = vec2(1.0, 1.0);
  tmpvar_53.z = s_41;
  highp vec3 tmpvar_54;
  tmpvar_54 = mix ((tmpvar_53 * tmpvar_44.yxz), detailCoords_40, vec3(nylerp_42));
  detailCoords_40 = tmpvar_54;
  uv_39 = (((
    (0.5 * detailCoords_40.yz)
   / 
    abs(detailCoords_40.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_55;
  uv_55 = uv_39;
  highp vec2 uvCont_56;
  highp vec2 tmpvar_57;
  highp float tmpvar_58;
  tmpvar_58 = (0.5 * _CityOverlayDetailScale);
  tmpvar_57 = abs((uv_55 - tmpvar_58));
  uvCont_56.x = max (tmpvar_57.x, tmpvar_57.y);
  uvCont_56.y = min (tmpvar_57.x, tmpvar_57.y);
  highp vec4 tmpvar_59;
  tmpvar_59.xy = dFdx(uvCont_56);
  tmpvar_59.zw = dFdy(uvCont_56);
  lowp vec4 tmpvar_60;
  tmpvar_60 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_39, tmpvar_59.xy, tmpvar_59.zw);
  mediump vec4 tmpvar_61;
  tmpvar_61 = tmpvar_60;
  citydarkoverlaydetail_3.xyz = tmpvar_61.xyz;
  mediump vec2 uv_62;
  mediump vec3 detailCoords_63;
  mediump float s_64;
  mediump float nylerp_65;
  mediump float zxlerp_66;
  highp vec3 tmpvar_67;
  tmpvar_67 = abs(tmpvar_44);
  highp float tmpvar_68;
  tmpvar_68 = float((tmpvar_67.z >= tmpvar_67.x));
  zxlerp_66 = tmpvar_68;
  highp float tmpvar_69;
  tmpvar_69 = float((max (tmpvar_67.x, tmpvar_67.z) >= tmpvar_67.y));
  nylerp_65 = tmpvar_69;
  highp float tmpvar_70;
  tmpvar_70 = mix (tmpvar_44.x, tmpvar_44.z, zxlerp_66);
  s_64 = tmpvar_70;
  highp float tmpvar_71;
  tmpvar_71 = sign(mix (tmpvar_44.y, s_64, nylerp_65));
  s_64 = tmpvar_71;
  mediump vec3 tmpvar_72;
  tmpvar_72.xz = vec2(1.0, -1.0);
  tmpvar_72.y = -(s_64);
  mediump vec3 tmpvar_73;
  tmpvar_73.xz = vec2(1.0, -1.0);
  tmpvar_73.y = s_64;
  highp vec3 tmpvar_74;
  tmpvar_74 = mix ((tmpvar_72 * tmpvar_44.xzy), (tmpvar_73 * tmpvar_44.zxy), vec3(zxlerp_66));
  detailCoords_63 = tmpvar_74;
  mediump vec3 tmpvar_75;
  tmpvar_75.xy = vec2(1.0, 1.0);
  tmpvar_75.z = s_64;
  highp vec3 tmpvar_76;
  tmpvar_76 = mix ((tmpvar_75 * tmpvar_44.yxz), detailCoords_63, vec3(nylerp_65));
  detailCoords_63 = tmpvar_76;
  uv_62 = (((
    (0.5 * detailCoords_63.yz)
   / 
    abs(detailCoords_63.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_77;
  uv_77 = uv_62;
  highp vec2 uvCont_78;
  highp vec2 tmpvar_79;
  tmpvar_79 = abs((uv_77 - tmpvar_58));
  uvCont_78.x = max (tmpvar_79.x, tmpvar_79.y);
  uvCont_78.y = min (tmpvar_79.x, tmpvar_79.y);
  highp vec4 tmpvar_80;
  tmpvar_80.xy = dFdx(uvCont_78);
  tmpvar_80.zw = dFdy(uvCont_78);
  lowp vec4 tmpvar_81;
  tmpvar_81 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_62, tmpvar_80.xy, tmpvar_80.zw);
  mediump vec4 tmpvar_82;
  tmpvar_82 = tmpvar_81;
  citylightoverlaydetail_2.xyz = tmpvar_82.xyz;
  cityoverlay_4.w = (tmpvar_36 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_61.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_82.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_82.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float shadow_83;
  shadow_83 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_84;
  lightDir_84 = xlv_TEXCOORD5;
  mediump vec3 viewDir_85;
  viewDir_85 = xlv_TEXCOORD1;
  mediump float atten_86;
  atten_86 = shadow_83;
  mediump vec4 c_87;
  mediump vec3 tmpvar_88;
  tmpvar_88 = normalize(lightDir_84);
  lightDir_84 = tmpvar_88;
  mediump vec3 tmpvar_89;
  tmpvar_89 = normalize(viewDir_85);
  viewDir_85 = tmpvar_89;
  mediump vec3 tmpvar_90;
  tmpvar_90 = normalize(normT_5);
  mediump float tmpvar_91;
  tmpvar_91 = dot (tmpvar_90, tmpvar_88);
  highp float tmpvar_92;
  mediump float tmpvar_93;
  tmpvar_93 = clamp (dot (normalize(
    (tmpvar_88 + tmpvar_89)
  ), tmpvar_90), 0.0, 1.0);
  tmpvar_92 = tmpvar_93;
  highp float tmpvar_94;
  tmpvar_94 = (pow (tmpvar_92, _SpecularPower) * _SpecularColor.w);
  c_87.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_91) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_94)) * (atten_86 * 2.0));
  c_87.w = (tmpvar_91 * (atten_86 * 2.0));
  highp vec3 tmpvar_95;
  tmpvar_95 = normalize(_SunDir);
  mediump vec3 lightDir_96;
  lightDir_96 = tmpvar_95;
  mediump vec3 normal_97;
  normal_97 = xlv_TEXCOORD3;
  mediump float tmpvar_98;
  tmpvar_98 = dot (normal_97, lightDir_96);
  color_6 = (c_87 * mix (1.0, clamp (
    floor((1.01 + tmpvar_98))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_98))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_99;
  tmpvar_99 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_99;
  tmpvar_1 = tmpvar_99;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1 = t0.yyyy * unity_World2Shadow[0][1];
    t1 = unity_World2Shadow[0][0] * t0.xxxx + t1;
    t1 = unity_World2Shadow[0][2] * t0.zzzz + t1;
    t0 = unity_World2Shadow[0][3] * t0.wwww + t1;
    vs_TEXCOORD6 = t0;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp sampler2D _CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec4 t10_4;
mediump vec2 t16_5;
lowp vec3 t10_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
mediump vec3 t16_9;
highp vec3 t10;
highp vec3 t11;
highp int ti11;
bvec2 tb11;
mediump vec2 t16_15;
highp vec2 t20;
highp float t21;
lowp float t10_21;
highp int ti21;
highp float t22;
mediump float t16_25;
highp float t30;
highp float t31;
bool tb31;
highp float t32;
mediump float t16_35;
mediump float t16_37;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t10.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t10.z), abs(t10.y));
    t1.x = float(1.0) / t1.x;
    t11.x = min(abs(t10.z), abs(t10.y));
    t1.x = t1.x * t11.x;
    t11.x = t1.x * t1.x;
    t21 = t11.x * 0.0208350997 + -0.0851330012;
    t21 = t11.x * t21 + 0.180141002;
    t21 = t11.x * t21 + -0.330299497;
    t11.x = t11.x * t21 + 0.999866009;
    t21 = t11.x * t1.x;
    t21 = t21 * -2.0 + 1.57079637;
    tb31 = abs(t10.z)<abs(t10.y);
    t21 = tb31 ? t21 : float(0.0);
    t1.x = t1.x * t11.x + t21;
    tb11.xy = lessThan(t10.zxzz, (-t10.zxzz)).xy;
    t11.x = tb11.x ? -3.14159274 : float(0.0);
    t1.x = t11.x + t1.x;
    t11.x = min(t10.z, t10.y);
    tb11.x = t11.x<(-t11.x);
    t31 = max(t10.z, t10.y);
    tb31 = t31>=(-t31);
    ti11 = int(uint(tb31) * 0xffffffffu & uint(tb11.x) * 0xffffffffu);
    t1.x = (ti11 != 0) ? (-t1.x) : t1.x;
    t11.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t11.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t31 = abs(t10.x) * -0.0187292993 + 0.0742610022;
    t31 = t31 * abs(t10.x) + -0.212114394;
    t31 = t31 * abs(t10.x) + 1.57072878;
    t22 = -abs(t10.x) + 1.0;
    t22 = sqrt(t22);
    t32 = t31 * t22;
    t32 = t32 * -2.0 + 3.14159274;
    t21 = tb11.y ? t32 : float(0.0);
    t21 = t31 * t22 + t21;
    t2.y = t21 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_CityOverlayTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t16_5.xy = t10_4.xy * alphaMask1.xy;
    t16_5.x = t16_5.y + t16_5.x;
    t16_5.x = t10_4.z * alphaMask1.z + t16_5.x;
    t16_5.x = t10_4.w * alphaMask1.w + t16_5.x;
    t10_21 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_6.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_21>=1.0;
    t16_15.x = (tb1) ? 0.0 : 1.0;
    t16_5.x = t16_15.x * t16_5.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t10.y);
    tb11.x = abs(t10.z)>=abs(t10.y);
    t11.x = tb11.x ? 1.0 : float(0.0);
    t1.x = t11.x * t1.x + t10.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t10.z), abs(t10.y));
    tb1 = t1.x>=abs(t10.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t10.x;
    ti21 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti21) + ti0;
    t16_7.y = float(ti0);
    t16_8.y = (-t16_7.y);
    t16_8.xz = vec2(1.0, -1.0);
    t2.xyz = t10.yzx * t16_8.xyz;
    t16_7.xz = vec2(1.0, -1.0);
    t3.xyz = t16_7.xyz * t10.zyx + (-t2.xyz);
    t11.xyz = t11.xxx * t3.xyz + t2.xyz;
    t11.xyz = (-t16_7.xxy) * t10.xyz + t11.xyz;
    t0.xyz = t10.xyz * t16_7.xxy;
    t0.xyz = t1.xxx * t11.xyz + t0.xyz;
    t16_15.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_15.xy = t16_15.xy / abs(t0.xx);
    t16_15.xy = t16_15.xy + vec2(0.5, 0.5);
    t0.xy = t16_15.xy * vec2(_CityOverlayDetailScale);
    t20.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t20.y), abs(t20.x));
    t20.x = min(abs(t20.y), abs(t20.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t20.x);
    t1.y = dFdy(t20.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_15.x = t16_5.x * t10_3.w;
    t16_5.x = t16_5.x * t10_0.w;
    t16_7.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_25 = dot(t10_6.xyz, t10_6.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_8.xyz = vec3(t16_25) * t10_6.xyz;
    t16_25 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_25 = inversesqrt(t16_25);
    t16_9.xyz = vec3(t16_25) * vs_TEXCOORD5.xyz;
    t16_25 = dot(t16_8.xyz, t16_9.xyz);
    vec3 txVec22 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_35 = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec22, 0.0);
    t16_37 = (-_LightShadowData.x) + 1.0;
    t16_35 = t16_35 * t16_37 + _LightShadowData.x;
    t16_25 = dot(vec2(t16_35), vec2(t16_25));
    t30 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t30 = inversesqrt(t30);
    t1.xyz = vec3(float(t30) * _SunDir.xxyz.y, float(t30) * _SunDir.xxyz.z, float(t30) * float(_SunDir.z));
    t16_35 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_37 = t16_35 + 1.00999999;
    t16_35 = t16_35 * -10.0;
    t16_35 = clamp(t16_35, 0.0, 1.0);
    t16_37 = floor(t16_37);
    t16_37 = clamp(t16_37, 0.0, 1.0);
    t16_37 = t16_37 + -1.0;
    t16_35 = t16_35 * t16_37 + 1.0;
    t16_25 = t16_35 * t16_25;
    t16_25 = clamp(t16_25, 0.0, 1.0);
    t16_25 = (-t16_25) + 1.0;
    t16_35 = t16_15.x * t16_25 + (-t16_5.x);
    t16_15.x = t16_25 * t16_15.x;
    t16_1.w = t16_15.x * t16_35 + t16_5.x;
    t16_1.xyz = t16_15.xxx * t16_7.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 28 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "MAP_TYPE_1" "ALPHAMAP_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 240
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Matrix 160 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 224 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  half4 tmpvar_2;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = _mtl_u._SunDir;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_7;
  tmpvar_7 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_8;
  float3 tmpvar_9;
  tmpvar_8 = _mtl_i._glesTANGENT.xyz;
  tmpvar_9 = (((tmpvar_6.yzx * tmpvar_7.zxy) - (tmpvar_6.zxy * tmpvar_7.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_10;
  tmpvar_10[0].x = tmpvar_8.x;
  tmpvar_10[0].y = tmpvar_9.x;
  tmpvar_10[0].z = _mtl_i._glesNormal.x;
  tmpvar_10[1].x = tmpvar_8.y;
  tmpvar_10[1].y = tmpvar_9.y;
  tmpvar_10[1].z = _mtl_i._glesNormal.y;
  tmpvar_10[2].x = tmpvar_8.z;
  tmpvar_10[2].y = tmpvar_9.z;
  tmpvar_10[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _mtl_u._WorldSpaceCameraPos;
  float4 o_12;
  float4 tmpvar_13;
  tmpvar_13 = (tmpvar_1 * 0.5);
  float2 tmpvar_14;
  tmpvar_14.x = tmpvar_13.x;
  tmpvar_14.y = (tmpvar_13.y * _mtl_u._ProjectionParams.x);
  o_12.xy = (tmpvar_14 + tmpvar_13.w);
  o_12.zw = tmpvar_1.zw;
  tmpvar_2 = half4(o_12);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_10 * (
    (_mtl_u._World2Object * tmpvar_11)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_4).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_10 * (_mtl_u._World2Object * tmpvar_5).xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_2;
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 235 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec4 tmpvar_21;
  vec3 tmpvar_22;
  tmpvar_22 = normalize(xlv_TEXCOORD2);
  tmpvar_21 = textureCube (cube_CityOverlayTex, tmpvar_22);
  cityoverlay_3.xyz = tmpvar_21.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_22);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_22.yxz), mix ((tmpvar_28 * tmpvar_22.xzy), (tmpvar_29 * tmpvar_22.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_23 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  vec4 tmpvar_36;
  tmpvar_36 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_23, tmpvar_35.xy, tmpvar_35.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_36.xyz;
  vec2 uv_37;
  vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_22);
  float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  float tmpvar_41;
  tmpvar_41 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_39), tmpvar_40));
  vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = -(tmpvar_41);
  vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = tmpvar_41;
  vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = tmpvar_41;
  vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_22.yxz), mix ((tmpvar_42 * tmpvar_22.xzy), (tmpvar_43 * tmpvar_22.zxy), vec3(tmpvar_39)), vec3(tmpvar_40));
  uv_37 = (((
    (0.5 * tmpvar_45.yz)
   / 
    abs(tmpvar_45.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_46;
  vec2 tmpvar_47;
  tmpvar_47 = abs((uv_37 - tmpvar_34));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  vec4 tmpvar_48;
  tmpvar_48.xy = dFdx(uvCont_46);
  tmpvar_48.zw = dFdy(uvCont_46);
  vec4 tmpvar_49;
  tmpvar_49 = texture2DGradARB (_CityLightOverlayDetailTex, uv_37, tmpvar_48.xy, tmpvar_48.zw);
  citylightoverlaydetail_1.xyz = tmpvar_49.xyz;
  cityoverlay_3.w = (tmpvar_21.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_36.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_49.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_49.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_50;
  vec3 tmpvar_51;
  tmpvar_51 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_52;
  tmpvar_52 = normalize(normal_20);
  float tmpvar_53;
  tmpvar_53 = dot (tmpvar_52, tmpvar_51);
  c_50.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_53) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_51 + normalize(xlv_TEXCOORD1)))
    , tmpvar_52), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_50.w = (tmpvar_53 * 2.0);
  float tmpvar_54;
  tmpvar_54 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_50 * mix (1.0, clamp (
    floor((1.01 + tmpvar_54))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_54))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_55;
  tmpvar_55 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_55;
  gl_FragData[0] = tmpvar_55;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa
eefiecedkdmflccgijkpncgpahgfjlmhfkmdhbmjabaaaaaaceaiaaaaadaaaaaa
cmaaaaaajmaaaaaafeabaaaaejfdeheogiaaaaaaadaaaaaaaiaaaaaafaaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaaaaaaaaaapapaaaafjaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaahahaaaagaaaaaaaaaaaaaaaaaaaaaaaadaaaaaaacaaaaaa
apapaaaafaepfdejfeejepeoaaeoepfcenebemaafeebeoehefeofeaaepfdeheo
laaaaaaaagaaaaaaaiaaaaaajiaaaaaaaaaaaaaaabaaaaaaadaaaaaaaaaaaaaa
apaaaaaakeaaaaaaaaaaaaaaaaaaaaaaadaaaaaaabaaaaaaabaoaaaakeaaaaaa
abaaaaaaaaaaaaaaadaaaaaaabaaaaaaaoabaaaakeaaaaaaacaaaaaaaaaaaaaa
adaaaaaaacaaaaaaahaiaaaakeaaaaaaadaaaaaaaaaaaaaaadaaaaaaadaaaaaa
ahaiaaaakeaaaaaaafaaaaaaaaaaaaaaadaaaaaaaeaaaaaaahaiaaaafdfgfpfa
epfdejfeejepeoaafeeffiedepepfceeaaklklklfdeieefcmiagaaaaeaaaabaa
lcabaaaafjaaaaaeegiocaaaaaaaaaaablaaaaaafjaaaaaeegiocaaaabaaaaaa
afaaaaaafjaaaaaeegiocaaaacaaaaaabeaaaaaafpaaaaadpcbabaaaaaaaaaaa
fpaaaaadhcbabaaaabaaaaaafpaaaaadpcbabaaaacaaaaaaghaaaaaepccabaaa
aaaaaaaaabaaaaaagfaaaaadbccabaaaabaaaaaagfaaaaadoccabaaaabaaaaaa
gfaaaaadhccabaaaacaaaaaagfaaaaadhccabaaaadaaaaaagfaaaaadhccabaaa
aeaaaaaagiaaaaacadaaaaaadiaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaa
egiocaaaacaaaaaaabaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaa
aaaaaaaaagbabaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaa
egiocaaaacaaaaaaacaaaaaakgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaak
pccabaaaaaaaaaaaegiocaaaacaaaaaaadaaaaaapgbpbaaaaaaaaaaaegaobaaa
aaaaaaaabaaaaaahbcaabaaaaaaaaaaaegbcbaaaabaaaaaaegbcbaaaabaaaaaa
eeaaaaafbcaabaaaaaaaaaaaakaabaaaaaaaaaaadiaaaaahhcaabaaaaaaaaaaa
agaabaaaaaaaaaaacgbjbaaaabaaaaaabaaaaaahicaabaaaaaaaaaaaegbcbaaa
acaaaaaaegbcbaaaacaaaaaaeeaaaaaficaabaaaaaaaaaaadkaabaaaaaaaaaaa
diaaaaahhcaabaaaabaaaaaapgapbaaaaaaaaaaajgbebaaaacaaaaaadiaaaaah
hcaabaaaacaaaaaaegacbaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
aaaaaaaacgajbaaaaaaaaaaajgaebaaaabaaaaaaegacbaiaebaaaaaaacaaaaaa
diaaaaahhcaabaaaaaaaaaaaegacbaaaaaaaaaaapgbpbaaaacaaaaaadiaaaaaj
hcaabaaaabaaaaaafgifcaaaabaaaaaaaeaaaaaaegiccaaaacaaaaaabbaaaaaa
dcaaaaalhcaabaaaabaaaaaaegiccaaaacaaaaaabaaaaaaaagiacaaaabaaaaaa
aeaaaaaaegacbaaaabaaaaaadcaaaaalhcaabaaaabaaaaaaegiccaaaacaaaaaa
bcaaaaaakgikcaaaabaaaaaaaeaaaaaaegacbaaaabaaaaaaaaaaaaaihcaabaaa
abaaaaaaegacbaaaabaaaaaaegiccaaaacaaaaaabdaaaaaaaaaaaaaihcaabaaa
abaaaaaaegacbaaaabaaaaaaegbcbaiaebaaaaaaaaaaaaaabaaaaaahecaabaaa
acaaaaaaegacbaaaaaaaaaaaegacbaaaabaaaaaabaaaaaahccaabaaaacaaaaaa
egbcbaaaacaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaaacaaaaaaegbcbaaa
abaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaaaaaaaaaajgahbaaaacaaaaaa
jgahbaaaacaaaaaaeeaaaaaficaabaaaaaaaaaaadkaabaaaaaaaaaaadiaaaaah
occabaaaabaaaaaapgapbaaaaaaaaaaafgaobaaaacaaaaaadiaaaaaihcaabaaa
abaaaaaafgbfbaaaaaaaaaaaegiccaaaacaaaaaaanaaaaaadcaaaaakhcaabaaa
abaaaaaaegiccaaaacaaaaaaamaaaaaaagbabaaaaaaaaaaaegacbaaaabaaaaaa
dcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaaoaaaaaakgbkbaaaaaaaaaaa
egacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaapaaaaaa
pgbpbaaaaaaaaaaaegacbaaaabaaaaaaaaaaaaajhcaabaaaabaaaaaaegacbaaa
abaaaaaaegiccaiaebaaaaaaabaaaaaaaeaaaaaabaaaaaahicaabaaaaaaaaaaa
egacbaaaabaaaaaaegacbaaaabaaaaaaelaaaaafbccabaaaabaaaaaadkaabaaa
aaaaaaaabbaaaaahicaabaaaaaaaaaaaegbobaaaaaaaaaaaegbobaaaaaaaaaaa
eeaaaaaficaabaaaaaaaaaaadkaabaaaaaaaaaaadiaaaaahhcaabaaaabaaaaaa
pgapbaaaaaaaaaaaegbcbaaaaaaaaaaadgaaaaaghccabaaaacaaaaaaegacbaia
ebaaaaaaabaaaaaadiaaaaaihcaabaaaabaaaaaafgbfbaaaabaaaaaaegiccaaa
acaaaaaaanaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaamaaaaaa
agbabaaaabaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaa
acaaaaaaaoaaaaaakgbkbaaaabaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaa
aaaaaaaaegacbaaaabaaaaaaegacbaaaabaaaaaaeeaaaaaficaabaaaaaaaaaaa
dkaabaaaaaaaaaaadiaaaaahhccabaaaadaaaaaapgapbaaaaaaaaaaaegacbaaa
abaaaaaadiaaaaajhcaabaaaabaaaaaakgikcaaaaaaaaaaabkaaaaaaegiccaaa
acaaaaaabbaaaaaadcaaaaalhcaabaaaabaaaaaaegiccaaaacaaaaaabaaaaaaa
fgifcaaaaaaaaaaabkaaaaaaegacbaaaabaaaaaadcaaaaalhcaabaaaabaaaaaa
egiccaaaacaaaaaabcaaaaaapgipcaaaaaaaaaaabkaaaaaaegacbaaaabaaaaaa
baaaaaahccaabaaaaaaaaaaaegacbaaaaaaaaaaaegacbaaaabaaaaaabaaaaaah
bcaabaaaaaaaaaaaegbcbaaaacaaaaaaegacbaaaabaaaaaabaaaaaahecaabaaa
aaaaaaaaegbcbaaaabaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaaaaaaaaaa
egacbaaaaaaaaaaaegacbaaaaaaaaaaaeeaaaaaficaabaaaaaaaaaaadkaabaaa
aaaaaaaadiaaaaahhccabaaaaeaaaaaapgapbaaaaaaaaaaaegacbaaaaaaaaaaa
doaaaaab"
}
SubProgram "gles " {
// Stats: 231 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  cityoverlay_4.xyz = tmpvar_29.xyz;
  mediump vec2 uv_30;
  mediump vec3 detailCoords_31;
  mediump float s_32;
  mediump float nylerp_33;
  mediump float zxlerp_34;
  highp vec3 tmpvar_35;
  tmpvar_35 = abs(tmpvar_27);
  highp float tmpvar_36;
  tmpvar_36 = float((tmpvar_35.z >= tmpvar_35.x));
  zxlerp_34 = tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = float((max (tmpvar_35.x, tmpvar_35.z) >= tmpvar_35.y));
  nylerp_33 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_34);
  s_32 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_27.y, s_32, nylerp_33));
  s_32 = tmpvar_39;
  mediump vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(s_32);
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = s_32;
  highp vec3 tmpvar_42;
  tmpvar_42 = mix ((tmpvar_40 * tmpvar_27.xzy), (tmpvar_41 * tmpvar_27.zxy), vec3(zxlerp_34));
  detailCoords_31 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xy = vec2(1.0, 1.0);
  tmpvar_43.z = s_32;
  highp vec3 tmpvar_44;
  tmpvar_44 = mix ((tmpvar_43 * tmpvar_27.yxz), detailCoords_31, vec3(nylerp_33));
  detailCoords_31 = tmpvar_44;
  uv_30 = (((
    (0.5 * detailCoords_31.yz)
   / 
    abs(detailCoords_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_45;
  uv_45 = uv_30;
  highp vec2 uvCont_46;
  highp vec2 tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = (0.5 * _CityOverlayDetailScale);
  tmpvar_47 = abs((uv_45 - tmpvar_48));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_46);
  tmpvar_49.zw = dFdy(uvCont_46);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_30, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citydarkoverlaydetail_3.xyz = tmpvar_51.xyz;
  mediump vec2 uv_52;
  mediump vec3 detailCoords_53;
  mediump float s_54;
  mediump float nylerp_55;
  mediump float zxlerp_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = abs(tmpvar_27);
  highp float tmpvar_58;
  tmpvar_58 = float((tmpvar_57.z >= tmpvar_57.x));
  zxlerp_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = float((max (tmpvar_57.x, tmpvar_57.z) >= tmpvar_57.y));
  nylerp_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_56);
  s_54 = tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = sign(mix (tmpvar_27.y, s_54, nylerp_55));
  s_54 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62.xz = vec2(1.0, -1.0);
  tmpvar_62.y = -(s_54);
  mediump vec3 tmpvar_63;
  tmpvar_63.xz = vec2(1.0, -1.0);
  tmpvar_63.y = s_54;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix ((tmpvar_62 * tmpvar_27.xzy), (tmpvar_63 * tmpvar_27.zxy), vec3(zxlerp_56));
  detailCoords_53 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xy = vec2(1.0, 1.0);
  tmpvar_65.z = s_54;
  highp vec3 tmpvar_66;
  tmpvar_66 = mix ((tmpvar_65 * tmpvar_27.yxz), detailCoords_53, vec3(nylerp_55));
  detailCoords_53 = tmpvar_66;
  uv_52 = (((
    (0.5 * detailCoords_53.yz)
   / 
    abs(detailCoords_53.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_67;
  uv_67 = uv_52;
  highp vec2 uvCont_68;
  highp vec2 tmpvar_69;
  tmpvar_69 = abs((uv_67 - tmpvar_48));
  uvCont_68.x = max (tmpvar_69.x, tmpvar_69.y);
  uvCont_68.y = min (tmpvar_69.x, tmpvar_69.y);
  highp vec4 tmpvar_70;
  tmpvar_70.xy = dFdx(uvCont_68);
  tmpvar_70.zw = dFdy(uvCont_68);
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_52, tmpvar_70.xy, tmpvar_70.zw);
  mediump vec4 tmpvar_72;
  tmpvar_72 = tmpvar_71;
  citylightoverlaydetail_2.xyz = tmpvar_72.xyz;
  cityoverlay_4.w = (tmpvar_29.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_51.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_72.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_72.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_73;
  lightDir_73 = xlv_TEXCOORD5;
  mediump vec3 viewDir_74;
  viewDir_74 = xlv_TEXCOORD1;
  mediump vec4 c_75;
  mediump vec3 tmpvar_76;
  tmpvar_76 = normalize(lightDir_73);
  lightDir_73 = tmpvar_76;
  mediump vec3 tmpvar_77;
  tmpvar_77 = normalize(viewDir_74);
  viewDir_74 = tmpvar_77;
  mediump vec3 tmpvar_78;
  tmpvar_78 = normalize(normT_5);
  mediump float tmpvar_79;
  tmpvar_79 = dot (tmpvar_78, tmpvar_76);
  highp float tmpvar_80;
  mediump float tmpvar_81;
  tmpvar_81 = clamp (dot (normalize(
    (tmpvar_76 + tmpvar_77)
  ), tmpvar_78), 0.0, 1.0);
  tmpvar_80 = tmpvar_81;
  highp float tmpvar_82;
  tmpvar_82 = (pow (tmpvar_80, _SpecularPower) * _SpecularColor.w);
  c_75.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_79) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_82)) * 2.0);
  c_75.w = (tmpvar_79 * 2.0);
  highp vec3 tmpvar_83;
  tmpvar_83 = normalize(_SunDir);
  mediump vec3 lightDir_84;
  lightDir_84 = tmpvar_83;
  mediump vec3 normal_85;
  normal_85 = xlv_TEXCOORD3;
  mediump float tmpvar_86;
  tmpvar_86 = dot (normal_85, lightDir_84);
  color_6 = (c_75 * mix (1.0, clamp (
    floor((1.01 + tmpvar_86))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_86))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_87;
  tmpvar_87 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_87;
  tmpvar_1 = tmpvar_87;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec3 t10_4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_14;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
highp float t20;
mediump float t16_23;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_32;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_4.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_19>=1.0;
    t16_5 = (tb1) ? 0.0 : 1.0;
    t10_1.x = texture(cube_CityOverlayTex, t9.yxz).w;
    t16_5 = t16_5 * t10_1.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_14.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t0.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t0.xy = t16_14.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_14.x = t16_5 * t10_3.w;
    t16_5 = t16_5 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_23 = dot(t10_4.xyz, t10_4.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_7.xyz = t10_4.xyz * vec3(t16_23);
    t16_23 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_8.xyz = vec3(t16_23) * vs_TEXCOORD5.xyz;
    t16_23 = dot(t16_7.xyz, t16_8.xyz);
    t16_23 = t16_23 + t16_23;
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_32 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_32 + 1.00999999;
    t16_32 = t16_32 * -10.0;
    t16_32 = clamp(t16_32, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_32 = t16_32 * t16_33 + 1.0;
    t16_23 = t16_32 * t16_23;
    t16_23 = clamp(t16_23, 0.0, 1.0);
    t16_23 = (-t16_23) + 1.0;
    t16_32 = t16_14.x * t16_23 + (-t16_5);
    t16_14.x = t16_23 * t16_14.x;
    t16_1.w = t16_14.x * t16_32 + t16_5;
    t16_1.xyz = t16_14.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
lowp vec4 t10_1;
vec2 t2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
vec4 t4;
lowp vec4 t10_4;
vec3 t5;
vec3 t6;
vec3 t7;
int ti7;
bvec2 tb7;
vec3 t8;
bool tb8;
vec2 t12;
float t13;
float t14;
int ti14;
float t19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7.x = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7.x;
    t7.x = t1.x * t1.x;
    t13 = t7.x * 0.0208350997 + -0.0851330012;
    t13 = t7.x * t13 + 0.180141002;
    t13 = t7.x * t13 + -0.330299497;
    t7.x = t7.x * t13 + 0.999866009;
    t13 = t7.x * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7.x + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7.x = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7.x + t1.x;
    t7.x = min(t6.z, t6.y);
    tb7.x = t7.x<(-t7.x);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_1 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t1.xy = t10_1.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb19 = t10_4.w>=1.0;
    t19 = (tb19) ? 0.0 : 1.0;
    t10_2 = texture(cube_CityOverlayTex, t6.yxz);
    t19 = t19 * t10_2.w;
    t2.x = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb8 = abs(t6.z)>=abs(t6.y);
    t8.x = tb8 ? 1.0 : float(0.0);
    t2.x = t8.x * t2.x + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t2.x;
    t2.x = max(abs(t6.z), abs(t6.y));
    tb2 = t2.x>=abs(t6.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t0.x = t2.x * t0.x + t6.x;
    ti14 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti14) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t8.xyz = t8.xxx * t5.xyz + t4.xyz;
    t8.xyz = (-t3.xxy) * t6.xyz + t8.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t2.x = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t12.x);
    t2.y = dFdy(t12.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t2.x = t19 * t4.w;
    t0.w = t19 * t0.w;
    t19 = dot(t1.xy, t1.xy);
    t19 = min(t19, 1.0);
    t19 = (-t19) + 1.0;
    t1.z = sqrt(t19);
    t19 = dot(t1.xyz, t1.xyz);
    t19 = inversesqrt(t19);
    t1.xyz = vec3(t19) * t1.xyz;
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t8.xyz = vec3(t19) * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xyz, t8.xyz);
    t1.x = t1.x + t1.x;
    t7.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t7.x = inversesqrt(t7.x);
    t7.xyz = t7.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t7.x = dot(vs_TEXCOORD3.xyz, t7.xyz);
    t13 = t7.x + 1.00999999;
    t7.x = t7.x * -10.0;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t13 = floor(t13);
    t13 = clamp(t13, 0.0, 1.0);
    t13 = t13 + -1.0;
    t7.x = t7.x * t13 + 1.0;
    t1.x = t7.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t4.w = t1.x * t2.x;
    t1 = (-t0) + t4;
    SV_Target0 = t4.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 237 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 tmpvar_1;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = gl_Normal;
  vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(gl_Normal);
  vec3 tmpvar_6;
  tmpvar_6 = normalize(TANGENT.xyz);
  vec3 tmpvar_7;
  vec3 tmpvar_8;
  tmpvar_7 = TANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * TANGENT.w);
  mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = gl_Normal.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = gl_Normal.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = gl_Normal.z;
  vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  vec4 o_11;
  vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_1 * 0.5);
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_12.x;
  tmpvar_13.y = (tmpvar_12.y * _ProjectionParams.x);
  o_11.xy = (tmpvar_13 + tmpvar_12.w);
  o_11.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
  xlv_TEXCOORD6 = o_11;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec4 tmpvar_21;
  vec3 tmpvar_22;
  tmpvar_22 = normalize(xlv_TEXCOORD2);
  tmpvar_21 = textureCube (cube_CityOverlayTex, tmpvar_22);
  cityoverlay_3.xyz = tmpvar_21.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_22);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_22.yxz), mix ((tmpvar_28 * tmpvar_22.xzy), (tmpvar_29 * tmpvar_22.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_23 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  vec4 tmpvar_36;
  tmpvar_36 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_23, tmpvar_35.xy, tmpvar_35.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_36.xyz;
  vec2 uv_37;
  vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_22);
  float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  float tmpvar_41;
  tmpvar_41 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_39), tmpvar_40));
  vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = -(tmpvar_41);
  vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = tmpvar_41;
  vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = tmpvar_41;
  vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_22.yxz), mix ((tmpvar_42 * tmpvar_22.xzy), (tmpvar_43 * tmpvar_22.zxy), vec3(tmpvar_39)), vec3(tmpvar_40));
  uv_37 = (((
    (0.5 * tmpvar_45.yz)
   / 
    abs(tmpvar_45.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_46;
  vec2 tmpvar_47;
  tmpvar_47 = abs((uv_37 - tmpvar_34));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  vec4 tmpvar_48;
  tmpvar_48.xy = dFdx(uvCont_46);
  tmpvar_48.zw = dFdy(uvCont_46);
  vec4 tmpvar_49;
  tmpvar_49 = texture2DGradARB (_CityLightOverlayDetailTex, uv_37, tmpvar_48.xy, tmpvar_48.zw);
  citylightoverlaydetail_1.xyz = tmpvar_49.xyz;
  cityoverlay_3.w = (tmpvar_21.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_36.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_49.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_49.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_50;
  tmpvar_50 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_51;
  vec3 tmpvar_52;
  tmpvar_52 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_53;
  tmpvar_53 = normalize(normal_20);
  float tmpvar_54;
  tmpvar_54 = dot (tmpvar_53, tmpvar_52);
  c_51.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_54) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_52 + normalize(xlv_TEXCOORD1)))
    , tmpvar_53), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_50.x * 2.0));
  c_51.w = (tmpvar_54 * (tmpvar_50.x * 2.0));
  float tmpvar_55;
  tmpvar_55 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_51 * mix (1.0, clamp (
    floor((1.01 + tmpvar_55))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_55))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_56;
  tmpvar_56 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_56;
  gl_FragData[0] = tmpvar_56;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 58 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_ProjectionParams]
Vector 12 [_ScreenParams]
Vector 13 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c14, 1, 0, 0.5, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c13
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c14
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r1.x, r0.y, c11.x
mul r1.w, r1.x, c14.z
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c14.z
mad o6.xy, r1.z, c12.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o6.zw, r0

"
}
SubProgram "d3d11 " {
// Stats: 53 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 237 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  cityoverlay_4.xyz = tmpvar_29.xyz;
  mediump vec2 uv_30;
  mediump vec3 detailCoords_31;
  mediump float s_32;
  mediump float nylerp_33;
  mediump float zxlerp_34;
  highp vec3 tmpvar_35;
  tmpvar_35 = abs(tmpvar_27);
  highp float tmpvar_36;
  tmpvar_36 = float((tmpvar_35.z >= tmpvar_35.x));
  zxlerp_34 = tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = float((max (tmpvar_35.x, tmpvar_35.z) >= tmpvar_35.y));
  nylerp_33 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_34);
  s_32 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_27.y, s_32, nylerp_33));
  s_32 = tmpvar_39;
  mediump vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(s_32);
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = s_32;
  highp vec3 tmpvar_42;
  tmpvar_42 = mix ((tmpvar_40 * tmpvar_27.xzy), (tmpvar_41 * tmpvar_27.zxy), vec3(zxlerp_34));
  detailCoords_31 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xy = vec2(1.0, 1.0);
  tmpvar_43.z = s_32;
  highp vec3 tmpvar_44;
  tmpvar_44 = mix ((tmpvar_43 * tmpvar_27.yxz), detailCoords_31, vec3(nylerp_33));
  detailCoords_31 = tmpvar_44;
  uv_30 = (((
    (0.5 * detailCoords_31.yz)
   / 
    abs(detailCoords_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_45;
  uv_45 = uv_30;
  highp vec2 uvCont_46;
  highp vec2 tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = (0.5 * _CityOverlayDetailScale);
  tmpvar_47 = abs((uv_45 - tmpvar_48));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_46);
  tmpvar_49.zw = dFdy(uvCont_46);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_30, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citydarkoverlaydetail_3.xyz = tmpvar_51.xyz;
  mediump vec2 uv_52;
  mediump vec3 detailCoords_53;
  mediump float s_54;
  mediump float nylerp_55;
  mediump float zxlerp_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = abs(tmpvar_27);
  highp float tmpvar_58;
  tmpvar_58 = float((tmpvar_57.z >= tmpvar_57.x));
  zxlerp_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = float((max (tmpvar_57.x, tmpvar_57.z) >= tmpvar_57.y));
  nylerp_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_56);
  s_54 = tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = sign(mix (tmpvar_27.y, s_54, nylerp_55));
  s_54 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62.xz = vec2(1.0, -1.0);
  tmpvar_62.y = -(s_54);
  mediump vec3 tmpvar_63;
  tmpvar_63.xz = vec2(1.0, -1.0);
  tmpvar_63.y = s_54;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix ((tmpvar_62 * tmpvar_27.xzy), (tmpvar_63 * tmpvar_27.zxy), vec3(zxlerp_56));
  detailCoords_53 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xy = vec2(1.0, 1.0);
  tmpvar_65.z = s_54;
  highp vec3 tmpvar_66;
  tmpvar_66 = mix ((tmpvar_65 * tmpvar_27.yxz), detailCoords_53, vec3(nylerp_55));
  detailCoords_53 = tmpvar_66;
  uv_52 = (((
    (0.5 * detailCoords_53.yz)
   / 
    abs(detailCoords_53.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_67;
  uv_67 = uv_52;
  highp vec2 uvCont_68;
  highp vec2 tmpvar_69;
  tmpvar_69 = abs((uv_67 - tmpvar_48));
  uvCont_68.x = max (tmpvar_69.x, tmpvar_69.y);
  uvCont_68.y = min (tmpvar_69.x, tmpvar_69.y);
  highp vec4 tmpvar_70;
  tmpvar_70.xy = dFdx(uvCont_68);
  tmpvar_70.zw = dFdy(uvCont_68);
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_52, tmpvar_70.xy, tmpvar_70.zw);
  mediump vec4 tmpvar_72;
  tmpvar_72 = tmpvar_71;
  citylightoverlaydetail_2.xyz = tmpvar_72.xyz;
  cityoverlay_4.w = (tmpvar_29.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_51.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_72.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_72.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_73 = tmpvar_74;
  mediump vec3 lightDir_75;
  lightDir_75 = xlv_TEXCOORD5;
  mediump vec3 viewDir_76;
  viewDir_76 = xlv_TEXCOORD1;
  mediump float atten_77;
  atten_77 = tmpvar_73;
  mediump vec4 c_78;
  mediump vec3 tmpvar_79;
  tmpvar_79 = normalize(lightDir_75);
  lightDir_75 = tmpvar_79;
  mediump vec3 tmpvar_80;
  tmpvar_80 = normalize(viewDir_76);
  viewDir_76 = tmpvar_80;
  mediump vec3 tmpvar_81;
  tmpvar_81 = normalize(normT_5);
  mediump float tmpvar_82;
  tmpvar_82 = dot (tmpvar_81, tmpvar_79);
  highp float tmpvar_83;
  mediump float tmpvar_84;
  tmpvar_84 = clamp (dot (normalize(
    (tmpvar_79 + tmpvar_80)
  ), tmpvar_81), 0.0, 1.0);
  tmpvar_83 = tmpvar_84;
  highp float tmpvar_85;
  tmpvar_85 = (pow (tmpvar_83, _SpecularPower) * _SpecularColor.w);
  c_78.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_82) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_85)) * (atten_77 * 2.0));
  c_78.w = (tmpvar_82 * (atten_77 * 2.0));
  highp vec3 tmpvar_86;
  tmpvar_86 = normalize(_SunDir);
  mediump vec3 lightDir_87;
  lightDir_87 = tmpvar_86;
  mediump vec3 normal_88;
  normal_88 = xlv_TEXCOORD3;
  mediump float tmpvar_89;
  tmpvar_89 = dot (normal_88, lightDir_87);
  color_6 = (c_78 * mix (1.0, clamp (
    floor((1.01 + tmpvar_89))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_89))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_90;
  tmpvar_90 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_90;
  tmpvar_1 = tmpvar_90;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
vec4 t0;
vec4 t1;
vec3 t2;
vec3 t3;
vec3 t7;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * in_NORMAL0.zxy;
    t13 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_TANGENT0.yzx;
    t3.xyz = t1.xyz * t2.xyz;
    t1.xyz = t1.zxy * t2.yzx + (-t3.xyz);
    t1.xyz = t1.xyz * in_TANGENT0.www;
    t2.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t2.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t2.xyz;
    t2.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t2.xyz;
    t2.xyz = t2.xyz + _World2Object[3].xyz;
    t2.xyz = t2.xyz + (-in_POSITION0.xyz);
    t7.y = dot(t1.xyz, t2.xyz);
    t7.x = dot(in_TANGENT0.xyz, t2.xyz);
    t7.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t7.xyz, t7.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD1.xyz = vec3(t13) * t7.xyz;
    t2.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t2.xyz;
    t2.xyz = _Object2World[3].xyz * in_POSITION0.www + t2.xyz;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t13 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD0 = sqrt(t13);
    t13 = dot(in_POSITION0, in_POSITION0);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t2.xyz);
    t2.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t2.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD3.xyz = vec3(t13) * t2.xyz;
    t2.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t2.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t2.xyz;
    t2.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t2.xyz;
    t1.y = dot(t1.xyz, t2.xyz);
    t1.x = dot(in_TANGENT0.xyz, t2.xyz);
    t1.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD6.zw = t0.zw;
    vs_TEXCOORD6.xy = t1.zz + t1.xw;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
lowp vec4 t10_1;
vec2 t2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
vec4 t4;
lowp vec4 t10_4;
vec3 t5;
vec3 t6;
vec3 t7;
int ti7;
bvec2 tb7;
vec3 t8;
bool tb8;
vec2 t12;
float t13;
float t14;
int ti14;
float t19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7.x = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7.x;
    t7.x = t1.x * t1.x;
    t13 = t7.x * 0.0208350997 + -0.0851330012;
    t13 = t7.x * t13 + 0.180141002;
    t13 = t7.x * t13 + -0.330299497;
    t7.x = t7.x * t13 + 0.999866009;
    t13 = t7.x * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7.x + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7.x = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7.x + t1.x;
    t7.x = min(t6.z, t6.y);
    tb7.x = t7.x<(-t7.x);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_1 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t1.xy = t10_1.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb19 = t10_4.w>=1.0;
    t19 = (tb19) ? 0.0 : 1.0;
    t10_2 = texture(cube_CityOverlayTex, t6.yxz);
    t19 = t19 * t10_2.w;
    t2.x = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb8 = abs(t6.z)>=abs(t6.y);
    t8.x = tb8 ? 1.0 : float(0.0);
    t2.x = t8.x * t2.x + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t2.x;
    t2.x = max(abs(t6.z), abs(t6.y));
    tb2 = t2.x>=abs(t6.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t0.x = t2.x * t0.x + t6.x;
    ti14 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti14) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t8.xyz = t8.xxx * t5.xyz + t4.xyz;
    t8.xyz = (-t3.xxy) * t6.xyz + t8.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t2.x = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t12.x);
    t2.y = dFdy(t12.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t2.x = t19 * t4.w;
    t0.w = t19 * t0.w;
    t19 = dot(t1.xy, t1.xy);
    t19 = min(t19, 1.0);
    t19 = (-t19) + 1.0;
    t1.z = sqrt(t19);
    t19 = dot(t1.xyz, t1.xyz);
    t19 = inversesqrt(t19);
    t1.xyz = vec3(t19) * t1.xyz;
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t8.xyz = vec3(t19) * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xyz, t8.xyz);
    t7.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_3 = texture(_ShadowMapTexture, t7.xy);
    t1.x = dot(t10_3.xx, t1.xx);
    t7.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t7.x = inversesqrt(t7.x);
    t7.xyz = t7.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t7.x = dot(vs_TEXCOORD3.xyz, t7.xyz);
    t13 = t7.x + 1.00999999;
    t7.x = t7.x * -10.0;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t13 = floor(t13);
    t13 = clamp(t13, 0.0, 1.0);
    t13 = t13 + -1.0;
    t7.x = t7.x * t13 + 1.0;
    t1.x = t7.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t4.w = t1.x * t2.x;
    t1 = (-t0) + t4;
    SV_Target0 = t4.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 235 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec4 tmpvar_21;
  vec3 tmpvar_22;
  tmpvar_22 = normalize(xlv_TEXCOORD2);
  tmpvar_21 = textureCube (cube_CityOverlayTex, tmpvar_22);
  cityoverlay_3.xyz = tmpvar_21.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_22);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_22.yxz), mix ((tmpvar_28 * tmpvar_22.xzy), (tmpvar_29 * tmpvar_22.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_23 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  vec4 tmpvar_36;
  tmpvar_36 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_23, tmpvar_35.xy, tmpvar_35.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_36.xyz;
  vec2 uv_37;
  vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_22);
  float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  float tmpvar_41;
  tmpvar_41 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_39), tmpvar_40));
  vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = -(tmpvar_41);
  vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = tmpvar_41;
  vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = tmpvar_41;
  vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_22.yxz), mix ((tmpvar_42 * tmpvar_22.xzy), (tmpvar_43 * tmpvar_22.zxy), vec3(tmpvar_39)), vec3(tmpvar_40));
  uv_37 = (((
    (0.5 * tmpvar_45.yz)
   / 
    abs(tmpvar_45.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_46;
  vec2 tmpvar_47;
  tmpvar_47 = abs((uv_37 - tmpvar_34));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  vec4 tmpvar_48;
  tmpvar_48.xy = dFdx(uvCont_46);
  tmpvar_48.zw = dFdy(uvCont_46);
  vec4 tmpvar_49;
  tmpvar_49 = texture2DGradARB (_CityLightOverlayDetailTex, uv_37, tmpvar_48.xy, tmpvar_48.zw);
  citylightoverlaydetail_1.xyz = tmpvar_49.xyz;
  cityoverlay_3.w = (tmpvar_21.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_36.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_49.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_49.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_50;
  vec3 tmpvar_51;
  tmpvar_51 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_52;
  tmpvar_52 = normalize(normal_20);
  float tmpvar_53;
  tmpvar_53 = dot (tmpvar_52, tmpvar_51);
  c_50.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_53) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_51 + normalize(xlv_TEXCOORD1)))
    , tmpvar_52), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_50.w = (tmpvar_53 * 2.0);
  float tmpvar_54;
  tmpvar_54 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_50 * mix (1.0, clamp (
    floor((1.01 + tmpvar_54))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_54))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_55;
  tmpvar_55 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_55;
  gl_FragData[0] = tmpvar_55;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 231 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  cityoverlay_4.xyz = tmpvar_29.xyz;
  mediump vec2 uv_30;
  mediump vec3 detailCoords_31;
  mediump float s_32;
  mediump float nylerp_33;
  mediump float zxlerp_34;
  highp vec3 tmpvar_35;
  tmpvar_35 = abs(tmpvar_27);
  highp float tmpvar_36;
  tmpvar_36 = float((tmpvar_35.z >= tmpvar_35.x));
  zxlerp_34 = tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = float((max (tmpvar_35.x, tmpvar_35.z) >= tmpvar_35.y));
  nylerp_33 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_34);
  s_32 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_27.y, s_32, nylerp_33));
  s_32 = tmpvar_39;
  mediump vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(s_32);
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = s_32;
  highp vec3 tmpvar_42;
  tmpvar_42 = mix ((tmpvar_40 * tmpvar_27.xzy), (tmpvar_41 * tmpvar_27.zxy), vec3(zxlerp_34));
  detailCoords_31 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xy = vec2(1.0, 1.0);
  tmpvar_43.z = s_32;
  highp vec3 tmpvar_44;
  tmpvar_44 = mix ((tmpvar_43 * tmpvar_27.yxz), detailCoords_31, vec3(nylerp_33));
  detailCoords_31 = tmpvar_44;
  uv_30 = (((
    (0.5 * detailCoords_31.yz)
   / 
    abs(detailCoords_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_45;
  uv_45 = uv_30;
  highp vec2 uvCont_46;
  highp vec2 tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = (0.5 * _CityOverlayDetailScale);
  tmpvar_47 = abs((uv_45 - tmpvar_48));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_46);
  tmpvar_49.zw = dFdy(uvCont_46);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_30, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citydarkoverlaydetail_3.xyz = tmpvar_51.xyz;
  mediump vec2 uv_52;
  mediump vec3 detailCoords_53;
  mediump float s_54;
  mediump float nylerp_55;
  mediump float zxlerp_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = abs(tmpvar_27);
  highp float tmpvar_58;
  tmpvar_58 = float((tmpvar_57.z >= tmpvar_57.x));
  zxlerp_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = float((max (tmpvar_57.x, tmpvar_57.z) >= tmpvar_57.y));
  nylerp_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_56);
  s_54 = tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = sign(mix (tmpvar_27.y, s_54, nylerp_55));
  s_54 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62.xz = vec2(1.0, -1.0);
  tmpvar_62.y = -(s_54);
  mediump vec3 tmpvar_63;
  tmpvar_63.xz = vec2(1.0, -1.0);
  tmpvar_63.y = s_54;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix ((tmpvar_62 * tmpvar_27.xzy), (tmpvar_63 * tmpvar_27.zxy), vec3(zxlerp_56));
  detailCoords_53 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xy = vec2(1.0, 1.0);
  tmpvar_65.z = s_54;
  highp vec3 tmpvar_66;
  tmpvar_66 = mix ((tmpvar_65 * tmpvar_27.yxz), detailCoords_53, vec3(nylerp_55));
  detailCoords_53 = tmpvar_66;
  uv_52 = (((
    (0.5 * detailCoords_53.yz)
   / 
    abs(detailCoords_53.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_67;
  uv_67 = uv_52;
  highp vec2 uvCont_68;
  highp vec2 tmpvar_69;
  tmpvar_69 = abs((uv_67 - tmpvar_48));
  uvCont_68.x = max (tmpvar_69.x, tmpvar_69.y);
  uvCont_68.y = min (tmpvar_69.x, tmpvar_69.y);
  highp vec4 tmpvar_70;
  tmpvar_70.xy = dFdx(uvCont_68);
  tmpvar_70.zw = dFdy(uvCont_68);
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_52, tmpvar_70.xy, tmpvar_70.zw);
  mediump vec4 tmpvar_72;
  tmpvar_72 = tmpvar_71;
  citylightoverlaydetail_2.xyz = tmpvar_72.xyz;
  cityoverlay_4.w = (tmpvar_29.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_51.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_72.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_72.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_73;
  lightDir_73 = xlv_TEXCOORD5;
  mediump vec3 viewDir_74;
  viewDir_74 = xlv_TEXCOORD1;
  mediump vec4 c_75;
  mediump vec3 tmpvar_76;
  tmpvar_76 = normalize(lightDir_73);
  lightDir_73 = tmpvar_76;
  mediump vec3 tmpvar_77;
  tmpvar_77 = normalize(viewDir_74);
  viewDir_74 = tmpvar_77;
  mediump vec3 tmpvar_78;
  tmpvar_78 = normalize(normT_5);
  mediump float tmpvar_79;
  tmpvar_79 = dot (tmpvar_78, tmpvar_76);
  highp float tmpvar_80;
  mediump float tmpvar_81;
  tmpvar_81 = clamp (dot (normalize(
    (tmpvar_76 + tmpvar_77)
  ), tmpvar_78), 0.0, 1.0);
  tmpvar_80 = tmpvar_81;
  highp float tmpvar_82;
  tmpvar_82 = (pow (tmpvar_80, _SpecularPower) * _SpecularColor.w);
  c_75.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_79) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_82)) * 2.0);
  c_75.w = (tmpvar_79 * 2.0);
  highp vec3 tmpvar_83;
  tmpvar_83 = normalize(_SunDir);
  mediump vec3 lightDir_84;
  lightDir_84 = tmpvar_83;
  mediump vec3 normal_85;
  normal_85 = xlv_TEXCOORD3;
  mediump float tmpvar_86;
  tmpvar_86 = dot (normal_85, lightDir_84);
  color_6 = (c_75 * mix (1.0, clamp (
    floor((1.01 + tmpvar_86))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_86))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_87;
  tmpvar_87 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_87;
  tmpvar_1 = tmpvar_87;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec3 t10_4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_14;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
highp float t20;
mediump float t16_23;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_32;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_4.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_19>=1.0;
    t16_5 = (tb1) ? 0.0 : 1.0;
    t10_1.x = texture(cube_CityOverlayTex, t9.yxz).w;
    t16_5 = t16_5 * t10_1.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_14.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t0.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t0.xy = t16_14.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_14.x = t16_5 * t10_3.w;
    t16_5 = t16_5 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_23 = dot(t10_4.xyz, t10_4.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_7.xyz = t10_4.xyz * vec3(t16_23);
    t16_23 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_8.xyz = vec3(t16_23) * vs_TEXCOORD5.xyz;
    t16_23 = dot(t16_7.xyz, t16_8.xyz);
    t16_23 = t16_23 + t16_23;
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_32 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_32 + 1.00999999;
    t16_32 = t16_32 * -10.0;
    t16_32 = clamp(t16_32, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_32 = t16_32 * t16_33 + 1.0;
    t16_23 = t16_32 * t16_23;
    t16_23 = clamp(t16_23, 0.0, 1.0);
    t16_23 = (-t16_23) + 1.0;
    t16_32 = t16_14.x * t16_23 + (-t16_5);
    t16_14.x = t16_23 * t16_14.x;
    t16_1.w = t16_14.x * t16_32 + t16_5;
    t16_1.xyz = t16_14.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
lowp vec4 t10_1;
vec2 t2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
vec4 t4;
lowp vec4 t10_4;
vec3 t5;
vec3 t6;
vec3 t7;
int ti7;
bvec2 tb7;
vec3 t8;
bool tb8;
vec2 t12;
float t13;
float t14;
int ti14;
float t19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7.x = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7.x;
    t7.x = t1.x * t1.x;
    t13 = t7.x * 0.0208350997 + -0.0851330012;
    t13 = t7.x * t13 + 0.180141002;
    t13 = t7.x * t13 + -0.330299497;
    t7.x = t7.x * t13 + 0.999866009;
    t13 = t7.x * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7.x + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7.x = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7.x + t1.x;
    t7.x = min(t6.z, t6.y);
    tb7.x = t7.x<(-t7.x);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_1 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t1.xy = t10_1.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb19 = t10_4.w>=1.0;
    t19 = (tb19) ? 0.0 : 1.0;
    t10_2 = texture(cube_CityOverlayTex, t6.yxz);
    t19 = t19 * t10_2.w;
    t2.x = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb8 = abs(t6.z)>=abs(t6.y);
    t8.x = tb8 ? 1.0 : float(0.0);
    t2.x = t8.x * t2.x + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t2.x;
    t2.x = max(abs(t6.z), abs(t6.y));
    tb2 = t2.x>=abs(t6.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t0.x = t2.x * t0.x + t6.x;
    ti14 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti14) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t8.xyz = t8.xxx * t5.xyz + t4.xyz;
    t8.xyz = (-t3.xxy) * t6.xyz + t8.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t2.x = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t12.x);
    t2.y = dFdy(t12.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t2.x = t19 * t4.w;
    t0.w = t19 * t0.w;
    t19 = dot(t1.xy, t1.xy);
    t19 = min(t19, 1.0);
    t19 = (-t19) + 1.0;
    t1.z = sqrt(t19);
    t19 = dot(t1.xyz, t1.xyz);
    t19 = inversesqrt(t19);
    t1.xyz = vec3(t19) * t1.xyz;
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t8.xyz = vec3(t19) * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xyz, t8.xyz);
    t1.x = t1.x + t1.x;
    t7.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t7.x = inversesqrt(t7.x);
    t7.xyz = t7.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t7.x = dot(vs_TEXCOORD3.xyz, t7.xyz);
    t13 = t7.x + 1.00999999;
    t7.x = t7.x * -10.0;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t13 = floor(t13);
    t13 = clamp(t13, 0.0, 1.0);
    t13 = t13 + -1.0;
    t7.x = t7.x * t13 + 1.0;
    t1.x = t7.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t4.w = t1.x * t2.x;
    t1 = (-t0) + t4;
    SV_Target0 = t4.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 237 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 tmpvar_1;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = gl_Normal;
  vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(gl_Normal);
  vec3 tmpvar_6;
  tmpvar_6 = normalize(TANGENT.xyz);
  vec3 tmpvar_7;
  vec3 tmpvar_8;
  tmpvar_7 = TANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * TANGENT.w);
  mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = gl_Normal.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = gl_Normal.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = gl_Normal.z;
  vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  vec4 o_11;
  vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_1 * 0.5);
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_12.x;
  tmpvar_13.y = (tmpvar_12.y * _ProjectionParams.x);
  o_11.xy = (tmpvar_13 + tmpvar_12.w);
  o_11.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
  xlv_TEXCOORD6 = o_11;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  vec4 tmpvar_21;
  vec3 tmpvar_22;
  tmpvar_22 = normalize(xlv_TEXCOORD2);
  tmpvar_21 = textureCube (cube_CityOverlayTex, tmpvar_22);
  cityoverlay_3.xyz = tmpvar_21.xyz;
  vec2 uv_23;
  vec3 tmpvar_24;
  tmpvar_24 = abs(tmpvar_22);
  float tmpvar_25;
  tmpvar_25 = float((tmpvar_24.z >= tmpvar_24.x));
  float tmpvar_26;
  tmpvar_26 = float((max (tmpvar_24.x, tmpvar_24.z) >= tmpvar_24.y));
  float tmpvar_27;
  tmpvar_27 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_25), tmpvar_26));
  vec3 tmpvar_28;
  tmpvar_28.xz = vec2(1.0, -1.0);
  tmpvar_28.y = -(tmpvar_27);
  vec3 tmpvar_29;
  tmpvar_29.xz = vec2(1.0, -1.0);
  tmpvar_29.y = tmpvar_27;
  vec3 tmpvar_30;
  tmpvar_30.xy = vec2(1.0, 1.0);
  tmpvar_30.z = tmpvar_27;
  vec3 tmpvar_31;
  tmpvar_31 = mix ((tmpvar_30 * tmpvar_22.yxz), mix ((tmpvar_28 * tmpvar_22.xzy), (tmpvar_29 * tmpvar_22.zxy), vec3(tmpvar_25)), vec3(tmpvar_26));
  uv_23 = (((
    (0.5 * tmpvar_31.yz)
   / 
    abs(tmpvar_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_32;
  vec2 tmpvar_33;
  float tmpvar_34;
  tmpvar_34 = (0.5 * _CityOverlayDetailScale);
  tmpvar_33 = abs((uv_23 - tmpvar_34));
  uvCont_32.x = max (tmpvar_33.x, tmpvar_33.y);
  uvCont_32.y = min (tmpvar_33.x, tmpvar_33.y);
  vec4 tmpvar_35;
  tmpvar_35.xy = dFdx(uvCont_32);
  tmpvar_35.zw = dFdy(uvCont_32);
  vec4 tmpvar_36;
  tmpvar_36 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_23, tmpvar_35.xy, tmpvar_35.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_36.xyz;
  vec2 uv_37;
  vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_22);
  float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  float tmpvar_41;
  tmpvar_41 = sign(mix (tmpvar_22.y, mix (tmpvar_22.x, tmpvar_22.z, tmpvar_39), tmpvar_40));
  vec3 tmpvar_42;
  tmpvar_42.xz = vec2(1.0, -1.0);
  tmpvar_42.y = -(tmpvar_41);
  vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = tmpvar_41;
  vec3 tmpvar_44;
  tmpvar_44.xy = vec2(1.0, 1.0);
  tmpvar_44.z = tmpvar_41;
  vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_44 * tmpvar_22.yxz), mix ((tmpvar_42 * tmpvar_22.xzy), (tmpvar_43 * tmpvar_22.zxy), vec3(tmpvar_39)), vec3(tmpvar_40));
  uv_37 = (((
    (0.5 * tmpvar_45.yz)
   / 
    abs(tmpvar_45.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_46;
  vec2 tmpvar_47;
  tmpvar_47 = abs((uv_37 - tmpvar_34));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  vec4 tmpvar_48;
  tmpvar_48.xy = dFdx(uvCont_46);
  tmpvar_48.zw = dFdy(uvCont_46);
  vec4 tmpvar_49;
  tmpvar_49 = texture2DGradARB (_CityLightOverlayDetailTex, uv_37, tmpvar_48.xy, tmpvar_48.zw);
  citylightoverlaydetail_1.xyz = tmpvar_49.xyz;
  cityoverlay_3.w = (tmpvar_21.w * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_36.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_49.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_49.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_50;
  tmpvar_50 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_51;
  vec3 tmpvar_52;
  tmpvar_52 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_53;
  tmpvar_53 = normalize(normal_20);
  float tmpvar_54;
  tmpvar_54 = dot (tmpvar_53, tmpvar_52);
  c_51.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_54) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_52 + normalize(xlv_TEXCOORD1)))
    , tmpvar_53), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_50.x * 2.0));
  c_51.w = (tmpvar_54 * (tmpvar_50.x * 2.0));
  float tmpvar_55;
  tmpvar_55 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_51 * mix (1.0, clamp (
    floor((1.01 + tmpvar_55))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_55))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_56;
  tmpvar_56 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_56;
  gl_FragData[0] = tmpvar_56;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 58 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_ProjectionParams]
Vector 12 [_ScreenParams]
Vector 13 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c14, 1, 0, 0.5, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c13
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c14
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r1.x, r0.y, c11.x
mul r1.w, r1.x, c14.z
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c14.z
mad o6.xy, r1.z, c12.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o6.zw, r0

"
}
SubProgram "d3d11 " {
// Stats: 53 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 237 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  cityoverlay_4.xyz = tmpvar_29.xyz;
  mediump vec2 uv_30;
  mediump vec3 detailCoords_31;
  mediump float s_32;
  mediump float nylerp_33;
  mediump float zxlerp_34;
  highp vec3 tmpvar_35;
  tmpvar_35 = abs(tmpvar_27);
  highp float tmpvar_36;
  tmpvar_36 = float((tmpvar_35.z >= tmpvar_35.x));
  zxlerp_34 = tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = float((max (tmpvar_35.x, tmpvar_35.z) >= tmpvar_35.y));
  nylerp_33 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_34);
  s_32 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_27.y, s_32, nylerp_33));
  s_32 = tmpvar_39;
  mediump vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(s_32);
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = s_32;
  highp vec3 tmpvar_42;
  tmpvar_42 = mix ((tmpvar_40 * tmpvar_27.xzy), (tmpvar_41 * tmpvar_27.zxy), vec3(zxlerp_34));
  detailCoords_31 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xy = vec2(1.0, 1.0);
  tmpvar_43.z = s_32;
  highp vec3 tmpvar_44;
  tmpvar_44 = mix ((tmpvar_43 * tmpvar_27.yxz), detailCoords_31, vec3(nylerp_33));
  detailCoords_31 = tmpvar_44;
  uv_30 = (((
    (0.5 * detailCoords_31.yz)
   / 
    abs(detailCoords_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_45;
  uv_45 = uv_30;
  highp vec2 uvCont_46;
  highp vec2 tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = (0.5 * _CityOverlayDetailScale);
  tmpvar_47 = abs((uv_45 - tmpvar_48));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_46);
  tmpvar_49.zw = dFdy(uvCont_46);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_30, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citydarkoverlaydetail_3.xyz = tmpvar_51.xyz;
  mediump vec2 uv_52;
  mediump vec3 detailCoords_53;
  mediump float s_54;
  mediump float nylerp_55;
  mediump float zxlerp_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = abs(tmpvar_27);
  highp float tmpvar_58;
  tmpvar_58 = float((tmpvar_57.z >= tmpvar_57.x));
  zxlerp_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = float((max (tmpvar_57.x, tmpvar_57.z) >= tmpvar_57.y));
  nylerp_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_56);
  s_54 = tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = sign(mix (tmpvar_27.y, s_54, nylerp_55));
  s_54 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62.xz = vec2(1.0, -1.0);
  tmpvar_62.y = -(s_54);
  mediump vec3 tmpvar_63;
  tmpvar_63.xz = vec2(1.0, -1.0);
  tmpvar_63.y = s_54;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix ((tmpvar_62 * tmpvar_27.xzy), (tmpvar_63 * tmpvar_27.zxy), vec3(zxlerp_56));
  detailCoords_53 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xy = vec2(1.0, 1.0);
  tmpvar_65.z = s_54;
  highp vec3 tmpvar_66;
  tmpvar_66 = mix ((tmpvar_65 * tmpvar_27.yxz), detailCoords_53, vec3(nylerp_55));
  detailCoords_53 = tmpvar_66;
  uv_52 = (((
    (0.5 * detailCoords_53.yz)
   / 
    abs(detailCoords_53.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_67;
  uv_67 = uv_52;
  highp vec2 uvCont_68;
  highp vec2 tmpvar_69;
  tmpvar_69 = abs((uv_67 - tmpvar_48));
  uvCont_68.x = max (tmpvar_69.x, tmpvar_69.y);
  uvCont_68.y = min (tmpvar_69.x, tmpvar_69.y);
  highp vec4 tmpvar_70;
  tmpvar_70.xy = dFdx(uvCont_68);
  tmpvar_70.zw = dFdy(uvCont_68);
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_52, tmpvar_70.xy, tmpvar_70.zw);
  mediump vec4 tmpvar_72;
  tmpvar_72 = tmpvar_71;
  citylightoverlaydetail_2.xyz = tmpvar_72.xyz;
  cityoverlay_4.w = (tmpvar_29.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_51.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_72.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_72.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float tmpvar_73;
  highp float tmpvar_74;
  tmpvar_74 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_73 = tmpvar_74;
  mediump vec3 lightDir_75;
  lightDir_75 = xlv_TEXCOORD5;
  mediump vec3 viewDir_76;
  viewDir_76 = xlv_TEXCOORD1;
  mediump float atten_77;
  atten_77 = tmpvar_73;
  mediump vec4 c_78;
  mediump vec3 tmpvar_79;
  tmpvar_79 = normalize(lightDir_75);
  lightDir_75 = tmpvar_79;
  mediump vec3 tmpvar_80;
  tmpvar_80 = normalize(viewDir_76);
  viewDir_76 = tmpvar_80;
  mediump vec3 tmpvar_81;
  tmpvar_81 = normalize(normT_5);
  mediump float tmpvar_82;
  tmpvar_82 = dot (tmpvar_81, tmpvar_79);
  highp float tmpvar_83;
  mediump float tmpvar_84;
  tmpvar_84 = clamp (dot (normalize(
    (tmpvar_79 + tmpvar_80)
  ), tmpvar_81), 0.0, 1.0);
  tmpvar_83 = tmpvar_84;
  highp float tmpvar_85;
  tmpvar_85 = (pow (tmpvar_83, _SpecularPower) * _SpecularColor.w);
  c_78.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_82) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_85)) * (atten_77 * 2.0));
  c_78.w = (tmpvar_82 * (atten_77 * 2.0));
  highp vec3 tmpvar_86;
  tmpvar_86 = normalize(_SunDir);
  mediump vec3 lightDir_87;
  lightDir_87 = tmpvar_86;
  mediump vec3 normal_88;
  normal_88 = xlv_TEXCOORD3;
  mediump float tmpvar_89;
  tmpvar_89 = dot (normal_88, lightDir_87);
  color_6 = (c_78 * mix (1.0, clamp (
    floor((1.01 + tmpvar_89))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_89))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_90;
  tmpvar_90 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_90;
  tmpvar_1 = tmpvar_90;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
vec4 t0;
vec4 t1;
vec3 t2;
vec3 t3;
vec3 t7;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * in_NORMAL0.zxy;
    t13 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_TANGENT0.yzx;
    t3.xyz = t1.xyz * t2.xyz;
    t1.xyz = t1.zxy * t2.yzx + (-t3.xyz);
    t1.xyz = t1.xyz * in_TANGENT0.www;
    t2.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t2.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t2.xyz;
    t2.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t2.xyz;
    t2.xyz = t2.xyz + _World2Object[3].xyz;
    t2.xyz = t2.xyz + (-in_POSITION0.xyz);
    t7.y = dot(t1.xyz, t2.xyz);
    t7.x = dot(in_TANGENT0.xyz, t2.xyz);
    t7.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t7.xyz, t7.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD1.xyz = vec3(t13) * t7.xyz;
    t2.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t2.xyz;
    t2.xyz = _Object2World[3].xyz * in_POSITION0.www + t2.xyz;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t13 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD0 = sqrt(t13);
    t13 = dot(in_POSITION0, in_POSITION0);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t2.xyz);
    t2.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t2.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD3.xyz = vec3(t13) * t2.xyz;
    t2.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t2.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t2.xyz;
    t2.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t2.xyz;
    t1.y = dot(t1.xyz, t2.xyz);
    t1.x = dot(in_TANGENT0.xyz, t2.xyz);
    t1.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD6.zw = t0.zw;
    vs_TEXCOORD6.xy = t1.zz + t1.xw;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
lowp vec4 t10_1;
vec2 t2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
vec4 t4;
lowp vec4 t10_4;
vec3 t5;
vec3 t6;
vec3 t7;
int ti7;
bvec2 tb7;
vec3 t8;
bool tb8;
vec2 t12;
float t13;
float t14;
int ti14;
float t19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7.x = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7.x;
    t7.x = t1.x * t1.x;
    t13 = t7.x * 0.0208350997 + -0.0851330012;
    t13 = t7.x * t13 + 0.180141002;
    t13 = t7.x * t13 + -0.330299497;
    t7.x = t7.x * t13 + 0.999866009;
    t13 = t7.x * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7.x + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7.x = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7.x + t1.x;
    t7.x = min(t6.z, t6.y);
    tb7.x = t7.x<(-t7.x);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_1 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t1.xy = t10_1.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb19 = t10_4.w>=1.0;
    t19 = (tb19) ? 0.0 : 1.0;
    t10_2 = texture(cube_CityOverlayTex, t6.yxz);
    t19 = t19 * t10_2.w;
    t2.x = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb8 = abs(t6.z)>=abs(t6.y);
    t8.x = tb8 ? 1.0 : float(0.0);
    t2.x = t8.x * t2.x + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t2.x;
    t2.x = max(abs(t6.z), abs(t6.y));
    tb2 = t2.x>=abs(t6.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t0.x = t2.x * t0.x + t6.x;
    ti14 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti14) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t8.xyz = t8.xxx * t5.xyz + t4.xyz;
    t8.xyz = (-t3.xxy) * t6.xyz + t8.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t2.x = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t12.x);
    t2.y = dFdy(t12.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t2.x = t19 * t4.w;
    t0.w = t19 * t0.w;
    t19 = dot(t1.xy, t1.xy);
    t19 = min(t19, 1.0);
    t19 = (-t19) + 1.0;
    t1.z = sqrt(t19);
    t19 = dot(t1.xyz, t1.xyz);
    t19 = inversesqrt(t19);
    t1.xyz = vec3(t19) * t1.xyz;
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t8.xyz = vec3(t19) * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xyz, t8.xyz);
    t7.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_3 = texture(_ShadowMapTexture, t7.xy);
    t1.x = dot(t10_3.xx, t1.xx);
    t7.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t7.x = inversesqrt(t7.x);
    t7.xyz = t7.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t7.x = dot(vs_TEXCOORD3.xyz, t7.xyz);
    t13 = t7.x + 1.00999999;
    t7.x = t7.x * -10.0;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t13 = floor(t13);
    t13 = clamp(t13, 0.0, 1.0);
    t13 = t13 + -1.0;
    t7.x = t7.x * t13 + 1.0;
    t1.x = t7.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t4.w = t1.x * t2.x;
    t1 = (-t0) + t4;
    SV_Target0 = t4.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "gles " {
// Stats: 236 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  cityoverlay_4.xyz = tmpvar_29.xyz;
  mediump vec2 uv_30;
  mediump vec3 detailCoords_31;
  mediump float s_32;
  mediump float nylerp_33;
  mediump float zxlerp_34;
  highp vec3 tmpvar_35;
  tmpvar_35 = abs(tmpvar_27);
  highp float tmpvar_36;
  tmpvar_36 = float((tmpvar_35.z >= tmpvar_35.x));
  zxlerp_34 = tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = float((max (tmpvar_35.x, tmpvar_35.z) >= tmpvar_35.y));
  nylerp_33 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_34);
  s_32 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_27.y, s_32, nylerp_33));
  s_32 = tmpvar_39;
  mediump vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(s_32);
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = s_32;
  highp vec3 tmpvar_42;
  tmpvar_42 = mix ((tmpvar_40 * tmpvar_27.xzy), (tmpvar_41 * tmpvar_27.zxy), vec3(zxlerp_34));
  detailCoords_31 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xy = vec2(1.0, 1.0);
  tmpvar_43.z = s_32;
  highp vec3 tmpvar_44;
  tmpvar_44 = mix ((tmpvar_43 * tmpvar_27.yxz), detailCoords_31, vec3(nylerp_33));
  detailCoords_31 = tmpvar_44;
  uv_30 = (((
    (0.5 * detailCoords_31.yz)
   / 
    abs(detailCoords_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_45;
  uv_45 = uv_30;
  highp vec2 uvCont_46;
  highp vec2 tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = (0.5 * _CityOverlayDetailScale);
  tmpvar_47 = abs((uv_45 - tmpvar_48));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_46);
  tmpvar_49.zw = dFdy(uvCont_46);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_30, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citydarkoverlaydetail_3.xyz = tmpvar_51.xyz;
  mediump vec2 uv_52;
  mediump vec3 detailCoords_53;
  mediump float s_54;
  mediump float nylerp_55;
  mediump float zxlerp_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = abs(tmpvar_27);
  highp float tmpvar_58;
  tmpvar_58 = float((tmpvar_57.z >= tmpvar_57.x));
  zxlerp_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = float((max (tmpvar_57.x, tmpvar_57.z) >= tmpvar_57.y));
  nylerp_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_56);
  s_54 = tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = sign(mix (tmpvar_27.y, s_54, nylerp_55));
  s_54 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62.xz = vec2(1.0, -1.0);
  tmpvar_62.y = -(s_54);
  mediump vec3 tmpvar_63;
  tmpvar_63.xz = vec2(1.0, -1.0);
  tmpvar_63.y = s_54;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix ((tmpvar_62 * tmpvar_27.xzy), (tmpvar_63 * tmpvar_27.zxy), vec3(zxlerp_56));
  detailCoords_53 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xy = vec2(1.0, 1.0);
  tmpvar_65.z = s_54;
  highp vec3 tmpvar_66;
  tmpvar_66 = mix ((tmpvar_65 * tmpvar_27.yxz), detailCoords_53, vec3(nylerp_55));
  detailCoords_53 = tmpvar_66;
  uv_52 = (((
    (0.5 * detailCoords_53.yz)
   / 
    abs(detailCoords_53.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_67;
  uv_67 = uv_52;
  highp vec2 uvCont_68;
  highp vec2 tmpvar_69;
  tmpvar_69 = abs((uv_67 - tmpvar_48));
  uvCont_68.x = max (tmpvar_69.x, tmpvar_69.y);
  uvCont_68.y = min (tmpvar_69.x, tmpvar_69.y);
  highp vec4 tmpvar_70;
  tmpvar_70.xy = dFdx(uvCont_68);
  tmpvar_70.zw = dFdy(uvCont_68);
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_52, tmpvar_70.xy, tmpvar_70.zw);
  mediump vec4 tmpvar_72;
  tmpvar_72 = tmpvar_71;
  citylightoverlaydetail_2.xyz = tmpvar_72.xyz;
  cityoverlay_4.w = (tmpvar_29.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_51.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_72.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_72.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float shadow_73;
  shadow_73 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_74;
  lightDir_74 = xlv_TEXCOORD5;
  mediump vec3 viewDir_75;
  viewDir_75 = xlv_TEXCOORD1;
  mediump float atten_76;
  atten_76 = shadow_73;
  mediump vec4 c_77;
  mediump vec3 tmpvar_78;
  tmpvar_78 = normalize(lightDir_74);
  lightDir_74 = tmpvar_78;
  mediump vec3 tmpvar_79;
  tmpvar_79 = normalize(viewDir_75);
  viewDir_75 = tmpvar_79;
  mediump vec3 tmpvar_80;
  tmpvar_80 = normalize(normT_5);
  mediump float tmpvar_81;
  tmpvar_81 = dot (tmpvar_80, tmpvar_78);
  highp float tmpvar_82;
  mediump float tmpvar_83;
  tmpvar_83 = clamp (dot (normalize(
    (tmpvar_78 + tmpvar_79)
  ), tmpvar_80), 0.0, 1.0);
  tmpvar_82 = tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = (pow (tmpvar_82, _SpecularPower) * _SpecularColor.w);
  c_77.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_81) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_84)) * (atten_76 * 2.0));
  c_77.w = (tmpvar_81 * (atten_76 * 2.0));
  highp vec3 tmpvar_85;
  tmpvar_85 = normalize(_SunDir);
  mediump vec3 lightDir_86;
  lightDir_86 = tmpvar_85;
  mediump vec3 normal_87;
  normal_87 = xlv_TEXCOORD3;
  mediump float tmpvar_88;
  tmpvar_88 = dot (normal_87, lightDir_86);
  color_6 = (c_77 * mix (1.0, clamp (
    floor((1.01 + tmpvar_88))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_88))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_89;
  tmpvar_89 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_89;
  tmpvar_1 = tmpvar_89;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1 = t0.yyyy * unity_World2Shadow[0][1];
    t1 = unity_World2Shadow[0][0] * t0.xxxx + t1;
    t1 = unity_World2Shadow[0][2] * t0.zzzz + t1;
    t0 = unity_World2Shadow[0][3] * t0.wwww + t1;
    vs_TEXCOORD6 = t0;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec3 t10_4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_14;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
highp float t20;
mediump float t16_23;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_32;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_4.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_19>=1.0;
    t16_5 = (tb1) ? 0.0 : 1.0;
    t10_1.x = texture(cube_CityOverlayTex, t9.yxz).w;
    t16_5 = t16_5 * t10_1.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_14.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t0.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t0.xy = t16_14.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_14.x = t16_5 * t10_3.w;
    t16_5 = t16_5 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_23 = dot(t10_4.xyz, t10_4.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_7.xyz = t10_4.xyz * vec3(t16_23);
    t16_23 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_8.xyz = vec3(t16_23) * vs_TEXCOORD5.xyz;
    t16_23 = dot(t16_7.xyz, t16_8.xyz);
    vec3 txVec12 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_32 = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec12, 0.0);
    t16_33 = (-_LightShadowData.x) + 1.0;
    t16_32 = t16_32 * t16_33 + _LightShadowData.x;
    t16_23 = dot(vec2(t16_32), vec2(t16_23));
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_32 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_32 + 1.00999999;
    t16_32 = t16_32 * -10.0;
    t16_32 = clamp(t16_32, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_32 = t16_32 * t16_33 + 1.0;
    t16_23 = t16_32 * t16_23;
    t16_23 = clamp(t16_23, 0.0, 1.0);
    t16_23 = (-t16_23) + 1.0;
    t16_32 = t16_14.x * t16_23 + (-t16_5);
    t16_14.x = t16_23 * t16_14.x;
    t16_1.w = t16_14.x * t16_32 + t16_5;
    t16_1.xyz = t16_14.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 28 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 240
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Matrix 160 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 224 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  half4 tmpvar_2;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = _mtl_u._SunDir;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_7;
  tmpvar_7 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_8;
  float3 tmpvar_9;
  tmpvar_8 = _mtl_i._glesTANGENT.xyz;
  tmpvar_9 = (((tmpvar_6.yzx * tmpvar_7.zxy) - (tmpvar_6.zxy * tmpvar_7.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_10;
  tmpvar_10[0].x = tmpvar_8.x;
  tmpvar_10[0].y = tmpvar_9.x;
  tmpvar_10[0].z = _mtl_i._glesNormal.x;
  tmpvar_10[1].x = tmpvar_8.y;
  tmpvar_10[1].y = tmpvar_9.y;
  tmpvar_10[1].z = _mtl_i._glesNormal.y;
  tmpvar_10[2].x = tmpvar_8.z;
  tmpvar_10[2].y = tmpvar_9.z;
  tmpvar_10[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _mtl_u._WorldSpaceCameraPos;
  float4 o_12;
  float4 tmpvar_13;
  tmpvar_13 = (tmpvar_1 * 0.5);
  float2 tmpvar_14;
  tmpvar_14.x = tmpvar_13.x;
  tmpvar_14.y = (tmpvar_13.y * _mtl_u._ProjectionParams.x);
  o_12.xy = (tmpvar_14 + tmpvar_13.w);
  o_12.zw = tmpvar_1.zw;
  tmpvar_2 = half4(o_12);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_10 * (
    (_mtl_u._World2Object * tmpvar_11)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_4).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_10 * (_mtl_u._World2Object * tmpvar_5).xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_2;
  return _mtl_o;
}

"
}
SubProgram "gles " {
// Stats: 236 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
#extension GL_EXT_shadow_samplers : enable
uniform mediump vec4 _LightShadowData;
uniform lowp sampler2DShadow _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  cityoverlay_4.xyz = tmpvar_29.xyz;
  mediump vec2 uv_30;
  mediump vec3 detailCoords_31;
  mediump float s_32;
  mediump float nylerp_33;
  mediump float zxlerp_34;
  highp vec3 tmpvar_35;
  tmpvar_35 = abs(tmpvar_27);
  highp float tmpvar_36;
  tmpvar_36 = float((tmpvar_35.z >= tmpvar_35.x));
  zxlerp_34 = tmpvar_36;
  highp float tmpvar_37;
  tmpvar_37 = float((max (tmpvar_35.x, tmpvar_35.z) >= tmpvar_35.y));
  nylerp_33 = tmpvar_37;
  highp float tmpvar_38;
  tmpvar_38 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_34);
  s_32 = tmpvar_38;
  highp float tmpvar_39;
  tmpvar_39 = sign(mix (tmpvar_27.y, s_32, nylerp_33));
  s_32 = tmpvar_39;
  mediump vec3 tmpvar_40;
  tmpvar_40.xz = vec2(1.0, -1.0);
  tmpvar_40.y = -(s_32);
  mediump vec3 tmpvar_41;
  tmpvar_41.xz = vec2(1.0, -1.0);
  tmpvar_41.y = s_32;
  highp vec3 tmpvar_42;
  tmpvar_42 = mix ((tmpvar_40 * tmpvar_27.xzy), (tmpvar_41 * tmpvar_27.zxy), vec3(zxlerp_34));
  detailCoords_31 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xy = vec2(1.0, 1.0);
  tmpvar_43.z = s_32;
  highp vec3 tmpvar_44;
  tmpvar_44 = mix ((tmpvar_43 * tmpvar_27.yxz), detailCoords_31, vec3(nylerp_33));
  detailCoords_31 = tmpvar_44;
  uv_30 = (((
    (0.5 * detailCoords_31.yz)
   / 
    abs(detailCoords_31.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_45;
  uv_45 = uv_30;
  highp vec2 uvCont_46;
  highp vec2 tmpvar_47;
  highp float tmpvar_48;
  tmpvar_48 = (0.5 * _CityOverlayDetailScale);
  tmpvar_47 = abs((uv_45 - tmpvar_48));
  uvCont_46.x = max (tmpvar_47.x, tmpvar_47.y);
  uvCont_46.y = min (tmpvar_47.x, tmpvar_47.y);
  highp vec4 tmpvar_49;
  tmpvar_49.xy = dFdx(uvCont_46);
  tmpvar_49.zw = dFdy(uvCont_46);
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_30, tmpvar_49.xy, tmpvar_49.zw);
  mediump vec4 tmpvar_51;
  tmpvar_51 = tmpvar_50;
  citydarkoverlaydetail_3.xyz = tmpvar_51.xyz;
  mediump vec2 uv_52;
  mediump vec3 detailCoords_53;
  mediump float s_54;
  mediump float nylerp_55;
  mediump float zxlerp_56;
  highp vec3 tmpvar_57;
  tmpvar_57 = abs(tmpvar_27);
  highp float tmpvar_58;
  tmpvar_58 = float((tmpvar_57.z >= tmpvar_57.x));
  zxlerp_56 = tmpvar_58;
  highp float tmpvar_59;
  tmpvar_59 = float((max (tmpvar_57.x, tmpvar_57.z) >= tmpvar_57.y));
  nylerp_55 = tmpvar_59;
  highp float tmpvar_60;
  tmpvar_60 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_56);
  s_54 = tmpvar_60;
  highp float tmpvar_61;
  tmpvar_61 = sign(mix (tmpvar_27.y, s_54, nylerp_55));
  s_54 = tmpvar_61;
  mediump vec3 tmpvar_62;
  tmpvar_62.xz = vec2(1.0, -1.0);
  tmpvar_62.y = -(s_54);
  mediump vec3 tmpvar_63;
  tmpvar_63.xz = vec2(1.0, -1.0);
  tmpvar_63.y = s_54;
  highp vec3 tmpvar_64;
  tmpvar_64 = mix ((tmpvar_62 * tmpvar_27.xzy), (tmpvar_63 * tmpvar_27.zxy), vec3(zxlerp_56));
  detailCoords_53 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xy = vec2(1.0, 1.0);
  tmpvar_65.z = s_54;
  highp vec3 tmpvar_66;
  tmpvar_66 = mix ((tmpvar_65 * tmpvar_27.yxz), detailCoords_53, vec3(nylerp_55));
  detailCoords_53 = tmpvar_66;
  uv_52 = (((
    (0.5 * detailCoords_53.yz)
   / 
    abs(detailCoords_53.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_67;
  uv_67 = uv_52;
  highp vec2 uvCont_68;
  highp vec2 tmpvar_69;
  tmpvar_69 = abs((uv_67 - tmpvar_48));
  uvCont_68.x = max (tmpvar_69.x, tmpvar_69.y);
  uvCont_68.y = min (tmpvar_69.x, tmpvar_69.y);
  highp vec4 tmpvar_70;
  tmpvar_70.xy = dFdx(uvCont_68);
  tmpvar_70.zw = dFdy(uvCont_68);
  lowp vec4 tmpvar_71;
  tmpvar_71 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_52, tmpvar_70.xy, tmpvar_70.zw);
  mediump vec4 tmpvar_72;
  tmpvar_72 = tmpvar_71;
  citylightoverlaydetail_2.xyz = tmpvar_72.xyz;
  cityoverlay_4.w = (tmpvar_29.w * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_51.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_72.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_72.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float shadow_73;
  shadow_73 = (_LightShadowData.x + (shadow2DEXT (_ShadowMapTexture, xlv_TEXCOORD6.xyz) * (1.0 - _LightShadowData.x)));
  mediump vec3 lightDir_74;
  lightDir_74 = xlv_TEXCOORD5;
  mediump vec3 viewDir_75;
  viewDir_75 = xlv_TEXCOORD1;
  mediump float atten_76;
  atten_76 = shadow_73;
  mediump vec4 c_77;
  mediump vec3 tmpvar_78;
  tmpvar_78 = normalize(lightDir_74);
  lightDir_74 = tmpvar_78;
  mediump vec3 tmpvar_79;
  tmpvar_79 = normalize(viewDir_75);
  viewDir_75 = tmpvar_79;
  mediump vec3 tmpvar_80;
  tmpvar_80 = normalize(normT_5);
  mediump float tmpvar_81;
  tmpvar_81 = dot (tmpvar_80, tmpvar_78);
  highp float tmpvar_82;
  mediump float tmpvar_83;
  tmpvar_83 = clamp (dot (normalize(
    (tmpvar_78 + tmpvar_79)
  ), tmpvar_80), 0.0, 1.0);
  tmpvar_82 = tmpvar_83;
  highp float tmpvar_84;
  tmpvar_84 = (pow (tmpvar_82, _SpecularPower) * _SpecularColor.w);
  c_77.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_81) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_84)) * (atten_76 * 2.0));
  c_77.w = (tmpvar_81 * (atten_76 * 2.0));
  highp vec3 tmpvar_85;
  tmpvar_85 = normalize(_SunDir);
  mediump vec3 lightDir_86;
  lightDir_86 = tmpvar_85;
  mediump vec3 normal_87;
  normal_87 = xlv_TEXCOORD3;
  mediump float tmpvar_88;
  tmpvar_88 = dot (normal_87, lightDir_86);
  color_6 = (c_77 * mix (1.0, clamp (
    floor((1.01 + tmpvar_88))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_88))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_89;
  tmpvar_89 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_89;
  tmpvar_1 = tmpvar_89;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
out mediump vec4 vs_TEXCOORD6;
highp vec4 t0;
highp vec4 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    t0 = in_POSITION0.yyyy * _Object2World[1];
    t0 = _Object2World[0] * in_POSITION0.xxxx + t0;
    t0 = _Object2World[2] * in_POSITION0.zzzz + t0;
    t0 = _Object2World[3] * in_POSITION0.wwww + t0;
    t1 = t0.yyyy * unity_World2Shadow[0][1];
    t1 = unity_World2Shadow[0][0] * t0.xxxx + t1;
    t1 = unity_World2Shadow[0][2] * t0.zzzz + t1;
    t0 = unity_World2Shadow[0][3] * t0.wwww + t1;
    vs_TEXCOORD6 = t0;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
uniform lowp sampler2DShadow hlslcc_zcmp_ShadowMapTexture;
uniform lowp sampler2D _ShadowMapTexture;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
in mediump vec4 vs_TEXCOORD6;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec3 t10_4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_14;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
highp float t20;
mediump float t16_23;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_32;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_4.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_19>=1.0;
    t16_5 = (tb1) ? 0.0 : 1.0;
    t10_1.x = texture(cube_CityOverlayTex, t9.yxz).w;
    t16_5 = t16_5 * t10_1.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_14.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t0.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t0.xy = t16_14.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_14.x = t16_5 * t10_3.w;
    t16_5 = t16_5 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_23 = dot(t10_4.xyz, t10_4.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_7.xyz = t10_4.xyz * vec3(t16_23);
    t16_23 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_8.xyz = vec3(t16_23) * vs_TEXCOORD5.xyz;
    t16_23 = dot(t16_7.xyz, t16_8.xyz);
    vec3 txVec15 = vec3(vs_TEXCOORD6.xy,vs_TEXCOORD6.z);
    t16_32 = textureLod(hlslcc_zcmp_ShadowMapTexture, txVec15, 0.0);
    t16_33 = (-_LightShadowData.x) + 1.0;
    t16_32 = t16_32 * t16_33 + _LightShadowData.x;
    t16_23 = dot(vec2(t16_32), vec2(t16_23));
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_32 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_32 + 1.00999999;
    t16_32 = t16_32 * -10.0;
    t16_32 = clamp(t16_32, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_32 = t16_32 * t16_33 + 1.0;
    t16_23 = t16_32 * t16_23;
    t16_23 = clamp(t16_23, 0.0, 1.0);
    t16_23 = (-t16_23) + 1.0;
    t16_32 = t16_14.x * t16_23 + (-t16_5);
    t16_14.x = t16_23 * t16_14.x;
    t16_1.w = t16_14.x * t16_32 + t16_5;
    t16_1.xyz = t16_14.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 28 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "SHADOWS_NATIVE" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_N_1" "MAP_TYPE_CUBE_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 240
Matrix 32 [glstate_matrix_mvp]
Matrix 96 [_Object2World]
Matrix 160 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 16 [_ProjectionParams]
Vector 224 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
  half4 xlv_TEXCOORD6;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4 _ProjectionParams;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float4 tmpvar_1;
  half4 tmpvar_2;
  tmpvar_1 = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  float3 tmpvar_3;
  tmpvar_3 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _mtl_i._glesNormal;
  float4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = _mtl_u._SunDir;
  float3 tmpvar_6;
  tmpvar_6 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_7;
  tmpvar_7 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_8;
  float3 tmpvar_9;
  tmpvar_8 = _mtl_i._glesTANGENT.xyz;
  tmpvar_9 = (((tmpvar_6.yzx * tmpvar_7.zxy) - (tmpvar_6.zxy * tmpvar_7.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_10;
  tmpvar_10[0].x = tmpvar_8.x;
  tmpvar_10[0].y = tmpvar_9.x;
  tmpvar_10[0].z = _mtl_i._glesNormal.x;
  tmpvar_10[1].x = tmpvar_8.y;
  tmpvar_10[1].y = tmpvar_9.y;
  tmpvar_10[1].z = _mtl_i._glesNormal.y;
  tmpvar_10[2].x = tmpvar_8.z;
  tmpvar_10[2].y = tmpvar_9.z;
  tmpvar_10[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = _mtl_u._WorldSpaceCameraPos;
  float4 o_12;
  float4 tmpvar_13;
  tmpvar_13 = (tmpvar_1 * 0.5);
  float2 tmpvar_14;
  tmpvar_14.x = tmpvar_13.x;
  tmpvar_14.y = (tmpvar_13.y * _mtl_u._ProjectionParams.x);
  o_12.xy = (tmpvar_14 + tmpvar_13.w);
  o_12.zw = tmpvar_1.zw;
  tmpvar_2 = half4(o_12);
  _mtl_o.gl_Position = tmpvar_1;
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_10 * (
    (_mtl_u._World2Object * tmpvar_11)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_4).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_10 * (_mtl_u._World2Object * tmpvar_5).xyz));
  _mtl_o.xlv_TEXCOORD6 = tmpvar_2;
  return _mtl_o;
}

"
}
SubProgram "opengl " {
// Stats: 240 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  float tmpvar_21;
  vec4 v_22;
  vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD2);
  v_22 = (textureCube (cube_CityOverlayTex, tmpvar_23) * alphaMask1);
  tmpvar_21 = ((v_22.x + v_22.y) + (v_22.z + v_22.w));
  vec4 tmpvar_24;
  tmpvar_24.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_24.w = tmpvar_21;
  cityoverlay_3.xyz = tmpvar_24.xyz;
  vec2 uv_25;
  vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_23);
  float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_27), tmpvar_28));
  vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(tmpvar_29);
  vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = tmpvar_29;
  vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = tmpvar_29;
  vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), mix ((tmpvar_30 * tmpvar_23.xzy), (tmpvar_31 * tmpvar_23.zxy), vec3(tmpvar_27)), vec3(tmpvar_28));
  uv_25 = (((
    (0.5 * tmpvar_33.yz)
   / 
    abs(tmpvar_33.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_34;
  vec2 tmpvar_35;
  float tmpvar_36;
  tmpvar_36 = (0.5 * _CityOverlayDetailScale);
  tmpvar_35 = abs((uv_25 - tmpvar_36));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  vec4 tmpvar_37;
  tmpvar_37.xy = dFdx(uvCont_34);
  tmpvar_37.zw = dFdy(uvCont_34);
  vec4 tmpvar_38;
  tmpvar_38 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_25, tmpvar_37.xy, tmpvar_37.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_38.xyz;
  vec2 uv_39;
  vec3 tmpvar_40;
  tmpvar_40 = abs(tmpvar_23);
  float tmpvar_41;
  tmpvar_41 = float((tmpvar_40.z >= tmpvar_40.x));
  float tmpvar_42;
  tmpvar_42 = float((max (tmpvar_40.x, tmpvar_40.z) >= tmpvar_40.y));
  float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_41), tmpvar_42));
  vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(tmpvar_43);
  vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = tmpvar_43;
  vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = tmpvar_43;
  vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_23.yxz), mix ((tmpvar_44 * tmpvar_23.xzy), (tmpvar_45 * tmpvar_23.zxy), vec3(tmpvar_41)), vec3(tmpvar_42));
  uv_39 = (((
    (0.5 * tmpvar_47.yz)
   / 
    abs(tmpvar_47.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_48;
  vec2 tmpvar_49;
  tmpvar_49 = abs((uv_39 - tmpvar_36));
  uvCont_48.x = max (tmpvar_49.x, tmpvar_49.y);
  uvCont_48.y = min (tmpvar_49.x, tmpvar_49.y);
  vec4 tmpvar_50;
  tmpvar_50.xy = dFdx(uvCont_48);
  tmpvar_50.zw = dFdy(uvCont_48);
  vec4 tmpvar_51;
  tmpvar_51 = texture2DGradARB (_CityLightOverlayDetailTex, uv_39, tmpvar_50.xy, tmpvar_50.zw);
  citylightoverlaydetail_1.xyz = tmpvar_51.xyz;
  cityoverlay_3.w = (tmpvar_21 * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_38.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_51.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_51.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_52;
  vec3 tmpvar_53;
  tmpvar_53 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_54;
  tmpvar_54 = normalize(normal_20);
  float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, tmpvar_53);
  c_52.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_55) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_53 + normalize(xlv_TEXCOORD1)))
    , tmpvar_54), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_52.w = (tmpvar_55 * 2.0);
  float tmpvar_56;
  tmpvar_56 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_52 * mix (1.0, clamp (
    floor((1.01 + tmpvar_56))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_56))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_57;
  tmpvar_57 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_57;
  gl_FragData[0] = tmpvar_57;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 236 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  mediump float tmpvar_30;
  mediump vec4 v_31;
  v_31 = (tmpvar_29 * alphaMask1);
  tmpvar_30 = ((v_31.x + v_31.y) + (v_31.z + v_31.w));
  mediump vec4 tmpvar_32;
  tmpvar_32.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_32.w = tmpvar_30;
  cityoverlay_4.xyz = tmpvar_32.xyz;
  mediump vec2 uv_33;
  mediump vec3 detailCoords_34;
  mediump float s_35;
  mediump float nylerp_36;
  mediump float zxlerp_37;
  highp vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_27);
  highp float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  zxlerp_37 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  nylerp_36 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_37);
  s_35 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = sign(mix (tmpvar_27.y, s_35, nylerp_36));
  s_35 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = -(s_35);
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = s_35;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_43 * tmpvar_27.xzy), (tmpvar_44 * tmpvar_27.zxy), vec3(zxlerp_37));
  detailCoords_34 = tmpvar_45;
  mediump vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = s_35;
  highp vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_27.yxz), detailCoords_34, vec3(nylerp_36));
  detailCoords_34 = tmpvar_47;
  uv_33 = (((
    (0.5 * detailCoords_34.yz)
   / 
    abs(detailCoords_34.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_48;
  uv_48 = uv_33;
  highp vec2 uvCont_49;
  highp vec2 tmpvar_50;
  highp float tmpvar_51;
  tmpvar_51 = (0.5 * _CityOverlayDetailScale);
  tmpvar_50 = abs((uv_48 - tmpvar_51));
  uvCont_49.x = max (tmpvar_50.x, tmpvar_50.y);
  uvCont_49.y = min (tmpvar_50.x, tmpvar_50.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_49);
  tmpvar_52.zw = dFdy(uvCont_49);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_33, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citydarkoverlaydetail_3.xyz = tmpvar_54.xyz;
  mediump vec2 uv_55;
  mediump vec3 detailCoords_56;
  mediump float s_57;
  mediump float nylerp_58;
  mediump float zxlerp_59;
  highp vec3 tmpvar_60;
  tmpvar_60 = abs(tmpvar_27);
  highp float tmpvar_61;
  tmpvar_61 = float((tmpvar_60.z >= tmpvar_60.x));
  zxlerp_59 = tmpvar_61;
  highp float tmpvar_62;
  tmpvar_62 = float((max (tmpvar_60.x, tmpvar_60.z) >= tmpvar_60.y));
  nylerp_58 = tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_59);
  s_57 = tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = sign(mix (tmpvar_27.y, s_57, nylerp_58));
  s_57 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xz = vec2(1.0, -1.0);
  tmpvar_65.y = -(s_57);
  mediump vec3 tmpvar_66;
  tmpvar_66.xz = vec2(1.0, -1.0);
  tmpvar_66.y = s_57;
  highp vec3 tmpvar_67;
  tmpvar_67 = mix ((tmpvar_65 * tmpvar_27.xzy), (tmpvar_66 * tmpvar_27.zxy), vec3(zxlerp_59));
  detailCoords_56 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68.xy = vec2(1.0, 1.0);
  tmpvar_68.z = s_57;
  highp vec3 tmpvar_69;
  tmpvar_69 = mix ((tmpvar_68 * tmpvar_27.yxz), detailCoords_56, vec3(nylerp_58));
  detailCoords_56 = tmpvar_69;
  uv_55 = (((
    (0.5 * detailCoords_56.yz)
   / 
    abs(detailCoords_56.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_70;
  uv_70 = uv_55;
  highp vec2 uvCont_71;
  highp vec2 tmpvar_72;
  tmpvar_72 = abs((uv_70 - tmpvar_51));
  uvCont_71.x = max (tmpvar_72.x, tmpvar_72.y);
  uvCont_71.y = min (tmpvar_72.x, tmpvar_72.y);
  highp vec4 tmpvar_73;
  tmpvar_73.xy = dFdx(uvCont_71);
  tmpvar_73.zw = dFdy(uvCont_71);
  lowp vec4 tmpvar_74;
  tmpvar_74 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_55, tmpvar_73.xy, tmpvar_73.zw);
  mediump vec4 tmpvar_75;
  tmpvar_75 = tmpvar_74;
  citylightoverlaydetail_2.xyz = tmpvar_75.xyz;
  cityoverlay_4.w = (tmpvar_30 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_54.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_75.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_75.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_76;
  lightDir_76 = xlv_TEXCOORD5;
  mediump vec3 viewDir_77;
  viewDir_77 = xlv_TEXCOORD1;
  mediump vec4 c_78;
  mediump vec3 tmpvar_79;
  tmpvar_79 = normalize(lightDir_76);
  lightDir_76 = tmpvar_79;
  mediump vec3 tmpvar_80;
  tmpvar_80 = normalize(viewDir_77);
  viewDir_77 = tmpvar_80;
  mediump vec3 tmpvar_81;
  tmpvar_81 = normalize(normT_5);
  mediump float tmpvar_82;
  tmpvar_82 = dot (tmpvar_81, tmpvar_79);
  highp float tmpvar_83;
  mediump float tmpvar_84;
  tmpvar_84 = clamp (dot (normalize(
    (tmpvar_79 + tmpvar_80)
  ), tmpvar_81), 0.0, 1.0);
  tmpvar_83 = tmpvar_84;
  highp float tmpvar_85;
  tmpvar_85 = (pow (tmpvar_83, _SpecularPower) * _SpecularColor.w);
  c_78.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_82) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_85)) * 2.0);
  c_78.w = (tmpvar_82 * 2.0);
  highp vec3 tmpvar_86;
  tmpvar_86 = normalize(_SunDir);
  mediump vec3 lightDir_87;
  lightDir_87 = tmpvar_86;
  mediump vec3 normal_88;
  normal_88 = xlv_TEXCOORD3;
  mediump float tmpvar_89;
  tmpvar_89 = dot (normal_88, lightDir_87);
  color_6 = (c_78 * mix (1.0, clamp (
    floor((1.01 + tmpvar_89))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_89))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_90;
  tmpvar_90 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_90;
  tmpvar_1 = tmpvar_90;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec3 t10_4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_14;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
highp float t20;
mediump float t16_23;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_32;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_4.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_19>=1.0;
    t16_5 = (tb1) ? 0.0 : 1.0;
    t10_1 = texture(cube_CityOverlayTex, t9.yxz);
    t16_14.xy = t10_1.xy * alphaMask1.xy;
    t16_14.x = t16_14.y + t16_14.x;
    t16_14.x = t10_1.z * alphaMask1.z + t16_14.x;
    t16_14.x = t10_1.w * alphaMask1.w + t16_14.x;
    t16_5 = t16_5 * t16_14.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_14.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t0.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t0.xy = t16_14.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_14.x = t16_5 * t10_3.w;
    t16_5 = t16_5 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_23 = dot(t10_4.xyz, t10_4.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_7.xyz = t10_4.xyz * vec3(t16_23);
    t16_23 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_8.xyz = vec3(t16_23) * vs_TEXCOORD5.xyz;
    t16_23 = dot(t16_7.xyz, t16_8.xyz);
    t16_23 = t16_23 + t16_23;
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_32 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_32 + 1.00999999;
    t16_32 = t16_32 * -10.0;
    t16_32 = clamp(t16_32, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_32 = t16_32 * t16_33 + 1.0;
    t16_23 = t16_32 * t16_23;
    t16_23 = clamp(t16_23, 0.0, 1.0);
    t16_23 = (-t16_23) + 1.0;
    t16_32 = t16_14.x * t16_23 + (-t16_5);
    t16_14.x = t16_23 * t16_14.x;
    t16_1.w = t16_14.x * t16_32 + t16_5;
    t16_1.xyz = t16_14.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
lowp vec4 t10_1;
vec2 t2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
vec4 t4;
lowp vec4 t10_4;
vec3 t5;
vec3 t6;
vec3 t7;
int ti7;
bvec2 tb7;
vec3 t8;
bool tb8;
vec2 t12;
float t13;
float t14;
int ti14;
float t19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7.x = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7.x;
    t7.x = t1.x * t1.x;
    t13 = t7.x * 0.0208350997 + -0.0851330012;
    t13 = t7.x * t13 + 0.180141002;
    t13 = t7.x * t13 + -0.330299497;
    t7.x = t7.x * t13 + 0.999866009;
    t13 = t7.x * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7.x + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7.x = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7.x + t1.x;
    t7.x = min(t6.z, t6.y);
    tb7.x = t7.x<(-t7.x);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_1 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t1.xy = t10_1.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb19 = t10_4.w>=1.0;
    t19 = (tb19) ? 0.0 : 1.0;
    t10_2 = texture(cube_CityOverlayTex, t6.yxz);
    t2.xy = t10_2.xy * alphaMask1.xy;
    t2.x = t2.y + t2.x;
    t2.x = t10_2.z * alphaMask1.z + t2.x;
    t2.x = t10_2.w * alphaMask1.w + t2.x;
    t19 = t19 * t2.x;
    t2.x = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb8 = abs(t6.z)>=abs(t6.y);
    t8.x = tb8 ? 1.0 : float(0.0);
    t2.x = t8.x * t2.x + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t2.x;
    t2.x = max(abs(t6.z), abs(t6.y));
    tb2 = t2.x>=abs(t6.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t0.x = t2.x * t0.x + t6.x;
    ti14 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti14) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t8.xyz = t8.xxx * t5.xyz + t4.xyz;
    t8.xyz = (-t3.xxy) * t6.xyz + t8.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t2.x = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t12.x);
    t2.y = dFdy(t12.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t2.x = t19 * t4.w;
    t0.w = t19 * t0.w;
    t19 = dot(t1.xy, t1.xy);
    t19 = min(t19, 1.0);
    t19 = (-t19) + 1.0;
    t1.z = sqrt(t19);
    t19 = dot(t1.xyz, t1.xyz);
    t19 = inversesqrt(t19);
    t1.xyz = vec3(t19) * t1.xyz;
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t8.xyz = vec3(t19) * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xyz, t8.xyz);
    t1.x = t1.x + t1.x;
    t7.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t7.x = inversesqrt(t7.x);
    t7.xyz = t7.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t7.x = dot(vs_TEXCOORD3.xyz, t7.xyz);
    t13 = t7.x + 1.00999999;
    t7.x = t7.x * -10.0;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t13 = floor(t13);
    t13 = clamp(t13, 0.0, 1.0);
    t13 = t13 + -1.0;
    t7.x = t7.x * t13 + 1.0;
    t1.x = t7.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t4.w = t1.x * t2.x;
    t1 = (-t0) + t4;
    SV_Target0 = t4.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 242 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;
uniform vec4 _ProjectionParams;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 tmpvar_1;
  tmpvar_1 = (gl_ModelViewProjectionMatrix * gl_Vertex);
  vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = gl_Normal;
  vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(gl_Normal);
  vec3 tmpvar_6;
  tmpvar_6 = normalize(TANGENT.xyz);
  vec3 tmpvar_7;
  vec3 tmpvar_8;
  tmpvar_7 = TANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * TANGENT.w);
  mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = gl_Normal.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = gl_Normal.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = gl_Normal.z;
  vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  vec4 o_11;
  vec4 tmpvar_12;
  tmpvar_12 = (tmpvar_1 * 0.5);
  vec2 tmpvar_13;
  tmpvar_13.x = tmpvar_12.x;
  tmpvar_13.y = (tmpvar_12.y * _ProjectionParams.x);
  o_11.xy = (tmpvar_13 + tmpvar_12.w);
  o_11.zw = tmpvar_1.zw;
  gl_Position = tmpvar_1;
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
  xlv_TEXCOORD6 = o_11;
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform sampler2D _ShadowMapTexture;
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
varying vec4 xlv_TEXCOORD6;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  float tmpvar_21;
  vec4 v_22;
  vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD2);
  v_22 = (textureCube (cube_CityOverlayTex, tmpvar_23) * alphaMask1);
  tmpvar_21 = ((v_22.x + v_22.y) + (v_22.z + v_22.w));
  vec4 tmpvar_24;
  tmpvar_24.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_24.w = tmpvar_21;
  cityoverlay_3.xyz = tmpvar_24.xyz;
  vec2 uv_25;
  vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_23);
  float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_27), tmpvar_28));
  vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(tmpvar_29);
  vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = tmpvar_29;
  vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = tmpvar_29;
  vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), mix ((tmpvar_30 * tmpvar_23.xzy), (tmpvar_31 * tmpvar_23.zxy), vec3(tmpvar_27)), vec3(tmpvar_28));
  uv_25 = (((
    (0.5 * tmpvar_33.yz)
   / 
    abs(tmpvar_33.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_34;
  vec2 tmpvar_35;
  float tmpvar_36;
  tmpvar_36 = (0.5 * _CityOverlayDetailScale);
  tmpvar_35 = abs((uv_25 - tmpvar_36));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  vec4 tmpvar_37;
  tmpvar_37.xy = dFdx(uvCont_34);
  tmpvar_37.zw = dFdy(uvCont_34);
  vec4 tmpvar_38;
  tmpvar_38 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_25, tmpvar_37.xy, tmpvar_37.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_38.xyz;
  vec2 uv_39;
  vec3 tmpvar_40;
  tmpvar_40 = abs(tmpvar_23);
  float tmpvar_41;
  tmpvar_41 = float((tmpvar_40.z >= tmpvar_40.x));
  float tmpvar_42;
  tmpvar_42 = float((max (tmpvar_40.x, tmpvar_40.z) >= tmpvar_40.y));
  float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_41), tmpvar_42));
  vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(tmpvar_43);
  vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = tmpvar_43;
  vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = tmpvar_43;
  vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_23.yxz), mix ((tmpvar_44 * tmpvar_23.xzy), (tmpvar_45 * tmpvar_23.zxy), vec3(tmpvar_41)), vec3(tmpvar_42));
  uv_39 = (((
    (0.5 * tmpvar_47.yz)
   / 
    abs(tmpvar_47.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_48;
  vec2 tmpvar_49;
  tmpvar_49 = abs((uv_39 - tmpvar_36));
  uvCont_48.x = max (tmpvar_49.x, tmpvar_49.y);
  uvCont_48.y = min (tmpvar_49.x, tmpvar_49.y);
  vec4 tmpvar_50;
  tmpvar_50.xy = dFdx(uvCont_48);
  tmpvar_50.zw = dFdy(uvCont_48);
  vec4 tmpvar_51;
  tmpvar_51 = texture2DGradARB (_CityLightOverlayDetailTex, uv_39, tmpvar_50.xy, tmpvar_50.zw);
  citylightoverlaydetail_1.xyz = tmpvar_51.xyz;
  cityoverlay_3.w = (tmpvar_21 * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_38.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_51.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_51.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 tmpvar_52;
  tmpvar_52 = texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6);
  vec4 c_53;
  vec3 tmpvar_54;
  tmpvar_54 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_55;
  tmpvar_55 = normalize(normal_20);
  float tmpvar_56;
  tmpvar_56 = dot (tmpvar_55, tmpvar_54);
  c_53.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_56) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_54 + normalize(xlv_TEXCOORD1)))
    , tmpvar_55), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * (tmpvar_52.x * 2.0));
  c_53.w = (tmpvar_56 * (tmpvar_52.x * 2.0));
  float tmpvar_57;
  tmpvar_57 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_53 * mix (1.0, clamp (
    floor((1.01 + tmpvar_57))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_57))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_58;
  tmpvar_58 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_58;
  gl_FragData[0] = tmpvar_58;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 58 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_ProjectionParams]
Vector 12 [_ScreenParams]
Vector 13 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c14, 1, 0, 0.5, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dcl_texcoord6 o6
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c13
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c14
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0
dp4 r0.y, c1, v0
mul r1.x, r0.y, c11.x
mul r1.w, r1.x, c14.z
dp4 r0.x, c0, v0
dp4 r0.w, c3, v0
mul r1.xz, r0.xyww, c14.z
mad o6.xy, r1.z, c12.zwzw, r1.xwzw
dp4 r0.z, c2, v0
mov o0, r0
mov o6.zw, r0

"
}
SubProgram "d3d11 " {
// Stats: 53 math
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
Vector 80 [_ProjectionParams]
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa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"
}
SubProgram "gles " {
// Stats: 242 math, 6 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 unity_World2Shadow[4];
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  mediump vec4 tmpvar_2;
  highp vec3 tmpvar_3;
  highp vec4 tmpvar_4;
  tmpvar_4 = (_Object2World * _glesVertex);
  tmpvar_3 = (tmpvar_4.xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_5;
  tmpvar_5.w = 0.0;
  tmpvar_5.xyz = tmpvar_1;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 0.0;
  tmpvar_6.xyz = _SunDir;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(_glesNormal);
  highp vec3 tmpvar_8;
  tmpvar_8 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_9;
  highp vec3 tmpvar_10;
  tmpvar_9 = _glesTANGENT.xyz;
  tmpvar_10 = (((tmpvar_7.yzx * tmpvar_8.zxy) - (tmpvar_7.zxy * tmpvar_8.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_11;
  tmpvar_11[0].x = tmpvar_9.x;
  tmpvar_11[0].y = tmpvar_10.x;
  tmpvar_11[0].z = tmpvar_1.x;
  tmpvar_11[1].x = tmpvar_9.y;
  tmpvar_11[1].y = tmpvar_10.y;
  tmpvar_11[1].z = tmpvar_1.y;
  tmpvar_11[2].x = tmpvar_9.z;
  tmpvar_11[2].y = tmpvar_10.z;
  tmpvar_11[2].z = tmpvar_1.z;
  highp vec4 tmpvar_12;
  tmpvar_12.w = 1.0;
  tmpvar_12.xyz = _WorldSpaceCameraPos;
  tmpvar_2 = (unity_World2Shadow[0] * tmpvar_4);
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_3, tmpvar_3));
  xlv_TEXCOORD1 = normalize((tmpvar_11 * (
    (_World2Object * tmpvar_12)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_5).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_11 * (_World2Object * tmpvar_6).xyz));
  xlv_TEXCOORD6 = tmpvar_2;
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform mediump vec4 _LightShadowData;
uniform highp sampler2D _ShadowMapTexture;
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
varying mediump vec4 xlv_TEXCOORD6;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  mediump float tmpvar_30;
  mediump vec4 v_31;
  v_31 = (tmpvar_29 * alphaMask1);
  tmpvar_30 = ((v_31.x + v_31.y) + (v_31.z + v_31.w));
  mediump vec4 tmpvar_32;
  tmpvar_32.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_32.w = tmpvar_30;
  cityoverlay_4.xyz = tmpvar_32.xyz;
  mediump vec2 uv_33;
  mediump vec3 detailCoords_34;
  mediump float s_35;
  mediump float nylerp_36;
  mediump float zxlerp_37;
  highp vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_27);
  highp float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  zxlerp_37 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  nylerp_36 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_37);
  s_35 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = sign(mix (tmpvar_27.y, s_35, nylerp_36));
  s_35 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = -(s_35);
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = s_35;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_43 * tmpvar_27.xzy), (tmpvar_44 * tmpvar_27.zxy), vec3(zxlerp_37));
  detailCoords_34 = tmpvar_45;
  mediump vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = s_35;
  highp vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_27.yxz), detailCoords_34, vec3(nylerp_36));
  detailCoords_34 = tmpvar_47;
  uv_33 = (((
    (0.5 * detailCoords_34.yz)
   / 
    abs(detailCoords_34.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_48;
  uv_48 = uv_33;
  highp vec2 uvCont_49;
  highp vec2 tmpvar_50;
  highp float tmpvar_51;
  tmpvar_51 = (0.5 * _CityOverlayDetailScale);
  tmpvar_50 = abs((uv_48 - tmpvar_51));
  uvCont_49.x = max (tmpvar_50.x, tmpvar_50.y);
  uvCont_49.y = min (tmpvar_50.x, tmpvar_50.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_49);
  tmpvar_52.zw = dFdy(uvCont_49);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_33, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citydarkoverlaydetail_3.xyz = tmpvar_54.xyz;
  mediump vec2 uv_55;
  mediump vec3 detailCoords_56;
  mediump float s_57;
  mediump float nylerp_58;
  mediump float zxlerp_59;
  highp vec3 tmpvar_60;
  tmpvar_60 = abs(tmpvar_27);
  highp float tmpvar_61;
  tmpvar_61 = float((tmpvar_60.z >= tmpvar_60.x));
  zxlerp_59 = tmpvar_61;
  highp float tmpvar_62;
  tmpvar_62 = float((max (tmpvar_60.x, tmpvar_60.z) >= tmpvar_60.y));
  nylerp_58 = tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_59);
  s_57 = tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = sign(mix (tmpvar_27.y, s_57, nylerp_58));
  s_57 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xz = vec2(1.0, -1.0);
  tmpvar_65.y = -(s_57);
  mediump vec3 tmpvar_66;
  tmpvar_66.xz = vec2(1.0, -1.0);
  tmpvar_66.y = s_57;
  highp vec3 tmpvar_67;
  tmpvar_67 = mix ((tmpvar_65 * tmpvar_27.xzy), (tmpvar_66 * tmpvar_27.zxy), vec3(zxlerp_59));
  detailCoords_56 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68.xy = vec2(1.0, 1.0);
  tmpvar_68.z = s_57;
  highp vec3 tmpvar_69;
  tmpvar_69 = mix ((tmpvar_68 * tmpvar_27.yxz), detailCoords_56, vec3(nylerp_58));
  detailCoords_56 = tmpvar_69;
  uv_55 = (((
    (0.5 * detailCoords_56.yz)
   / 
    abs(detailCoords_56.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_70;
  uv_70 = uv_55;
  highp vec2 uvCont_71;
  highp vec2 tmpvar_72;
  tmpvar_72 = abs((uv_70 - tmpvar_51));
  uvCont_71.x = max (tmpvar_72.x, tmpvar_72.y);
  uvCont_71.y = min (tmpvar_72.x, tmpvar_72.y);
  highp vec4 tmpvar_73;
  tmpvar_73.xy = dFdx(uvCont_71);
  tmpvar_73.zw = dFdy(uvCont_71);
  lowp vec4 tmpvar_74;
  tmpvar_74 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_55, tmpvar_73.xy, tmpvar_73.zw);
  mediump vec4 tmpvar_75;
  tmpvar_75 = tmpvar_74;
  citylightoverlaydetail_2.xyz = tmpvar_75.xyz;
  cityoverlay_4.w = (tmpvar_30 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_54.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_75.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_75.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  lowp float tmpvar_76;
  highp float tmpvar_77;
  tmpvar_77 = max (float((texture2DProj (_ShadowMapTexture, xlv_TEXCOORD6).x > 
    (xlv_TEXCOORD6.z / xlv_TEXCOORD6.w)
  )), _LightShadowData.x);
  tmpvar_76 = tmpvar_77;
  mediump vec3 lightDir_78;
  lightDir_78 = xlv_TEXCOORD5;
  mediump vec3 viewDir_79;
  viewDir_79 = xlv_TEXCOORD1;
  mediump float atten_80;
  atten_80 = tmpvar_76;
  mediump vec4 c_81;
  mediump vec3 tmpvar_82;
  tmpvar_82 = normalize(lightDir_78);
  lightDir_78 = tmpvar_82;
  mediump vec3 tmpvar_83;
  tmpvar_83 = normalize(viewDir_79);
  viewDir_79 = tmpvar_83;
  mediump vec3 tmpvar_84;
  tmpvar_84 = normalize(normT_5);
  mediump float tmpvar_85;
  tmpvar_85 = dot (tmpvar_84, tmpvar_82);
  highp float tmpvar_86;
  mediump float tmpvar_87;
  tmpvar_87 = clamp (dot (normalize(
    (tmpvar_82 + tmpvar_83)
  ), tmpvar_84), 0.0, 1.0);
  tmpvar_86 = tmpvar_87;
  highp float tmpvar_88;
  tmpvar_88 = (pow (tmpvar_86, _SpecularPower) * _SpecularColor.w);
  c_81.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_85) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_88)) * (atten_80 * 2.0));
  c_81.w = (tmpvar_85 * (atten_80 * 2.0));
  highp vec3 tmpvar_89;
  tmpvar_89 = normalize(_SunDir);
  mediump vec3 lightDir_90;
  lightDir_90 = tmpvar_89;
  mediump vec3 normal_91;
  normal_91 = xlv_TEXCOORD3;
  mediump float tmpvar_92;
  tmpvar_92 = dot (normal_91, lightDir_90);
  color_6 = (c_81 * mix (1.0, clamp (
    floor((1.01 + tmpvar_92))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_92))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_93;
  tmpvar_93 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_93;
  tmpvar_1 = tmpvar_93;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_SCREEN" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
out vec4 vs_TEXCOORD6;
vec4 t0;
vec4 t1;
vec3 t2;
vec3 t3;
vec3 t7;
float t13;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    t0 = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    gl_Position = t0;
    t1.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t1.x = inversesqrt(t1.x);
    t1.xyz = t1.xxx * in_NORMAL0.zxy;
    t13 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_TANGENT0.yzx;
    t3.xyz = t1.xyz * t2.xyz;
    t1.xyz = t1.zxy * t2.yzx + (-t3.xyz);
    t1.xyz = t1.xyz * in_TANGENT0.www;
    t2.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t2.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t2.xyz;
    t2.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t2.xyz;
    t2.xyz = t2.xyz + _World2Object[3].xyz;
    t2.xyz = t2.xyz + (-in_POSITION0.xyz);
    t7.y = dot(t1.xyz, t2.xyz);
    t7.x = dot(in_TANGENT0.xyz, t2.xyz);
    t7.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t7.xyz, t7.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD1.xyz = vec3(t13) * t7.xyz;
    t2.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t2.xyz;
    t2.xyz = _Object2World[3].xyz * in_POSITION0.www + t2.xyz;
    t2.xyz = t2.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t13 = dot(t2.xyz, t2.xyz);
    vs_TEXCOORD0 = sqrt(t13);
    t13 = dot(in_POSITION0, in_POSITION0);
    t13 = inversesqrt(t13);
    t2.xyz = vec3(t13) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t2.xyz);
    t2.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t2.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t2.xyz;
    t2.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t2.xyz;
    t13 = dot(t2.xyz, t2.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD3.xyz = vec3(t13) * t2.xyz;
    t2.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t2.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t2.xyz;
    t2.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t2.xyz;
    t1.y = dot(t1.xyz, t2.xyz);
    t1.x = dot(in_TANGENT0.xyz, t2.xyz);
    t1.z = dot(in_NORMAL0.xyz, t2.xyz);
    t13 = dot(t1.xyz, t1.xyz);
    t13 = inversesqrt(t13);
    vs_TEXCOORD5.xyz = vec3(t13) * t1.xyz;
    t0.y = t0.y * _ProjectionParams.x;
    t1.xzw = t0.xwy * vec3(0.5, 0.5, 0.5);
    vs_TEXCOORD6.zw = t0.zw;
    vs_TEXCOORD6.xy = t1.zz + t1.xw;
    return;
}

#endif
#ifdef FRAGMENT
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform  sampler2D _MainTex;
uniform  sampler2D _BumpMap;
uniform  samplerCube cube_CityOverlayTex;
uniform  sampler2D _CityDarkOverlayDetailTex;
uniform  sampler2D _CityLightOverlayDetailTex;
uniform  sampler2D _ShadowMapTexture;
in  vec3 vs_TEXCOORD2;
in  vec3 vs_TEXCOORD3;
in  vec3 vs_TEXCOORD5;
in  vec4 vs_TEXCOORD6;
out vec4 SV_Target0;
vec4 t0;
int ti0;
vec4 t1;
lowp vec4 t10_1;
vec2 t2;
lowp vec4 t10_2;
bool tb2;
vec3 t3;
lowp vec4 t10_3;
vec4 t4;
lowp vec4 t10_4;
vec3 t5;
vec3 t6;
vec3 t7;
int ti7;
bvec2 tb7;
vec3 t8;
bool tb8;
vec2 t12;
float t13;
float t14;
int ti14;
float t19;
bool tb19;
float t20;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t6.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t6.z), abs(t6.y));
    t1.x = float(1.0) / t1.x;
    t7.x = min(abs(t6.z), abs(t6.y));
    t1.x = t1.x * t7.x;
    t7.x = t1.x * t1.x;
    t13 = t7.x * 0.0208350997 + -0.0851330012;
    t13 = t7.x * t13 + 0.180141002;
    t13 = t7.x * t13 + -0.330299497;
    t7.x = t7.x * t13 + 0.999866009;
    t13 = t7.x * t1.x;
    t13 = t13 * -2.0 + 1.57079637;
    tb19 = abs(t6.z)<abs(t6.y);
    t13 = tb19 ? t13 : float(0.0);
    t1.x = t1.x * t7.x + t13;
    tb7.xy = lessThan(t6.zxzz, (-t6.zxzz)).xy;
    t7.x = tb7.x ? -3.14159274 : float(0.0);
    t1.x = t7.x + t1.x;
    t7.x = min(t6.z, t6.y);
    tb7.x = t7.x<(-t7.x);
    t19 = max(t6.z, t6.y);
    tb19 = t19>=(-t19);
    ti7 = int(uint(tb19) * 0xffffffffu & uint(tb7.x) * 0xffffffffu);
    t1.x = (ti7 != 0) ? (-t1.x) : t1.x;
    t7.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t7.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t19 = abs(t6.x) * -0.0187292993 + 0.0742610022;
    t19 = t19 * abs(t6.x) + -0.212114394;
    t19 = t19 * abs(t6.x) + 1.57072878;
    t14 = -abs(t6.x) + 1.0;
    t14 = sqrt(t14);
    t20 = t19 * t14;
    t20 = t20 * -2.0 + 3.14159274;
    t13 = tb7.y ? t20 : float(0.0);
    t13 = t19 * t14 + t13;
    t2.y = t13 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_4 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t10_1 = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy);
    t1.xy = t10_1.wy * vec2(2.0, 2.0) + vec2(-1.0, -1.0);
    tb19 = t10_4.w>=1.0;
    t19 = (tb19) ? 0.0 : 1.0;
    t10_2 = texture(cube_CityOverlayTex, t6.yxz);
    t2.xy = t10_2.xy * alphaMask1.xy;
    t2.x = t2.y + t2.x;
    t2.x = t10_2.z * alphaMask1.z + t2.x;
    t2.x = t10_2.w * alphaMask1.w + t2.x;
    t19 = t19 * t2.x;
    t2.x = vs_TEXCOORD2.z * t0.x + (-t6.y);
    tb8 = abs(t6.z)>=abs(t6.y);
    t8.x = tb8 ? 1.0 : float(0.0);
    t2.x = t8.x * t2.x + t6.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t2.x;
    t2.x = max(abs(t6.z), abs(t6.y));
    tb2 = t2.x>=abs(t6.x);
    t2.x = tb2 ? 1.0 : float(0.0);
    t0.x = t2.x * t0.x + t6.x;
    ti14 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti14) + ti0;
    t3.y = float(ti0);
    t4.y = (-t3.y);
    t4.xz = vec2(1.0, -1.0);
    t4.xyz = t6.yzx * t4.xyz;
    t3.xz = vec2(1.0, -1.0);
    t5.xyz = t3.xyz * t6.zyx + (-t4.xyz);
    t8.xyz = t8.xxx * t5.xyz + t4.xyz;
    t8.xyz = (-t3.xxy) * t6.xyz + t8.xyz;
    t0.xyz = t6.xyz * t3.xxy;
    t0.xyz = t2.xxx * t8.xyz + t0.xyz;
    t6.xy = t0.yz * vec2(0.5, 0.5);
    t0.xy = t6.xy / abs(t0.xx);
    t0.xy = t0.xy + vec2(0.5, 0.5);
    t0.xy = t0.xy * vec2(_CityOverlayDetailScale);
    t12.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t2.x = max(abs(t12.y), abs(t12.x));
    t12.x = min(abs(t12.y), abs(t12.x));
    t3.x = dFdx(t2.x);
    t2.x = dFdy(t2.x);
    t3.y = dFdx(t12.x);
    t2.y = dFdy(t12.x);
    t4 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t3.xyxx).xy, vec4(t2.xyxx).xy);
    t2.x = t19 * t4.w;
    t0.w = t19 * t0.w;
    t19 = dot(t1.xy, t1.xy);
    t19 = min(t19, 1.0);
    t19 = (-t19) + 1.0;
    t1.z = sqrt(t19);
    t19 = dot(t1.xyz, t1.xyz);
    t19 = inversesqrt(t19);
    t1.xyz = vec3(t19) * t1.xyz;
    t19 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t19 = inversesqrt(t19);
    t8.xyz = vec3(t19) * vs_TEXCOORD5.xyz;
    t1.x = dot(t1.xyz, t8.xyz);
    t7.xy = vs_TEXCOORD6.xy / vs_TEXCOORD6.ww;
    t10_3 = texture(_ShadowMapTexture, t7.xy);
    t1.x = dot(t10_3.xx, t1.xx);
    t7.x = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t7.x = inversesqrt(t7.x);
    t7.xyz = t7.xxx * vec3(_SunDir.x, _SunDir.y, _SunDir.z);
    t7.x = dot(vs_TEXCOORD3.xyz, t7.xyz);
    t13 = t7.x + 1.00999999;
    t7.x = t7.x * -10.0;
    t7.x = clamp(t7.x, 0.0, 1.0);
    t13 = floor(t13);
    t13 = clamp(t13, 0.0, 1.0);
    t13 = t13 + -1.0;
    t7.x = t7.x * t13 + 1.0;
    t1.x = t7.x * t1.x;
    t1.x = clamp(t1.x, 0.0, 1.0);
    t1.x = (-t1.x) + 1.0;
    t4.w = t1.x * t2.x;
    t1 = (-t0) + t4;
    SV_Target0 = t4.wwww * t1 + t0;
    return;
}

#endif
"
}
SubProgram "opengl " {
// Stats: 240 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLSL#version 120

#ifdef VERTEX
uniform vec3 _WorldSpaceCameraPos;

uniform mat4 _Object2World;
uniform mat4 _World2Object;
uniform vec3 _SunDir;
attribute vec4 TANGENT;
varying float xlv_TEXCOORD0;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec3 tmpvar_1;
  tmpvar_1 = ((_Object2World * gl_Vertex).xyz - _WorldSpaceCameraPos);
  vec4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = gl_Normal;
  vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _SunDir;
  vec3 tmpvar_4;
  tmpvar_4 = normalize(gl_Normal);
  vec3 tmpvar_5;
  tmpvar_5 = normalize(TANGENT.xyz);
  vec3 tmpvar_6;
  vec3 tmpvar_7;
  tmpvar_6 = TANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * TANGENT.w);
  mat3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = gl_Normal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = gl_Normal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = gl_Normal.z;
  vec4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _WorldSpaceCameraPos;
  gl_Position = (gl_ModelViewProjectionMatrix * gl_Vertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_World2Object * tmpvar_9)
  .xyz - gl_Vertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(gl_Vertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_2).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_8 * (_World2Object * tmpvar_3).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_ARB_shader_texture_lod : enable
uniform vec4 _LightColor0;
uniform vec4 alphaMask1;
uniform samplerCube cube_CityOverlayTex;
uniform float _SpecularPower;
uniform vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform vec3 _SunDir;
uniform float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying vec3 xlv_TEXCOORD1;
varying vec3 xlv_TEXCOORD2;
varying vec3 xlv_TEXCOORD3;
varying vec3 xlv_TEXCOORD5;
void main ()
{
  vec4 citylightoverlaydetail_1;
  vec4 citydarkoverlaydetail_2;
  vec4 cityoverlay_3;
  vec4 color_4;
  vec3 tmpvar_5;
  tmpvar_5 = normalize(xlv_TEXCOORD2);
  vec2 uv_6;
  float tmpvar_7;
  float tmpvar_8;
  tmpvar_8 = (min (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0) / max (abs(
    (tmpvar_5.x / tmpvar_5.z)
  ), 1.0));
  float tmpvar_9;
  tmpvar_9 = (tmpvar_8 * tmpvar_8);
  tmpvar_9 = (((
    ((((
      ((((-0.01213232 * tmpvar_9) + 0.05368138) * tmpvar_9) - 0.1173503)
     * tmpvar_9) + 0.1938925) * tmpvar_9) - 0.3326756)
   * tmpvar_9) + 0.9999793) * tmpvar_8);
  tmpvar_9 = (tmpvar_9 + (float(
    (abs((tmpvar_5.x / tmpvar_5.z)) > 1.0)
  ) * (
    (tmpvar_9 * -2.0)
   + 1.570796)));
  tmpvar_7 = (tmpvar_9 * sign((tmpvar_5.x / tmpvar_5.z)));
  if ((abs(tmpvar_5.z) > (1e-08 * abs(tmpvar_5.x)))) {
    if ((tmpvar_5.z < 0.0)) {
      if ((tmpvar_5.x >= 0.0)) {
        tmpvar_7 += 3.141593;
      } else {
        tmpvar_7 = (tmpvar_7 - 3.141593);
      };
    };
  } else {
    tmpvar_7 = (sign(tmpvar_5.x) * 1.570796);
  };
  uv_6.x = (0.5 + (0.1591549 * tmpvar_7));
  uv_6.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_5.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_5.y)
    )) * (1.570796 + (
      abs(tmpvar_5.y)
     * 
      (-0.2146018 + (abs(tmpvar_5.y) * (0.08656672 + (
        abs(tmpvar_5.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_10;
  uvCont_10.y = uv_6.y;
  uvCont_10.x = abs((uv_6.x - 0.5));
  vec4 tmpvar_11;
  tmpvar_11.xy = dFdx(uvCont_10);
  tmpvar_11.zw = dFdy(uvCont_10);
  vec4 tmpvar_12;
  tmpvar_12 = texture2DGradARB (_MainTex, uv_6, tmpvar_11.xy, tmpvar_11.zw);
  vec3 tmpvar_13;
  tmpvar_13 = normalize(xlv_TEXCOORD2);
  vec2 uv_14;
  float tmpvar_15;
  float tmpvar_16;
  tmpvar_16 = (min (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0) / max (abs(
    (tmpvar_13.x / tmpvar_13.z)
  ), 1.0));
  float tmpvar_17;
  tmpvar_17 = (tmpvar_16 * tmpvar_16);
  tmpvar_17 = (((
    ((((
      ((((-0.01213232 * tmpvar_17) + 0.05368138) * tmpvar_17) - 0.1173503)
     * tmpvar_17) + 0.1938925) * tmpvar_17) - 0.3326756)
   * tmpvar_17) + 0.9999793) * tmpvar_16);
  tmpvar_17 = (tmpvar_17 + (float(
    (abs((tmpvar_13.x / tmpvar_13.z)) > 1.0)
  ) * (
    (tmpvar_17 * -2.0)
   + 1.570796)));
  tmpvar_15 = (tmpvar_17 * sign((tmpvar_13.x / tmpvar_13.z)));
  if ((abs(tmpvar_13.z) > (1e-08 * abs(tmpvar_13.x)))) {
    if ((tmpvar_13.z < 0.0)) {
      if ((tmpvar_13.x >= 0.0)) {
        tmpvar_15 += 3.141593;
      } else {
        tmpvar_15 = (tmpvar_15 - 3.141593);
      };
    };
  } else {
    tmpvar_15 = (sign(tmpvar_13.x) * 1.570796);
  };
  uv_14.x = (0.5 + (0.1591549 * tmpvar_15));
  uv_14.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_13.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_13.y)
    )) * (1.570796 + (
      abs(tmpvar_13.y)
     * 
      (-0.2146018 + (abs(tmpvar_13.y) * (0.08656672 + (
        abs(tmpvar_13.y)
       * -0.03102955))))
    ))))
  )));
  vec2 uvCont_18;
  uvCont_18.y = uv_14.y;
  uvCont_18.x = abs((uv_14.x - 0.5));
  vec4 tmpvar_19;
  tmpvar_19.xy = dFdx(uvCont_18);
  tmpvar_19.zw = dFdy(uvCont_18);
  vec3 normal_20;
  normal_20.xy = ((texture2DGradARB (_BumpMap, uv_14, tmpvar_19.xy, tmpvar_19.zw).wy * 2.0) - 1.0);
  normal_20.z = sqrt((1.0 - clamp (
    dot (normal_20.xy, normal_20.xy)
  , 0.0, 1.0)));
  float tmpvar_21;
  vec4 v_22;
  vec3 tmpvar_23;
  tmpvar_23 = normalize(xlv_TEXCOORD2);
  v_22 = (textureCube (cube_CityOverlayTex, tmpvar_23) * alphaMask1);
  tmpvar_21 = ((v_22.x + v_22.y) + (v_22.z + v_22.w));
  vec4 tmpvar_24;
  tmpvar_24.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_24.w = tmpvar_21;
  cityoverlay_3.xyz = tmpvar_24.xyz;
  vec2 uv_25;
  vec3 tmpvar_26;
  tmpvar_26 = abs(tmpvar_23);
  float tmpvar_27;
  tmpvar_27 = float((tmpvar_26.z >= tmpvar_26.x));
  float tmpvar_28;
  tmpvar_28 = float((max (tmpvar_26.x, tmpvar_26.z) >= tmpvar_26.y));
  float tmpvar_29;
  tmpvar_29 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_27), tmpvar_28));
  vec3 tmpvar_30;
  tmpvar_30.xz = vec2(1.0, -1.0);
  tmpvar_30.y = -(tmpvar_29);
  vec3 tmpvar_31;
  tmpvar_31.xz = vec2(1.0, -1.0);
  tmpvar_31.y = tmpvar_29;
  vec3 tmpvar_32;
  tmpvar_32.xy = vec2(1.0, 1.0);
  tmpvar_32.z = tmpvar_29;
  vec3 tmpvar_33;
  tmpvar_33 = mix ((tmpvar_32 * tmpvar_23.yxz), mix ((tmpvar_30 * tmpvar_23.xzy), (tmpvar_31 * tmpvar_23.zxy), vec3(tmpvar_27)), vec3(tmpvar_28));
  uv_25 = (((
    (0.5 * tmpvar_33.yz)
   / 
    abs(tmpvar_33.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_34;
  vec2 tmpvar_35;
  float tmpvar_36;
  tmpvar_36 = (0.5 * _CityOverlayDetailScale);
  tmpvar_35 = abs((uv_25 - tmpvar_36));
  uvCont_34.x = max (tmpvar_35.x, tmpvar_35.y);
  uvCont_34.y = min (tmpvar_35.x, tmpvar_35.y);
  vec4 tmpvar_37;
  tmpvar_37.xy = dFdx(uvCont_34);
  tmpvar_37.zw = dFdy(uvCont_34);
  vec4 tmpvar_38;
  tmpvar_38 = texture2DGradARB (_CityDarkOverlayDetailTex, uv_25, tmpvar_37.xy, tmpvar_37.zw);
  citydarkoverlaydetail_2.xyz = tmpvar_38.xyz;
  vec2 uv_39;
  vec3 tmpvar_40;
  tmpvar_40 = abs(tmpvar_23);
  float tmpvar_41;
  tmpvar_41 = float((tmpvar_40.z >= tmpvar_40.x));
  float tmpvar_42;
  tmpvar_42 = float((max (tmpvar_40.x, tmpvar_40.z) >= tmpvar_40.y));
  float tmpvar_43;
  tmpvar_43 = sign(mix (tmpvar_23.y, mix (tmpvar_23.x, tmpvar_23.z, tmpvar_41), tmpvar_42));
  vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = -(tmpvar_43);
  vec3 tmpvar_45;
  tmpvar_45.xz = vec2(1.0, -1.0);
  tmpvar_45.y = tmpvar_43;
  vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = tmpvar_43;
  vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_23.yxz), mix ((tmpvar_44 * tmpvar_23.xzy), (tmpvar_45 * tmpvar_23.zxy), vec3(tmpvar_41)), vec3(tmpvar_42));
  uv_39 = (((
    (0.5 * tmpvar_47.yz)
   / 
    abs(tmpvar_47.x)
  ) + 0.5) * _CityOverlayDetailScale);
  vec2 uvCont_48;
  vec2 tmpvar_49;
  tmpvar_49 = abs((uv_39 - tmpvar_36));
  uvCont_48.x = max (tmpvar_49.x, tmpvar_49.y);
  uvCont_48.y = min (tmpvar_49.x, tmpvar_49.y);
  vec4 tmpvar_50;
  tmpvar_50.xy = dFdx(uvCont_48);
  tmpvar_50.zw = dFdy(uvCont_48);
  vec4 tmpvar_51;
  tmpvar_51 = texture2DGradARB (_CityLightOverlayDetailTex, uv_39, tmpvar_50.xy, tmpvar_50.zw);
  citylightoverlaydetail_1.xyz = tmpvar_51.xyz;
  cityoverlay_3.w = (tmpvar_21 * (1.0 - float(
    (tmpvar_12.w >= 1.0)
  )));
  citydarkoverlaydetail_2.w = (tmpvar_38.w * cityoverlay_3.w);
  citylightoverlaydetail_1.w = (tmpvar_51.w * cityoverlay_3.w);
  color_4.xyz = (tmpvar_51.xyz * citylightoverlaydetail_1.www);
  color_4.w = 0.0;
  vec4 c_52;
  vec3 tmpvar_53;
  tmpvar_53 = normalize(xlv_TEXCOORD5);
  vec3 tmpvar_54;
  tmpvar_54 = normalize(normal_20);
  float tmpvar_55;
  tmpvar_55 = dot (tmpvar_54, tmpvar_53);
  c_52.xyz = (((
    (color_4.xyz * _LightColor0.xyz)
   * tmpvar_55) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * 
    (pow (clamp (dot (
      normalize((tmpvar_53 + normalize(xlv_TEXCOORD1)))
    , tmpvar_54), 0.0, 1.0), _SpecularPower) * _SpecularColor.w)
  )) * 2.0);
  c_52.w = (tmpvar_55 * 2.0);
  float tmpvar_56;
  tmpvar_56 = dot (xlv_TEXCOORD3, normalize(_SunDir));
  color_4 = (c_52 * mix (1.0, clamp (
    floor((1.01 + tmpvar_56))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_56))
  , 0.0, 1.0)));
  citydarkoverlaydetail_2.w = (citydarkoverlaydetail_2.w * (1.0 - clamp (color_4.w, 0.0, 1.0)));
  vec4 tmpvar_57;
  tmpvar_57 = mix (citylightoverlaydetail_1, citydarkoverlaydetail_2, citydarkoverlaydetail_2.wwww);
  color_4 = tmpvar_57;
  gl_FragData[0] = tmpvar_57;
}


#endif
"
}
SubProgram "d3d9 " {
// Stats: 52 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
Matrix 4 [_Object2World] 3
Matrix 7 [_World2Object] 3
Matrix 0 [glstate_matrix_mvp]
Vector 11 [_SunDir]
Vector 10 [_WorldSpaceCameraPos]
"vs_3_0
def c12, 1, 0, 0, 0
dcl_position v0
dcl_normal v1
dcl_tangent v2
dcl_position o0
dcl_texcoord o1.x
dcl_texcoord1 o2.xyz
dcl_texcoord2 o3.xyz
dcl_texcoord3 o4.xyz
dcl_texcoord5 o5.xyz
dp4 o0.x, c0, v0
dp4 o0.y, c1, v0
dp4 o0.z, c2, v0
dp4 o0.w, c3, v0
dp4 r0.x, c4, v0
dp4 r0.y, c5, v0
dp4 r0.z, c6, v0
add r0.xyz, r0, -c10
dp3 r0.x, r0, r0
rsq r0.x, r0.x
rcp o1.x, r0.x
dp4 r0.x, v0, v0
rsq r0.x, r0.x
mul r0.xyz, r0.x, v0
mov o3.xyz, -r0
dp3 r0.x, c4, v1
dp3 r0.y, c5, v1
dp3 r0.z, c6, v1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o4.xyz, r0.w, r0
dp3 r0.x, v1, v1
rsq r0.x, r0.x
mul r0.xyz, r0.x, v1.zxyw
dp3 r0.w, v2, v2
rsq r0.w, r0.w
mul r1.xyz, r0.w, v2.yzxw
mul r2.xyz, r0, r1
mad r0.xyz, r0.zxyw, r1.yzxw, -r2
mul r0.xyz, r0, v2.w
mov r1.xyz, c11
dp3 r2.x, c7, r1
dp3 r2.y, c8, r1
dp3 r2.z, c9, r1
dp3 r1.y, r0, r2
dp3 r1.x, v2, r2
dp3 r1.z, v1, r2
dp3 r0.w, r1, r1
rsq r0.w, r0.w
mul o5.xyz, r0.w, r1
mov r1.xy, c12
mad r1, c10.xyzx, r1.xxxy, r1.yyyx
dp4 r2.x, c7, r1
dp4 r2.y, c8, r1
dp4 r2.z, c9, r1
add r1.xyz, r2, -v0
dp3 r0.y, r0, r1
dp3 r0.x, v2, r1
dp3 r0.z, v1, r1
dp3 r0.w, r0, r0
rsq r0.w, r0.w
mul o2.xyz, r0.w, r0

"
}
SubProgram "d3d11 " {
// Stats: 50 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "vertex" Vertex
Bind "normal" Normal
Bind "tangent" TexCoord4
ConstBuffer "$Globals" 448
Vector 420 [_SunDir] 3
ConstBuffer "UnityPerCamera" 144
Vector 64 [_WorldSpaceCameraPos] 3
ConstBuffer "UnityPerDraw" 352
Matrix 0 [glstate_matrix_mvp]
Matrix 192 [_Object2World]
Matrix 256 [_World2Object]
BindCB  "$Globals" 0
BindCB  "UnityPerCamera" 1
BindCB  "UnityPerDraw" 2
"vs_4_0
root12:aaadaaaa
eefiecedkdmflccgijkpncgpahgfjlmhfkmdhbmjabaaaaaaceaiaaaaadaaaaaa
cmaaaaaajmaaaaaafeabaaaaejfdeheogiaaaaaaadaaaaaaaiaaaaaafaaaaaaa
aaaaaaaaaaaaaaaaadaaaaaaaaaaaaaaapapaaaafjaaaaaaaaaaaaaaaaaaaaaa
adaaaaaaabaaaaaaahahaaaagaaaaaaaaaaaaaaaaaaaaaaaadaaaaaaacaaaaaa
apapaaaafaepfdejfeejepeoaaeoepfcenebemaafeebeoehefeofeaaepfdeheo
laaaaaaaagaaaaaaaiaaaaaajiaaaaaaaaaaaaaaabaaaaaaadaaaaaaaaaaaaaa
apaaaaaakeaaaaaaaaaaaaaaaaaaaaaaadaaaaaaabaaaaaaabaoaaaakeaaaaaa
abaaaaaaaaaaaaaaadaaaaaaabaaaaaaaoabaaaakeaaaaaaacaaaaaaaaaaaaaa
adaaaaaaacaaaaaaahaiaaaakeaaaaaaadaaaaaaaaaaaaaaadaaaaaaadaaaaaa
ahaiaaaakeaaaaaaafaaaaaaaaaaaaaaadaaaaaaaeaaaaaaahaiaaaafdfgfpfa
epfdejfeejepeoaafeeffiedepepfceeaaklklklfdeieefcmiagaaaaeaaaabaa
lcabaaaafjaaaaaeegiocaaaaaaaaaaablaaaaaafjaaaaaeegiocaaaabaaaaaa
afaaaaaafjaaaaaeegiocaaaacaaaaaabeaaaaaafpaaaaadpcbabaaaaaaaaaaa
fpaaaaadhcbabaaaabaaaaaafpaaaaadpcbabaaaacaaaaaaghaaaaaepccabaaa
aaaaaaaaabaaaaaagfaaaaadbccabaaaabaaaaaagfaaaaadoccabaaaabaaaaaa
gfaaaaadhccabaaaacaaaaaagfaaaaadhccabaaaadaaaaaagfaaaaadhccabaaa
aeaaaaaagiaaaaacadaaaaaadiaaaaaipcaabaaaaaaaaaaafgbfbaaaaaaaaaaa
egiocaaaacaaaaaaabaaaaaadcaaaaakpcaabaaaaaaaaaaaegiocaaaacaaaaaa
aaaaaaaaagbabaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaakpcaabaaaaaaaaaaa
egiocaaaacaaaaaaacaaaaaakgbkbaaaaaaaaaaaegaobaaaaaaaaaaadcaaaaak
pccabaaaaaaaaaaaegiocaaaacaaaaaaadaaaaaapgbpbaaaaaaaaaaaegaobaaa
aaaaaaaabaaaaaahbcaabaaaaaaaaaaaegbcbaaaabaaaaaaegbcbaaaabaaaaaa
eeaaaaafbcaabaaaaaaaaaaaakaabaaaaaaaaaaadiaaaaahhcaabaaaaaaaaaaa
agaabaaaaaaaaaaacgbjbaaaabaaaaaabaaaaaahicaabaaaaaaaaaaaegbcbaaa
acaaaaaaegbcbaaaacaaaaaaeeaaaaaficaabaaaaaaaaaaadkaabaaaaaaaaaaa
diaaaaahhcaabaaaabaaaaaapgapbaaaaaaaaaaajgbebaaaacaaaaaadiaaaaah
hcaabaaaacaaaaaaegacbaaaaaaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaa
aaaaaaaacgajbaaaaaaaaaaajgaebaaaabaaaaaaegacbaiaebaaaaaaacaaaaaa
diaaaaahhcaabaaaaaaaaaaaegacbaaaaaaaaaaapgbpbaaaacaaaaaadiaaaaaj
hcaabaaaabaaaaaafgifcaaaabaaaaaaaeaaaaaaegiccaaaacaaaaaabbaaaaaa
dcaaaaalhcaabaaaabaaaaaaegiccaaaacaaaaaabaaaaaaaagiacaaaabaaaaaa
aeaaaaaaegacbaaaabaaaaaadcaaaaalhcaabaaaabaaaaaaegiccaaaacaaaaaa
bcaaaaaakgikcaaaabaaaaaaaeaaaaaaegacbaaaabaaaaaaaaaaaaaihcaabaaa
abaaaaaaegacbaaaabaaaaaaegiccaaaacaaaaaabdaaaaaaaaaaaaaihcaabaaa
abaaaaaaegacbaaaabaaaaaaegbcbaiaebaaaaaaaaaaaaaabaaaaaahecaabaaa
acaaaaaaegacbaaaaaaaaaaaegacbaaaabaaaaaabaaaaaahccaabaaaacaaaaaa
egbcbaaaacaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaaacaaaaaaegbcbaaa
abaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaaaaaaaaaajgahbaaaacaaaaaa
jgahbaaaacaaaaaaeeaaaaaficaabaaaaaaaaaaadkaabaaaaaaaaaaadiaaaaah
occabaaaabaaaaaapgapbaaaaaaaaaaafgaobaaaacaaaaaadiaaaaaihcaabaaa
abaaaaaafgbfbaaaaaaaaaaaegiccaaaacaaaaaaanaaaaaadcaaaaakhcaabaaa
abaaaaaaegiccaaaacaaaaaaamaaaaaaagbabaaaaaaaaaaaegacbaaaabaaaaaa
dcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaaoaaaaaakgbkbaaaaaaaaaaa
egacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaapaaaaaa
pgbpbaaaaaaaaaaaegacbaaaabaaaaaaaaaaaaajhcaabaaaabaaaaaaegacbaaa
abaaaaaaegiccaiaebaaaaaaabaaaaaaaeaaaaaabaaaaaahicaabaaaaaaaaaaa
egacbaaaabaaaaaaegacbaaaabaaaaaaelaaaaafbccabaaaabaaaaaadkaabaaa
aaaaaaaabbaaaaahicaabaaaaaaaaaaaegbobaaaaaaaaaaaegbobaaaaaaaaaaa
eeaaaaaficaabaaaaaaaaaaadkaabaaaaaaaaaaadiaaaaahhcaabaaaabaaaaaa
pgapbaaaaaaaaaaaegbcbaaaaaaaaaaadgaaaaaghccabaaaacaaaaaaegacbaia
ebaaaaaaabaaaaaadiaaaaaihcaabaaaabaaaaaafgbfbaaaabaaaaaaegiccaaa
acaaaaaaanaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaaacaaaaaaamaaaaaa
agbabaaaabaaaaaaegacbaaaabaaaaaadcaaaaakhcaabaaaabaaaaaaegiccaaa
acaaaaaaaoaaaaaakgbkbaaaabaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaa
aaaaaaaaegacbaaaabaaaaaaegacbaaaabaaaaaaeeaaaaaficaabaaaaaaaaaaa
dkaabaaaaaaaaaaadiaaaaahhccabaaaadaaaaaapgapbaaaaaaaaaaaegacbaaa
abaaaaaadiaaaaajhcaabaaaabaaaaaakgikcaaaaaaaaaaabkaaaaaaegiccaaa
acaaaaaabbaaaaaadcaaaaalhcaabaaaabaaaaaaegiccaaaacaaaaaabaaaaaaa
fgifcaaaaaaaaaaabkaaaaaaegacbaaaabaaaaaadcaaaaalhcaabaaaabaaaaaa
egiccaaaacaaaaaabcaaaaaapgipcaaaaaaaaaaabkaaaaaaegacbaaaabaaaaaa
baaaaaahccaabaaaaaaaaaaaegacbaaaaaaaaaaaegacbaaaabaaaaaabaaaaaah
bcaabaaaaaaaaaaaegbcbaaaacaaaaaaegacbaaaabaaaaaabaaaaaahecaabaaa
aaaaaaaaegbcbaaaabaaaaaaegacbaaaabaaaaaabaaaaaahicaabaaaaaaaaaaa
egacbaaaaaaaaaaaegacbaaaaaaaaaaaeeaaaaaficaabaaaaaaaaaaadkaabaaa
aaaaaaaadiaaaaahhccabaaaaeaaaaaapgapbaaaaaaaaaaaegacbaaaaaaaaaaa
doaaaaab"
}
SubProgram "gles " {
// Stats: 236 math, 5 textures, 6 branches
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES
#version 100

#ifdef VERTEX
attribute vec4 _glesTANGENT;
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
uniform highp vec3 _WorldSpaceCameraPos;
uniform highp mat4 glstate_matrix_mvp;
uniform highp mat4 _Object2World;
uniform highp mat4 _World2Object;
uniform highp vec3 _SunDir;
varying highp float xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesNormal;
  highp vec3 tmpvar_2;
  tmpvar_2 = ((_Object2World * _glesVertex).xyz - _WorldSpaceCameraPos);
  highp vec4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = tmpvar_1;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 0.0;
  tmpvar_4.xyz = _SunDir;
  highp vec3 tmpvar_5;
  tmpvar_5 = normalize(_glesNormal);
  highp vec3 tmpvar_6;
  tmpvar_6 = normalize(_glesTANGENT.xyz);
  highp vec3 tmpvar_7;
  highp vec3 tmpvar_8;
  tmpvar_7 = _glesTANGENT.xyz;
  tmpvar_8 = (((tmpvar_5.yzx * tmpvar_6.zxy) - (tmpvar_5.zxy * tmpvar_6.yzx)) * _glesTANGENT.w);
  highp mat3 tmpvar_9;
  tmpvar_9[0].x = tmpvar_7.x;
  tmpvar_9[0].y = tmpvar_8.x;
  tmpvar_9[0].z = tmpvar_1.x;
  tmpvar_9[1].x = tmpvar_7.y;
  tmpvar_9[1].y = tmpvar_8.y;
  tmpvar_9[1].z = tmpvar_1.y;
  tmpvar_9[2].x = tmpvar_7.z;
  tmpvar_9[2].y = tmpvar_8.z;
  tmpvar_9[2].z = tmpvar_1.z;
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.xyz = _WorldSpaceCameraPos;
  gl_Position = (glstate_matrix_mvp * _glesVertex);
  xlv_TEXCOORD0 = sqrt(dot (tmpvar_2, tmpvar_2));
  xlv_TEXCOORD1 = normalize((tmpvar_9 * (
    (_World2Object * tmpvar_10)
  .xyz - _glesVertex.xyz)));
  xlv_TEXCOORD2 = -(normalize(_glesVertex)).xyz;
  xlv_TEXCOORD3 = normalize((_Object2World * tmpvar_3).xyz);
  xlv_TEXCOORD5 = normalize((tmpvar_9 * (_World2Object * tmpvar_4).xyz));
}


#endif
#ifdef FRAGMENT
#extension GL_EXT_shader_texture_lod : enable
#extension GL_OES_standard_derivatives : enable
uniform lowp vec4 _LightColor0;
uniform mediump vec4 alphaMask1;
uniform lowp samplerCube cube_CityOverlayTex;
uniform highp float _SpecularPower;
uniform mediump vec4 _SpecularColor;
uniform sampler2D _MainTex;
uniform sampler2D _BumpMap;
uniform highp vec3 _SunDir;
uniform highp float _CityOverlayDetailScale;
uniform sampler2D _CityDarkOverlayDetailTex;
uniform sampler2D _CityLightOverlayDetailTex;
varying highp vec3 xlv_TEXCOORD1;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
varying highp vec3 xlv_TEXCOORD5;
void main ()
{
  lowp vec4 tmpvar_1;
  mediump vec4 citylightoverlaydetail_2;
  mediump vec4 citydarkoverlaydetail_3;
  mediump vec4 cityoverlay_4;
  mediump vec3 normT_5;
  mediump vec4 color_6;
  highp vec3 tmpvar_7;
  tmpvar_7 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_8;
  highp float tmpvar_9;
  highp float tmpvar_10;
  tmpvar_10 = (min (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0) / max (abs(
    (tmpvar_7.x / tmpvar_7.z)
  ), 1.0));
  highp float tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_10);
  tmpvar_11 = (((
    ((((
      ((((-0.01213232 * tmpvar_11) + 0.05368138) * tmpvar_11) - 0.1173503)
     * tmpvar_11) + 0.1938925) * tmpvar_11) - 0.3326756)
   * tmpvar_11) + 0.9999793) * tmpvar_10);
  tmpvar_11 = (tmpvar_11 + (float(
    (abs((tmpvar_7.x / tmpvar_7.z)) > 1.0)
  ) * (
    (tmpvar_11 * -2.0)
   + 1.570796)));
  tmpvar_9 = (tmpvar_11 * sign((tmpvar_7.x / tmpvar_7.z)));
  if ((abs(tmpvar_7.z) > (1e-08 * abs(tmpvar_7.x)))) {
    if ((tmpvar_7.z < 0.0)) {
      if ((tmpvar_7.x >= 0.0)) {
        tmpvar_9 += 3.141593;
      } else {
        tmpvar_9 = (tmpvar_9 - 3.141593);
      };
    };
  } else {
    tmpvar_9 = (sign(tmpvar_7.x) * 1.570796);
  };
  uv_8.x = (0.5 + (0.1591549 * tmpvar_9));
  uv_8.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_7.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_7.y)
    )) * (1.570796 + (
      abs(tmpvar_7.y)
     * 
      (-0.2146018 + (abs(tmpvar_7.y) * (0.08656672 + (
        abs(tmpvar_7.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_12;
  uvCont_12.y = uv_8.y;
  uvCont_12.x = abs((uv_8.x - 0.5));
  highp vec4 tmpvar_13;
  tmpvar_13.xy = dFdx(uvCont_12);
  tmpvar_13.zw = dFdy(uvCont_12);
  lowp vec4 tmpvar_14;
  tmpvar_14 = texture2DGradEXT (_MainTex, uv_8, tmpvar_13.xy, tmpvar_13.zw);
  mediump vec4 tmpvar_15;
  tmpvar_15 = tmpvar_14;
  highp vec3 tmpvar_16;
  tmpvar_16 = normalize(xlv_TEXCOORD2);
  highp vec2 uv_17;
  highp float tmpvar_18;
  highp float tmpvar_19;
  tmpvar_19 = (min (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0) / max (abs(
    (tmpvar_16.x / tmpvar_16.z)
  ), 1.0));
  highp float tmpvar_20;
  tmpvar_20 = (tmpvar_19 * tmpvar_19);
  tmpvar_20 = (((
    ((((
      ((((-0.01213232 * tmpvar_20) + 0.05368138) * tmpvar_20) - 0.1173503)
     * tmpvar_20) + 0.1938925) * tmpvar_20) - 0.3326756)
   * tmpvar_20) + 0.9999793) * tmpvar_19);
  tmpvar_20 = (tmpvar_20 + (float(
    (abs((tmpvar_16.x / tmpvar_16.z)) > 1.0)
  ) * (
    (tmpvar_20 * -2.0)
   + 1.570796)));
  tmpvar_18 = (tmpvar_20 * sign((tmpvar_16.x / tmpvar_16.z)));
  if ((abs(tmpvar_16.z) > (1e-08 * abs(tmpvar_16.x)))) {
    if ((tmpvar_16.z < 0.0)) {
      if ((tmpvar_16.x >= 0.0)) {
        tmpvar_18 += 3.141593;
      } else {
        tmpvar_18 = (tmpvar_18 - 3.141593);
      };
    };
  } else {
    tmpvar_18 = (sign(tmpvar_16.x) * 1.570796);
  };
  uv_17.x = (0.5 + (0.1591549 * tmpvar_18));
  uv_17.y = (0.3183099 * (1.570796 - (
    sign(tmpvar_16.y)
   * 
    (1.570796 - (sqrt((1.0 - 
      abs(tmpvar_16.y)
    )) * (1.570796 + (
      abs(tmpvar_16.y)
     * 
      (-0.2146018 + (abs(tmpvar_16.y) * (0.08656672 + (
        abs(tmpvar_16.y)
       * -0.03102955))))
    ))))
  )));
  highp vec2 uvCont_21;
  uvCont_21.y = uv_17.y;
  uvCont_21.x = abs((uv_17.x - 0.5));
  highp vec4 tmpvar_22;
  tmpvar_22.xy = dFdx(uvCont_21);
  tmpvar_22.zw = dFdy(uvCont_21);
  lowp vec4 tmpvar_23;
  tmpvar_23 = texture2DGradEXT (_BumpMap, uv_17, tmpvar_22.xy, tmpvar_22.zw);
  mediump vec4 tmpvar_24;
  tmpvar_24 = tmpvar_23;
  lowp vec3 tmpvar_25;
  lowp vec4 packednormal_26;
  packednormal_26 = tmpvar_24;
  tmpvar_25 = ((packednormal_26.xyz * 2.0) - 1.0);
  normT_5 = tmpvar_25;
  highp vec3 tmpvar_27;
  tmpvar_27 = normalize(xlv_TEXCOORD2);
  lowp vec4 tmpvar_28;
  tmpvar_28 = textureCube (cube_CityOverlayTex, tmpvar_27);
  mediump vec4 tmpvar_29;
  tmpvar_29 = tmpvar_28;
  mediump float tmpvar_30;
  mediump vec4 v_31;
  v_31 = (tmpvar_29 * alphaMask1);
  tmpvar_30 = ((v_31.x + v_31.y) + (v_31.z + v_31.w));
  mediump vec4 tmpvar_32;
  tmpvar_32.xyz = vec3(1.0, 1.0, 1.0);
  tmpvar_32.w = tmpvar_30;
  cityoverlay_4.xyz = tmpvar_32.xyz;
  mediump vec2 uv_33;
  mediump vec3 detailCoords_34;
  mediump float s_35;
  mediump float nylerp_36;
  mediump float zxlerp_37;
  highp vec3 tmpvar_38;
  tmpvar_38 = abs(tmpvar_27);
  highp float tmpvar_39;
  tmpvar_39 = float((tmpvar_38.z >= tmpvar_38.x));
  zxlerp_37 = tmpvar_39;
  highp float tmpvar_40;
  tmpvar_40 = float((max (tmpvar_38.x, tmpvar_38.z) >= tmpvar_38.y));
  nylerp_36 = tmpvar_40;
  highp float tmpvar_41;
  tmpvar_41 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_37);
  s_35 = tmpvar_41;
  highp float tmpvar_42;
  tmpvar_42 = sign(mix (tmpvar_27.y, s_35, nylerp_36));
  s_35 = tmpvar_42;
  mediump vec3 tmpvar_43;
  tmpvar_43.xz = vec2(1.0, -1.0);
  tmpvar_43.y = -(s_35);
  mediump vec3 tmpvar_44;
  tmpvar_44.xz = vec2(1.0, -1.0);
  tmpvar_44.y = s_35;
  highp vec3 tmpvar_45;
  tmpvar_45 = mix ((tmpvar_43 * tmpvar_27.xzy), (tmpvar_44 * tmpvar_27.zxy), vec3(zxlerp_37));
  detailCoords_34 = tmpvar_45;
  mediump vec3 tmpvar_46;
  tmpvar_46.xy = vec2(1.0, 1.0);
  tmpvar_46.z = s_35;
  highp vec3 tmpvar_47;
  tmpvar_47 = mix ((tmpvar_46 * tmpvar_27.yxz), detailCoords_34, vec3(nylerp_36));
  detailCoords_34 = tmpvar_47;
  uv_33 = (((
    (0.5 * detailCoords_34.yz)
   / 
    abs(detailCoords_34.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_48;
  uv_48 = uv_33;
  highp vec2 uvCont_49;
  highp vec2 tmpvar_50;
  highp float tmpvar_51;
  tmpvar_51 = (0.5 * _CityOverlayDetailScale);
  tmpvar_50 = abs((uv_48 - tmpvar_51));
  uvCont_49.x = max (tmpvar_50.x, tmpvar_50.y);
  uvCont_49.y = min (tmpvar_50.x, tmpvar_50.y);
  highp vec4 tmpvar_52;
  tmpvar_52.xy = dFdx(uvCont_49);
  tmpvar_52.zw = dFdy(uvCont_49);
  lowp vec4 tmpvar_53;
  tmpvar_53 = texture2DGradEXT (_CityDarkOverlayDetailTex, uv_33, tmpvar_52.xy, tmpvar_52.zw);
  mediump vec4 tmpvar_54;
  tmpvar_54 = tmpvar_53;
  citydarkoverlaydetail_3.xyz = tmpvar_54.xyz;
  mediump vec2 uv_55;
  mediump vec3 detailCoords_56;
  mediump float s_57;
  mediump float nylerp_58;
  mediump float zxlerp_59;
  highp vec3 tmpvar_60;
  tmpvar_60 = abs(tmpvar_27);
  highp float tmpvar_61;
  tmpvar_61 = float((tmpvar_60.z >= tmpvar_60.x));
  zxlerp_59 = tmpvar_61;
  highp float tmpvar_62;
  tmpvar_62 = float((max (tmpvar_60.x, tmpvar_60.z) >= tmpvar_60.y));
  nylerp_58 = tmpvar_62;
  highp float tmpvar_63;
  tmpvar_63 = mix (tmpvar_27.x, tmpvar_27.z, zxlerp_59);
  s_57 = tmpvar_63;
  highp float tmpvar_64;
  tmpvar_64 = sign(mix (tmpvar_27.y, s_57, nylerp_58));
  s_57 = tmpvar_64;
  mediump vec3 tmpvar_65;
  tmpvar_65.xz = vec2(1.0, -1.0);
  tmpvar_65.y = -(s_57);
  mediump vec3 tmpvar_66;
  tmpvar_66.xz = vec2(1.0, -1.0);
  tmpvar_66.y = s_57;
  highp vec3 tmpvar_67;
  tmpvar_67 = mix ((tmpvar_65 * tmpvar_27.xzy), (tmpvar_66 * tmpvar_27.zxy), vec3(zxlerp_59));
  detailCoords_56 = tmpvar_67;
  mediump vec3 tmpvar_68;
  tmpvar_68.xy = vec2(1.0, 1.0);
  tmpvar_68.z = s_57;
  highp vec3 tmpvar_69;
  tmpvar_69 = mix ((tmpvar_68 * tmpvar_27.yxz), detailCoords_56, vec3(nylerp_58));
  detailCoords_56 = tmpvar_69;
  uv_55 = (((
    (0.5 * detailCoords_56.yz)
   / 
    abs(detailCoords_56.x)
  ) + 0.5) * _CityOverlayDetailScale);
  highp vec2 uv_70;
  uv_70 = uv_55;
  highp vec2 uvCont_71;
  highp vec2 tmpvar_72;
  tmpvar_72 = abs((uv_70 - tmpvar_51));
  uvCont_71.x = max (tmpvar_72.x, tmpvar_72.y);
  uvCont_71.y = min (tmpvar_72.x, tmpvar_72.y);
  highp vec4 tmpvar_73;
  tmpvar_73.xy = dFdx(uvCont_71);
  tmpvar_73.zw = dFdy(uvCont_71);
  lowp vec4 tmpvar_74;
  tmpvar_74 = texture2DGradEXT (_CityLightOverlayDetailTex, uv_55, tmpvar_73.xy, tmpvar_73.zw);
  mediump vec4 tmpvar_75;
  tmpvar_75 = tmpvar_74;
  citylightoverlaydetail_2.xyz = tmpvar_75.xyz;
  cityoverlay_4.w = (tmpvar_30 * (1.0 - float(
    (tmpvar_15.w >= 1.0)
  )));
  citydarkoverlaydetail_3.w = (tmpvar_54.w * cityoverlay_4.w);
  citylightoverlaydetail_2.w = (tmpvar_75.w * cityoverlay_4.w);
  color_6.xyz = (tmpvar_75.xyz * citylightoverlaydetail_2.www);
  color_6.w = 0.0;
  mediump vec3 lightDir_76;
  lightDir_76 = xlv_TEXCOORD5;
  mediump vec3 viewDir_77;
  viewDir_77 = xlv_TEXCOORD1;
  mediump vec4 c_78;
  mediump vec3 tmpvar_79;
  tmpvar_79 = normalize(lightDir_76);
  lightDir_76 = tmpvar_79;
  mediump vec3 tmpvar_80;
  tmpvar_80 = normalize(viewDir_77);
  viewDir_77 = tmpvar_80;
  mediump vec3 tmpvar_81;
  tmpvar_81 = normalize(normT_5);
  mediump float tmpvar_82;
  tmpvar_82 = dot (tmpvar_81, tmpvar_79);
  highp float tmpvar_83;
  mediump float tmpvar_84;
  tmpvar_84 = clamp (dot (normalize(
    (tmpvar_79 + tmpvar_80)
  ), tmpvar_81), 0.0, 1.0);
  tmpvar_83 = tmpvar_84;
  highp float tmpvar_85;
  tmpvar_85 = (pow (tmpvar_83, _SpecularPower) * _SpecularColor.w);
  c_78.xyz = (((
    (color_6.xyz * _LightColor0.xyz)
   * tmpvar_82) + (
    (_LightColor0.xyz * _SpecularColor.xyz)
   * tmpvar_85)) * 2.0);
  c_78.w = (tmpvar_82 * 2.0);
  highp vec3 tmpvar_86;
  tmpvar_86 = normalize(_SunDir);
  mediump vec3 lightDir_87;
  lightDir_87 = tmpvar_86;
  mediump vec3 normal_88;
  normal_88 = xlv_TEXCOORD3;
  mediump float tmpvar_89;
  tmpvar_89 = dot (normal_88, lightDir_87);
  color_6 = (c_78 * mix (1.0, clamp (
    floor((1.01 + tmpvar_89))
  , 0.0, 1.0), clamp (
    (10.0 * -(tmpvar_89))
  , 0.0, 1.0)));
  citydarkoverlaydetail_3.w = (citydarkoverlaydetail_3.w * (1.0 - clamp (color_6.w, 0.0, 1.0)));
  mediump vec4 tmpvar_90;
  tmpvar_90 = mix (citylightoverlaydetail_2, citydarkoverlaydetail_3, citydarkoverlaydetail_3.wwww);
  color_6 = tmpvar_90;
  tmpvar_1 = tmpvar_90;
  gl_FragData[0] = tmpvar_1;
}


#endif
"
}
SubProgram "gles3 " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GLES3
#ifdef VERTEX
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in highp vec4 in_POSITION0;
in highp vec3 in_NORMAL0;
in highp vec4 in_TANGENT0;
out highp float vs_TEXCOORD0;
out highp vec3 vs_TEXCOORD1;
out highp vec3 vs_TEXCOORD2;
out highp vec3 vs_TEXCOORD3;
out highp vec3 vs_TEXCOORD5;
highp vec4 t0;
highp vec3 t1;
highp vec3 t2;
highp vec3 t5;
highp float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_NORMAL0.zzz + t1.xyz;
    t9 = dot(t1.xyz, t1.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD3.xyz = vec3(t9) * t1.xyz;
    t1.xyz = _World2Object[1].xyz * _SunDir.xxyz.zzz;
    t1.xyz = _World2Object[0].xyz * _SunDir.xxyz.yyy + t1.xyz;
    t1.xyz = _World2Object[2].xyz * vec3(_SunDir.z, _SunDir.z, _SunDir.z) + t1.xyz;
    t0.y = dot(t0.xyz, t1.xyz);
    t0.x = dot(in_TANGENT0.xyz, t1.xyz);
    t0.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t0.xyz, t0.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD5.xyz = vec3(t9) * t0.xyz;
    return;
}

#endif
#ifdef FRAGMENT
#version 300 es
precision highp float;
precision highp int;
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	mediump vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	mediump vec4 unity_4LightAtten0;
uniform 	mediump vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	mediump vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	mediump vec4 unity_SHAr;
uniform 	mediump vec4 unity_SHAg;
uniform 	mediump vec4 unity_SHAb;
uniform 	mediump vec4 unity_SHBr;
uniform 	mediump vec4 unity_SHBg;
uniform 	mediump vec4 unity_SHBb;
uniform 	mediump vec4 unity_SHC;
uniform 	mediump vec3 unity_LightColor0;
uniform 	mediump vec3 unity_LightColor1;
uniform 	mediump vec3 unity_LightColor2;
uniform 	mediump vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	mediump vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	lowp vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	lowp vec4 unity_AmbientSky;
uniform 	lowp vec4 unity_AmbientEquator;
uniform 	lowp vec4 unity_AmbientGround;
uniform 	lowp vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	mediump vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	mediump vec4 unity_SpecCube1_HDR;
uniform 	lowp vec4 unity_ColorSpaceGrey;
uniform 	lowp vec4 unity_ColorSpaceDouble;
uniform 	mediump vec4 unity_ColorSpaceDielectricSpec;
uniform 	mediump vec4 unity_ColorSpaceLuminance;
uniform 	mediump vec4 unity_Lightmap_HDR;
uniform 	mediump vec4 unity_DynamicLightmap_HDR;
uniform 	lowp vec4 _LightColor0;
uniform 	lowp vec4 _SpecColor;
uniform 	mediump vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	mediump vec4 alphaMask1;
uniform 	lowp vec4 _Color;
uniform 	float _SpecularPower;
uniform 	mediump vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
uniform lowp sampler2D _MainTex;
uniform lowp sampler2D _BumpMap;
uniform lowp samplerCube cube_CityOverlayTex;
uniform lowp sampler2D _CityDarkOverlayDetailTex;
uniform lowp sampler2D _CityLightOverlayDetailTex;
in highp vec3 vs_TEXCOORD2;
in highp vec3 vs_TEXCOORD3;
in highp vec3 vs_TEXCOORD5;
layout(location = 0) out lowp vec4 SV_Target0;
highp vec3 t0;
lowp vec4 t10_0;
highp int ti0;
highp vec3 t1;
mediump vec4 t16_1;
lowp vec4 t10_1;
bool tb1;
highp vec3 t2;
highp vec3 t3;
lowp vec4 t10_3;
lowp vec3 t10_4;
mediump float t16_5;
mediump vec3 t16_6;
mediump vec3 t16_7;
mediump vec3 t16_8;
highp vec3 t9;
highp vec3 t10;
highp int ti10;
bvec2 tb10;
mediump vec2 t16_14;
highp vec2 t18;
highp float t19;
lowp float t10_19;
highp int ti19;
highp float t20;
mediump float t16_23;
highp float t27;
highp float t28;
bool tb28;
highp float t29;
mediump float t16_32;
mediump float t16_33;
void main()
{
    t0.x = dot(vs_TEXCOORD2.xyz, vs_TEXCOORD2.xyz);
    t0.x = inversesqrt(t0.x);
    t9.xyz = t0.xxx * vs_TEXCOORD2.yxz;
    t1.x = max(abs(t9.z), abs(t9.y));
    t1.x = float(1.0) / t1.x;
    t10.x = min(abs(t9.z), abs(t9.y));
    t1.x = t1.x * t10.x;
    t10.x = t1.x * t1.x;
    t19 = t10.x * 0.0208350997 + -0.0851330012;
    t19 = t10.x * t19 + 0.180141002;
    t19 = t10.x * t19 + -0.330299497;
    t10.x = t10.x * t19 + 0.999866009;
    t19 = t10.x * t1.x;
    t19 = t19 * -2.0 + 1.57079637;
    tb28 = abs(t9.z)<abs(t9.y);
    t19 = tb28 ? t19 : float(0.0);
    t1.x = t1.x * t10.x + t19;
    tb10.xy = lessThan(t9.zxzz, (-t9.zxzz)).xy;
    t10.x = tb10.x ? -3.14159274 : float(0.0);
    t1.x = t10.x + t1.x;
    t10.x = min(t9.z, t9.y);
    tb10.x = t10.x<(-t10.x);
    t28 = max(t9.z, t9.y);
    tb28 = t28>=(-t28);
    ti10 = int(uint(tb28) * 0xffffffffu & uint(tb10.x) * 0xffffffffu);
    t1.x = (ti10 != 0) ? (-t1.x) : t1.x;
    t10.x = t1.x * 0.159154937;
    t2.x = t1.x * 0.159154937 + 0.5;
    t1.x = abs(t10.x);
    t3.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t28 = abs(t9.x) * -0.0187292993 + 0.0742610022;
    t28 = t28 * abs(t9.x) + -0.212114394;
    t28 = t28 * abs(t9.x) + 1.57072878;
    t20 = -abs(t9.x) + 1.0;
    t20 = sqrt(t20);
    t29 = t28 * t20;
    t29 = t29 * -2.0 + 3.14159274;
    t19 = tb10.y ? t29 : float(0.0);
    t19 = t28 * t20 + t19;
    t2.y = t19 * 0.318309873;
    t3.y = dFdx(t2.y);
    t1.y = dFdy(t2.y);
    t10_19 = textureGrad(_MainTex, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).w;
    t10_1.xyw = textureGrad(_BumpMap, t2.xy, vec4(t3.xyxx).xy, vec4(t1.xyxx).xy).xyz;
    t10_4.xyz = t10_1.xyw * vec3(2.0, 2.0, 2.0) + vec3(-1.0, -1.0, -1.0);
    tb1 = t10_19>=1.0;
    t16_5 = (tb1) ? 0.0 : 1.0;
    t10_1 = texture(cube_CityOverlayTex, t9.yxz);
    t16_14.xy = t10_1.xy * alphaMask1.xy;
    t16_14.x = t16_14.y + t16_14.x;
    t16_14.x = t10_1.z * alphaMask1.z + t16_14.x;
    t16_14.x = t10_1.w * alphaMask1.w + t16_14.x;
    t16_5 = t16_5 * t16_14.x;
    t1.x = vs_TEXCOORD2.z * t0.x + (-t9.y);
    tb10.x = abs(t9.z)>=abs(t9.y);
    t10.x = tb10.x ? 1.0 : float(0.0);
    t1.x = t10.x * t1.x + t9.y;
    t0.x = (-vs_TEXCOORD2.y) * t0.x + t1.x;
    t1.x = max(abs(t9.z), abs(t9.y));
    tb1 = t1.x>=abs(t9.x);
    t1.x = tb1 ? 1.0 : float(0.0);
    t0.x = t1.x * t0.x + t9.x;
    ti19 = int((0.0<t0.x) ? 0xFFFFFFFFu : uint(0u));
    ti0 = int((t0.x<0.0) ? 0xFFFFFFFFu : uint(0u));
    ti0 = (-ti19) + ti0;
    t16_6.y = float(ti0);
    t16_7.y = (-t16_6.y);
    t16_7.xz = vec2(1.0, -1.0);
    t2.xyz = t9.yzx * t16_7.xyz;
    t16_6.xz = vec2(1.0, -1.0);
    t3.xyz = t16_6.xyz * t9.zyx + (-t2.xyz);
    t10.xyz = t10.xxx * t3.xyz + t2.xyz;
    t10.xyz = (-t16_6.xxy) * t9.xyz + t10.xyz;
    t0.xyz = t9.xyz * t16_6.xxy;
    t0.xyz = t1.xxx * t10.xyz + t0.xyz;
    t16_14.xy = vec2(t0.y * float(0.5), t0.z * float(0.5));
    t16_14.xy = t16_14.xy / abs(t0.xx);
    t16_14.xy = t16_14.xy + vec2(0.5, 0.5);
    t0.xy = t16_14.xy * vec2(_CityOverlayDetailScale);
    t18.xy = (-vec2(_CityOverlayDetailScale)) * vec2(0.5, 0.5) + t0.xy;
    t1.x = max(abs(t18.y), abs(t18.x));
    t18.x = min(abs(t18.y), abs(t18.x));
    t2.x = dFdx(t1.x);
    t1.x = dFdy(t1.x);
    t2.y = dFdx(t18.x);
    t1.y = dFdy(t18.x);
    t10_3 = textureGrad(_CityDarkOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t10_0 = textureGrad(_CityLightOverlayDetailTex, t0.xy, vec4(t2.xyxx).xy, vec4(t1.xyxx).xy);
    t16_14.x = t16_5 * t10_3.w;
    t16_5 = t16_5 * t10_0.w;
    t16_6.xyz = (-t10_0.xyz) + t10_3.xyz;
    t16_23 = dot(t10_4.xyz, t10_4.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_7.xyz = t10_4.xyz * vec3(t16_23);
    t16_23 = dot(vs_TEXCOORD5.xyz, vs_TEXCOORD5.xyz);
    t16_23 = inversesqrt(t16_23);
    t16_8.xyz = vec3(t16_23) * vs_TEXCOORD5.xyz;
    t16_23 = dot(t16_7.xyz, t16_8.xyz);
    t16_23 = t16_23 + t16_23;
    t27 = dot(vec3(_SunDir.x, _SunDir.y, _SunDir.z), vec3(_SunDir.x, _SunDir.y, _SunDir.z));
    t27 = inversesqrt(t27);
    t1.xyz = vec3(float(t27) * _SunDir.xxyz.y, float(t27) * _SunDir.xxyz.z, float(t27) * float(_SunDir.z));
    t16_32 = dot(vs_TEXCOORD3.xyz, t1.xyz);
    t16_33 = t16_32 + 1.00999999;
    t16_32 = t16_32 * -10.0;
    t16_32 = clamp(t16_32, 0.0, 1.0);
    t16_33 = floor(t16_33);
    t16_33 = clamp(t16_33, 0.0, 1.0);
    t16_33 = t16_33 + -1.0;
    t16_32 = t16_32 * t16_33 + 1.0;
    t16_23 = t16_32 * t16_23;
    t16_23 = clamp(t16_23, 0.0, 1.0);
    t16_23 = (-t16_23) + 1.0;
    t16_32 = t16_14.x * t16_23 + (-t16_5);
    t16_14.x = t16_23 * t16_14.x;
    t16_1.w = t16_14.x * t16_32 + t16_5;
    t16_1.xyz = t16_14.xxx * t16_6.xyz + t10_0.xyz;
    SV_Target0 = t16_1;
    return;
}

#endif
"
}
SubProgram "metal " {
// Stats: 25 math
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
Bind "tangent" ATTR0
Bind "vertex" ATTR1
Bind "normal" ATTR2
ConstBuffer "$Globals" 224
Matrix 16 [glstate_matrix_mvp]
Matrix 80 [_Object2World]
Matrix 144 [_World2Object]
Vector 0 [_WorldSpaceCameraPos] 3
Vector 208 [_SunDir] 3
"metal_vs
#include <metal_stdlib>
using namespace metal;
struct xlatMtlShaderInput {
  float4 _glesTANGENT [[attribute(0)]];
  float4 _glesVertex [[attribute(1)]];
  float3 _glesNormal [[attribute(2)]];
};
struct xlatMtlShaderOutput {
  float4 gl_Position [[position]];
  float xlv_TEXCOORD0;
  float3 xlv_TEXCOORD1;
  float3 xlv_TEXCOORD2;
  float3 xlv_TEXCOORD3;
  float3 xlv_TEXCOORD5;
};
struct xlatMtlShaderUniform {
  float3 _WorldSpaceCameraPos;
  float4x4 glstate_matrix_mvp;
  float4x4 _Object2World;
  float4x4 _World2Object;
  float3 _SunDir;
};
vertex xlatMtlShaderOutput xlatMtlMain (xlatMtlShaderInput _mtl_i [[stage_in]], constant xlatMtlShaderUniform& _mtl_u [[buffer(0)]])
{
  xlatMtlShaderOutput _mtl_o;
  float3 tmpvar_1;
  tmpvar_1 = ((_mtl_u._Object2World * _mtl_i._glesVertex).xyz - _mtl_u._WorldSpaceCameraPos);
  float4 tmpvar_2;
  tmpvar_2.w = 0.0;
  tmpvar_2.xyz = _mtl_i._glesNormal;
  float4 tmpvar_3;
  tmpvar_3.w = 0.0;
  tmpvar_3.xyz = _mtl_u._SunDir;
  float3 tmpvar_4;
  tmpvar_4 = normalize(_mtl_i._glesNormal);
  float3 tmpvar_5;
  tmpvar_5 = normalize(_mtl_i._glesTANGENT.xyz);
  float3 tmpvar_6;
  float3 tmpvar_7;
  tmpvar_6 = _mtl_i._glesTANGENT.xyz;
  tmpvar_7 = (((tmpvar_4.yzx * tmpvar_5.zxy) - (tmpvar_4.zxy * tmpvar_5.yzx)) * _mtl_i._glesTANGENT.w);
  float3x3 tmpvar_8;
  tmpvar_8[0].x = tmpvar_6.x;
  tmpvar_8[0].y = tmpvar_7.x;
  tmpvar_8[0].z = _mtl_i._glesNormal.x;
  tmpvar_8[1].x = tmpvar_6.y;
  tmpvar_8[1].y = tmpvar_7.y;
  tmpvar_8[1].z = _mtl_i._glesNormal.y;
  tmpvar_8[2].x = tmpvar_6.z;
  tmpvar_8[2].y = tmpvar_7.z;
  tmpvar_8[2].z = _mtl_i._glesNormal.z;
  float4 tmpvar_9;
  tmpvar_9.w = 1.0;
  tmpvar_9.xyz = _mtl_u._WorldSpaceCameraPos;
  _mtl_o.gl_Position = (_mtl_u.glstate_matrix_mvp * _mtl_i._glesVertex);
  _mtl_o.xlv_TEXCOORD0 = sqrt(dot (tmpvar_1, tmpvar_1));
  _mtl_o.xlv_TEXCOORD1 = normalize((tmpvar_8 * (
    (_mtl_u._World2Object * tmpvar_9)
  .xyz - _mtl_i._glesVertex.xyz)));
  _mtl_o.xlv_TEXCOORD2 = -(normalize(_mtl_i._glesVertex)).xyz;
  _mtl_o.xlv_TEXCOORD3 = normalize((_mtl_u._Object2World * tmpvar_2).xyz);
  _mtl_o.xlv_TEXCOORD5 = normalize((tmpvar_8 * (_mtl_u._World2Object * tmpvar_3).xyz));
  return _mtl_o;
}

"
}
SubProgram "glcore " {
Keywords { "DIRECTIONAL" "SHADOWS_OFF" "LIGHTMAP_OFF" "DIRLIGHTMAP_OFF" "DYNAMICLIGHTMAP_OFF" "VERTEXLIGHT_ON" "ALPHAMAP_1" "MAP_TYPE_CUBE_1" }
"!!GL3x
#ifdef VERTEX
#version 150
#extension GL_ARB_shader_bit_encoding : enable
uniform 	vec4 _Time;
uniform 	vec4 _SinTime;
uniform 	vec4 _CosTime;
uniform 	vec4 unity_DeltaTime;
uniform 	vec3 _WorldSpaceCameraPos;
uniform 	vec4 _ProjectionParams;
uniform 	vec4 _ScreenParams;
uniform 	vec4 _ZBufferParams;
uniform 	vec4 unity_OrthoParams;
uniform 	vec4 unity_CameraWorldClipPlanes[6];
uniform 	mat4 unity_CameraProjection;
uniform 	mat4 unity_CameraInvProjection;
uniform 	vec4 _WorldSpaceLightPos0;
uniform 	vec4 _LightPositionRange;
uniform 	vec4 unity_4LightPosX0;
uniform 	vec4 unity_4LightPosY0;
uniform 	vec4 unity_4LightPosZ0;
uniform 	vec4 unity_4LightAtten0;
uniform 	vec4 unity_LightColor[8];
uniform 	vec4 unity_LightPosition[8];
uniform 	vec4 unity_LightAtten[8];
uniform 	vec4 unity_SpotDirection[8];
uniform 	vec4 unity_SHAr;
uniform 	vec4 unity_SHAg;
uniform 	vec4 unity_SHAb;
uniform 	vec4 unity_SHBr;
uniform 	vec4 unity_SHBg;
uniform 	vec4 unity_SHBb;
uniform 	vec4 unity_SHC;
uniform 	vec3 unity_LightColor0;
uniform 	vec3 unity_LightColor1;
uniform 	vec3 unity_LightColor2;
uniform 	vec3 unity_LightColor3;
uniform 	vec4 unity_ShadowSplitSpheres[4];
uniform 	vec4 unity_ShadowSplitSqRadii;
uniform 	vec4 unity_LightShadowBias;
uniform 	vec4 _LightSplitsNear;
uniform 	vec4 _LightSplitsFar;
uniform 	mat4 unity_World2Shadow[4];
uniform 	vec4 _LightShadowData;
uniform 	vec4 unity_ShadowFadeCenterAndType;
uniform 	mat4 glstate_matrix_mvp;
uniform 	mat4 glstate_matrix_modelview0;
uniform 	mat4 glstate_matrix_invtrans_modelview0;
uniform 	mat4 _Object2World;
uniform 	mat4 _World2Object;
uniform 	vec4 unity_LODFade;
uniform 	vec4 unity_WorldTransformParams;
uniform 	mat4 glstate_matrix_transpose_modelview0;
uniform 	mat4 glstate_matrix_projection;
uniform 	vec4 glstate_lightmodel_ambient;
uniform 	mat4 unity_MatrixV;
uniform 	mat4 unity_MatrixVP;
uniform 	vec4 unity_AmbientSky;
uniform 	vec4 unity_AmbientEquator;
uniform 	vec4 unity_AmbientGround;
uniform 	vec4 unity_FogColor;
uniform 	vec4 unity_FogParams;
uniform 	vec4 unity_LightmapST;
uniform 	vec4 unity_DynamicLightmapST;
uniform 	vec4 unity_SpecCube0_BoxMax;
uniform 	vec4 unity_SpecCube0_BoxMin;
uniform 	vec4 unity_SpecCube0_ProbePosition;
uniform 	vec4 unity_SpecCube0_HDR;
uniform 	vec4 unity_SpecCube1_BoxMax;
uniform 	vec4 unity_SpecCube1_BoxMin;
uniform 	vec4 unity_SpecCube1_ProbePosition;
uniform 	vec4 unity_SpecCube1_HDR;
uniform 	vec4 unity_ColorSpaceGrey;
uniform 	vec4 unity_ColorSpaceDouble;
uniform 	vec4 unity_ColorSpaceDielectricSpec;
uniform 	vec4 unity_ColorSpaceLuminance;
uniform 	vec4 unity_Lightmap_HDR;
uniform 	vec4 unity_DynamicLightmap_HDR;
uniform 	vec4 _LightColor0;
uniform 	vec4 _SpecColor;
uniform 	vec4 unity_LightGammaCorrectionConsts;
uniform 	mat4 _MainRotation;
uniform 	mat4 _DetailRotation;
uniform 	mat4 _ShadowBodies;
uniform 	float _SunRadius;
uniform 	vec3 _SunPos;
uniform 	vec4 alphaMask1;
uniform 	vec4 _Color;
uniform 	float _SpecularPower;
uniform 	vec4 _SpecularColor;
uniform 	float _DetailDist;
uniform 	vec3 _SunDir;
uniform 	float _CityOverlayDetailScale;
in  vec4 in_POSITION0;
in  vec3 in_NORMAL0;
in  vec4 in_TANGENT0;
out float vs_TEXCOORD0;
out vec3 vs_TEXCOORD1;
out vec3 vs_TEXCOORD2;
out vec3 vs_TEXCOORD3;
out vec3 vs_TEXCOORD5;
vec4 t0;
vec3 t1;
vec3 t2;
vec3 t5;
float t9;
void main()
{
    t0 = in_POSITION0.yyyy * glstate_matrix_mvp[1];
    t0 = glstate_matrix_mvp[0] * in_POSITION0.xxxx + t0;
    t0 = glstate_matrix_mvp[2] * in_POSITION0.zzzz + t0;
    gl_Position = glstate_matrix_mvp[3] * in_POSITION0.wwww + t0;
    t0.x = dot(in_NORMAL0.xyz, in_NORMAL0.xyz);
    t0.x = inversesqrt(t0.x);
    t0.xyz = t0.xxx * in_NORMAL0.zxy;
    t9 = dot(in_TANGENT0.xyz, in_TANGENT0.xyz);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_TANGENT0.yzx;
    t2.xyz = t0.xyz * t1.xyz;
    t0.xyz = t0.zxy * t1.yzx + (-t2.xyz);
    t0.xyz = t0.xyz * in_TANGENT0.www;
    t1.xyz = _WorldSpaceCameraPos.xyzx.yyy * _World2Object[1].xyz;
    t1.xyz = _World2Object[0].xyz * _WorldSpaceCameraPos.xyzx.xxx + t1.xyz;
    t1.xyz = _World2Object[2].xyz * _WorldSpaceCameraPos.xyzx.zzz + t1.xyz;
    t1.xyz = t1.xyz + _World2Object[3].xyz;
    t1.xyz = t1.xyz + (-in_POSITION0.xyz);
    t5.y = dot(t0.xyz, t1.xyz);
    t5.x = dot(in_TANGENT0.xyz, t1.xyz);
    t5.z = dot(in_NORMAL0.xyz, t1.xyz);
    t9 = dot(t5.xyz, t5.xyz);
    t9 = inversesqrt(t9);
    vs_TEXCOORD1.xyz = vec3(t9) * t5.xyz;
    t1.xyz = in_POSITION0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_POSITION0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_POSITION0.zzz + t1.xyz;
    t1.xyz = _Object2World[3].xyz * in_POSITION0.www + t1.xyz;
    t1.xyz = t1.xyz + (-_WorldSpaceCameraPos.xyzx.xyz);
    t9 = dot(t1.xyz, t1.xyz);
    vs_TEXCOORD0 = sqrt(t9);
    t9 = dot(in_POSITION0, in_POSITION0);
    t9 = inversesqrt(t9);
    t1.xyz = vec3(t9) * in_POSITION0.xyz;
    vs_TEXCOORD2.xyz = (-t1.xyz);
    t1.xyz = in_NORMAL0.yyy * _Object2World[1].xyz;
    t1.xyz = _Object2World[0].xyz * in_NORMAL0.xxx + t1.xyz;
    t1.xyz = _Object2World[2].xyz * in_N