
<!-- Readme.md v1.1.1.3
Biomatic (BIO)
created: 11 Aug 2018
updated: 03 Feb 2020 -->

<!-- Download on SpaceDock or Github or Curseforge. Also available on CKAN. -->

# Biomatic
## Simple biome identification, notification, tracking, and warp stopping. <br>
*adopted for curation by zer0Kerbal - originally by @Biff_Space*

![Biomatic Version](https://img.shields.io/github/v/release/zer0Kerbal/Biomatic?include_prereleases)
![KSP 1.7.3](https://img.shields.io/badge/KSP%20version-1.7.3-66ccff.svg?style=flat-square)
![CKAN listed](https://img.shields.io/badge/CKAN-Indexed-brightgreen.svg)
![License GPLv3](https://img.shields.io/badge/SoftwareLicense-GPLv3-red)

![Biomatic](https://spacedock.info/content/BiffSpace_2144/Biomatic/Biomatic-1462190469.105298.jpg "Biomatic")

The Biomatic sensor identifies the biome that the ship is in / above, and shows the information in a small text window. Optionally the ship's situation (high / low space, high / low flight, landed, splashed) can be shown as well. Biomes where science has been done can be added to a list, which is used together with a kill warp option to de-warp the ship when entering an un-listed biome. The list of biomes can be per-vessel, or global.

It is integrated with the stock toolbar by default, but can be configured to use blizzy's. (Change 'stock' to 'blizzy' in the config file).

## The Biomatic Part

The Biomatic part is found under the science tab. In career or science mode, it is found in the 'Space Exploration' node of the tech tree - this must be researched before Biomatic will work, either as a part or as a Module Manager add-on to command pods.

## Module Manager Patch(es)
- adds Biomatic to any command module or probe core
- [OPTIONAL] makes Start the techRequired for the Biomatic part 

## Dependencies
 * [Kerbal Space Program](https://kerbalspaceprogram.com)
 * [Module Manager](https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*)

### Recommends
 * [NEW] [ToolbarController](https://forum.kerbalspaceprogram.com/index.php?/topic/169509-*)
 * [NEW] [ClickThroughBlocker](https://forum.kerbalspaceprogram.com/index.php?/topic/170747-*)

### Suggests
 * [Toolbar (Blizzy's)](https://forum.kerbalspaceprogram.com/index.php?/topic/161857-*)
 * [On Demand Fuel Cells (ODFC)](https://forum.kerbalspaceprogram.com/index.php?/topic/187625-*)
 * [Field Training Facility (FTF)](https://forum.kerbalspaceprogram.com/index.php?/topic/188841-*)
 * [Field Training Lab (FTL)](https://forum.kerbalspaceprogram.com/index.php?/topic/188841-*)
 * [Docking Port Descriptions](https://github.com/zer0Kerbal/KGEx/tree/master/GameData/KGEx/DockingPortDescriptions)
 * [More Hitchhikers](https://forum.kerbalspaceprogram.com/index.php?/topic/188246-*)
 * [PicoPort Shielded](https://github.com/zer0Kerbal/KGEx/tree/master/GameData/KGEx/MM-Patches/ShieldedPicoPort)
 * [Transparent Command Pods Repressurized](https://forum.kerbalspaceprogram.com/index.php?/topic/187495-*)
 * [Nuke Refueled](https://forum.kerbalspaceprogram.com/index.php?/topic/21466-*)
 * [Vanguard]()
 * [ProbiTronics]()
 * [CTN]()
 * [Stork Delivery System (SDS)]()
 * [SimpleLogistics]()
 * [SimpleConstruction]()
 * [Not So Simple Construction]()
 * [B9 Stock Switches (BSS)]()
 * [HotBeverages!]()

### 

### Installation 

The Biomatic folder needs to be unzipped and put in your KSP\GameData folder:

### Feedback

Any comments and suggestions for improvements are welcome, as are reports of bugs / problems - please let me know what you think.

### Code


- Window now disappears with the rest of the UI on F2
- If the part config file is edited to move the part to a different tech tree node, it will now behave sensibly rather than requiring 'spaceExploration' to be unlocked

### Licence
- ![GPLv3](https://www.gnu.org/graphics/gplv3-or-later-sm.png) [Software and Sourcecode Only License. This only covers the software and sourcecode. Original license.](https://www.gnu.org/licenses/gpl-3.0.html)
Biomatic, its associated files and the source code are all released under the GPL 3 licence, text here: http://www.gnu.org/licenses/gpl.txt.

![Screenshot](https://i.imgur.com/TrdnPPU.jpg)

[![Biomatic YouTube](http://img.youtube.com/vi/D3lBi38pTjU/0.jpg)](http://www.youtube.com/watch?v=D3lBi38pTjU "Biomatic in Action")

<a href="http://www.youtube.com/watch?feature=player_embedded&v=D3lBi38pTjU
" target="_blank"><img src="http://img.youtube.com/vi/D3lBi38pTjU/0.jpg" 
alt="Biomatic in Action" width="640" height="480" border="10" /></a>

![YouTube](https://youtu.be/D3lBi38pTjU)

<iframe width="935" height="527" src="https://www.youtube.com/embed/D3lBi38pTjU" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
### Original:
- ![Biomatic biome identifier](https://forum.kerbalspaceprogram.com/index.php?/topic/80379-*)
- ![SpaceDock](http://spacedock.info/mod/634)

<hr>
 *Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date*

###### 📌 v1.3.1.0 original: 11 Aug 2018 0K updated: 03 Feb 2020 zed'K


<!--
CC BY-NC-SA 4.0
zer0Kerbal (zed'K)
-->
