# Goo Pumps & Oils' Speed Pump

Allows you to automatically transfer or balance fuel.

New in the neighbourhood? Check out the [![Github Pages](https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "Github Pages")](https://net-lisias-ksp.github.io/GPOSpeedPump/)!!

Brought to you by [`Lisias`](https://forum.kerbalspaceprogram.com/index.php?/profile/187168-lisias/) and [`zer0Kerbal`](https://forum.kerbalspaceprogram.com/index.php?/profile/190933-zer0kerbal/), previously by [`hab136`](https://forum.kerbalspaceprogram.com/index.php?/profile/75997-hab136/), then previously by [`Geordiepigeonowner`](https://forum.kerbalspaceprogram.com/index.php?/profile/116764-geordiepigeonowner/), and originally by [`Gaius`](https://forum.kerbalspaceprogram.com/index.php?/profile/66495-gaius/).


## In a Hurry

* [Latest Release](https://github.com/net-lisias-ksp/GPOSpeedPump/releases)
	+ [Binaries](https://github.com/net-lisias-ksp/GPOSpeedPump/tree/Archive)
	+ [Source](https://github.com/net-lisias-ksp/GPOSpeedPump)
* Documentation
	+ [Github Pages](https://net-lisias-ksp.github.io/GPOSpeedPump/) 
	+ [Project's README](https://github.com/net-lisias-ksp/GPOSpeedPump/blob/master/README.md)
	+ [Install Instructions](https://github.com/net-lisias-ksp/GPOSpeedPump/blob/master/INSTALL.md)
	+ [Change Log](./CHANGE_LOG.md)
* Support
	+ [Discussions](https://github.com/net-lisias-ksp/GPOSpeedPump/discussions/categories/support)
	+ [Issue Track](https://github.com/net-lisias-ksp/GPOSpeedPump/issues)
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/207732-*/)
* Official Distribution Channels:
	+ [CurseForge](https://kerbal.curseforge.com/projects/gpospeedfuelpump-continued/files)
	+ [SpaceDock](http://spacedock.info/mod/546/GPOSpeedPump)
	+ [GitHub](https://github.com/net-lisias-ksp/GPOSpeedPump/releases)


## Description

<img src="./PR_material/img/HeroLogo_1920x1920.png?raw=true" alt="HeroLogo_1920x1920.png" style="display: block; margin-left: auto; margin-right: auto; width: 80%;" />

Ever undock from your space station, only to realize you forgot to top off your fuel or RCS tanks? Want to have tanks that automatically pump fuel where it's needed, without having to bring up windows and manually move fuel around? Want to set up fuel balancing in the SPH or VAB as a "tweakable" and have it saved with your vessel? Simultaneously balance different groups of tanks on the same vessel independently of one-another? Just generally mess around with fuel routing, and have these settings persistent? Then **Goo Pumps & Oils** has the tool for you!

The **Goo Pumps & Oils'** *Speed Pump*, once installed in your fuel tanks, allows you to set up a "pump level" for each tank, either as a "tweakable" while building your vehicle, or while in flight. You can set tanks to automatically pump fuel to lower level tanks whenever possible, or balance between tanks at the same level. Uses include refuelling tanks at space stations that automatically top off the tanks of any vessels as soon as they dock with the station, refuelling vessels with higher level pumps that automatically refuel the space station as soon as they dock, setting up fuel balancing while building a plane and having it saved with the plane and done completely automatically in flight, setting up more complicated fuel flow patterns for asparagus-like situations without fuel lines for fuel types that don't normally flow that way (e.g. monopropellant and xenon gas), and many other uses!

Right-click a tank while in the assembly building, or while in flight. Set the pump level as desired, and turn on "Auto Pump" and/or "Balance". "Auto Pump" will automatically pump fuel from this tank to any lower level tanks (water flows downhill) when they have room. The "Balance" function will keep the percentage of fuel in this tank identical to any other tanks with the same pump level and "Balance" on. Note that this allows different sets of tanks to be balanced within their own set but independently of the other sets.

### Pictures, or it didn't happened!

The first pic shows a fuel station that automatically refuels any ship that docks with it. In this setup, the top two tanks remain left/right balanced while draining first, then the next two down, and so on, with the two on the bottom draining last. Why would you want to do this? Because... reasons.

![](https://i.imgur.com/2pChN3Q.png)

The second pic just shows that the pump settings appear in the assembly building as "tweakables" as well as in-flight. These settings are saved with your craft.

![](https://i.imgur.com/JnfmO7C.png)

The third pic just shows the pumps keeping three tanks balanced in-flight.

![](https://i.imgur.com/Bxmxd6d.png)

The fourth pic shows the "Pump Options" window that allows you to turn off the pumping of some resources while leaving it enabled for others.

![](https://i.imgur.com/G1kAfqy.png)


## Installation

Detailed installation instructions are now on its own file (see the [In a Hurry](#in-a-hurry) section) and on the distribution file.


## License:

This work is licensed under the [GPL 3.0](https://www.gnu.org/licenses/gpl-3.0.txt). See [here](./LICENSE)

+ You are free to:
	- Use : unpack and use the material in any computer or device
	- Redistribute : redistribute the original package in any medium
	- Adapt : Reuse, modify or incorporate source code into your works (and redistribute it!)
+ Under the following terms:
	- You retain any copyright notices
	- You recognise and respect any trademarks
	- You don't impersonate the authors, neither redistribute a derivative that could be misrepresented as theirs.
	- You credit the author and republish the copyright notices on your works where the code is used.
	- You relicense (and fully comply) your works using GPL 3.0
		- Please note that upgrading the license to any future license version  **IS NOT ALLOWED** for this work, as the author **DID NOT**
 added the "or (at your option) any later version" on the license
	- You don't mix your work with GPL incompatible works.

Please note the copyrights and trademarks in [NOTICE](./NOTICE).


## UPSTREAM

* [Gaius](https://forum.kerbalspaceprogram.com/index.php?/profile/66495-gaius/) ROOT
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/60992-*/)
	+ [Imgur](https://imgur.com/a/ilLes)
* [Geordiepigeonowner](https://forum.kerbalspaceprogram.com/index.php?/profile/116764-geordiepigeonowner/) PREVIOUS
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/106448-*/) 
* [hab136](https://forum.kerbalspaceprogram.com/index.php?/profile/75997-hab136/) PREVIOUS
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/137489-*/) 
	+ [CurseForge](https://kerbal.curseforge.com/projects/gpospeedfuelpump-continued/files)
	+ [SpaceDock](http://spacedock.info/mod/546/GPOSpeedFuelPump)
	+ [Github](https://github.com/henrybauer/GPOSpeedPump)
