﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
namespace DepthCharge
{
    [KSPAddon(KSPAddon.Startup.MainMenu, true)]
    public class DepthContorllerApplicationLauncher : MonoBehaviour
    {
        private static bool drawGUI
        {
            get
            {
                return ModGlobal.drawSettingsWindow;
            }
            set
            {
                ModGlobal.drawSettingsWindow = value;
            }
        }

        public void Start()
        {
            Debug.Log("start load DepthChargeSettings");
            DepthChargeSettings.Load();
            Debug.Log("end load DepthChargeSettings");
            Texture2D tex2d = GameDatabase.Instance.GetTexture(DepthChargeSettings.iconURL, false);
            ApplicationLauncher.Instance.AddModApplication(OnTrue, OnFalse, OnOther, OnOther, OnOther, OnOther, ApplicationLauncher.AppScenes.FLIGHT,
                tex2d);
            ApplicationLauncher.Instance.AddModApplication(OnTrue, OnFalse, OnOther, OnOther, OnOther, OnOther, ApplicationLauncher.AppScenes.SPH,
                tex2d);
        }
        public void OnTrue()
        {
            drawGUI = true;
        }
        public void OnFalse()
        {
            drawGUI = false;
        }
        public void OnOther()
        {

        }
    }
}
