﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using BahaTurret;
using UnityEngine;
using DepthCharge.Libs;

namespace DepthCharge
{
    public class ModuleDepthCharge : PartModule
    {
        [KSPField]
        public int errorRange = 10;

        [KSPField]
        public bool volumeBuoyancy = false;

        [KSPField]
        public float volume = -1f;

        [KSPField]
        public float buoyancyForce = -1f;

        [KSPField]
        public Vector3 airMaxTorque = Vector3.zero;

        [KSPField]
        public Vector3 airCoeff = Vector3.zero;

        [KSPField]
        public Vector3 waterMaxTorque = Vector3.zero;

        [KSPField]
        public Vector3 waterCoeff = Vector3.zero;

        [KSPField]
        public bool autoDeployParachute = true;

        [KSPField]
        public bool simulationOnlyOnFired = true;

        [KSPField(isPersistant = true, guiActive = true, guiActiveEditor = true, guiName = "Destroy Depth ")
, UI_FloatRange(controlEnabled = true, maxValue = 500, minValue = 50, scene = UI_Scene.All, stepIncrement = 10f)]
        public float autoDestroyDepth = 500;


        private Buoyancy buoyancy;
        private BombSystem bombSystem;
        private RotationSystem rotationSystem;
        private MissileLauncher missileLauncher;
        private UI_Control depthField;
        private Rigidbody partRigidbodyValue;
        private Rigidbody partRigidbody
        {
            get
            {
                if (!partRigidbodyValue)
                    partRigidbodyValue = part.GetComponent<Rigidbody>();
                return partRigidbodyValue;
            }
        }
        float height
        {
            get
            {
                return (float)vessel.mainBody.GetAltitude(vessel.GetWorldPos3D());
            }
        }
        public override void OnStart(StartState state)
        {
            base.OnStart(state);
            if (HighLogic.LoadedSceneIsFlight)
            {
                buoyancy = new Buoyancy();
                buoyancy.BuoyancyDataWrite(volumeBuoyancy, volume, buoyancyForce);
                rotationSystem = new RotationSystem();
                rotationSystem.RotationData(airMaxTorque, waterMaxTorque, airCoeff, waterCoeff);
                bombSystem = new BombSystem();
                bombSystem.ChargeDataWrite(errorRange, autoDestroyDepth);
                bombSystem.ran();
                missileLauncher = GetComponent<MissileLauncher>();
                if (!missileLauncher)
                    Debug.LogError("Failed when find the MissileLauncher!");
                depthField = Fields["autoDestroyDepth"].uiControlFlight;
            }
        }
        public override void OnUpdate()
        {
            base.OnUpdate();
            if (HighLogic.LoadedSceneIsFlight)
            {
                if (missileLauncher.hasFired)
                {
                    if (depthField.controlEnabled)
                        depthField.controlEnabled = false;
                    if (bombSystem.Bomb(height))
                    {
                        Debug.Log("DepthCharge Bombed At " + height + "m on " + vessel.mainBody.name);
                        part.temperature = part.maxTemp * 2;
                        missileLauncher.Detonate();
                    }
                }
                else
                {
                    bombSystem.ChargeDataWrite(autoDestroyDepth);
                }
            }
        }
        public override void OnFixedUpdate()
        {
            base.OnFixedUpdate();
            if (HighLogic.LoadedSceneIsFlight)
            {
                if ((simulationOnlyOnFired && missileLauncher.hasFired) || !simulationOnlyOnFired)
                {
                    if (height < 0)
                    {
                        partRigidbody.AddForce(buoyancy.Force(height));
                    }
                    partRigidbody.AddTorque(rotationSystem.Torque(vessel.vesselTransform.forward,vessel.srf_velocity, height));

                }
            }
        }
    }
}
