﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
using BahaTurret;
using DepthCharge.Libs;
namespace DepthCharge
{
    [KSPAddon(KSPAddon.Startup.EveryScene, false)]
    class ModUIManager : MonoBehaviour
    {
        private Vector2 DCScroll = Vector2.zero;
        void OnGUI()
        {
            if (ModGlobal.loadedSceneIsOn && ModGlobal.drawSettingsWindow)
            {
                DepthChargeSettings.settingsWindowRect = GUI.Window(976233, DepthChargeSettings.settingsWindowRect, DrawDepthContorllerWindow, "Depth Charge Manager");
            }
            /*
            if (Camera.main)
            {
                if (!Camera.main.GetComponent<GLCameraDrawer>())
                    Camera.main.gameObject.AddComponent<GLCameraDrawer>();
            }*/
        }
        void OnRenderObject()
        {
            //RoundDrawingTesting.DrawRound();
            //GLCameraDrawer.Draw();
        }
        void DrawDepthContorllerWindow(int windowID)
        {
            GUI.DragWindow(new Rect(0, 0, 400, 20));
            GUILayout.Label("Depth Charges on this vessel :");
            GUILayout.Space(15);
            GUILayout.BeginScrollView(DCScroll, false, false, GUILayout.ExpandHeight(true));
            if (FlightGlobals.ActiveVessel == null || FlightGlobals.ActiveVessel.Parts == null)
                return;
            foreach (var current in FlightGlobals.ActiveVessel.Parts)
            {
                if (current)
                    DrawDepthCharge(current.GetComponent<ModuleDepthCharge>());
            }
            GUILayout.EndScrollView();
        }
        void DrawDepthCharge(ModuleDepthCharge target)
        {
            if (!target)
                return;
            var missileLauncher = target.GetComponent<MissileLauncher>();
            if (!missileLauncher || missileLauncher.hasFired)
                return;
            GUILayout.BeginHorizontal();
            GUILayout.Label(missileLauncher.shortName);
            GUILayout.FlexibleSpace();
            GUILayout.Label(target.autoDestroyDepth.ToString() + " m");
            target.autoDestroyDepth = (int)(GUILayout.HorizontalScrollbar(target.autoDestroyDepth, 10, 50, 500, GUILayout.MinWidth(100)) / 10) * 10;
            GUILayout.EndHorizontal();
        }
    }
}
