﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;
using UnityEngine;
namespace DepthCharge
{
    public static class DepthChargeSettings
    {
        //base value
        public static string configURL = "GameData/DepthCharge/settings.cfg";
        //create on start
        public static ConfigNode configRootNode;
        public static Rect settingsWindowRect = new Rect(0, 0, 400, 600);
        //Load after running
        [DepthChargeSettingsField]
        public static string iconURL = "DepthCharge/icons/ApplicationLauncherIcon";

        public static void Save()
        {
            ConfigNode fileNode = ConfigNode.Load(configURL);
            if (!fileNode.HasNode("DepthChargeSettings"))
                fileNode.AddNode("DepthChargeSettings");
            configRootNode = fileNode.GetNode("DepthChargeSettings");

            foreach (var fieldInfo in typeof(DepthChargeSettings).GetFields())
            {
                if (!fieldInfo.IsDefined(typeof(DepthChargeSettingsField), false)) continue;
                configRootNode.SetValue(fieldInfo.Name, fieldInfo.GetValue(null).ToString(), true);
            }
            fileNode.Save(configURL);
        }
        public static void Load()
        {
            ConfigNode fileNode = ConfigNode.Load(configURL);
            if (!fileNode.HasNode("DepthChargeSettings"))
                return;
            configRootNode = fileNode.GetNode("DepthChargeSettings");
            foreach (var fieldInfo in typeof(DepthChargeSettings).GetFields())
            {
                if (!fieldInfo.IsDefined(typeof(DepthChargeSettingsField), false)) continue;
                if (configRootNode.HasValue(fieldInfo.Name))
                {
                    // object parsedValue = ParseValue(fieldInfo.FieldType, configRootNode.GetValue(fieldInfo.Name));
                    object parsedValue = configRootNode.GetValue(fieldInfo.Name);
                    if (parsedValue != null)
                        fieldInfo.SetValue(null, parsedValue);
                }
            }
        }
        public static T GetValue<T>(T value, string name)
        {
            if (configRootNode.HasValue(name))
            {
                object parsedValue = ParseValue<T>(configRootNode.GetValue(name));
                if (parsedValue != null) return (T)parsedValue;
            }
            return value;
        }
        public static object GetValue(Type type, string name)
        {
            if (configRootNode.HasValue(name))
            {
                object parsedValue = ParseValue(type, configRootNode.GetValue(name));
                if (parsedValue != null) return parsedValue;
            }
            return null;
        }

        public static object ParseValue<T>(string value)
        {
            return ParseValue(typeof(T), value);
        }
        public static object ParseValue(Type type, string value)
        {
            if (type == typeof(string))
            {
                return value;
            }
            if (type == typeof(bool))
            {
                return bool.Parse(value);
            }
            if (type.IsEnum)
            {
                return Enum.Parse(type, value);
            }
            if (type == typeof(float))
            {
                return float.Parse(value);
            }
            if (type == typeof(double))
            {
                return double.Parse(value);
            }
            if (type == typeof(int))
            {
                return int.Parse(value);
            }
            if (type == typeof(Color))
            {
                return ConfigNode.ParseColor(value);
            }
            if (type == typeof(Color32))
            {
                return ConfigNode.ParseColor32(value);
            }
            if (type == typeof(Matrix4x4))
            {
                return ConfigNode.ParseMatrix4x4(value);
            }
            if (type == typeof(Vector2))
            {
                return ConfigNode.ParseVector2(value);
            }
            if (type == typeof(Vector3))
            {
                return ConfigNode.ParseVector3(value);
            }
            if (type == typeof(Vector3d))
            {
                return ConfigNode.ParseVector3D(value);
            }
            if (type == typeof(Vector4))
            {
                return ConfigNode.ParseVector4(value);
            }
            if (type == typeof(Quaternion))
            {
                return ConfigNode.ParseQuaternion(value);
            }
            if (type == typeof(QuaternionD))
            {
                return ConfigNode.ParseQuaternionD(value);
            }
            if (type == typeof(Rect))
            {
                var vec4 = ConfigNode.ParseVector4(value);
                return new Rect(vec4.x, vec4.y, vec4.z, vec4.w);
            }
            return null;
        }
    }
}
