﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
using ModuleDepthChargeSystem;

namespace DepthCharge.Libs
{
    public class BombSystem
    {
        private int r;
        MDCData Data = new MDCData();
        public void ChargeDataWrite(int errorRange, float autoDestroyDepth)
        {
            Data.errorRange = errorRange;
            Data.autoDestroyDepth = autoDestroyDepth;
        }
        public void ChargeDataWrite(float autoDestroyDepth)
        {
            Data.autoDestroyDepth = autoDestroyDepth;
        }
        public int ran()
        {
            System.Random ran = new System.Random();
            r = ran.Next(0, (int)Data.errorRange);
            return r;
        }
        public bool Bomb(float hight)
        {
            if (hight < 0 && Data.autoDestroyDepth != 0)
            {
                if (Math.Abs(hight) > Math.Abs(Data.autoDestroyDepth) - r || Math.Abs(hight) > Math.Abs(Data.autoDestroyDepth) + Data.errorRange)
                    return true;
                else
                    return false;
            }
            else
                return false;
        }
    }
    public class Buoyancy
    {
        MDCData Data = new MDCData();
        public void BuoyancyDataWrite(bool volumebuoyancy, float volume, float buoyancyForce)
        {
            Data.volumebuoyancy = volumebuoyancy;
            Data.volume = volume;
            Data.buoyancyForce = buoyancyForce;
        }
        public Vector3 Force(float hight)
        {
            if (hight < 0)
            {
                if (Data.volumebuoyancy)
                    return new Vector3(0, Data.volume * 10, 0);
                else
                {
                    if (Data.volume == -1)
                        return Vector3.zero;
                    else
                        return new Vector3(0, Data.buoyancyForce, 0);
                }
            }
            else
                return Vector3.zero;
        }
    }
    public class RotationSystem
    {
        MDCData Data = new MDCData();
        public void RotationData(Vector3 airMaxTorque, Vector3 waterMaxTorque, Vector3 airCocf, Vector3 waterCocf)
        {
            Data.airMaxTorque = airMaxTorque;
            Data.waterMaxTorque = waterMaxTorque;
            Data.airCocf = airCocf;
            Data.waterCocf = waterCocf;
        }
        public Vector3 Torque(Vector3 TransformUp ,Vector3 velocity, float hight)
        {
            if (hight >= 0)
            {
                return new Vector3(Vector3.Cross(TransformUp, velocity).x*Data.airMaxTorque.x, Vector3.Cross(TransformUp, velocity).y*Data.airMaxTorque.y+0.1f, Vector3.Cross(TransformUp, velocity).z*Data.airMaxTorque.z);
            }
            else
                return new Vector3(Vector3.Cross(TransformUp, velocity).x*Data.waterMaxTorque.x, Vector3.Cross(TransformUp, velocity).y*Data.waterMaxTorque.y+0.1f, Vector3.Cross(TransformUp, velocity).z*Data.waterMaxTorque.z);
        }
    }
}
