﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
using Upgradeables;

namespace FacilityReset
{
    [KSPAddon(KSPAddon.Startup.SpaceCentre,false)]
    public class FacilityReset : MonoBehaviour
    {
        private static bool buttonAdded = false;
        private ApplicationLauncherButton _appButton;
        public void Start()
        {
            if (!buttonAdded) CreateAppButton();
        }

        private void OnDestroy()
        {
            DestroyAppButton();
        }
        
        private void CreateAppButton()
        {
            _appButton = ApplicationLauncher.Instance.AddModApplication(
                () => { ChangeAttempt(); },
                () => { ChangeAttempt(); },
                null,
                null,
                null,
                null,
                ApplicationLauncher.AppScenes.SPACECENTER,
                GameDatabase.Instance.GetTexture("FacilityReset/FacilityResetIcon", false)
                );
            buttonAdded = true;
        }
        private void DestroyAppButton()
        {
            if (_appButton != null) ApplicationLauncher.Instance.RemoveModApplication(_appButton);
            buttonAdded = false;
        }


        private void ChangeAttempt()
        {
            
            foreach (UpgradeableFacility facility in GameObject.FindObjectsOfType<UpgradeableFacility>())
            {
                int correctLevel = (int)(ScenarioUpgradeableFacilities.GetFacilityLevel((SpaceCenterFacility)Enum.Parse(typeof(SpaceCenterFacility), facility.name)) * (float)facility.MaxLevel);
                if (facility.FacilityLevel != correctLevel)
                {
                    Debug.Log("[FacilityReset] " + facility.name + " level changed from " + facility.FacilityLevel + " to " + correctLevel);
                    ScenarioUpgradeableFacilities.UnregisterUpgradeable(facility, facility.name);
                    ScenarioUpgradeableFacilities.RegisterUpgradeable(facility, facility.name);
                    facility.SetLevel(correctLevel);
                }
            }
        }


    }
}
