using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine.Networking;
using UnityEngine;
using KSP.UI.Screens.DebugToolbar.Screens.Cheats;

namespace AlmajaraCoreBackgroundMusic
{
    [KSPAddon(KSPAddon.Startup.Flight, false)]
    public class BackgroundAudio1 : MonoBehaviour
    {
        private static MusicLogic music = null;
        protected static AudioSource source = null;
        static GameObject gameObject2 = null;
        protected static List<AudioClip> emptySongsList = null;
        protected static List<AudioClip> stockPlaylist = null;
        public static AudioClip myClip = null;

        public void Start()
        {
            Debug.LogError(KSPUtil.ApplicationRootPath);
            // Create game object for music
            gameObject2 = new GameObject();
            GameObject.DontDestroyOnLoad(gameObject2);
            gameObject2.name = "AlmajaraCoreBackgroundMusicObject";

            // Create audio source
            source = gameObject2.AddComponent<AudioSource>();

            // Audio achieves god mode
            source.spatialBlend = 0;
            source.dopplerLevel = 0;
            source.loop = false;

            // Disable stock music
            music = MusicLogic.fetch;
            emptySongsList = new List<AudioClip>();
            emptySongsList.Add(AudioClip.Create("none", 44100, 1, 44100, false));
            music.audio1.Stop();
            stockPlaylist = music.spacePlaylist;
            music.spacePlaylist = emptySongsList;

            // Get audio
            StartCoroutine(GetAudioClip());

            // Set up audio
            source.clip = myClip;
            source.loop = true;
            source.time = 0;
        }

        IEnumerator GetAudioClip() // Gets the audio clip from file
        {
            using (UnityWebRequest www = UnityWebRequestMultimedia.GetAudioClip("file:///"+ KSPUtil.ApplicationRootPath + "GameData/Almajara-Core/Music/1.wav", AudioType.WAV))
            {
                yield return www.SendWebRequest();

                myClip = DownloadHandlerAudioClip.GetContent(www);
            }
        }

        public void FixedUpdate()
        {
            // Add clip if not added (happens when the request doesn't complete fast enough)
            if (source.clip == null)
                source.clip = myClip;

            // Does Sorut exist?
            CelestialBody BODYNAME = null;
            foreach (var b in FlightGlobals.Bodies)
            {
                if (b.name == "Sorut")
                {
                    BODYNAME = b;
                    break;
                }
            }

            //If Sorut exists, play music when over Sorut
            if (BODYNAME != null)
            {
                if (FlightGlobals.ActiveVessel.mainBody == BODYNAME) // Is over Sorut?
                {
                    if (!source.isPlaying) source.Play();  // Play music if not already playing
                }
                else
                {
                    source.Stop();  // Stop music if not over Sorut
                    music.spacePlaylist = stockPlaylist;  // Restore stock music
                }
            }
        }

        public void onDestroy()
        {
            // Clean up when exiting flight scene
            gameObject2.DestroyGameObject();
            source.Stop();
            music.spacePlaylist = stockPlaylist;
        }
    }
}
