using System.IO;
using System.Collections;
using UnityEngine;
using UnityEngine.Networking;

namespace AudioPlayer1
{
    [KSPAddon(KSPAddon.Startup.Flight, false)]
    public class Audio1 : MonoBehaviour
    {
        AudioSource source;
        static GameObject gameObject2 = null;
        public void Start()
        {
            gameObject2 = new GameObject();
            GameObject.DontDestroyOnLoad(gameObject2);
            gameObject2.name = "AlmajaraLastLightSecret1";

            source = gameObject2.AddComponent<AudioSource>();

            source.spatialBlend = 0;
            source.dopplerLevel = 0;
            source.loop = false;
            source.maxDistance = 10000000f;

            StartCoroutine(GetAudioClip());
        }
        IEnumerator GetAudioClip() // Gets the audio clip from file
        {
            using (UnityWebRequest www = UnityWebRequestMultimedia.GetAudioClip("file:///" + KSPUtil.ApplicationRootPath + "GameData/Almajara-LastLight/Music/secret1.wav", AudioType.WAV))
            {
                yield return www.SendWebRequest();

                source.clip = DownloadHandlerAudioClip.GetContent(www);
                source.time = 0;
                source.loop = true;
            }
        }
        public void FixedUpdate()
        {
            CelestialBody BODYNAME = null;
            foreach (var b in FlightGlobals.Bodies)
                if (b.name == "Saheb")
                    BODYNAME = b;
            if (BODYNAME != null)
            {
                if (FlightGlobals.ActiveVessel.mainBody == BODYNAME)
                {
                    double latitude = 63.0950012073209;   // degrees
                    double longitude = -90.0799971745093;  // degrees
                    double altitude = 7;   // meters (relative to the body's surface level not sea level)

                    Vector3d worldPos = BODYNAME.GetWorldSurfacePosition(latitude, longitude, altitude);
                    gameObject2.transform.position = ScaledSpace.ScaledToLocalSpace(worldPos);
                    var BODYNAMEpos = ScaledSpace.ScaledToLocalSpace(BODYNAME.position);
                    var vesselpos = ScaledSpace.ScaledToLocalSpace(FlightGlobals.ActiveVessel.transform.position) * ScaledSpace.ScaleFactor;

                    float dist = (float)Vector3d.Distance(vesselpos, BODYNAMEpos);
                    KSPLog.print("Distance: " + dist.ToString() + " meters.");
                    if (dist < 1000f)
                    {
                        if (!source.isPlaying)
                        {
                            source.Play();
                        }
                        source.volume = 1f;
                    }
                    else
                    {
                        source.Stop();
                        source.volume = 0;
                    }
                }
                else
                {
                    source.Stop();
                    source.volume = 0;
                }
            }
        }
        public void onDestroy()
        {
            // Clean up when exiting flight scene
            gameObject2.DestroyGameObject();
            source.Stop();
        }
    }
}