"""
Copyright (c) 2025 Chitak 985 YT

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom
the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or
substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
USE OR OTHER DEALINGS IN THE SOFTWARE.

This script uses configs from the Kittiopia Dumps: https://github.com/Kopernicus/kittopia-dumps
"""

from random import choice as rc
from os import mkdir

# Planet definitions (Kittiopia dumps)
definitions = ['''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = The Sun is the most well known object in the daytime sky. Scientists have noted a particular burning sensation and potential loss of vision if it is stared at for long periods of time. This is especially important to keep in mind considering the effect shiny objects have on the average Kerbal.
			radius = 261600000
			geeASL = 1.74684656100137
			mass = 1.75654591319326E+28
			gravParameter = 1.17233279483249E+18
			rotates = True
			rotationPeriod = 432000
			tidallyLocked = False
			initialRotation = 0
			inverseRotThresholdAltitude = 600000
			albedo = 0
			emissivity = 0
			coreTemperatureOffset = 0
			timewarpAltitudeLimits = 0 3270000 3270000 6540000 1.308E+07 2.616E+07 5.232E+07 6.54E+07
			sphereOfInfluence = 1E10
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			useTheInName = True
			displayName = The Sun^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = True
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 1 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 11 // Science multiplier for in space low science.
				inSpaceHighDataValue = 2 // Science multiplier for in space high science.
				recoveryValue = 4
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 1E+09 // Altitude when "in space low" transitions from/to "in space high"
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Star
			fadeStart = 0
			fadeEnd = 0
			sphericalModel = False
			deferMesh = False
			invisible = False
			Light
			{
				sunlightColor = 1,1,1,1 // The color of the LocalSpace starlight. Influences vessels and PQS terrain.
				sunlightShadowStrength = 0.7523364 // The strength of the shadows caused by LocalSpace starlight.
				scaledSunlightColor = 1,1,1,1 // The color of the ScaledSpace starlight. Influences the ScaledSpace representation of the bodies.
				IVASunColor = 1,0.976999998,0.896000028,1 // The color of the starlight in IVA view.
				ambientLightColor = 0.0599999987,0.0599999987,0.0599999987,1 // The color of ambient lighting when orbiting near the star.
				sunLensFlareColor = 1,1,1,1 // The color of the stars LensFlare effect. Gets multiplied with the color of the base texture (yellow-ish for stock flare).
				givesOffLight = True // Whether the star should emit light and have a LensFlare effect.
				sunAU = 13599840256 // TODO
				luminosity = 1360 // TODO
				insolation = 0.15 // TODO
				radiationFactor = 1 // TODO
				brightnessCurve // Associates a distance value with a multiplier for the brightness of the LensFlare effect.
				{
					key = -0.01573471 0.217353 1.706627 1.706627
					key = 5.084181 3.997075 -0.001802375 -0.001802375
					key = 38.56295 1.82142 0.0001713 0.0001713
				}
				IntensityCurve // Associates a distance value (in meters) with a value that describes the intensity of the LocalSpace starlight at that point.
				{
					key = 0 0.9 0 0
					key = 1 0.9 0 0
				}
				ScaledIntensityCurve // Associates a distance value (in meters / 6000) with a value that describes the intensity of the ScaledSpace starlight at that point.
				{
					key = 0 0.9 0 0
					key = 1 0.9 0 0
				}
				IVAIntensityCurve // Associates a distance value (in meters) with a value that describes the intensity of the IVA starlight at that point.
				{
					key = 0 0.8099999 0 0
					key = 1 0.8099999 0 0
				}
			}
			Material
			{
				rampMap = BUILTIN/
				rampMapScale = 1,1
				rampMapOffset = 0,0
				noiseMap = BUILTIN/sunnoisenew
				noiseMapScale = 1,1
				noiseMapOffset = 0,0
				emitColor0 = 1,0.816042185,0.506993055,1
				emitColor1 = 0.925373137,0.773156404,0.287965715,1
				sunspotTex = BUILTIN/sunsurfacenew
				sunspotTexScale = 1,1
				sunspotTexOffset = 0,0
				sunspotPower = 1
				sunspotColor = 0.283582091,0.126710668,0.0208224356,1
				rimColor = 1,0.863375425,0.583916068,1
				rimPower = 1.29
				rimBlend = 2.5
			}
			Coronas
			{
				Value
				{
					scaleSpeed = 0.007
					scaleLimitY = 5
					scaleLimitX = 5
					updateInterval = 5
					speed = -1
					rotation = 0
					Material
					{
						texture = BUILTIN/suncoronanew
						mainTexScale = 1,1
						mainTexOffset = 0,0
						invFade = 2.553731
					}
				}
				Value
				{
					scaleSpeed = 0.009
					scaleLimitY = 5
					scaleLimitX = 5
					updateInterval = 5
					speed = 1
					rotation = 0
					Material
					{
						texture = BUILTIN/suncoronanew
						mainTexScale = 1,1
						mainTexOffset = 0,0
						invFade = 2.553731
					}
				}
			}
		}
		Atmosphere
		{
			enabled = True // Whether the body has an atmosphere
			oxygen = False // Whether the atmosphere contains oxygen
			staticDensityASL = 0.00072492861572823 // Atmospheric density at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			adiabaticIndex = 1.42999994754791 // A thermodynamic property of the gas, also known as heat capacity ratio
			atmosphereDepth = 600000 // The height of the atmosphere
			gasMassLapseRate = 0.465695397616382
			atmosphereMolarMass = 0.00219999998807907 // The mass in kilograms of one mole of gas
			pressureCurveIsNormalized = False // Whether the pressure curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			shockTemperatureMultiplier = 0.5 // Multiplies the External/Shock Temperature by this value. This is relevant for aerodynamic heating
			staticPressureASL = 16 // The static pressure at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			temperatureCurveIsNormalized = False // Whether the temperature curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			temperatureLapseRate = 0.00973333333333333
			temperatureSeaLevel = 5840 // The static temperature at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			ambientColor = 0,0,0,0 // All objects inside of the atmosphere will slightly shine in this color
			addAFG = True
			pressureCurve // Assigns a pressure value to a height value inside of the atmosphere
			{
				key = 0 16 0 0
				key = 5000 8.3 -0.001532 -0.001532
				key = 10000 0.68 -0.001178053 -0.001178053
				key = 10753.09 0.300954 -2.96097E-05 -2.96097E-05
				key = 14194.01 0.2613179 -8.41565E-07 -8.41565E-07
				key = 350000 0.1 -7.49481E-07 -7.49481E-07
				key = 400000 0.04 -7.05211E-07 -7.05211E-07
				key = 590000 2E-05 -6.21053E-09 -6.21053E-09
				key = 600000 0 0 0
			}
			temperatureCurve // Assigns a base temperature value to a height value inside of the atmosphere
			{
				key = 0 5840 0 -0.2780258
				key = 10000 4465 -0.01447884 -0.01447884
				key = 50000 4000 -0.007179292 0.003853968
				key = 250000 5800 0.0009989792 0.0009989792
				key = 500000 6000 0.001352723 0.001352723
				key = 600000 10000 0.06371323 0
			}
			temperatureSunMultCurve // How the temperature modifiers vary by altitude, in the form of a multiplier
			{
				key = 0 0 0 0
			}
			temperatureLatitudeBiasCurve // Latitudinal temperature modifier
			{
				key = 0 0 0 0
			}
			temperatureLatitudeSunMultCurve // Day - night temperature modifier by latitude
			{
				key = 0 0 0 0
			}
			temperatureAxialSunBiasCurve // Seasonal temperature modifier by true anomaly
			{
				key = 0 0 0 0
			}
			temperatureAxialSunMultCurve // How the seasonal temperature modifier varies by latitude
			{
				key = 0 0 0 0
			}
			temperatureEccentricityBiasCurve // Orbital eccentricity temperature modifier
			{
				key = 0 0 0 0
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Bop is a small moon in the vicinity of Jool. In Kerbal mythology, Bop is believed to be the home of the Kraken, a mischievous creature said to play with the ships of hapless explorers, by spinning them out of control until torn asunder, then casting them into oblivion.
			radius = 65000
			geeASL = 0.0600204949543182
			mass = 3.72610898343278E+19
			gravParameter = 2486834944.41491
			rotates = True
			rotationPeriod = 544507.428516654
			tidallyLocked = True
			initialRotation = 230
			inverseRotThresholdAltitude = 100000
			albedo = 0.200000002980232
			emissivity = 0.800000011920929
			coreTemperatureOffset = 10
			timewarpAltitudeLimits = 0 24500 24500 24500 40000 60000 80000 100000
			sphereOfInfluence = 1221060.86284253
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/bop_biomes
			useTheInName = False
			displayName = Bop^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 12 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 9 // Science multiplier for in space low science.
				inSpaceHighDataValue = 8 // Science multiplier for in space high science.
				recoveryValue = 8
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 25000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Peaks // The name of this biome.
					displayName = Peaks // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.866666675,0.800000012,0.654901981,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Ridges // The name of this biome.
					displayName = Ridges // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.768627465,0.698039234,0.545098066,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.960784316,0.886274517,0.725490212,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Slopes // The name of this biome.
					displayName = Slopes // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.68235296,0.615686297,0.470588237,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Valley // The name of this biome.
					displayName = Valley // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.592156887,0.549019635,0.450980395,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 1000
			fadeEnd = 30000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0,0,0,1
				shininess = 0.078125
				texture = BUILTIN/gp1minormoon100
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/gp1minormoon101
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 7
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 30000
			fadeEnd = 150000
			deactivateAltitude = 250000
			mapMaxHeight = 30000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 10
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1.1
				steepPower = 3
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/bopSteep_diffuse
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/gillySteep_nrm
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 50
				steepTiling = 25
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 100000
				midTex = BUILTIN/gillyMedTerrain_diffuse
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 100000
				midBumpMap = BUILTIN/gillyMedTerrain_nrm
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 100000
				highTex = BUILTIN/gillyHighTerrain
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 50000
				lowStart = 0
				lowEnd = 0
				highStart = 0.4
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 1
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.2
				tintColor = 1,1,1,0
				texTiling = 1024
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 20000
				multiFactor = 0.5
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				FlattenArea
				{
					DEBUG_showColors = False
					flattenTo = 900
					innerRadius = 15000
					outerRadius = 35000
					position = -19468.5,5737.08887,61828.1289
					smoothEnd = 0
					smoothStart = 0
					order = 11
					enabled = False
					name = _Crater1
				}
				MapDecal
				{
					absolute = False
					absoluteOffset = 0
					angle = 0
					colorMap = BUILTIN/bigcrater
					cullBlack = False
					DEBUG_HighlightInclusion = False
					heightMapDeformity = 10
					position = -19468.5,5737.08887,61828.1289
					removeScatter = False
					radius = 65000
					smoothColor = 0.125
					smoothHeight = 0.125
					useAlphaHeightSmoothing = False
					order = 120
					enabled = True
					name = _Crater1
				}
				VertexSimplexHeightAbsolute
				{
					deformity = 24000
					frequency = 0.800000011920929
					octaves = 3
					persistence = 0.5
					seed = 3339066
					order = 10
					enabled = True
					name = _Height
				}
				VertexHeightNoise
				{
					deformity = 600
					frequency = 5
					octaves = 8
					persistence = 0.5
					seed = 45756
					noiseType = RiggedMultifractal
					mode = Low
					lacunarity = 2.5
					order = 19
					enabled = True
					name = _Height
				}
				FlattenArea
				{
					DEBUG_showColors = False
					flattenTo = 2200
					innerRadius = 4000
					outerRadius = 15000
					position = 2000,5737.08887,61828.1289
					smoothEnd = 0
					smoothStart = 0
					order = 13
					enabled = False
					name = _Crater2
				}
				MapDecal
				{
					absolute = False
					absoluteOffset = 0
					angle = 0
					colorMap = BUILTIN/bigcrater
					cullBlack = False
					DEBUG_HighlightInclusion = False
					heightMapDeformity = 10
					position = 2000,5737.08887,61828.1289
					removeScatter = False
					radius = 20000
					smoothColor = 0.125
					smoothHeight = 0.125
					useAlphaHeightSmoothing = False
					order = 121
					enabled = True
					name = _Crater2
				}
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				VertexSimplexNoiseColor
				{
					blend = 1
					colorStart = 0.171641767,0.15043062,0.130652696,1
					colorEnd = 0.291044772,0.240739986,0.21285364,1
					frequency = 1
					octaves = 6
					persistence = 0.5
					seed = 64564
					order = 100
					enabled = True
					name = _Color
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					order = 999999
					enabled = True
					name = Scatter
					Scatters
					{
						Value
						{
							name = boulder
							materialType = BumpedDiffuse
							material = BUILTIN/brown_cliff
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 3
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.5
							recieveShadows = True
							seed = 231123
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 1,1,1,1
								mainTex = BUILTIN/brown_cliff
								mainTexScale = 1,1
								mainTexOffset = 0,0
								bumpMap = BUILTIN/bouldernormal
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Base
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 1
									scatterName = boulder
									delete = False
								}
							}
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = -13172.3496,73416.7266,25863.1309
					repositionRadiusOffset = 13949.7001953125
					repositionToSphere = True
					repositionToSphereSurface = False
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = DeadKraken
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Also known as the red dot that you can see if you squint at it really hard, Duna has long been a wonder to Kerbalkind. The planet has been held in much awe, due to its striking red color and stark contrast to the color green.
			radius = 320000
			geeASL = 0.300102493404406
			mass = 4.51542702477492E+21
			gravParameter = 301363211975.098
			rotates = True
			rotationPeriod = 65517.859375
			tidallyLocked = False
			initialRotation = 90
			inverseRotThresholdAltitude = 100000
			albedo = 0.170000001788139
			emissivity = 0.829999983310699
			coreTemperatureOffset = 0
			timewarpAltitudeLimits = 0 30000 30000 60000 100000 300000 600000 800000
			sphereOfInfluence = 47921949.369738
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/duna_biomes
			useTheInName = False
			displayName = Duna^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 8 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 5 // Science multiplier for flying low science.
				flyingHighDataValue = 5 // Science multiplier for flying high science.
				inSpaceLowDataValue = 7 // Science multiplier for in space low science.
				inSpaceHighDataValue = 5 // Science multiplier for in space high science.
				recoveryValue = 5
				flyingAltitudeThreshold = 12000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 140000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,1,1,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.988235295,0.549019635,0.349019617,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.913725495,0.41568628,0.192156866,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Craters // The name of this biome.
					displayName = Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.717647076,0.396078438,0.00392156886,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,0.666666687,0.513725519,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midland Sea // The name of this biome.
					displayName = Midland Sea // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,0.568627477,0.00784313772,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northern Basin // The name of this biome.
					displayName = Northeast Basin // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.709803939,0.160784319,0.13333334,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Southern Basin // The name of this biome.
					displayName = Southern Basin // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.823529422,0.290196091,0.262745112,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northern Shelf // The name of this biome.
					displayName = Northern Shelf // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.580392182,0.0705882385,0.0431372561,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midland Canyon // The name of this biome.
					displayName = Midland Canyon // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.733333349,0.345098048,0.0352941193,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Eastern Canyon // The name of this biome.
					displayName = Eastern Canyon // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.600000024,0.266666681,0,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Western Canyon // The name of this biome.
					displayName = Western Canyon // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.435294122,0.192156866,0,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Polar Highlands // The name of this biome.
					displayName = Polar Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.90196079,0.90196079,0.90196079,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Polar Craters // The name of this biome.
					displayName = Polar Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.745098054,0.745098054,0.745098054,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Atmospheric
			fadeStart = 30000
			fadeEnd = 100000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0.0294117928,0.0294117928,0.0294117928,1
				shininess = 0.051
				texture = BUILTIN/Duna [Albedo]
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/Duna5_01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				rimPower = 1.62
				rimBlend = 0.3
				rimColorRamp = BUILTIN/desert_atmogradient
				rimColorRampScale = 1,1
				rimColorRampOffset = 0,0
				localLightDirection = 0.640664756,1.59069477E-05,-0.767820835,0
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		Atmosphere
		{
			enabled = True // Whether the body has an atmosphere
			oxygen = False // Whether the atmosphere contains oxygen
			staticDensityASL = 0.149935108881759 // Atmospheric density at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			adiabaticIndex = 1.20000004768372 // A thermodynamic property of the gas, also known as heat capacity ratio
			atmosphereDepth = 50000 // The height of the atmosphere
			gasMassLapseRate = 3.04406677337964
			atmosphereMolarMass = 0.0430000014603138 // The mass in kilograms of one mole of gas
			pressureCurveIsNormalized = False // Whether the pressure curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			shockTemperatureMultiplier = 1.1 // Multiplies the External/Shock Temperature by this value. This is relevant for aerodynamic heating
			staticPressureASL = 6.75500011444092 // The static pressure at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			temperatureCurveIsNormalized = False // Whether the temperature curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			temperatureLapseRate = 0.005
			temperatureSeaLevel = 250 // The static temperature at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			ambientColor = 0.323529422,0.220170617,0.173659176,1 // All objects inside of the atmosphere will slightly shine in this color
			lightColor = 0.509465635,0.588402689,0.643137276,0 // Same as waveLength in AtmosphereFromGround
			addAFG = True
			pressureCurve // Assigns a pressure value to a height value inside of the atmosphere
			{
				key = 0 6.755 0 -0.0007
				key = 12000 1.276 -0.000223 -0.000223
				key = 20000 0.241 -4.22E-05 -4.22E-05
				key = 35000 0.015 -2.787075E-06 -2.787075E-06
				key = 50000 0 0 0
			}
			temperatureCurve // Assigns a base temperature value to a height value inside of the atmosphere
			{
				key = 0 233 0 -0.0004261126
				key = 1000 232.8 -0.000573325 -0.000573325
				key = 25000 153.7 -0.001877083 -0.001877083
				key = 30000 150 0 0
				key = 45000 150 0 0
				key = 50000 160 0.003746914 0
			}
			temperatureSunMultCurve // How the temperature modifiers vary by altitude, in the form of a multiplier
			{
				key = 0 1 0 0
				key = 1000 1 0 0
				key = 25000 0 0 0
				key = 45000 0 0 0
				key = 47350 0.4551345 0.0006885778 0.0006885778
				key = 50000 1 0 0
			}
			temperatureLatitudeBiasCurve // Latitudinal temperature modifier
			{
				key = 0 20 0 -0.0957164
				key = 50 0 -0.950278 -0.950278
				key = 70 -30 -1.955704 -1.955704
				key = 90 -50 -0.02418368 0
			}
			temperatureLatitudeSunMultCurve // Day - night temperature modifier by latitude
			{
				key = 0 18 0 0.06497125
				key = 40 25 0 0
				key = 65 20 -0.5202533 -0.5202533
				key = 90 5 0 0
			}
			temperatureAxialSunBiasCurve // Seasonal temperature modifier by true anomaly
			{
				key = 0 0 0 0
			}
			temperatureAxialSunMultCurve // How the seasonal temperature modifier varies by latitude
			{
				key = 0 0 0 0
			}
			temperatureEccentricityBiasCurve // Orbital eccentricity temperature modifier
			{
				key = 0 0 0 0
			}
			AtmosphereFromGround // The atmosphere effect that is seen on the horizon
			{
				DEBUG_alwaysUpdateAll = False // Whether all parameters should get recalculated and reapplied every frame.
				doScale = True // Whether the atmosphere mesh should be scaled automatically.
				innerRadius = 322920 // The lower bound of the atmosphere effect.
				invWaveLength = 14.8436403,8.34259987,5.84501028,0.5
				outerRadius = 331200 // The upper bound of the atmosphere effect.
				samples = 4
				transformScale = 1.03499997,1.03499997,1.03499997 // The scale of the atmosphere mesh in all three directions. Automatically set if doScale is enabled.
				waveLength = 0.509465635,0.588402689,0.643137276,0
				outerRadiusMult = 1.035 // A multiplier that automatically sets outerRadius based on the planets radius.
				innerRadiusMult = 0.975 // A multiplier that automatically sets innerRadius based on the planets radius.
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 10
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 50000
			fadeEnd = 110000
			deactivateAltitude = 120000
			mapMaxHeight = 10500
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 7.5
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1.6
				steepPower = 1.2
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/Duna Cliff [Diffuse]
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/Duna Boulder [Normal]
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 1000
				steepTiling = 100
				lowTex = BUILTIN/Duna Floor - low [Diffuse]
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 38000
				midTex = BUILTIN/Duna Floor [Diffuse]
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 38000
				midBumpMap = BUILTIN/Duna Floor [Normal]
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 38000
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 1
				lowStart = 0
				lowEnd = 0.3
				highStart = 1
				highEnd = 1
				globalDensity = 0
				fogColorRamp = BUILTIN/desert_atmogradient
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.55
				tintColor = 1,1,1,0
				texTiling = 1000
				texPower = 0.3
				multiPower = 0.3
				groundTexStart = 20000
				groundTexEnd = 60000
				multiFactor = 0.5
				mainTex = BUILTIN/SandyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 0
			}
			Mods
			{
				VertexHeightMap
				{
					map = BUILTIN/desertplanet_height
					offset = 0
					deformity = 6000
					scaleDeformityByRadius = False
					order = 10
					enabled = True
					name = _Height
				}
				VertexSimplexHeightAbsolute
				{
					deformity = 500
					frequency = 12
					octaves = 6
					persistence = 0.800000011920929
					seed = 23893455
					order = 12
					enabled = True
					name = _Height
				}
				VertexHeightNoiseVertHeightCurve2
				{
					deformity = 1000
					ridgedAddFrequency = 12
					ridgedAddLacunarity = 2
					ridgedAddOctaves = 4
					ridgedAddSeed = 1212
					ridgedMode = Low
					ridgedSubFrequency = 12
					ridgedSubLacunarity = 2
					ridgedSubOctaves = 4
					ridgedSubSeed = 23234423
					simplexFrequency = 12
					simplexHeightEnd = 6500
					simplexHeightStart = 0
					simplexOctaves = 4
					simplexPersistence = 0.600000023841858
					simplexSeed = 654786
					order = 13
					enabled = True
					name = _Height
					simplexCurve
					{
						key = 0 0 0.1466263 0.1466263
						key = 0.7922793 0.2448772 0.6761706 1.497418
						key = 1 1 6.106985 6.106985
					}
				}
				VertexHeightNoiseVertHeightCurve2
				{
					deformity = 1000
					ridgedAddFrequency = 18
					ridgedAddLacunarity = 2
					ridgedAddOctaves = 4
					ridgedAddSeed = 1212
					ridgedMode = Low
					ridgedSubFrequency = 18
					ridgedSubLacunarity = 2
					ridgedSubOctaves = 4
					ridgedSubSeed = 23234423
					simplexFrequency = 18
					simplexHeightEnd = 7500
					simplexHeightStart = 0
					simplexOctaves = 4
					simplexPersistence = 0.600000023841858
					simplexSeed = 654786
					order = 14
					enabled = True
					name = _Height
					simplexCurve
					{
						key = 0 0 2 2
						key = 1 1 0 0
					}
				}
				VertexHeightNoiseVertHeightCurve2
				{
					deformity = 2000
					ridgedAddFrequency = 22
					ridgedAddLacunarity = 3
					ridgedAddOctaves = 6
					ridgedAddSeed = 534543
					ridgedMode = Low
					ridgedSubFrequency = 22
					ridgedSubLacunarity = 3
					ridgedSubOctaves = 6
					ridgedSubSeed = 435436
					simplexFrequency = 22
					simplexHeightEnd = 8500
					simplexHeightStart = 0
					simplexOctaves = 4
					simplexPersistence = 0.600000023841858
					simplexSeed = 546567
					order = 15
					enabled = True
					name = _Height
					simplexCurve
					{
						key = 0 0 0 0
						key = 1 1 0 0
					}
				}
				AltitudeAlpha
				{
					atmosphereDepth = 11500
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				LandControl
				{
					altitudeBlend = 0.05
					altitudeFrequency = 12
					altitudeOctaves = 2
					altitudePersistance = 0.6
					altitudeSeed = 212121
					createColors = True
					createScatter = True
					heightMap = BUILTIN/desertplanet_height
					latitudeBlend = 0.02
					latitudeFrequency = 4
					latitudeOctaves = 4
					latitudePersistance = 0.6
					latitudeSeed = 47373
					longitudeBlend = 0.05
					longitudeFrequency = 4
					longitudeOctaves = 4
					longitudePersistance = 0.6
					longitudeSeed = 768453
					useHeightMap = False
					vHeightMax = 3500
					order = 9999991
					enabled = True
					name = _LandClass
					Scatters
					{
						Value
						{
							name = boulder
							materialType = StandardSpecular
							material = BUILTIN/red_cliff
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 0.25
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 4
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.1
							recieveShadows = True
							seed = 4565677
							verticalOffset = 0.2
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 0.595588207,0.429113448,0.367863297,1
								mainTex = BUILTIN/Duna Boulder [Diffuse]
								mainTexScale = 2,2
								mainTexOffset = 0,0
								cutoff = 0.5
								glossiness = 0.5
								glossMapScale = 1
								smoothnessTextureChannel = AlbedoAlpha
								specColor = 0.0735294223,0.0735294223,0.0735294223,1
								metallicGlossMapScale = 1,1
								metallicGlossMapOffset = 0,0
								specularHighlights = True
								glossyReflections = True
								bumpScale = 1
								bumpMap = BUILTIN/Duna Boulder [Normal]
								bumpMapScale = 2,2
								bumpMapOffset = 0,0
								parallax = 0.02
								parallaxMapScale = 1,1
								parallaxMapOffset = 0,0
								occlusionStrength = 1
								occlusionMapScale = 1,1
								occlusionMapOffset = 0,0
								emissionColor = 0,0,0,1
								emissionMapScale = 1,1
								emissionMapOffset = 0,0
								detailMaskScale = 1,1
								detailMaskOffset = 0,0
								detailAlbedoMapScale = 1,1
								detailAlbedoMapOffset = 0,0
								detailNormalMapScale = 1,1
								detailNormalMapOffset = 0,0
								UVSec = Uv0
								mode = Opaque
								srcBlend = 1
								dstBlend = 0
								ZWrite = 1
							}
						}
						Value
						{
							name = iceboulder
							materialType = StandardSpecular
							material = BUILTIN/snowboulder
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 0.25
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 4
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.1
							recieveShadows = True
							seed = 324234645
							verticalOffset = 0.2
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 0.904411793,0.884461522,0.884461522,1
								mainTex = BUILTIN/Duna Snow Boulder [Diffuse]
								mainTexScale = 3,3
								mainTexOffset = 0,0
								cutoff = 0.5
								glossiness = 0.5
								glossMapScale = 1
								smoothnessTextureChannel = AlbedoAlpha
								specColor = 0.0661764741,0.0661764741,0.0661764741,1
								metallicGlossMapScale = 1,1
								metallicGlossMapOffset = 0,0
								specularHighlights = True
								glossyReflections = True
								bumpScale = 1
								bumpMap = BUILTIN/Duna Snow Boulder [Normal]
								bumpMapScale = 3,3
								bumpMapOffset = 0,0
								parallax = 0.02
								parallaxMapScale = 1,1
								parallaxMapOffset = 0,0
								occlusionStrength = 1
								occlusionMapScale = 1,1
								occlusionMapOffset = 0,0
								emissionColor = 0,0,0,1
								emissionMapScale = 1,1
								emissionMapOffset = 0,0
								detailMaskScale = 1,1
								detailMaskOffset = 0,0
								detailAlbedoMapScale = 1,1
								detailAlbedoMapOffset = 0,0
								detailNormalMapScale = 1,1
								detailNormalMapOffset = 0,0
								UVSec = Uv0
								mode = Opaque
								srcBlend = 1
								dstBlend = 0
								ZWrite = 1
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.470149279,0.180532217,0.0969888344,0
							coverageBlend = 0.5
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.2
							coverageSeed = 34535345
							name = Badlands
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.8
							noiseColor = 0.335820913,0.19791387,0.120942496,0
							noiseFrequency = 2
							noiseOctaves = 8
							noisePersistance = 0.7
							noiseSeed = 45656745
							delete = False
							altitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = 1
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 0.25
									scatterName = boulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.283582091,0.0993807092,0.0677210912,0
							coverageBlend = 0.01
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.9
							coverageSeed = 34535345
							name = Craters
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.1
							noiseColor = 0.216417909,0.150523514,0.134049892,0
							noiseFrequency = 9
							noiseOctaves = 6
							noisePersistance = 0.7
							noiseSeed = 45656745
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 0
								startEnd = -10
								startStart = -10
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 0.5
									scatterName = boulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 100
							alterRealHeight = 100
							color = 0.865671635,0.865671635,0.865671635,0
							coverageBlend = 0
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.8
							coverageSeed = 93747294
							name = Ice Caps
							latDelta = 0
							latitudeDouble = True
							lonDelta = 1
							minimumRealHeight = 0.100000001490116
							noiseBlend = 0.2
							noiseColor = 0.768656731,0.768656731,0.768656731,0
							noiseFrequency = 9
							noiseOctaves = 6
							noisePersistance = 0.2
							noiseSeed = 6288946
							delete = False
							altitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = 0.754999995231628
								startStart = 0.75
							}
							latitudeRange
							{
								endEnd = 0.25
								endStart = 0.245000004768372
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = -2
									scatterName = boulder
									delete = False
								}
								Value
								{
									density = 1
									scatterName = iceboulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.134328365,0.112456717,0.104254849,0
							coverageBlend = 0.5
							coverageFrequency = 4
							coverageOctaves = 5
							coveragePersistance = 0.2
							coverageSeed = 93747294
							name = Frost
							latDelta = 1
							latitudeDouble = True
							lonDelta = 1
							minimumRealHeight = 0.100000001490116
							noiseBlend = 1
							noiseColor = 0.074626863,0.0649333894,0.0640454441,0
							noiseFrequency = 9
							noiseOctaves = 6
							noisePersistance = 0.2
							noiseSeed = 6288946
							delete = False
							altitudeRange
							{
								endEnd = 0.150000005960464
								endStart = 0.100000001490116
								startEnd = 0.100000001490116
								startStart = -1
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
						}
					}
				}
				VertexColorMapBlend
				{
					map = BUILTIN/duna_coloraddition
					blend = 0.5
					order = 9999993
					enabled = True
					name = _LandClass
				}
				VertexSimplexNoiseColor
				{
					blend = 0.125
					colorStart = 1,1,1,1
					colorEnd = 0,0,0,1
					frequency = 24
					octaves = 4
					persistence = 0.600000023841858
					seed = 452635
					order = 9999992
					enabled = True
					name = _LandClass
				}
				AerialPerspectiveMaterial
				{
					atmosphereDepth = 150000
					DEBUG_SetEveryFrame = True
					globalDensity = -1E-05
					heightFalloff = 6.75
					oceanDepth = 0
					order = 100
					enabled = True
					name = _Material_AerialPerspective
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 230
					reorientInitialUp = 0,1,0
					repositionRadial = 24275.75,94091.4766,-305676.094
					repositionRadiusOffset = 510
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Face
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = 242934.5,-162286.297,-133611.5
					repositionRadiusOffset = -5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = MSL
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				MapDecal
				{
					absolute = False
					absoluteOffset = 0
					angle = 0
					colorMap = BUILTIN/pyramidcolor
					cullBlack = False
					DEBUG_HighlightInclusion = False
					heightMap = BUILTIN/pyramid
					heightMapDeformity = 100
					position = -123617.5,-294525.688,-42850.8008
					removeScatter = False
					radius = 400
					smoothColor = 0.125
					smoothHeight = 0.125
					useAlphaHeightSmoothing = False
					order = 8000
					enabled = True
					name = Pyramid
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = -123617.5,-294525.688,-42850.8008
					repositionRadiusOffset = 0
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 8001
					enabled = True
					name = Pyramid
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 62
					reorientInitialUp = 0,1,0
					repositionRadial = 320510.813,-13570.3604,-29862.6602
					repositionRadiusOffset = 4.4
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Anniversary4
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = There’s been a considerable amount of controversy around the status of Eeloo as being a proper planet or a just “lump of ice going around the Sun”. The debate is still ongoing, since most academic summits held to address the issue have devolved into, on good days, petty name calling, and on worse ones, all-out brawls.
			radius = 210000
			geeASL = 0.172058761891442
			mass = 1.11492242417007E+21
			gravParameter = 74410814527.0496
			rotates = True
			rotationPeriod = 19460
			tidallyLocked = False
			initialRotation = 25
			inverseRotThresholdAltitude = 100000
			albedo = 0.5
			emissivity = 0.5
			coreTemperatureOffset = 0
			timewarpAltitudeLimits = 0 4000 4000 20000 30000 40000 70000 150000
			sphereOfInfluence = 119082941.647812
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/eeloo_biomes
			useTheInName = False
			displayName = Eeloo^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 15 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 12 // Science multiplier for in space low science.
				inSpaceHighDataValue = 10 // Science multiplier for in space high science.
				recoveryValue = 10
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 60000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,1,1,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northern Glaciers // The name of this biome.
					displayName = Northern Glaciers // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.792156875,0.792156875,0.792156875,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.482352942,0.639215708,0.905882359,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.835294127,0.854901969,0.882352948,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Ice Canyons // The name of this biome.
					displayName = Ice Canyons // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,0.709803939,0.388235301,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Craters // The name of this biome.
					displayName = Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.87843138,0.533333361,0.13333334,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.745098054,0.807843149,0.909803927,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Fragipan // The name of this biome.
					displayName = Fragipan // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,0.80392158,0.580392182,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Babbage Patch // The name of this biome.
					displayName = Babbage Patch // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.592156887,0.701960802,0.894117653,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Southern Glaciers // The name of this biome.
					displayName = Southern Glaciers // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.87843138,0.87843138,0.87843138,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Mu Glacier // The name of this biome.
					displayName = Mu Glacier // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.486274511,0.486274511,0.486274511,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = AtmosphericStandard
			fadeStart = 35000
			fadeEnd = 100000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0.074626863,0.074626863,0.074626863,1
				shininess = 0.4605465
				texture = BUILTIN/snowydwarfplanet00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/snowydwarfplanet01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				rimPower = 0
				rimBlend = 0
				rimColorRampScale = 1,1
				rimColorRampOffset = 0,0
				localLightDirection = 1,0,0,0
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 10
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 50000
			fadeEnd = 110000
			deactivateAltitude = 120000
			mapMaxHeight = 6000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 11.98
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1
				steepPower = 1
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/EelooSteep_Diffuse
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/EelooSteep_Normal
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 6000
				steepTiling = 40
				lowTex = BUILTIN/EelooHighQuality-Low_Diffuse
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 50000
				midTex = BUILTIN/EelooHighQuality-Mid_Diffuse
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 50000
				midBumpMap = BUILTIN/EelooHighQuality-Mid_Normal
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 50000
				highTex = BUILTIN/EelooHighQuality-High_Diffuse
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 50000
				lowStart = 0.15
				lowEnd = 0.4
				highStart = 0.7
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.55
				tintColor = 1,1,1,0
				texTiling = 1000
				texPower = 0.3
				multiPower = 0.3
				groundTexStart = 20000
				groundTexEnd = 60000
				multiFactor = 0.5
				mainTex = BUILTIN/SandyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 0
			}
			Mods
			{
				AltitudeAlpha
				{
					atmosphereDepth = 4000
					invert = False
					order = 999999999
					enabled = False
					name = _Material_ModProjection
				}
				LandControl
				{
					altitudeBlend = 0.05
					altitudeFrequency = 12
					altitudeOctaves = 2
					altitudePersistance = 0.6
					altitudeSeed = 212121
					createColors = True
					createScatter = True
					heightMap = BUILTIN/snowydwarfplanet_height
					latitudeBlend = 0.02
					latitudeFrequency = 4
					latitudeOctaves = 4
					latitudePersistance = 0.6
					latitudeSeed = 47373
					longitudeBlend = 0.05
					longitudeFrequency = 4
					longitudeOctaves = 4
					longitudePersistance = 0.6
					longitudeSeed = 768453
					useHeightMap = False
					vHeightMax = 3500
					order = 9999991
					enabled = True
					name = _LandClass
					Scatters
					{
						Value
						{
							name = boulder
							materialType = StandardSpecular
							material = BUILTIN/snowboulder
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 0.0199999995529652
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 4
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.1
							recieveShadows = True
							seed = 4565677
							verticalOffset = 0.2
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 0.904411793,0.884461522,0.884461522,1
								mainTex = BUILTIN/Duna Snow Boulder [Diffuse]
								mainTexScale = 3,3
								mainTexOffset = 0,0
								cutoff = 0.5
								glossiness = 0.5
								glossMapScale = 1
								smoothnessTextureChannel = AlbedoAlpha
								specColor = 0.0661764741,0.0661764741,0.0661764741,1
								metallicGlossMapScale = 1,1
								metallicGlossMapOffset = 0,0
								specularHighlights = True
								glossyReflections = True
								bumpScale = 1
								bumpMap = BUILTIN/Duna Snow Boulder [Normal]
								bumpMapScale = 3,3
								bumpMapOffset = 0,0
								parallax = 0.02
								parallaxMapScale = 1,1
								parallaxMapOffset = 0,0
								occlusionStrength = 1
								occlusionMapScale = 1,1
								occlusionMapOffset = 0,0
								emissionColor = 0,0,0,1
								emissionMapScale = 1,1
								emissionMapOffset = 0,0
								detailMaskScale = 1,1
								detailMaskOffset = 0,0
								detailAlbedoMapScale = 1,1
								detailAlbedoMapOffset = 0,0
								detailNormalMapScale = 1,1
								detailNormalMapOffset = 0,0
								UVSec = Uv0
								mode = Opaque
								srcBlend = 1
								dstBlend = 0
								ZWrite = 1
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.595997214,0.641892254,0.679104447,0
							coverageBlend = 0.5
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.2
							coverageSeed = 34535345
							name = Snow
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.8
							noiseColor = 0.373134315,0.361236542,0.311815023,0
							noiseFrequency = 0.5
							noiseOctaves = 8
							noisePersistance = 0.7
							noiseSeed = 45656745
							delete = False
							altitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = 1
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 0.0199999995529652
									scatterName = boulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.373134315,0.326146901,0.207441822,0
							coverageBlend = 0.5
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.2
							coverageSeed = 34535345
							name = MoreSnow
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.8
							noiseColor = 0.24626863,0.227543369,0.205797896,0
							noiseFrequency = 0.5
							noiseOctaves = 8
							noisePersistance = 0.7
							noiseSeed = 45656745
							delete = False
							altitudeRange
							{
								endEnd = 0.300000011920929
								endStart = 0.100000001490116
								startEnd = -1
								startStart = -1
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 0.0199999995529652
									scatterName = boulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.597014904,0.597014904,0.597014904,0
							coverageBlend = 0.5
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.2
							coverageSeed = 456567834
							name = EvenMoreSnow
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.8
							noiseColor = 0.201492548,0.192007825,0.172607258,0
							noiseFrequency = 0.5
							noiseOctaves = 8
							noisePersistance = 0.7
							noiseSeed = 1232343
							delete = False
							altitudeRange
							{
								endEnd = 2
								endStart = 1
								startEnd = 0.800000011920929
								startStart = 0.699999988079071
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 0.0199999995529652
									scatterName = boulder
									delete = False
								}
							}
						}
					}
				}
				AerialPerspectiveMaterial
				{
					atmosphereDepth = 150000
					DEBUG_SetEveryFrame = True
					globalDensity = -1E-05
					heightFalloff = 6.75
					oceanDepth = 0
					order = 100
					enabled = True
					name = _Material_AerialPerspective
				}
				VertexSimplexHeight
				{
					deformity = 600
					frequency = 8
					octaves = 10
					persistence = 0.5
					seed = 435213423
					order = 20
					enabled = True
					name = _HeightNoise
				}
				VertexHeightNoise
				{
					deformity = 400
					frequency = 3
					octaves = 6
					persistence = 0.5
					seed = 783456456
					noiseType = RiggedMultifractal
					mode = Low
					lacunarity = 1.5
					order = 22
					enabled = True
					name = _HeightNoise
				}
				VertexVoronoi
				{
					deformation = 250
					displacement = 0.00499999988824129
					enableDistance = True
					frequency = 12
					seed = 56457563
					order = 23
					enabled = True
					name = _HeightNoise
				}
				FlattenOcean
				{
					oceanRadius = 1
					order = 21
					enabled = True
					name = _HeightNoise
				}
				VertexHeightNoiseVertHeight
				{
					heightStart = 0.2
					heightEnd = 1
					deformity = 140
					frequency = 70
					octaves = 4
					persistance = 0.7
					seed = 78967456
					mode = Low
					noiseType = RiggedMultifractal
					lacunarity = 3
					order = 30
					enabled = True
					name = _FineDetail
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = -40
					reorientInitialUp = 0,1,0
					repositionRadial = -66385.4297,92051.3516,176690.5
					repositionRadiusOffset = -0.2
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Anniversary3
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Eve is certainly the purplest object in the solar system. It’s one of the larger, most visible objects, mainly because of its very, very purple tint.It is considered by some to be almost a sister planet to Kerbin. Well, despite the purple, and the toxic atmosphere, and the extreme pressures and temperatures. Actually, it’s not very similar at all is it? Who are those people?
			radius = 700000
			geeASL = 1.7005807760833
			mass = 1.2243980038014E+23
			gravParameter = 8171730229210.87
			rotates = True
			rotationPeriod = 80500
			tidallyLocked = False
			initialRotation = 0
			inverseRotThresholdAltitude = 100000
			albedo = 0.449999988079071
			emissivity = 0.550000011920929
			coreTemperatureOffset = 0
			timewarpAltitudeLimits = 0 30000 30000 60000 120000 240000 480000 600000
			sphereOfInfluence = 85109364.7382441
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/eve_biomes
			useTheInName = False
			displayName = Eve^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 8 // Science multiplier for landed science.
				splashedDataValue = 8 // Science multiplier for splashed down science.
				flyingLowDataValue = 6 // Science multiplier for flying low science.
				flyingHighDataValue = 6 // Science multiplier for flying high science.
				inSpaceLowDataValue = 7 // Science multiplier for in space low science.
				inSpaceHighDataValue = 5 // Science multiplier for in space high science.
				recoveryValue = 5
				flyingAltitudeThreshold = 22000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 400000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.862745106,0.75686276,0.996078432,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.450980395,0.180392161,0.525490224,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Explodium Sea // The name of this biome.
					displayName = Explodium Sea // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.694117665,0.349019617,0.513725519,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.360784322,0.0980392173,0.435294122,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.541176498,0.286274523,0.611764729,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Peaks // The name of this biome.
					displayName = Peaks // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.65882355,0.443137258,0.729411781,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Impact Ejecta // The name of this biome.
					displayName = Impact Ejecta // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.654901981,0.396078438,0.980392158,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Crater Lake // The name of this biome.
					displayName = Crater Lake // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.556862772,0.184313729,0.360784322,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Western Sea // The name of this biome.
					displayName = Western Sea // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.835294127,0.556862772,0.690196097,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Olympus // The name of this biome.
					displayName = Olympus // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,1,1,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Eastern Sea // The name of this biome.
					displayName = Eastern Sea // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.41568628,0.0705882385,0.235294119,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Craters // The name of this biome.
					displayName = Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.654901981,0.396078438,0.980392158,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Foothills // The name of this biome.
					displayName = Foothills // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.811764717,0.650980413,0.854901969,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Akatsuki Lake // The name of this biome.
					displayName = Akatsuki Lake // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.729411781,0.568627477,0.741176486,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Shallows // The name of this biome.
					displayName = Shallows // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.545098066,0.400000006,0.552941203,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Atmospheric
			fadeStart = 20000
			fadeEnd = 60000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0.396078438,0.396078438,0.396078438,1
				shininess = 0.0831425
				texture = BUILTIN/Eve2_00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/Eve2_01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				rimPower = 1.5
				rimBlend = 0.35
				rimColorRamp = BUILTIN/purple_atmogradiant
				rimColorRampScale = 1,1
				rimColorRampOffset = 0,0
				localLightDirection = 1,0,0,0
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		Atmosphere
		{
			enabled = True // Whether the body has an atmosphere
			oxygen = False // Whether the atmosphere contains oxygen
			staticDensityASL = 6.23837138885624 // Atmospheric density at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			adiabaticIndex = 1.20000004768372 // A thermodynamic property of the gas, also known as heat capacity ratio
			atmosphereDepth = 90000 // The height of the atmosphere
			gasMassLapseRate = 19.0254171112692
			atmosphereMolarMass = 0.0430000014603138 // The mass in kilograms of one mole of gas
			pressureCurveIsNormalized = False // Whether the pressure curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			shockTemperatureMultiplier = 1.1 // Multiplies the External/Shock Temperature by this value. This is relevant for aerodynamic heating
			staticPressureASL = 506.625 // The static pressure at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			temperatureCurveIsNormalized = False // Whether the temperature curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			temperatureLapseRate = 0.00453333333333333
			temperatureSeaLevel = 408 // The static temperature at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			ambientColor = 0.223535195,0.194325268,0.305882365,1 // All objects inside of the atmosphere will slightly shine in this color
			lightColor = 0.449885309,0.514925361,0.347322196,1 // Same as waveLength in AtmosphereFromGround
			addAFG = True
			pressureCurve // Assigns a pressure value to a height value inside of the atmosphere
			{
				key = 0 506.625 0 -0.04423852
				key = 15000 95.6891 -0.01304926 -0.01304926
				key = 25000 18.07334 -0.003012223 -0.003012223
				key = 40000 3.5 -0.0005689354 -0.0005689354
				key = 50000 0.1217772 -2.02962E-05 -2.02962E-05
				key = 60000 0.02300074 -3.8335E-06 -3.8335E-06
				key = 70000 0.004344278 -7.24E-07 -7.24E-07
				key = 80000 0.0008205283 -1.368E-07 -1.368E-07
				key = 90000 0 -2.58E-08 0
			}
			temperatureCurve // Assigns a base temperature value to a height value inside of the atmosphere
			{
				key = 0 420 0 -0.01029338
				key = 15000 280 -0.004705439 -0.004705439
				key = 50000 180 0 0
				key = 60000 190 0 0
				key = 70000 160 0 0
				key = 90000 250 0.005894589 0
			}
			temperatureSunMultCurve // How the temperature modifiers vary by altitude, in the form of a multiplier
			{
				key = 0 1 0 0
				key = 15000 0 0 0
				key = 50000 0.5 0 0
				key = 70000 1.5 3.82549E-05 3.82549E-05
				key = 90000 2 0 0
			}
			temperatureLatitudeBiasCurve // Latitudinal temperature modifier
			{
				key = 0 0 0 -0.1152484
				key = 30 -15 -1.127599 -1.127599
				key = 55 -30 -0.6 -0.6
				key = 90 -60 -0.02418368 0
			}
			temperatureLatitudeSunMultCurve // Day - night temperature modifier by latitude
			{
				key = 0 9 0 0
				key = 40 11 0.0669307 0.0669307
				key = 65 12 0 0
				key = 90 8 0 0
			}
			temperatureAxialSunBiasCurve // Seasonal temperature modifier by true anomaly
			{
				key = 0 0 0 0
			}
			temperatureAxialSunMultCurve // How the seasonal temperature modifier varies by latitude
			{
				key = 0 0 0 0
			}
			temperatureEccentricityBiasCurve // Orbital eccentricity temperature modifier
			{
				key = 0 0 0 0
			}
			AtmosphereFromGround // The atmosphere effect that is seen on the horizon
			{
				DEBUG_alwaysUpdateAll = False // Whether all parameters should get recalculated and reapplied every frame.
				doScale = True // Whether the atmosphere mesh should be scaled automatically.
				innerRadius = 699562.5 // The lower bound of the atmosphere effect.
				invWaveLength = 24.4114037,14.2240372,68.7178955,0.5
				outerRadius = 717500 // The upper bound of the atmosphere effect.
				samples = 4
				transformScale = 1.02499998,1.02499998,1.02499998 // The scale of the atmosphere mesh in all three directions. Automatically set if doScale is enabled.
				waveLength = 0.449885309,0.514925361,0.347322196,1
				outerRadiusMult = 1.025 // A multiplier that automatically sets outerRadius based on the planets radius.
				innerRadiusMult = 0.975 // A multiplier that automatically sets innerRadius based on the planets radius.
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 11
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 60000
			fadeEnd = 110000
			deactivateAltitude = 150000
			mapMaxHeight = 10000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Multiply
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.9
				dynamicFriction = 0.9
			}
			Material
			{
				factor = 10
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1.5
				steepPower = 2
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/terrain_rock00
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/Cliff (Layered Rock)_NRM
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 125
				steepTiling = 50
				lowTex = BUILTIN/eveLowSand_diffuse
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 55000
				midTex = BUILTIN/eveSand_diffuse
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 45000
				midBumpMap = BUILTIN/eveSand_nrm
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 45000
				highTex = BUILTIN/eveHighSand_diffuse
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 45000
				lowStart = 0
				lowEnd = 0.0003
				highStart = 0.25
				highEnd = 0.7
				globalDensity = 0
				fogColorRamp = BUILTIN/purple_atmogradiant
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.83
				tintColor = 1,1,1,0
				texTiling = 1000
				texPower = 0.5
				multiPower = 0.3
				groundTexStart = 20000
				groundTexEnd = 60000
				multiFactor = 0.5
				mainTex = BUILTIN/SandyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexHeightMap
				{
					map = BUILTIN/eve_height_new
					offset = -1500
					deformity = 5000
					scaleDeformityByRadius = False
					order = 10
					enabled = True
					name = _HeightNoise
				}
				VertexSimplexHeight
				{
					deformity = 500
					frequency = 24
					octaves = 8
					persistence = 0.550000011920929
					seed = 12435453
					order = 11
					enabled = True
					name = _HeightNoise
				}
				VertexHeightNoiseVertHeightCurve2
				{
					deformity = 5000
					ridgedAddFrequency = 24
					ridgedAddLacunarity = 2
					ridgedAddOctaves = 2
					ridgedAddSeed = 1968186156
					ridgedMode = Low
					ridgedSubFrequency = 24
					ridgedSubLacunarity = 2
					ridgedSubOctaves = 2
					ridgedSubSeed = 484009382
					simplexFrequency = 24
					simplexHeightEnd = 5000
					simplexHeightStart = 250
					simplexOctaves = 4
					simplexPersistence = 0.600000023841858
					simplexSeed = 661000047
					order = 12
					enabled = True
					name = _HeightNoise
					simplexCurve
					{
						key = 0 0 0 0
						key = 1 1 2 2
					}
				}
				LandControl
				{
					altitudeBlend = 0.05
					altitudeFrequency = 12
					altitudeOctaves = 2
					altitudePersistance = 0.6
					altitudeSeed = 212121
					createColors = True
					createScatter = True
					heightMap = BUILTIN/eve_height_new
					latitudeBlend = 0.02
					latitudeFrequency = 4
					latitudeOctaves = 4
					latitudePersistance = 0.6
					latitudeSeed = 47373
					longitudeBlend = 0.05
					longitudeFrequency = 4
					longitudeOctaves = 4
					longitudePersistance = 0.6
					longitudeSeed = 768453
					useHeightMap = False
					vHeightMax = 3500
					order = 9999991
					enabled = True
					name = _LandClass
					Scatters
					{
						Value
						{
							name = boulder
							materialType = KSPBumpedSpecular
							material = BUILTIN/eve_scatter_rock
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 0.25
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 4
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.1
							recieveShadows = True
							seed = 66564
							verticalOffset = 0.2
							instancing = True
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								mainTex = BUILTIN/eveScatterDiffuse
								mainTexScale = 1,1
								mainTexOffset = 0,0
								bumpMap = BUILTIN/eveScatterNRM
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
								color = 0.639705896,0.639705896,0.639705896,0.397000015
								specColor = 0.5,0.5,0.5,1
								shininess = 0.4
								opacity = 0
								rimFalloff = 0.1
								rimColor = 0,0,0,0
								temperatureColor = 0,0,0,0
								burnColor = 1,1,1,1
								underwaterFogFactor = 0
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.176431224,0.123134315,0.24626863,0
							coverageBlend = 0.5
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.2
							coverageSeed = 5645
							name = Badlands
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.8
							noiseColor = 0.218646362,0.186932489,0.268656731,0
							noiseFrequency = 2
							noiseOctaves = 8
							noisePersistance = 0.7
							noiseSeed = 23534
							delete = False
							altitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = 1
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 0.25
									scatterName = boulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.274666727,0.221688747,0.358208954,0
							coverageBlend = 0.5
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.2
							coverageSeed = 67845
							name = Sea
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.8
							noiseColor = 0.144924998,0.127204895,0.186567187,0
							noiseFrequency = 2
							noiseOctaves = 8
							noisePersistance = 0.7
							noiseSeed = 34333
							delete = False
							altitudeRange
							{
								endEnd = 0.0500000007450581
								endStart = -0.100000001490116
								startEnd = -5
								startStart = -5
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = -2
									scatterName = boulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.0912883952,0.082924515,0.104477584,0
							coverageBlend = 0.5
							coverageFrequency = 8
							coverageOctaves = 3
							coveragePersistance = 0.2
							coverageSeed = 89
							name = Mountains
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0.8
							noiseColor = 0.248020425,0.203710482,0.276119411,0
							noiseFrequency = 2
							noiseOctaves = 8
							noisePersistance = 0.7
							noiseSeed = 1200
							delete = False
							altitudeRange
							{
								endEnd = 10
								endStart = 5
								startEnd = 0.800000011920929
								startStart = 0.300000011920929
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 1
									scatterName = boulder
									delete = False
								}
							}
						}
					}
				}
				VertexSimplexNoiseColor
				{
					blend = 0.1
					colorStart = 0,0,0,0
					colorEnd = 1,1,1,0
					frequency = 12
					octaves = 4
					persistence = 0.600000023841858
					seed = 454213321
					order = 9999992
					enabled = True
					name = _LandClass
				}
				VertexColorMapBlend
				{
					map = BUILTIN/eve_coloraddition
					blend = 0.25
					order = 9999993
					enabled = True
					name = _LandClass
				}
				AltitudeAlpha
				{
					atmosphereDepth = 10000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				AerialPerspectiveMaterial
				{
					atmosphereDepth = 150000
					DEBUG_SetEveryFrame = True
					globalDensity = -1E-05
					heightFalloff = 6.75
					oceanDepth = 0
					order = 100
					enabled = True
					name = _Material_AerialPerspective
				}
				QuadEnhanceCoast
				{
					coastLessThan = 0
					oceanFactor = 1
					order = 9999
					enabled = True
					name = _CoastlineLOD
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
			}
		}
		Ocean
		{
			ocean = True
			oceanColor = 0.266666681,0.243137255,0.305882365,1
			oceanHeight = 0
			density = 1.5
			minLevel = 1
			maxLevel = 7
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			Material
			{
				color = 0.678159177,0.580055177,0.745283008,1
				colorFromSpace = 0.443137258,0.411764711,0.450980395,1
				specColor = 0.396078438,0.396078438,0.396078438,1
				shininess = 0.0831425
				gloss = 0.2
				tiling = 1000
				waterTex = BUILTIN/sea-water9
				waterTexScale = 1,1
				waterTexOffset = 0,0
				waterTex1 = BUILTIN/sea-water10
				waterTex1Scale = 1,1
				waterTex1Offset = 0,0
				bTiling = 800
				bumpMap = BUILTIN/Eve2_01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				displacement = 0.01
				texDisplacement = 0.31
				dispFreq = 0.1
				mix = 0.554
				oceanOpacity = 1
				falloffPower = 5
				falloffExp = 0
				fogColor = 0.917910457,0.917910457,1,1
				heightFallOff = 0.2
				globalDensity = -8E-06
				atmosphereDepth = 150000
				fogColorRamp = BUILTIN/purple_atmogradiant
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				fadeStart = 20000
				fadeEnd = 60000
				planetOpacity = 1
				normalXYFudge = 1.4
				normalZFudge = 1.18
			}
			FallbackMaterial
			{
				color = 0.525490224,0.46274513,0.568627477,1
				colorFromSpace = 0.265444487,0.244319439,0.305970132,1
				specColor = 1,1,1,1
				shininess = 1
				gloss = 1
				tiling = 2000
				waterTex = BUILTIN/quiet
				waterTexScale = 1,1
				waterTexOffset = 0,0
				waterTex1 = BUILTIN/quiet
				waterTex1Scale = 1,1
				waterTex1Offset = 0,0
				fadeStart = 20000
				fadeEnd = 60000
				planetOpacity = 1
			}
			Fog
			{
				afgAltMult = 0.05
				afgBase = 0.6
				afgLerp = False
				afgMin = 0.05
				fogColorEnd = 0,0.0850000009,0.122500002,1
				fogColorStart = 0.407954782,0.324893236,0.46226418,1
				fogDensityAltScalar = -0.0008
				fogDensityEnd = 0.025
				fogDensityExponent = 1
				fogDensityPQSMult = 0.02
				fogDensityStart = 0.005
				skyColorMult = 1.1
				skyColorOpacityAltMult = 12
				skyColorOpacityBase = 0.33
				sunAltMult = 0.01
				sunBase = 0.5
				sunMin = 0.05
				useFog = True
			}
			Mods
			{
				AerialPerspectiveMaterial
				{
					atmosphereDepth = 5000
					DEBUG_SetEveryFrame = False
					globalDensity = -7.5E-06
					heightFalloff = 0.2
					oceanDepth = 0
					order = 100
					enabled = True
					name = _Material_AerialPerspective
				}
				RemoveQuadMap
				{
					map = BUILTIN/eve_height_new
					deformity = 0
					maxHeight = 0.7
					minHeight = 0
					order = 1
					enabled = True
					name = QuadRemoveMap
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Gilly is a lumpy rock wandering around the orbit of Eve. It’s by far the smallest natural satellite that the Kerbal Astronomical Society has discovered.Due to the large amount of squinting and eye strain associated with its discovery, wearing glasses has now become synonymous with being an accomplished Astronomer.
			radius = 13000
			geeASL = 0.00500170791285985
			mass = 1.24203632781093E+17
			gravParameter = 8289449.81471635
			rotates = True
			rotationPeriod = 28255
			tidallyLocked = False
			initialRotation = 5
			inverseRotThresholdAltitude = 100000
			albedo = 0.15
			emissivity = 0.85
			coreTemperatureOffset = 20
			timewarpAltitudeLimits = 0 8000 8000 8000 20000 40000 80000 100000
			sphereOfInfluence = 126123.271704568
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/gilly_biomes
			useTheInName = False
			displayName = Gilly^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 9 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 8 // Science multiplier for in space low science.
				inSpaceHighDataValue = 6 // Science multiplier for in space high science.
				recoveryValue = 6
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 6000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.796078444,0.631372571,0.36470589,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.647058845,0.505882382,0.278431386,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.917647064,0.792156875,0.588235319,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 7000
			fadeEnd = 10000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 0.911764681,0.911764681,0.911764681,1
				specColor = 0.0588235259,0.0588235259,0.0588235259,1
				shininess = 0.98
				texture = BUILTIN/evemoon100
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/evemoon101
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 8
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 10000
			fadeEnd = 40000
			deactivateAltitude = 180000
			mapMaxHeight = 9000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 10
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 2
				steepPower = 3
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/gillySteep_diffuse
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/gillySteep_nrm
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 15
				steepTiling = 63
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 100000
				midTex = BUILTIN/gillyMedTerrain_diffuse
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 100000
				midBumpMap = BUILTIN/gillyMedTerrain_nrm
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 100000
				highTex = BUILTIN/gillyHighTerrain
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 50000
				lowStart = 0
				lowEnd = 0
				highStart = 0.4
				highEnd = 0.7
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 1
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1
				tintColor = 1,1,1,0
				texTiling = 80
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 20000
				multiFactor = 0.5
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexSimplexHeightAbsolute
				{
					deformity = 8000
					frequency = 0.5
					octaves = 3
					persistence = 0.5
					seed = 12
					order = 10
					enabled = True
					name = _Height
				}
				VertexHeightNoise
				{
					deformity = 150
					frequency = 4
					octaves = 6
					persistence = 0.5
					seed = 111111112
					noiseType = RiggedMultifractal
					mode = Low
					lacunarity = 2.5
					order = 19
					enabled = True
					name = _Height
				}
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				VertexColorMap
				{
					map = BUILTIN/gilly_coloraddition
					order = 99
					enabled = True
					name = _Color
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					order = 999999
					enabled = True
					name = Scatter
					Scatters
					{
						Value
						{
							name = boulder
							materialType = BumpedDiffuse
							material = BUILTIN/gilly_scatter
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 3
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.5
							recieveShadows = True
							seed = 231123
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 1,1,1,1
								mainTex = BUILTIN/gillyScatter
								mainTexScale = 1,1
								mainTexOffset = 0,0
								bumpMap = BUILTIN/ikeScatterNRM
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Base
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 1
									scatterName = boulder
									delete = False
								}
							}
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Ike is a relatively large, grey object occasionally seen orbiting Duna. Scientists have postulated that Ike is seemingly perfectly positioned to sneakily interfere with any object that presumes to come orbiting near its parent.
			radius = 130000
			geeASL = 0.112038263210561
			mass = 2.78216152235874E+20
			gravParameter = 18568368573.144
			rotates = True
			rotationPeriod = 65517.8621348081
			tidallyLocked = True
			initialRotation = 0
			inverseRotThresholdAltitude = 100000
			albedo = 0.14
			emissivity = 0.86
			coreTemperatureOffset = 2
			timewarpAltitudeLimits = 0 5000 5000 10000 25000 50000 100000 200000
			sphereOfInfluence = 1049598.93931162
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/ike_biomes
			useTheInName = False
			displayName = Ike^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 8 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 7 // Science multiplier for in space low science.
				inSpaceHighDataValue = 5 // Science multiplier for in space high science.
				recoveryValue = 5
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 50000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Polar Lowlands // The name of this biome.
					displayName = Polar Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.474509805,0.466666669,0.4627451,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.576470613,0.576470613,0.576470613,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Eastern Mountain Ridge // The name of this biome.
					displayName = Eastern Mountain Ridge // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,1,1,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Western Mountain Ridge // The name of this biome.
					displayName = Western Mountain Ridge // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.925490201,0.925490201,0.925490201,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.407843143,0.407843143,0.407843143,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = South Eastern Mountain Range // The name of this biome.
					displayName = South Eastern Mountain Range // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.854901969,0.854901969,0.854901969,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = South Pole // The name of this biome.
					displayName = South Pole // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.517647088,0.517647088,0.517647088,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Central Mountain Range // The name of this biome.
					displayName = Central Mountain Range // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.800000012,0.800000012,0.800000012,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 20000
			fadeEnd = 25000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0,0,0,1
				shininess = 0.078125
				texture = BUILTIN/desertplanetmoon00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/desertplanetmoon01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 8
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 25000
			fadeEnd = 50000
			deactivateAltitude = 180000
			mapMaxHeight = 20000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 3
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 2
				steepPower = 2
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/ikeSteep_diffuse
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/ikeSteep_nrm
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 50
				steepTiling = 50
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 100000
				midTex = BUILTIN/ikeGround_diffuse
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 150000
				midBumpMap = BUILTIN/ikeGround_nrm
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 150000
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 100000
				lowStart = 0
				lowEnd = 0
				highStart = 2
				highEnd = 2
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.2
				tintColor = 1,1,1,0
				texTiling = 1024
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 20000
				multiFactor = 0.5
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexSimplexHeightAbsolute
				{
					deformity = 12000
					frequency = 1
					octaves = 2
					persistence = 0.5
					seed = 2297
					order = 10
					enabled = True
					name = _Height
				}
				VertexHeightNoise
				{
					deformity = 1600
					frequency = 3
					octaves = 8
					persistence = 0.5
					seed = 8893284
					noiseType = RiggedMultifractal
					mode = Low
					lacunarity = 2.5
					order = 19
					enabled = True
					name = _Height
				}
				VertexSimplexHeight
				{
					deformity = 100
					frequency = 12
					octaves = 8
					persistence = 0.5
					seed = 56899452
					order = 20
					enabled = True
					name = _Height
				}
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				VertexSimplexNoiseColor
				{
					blend = 0.05
					colorStart = 0,0,0,0
					colorEnd = 0.791044772,0.791044772,0.791044772,0
					frequency = 2
					octaves = 2
					persistence = 0.5
					seed = 456364
					order = 100
					enabled = True
					name = _Color
				}
				VertexColorMap
				{
					map = BUILTIN/desertplanetmoon_coloroverlay
					order = 99
					enabled = True
					name = _Color
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					order = 999999
					enabled = True
					name = Scatter
					Scatters
					{
						Value
						{
							name = boulder
							materialType = KSPBumped
							material = BUILTIN/ikeScatter
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 2
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.1
							recieveShadows = True
							seed = 231123
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								mainTex = BUILTIN/ikeScatterDiffuse
								mainTexScale = 1,1
								mainTexOffset = 0,0
								bumpMap = BUILTIN/ikeScatterNRM
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
								color = 1,1,1,1
								opacity = 0
								rimFalloff = 0.1
								rimColor = 0,0,0,0
								temperatureColor = 0,0,0,0
								burnColor = 1,1,1,1
								underwaterFogFactor = 0
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Base
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 0.200000002980232
									scatterName = boulder
									delete = False
								}
							}
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = 113447.102,-25695.3398,58574.4688
					repositionRadiusOffset = 3.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Anniversary5
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[Dres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Jool is particularly known for being a rather large, predominantly green planet. Kerbalkind has longed to visit it since it was first spotted in the sky. Philosophers reason that the swirling green planet must be a really nice place to visit, on account of its wholesome coloration.If you look at Jool through a telescope, it is fuzzy.
			radius = 6000000
			geeASL = 0.800273295870079
			mass = 4.23321273059351E+24
			gravParameter = 282528004209995
			rotates = True
			rotationPeriod = 36000
			tidallyLocked = False
			initialRotation = 0
			inverseRotThresholdAltitude = 220000
			albedo = 0.52
			emissivity = 0.48
			coreTemperatureOffset = 80
			timewarpAltitudeLimits = 0 0 15000 60000 150000 300000 600000 1200000
			sphereOfInfluence = 2455985185.42347
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			useTheInName = False
			displayName = Jool^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 30 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 12 // Science multiplier for flying low science.
				flyingHighDataValue = 9 // Science multiplier for flying high science.
				inSpaceLowDataValue = 7 // Science multiplier for in space low science.
				inSpaceHighDataValue = 6 // Science multiplier for in space high science.
				recoveryValue = 6
				flyingAltitudeThreshold = 120000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 4000000 // Altitude when "in space low" transitions from/to "in space high"
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Atmospheric
			fadeStart = 29000
			fadeEnd = 30000
			sphericalModel = False
			deferMesh = False
			invisible = False
		}
		Atmosphere
		{
			enabled = True // Whether the body has an atmosphere
			oxygen = False // Whether the atmosphere contains oxygen
			staticDensityASL = 6.70262205528434 // Atmospheric density at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			adiabaticIndex = 1.43 // A thermodynamic property of the gas, also known as heat capacity ratio
			atmosphereDepth = 200000 // The height of the atmosphere
			gasMassLapseRate = 2.07657256052129
			atmosphereMolarMass = 0.0022 // The mass in kilograms of one mole of gas
			pressureCurveIsNormalized = False // Whether the pressure curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			shockTemperatureMultiplier = 0.5 // Multiplies the External/Shock Temperature by this value. This is relevant for aerodynamic heating
			staticPressureASL = 1519.875 // The static pressure at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			temperatureCurveIsNormalized = False // Whether the temperature curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			temperatureLapseRate = 0.001
			temperatureSeaLevel = 200 // The static temperature at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			ambientColor = 0.0754820928,0.208955199,0.0686121732,1 // All objects inside of the atmosphere will slightly shine in this color
			lightColor = 0.674509823,0.596078455,0.850980401,0 // Same as waveLength in AtmosphereFromGround
			addAFG = True
			pressureCurve // Assigns a pressure value to a height value inside of the atmosphere
			{
				key = 0 5066.25 0 -0.6723968
				key = 10000 1519.875 -0.1346587 -0.1346587
				key = 29000 628.0436 -0.01449255 -0.01449255
				key = 123450 22.26 -0.001562163 -0.001562163
				key = 150000 2 -0.0001361465 -0.0001361465
				key = 170000 0.1 -1.001277E-05 -1.001277E-05
				key = 200000 0 0 0
			}
			temperatureCurve // Assigns a base temperature value to a height value inside of the atmosphere
			{
				key = 0 200 0 -0.001182922
				key = 29000 165 -0.001207278 -0.001207278
				key = 123450 120 0 0
				key = 168000 160 0.0009967944 0.0009967944
				key = 187500 175 0 0
				key = 194000 167 0 0
				key = 200000 350 0.08717471 0
			}
			temperatureSunMultCurve // How the temperature modifiers vary by altitude, in the form of a multiplier
			{
				key = 0 0 0 0
				key = 29000 0.5 0 0
				key = 123450 0.8 0 0
				key = 200000 1.5 0 0
			}
			temperatureLatitudeBiasCurve // Latitudinal temperature modifier
			{
				key = 0 30 0 -0.0957164
				key = 50 10 -0.950278 -0.950278
				key = 70 -20 -1.955704 -1.955704
				key = 90 -40 -0.02418368 0
			}
			temperatureLatitudeSunMultCurve // Day - night temperature modifier by latitude
			{
				key = 0 9 0 0.02746098
				key = 40 12 0.2295445 0.2295445
				key = 65 18 0 0
				key = 90 5 0 0
			}
			temperatureAxialSunBiasCurve // Seasonal temperature modifier by true anomaly
			{
				key = 0 0 0 0
			}
			temperatureAxialSunMultCurve // How the seasonal temperature modifier varies by latitude
			{
				key = 0 0 0 0
			}
			temperatureEccentricityBiasCurve // Orbital eccentricity temperature modifier
			{
				key = 0 0 0 0
			}
			AtmosphereFromGround // The atmosphere effect that is seen on the horizon
			{
				DEBUG_alwaysUpdateAll = False // Whether all parameters should get recalculated and reapplied every frame.
				doScale = True // Whether the atmosphere mesh should be scaled automatically.
				innerRadius = 5996250 // The lower bound of the atmosphere effect.
				invWaveLength = 4.83110952,7.92111492,1.90687299,0.5
				outerRadius = 6150000 // The upper bound of the atmosphere effect.
				samples = 4
				transformScale = 1.02499998,1.02499998,1.02499998 // The scale of the atmosphere mesh in all three directions. Automatically set if doScale is enabled.
				waveLength = 0.674509823,0.596078455,0.850980401,0
				outerRadiusMult = 1.025 // A multiplier that automatically sets outerRadius based on the planets radius.
				innerRadiusMult = 0.975 // A multiplier that automatically sets innerRadius based on the planets radius.
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = When Laythe was first discovered, it was not entered in the records because the scientist in charge thought he was looking at Kerbin.Luckily this error was corrected when a plucky intern informed him that “telescopes don’t work that way”.The intern was shortly afterwards “promoted” and moved to the experimental rocket testing program.
			radius = 500000
			geeASL = 0.800273295870079
			mass = 2.93973106291216E+22
			gravParameter = 1962000029236.08
			rotates = True
			rotationPeriod = 52980.8790593796
			tidallyLocked = True
			initialRotation = 90
			inverseRotThresholdAltitude = 100000
			albedo = 0.3
			emissivity = 0.7
			coreTemperatureOffset = 80
			timewarpAltitudeLimits = 0 30000 30000 60000 120000 240000 480000 600000
			sphereOfInfluence = 3723645.81113302
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/laythe_biomes
			useTheInName = False
			displayName = Laythe^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 14 // Science multiplier for landed science.
				splashedDataValue = 12 // Science multiplier for splashed down science.
				flyingLowDataValue = 11 // Science multiplier for flying low science.
				flyingHighDataValue = 10 // Science multiplier for flying high science.
				inSpaceLowDataValue = 9 // Science multiplier for in space low science.
				inSpaceHighDataValue = 8 // Science multiplier for in space high science.
				recoveryValue = 8
				flyingAltitudeThreshold = 10000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 200000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.725490212,0.835294127,0.890196085,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Shores // The name of this biome.
					displayName = Shores // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,0.925490201,0.647058845,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Dunes // The name of this biome.
					displayName = Dunes // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.839215696,0.745098054,0.384313732,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Crescent Bay // The name of this biome.
					displayName = Crescent Bay // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.368627459,0.43921569,0.800000012,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = The Sagen Sea // The name of this biome.
					displayName = The Sagen Sea // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.149019614,0.384313732,0.686274529,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Crater Island // The name of this biome.
					displayName = Crater Island // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.678431392,0.580392182,0.196078435,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Shallows // The name of this biome.
					displayName = Shallows // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.443137258,0.619607866,0.843137264,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Crater Bay // The name of this biome.
					displayName = Crater Bay // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.282352954,0.490196079,0.760784328,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = DeGrasse Sea // The name of this biome.
					displayName = Degrasse Sea // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.0470588244,0.266666681,0.549019635,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Peaks // The name of this biome.
					displayName = Peaks // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,0.964705884,0.835294127,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Atmospheric
			fadeStart = 1000
			fadeEnd = 40000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0.305970132,0.305970132,0.305970132,1
				shininess = 0.1661175
				texture = BUILTIN/newoceanmoon00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/newoceanmoon01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				rimPower = 5
				rimBlend = 1
				rimColorRamp = BUILTIN/AerialRampKerbin2
				rimColorRampScale = 1,1
				rimColorRampOffset = 0,0
				localLightDirection = -0.617191017,0.0226955116,-0.78648591,0
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		Atmosphere
		{
			enabled = True // Whether the body has an atmosphere
			oxygen = True // Whether the atmosphere contains oxygen
			staticDensityASL = 0.764571404126208 // Atmospheric density at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			adiabaticIndex = 1.39999997615814 // A thermodynamic property of the gas, also known as heat capacity ratio
			atmosphereDepth = 50000 // The height of the atmosphere
			gasMassLapseRate = 4.84741125702493
			atmosphereMolarMass = 0.0289644002914429 // The mass in kilograms of one mole of gas
			pressureCurveIsNormalized = False // Whether the pressure curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			shockTemperatureMultiplier = 1 // Multiplies the External/Shock Temperature by this value. This is relevant for aerodynamic heating
			staticPressureASL = 60.795 // The static pressure at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			temperatureCurveIsNormalized = False // Whether the temperature curve should use absolute (0 - atmosphereDepth) or relative (0 - 1) values
			temperatureLapseRate = 0.00564
			temperatureSeaLevel = 282 // The static temperature at sea level. Used to calculate the parameters of the atmosphere if no curves are used
			ambientColor = 0.187128037,0.239393175,0.305882365,1 // All objects inside of the atmosphere will slightly shine in this color
			lightColor = 0.843283594,0.668219268,0.49830395,0 // Same as waveLength in AtmosphereFromGround
			addAFG = True
			pressureCurve // Assigns a pressure value to a height value inside of the atmosphere
			{
				key = 0 60.795 0 -0.005216384
				key = 5250 33.40898 -0.004252711 -0.004252711
				key = 10000 17.78605 -0.002407767 -0.002407767
				key = 17000 7.100577 -0.001092064 -0.001092064
				key = 22000 3.812421 -0.0004677011 -0.0004677011
				key = 31000 1.312482 -0.0001961767 -0.0001961767
				key = 38000 0.5104055 -7.855808E-05 -7.855808E-05
				key = 50000 0 0 0
			}
			temperatureCurve // Assigns a base temperature value to a height value inside of the atmosphere
			{
				key = 0 277 0 -0.009285714
				key = 5250 206 -0.009253677 0
				key = 10000 206 0 0.001419616
				key = 17000 217.8 0.001414257 0.003959919
				key = 22000 235.5 0.0039412 -0.0002581542
				key = 31000 203 -0.003911343 -0.0007623209
				key = 38000 199 0 0.001478429
				key = 50000 214 0 0
			}
			temperatureSunMultCurve // How the temperature modifiers vary by altitude, in the form of a multiplier
			{
				key = 0 1 0 0
				key = 5250 0.1 -6.848309E-05 -6.848309E-05
				key = 10000 0 0 0
				key = 17000 0 0 0
				key = 27000 0.1763835 4.519309E-05 4.519309E-05
				key = 38000 1 4.497274E-05 4.497274E-05
				key = 50000 1.2 0 0
			}
			temperatureLatitudeBiasCurve // Latitudinal temperature modifier
			{
				key = 0 5 0 -0.04354425
				key = 50 1 -0.2132 -0.2132
				key = 70 -10 -1.128971 -1.128971
				key = 90 -30 -0.02418368 0
			}
			temperatureLatitudeSunMultCurve // Day - night temperature modifier by latitude
			{
				key = 0 6 0 0.02746098
				key = 40 9 0.2094055 0.2094055
				key = 65 11 0 0
				key = 90 2 0 0
			}
			temperatureAxialSunBiasCurve // Seasonal temperature modifier by true anomaly
			{
				key = 0 0 0 0
			}
			temperatureAxialSunMultCurve // How the seasonal temperature modifier varies by latitude
			{
				key = 0 0 0 0
			}
			temperatureEccentricityBiasCurve // Orbital eccentricity temperature modifier
			{
				key = 0 0 0 0
			}
			AtmosphereFromGround // The atmosphere effect that is seen on the horizon
			{
				DEBUG_alwaysUpdateAll = False // Whether all parameters should get recalculated and reapplied every frame.
				doScale = True // Whether the atmosphere mesh should be scaled automatically.
				innerRadius = 499687.5 // The lower bound of the atmosphere effect.
				invWaveLength = 1.97744954,5.01561308,16.2189484,0.5
				outerRadius = 512500 // The upper bound of the atmosphere effect.
				samples = 4
				transformScale = 1.02499998,1.02499998,1.02499998 // The scale of the atmosphere mesh in all three directions. Automatically set if doScale is enabled.
				waveLength = 0.843283594,0.668219268,0.49830395,0
				outerRadiusMult = 1.025 // A multiplier that automatically sets outerRadius based on the planets radius.
				innerRadiusMult = 0.975 // A multiplier that automatically sets innerRadius based on the planets radius.
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 11
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 40000
			fadeEnd = 110000
			deactivateAltitude = 150000
			mapMaxHeight = 4096
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Multiply
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.9
				dynamicFriction = 0.9
			}
			Material
			{
				factor = 9
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1
				steepPower = 3
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/laythSteep_diff
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/laytheSteep_nrm
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 100
				steepTiling = 50
				lowTex = BUILTIN/laytheLow_diff
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 20000
				midTex = BUILTIN/laytheSand_diffuse
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 40000
				midBumpMap = BUILTIN/laytheSand_nrm
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 40000
				highTex = BUILTIN/laytheSnow_diff
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 1000
				lowStart = 0
				lowEnd = 0.1
				highStart = 0.6
				highEnd = 1
				globalDensity = 0
				fogColorRamp = BUILTIN/blue_atmogradient
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0.002323827
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.55
				tintColor = 1,1,1,0
				texTiling = 1000
				texPower = 0.5
				multiPower = 0.3
				groundTexStart = 20000
				groundTexEnd = 60000
				multiFactor = 0.5
				mainTex = BUILTIN/SandyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				LandControl
				{
					altitudeBlend = 0.01
					altitudeFrequency = 2
					altitudeOctaves = 2
					altitudePersistance = 0.5
					altitudeSeed = 53453
					createColors = True
					createScatter = True
					heightMap = BUILTIN/oceanmoon_height
					latitudeBlend = 0.05
					latitudeFrequency = 12
					latitudeOctaves = 6
					latitudePersistance = 0.5
					latitudeSeed = 53456345
					longitudeBlend = 0.05
					longitudeFrequency = 12
					longitudeOctaves = 4
					longitudePersistance = 0.5
					longitudeSeed = 98888
					useHeightMap = False
					vHeightMax = 6000
					order = 100
					enabled = True
					name = _LandClass
					Scatters
					{
						Value
						{
							name = BrownRock
							materialType = DiffuseWrapped
							material = BUILTIN/scatter_rock_laythe
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 1.5
							maxScatter = 30
							maxSpeed = 1000
							minScale = 0.25
							recieveShadows = True
							seed = 345234534
							verticalOffset = 0
							instancing = True
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								mainTex = BUILTIN/brown_cliff
								mainTexScale = 1,1
								mainTexOffset = 0,0
								color = 1,1,1,0.421999991
								diff = 0.2
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.25373137,0.240503222,0.229777679,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 0.5
							coverageSeed = 1
							name = BaseLand
							latDelta = 1
							latitudeDouble = True
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 1
							noiseColor = 0.186567187,0.183743656,0.167649537,0
							noiseFrequency = 32
							noiseOctaves = 8
							noisePersistance = 0.5
							noiseSeed = 9234
							delete = False
							altitudeRange
							{
								endEnd = 3
								endStart = 3
								startEnd = 0.025000000372529
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = 0.5
									scatterName = BrownRock
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.237999991,0.214967743,0.168903217,0
							coverageBlend = 0.2
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 0.5
							coverageSeed = 75674
							name = Beach
							latDelta = 1
							latitudeDouble = True
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 1
							noiseColor = 0.121568628,0.109803922,0.0862745121,0
							noiseFrequency = 24
							noiseOctaves = 8
							noisePersistance = 0.5
							noiseSeed = 75635
							delete = False
							altitudeRange
							{
								endEnd = 0.0700000002980232
								endStart = 0
								startEnd = 0
								startStart = -0.0500000007450581
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = -1
									scatterName = BrownRock
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.0840204582,0.105440333,0.149253726,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 0.5
							coverageSeed = 75674
							name = SeaFloor
							latDelta = 1
							latitudeDouble = True
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 1
							noiseColor = 0.0661204308,0.0769978315,0.104477584,0
							noiseFrequency = 24
							noiseOctaves = 8
							noisePersistance = 0.5
							noiseSeed = 75635
							delete = False
							altitudeRange
							{
								endEnd = -0.00999999977648258
								endStart = -0.0299999993294477
								startEnd = -10
								startStart = -10
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = -9
								startStart = -9
							}
							latitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = -1
									scatterName = BrownRock
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.231343269,0.17757003,0.12537834,0
							coverageBlend = 1
							coverageFrequency = 24
							coverageOctaves = 8
							coveragePersistance = 0.5
							coverageSeed = 234124
							name = Mud
							latDelta = 0
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 1
							noiseColor = 0.313432813,0.22687158,0.106304161,0
							noiseFrequency = 24
							noiseOctaves = 8
							noisePersistance = 0.5
							noiseSeed = 5646345
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 0.300000011920929
								startEnd = 0.0399999991059303
								startStart = 0.0299999993294477
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 0.899999998509884
								startEnd = 0.550000011920929
								startStart = 0.5
							}
							latitudeRange
							{
								endEnd = 0.5
								endStart = 0.449999988079071
								startEnd = 0.100000001490116
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 5
								endStart = 5
								startEnd = -5
								startStart = -5
							}
							Scatters
							{
								Value
								{
									density = -1
									scatterName = BrownRock
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0.896226406,0.896226406,0.896226406,0
							coverageBlend = 1
							coverageFrequency = 12
							coverageOctaves = 6
							coveragePersistance = 0.5
							coverageSeed = 234124
							name = Snow
							latDelta = 0.0325871132749287
							latitudeDouble = True
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 1
							noiseColor = 0.877358496,0.877358496,0.877358496,0
							noiseFrequency = 24
							noiseOctaves = 8
							noisePersistance = 0.5
							noiseSeed = 5646345
							delete = False
							altitudeRange
							{
								endEnd = 3
								endStart = 3
								startEnd = 0.600000023841858
								startStart = 0.400000005960464
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = 0.699999988079071
								startStart = 0.5
							}
							latitudeRange
							{
								endEnd = 0.5
								endStart = 0.300000011920929
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = -0.25
									scatterName = BrownRock
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 100
							alterRealHeight = 10
							color = 0.731343269,0.731343269,0.731343269,0
							coverageBlend = 1
							coverageFrequency = 12
							coverageOctaves = 6
							coveragePersistance = 0.5
							coverageSeed = 234124
							name = IceCaps
							latDelta = 0
							latitudeDouble = True
							lonDelta = 1
							minimumRealHeight = 20
							noiseBlend = 0.25
							noiseColor = 0.552238822,0.519182861,0.480795324,0
							noiseFrequency = 24
							noiseOctaves = 8
							noisePersistance = 0.5
							noiseSeed = 5646345
							delete = False
							altitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -0.5
								startStart = -0.5
							}
							latitudeDoubleRange
							{
								endEnd = 11
								endStart = 11
								startEnd = 0.96000000089407
								startStart = 0.958500001579523
							}
							latitudeRange
							{
								endEnd = 0.0414999984204769
								endStart = 0.0399999991059303
								startEnd = -10
								startStart = -10
							}
							longitudeRange
							{
								endEnd = 10
								endStart = 10
								startEnd = -10
								startStart = -10
							}
							Scatters
							{
								Value
								{
									density = -1
									scatterName = BrownRock
									delete = False
								}
							}
						}
					}
				}
				AltitudeAlpha
				{
					atmosphereDepth = 4000
					invert = False
					order = 999999999
					enabled = False
					name = _Material_ModProjection
				}
				AerialPerspectiveMaterial
				{
					atmosphereDepth = 150000
					DEBUG_SetEveryFrame = True
					globalDensity = -1E-05
					heightFalloff = 6.75
					oceanDepth = 0
					order = 101
					enabled = True
					name = _Material_AerialPerspective
				}
				VertexHeightNoise
				{
					deformity = 800
					frequency = 18
					octaves = 4
					persistence = 0.7
					seed = 1238999999
					noiseType = RiggedMultifractal
					mode = Low
					lacunarity = 3
					order = 21
					enabled = True
					name = _HeightNoise
				}
				VertexSimplexHeightMap
				{
					deformity = 900
					frequency = 12
					heightEnd = 1
					heightStart = 0.6
					map = BUILTIN/oceanmoon_height
					octaves = 8
					persistence = 0.5
					seed = 55345
					order = 20
					enabled = True
					name = _HeightNoise
				}
				QuadEnhanceCoast
				{
					coastLessThan = 0
					oceanFactor = 1
					order = 9999
					enabled = True
					name = _CoastlineLOD
				}
				VertexHeightNoiseVertHeight
				{
					heightStart = 0.2
					heightEnd = 1
					deformity = 200
					frequency = 400
					octaves = 2
					persistance = 0.7
					seed = 3475645
					mode = Low
					noiseType = Billow
					lacunarity = 1.5
					order = 30
					enabled = True
					name = _FineDetail
				}
				VertexHeightMap
				{
					map = BUILTIN/oceanmoon_height
					offset = -2000
					deformity = 8000
					scaleDeformityByRadius = False
					order = 99
					enabled = True
					name = _Height
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = -476923.594,645.771729,-150144.703
					repositionRadiusOffset = 1.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Anniversary7
				}
			}
		}
		Ocean
		{
			ocean = True
			oceanColor = 0.116715364,0.12626785,0.156716406,1
			oceanHeight = 0
			density = 1
			minLevel = 1
			maxLevel = 6
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			Material
			{
				color = 0.413805217,0.387094229,0.514925361,1
				colorFromSpace = 0.116878122,0.126456618,0.156862751,1
				specColor = 1,1,1,1
				shininess = 1
				gloss = 0.2
				tiling = 1000
				waterTex = BUILTIN/sea-water1
				waterTexScale = 1,1
				waterTexOffset = 0,0
				waterTex1 = BUILTIN/sea-water2
				waterTex1Scale = 1,1
				waterTex1Offset = 0,0
				bTiling = 800
				bumpMap = BUILTIN/quiet
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				displacement = 0.05
				texDisplacement = 0.31
				dispFreq = 0.15
				mix = 0.5566635
				oceanOpacity = 0.3
				falloffPower = 3
				falloffExp = 0.05
				fogColor = 0.321443439,0.611232221,0.947761178,1
				heightFallOff = 0.2
				globalDensity = -8E-06
				atmosphereDepth = 50000
				fogColorRamp = BUILTIN/blue_atmogradient
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				fadeStart = 20000
				fadeEnd = 60000
				planetOpacity = 1
				normalXYFudge = 1.4
				normalZFudge = 1.18
			}
			FallbackMaterial
			{
				color = 0.336603671,0.378080368,0.447761178,1
				colorFromSpace = 0.116878122,0.126456618,0.156862751,1
				specColor = 0.8493402,0.8493402,0.8493402,1
				shininess = 1
				gloss = 0.3336538
				tiling = 1000
				waterTex = BUILTIN/sea-water1
				waterTexScale = 1,1
				waterTexOffset = 0,0
				waterTex1 = BUILTIN/sea-water2
				waterTex1Scale = 1,1
				waterTex1Offset = 0,0
				fadeStart = 20000
				fadeEnd = 60000
				planetOpacity = 1
			}
			Fog
			{
				afgAltMult = 0.05
				afgBase = 0.6
				afgLerp = False
				afgMin = 0.05
				fogColorEnd = 0,0.0850000009,0.122500002,1
				fogColorStart = 0,0.340000004,0.49000001,1
				fogDensityAltScalar = -0.0008
				fogDensityEnd = 0.025
				fogDensityExponent = 1
				fogDensityPQSMult = 0.02
				fogDensityStart = 0.005
				skyColorMult = 1.1
				skyColorOpacityAltMult = 15
				skyColorOpacityBase = 0.25
				sunAltMult = 0.01
				sunBase = 0.5
				sunMin = 0.05
				useFog = True
			}
			Mods
			{
				AerialPerspectiveMaterial
				{
					atmosphereDepth = 5000
					DEBUG_SetEveryFrame = False
					globalDensity = -7.5E-06
					heightFalloff = 0.2
					oceanDepth = 0
					order = 100
					enabled = True
					name = _Material_AerialPerspective
				}
				RemoveQuadMap
				{
					map = BUILTIN/oceanmoon_height
					deformity = 0
					maxHeight = 0.5
					minHeight = 0
					order = 1000
					enabled = True
					name = QuadRemoveMap
				}
				OceanFX
				{
					angle = 0
					blendA = 0
					blendB = 0
					framesPerSecond = 10
					oceanOpacity = 0
					spaceAltitude = 0
					spaceSurfaceBlend = 0
					specColor = 0,0,0,0
					texBlend = 0
					txIndex = 0
					order = 100
					enabled = True
					name = OceanFX
					Watermain
					{
						value = BUILTIN/sea-water1
						value = BUILTIN/sea-water2
						value = BUILTIN/sea-water3
						value = BUILTIN/sea-water4
						value = BUILTIN/sea-water5
						value = BUILTIN/sea-water6
						value = BUILTIN/sea-water7
						value = BUILTIN/sea-water8
						value = BUILTIN/sea-water1
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Minmus is the smallest moon orbiting Kerbin. From the surface of Kerbin, it can be seen on clear days as a tiny blue speck in the sky. It is often mistaken as dirt on telescope lenses or dead pixels, but the top minds at the Kerbal Astronomical Society assure us it is a real moon nevertheless.
			radius = 60000
			geeASL = 0.05001708099188
			mass = 2.64575795662095E+19
			gravParameter = 1765800026.31247
			rotates = True
			rotationPeriod = 40400
			tidallyLocked = False
			initialRotation = 230
			inverseRotThresholdAltitude = 100000
			albedo = 0.5
			emissivity = 0.7
			coreTemperatureOffset = 1
			timewarpAltitudeLimits = 0 3000 3000 6000 12000 24000 48000 60000
			sphereOfInfluence = 2247428.3879023
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/minmus_biomes
			useTheInName = False
			displayName = Minmus^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 5 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 4 // Science multiplier for in space low science.
				inSpaceHighDataValue = 2.5 // Science multiplier for in space high science.
				recoveryValue = 2.5
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 30000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.380392164,0.513725519,0.509803951,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.529411793,0.670588255,0.615686297,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.690196097,0.882352948,0.807843149,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Flats // The name of this biome.
					displayName = Flats // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.752941191,1,0.905882359,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Great Flats // The name of this biome.
					displayName = Great Flats // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.411764711,0.760784328,0.737254918,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Greater Flats // The name of this biome.
					displayName = Greater Flats // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.647058845,0.843137264,0.850980401,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lesser Flats // The name of this biome.
					displayName = Lesser Flats // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.545098066,0.831372559,0.811764717,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,1,1,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Slopes // The name of this biome.
					displayName = Slopes // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.600000024,0.800000012,0.733333349,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 95000
			fadeEnd = 140000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 0.735294104,0.735294104,0.735294104,1
				specColor = 0.191176474,0.191176474,0.191176474,1
				shininess = 0.03
				texture = BUILTIN/NewMunSurfaceMap00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/NormalMap
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 8
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 100000
			fadeEnd = 145000
			deactivateAltitude = 180000
			mapMaxHeight = 4000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Multiply
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.9
				dynamicFriction = 0.9
			}
			Material
			{
				factor = 14.26
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1.64
				steepPower = 1.5
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/MunCliff [Diffuse]
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/MunCliff [Normal]
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 500
				steepTiling = 350
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 1
				midTex = BUILTIN/Minmus [Diffuse]
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 150000
				midBumpMap = BUILTIN/Minmus [Normal]
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 150000
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 1.5
				lowStart = -1
				lowEnd = -1
				highStart = 1
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 3
				tintColor = 1,1,1,0
				texTiling = 1024
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 5000
				multiFactor = 0.5
				mainTex = BUILTIN/terrain_sand00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 0
			}
			Mods
			{
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				VertexPlanet
				{
					buildHeightColors = False
					colorDeformity = 6000
					deformity = 5000
					oceanDepth = 0
					oceanLevel = 0
					oceanSnap = False
					oceanStep = 0
					seed = 23123
					terrainRidgeBalance = 0.1
					terrainRidgesMax = 1
					terrainRidgesMin = 0.4
					terrainShapeEnd = -2
					terrainShapeStart = 2
					terrainSmoothing = 0.100000001490116
					order = 100
					enabled = True
					name = VertexPlanet
					ContinentalSimplex
					{
						deformity = 1
						frequency = 1
						octaves = 10
						persistance = 0.400000005960464
						seed = 0
					}
					RuggednessSimplex
					{
						deformity = 1
						frequency = 0.5
						octaves = 4
						persistance = 0.5
						seed = 0
					}
					SharpnessNoise
					{
						deformity = 0.00100000004749745
						frequency = 0.5
						octaves = 4
						persistance = 0.5
						seed = 0
					}
					SharpnessSimplexMap
					{
						deformity = 50
						frequency = 1.5
						octaves = 4
						persistance = 0.550000011920929
						seed = 0
					}
					LandClasses
					{
						Value
						{
							name = AbyPl
							baseColor = 0.450980395,0.588235319,0.533333361,1
							colorNoise = 0.4627451,0.749019623,0.635294139,1
							colorNoiseAmount = 0.200000002980232
							fractalEnd = 0.00100000004749745
							fractalStart = 0
							lerpToNext = True
							fractalDelta = 0.00100000004749745
							endHeight = 0
							startHeight = 0
							delete = False
							SimplexNoiseMap
							{
								deformity = 1
								frequency = 4
								octaves = 4
								persistance = 0.600000023841858
								seed = 0
							}
						}
						Value
						{
							name = Beach
							baseColor = 0.635294139,0.78039217,0.725490212,1
							colorNoise = 0.332423717,0.350746274,0.333064348,1
							colorNoiseAmount = 0.200000002980232
							fractalEnd = 0.449999988079071
							fractalStart = 0.00100000004749745
							lerpToNext = True
							fractalDelta = 0.448999988031574
							endHeight = 0
							startHeight = 0
							delete = False
							SimplexNoiseMap
							{
								deformity = 1
								frequency = 4
								octaves = 4
								persistance = 0.600000023841858
								seed = 0
							}
						}
						Value
						{
							name = Grass
							baseColor = 0.725490212,0.831372559,0.729411781,1
							colorNoise = 0.5,0.5,0.425373137,1
							colorNoiseAmount = 0.300000011920929
							fractalEnd = 0.899999976158142
							fractalStart = 0.449999988079071
							lerpToNext = True
							fractalDelta = 0.449999988079071
							endHeight = 0
							startHeight = 0
							delete = False
							SimplexNoiseMap
							{
								deformity = 1
								frequency = 3
								octaves = 4
								persistance = 0.600000023841858
								seed = 0
							}
						}
						Value
						{
							name = Snow
							baseColor = 0.431444645,0.514705896,0.450367659,0.686274529
							colorNoise = 0.430215567,0.432835817,0.339162409,1
							colorNoiseAmount = 0.400000005960464
							fractalEnd = 2
							fractalStart = 0.899999976158142
							lerpToNext = False
							fractalDelta = 1.10000002384186
							endHeight = 0
							startHeight = 0
							delete = False
							SimplexNoiseMap
							{
								deformity = 1
								frequency = 2
								octaves = 4
								persistance = 0.600000023841858
								seed = 0
							}
						}
					}
					TerrainTypeSimplex
					{
						deformity = 1
						frequency = 4
						octaves = 12
						persistance = 0.7
						seed = 0
					}
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					order = 999999
					enabled = True
					name = Scatter
					Scatters
					{
						Value
						{
							name = IceBoulder
							materialType = KSPBumpedSpecular
							material = BUILTIN/scatter_rock_minmusIce
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 3
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.5
							recieveShadows = True
							seed = 231122
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								mainTex = BUILTIN/MinmusIceBoulder [Diffuse]
								mainTexScale = 1,1
								mainTexOffset = 0,0
								bumpMap = BUILTIN/MinmusBoulder [Diffuse]
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
								color = 0.65882355,0.788235307,0.729411781,0.686274529
								specColor = 0.0882353187,0.0882353187,0.0882353187,1
								shininess = 0.078125
								opacity = 0
								rimFalloff = 0.1
								rimColor = 0,0,0,0
								temperatureColor = 0,0,0,0
								burnColor = 1,1,1,1
								underwaterFogFactor = 0
							}
						}
						Value
						{
							name = SnowBoulder
							materialType = KSPBumpedSpecular
							material = BUILTIN/scatter_rock_minmusSnow
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 3
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.5
							recieveShadows = True
							seed = 231123
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								mainTex = BUILTIN/MinmusSnowBoulder [Diffuse]
								mainTexScale = 1,1
								mainTexOffset = 0,0
								bumpMap = BUILTIN/MinmusBoulder [Diffuse]
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
								color = 0.544009507,0.632352948,0.562896669,0.686274529
								specColor = 0.0882353187,0.0882353187,0.0882353187,1
								shininess = 0.078125
								opacity = 0
								rimFalloff = 0.1
								rimColor = 0,0,0,0
								temperatureColor = 0,0,0,0
								burnColor = 1,1,1,1
								underwaterFogFactor = 0
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Ice
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 0.005
								endStart = 0.005
								startEnd = 0
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 1
									scatterName = IceBoulder
									delete = False
								}
							}
						}
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Snow
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0.08
								startStart = 0.08
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 1
									scatterName = SnowBoulder
									delete = False
								}
							}
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 67.65
					reorientInitialUp = 0,1,0
					repositionRadial = 1666,1470,2891
					repositionRadiusOffset = -1
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Monolith00
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Moho figures in Kerbal mythology as a fiery place with oceans of flowing lava. In reality however, it’s much less interesting. Scientists speculate about possible ways to make it “awesome like in the stories”. Some of those ideas have led to new breakthroughs in aerospace technology.
			radius = 250000
			geeASL = 0.275093947318621
			mass = 2.52633139930162E+21
			gravParameter = 168609378654.509
			rotates = True
			rotationPeriod = 1210000
			tidallyLocked = False
			initialRotation = 190
			inverseRotThresholdAltitude = 100000
			albedo = 0.1
			emissivity = 0.9
			coreTemperatureOffset = 0
			timewarpAltitudeLimits = 0 10000 10000 30000 50000 100000 200000 300000
			sphereOfInfluence = 9646663.02332811
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/moho_biomes
			useTheInName = False
			displayName = Moho^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 10 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 8 // Science multiplier for in space low science.
				inSpaceHighDataValue = 7 // Science multiplier for in space high science.
				recoveryValue = 7
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 80000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = North Pole // The name of this biome.
					displayName = North Pole // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.839215696,0.741176486,0.650980413,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northern Sinkhole Ridge // The name of this biome.
					displayName = Northern Sinkhole Ridge // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.650980413,0.501960814,0.368627459,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northern Sinkhole // The name of this biome.
					displayName = Northern Sinkhole // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.4627451,0.419607848,0.384313732,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.70588237,0.56078434,0.427450985,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Western Lowlands // The name of this biome.
					displayName = Western Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.345098048,0.294117659,0.254901975,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Central Lowlands // The name of this biome.
					displayName = Central Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.345098048,0.309803933,0.282352954,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.776470602,0.623529434,0.486274511,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Minor Craters // The name of this biome.
					displayName = Minor Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.301960796,0.266666681,0.239215687,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = South Western Lowlands // The name of this biome.
					displayName = South Western Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.388235301,0.345098048,0.309803933,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = South Eastern Lowlands // The name of this biome.
					displayName = South Eastern Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.419607848,0.376470596,0.337254912,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Canyon // The name of this biome.
					displayName = Canyon // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.294117659,0.243137255,0.203921571,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = South Pole // The name of this biome.
					displayName = South Pole // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.847058833,0.698039234,0.564705908,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 30000
			fadeEnd = 40000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0.0769999996,0.0769999996,0.0769999996,1
				shininess = 0.03
				texture = BUILTIN/moho01
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/moho02
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 10
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 45000
			fadeEnd = 150000
			deactivateAltitude = 150000
			mapMaxHeight = 8000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Multiply
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.9
				dynamicFriction = 0.9
			}
			Material
			{
				factor = 7.73
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1
				steepPower = 1
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/MohoSteep
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/MohoSteep_nrm
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 2000
				steepTiling = 20
				lowTex = BUILTIN/MohoLow
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 100000
				midTex = BUILTIN/MohoMid
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 100000
				midBumpMap = BUILTIN/MohoMid_nrm
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 100000
				highTex = BUILTIN/MohoMid
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 100000
				lowStart = 0
				lowEnd = 0.3
				highStart = 1
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1.62
				contrast = 1.9
				tintColor = 1,1,1,0
				texTiling = 1024
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 20000
				multiFactor = 0.5
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexSimplexNoiseColor
				{
					blend = 1
					colorStart = 0.723880589,0.723880589,0.723880589,1
					colorEnd = 0,0,0,1
					frequency = 2
					octaves = 12
					persistence = 0.5
					seed = 346434
					order = 200
					enabled = True
					name = _Color
				}
				HeightColorMap
				{
					blend = 0.75
					order = 201
					enabled = True
					name = _Color
					LandClasses
					{
						Value
						{
							name = AbyPl
							color = 0,0,0,1
							altitudeStart = 0
							altitudeEnd = 0.400000005960464
							lerpToNext = True
							delete = False
						}
						Value
						{
							name = Beach
							color = 0.328358233,0.255016565,0.205510929,1
							altitudeStart = 0.400000005960464
							altitudeEnd = 1
							lerpToNext = False
							delete = False
						}
					}
				}
				AltitudeAlpha
				{
					atmosphereDepth = 7000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				AerialPerspectiveMaterial
				{
					atmosphereDepth = 150000
					DEBUG_SetEveryFrame = True
					globalDensity = -1E-05
					heightFalloff = 6.75
					oceanDepth = 0
					order = 100
					enabled = True
					name = _Material_AerialPerspective
				}
				VertexHeightMap
				{
					map = BUILTIN/moho_height
					offset = 0
					deformity = 5000
					scaleDeformityByRadius = False
					order = 20
					enabled = True
					name = _HeightNoise
				}
				VertexSimplexHeight
				{
					deformity = 500
					frequency = 6
					octaves = 12
					persistence = 0.5
					seed = 456574
					order = 21
					enabled = True
					name = _HeightNoise
				}
				FlattenOcean
				{
					oceanRadius = 1
					order = 22
					enabled = True
					name = _HeightNoise
				}
				VertexHeightNoiseVertHeightCurve2
				{
					deformity = 2500
					ridgedAddFrequency = 32
					ridgedAddLacunarity = 2
					ridgedAddOctaves = 4
					ridgedAddSeed = 1212
					ridgedMode = Low
					ridgedSubFrequency = 32
					ridgedSubLacunarity = 2
					ridgedSubOctaves = 4
					ridgedSubSeed = 453123
					simplexFrequency = 24
					simplexHeightEnd = 5500
					simplexHeightStart = 10
					simplexOctaves = 4
					simplexPersistence = 0.5
					simplexSeed = 453452378
					order = 23
					enabled = True
					name = _HeightNoise
					simplexCurve
					{
						key = 0 0 0 0
						key = 0.6311918 0.4490898 1.432598 1.432598
						key = 1 1 0 0
					}
				}
				VertexSimplexHeightAbsolute
				{
					deformity = 200
					frequency = 18
					octaves = 7
					persistence = 0.5
					seed = 435345
					order = 30
					enabled = True
					name = _FineDetail
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City2
				{
					snapToSurface = True
					alt = 192.09375
					lat = 90
					lon = -4.78341462454E-06
					objectName = Mohole
					up = 0,1,0
					rotation = 0
					snapHeightOffset = 0
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Mohole
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = The Mun, is a large satellite orbiting Kerbin. It is mostly gray in appearance, with craters of various sizes dotting its otherwise smooth surface.The Mun’s discovery is widely regarded as one of the more important breakthroughs of Kerbal evolution. Granted, it didn’t happen all that long ago, but it’s still fair to say Kerbals are wiser and more evolved now than they were back then.
			radius = 200000
			geeASL = 0.166056700098353
			mass = 9.7599066119646E+20
			gravParameter = 65138397520.7807
			rotates = True
			rotationPeriod = 138984.376574476
			tidallyLocked = True
			initialRotation = 230
			inverseRotThresholdAltitude = 100000
			albedo = 0.1
			emissivity = 0.9
			coreTemperatureOffset = 5
			timewarpAltitudeLimits = 0 5000 5000 10000 25000 50000 100000 200000
			sphereOfInfluence = 2429559.11656475
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/mun_Biomes
			useTheInName = True
			displayName = The Mun^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 4 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 3 // Science multiplier for in space low science.
				inSpaceHighDataValue = 2 // Science multiplier for in space high science.
				recoveryValue = 2
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 60000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.36470589,0.458823532,0.509803951,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northern Basin // The name of this biome.
					displayName = Northeast Basin // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.423529416,0.458823532,0.576470613,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = East Crater // The name of this biome.
					displayName = East Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.580392182,0.627451003,0.796078444,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northwest Crater // The name of this biome.
					displayName = Northwest Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.407843143,0.474509805,0.694117665,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Southwest Crater // The name of this biome.
					displayName = Southwest Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.65882355,0.678431392,0.737254918,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Farside Crater // The name of this biome.
					displayName = Farside Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.56078434,0.647058845,0.90196079,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Canyons // The name of this biome.
					displayName = Canyons // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.325490206,0.368627459,0.521568656,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Polar Crater // The name of this biome.
					displayName = Polar Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.603921592,0.647058845,0.670588255,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.917647064,0.925490201,0.929411769,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Polar Lowlands // The name of this biome.
					displayName = Polar Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.811764717,0.827450991,0.839215696,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.450980395,0.53725493,0.58431375,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highland Craters // The name of this biome.
					displayName = Highland Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.694117665,0.733333349,0.870588243,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midland Craters // The name of this biome.
					displayName = Midland Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.164705887,0.247058824,0.294117659,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = East Farside Crater // The name of this biome.
					displayName = East Farside Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.603921592,0.611764729,0.917647064,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Twin Craters // The name of this biome.
					displayName = Twin Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.678431392,0.745098054,0.945098042,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.254901975,0.356862754,0.41568628,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Farside Basin // The name of this biome.
					displayName = Farside Basin // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.529411793,0.556862772,0.639215708,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 55000
			fadeEnd = 60000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 0.723880589,0.734684765,0.734684765,1
				specColor = 0,0,0,1
				shininess = 0.03
				texture = BUILTIN/NewMunSurfaceMapDiffuse
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/NewMunSurfaceMapNormals
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 10
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 60000
			fadeEnd = 120000
			deactivateAltitude = 120750
			mapMaxHeight = 9000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 8
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1
				steepPower = 1.5
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/MunCliff [Diffuse]
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/MunCliff [Normal]
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 500
				steepTiling = 350
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 1
				midTex = BUILTIN/MunFloor [Diffuse]
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 150000
				midBumpMap = BUILTIN/MunFloor [Normal]
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 150000
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 1.5
				lowStart = -1
				lowEnd = -1
				highStart = 1
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0.002323827
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1
				tintColor = 1,1,1,0
				texTiling = 4000
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 6000
				multiFactor = 24
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexColorMap
				{
					map = BUILTIN/munColorMap2
					order = 10
					enabled = True
					name = _Color
				}
				VertexHeightMap
				{
					map = BUILTIN/munHeightMap2
					offset = 0
					deformity = 7500
					scaleDeformityByRadius = False
					order = 10
					enabled = True
					name = _Height
				}
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					order = 999999
					enabled = True
					name = Scatter
					Scatters
					{
						Value
						{
							name = Rock00
							materialType = StandardSpecular
							material = BUILTIN/terrain_rock00
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 2.5
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.15
							recieveShadows = True
							seed = 231123
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 0.519999981,0.513417721,0.490379721,1
								mainTex = BUILTIN/MunBoulder [Diffuse]
								mainTexScale = 4,4
								mainTexOffset = 0,0
								cutoff = 0.5
								glossiness = 0.078
								glossMapScale = 1
								smoothnessTextureChannel = AlbedoAlpha
								specColor = 0.117647052,0.117647052,0.117647052,1
								metallicGlossMapScale = 1,1
								metallicGlossMapOffset = 0,0
								specularHighlights = True
								glossyReflections = True
								bumpScale = 1
								bumpMap = BUILTIN/MunBoulder [Normal]
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
								parallax = 0.02
								parallaxMapScale = 1,1
								parallaxMapOffset = 0,0
								occlusionStrength = 1
								occlusionMapScale = 1,1
								occlusionMapOffset = 0,0
								emissionColor = 0,0,0,1
								emissionMapScale = 4,4
								emissionMapOffset = 0,0
								detailMaskScale = 1,1
								detailMaskOffset = 0,0
								detailAlbedoMapScale = 1,1
								detailAlbedoMapOffset = 0,0
								detailNormalMapScale = 1,1
								detailNormalMapOffset = 0,0
								UVSec = Uv0
								mode = Opaque
								srcBlend = 1
								dstBlend = 0
								ZWrite = 1
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Base
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 1
									scatterName = Rock00
									delete = False
								}
							}
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = -117.65
					reorientInitialUp = 0,1,0
					repositionRadial = 178121,-34319,86559
					repositionRadiusOffset = 800
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Monolith00
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 27.65
					reorientInitialUp = 0,1,0
					repositionRadial = -6140,-200500,26747
					repositionRadiusOffset = -189
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Monolith02
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				FlattenArea
				{
					DEBUG_showColors = False
					flattenTo = 4500.25
					innerRadius = 200
					outerRadius = 1000
					position = -6140,-200500,26747
					smoothEnd = 0
					smoothStart = 0
					order = 100
					enabled = True
					name = Monolith02
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = -92.65
					reorientInitialUp = 0,1,0
					repositionRadial = 106480,170340,17136
					repositionRadiusOffset = 14
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = True
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Monolith01
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				FlattenArea
				{
					DEBUG_showColors = False
					flattenTo = 4000.25
					innerRadius = 200
					outerRadius = 1000
					position = 106480,170340,17136
					smoothEnd = 0
					smoothStart = 0
					order = 100
					enabled = True
					name = Monolith01
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = 2984,872,19998
					repositionRadiusOffset = 2370
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = RockArch02
					LOD
					{
						Value
						{
							visibleRange = 20000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = 15233,4336,12414
					repositionRadiusOffset = 1230
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = RockArch00
					LOD
					{
						Value
						{
							visibleRange = 20000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = -15233,-4336,-12360
					repositionRadiusOffset = 1970
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = RockArch01
					LOD
					{
						Value
						{
							visibleRange = 20000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 0
					reorientInitialUp = 0,1,0
					repositionRadial = 184640.094,2455.73901,77414.4766
					repositionRadiusOffset = 225
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = ArmstrongMemorial
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 180
					reorientInitialUp = 0,1,0
					repositionRadial = 24581.6309,-191229.094,-61263.4883
					repositionRadiusOffset = 2300
					repositionToSphere = False
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = UFO
					LOD
					{
						Value
						{
							visibleRange = 8000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
				VertexSimplexNoiseColor
				{
					blend = 0.125
					colorStart = 0,0,0,1
					colorEnd = 1,1,1,1
					frequency = 4
					octaves = 8
					persistence = 0.600000023841858
					seed = 0
					order = 200
					enabled = True
					name = _ColorNoise
				}
				VertexSimplexHeight
				{
					deformity = 400
					frequency = 12
					octaves = 8
					persistence = 0.5
					seed = 2211221
					order = 102
					enabled = True
					name = _HeightNoise
				}
				VertexHeightNoiseVertHeight
				{
					heightStart = 0
					heightEnd = 1
					deformity = 400
					frequency = 12
					octaves = 6
					persistance = 0.5
					seed = 1283704385
					mode = Low
					noiseType = Perlin
					lacunarity = 2
					order = 103
					enabled = True
					name = _HeightNoise
				}
				VoronoiCraters
				{
					colorOpacity = 0.7
					DebugColorMapping = False
					deformation = 500
					jitter = 0.1
					jitterHeight = 3
					rFactor = 1
					rOffset = 1
					simplexFrequency = 120
					simplexOctaves = 3
					simplexPersistence = 0.5
					simplexSeed = 123123
					voronoiDisplacement = 0
					voronoiFrequency = 22
					voronoiSeed = 824
					order = 101
					enabled = True
					name = _HeightNoise
					CraterCurve
					{
						key = -0.9982381 -0.7411783 -0.06500059 -0.06500059
						key = -0.9332262 -0.7678316 -0.2176399 -0.2176399
						key = -0.8990405 -0.7433339 -2.560626 -2.560626
						key = -0.7445966 -0.8581167 0.4436148 0.4436148
						key = -0.4499771 -0.1392395 5.289535 5.289535
						key = -0.4015177 0.2551735 9.069458 -2.149609
						key = -0.2297457 0.002857953 -0.4453675 -0.4453675
						key = 0.2724952 0.00423781 -0.01884932 -0.01884932
						key = 0.9998434 -0.004090764 0.01397126 0.01397126
					}
					JitterCurve
					{
						key = -1.000701 0.4278412 0.1577609 0.1577609
						key = -0.7884969 0.09487452 -0.7739663 -0.7739663
						key = -0.6091803 0.072019 0.123537 0.123537
						key = -0.3930514 0.3903495 3.300831 3.300831
						key = -0.3584836 0.8643304 0.07139917 0.07139917
						key = -0.2988068 0.002564805 -0.01814346 -0.01814346
						key = 0.9970253 0.003401639 0 0
					}
				}
				VoronoiCraters
				{
					colorOpacity = 0.7
					DebugColorMapping = False
					deformation = 200
					jitter = 0.1
					jitterHeight = 2
					rFactor = 1
					rOffset = 1.1
					simplexFrequency = 300
					simplexOctaves = 3
					simplexPersistence = 0.5
					simplexSeed = 123123
					voronoiDisplacement = 0
					voronoiFrequency = 50
					voronoiSeed = 462
					order = 100
					enabled = True
					name = _HeightNoise
					CraterCurve
					{
						key = -0.9963056 -0.7950293 -0.1902251 -0.1902251
						key = -0.9520697 -0.8223228 -0.6806358 -0.6806358
						key = -0.7445966 -0.8581167 0.4436148 0.4436148
						key = -0.4499771 -0.1392395 5.289535 5.289535
						key = -0.4015177 0.2551735 9.069458 -2.149609
						key = -0.2297457 0.08363447 -0.4453675 -0.4453675
						key = 0.2817185 0.01192154 0.01421198 0.01421198
						key = 1.000876 0.001117015 0.01397126 0.01397126
					}
					JitterCurve
					{
						key = -1.000701 0.4278412 0.1577609 0.1577609
						key = -0.7884969 0.09487452 -0.7739663 -0.7739663
						key = -0.6091803 0.072019 0.123537 0.123537
						key = -0.3930514 0.3903495 3.300831 3.300831
						key = -0.3141366 0.9276265 0 0
						key = -0.2586833 0.002564805 -0.01814346 -0.01814346
						key = 0.9970253 0.003401639 0 0
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = This moon was especially hard to spot, as it looks just like a pollen grain, particularly when observed through telescopes based near dusty fields.Pol was finally discovered when someone decided to write down the location of the pollen, after having given up on yet another failed attempt to be rid of the smudge.
			radius = 44000
			geeASL = 0.0380129809873912
			mass = 1.08135065806823E+19
			gravParameter = 721702080
			rotates = True
			rotationPeriod = 901902.623531173
			tidallyLocked = True
			initialRotation = 25
			inverseRotThresholdAltitude = 100000
			albedo = 0.5
			emissivity = 0.5
			coreTemperatureOffset = 7
			timewarpAltitudeLimits = 0 5000 5000 5000 8000 12000 30000 90000
			sphereOfInfluence = 1042138.89230178
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/pol_biomes
			useTheInName = False
			displayName = Pol^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 12 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 9 // Science multiplier for in space low science.
				inSpaceHighDataValue = 8 // Science multiplier for in space high science.
				recoveryValue = 8
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 22000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,0.952941179,0.772549033,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.713725507,0.647058845,0.407843143,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.960784316,0.894117653,0.639215708,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.831372559,0.75686276,0.478431374,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 10000
			fadeEnd = 15000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0,0,0,1
				shininess = 0.078125
				texture = BUILTIN/gp1minormoon200
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/gp1minormoon201
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 10
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 15000
			fadeEnd = 60000
			deactivateAltitude = 80000
			mapMaxHeight = 6000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 6
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1.15
				steepPower = 2
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/pol_steepDiff
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/pol_steepNRM
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 100
				steepTiling = 50
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 1
				midTex = BUILTIN/pol_lowDiff
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 120000
				midBumpMap = BUILTIN/pol_lowNRM
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 120000
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 120000
				lowStart = -1
				lowEnd = -1
				highStart = 1
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0.002323827
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.2
				tintColor = 1,1,1,0
				texTiling = 1024
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 20000
				multiFactor = 0.5
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexSimplexHeightAbsolute
				{
					deformity = 3000
					frequency = 2
					octaves = 6
					persistence = 0.5
					seed = 2312
					order = 20
					enabled = True
					name = _Height
				}
				VertexHeightNoise
				{
					deformity = 2600
					frequency = 1.5
					octaves = 4
					persistence = 0.5
					seed = 546345
					noiseType = RiggedMultifractal
					mode = Low
					lacunarity = 2.5
					order = 10
					enabled = True
					name = _Height
				}
				FlattenOcean
				{
					oceanRadius = 1
					order = 11
					enabled = True
					name = _Height
				}
				VertexSimplexHeightAbsolute
				{
					deformity = 800
					frequency = 6
					octaves = 8
					persistence = 0.5
					seed = 5645667
					order = 21
					enabled = True
					name = _Height
				}
				VertexHeightOffset
				{
					offset = -700
					order = 80
					enabled = True
					name = _Height
				}
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				VertexSimplexNoiseColor
				{
					blend = 1
					colorStart = 0.925373137,0.899681747,0.495042235,1
					colorEnd = 0.139860123,0.143785819,0.149253726,1
					frequency = 4
					octaves = 8
					persistence = 0.5
					seed = 9674345
					order = 40
					enabled = True
					name = _Color
				}
				HeightColorMap
				{
					blend = 0.5
					order = 41
					enabled = True
					name = _Color
					LandClasses
					{
						Value
						{
							name = AbyPl
							color = 0.552941203,0.466666669,0.337254912,1
							altitudeStart = 0
							altitudeEnd = 0.500000023841858
							lerpToNext = True
							delete = False
						}
						Value
						{
							name = Beach
							color = 0.656716406,0.458899528,0.401836962,1
							altitudeStart = 0.500000023841858
							altitudeEnd = 0.600000023841858
							lerpToNext = True
							delete = False
						}
						Value
						{
							name = Grass
							color = 0.447058827,0.447058827,0.447058827,1
							altitudeStart = 0.600000023841858
							altitudeEnd = 1
							lerpToNext = False
							delete = False
						}
					}
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					order = 999999
					enabled = True
					name = Scatter
					Scatters
					{
						Value
						{
							name = boulder
							materialType = DiffuseDetail
							material = BUILTIN/brownrock
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 2
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.25
							recieveShadows = True
							seed = 231123
							verticalOffset = -0.15
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 0.664179087,0.63194412,0.448204786,1
								mainTex = BUILTIN/distantground
								mainTexScale = 0.5,0.5
								mainTexOffset = 0,0
								detail = BUILTIN/rock00
								detailScale = 3,3
								detailOffset = 0,0
							}
						}
						Value
						{
							name = stalactite
							materialType = DiffuseDetail
							material = BUILTIN/brownrock
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/Cube
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 4
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.5
							recieveShadows = True
							seed = 23453
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 0.664179087,0.63194412,0.448204786,1
								mainTex = BUILTIN/distantground
								mainTexScale = 0.5,0.5
								mainTexOffset = 0,0
								detail = BUILTIN/rock00
								detailScale = 3,3
								detailOffset = 0,0
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Base
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 0.25
									scatterName = boulder
									delete = False
								}
								Value
								{
									density = 0.75
									scatterName = stalactite
									delete = False
								}
							}
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Tylo was the first moon of Jool to be discovered by the Kerbal Astronomical Society. After many failed attempts to take a flawless picture of Jool to hang on the office walls, it was finally discovered that the wandering white smear was indeed a moon.Scientists speculate that the view from the surface with Laythe, Vall and Jool overhead must be “quite something”.
			radius = 600000
			geeASL = 0.800273295870079
			mass = 4.23321273059351E+22
			gravParameter = 2825280042099.95
			rotates = True
			rotationPeriod = 211926.35802123
			tidallyLocked = True
			initialRotation = 0
			inverseRotThresholdAltitude = 100000
			albedo = 0.1
			emissivity = 0.9
			coreTemperatureOffset = 20
			timewarpAltitudeLimits = 0 30000 30000 60000 120000 240000 480000 600000
			sphereOfInfluence = 10856518.3683586
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/tylo_biome2
			useTheInName = False
			displayName = Tylo^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 12 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 10 // Science multiplier for in space low science.
				inSpaceHighDataValue = 8 // Science multiplier for in space high science.
				recoveryValue = 8
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 250000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.701960802,0.639215708,0.603921592,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.792156875,0.733333349,0.701960802,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.619607866,0.556862772,0.517647088,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Mara // The name of this biome.
					displayName = Mara // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.53725493,0.474509805,0.435294122,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Minor Craters // The name of this biome.
					displayName = Minor Craters // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.447058827,0.388235301,0.352941185,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Tycho Crater // The name of this biome.
					displayName = Tycho Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.827450991,0.643137276,0.533333361,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Galileio Crater // The name of this biome.
					displayName = Galileio Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.741176486,0.541176498,0.423529416,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Grissom Crater // The name of this biome.
					displayName = Grissom Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.666666687,0.458823532,0.337254912,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Gagarin Crater // The name of this biome.
					displayName = Gagarin Crater // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.58431375,0.388235301,0.274509817,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 10000
			fadeEnd = 50000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 1,1,1,1
				specColor = 0,0,0,1
				shininess = 0.078125
				texture = BUILTIN/rockyMoon00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/rockyMoon01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 10
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 50000
			fadeEnd = 100000
			deactivateAltitude = 400000
			mapMaxHeight = 16000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 10
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1.2
				steepPower = 1.8
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/MunCliff [Diffuse]
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/MunCliff [Normal]
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 500
				steepTiling = 350
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 1
				midTex = BUILTIN/tyloFloorDiffuse
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 120000
				midBumpMap = BUILTIN/tyloNRM
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 120000
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 1.5
				lowStart = -1
				lowEnd = -1
				highStart = 1
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0.002323827
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 1.2
				tintColor = 1,1,1,0
				texTiling = 1024
				texPower = 0.75
				multiPower = 0.75
				groundTexStart = 0
				groundTexEnd = 20000
				multiFactor = 0.5
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexSimplexHeightAbsolute
				{
					deformity = 1000
					frequency = 24
					octaves = 8
					persistence = 0.5
					seed = 4447895
					order = 50
					enabled = True
					name = _Height
				}
				VertexSimplexHeight
				{
					deformity = 2000
					frequency = 4
					octaves = 8
					persistence = 0.5
					seed = 98374
					order = 59
					enabled = True
					name = _Height
				}
				VertexHeightMap
				{
					map = BUILTIN/rockymoon_height
					offset = 0
					deformity = 6000
					scaleDeformityByRadius = False
					order = 49
					enabled = True
					name = _Height
				}
				FlattenOcean
				{
					oceanRadius = 1
					order = 60
					enabled = True
					name = _Height
				}
				VertexHeightNoiseVertHeightCurve2
				{
					deformity = 8000
					ridgedAddFrequency = 12
					ridgedAddLacunarity = 2
					ridgedAddOctaves = 4
					ridgedAddSeed = 1530393239
					ridgedMode = Low
					ridgedSubFrequency = 12
					ridgedSubLacunarity = 2
					ridgedSubOctaves = 4
					ridgedSubSeed = 1212096306
					simplexFrequency = 4
					simplexHeightEnd = 9000
					simplexHeightStart = 0
					simplexOctaves = 6
					simplexPersistence = 0.699999988079071
					simplexSeed = 1909396195
					order = 100
					enabled = True
					name = _Height
					simplexCurve
					{
						key = 0 0 0 0
						key = 1 1 2 2
					}
				}
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = False
					name = _Material_ModProjection
				}
				HeightColorMap
				{
					blend = 0.4
					order = 201
					enabled = True
					name = _Color
					LandClasses
					{
						Value
						{
							name = AbyPl
							color = 0.0895522237,0.0818317235,0.0710781664,1
							altitudeStart = 0
							altitudeEnd = 0.100000001490116
							lerpToNext = True
							delete = False
						}
						Value
						{
							name = Beach
							color = 0.186567187,0.175477535,0.175477535,1
							altitudeStart = 0.100000001490116
							altitudeEnd = 0.699999988079071
							lerpToNext = True
							delete = False
						}
						Value
						{
							name = Beach
							color = 0.76119405,0.715948284,0.715948284,1
							altitudeStart = 0.699999988079071
							altitudeEnd = 1
							lerpToNext = False
							delete = False
						}
					}
				}
				VertexColorMap
				{
					map = BUILTIN/rockymoon_color
					order = 200
					enabled = True
					name = _Color
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					order = 999999
					enabled = True
					name = Scatter
					Scatters
					{
						Value
						{
							name = boulder
							materialType = StandardSpecular
							material = BUILTIN/terrain_rock00
							allowedBiomes = 
							lethalRadius = 0
							lethalRadiusMsg = 
							lethalRadiusWarnMsg = 
							mesh = BUILTIN/boulder
							castShadows = True
							densityFactor = 1
							maxCache = 512
							maxCacheDelta = 32
							maxLevelOffset = 0
							maxScale = 3
							maxScatter = 20
							maxSpeed = 1000
							minScale = 0.5
							recieveShadows = True
							seed = 231123
							verticalOffset = 0
							instancing = False
							rotation = 0 360
							useBetterDensity = False
							spawnChance = 1
							ignoreDensityGameSetting = False
							delete = False
							Material
							{
								color = 0.519999981,0.513417721,0.490379721,1
								mainTex = BUILTIN/MunBoulder [Diffuse]
								mainTexScale = 4,4
								mainTexOffset = 0,0
								cutoff = 0.5
								glossiness = 0.078
								glossMapScale = 1
								smoothnessTextureChannel = AlbedoAlpha
								specColor = 0.117647052,0.117647052,0.117647052,1
								metallicGlossMapScale = 1,1
								metallicGlossMapOffset = 0,0
								specularHighlights = True
								glossyReflections = True
								bumpScale = 1
								bumpMap = BUILTIN/MunBoulder [Normal]
								bumpMapScale = 1,1
								bumpMapOffset = 0,0
								parallax = 0.02
								parallaxMapScale = 1,1
								parallaxMapOffset = 0,0
								occlusionStrength = 1
								occlusionMapScale = 1,1
								occlusionMapOffset = 0,0
								emissionColor = 0,0,0,1
								emissionMapScale = 4,4
								emissionMapOffset = 0,0
								detailMaskScale = 1,1
								detailMaskOffset = 0,0
								detailAlbedoMapScale = 1,1
								detailAlbedoMapOffset = 0,0
								detailNormalMapScale = 1,1
								detailNormalMapOffset = 0,0
								UVSec = Uv0
								mode = Opaque
								srcBlend = 1
								dstBlend = 0
								ZWrite = 1
							}
						}
					}
					LandClasses
					{
						Value
						{
							alterApparentHeight = 0
							alterRealHeight = 0
							color = 0,0,0,0
							coverageBlend = 0
							coverageFrequency = 1
							coverageOctaves = 1
							coveragePersistance = 1
							coverageSeed = 1
							name = Base
							latDelta = 1
							latitudeDouble = False
							lonDelta = 1
							minimumRealHeight = 0
							noiseBlend = 0
							noiseColor = 0,0,0,0
							noiseFrequency = 1
							noiseOctaves = 1
							noisePersistance = 1
							noiseSeed = 1
							delete = False
							altitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeDoubleRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							latitudeRange
							{
								endEnd = 1
								endStart = 1
								startEnd = 0
								startStart = 0
							}
							longitudeRange
							{
								endEnd = 2
								endStart = 2
								startEnd = -1
								startStart = -1
							}
							Scatters
							{
								Value
								{
									density = 0.5
									scatterName = boulder
									delete = False
								}
							}
						}
					}
				}
				MapDecal
				{
					absolute = False
					absoluteOffset = 0
					angle = 70
					cullBlack = False
					DEBUG_HighlightInclusion = False
					heightMap = BUILTIN/saganface
					heightMapDeformity = 50
					position = 569917.375,-94669.7969,181300.906
					removeScatter = True
					radius = 6000
					smoothColor = 0
					smoothHeight = 0.125
					useAlphaHeightSmoothing = False
					order = 200
					enabled = True
					name = Sagan
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = False
					reorientToSphere = True
					reorientFinalAngle = 30
					reorientInitialUp = 0,1,0
					repositionRadial = -457335.5,388660.5,48087.0898
					repositionRadiusOffset = 2085
					repositionToSphere = True
					repositionToSphereSurface = False
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Cave
					LOD
					{
						Value
						{
							visibleRange = 12000
							scale = 0,0,0
							delete = False
						}
					}
				}
				City
				{
					debugOrientated = False
					frameDelta = 1
					randomizeOnSphere = True
					reorientToSphere = True
					reorientFinalAngle = 45
					reorientInitialUp = 0,1,0
					repositionRadial = 513856,-290549,-122798
					repositionRadiusOffset = 2948.5
					repositionToSphere = True
					repositionToSphereSurface = True
					repositionToSphereSurfaceAddHeight = False
					commnetStation = False
					isKSC = False
					order = 100
					enabled = True
					name = Randolith
					LOD
					{
						Value
						{
							visibleRange = 10000
							scale = 0,0,0
							delete = False
						}
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''','''@Kopernicus:FOR[RandomDres]
{
	Body
	{
		name = Dres
		barycenter = False
		identifier = Squad/Dres
		finalizeOrbit = False
		randomMainMenuBody = False
		contractWeight = 30
		Properties
		{
			description = Vall was one of the last Moons of Jool to be discovered. Frustrated scientists kept attempting to wipe it off the lenses of their telescopes. Eventually after a rash of returned telescopes, Advanced Optics Co. finally decided to just tell them it was an actual object in the sky.
			radius = 300000
			geeASL = 0.235080276562617
			mass = 3.10876554482042E+21
			gravParameter = 207481499473.751
			rotates = True
			rotationPeriod = 105962.088893924
			tidallyLocked = True
			initialRotation = 0
			inverseRotThresholdAltitude = 100000
			albedo = 0.5
			emissivity = 0.7
			coreTemperatureOffset = 40
			timewarpAltitudeLimits = 0 24500 24500 24500 40000 60000 80000 100000
			sphereOfInfluence = 2406401.44479404
			solarRotationPeriod = False
			navballSwitchRadiusMult = 0.06
			navballSwitchRadiusMultLow = 0.055
			biomeMap = BUILTIN/Vall_biomes
			useTheInName = False
			displayName = Vall^N
			selectable = True
			RnDVisibility = Visible
			RnDRotation = False
			maxZoom = 60000
			ScienceValues
			{
				landedDataValue = 12 // Science multiplier for landed science.
				splashedDataValue = 1 // Science multiplier for splashed down science.
				flyingLowDataValue = 1 // Science multiplier for flying low science.
				flyingHighDataValue = 1 // Science multiplier for flying high science.
				inSpaceLowDataValue = 9 // Science multiplier for in space low science.
				inSpaceHighDataValue = 8 // Science multiplier for in space high science.
				recoveryValue = 8
				flyingAltitudeThreshold = 18000 // Altitude when "flying at <body>" transitions from/to "from <body>'s upper atmosphere"
				spaceAltitudeThreshold = 90000 // Altitude when "in space low" transitions from/to "in space high"
			}
			Biomes
			{
				Value
				{
					name = Poles // The name of this biome.
					displayName = Poles // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.745098054,0.968627453,0.988235295,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Midlands // The name of this biome.
					displayName = Midlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.419607848,0.776470602,0.807843149,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Highlands // The name of this biome.
					displayName = Highlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.270588249,0.698039234,0.737254918,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Lowlands // The name of this biome.
					displayName = Lowlands // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 1,1,1,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northeast Basin // The name of this biome.
					displayName = Northeast Basin // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.698039234,0.698039234,0.698039234,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Northwest Basin // The name of this biome.
					displayName = Northwest Basin // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.588235319,0.588235319,0.588235319,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Southern Basin // The name of this biome.
					displayName = Southern Basin // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.866666675,0.866666675,0.866666675,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Southern Valleys // The name of this biome.
					displayName = Southern Valleys // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.78039217,0.78039217,0.78039217,1 // The color of the biome on the biome map.
				}
				Value
				{
					name = Mountains // The name of this biome.
					displayName = Mountains // The displayed name of the biome. Can be a localization tag.
					value = 0 // A value that gets multiplied with every amount of science that is returned in the biome.
					color = 0.611764729,0.850980401,0.870588243,1 // The color of the biome on the biome map.
				}
			}
		}
		Orbit
		{
			referenceBody = Sun // The body that this body is orbiting around.
			inclination = 5 // The angle between the orbital plane and the ecliptic
			eccentricity = 0.145 // The deviation of the orbit from circularity
			semiMajorAxis = 40839348203 // One-half the length of a line segment drawn from periapsis to apoapsis
			longitudeOfAscendingNode = 280 // Where the orbit crosses the ecliptic moving south to north
			argumentOfPeriapsis = 90 // The angular distance between longitudeOfAscendingNode and periapsis
			meanAnomalyAtEpoch = 3.14000010490417 // The body's mean anomaly at the specified epoch, in radians
			meanAnomalyAtEpochD = 179.908753681645 // The body's mean anomaly at the specified epoch, in degrees
			epoch = 0 // The number of elapsed seconds from UT = 00:00:00
			color = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the orbit line in the Tracking Station
			nodeColor = 0.352941185,0.266666681,0.196078435,0.501960814 // The color of the circle that marks the planets current position on the orbit
			mode = REDRAW_AND_RECALCULATE
			icon = ALL
			cameraSmaRatioBounds = 0.03 25
			period = 47893063.1385932 // Orbital period in seconds
		}
		ScaledVersion
		{
			type = Vacuum
			fadeStart = 100000
			fadeEnd = 200000
			sphericalModel = False
			deferMesh = False
			invisible = False
			Material
			{
				color = 0.604477644,0.604477644,0.604477644,1
				specColor = 0,0,0,1
				shininess = 0.078125
				texture = BUILTIN/gp1icemoon00
				mainTexScale = 1,1
				mainTexOffset = 0,0
				normals = BUILTIN/gp1icemoon01
				bumpMapScale = 1,1
				bumpMapOffset = 0,0
				opacity = 1
				resourceMapScale = 1,1
				resourceMapOffset = 0,0
			}
		}
		PQS
		{
			minLevel = 2
			maxLevel = 10
			minDetailDistance = 8
			maxQuadLengthsPerFrame = 0.03
			fadeStart = 200000
			fadeEnd = 300000
			deactivateAltitude = 330000
			mapMaxHeight = 20000
			materialType = AtmosphericTriplanarZoomRotation
			PhysicsMaterial
			{
				bounceCombine = Average
				frictionCombine = Maximum
				bounciness = 0
				staticFriction = 0.8
				dynamicFriction = 0.6
			}
			Material
			{
				factor = 5
				factorBlendWidth = 0
				factorRotation = 0
				saturation = 0
				contrast = 0
				tintColor = 0,0,0,0
				specularColor = 0,0,0,0
				albedoBrightness = 1.5
				steepPower = 1.5
				steepTexStart = 0
				steepTexEnd = 0
				steepTex = BUILTIN/VallHigh[Spec-Diffuse]
				steepTexScale = 1,1
				steepTexOffset = 0,0
				steepBumpMap = BUILTIN/VallSteep[Nomral]
				steepBumpMapScale = 1,1
				steepBumpMapOffset = 0,0
				steepNearTiling = 500
				steepTiling = 350
				lowTexScale = 1,1
				lowTexOffset = 0,0
				lowTiling = 1
				midTex = BUILTIN/VallFloor [Spec-Diffuse]
				midTexScale = 1,1
				midTexOffset = 0,0
				midTiling = 100000
				midBumpMap = BUILTIN/VallFloor [Nomral]
				midBumpMapScale = 1,1
				midBumpMapOffset = 0,0
				midBumpTiling = 100000
				highTex = BUILTIN/VallHigh[Spec-Diffuse]
				highTexScale = 1,1
				highTexOffset = 0,0
				highTiling = 100000
				lowStart = -1
				lowEnd = -1
				highStart = 0.01
				highEnd = 1
				globalDensity = 0
				fogColorRampScale = 1,1
				fogColorRampOffset = 0,0
				planetOpacity = 0.002323827
				oceanFogDistance = 0
			}
			FallbackMaterial
			{
				saturation = 1
				contrast = 0.8
				tintColor = 1,1,1,0
				texTiling = 2000
				texPower = 0.36
				multiPower = 0.25
				groundTexStart = 5000
				groundTexEnd = 12000
				multiFactor = 0.5
				mainTex = BUILTIN/RockyGround
				mainTexScale = 1,1
				mainTexOffset = 0,0
				planetOpacity = 1
			}
			Mods
			{
				VertexSimplexHeightAbsolute
				{
					deformity = 3000
					frequency = 3
					octaves = 8
					persistence = 0.5
					seed = 56499778
					order = 10
					enabled = True
					name = _Height
				}
				VertexHeightNoise
				{
					deformity = 2000
					frequency = 4
					octaves = 8
					persistence = 0.5
					seed = 56930927
					noiseType = RiggedMultifractal
					mode = Low
					lacunarity = 2
					order = 11
					enabled = True
					name = _Height
				}
				VertexHeightMap
				{
					map = BUILTIN/genericoffset
					offset = 0
					deformity = 1000
					scaleDeformityByRadius = False
					order = 9
					enabled = True
					name = _Height
				}
				VertexSimplexHeightAbsolute
				{
					deformity = 100
					frequency = 25
					octaves = 6
					persistence = 0.5
					seed = 8008135
					order = 12
					enabled = True
					name = _Height
				}
				VertexHeightMap
				{
					map = BUILTIN/icemoon_mountains
					offset = 0
					deformity = 2000
					scaleDeformityByRadius = False
					order = 100
					enabled = True
					name = _Height
				}
				AltitudeAlpha
				{
					atmosphereDepth = 8000
					invert = False
					order = 999999999
					enabled = True
					name = _Material_ModProjection
				}
				HeightColorMap
				{
					blend = 1
					order = 500
					enabled = True
					name = _Color
					LandClasses
					{
						Value
						{
							name = Ice
							color = 0.115671635,0.195087969,0.231343269,1
							altitudeStart = -1
							altitudeEnd = 0.600000023841858
							lerpToNext = True
							delete = False
						}
						Value
						{
							name = Snow
							color = 0.503757417,0.670200825,0.731343269,1
							altitudeStart = 0.600000023841858
							altitudeEnd = 0.699999988079071
							lerpToNext = True
							delete = False
						}
						Value
						{
							name = Snow
							color = 0.748277843,0.868349135,0.902985096,1
							altitudeStart = 0.699999988079071
							altitudeEnd = 1
							lerpToNext = False
							delete = False
						}
					}
				}
				VertexSimplexNoiseColor
				{
					blend = 0.3
					colorStart = 0.274258614,0.283582091,0.238962531,0
					colorEnd = 0.634328365,0.628634572,0.538957298,0
					frequency = 12
					octaves = 8
					persistence = 0.5
					seed = 777834934
					order = 501
					enabled = True
					name = _Color
				}
				LandControl
				{
					altitudeBlend = 0
					altitudeFrequency = 1
					altitudeOctaves = 1
					altitudePersistance = 1
					altitudeSeed = 1
					createColors = False
					createScatter = True
					heightMap = BUILTIN/icemoon_mountains
					latitudeBlend = 0
					latitudeFrequency = 1
					latitudeOctaves = 1
					latitudePersistance = 1
					latitudeSeed = 1
					longitudeBlend = 0
					longitudeFrequency = 1
					longitudeOctaves = 1
					longitudePersistance = 1
					longitudeSeed = 1
					useHeightMap = False
					vHeightMax = 10000
					Scatters
					{
						Value
						{
							name = boulder
						}
					}
				}
			}
		}
		Debug
		{
			exportMesh = True // Whether Kopernicus should save a .bin file with the ScaledSpace mesh.
			update = False // Setting this to true will force Kopernicus to update the ScaledSpace mesh.
			showSOI = False
		}
	}
}''']
try: mkdir("RandomDres")
except Exception: pass
with open("RandomDres\\patch.cfg", "w") as f:
    f.write('''@Kopernicus:FOR[RandomDres]
{
    !Body[Dres] {}
}
'''+rc(definitions))
