# KerbNoteLite Texture Packs

This folder is for custom UI skins/texture packs.

## Structure

Each skin should be in its own folder with this structure:

```
texture_pack/
├── YourSkinName/
│   └── Textures/
│       ├── Background_window.png
│       ├── NoteWindow.png
│       ├── Button.png
│       ├── ButtonHover.png
│       ├── ButtonClick.png
│       ├── Tab.png
│       ├── TabHover.png
│       ├── TabClick.png
│       ├── TabRed.png
│       ├── Alarm_bar.png
│       └── Alarm_bar_horizontal.png
```

## How to Use

1. Create a folder with your skin name (e.g., `DarkTheme`)
2. Inside, create a `Textures/` folder
3. Place your custom textures there
4. Launch KSP
5. Open KerbNote settings and select your skin

## Included Skins

- **Green** (default) - Classic green theme
- **Blue** - Cool blue theme
- **Orange** - Warm orange theme
- *(Add more as you create them)*

## Creating Custom Skins

- Textures can be any size (will be stretched to fit)
- Recommended: PNG format with transparency
- Base your design on the default textures in `../Textures/`

## Sharing Your Skins

Feel free to share your custom skins on:
- KSP Forums
- GitHub (as a separate mod or texture pack)
- SpaceDock

Credit appreciated but not required! 🎨
