# BodyDragFix

This is a tiny plug-in mod that alters the way KSP calculates body drag to give a slightly less unrealistic result. Minimum drag should be unchanged, but the behaviour for small angles of attack is much more lenient and realistic.

The problem
-----------

KSP uses the drag cube model for estimating drag for most components. It works by estimating the projected area and drag coefficient of a part when viewed from all cardinal directions. Then, during flight, it computes the contributions of each cardinal direction's view to the total drag generated by a drag cube.

Unfortunately, the way it does this is fairly suboptimal. KSP will project the area of any drag cube face into the velocity direction, and simply use this projected area as the reference area for that face in the calculation, and the drag coefficient is kept constant. This results in drag estimations that vary wildly based on the direction a component is viewed from. Even a component as simple as a sphere can increase 70% in drag when facing the airstream in certain directions. This effect can be easily demonstrated using some dumpling tanks in game.

![Some dumpling tanks at different angles](https://github.com/CensoredUsername/BodyDragFix/blob/master/images/Spheres.png)

As most aircraft in KSP have a small frontal surface area but significant top/bottom area, this is especially problematic. Neglecting the front/rear faces, drag from a long object will double at less than 2.5 degrees angle of attack in any direction.

The numbers
-----------

The logic implemented by KSP can be written down as follows:

```
fade = abs(cos(angle_between_forward_and_surface_normal))
if angle_between_forward_and_surface_normal < 90:
    face_drag = A * (Cd_tip * fade + Cd_surface * (1 - fade))
else:
    face_drag = A * (Cd_tail * fade + Cd_surface * (1 - fade))
```

This behaviour results in the following curves:

![A list of drag curves using KSPs face projection implementation](https://github.com/CensoredUsername/BodyDragFix/blob/master/images/KSP_default_behaviour.png)

As can be seen, the drag of a simple cube / sphere varies more than 40% just by spinning it around the pitch axis. The behaviour of drag around a cardinal direction changes sharply, which is very unrealistic.

The fix for this is luckily simple. By squaring the cosine of the angle of attack, a mixing behaviour can be obtained that fixes these problems:

```
fade = squared(cos(angle_between_forward_and_surface_normal))
if angle_between_forward_and_surface_normal < 90:
    face_drag = A * (Cd_tip * fade + Cd_surface * (1 - fade))
else:
    face_drag = A * (Cd_tail * fade + Cd_surface * (1 - fade))
```

This simple change produces the following curves:

![A list of drag curves using the discussed face projection implementation](https://github.com/CensoredUsername/BodyDragFix/blob/master/images/BodyDragFix_behaviour.png)

As can be seen, with these changes the resulting drag curves are far more continuous, and the expected total drag of a unit sphere / cube doesn't change with the angle of attack. This is far more realistic as in reality the pitch angle of a cube causes only a ~7% change in drag coefficient, and for a sphere no change is expected.

The most striking changes are visible for a component which has both its forward face and after face not simulated, like a long fuel tank inbetween a nosecone and an engine.

![A comparison in the resulting drag to angle of attack curves](https://github.com/CensoredUsername/BodyDragFix/blob/master/images/Comparison.png)

With the standard KSP calculation, such a component's drag increases extremely fast when moving away from 0 angle of attack, doubling even at only 2 degrees pitch. In comparison, with this new calculation this only happens after 10 degrees angle of attack. As KSP's wings have extremely gentle lift curves, this means that any variation of lift for manoeuvres would come with significant drag penalties. This behaviour is the reason behind the common wisdom to pitch up your wings in the editor, and purely face prograde while flying.

So if you were already doing this, this mod will offer negligible benefits as it will not change the minimum drag experienced by your aircraft. It will also not not affect the maximum drag generated during a 90 degrees pitch up manoeuvre. But it will significantly lower the experienced drag during turns and gliding flight, resulting in much more realistic and forgiving flying behaviour.

Installation instructions
-------------------------
Simply copy the `GameData/BodyDragFix` folder into your KSP install's `GameData` folder.

Dependencies
------------
You should have [HarmonyKSP](https://github.com/KSPModdingLibs/HarmonyKSP) installed, either via [CKAN](https://github.com/KSP-CKAN/CKAN) or manually.

Incompatibilities
-----------------

None currently known. This mod is compatible with KSP Community Fixes (which rewrites a significant part of the simulation code for performance reasons, so it also patches those). Using this mod together with FAR will not do anything as FAR implements a far more advanced aerodynamic model.
 