# KSRSS as a Secondary System

Fully self-contained duplication of the quarter-scale KSRSS solar system, hosted as a distant secondary star (`Sol`) so the stock Kerbol system remains untouched.

## Feature Highlights
- All planets, dwarf planets, major moons, and notable small bodies from KSRSS reproduced around `Sol` (Mercury → Neptune, Pluto/Charon, Vesta, Ceres, Ryugu, Eros, 67P, Halley, etc.).
- Star `Sol` orbits the stock Sun ~2.5e13 m away, keeping physics safe while preserving stock gameplay.
- No Kronometer, CustomBarnKit, CommNet, launch-site, or DSN changes—this is strictly a content addition.
- All color/normal/height/biome maps, terrain tiles, ring textures, and optional visual assets are internalized under `KSRSS-Secondary` with MIT attribution.
- Optional EVE + Scatterer configs bundled under `Visuals/`; runtime path rewrites ensure they reference local assets only.

## Installation
1. Install **Kopernicus** for KSP 1.12.x (plus its usual dependencies).
2. Copy the `KSRSS-Secondary` folder into your `GameData/`.
3. (Optional visuals) Install **EVE Redux** and/or **Scatterer**, then rename `GameData/KSRSS-Secondary/Optional/Enable-Visuals.cfg.disabled` to `Enable-Visuals.cfg` to opt-in. Delete or re-disable the file to return to stock lighting.


Didn't seem to work on my current save, works on new saves. If it crashes on the first startup try restarting it should be ok after.