# Project Hail Kary Continued

A KSP mod that recreates Andy Weir's "Hail Mary" ship from Project Hail Mary, updated for modern Kerbal Space Program.

## Overview

Project Hail Kary Continued is an updated version of the classic Project Hail Kary mod, now compatible with KSP 1.8.x through 1.12.x. This update rebalances Astrophage for stock delta-V calculations, adds scaleable part families, and introduces additional engines and tanks inspired by Andy Weir's novel "Project Hail Mary".

## Features

- **Astrophage Resource**: Rebalanced density and pricing so stock delta-V tools work without plugins
- **Astrophage Engines**: A complete family of drives powered by Astrophage
  - Mini Astrophage Engine and Booster variant (0.625 m)
  - Astrophage Propulsion System and Booster (2.5 m)
  - Astrophage Heavy Drive (3.75 m)
  - Astrophage Titan Drive (5 m flagship engine)
  - Astrophage Vernor Engine (RCS thruster)
- **Astrophage Fuel Tanks**: Matching tank lineup for every stack size
  - Mini Tank (0.625 m), 1.25 m Tank, 2.5 m Tank, Size 3 (3.75 m) Tank, and 5 m Superheavy Tank
- **Optional TweakScale**: Native configs let every engine and tank scale cleanly with TweakScale if installed

## Installation

1. Extract the contents to your KSP GameData folder
2. Launch KSP and find the new parts in the Propulsion category!

## About the Original Mod

From the original author Janus92:

> "I have just completed building the ship Hail Mary from Mr. Weir's latest novel. The ship in the novel was powered by an alien micro-organism called Astrophage, emitting infrared light at the 25.984 micron frequency. To simulate this I have simply included a transmission module from KSP's interstellar extended mod in my engine module."

## Compatibility

- **KSP Version**: 1.8.0 - 1.12.x
- **Dependencies**: None (stock KSP only)
- **Recommended**: [TweakScale](https://github.com/net-lisias-ksp/TweakScale) for additional sizing flexibility (support patch included)
- **Optional**: Community Tech Tree — if installed, all Astrophage parts are moved to the end‑game node `ultraHighEnergyPhysics` (see `Patches/CTT_UltraHighEnd.cfg`)

## Credits

- **Original Author**: Janus92  
- **Updated by**: enryofalitz aka bryguy4
- **Inspired by**: Andy Weir's "Project Hail Mary"

## License

This work is in the public domain: do what you will and share what you learn!

## Changelog

### Versopm 1.2.0
- added CTT Patch

### Version 1.1.0
- Rebalanced Astrophage resource and engines for sensible thrust, cost, and stock delta-V readouts
- Added new engine variants (Booster, Heavy, Titan, Mini Booster) and matching tank sizes up to 5 m
- Integrated optional TweakScale support for all astrophage parts
- Updated pricing, tech requirements, and metadata

### Version 1.0.0
- Updated for KSP 1.12.x compatibility
- Restructured for modern KSP modding standards
- Fixed compatibility issues with recent KSP versions
- Renamed to "Project Hail Kary Continued"