# Old Parts Revived
OldPartsRevived: An unofficial continuation of the 'OldPartsRedux' and 'Kerbal Historical Institute' mods, made by @TriggeredSnake and @blspblackdeath, respectively.  More parts, more organization, more versions, more nostalgia!

Features over 140 Parts from a decade of Kerbal History. Includes all parts from Squad/zDeprecated and more! Guaranteed to be compatible with KSP 1.12.5 or your money back!
Also features several rare/obscure parts, such as unique models for the Engine Nacelle, Mk1 Inline Cockpit, and more!

Extensive VABOrganizer support! Clear and concise titles! Description support! 100% Localized titles!
Optional PatchManager patches! IVAs included at no additional cost! Easy-to-follow file structure!

See a parts history from Alpha to Beta to 1.0 and beyond.
Relive that sweet, sweet nostalgia. Jump back to 2018, 2015, or even earlier.
Experience KSPs parts like you've never before.

============================================================================================

Changelog:

1.0 (8/12/25)
- Initial release
=========================================================================================

The beginning: Why I started this project
-------------------------------------------------------------------------------------------------------------------------------------------------

(First of all - I am claiming NO OWNERSHIP over anything in this mod. All credit goes to Squad for the models and textures.)
(Assets are distributed under CC-BY-NC-4.0.)

-------------------------------------------------------------------------------------------------------------------------------------------------
Since both OldPartsRedux and Kerbal Historical Institute haven't been updated in *many* years now, I'd figure I'd take a crack at reviving them.
There will be some similarities and differences from the original mods. I'll try and be concise, but no promises.

Many parts added are directly copied from Squad/zDeprecated. These parts are included in every copy of KSP, but are not loaded in by the game.
This mod adds them back in with updated tiles to let you know which version they were from/replaced in.

Any parts added are kept as true as possible to their original stats. Exceptions are on extremely old parts that have no MODULES.

First: A disclaimer on which parts will be included. If a part has a *stats* change, but not a *model* change, then it will _NOT_* be included.
This is to keep part count to a minimum and ensure each added part is unique. (I also *really* don't want to have to add in multiple copies of the exact same part.)
This is the major difference between Revived and Redux/KHI: I only count model updates as an 'Old Part' that needs to be revived.

This prevents there from being 5 or more versions of the same part, each with only slight stat differences.
(Looking at you toroidalAerospike!)

*Some exceptions apply

============================================================================================


The Big Question: How much of this is legal, and what parts from which KSP versions are included?
-------------------------------------------------------------------------------------------------------------------------------------------------

For Alpha parts, I'm using ones mostly copied from the Kerbal Space Program Alpha Archive, found at https://archive.org/details/ksp_archive 
There are also some additional versions found from https://archive.org/details/ksp-archive-0.7.3-0.90.0

The Alpha versions included are:

- 0.7.3
- 0.12
- 0.15.2
- 0.17.1

I'm *pretty* sure these versions are all legally "free", so distributing the parts assets won't be breaking (too) many laws...

============================================================================================

The next few versions required a bit more knowledge on how to acquire them legally. By using the Steam console (steam://open/console), enter "download_depot 220200 220201 "
Then, enter one of the number strings found at https://steamdb.info/depot/220201/manifests/, and you can download versions as far back as 0.19 (when KSP was first added to Steam)

The Steam Depot versions included are:

- 0.20.2
- 0.21.1	
- 0.24.2
- 0.25
- 0.90
- 1.0.2
- 1.0.4

============================================================================================

Lastly, the following full-release versions are officially available from Steam by using the 'Beta Participation' feature in the properties menu.

The Full-Release versions included are:

- 1.0.5
- 1.1.3
- 1.3.1
- 1.4.5
- 1.5.1
- 1.6.1
- 1.7.3
- 1.8.1
- 1.9.1
- 1.10.1
- 1.11.2
- 1.12.1

If you don't see a version, then it's because there were no parts revamped in the version *following* it.
For example, no parts were revamped in KSP 1.3 "Away with words", so there's no need to include any parts from update 1.2 "Loud and clear"

============================================================================================


Organization: What's different from OldPartsRedux/KHI?
-------------------------------------------------------------------------------------------------------------------------------------------------


I had to choose between 2 different eras of parts to add: Do I add in the part from the version it *First Appeared In*, or do I add the part from *Right Before its Revamp*?
I ultimately decided to go with the latter option, as this makes the most sense regarding the deprecated parts. 


For example, the LV-T30 "Reliant" engine (from before 1.12.2) title would be:

changed to:	 LV-T30 "Reliant" (1.12.1)	[the version right before it got revamped]

Instead of:	 LV-T30 "Reliant" (0.18)	[the version where the model was first added]


This is different from OldPartsRedux, which only grabbed parts from arbitrary/nonspecific versions. It also retains the parts original name, unlike KHI.
This helps preserve officially-made stat changes made by developers and helps keep parts as up-to-date as possible, at least until they were revamped/replaced.

============================================================================================


Using and un-hiding Stock parts:
-------------------------------------------------------------------------------------------------------------------------------------------------

Another difference from OldPartsRedux/KHI is the omission of certain parts if they already exist in-game.
This helps reduce the size of the mod a little compared to Redux, while also reducing total parts added (but the total part count is *way* higher anyways)

If you didn't know, in KSP 1.12.5, there are 11 hidden deprecated parts which you can find in the Advanced view mode in the VAB.
This mod un-hides them and updates their names to let you know that they are now 'Classic' parts. The full part list is:

- HighGainAntenna5	= HG-5 Antenna
- liquidEngine		= Reliant
- liquidEngine2		= Swivel
- mk2LanderCabin		= Mk2 Lander Can
- probeCoreHex		= HECS
- rocketNoseCone_v2	= Nose Cone Mk7
- roverBody		= RoveMate
- Size2LFB		= Twin-Boar
- smallRadialEngine	= Twitch
- spotLight1		= Illuminator Mk1
- spotlight2		= Illuminator Mk2

To differentiate these parts from parts that are added by Revived, they have '(Stock)' in their titles.

If you don't want to re-hide these parts as well as other parts added by this mod, there is a patch you can activate via PatchManager.
The patch will set them to 'hidden', but they can still be used for making ships (you'd have to go in the Advanced view to find them)


============================================================================================

VABOrganizer: What's included?
-------------------------------------------------------------------------------------------------------------------------------------------------

Each versions parts included have their own dedicated VABOrganizer subcategory. It starts at 1.12 and goes back to 0.12/earlier, with every part added by this mod being assigned to their respective versions they were taken from. It also adds the 11 un-hidden Stock deprecated parts to these categories to, for ease-of-access.

Every category has a priority of 999, so it *should* always be at the bottom of the part list. This won't conflict with any other mods that also add VABOrganizer subcategories.
A good way to view all categories is clicking in the search bar, and scrolling alllllll the way down. FilterExtensions also works great too!

============================================================================================


Compatibility:
-------------------------------------------------------------------------------------------------------------------------------------------------

DISCLAIMER: The older a part is, the less likely it is to work!

I'll try my best to patch up a parts .CFG file, but there's not much I can do regarding a parts model.mu
Generally, parts from 0.18 and after should be... *"more likely"* to work, as that was when the game was upgraded to Unity 4

If you have any clue on how to fix models, please send me a message!
I have Blender installed on my laptop, but no clue on how to use it at all, besides importing KSP model.mu files and looking at them

-------------------------------------------------------------------------------------------------------------------------------------------------

This is purely a part mod, so it should in theory work with most KSP versions (tested on 1.12.5)

Compatible and tested with:

- VABOrganizer 		: Parts will be assigned to various version-specific subcategories, located at the very bottom
- FilterExtensions	: Easily view all added parts, also works well with the stock Advanced view!
- PatchManager 		: Choose to enable/disable hiding of parts, and change stats of certain parts
- Stock 		: Un-hides the 11 hidden deprecated parts in KSP 1.12.5 with updated titles/descriptions


Highly Recommended Mods:
-------------------------------------------------------------------------------------------------------------------------------------------------

- Part Info in PAW	: This will let you see a parts ID so you can tell if it's a Stock part or not, and open its CFG file (EXTREMELY USEFUL PLEASE DOWNLOAD)
- Janitors Closet	: Lets you filter between parts added in the mod and Stock ones, in case you get confused
- Node Helper		: Some nodes on parts may be a little wonky. You can try fixing any broken nodes that I may have missed


Known Issues:
============================================================================================

Here's some of the bugs I know about, and currently have ABSOLUTELY NO CLUE on how to fix. Feel free to DM me if you have ideas!

- Some nodes, especially on the older parts, may be slightly off. They should at least face the right direction
- The small landing gear from 1.0.5 has no suspension/isn't really a 'wheel' at all
- The landing legs from 0.21 have no audio when extending/retracting
- The RCS Block from 0.17 has no audio when running, and the plumes are inverted 180 degrees
- Some of the exhausts for the 0.17 engines are offset a little too far
- The Stack Tricouplers from 0.17 and 0.7.3 are rotated wrong
- The 0.7.3 Stack Tricoupler from 0.7.3 has a very messed up texture

(Emphasis on the NO CLUE part - I really tried everything I knew and couldn't fix these problems!)

============================================================================================

Assets used:
-------------------------------------------------------------------------------------------------------------------------------------------------

Remember earlier when I said I would try and stay as close as possible to a part's original stats? This is true... but unfortunatly I couldn't re-use *every* parts original model.
Because of KSPs journey throughout Unity, some of the older parts simply do not work anymore in the current Unity version (2019.4.18f1 LTS).

Believe me, I tried using them, and it would either instantly explode the rocket or send you flying at speeds exceeding 1C. Not ideal.


Now, to fix this problem, I had to either:
-------------------------------------------------------------------------------------------------------------------------------------------------
1. Spend several days (or weeks) on Blender and Unity tutorial courses to teach myself how to convert 14 year old .DAE models to modern KSP .mu standards...
 
or

2. Shamelessly steal models from mods that already had working models (in this case - Kerbal Historical Institute)
-------------------------------------------------------------------------------------------------------------------------------------------------

Because I am Lazy™ I went with the latter option.

ALL credit goes to the original authors of the KHI mod for the following parts:

All parts from 0.12/Earlier
All parts from 0.15
Most parts from 0.17. If a part has a folder called 'OldFiles' in it's part directory, then that part's model was taken from KHI.

============================================================================================

Credits and Thanks:
============================================================================================

- @TriggeredSnake, for making the original OldPartsRedux mod.
- @blspblackdeath, for making the Kerbal Historical Institute mod and for providing models for pre-0.18 parts

- The KSP Wiki, for recording which versions these parts were revamped.
- Archive.org, for preserving these important versions of Kerbal history.

- Steam, for letting me download older version of KSP in the first place (Which not every platform allows! Looking at you Epic Games/GOG)
- SteamDB, for allowing me to access versions of KSP before 1.0.5. (Even if I had to go through extra effort to access pre-1.0 versions)

- Squad and all the KSP Devs, for making these wonderful models and textures so I can ~~steal~~ *preserve* them.
- HarvesteR, Mrbrownce, NovaSilisko, C. Jenkins, and Porkjet for modelling like 99% of these parts.

- You! For making it to the end of the README. I hope this wasn't too confusing to read lol.

-munktron239
