# 1.5.6
- Added Russian localization (contributed by @Bimo1D)
- Fixed pyrotechnic ignitor description
# 1.5.5
- Added LqdCO-burning option to LOX-augmented NTRs in Chemical Propulsion Nuclear
- Added Diborane option to thermal rockets when using both Chemical Propulsion Exotics and Chemical Propulsion Nuclear
- Added compatibility patches for the following mods:
  - SXT Continued
  - Mk2 Expansion
  - Mk3 Expansion
  - SMURFF
  - Skyhawk Science System (contributed by @Arofire)
- Added descriptions to switcher subtypes
- Changed EVA propulsion to use Nitrogen
- Changed extras patch ordering so they work no matter where they are installed
- Buffed isp for various hypergolic RCS parts which still had default MonoPropellant isp
- Nerfed Chemical Propulsion Nuclear alternate NTR propellant Isp
- Removed erroneous change to Cryogenic Engines' CE-60 'Tharsis' engine
- Fixed incompatibility with Rational Resources Kerbalism
# 1.5.4
- Updated to Ignition 1.2.2
- Added hypergolic ignitor options to ethalox engines
- Added support for NTRs which consume LqdHydrogen and EnrichedUranium
- Removed fixed pyrotechnic ignitor when using a chemical ignitor fluid. Choose one or the other
- Fixed Chemical Propulsion Nuclear assigning inert propellants to lox-augmented NTRs which should only have combustible fuel options
# 1.5.3
- Updated to Chemical Core 1.4.2
- Updated to Ignition 1.2.1.2
- Added Waterfall plume to hydrolox mode of Near Future Launch Vehicles KR-701 'Cougar' and KR-74 'Lynx' multimode bipropellant-tripropellant engines
- Changed Near Future Aeronautics' multimodal jet-rocket engines to have proper hydrolox isp
- Adjusted the isp curve of T-1 Toroidal Aerospike "Dart" and bipropellant mode of CR-7 R.A.P.I.E.R. to give improved performance in thicker atmospheres
# 1.5.2.2
- Fixed Tundra Exploration compatibility
# 1.5.2.1
- Fixed Procedural Parts SRB
# 1.5.2
- Consolidated LqdMethane and LqdAmmonia assignment, which should hopefully give a more consistent experience depending on whether using-mods are present
- Added missing mod-triggered propellant assignment to "storable" tank type
- Added "none" ignitor fluid subtype
- Changed Missing History's LV-T15 "Valiant" and LV-303 "Pug" to kerolox and hypergolic propellants respectively, bringing them in line with the ReStockPlus equivalents
- Changed Near Future Aeronautics' multimodal jet-rocket engines to use LqdHydrogen instead of Kerosene
- Fixed hypergolic RCS integrated fuel cell converter name
- Fixed ignitor resource assignment patch ordering
  - Fixes automatically assigned propellants in particular, which previously did not have the proper ignitors assigned
- Fixed certain ignitor fluids being assigned to unintended types of engine
- Fixed electric ignitor not being assigned to lox-augmented mode of multimode NTRs
# 1.5.1
- Updated to Chemical Core 1.4.1
- Updated to Ignition 1.2.1
- Added Simplified Chinese localization (contributed by @Aebestach)
- Added explicit compatibility patches for the following mods:
  - Internal RCS
  - Moldavite Machines (contributed by @Aebestach)
  - Near Future Construction
  - Rocket Motor Menagerie
  - Space Dust (removes stock propellants from all scanners, telescopes and harvesters)
    - Space Dust Next is essentially required for playability
  - Ursa (Crew pod and spaceship parts)
- Added more detailed stats and propellant types to propellant part upgrade descriptions:
  - Storable = Can be stored in a conventional tank
  - Cryogenic = Requires CryoTanks cooling
  - Exotic = Unconventional, dangerous. Right now this basically just means *expensive*
  - Hypergolic = Hypergolic with other hypergolic propellants
  - Super-hypergolic = Hypergolic with everything
- Added Aniline subtype to Near Future Exploration tanks
- Added a few common bipropellant mixtures to tanks from the following mods:
  - Near Future Exploration
  - Procedural Parts
  - Universal Storage II Finalized
- Added `storable` tank type for all non-cryogenic single propellants (currently only used by Chemical Storage)
- Added VABOrganizer subcategories for Chemical Propulsion tank types, which should make it more obvious when a tank is not properly supported:
  - Bipropellant
  - Storable Propellant
  - Cryogenic Propellant
  - Aviation Fuel
  - Monopropellant
- Added CryoTanks boiloff for LqdCO2 and LqdNitrogen
- Added support for exotic propellants (Pentaborane, Diborane, LqdFluorine, N2F4) in Procedural Parts tanks
- Added more robust fuel cell patch which should catch and properly convert most cases
  - Fixes Near Future Launch Vehicles RCS integrated fuel cells
- Reduced CryoTanks cooling cost to 50% default on cryogenic tanks
- Changed ignitors for certain bipropellant mixtures:
  - Aniline/Hydrazine with a non-hypergolic oxidizer requires Nitric acid/NTO ignitor (switchable)
  - Nitric acid/NTO with a non-hypergolic fuel requires Aniline/Hydrazine ignitor (switchable)
  - Fixed ignitor removed from hypergolic engines
  - Electric ignitor removed from ethalox engines
- Changed default catch-all bipropellant type for not-explicitly-supported engines to kerolox
- Changed PBAN and early SRBs to starting technology since this is too much of a compatibility headache otherwise
- Consolidated patch ordering into coherent stages (see README)
- Consolidated switch subtype ordering to avoid issues with tech restrictions
- Moved non-stock-configured propellant tagging outside of core patches so these options won't show up in sandbox mode
- Made some minor improvements to VABOrganizer subcategory assignment
- Removed alternate hypergolic options from engines with default aniline and/or nitric acid (affects a few engines from Taerobee and Tantares)
- Removed Ethanol, Aniline, LqdAmmonia, LqdMethane and IWFNA propellant subtypes from Universal Storage II Finalized tank switches since they don't appear in the "stock" configuration of Chemical Propulsion
- Fixed "Keroxide" part title replacement overriding "Kerolox"
- Fixed Near Future Launch Vehicles' monopropellant RCS being wrongly assigned hypergolics
- Fixed Chemical Propulsion Nuclear wrongly targeting non-nuclear thermal engines
- Fixed Chemical Propulsion Nuclear improperly assigning tank tags
- Fixed Near Future Exploration tank switch subtype masses
- Fixed exotic propellants not appearing in cryogenic tanks
# 1.5.0
- Updated to Chemical Core 1.4.0
- Updated to Ignition 1.1.4
- Added Aniline as a basic hypergolic fuel to pair with nitric acid
- Added Taerobee compatibility
- Added extras:
  - Chemical Propulsion Keroxide: Adds HTP oxidizer option to all kerolox engines
  - Chemical Propulsion Hypergolics: Adds Aniline and IWFNA as lower-tech alternatives to Hydrazine and NTO respectively in all hypergolic engines
  - Chemical Propulsion Nuclear: Adds Water, LqdCO2, LqdCO and LqdNitrogen options to all cryogenic tanks and non-LOX-augmented NTRs
- Moved tank subtype handling from extras to main patches to support third party activation
- Changed configuration of former-keroxide stock and ReStock+ engines:
  - LV-T30 "Reliant"
    - Keroxide → Kerolox
    - Isp: 265-310s → 260-295s
  - LV-T45 "Swivel"
    - Keroxide → Kerolox
    - Isp: 250-320s → 220-315s
	- Thrust: 215kN → 150kN
  - LV-T15 'Valiant'
    - Keroxide → Kerolox
  - LV-303 'Pug'
    - Keroxide → Hypergolic
- Changed propellant subtype ordering from LqdAmmonia > LqdMethane > LqdHydrogen to LqdHydrogen > LqdMethane > LqdAmmonia
- Changed oxidizer subtype ordering from IWFNA > NTO to NTO > IWFNA
- Changed Procedural Parts SRB tech level to "Basic Rocketry"
- Slightly nerfed LqdMethane and LqdAmmonia thrust when used in thermal rockets
- Deactivated IWFNA (nitric acid), LqdMethane and LqdAmmonia subtypes when there is no using mod present
- Fixed LOX-augmented NTR propellant switches
- Fixed Kerbal Atomics `MultiModeEngine` patch interfering with NTR propellant assignment
- Fixed Chemical Propulsion Exotics assignment of Pentaborane option to Kerosene jet engines
- Fixed Near Future Launch Vehicles' bipropellant RCS to use NTO as the default oxidizer for stats computation
# 1.4.0.2
- Actually fixed Universal Storage II Finalized compatibility
# 1.4.0.1
- Fixed Universal Storage II Finalized compatibility
# 1.4.0
- Added part upgrade activation system which keeps part upgrades and associated switch subtypes hidden if unused
- Added Extras/ChemicalPropulsionExotics, absorbed from now-deprecated Chemical Exotics
- Added hypergolic propellant options to Alcoholic Aeronautics engines
- Added bespoke compatibility patches for the following mods:
  - CRE (Commonwealth Rockets)
  - BlueSteel (Commonwealth Aeronautics)
- Updated to Chemical Core 1.3.0
- Updated to Ignition 1.1.3
- Improved VABOrganizer subtype assignment
- Improved part title replacement
- Improved propellant subtype priority ordering
- Improved patching of engines and RCS using SolidFuel
  - Fixes Near Future Propulsion's KO-1 Pulsed Plasma RCS Thruster
- Improved various aspects of tank patching
  - Fixes lack of tanks on parts with air intakes or electric charge
  - Fixes lack of "none" type on tanks with an unrelated engine, e.g. the FL-C1000
- Changed propellant tagging system to use separate `chemTechPropellant`, `chemTechFuel` and `chemTechOxidizer` fields
  - Fixes various propellant subtype ordering issues causing the wrong propellant to be selected to represent the default stats of engines and RCS
- Changed aviation fuel tanks to only contain jet fuels (Kerosene, LqdHydrogen, Kerosene)
- Changed configuration of some stock engines:
  - RE-M3 "Mainsail"
    - Isp: 285-310s → 300-330s
  - Mk-55 "Thud"
    - Kerosene-HTP → Kerolox
  - LV-1 "Ant", LV-1R "Spider", 48-7S "Spark", 24-77 "Twitch"
    - Kerosene-HTP → Hypergolic
  - LV-909 "Terrier"
    - Kerolox → Hypergolic
	- Isp 85-345s → 85-315s
  - RE-I5 "Skipper"
    - Kerolox → Hydrolox
    - Isp: 280-320s → 350-445s
	- Thrust: 650kN → 325kN
  - CR-7 R.A.P.I.E.R.
    - Air-breathing:
      - Kerosene → LqdHydrogen
	  - Isp: 3200s → 3600s
	- Closed-cycle:
	  - Kerolox → Hydrolox
	  - Isp: 275-305s → 350-460s
- Changed Labradoodle's RE-L20 "Labrador" from hypergolic to kerolox
- Changed tech tree position for Making History's RK-7 "Kodiak" / ReStockPlus' RK-107 'Ursa' from Heavy Rocketry to Advanced Rocketry
- Changed default propellant for Supplementary Electric Engines' electrothermal engines to Hydrazine
# 1.3.1
- Improved Firespitter engine patch
- Added support for Breaking Ground's `ModuleRoboticServoRotor`
# 1.3.0
- Updated to Chemical Core 1.2.0
- Updated to Ignition 1.1.2
- Added IWFNA (Nitric acid) as a basic hypergolic oxidizer
- Added bespoke compatibility patches for the following mods:
  - Firespitter (with contributions from Ari Lana @ratemisia)
  - Grounded - Modular Vehicles (with contributions from Ari Lana @ratemisia)
  - Kerbalism
  - Knes
  - Procedural Parts
  - Tantares
  - TantaresLV
  - TantaresSP
  - Universal Storage II Finalized
  - UnKerballed Start
- Added compatibility patches to find and replace fuel tank switches from the following mods:
  - B9PartSwitch
  - Configurable Containers
  - Firespitter
  - Modular Fuel Tanks
- Added tank mass offset computation
- Changed the positions of some propellant part upgrades in the tech tree to fit with new design supporting more mods:
  - Hydrazine: Advanced Rocketry → General Rocketry
  - Kerosene: General Rocketry → Start
  - NTO: Advanced Rocketry → Propulsion Systems
- Changed oxidizer used in OCRAP engines from NTO to IWFNA
- Changed MonoPropellant fuel cells to use Hydrazine
- Increased thrust and/or isp of stock and Making History SRBs
- Fixed hidden parts appearing due to VABOrganizer subcategory assignment
# 1.2.2
- Fixed Alcoholic Aeronautics compatibility
# 1.2.1
- Added bespoke compatibility patches for the following mods:
  - Kerbal Reusability Expansion
  - Shuttle Orbiter Construction Kit
  - Tundra Exploration
- Changed RCS and tanks on Near Future Spacecraft's Amalthea, Tethys and Nereid command pods to use hypergolic bipropellant rather than monopropellant. Note that the latter two are soft-deprecated as of Near Future Spacecraft 1.4.6.
- Improved targeting of B9PartSwitch tanks to find various kinds of tanks using CryoTanks subtypes and convert them to Ignition tanks
- Fixed the single fixed ignitor added to every bipropellant engine
- Fixed SystemHeat compatibility
- Fixed Chemical Storage compatibility
# 1.2.0
- Added Ethanol as a supported fuel and Ethanol/LqdOxygen as a supported bipropellant type
- Added Alcoholic Aeronautics support (recommended for ethalox start)
- Added one fixed ignitor to every bipropellant engine, so they can always be started at least once on the launch pad
- Added handling of multiple tanks with separate volumes on the same part, fixes e.g. Near Future Spacecraft's service tanks
- Updated to Chemical Core 1.1.0
- Updated to Ignition 1.1.1
- Changed the tech progression of various early engines and tanks to align with ethalox start
- Changed Kerosene and TEATEB part upgrade descriptions
- Changed monopropellant engines to use hypergolic propellants Hydrazine/NTO, since they are broadly based on real hypergolic engines:
  - Stock:
    - O-10 "Puff" ~~MonoPropellant Fuel~~ Hypergolic Engine
  - Near Future Spacecraft:
    - 64-8S 'Chickadee' Landing Engine
    - 96-8S 'Hummingbird' Landing Engine
	- LV-601 Orbital Maneuvering Engine
	- LV-601-4 Orbital Maneuvering Engine Cluster
	- LV-95 Orbital Maneuvering Engine
	- LV-95-6 Orbital Maneuvering Engine Cluster
- Reordered part switch subtypes to match the order of the corresponding part upgrades in the tech tree
- Removed Ignition propellant module for IntakeAir
- Improved patch which removed PROPELLANT modules using Chemical Technologies resources by ensuring it only does so when the specific resource is handled by an Ignition module.
- Fixed jet engine propellant ratio
- Fixed subtype tech restrictions on tanks with a "none" subtype
- Fixed Mk-33 linear aerospike multimode engine
# 1.1.0
- Added single-propellant configs for Hydrazine and HTP, used in monopropellant and thermal rockets
- Added support for Near Future Launch Vehicle's switchable tank volumes
- Added support for Near Future Exploration's switchable tanks
- Updated to Ignition 1.1.0
  - Added explicit propellant removal patch
  - Removed IntakeAir propellant modules
  - Added fixed ignitor to Kerosene-NTO engines
- Reordered patches and changed tagging system to use individual propellants rather than combined types to allow any arbitrary combinations and thus better third-party mod support
  - Added support for Supplementary Electric Engines
  - Added support for OCRAP
- Changed LqdAmmonia tech level to "Basic Rocketry", since it has broad applications and can serve as a basic rocket fuel
- Changed NTO tech level to "Advanced Rocketry", since it can serve as an oxidizer before hypergolics are researched
- Changed bipropellant RCS to use Hydrazine/NTO
- Changed Near Future Spacecraft monopropellant engines to use Hydrazine/NTO
- Changed 'Baguette', 'Dumpling' and 'Doughnut' stock small external tanks to single-propellant cryogenic tanks
- Minor adjustments to switch subtype ordering
- Fixed solid rocket VABOrganizer subcategory assignment overwriting an existing subcategory
- Fixed fuel-air ratio for multi mode jet engines
- Fixed behaviour of B9 togglable tanks controlled via `ModuleIgnitionTankController`
- Fixed tank type assignment for built-in RCS tanks (e.g. on command pods)
# 1.0.2
- Fixed propellant ratio parsing for jet engines
- Improved behaviour of implicit engine type assignment
# 1.0.1
- Fixed Rhino Isp curve
- Fixed Kerosene ignition potential
- Fixed removal of tech restriction from default subtype on propellant switches with a "none" subtype
- Changed LqdOxygen and TEATEB (thus kerolox) to unlock at "General Rocketry" and made a few adjustments to part tech requirements to accomodate
# 1.0.0
- Release
- Updated to Ignition 1.0.0
  - Added `ModuleIgnitionEngineController`, `ModuleIgnitionRCSController` and `ModuleIgnitionTankController` where applicable
- Added PBAN and HTPB options to solid rockets, which are now fully supported
- Improved engine controller module tagging, which should mean much broader implicit support of some trickier multi mode engines
- Removed "none" option from monopropellant switch on parts with RCS modules
# 0.6.0
- Updated to Ignition 0.3.0 (formerly FuelMixer)
- Added ignition systems to bipropellant engines
  - Kerolox requires TEATEB
  - Ammonilox, methalox, hydrolox and jet engines require ElectricCharge
  - All other types require no ignitor
- Added TEATEB option to monopropellant tanks (This is intended to be temporary, bespoke TEATEB tanks will be added in the future)
- Removed exotic propellants (Diborane, Pentaborane, LqdFluorine, N2F4) which are now implemented solely by Chemical Exotics
# 0.5.1
- Added a last-ditch compatibility patch which replaces LiquidFuel and MonoPropellant in unpatched engines with Hydrazine... I imagine this will have unintended consequences but I haven't run into any yet
- Realigned MissingHistory's "Pug" and "Valiant" engines to have identical stats with their Restock+ counterparts
- Fixed assignment of tank volume and mass for built-in tanks on engines
- Fixed assignment of jet engine VABOrganizer category on multimode engines
- Fixed compatibility with many kinds of engines which were erroneously targeted due to containing targeted propellants alongside additional propellants
- Fixed patch ordering of generic engine type assignment, which further improves mod compatibility
# 0.5.0
- Updated FuelMixer to 0.2.0
- Added jet engine FuelMixer integration
- Added N2F4 as an exotic advanced oxidizer in hypergolic engines
- Added part upgrades for propellant unlocks
- Added more verbose propellant descriptions
- Added patch to remove KerbalAtomics' LF mode on the LV-N "Nerv"
- Added proper support for `MultiModeEngine`s via the creation of extra `ModuleFuelMixerPropellant`s
- Added `FuelMixerPropellantCombinationConfig`s for single-propellant nuclear thermal rockets and added a switch for them to all NTRs:
  - LqdHydrogen: `ThrustMultiplier 0.3; IspMultiplier 2.4`, c.f. hydrolox `~0.765; ~1.355`
  - LqdMethane: `ThrustMultiplier 0.45; IspMultiplier 1.8`, c.f. methalox `~0.964; ~1.083`
  - LqdAmmonia: `ThrustMultiplier 0.6; IspMultiplier 1.2`, c.f. ammonilox `~0.931; ~0.978`
- Added "None" option to tank propellant switches so that bipropellant tanks can contain just the fuel or just the oxidizer. Tank mass defaults to stock dry mass if both are set to "None"
- Added LqdFluorine to aviation tanks
- Added explicit `addedVolume` and `addedMass` parameters to all `ModuleFuelMixerPropellant`s
- Improved generation of `ModuleB9PartSwitch` propellant switches, so they should be more reliable
- Changed fuel mixtures available on liquid fuel engine types:
  - Monopropellant: HTP—Hydrazine
  - Keroxide: Kerosene / HTP
  - Hypergolic: Hydrazine—Pentaborane / NTO-N2F4
  - Ammonilox: LqdAmmonia / LqdOxygen-LqdFluorine (currently unassigned, but can be used in NTRs with an oxidizer-augmented mode)
  - Kerolox: Kerosene / LqdOxygen—LqdFluorine
  - Methalox: LqdMethane—Diborane / LqdOxygen—LqdFluorine
  - Hydrolox: LqdHydrogen / LqdOxygen—LqdFluorine
- Changed two engines from kerolox to hypergolic type, since there were not many hypergolic engines assigned after the introduction of keroxide:
  - LV-TX87 "Bobcat" (Making History), since it's based on the LR-87 which was used with hypergolic propellants for most of its history
  - RE-L20 "Labrador" (Labradoodle), since it kind of looks like an RD-170 and same as above
- Assigned keroxide type to basic stock and Restock+ liquid fuel engines:
  - LV-1R "Spider"
  - 24-77 "Twitch"
  - Mk-55 "Thud"
  - LV-1 "Ant"
  - 48-7S "Spark"
  - LV-T30 "Reliant"
  - LV-T45 "Swivel"
  - LV-303 "Pug"
  - LV-T15 "Valiant"
- Assigned hydrogen type to engines which are already defined with LqdHydrogen as sole propellant
- Buffed exotic propellant isp multipliers:
  - Pentaborane: 1.14 → 1.55
  - LqdFluorine: 1.12 → 1.2
- Minor adjustment to jet engine propellant ratios to maintain exactly the same IntakeAir and mass flow rates as stock
- Minor changes to part titles and VABOrganizer category titles
- Removed LqdAmmonia as a hypergolic fuel option
- Removed bipropellant `FuelMixerPropellantCombinationConfig`s since they are made redundant by rebalanced `FuelMixerPropellantConfig`s
# 0.4.1
- Changed multimode engines to use FuelMixer, though currently without any propellant switcher (though FuelMixer can support this).
- Added support for stock multimode engines
- Added support for Near Future Aeronautics multimode engines
- Added support for Kerbal Atomics multimode engines
- Added support for WildBlueIndustries Mk-33
- Added `hydrogenJet` engine type
- Fixed tanks with built-in engines using a different propellant, e.g. bipropellant tanks with solid fuel separators
- Fixed FuelMixer default propellant assignment for monopropellant engines and multi-type engines, e.g. bipropellant RCS (kerolox, methalox and hydrolox)
- Fixed B9PartSwitch togglable integrated tanks on engines, which should now apply their volume to FuelMixer
# 0.4.0
- Renamed from "Immersive Chemical Propulsion" to "Chemical Propulsion"
- Rewrote a good chunk of the patches using new FuelMixer plugin (0.1.0) to handle monopropellant and bipropellant fuel tanks, engines and RCS
- Changed fuel mixtures available on bipropellant engine types:
  - Monopropellant: HTP—Hydrazine
  - Hypergolic: LqdAmmonia—Hydrazine—Pentaborane / NTO
  - Kerolox: Kerosene / HTP—LqdOxygen—LqdFluorine
  - Methalox: LqdMethane—Diborane / LqdOxygen—LqdFluorine
  - Hydrolox: LqdHydrogen / LqdOxygen—LqdFluorine
- Changed fuel cells to only use LqdHydrogen+LqdOxygen and ISRU to only deal with LqdHydrogen, LqdOxygen, LqdMethane and HTP in order to balance the more effective propellants by the lack of ISRU, and in preparation for Chemical Conversion which will handle all of this more comprehensively
- Various tidying of code and small fixes
# 0.3.0
- Introduced HTP as a basic monopropellant and Kerosene/HTP as a basic hypergolic bipropellant
- Added switches to engines, tanks, RCS for a pair of "basic" and "advanced" (higher Isp, more expensive) propellants for the five liquid engine types:
  - Monopropellant: HTP — Hydrazine
  - Hypergolic: Kerosene/HTP — Hydrazine/NTO
  - Kerolox: Kerosene/LqdOxygen — Pentaborane/LqdFluorine
  - Methalox: LqdMethane/LqdOxygen — Diborane/LqdFluorine
  - Hydrolox: LqdHydrogen/LqdOxygen — LqdHydrogen/LqdFluorine
- Removed Hydrazine and NTO recipes from ISRU in favour of a consistency (only basic propellants allowed)
- Changed everything to use Immersive Chemical Core 0.3.0 common resource colours
- Added common propellant ratios used throughout all patches
- Restored original stats for the LV-T30 "Reliant" and the LV-T45 "Swivel", since the lower-Isp constraint on low tech engines is now handled by the use of Kerosene/HTP (note that no tech restrictions actually exist yet)
- Balanced Restock+'s Pug against other hypergolic engines:
  - LV-303 'Pug' Liquid Fuel Engine [250-330 → 220-310s]
- Fixed stats of Near Future Launch Vehicles's Rutherford analogues to reflect their real performance and balanced them with the other kerolox engines:
  - KS-1E 'Goldfish' Liquid Fuel Engine [270-280s → 270-310s]
  - KR-1E-V 'Angora' Liquid Fuel Engine [250-320 → 220-340s]
# 0.2.0
- Added generic targeting of integrated fuel tanks on boosters using the engine propellant type
- Added native fuel tank switch for more control. Replaces existing switches, so removes the dependency on CryoTanks
- Added native RCS bipropellant switch for more control. Replaces existing switches, e.g. the one provided by Near Future Launch Vehicles
- Added support for Near Future Aeronautics aviation fuel tanks
- Added support for VABOrganizer, with new categories for different types of engine and RCS. This adds subcategorisation to many parts which didn't already have any, including tanks
- Added flags for Immersive Chemical Core 0.2.0 CryoTanks boiloff system, which should ensure all cryogenic fuels are given boiloff configs no matter where the are stored
- Fixed tank type patch ordering
- Fixed Pentaborane/LqdFluorine B9 tank type mass and cost (exotics coming soon)
# 0.1.3
- Improved propellant type assignment targeting, should fix some odd cases where copies of parts inherit the wrong propellant type
- Changed engine name replacement to use terms which characterise the propellant combination: "Kerolox", "Methalox" and "Hydrolox"
- Moved hydrolox options behind methalox in tanks and other places, so that they're broadly ordered by specific impulse (Hypergolic < Kerolox < Methalox < Hydrolox)
- Add descriptions to propellant combinations, only used in RCS switches at the moment
- Added MissingHistory support:
  - LV-303 "Pug": Hypergolic, stats unchanged
  - LV-T15 "Valiant": Hypergolic, stats unchanged
  - Other engines handled automatically
- Added Labradoodle support:
  - RE-L20 "Labrador": Kerolox, stats unchanged
# 0.1.2
- Fixed catch-all engine type patch which converts all not-directly-supported engines into Hydrazine/NTO
- Added simple regex which replaces "Liquid Fuel" in engine titles with "Hypergolic", "Kerosene", "Liquid Hydrogen", "Liquid Methane" or "Kero-Hydro-Lox" (ideally this would hook into localisation, but only supports English for now)
- Replaced MonoPropellant with Hydrazine in tanks contained in B9 part switches, e.g. the integrated tanks on the orbital maneuvering engines from Near Future Spacecraft
# 0.1.1
- Fixed patches targeting presence of MakingHistory with ModuleManager NEEDS
- Changed Kerbodyne KR-2L+ "Rhino" to use LqdHydrogen/LqdOxygen since it makes a good Aerojet M-1 analogue, which is seemingly how Restock treats it, with performance balanced accordingly:
  - 1750kN, 310-430s
- Balanced hydrolox engines:
  - Making History RE-I2 "Skiff" / Restock+ RE-I2 'Caravel': 300/510kN → 31kN, 1.6/2t → 1.4t (30% thrust scaled J-2 analogue)
  - S3 KS-25 "Vector": 1000kN → 675kN, 4t → 3t (30% thrust scaled RS-25 analogue)
  - S3 KS-25x4 "Mammoth": 4000kN → 2700kN, 15t → 12t (4x S3 KS-25 "Vector")
  - CryoEngines CE-60 'Tharsis': 360kN → 320kN, 3t → 2.4t (2x CE-60 'Pavonis')
  - Restock+ KR-10A 'Corgi': 750kN → 220kN, 5.25t → 2.2t (4x CryoEngines CE-10 'Hecate')
- Balanced hypergolic engines:
  - LV-T30 "Reliant": Vacuum 310s → 300s (Minor adjustment to balance against other hypergolic engines)
  - LV-T45 "Swivel": Vacuum 320s → 310s (Minor adjustment to balance against other hypergolic engines)
  - RE-J10 "Wolfhound": 375kN → 110kN, 3.3t → 0.8t (Restock+ RE-137 'Schnauzer' stats, which are much more sensible)
# 0.1.0
- Pre-release
- Add B9 tank types for new propellant combinations with mixture ratios designed to fit nicely in tanks while keeping in line with reality:
  - Bipropellants:
    - 2 Hydrazine / 3 NTO
    - 3 Kerosene / 5 LqdOxygen
    - 3 LqdHydrogen / 1 LqdOxygen
    - 7 LqdMethane / 9 LqdOxygen
    - 3 Pentaborane / 7 LqdFluorine
    - 3 LqdHydrogen / 1 LqdFluorine
  - Tripropellants:
    - 1 Kerosene / 4 LqdHydrogen / 3 LqdOxygen (equivalent to 1/3 kerolox + 2/3 hydrolox)
- Changed LiquidFuel-only fuel tanks to Kerosene.
- Changed MonoPropellant fuel tanks to Hydrazine.
- Changed engines to use new fuel types:
  - All jet LiquidFuel/IntakeAir → Kerosene/IntakeAir
  - All nuclear LiquidFuel → LqdHydrogen
  - All MonoPropellant → Hydrazine
  - All LqdHydrogen/Oxidizer → LqdHydrogen/LqdOxygen
  - All LqdMethane/Oxidizer → LqdMethane/LqdOxygen
  - LiquidFuel/Oxidizer depends on the engine and mostly follows the real-life inspirations where applicable, some of which have corresponding changes to Isp for realism and balance:
    - Stock:
      - Hydrazine/NTO
        - LV-1R "Spider" Liquid Fuel Engine
        - 24-77 "Twitch" Liquid Fuel Engine
        - Mk-55 "Thud" Liquid Fuel Engine
        - LV-1 "Ant" Liquid Fuel Engine
        - 48-7S "Spark" Liquid Fuel Engine
        - LV-T30 "Reliant" Liquid Fuel Engine
        - LV-T45 "Swivel" Liquid Fuel Engine
      - Kerosene/LqdOxygen
        - LV-909 "Terrier" Liquid Fuel Engine
        - RE-I5 "Skipper" Liquid Fuel Engine
        - RE-M3 "Mainsail" Liquid Fuel Engine
        - LFB KR-1x2 "Twin-Boar" Liquid Fuel Engine
        - Kerbodyne KR-2L+ "Rhino" Liquid Fuel Engine
      - LqdHydrogen/LqdOxygen
        - S3 KS-25 "Vector" Liquid Fuel Engine [295-315s → 365-450s]
        - T-1 Toroidal Aerospike "Dart" Liquid Fuel Engine [290-340s → 380-430s]
        - RE-L10 "Poodle" Liquid Fuel Engine [90-350s → 180-460s]
        - S3 KS-25x4 "Mammoth" Liquid Fuel Engine [295-315s → 365-450s]
    - Making History:
      - Hydrazine/NTO
        - LV-T91 "Cheetah" Liquid Fuel Engine [150-355s → 150-315s]
        - RE-J10 "Wolfhound" Liquid Fuel Engine [70-380s → 70-330s]
      - Kerosene/LqdOxygen
        - RV-1 "Cub" Vernier Engine
        - RK-7 "Kodiak" Liquid Fueled Engine [285-300s → 285-320s]
        - LV-TX87 "Bobcat" Liquid Fuel Engine
        - Kerbodyne KE-1 "Mastodon" Liquid Fuel Engine
      - LqdHydrogen/LqdOxygen
        - RE-I2 "Skiff" Liquid Fuel Engine [265-330s → 200-420s]
    - Restock+:
      - Hydrazine/NTO
        - LV-303 'Pug' Liquid Fuel Engine
        - LV-T15 'Valiant' Liquid Fuel Engine
        - RK-1 'Trash Panda' Vernier Engine
        - RE-137 'Schnauzer' Liquid Fuel Engine [70-350s → 70-330s]
      - Kerosene/LqdOxygen
        - KR-1 'Boar' Liquid Fuel Engine
        - Mk-1H 'Torch' Liquid Fuel Engine
        - RK-107 'Ursa' Liquid Fueled Engine [285-300s → 285-320s]
        - Kerbodyne UR-1 "Galleon"" Liquid Fuel Engine
      - LqdHydrogen/LqdOxygen
        - RE-I2 'Caravel' Liquid Fuel Engine [265-320s → 200-420s]
        - KR-10A 'Corgi' Liquid Fuel Engine Cluster [95-355s → 110-465s]
    - Near Future Launch Vehicles:
      - Kerosene/LqdOxygen
        - KS-10AJ 'Walrus' Liquid Fuel Engine
        - KS-600AJ 'Manatee' Liquid Fuel Engine
        - KS-1M 'Otter' Liquid Fuel Engine [280-295s → 280-310s]
        - KR-1M-V 'Sphinx' Liquid Fuel Engine [260-330s → 230-350s]
        - KR-84 'Ocelot' Liquid Fuel Engine
        - KS-1E 'Goldfish' Liquid Fuel Engine [270-280s → 280-310s]
        - KR-1E-V 'Angora' Liquid Fuel Engine [250-320 → 310-320s]
        - KS-160 'Orca' Liquid Fuel Engine
        - KS-107 'Porpoise' Liquid Fuel Engine
      - Kerosene/LqdHydrogen/LqdOxygen
        - KR-701 'Cougar' Liquid Fuel Engine [295-345s → 330-415s (mode 1); 220-460s (mode 2)]
        - KR-74 'Lynx' Liquid Fuel Engine [298-345s → 355-405s (mode 1); 245-450s (mode 2)]
- Changed MonoPropellant RCS to use Hydrazine
- Changed LiquidFuel/Oxidizer RCS to use Hydrazine/NTO
- Changed Near Future Launch Vehicles multimode bipropellant RCS to use Hydrazine/NTO, Kerosene/LqdOxygen, LqdHydrogen/LqdOxygen and LqdMethane/LqdOxygen
- Replaced all Ore → MonoPropellant ModuleResourceConverter recipes to Ore → Hydrazine:
- Replaced all Ore → LiquidFuel/LqdHydrogen/LqdMethane + Oxidizer ModuleResourceConverter recipes to the following:
  - Ore → Hydrazine
  - Ore → NTO
  - Ore → Hydrazine + NTO
  - Ore → Kerosene
  - Ore → LqdOxygen
  - Ore → Kerosene + LqdOxygen
  - Ore → LqdHydrogen
  - Ore → LqdHydrogen + LqdOxygen
  - Ore → LqdMethane
  - Ore → LqdMethane + LqdOxygen
