# KSPCommunityPartModules

This mod is a collection of part modules that are frequently used by multiple mods.
It was created to avoid the frequent copying of modules between mods which made maintaining the modules more difficult and sometimes resulted in incompatibility between mods' modules.
This mod by itself will not have any effects, it is meant to be used as a dependency for other mods.

This mod is meant as community project, so feel free to propose additional module ideas by opening an issue, or to contribute with a pull request.

### Download and installation

Compatible with **KSP 1.12.3** and up - Available on [CKAN]

**Required** and **must be downloaded separately** : 

- **HarmonyKSP** : **[Download](https://github.com/KSPModdingLibs/HarmonyKSP/releases)** - [Homepage](https://github.com/KSPModdingLibs/HarmonyKSP/) - Available on [CKAN]

**Installation**
- Go to the **[GitHub release page](https://github.com/KSPModdingLibs/KSPCommunityPartModules/releases)** and download the newest file named `KSPCommunityPartModules_x.x.x.zip`
- Open the downloaded *.zip archive
- Open the `GameData` folder of your KSP installation
- Delete any existing `KSPCommunityPartModules` folder in your `GameData` folder
- Copy the `KSPCommunityPartModules` folder found in the archive into your `GameData` folder

### Included part modules

- **ModuleCoPFollowTransform**<br/>This module allows you to make the Center of Pressure (CoP), Center of Mass (CoM) or Center of Lift (CoL) follow a specified transform on the same part.

- **ModuleAutoCutDrogue**<br/>Automatically cuts deployed drogue chutes when main parachutes deploy, allowing for more realistic landings without requiring users to set up complicated action groups. 

- **ModuleDepthMask**<br/>This module allows for parts to have hollow insets that dont clip into other parts, ideal for engine nozzles, landing gear, air intakes, solar panel bays, and more.


[CKAN]: https://forum.kerbalspaceprogram.com/topic/197082-ckan-the-comprehensive-kerbal-archive-network-v1332-laplace-ksp-2-support/
