﻿using Expansions.Serenity;
using KSP.UI.Screens;
using Smooth.Slinq.Collections;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using TMPro;
using UnityEngine;
using static EdyCommonTools.RotationController;
using static System.Collections.Specialized.BitVector32;
using UnityEngine.SceneManagement;

namespace AutophageMod
{
    public class ModuleAutophageTank : ModuleRoboticServoPiston
    {
        private PartResource fuelResource;
        private float maximumExtension;
        private string resourceName = "RigidFuel";

        public override void OnStart(StartState state)
        {
            base.OnStart(state);
            fuelResource = part.Resources[resourceName];
            maximumExtension = ((Vector2)Fields.GetValue("softMinMaxExtension")).y;
            Actions.Clear();

            deactivateFieldGUI("targetExtension");
            deactivateFieldGUI("currentExtension");
            deactivateFieldGUI("servoMotorIsEngaged");
            deactivateFieldGUI("lockPartOnPowerLoss");
            //jointParentName = "JointParent"
            //servoAttachNodes = ""
            //A Comma separated list of AttachNodes that are part of the pivoting/ rotating section of the servo. Any nodes listed will automatically be moved and rotated based on the movement of the servo. NOTE: This is only applied in the Editor scenes.
            print(baseTransformName); //BottomJoint
            // The Part base Transform Name in the Model. This will be the Transform that is the base of the part (not the Servo).
            print(servoSrfMeshNames); //capTransform
            // A comma separated list of Mesh/collider transform Names that are part of the pivoting/rotation section of the servo. Any parts that are surface attached to these colliders will be pivoted/rotated based on the movement of the ervo.
            print(servoTransformName); //TopJoint
            // The Servo Transform Name in the Model. This will be the Transform the Servo will be attached to.
            print(servoTransformRotation); //{0.7, 0.0, 0.0, 0.7}
            // Persists the servo Transform LocalRotation
            print(servoTransformPosition); //{0.0, 0.0, 0.0}
            // Persists the servo Transform LocalPosition
            print(useMultipleDragCubes); //False
            // Set True to use multiple Drag Cubes.
            print(slaveTransformNames); //Sleave0, Sleave1
            // Comma separated list of names of transforms used for slave segments that interpolate their positions between servoTransform and baseTransform.
            // The first transform in the list will be closest to servoTransform and the last closest to baseTransform, with any in between interpoleted in listed order. 
            print(servoAttachNodes); //top
        }

        protected override void Update()
        {
            base.Update();
            if (fuelResource != null && fuelResource.maxAmount > 0 && HighLogic.LoadedSceneIsEditor)
            {
                Fields.SetValue("targetExtension", maximumExtension * (float)(fuelResource.amount / fuelResource.maxAmount));
            }
        }

        protected override void OnFixedUpdate()
        {
            base.OnFixedUpdate();
            if (fuelResource != null && fuelResource.maxAmount > 0 && HighLogic.LoadedSceneIsFlight)
            {
                Fields.SetValue("targetExtension", maximumExtension * (float)(fuelResource.amount / fuelResource.maxAmount));
                Fields.SetValue("currentExtension", maximumExtension * (float)(fuelResource.amount / fuelResource.maxAmount));
            }
        }

        private void deactivateFieldGUI(string fieldName)
        {
            Fields[fieldName].guiActiveEditor = false;
            Fields[fieldName].guiActive = false;
        }
    }
}