﻿/*Copyright © 2016, wasml
 Licensed under the Attribution-ShareAlike 4.0 (CC BY-SA 4.0)
 creative commons license. See <https://creativecommons.org/licenses/by-nc-sa/4.0/>
 for full details.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using KSP.IO;

namespace Aerostat
{
    class AerostatControlGUI : MonoBehaviour
    {
        private struct cellParams
        {
            public float pressure;
            public float fill;
            public float volume;
            public bool ruptured;
            public bool venting;
        }

        private const int queueSpot = 6;
        private const int WINDOW_WIDTH = 400;
        private const int WINDOW_HEIGHT = 200;

        private const int deltaTop = 15;
        private const int deltaLeft = 100;

        private int top;
        private int left;

        private int windowID;
        private Rect windowRect;
        Rect dragRect = new Rect(0, 0, WINDOW_WIDTH, 17);
        private GUIStyle labelStyle, buttonStyle, toggleStyle;

        // Display values
        float totalBouyancy;
        float[] totalVolume     = new float[2];
        cellParams[] Params = new cellParams[1];
        //float[] displayPressure = new float[10];
        //float[] displayFill     = new float[10];
        //float[] displayVolume   = new float[10];
        //bool[]  displayRupture  = new bool[10];

        private bool _GUIVisible = false;
        public bool guiVisible
        {
            get { return _GUIVisible; }
            set
            {
                _GUIVisible = value;
                if (_GUIVisible)
                {
                    Debug.Log("RenderingManager add");
                    RenderingManager.AddToPostDrawQueue(queueSpot, OnDraw);
                }
                else
                {
                    Debug.Log("RenderingManager remove");
                    RenderingManager.RemoveFromPostDrawQueue(queueSpot, OnDraw);
                }
            }
        }

        private void Start()
        {
            windowID = new System.Random().Next();
        }

        private void InitStyle(ref GUIStyle style, TextAnchor align, bool strechWidth, Color color, FontStyle fontStyle, int fontSize)
        {
            style = new GUIStyle(GUI.skin.label);
            style.alignment = align;
            style.stretchWidth = strechWidth;
            style.normal.textColor = color;
            style.fontStyle = fontStyle;
            style.fontSize = fontSize;
        }

        private void OnDraw()
        {
            int GUITextSize = 12;

            if (!_GUIVisible) // || gamepaused
                return;

            windowRect = new Rect(10, 10, WINDOW_WIDTH, WINDOW_HEIGHT);

            InitStyle(ref labelStyle, TextAnchor.MiddleLeft, true, Color.yellow, FontStyle.Bold, GUITextSize);
            InitStyle(ref buttonStyle, TextAnchor.MiddleCenter, true, Color.yellow, FontStyle.Normal, GUITextSize);
            InitStyle(ref toggleStyle, TextAnchor.MiddleLeft, true, Color.yellow, FontStyle.Normal, GUITextSize);

            GUI.skin = HighLogic.Skin;
            GUI.skin.button.fontSize = GUITextSize;
            GUI.skin.toggle.fontSize = GUITextSize;
            GUI.skin.textField.fontSize = GUITextSize;
            GUI.skin.textArea.fontSize = GUITextSize;
            windowRect = GUILayout.Window(windowID, windowRect, windowFunc, "AeroStat");
        }

        public void SetDisplayBouyancy(float newTotalBouyancy) { totalBouyancy = newTotalBouyancy; }
        public void SetDisplayPressure(int envIndex, float value) { }
        public void SetDisplayRuptured(int envIndex, bool value) { }
        public void SetDisplayFill(int envIndex, float value) { }
        public void SetDisplayVolume(int envIndex, float value) { Params[envIndex].volume = value; }

        public void ChangeCellCount(int newCount)
        {
            Params = new cellParams[newCount];
        }

        public void SetParams(int index, float Pressure, float Fill, bool Ruptured, bool Venting)
        { 
            if (index < Params.Length)
            {
                Params[index].pressure = Pressure;
                Params[index].fill = Fill;
                Params[index].ruptured = Ruptured;
                Params[index].venting = Venting;
            }
        }

        public void SetParams(List<ModuleAerostat> cells)
        {
            for (int i = 0; i < cells.Count; i++)
            {
                Params[i].pressure = cells[i].gasCells[0].pressureDifferential;
                Params[i].fill = cells[i].gasCells[0].gasVolume / cells[i].gasCells[0].cellVolume;
                Params[i].ruptured = cells[i].gasCells[0].gasLeak > 0.01f;
                Params[i].venting = cells[i].gasCells[0].ERVVenting;
            }
        }

        private void AddLabel(string lbl, int width, int height = deltaTop)
        {
            GUI.Label(new Rect(left, top, width, height), lbl, labelStyle);
            top += deltaTop;
        }

        private void windowFunc(int ID)
        {
            int i;
            int right = (int)(windowRect.width - 24);
            //float hSliderValue = 0.0f;
            float targetFillPercent = 0.0f;
            int toolbarInt = -1;
            string[] toolbarStrings = {"-", "+"};
            bool toggleBool = true;
            string textFieldString = "0";

            Debug.Log("RenderingManager X");
            if (GUI.Button(new Rect(right, 8, 17, 17), "X")) { _GUIVisible = false; }

            left = 5;
            top = deltaTop;
            AddLabel(" Vol " + totalVolume[0].ToString("F0") + " m³", 100);
            AddLabel("Bouy " + totalBouyancy.ToString("F3") + " KN", 100);
            AddLabel("Trim " + "+3" + "°", 100);
            AddLabel("Rate " + "+0.341" + " m/s", 100);
            AddLabel(" Alt " + "1234" + " m", 100);
            left = deltaLeft;

            for (i = 0; i < 3; i++)
            {
                top = deltaTop;
                //hSliderValue = GUI.HorizontalSlider(new Rect(left, top, 50, 25), hSliderValue, 0.0f, 10.0f);
                targetFillPercent = GUI.VerticalSlider(new Rect(left + top, 25, 25, 150), targetFillPercent, 1.0f, 0.0f);
                top += deltaTop;
                //targetFillPercent = GUI.VerticalSlider(new Rect(left + top, 25, 25, 150), targetFillPercent, 1.0f, 0.0f);
                toolbarInt = GUI.Toolbar(new Rect(left, top, 50, 25), toolbarInt, toolbarStrings);
                top += deltaTop;
                toggleBool = GUI.Toggle(new Rect(left, top, 50, 25), toggleBool, "Alt Hold");
                top += deltaTop;
                textFieldString = GUI.TextField(new Rect(left + 60, 50, 40, 25), textFieldString);
                top += deltaTop;
                if (GUI.RepeatButton(new Rect(left, top, 50, 25), "+")) { }
                top += deltaTop;
                if (GUI.Button(new Rect(left, top, 40, 25), "Button")) { }
                top += deltaTop;
                //GUI.Label(new Rect(left, top, 100, 25), "Label");
                left += deltaLeft;
            }

            GUI.DragWindow(dragRect);
        }

    }
}
