﻿using System;

namespace Lib
{
    public class IdealGasMath
    {
        public enum UnitTypes : byte { Liter = 0, Meter3 };
        // PV = NRT
        public static float ATM_TO_PA = 101325.0f;   // 1 Atm in Pascals
        public static double R = 8314.459848; // Universal gas constant L, Pa, K, mol
        public static double LITER_PER_MOLE = 22.414; // At STP
        public static double MOLES_PER_LITER = 0.04461497; // At STP
        public static double STANDARD_TEMP = 273.15;      // K
        public static double STANDARD_PRESSURE = 100000.0;    //mB
        public static double LITERS_TO_METERS3 = 0.001;
        public static double KGMETERS3_TO_KGLITER = 0.001;
        public static double LITERS_PER_METERS3 = 1000.0;

        public UnitTypes units
        { 
            get { return units; }
            set
            {
                units = value;
                switch (units)
                {
                    case UnitTypes.Liter:
                        R = 8314.459848;
                        break;
                    case UnitTypes.Meter3:
                        R = 8.314459848;
                        break;
                }
            }
        }

        //IdealGasLaw() { }

        public static double MolesToSTPVolume(double N)
        {
            return N * R * STANDARD_TEMP / STANDARD_PRESSURE;
        }

        public static double MolesToSTPPressure(double N)
        {
            return N * R * STANDARD_TEMP / STANDARD_PRESSURE;
        }

        public static double Volume(double N, double T, double P)
        {
            try
            { return N * R * T / P; }
            catch
            { return 0.0; }
        }

        public static double Pressure(double N, double T, double V)
        {
            try
            { return N * R * T / V; }
            catch
            { return 0.0; }
        }

        public static double Temparature(double N, double P, double V)
        {
            try
            { return (P * V) / (N * R); }
            catch
            { return 0.0; }
        }

        public static double Moles(double P, double V, double T)
        {
            try
            { return (P * V) / (R * T); }
            catch
            { return 0.0; }
        }

    }
}