﻿using System;
using UnityEngine;

namespace Lib
{
    class IntervalTimer
    {
        public delegate void Callback();

        public Callback callback;
        protected float nextInterval;
        public float interval
        {
            get { return interval; }
            set { interval = value; }
        }

        public void AddCallback(Callback newCallback)
        { callback += newCallback; }

        public void RemoveCallback(Callback oldCallback)
        { callback -= oldCallback; }

        public bool HasExpired()
        { return nextInterval <= Time.fixedTime; }

        public void ResetInterval()
        { nextInterval = Time.fixedTime + interval; }

        public void ExpireInterval()
        { nextInterval = Time.fixedTime; }

        public void Check()
        {
            if (nextInterval <= Time.fixedTime)
            {
                nextInterval = Time.fixedTime + interval;
                callback();
            }
        }

        public void Fire()
        { callback(); }
    }
}
