﻿using System;
using System.Collections.Generic;
using UnityEngine;
using KSP.IO;

namespace ModuleAirship
{
    public class ModuleAirshipControler : PartModule
    { 
        private bool holdRate = false;
        private float rateSet = 0.0f;
        private float lastRate = 0.0f;
        [KSPField(guiActive = true, guiActiveEditor = false, guiFormat = "f3", guiName = "Rate", guiUnits = "m/s", isPersistant = true)]
        public float rate = 0.0f;

        private bool holdVolume = false;
        private float volumeSet = 0.0f;
        [KSPField(guiActive = true, guiActiveEditor = false, guiFormat = "f1", guiName = "Volume", guiUnits = "m3", isPersistant = true)]
        public float volume = 0.0f;

        private bool holdBuoyancy = false;
        private float buoyancySet = 0.0f;
        private float lastBuoyancy = 0.0f;
        [KSPField(guiActive = true, guiActiveEditor = false, guiFormat = "f3", guiName = "Buoyancy", guiUnits = "KN", isPersistant = true)]
        public float buoyancy = 0.0f;

        private Part[] envelopes = null;
        private int envIndex = 0;

        [KSPField(isPersistant = true)]
        bool preventVenting = false;
        [KSPEvent(active = true, guiActive = true, guiActiveEditor = true, guiName = "Prevent Venting")]
        public void togglePreventVenting()
        {
            preventVenting = !preventVenting;
        }

        private bool holdAltitude = false;
        private double altitudeSet = 0.0f;
        private double lastAltitude = 0.0f;

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Altitude Off")]
        public void toggleAltitude()
        {
            holdAltitude = !holdAltitude;
            if (holdAltitude)
            {
                Events["toggleAltitude"].guiName = "Altitude On";
                holdRate = false;
                holdVolume = false;
                holdBuoyancy = false;
            }
            else
            {
                Events["toggleAltitude"].guiName = "Altitude Off";
            }
        }

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Altitude+")]
        public void AltitudePlus()
        {
            altitudeSet = altitudeSet + 1;
        }

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Altitude-")]
        public void AltitudeMinus()
        {
            altitudeSet = altitudeSet - 1;
        }

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Rate Off")]
        public void toggleRate()
        {
            holdRate = !holdRate;
            if (holdRate)
            {
                Events["toggleRate"].guiName = "Rate On";
                holdAltitude = false;
                holdVolume = false;
                holdBuoyancy = false;
            }
            else
            {
                Events["toggleRate"].guiName = "Rate Off";
            }
        }

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Volume Off")]
        public void toggleVolume()
        {
            holdVolume = !holdVolume;
            if (holdVolume)
            {
                Events["toggleVolume"].guiName = "Volume On";
                holdAltitude = false;
                holdRate = false;
                holdBuoyancy = false;
            }
            else
            {
                Events["toggleVolume"].guiName = "Volume Off";
            }
        }

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Buoyancy Off")]
        public void toggleBuoyancy()
        {
            holdBuoyancy = !holdBuoyancy;
            if (holdBuoyancy)
            {
                Events["toggleBuoyancy"].guiName = "Buoyancy On";
                holdAltitude = false;
                holdRate = false;
                holdVolume = false;
            }
            else
            {
                Events["toggleBuoyancy"].guiName = "Buoyancy Off";
            }
        }

        private bool holdTrim = false;
        private float trimSet = 0.0f;
        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Trim Off")]
        public void toggleTrim()
        {
            holdTrim = !holdTrim;
            if (holdTrim)
            {
                Events["toggleTrim"].guiName = "Trim On";
            }
            else
            {
                Events["toggleTrim"].guiName = "Trim Off";
            }
        }

        [KSPField(guiActive = true, guiActiveEditor = false, guiFormat = "f1", guiName = "Trim", guiUnits = "Deg", isPersistant = true)]
        public float trim = 0.0f;

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Trim+")]
        public void TrimPlus()
        {
            trimSet = trimSet + 1;
        }

        [KSPEvent(active = true, guiActive = true, guiActiveEditor = false, guiName = "Trim-")]
        public void TrimMinus()
        {
            trimSet = trimSet - 1;
        }

        private int locateEnvelopes()
        {
            //Debug.Log("[AirshipControler] locateEnvelopes");

            int count = 0;
            foreach (Part p in vessel.parts)
                if (p.Modules.Contains("ModuleRigidFrameAirship"))
                    count++;

            envelopes = new Part[count];
            envIndex = 0;
            // Locate and save envelopes to control
            foreach (Part p in vessel.parts)
            {
                if (p.Modules.Contains("ModuleRigidFrameAirship"))
                {
                    envelopes[envIndex] = p;
                    envIndex++;
                }
            }
            
            //Debug.Log("[AirshipControler] locateEnvelopes");
            return count;
        }

        public override void OnAwake()
        {
            //Debug.Log("[AirshipControler] OnAwake");

            base.OnAwake();
            locateEnvelopes();

            //Debug.Log("[AirshipControler] Exit OnAwake");
        }

        // public override void OnFixedUpdate()
        public void FixedUpdate()
        {
            //Debug.Log("[AirshipControler] FixedUpdate");

            //base.OnFixedUpdate();

            // Check envelopes and accumulate values for display
            volume = 0.0f;
            buoyancy = -vessel.GetTotalMass();
            List<ModuleAerostat> envelopes = vessel.FindPartModulesImplementing<ModuleAerostat>();

            foreach (ModuleAerostat envelope in envelopes)
                {
                    try
                    {
                        volume = volume + envelope.liftCellMoles;
                        buoyancy = buoyancy + envelope.lift;
                        if ((preventVenting) && (envelope.pressureDifferential > envelope.maxPressure * 0.95)) // Is this too close?
                        {
                            envelope.liftCellTargetMoles = (float)envelope.calcMolesForPressure(envelope.maxPressure * 0.95);
                        }
                    }
                    catch (Exception)
                    {
                        // Ignore and continue
                    }
                }
            rate = (float)((vessel.altitude - lastAltitude) / Time.deltaTime);
            trim = (float)(Math.Acos(Vector3.Dot(vessel.GetFwdVector(), vessel.findWorldCenterOfMass())) * (180/Math.PI));
            // Vector3 COM = vessel.findLocalCenterOfMass();

            if (holdTrim)
            {
                // find lead and trail envelope and transfer some x moles of gas
                // Find dist from COM and use farthest?
            }
            
            if ((holdAltitude) && (Math.Abs(vessel.altitude - altitudeSet) > 1.0))
            { 
                // Try and +/- ends evenly so as not to change trim
            }

            if ((holdRate) && (Math.Abs(rate - rateSet) > 0.01))
            {
            }

            if ((holdVolume) && (Math.Abs(volume - volumeSet) > 1.0))
            {
            }

            if ((holdBuoyancy) && (Math.Abs(buoyancySet - buoyancy) > 1.0))
            {
            }

            //Debug.Log("[AirshipControler] Exit FixedUpdate");
        }

        public override void OnUpdate()
        {
            //Debug.Log("[AirshipControler] OnUpdate");

            base.OnUpdate();

            // Calc for display
            // Max pressure
            // Volume
            // Trim
            // Rate
            // Buoyancy

            lastAltitude = (float)vessel.altitude;
            lastBuoyancy = buoyancy;
            lastRate = rate;

            //Debug.Log("[AirshipControler] Exit OnUpdate");
        }

    }

}
