﻿/*Copyright © 2016, wasml
 Licensed under the Attribution-ShareAlike 4.0 (CC BY-SA 4.0)
 creative commons license. See <https://creativecommons.org/licenses/by-nc-sa/4.0/>
 for full details.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using KSP;
using UnityEngine;

//TODO: Make sure this is loading/saving
namespace Aerostat
{
    [KSPScenario(ScenarioCreationOptions.AddToAllGames, new GameScenes[] { GameScenes.FLIGHT, GameScenes.SPACECENTER })]
    internal class AerostatScenario : ScenarioModule
    {
        private static string stLiftMultiplier = "liftMultiplier";
        private static float liftMultiplier = 2.0f;
        private static string modTag = "AerostatScenario";
        public static float LiftMultiplier
        {
            get { return liftMultiplier; }
            set { if (liftMultiplier != value) liftMultiplier = value; }
        }

        public override void OnLoad(ConfigNode gameNode)
        {
            //Debug.Log(modTag + "-> OnLoad()");

            base.OnLoad(gameNode);

            if (gameNode.HasValue(stLiftMultiplier)) 
            {
                liftMultiplier = float.Parse(gameNode.GetValue(stLiftMultiplier));
                Debug.Log(modTag + stLiftMultiplier + " = " + liftMultiplier);
            }

            //Debug.Log(modTag + "   OnLoad ->");
        }

        public override void OnSave(ConfigNode gameNode)
        {
            //Debug.Log(modTag + "-> OnSave()");

            base.OnSave(gameNode);

            gameNode.AddValue(stLiftMultiplier, liftMultiplier.ToString());

            //Debug.Log(modTag + "   OnSave ->");
        }
    }
}
