# WeatherDrivenSolarPanel (WDSP)
[English](https://github.com/Aebestach/WeatherDrivenSolarPanel/blob/master/README.md) | [简体中文](https://www.bilibili.com/read/cv31075491/)

![Imgur](https://i.imgur.com/WoxMQ3K.jpg)

## Introduce

In the stock version of Kerbal Space Program, the energy output of solar panels is affected by direct sunlight, being blocked by terrain, being blocked by satellites, and being blocked by other parts. With the release of blackrack’s [True Volumetric Clouds](https://www.patreon.com/blackrack/posts), there is now another way to change energy output --- ***weather***. <br><br>This plugin is designed to be used in conjunction with True Volumetric Clouds. When you encounter rain, snow, dust storms, or volcanic clouds on a planet, you will notice a wonderful change in the values on the panel. Enjoy the game to the fullest!

Since the v5.0 update, a new wear feature has been added to WDSP, see [**Others**](https://github.com/Aebestach/WeatherDrivenSolarPanel?tab=readme-ov-file#others) for details

## Dependencies

- [Kopernicus](https://github.com/Kopernicus/Kopernicus)  ***[Please use version v212 or later]*** 
<br> **I think you might want to take a look at [this](https://github.com/Aebestach/WeatherDrivenSolarPanel/issues/5), just in case you make a mistake.**
- [True volumetric clouds](https://www.patreon.com/blackrack/posts)
- Module Manager
- If you use Kerbalism, make sure `000_Harmony` exists

## Installation
- The installation process is the same as other mods. Just put the WeatherDrivenSolarPanel folder from GameData into the GameData in the game root directory. 
- If you use the Kerbalism version, please copy `Extras\KerbalismSupport\WeatherDrivenSolarPanel.dll` to `GameData\WeatherDrivenSolarPanel\Plugin` and replace it.

## Preview Image & Video
![Imgur](https://i.imgur.com/B9q2Rak.jpg)
![Imgur](https://i.imgur.com/drHOD4A.jpg)
![Imgur](https://i.imgur.com/oz1DLv0.jpg)
[YouTube](https://youtu.be/IKnQO8X81A4?si=3_P_wxlH7WFWAL_2) 


## Compatibility
- RSS-Reborn needs ballisticfox to update his Kopernicus
- Compatible with JNSQ, KSRSS, Kcalbeloh System, RO (for RO, replaces the original solar module of RO), Kerbalism

## Others 
Since the v5.0 update, the wear feature has been introduced. Once the wear reaches 100%, the solar panel will be damaged and cannot be repaired.
- The solar panel will increase wear over time. (This feature is not enabled in the Stock+Kerbalism environment and is disabled by default.)
- The solar panel will increase wear due to weather.

**Note: This process is irreversible.** If you do not need these two new features, you can turn them off in`WeatherDrivenSolarPanel/Config/GlobalConfig.cfg`.

* * *
**Provides two graphs, one for time versus wear and one for weather versus wear.**

![Imgur](https://imgur.com/2pyqZmO.png)
![Imgur](https://imgur.com/7LH2wLB.png)

## Credits
- Thank you so much to [R-T-B](https://github.com/R-T-B)  for all your help with WDSP.
- Thanks to [blackrack](https://github.com/LGhassen)  for the beautiful beautification mod and for his help in it.
-  **Thanks to both of them for their help with this plugin!**
