# TweakScale Companion :: Kerbal Inventory & Attachment Systems (KIAS)

Adds (up to date) TweakScale /L patches for Kerbal Inventory System (KIS) and Kerbal Attachment System (KAS).


## In a Hurry

* [Source](https://github.com/net-lisias-ksp/TweakScaleCompanion_KIAS)
	+ [Issue Tracker](https://github.com/net-lisias-ksp/TweakScaleCompanion_KIAS/issues)
* Documentation
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/192216-tweakscale-companion-program/)
	+ [Project's README](https://github.com/net-lisias-ksp/TweakScaleCompanion_KIAS/blob/master/README.md)
	+ [Install Instructions](https://github.com/net-lisias-ksp/TweakScaleCompanion_KIAS/blob/master/INSTALL.md)
	+ [Change Log](./CHANGE_LOG.md)
	+ [Known Issues](./KNOWN_ISSUES.md)
* Official Distribution Sites:
	+ [Source and Binaries](https://github.com/net-lisias-ksp/TweakScaleCompanion_KIAS) on GitHub.
	+ [Latest Release](https://github.com/net-lisias-ksp/TweakScaleCompanion_KIAS/releases)
		- [Binaries](https://github.com/net-lisias-ksp/TweakScaleCompanion_KIAS/Archive)


## Description

**TweakScale Companion for Kerbal Inventory & Attachment Systems** adds (up to date) [TweakScale /L](https://forum.kerbalspaceprogram.com/index.php?/topic/179030-ksp-141-tweakscale-under-lisias-management-24310-2019-1030/) support for:

* [Kerbal Inventory System (KIS)](https://forum.kerbalspaceprogram.com/index.php?/topic/149848-*/)
* [Kerbal Attachment System (KAS)](https://forum.kerbalspaceprogram.com/index.php?/topic/142594-*/)
	+ (unreleased).

### How to Use

There's an option, when scaling Containers, to select scaling only the Volume or also the number of slots on the container.

When scaling the number of slots, there's a penalty on cost and volume due the extra hardware needed to accommodate the extra slots.


## Installation

Detailed installation instructions are now on its own file (see the [In a Hurry](#in-a-hurry) section) and on the distribution file.

### License

* This work is **double licensed** as follows:
	+ [SKL 1.0](https://ksp.lisias.net/SKL-1_0.txt). See [here](./LICENSE.SKL-1_0)
		+ You are free to:
			- Use : unpack and use the material in any computer or device
			- Redistribute: redistribute the original package in any medium
		+ Under the following terms:
			- You agree to use the material only on (or to) KSP
			- You don't alter the package in any form or way (but you can embedded it)
			- You don't change the material in any way, and retain any copyright notices
			- You must explicitly state the author's Copyright, as well an Official Site for downloading the original and new versions (the one you used to download is good enough) 
	+ [GPL 2.0](https://www.gnu.org/licenses/gpl-2.0.txt). See [here](./LICENSE.GPL-2_0)
		+ You are free to:
			- Use : unpack and use the material in any computer or device
			- Redistribute : redistribute the original package in any medium
			- Adapt : Reuse, modify or incorporate source code into your works (and redistribute it!) 
		+ Under the following terms:
			- You retain any copyright notices
			- You recognize and respect any trademarks
			- You don't impersonate the authors, neither redistribute a derivative that could be misrepresented as theirs.
			- You credit the author and republish the copyright notices on your works where the work is used.
			- You relicense (and fully comply) your works using GPL 2.0
				- Please note that upgrading the license to GPLv3 **IS NOT ALLOWED** for this work, as the author **DID NOT** added the "or (at your option) any later version" on the license.
			- You don't mix your work with GPL incompatible works.
	+ If by some reason the GPL would be invalid for you, rest assured that you still retain the right to Use the Work under SKL 1.0.

You have the option to choose the license that best suits you (when applicable).

See [NOTICE](./NOTICE) for further copyright and trademarks notices.


## References

* TweakScale /L ([LisiasT](https://forum.kerbalspaceprogram.com/index.php?/profile/187168-lisias/))
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/179030-ksp-141-tweakscale-under-lisias-management-24310-2019-1030/)
	+ [CurseForge](https://kerbal.curseforge.com/projects/tweakscale)
	+ [SpaceDock](https://spacedock.info/mod/127/TweakScale)
	+ [Homepage](http://ksp.lisias.net/add-ons/TweakScale) on L Aerospace
	+ [GitHub](https://github.com/net-lisias-ksp/TweakScale).
* Kerbal Attachment System (KAS) ([IgorZ](https://forum.kerbalspaceprogram.com/index.php?/profile/155445-igorz/))
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/149848-minimum-ksp-version-18-kerbal-inventory-system-kis-v125/)
	+ [CurseForge](https://www.curseforge.com/kerbal/ksp-mods/kerbal-attachment-system-kas)
	+ [SpaceDock](https://spacedock.info/mod/1987/Kerbal%20Attachment%20System%20%28KAS%29)
	+ [GitHub](https://github.com/ihsoft/KAS).
* Kerbal Inventory System (KIS) ([IgorZ](https://forum.kerbalspaceprogram.com/index.php?/profile/155445-igorz/))
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/149848-minimum-ksp-version-18-kerbal-inventory-system-kis-v125/)
	+ [CurseForge](https://www.curseforge.com/kerbal/ksp-mods/kerbal-inventory-system-kis)
	+ [SpaceDock](https://spacedock.info/mod/1909/Kerbal%20Inventory%20System%20%28KIS%29)
	+ [GitHub](https://github.com/ihsoft/KIS).
