# TweakScale Companion :: Post Kerbin Mining Corporation Add'Ons

Adds (up to date) TweakScale /L patches for Post Kerbin Mining Corporation Add'Ons, including Near Future ones.


## In a Hurry

* [Source](https://github.com/TweakScale/Companion_PKMC)
	+ [Issue Tracker](https://github.com/TweakScale/Companion_PKMC/issues)
* Documentation
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/192216-tweakscale-companion-program/)
	+ [Project's README](https://github.com/TweakScale/Companion_PKMC/blob/master/README.md)
	+ [Install Instructions](https://github.com/TweakScale/Companion_PKMC/blob/master/INSTALL.md)
	+ [Change Log](./CHANGE_LOG.md)
	+ [Known Issues](./KNOWN_ISSUES.md)
* Official Distribution Sites:
	+ [Source and Binaries](https://github.com/TweakScale/Companion_PKMC) on GitHub.
	+ [Latest Release](https://github.com/TweakScale/Companion_PKMC/releases)
		- [Binaries](https://github.com/TweakScale/Companion_PKMC/Archive)


## Description

**TweakScale Companion for Post Kerbin Mining Corporation Add'Ons** adds (up to date) [TweakScale /L](https://forum.kerbalspaceprogram.com/index.php?/topic/179030-ksp-141-tweakscale-under-lisias-management-24310-2019-1030/) support for ( surprisingly :P ) Near Future Add'Ons](https://forum.kerbalspaceprogram.com/index.php?/topic/155465-18x-near-future-technologies-please-welcome-near-future-exploration/) and others from the [Post Kerbin Mining Corporation](https://post-kerbin-mining-corporation.github.io).

Currently supporting:

* Far Future Technologies
* Near Future Technologies
	+ Near Future Aeronautics
	+ Near Future Construction
	+ Near Future Electrical
	+ Near Future Exploration
	+ Near Future Construction
	+ Near Future Launch Vehicle
	+ Near Future Propulsion
	+ Near Future Solar
	+ Near Future Space Craft


## Installation

Detailed installation instructions are now on its own file (see the [In a Hurry](#in-a-hurry) section) and on the distribution file.

### License

* This work is **double licensed** as follows:
	+ [SKL 1.0](https://ksp.lisias.net/SKL-1_0.txt). See [here](./LICENSE.SKL-1_0)
		+ You are free to:
			- Use : unpack and use the material in any computer or device
			- Redistribute: redistribute the original package in any medium
		+ Under the following terms:
			- You agree to use the material only on (or to) KSP
			- You don't alter the package in any form or way (but you can embedded it)
			- You don't change the material in any way, and retain any copyright notices
			- You must explicitly state the author's Copyright, as well an Official Site for downloading the original and new versions (the one you used to download is good enough) 
	+ [GPL 2.0](https://www.gnu.org/licenses/gpl-2.0.txt). See [here](./LICENSE.GPL-2_0)
		+ You are free to:
			- Use : unpack and use the material in any computer or device
			- Redistribute : redistribute the original package in any medium
			- Adapt : Reuse, modify or incorporate source code into your works (and redistribute it!) 
		+ Under the following terms:
			- You retain any copyright notices
			- You recognise and respect any trademarks
			- You don't impersonate the authors, neither redistribute a derivative that could be misrepresented as theirs.
			- You credit the author and republish the copyright notices on your works where the work is used.
			- You relicense (and fully comply) your works using GPL 2.0
				- Please note that upgrading the license to GPLv3 **IS NOT ALLOWED** for this work, as the author **DID NOT** added the "or (at your option) any later version" on the license.
			- You don't mix your work with GPL incompatible works.
	+ If by some reason the GPL would be invalid for you, rest assured that you still retain the right to Use the Work under SKL 1.0.

You have the option to choose the license that best suits you (when applicable).

See [NOTICE](./NOTICE) for further copyright and trademarks notices.


## Refences

* TweakScale /L ([LisiasT](https://forum.kerbalspaceprogram.com/index.php?/profile/187168-lisias/))
	+ [Homepage](http://ksp.lisias.net/add-ons/TweakScale) on L Aerospace
	+ [Reddit](https://www.reddit.com/r/TweakScale/)
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/179030-*/)
	+ [CurseForge](https://kerbal.curseforge.com/projects/tweakscale)
	+ [SpaceDock](https://spacedock.info/mod/127/TweakScale)
	+ [GitHub](https://github.com/TweakScale/TweakScale)
* [Far Future Technologies](https://forum.kerbalspaceprogram.com/index.php?/topic/199070-*/)
	+ [CurseForge](https://www.curseforge.com/kerbal/ksp-mods/far-future-technologies)
	+ [SpaceDock](https://spacedock.info/mod/2603/Far%20Future%20Technologies) 
	+ [GitHub](https://github.com/post-kerbin-mining-corporation/FarFutureTechnologies/releases)
* [Near Future Technologies](https://forum.kerbalspaceprogram.com/index.php?/topic/155465-*/)
	+ Near Future Aeronautics
		- [CurseForge](https://kerbal.curseforge.com/projects/near-future-aeronautics)
		- [SpaceDock](https://spacedock.info/mod/1957/Near%20Future%20Aeronautics) 
		- [GitHub](https://github.com/ChrisAdderley/NearFutureAeronautics/releases)
	+ Near Future Construction
		- [CurseForge](https://kerbal.curseforge.com/projects/near-future-construction)
		- [SpaceDock](http://spacedock.info/mod/563/Near%20Future%20Construction)
		- [GitHub](https://github.com/ChrisAdderley/NearFutureConstruction/releases)
	+ Near Future Electrical
		- [CurseForge](https://kerbal.curseforge.com/projects/near-future-electrical)
		- [SpaceDock](http://spacedock.info/mod/558/Near%20Future%20Electrical) 
		- [GitHub](https://github.com/ChrisAdderley/NearFutureElectrical/releases)
	+ Near Future Exploration
		- [CurseForge](https://www.curseforge.com/kerbal/ksp-mods/near-future-exploration)
		- [SpaceDock](https://spacedock.info/mod/2305/Near%20Future%20Exploration) 
		- [GitHub](https://github.com/ChrisAdderley/NearFutureExploration/releases)
	+ Near Future Construction
		- [CurseForge](https://kerbal.curseforge.com/projects/near-future-construction)
		- [SpaceDock](http://spacedock.info/mod/563/Near%20Future%20Construction)
		- [GitHub](https://github.com/ChrisAdderley/NearFutureConstruction/releases)
	+ Near Future Launch Vehicle
		- [CurseForge](https://spacedock.info/mod/1434/Near%20Future%20Launch%20Vehicles)
		- [SpaceDock](https://kerbal.curseforge.com/projects/near-future-launch-vehicles) 
		- [GitHub](https://github.com/ChrisAdderley/NearFutureLaunchVehicles/releases)
	+ Near Future Propulsion
		- [CurseForge](https://kerbal.curseforge.com/projects/near-future-propulsion)
		- [SpaceDock](http://spacedock.info/mod/557/Near%20Future%20Propulsion) 
		- [GitHub](https://github.com/ChrisAdderley/NearFuturePropulsion/releases)
	+ Near Future Solar
		- [CurseForge](https://kerbal.curseforge.com/projects/near-future-solar)
		- [SpaceDock](http://spacedock.info/mod/559/Near%20Future%20Solar)
		- [GitHub](https://github.com/ChrisAdderley/NearFutureSolar/releases)
	+ Near Future Space Craft
		- [CurseForge](https://spacedock.info/mod/708/Near%20Future%20Spacecraft)
		- [SpaceDock](https://kerbal.curseforge.com/projects/near-future-spacecraft-parts) 
		- [GitHub](https://github.com/ChrisAdderley/NearFutureSpacecraft/releases)
