# TweakScale Companion Program

A centralised database for keeping up with the growing TweakScale Companion Program.

Provides a mega package including all Companions currently published for the lazy installers. This package is updated sparingly, the Companion's repositories (listed below) will always be updated with the latest versions - and are still the canonical way to have everything up to date.

## In a Hurry

* Documentation
	+ [Homepage](http://ksp.lisias.net/add-ons/TweakScaleCompanion/) on L Aerospace
	+ [Project's README](https://github.com/TweakScale/Companion/blob/master/README.md)
	+ [Install Instructions](https://github.com/TweakScale/Companion/blob/master/INSTALL.md)
* Official Distribution Sites:
	+ [CurseForge](https://www.curseforge.com/kerbal/ksp-mods/tweakscale-companion)
	+ [SpaceDock](https://spacedock.info/mod/3202/TweakScale%20Companion)
	+ [Latest Release on Github](https://github.com/TweakScale/Companion/releases)
* Support
	+ [Homepage](http://ksp.lisias.net/add-ons/TweakScaleCompanion/Support/) on L Aerospace
	+ [Reddit](https://www.reddit.com/r/TweakScale/)
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/192216-*)
		- [Abbreviation's thread](https://forum.kerbalspaceprogram.com/topic/194416-abbreviations-for-addons/). 
	+ [Discussions on Github](https://github.com/TweakScale/Companion/discussions/categories/support)
* [Source](https://github.com/TweakScale/Companion)
	+ [Issue Tracker](https://github.com/TweakScale/Companion/issues)

## Description

**TweakScale Companion Program** is a series of "Add'On's Add'Ons", adding TweakScale /L support for third parties but decoupling the target Add'On's life cycle from TweakScale's , easing maintenance and distribution efforts.

The purpose of this project is to provide a centralised, controlled and curated (minimalistic) database to allow TweakScale to keep track of the Companions and propose actions to the user when needed, as well to make TweakScale user's life easier at first installs with a (most of the time) updated collection with all the currently available Companions at once.

### Current Companions

#### Gold Status

* [TweakScale Companion for AirCrafts](https://github.com/TweakScale/Companion_AirCrafts) *RC*
	- [Airplane Plus](https://forum.kerbalspaceprogram.com/topic/140262-14x-18x-airplane-plus-r264-fixed-issuesgithub-is-up-to-date-dec-21-2019/)
	- [Neist Airline Parts](https://forum.kerbalspaceprogram.com/topic/174152-wip-neist-airliner-parts/)
	- [Stock eXTension - SXT](https://forum.kerbalspaceprogram.com/topic/151129-112x-sxt-continued/)
* [TweakScale Companion for Firespitter](https://github.com/TweakScale/Companion_FS)
	+ For (surpringly :P) [Firespiter](https://forum.kerbalspaceprogram.com/index.php?/topic/22583-*/)
	+ and [Firespiter Extended](https://forum.kerbalspaceprogram.com/index.php?/topic/184773-*/)
* [TweakScale Companion Frameworks](https://github.com/TweakScale/Companion_Frameworks)
	+ [Test Flight](https://forum.kerbalspaceprogram.com/index.php?/topic/99043-*/)
	+ [Cryo Tanks](https://forum.kerbalspaceprogram.com/index.php?/topic/195042-*/)
	+ [Space Dust](https://forum.kerbalspaceprogram.com/index.php?/topic/197723-*/)
	+ [System Heat](https://forum.kerbalspaceprogram.com/index.php?/topic/193909-*/)
	+ [Waterfall](https://forum.kerbalspaceprogram.com/index.php?/topic/196309-*/)
* [TweakScale Companion for KIAS](https://github.com/TweakScale/Companion_KIAS)
	+ [KIS](https://forum.kerbalspaceprogram.com/index.php?/topic/149848-*)
	+ [KAS](https://forum.kerbalspaceprogram.com/index.php?/topic/142594-*)
		- (unreleased)
* [TweakScale Companion PKMC](https://github.com/TweakScale/Companion_PKMC)
	+ [Far Future Technologies](https://forum.kerbalspaceprogram.com/index.php?/topic/199070-*/) 
	+ [Near Future Technologies](https://forum.kerbalspaceprogram.com/index.php?/topic/155465-*/)
		- Near Future Aeronautics
		- Near Future Construction
		- Near Future Electric
		- Near Future Exploration
		- Near Future Launch Vehicles
		- Near Future Propulsion
		- Near Future Solar
		- Near Future Space Craft
	+ Stock alike Space Station Expansion ([Redux](https://forum.kerbalspaceprogram.com/index.php?/topic/170211-*/) and Legacy)
* [TweakScale Companion for ReStockPlus](https://github.com/TweakScale/Companion_ReStockPlus)
	+ For [ReStock[+]](https://forum.kerbalspaceprogram.com/index.php?/topic/182679-*/)

#### Alphas, Betas and Release Candidates

* [TweakScale Companion for OPT](https://github.com/TweakScale/Companion_OPT) *_Alpha_*
	+ For OPT
		- [Classic](https://forum.kerbalspaceprogram.com/index.php?/topic/87956-*/)
		- [Legacy](https://forum.kerbalspaceprogram.com/index.php?/topic/173833-*/)
		- [Continued](https://forum.kerbalspaceprogram.com/index.php?/topic/196187-*/) 
* [TweakScale Companion LivingStyle](https://github.com/TweakScale/Companion_LivingStyle) *Beta*
	+ [CxAerospace Station Parts](https://forum.kerbalspaceprogram.com/index.php?/topic/138910-*/) 
	+ [PorkJet's HabPack](https://forum.kerbalspaceprogram.com/index.php?/topic/58534-*/)
	+ [HabTech (1)](https://forum.kerbalspaceprogram.com/index.php?/topic/133501-*/)
	+ [HabTech 2](https://forum.kerbalspaceprogram.com/index.php?/topic/133501-*/)
	+ [Station Parts Expansion (Classic)](https://forum.kerbalspaceprogram.com/index.php?/topic/155480-*/)
	+ [Station Parts Expansion Redux](https://forum.kerbalspaceprogram.com/topic/170211-*/)
	+ [Tokamak Industries](https://forum.kerbalspaceprogram.com/index.php?/topic/163166-*/) 
* [TweakScale Companion Multipass](https://github.com/TweakScale/Companion_Multipass) *Beta*
	+ [MechJeb 2 ](https://forum.kerbalspaceprogram.com/index.php?/topic/154834-*/)
	+ [Tarsier Space Technologies](https://forum.kerbalspaceprogram.com/index.php?/topic/154853-*/)
* [TweakScale Companion SpannerMonkey](https://github.com/TweakScale/Companion_SMCE) *Beta*
	+ [Large Ship Parts pack](https://forum.kerbalspaceprogram.com/index.php?/topic/155992-*/) 
	+ [SM Marine](https://forum.kerbalspaceprogram.com/topic/142557-*/)
* [TweakScale Companion for Rockets](https://github.com/TweakScale/Companion_Rockets) *Beta*
	+ [Arc Aerospace](https://forum.kerbalspaceprogram.com/index.php?/topic/165224-*/)
	+ [RealEngines](https://forum.kerbalspaceprogram.com/index.php?/topic/154624-*/)


#### Unreleased

The following are planned or in the works but still unreleased, Companions:

* [TweakScale Companion ChitChat](https://github.com/TweakScale/Companion_ChitChat/)
	- WiP 
* [TweakScale Companion Fitness & Health](https://github.com/TweakScale/Companion_FitAndHealth/)
	- WiP 
* [TweakScale Companion for Fuel Switches](https://github.com/TweakScale/Companion_FuelSwitches/)
	- WiP 
* [TweakScale Companion Legacy](https://github.com/TweakScale/Companion_Legacy/)
	- WiP 
* [TweakScale Companion for Modular Fuel Tanks](https://github.com/TweakScale/Companion_MFT/releases)
	- [Modular Fuel Tanks](https://forum.kerbalspaceprogram.com/index.php?/topic/58235-*/)
	- [RealFuels](https://forum.kerbalspaceprogram.com/index.php?/topic/58236-*) 
* [TweakScale Companion for Space Planes](https://github.com/TweakScale/Companion_SpacePlanes/)
	- WiP 
* [TweakScale Companion for Universal Storage](https://github.com/TweakScale/Companion_US/)
	- [Universal Storage (I)](https://forum.kerbalspaceprogram.com/index.php?/topic/68043-universal-storage/)
	- [Universal Storage (II)](https://forum.kerbalspaceprogram.com/index.php?/topic/177385-universal-storage-ii/)
* [TweakScale Companion for Wild Blue Industries](https://github.com/TweakScale/Companion_WBI/)
	- WiP 


## Installation

Detailed installation instructions are now on its own file (see the [In a Hurry](#in-a-hurry) section) and on the distribution file.

### License

* This work is licensed as follows:
	+ [SKL 1.0](https://ksp.lisias.net/SKL-1_0.txt). See [here](./LICENSE.SKL-1_0)
		+ You are free to:
			- Use : unpack and use the material in any computer or device
			- Redistribute: redistribute the original package in any medium
		+ Under the following terms:
			- You agree to use the material only on (or to) KSP
			- You don't alter the package in any form or way (but you can embedded it)
			- You don't change the material in any way, and retain any copyright notices
			- You must explicitly state the author's Copyright, as well an Official Site for downloading the original and new versions (the one you used to download is good enough)
	+ Individual packages under the `GameData/TweakScaleCompanion` directory are distributed under their own licenses.

Be advised that redistribution of derivatives is expressibly forbidden.

See [NOTICE](./NOTICE) for further copyright and trademarks notices.


## References

* TweakScale /L ([LisiasT](https://forum.kerbalspaceprogram.com/index.php?/profile/187168-lisias/))
	+ [Homepage](http://ksp.lisias.net/add-ons/TweakScale) on L Aerospace
	+ [Reddit](https://www.reddit.com/r/TweakScale/)
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/179030-*/)
	+ [CurseForge](https://kerbal.curseforge.com/projects/tweakscale)
	+ [SpaceDock](https://spacedock.info/mod/127/TweakScale)
	+ [GitHub](https://github.com/TweakScale/TweakScale)
