using UnityEngine;

namespace PositionController {
    [KSPAddon(KSPAddon.Startup.Flight, false)]
    public class LoaderFlight : MonoBehaviour
    {
        public LoaderFlight()
        {
            Update();
        }

        public void Update()
        {
            var controller = UIPartActionController.Instance;
            if (!controller) return;

            var prefab = controller.windowPrefab;
            if (!prefab) return;

            // Pre-attach controller to the menu window template.
            if (!prefab.GetComponent<DraggableMenu.PositionController>())
                prefab.gameObject.AddComponent<DraggableMenu.PositionController>();

            Destroy(this);
        }
    }

    [KSPAddon(KSPAddon.Startup.EditorAny, false)]
    public class LoaderEditors : MonoBehaviour
    {
        public LoaderEditors()
        {
            Update();
        }

        public void Update()
        {
            var controller = UIPartActionController.Instance;
            if (!controller) return;

            var prefab = controller.windowPrefab;
            if (!prefab) return;

            // Pre-attach controller to the menu window template.
            if (!prefab.GetComponent<DraggableMenu.PositionController>())
                prefab.gameObject.AddComponent<DraggableMenu.PositionController>();

            Destroy(this);
        }
    }
}