﻿using System;
using System.Collections.Generic;
using KSPPluginFramework;

using UnityEngine;
using KSP.UI.Screens;
using KSP.UI.Language;
using FinePrint;
using FinePrint.Contracts.Parameters;
using FinePrint.Utilities;
using Contracts;
using Expansions.Missions;
using Expansions.Missions.Editor;
using UnityEngine.SceneManagement;

using ClickThroughFix;
using ToolbarControl_NS;

namespace RealtimeFunding
{

    [KSPAddon(KSPAddon.Startup.SpaceCentre, true)]
    public class RealtimeFunding : MonoBehaviour
    {
        public static RealtimeFunding instance;
        ToolbarControl toolbarControl;


        public static double BudgetMultiplier = 1.15;
        public static int BaseFunding = 200;
        public static double ScientistExponent = 1.4;
        public static double ScientistMultiplier = 0.5;
        public static double QuestMultiplier = 0.5;
        public static double QuestReputationMultiplier = 0.5;
        public static double QuestPoints = 0;
        public static double lastScienceTick = 0;
        public static double lastFundingTick = 0;
        public static double lastCashOut_GameTime = Planetarium.GetUniversalTime();
        public static long LastSettingChange = 0;
        public static bool GUIopen = false;
        public static long lastCashOut = (long)(System.DateTime.Now.Ticks / 10000000);
        public static ushort[] repArray = new ushort[3317] { 650, 1300, 1950, 2600, 3250, 3900, 4550, 5200, 5850, 6500, 7150, 7800, 8450, 9100, 9749, 10399, 11048, 11697, 12346, 12994, 13642, 14290, 14937, 15583, 16229, 16873, 17517, 18159, 18800, 19439, 20076, 20711, 21343, 21973, 22600, 23223, 23842, 24457, 25068, 25673, 26273, 26866, 27453, 28033, 28605, 29169, 29724, 30269, 30805, 31329, 31843, 32345, 32835, 33312, 33778, 34231, 34673, 35103, 35521, 35929, 36326, 36713, 37090, 37457, 37814, 38162, 38501, 38832, 39154, 39468, 39774, 40073, 40364, 40648, 40926, 41196, 41461, 41719, 41971, 42217, 42457, 42692, 42922, 43147, 43367, 43582, 43792, 43998, 44199, 44397, 44590, 44779, 44964, 45146, 45324, 45498, 45670, 45837, 46002, 46163, 46322, 46477, 46630, 46780, 46927, 47071, 47213, 47352, 47489, 47624, 47756, 47886, 48014, 48140, 48264, 48385, 48505, 48623, 48739, 48853, 48965, 49076, 49185, 49292, 49397, 49501, 49604, 49705, 49804, 49902, 49999, 50094, 50188, 50280, 50372, 50462, 50550, 50638, 50724, 50809, 50893, 50976, 51058, 51139, 51219, 51298, 51375, 51452, 51528, 51603, 51677, 51750, 51822, 51893, 51963, 52033, 52102, 52170, 52237, 52303, 52369, 52433, 52498, 52561, 52624, 52685, 52747, 52807, 52867, 52926, 52985, 53043, 53100, 53157, 53213, 53269, 53324, 53378, 53432, 53485, 53538, 53590, 53642, 53693, 53744, 53794, 53844, 53893, 53942, 53990, 54038, 54085, 54132, 54178, 54224, 54270, 54315, 54360, 54404, 54448, 54491, 54534, 54577, 54619, 54661, 54703, 54744, 54785, 54825, 54866, 54905, 54945, 54984, 55023, 55061, 55099, 55137, 55175, 55212, 55249, 55285, 55321, 55357, 55393, 55428, 55463, 55498, 55533, 55567, 55601, 55635, 55668, 55701, 55734, 55767, 55800, 55832, 55864, 55895, 55927, 55958, 55989, 56020, 56050, 56081, 56111, 56141, 56170, 56200, 56229, 56258, 56287, 56315, 56344, 56372, 56400, 56428, 56455, 56483, 56510, 56537, 56564, 56590, 56617, 56643, 56669, 56695, 56721, 56746, 56772, 56797, 56822, 56847, 56872, 56896, 56921, 56945, 56969, 56993, 57017, 57041, 57064, 57087, 57111, 57134, 57157, 57179, 57202, 57224, 57247, 57269, 57291, 57313, 57335, 57356, 57378, 57399, 57421, 57442, 57463, 57484, 57505, 57525, 57546, 57566, 57586, 57607, 57627, 57647, 57666, 57686, 57706, 57725, 57745, 57764, 57783, 57802, 57821, 57840, 57858, 57877, 57896, 57914, 57932, 57951, 57969, 57987, 58005, 58022, 58040, 58058, 58075, 58093, 58110, 58127, 58144, 58161, 58178, 58195, 58212, 58229, 58245, 58262, 58278, 58295, 58311, 58327, 58343, 58359, 58375, 58391, 58407, 58423, 58438, 58454, 58469, 58485, 58500, 58515, 58530, 58545, 58560, 58575, 58590, 58605, 58620, 58634, 58649, 58664, 58678, 58692, 58707, 58721, 58735, 58749, 58763, 58777, 58791, 58805, 58819, 58832, 58846, 58860, 58873, 58886, 58900, 58913, 58926, 58940, 58953, 58966, 58979, 58992, 59005, 59018, 59030, 59043, 59056, 59068, 59081, 59094, 59106, 59118, 59131, 59143, 59155, 59167, 59180, 59192, 59204, 59216, 59228, 59239, 59251, 59263, 59275, 59286, 59298, 59310, 59321, 59332, 59344, 59355, 59367, 59378, 59389, 59400, 59411, 59423, 59434, 59445, 59456, 59466, 59477, 59488, 59499, 59510, 59520, 59531, 59542, 59552, 59563, 59573, 59583, 59594, 59604, 59615, 59625, 59635, 59645, 59655, 59665, 59676, 59686, 59696, 59705, 59715, 59725, 59735, 59745, 59755, 59764, 59774, 59784, 59793, 59803, 59812, 59822, 59831, 59841, 59850, 59859, 59869, 59878, 59887, 59897, 59906, 59915, 59924, 59933, 59942, 59951, 59960, 59969, 59978, 59987, 59996, 60005, 60013, 60022, 60031, 60039, 60048, 60057, 60065, 60074, 60082, 60091, 60099, 60108, 60116, 60125, 60133, 60141, 60150, 60158, 60166, 60174, 60183, 60191, 60199, 60207, 60215, 60223, 60231, 60239, 60247, 60255, 60263, 60271, 60278, 60286, 60294, 60302, 60310, 60317, 60325, 60333, 60340, 60348, 60356, 60363, 60371, 60378, 60386, 60393, 60401, 60408, 60415, 60423, 60430, 60437, 60445, 60452, 60459, 60466, 60474, 60481, 60488, 60495, 60502, 60509, 60516, 60523, 60530, 60537, 60544, 60551, 60558, 60565, 60572, 60579, 60586, 60592, 60599, 60606, 60613, 60619, 60626, 60633, 60639, 60646, 60653, 60659, 60666, 60672, 60679, 60686, 60692, 60699, 60705, 60711, 60718, 60724, 60731, 60737, 60743, 60750, 60756, 60762, 60769, 60775, 60781, 60787, 60793, 60800, 60806, 60812, 60818, 60824, 60830, 60836, 60842, 60848, 60854, 60860, 60866, 60872, 60878, 60884, 60890, 60896, 60902, 60908, 60914, 60919, 60925, 60931, 60937, 60942, 60948, 60954, 60960, 60965, 60971, 60977, 60982, 60988, 60994, 60999, 61005, 61010, 61016, 61021, 61027, 61032, 61038, 61043, 61049, 61054, 61060, 61065, 61070, 61076, 61081, 61087, 61092, 61097, 61103, 61108, 61113, 61118, 61124, 61129, 61134, 61139, 61145, 61150, 61155, 61160, 61165, 61170, 61175, 61180, 61186, 61191, 61196, 61201, 61206, 61211, 61216, 61221, 61226, 61231, 61236, 61241, 61245, 61250, 61255, 61260, 61265, 61270, 61275, 61280, 61284, 61289, 61294, 61299, 61304, 61308, 61313, 61318, 61323, 61327, 61332, 61337, 61341, 61346, 61351, 61355, 61360, 61364, 61369, 61374, 61378, 61383, 61387, 61392, 61396, 61401, 61405, 61410, 61414, 61419, 61423, 61428, 61432, 61437, 61441, 61446, 61450, 61454, 61459, 61463, 61467, 61472, 61476, 61480, 61485, 61489, 61493, 61498, 61502, 61506, 61510, 61515, 61519, 61523, 61527, 61532, 61536, 61540, 61544, 61548, 61552, 61557, 61561, 61565, 61569, 61573, 61577, 61581, 61585, 61589, 61593, 61597, 61601, 61605, 61609, 61613, 61617, 61621, 61625, 61629, 61633, 61637, 61641, 61645, 61649, 61653, 61657, 61661, 61665, 61669, 61672, 61676, 61680, 61684, 61688, 61692, 61695, 61699, 61703, 61707, 61711, 61714, 61718, 61722, 61726, 61729, 61733, 61737, 61741, 61744, 61748, 61752, 61755, 61759, 61763, 61766, 61770, 61774, 61777, 61781, 61784, 61788, 61792, 61795, 61799, 61802, 61806, 61809, 61813, 61817, 61820, 61824, 61827, 61831, 61834, 61838, 61841, 61845, 61848, 61852, 61855, 61859, 61862, 61865, 61869, 61872, 61876, 61879, 61882, 61886, 61889, 61893, 61896, 61899, 61903, 61906, 61909, 61913, 61916, 61919, 61923, 61926, 61929, 61933, 61936, 61939, 61942, 61946, 61949, 61952, 61955, 61959, 61962, 61965, 61968, 61972, 61975, 61978, 61981, 61984, 61987, 61991, 61994, 61997, 62000, 62003, 62006, 62010, 62013, 62016, 62019, 62022, 62025, 62028, 62031, 62034, 62037, 62041, 62044, 62047, 62050, 62053, 62056, 62059, 62062, 62065, 62068, 62071, 62074, 62077, 62080, 62083, 62086, 62089, 62092, 62095, 62098, 62101, 62104, 62106, 62109, 62112, 62115, 62118, 62121, 62124, 62127, 62130, 62133, 62136, 62138, 62141, 62144, 62147, 62150, 62153, 62155, 62158, 62161, 62164, 62167, 62170, 62172, 62175, 62178, 62181, 62184, 62186, 62189, 62192, 62195, 62197, 62200, 62203, 62206, 62208, 62211, 62214, 62217, 62219, 62222, 62225, 62227, 62230, 62233, 62235, 62238, 62241, 62244, 62246, 62249, 62252, 62254, 62257, 62259, 62262, 62265, 62267, 62270, 62273, 62275, 62278, 62280, 62283, 62286, 62288, 62291, 62293, 62296, 62298, 62301, 62304, 62306, 62309, 62311, 62314, 62316, 62319, 62321, 62324, 62326, 62329, 62331, 62334, 62336, 62339, 62341, 62344, 62346, 62349, 62351, 62354, 62356, 62359, 62361, 62364, 62366, 62368, 62371, 62373, 62376, 62378, 62381, 62383, 62385, 62388, 62390, 62393, 62395, 62397, 62400, 62402, 62405, 62407, 62409, 62412, 62414, 62416, 62419, 62421, 62423, 62426, 62428, 62430, 62433, 62435, 62437, 62440, 62442, 62444, 62447, 62449, 62451, 62453, 62456, 62458, 62460, 62463, 62465, 62467, 62469, 62472, 62474, 62476, 62478, 62481, 62483, 62485, 62487, 62490, 62492, 62494, 62496, 62498, 62501, 62503, 62505, 62507, 62509, 62512, 62514, 62516, 62518, 62520, 62523, 62525, 62527, 62529, 62531, 62533, 62535, 62538, 62540, 62542, 62544, 62546, 62548, 62550, 62553, 62555, 62557, 62559, 62561, 62563, 62565, 62567, 62569, 62572, 62574, 62576, 62578, 62580, 62582, 62584, 62586, 62588, 62590, 62592, 62594, 62596, 62598, 62600, 62602, 62605, 62607, 62609, 62611, 62613, 62615, 62617, 62619, 62621, 62623, 62625, 62627, 62629, 62631, 62633, 62635, 62637, 62639, 62641, 62643, 62645, 62646, 62648, 62650, 62652, 62654, 62656, 62658, 62660, 62662, 62664, 62666, 62668, 62670, 62672, 62674, 62676, 62678, 62679, 62681, 62683, 62685, 62687, 62689, 62691, 62693, 62695, 62697, 62698, 62700, 62702, 62704, 62706, 62708, 62710, 62712, 62714, 62715, 62717, 62719, 62721, 62723, 62725, 62726, 62728, 62730, 62732, 62734, 62736, 62737, 62739, 62741, 62743, 62745, 62746, 62748, 62750, 62752, 62754, 62756, 62757, 62759, 62761, 62763, 62765, 62766, 62768, 62770, 62772, 62773, 62775, 62777, 62779, 62780, 62782, 62784, 62786, 62787, 62789, 62791, 62793, 62794, 62796, 62798, 62800, 62801, 62803, 62805, 62807, 62808, 62810, 62812, 62813, 62815, 62817, 62819, 62820, 62822, 62824, 62825, 62827, 62829, 62830, 62832, 62834, 62835, 62837, 62839, 62840, 62842, 62844, 62845, 62847, 62849, 62850, 62852, 62854, 62855, 62857, 62859, 62860, 62862, 62864, 62865, 62867, 62869, 62870, 62872, 62873, 62875, 62877, 62878, 62880, 62881, 62883, 62885, 62886, 62888, 62889, 62891, 62893, 62894, 62896, 62897, 62899, 62900, 62902, 62904, 62905, 62907, 62908, 62910, 62912, 62913, 62915, 62916, 62918, 62919, 62921, 62923, 62924, 62926, 62927, 62929, 62930, 62932, 62933, 62935, 62936, 62938, 62939, 62941, 62942, 62944, 62945, 62947, 62949, 62950, 62952, 62953, 62955, 62956, 62958, 62959, 62961, 62962, 62964, 62965, 62967, 62968, 62970, 62971, 62973, 62974, 62976, 62977, 62979, 62980, 62981, 62983, 62984, 62986, 62987, 62989, 62990, 62992, 62993, 62995, 62996, 62997, 62999, 63000, 63002, 63003, 63005, 63006, 63007, 63009, 63010, 63012, 63013, 63015, 63016, 63017, 63019, 63020, 63022, 63023, 63025, 63026, 63027, 63029, 63030, 63032, 63033, 63034, 63036, 63037, 63039, 63040, 63042, 63043, 63044, 63046, 63047, 63048, 63050, 63051, 63052, 63054, 63055, 63057, 63058, 63059, 63061, 63062, 63063, 63065, 63066, 63067, 63069, 63070, 63071, 63073, 63074, 63076, 63077, 63078, 63080, 63081, 63082, 63084, 63085, 63086, 63088, 63089, 63090, 63092, 63093, 63094, 63096, 63097, 63098, 63100, 63101, 63102, 63104, 63105, 63106, 63107, 63109, 63110, 63111, 63113, 63114, 63115, 63116, 63118, 63119, 63120, 63122, 63123, 63124, 63125, 63127, 63128, 63129, 63130, 63132, 63133, 63134, 63136, 63137, 63138, 63139, 63141, 63142, 63143, 63144, 63146, 63147, 63148, 63149, 63151, 63152, 63153, 63154, 63156, 63157, 63158, 63159, 63161, 63162, 63163, 63164, 63166, 63167, 63168, 63169, 63171, 63172, 63173, 63174, 63175, 63177, 63178, 63179, 63180, 63181, 63183, 63184, 63185, 63186, 63187, 63189, 63190, 63191, 63192, 63193, 63195, 63196, 63197, 63198, 63199, 63200, 63202, 63203, 63204, 63205, 63206, 63208, 63209, 63210, 63211, 63212, 63214, 63215, 63216, 63217, 63218, 63219, 63221, 63222, 63223, 63224, 63225, 63226, 63228, 63229, 63230, 63231, 63232, 63233, 63234, 63236, 63237, 63238, 63239, 63240, 63241, 63242, 63243, 63245, 63246, 63247, 63248, 63249, 63250, 63251, 63252, 63254, 63255, 63256, 63257, 63258, 63259, 63260, 63261, 63262, 63264, 63265, 63266, 63267, 63268, 63269, 63270, 63271, 63272, 63274, 63275, 63276, 63277, 63278, 63279, 63280, 63281, 63282, 63283, 63285, 63286, 63287, 63288, 63289, 63290, 63291, 63292, 63293, 63294, 63295, 63297, 63298, 63299, 63300, 63301, 63302, 63303, 63304, 63305, 63306, 63307, 63308, 63309, 63310, 63311, 63312, 63313, 63314, 63315, 63316, 63318, 63319, 63320, 63321, 63322, 63323, 63324, 63325, 63326, 63327, 63328, 63329, 63330, 63331, 63332, 63333, 63334, 63335, 63336, 63337, 63338, 63339, 63340, 63341, 63342, 63343, 63344, 63345, 63346, 63347, 63348, 63349, 63350, 63351, 63353, 63354, 63355, 63356, 63357, 63358, 63359, 63360, 63361, 63362, 63363, 63364, 63365, 63366, 63367, 63368, 63369, 63370, 63371, 63372, 63373, 63374, 63375, 63375, 63376, 63377, 63378, 63379, 63380, 63381, 63382, 63383, 63384, 63385, 63386, 63387, 63388, 63389, 63390, 63391, 63392, 63393, 63394, 63395, 63396, 63397, 63398, 63399, 63399, 63400, 63401, 63402, 63403, 63404, 63405, 63406, 63407, 63408, 63409, 63410, 63411, 63412, 63413, 63414, 63415, 63416, 63417, 63418, 63418, 63419, 63420, 63421, 63422, 63423, 63424, 63425, 63426, 63427, 63428, 63429, 63430, 63431, 63432, 63433, 63433, 63434, 63435, 63436, 63437, 63438, 63439, 63440, 63441, 63442, 63443, 63444, 63444, 63445, 63446, 63447, 63448, 63449, 63450, 63451, 63452, 63452, 63453, 63454, 63455, 63456, 63457, 63458, 63459, 63460, 63460, 63461, 63462, 63463, 63464, 63465, 63466, 63467, 63467, 63468, 63469, 63470, 63471, 63472, 63473, 63474, 63474, 63475, 63476, 63477, 63478, 63479, 63480, 63481, 63481, 63482, 63483, 63484, 63485, 63486, 63487, 63488, 63488, 63489, 63490, 63491, 63492, 63493, 63494, 63494, 63495, 63496, 63497, 63498, 63499, 63500, 63500, 63501, 63502, 63503, 63504, 63505, 63506, 63507, 63507, 63508, 63509, 63510, 63511, 63512, 63513, 63513, 63514, 63515, 63516, 63517, 63518, 63518, 63519, 63520, 63521, 63522, 63522, 63523, 63524, 63525, 63526, 63526, 63527, 63528, 63529, 63530, 63530, 63531, 63532, 63533, 63534, 63535, 63535, 63536, 63537, 63538, 63539, 63539, 63540, 63541, 63542, 63543, 63543, 63544, 63545, 63546, 63547, 63547, 63548, 63549, 63550, 63550, 63551, 63552, 63553, 63554, 63554, 63555, 63556, 63557, 63558, 63558, 63559, 63560, 63561, 63562, 63562, 63563, 63564, 63565, 63566, 63566, 63567, 63568, 63569, 63569, 63570, 63571, 63572, 63573, 63573, 63574, 63575, 63576, 63577, 63577, 63578, 63579, 63580, 63580, 63581, 63582, 63583, 63584, 63584, 63585, 63586, 63587, 63587, 63588, 63589, 63590, 63591, 63591, 63592, 63593, 63594, 63594, 63595, 63596, 63597, 63597, 63598, 63599, 63600, 63600, 63601, 63602, 63603, 63603, 63604, 63605, 63606, 63606, 63607, 63608, 63608, 63609, 63610, 63611, 63611, 63612, 63613, 63613, 63614, 63615, 63616, 63616, 63617, 63618, 63619, 63619, 63620, 63621, 63621, 63622, 63623, 63624, 63624, 63625, 63626, 63626, 63627, 63628, 63629, 63629, 63630, 63631, 63632, 63632, 63633, 63634, 63634, 63635, 63636, 63637, 63637, 63638, 63639, 63639, 63640, 63641, 63642, 63642, 63643, 63644, 63644, 63645, 63646, 63647, 63647, 63648, 63649, 63649, 63650, 63651, 63651, 63652, 63653, 63654, 63654, 63655, 63656, 63656, 63657, 63658, 63659, 63659, 63660, 63661, 63661, 63662, 63663, 63663, 63664, 63665, 63666, 63666, 63667, 63668, 63668, 63669, 63670, 63670, 63671, 63672, 63673, 63673, 63674, 63675, 63675, 63676, 63677, 63677, 63678, 63679, 63679, 63680, 63681, 63682, 63682, 63683, 63683, 63684, 63685, 63685, 63686, 63687, 63687, 63688, 63689, 63689, 63690, 63691, 63691, 63692, 63693, 63693, 63694, 63695, 63695, 63696, 63696, 63697, 63698, 63698, 63699, 63700, 63700, 63701, 63702, 63702, 63703, 63704, 63704, 63705, 63706, 63706, 63707, 63707, 63708, 63709, 63709, 63710, 63711, 63711, 63712, 63713, 63713, 63714, 63714, 63715, 63716, 63716, 63717, 63718, 63718, 63719, 63720, 63720, 63721, 63721, 63722, 63723, 63723, 63724, 63725, 63725, 63726, 63727, 63727, 63728, 63728, 63729, 63730, 63730, 63731, 63732, 63732, 63733, 63734, 63734, 63735, 63735, 63736, 63737, 63737, 63738, 63739, 63739, 63740, 63740, 63741, 63742, 63742, 63743, 63744, 63744, 63745, 63745, 63746, 63747, 63747, 63748, 63749, 63749, 63750, 63750, 63751, 63752, 63752, 63753, 63754, 63754, 63755, 63755, 63756, 63757, 63757, 63758, 63759, 63759, 63760, 63760, 63761, 63762, 63762, 63763, 63763, 63764, 63765, 63765, 63766, 63767, 63767, 63768, 63768, 63769, 63770, 63770, 63771, 63771, 63772, 63773, 63773, 63774, 63774, 63775, 63775, 63776, 63777, 63777, 63778, 63778, 63779, 63779, 63780, 63781, 63781, 63782, 63782, 63783, 63783, 63784, 63785, 63785, 63786, 63786, 63787, 63787, 63788, 63789, 63789, 63790, 63790, 63791, 63791, 63792, 63793, 63793, 63794, 63794, 63795, 63795, 63796, 63796, 63797, 63798, 63798, 63799, 63799, 63800, 63800, 63801, 63802, 63802, 63803, 63803, 63804, 63804, 63805, 63805, 63806, 63807, 63807, 63808, 63808, 63809, 63809, 63810, 63810, 63811, 63812, 63812, 63813, 63813, 63814, 63814, 63815, 63815, 63816, 63817, 63817, 63818, 63818, 63819, 63819, 63820, 63820, 63821, 63822, 63822, 63823, 63823, 63824, 63824, 63825, 63825, 63826, 63827, 63827, 63828, 63828, 63829, 63829, 63830, 63830, 63831, 63832, 63832, 63833, 63833, 63834, 63834, 63835, 63835, 63836, 63836, 63837, 63838, 63838, 63839, 63839, 63840, 63840, 63841, 63841, 63842, 63842, 63843, 63844, 63844, 63845, 63845, 63846, 63846, 63847, 63847, 63848, 63848, 63849, 63850, 63850, 63851, 63851, 63852, 63852, 63853, 63853, 63854, 63854, 63855, 63855, 63856, 63857, 63857, 63858, 63858, 63859, 63859, 63860, 63860, 63861, 63861, 63862, 63862, 63863, 63864, 63864, 63865, 63865, 63866, 63866, 63867, 63867, 63868, 63868, 63869, 63869, 63870, 63870, 63871, 63871, 63872, 63872, 63873, 63873, 63874, 63874, 63875, 63875, 63876, 63876, 63877, 63877, 63878, 63878, 63879, 63879, 63880, 63880, 63881, 63881, 63881, 63882, 63882, 63883, 63883, 63884, 63884, 63885, 63885, 63886, 63886, 63887, 63887, 63888, 63888, 63889, 63889, 63890, 63890, 63891, 63891, 63892, 63892, 63893, 63893, 63894, 63894, 63895, 63895, 63896, 63896, 63897, 63897, 63898, 63898, 63899, 63899, 63899, 63900, 63900, 63901, 63901, 63902, 63902, 63903, 63903, 63904, 63904, 63905, 63905, 63906, 63906, 63907, 63907, 63908, 63908, 63909, 63909, 63910, 63910, 63911, 63911, 63911, 63912, 63912, 63913, 63913, 63914, 63914, 63915, 63915, 63916, 63916, 63917, 63917, 63918, 63918, 63919, 63919, 63920, 63920, 63921, 63921, 63921, 63922, 63922, 63923, 63923, 63924, 63924, 63925, 63925, 63926, 63926, 63927, 63927, 63928, 63928, 63929, 63929, 63930, 63930, 63930, 63931, 63931, 63932, 63932, 63933, 63933, 63934, 63934, 63935, 63935, 63936, 63936, 63937, 63937, 63937, 63938, 63938, 63939, 63939, 63940, 63940, 63941, 63941, 63942, 63942, 63943, 63943, 63944, 63944, 63944, 63945, 63945, 63946, 63946, 63947, 63947, 63948, 63948, 63949, 63949, 63950, 63950, 63951, 63951, 63951, 63952, 63952, 63953, 63953, 63954, 63954, 63955, 63955, 63956, 63956, 63957, 63957, 63957, 63958, 63958, 63959, 63959, 63960, 63960, 63961, 63961, 63962, 63962, 63963, 63963, 63963, 63964, 63964, 63965, 63965, 63966, 63966, 63967, 63967, 63968, 63968, 63968, 63969, 63969, 63970, 63970, 63971, 63971, 63972, 63972, 63972, 63973, 63973, 63974, 63974, 63974, 63975, 63975, 63976, 63976, 63976, 63977, 63977, 63978, 63978, 63979, 63979, 63979, 63980, 63980, 63981, 63981, 63981, 63982, 63982, 63983, 63983, 63983, 63984, 63984, 63985, 63985, 63986, 63986, 63986, 63987, 63987, 63988, 63988, 63988, 63989, 63989, 63990, 63990, 63990, 63991, 63991, 63992, 63992, 63993, 63993, 63993, 63994, 63994, 63995, 63995, 63995, 63996, 63996, 63997, 63997, 63997, 63998, 63998, 63999, 63999, 63999, 64000, 64000, 64001, 64001, 64001, 64002, 64002, 64003, 64003, 64003, 64004, 64004, 64005, 64005, 64005, 64006, 64006, 64007, 64007, 64008, 64008, 64008, 64009, 64009, 64010, 64010, 64010, 64011, 64011, 64012, 64012, 64012, 64013, 64013, 64014, 64014, 64014, 64015, 64015, 64016, 64016, 64016, 64017, 64017, 64018, 64018, 64018, 64019, 64019, 64020, 64020, 64020, 64021, 64021, 64022, 64022, 64022, 64023, 64023, 64024, 64024, 64024, 64025, 64025, 64025, 64026, 64026, 64027, 64027, 64027, 64028, 64028, 64029, 64029, 64029, 64030, 64030, 64031, 64031, 64031, 64032, 64032, 64033, 64033, 64033, 64034, 64034, 64035, 64035, 64035, 64036, 64036, 64037, 64037, 64037, 64038, 64038, 64039, 64039, 64039, 64040, 64040, 64040, 64041, 64041, 64042, 64042, 64042, 64043, 64043, 64044, 64044, 64044, 64045, 64045, 64046, 64046, 64046, 64047, 64047, 64047, 64048, 64048, 64049, 64049, 64049, 64050, 64050, 64051, 64051, 64051, 64052, 64052, 64053, 64053, 64053, 64054, 64054, 64054, 64055, 64055, 64056, 64056, 64056, 64057, 64057, 64058, 64058, 64058, 64059, 64059, 64059, 64060, 64060, 64061, 64061, 64061, 64062, 64062, 64063, 64063, 64063, 64064, 64064, 64064, 64065, 64065, 64066, 64066, 64066, 64067, 64067, 64068, 64068, 64068, 64069, 64069, 64069, 64070, 64070, 64071, 64071, 64071, 64072, 64072, 64072, 64073, 64073, 64074, 64074, 64074, 64075, 64075, 64076, 64076, 64076, 64077, 64077, 64077, 64078, 64078, 64079, 64079, 64079, 64080, 64080, 64080, 64081, 64081, 64082, 64082, 64082, 64083, 64083, 64083, 64084, 64084, 64084, 64085, 64085, 64085, 64086, 64086, 64086, 64087, 64087, 64087, 64088, 64088, 64088, 64089, 64089, 64089, 64090, 64090, 64090, 64091, 64091, 64091, 64092, 64092, 64092, 64093, 64093, 64093, 64094, 64094, 64094, 64095, 64095, 64095, 64096, 64096, 64096, 64097, 64097, 64097, 64098, 64098, 64098, 64099, 64099, 64099, 64100, 64100, 64100, 64101, 64101, 64101, 64102, 64102, 64102, 64103, 64103, 64103, 64104, 64104, 64104, 64105, 64105, 64105, 64106, 64106, 64106, 64107, 64107, 64107, 64108, 64108, 64108, 64109, 64109, 64109, 64110, 64110, 64110, 64111, 64111, 64111, 64112, 64112, 64112, 64113, 64113, 64113, 64114, 64114, 64114, 64115, 64115, 64115, 64116, 64116, 64116, 64117, 64117, 64117, 64118, 64118, 64118, 64119, 64119, 64119, 64120, 64120, 64120, 64120, 64121, 64121, 64121, 64122, 64122, 64122, 64123, 64123, 64123, 64124, 64124, 64124, 64125, 64125, 64125, 64126, 64126, 64126, 64127, 64127, 64127, 64128, 64128, 64128, 64129, 64129, 64129, 64130, 64130, 64130, 64131, 64131, 64131, 64131, 64132, 64132, 64132, 64133, 64133, 64133, 64134, 64134, 64134, 64135, 64135, 64135, 64136, 64136, 64136, 64137, 64137, 64137, 64138, 64138, 64138, 64139, 64139, 64139, 64140, 64140, 64140, 64140, 64141, 64141, 64141, 64142, 64142, 64142, 64143, 64143, 64143, 64144, 64144, 64144, 64145, 64145, 64145, 64146, 64146, 64146, 64146, 64147, 64147, 64147, 64148, 64148, 64148, 64149, 64149, 64149, 64150, 64150, 64150, 64151, 64151, 64151, 64152, 64152, 64152, 64153, 64153, 64153, 64153, 64154, 64154, 64154, 64155, 64155, 64155, 64156, 64156, 64156, 64157, 64157, 64157, 64158, 64158, 64158, 64158, 64159, 64159, 64159, 64160, 64160, 64160, 64161, 64161, 64161, 64162, 64162, 64162, 64163, 64163, 64163, 64163, 64164, 64164, 64164, 64165, 64165, 64165, 64166, 64166, 64166, 64167, 64167, 64167, 64167, 64168, 64168, 64168, 64169, 64169, 64169, 64170, 64170, 64170, 64171, 64171, 64171, 64172, 64172, 64172, 64172, 64173, 64173, 64173, 64174, 64174, 64174, 64175, 64175, 64175, 64176, 64176, 64176, 64176, 64177, 64177, 64177, 64178, 64178, 64178, 64179, 64179, 64179, 64180, 64180, 64180, 64180, 64181, 64181, 64181, 64182, 64182, 64182, 64183, 64183, 64183, 64183, 64184, 64184, 64184, 64185, 64185, 64185, 64186, 64186, 64186, 64187, 64187, 64187, 64187, 64188, 64188, 64188, 64189, 64189, 64189, 64190, 64190, 64190, 64191, 64191, 64191, 64191, 64192, 64192, 64192, 64193, 64193, 64193, 64194, 64194, 64194, 64194, 64195, 64195, 64195, 64196, 64196, 64196, 64197, 64197, 64197, 64197, 64198, 64198, 64198, 64199, 64199, 64199, 64200, 64200, 64200, 64200, 64201, 64201, 64201, 64202, 64202, 64202, 64203, 64203, 64203, 64203, 64204, 64204, 64204, 64205, 64205, 64205, 64206, 64206, 64206, 64206, 64207, 64207, 64207, 64208, 64208, 64208, 64209, 64209, 64209, 64209, 64210, 64210, 64210, 64211, 64211, 64211, 64211, 64212, 64212, 64212, 64212, 64213, 64213, 64213, 64213, 64214, 64214, 64214, 64214, 64215, 64215, 64215, 64215, 64216, 64216, 64216, 64216, 64217, 64217, 64217, 64217, 64218, 64218, 64218, 64218, 64219, 64219, 64219, 64220, 64220, 64220, 64220, 64221, 64221, 64221, 64221, 64222, 64222, 64222, 64222, 64223, 64223, 64223, 64223, 64224, 64224, 64224, 64224, 64225, 64225, 64225, 64225, 64226, 64226, 64226, 64226, 64227, 64227, 64227, 64227, 64228 };
        public static Dictionary<String, String> planetFinder = new Dictionary<String, String>() {
                    {" Moho","Moho"},
                    {" Eve","Eve"},
                    {" Gilly","Gilly"},
                    {" Duna","Duna"},
                    {" Ike","Ike"},
                    {" Dres","Dres"},
                    {" Jool","Jool"},
                    {" Laythe","Laythe"},
                    {" Vall","Vall"},
                    {" Tylo","Tylo"},
                    {" Bop","Bop"},
                    {" Pol","Pol"},
                    {" Eeloo","Eeloo"},
                    {" Mun","Mun"},
                    {" Minmus","Minmus"},
                    {" Kerbol","Sun"},
                    {" Sonne","Sun"},
                    {" Sun","Sun"},
                    {" Sol","Sun"},
                    {" Kerbin","Kerbin"}};


        private bool RealtimeFundingDebug = true;
        private bool RealtimeFundingThrottle = true;
        private String logOutput = "[RTF] ";

        internal RealtimeFunding()
        {
            instance = this;
        }
        private void Awake()
        {
            GameEvents.onGameStateLoad.Add(onGameStateLoad);
            DontDestroyOnLoad(this);
        }
        bool initted = false;
        void doInit()
        {
            if (!initted)
            {
                GameEvents.onGUIRnDComplexSpawn.Add(HideGUI);
                GameEvents.onGUIApplicationLauncherReady.Add(OnGUIApplicationLauncherReady);
                GameEvents.Contract.onCompleted.Add(OnContractCompleted);
                GameEvents.Contract.onAccepted.Add(OnContractAccepted);
                GameEvents.onGUIAdministrationFacilitySpawn.Add(openGUI);
                GameEvents.onGUIAdministrationFacilityDespawn.Add(closeGUI);
                GameEvents.onGUIMissionControlSpawn.Add(openGUI);
                GameEvents.onGUIMissionControlDespawn.Add(closeGUI);
                GameEvents.onGUIRnDComplexSpawn.Add(openGUI);
                GameEvents.onGUIRnDComplexDespawn.Add(closeGUI);
                GameEvents.onGUIAstronautComplexSpawn.Add(openGUI);
                GameEvents.onGUIAstronautComplexDespawn.Add(closeGUI);
                var game = HighLogic.CurrentGame;
                initted = true;
                // ProtoScenarioModule psm = game.scenarios.Find(s => s.moduleName == typeof(RealtimeFundingData).Name);
                //if (psm == null)
                {
                    //psm = game.AddProtoScenarioModule(typeof(RealtimeFundingData), GameScenes.SPACECENTER);
                }
            }
        }

        private void closeGUI()
        {
            GUIopen = false;
            //Log("this message should only show once");
        }

        private void openGUI()
        {
            GUIopen = true;
            //Log("this other message should also only show once");
        }

        private void onGameStateLoad(ConfigNode node)
        {
            if (HighLogic.CurrentGame != null && HighLogic.CurrentGame.Mode != Game.Modes.CAREER)
            {
                if (initted)
                {

                    GameEvents.onGUIRnDComplexSpawn.Remove(HideGUI);
                    GameEvents.onGUIApplicationLauncherReady.Remove(OnGUIApplicationLauncherReady);
                    GameEvents.Contract.onCompleted.Remove(OnContractCompleted);
                    GameEvents.Contract.onAccepted.Remove(OnContractAccepted);
                    GameEvents.onGUIAdministrationFacilitySpawn.Remove(openGUI);
                    GameEvents.onGUIAdministrationFacilityDespawn.Remove(closeGUI);
                    GameEvents.onGUIMissionControlSpawn.Remove(openGUI);
                    GameEvents.onGUIMissionControlDespawn.Remove(closeGUI);
                    GameEvents.onGUIRnDComplexSpawn.Remove(openGUI);
                    GameEvents.onGUIRnDComplexDespawn.Remove(closeGUI);
                    GameEvents.onGUIAstronautComplexSpawn.Remove(openGUI);
                    GameEvents.onGUIAstronautComplexDespawn.Remove(closeGUI);
                    if (toolbarControl != null)
                    {
                        toolbarControl.OnDestroy();
                        Destroy(toolbarControl);
                    }
                    initted = false;
                }

                return;
            }
            doInit();
        }

        public void OnDestroy()
        {
            GameEvents.onGameStateLoad.Remove(onGameStateLoad);
        }

        public void OnDisable()
        {
            if (HighLogic.CurrentGame != null && HighLogic.CurrentGame.Mode != Game.Modes.CAREER)
                return;

            ShowGUI = false;
        }

        #region GUI
        private bool stylesSetup = false;
        bool windowPosInitted = false;
        private Rect windowPos = new Rect(580f, 40f, 1f, 1f);
        private bool ShowSettings = false;
        private bool ShowGUI = false;
        private static GUIStyle headerText;
        private static GUIStyle bigHeaderText;
        private static GUIStyle normalText;

        private void SetupStyles()
        {
            stylesSetup = true;

            headerText = new GUIStyle(GUI.skin.label);
            headerText.normal.textColor = Color.white;
            headerText.fontStyle = FontStyle.Bold;
            headerText.alignment = TextAnchor.MiddleLeft;

            bigHeaderText = new GUIStyle(GUI.skin.label);
            bigHeaderText.normal.textColor = Color.white;
            bigHeaderText.fontSize = 18;
            bigHeaderText.fontStyle = FontStyle.Bold;
            bigHeaderText.alignment = TextAnchor.MiddleCenter;

            normalText = new GUIStyle(GUI.skin.label);
            normalText.normal.textColor = Color.white;
            normalText.fontStyle = FontStyle.Normal;
            normalText.alignment = TextAnchor.MiddleLeft;
        }

        private void OnGUIApplicationLauncherReady()
        {
            if (HighLogic.CurrentGame != null && HighLogic.CurrentGame.Mode == Game.Modes.CAREER)
            {
                if (toolbarControl == null)
                {
                    toolbarControl = gameObject.AddComponent<ToolbarControl>();
                    toolbarControl.AddToAllToolbars(GUISwitch, GUISwitch,
                        ApplicationLauncher.AppScenes.SPACECENTER |
                        ApplicationLauncher.AppScenes.MAPVIEW,
                        "RealtimeFunding_NS",
                        "RealtimeFundingButton",
                        "RealtimeFunding/PluginData/Icon_38",
                        "RealtimeFunding/PluginData/Icon_24",
                        "RealtimeFunding"
                    );
                    toolbarControl.UseBlizzy(HighLogic.CurrentGame.Parameters.CustomParams<rfunding>().useBlizzy);

                }
            }
        }

        public void HideGUI()
        {
            ShowGUI = false;
        }

        public void GUISwitch()
        {
            if (ShowGUI == false)
            {
                ShowGUI = true;
            }
            else
            {
                ShowGUI = !ShowGUI;
            }
        }

        //OnDraw Shows the MainGUI Window
        private void OnGUI()
        {
            if (HighLogic.CurrentGame == null || HighLogic.CurrentGame.Mode != Game.Modes.CAREER)
                return;
            if (toolbarControl != null)
                toolbarControl.UseBlizzy(HighLogic.CurrentGame.Parameters.CustomParams<rfunding>().useBlizzy);

            GUI.skin.window.richText = true;
            if (HighLogic.LoadedScene == GameScenes.SPACECENTER && ShowGUI == true)
            {
                if (!stylesSetup)
                {
                    SetupStyles();
                }

                GUI.skin = HighLogic.Skin;
                if (!windowPosInitted && windowPos.height > 1)
                {
                    windowPos.xMin = Screen.width - 336 - 14;
                    windowPos.yMin = Screen.height - windowPos.height - 40f;
                    windowPos.yMax = Screen.height - 40f;
                    windowPosInitted = true;
                }
                windowPos = ClickThruBlocker.GUILayoutWindow(
                    typeof(RealtimeFunding).FullName.GetHashCode(),
                    windowPos,
                    MainGUI,
                    "RealtimeFunding");

                GUI.depth = 0;
            }
        }

        //MainGUI Window Content
        private void MainGUI(int WindowID)
        {
            GUILayout.BeginVertical(GUILayout.Width(300), GUILayout.ExpandWidth(false));
            if (ShowSettings)
            {

                GUILayout.BeginHorizontal();
                GUILayout.Label("Funding:", headerText, GUILayout.Width(150));
                GUILayout.EndHorizontal();
                GUILayout.BeginHorizontal();
                GUILayout.Label("Base", headerText, GUILayout.Width(150));
                string text = GUILayout.TextField(BaseFunding.ToString());
                int tempi = 0;
                if (int.TryParse(text, out tempi))
                {
                    tempi = Mathf.Clamp(tempi, 0, 1000000);
                    if (Math.Abs(BaseFunding - tempi) > 1)
                    {
                        BaseFunding = tempi;
                        LastSettingChange = System.DateTime.Now.Ticks / 10000000;
                        CashOut(0, false);
                    }
                    else
                        BaseFunding = tempi;
                }
                else if (text == "") BaseFunding = 200;
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("(Real) Reputation Multiplier", headerText, GUILayout.Width(150));
                text = GUILayout.TextField(BudgetMultiplier.ToString("n2"));
                float tempf = 0;
                if (float.TryParse(text, out tempf))
                {
                    tempf = (float)Mathf.Clamp(tempf, 0, 1000000);
                    if (Math.Abs(BudgetMultiplier - tempf) > 0.01)
                    {
                        BudgetMultiplier = tempf;
                        LastSettingChange = System.DateTime.Now.Ticks / 10000000;
                        CashOut(0, false);
                    }
                    else
                        BudgetMultiplier = tempf;
                }
                else if (text == "") BudgetMultiplier = 1.15;
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("Quests Science:", headerText, GUILayout.Width(150));
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("Quest Multiplier", headerText, GUILayout.Width(150));
                text = GUILayout.TextField(QuestMultiplier.ToString("n2"));
                tempf = 0;
                if (float.TryParse(text, out tempf))
                {
                    tempf = (float)Mathf.Clamp(tempf, 0, 10);
                    if (Math.Abs(QuestMultiplier - tempf) > 0.01)
                    {
                        QuestMultiplier = tempf;
                        LastSettingChange = System.DateTime.Now.Ticks / 10000000;
                        CashOut(0, false);
                    }
                    else
                        QuestMultiplier = tempf;
                }
                else if (text == "") QuestMultiplier = 0.5;
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("(Displayed) Reputation Quest Reward Bonus at 100%", headerText, GUILayout.Width(150));
                text = GUILayout.TextField(QuestReputationMultiplier.ToString("n2"));
                tempf = 0;
                if (float.TryParse(text, out tempf))
                {
                    tempf = (float)Mathf.Clamp(tempf, 0, 1000);
                    if (Math.Abs(QuestReputationMultiplier - tempf) > 0.01)
                    {
                        QuestReputationMultiplier = tempf;
                        LastSettingChange = System.DateTime.Now.Ticks / 10000000;
                        CashOut(0, false);
                    }
                    else
                        QuestReputationMultiplier = tempf;
                }
                else if (text == "") QuestReputationMultiplier = 0.5;
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("Scientists:", headerText, GUILayout.Width(150));
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("Scientists Exponent", headerText, GUILayout.Width(150));
                text = GUILayout.TextField(ScientistExponent.ToString("n2"));
                tempf = 0;
                if (float.TryParse(text, out tempf))
                {
                    tempf = (float)Mathf.Clamp(tempf, 0, 5);
                    if (Math.Abs(ScientistExponent - tempf) > 0.01)
                    {
                        ScientistExponent = tempf;
                        LastSettingChange = System.DateTime.Now.Ticks / 10000000;
                        CashOut(0, false);
                    }
                    else
                        ScientistExponent = tempf;
                }
                else if (text == "") ScientistExponent = 1.4;
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("(Final) Multiplier", headerText, GUILayout.Width(150));
                text = GUILayout.TextField(ScientistMultiplier.ToString("n2"));
                tempf = 0;
                if (float.TryParse(text, out tempf))
                {
                    tempf = (float)Mathf.Clamp(tempf, 0, 5);
                    if (Math.Abs(ScientistMultiplier - tempf) > 0.01)
                    {
                        ScientistMultiplier = tempf;
                        LastSettingChange = System.DateTime.Now.Ticks / 10000000;
                        CashOut(0, false);
                    }
                    else
                        ScientistMultiplier = tempf;
                }
                else if (text == "") ScientistMultiplier = 0.5;
                GUILayout.EndHorizontal();



                if (GUILayout.Button("< Back"))
                {
                    ShowSettings = false;
                }
            }
            else
            {



                GUILayout.BeginHorizontal();
                GUILayout.Label("Funding/min", headerText, GUILayout.Width(150));
                string text = GUILayout.TextField(((int)(lastFundingTick)).ToString());

                if (GUILayout.Button("$", GUILayout.Width(20), GUILayout.ExpandHeight(false)))
                {
                    ShowSettings = true;
                }
                GUILayout.EndHorizontal();

                GUILayout.BeginHorizontal();
                GUILayout.Label("Science/min", headerText, GUILayout.Width(150));
                text = GUILayout.TextField(lastScienceTick.ToString("n2"));
                GUILayout.EndHorizontal();


            }

            GUILayout.EndVertical();
            GUI.DragWindow();
        }

        #endregion




        private void Save() //saving everytime RND complex despawns??
        {
            GamePersistence.SaveGame("persistent", HighLogic.SaveFolder, SaveMode.OVERWRITE);
        }

        public static string LastBudget = "";

        public void Update()
        {
            long systemTime = System.DateTime.Now.Ticks / 10000000;
            if (logOutput != "[RTF] ")
            {
                Debug.Log(logOutput);
                logOutput = "[RTF] ";
            }

            //if (paused)
            //{
            //    seconds = (long)(System.DateTime.Now.Ticks / 10000000);
            //}
            //else
            //{
            if (systemTime - lastCashOut >= 10)
            {
                double gameTime = Planetarium.GetUniversalTime();
                if ((Math.Abs(gameTime - lastCashOut_GameTime) > 0.5 || HighLogic.LoadedScene == GameScenes.EDITOR || HighLogic.LoadedScene == GameScenes.MISSIONBUILDER || GUIopen) && (systemTime - LastSettingChange) > 15)
                {
                    CashOut(systemTime - lastCashOut, true);
                }
                lastCashOut_GameTime = gameTime;
                lastCashOut = systemTime;

                //ScreenMessages.PostScreenMessage(resultrep.ToString());

            }

            //}
        }

        private void Log(string msg)
        {
            if (RealtimeFundingDebug)
            {
                if (RealtimeFundingThrottle)
                    ThrottleLog(msg);
                else
                    Debug.Log("[RTF]: " + msg);

            }

        }
        private void ThrottleLog(string msg)
        {
            logOutput = logOutput + msg + "\n";
        }
        private void OnContractAccepted(Contract data)
        {
            ScreenMessages.PostScreenMessage("On completion +" + missionScore(data).ToString("n2") + "science/min");
        }

        private void OnContractCompleted(Contract data)
        {
            double score = missionScore(data);
            QuestPoints = QuestPoints + score;
            ScreenMessages.PostScreenMessage("+" + score.ToString("n2") + "science/min ("+ QuestPoints.ToString("n2")+")");
        }
        public void CashOut(double secs, bool modifyCurrencies)
        {
            if (secs > 15 || secs < 0)
            {
                secs = 10;
            }
            if (BudgetMultiplier <= 0 || BudgetMultiplier > 1000000) return; //overflow protection
            double budget = (getRealReputation() * BudgetMultiplier + (double)BaseFunding);
            if (budget > 0)
            {
                //ScreenMessages.PostScreenMessage("[RTF]: Budget received: " + budget.ToString("C"));
                if (modifyCurrencies)
                    Funding.Instance.AddFunds(budget / 60 * secs, TransactionReasons.None);
            }
            lastFundingTick = budget;

            //ScreenMessages.PostScreenMessage("[RTF]:QuestPoints: " + QuestPoints);


            double scientists = 0;
            List<Vessel> vessels = FlightGlobals.Vessels;
            foreach (Vessel v in vessels)
            {
                var situation = v.situation;
                if ((situation != Vessel.Situations.LANDED || situation == Vessel.Situations.LANDED && v.mainBody.GetName() != "Kerbin") && situation != Vessel.Situations.SPLASHED && situation != Vessel.Situations.PRELAUNCH)
                {
                    List<ProtoCrewMember> kerbals = v.GetVesselCrew();
                    foreach (ProtoCrewMember k in kerbals)
                    {
                        if (k.trait == "Scientist")
                        {
                            scientists += 1 + (double)k.experienceLevel / 10;
                        }

                    }
                }
            }
            double temp = Math.Pow(scientists,ScientistExponent) * ScientistMultiplier + QuestPoints;
            if (modifyCurrencies)
                ResearchAndDevelopment.Instance.AddScience((float)(temp/60*secs), TransactionReasons.None);
            lastScienceTick = temp;
        }

        public float getRealReputation()
        {
            ushort tempRep = (ushort)(Math.Max(0, Reputation.Instance.reputation) * 65);
            int resultrep = 33170;
            //ScreenMessages.PostScreenMessage("ORC: "+data0.ToString()+" - "+data1.displayDescription());
            for (int i = 0; i < 3317; i++)
            {
                if (repArray[i] >= tempRep)
                {
                    resultrep = (i + 1) * 10;
                    break;
                }
            }

            return resultrep;
        }

        double getPlanetScore(String planet, double situationScore)
        {
            double deltaV = 0;
            double landingDeltaV = 500;
            double timeMod = 1;
            double startingDeltaV = 500;
            // 2 -> land
            // 2.5 -> start
            // 2.2 -> not sure
            planet = planet.ToLower();
            switch (planet)
            {   // deltaV including landing (subtracted for orbit), 1 timemod = 1 year
                case "asteroid": deltaV = 5000; timeMod = 0; break;
                case "comet": deltaV = 5000; timeMod = 0; break;
                case "space": deltaV = 3500; timeMod = 0; break;
                case "kerbol": deltaV = 4400; timeMod = 0; break;
                case "sonne": deltaV = 4400; timeMod = 0; break;
                case "sun": deltaV = 4400; timeMod = 0; break;
                case "sol": deltaV = 4400; timeMod = 0; break;
                case "moho": deltaV = 8400; timeMod = 0.35; ; break;
                case "eve": deltaV = 13900; landingDeltaV = 8000; startingDeltaV = 21000; timeMod = 2; break;  //5 is max because of situation
                case "gilly": deltaV = 5000; landingDeltaV = 100; startingDeltaV = 100; timeMod = 2; break;
                case "kerbin": deltaV = 1000; timeMod = 0; break;
                case "mun": deltaV = 5300; timeMod = 0; break;
                case "minmus": deltaV = 4700; landingDeltaV = 100; startingDeltaV = 100; timeMod = 0; break;
                case "duna": deltaV = 6500; landingDeltaV = 1500; startingDeltaV = 2200; timeMod = 2; break;
                case "ike": deltaV = 5400; timeMod = 2; break;
                case "dres": deltaV = 6700; break;
                case "jool": deltaV = 8000; landingDeltaV = 0; break;
                case "laythe": deltaV = 10400; landingDeltaV = 3000; startingDeltaV = 4700; break;
                case "vall": deltaV = 7900; break;
                case "tylo": deltaV = 9300; landingDeltaV = 2200; startingDeltaV = 2400; break;
                case "bop": deltaV = 6800; landingDeltaV = 200; startingDeltaV = 200; break;
                case "pol": deltaV = 6600; landingDeltaV = 200; startingDeltaV = 200; break;
                case "eeloo": deltaV = 7500; timeMod = 1.6; break;
                default:
                    Log("No planet named " + planet);
                    deltaV = 1000;
                    timeMod = 0;
                    break;

            }
            if (situationScore < 2) //orbit
                return Math.Max(0.5, (deltaV - landingDeltaV) / 5000 - 0.5 + timeMod + situationScore / 2);
            else if (situationScore >= 2.5)//starting
                return Math.Max(0.5, (deltaV + startingDeltaV+Math.Max(0,deltaV-landingDeltaV-3400)/2) / 5000 - 0.5 + timeMod + situationScore / 2);
            else if(situationScore >= 2.2)//landing+
                return Math.Max(0.5, (deltaV + startingDeltaV/3) / 5000 - 0.5 + timeMod + situationScore / 2);
            else//landing
                return Math.Max(0.5, (deltaV) / 5000 - 0.5 + timeMod + situationScore / 2);
        }

        double getSituationScore(String situation)
        {
            situation = situation.ToUpper();
            switch (situation)
            {
                case "ALTITUDERECORD": return 1.1;
                case "BASECONSTRUCTION": return 1.2;
                case "CREWTRANSFER": return 1.3;
                case "CREWRECOVERY": return 1.3;
                case "DEPTHRECORD": return 1.1;
                case "DISTANCERECORD": return 1.1;
                case "DOCKING": return 1.2;
                case "ESCAPE": return 1;
                case "FIRSTLAUNCH": return 0.9;
                case "FLAGPLANT": return 2.5;
                case "PLANTFLAG": return 2.5;
                case "FLIGHT": return 0.9;
                case "FLYBY": return 0.9;
                case "LAND": return 2;
                case "FLYBYRETURN": return 1.4;
                case "LANDING": return 2;
                case "LANDINGRETURN": return 2.5;
                case "ORBIT": return 1.1;
                case "ORBITRETURN": return 1.6;
                case "POINTOFINTEREST": return 1.1;
                case "REACHSPACE": return 1;
                case "RENDEZVOUS": return 1.2;
                case "SCIENCE": return 1;
                case "SPACEWALK": return 1;
                case "SPEEDRECORD": return 1;
                case "SPLASHDOWN": return 1;
                case "STATIONCONSTRUCTION": return 1.15;
                case "STUNT": return 1;
                case "SUBORBIT": return 1;
                case "SURFACEEVA": return 2.5;
                case "SURFACE": return 2;
                default:
                    Log("No situation named " + situation);
                    return 1;
            }
        }


        double missionScore(Contract data)
        {
            Log("");
            double maxPlanetScore = 0;
            double maxSituationScore = 0;
            double missionTypeDifficultyMod = 0;
            double missionScore = 0;
            Dictionary<String,double> destinations = new Dictionary<String, double>();
            Log(data.Title);
            Log("  Description: "+data.Description);
            //if (data.Notes.Length > 2) //data.Notes.Length crashes..
                Log("  Notes: "+ data.Notes);
            foreach (ContractParameter p in data.AllParameters)
            {
                //double tempPlanetScore = 0;
                double tempSituationScore = 0;
                String tempPlanet = "UNKNOWN";
                Log(p.ToString());
                Log("  "+ p.Title);
                switch (p.ToString())
                {
                    case "Contracts.Parameters.AcquireCrew":
                        break;

                    case "Contracts.Parameters.AcquirePart":
                        break;

                    case "Contracts.Parameters.CollectScience":
                        tempPlanet = ((p as Contracts.Parameters.CollectScience).TargetBody.name);
                        tempSituationScore = getSituationScore((p as Contracts.Parameters.CollectScience).TargetLocation.ToString());
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod,0.1);
                        break;

                    case "Contracts.Parameters.EnterOrbit":
                        tempPlanet = ((p as Contracts.Parameters.EnterOrbit).TargetBody.name);
                        tempSituationScore = getSituationScore("Orbit");
                        break;

                    case "Contracts.Parameters.EnterSOI":
                        tempPlanet = ((p as Contracts.Parameters.EnterSOI).TargetBody.name);
                        tempSituationScore = getSituationScore("Flyby");
                        break;

                    case "Contracts.Parameters.KerbalDeaths ":
                        break;

                    case "Contracts.Parameters.LandOnBody":
                        tempPlanet = ((p as Contracts.Parameters.LandOnBody).TargetBody.name);
                        tempSituationScore = getSituationScore("Land");
                        break;

                    case "Contracts.Parameters.OR": // LOGIC OPERATOR?

                        break;

                    case "Contracts.Parameters.PartTest":
                        tempSituationScore = 1.25;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 0.1);
                        break;

                    case "Contracts.Parameters.PlantFlag":
                        tempPlanet = ((p as Contracts.Parameters.PlantFlag).TargetBody.name);
                        tempSituationScore = getSituationScore("PlantFlag");
                        break;

                    case "Contracts.Parameters.ReachAltitudeEnvelope": // ???
                        tempSituationScore = 0.9;
                        break;

                    case "Contracts.Parameters.ReachBiome":
                        tempSituationScore = 1.2;
                        break;

                    case "Contracts.Parameters.ReachDestination":
                        tempPlanet = ((p as Contracts.Parameters.ReachDestination).Destination.name);
                        tempSituationScore = getSituationScore("Orbit");
                        break;

                    case "Contracts.Parameters.ReachFlightEnvelope":
                        tempPlanet = ((p as Contracts.Parameters.ReachFlightEnvelope).Destination.name);
                        tempSituationScore = getSituationScore((p as Contracts.Parameters.ReachFlightEnvelope).Situation.ToString());

                        break;

                    case "Contracts.Parameters.ReachSituation":
                        tempSituationScore = getSituationScore((p as Contracts.Parameters.ReachSituation).Situation.ToString());
                        break;

                    case "Contracts.Parameters.ReachSpeedEnvelope":
                        tempSituationScore = 1;
                        break;

                    case "Contracts.Parameters.RecoverKerbal":
                        if (data.Title.Contains("surface") || data.Title.Contains("Oberfläche") || data.Title.Contains("superficie"))
                            tempSituationScore = 2.5;
                        else
                            tempSituationScore = 1.2;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 0.15);
                        break;

                    case "Contracts.Parameters.RecoverPart":
                        if (data.Title.Contains("surface") || data.Title.Contains("Oberfläche") || data.Title.Contains("superficie"))
                            tempSituationScore = 2.2;
                        else
                            tempSituationScore = 1.3;
                        break;

                    case "Contracts.Parameters.XOR": // LOGIC OPERATOR?
                        break;

                    case "Expansions.Serenity.Contracts.CollectDeployedScience":
                        if (data.Title.Contains("surface") || data.Title.Contains("Oberfläche") || data.Title.Contains("superficie"))
                            tempSituationScore = 2.5;
                        else
                            tempSituationScore = 1.2;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 2);
                        break;

                    case "Expansions.Serenity.Contracts.CollectROCScienceArm":
                        tempPlanet = ((p as Expansions.Serenity.Contracts.CollectROCScienceArm).TargetBody.name);
                        tempSituationScore = 2.2;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 1);
                        break;

                    case "Expansions.Serenity.Contracts.CollectROCScienceRetrieval":
                        tempPlanet = ((p as Expansions.Serenity.Contracts.CollectROCScienceRetrieval).TargetBody.name);
                        tempSituationScore = 2.5;

                        break;

                    case "FinePrint.Contracts.Parameters.AsteroidParameter":
                        tempPlanet = "asteroid";
                        tempSituationScore = 1.6;
                        break;

                    case "FinePrint.Contracts.Parameters.CometDetectionParameter":
                        tempPlanet = "sun";
                        tempSituationScore = 1.1;
                        break;

                    case "FinePrint.Contracts.Parameters.CometParameter":
                        tempPlanet = "comet";
                        tempSituationScore = 1.2;
                        break;

                    case "FinePrint.Contracts.Parameters.CometScienceParameter":
                        tempPlanet = "comet";
                        tempSituationScore = 1.4;
                        break;

                    case "FinePrint.Contracts.Parameters.ConstructionParameter":
                        tempPlanet = ((p as FinePrint.Contracts.Parameters.ConstructionParameter).TargetBody.name);
                        tempSituationScore = 1.5;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 0.65);
                        break;

                    case "FinePrint.Contracts.Parameters.CrewCapacityParameter":
                        tempSituationScore = 1.7;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 1.2);
                        break;

                    case "FinePrint.Contracts.Parameters.CrewTraitParameter":
                        break;

                    case "FinePrint.Contracts.Parameters.KerbalDestinationParameter":
                        tempPlanet = ((p as FinePrint.Contracts.Parameters.KerbalDestinationParameter).targetBody.name);
                        tempSituationScore = getSituationScore((p as FinePrint.Contracts.Parameters.KerbalDestinationParameter).targetType.ToString()) * 1.25;

                        break;

                    case "FinePrint.Contracts.Parameters.KerbalGeeAdventureParameter":
                        tempSituationScore = 1.2;
                        break;

                    case "FinePrint.Contracts.Parameters.KerbalTourParameter":
                        tempSituationScore = 1.2;
                        break;

                    case "FinePrint.Contracts.Parameters.LocationAndSituationParameter": //buggy?
                        tempSituationScore = 1.2;
                        break;

                    case "FinePrint.Contracts.Parameters.MobileBaseParameter":
                        tempSituationScore = 2.2;
                        break;

                    case "FinePrint.Contracts.Parameters.PartRequestParameter":
                        tempSituationScore = 1.1;
                        break;

                    case "FinePrint.Contracts.Parameters.ProgressTrackingParameter":
                        tempPlanet = ((p as FinePrint.Contracts.Parameters.ProgressTrackingParameter).milestone.body.name);
                        tempSituationScore = getSituationScore((p as FinePrint.Contracts.Parameters.ProgressTrackingParameter).milestone.type.ToString());
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 0.3);
                        break;

                    case "FinePrint.Contracts.Parameters.RepairPartParameter":
                        tempPlanet = ((p as FinePrint.Contracts.Parameters.RepairPartParameter).TargetBody.name);
                        tempSituationScore = 1.3;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 0.6);
                        break;

                    case "FinePrint.Contracts.Parameters.ResourceExtractionParameter":
                        tempSituationScore = 2.2;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 0.65);
                        break;

                    case "FinePrint.Contracts.Parameters.SpecificOrbitParameter":
                        tempPlanet = ((p as FinePrint.Contracts.Parameters.SpecificOrbitParameter).TargetBody.name);
                        tempSituationScore = getSituationScore("Orbit");
                        break;

                    case "FinePrint.Contracts.Parameters.StabilityParameter":
                        tempSituationScore = 1;
                        break;

                    case "FinePrint.Contracts.Parameters.ResourcePossessionParameter":
                        tempSituationScore = 1.2;
                        break;

                    case "FinePrint.Contracts.Parameters.StationaryPointParameter":
                        tempSituationScore = getSituationScore("Orbit");
                        break;

                    case "FinePrint.Contracts.Parameters.SurveyWaypointParameter":
                        tempSituationScore = 1.8;
                        break;

                    case "FinePrint.Contracts.Parameters.VesselDestinationParameter":
                        tempPlanet = ((p as FinePrint.Contracts.Parameters.VesselDestinationParameter).targetBody.name);
                        tempSituationScore = getSituationScore((p as FinePrint.Contracts.Parameters.VesselDestinationParameter).targetType.ToString());
                        break;

                    case "FinePrint.Contracts.Parameters.VesselSystemsParameter":
                        tempSituationScore = 1.1;
                        break;

                    case "FinePrint.Contracts.Parameters.WaypointParameter":
                        tempPlanet = ((p as FinePrint.Utilities.WaypointParameter).TargetBody.name);
                        tempSituationScore = 1.2;
                        break;

                    case "SentinelMission.SentinelParameter":
                        tempPlanet = ((p as SentinelMission.SentinelParameter).FocusBody.name);
                        tempSituationScore = 1.1;
                        break;

                    case "FinePrint.Contracts.Parameters.RoverWayPointParameter":
                        tempPlanet = ((p as FinePrint.Contracts.Parameters.RoverWayPointParameter).TargetBody.name);
                        tempSituationScore = 2.5;
                        missionTypeDifficultyMod = Math.Max(missionTypeDifficultyMod, 0.5);
                        break;

                    default:
                        Log("  Unknown mission parameter: " + p.ToString());
                        tempSituationScore = 1;
                        break;

                }
                if (data.Title.Contains("surface ") || data.Title.Contains("Oberfläche ") || data.Title.Contains("superficie "))
                    tempSituationScore = Math.Max(2, tempSituationScore);

                if (p.Title.Contains("Aterriza ") || p.Title.Contains("Lande ") || p.Title.Contains("Land "))
                    tempSituationScore = Math.Max(2, tempSituationScore);



                if (tempPlanet == "UNKNOWN")
                {
                    Log("  No planet parameter, checking param title");
                    String paramTitle = p.Title;
                    
                    foreach (KeyValuePair<String, String> entry in planetFinder)
                    {
                        if (paramTitle.Contains(entry.Key))
                        {
                            Log("  "+entry.Value+" detected, situation:" + tempSituationScore.ToString("n2"));
                            if (destinations.ContainsKey(entry.Value))
                                destinations[entry.Value] = Math.Max(destinations[entry.Value], tempSituationScore);
                            else
                                destinations[entry.Value] = tempSituationScore;
                        }
                    }
                }
                else
                {

                    if (destinations.ContainsKey(tempPlanet))
                        destinations[tempPlanet] = Math.Max(destinations[tempPlanet], tempSituationScore);
                    else
                        destinations[tempPlanet] = tempSituationScore;

                    Log("  Planet: " + tempPlanet + " situation:" + tempSituationScore.ToString("n2"));
                    //tempPlanetScore = getPlanetScore(tempPlanet, tempSituationScore) + missionTypeDifficultyMod + countTourists / 10;

                }



                //maxPlanetScore = Math.Max(maxPlanetScore, tempPlanetScore);
                maxSituationScore = Math.Max(tempSituationScore, maxSituationScore);

            }
            Log("Max Situation Score: " + maxSituationScore.ToString("n2"));
            Log("Adding planets from mission title...:");
            String missionTitle = data.Title;
            foreach (KeyValuePair<String, String> entry in planetFinder)
            {
                if (missionTitle.Contains(entry.Key))
                {
                    if (!destinations.ContainsKey(entry.Value))
                    {
                        Log("  Adding with situation score: " + maxSituationScore.ToString("n2"));
                        destinations[entry.Value] = maxSituationScore;
                    }
                    else
                        Log("  " + entry.Value + " in mission title but already present with "+destinations[entry.Value].ToString("n2"));
                }
            }

           if (destinations.Count == 0)
            {
                Log("No destinations detected, using kerbin with " + maxSituationScore.ToString("n2"));
                destinations["Kerbin"] = maxSituationScore;
            }
           Log("Calculating total score...:");
           double tempPlanetScore = 0;
           foreach (KeyValuePair<String,double> entry in destinations)
           {
               if (destinations.Count > 1 && entry.Key == "Kerbin")
                {
                    //ignore kerbin
                }
               else
                {
                    tempPlanetScore = getPlanetScore(entry.Key, entry.Value);
                    Log("  " + entry.Key + " +" + tempPlanetScore.ToString("n2"));
                    maxPlanetScore = Math.Max(maxPlanetScore, tempPlanetScore);
                    missionScore += tempPlanetScore;
                }
           }
            if (missionTypeDifficultyMod > 0)
                Log("Adding " + missionTypeDifficultyMod + " for this mission type");
            missionScore += missionTypeDifficultyMod;
            double QuestReputationReward = Reputation.Instance.reputation * QuestReputationMultiplier / 1000;
            Log("Returning " + missionScore.ToString("n2") + " * "+ QuestMultiplier.ToString("n2") + " = " + (missionScore * QuestMultiplier).ToString("n2")+" + "+ QuestReputationReward.ToString("n2"));
            return missionScore * QuestMultiplier + QuestReputationReward;
        }
    }
}


