﻿using System;



namespace RealtimeFunding
{
    [KSPScenario(ScenarioCreationOptions.AddToNewCareerGames | ScenarioCreationOptions.AddToExistingCareerGames, new GameScenes[] {
        GameScenes.SPACECENTER,
        GameScenes.EDITOR,
        GameScenes.FLIGHT,
        GameScenes.TRACKSTATION,
        GameScenes.SPACECENTER
    })]
    public class RealtimeFundingData : ScenarioModule
    {

        public override void OnSave(ConfigNode node)
        {
            ConfigNode n = new ConfigNode("RealtimeFunding");
            n.AddValue("LastBudget", RealtimeFunding.LastBudget);
            n.AddValue("BudgetMultiplier", RealtimeFunding.BudgetMultiplier.ToString());
            n.AddValue("BaseFunding", RealtimeFunding.BaseFunding.ToString());
            n.AddValue("ScientistExponent", RealtimeFunding.ScientistExponent.ToString());
            n.AddValue("ScientistMultiplier", RealtimeFunding.ScientistMultiplier.ToString());
            n.AddValue("QuestMultiplier", RealtimeFunding.QuestMultiplier.ToString());
            n.AddValue("QuestReputationMultiplier", RealtimeFunding.QuestReputationMultiplier.ToString());
            n.AddValue("QuestPoints", RealtimeFunding.QuestPoints.ToString());
            node.AddNode(n);
            base.OnSave(node);
        }

        public override void OnLoad(ConfigNode node)
        {
            base.OnLoad(node);

            var n = node.GetNode("RealtimeFunding");

            if (n != null)
            {
                string param = n.GetValue("LastBudget");
                if (param != null)
                    RealtimeFunding.LastBudget = param;

                param = n.GetValue("BudgetMultiplier");
                if (param != null)
                    RealtimeFunding.BudgetMultiplier = double.Parse(param);

                param = n.GetValue("BaseFunding");
                if (param != null)
                    RealtimeFunding.BaseFunding = int.Parse(param);

                param = n.GetValue("ScientistExponent");
                if (param != null)
                    RealtimeFunding.ScientistExponent = double.Parse(param);

                param = n.GetValue("ScientistMultiplier");
                if (param != null)
                    RealtimeFunding.ScientistMultiplier = double.Parse(param);

                param = n.GetValue("QuestMultiplier");
                if (param != null)
                    RealtimeFunding.QuestMultiplier = double.Parse(param);

                param = n.GetValue("QuestReputationMultiplier");
                if (param != null)
                    RealtimeFunding.QuestReputationMultiplier = double.Parse(param);

                param = n.GetValue("QuestPoints");
                if (param != null)
                    RealtimeFunding.QuestPoints = double.Parse(param);
            }
            else
            {
                RealtimeFunding.BudgetMultiplier = 1.15;
                RealtimeFunding.BaseFunding = 200;
                RealtimeFunding.ScientistExponent = 1.4;
                RealtimeFunding.ScientistMultiplier = 0.5;
                RealtimeFunding.QuestMultiplier = 0.5;
                RealtimeFunding.QuestReputationMultiplier = 0.5;
                RealtimeFunding.QuestPoints = 0;
                RealtimeFunding.lastScienceTick = 0;


    }
        }

    }


}
