# Starship Expansion Project
Starship Expansion Project (SEP) is a mod being developed by me, Kari, and our amazing team. Our project aims to bring our intepretation of the Starship vehicle by SpaceX into Kerbal Space Program. While a lot of the design choices are based on the actual vehicle sitting on Boca Chica, creative freedom is used to expand our mod even further.


### Dependencies:
- B9 Part Switch
- Waterfall
- ModuleManager

### Recommended Mods:
- Textures Unlimited
- Tundra Exploration
- Kerbal Joint Reinforcement (Next or Continued)
- Starship Launch Expansion

### Suggested Mods:
- Community Resource Pack 
- Modular Launch Pads
- Flight Manager for Reusable Stages (FMRS)
- Trajectories
- HullCameraVDS & NeptuneCamera

### IVA Dependencies
- Near Future Props
- Reviva
- Free IVA
- Raster Prop Monitor
- ASET Props

## Roadmap
You can check my roadmap on https://trello.com/b/UPblvcar/karis-roadmap

## Discord
I also have a discord server, enter for updates, dev talk or to have fun 
https://discord.gg/CQzk9H84pr

## Know Issues
- When you spawn a part in the VAB it may have invisible meshes, just click it again and will fix itself
- If SEP parts are black, you need to bump up KSP graphical settings, specifically render quality and reflection related settings
- Ship's aerodynamics is very sensitive, small changes to the weight distribution can cause instability, we are looking at potential *permanent* fixes
- Stock SAS tends to overcorrect a lot and can create even more instability on ship EDL (Entry, descent and landing). We recommend using MechJeb to avoid this.
- Full Stack is not very stable on ascent, that's a design issue, fly with flaps perpendicular to the ground and don't be too agressive on the gravity turn and you should be fine.

## LICENSE
All configs are distributed under CC-NC-SA-4.0 license. 
Nertea's HabUtils.dll is distributed under MIT license. 
All assets (all .dds, .png and .mu files) alongside with our StarshipExpansionProject.dll are distributed under an All Rights Reserved license. 

You may not redistribute or re-use these assets without express permission from the author. Updated on February 25th, 2023
