# NavInstruments /L Unofficial

Adds a horizontal situation indicator with integrated ILS functionality to a popup window or your RPM cockpit.

Unofficial fork by Lisias.


## In a Hurry

* [Latest Release](https://github.com/net-lisias-kspu/NavInstruments/releases)
	+ [Binaries](https://github.com/net-lisias-kspu/NavInstruments/tree/Archive)
* [Source](https://github.com/net-lisias-kspu/NavInstruments)
* Documentation
	+ [Project's README](https://github.com/net-lisias-kspu/NavInstruments/blob/master/README.md)
	+ [Install Instructions](https://github.com/net-lisias-kspu/NavInstruments/blob/master/INSTALL.md)
	+ [Tech Docs](https://github.com/net-lisias-kspu/NavInstruments/blob/master/Docs/index.md)
	+ [Change Log](./CHANGE_LOG.md)
	+ [TODO](./TODO.md) list


## Description

Adds a horizontal situation indicator with integrated ILS functionality to a popup window or your RPM cockpit.﻿

The standalone version can be accessed (along with the options page and custom runway page, for controlling the current runway and GUI scale) via the App Launcher.

ILS style localizer, glideslope indicator, distance measuring equipment, and backcourse indicator.

Outer, Middle, and Inner Markers are fully functional, with the audio cue volume controlled by your Voices volume setting (**WARNING**: Middle and Inner marker audio cues are high pitch﻿ and, depending on your settings, may be loud). 

The window GUI auto hides when you enter IVA. Current runway and glideslope selection remain synced between the standalone GUI and the version for RPM.

Included selectable runways:

* KSC 09
* KSC 27
* Island 09
* Island 27
* VAB Helipad East
* VAB Helipad West
* Administration Helipad

Included glideslopes range from default 3° to 25°

More runways and glideslopes can be added via config file or in game.

Use ALT (Option on Mac) while clicking the NavInstruments button on Toolbar for open/close the Settings Window.

### Compatible with

* RasterPropMonitor by Mihara
* Kerbal Space Industries MFD by Hyomoto
* Kerbin Shuttle Orbiter System by Helldiver & Nazari1382

### Known Issues

* Currently, volume settings will not update when in flight, but going to the space center should update them.


## Installation

Detailed installation instructions are now on its own file (see the [In a Hurry](#in-a-hurry) section) and on the distribution file.

### License:

Released under a Custom, Permissive under Constraints license. See [here](./LICENSE). Don't fork this work without reading and understanding it.

Please note the copyrights and trademarks in [NOTICE](./NOTICE).


## UPSTREAM

* [Ser](https://forum.kerbalspaceprogram.com/index.php?/profile/104207-ser/) CURRENT MAINTAINER
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/162967-*)
	+ [SpaceDock](https://spacedock.info/mod/1432/NavUtilities%20continued)
	+ [GitHub](https://github.com/SerTheGreat/NavInstruments)
* [Kujuman](https://forum.kerbalspaceprogram.com/index.php?/profile/28299-kujuman/) ROOT
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/77062-*)
	+ [SpaceDock](https://spacedock.info/mod/542/NavUtilities)
	+ [GitHub](https://github.com/kujuman/NavInstruments)
