# Endurance Reconfig
### Licensed: CC-BY-NC-SA
For the KSP mod for the Interstellar movie's Endurance ship
![SpaceDock banner](https://i.imgur.com/I3NKBhG.png)

This mod performs the following:
* Adds a copy of the crew cabin, purposed for integration with DeepFreeze, Kerbal Health and Kerbalism.
* Adds plumes to nearly all engines and RCS thrusters. (Technical issues beyond my grasp.)
* Adds stack symmetry (only for 2x symmetry, very handy) to the structural ring.
* Adds missing built-in antennas and KerbNet modules.
* Fixes heat limits and heat production to be mostly negligible.
* Fixes the Viper/Mini-Ranger to:
  * Have some stack nodes for mounting onto other parts/vessels.
  * Use Kerbal Flying Saucers features if that mod is installed.
* Makes the engines and RCS use only LiquidFuel and ElectricCharge, and raises their Isp and their Electrical demands to practical high levels. These buffs make Endurance much more fit for use in a large kerbal universe, whether an upscaled one or one with many star systems.
  * Makes use of LqdHydrogen instead of LiquidFuel in CRP (when Rational Resources, CryoEngines or Kerbal Atomics are present).
  * Makes use of Propellium instead of LiquidFuel in WBI Classic Stock.
  * LiquidFuel replacement also applies to fuel cells.
* Moves some parts further along in the tech tree (when CTT is present) due to their fusion power natures.
* Replaces the basic, high-powered generator module with convincing fuel cells and Tokamak-alike fusion power sources.
* Changes ElectricCharge tankage and changes tanks to use B9 Part Switch or WBI OmniStorage.
* Integrates parts with WBI Pathfinder and Snacks for a very complete gameplay feature set.
  * Changes habitability assessment experiment into 2x WBT experiments that require time and resources and only fully functions at some worlds.
  * Makes crewed parts configurable in-flight.
  * Provides life support mod integration only for WBI Snacks.
