# Warp Everywhere Plus
<br/>

### LICENSE:
Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)
<br/><br/>

### CHANGELOG:
  - 1.3: Recompiled against KSP 1.12; Added some extra debug log tracking details for troubleshooting
  - 1.2: Made default values more reasonable for stock game; Recompiled for KSP 1.11 and dotNET 4.7.2
  - 1.1: First Release (started at 1.1 since the original "WarpEverywhere" froze at 1.0 back in 2018)
<br/><br/>

__WarpEverywherePlus__ lets you add up to 8 new Time Warp levels, and up to 8 new Physics Warp levels. The inspiration came from __5thHorseman__ 
(who got it from *"WarpUnlocker"*, who got it from *"TimeControl"*, etc), all credit goes to his design!
([forum](http://forum.kerbalspaceprogram.com/index.php?/topic/148278-k) / [github](https://github.com/5thHorseman/WarpEverywhere) / [spacedock](https://spacedock.info/mod/982/Warp%20Everywhere)).
Another great warp implementation is "BetterTimeWarp", now adopted by (of course) __LinuxGuruGamer__
([forum](https://forum.kerbalspaceprogram.com/index.php?/topic/154935-19x-bettertimewarpcontinued-customizable-time-warp-and-lossless-physics-warp/) / 
[github](https://github.com/linuxgurugamer/BetterTimeWarpContinued) / [spacedock](http://spacedock.info/mod/1162/BetterTimeWarpContinued)).
Both of those useful mods will work great for you, as alternatives.

The goal of this mod is to refresh the original WarpEverywhere with extra new features:

* Added "physics" warp functionality
* Customize the warp levels via a text config file
* Recompiled it against the most recent KSP and dotNET (runs on KSP 1.8 - 1.11, and probably earlier ones too.)

Adding new warp levels in the config file will *append* them to the existing stock list, which is how the original WarpEverywhere worked.
So the time jumps will cycle through first the stock ones, and then the ones you designated.

It would be easy for this mod to *overwrite* the stock levels instead (so you could create your own unique set of warps), 
but appending speeds worked well for the classic WarpEverywhere, plus the stock list is pretty good, so 5thHorseman's fundamental design continues here.

To help you decide which mod you should use, here is a helpful comparison table  ;-)
<br/><br/>

![Warp Comparison](https://i.imgur.com/cIxymyk.png)
<br/><br/>

# INSTALLATION

- Like all Kerbal Space Program system-level mods, the free [ModuleManager](https://github.com/sarbian/ModuleManager/releases) loads the DLL. If you have any other mods, you already have MM in your GameData folder.

- copy "WarpEverywherePlus.dll" and "WarpEverywherePlus.cfg" to "(KSP install folder)\GameData\WarpEverywherePlus", so the file structure looks like this:
        
        \Kerbal Space Program\GameData\WarpEverywherePlus\
                                                  WarpEverywherePlus.cfg
                                                  WarpEverywherePlus.dll
<br/>

# CONFIG FILE REFERENCE

Everything about WarpEverywherePlus is controlled by the settings (text) file "WarpEverywherePlus.cfg". 

You can delete the "WarpEverywherePlus.cfg" file, and a canned template (default) settings file will be created for you.

Here's a basic example of the config entries:


    WarpEverywherePlus
    {
        extra_warp_1 = 7000000
        extra_warp_2 = 8000000      // extra_warp_3, extra_warp_4, etc. You can have up to 8 extra warp rates. Have fun!

        extra_physics_1 = 5
        extra_physics_2 = 10        // extra_physics_3, etc. You can have up to 8 extra physics warp rates. Be careful with physics warp!
    }

<br/>


Your long-duration ion engine burns (and Jeb's sprints back to the ship after his EVA jetpack runs out of propellant yet again) will be so much faster!! **Enjoy :)**

![Enjoy](https://i.imgur.com/Pvfwfab.png)
