# Outer Planets Mod v2.2.12

This version of Outer Planets Mod has been built to work for KSP version 1.3.1 - 1.12.*.

### 1 - About

The Outer Planets Mod is a mod that expands the outer edges of the Kerbol system to create something akin to the real Solar System's. It adds Kerbalized versions of Saturn, Uranus, Neptune and Pluto as well as several of these planets' moons. These faraway planets provide a challenge rarely encountered in Kerbal Space Program; you'll have to figure out new transfer windows, manage your power supply differently, provide your spacecraft with more Delta-V and be ready to travel years or even decades.

### 2 - Features

* Explore 15 new highly detailed planets and moons, all in a stock-a-like artstyle.
* Discover never before seen worlds, such as a sub-satellite, Trojan moon or a set of binary bodies.
* Collect science in over 140 biomes, with almost a thousand unique science blurbs.
* Custom terrain textures and improved ground scatter has made planets and moons never look so good up close.
* A full set of KSPedia entries for OPM's various bodies helps you to navigate the far reaches of the Kerbol system.
* Includes a Level 4 Tracking Station upgrade (requires CustomBarnKit) to boost your communication range out to the furthest reaches of the system without requiring additional modded antennas.
* Extensive third-party mod integration means you can play OPM with a whole range of other mods.

### 3 - Known Issues

* None at this time

### 4 - How to Install

Extract the GameData folder found in the downloadable .zip directly into your Kerbal Space Program install directory. If located correctly, the OPM and CTTP directories should be found at:

* \Kerbal Space Program\GameData\OPM

&

* \Kerbal Space Program\GameData\CTTP

### 5 - Dependencies

The following KSP mods must be installed prior to using Outer Planets Mod (ensure you install the correct version of the dependencies for your version of KSP):

* Kopernicus - https://github.com/Kopernicus/Kopernicus/releases (depending on KSP game version)
* KSP Texture Loader - https://github.com/Phantomical/KSPTextureLoader/releases (dependency of Kopernicus as of 2:release-1.12.1-232)
* Module Manager - https://forum.kerbalspaceprogram.com/index.php?/topic/50533-1
* Community Terrain Texture Pack - bundled within OPM

### 6 - Supported Mods

* Custom Barn Kit - https://forum.kerbalspaceprogram.com/index.php?/topic/109027-1
* Community Resource Pack
* Distant Object Enhancement
* PlanetShine
* Research Bodies

### 7 - Changelog

v2.2.12

* Compiled textures into single assetbundle to leverage KSP Texture Loader functionality. New dependency of KSP Texture Loader (Kopernicus now requires it anyhow...)
* Fixed Research Bodies celestial body values for easy, normal, medium and hard settings, to align with core Research Bodies design strategy.

Previous changelogs can be found on the GitHub repository or the original forum thread: https://forum.kerbalspaceprogram.com/index.php?/topic/93999-1

### 8 - License

Outer Planets Mod is being maintained by a collaborative group. The mod is still licensed under the original Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International license.
