# UnKerballedStart
Probes-first and planes-first tech tree for Kerbal Space Program. Inspired by UnmannedBeforeManned by Yemo.


UnKerballed Start by Spink Akron and theonegalen.

This is an unmanned start mod in the spirit of Yemo’s SETI, Unmanned Before Manned. It is structured around early probes and aircraft.

Installation Instructions:
1. Uninstall any previous version of the mod when upgrading to the latest version.
2. Copy the UnKerballedStart folder into GameData.
3. There is no step 3.

Required mods:
Community Tech Tree
Module Manager

Optional:
Custom Barn Kit - for swapping VAB/Launchpad upgrade costs.


Overview
    • Start with the Stayputnik probe core. Lack of control is the first difficulty to overcome.
    • Only .625m engines are available at start. More powerful engines have been moved up the tech tree. Multi-engine setups should be more useful now. Making History's engine plates are made available earlier to facilitate this.
    • Revamped tech tree. The tech tree has been de-squished, de-tangled, and rationalized. Orphan lines such as Nuclear Power and Colonization have been fully integrated. Additional nodes have been added to flesh out the early tree and where needed at various other points. The Precision Rocketry line has been expanded to cover additional tiers, splitting Rocketry into a Power/Boosters line and a Specialty line. This further reduces rocketry advancement, slowing the pace. NOTE: All inputs to a node are now required to unlock, not just one like stock. Links that didn't make sense have been removed.
    • To balance the later availability of powerful engines, most other parts have been moved up. The intent is that the player spend more time developing the Kerbin SOI before heading out to the planets. Special thanks to @Pand5461 for the concept of later engine availability. That was the key that made the whole project come together.
    • Early aviation with extensive mod support generously provided by UBM Extended's@theonegalen.
    • Soviet-style Reentry Pods now have their own tech line. They are simple and cheap, but ultimately a dead end. In a low-income playthrough they become a real option.
    • Parts are only re-positioned. No parts or resources are changed so compatibility issues are reduced.
    • Three new .625m engines have been added. The LV-T05 and LV-T10 are re-scaled versions of the LV-30 and LV-45. The RT1 SRB is a re-scaled version of the RT-10. They are removed if a mod with equivalent parts is installed. Added a .625m fairing provided by @PocketBrotector from his Extended Antenna Progression mod. 
		
		Optional: Small parts means more parts so the upgrade costs for VAB/Launchpad and SPH/Runway have been swapped via Custom Barn Kit. This allows for earlier VAB upgrading. ﻿To activate this change rename CustomBarnKit.cfg.disabled to CustomBarnKit.cfg
		
Compatibility
The only mods that are incompatible are other tech tree mods. All parts added by mods will work as designed but their position in the tech tree may not be consistent with the changes made by this mod. If you’d like a mod adapted, I’d be happy to make a config for it.
