# Telemetria

*Quick List of Features:*

1) Displays important orbital details on the main flight screen

2) Provides keyboard binding for Prograde/Retro, SAS:Surface/SAS:Orbit, and "Warp to Next Maneuver" and Warp to Ap/Pe

3) Provides Ascent Guidance for optimal launches + Auto-Throttle + Auto-Land, and shows interesting data like MaxQ, kph, and mph

4) Hotkeys for quickly flipping to different cameras

5) A goal of being as small and simple as possible, with no dependencies


### LICENSE:
Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)



## *New for 1.15-1.17:*

Okay, so Telemetria continues to grow as my catch-all code repository for automating my KSP life. Lots of big updates and fixes are included in version 1.15.
Since Telemetria handles flight parameters, Autopilots and AutoThrottles could be added to automate various flight regimes.
(As mentioned elsewhere on this page, popular apps like *Kerbal Engineer (KER)* and *MechJeb* do this very accurately, but Telemetria is probably the lightest/simplest plugin with this feature.)

The most helpful addition is __Auto Throttle Lock__ aka "cruise control", so you can (for example) lock the throttle at a thrust-to-weight ratio of 2:1 for gravity turns during launch.
Telemetria will control the throttle for you, making small adjustments to hold the values you want.

![](https://i.imgur.com/fZejRX2.png)


It also has __Auto Guidance__ to steer the suggested angle degrees during ascent. Note: this requires the control point to be facing the correct way, and works by toggling the SAS on/off and pitching downward. 
That technique is simple to implement in code, but can be unstable with some ship designs, so you might want to activate it for just portions of the ascent and then switch to Prograde. 
But it does work as intended for hands-off gravity turns.

In addition to controlling the throttle and guidance, Telemetria can also calculate optimum minimum-fuel landing descents (aka __Suicide Burns__).
It puts guidance + throttle automation together for a full __Auto-Land sequence__, including putting the landing gear down at the last moment and softly touching down, it's pretty cool to watch.
It's fun to stay 100% IVA and look out the window as the ship manipulates the throttle and lands itself!

![](https://i.imgur.com/QlG5UD9.jpg)

In a vacuum environment like the Mun, this feature is very accurate. 
But Auto-Land gets somewhat less accurate in aero/atmospheric environments like Kerbin/Earth, so consider it BETA, and save games before attempting.
You can control the performance of the suicide burn by modifying the *"Suicide_Vacuum_Extra_Margin"*, *"Suicide_Atmosphere_Extra_Margin"* and *"AutoThrottle_Suicide_Land_Aggressive"* 
values in Telemetria.cfg (see bottom of this page).

HINT: Also, do not activate Auto-Land too early, otherwise Telemetria will have insufficient descent data for calculations.
Wait until you're closer to the ground to activate suicide burns -- wait after "Est. Burn" numbers turn positive, indicating the velocity trends are converging
and a solution is available.
Telemetria will display suggestions regarding estimated altitudes/times when it senses an imminent lithobrake opportunity in your future.

By tweaking the values like "*Suicide_Vacuum_Extra_Margin*" and others mentioned above in Telemetria.cfg, you can get any outcome you want.
Internally, two separate formulas are evaluated during Auto-Land, one proprietary that calculates time to impact vs. burn duration, and a deceleration formula from [https://www.desmos.com/calculator/ms0zpkjkvp](https://www.desmos.com/calculator/ms0zpkjkvp)

![](https://i.imgur.com/Nss0QiA.png)

Quick keys can be assigned in Telemetria for these new guidance features (by default, they are unassigned, you need to add the ones you want in Telemetria.cfg):

![](https://i.imgur.com/frbcHnD.png)

This was tested in hundreds of launches and landings in Real Solar System, and also some light testing in Stock KSP. 
Telemetria consistently and reliably auto-lands the stock "KerbalX", the Apollo LEM on the Moon, and even SpaceX boostback landings:
                                                                                                                                   
![](https://i.imgur.com/RPotKII.jpg)



## *New for 1.14:*

When launching and approaching orbit, you might temporarily pass the apoapsis while circularizing your orbit, especially with low-thrust second stages that are common in the real world.
When that happens, KSP wraps around the "Time to Apoapsis" and show Hours:Minutes:Second for the *next* Ap, so you lose information on how far ahead of Ap you currently are.
This latest Telemetria upgrade will show the "Time Past Apoapsis" data with a negative number, making it obvious that Ap is **behind** you so it's easier to adjust your ascent.

![](https://i.imgur.com/0DUsMMz.png)




* Also added "Distance" as one of the camera parameters for setting up custom quick snap-to-view.

![](https://i.imgur.com/6pKSFFA.png)



# (original v0.10) DESCRIPTION:

So you're launching a glorious new rocket, and you have to constantly flip between the Map view and Ship view, so you can track the __Apoapsis__ and __Periapsis__ during ascent.
I'd rather watch my rocket and epic staging events than a parabola line. Even worse, right-click the Apoapsis to keep the data visible > then switch back to Ship view > switch back to Map view and *poof* the data is gone again. 
**Update**: *As of KSP 1.7+, the Ap/Pe display is included in stock Kerbal, plus the data stays visible, BUT Telemetria's display is 1) easier to read, 
2) doesn't constantly change the number format, 3) shows when Ap/Pe is close behind you, and 4) is moveable.*

As you probably know, mods like *Kerbal Engineer (KER)*, *MechJeb*, and *BasicOrbit* can already show this information and a lot more, but I wanted something minimalist and simpler. Preferably, a single file plug-in (with minimum-to-no dependencies), and a basic .cfg text file that I can easily edit for changes. Using this mod, I can get perfectly circular orbits every time, and at the precise desired altitude, all without ever needing to go into Map view. It's very satisfying to reach a perfect orbit by hand-flying with this tool.

During the ascent, there are numerous changes typically made with SAS relating to switching pointing reference -- Surface while low, and Orbit when higher. In the stock configuration, this requires mouse moves/clicks to activate. To facilitate SAS changes, this mod lets you map keys for Prograde and Retrograde pointing, and also key toggling for the SAS Mode ("Current Plane of Reference"), between __SAS: Surface__ and __SAS: Orbit__.

Since we're mapping commands here, we've all had the experience of trying to click the (nearly hidden) dotted brown line so you can pick __Warp to Next Maneuver__.
As you know, when the Maneuver trajectory is too close to the current trajectory, it's nearly impossible to right-click it with the mouse.
With this mod, you can assign the __Warp To Node__ command to any unused key.
Even better, you can set the time allowance to be anything you want, instead of the default 60 seconds that exists in KSP version 1.5.1 and lower.
Using this key command also sets the pointing to SAS:Maneuver, which is one less thing you have to click.
If there is no Maneuver Node, then this will warp you to the next Apoapsis/Periapsis minus 30 seconds - great for orbital circularization!

![](https://i.imgur.com/vOLO0vj.png)


To view the key bindings that are active with Telemetria, press the key combo mentioned in the title bar (Alt+F7 by default):

![](https://i.imgur.com/C13Focn.png)

### __Feature: Ascent Guidance__
"Ascent Guidance" shows you the optimum pitch angle to steer while climbing to arrive at your desired altitude and angle.
If you've played KSP for awhile, you probably already do this based on instinct, however this guidance can assist you with achieving a Kerbal Space Agency-approved launch trajectory resulting in a circular orbit with minimum fuel.
The formula used for guidance was listed in this thread:

[https://www.reddit.com/r/KerbalAcademy/comments/4b878r/how_to_launch_rockets_efficiently_in_ksp_105_and/](https://www.reddit.com/r/KerbalAcademy/comments/4b878r/how_to_launch_rockets_efficiently_in_ksp_105_and/)

![](https://i.imgur.com/aUFZQQM.png)

Ascent Guidance will be active if the following conditions are true:
1) You are launching from a location with an atmosphere (non-atmospheric launches do not need guidance, and should turn prograde immediately after rising above terrain height)
2) The vertical speed is currently higher than 20m/s
3) You are above the "Start Turn" altitude in the .cfg file

The following parameters are available to tweak your ascent trajectory: (a) Start Turn Altitude, (b) End Turn Altitude, (c) End Turn Pitch Angle.
Telemetria can pick all of these parameters for you with default values, which should work for both Kerbin and Earth/RSS.

__Feature: Latitude__ shows the current latitude degrees, plus time to the next 0 node (when you cross a plane of reference such as the equator, in other words the next Ascending (AN) or Descending (DN) node). The 0 transition happens twice per orbit.
The *"time to 0"* is helpful since it allows you to adjust your inclination at a celestial body using no other references.
This means you don't need to do the trick of "put a probe orbiting at 0" (or hyperedit the *persistent.sfs* file) to obtain a reference for inclination changes.
Like most data that Telemetria provides, the current Latitude and time to AN/DN is not available on the stock KSP ship screen, but is critical for realistic orbital flight ops.

__Feature: Inclination Indicator__ Added small indicators to show if you are heading up "^" or down "v" on inclination.
Note that this is independent of current latitude; "going up" can be positive or negative latitude.
This information helps you to know which way to point (Normal or Antinormal) for inclination changes when reaching the 0 transition.

![](https://i.imgur.com/x8PoZfm.png)      ![](https://i.imgur.com/Huf7vOC.png)

__Feature: Extra Data__ There was some additional information that is of interest during launches and other activities, such as "kph", "mph", Max Q, etc.
Using this data, Telemetria can calculate "[Max q](https://en.wikipedia.org/wiki/Max_q)", and also when the vehicle goes supersonic.

![](https://i.imgur.com/OX8I8bm.png)

*Demonstration of Telemetria showing "Max Q" for a Falcon Heavy passing through 13km in the Real Solar System environment*


# INSTALLATION / COMPATIBILITY / DEPENDENCIES:

- Like all Kerbal Space Program system-level mods, the free *"ModuleManager"* is required (all MM versions 3.x/4.x tested fine with this mod). If you have any other mods, you already have MM in your GameData folder.

- copy "Telemetria.dll" and "Telemetria.cfg" to "[KSP install folder]\GameData\Telemetria", so the file structure looks like this:
        
        \Kerbal Space Program\GameData\Telemetria\
                                                  Telemetria.cfg
                                                  Telemetria.dll

# CONFIG FILE REFERENCE:    

Everything about Telemetria is controlled by the settings (text) file "Telemetria.cfg". 
As of v0.4, you can even change the .cfg file entries while playing the game, and Telemetria tries to be intelligent about your new settings without requiring a KSP restart 
(it will reload changes during a scene or vessel switch). 
This allows you make changes based on new ships and launches, or alternate target orbits, without restarting.

You can delete the "Telemetria.cfg" file, and a canned template (default) settings file will be created for you.

Telemetria saves the (x,y) coordinates of its app window to the config file. This means the Telemetria window is persistent between KSP sessions.
All the other settings are meant to be manually modified with a text editor like Notepad (I have no plans to make a special UI for this mod, and in KSP you quickly get skilled at modifying .cfg files).

Key Examples:    Y, F6, Alt+F6, PageUp, ScrollLock, Keypad5, KeypadEnter, Mouse2, JoystickButton0, etc.

Full Key List:   https://docs.unity3d.com/ScriptReference/KeyCode.html

Avoid Key conflicts: https://wiki.kerbalspaceprogram.com/wiki/Key_bindings

    window_width = 430              // Window size (default: 430 pixels)
    window_x = 0                    // Window position Left (this is automatically updated by Telemetria)
    window_y = 0                    // Window position Top (this is automatically updated by Telemetria)
    warp_node_margin = 180          // Time, in seconds, of the "Warp to Next Maneuver" buffer
	
    ascent_turn_start    = 500      // Altitude to begin gravity turn (default: 500m)
    ascent_turn_end      = 80000    // Altitude to end guidance (default: atmosphere height, which is 70,000m for Kerbin, or 140,000 for Earth, the full gravity turn may continue much higher.)
    ascent_angle_final   = 0.0      // Pitch angle when guidance is complete (default: 5.0; a non-zero angle aids in following Prograde marker the rest of the way to orbit)
    ascent_show_hints    = false    // Optionally show extra warnings for asscent guidance (ie, thrust too high, apoapsis too far, etc)

    Suicide_Vacuum_Extra_Margin = 40        // Extra height buffer (meters) when performing automated suicide burns in vacuum (such as the Mun)
    Suicide_Atmosphere_Extra_Margin = 40    // Extra height buffer (meters) when performing automated suicide burns in air (such as Kerbin/Earth)

    Hide = F7                       // Show/Hide the Telemetria window (only key that can't use mod "Alt+", to avoid conflicts.)
    Prograde = F6                   // Activates "Prograde" following in SAS mode
    Retrograde = F8                 // Activates "Retrograde" following in SAS mode
    SASMode = Y                     // Toggles between "Surface" and "Orbit" mode for SAS
    Mute =                          // Master mute toggle for all KSP sounds
    WarpToNode = Alt+F8             // Provides "Warp to Next Maneuver" (and Ap/Pe) without needing to right-click mouse

    SnapCamera0 = Alt + Keypad8     // Snaps the camera to 0* (looking straight north; helps during launch)
    SnapCamera90 = Alt + Keypad6    // Snaps the camera to 90* (looking east)
    SnapCamera180 = Alt + Keypad2   // Snaps the camera to 180* (looking south)
    SnapCamera270 = Alt + Keypad4   // Snaps the camera to 270* (looking west)

    SnapCameraCustom = Alt + Y      // Snaps the camera to angle that you provide in "SnapCameraCustom_Heading**"
    SnapCameraCustom_Heading = 45   // 45* camera angle (looking northeast)
    SnapCameraCustom_Pitch = 0.115  // Pitch angle of camera (up/down view)
    SnapCameraCustom_Distance = 50  // Distance of camera from focus point (in meters)

    AutoGuidance =                    // Steers the suggested pitch angle during gravity turn (suggested: Alt + I)
    AutoThrottle_TWR = Alt + O        // Locks throttle for current T/W ratio; works great for ascents to keep G-level constant (suggested: Alt + O)
    AutoThrottle_Speed =              // BETA: Locks throttle to the current m/s speed (suggested: Alt + E)
    AutoThrottle_Suicide =            // BETA: Initiates burn at right moment; Must be activated while in free-fall (suggested: Alt + Home)
    AutoThrottle_Suicide_Land =       // BETA: Suicide burn via Safer/Higher mode, then transition to a full landing (suggested: Alt + End)
    AutoThrottle_Suicide_Land_Aggressive =  // BETA: Suicide burn + landing in Aggressive/Lower mode (suggested: Alt + PageDown)

# FAQ:
*(well actually nobody has asked any of these questions, but they seem like good questions)*
  

#### *1) Why is it named Telemetria*
    
    Since this mod primarily deals with telemetry from the Launch and Ascent phases of flight, *Telemetria* was the obvious name choice.
    (and btw Telemetria is Spanish for telemetry, pero con acento por supuesto)
  
  

#### *2) Why no "SAS:Target" toggle?*
    
    Because this was originally made for ascents. Plus, when doing an orbital rendezvous, you typically click the "Target" mode approximately one time and just leave it on.
    So it didn't seem like it needed quick access.
    I can certainly add it if people request it, BUT then you will have to cycle through 3 modes instead of 2.
  
  
#### *3) Why no "Toggle SAS on/off"*
    
    The stock game already does that with "T"
  
  
#### *4) Will you add other commands for keyboard mapping?*
    
    Maybe, if it makes sense and others want it too. But I'd prefer to keep this simple and small.
  
  
#### *5) If this functionality already exists in mods like KER and MechJeb, why did you create a new mod?*
    
	I wrote this mostly to solve the few things that I found annoying in the stock game to make my life easier, but without all the complexity, overhead, and dependencies of a major add-on.
	I'm not aware of any mod that provides these specific features (Ap/Pe, Guidance, key override for Surface/Orbit), and nothing else, all displayed in the same tiny window.
	Plus, this project gave me the experience of writing a mod for a popular game, using my own source code that I can update instantly for new versions.
	Hopefully you find this mod useful like I do.

## CHANGELOG:
  - 0.1: Initial Build.
  - 0.2: Add Ascent Guidance, add new display options, minor fixes
  - 0.3: Fixed error with Radar Altimeter reading incorrectly over water
  - 0.4: Updated persistence logic when switching scenes and vessels
  - 0.5: Added Vessel Latitude readout, plus time to Ascending/Descending node for easier inclination changes
  - 0.6: New ascending "^" and descending "v" indicators for inclination, also some minor fixes and formatting changes
  - 0.7: Fixed bug with volume key always activating mute if game started at vol level 0
  - 0.8: Fixed bug with Warp to Node; Added "Warp to Ap/Pe" if no Node; Minor changes to formatting and Ascent Guidance defaults; undocumented "ExtraData" (see cfg)
  - 0.9: Fixed bug with visibility when using F2 key; Added Camera Snap hotkeys, Keys now allow modifiers such as Alt + F7
  - 1.10: Many bug fixes; Removed "Radar Altimeter" since now included in stock; Reorganized data display; Updated key defaults
  - 1.12: (initially released as 1.13, but had minor formatting error)
  - 1.13: Automatically calculates accurate TWR for ascent guidance (much improved guidance); Annunciators give hints about optimal ascent; Added "SnapCameraCustom" (in .cfg) to position camera at any desired heading
  - 1.14: Added "Distance" to custom camera snap; Modified time-to-Ap to show negative (countdown) during orbit insertion/circularizations; Fixed decimal formats; Recompiled against KSP version 1.8.1 and .NET 4.7.1
  - 1.15: Added AutoGuidance, AutoThrottle (5 modes), Adjustable app size; Fixed bug with "SnapCameraCustom_Heading"; Removed log spam; Many bug fixes; updated to dotNET 4.7.2 and KSP 1.11.2
  - 1.16: Minor formatting changes to Time displays and colors; Small fix for tumbling during AutoGuidance
