![MkON](/logo.png "MkON")

MkON is a completely modular control panel UI for [Telemachus](http://forum.kerbalspaceprogram.com/threads/24594-0-23-Telemachus-%E2%80%93-Telemetry-and-Flight-Control-in-the-Web-Browser-(2014-1-11)) (see below) and Kerbal Space Program.  The UI is designed to work on tablets and second monitors as an auxiliary display and is styled in the KSP aesthetic. It also allows a degree of control using pressable buttons, dials, meters and lots of data for number junkies.

* [Telemachus](http://forum.kerbalspaceprogram.com/threads/24594-0-23-Telemachus-%E2%80%93-Telemetry-and-Flight-Control-in-the-Web-Browser-(2014-1-11)) is a plugin by [Richard Bunt](https://github.com/richardbunt) for Kerbal Space Program that allows real-time in game telemetry to be viewed in the browser. It's pretty awesome, actually.

<br />
![MkON](/preview.jpg "MkON in action")
_MkON controls on a touch tablet, with a second monitor showing resource information._

## Features

- A huge variety of buttons, dials, screens, scales and controls.
- A fun and bright UI that works well with Kerbal Space Program.
- Automatic saving of layouts (same device) and the ability to export/import them to screens of the same resolution.
- Common KSP Keyboard shortcuts for some modules (SAS, RCS, GEAR etc).
- Working touch screen support for most buttons and controls.

## Installation

- You need to download and install the latest release of [Telemachus](https://github.com/richardbunt/Telemachus/releases)
- Download the latest version of [MKON](https://github.com/chrisnic/mkon/releases)
- Go to your KSP Folder/Game Data/Telemachus/Plugins/PluginData/Telemachus folder and delete or move the existing contents to a backup folder.
- Copy the contents of the MkON zip into the above folder.
- Load up KSP and open Telemachus as you would normally - follow the [Telemachus user guide](https://github.com/richardbunt/Telemachus/wiki/User-Guide).

## How to use

Please see the [wiki](https://github.com/chrisnic/mkon/wiki).

## Coming Soon

- Working 3D Navball, with touch support.
- Draggable throttle control.
- 2D GPS Map.
- Switches and alternative button designs.
- Improved layout saving options (swipe to switch between).

## Disclaimer

This project is very much a work in progress. Expect bugs, occasional slowness and wierd errors but most of the time a refresh will fix it. Optimization will focus exclusively on tablets and desktops/laptops first. Currently tested working environments include:

- Chrome, Safari, Firefox on Windows/OSX for desktops and laptops.
- Chrome, Safari for iPad 4.
- Chrome, Safari for Android Tablets (Asus Transformer Prime).

If you find a bug, or something you think should be added please submit it [here](https://github.com/chrisnic/mkon/issues).

## License

[Attribution-NonCommercial-NoDerivatives 4.0 International](http://creativecommons.org/licenses/by-nc-nd/4.0/)
